/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.flipkart.foxtrot.common.query.FilterVisitor;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.query.general.AnyFilter;
import com.flipkart.foxtrot.common.query.general.EqualsFilter;
import com.flipkart.foxtrot.common.query.general.ExistsFilter;
import com.flipkart.foxtrot.common.query.general.InFilter;
import com.flipkart.foxtrot.common.query.general.MissingFilter;
import com.flipkart.foxtrot.common.query.general.NotEqualsFilter;
import com.flipkart.foxtrot.common.query.general.NotInFilter;
import com.flipkart.foxtrot.common.query.numeric.BetweenFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.GreaterThanFilter;
import com.flipkart.foxtrot.common.query.numeric.LessEqualFilter;
import com.flipkart.foxtrot.common.query.numeric.LessThanFilter;
import com.flipkart.foxtrot.common.query.string.ContainsFilter;
import com.flipkart.foxtrot.common.query.string.WildCardFilter;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.NotEmpty;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="operator")
@JsonSubTypes(value={@JsonSubTypes.Type(value=GreaterEqualFilter.class, name="greater_equal"), @JsonSubTypes.Type(value=GreaterThanFilter.class, name="greater_than"), @JsonSubTypes.Type(value=LessEqualFilter.class, name="less_equal"), @JsonSubTypes.Type(value=LessThanFilter.class, name="less_than"), @JsonSubTypes.Type(value=BetweenFilter.class, name="between"), @JsonSubTypes.Type(value=EqualsFilter.class, name="equals"), @JsonSubTypes.Type(value=InFilter.class, name="in"), @JsonSubTypes.Type(value=NotInFilter.class, name="not_in"), @JsonSubTypes.Type(value=NotEqualsFilter.class, name="not_equals"), @JsonSubTypes.Type(value=AnyFilter.class, name="any"), @JsonSubTypes.Type(value=ExistsFilter.class, name="exists"), @JsonSubTypes.Type(value=MissingFilter.class, name="missing"), @JsonSubTypes.Type(value=ContainsFilter.class, name="contains"), @JsonSubTypes.Type(value=WildCardFilter.class, name="wildcard"), @JsonSubTypes.Type(value=LastFilter.class, name="last")})
public abstract class Filter
implements Serializable {
    @NotNull
    @NotEmpty
    private final String operator;
    private String field;

    protected Filter(String operator) {
        this.operator = operator;
    }

    protected Filter(String operator, String field) {
        this.operator = operator;
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getOperator() {
        return this.operator;
    }

    public abstract <T> T accept(FilterVisitor<T> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        if (!this.field.equals(filter.field)) {
            return false;
        }
        return this.operator.equals(filter.operator);
    }

    public int hashCode() {
        int result = this.operator.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("operator", (Object)this.operator).append("field", (Object)this.field).toString();
    }

    @JsonIgnore
    public boolean isFilterTemporal() {
        return false;
    }

    public Set<String> validate() {
        HashSet<String> validationErrors = new HashSet<String>();
        if (CollectionUtils.isNullOrEmpty(this.field)) {
            validationErrors.add("filter field cannot be null or empty");
        }
        return validationErrors;
    }
}

