/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.foxtrot.common.Date;
import com.flipkart.foxtrot.common.DocumentMetadata;
import com.flipkart.foxtrot.common.util.Utils;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;

public class Document
implements Serializable {
    private static final long serialVersionUID = 1394184997687819635L;
    @NotNull
    @NotEmpty
    @JsonProperty
    private String id;
    @JsonProperty
    private long timestamp;
    private Date date;
    private DocumentMetadata metadata;
    @NotNull
    @JsonProperty
    private JsonNode data;

    public Document() {
        this.id = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
        this.date = new Date(DateTime.now());
    }

    public Document(String id, long timestamp, JsonNode data) {
        this.id = id;
        this.timestamp = timestamp;
        this.data = data;
        this.date = Utils.getDate(timestamp);
    }

    public Document(String id, long timestamp, JsonNode data, Date date) {
        this.id = id;
        this.timestamp = timestamp;
        this.data = data;
        this.date = date;
    }

    public Document(String id, long timestamp, DocumentMetadata metadata, JsonNode data) {
        this.id = id;
        this.timestamp = timestamp;
        this.metadata = metadata;
        this.data = data;
        this.date = Utils.getDate(timestamp);
    }

    public static DocumentBuilder builder() {
        return new DocumentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Date getDate() {
        return this.date;
    }

    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    public JsonNode getData() {
        return this.data;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setMetadata(DocumentMetadata metadata) {
        this.metadata = metadata;
    }

    public void setData(JsonNode data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        DocumentMetadata this$metadata = this.getMetadata();
        DocumentMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        JsonNode this$data = this.getData();
        JsonNode other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Document;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        DocumentMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        JsonNode $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Document(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", date=" + this.getDate() + ", metadata=" + this.getMetadata() + ", data=" + this.getData() + ")";
    }

    public static class DocumentBuilder {
        private String id;
        private long timestamp;
        private DocumentMetadata metadata;
        private JsonNode data;

        DocumentBuilder() {
        }

        public DocumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DocumentBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DocumentBuilder metadata(DocumentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public DocumentBuilder data(JsonNode data) {
            this.data = data;
            return this;
        }

        public Document build() {
            return new Document(this.id, this.timestamp, this.metadata, this.data);
        }

        public String toString() {
            return "Document.DocumentBuilder(id=" + this.id + ", timestamp=" + this.timestamp + ", metadata=" + this.metadata + ", data=" + this.data + ")";
        }
    }
}

