/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.estimation;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.flipkart.foxtrot.common.estimation.CardinalityEstimationData;
import com.flipkart.foxtrot.common.estimation.EstimationDataType;
import com.flipkart.foxtrot.common.estimation.EstimationDataVisitor;
import com.flipkart.foxtrot.common.estimation.FixedEstimationData;
import com.flipkart.foxtrot.common.estimation.PercentileEstimationData;
import com.flipkart.foxtrot.common.estimation.TermHistogramEstimationData;
import java.io.Serializable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="FIXED", value=FixedEstimationData.class), @JsonSubTypes.Type(name="CARDINALITY", value=CardinalityEstimationData.class), @JsonSubTypes.Type(name="PERCENTILE", value=PercentileEstimationData.class), @JsonSubTypes.Type(name="TERM_HISTOGRAM", value=TermHistogramEstimationData.class)})
public abstract class EstimationData
implements Serializable {
    private static final long serialVersionUID = -6542054750045180777L;
    private final EstimationDataType type;
    private long count;

    EstimationData(EstimationDataType type) {
        this.type = type;
    }

    EstimationData(EstimationDataType type, long count) {
        this.type = type;
        this.count = count;
    }

    public abstract <T> T accept(EstimationDataVisitor<T> var1);

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstimationData)) {
            return false;
        }
        EstimationData other = (EstimationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EstimationDataType this$type = this.getType();
        EstimationDataType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EstimationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EstimationDataType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        return result;
    }

    public String toString() {
        return "EstimationData(type=" + (Object)((Object)this.getType()) + ", count=" + this.getCount() + ")";
    }

    public EstimationDataType getType() {
        return this.type;
    }
}

