/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.flipkart.foxtrot.common.ActionRequestVisitor;
import com.flipkart.foxtrot.common.query.Filter;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="opcode")
public abstract class ActionRequest
implements Serializable,
Cloneable {
    private String opcode;
    private List<Filter> filters;

    protected ActionRequest(String opcode) {
        this.opcode = opcode;
    }

    protected ActionRequest(String opcode, List<Filter> filters) {
        this.opcode = opcode;
        this.filters = filters;
    }

    public String getOpcode() {
        return this.opcode;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            return Lists.newArrayList();
        }
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public abstract <T> T accept(ActionRequestVisitor<T> var1);

    public String toString() {
        return new ToStringBuilder((Object)this).append("opcode", (Object)this.opcode).append("filters", this.filters).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        ActionRequest actionRequestClone = (ActionRequest)super.clone();
        actionRequestClone.setFilters(new ArrayList<Filter>(this.filters));
        return actionRequestClone;
    }

    public ActionRequest() {
    }
}

