/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.stats;

public enum Stat {
    COUNT(false){

        @Override
        public <T> T visit(StatVisitor<T> visitor) {
            return visitor.visitCount();
        }
    }
    ,
    MIN(false){

        @Override
        public <T> T visit(StatVisitor<T> visitor) {
            return visitor.visitMin();
        }
    }
    ,
    MAX(false){

        @Override
        public <T> T visit(StatVisitor<T> visitor) {
            return visitor.visitMax();
        }
    }
    ,
    AVG(false){

        @Override
        public <T> T visit(StatVisitor<T> visitor) {
            return visitor.visitAvg();
        }
    }
    ,
    SUM(false){

        @Override
        public <T> T visit(StatVisitor<T> visitor) {
            return visitor.visitSum();
        }
    }
    ,
    SUM_OF_SQUARES(true){

        @Override
        public <T> T visit(StatVisitor<T> visitor) {
            return visitor.visitSumOfSquares();
        }
    }
    ,
    VARIANCE(true){

        @Override
        public <T> T visit(StatVisitor<T> visitor) {
            return visitor.visitVariance();
        }
    }
    ,
    STD_DEVIATION(true){

        @Override
        public <T> T visit(StatVisitor<T> visitor) {
            return visitor.visitStdDeviation();
        }
    };

    private boolean extended;

    private Stat(boolean extended) {
        this.extended = extended;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public abstract <T> T visit(StatVisitor<T> var1);

    public static interface StatVisitor<T> {
        public T visitCount();

        public T visitMin();

        public T visitMax();

        public T visitAvg();

        public T visitSum();

        public T visitSumOfSquares();

        public T visitVariance();

        public T visitStdDeviation();
    }
}

