/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.estimation;

import com.flipkart.foxtrot.common.estimation.EstimationData;
import com.flipkart.foxtrot.common.estimation.EstimationDataType;
import com.flipkart.foxtrot.common.estimation.EstimationDataVisitor;
import java.util.Arrays;

public class PercentileEstimationData
extends EstimationData {
    private static final long serialVersionUID = -4790803356348252020L;
    private double[] values;
    private long cardinality;

    public PercentileEstimationData() {
        super(EstimationDataType.PERCENTILE);
    }

    public double[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public PercentileEstimationData(double[] values, long count, long cardinality) {
        super(EstimationDataType.PERCENTILE, count);
        this.values = values;
        this.cardinality = cardinality;
    }

    @Override
    public <T> T accept(EstimationDataVisitor<T> estimationDataVisitor) {
        return estimationDataVisitor.visit(this);
    }

    public static PercentileEstimationDataBuilder builder() {
        return new PercentileEstimationDataBuilder();
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public void setCardinality(long cardinality) {
        this.cardinality = cardinality;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PercentileEstimationData)) {
            return false;
        }
        PercentileEstimationData other = (PercentileEstimationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getValues(), other.getValues())) {
            return false;
        }
        return this.getCardinality() == other.getCardinality();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PercentileEstimationData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getValues());
        long $cardinality = this.getCardinality();
        result = result * 59 + (int)($cardinality >>> 32 ^ $cardinality);
        return result;
    }

    @Override
    public String toString() {
        return "PercentileEstimationData(super=" + super.toString() + ", values=" + Arrays.toString(this.getValues()) + ", cardinality=" + this.getCardinality() + ")";
    }

    public static class PercentileEstimationDataBuilder {
        private double[] values;
        private long count;
        private long cardinality;

        PercentileEstimationDataBuilder() {
        }

        public PercentileEstimationDataBuilder values(double[] values) {
            this.values = values;
            return this;
        }

        public PercentileEstimationDataBuilder count(long count) {
            this.count = count;
            return this;
        }

        public PercentileEstimationDataBuilder cardinality(long cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public PercentileEstimationData build() {
            return new PercentileEstimationData(this.values, this.count, this.cardinality);
        }

        public String toString() {
            return "PercentileEstimationData.PercentileEstimationDataBuilder(values=" + Arrays.toString(this.values) + ", count=" + this.count + ", cardinality=" + this.cardinality + ")";
        }
    }
}

