/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.estimation;

import com.flipkart.foxtrot.common.estimation.EstimationData;
import com.flipkart.foxtrot.common.estimation.EstimationDataType;
import com.flipkart.foxtrot.common.estimation.EstimationDataVisitor;

public class CardinalityEstimationData
extends EstimationData {
    private static final long serialVersionUID = -7107697070895705011L;
    private long cardinality;

    public CardinalityEstimationData() {
        super(EstimationDataType.CARDINALITY);
    }

    public CardinalityEstimationData(long cardinality, long count) {
        super(EstimationDataType.CARDINALITY, count);
        this.cardinality = cardinality;
    }

    @Override
    public <T> T accept(EstimationDataVisitor<T> estimationDataVisitor) {
        return estimationDataVisitor.visit(this);
    }

    public static CardinalityEstimationDataBuilder builder() {
        return new CardinalityEstimationDataBuilder();
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(long cardinality) {
        this.cardinality = cardinality;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardinalityEstimationData)) {
            return false;
        }
        CardinalityEstimationData other = (CardinalityEstimationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getCardinality() == other.getCardinality();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CardinalityEstimationData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $cardinality = this.getCardinality();
        result = result * 59 + (int)($cardinality >>> 32 ^ $cardinality);
        return result;
    }

    @Override
    public String toString() {
        return "CardinalityEstimationData(super=" + super.toString() + ", cardinality=" + this.getCardinality() + ")";
    }

    public static class CardinalityEstimationDataBuilder {
        private long cardinality;
        private long count;

        CardinalityEstimationDataBuilder() {
        }

        public CardinalityEstimationDataBuilder cardinality(long cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public CardinalityEstimationDataBuilder count(long count) {
            this.count = count;
            return this;
        }

        public CardinalityEstimationData build() {
            return new CardinalityEstimationData(this.cardinality, this.count);
        }

        public String toString() {
            return "CardinalityEstimationData.CardinalityEstimationDataBuilder(cardinality=" + this.cardinality + ", count=" + this.count + ")";
        }
    }
}

