/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.query.numeric;

import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.FilterVisitor;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class BetweenFilter
extends Filter {
    private boolean temporal;
    @NotNull
    private Number from;
    @NotNull
    private Number to;

    public BetweenFilter() {
        super("between");
    }

    public BetweenFilter(String field, Number from, Number to, boolean temporal) {
        super("between", field);
        this.from = from;
        this.to = to;
        this.temporal = temporal;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) throws Exception {
        return visitor.visit(this);
    }

    @Override
    public boolean isFilterTemporal() {
        return this.temporal;
    }

    @Override
    public Set<String> validate() {
        Set<String> validationErrors = super.validate();
        if (this.from == null) {
            validationErrors.add("from field cannot be null");
        }
        if (this.to == null) {
            validationErrors.add("to field cannot be null");
        }
        return validationErrors;
    }

    public static BetweenFilterBuilder builder() {
        return new BetweenFilterBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BetweenFilter)) {
            return false;
        }
        BetweenFilter other = (BetweenFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isTemporal() != other.isTemporal()) {
            return false;
        }
        Number this$from = this.getFrom();
        Number other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Number this$to = this.getTo();
        Number other$to = other.getTo();
        return !(this$to == null ? other$to != null : !this$to.equals(other$to));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BetweenFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + (this.isTemporal() ? 79 : 97);
        Number $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Number $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BetweenFilter(super=" + super.toString() + ", temporal=" + this.isTemporal() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public boolean isTemporal() {
        return this.temporal;
    }

    public Number getFrom() {
        return this.from;
    }

    public Number getTo() {
        return this.to;
    }

    public void setTemporal(boolean temporal) {
        this.temporal = temporal;
    }

    public void setFrom(Number from) {
        this.from = from;
    }

    public void setTo(Number to) {
        this.to = to;
    }

    public static class BetweenFilterBuilder {
        private String field;
        private Number from;
        private Number to;
        private boolean temporal;

        BetweenFilterBuilder() {
        }

        public BetweenFilterBuilder field(String field) {
            this.field = field;
            return this;
        }

        public BetweenFilterBuilder from(Number from) {
            this.from = from;
            return this;
        }

        public BetweenFilterBuilder to(Number to) {
            this.to = to;
            return this;
        }

        public BetweenFilterBuilder temporal(boolean temporal) {
            this.temporal = temporal;
            return this;
        }

        public BetweenFilter build() {
            return new BetweenFilter(this.field, this.from, this.to, this.temporal);
        }

        public String toString() {
            return "BetweenFilter.BetweenFilterBuilder(field=" + this.field + ", from=" + this.from + ", to=" + this.to + ", temporal=" + this.temporal + ")";
        }
    }
}

