/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.query.datetime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.FilterVisitor;
import com.flipkart.foxtrot.common.query.datetime.RoundingMode;
import com.flipkart.foxtrot.common.query.datetime.TimeWindow;
import com.flipkart.foxtrot.common.query.datetime.WindowUtil;
import com.google.common.base.Strings;
import io.dropwizard.util.Duration;
import javax.validation.constraints.NotNull;

public class LastFilter
extends Filter {
    private long currentTime;
    private RoundingMode roundingMode;
    @NotNull
    private Duration duration;

    public LastFilter() {
        super("last");
        this.currentTime = System.currentTimeMillis();
        super.setField("_timestamp");
    }

    public LastFilter(String field, long currentTime, Duration duration, RoundingMode roundingMode) {
        super("last");
        super.setField(Strings.isNullOrEmpty((String)field) ? "_timestamp" : field);
        this.currentTime = currentTime == 0L ? System.currentTimeMillis() : currentTime;
        this.duration = duration;
        this.roundingMode = roundingMode == null ? RoundingMode.NONE : roundingMode;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) throws Exception {
        return visitor.visit(this);
    }

    @JsonIgnore
    public TimeWindow getWindow() {
        return WindowUtil.calculate(this.currentTime, this.duration, this.roundingMode);
    }

    @Override
    @JsonIgnore
    public boolean isFilterTemporal() {
        return true;
    }

    public static LastFilterBuilder builder() {
        return new LastFilterBuilder();
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LastFilter)) {
            return false;
        }
        LastFilter other = (LastFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentTime() != other.getCurrentTime()) {
            return false;
        }
        RoundingMode this$roundingMode = this.getRoundingMode();
        RoundingMode other$roundingMode = other.getRoundingMode();
        if (this$roundingMode == null ? other$roundingMode != null : !((Object)((Object)this$roundingMode)).equals((Object)other$roundingMode)) {
            return false;
        }
        Duration this$duration = this.getDuration();
        Duration other$duration = other.getDuration();
        return !(this$duration == null ? other$duration != null : !this$duration.equals(other$duration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LastFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $currentTime = this.getCurrentTime();
        result = result * 59 + (int)($currentTime >>> 32 ^ $currentTime);
        RoundingMode $roundingMode = this.getRoundingMode();
        result = result * 59 + ($roundingMode == null ? 43 : ((Object)((Object)$roundingMode)).hashCode());
        Duration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "LastFilter(super=" + super.toString() + ", currentTime=" + this.getCurrentTime() + ", roundingMode=" + (Object)((Object)this.getRoundingMode()) + ", duration=" + this.getDuration() + ")";
    }

    public static class LastFilterBuilder {
        private String field;
        private long currentTime;
        private Duration duration;
        private RoundingMode roundingMode;

        LastFilterBuilder() {
        }

        public LastFilterBuilder field(String field) {
            this.field = field;
            return this;
        }

        public LastFilterBuilder currentTime(long currentTime) {
            this.currentTime = currentTime;
            return this;
        }

        public LastFilterBuilder duration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public LastFilterBuilder roundingMode(RoundingMode roundingMode) {
            this.roundingMode = roundingMode;
            return this;
        }

        public LastFilter build() {
            return new LastFilter(this.field, this.currentTime, this.duration, this.roundingMode);
        }

        public String toString() {
            return "LastFilter.LastFilterBuilder(field=" + this.field + ", currentTime=" + this.currentTime + ", duration=" + this.duration + ", roundingMode=" + (Object)((Object)this.roundingMode) + ")";
        }
    }
}

