/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.common.query.general;

import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.FilterVisitor;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

public class InFilter
extends Filter {
    @NotNull
    @NotEmpty
    @Size(min=1, max=10000)
    private List<Object> values;

    public InFilter() {
        super("in");
    }

    public InFilter(String field, List<Object> values) {
        super("in", field);
        this.values = values;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) throws Exception {
        return visitor.visit(this);
    }

    @Override
    public Set<String> validate() {
        Set<String> validationErrors = super.validate();
        if (CollectionUtils.isNullOrEmpty(this.values)) {
            validationErrors.add("at least one value needs to be provided for field");
        }
        return validationErrors;
    }

    public static InFilterBuilder builder() {
        return new InFilterBuilder();
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InFilter)) {
            return false;
        }
        InFilter other = (InFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Object> this$values = this.getValues();
        List<Object> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "InFilter(super=" + super.toString() + ", values=" + this.getValues() + ")";
    }

    public static class InFilterBuilder {
        private String field;
        private List<Object> values;

        InFilterBuilder() {
        }

        public InFilterBuilder field(String field) {
            this.field = field;
            return this;
        }

        public InFilterBuilder values(List<Object> values) {
            this.values = values;
            return this;
        }

        public InFilter build() {
            return new InFilter(this.field, this.values);
        }

        public String toString() {
            return "InFilter.InFilterBuilder(field=" + this.field + ", values=" + this.values + ")";
        }
    }
}

