/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.cluster;

import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.cluster.ClusterStatusUpdater;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterMember;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterStatus;
import com.flipkart.foxtrot.client.selectors.MemberSelector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoxtrotCluster {
    private static final Logger logger = LoggerFactory.getLogger((String)FoxtrotCluster.class.getSimpleName());
    private final MemberSelector selector;
    private FoxtrotClientConfig clientConfig;
    private final ScheduledFuture<?> future;
    private ScheduledExecutorService executorService;
    private AtomicReference<FoxtrotClusterStatus> status = new AtomicReference();

    public FoxtrotCluster(FoxtrotClientConfig config, MemberSelector selector) throws Exception {
        this.selector = selector;
        this.clientConfig = config;
        this.executorService = Executors.newScheduledThreadPool(1);
        ClusterStatusUpdater updater = ClusterStatusUpdater.create(config, this.status);
        logger.info("Host : {}", (Object)config.getHost());
        updater.loadClusterData();
        this.future = this.executorService.scheduleWithFixedDelay(updater, config.getRefreshIntervalSecs(), config.getRefreshIntervalSecs(), TimeUnit.SECONDS);
    }

    public FoxtrotClusterMember member() {
        if (null == this.status || this.status.get() == null || this.status.get().getMembers().isEmpty()) {
            return null;
        }
        return this.selector.selectMember(this.status.get().getMembers());
    }

    public void stop() {
        logger.info("table={} shutting_down_cluster_status_checker", new Object[]{this.clientConfig.getTable()});
        this.future.cancel(true);
        while (!this.future.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error("table={} interrupted", (Object)new Object[]{this.clientConfig.getTable()}, (Object)e);
            }
            logger.info("table={} waiting_for_checker_to_stop", new Object[]{this.clientConfig.getTable()});
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("table={} executor_service_termination_exception", (Object)new Object[]{this.clientConfig.getTable()}, (Object)e);
        }
        this.executorService.shutdownNow();
        logger.info("table={} cluster_status_checker_shutdown_complete", new Object[]{this.clientConfig.getTable()});
    }
}

