/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.cluster;

import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterHttpClient;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterStatus;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStatusUpdater
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)ClusterStatusUpdater.class.getSimpleName());
    private final FoxtrotClusterHttpClient httpClient;
    private AtomicReference<FoxtrotClusterStatus> status;
    private static final JacksonDecoder decoder = new JacksonDecoder();
    private static final JacksonEncoder encoder = new JacksonEncoder();
    private static final Slf4jLogger slf4jLogger = new Slf4jLogger();

    private ClusterStatusUpdater(AtomicReference<FoxtrotClusterStatus> status, FoxtrotClusterHttpClient httpClient) {
        this.status = status;
        this.httpClient = httpClient;
    }

    static ClusterStatusUpdater create(FoxtrotClientConfig config, AtomicReference<FoxtrotClusterStatus> status) {
        FoxtrotClusterHttpClient httpClient = (FoxtrotClusterHttpClient)Feign.builder().decoder((Decoder)decoder).encoder((Encoder)encoder).client((Client)new OkHttpClient()).logger((feign.Logger)slf4jLogger).logLevel(Logger.Level.BASIC).target(FoxtrotClusterHttpClient.class, String.format("http://%s:%s", config.getHost(), config.getPort()));
        return new ClusterStatusUpdater(status, httpClient);
    }

    @Override
    public void run() {
        this.loadClusterData();
    }

    void loadClusterData() {
        try {
            logger.trace("Initiating data get");
            this.status.set(this.httpClient.load());
            if (this.status.get() != null && !this.status.get().getMembers().isEmpty()) {
                logger.info("Members : {}", (Object)this.httpClient.load().getMembers().get(0));
            } else {
                logger.info("Members : {}", (Object)this.status.get());
            }
        }
        catch (Exception e) {
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof FeignException) {
                FeignException feignException = (FeignException)e;
                logger.error("Error getting status:{} - {}", (Object)feignException.status(), (Object)feignException.getMessage());
            }
            logger.error("Error getting cluster data: ", (Throwable)e);
        }
    }
}

