/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.flipkart.foxtrot.client.serialization.DeserializationException;
import com.flipkart.foxtrot.client.serialization.SerDe;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    private JsonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, Object> readMapFromString(String json) throws DeserializationException {
        return JsonUtils.fromJson(json, new TypeReference<Map<String, Object>>(){});
    }

    private static <T> T fromJson(String json, TypeReference<T> typeReference) throws DeserializationException {
        try {
            return (T)SerDe.mapper().readValue(json, typeReference);
        }
        catch (IOException e) {
            log.error("Error while deserializing in fromJson for json : {}, error: {}", (Object)json, (Object)e);
            throw new DeserializationException("Unable to deserialize data with type reference", e);
        }
    }
}

