/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.senders;

import com.flipkart.foxtrot.client.Document;
import com.flipkart.foxtrot.client.EventSender;
import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.cluster.FoxtrotCluster;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterMember;
import com.flipkart.foxtrot.client.selectors.FoxtrotTarget;
import com.flipkart.foxtrot.client.senders.FoxtrotHttpClient;
import com.flipkart.foxtrot.client.serialization.EventSerializationHandler;
import com.flipkart.foxtrot.client.serialization.SerializationException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.Response;
import feign.slf4j.Slf4jLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSyncEventSender
extends EventSender {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpSyncEventSender.class.getSimpleName());
    private final String table;
    private final FoxtrotCluster client;
    private FoxtrotHttpClient httpClient;
    private static final Slf4jLogger slf4jLogger = new Slf4jLogger();
    private static List<String> ignoreableFailureReasons = Lists.newArrayList();

    public HttpSyncEventSender(FoxtrotClientConfig config, FoxtrotCluster client, EventSerializationHandler serializationHandler) {
        super(serializationHandler);
        this.table = config.getTable();
        this.client = client;
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setConnectionPool(new ConnectionPool(config.getMaxConnections(), config.getKeepAliveTimeMillis()));
        this.httpClient = (FoxtrotHttpClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(okHttpClient)).logger((feign.Logger)slf4jLogger).logLevel(Logger.Level.BASIC).target(new FoxtrotTarget<FoxtrotHttpClient>(FoxtrotHttpClient.class, "foxtrot", client));
        ignoreableFailureReasons = Arrays.asList(config.getCommaSeparatedIgnorableFailureMessages().split(","));
    }

    @Override
    public void send(Document document) {
        this.send(this.table, document);
    }

    @Override
    public void send(String table, Document document) {
        this.send(table, Collections.singletonList(document));
    }

    @Override
    public void send(List<Document> documents) {
        this.send(this.table, documents);
    }

    @Override
    public void send(String table, List<Document> documents) {
        try {
            this.send(table, this.getSerializationHandler().serialize(documents));
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }

    public void send(String table, byte[] payload) {
        block6: {
            FoxtrotClusterMember clusterMember = this.client.member();
            Preconditions.checkNotNull((Object)clusterMember, (Object)"No members found in foxtrot cluster");
            try {
                Response response = this.httpClient.send(table, payload);
                if (this.is2XX(response.status())) {
                    logger.info("table={} messages_sent host={} port={}", new Object[]{table, clusterMember.getHost(), clusterMember.getPort()});
                    break block6;
                }
                if (response.status() == 400) {
                    logger.error("table={} host={} port={} statusCode={}", new Object[]{table, clusterMember.getHost(), clusterMember.getPort(), response.status()});
                    break block6;
                }
                if (response.status() == 500) {
                    boolean[] ignoreException = new boolean[]{false};
                    ignoreableFailureReasons.forEach(s -> {
                        if (response.reason().contains((CharSequence)s)) {
                            ignoreException[0] = true;
                        }
                    });
                    if (!ignoreException[0]) {
                        throw new RuntimeException(String.format("table=%s event_send_failed status [%d] exception_message=%s", table, response.status(), response.reason()));
                    }
                    break block6;
                }
                throw new RuntimeException(String.format("table=%s event_send_failed status [%d] exception_message=%s", table, response.status(), response.reason()));
            }
            catch (FeignException e) {
                logger.error("table={} msg=event_publish_failed", (Object)new Object[]{table}, (Object)e);
                throw new RuntimeException("msg=event_publish_failed with exception : ", e);
            }
        }
    }

    private boolean is2XX(int status) {
        return status / 100 == 2;
    }
}

