(ns com.flyingmachine.email.sending.content
  (:require [clojure.java.io :as io]
            [stencil.core :as stencil]
            [com.flyingmachine.config :as config]
            [clojure.contrib.core :refer (-?>)]))

(defn template-path
  [template-name extension]
  (str (config/setting :com.flyingmachine.email :template-path)
       "/" template-name "." extension))

(defn template
  [name extension]
  (-?> name
       (template-path extension)
       io/resource
       slurp))

(defn body
  [template-name data]
  (let [html-template (template template-name "html")
        text-template (template template-name "txt")]
    {:text (stencil/render-string text-template data)
     :html (stencil/render-string html-template data)}))