(ns fluree.raft.json-log
  (:require [clojure.data.json :as json]
            [clojure.tools.logging :as log]))

(defn log-event
  "Log a Raft event as JSON for timeline analysis."
  [event-type raft-state & {:as extra-data}]
  (let [event-data (merge
                    {:timestamp (System/currentTimeMillis)
                     :event event-type
                     :node (:this-server raft-state)
                     :term (:term raft-state)
                     :status (:status raft-state)
                     :leader (:leader raft-state)
                     :commit (:commit raft-state)
                     :index (:index raft-state)}
                    extra-data)]
    (log/info (str "RAFT-EVENT:" (json/write-str event-data)))))