// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5523__auto__ = (function tailrecursion$priority_map$iter__39641(s__39642){
return (new cljs.core.LazySeq(null,(function (){
var s__39642__$1 = s__39642;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39642__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39647 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39647,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39647,(1),null);
var iterys__5519__auto__ = ((function (s__39642__$1,vec__39647,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__39641_$_iter__39643(s__39644){
return (new cljs.core.LazySeq(null,((function (s__39642__$1,vec__39647,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function (){
var s__39644__$1 = s__39644;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39644__$1);
if(temp__5804__auto____$1){
var s__39644__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39644__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__39644__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__39646 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__39645 = (0);
while(true){
if((i__39645 < size__5522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__39645);
cljs.core.chunk_append(b__39646,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__39700 = (i__39645 + (1));
i__39645 = G__39700;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39646),tailrecursion$priority_map$iter__39641_$_iter__39643(cljs.core.chunk_rest(s__39644__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39646),null);
}
} else {
var item = cljs.core.first(s__39644__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__39641_$_iter__39643(cljs.core.rest(s__39644__$2)));
}
} else {
return null;
}
break;
}
});})(s__39642__$1,vec__39647,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
,null,null));
});})(s__39642__$1,vec__39647,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
;
var fs__5520__auto__ = cljs.core.seq(iterys__5519__auto__(item_set));
if(fs__5520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5520__auto__,tailrecursion$priority_map$iter__39641(cljs.core.rest(s__39642__$1)));
} else {
var G__39701 = cljs.core.rest(s__39642__$1);
s__39642__$1 = G__39701;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__5523__auto__ = (function tailrecursion$priority_map$iter__39650(s__39651){
return (new cljs.core.LazySeq(null,(function (){
var s__39651__$1 = s__39651;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39651__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39656 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39656,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39656,(1),null);
var iterys__5519__auto__ = ((function (s__39651__$1,vec__39656,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__39650_$_iter__39652(s__39653){
return (new cljs.core.LazySeq(null,((function (s__39651__$1,vec__39656,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function (){
var s__39653__$1 = s__39653;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39653__$1);
if(temp__5804__auto____$1){
var s__39653__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39653__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__39653__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__39655 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__39654 = (0);
while(true){
if((i__39654 < size__5522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__39654);
cljs.core.chunk_append(b__39655,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__39702 = (i__39654 + (1));
i__39654 = G__39702;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39655),tailrecursion$priority_map$iter__39650_$_iter__39652(cljs.core.chunk_rest(s__39653__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39655),null);
}
} else {
var item = cljs.core.first(s__39653__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__39650_$_iter__39652(cljs.core.rest(s__39653__$2)));
}
} else {
return null;
}
break;
}
});})(s__39651__$1,vec__39656,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
,null,null));
});})(s__39651__$1,vec__39656,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
;
var fs__5520__auto__ = cljs.core.seq(iterys__5519__auto__(item_set));
if(fs__5520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5520__auto__,tailrecursion$priority_map$iter__39650(cljs.core.rest(s__39651__$1)));
} else {
var G__39703 = cljs.core.rest(s__39651__$1);
s__39651__$1 = G__39703;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__39659 = item;
var G__39660 = new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517);
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__39659,G__39660) : self__.item__GT_priority.call(null,G__39659,G__39660));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5802__auto__)){
var current_priority = temp__5802__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5523__auto__ = (function tailrecursion$priority_map$iter__39661(s__39662){
return (new cljs.core.LazySeq(null,(function (){
var s__39662__$1 = s__39662;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39662__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39667 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39667,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39667,(1),null);
var iterys__5519__auto__ = ((function (s__39662__$1,vec__39667,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__39661_$_iter__39663(s__39664){
return (new cljs.core.LazySeq(null,((function (s__39662__$1,vec__39667,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function (){
var s__39664__$1 = s__39664;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39664__$1);
if(temp__5804__auto____$1){
var s__39664__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39664__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__39664__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__39666 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__39665 = (0);
while(true){
if((i__39665 < size__5522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__39665);
cljs.core.chunk_append(b__39666,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__39704 = (i__39665 + (1));
i__39665 = G__39704;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39666),tailrecursion$priority_map$iter__39661_$_iter__39663(cljs.core.chunk_rest(s__39664__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39666),null);
}
} else {
var item = cljs.core.first(s__39664__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__39661_$_iter__39663(cljs.core.rest(s__39664__$2)));
}
} else {
return null;
}
break;
}
});})(s__39662__$1,vec__39667,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
,null,null));
});})(s__39662__$1,vec__39667,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
;
var fs__5520__auto__ = cljs.core.seq(iterys__5519__auto__(item_set));
if(fs__5520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5520__auto__,tailrecursion$priority_map$iter__39661(cljs.core.rest(s__39662__$1)));
} else {
var G__39705 = cljs.core.rest(s__39662__$1);
s__39662__$1 = G__39705;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__5523__auto__ = (function tailrecursion$priority_map$iter__39670(s__39671){
return (new cljs.core.LazySeq(null,(function (){
var s__39671__$1 = s__39671;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39671__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39676 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39676,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39676,(1),null);
var iterys__5519__auto__ = ((function (s__39671__$1,vec__39676,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__39670_$_iter__39672(s__39673){
return (new cljs.core.LazySeq(null,((function (s__39671__$1,vec__39676,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function (){
var s__39673__$1 = s__39673;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39673__$1);
if(temp__5804__auto____$1){
var s__39673__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39673__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__39673__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__39675 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__39674 = (0);
while(true){
if((i__39674 < size__5522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__39674);
cljs.core.chunk_append(b__39675,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__39706 = (i__39674 + (1));
i__39674 = G__39706;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39675),tailrecursion$priority_map$iter__39670_$_iter__39672(cljs.core.chunk_rest(s__39673__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39675),null);
}
} else {
var item = cljs.core.first(s__39673__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__39670_$_iter__39672(cljs.core.rest(s__39673__$2)));
}
} else {
return null;
}
break;
}
});})(s__39671__$1,vec__39676,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
,null,null));
});})(s__39671__$1,vec__39676,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
;
var fs__5520__auto__ = cljs.core.seq(iterys__5519__auto__(item_set));
if(fs__5520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5520__auto__,tailrecursion$priority_map$iter__39670(cljs.core.rest(s__39671__$1)));
} else {
var G__39707 = cljs.core.rest(s__39671__$1);
s__39671__$1 = G__39707;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__39708 = null;
var G__39708__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__39708__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__39708 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__39708__2.call(this,self__,item);
case 3:
return G__39708__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__39708.cljs$core$IFn$_invoke$arity$2 = G__39708__2;
G__39708.cljs$core$IFn$_invoke$arity$3 = G__39708__3;
return G__39708;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args39640){
var self__ = this;
var self____$1 = this;
var args__5260__auto__ = cljs.core.aclone(args39640);
return self____$1.call.apply(self____$1,[self____$1].concat((((args__5260__auto__.length > (20)))?(function (){var G__39679 = args__5260__auto__.slice((0),(20));
G__39679.push(args__5260__auto__.slice((20)));

return G__39679;
})():args__5260__auto__)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__39680 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__39680.cljs$core$IFn$_invoke$arity$1 ? fexpr__39680.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__39680.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5523__auto__ = (function tailrecursion$priority_map$iter__39681(s__39682){
return (new cljs.core.LazySeq(null,(function (){
var s__39682__$1 = s__39682;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39682__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39687 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39687,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39687,(1),null);
var iterys__5519__auto__ = ((function (s__39682__$1,vec__39687,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__39681_$_iter__39683(s__39684){
return (new cljs.core.LazySeq(null,((function (s__39682__$1,vec__39687,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function (){
var s__39684__$1 = s__39684;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39684__$1);
if(temp__5804__auto____$1){
var s__39684__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39684__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__39684__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__39686 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__39685 = (0);
while(true){
if((i__39685 < size__5522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__39685);
cljs.core.chunk_append(b__39686,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__39709 = (i__39685 + (1));
i__39685 = G__39709;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39686),tailrecursion$priority_map$iter__39681_$_iter__39683(cljs.core.chunk_rest(s__39684__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39686),null);
}
} else {
var item = cljs.core.first(s__39684__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__39681_$_iter__39683(cljs.core.rest(s__39684__$2)));
}
} else {
return null;
}
break;
}
});})(s__39682__$1,vec__39687,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
,null,null));
});})(s__39682__$1,vec__39687,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
;
var fs__5520__auto__ = cljs.core.seq(iterys__5519__auto__(item_set));
if(fs__5520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5520__auto__,tailrecursion$priority_map$iter__39681(cljs.core.rest(s__39682__$1)));
} else {
var G__39710 = cljs.core.rest(s__39682__$1);
s__39682__$1 = G__39710;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__5523__auto__ = (function tailrecursion$priority_map$iter__39690(s__39691){
return (new cljs.core.LazySeq(null,(function (){
var s__39691__$1 = s__39691;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__39691__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__39696 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39696,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39696,(1),null);
var iterys__5519__auto__ = ((function (s__39691__$1,vec__39696,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__39690_$_iter__39692(s__39693){
return (new cljs.core.LazySeq(null,((function (s__39691__$1,vec__39696,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function (){
var s__39693__$1 = s__39693;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__39693__$1);
if(temp__5804__auto____$1){
var s__39693__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__39693__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__39693__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__39695 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__39694 = (0);
while(true){
if((i__39694 < size__5522__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__39694);
cljs.core.chunk_append(b__39695,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__39711 = (i__39694 + (1));
i__39694 = G__39711;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39695),tailrecursion$priority_map$iter__39690_$_iter__39692(cljs.core.chunk_rest(s__39693__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39695),null);
}
} else {
var item = cljs.core.first(s__39693__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__39690_$_iter__39692(cljs.core.rest(s__39693__$2)));
}
} else {
return null;
}
break;
}
});})(s__39691__$1,vec__39696,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
,null,null));
});})(s__39691__$1,vec__39696,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
;
var fs__5520__auto__ = cljs.core.seq(iterys__5519__auto__(item_set));
if(fs__5520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5520__auto__,tailrecursion$priority_map$iter__39690(cljs.core.rest(s__39691__$1)));
} else {
var G__39712 = cljs.core.rest(s__39691__$1);
s__39691__$1 = G__39712;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__39699 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__39699) : self__.keyfn.call(null,G__39699));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__39714 = arguments.length;
switch (G__39714) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39717 = arguments.length;
var i__5770__auto___39718 = (0);
while(true){
if((i__5770__auto___39718 < len__5769__auto___39717)){
args__5775__auto__.push((arguments[i__5770__auto___39718]));

var G__39719 = (i__5770__auto___39718 + (1));
i__5770__auto___39718 = G__39719;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__39720 = cljs.core.nnext(in$);
var G__39721 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__39720;
out = G__39721;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq39716){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39716));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39724 = arguments.length;
var i__5770__auto___39725 = (0);
while(true){
if((i__5770__auto___39725 < len__5769__auto___39724)){
args__5775__auto__.push((arguments[i__5770__auto___39725]));

var G__39726 = (i__5770__auto___39725 + (1));
i__5770__auto___39725 = G__39726;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__39727 = cljs.core.nnext(in$);
var G__39728 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__39727;
out = G__39728;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq39722){
var G__39723 = cljs.core.first(seq39722);
var seq39722__$1 = cljs.core.next(seq39722);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39723,seq39722__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39731 = arguments.length;
var i__5770__auto___39732 = (0);
while(true){
if((i__5770__auto___39732 < len__5769__auto___39731)){
args__5775__auto__.push((arguments[i__5770__auto___39732]));

var G__39733 = (i__5770__auto___39732 + (1));
i__5770__auto___39732 = G__39733;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__39734 = cljs.core.nnext(in$);
var G__39735 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__39734;
out = G__39735;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq39729){
var G__39730 = cljs.core.first(seq39729);
var seq39729__$1 = cljs.core.next(seq39729);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39730,seq39729__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__5775__auto__ = [];
var len__5769__auto___39739 = arguments.length;
var i__5770__auto___39740 = (0);
while(true){
if((i__5770__auto___39740 < len__5769__auto___39739)){
args__5775__auto__.push((arguments[i__5770__auto___39740]));

var G__39741 = (i__5770__auto___39740 + (1));
i__5770__auto___39740 = G__39741;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__39742 = cljs.core.nnext(in$);
var G__39743 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__39742;
out = G__39743;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq39736){
var G__39737 = cljs.core.first(seq39736);
var seq39736__$1 = cljs.core.next(seq39736);
var G__39738 = cljs.core.first(seq39736__$1);
var seq39736__$2 = cljs.core.next(seq39736__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39737,G__39738,seq39736__$2);
}));

