// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27351,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27355 = k27351;
var G__27355__$1 = (((G__27355 instanceof cljs.core.Keyword))?G__27355.fqn:null);
switch (G__27355__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27351,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__27356){
var vec__27357 = p__27356;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27357,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27357,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27350){
var self__ = this;
var G__27350__$1 = this;
return (new cljs.core.RecordIter((0),G__27350__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__27360 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__27360(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27352,other27353){
var self__ = this;
var this27352__$1 = this;
return (((!((other27353 == null)))) && ((((this27352__$1.constructor === other27353.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.conn,other27353.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.network,other27353.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.ledger_id,other27353.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.db_name,other27353.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.update_chan,other27353.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.transact_chan,other27353.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.state,other27353.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.schema_cache,other27353.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.blank_db,other27353.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.close,other27353.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.id,other27353.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27352__$1.__extmap,other27353.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27351){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27361 = k27351;
var G__27361__$1 = (((G__27361 instanceof cljs.core.Keyword))?G__27361.fqn:null);
switch (G__27361__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27351);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27350){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27362 = cljs.core.keyword_identical_QMARK_;
var expr__27363 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__27365 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27366 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27365,G__27366) : pred__27362.call(null,G__27365,G__27366));
})())){
return (new fluree.db.session.DbSession(G__27350,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27367 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27368 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27367,G__27368) : pred__27362.call(null,G__27367,G__27368));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27350,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27369 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__27370 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27369,G__27370) : pred__27362.call(null,G__27369,G__27370));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27350,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27371 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27372 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27371,G__27372) : pred__27362.call(null,G__27371,G__27372));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__27350,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27373 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27374 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27373,G__27374) : pred__27362.call(null,G__27373,G__27374));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__27350,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27375 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27376 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27375,G__27376) : pred__27362.call(null,G__27375,G__27376));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__27350,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27377 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27378 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27377,G__27378) : pred__27362.call(null,G__27377,G__27378));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__27350,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27379 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27380 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27379,G__27380) : pred__27362.call(null,G__27379,G__27380));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27350,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27381 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27382 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27381,G__27382) : pred__27362.call(null,G__27381,G__27382));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27350,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27383 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27384 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27383,G__27384) : pred__27362.call(null,G__27383,G__27384));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27350,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27385 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27386 = expr__27363;
return (pred__27362.cljs$core$IFn$_invoke$arity$2 ? pred__27362.cljs$core$IFn$_invoke$arity$2(G__27385,G__27386) : pred__27362.call(null,G__27385,G__27386));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27350,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__27350),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27350){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27350,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27354){
var extmap__5385__auto__ = (function (){var G__27387 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27354,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27354)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27387);
} else {
return G__27387;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27354),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27354),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27390 = session;
var map__27390__$1 = cljs.core.__destructure_map(map__27390);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27390__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27390__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27432){
var state_val_27433 = (state_27432[(1)]);
if((state_val_27433 === (7))){
var inst_27406 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_27407 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27408 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27409 = cljs.core.PersistentHashMap.fromArrays(inst_27407,inst_27408);
var inst_27410 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27406,inst_27409);
var inst_27411 = (function(){throw inst_27410})();
var state_27432__$1 = state_27432;
var statearr_27434_27457 = state_27432__$1;
(statearr_27434_27457[(2)] = inst_27411);

(statearr_27434_27457[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (1))){
var state_27432__$1 = state_27432;
var statearr_27435_27458 = state_27432__$1;
(statearr_27435_27458[(2)] = null);

(statearr_27435_27458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (4))){
var inst_27391 = (state_27432[(2)]);
var state_27432__$1 = state_27432;
var statearr_27436_27459 = state_27432__$1;
(statearr_27436_27459[(2)] = inst_27391);

(statearr_27436_27459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (6))){
var inst_27403 = (state_27432[(7)]);
var inst_27402 = (state_27432[(2)]);
var inst_27403__$1 = fluree.db.util.async.throw_err(inst_27402);
var inst_27404 = cljs.core.empty_QMARK_(inst_27403__$1);
var state_27432__$1 = (function (){var statearr_27437 = state_27432;
(statearr_27437[(7)] = inst_27403__$1);

return statearr_27437;
})();
if(inst_27404){
var statearr_27438_27460 = state_27432__$1;
(statearr_27438_27460[(1)] = (7));

} else {
var statearr_27439_27461 = state_27432__$1;
(statearr_27439_27461[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (3))){
var inst_27430 = (state_27432[(2)]);
var state_27432__$1 = state_27432;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27432__$1,inst_27430);
} else {
if((state_val_27433 === (12))){
var inst_27425 = (state_27432[(2)]);
var state_27432__$1 = state_27432;
var statearr_27440_27462 = state_27432__$1;
(statearr_27440_27462[(2)] = inst_27425);

(statearr_27440_27462[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (2))){
var _ = (function (){var statearr_27441 = state_27432;
(statearr_27441[(4)] = cljs.core.cons((5),(state_27432[(4)])));

return statearr_27441;
})();
var inst_27397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27398 = [network,ledger_id];
var inst_27399 = (new cljs.core.PersistentVector(null,2,(5),inst_27397,inst_27398,null));
var inst_27400 = fluree.db.operations.ledger_info_async(conn,inst_27399);
var state_27432__$1 = state_27432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27432__$1,(6),inst_27400);
} else {
if((state_val_27433 === (11))){
var inst_27403 = (state_27432[(7)]);
var state_27432__$1 = state_27432;
var statearr_27443_27463 = state_27432__$1;
(statearr_27443_27463[(2)] = inst_27403);

(statearr_27443_27463[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (9))){
var inst_27427 = (state_27432[(2)]);
var _ = (function (){var statearr_27444 = state_27432;
(statearr_27444[(4)] = cljs.core.rest((state_27432[(4)])));

return statearr_27444;
})();
var state_27432__$1 = state_27432;
var statearr_27445_27464 = state_27432__$1;
(statearr_27445_27464[(2)] = inst_27427);

(statearr_27445_27464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (5))){
var _ = (function (){var statearr_27446 = state_27432;
(statearr_27446[(4)] = cljs.core.rest((state_27432[(4)])));

return statearr_27446;
})();
var state_27432__$1 = state_27432;
var ex27442 = (state_27432__$1[(2)]);
var statearr_27447_27465 = state_27432__$1;
(statearr_27447_27465[(5)] = ex27442);


if((ex27442 instanceof Error)){
var statearr_27448_27466 = state_27432__$1;
(statearr_27448_27466[(1)] = (4));

(statearr_27448_27466[(5)] = null);

} else {
throw ex27442;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (10))){
var inst_27403 = (state_27432[(7)]);
var inst_27416 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27403);
var inst_27417 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27416),"."].join('');
var inst_27418 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27419 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27420 = cljs.core.PersistentHashMap.fromArrays(inst_27418,inst_27419);
var inst_27421 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27417,inst_27420);
var inst_27422 = (function(){throw inst_27421})();
var state_27432__$1 = state_27432;
var statearr_27449_27467 = state_27432__$1;
(statearr_27449_27467[(2)] = inst_27422);

(statearr_27449_27467[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (8))){
var inst_27403 = (state_27432[(7)]);
var inst_27413 = fluree.db.session.ready_QMARK_(inst_27403);
var inst_27414 = (!(inst_27413));
var state_27432__$1 = state_27432;
if(inst_27414){
var statearr_27450_27468 = state_27432__$1;
(statearr_27450_27468[(1)] = (10));

} else {
var statearr_27451_27469 = state_27432__$1;
(statearr_27451_27469[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0 = (function (){
var statearr_27452 = [null,null,null,null,null,null,null,null];
(statearr_27452[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2684__auto__);

(statearr_27452[(1)] = (1));

return statearr_27452;
});
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1 = (function (state_27432){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27432);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27453){var ex__2687__auto__ = e27453;
var statearr_27454_27470 = state_27432;
(statearr_27454_27470[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27432[(4)]))){
var statearr_27455_27471 = state_27432;
(statearr_27455_27471[(1)] = cljs.core.first((state_27432[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27472 = state_27432;
state_27432 = G__27472;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__ = function(state_27432){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1.call(this,state_27432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27456 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27456[(6)] = c__2706__auto__);

return statearr_27456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__27473){
var map__27474 = p__27473;
var map__27474__$1 = cljs.core.__destructure_map(map__27474);
var blank_db = map__27474__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27474__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27474__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27549){
var state_val_27550 = (state_27549[(1)]);
if((state_val_27550 === (7))){
var inst_27492 = (state_27549[(7)]);
var inst_27491 = (state_27549[(2)]);
var inst_27492__$1 = fluree.db.util.async.throw_err(inst_27491);
var state_27549__$1 = (function (){var statearr_27551 = state_27549;
(statearr_27551[(7)] = inst_27492__$1);

return statearr_27551;
})();
if(cljs.core.truth_(inst_27492__$1)){
var statearr_27552_27587 = state_27549__$1;
(statearr_27552_27587[(1)] = (8));

} else {
var statearr_27553_27588 = state_27549__$1;
(statearr_27553_27588[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (20))){
var inst_27497 = (state_27549[(8)]);
var inst_27530 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27497)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27531 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27532 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27533 = cljs.core.PersistentHashMap.fromArrays(inst_27531,inst_27532);
var inst_27534 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27530,inst_27533);
var inst_27535 = (function(){throw inst_27534})();
var state_27549__$1 = state_27549;
var statearr_27554_27589 = state_27549__$1;
(statearr_27554_27589[(2)] = inst_27535);

(statearr_27554_27589[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (1))){
var state_27549__$1 = state_27549;
var statearr_27555_27590 = state_27549__$1;
(statearr_27555_27590[(2)] = null);

(statearr_27555_27590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (4))){
var inst_27475 = (state_27549[(2)]);
var state_27549__$1 = state_27549;
var statearr_27556_27591 = state_27549__$1;
(statearr_27556_27591[(2)] = inst_27475);

(statearr_27556_27591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (15))){
var inst_27539 = (state_27549[(2)]);
var state_27549__$1 = state_27549;
var statearr_27557_27592 = state_27549__$1;
(statearr_27557_27592[(2)] = inst_27539);

(statearr_27557_27592[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (21))){
var inst_27537 = (state_27549[(2)]);
var state_27549__$1 = state_27549;
var statearr_27558_27593 = state_27549__$1;
(statearr_27558_27593[(2)] = inst_27537);

(statearr_27558_27593[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (13))){
var inst_27496 = (state_27549[(9)]);
var inst_27501 = fluree.db.query.schema.schema_map(inst_27496);
var inst_27502 = fluree.db.query.schema.setting_map(inst_27496);
var inst_27503 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_27496);
var inst_27504 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_27503,cljs.core.empty);
var state_27549__$1 = (function (){var statearr_27559 = state_27549;
(statearr_27559[(10)] = inst_27504);

(statearr_27559[(11)] = inst_27502);

return statearr_27559;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27549__$1,(16),inst_27501);
} else {
if((state_val_27550 === (22))){
var inst_27497 = (state_27549[(8)]);
var inst_27525 = (state_27549[(2)]);
var inst_27526 = fluree.db.util.async.throw_err(inst_27525);
var inst_27527 = (inst_27497 + (1));
var inst_27496 = inst_27526;
var inst_27497__$1 = inst_27527;
var state_27549__$1 = (function (){var statearr_27560 = state_27549;
(statearr_27560[(8)] = inst_27497__$1);

(statearr_27560[(9)] = inst_27496);

return statearr_27560;
})();
var statearr_27561_27594 = state_27549__$1;
(statearr_27561_27594[(2)] = null);

(statearr_27561_27594[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (6))){
var inst_27484 = (state_27549[(2)]);
var inst_27485 = fluree.db.util.async.throw_err(inst_27484);
var inst_27486 = cljs.core.__destructure_map(inst_27485);
var inst_27487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27486,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27486,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_27489 = fluree.db.storage.core.reify_db(conn,network,ledger_id,blank_db,inst_27488);
var state_27549__$1 = (function (){var statearr_27562 = state_27549;
(statearr_27562[(12)] = inst_27487);

return statearr_27562;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27549__$1,(7),inst_27489);
} else {
if((state_val_27550 === (17))){
var inst_27496 = (state_27549[(9)]);
var inst_27507 = (state_27549[(13)]);
var inst_27509 = (state_27549[(2)]);
var inst_27510 = fluree.db.util.async.throw_err(inst_27509);
var inst_27511 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_27496,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27507,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27510], 0));
var state_27549__$1 = state_27549;
var statearr_27563_27595 = state_27549__$1;
(statearr_27563_27595[(2)] = inst_27511);

(statearr_27563_27595[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (3))){
var inst_27547 = (state_27549[(2)]);
var state_27549__$1 = state_27549;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27549__$1,inst_27547);
} else {
if((state_val_27550 === (12))){
var inst_27541 = (state_27549[(2)]);
var state_27549__$1 = state_27549;
var statearr_27564_27596 = state_27549__$1;
(statearr_27564_27596[(2)] = inst_27541);

(statearr_27564_27596[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (2))){
var _ = (function (){var statearr_27565 = state_27549;
(statearr_27565[(4)] = cljs.core.cons((5),(state_27549[(4)])));

return statearr_27565;
})();
var inst_27482 = fluree.db.session.load_ledger_info(conn,network,ledger_id);
var state_27549__$1 = state_27549;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27549__$1,(6),inst_27482);
} else {
if((state_val_27550 === (19))){
var inst_27496 = (state_27549[(9)]);
var inst_27516 = (state_27549[(14)]);
var inst_27519 = cljs.core.__destructure_map(inst_27516);
var inst_27520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27519,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27521 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27519,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27522 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27519,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27523 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27496,inst_27521,inst_27520);
var state_27549__$1 = (function (){var statearr_27566 = state_27549;
(statearr_27566[(15)] = inst_27522);

return statearr_27566;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27549__$1,(22),inst_27523);
} else {
if((state_val_27550 === (11))){
var inst_27497 = (state_27549[(8)]);
var inst_27487 = (state_27549[(12)]);
var inst_27499 = (inst_27497 > inst_27487);
var state_27549__$1 = state_27549;
if(cljs.core.truth_(inst_27499)){
var statearr_27568_27597 = state_27549__$1;
(statearr_27568_27597[(1)] = (13));

} else {
var statearr_27569_27598 = state_27549__$1;
(statearr_27569_27598[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (9))){
var state_27549__$1 = state_27549;
var statearr_27570_27599 = state_27549__$1;
(statearr_27570_27599[(2)] = null);

(statearr_27570_27599[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (5))){
var _ = (function (){var statearr_27571 = state_27549;
(statearr_27571[(4)] = cljs.core.rest((state_27549[(4)])));

return statearr_27571;
})();
var state_27549__$1 = state_27549;
var ex27567 = (state_27549__$1[(2)]);
var statearr_27572_27600 = state_27549__$1;
(statearr_27572_27600[(5)] = ex27567);


if((ex27567 instanceof Error)){
var statearr_27573_27601 = state_27549__$1;
(statearr_27573_27601[(1)] = (4));

(statearr_27573_27601[(5)] = null);

} else {
throw ex27567;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (14))){
var inst_27497 = (state_27549[(8)]);
var inst_27513 = fluree.db.storage.core.read_block(conn,network,ledger_id,inst_27497);
var state_27549__$1 = state_27549;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27549__$1,(18),inst_27513);
} else {
if((state_val_27550 === (16))){
var inst_27502 = (state_27549[(11)]);
var inst_27506 = (state_27549[(2)]);
var inst_27507 = fluree.db.util.async.throw_err(inst_27506);
var state_27549__$1 = (function (){var statearr_27574 = state_27549;
(statearr_27574[(13)] = inst_27507);

return statearr_27574;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27549__$1,(17),inst_27502);
} else {
if((state_val_27550 === (10))){
var inst_27544 = (state_27549[(2)]);
var _ = (function (){var statearr_27575 = state_27549;
(statearr_27575[(4)] = cljs.core.rest((state_27549[(4)])));

return statearr_27575;
})();
var state_27549__$1 = state_27549;
var statearr_27576_27602 = state_27549__$1;
(statearr_27576_27602[(2)] = inst_27544);

(statearr_27576_27602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (18))){
var inst_27516 = (state_27549[(14)]);
var inst_27515 = (state_27549[(2)]);
var inst_27516__$1 = fluree.db.util.async.throw_err(inst_27515);
var state_27549__$1 = (function (){var statearr_27577 = state_27549;
(statearr_27577[(14)] = inst_27516__$1);

return statearr_27577;
})();
if(cljs.core.truth_(inst_27516__$1)){
var statearr_27578_27603 = state_27549__$1;
(statearr_27578_27603[(1)] = (19));

} else {
var statearr_27579_27604 = state_27549__$1;
(statearr_27579_27604[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27550 === (8))){
var inst_27492 = (state_27549[(7)]);
var inst_27494 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27492);
var inst_27495 = (inst_27494 + (1));
var inst_27496 = inst_27492;
var inst_27497 = inst_27495;
var state_27549__$1 = (function (){var statearr_27580 = state_27549;
(statearr_27580[(8)] = inst_27497);

(statearr_27580[(9)] = inst_27496);

return statearr_27580;
})();
var statearr_27581_27605 = state_27549__$1;
(statearr_27581_27605[(2)] = null);

(statearr_27581_27605[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2684__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2684__auto____0 = (function (){
var statearr_27582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27582[(0)] = fluree$db$session$load_current_db_$_state_machine__2684__auto__);

(statearr_27582[(1)] = (1));

return statearr_27582;
});
var fluree$db$session$load_current_db_$_state_machine__2684__auto____1 = (function (state_27549){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27549);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27583){var ex__2687__auto__ = e27583;
var statearr_27584_27606 = state_27549;
(statearr_27584_27606[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27549[(4)]))){
var statearr_27585_27607 = state_27549;
(statearr_27585_27607[(1)] = cljs.core.first((state_27549[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27608 = state_27549;
state_27549 = G__27608;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2684__auto__ = function(state_27549){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2684__auto____1.call(this,state_27549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2684__auto____0;
fluree$db$session$load_current_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2684__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27586 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27586[(6)] = c__2706__auto__);

return statearr_27586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27609,old_db_ch,new_db_ch){
var map__27610 = p__27609;
var map__27610__$1 = cljs.core.__destructure_map(map__27610);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27610__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p__27611){
var map__27612 = p__27611;
var map__27612__$1 = cljs.core.__destructure_map(map__27612);
var s = map__27612__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27612__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,old_db_ch)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27613){
var map__27614 = p__27613;
var map__27614__$1 = cljs.core.__destructure_map(map__27614);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27614__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27615){
var map__27616 = p__27615;
var map__27616__$1 = cljs.core.__destructure_map(map__27616);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27616__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27616__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27616__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2706__auto___27653 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27636){
var state_val_27637 = (state_27636[(1)]);
if((state_val_27637 === (1))){
var state_27636__$1 = state_27636;
var statearr_27638_27654 = state_27636__$1;
(statearr_27638_27654[(2)] = null);

(statearr_27638_27654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27637 === (2))){
var _ = (function (){var statearr_27639 = state_27636;
(statearr_27639[(4)] = cljs.core.cons((5),(state_27636[(4)])));

return statearr_27639;
})();
var inst_27626 = fluree.db.session.load_current_db(conn,blank_db);
var state_27636__$1 = state_27636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27636__$1,(6),inst_27626);
} else {
if((state_val_27637 === (3))){
var inst_27634 = (state_27636[(2)]);
var state_27636__$1 = state_27636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27636__$1,inst_27634);
} else {
if((state_val_27637 === (4))){
var inst_27617 = (state_27636[(2)]);
var inst_27618 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27619 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_27617,"Error reloading db") : fluree.db.util.log.error.call(null,inst_27617,"Error reloading db"));
var inst_27620 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(db_ch,inst_27617);
var state_27636__$1 = (function (){var statearr_27641 = state_27636;
(statearr_27641[(7)] = inst_27619);

(statearr_27641[(8)] = inst_27618);

return statearr_27641;
})();
var statearr_27642_27655 = state_27636__$1;
(statearr_27642_27655[(2)] = inst_27620);

(statearr_27642_27655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27637 === (5))){
var _ = (function (){var statearr_27643 = state_27636;
(statearr_27643[(4)] = cljs.core.rest((state_27636[(4)])));

return statearr_27643;
})();
var state_27636__$1 = state_27636;
var ex27640 = (state_27636__$1[(2)]);
var statearr_27644_27656 = state_27636__$1;
(statearr_27644_27656[(5)] = ex27640);


var statearr_27645_27657 = state_27636__$1;
(statearr_27645_27657[(1)] = (4));

(statearr_27645_27657[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27637 === (6))){
var inst_27628 = (state_27636[(2)]);
var inst_27629 = fluree.db.util.async.throw_err(inst_27628);
var state_27636__$1 = state_27636;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27636__$1,(7),db_ch,inst_27629);
} else {
if((state_val_27637 === (7))){
var inst_27631 = (state_27636[(2)]);
var _ = (function (){var statearr_27646 = state_27636;
(statearr_27646[(4)] = cljs.core.rest((state_27636[(4)])));

return statearr_27646;
})();
var state_27636__$1 = state_27636;
var statearr_27647_27658 = state_27636__$1;
(statearr_27647_27658[(2)] = inst_27631);

(statearr_27647_27658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0 = (function (){
var statearr_27648 = [null,null,null,null,null,null,null,null,null];
(statearr_27648[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__);

(statearr_27648[(1)] = (1));

return statearr_27648;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1 = (function (state_27636){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27636);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27649){var ex__2687__auto__ = e27649;
var statearr_27650_27659 = state_27636;
(statearr_27650_27659[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27636[(4)]))){
var statearr_27651_27660 = state_27636;
(statearr_27651_27660[(1)] = cljs.core.first((state_27636[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27661 = state_27636;
state_27636 = G__27661;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__ = function(state_27636){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1.call(this,state_27636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27652 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27652[(6)] = c__2706__auto___27653);

return statearr_27652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27663 = arguments.length;
switch (G__27663) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27664){
var map__27665 = p__27664;
var map__27665__$1 = cljs.core.__destructure_map(map__27665);
var session = map__27665__$1;
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27665__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2(session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27666,blank_db){
var map__27667 = p__27666;
var map__27667__$1 = cljs.core.__destructure_map(map__27667);
var session = map__27667__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27667__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27667__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis()),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
if(cljs.core.not(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cur_ch,state_ch)){
var c__2706__auto___27705 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27687){
var state_val_27688 = (state_27687[(1)]);
if((state_val_27688 === (1))){
var state_27687__$1 = state_27687;
var statearr_27689_27706 = state_27687__$1;
(statearr_27689_27706[(2)] = null);

(statearr_27689_27706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27688 === (2))){
var _ = (function (){var statearr_27690 = state_27687;
(statearr_27690[(4)] = cljs.core.cons((5),(state_27687[(4)])));

return statearr_27690;
})();
var inst_27677 = fluree.db.session.load_current_db(conn,blank_db);
var state_27687__$1 = state_27687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27687__$1,(6),inst_27677);
} else {
if((state_val_27688 === (3))){
var inst_27685 = (state_27687[(2)]);
var state_27687__$1 = state_27687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27687__$1,inst_27685);
} else {
if((state_val_27688 === (4))){
var inst_27668 = (state_27687[(2)]);
var inst_27669 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27670 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_27668,"Error loading current db") : fluree.db.util.log.error.call(null,inst_27668,"Error loading current db"));
var inst_27671 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cur_ch,inst_27668);
var state_27687__$1 = (function (){var statearr_27692 = state_27687;
(statearr_27692[(7)] = inst_27670);

(statearr_27692[(8)] = inst_27669);

return statearr_27692;
})();
var statearr_27693_27707 = state_27687__$1;
(statearr_27693_27707[(2)] = inst_27671);

(statearr_27693_27707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27688 === (5))){
var _ = (function (){var statearr_27694 = state_27687;
(statearr_27694[(4)] = cljs.core.rest((state_27687[(4)])));

return statearr_27694;
})();
var state_27687__$1 = state_27687;
var ex27691 = (state_27687__$1[(2)]);
var statearr_27695_27708 = state_27687__$1;
(statearr_27695_27708[(5)] = ex27691);


var statearr_27696_27709 = state_27687__$1;
(statearr_27696_27709[(1)] = (4));

(statearr_27696_27709[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27688 === (6))){
var inst_27679 = (state_27687[(2)]);
var inst_27680 = fluree.db.util.async.throw_err(inst_27679);
var state_27687__$1 = state_27687;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27687__$1,(7),cur_ch,inst_27680);
} else {
if((state_val_27688 === (7))){
var inst_27682 = (state_27687[(2)]);
var _ = (function (){var statearr_27697 = state_27687;
(statearr_27697[(4)] = cljs.core.rest((state_27687[(4)])));

return statearr_27697;
})();
var state_27687__$1 = state_27687;
var statearr_27698_27710 = state_27687__$1;
(statearr_27698_27710[(2)] = inst_27682);

(statearr_27698_27710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27699 = [null,null,null,null,null,null,null,null,null];
(statearr_27699[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27699[(1)] = (1));

return statearr_27699;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27687){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27687);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27700){var ex__2687__auto__ = e27700;
var statearr_27701_27711 = state_27687;
(statearr_27701_27711[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27687[(4)]))){
var statearr_27702_27712 = state_27687;
(statearr_27702_27712[(1)] = cljs.core.first((state_27687[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27713 = state_27687;
state_27687 = G__27713;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27687){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27703 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27703[(6)] = c__2706__auto___27705);

return statearr_27703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger named testledger on network testnet.
 *   - [testnet testledger] - already in form of [network ledger-id]
 * 
 *   The two-arity version of this exists for backwards compatibility. It doesn't do anything with the
 *   conn arg so there is also a single-arity version that just takes the ledger name.
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(var_args){
var G__27715 = arguments.length;
switch (G__27715) {
case 1:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1 = (function (ledger){
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(null,ledger);
}));

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2 = (function (_conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var ledger_id = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return ledger_id;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
}
}));

(fluree.db.session.resolve_ledger.cljs$lang$maxFixedArity = 2);

if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__27717 = cljs.core.get_global_hierarchy;
return (fexpr__27717.cljs$core$IFn$_invoke$arity$0 ? fexpr__27717.cljs$core$IFn$_invoke$arity$0() : fexpr__27717.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27719){
var state_val_27720 = (state_27719[(1)]);
if((state_val_27720 === (1))){
var state_27719__$1 = state_27719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27719__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27721 = [null,null,null,null,null,null,null];
(statearr_27721[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27721[(1)] = (1));

return statearr_27721;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27719){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27719);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27722){var ex__2687__auto__ = e27722;
var statearr_27723_27726 = state_27719;
(statearr_27723_27726[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27719[(4)]))){
var statearr_27724_27727 = state_27719;
(statearr_27724_27727[(1)] = cljs.core.first((state_27719[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27728 = state_27719;
state_27719 = G__27728;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27719){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27725 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27725[(6)] = c__2706__auto__);

return statearr_27725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27729){
var map__27730 = p__27729;
var map__27730__$1 = cljs.core.__destructure_map(map__27730);
var data = map__27730__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27730__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27730__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27730__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27789){
var state_val_27790 = (state_27789[(1)]);
if((state_val_27790 === (7))){
var inst_27741 = (state_27789[(7)]);
var inst_27744 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27745 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27746 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27744),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27745),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27741),". No-op."].join('');
var inst_27747 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_27746) : fluree.db.util.log.info.call(null,inst_27746));
var state_27789__$1 = state_27789;
var statearr_27791_27829 = state_27789__$1;
(statearr_27791_27829[(2)] = inst_27747);

(statearr_27791_27829[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (1))){
var state_27789__$1 = state_27789;
var statearr_27792_27830 = state_27789__$1;
(statearr_27792_27830[(2)] = null);

(statearr_27792_27830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (4))){
var inst_27731 = (state_27789[(2)]);
var state_27789__$1 = state_27789;
var statearr_27793_27831 = state_27789__$1;
(statearr_27793_27831[(2)] = inst_27731);

(statearr_27793_27831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (15))){
var inst_27770 = (state_27789[(2)]);
var state_27789__$1 = state_27789;
var statearr_27794_27832 = state_27789__$1;
(statearr_27794_27832[(2)] = inst_27770);

(statearr_27794_27832[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (13))){
var inst_27761 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27763 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27764 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27765 = [inst_27763,inst_27764];
var inst_27766 = (new cljs.core.PersistentVector(null,2,(5),inst_27762,inst_27765,null));
var inst_27767 = (function (){var G__27795 = inst_27761;
var G__27796 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__27797 = inst_27766;
var G__27798 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__27795,G__27796,G__27797,G__27798) : fluree.db.conn_events.process_event.call(null,G__27795,G__27796,G__27797,G__27798));
})();
var state_27789__$1 = state_27789;
var statearr_27799_27833 = state_27789__$1;
(statearr_27799_27833[(2)] = inst_27767);

(statearr_27799_27833[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (6))){
var inst_27741 = (state_27789[(7)]);
var inst_27740 = (state_27789[(8)]);
var inst_27739 = (state_27789[(2)]);
var inst_27740__$1 = fluree.db.util.async.throw_err(inst_27739);
var inst_27741__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27740__$1);
var inst_27742 = (block <= inst_27741__$1);
var state_27789__$1 = (function (){var statearr_27800 = state_27789;
(statearr_27800[(7)] = inst_27741__$1);

(statearr_27800[(8)] = inst_27740__$1);

return statearr_27800;
})();
if(cljs.core.truth_(inst_27742)){
var statearr_27801_27834 = state_27789__$1;
(statearr_27801_27834[(1)] = (7));

} else {
var statearr_27802_27835 = state_27789__$1;
(statearr_27802_27835[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (17))){
var state_27789__$1 = state_27789;
var statearr_27803_27836 = state_27789__$1;
(statearr_27803_27836[(2)] = null);

(statearr_27803_27836[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (3))){
var inst_27787 = (state_27789[(2)]);
var state_27789__$1 = state_27789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27789__$1,inst_27787);
} else {
if((state_val_27790 === (12))){
var inst_27782 = (state_27789[(2)]);
var state_27789__$1 = state_27789;
var statearr_27804_27837 = state_27789__$1;
(statearr_27804_27837[(2)] = inst_27782);

(statearr_27804_27837[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (2))){
var inst_27737 = (state_27789[(9)]);
var _ = (function (){var statearr_27805 = state_27789;
(statearr_27805[(4)] = cljs.core.cons((5),(state_27789[(4)])));

return statearr_27805;
})();
var inst_27737__$1 = fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
var state_27789__$1 = (function (){var statearr_27806 = state_27789;
(statearr_27806[(9)] = inst_27737__$1);

return statearr_27806;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27789__$1,(6),inst_27737__$1);
} else {
if((state_val_27790 === (11))){
var state_27789__$1 = state_27789;
var statearr_27808_27838 = state_27789__$1;
(statearr_27808_27838[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (9))){
var inst_27784 = (state_27789[(2)]);
var _ = (function (){var statearr_27810 = state_27789;
(statearr_27810[(4)] = cljs.core.rest((state_27789[(4)])));

return statearr_27810;
})();
var state_27789__$1 = state_27789;
var statearr_27811_27839 = state_27789__$1;
(statearr_27811_27839[(2)] = inst_27784);

(statearr_27811_27839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (5))){
var _ = (function (){var statearr_27812 = state_27789;
(statearr_27812[(4)] = cljs.core.rest((state_27789[(4)])));

return statearr_27812;
})();
var state_27789__$1 = state_27789;
var ex27807 = (state_27789__$1[(2)]);
var statearr_27813_27840 = state_27789__$1;
(statearr_27813_27840[(5)] = ex27807);


if((ex27807 instanceof Error)){
var statearr_27814_27841 = state_27789__$1;
(statearr_27814_27841[(1)] = (4));

(statearr_27814_27841[(5)] = null);

} else {
throw ex27807;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (14))){
var state_27789__$1 = state_27789;
var statearr_27815_27842 = state_27789__$1;
(statearr_27815_27842[(2)] = null);

(statearr_27815_27842[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (16))){
var inst_27741 = (state_27789[(7)]);
var inst_27773 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27774 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27775 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27773),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27774),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27741),". Forcing a db reload."].join('');
var inst_27776 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_27775) : fluree.db.util.log.info.call(null,inst_27775));
var inst_27777 = fluree.db.session.reload_db_BANG_(session);
var state_27789__$1 = (function (){var statearr_27816 = state_27789;
(statearr_27816[(10)] = inst_27776);

return statearr_27816;
})();
var statearr_27817_27843 = state_27789__$1;
(statearr_27817_27843[(2)] = inst_27777);

(statearr_27817_27843[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (10))){
var inst_27741 = (state_27789[(7)]);
var inst_27740 = (state_27789[(8)]);
var inst_27737 = (state_27789[(9)]);
var inst_27752 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27753 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27754 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27752),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27753),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27755 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1(inst_27754) : fluree.db.util.log.trace.call(null,inst_27754));
var inst_27756 = (function (){var current_db_ch = inst_27737;
var current_db = inst_27740;
var current_block = inst_27741;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(f);
}
});
})();
var inst_27757 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27756,flakes);
var inst_27758 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27740,block,inst_27757);
var inst_27759 = fluree.db.session.cas_db_BANG_(session,inst_27737,inst_27758);
var state_27789__$1 = (function (){var statearr_27818 = state_27789;
(statearr_27818[(11)] = inst_27755);

return statearr_27818;
})();
if(inst_27759){
var statearr_27819_27844 = state_27789__$1;
(statearr_27819_27844[(1)] = (13));

} else {
var statearr_27820_27845 = state_27789__$1;
(statearr_27820_27845[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (18))){
var inst_27780 = (state_27789[(2)]);
var state_27789__$1 = state_27789;
var statearr_27821_27846 = state_27789__$1;
(statearr_27821_27846[(2)] = inst_27780);

(statearr_27821_27846[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27790 === (8))){
var inst_27741 = (state_27789[(7)]);
var inst_27749 = ((1) + inst_27741);
var inst_27750 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27749);
var state_27789__$1 = state_27789;
if(inst_27750){
var statearr_27822_27847 = state_27789__$1;
(statearr_27822_27847[(1)] = (10));

} else {
var statearr_27823_27848 = state_27789__$1;
(statearr_27823_27848[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27824 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27824[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27824[(1)] = (1));

return statearr_27824;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27789){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27789);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27825){var ex__2687__auto__ = e27825;
var statearr_27826_27849 = state_27789;
(statearr_27826_27849[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27789[(4)]))){
var statearr_27827_27850 = state_27789;
(statearr_27827_27850[(1)] = cljs.core.first((state_27789[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27851 = state_27789;
state_27789 = G__27851;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27789){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27828 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27828[(6)] = c__2706__auto__);

return statearr_27828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27858){
var state_val_27859 = (state_27858[(1)]);
if((state_val_27859 === (1))){
var inst_27852 = fluree.db.session.clear_db_BANG_(session);
var inst_27853 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27854 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27855 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27853),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27854)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27856 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1(inst_27855) : fluree.db.util.log.debug.call(null,inst_27855));
var state_27858__$1 = (function (){var statearr_27860 = state_27858;
(statearr_27860[(7)] = inst_27852);

(statearr_27860[(8)] = inst_27856);

return statearr_27860;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27858__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27861 = [null,null,null,null,null,null,null,null,null];
(statearr_27861[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27861[(1)] = (1));

return statearr_27861;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27858){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27858);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27862){var ex__2687__auto__ = e27862;
var statearr_27863_27866 = state_27858;
(statearr_27863_27866[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27858[(4)]))){
var statearr_27864_27867 = state_27858;
(statearr_27864_27867[(1)] = cljs.core.first((state_27858[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27868 = state_27858;
state_27858 = G__27868;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27858){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27865 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27865[(6)] = c__2706__auto__);

return statearr_27865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27870 = arguments.length;
switch (G__27870) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27871){
var map__27872 = p__27871;
var map__27872__$1 = cljs.core.__destructure_map(map__27872);
var session = map__27872__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27872__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27872__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27872__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27872__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27872__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27872__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27872__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
fluree.db.session.remove_cache_BANG_(network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__27873_27876 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27873_27876.cljs$core$IFn$_invoke$arity$3 ? fexpr__27873_27876.cljs$core$IFn$_invoke$arity$3(network,ledger_id,id) : fexpr__27873_27876.call(null,network,ledger_id,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,ledger_id);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__27874_27877 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__27874_27877.cljs$core$IFn$_invoke$arity$0 ? fexpr__27874_27877.cljs$core$IFn$_invoke$arity$0() : fexpr__27874_27877.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27929){
var state_val_27930 = (state_27929[(1)]);
if((state_val_27930 === (7))){
var inst_27925 = (state_27929[(2)]);
var state_27929__$1 = state_27929;
var statearr_27931_27962 = state_27929__$1;
(statearr_27931_27962[(2)] = inst_27925);

(statearr_27931_27962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (1))){
var state_27929__$1 = state_27929;
var statearr_27932_27963 = state_27929__$1;
(statearr_27932_27963[(2)] = null);

(statearr_27932_27963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (4))){
var inst_27881 = (state_27929[(7)]);
var inst_27880 = (state_27929[(2)]);
var inst_27881__$1 = fluree.db.util.async.throw_err(inst_27880);
var inst_27882 = fluree.db.session.from_cache(network,ledger_id);
var inst_27883 = (inst_27881__$1 == null);
var state_27929__$1 = (function (){var statearr_27933 = state_27929;
(statearr_27933[(8)] = inst_27882);

(statearr_27933[(7)] = inst_27881__$1);

return statearr_27933;
})();
if(cljs.core.truth_(inst_27883)){
var statearr_27934_27964 = state_27929__$1;
(statearr_27934_27964[(1)] = (5));

} else {
var statearr_27935_27965 = state_27929__$1;
(statearr_27935_27965[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (15))){
var inst_27917 = (state_27929[(2)]);
var state_27929__$1 = (function (){var statearr_27936 = state_27929;
(statearr_27936[(9)] = inst_27917);

return statearr_27936;
})();
var statearr_27937_27966 = state_27929__$1;
(statearr_27937_27966[(2)] = null);

(statearr_27937_27966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (13))){
var inst_27921 = (state_27929[(2)]);
var state_27929__$1 = state_27929;
var statearr_27939_27967 = state_27929__$1;
(statearr_27939_27967[(2)] = inst_27921);

(statearr_27939_27967[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (6))){
var inst_27882 = (state_27929[(8)]);
var inst_27888 = (inst_27882 == null);
var state_27929__$1 = state_27929;
if(cljs.core.truth_(inst_27888)){
var statearr_27940_27968 = state_27929__$1;
(statearr_27940_27968[(1)] = (8));

} else {
var statearr_27941_27969 = state_27929__$1;
(statearr_27941_27969[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (17))){
var _ = (function (){var statearr_27942 = state_27929;
(statearr_27942[(4)] = cljs.core.rest((state_27929[(4)])));

return statearr_27942;
})();
var state_27929__$1 = state_27929;
var ex27938 = (state_27929__$1[(2)]);
var statearr_27943_27970 = state_27929__$1;
(statearr_27943_27970[(5)] = ex27938);


var statearr_27944_27971 = state_27929__$1;
(statearr_27944_27971[(1)] = (16));

(statearr_27944_27971[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (3))){
var inst_27927 = (state_27929[(2)]);
var state_27929__$1 = state_27929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27929__$1,inst_27927);
} else {
if((state_val_27930 === (12))){
var state_27929__$1 = state_27929;
var statearr_27945_27972 = state_27929__$1;
(statearr_27945_27972[(2)] = null);

(statearr_27945_27972[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (2))){
var state_27929__$1 = state_27929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27929__$1,(4),update_chan);
} else {
if((state_val_27930 === (11))){
var state_27929__$1 = state_27929;
var statearr_27946_27973 = state_27929__$1;
(statearr_27946_27973[(2)] = null);

(statearr_27946_27973[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (9))){
var state_27929__$1 = state_27929;
var statearr_27947_27974 = state_27929__$1;
(statearr_27947_27974[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (5))){
var inst_27885 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27886 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Channel closed for session updates for:",inst_27885) : fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27885));
var state_27929__$1 = state_27929;
var statearr_27949_27975 = state_27929__$1;
(statearr_27949_27975[(2)] = inst_27886);

(statearr_27949_27975[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (14))){
var inst_27882 = (state_27929[(8)]);
var inst_27881 = (state_27929[(7)]);
var _ = (function (){var statearr_27950 = state_27929;
(statearr_27950[(4)] = cljs.core.cons((17),(state_27929[(4)])));

return statearr_27950;
})();
var inst_27905 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27881,(0),null);
var inst_27906 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27881,(1),null);
var inst_27907 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27908 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27881], 0));
var inst_27909 = fluree.db.util.core.trunc(inst_27908,(200));
var inst_27910 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(inst_27907,inst_27909) : fluree.db.util.log.trace.call(null,inst_27907,inst_27909));
var inst_27911 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_27882,inst_27905,inst_27906) : fluree.db.session.process_ledger_update.call(null,inst_27882,inst_27905,inst_27906));
var state_27929__$1 = (function (){var statearr_27951 = state_27929;
(statearr_27951[(10)] = inst_27910);

return statearr_27951;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27929__$1,(18),inst_27911);
} else {
if((state_val_27930 === (16))){
var inst_27881 = (state_27929[(7)]);
var inst_27895 = (state_27929[(2)]);
var inst_27896 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_27895,"Exception processing ledger updates for message: ",inst_27881) : fluree.db.util.log.error.call(null,inst_27895,"Exception processing ledger updates for message: ",inst_27881));
var state_27929__$1 = state_27929;
var statearr_27952_27976 = state_27929__$1;
(statearr_27952_27976[(2)] = inst_27896);

(statearr_27952_27976[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (10))){
var inst_27923 = (state_27929[(2)]);
var state_27929__$1 = state_27929;
var statearr_27953_27977 = state_27929__$1;
(statearr_27953_27977[(2)] = inst_27923);

(statearr_27953_27977[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (18))){
var inst_27913 = (state_27929[(2)]);
var inst_27914 = fluree.db.util.async.throw_err(inst_27913);
var _ = (function (){var statearr_27954 = state_27929;
(statearr_27954[(4)] = cljs.core.rest((state_27929[(4)])));

return statearr_27954;
})();
var state_27929__$1 = state_27929;
var statearr_27955_27978 = state_27929__$1;
(statearr_27955_27978[(2)] = inst_27914);

(statearr_27955_27978[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27930 === (8))){
var inst_27881 = (state_27929[(7)]);
var inst_27890 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27891 = cljs.core.first(inst_27881);
var inst_27892 = (fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4("Ledger update received for session that is no longer open:",inst_27890,"Message: ",inst_27891) : fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27890,"Message: ",inst_27891));
var state_27929__$1 = state_27929;
var statearr_27956_27979 = state_27929__$1;
(statearr_27956_27979[(2)] = inst_27892);

(statearr_27956_27979[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0 = (function (){
var statearr_27957 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27957[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__);

(statearr_27957[(1)] = (1));

return statearr_27957;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1 = (function (state_27929){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27929);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27958){var ex__2687__auto__ = e27958;
var statearr_27959_27980 = state_27929;
(statearr_27959_27980[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27929[(4)]))){
var statearr_27960_27981 = state_27929;
(statearr_27960_27981[(1)] = cljs.core.first((state_27929[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27982 = state_27929;
state_27929 = G__27982;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__ = function(state_27929){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1.call(this,state_27929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27961 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27961[(6)] = c__2706__auto__);

return statearr_27961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27983){
var map__27984 = p__27983;
var map__27984__$1 = cljs.core.__destructure_map(map__27984);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27984__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null),network,null,conn]));
var current_db_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db(conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27988 = block_result;
var map__27988__$1 = cljs.core.__destructure_map(map__27988);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27988__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27988__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27988__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27988__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27988__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__27989 = tx_result;
var map__27989__$1 = cljs.core.__destructure_map(map__27989);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27989__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27989__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__27985_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,fluree.db.flake.t(p1__27985_SHARP_));
}):(function (p1__27986_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27986_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__27987_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__27987_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27987_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27990 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27990,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27990,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27990,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27990,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var G__27993_27995 = "Create and cache session. Opt keys: ";
var G__27994_27996 = cljs.core.keys(opts);
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(G__27993_27995,G__27994_27996) : fluree.db.util.log.trace.call(null,G__27993_27995,G__27994_27996));

var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27998 = arguments.length;
switch (G__27998) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27999){
var map__28000 = p__27999;
var map__28000__$1 = cljs.core.__destructure_map(map__28000);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28000__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28000__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28000__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28000__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28001 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28001,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28001,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28001,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__28005_28157 = network;
var G__28006_28158 = ledger_id;
var G__28007_28159 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__28008_28160 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28009 = cljs.core.seq(tids);
var chunk__28010 = null;
var count__28011 = (0);
var i__28012 = (0);
while(true){
if((i__28012 < count__28011)){
var tid = chunk__28010.cljs$core$IIndexed$_nth$arity$2(null,i__28012);
var temp__5804__auto___28162__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___28162__$1)){
var keyed_callbacks_28163 = temp__5804__auto___28162__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28164 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28069_28165 = cljs.core.seq(keyed_callbacks_28163);
var chunk__28070_28166 = null;
var count__28071_28167 = (0);
var i__28072_28168 = (0);
while(true){
if((i__28072_28168 < count__28071_28167)){
var vec__28085_28169 = chunk__28070_28166.cljs$core$IIndexed$_nth$arity$2(null,i__28072_28168);
var k_28170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28085_28169,(0),null);
var f_28171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28085_28169,(1),null);
try{(f_28171.cljs$core$IFn$_invoke$arity$1 ? f_28171.cljs$core$IFn$_invoke$arity$1(tx_response_28164) : f_28171.call(null,tx_response_28164));
}catch (e28088){var e_28172 = e28088;
var G__28089_28173 = e_28172;
var G__28090_28174 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__28089_28173,G__28090_28174) : fluree.db.util.log.error.call(null,G__28089_28173,G__28090_28174));
}

var G__28175 = seq__28069_28165;
var G__28176 = chunk__28070_28166;
var G__28177 = count__28071_28167;
var G__28178 = (i__28072_28168 + (1));
seq__28069_28165 = G__28175;
chunk__28070_28166 = G__28176;
count__28071_28167 = G__28177;
i__28072_28168 = G__28178;
continue;
} else {
var temp__5804__auto___28179__$2 = cljs.core.seq(seq__28069_28165);
if(temp__5804__auto___28179__$2){
var seq__28069_28180__$1 = temp__5804__auto___28179__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28069_28180__$1)){
var c__5568__auto___28181 = cljs.core.chunk_first(seq__28069_28180__$1);
var G__28182 = cljs.core.chunk_rest(seq__28069_28180__$1);
var G__28183 = c__5568__auto___28181;
var G__28184 = cljs.core.count(c__5568__auto___28181);
var G__28185 = (0);
seq__28069_28165 = G__28182;
chunk__28070_28166 = G__28183;
count__28071_28167 = G__28184;
i__28072_28168 = G__28185;
continue;
} else {
var vec__28091_28186 = cljs.core.first(seq__28069_28180__$1);
var k_28187 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28091_28186,(0),null);
var f_28188 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28091_28186,(1),null);
try{(f_28188.cljs$core$IFn$_invoke$arity$1 ? f_28188.cljs$core$IFn$_invoke$arity$1(tx_response_28164) : f_28188.call(null,tx_response_28164));
}catch (e28094){var e_28189 = e28094;
var G__28095_28190 = e_28189;
var G__28096_28191 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__28095_28190,G__28096_28191) : fluree.db.util.log.error.call(null,G__28095_28190,G__28096_28191));
}

var G__28192 = cljs.core.next(seq__28069_28180__$1);
var G__28193 = null;
var G__28194 = (0);
var G__28195 = (0);
seq__28069_28165 = G__28192;
chunk__28070_28166 = G__28193;
count__28071_28167 = G__28194;
i__28072_28168 = G__28195;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28196 = seq__28009;
var G__28197 = chunk__28010;
var G__28198 = count__28011;
var G__28199 = (i__28012 + (1));
seq__28009 = G__28196;
chunk__28010 = G__28197;
count__28011 = G__28198;
i__28012 = G__28199;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__28009);
if(temp__5804__auto____$1){
var seq__28009__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__28009__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__28009__$1);
var G__28200 = cljs.core.chunk_rest(seq__28009__$1);
var G__28201 = c__5568__auto__;
var G__28202 = cljs.core.count(c__5568__auto__);
var G__28203 = (0);
seq__28009 = G__28200;
chunk__28010 = G__28201;
count__28011 = G__28202;
i__28012 = G__28203;
continue;
} else {
var tid = cljs.core.first(seq__28009__$1);
var temp__5804__auto___28204__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___28204__$2)){
var keyed_callbacks_28205 = temp__5804__auto___28204__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28206 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28097_28207 = cljs.core.seq(keyed_callbacks_28205);
var chunk__28098_28208 = null;
var count__28099_28209 = (0);
var i__28100_28210 = (0);
while(true){
if((i__28100_28210 < count__28099_28209)){
var vec__28113_28211 = chunk__28098_28208.cljs$core$IIndexed$_nth$arity$2(null,i__28100_28210);
var k_28212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28113_28211,(0),null);
var f_28213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28113_28211,(1),null);
try{(f_28213.cljs$core$IFn$_invoke$arity$1 ? f_28213.cljs$core$IFn$_invoke$arity$1(tx_response_28206) : f_28213.call(null,tx_response_28206));
}catch (e28116){var e_28214 = e28116;
var G__28117_28215 = e_28214;
var G__28118_28216 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__28117_28215,G__28118_28216) : fluree.db.util.log.error.call(null,G__28117_28215,G__28118_28216));
}

var G__28217 = seq__28097_28207;
var G__28218 = chunk__28098_28208;
var G__28219 = count__28099_28209;
var G__28220 = (i__28100_28210 + (1));
seq__28097_28207 = G__28217;
chunk__28098_28208 = G__28218;
count__28099_28209 = G__28219;
i__28100_28210 = G__28220;
continue;
} else {
var temp__5804__auto___28221__$3 = cljs.core.seq(seq__28097_28207);
if(temp__5804__auto___28221__$3){
var seq__28097_28222__$1 = temp__5804__auto___28221__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28097_28222__$1)){
var c__5568__auto___28223 = cljs.core.chunk_first(seq__28097_28222__$1);
var G__28224 = cljs.core.chunk_rest(seq__28097_28222__$1);
var G__28225 = c__5568__auto___28223;
var G__28226 = cljs.core.count(c__5568__auto___28223);
var G__28227 = (0);
seq__28097_28207 = G__28224;
chunk__28098_28208 = G__28225;
count__28099_28209 = G__28226;
i__28100_28210 = G__28227;
continue;
} else {
var vec__28119_28228 = cljs.core.first(seq__28097_28222__$1);
var k_28229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28119_28228,(0),null);
var f_28230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28119_28228,(1),null);
try{(f_28230.cljs$core$IFn$_invoke$arity$1 ? f_28230.cljs$core$IFn$_invoke$arity$1(tx_response_28206) : f_28230.call(null,tx_response_28206));
}catch (e28122){var e_28231 = e28122;
var G__28123_28232 = e_28231;
var G__28124_28233 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__28123_28232,G__28124_28233) : fluree.db.util.log.error.call(null,G__28123_28232,G__28124_28233));
}

var G__28234 = cljs.core.next(seq__28097_28222__$1);
var G__28235 = null;
var G__28236 = (0);
var G__28237 = (0);
seq__28097_28207 = G__28234;
chunk__28098_28208 = G__28235;
count__28099_28209 = G__28236;
i__28100_28210 = G__28237;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28238 = cljs.core.next(seq__28009__$1);
var G__28239 = null;
var G__28240 = (0);
var G__28241 = (0);
seq__28009 = G__28238;
chunk__28010 = G__28239;
count__28011 = G__28240;
i__28012 = G__28241;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__28004_28161 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28004_28161.cljs$core$IFn$_invoke$arity$4 ? fexpr__28004_28161.cljs$core$IFn$_invoke$arity$4(G__28005_28157,G__28006_28158,G__28007_28159,G__28008_28160) : fexpr__28004_28161.call(null,G__28005_28157,G__28006_28158,G__28007_28159,G__28008_28160));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28242 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2706__auto___28243 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28141){
var state_val_28142 = (state_28141[(1)]);
if((state_val_28142 === (1))){
var state_28141__$1 = state_28141;
var statearr_28143_28244 = state_28141__$1;
(statearr_28143_28244[(2)] = null);

(statearr_28143_28244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28142 === (2))){
var inst_28126 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28141__$1 = state_28141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28141__$1,(4),inst_28126);
} else {
if((state_val_28142 === (3))){
var inst_28139 = (state_28141[(2)]);
var state_28141__$1 = state_28141;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28141__$1,inst_28139);
} else {
if((state_val_28142 === (4))){
var inst_28128 = (state_28141[(7)]);
var inst_28128__$1 = (state_28141[(2)]);
var inst_28129 = (inst_28128__$1 == null);
var state_28141__$1 = (function (){var statearr_28144 = state_28141;
(statearr_28144[(7)] = inst_28128__$1);

return statearr_28144;
})();
if(cljs.core.truth_(inst_28129)){
var statearr_28145_28245 = state_28141__$1;
(statearr_28145_28245[(1)] = (5));

} else {
var statearr_28146_28246 = state_28141__$1;
(statearr_28146_28246[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28142 === (5))){
var inst_28131 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28132 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Transactor session closing for db:",inst_28131) : fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_28131));
var state_28141__$1 = state_28141;
var statearr_28147_28247 = state_28141__$1;
(statearr_28147_28247[(2)] = inst_28132);

(statearr_28147_28247[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28142 === (6))){
var inst_28128 = (state_28141[(7)]);
var inst_28134 = (transact_handler_28242.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28242.cljs$core$IFn$_invoke$arity$2(conn,inst_28128) : transact_handler_28242.call(null,conn,inst_28128));
var state_28141__$1 = (function (){var statearr_28148 = state_28141;
(statearr_28148[(8)] = inst_28134);

return statearr_28148;
})();
var statearr_28149_28248 = state_28141__$1;
(statearr_28149_28248[(2)] = null);

(statearr_28149_28248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28142 === (7))){
var inst_28137 = (state_28141[(2)]);
var state_28141__$1 = state_28141;
var statearr_28150_28249 = state_28141__$1;
(statearr_28150_28249[(2)] = inst_28137);

(statearr_28150_28249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_28151 = [null,null,null,null,null,null,null,null,null];
(statearr_28151[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_28151[(1)] = (1));

return statearr_28151;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_28141){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28141);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28152){var ex__2687__auto__ = e28152;
var statearr_28153_28250 = state_28141;
(statearr_28153_28250[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28141[(4)]))){
var statearr_28154_28251 = state_28141;
(statearr_28154_28251[(1)] = cljs.core.first((state_28141[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28252 = state_28141;
state_28141 = G__28252;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_28141){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_28141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28155 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28155[(6)] = c__2706__auto___28243);

return statearr_28155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28255 = arguments.length;
switch (G__28255) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28256 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28253_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28253_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28256);
} else {
return G__28256;
}
})();
var seq__28257 = cljs.core.seq(sessions);
var chunk__28258 = null;
var count__28259 = (0);
var i__28260 = (0);
while(true){
if((i__28260 < count__28259)){
var session = chunk__28258.cljs$core$IIndexed$_nth$arity$2(null,i__28260);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28262 = seq__28257;
var G__28263 = chunk__28258;
var G__28264 = count__28259;
var G__28265 = (i__28260 + (1));
seq__28257 = G__28262;
chunk__28258 = G__28263;
count__28259 = G__28264;
i__28260 = G__28265;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__28257);
if(temp__5804__auto__){
var seq__28257__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28257__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__28257__$1);
var G__28266 = cljs.core.chunk_rest(seq__28257__$1);
var G__28267 = c__5568__auto__;
var G__28268 = cljs.core.count(c__5568__auto__);
var G__28269 = (0);
seq__28257 = G__28266;
chunk__28258 = G__28267;
count__28259 = G__28268;
i__28260 = G__28269;
continue;
} else {
var session = cljs.core.first(seq__28257__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28270 = cljs.core.next(seq__28257__$1);
var G__28271 = null;
var G__28272 = (0);
var G__28273 = (0);
seq__28257 = G__28270;
chunk__28258 = G__28271;
count__28259 = G__28272;
i__28260 = G__28273;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
