// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__21431){
var map__21432 = p__21431;
var map__21432__$1 = cljs.core.__destructure_map(map__21432);
var parsed_query = map__21432__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21432__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21432__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db(db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__21433){
var map__21434 = p__21433;
var map__21434__$1 = cljs.core.__destructure_map(map__21434);
var opts = map__21434__$1;
var rdf_type_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21434__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21434__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21478){
var state_val_21479 = (state_21478[(1)]);
if((state_val_21479 === (7))){
var inst_21457 = (state_21478[(7)]);
var inst_21459 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(inst_21457);
var state_21478__$1 = state_21478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21478__$1,(10),inst_21459);
} else {
if((state_val_21479 === (1))){
var inst_21442 = vars;
var inst_21443 = cljs.core.seq(inst_21442);
var inst_21444 = cljs.core.first(inst_21443);
var inst_21445 = cljs.core.next(inst_21443);
var inst_21446 = cljs.core.PersistentVector.EMPTY;
var inst_21447 = inst_21442;
var inst_21448 = inst_21446;
var state_21478__$1 = (function (){var statearr_21480 = state_21478;
(statearr_21480[(8)] = inst_21445);

(statearr_21480[(9)] = inst_21447);

(statearr_21480[(10)] = inst_21448);

(statearr_21480[(11)] = inst_21444);

return statearr_21480;
})();
var statearr_21481_21499 = state_21478__$1;
(statearr_21481_21499[(2)] = null);

(statearr_21481_21499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (4))){
var inst_21454 = (state_21478[(12)]);
var inst_21457 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_21454);
var state_21478__$1 = (function (){var statearr_21482 = state_21478;
(statearr_21482[(7)] = inst_21457);

return statearr_21482;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_21483_21500 = state_21478__$1;
(statearr_21483_21500[(1)] = (7));

} else {
var statearr_21484_21501 = state_21478__$1;
(statearr_21484_21501[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (6))){
var inst_21474 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
var statearr_21485_21502 = state_21478__$1;
(statearr_21485_21502[(2)] = inst_21474);

(statearr_21485_21502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (3))){
var inst_21476 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21478__$1,inst_21476);
} else {
if((state_val_21479 === (2))){
var inst_21454 = (state_21478[(12)]);
var inst_21447 = (state_21478[(9)]);
var inst_21453 = cljs.core.seq(inst_21447);
var inst_21454__$1 = cljs.core.first(inst_21453);
var inst_21455 = cljs.core.next(inst_21453);
var state_21478__$1 = (function (){var statearr_21486 = state_21478;
(statearr_21486[(12)] = inst_21454__$1);

(statearr_21486[(13)] = inst_21455);

return statearr_21486;
})();
if(cljs.core.truth_(inst_21454__$1)){
var statearr_21487_21503 = state_21478__$1;
(statearr_21487_21503[(1)] = (4));

} else {
var statearr_21488_21504 = state_21478__$1;
(statearr_21488_21504[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (11))){
var inst_21466 = (state_21478[(2)]);
var inst_21467 = fluree.db.util.async.throw_err(inst_21466);
var state_21478__$1 = state_21478;
var statearr_21489_21505 = state_21478__$1;
(statearr_21489_21505[(2)] = inst_21467);

(statearr_21489_21505[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (9))){
var inst_21448 = (state_21478[(10)]);
var inst_21455 = (state_21478[(13)]);
var inst_21469 = (state_21478[(2)]);
var inst_21470 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21448,inst_21469);
var inst_21447 = inst_21455;
var inst_21448__$1 = inst_21470;
var state_21478__$1 = (function (){var statearr_21490 = state_21478;
(statearr_21490[(9)] = inst_21447);

(statearr_21490[(10)] = inst_21448__$1);

return statearr_21490;
})();
var statearr_21491_21506 = state_21478__$1;
(statearr_21491_21506[(2)] = null);

(statearr_21491_21506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (5))){
var inst_21448 = (state_21478[(10)]);
var state_21478__$1 = state_21478;
var statearr_21492_21507 = state_21478__$1;
(statearr_21492_21507[(2)] = inst_21448);

(statearr_21492_21507[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (10))){
var inst_21461 = (state_21478[(2)]);
var inst_21462 = fluree.db.util.async.throw_err(inst_21461);
var state_21478__$1 = state_21478;
var statearr_21493_21508 = state_21478__$1;
(statearr_21493_21508[(2)] = inst_21462);

(statearr_21493_21508[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (8))){
var inst_21457 = (state_21478[(7)]);
var inst_21464 = fluree.db.query.subject_crawl.subject.subj_crawl(inst_21457);
var state_21478__$1 = state_21478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21478__$1,(11),inst_21464);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0 = (function (){
var statearr_21494 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21494[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__);

(statearr_21494[(1)] = (1));

return statearr_21494;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1 = (function (state_21478){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21478);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21495){var ex__2687__auto__ = e21495;
var statearr_21496_21509 = state_21478;
(statearr_21496_21509[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21478[(4)]))){
var statearr_21497_21510 = state_21478;
(statearr_21497_21510[(1)] = cljs.core.first((state_21478[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21511 = state_21478;
state_21478 = G__21511;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__ = function(state_21478){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1.call(this,state_21478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21498 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21498[(6)] = c__2706__auto__);

return statearr_21498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__21513){
var map__21514 = p__21513;
var map__21514__$1 = cljs.core.__destructure_map(map__21514);
var parsed_query = map__21514__$1;
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21514__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21514__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21514__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21514__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var fns = (function (){var G__21515 = cljs.core.PersistentVector.EMPTY;
var G__21515__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__21515,(function (result){
return cljs.core.first(result);
})):G__21515);
var G__21515__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__21515__$1,(function (){var select_var = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__21512_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__21512_SHARP_]);
}),result);
});
})()):G__21515__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__21515__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results(result,order_by,limit);
}));
} else {
return G__21515__$2;
}
})();
if(cljs.core.empty_QMARK_(fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__21516){
var map__21517 = p__21516;
var map__21517__$1 = cljs.core.__destructure_map(map__21517);
var parsed_query = map__21517__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var ident_vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21517__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("Running simple subject crawl query:",parsed_query) : fluree.db.util.log.debug.call(null,"Running simple subject crawl query:",parsed_query));

var error_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var f_where = cljs.core.first(where);
var rdf_type_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second(where));
var cache = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_((0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec(db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn(parsed_query);
var opts__$1 = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,(cljs.core.truth_(order_by)?(9007199254740991):limit),ident_vars,offset,db,error_ch,cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877).cljs$core$IFn$_invoke$arity$1(opts),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("simple-subject-crawl opts:",opts__$1) : fluree.db.util.log.debug.call(null,"simple-subject-crawl opts:",opts__$1));

if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding(opts__$1);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(opts__$1);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl(opts__$1);
}
}
});
