// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__20244){
var map__20245 = p__20244;
var map__20245__$1 = cljs.core.__destructure_map(map__20245);
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20245__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20245__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20245__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20245__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20245__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,(function (){var G__20246 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__20246,xf);
} else {
return G__20246;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__20247){
var map__20248 = p__20247;
var map__20248__$1 = cljs.core.__destructure_map(map__20248);
var _opts = map__20248__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20248__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20248__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20248__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20248__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20248__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20248__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var parse_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20248__$1,new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877));
return (function (flakes,port){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20293){
var state_val_20294 = (state_20293[(1)]);
if((state_val_20294 === (7))){
var inst_20258 = (state_20293[(7)]);
var inst_20262 = [new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877)];
var inst_20263 = [parse_json_QMARK_];
var inst_20264 = cljs.core.PersistentHashMap.fromArrays(inst_20262,inst_20263);
var inst_20265 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel_vol,max_fuel,select_spec,inst_20264,inst_20258);
var state_20293__$1 = state_20293;
var statearr_20295_20331 = state_20293__$1;
(statearr_20295_20331[(2)] = inst_20265);

(statearr_20295_20331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (1))){
var state_20293__$1 = state_20293;
var statearr_20296_20332 = state_20293__$1;
(statearr_20296_20332[(2)] = null);

(statearr_20296_20332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (4))){
var inst_20249 = (state_20293[(2)]);
var inst_20250 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_20249);
var inst_20251 = cljs.core.async.close_BANG_(port);
var state_20293__$1 = (function (){var statearr_20297 = state_20293;
(statearr_20297[(8)] = inst_20250);

(statearr_20297[(9)] = inst_20251);

return statearr_20297;
})();
var statearr_20298_20333 = state_20293__$1;
(statearr_20298_20333[(2)] = null);

(statearr_20298_20333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (15))){
var inst_20281 = (state_20293[(10)]);
var inst_20281__$1 = (state_20293[(2)]);
var inst_20282 = (inst_20281__$1 == null);
var state_20293__$1 = (function (){var statearr_20299 = state_20293;
(statearr_20299[(10)] = inst_20281__$1);

return statearr_20299;
})();
if(cljs.core.truth_(inst_20282)){
var statearr_20300_20334 = state_20293__$1;
(statearr_20300_20334[(1)] = (16));

} else {
var statearr_20301_20335 = state_20293__$1;
(statearr_20301_20335[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (13))){
var state_20293__$1 = state_20293;
var statearr_20302_20336 = state_20293__$1;
(statearr_20302_20336[(2)] = null);

(statearr_20302_20336[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (6))){
var state_20293__$1 = state_20293;
var statearr_20303_20337 = state_20293__$1;
(statearr_20303_20337[(2)] = null);

(statearr_20303_20337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (17))){
var inst_20281 = (state_20293[(10)]);
var inst_20285 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_20281);
var state_20293__$1 = state_20293;
var statearr_20304_20338 = state_20293__$1;
(statearr_20304_20338[(2)] = inst_20285);

(statearr_20304_20338[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (3))){
var inst_20291 = (state_20293[(2)]);
var state_20293__$1 = state_20293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20293__$1,inst_20291);
} else {
if((state_val_20294 === (12))){
var inst_20272 = (state_20293[(2)]);
var inst_20273 = fluree.db.util.async.throw_err(inst_20272);
var state_20293__$1 = state_20293;
var statearr_20305_20339 = state_20293__$1;
(statearr_20305_20339[(2)] = inst_20273);

(statearr_20305_20339[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (2))){
var inst_20258 = (state_20293[(7)]);
var _ = (function (){var statearr_20306 = state_20293;
(statearr_20306[(4)] = cljs.core.cons((5),(state_20293[(4)])));

return statearr_20306;
})();
var inst_20258__$1 = flakes;
var inst_20259 = (inst_20258__$1 == null);
var state_20293__$1 = (function (){var statearr_20307 = state_20293;
(statearr_20307[(7)] = inst_20258__$1);

return statearr_20307;
})();
if(cljs.core.truth_(inst_20259)){
var statearr_20308_20340 = state_20293__$1;
(statearr_20308_20340[(1)] = (6));

} else {
var statearr_20309_20341 = state_20293__$1;
(statearr_20309_20341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (11))){
var inst_20275 = (state_20293[(11)]);
var inst_20275__$1 = (state_20293[(2)]);
var inst_20276 = (inst_20275__$1 == null);
var state_20293__$1 = (function (){var statearr_20311 = state_20293;
(statearr_20311[(11)] = inst_20275__$1);

return statearr_20311;
})();
if(cljs.core.truth_(inst_20276)){
var statearr_20312_20342 = state_20293__$1;
(statearr_20312_20342[(1)] = (13));

} else {
var statearr_20313_20343 = state_20293__$1;
(statearr_20313_20343[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (9))){
var state_20293__$1 = state_20293;
var statearr_20314_20344 = state_20293__$1;
(statearr_20314_20344[(2)] = null);

(statearr_20314_20344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (5))){
var _ = (function (){var statearr_20315 = state_20293;
(statearr_20315[(4)] = cljs.core.rest((state_20293[(4)])));

return statearr_20315;
})();
var state_20293__$1 = state_20293;
var ex20310 = (state_20293__$1[(2)]);
var statearr_20316_20345 = state_20293__$1;
(statearr_20316_20345[(5)] = ex20310);


var statearr_20317_20346 = state_20293__$1;
(statearr_20317_20346[(1)] = (4));

(statearr_20317_20346[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (14))){
var inst_20275 = (state_20293[(11)]);
var inst_20279 = cljs.core.not_empty(inst_20275);
var state_20293__$1 = state_20293;
var statearr_20318_20347 = state_20293__$1;
(statearr_20318_20347[(2)] = inst_20279);

(statearr_20318_20347[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (16))){
var state_20293__$1 = state_20293;
var statearr_20319_20348 = state_20293__$1;
(statearr_20319_20348[(2)] = null);

(statearr_20319_20348[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (10))){
var inst_20267 = (state_20293[(12)]);
var state_20293__$1 = state_20293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20293__$1,(12),inst_20267);
} else {
if((state_val_20294 === (18))){
var inst_20287 = (state_20293[(2)]);
var inst_20288 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_20320 = state_20293;
(statearr_20320[(4)] = cljs.core.rest((state_20293[(4)])));

return statearr_20320;
})();
var state_20293__$1 = (function (){var statearr_20321 = state_20293;
(statearr_20321[(13)] = inst_20287);

return statearr_20321;
})();
var statearr_20322_20349 = state_20293__$1;
(statearr_20322_20349[(2)] = inst_20288);

(statearr_20322_20349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20294 === (8))){
var inst_20267 = (state_20293[(12)]);
var inst_20267__$1 = (state_20293[(2)]);
var inst_20268 = (inst_20267__$1 == null);
var state_20293__$1 = (function (){var statearr_20323 = state_20293;
(statearr_20323[(12)] = inst_20267__$1);

return statearr_20323;
})();
if(cljs.core.truth_(inst_20268)){
var statearr_20324_20350 = state_20293__$1;
(statearr_20324_20350[(1)] = (9));

} else {
var statearr_20325_20351 = state_20293__$1;
(statearr_20325_20351[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0 = (function (){
var statearr_20326 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20326[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__);

(statearr_20326[(1)] = (1));

return statearr_20326;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1 = (function (state_20293){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20293);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20327){var ex__2687__auto__ = e20327;
var statearr_20328_20352 = state_20293;
(statearr_20328_20352[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20293[(4)]))){
var statearr_20329_20353 = state_20293;
(statearr_20329_20353[(1)] = cljs.core.first((state_20293[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20354 = state_20293;
state_20293 = G__20354;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__ = function(state_20293){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1.call(this,state_20293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20330 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20330[(6)] = c__2706__auto__);

return statearr_20330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__20355){
var map__20356 = p__20355;
var map__20356__$1 = cljs.core.__destructure_map(map__20356);
var db = map__20356__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20356__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_(permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_(cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_(coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20387){
var state_val_20388 = (state_20387[(1)]);
if((state_val_20388 === (7))){
var inst_20363 = (state_20387[(7)]);
var inst_20373 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_20363);
var state_20387__$1 = state_20387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20387__$1,(10),inst_20373);
} else {
if((state_val_20388 === (1))){
var state_20387__$1 = state_20387;
var statearr_20389_20412 = state_20387__$1;
(statearr_20389_20412[(2)] = null);

(statearr_20389_20412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (4))){
var inst_20357 = (state_20387[(2)]);
var state_20387__$1 = state_20387;
var statearr_20390_20413 = state_20387__$1;
(statearr_20390_20413[(2)] = inst_20357);

(statearr_20390_20413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (13))){
var inst_20380 = (state_20387[(2)]);
var state_20387__$1 = state_20387;
var statearr_20391_20414 = state_20387__$1;
(statearr_20391_20414[(2)] = inst_20380);

(statearr_20391_20414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (6))){
var inst_20368 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,flakes);
var state_20387__$1 = state_20387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20387__$1,(9),inst_20368);
} else {
if((state_val_20388 === (3))){
var inst_20385 = (state_20387[(2)]);
var state_20387__$1 = state_20387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20387__$1,inst_20385);
} else {
if((state_val_20388 === (12))){
var state_20387__$1 = state_20387;
var statearr_20392_20415 = state_20387__$1;
(statearr_20392_20415[(2)] = null);

(statearr_20392_20415[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (2))){
var inst_20363 = (state_20387[(7)]);
var _ = (function (){var statearr_20393 = state_20387;
(statearr_20393[(4)] = cljs.core.cons((5),(state_20387[(4)])));

return statearr_20393;
})();
var inst_20363__$1 = cljs.core.first(flakes);
var inst_20364 = fluree.db.flake.s(inst_20363__$1);
var inst_20365 = fluree.db.flake.sid__GT_cid(inst_20364);
var inst_20366 = filter_predicates_QMARK_(inst_20365);
var state_20387__$1 = (function (){var statearr_20394 = state_20387;
(statearr_20394[(7)] = inst_20363__$1);

return statearr_20394;
})();
if(cljs.core.truth_(inst_20366)){
var statearr_20395_20416 = state_20387__$1;
(statearr_20395_20416[(1)] = (6));

} else {
var statearr_20396_20417 = state_20387__$1;
(statearr_20396_20417[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (11))){
var state_20387__$1 = state_20387;
var statearr_20398_20418 = state_20387__$1;
(statearr_20398_20418[(2)] = flakes);

(statearr_20398_20418[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (9))){
var inst_20370 = (state_20387[(2)]);
var inst_20371 = fluree.db.util.async.throw_err(inst_20370);
var state_20387__$1 = state_20387;
var statearr_20399_20419 = state_20387__$1;
(statearr_20399_20419[(2)] = inst_20371);

(statearr_20399_20419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (5))){
var _ = (function (){var statearr_20400 = state_20387;
(statearr_20400[(4)] = cljs.core.rest((state_20387[(4)])));

return statearr_20400;
})();
var state_20387__$1 = state_20387;
var ex20397 = (state_20387__$1[(2)]);
var statearr_20401_20420 = state_20387__$1;
(statearr_20401_20420[(5)] = ex20397);


if((ex20397 instanceof Error)){
var statearr_20402_20421 = state_20387__$1;
(statearr_20402_20421[(1)] = (4));

(statearr_20402_20421[(5)] = null);

} else {
throw ex20397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (10))){
var inst_20375 = (state_20387[(2)]);
var inst_20376 = fluree.db.util.async.throw_err(inst_20375);
var state_20387__$1 = state_20387;
if(cljs.core.truth_(inst_20376)){
var statearr_20403_20422 = state_20387__$1;
(statearr_20403_20422[(1)] = (11));

} else {
var statearr_20404_20423 = state_20387__$1;
(statearr_20404_20423[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20388 === (8))){
var inst_20382 = (state_20387[(2)]);
var _ = (function (){var statearr_20405 = state_20387;
(statearr_20405[(4)] = cljs.core.rest((state_20387[(4)])));

return statearr_20405;
})();
var state_20387__$1 = state_20387;
var statearr_20406_20424 = state_20387__$1;
(statearr_20406_20424[(2)] = inst_20382);

(statearr_20406_20424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_20407 = [null,null,null,null,null,null,null,null];
(statearr_20407[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__);

(statearr_20407[(1)] = (1));

return statearr_20407;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1 = (function (state_20387){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20387);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20408){var ex__2687__auto__ = e20408;
var statearr_20409_20425 = state_20387;
(statearr_20409_20425[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20387[(4)]))){
var statearr_20410_20426 = state_20387;
(statearr_20410_20426[(1)] = cljs.core.first((state_20387[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20427 = state_20387;
state_20387 = G__20427;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__ = function(state_20387){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1.call(this,state_20387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20411 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20411[(6)] = c__2706__auto__);

return statearr_20411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some((function (p1__20428_SHARP_){
return (filter_fn.cljs$core$IFn$_invoke$arity$2 ? filter_fn.cljs$core$IFn$_invoke$arity$2(p1__20428_SHARP_,vars) : filter_fn.call(null,p1__20428_SHARP_,vars));
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__20432 = filter_fns;
var vec__20433 = G__20432;
var seq__20434 = cljs.core.seq(vec__20433);
var first__20435 = cljs.core.first(seq__20434);
var seq__20434__$1 = cljs.core.next(seq__20434);
var filter_fn = first__20435;
var r_fns = seq__20434__$1;
var G__20432__$1 = G__20432;
while(true){
var vec__20436 = G__20432__$1;
var seq__20437 = cljs.core.seq(vec__20436);
var first__20438 = cljs.core.first(seq__20437);
var seq__20437__$1 = cljs.core.next(seq__20437);
var filter_fn__$1 = first__20438;
var r_fns__$1 = seq__20437__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_(filter_fn__$1,vars,pred_flakes))){
var G__20439 = r_fns__$1;
G__20432__$1 = G__20439;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__20443 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,flakes);
var vec__20444 = G__20443;
var seq__20445 = cljs.core.seq(vec__20444);
var first__20446 = cljs.core.first(seq__20445);
var seq__20445__$1 = cljs.core.next(seq__20445);
var p_flakes = first__20446;
var r = seq__20445__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__20443__$1 = G__20443;
var required_p__$1 = required_p;
while(true){
var vec__20450 = G__20443__$1;
var seq__20451 = cljs.core.seq(vec__20450);
var first__20452 = cljs.core.first(seq__20451);
var seq__20451__$1 = cljs.core.next(seq__20451);
var p_flakes__$1 = first__20452;
var r__$1 = seq__20451__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p(cljs.core.first(p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_(filter_fns,vars,p_flakes__$1)){
var G__20453 = r__$1;
var G__20454 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__20443__$1 = G__20453;
required_p__$1 = G__20454;
continue;
} else {
return null;
}
} else {
var G__20455 = r__$1;
var G__20456 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__20443__$1 = G__20455;
required_p__$1 = G__20456;
continue;
}
} else {
if(cljs.core.empty_QMARK_(required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__20457,limit){
var map__20458 = p__20457;
var map__20458__$1 = cljs.core.__destructure_map(map__20458);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20458__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20458__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20458__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var sorted = (function (){var G__20459 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (result){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(result,predicate);
}),results);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"desc","desc",2093485764),order)){
return cljs.core.reverse(G__20459);
} else {
return G__20459;
}
})();
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,sorted));
}
});
/**
 * When some variables may be idents (two-tuples) they need to get resolved into
 *   subject _id values before executing query.
 */
fluree.db.query.subject_crawl.common.resolve_ident_vars = (function fluree$db$query$subject_crawl$common$resolve_ident_vars(db,vars,ident_vars){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20529){
var state_val_20530 = (state_20529[(1)]);
if((state_val_20530 === (7))){
var inst_20524 = (state_20529[(2)]);
var _ = (function (){var statearr_20531 = state_20529;
(statearr_20531[(4)] = cljs.core.rest((state_20529[(4)])));

return statearr_20531;
})();
var state_20529__$1 = state_20529;
var statearr_20532_20574 = state_20529__$1;
(statearr_20532_20574[(2)] = inst_20524);

(statearr_20532_20574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (20))){
var inst_20485 = (state_20529[(7)]);
var inst_20479 = (state_20529[(8)]);
var inst_20486 = (state_20529[(9)]);
var inst_20502 = (state_20529[(2)]);
var inst_20503 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20479,inst_20485,inst_20502);
var inst_20478 = inst_20486;
var inst_20479__$1 = inst_20503;
var state_20529__$1 = (function (){var statearr_20533 = state_20529;
(statearr_20533[(8)] = inst_20479__$1);

(statearr_20533[(10)] = inst_20478);

return statearr_20533;
})();
var statearr_20534_20575 = state_20529__$1;
(statearr_20534_20575[(2)] = null);

(statearr_20534_20575[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (1))){
var state_20529__$1 = state_20529;
var statearr_20535_20576 = state_20529__$1;
(statearr_20535_20576[(2)] = null);

(statearr_20535_20576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (4))){
var inst_20460 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20536_20577 = state_20529__$1;
(statearr_20536_20577[(2)] = inst_20460);

(statearr_20536_20577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (15))){
var state_20529__$1 = state_20529;
var statearr_20537_20578 = state_20529__$1;
(statearr_20537_20578[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (21))){
var inst_20485 = (state_20529[(7)]);
var inst_20488 = (state_20529[(11)]);
var inst_20507 = ["Invalid identity provided in variable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20485),". Must be a two-tuple identity, IRI, or integer id. ","Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20488)].join('');
var inst_20508 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20509 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20510 = cljs.core.PersistentHashMap.fromArrays(inst_20508,inst_20509);
var inst_20511 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20507,inst_20510);
var inst_20512 = (function(){throw inst_20511})();
var state_20529__$1 = state_20529;
var statearr_20539_20579 = state_20529__$1;
(statearr_20539_20579[(2)] = inst_20512);

(statearr_20539_20579[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (13))){
var inst_20519 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20540_20580 = state_20529__$1;
(statearr_20540_20580[(2)] = inst_20519);

(statearr_20540_20580[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (22))){
var state_20529__$1 = state_20529;
var statearr_20541_20581 = state_20529__$1;
(statearr_20541_20581[(2)] = null);

(statearr_20541_20581[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (6))){
var inst_20485 = (state_20529[(7)]);
var inst_20478 = (state_20529[(10)]);
var inst_20484 = cljs.core.seq(inst_20478);
var inst_20485__$1 = cljs.core.first(inst_20484);
var inst_20486 = cljs.core.next(inst_20484);
var state_20529__$1 = (function (){var statearr_20542 = state_20529;
(statearr_20542[(7)] = inst_20485__$1);

(statearr_20542[(9)] = inst_20486);

return statearr_20542;
})();
if(cljs.core.truth_(inst_20485__$1)){
var statearr_20543_20582 = state_20529__$1;
(statearr_20543_20582[(1)] = (8));

} else {
var statearr_20544_20583 = state_20529__$1;
(statearr_20544_20583[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (17))){
var inst_20498 = (state_20529[(12)]);
var inst_20497 = (state_20529[(2)]);
var inst_20498__$1 = fluree.db.util.async.throw_err(inst_20497);
var state_20529__$1 = (function (){var statearr_20545 = state_20529;
(statearr_20545[(12)] = inst_20498__$1);

return statearr_20545;
})();
if(cljs.core.truth_(inst_20498__$1)){
var statearr_20546_20584 = state_20529__$1;
(statearr_20546_20584[(1)] = (18));

} else {
var statearr_20547_20585 = state_20529__$1;
(statearr_20547_20585[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (3))){
var inst_20527 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20529__$1,inst_20527);
} else {
if((state_val_20530 === (12))){
var inst_20488 = (state_20529[(11)]);
var inst_20493 = fluree.db.util.core.pred_ident_QMARK_(inst_20488);
var state_20529__$1 = state_20529;
if(inst_20493){
var statearr_20548_20586 = state_20529__$1;
(statearr_20548_20586[(1)] = (14));

} else {
var statearr_20549_20587 = state_20529__$1;
(statearr_20549_20587[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (2))){
var _ = (function (){var statearr_20550 = state_20529;
(statearr_20550[(4)] = cljs.core.cons((5),(state_20529[(4)])));

return statearr_20550;
})();
var inst_20473 = ident_vars;
var inst_20474 = cljs.core.seq(inst_20473);
var inst_20475 = cljs.core.first(inst_20474);
var inst_20476 = cljs.core.next(inst_20474);
var inst_20477 = vars;
var inst_20478 = inst_20473;
var inst_20479 = inst_20477;
var state_20529__$1 = (function (){var statearr_20551 = state_20529;
(statearr_20551[(8)] = inst_20479);

(statearr_20551[(10)] = inst_20478);

(statearr_20551[(13)] = inst_20476);

(statearr_20551[(14)] = inst_20475);

return statearr_20551;
})();
var statearr_20552_20588 = state_20529__$1;
(statearr_20552_20588[(2)] = null);

(statearr_20552_20588[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (23))){
var inst_20515 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20554_20589 = state_20529__$1;
(statearr_20554_20589[(2)] = inst_20515);

(statearr_20554_20589[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (19))){
var state_20529__$1 = state_20529;
var statearr_20555_20590 = state_20529__$1;
(statearr_20555_20590[(2)] = (0));

(statearr_20555_20590[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (11))){
var inst_20479 = (state_20529[(8)]);
var inst_20486 = (state_20529[(9)]);
var tmp20553 = inst_20479;
var inst_20478 = inst_20486;
var inst_20479__$1 = tmp20553;
var state_20529__$1 = (function (){var statearr_20557 = state_20529;
(statearr_20557[(8)] = inst_20479__$1);

(statearr_20557[(10)] = inst_20478);

return statearr_20557;
})();
var statearr_20558_20591 = state_20529__$1;
(statearr_20558_20591[(2)] = null);

(statearr_20558_20591[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (9))){
var inst_20479 = (state_20529[(8)]);
var state_20529__$1 = state_20529;
var statearr_20559_20592 = state_20529__$1;
(statearr_20559_20592[(2)] = inst_20479);

(statearr_20559_20592[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (5))){
var _ = (function (){var statearr_20560 = state_20529;
(statearr_20560[(4)] = cljs.core.rest((state_20529[(4)])));

return statearr_20560;
})();
var state_20529__$1 = state_20529;
var ex20556 = (state_20529__$1[(2)]);
var statearr_20561_20593 = state_20529__$1;
(statearr_20561_20593[(5)] = ex20556);


if((ex20556 instanceof Error)){
var statearr_20562_20594 = state_20529__$1;
(statearr_20562_20594[(1)] = (4));

(statearr_20562_20594[(5)] = null);

} else {
throw ex20556;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (14))){
var inst_20488 = (state_20529[(11)]);
var inst_20495 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20488);
var state_20529__$1 = state_20529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20529__$1,(17),inst_20495);
} else {
if((state_val_20530 === (16))){
var inst_20517 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20563_20595 = state_20529__$1;
(statearr_20563_20595[(2)] = inst_20517);

(statearr_20563_20595[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (10))){
var inst_20522 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20564_20596 = state_20529__$1;
(statearr_20564_20596[(2)] = inst_20522);

(statearr_20564_20596[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (18))){
var inst_20498 = (state_20529[(12)]);
var state_20529__$1 = state_20529;
var statearr_20565_20597 = state_20529__$1;
(statearr_20565_20597[(2)] = inst_20498);

(statearr_20565_20597[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20530 === (8))){
var inst_20485 = (state_20529[(7)]);
var inst_20488 = (state_20529[(11)]);
var inst_20488__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,inst_20485);
var inst_20489 = cljs.core.int_QMARK_(inst_20488__$1);
var state_20529__$1 = (function (){var statearr_20566 = state_20529;
(statearr_20566[(11)] = inst_20488__$1);

return statearr_20566;
})();
if(inst_20489){
var statearr_20567_20598 = state_20529__$1;
(statearr_20567_20598[(1)] = (11));

} else {
var statearr_20568_20599 = state_20529__$1;
(statearr_20568_20599[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0 = (function (){
var statearr_20569 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20569[(0)] = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__);

(statearr_20569[(1)] = (1));

return statearr_20569;
});
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1 = (function (state_20529){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20529);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20570){var ex__2687__auto__ = e20570;
var statearr_20571_20600 = state_20529;
(statearr_20571_20600[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20529[(4)]))){
var statearr_20572_20601 = state_20529;
(statearr_20572_20601[(1)] = cljs.core.first((state_20529[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20602 = state_20529;
state_20529 = G__20602;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__ = function(state_20529){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1.call(this,state_20529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20573 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20573[(6)] = c__2706__auto__);

return statearr_20573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
