// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14910 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14910,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14910,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14910,(2),null);
var p4 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14910,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14910,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14910,(5),null);
var G__14913 = idx;
var G__14913__$1 = (((G__14913 instanceof cljs.core.Keyword))?G__14913.fqn:null);
switch (G__14913__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate(db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14913__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14915 = idx;
var G__14915__$1 = (((G__14915 instanceof cljs.core.Keyword))?G__14915.fqn:null);
switch (G__14915__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14915__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14917 = idx;
var G__14917__$1 = (((G__14917 instanceof cljs.core.Keyword))?G__14917.fqn:null);
switch (G__14917__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14917__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if(cljs.core.not(id)){
cljs.core.async.close_BANG_(out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_(id)){
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,id),out);
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14957){
var state_val_14958 = (state_14957[(1)]);
if((state_val_14958 === (7))){
var inst_14934 = (state_14957[(7)]);
var inst_14941 = (state_14957[(2)]);
var inst_14942 = fluree.db.util.async.throw_err(inst_14941);
var state_14957__$1 = (function (){var statearr_14959 = state_14957;
(statearr_14959[(8)] = inst_14942);

return statearr_14959;
})();
if(cljs.core.truth_(inst_14934)){
var statearr_14960_14984 = state_14957__$1;
(statearr_14960_14984[(1)] = (8));

} else {
var statearr_14961_14985 = state_14957__$1;
(statearr_14961_14985[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (1))){
var state_14957__$1 = state_14957;
var statearr_14962_14986 = state_14957__$1;
(statearr_14962_14986[(2)] = null);

(statearr_14962_14986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (4))){
var inst_14919 = (state_14957[(2)]);
var state_14957__$1 = state_14957;
var statearr_14963_14987 = state_14957__$1;
(statearr_14963_14987[(2)] = inst_14919);

(statearr_14963_14987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (13))){
var inst_14949 = (state_14957[(2)]);
var state_14957__$1 = state_14957;
var statearr_14964_14988 = state_14957__$1;
(statearr_14964_14988[(2)] = inst_14949);

(statearr_14964_14988[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (6))){
var inst_14931 = (state_14957[(9)]);
var inst_14937 = (state_14957[(2)]);
var inst_14938 = fluree.db.util.async.throw_err(inst_14937);
var inst_14939 = fluree.db.query.range.resolve_subid(db,inst_14931);
var state_14957__$1 = (function (){var statearr_14965 = state_14957;
(statearr_14965[(10)] = inst_14938);

return statearr_14965;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14957__$1,(7),inst_14939);
} else {
if((state_val_14958 === (3))){
var inst_14955 = (state_14957[(2)]);
var state_14957__$1 = state_14957;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14957__$1,inst_14955);
} else {
if((state_val_14958 === (12))){
var state_14957__$1 = state_14957;
var statearr_14966_14989 = state_14957__$1;
(statearr_14966_14989[(2)] = (2147483647));

(statearr_14966_14989[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (2))){
var _ = (function (){var statearr_14967 = state_14957;
(statearr_14967[(4)] = cljs.core.cons((5),(state_14957[(4)])));

return statearr_14967;
})();
var inst_14928 = parts;
var inst_14929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14928,(0),null);
var inst_14930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14928,(1),null);
var inst_14931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14928,(2),null);
var inst_14932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14928,(3),null);
var inst_14933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14928,(4),null);
var inst_14934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14928,(5),null);
var inst_14935 = fluree.db.query.range.resolve_subid(db,inst_14929);
var state_14957__$1 = (function (){var statearr_14968 = state_14957;
(statearr_14968[(11)] = inst_14932);

(statearr_14968[(9)] = inst_14931);

(statearr_14968[(12)] = inst_14933);

(statearr_14968[(7)] = inst_14934);

(statearr_14968[(13)] = inst_14930);

return statearr_14968;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14957__$1,(6),inst_14935);
} else {
if((state_val_14958 === (11))){
var state_14957__$1 = state_14957;
var statearr_14970_14990 = state_14957__$1;
(statearr_14970_14990[(2)] = (-2147483647));

(statearr_14970_14990[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (9))){
var inst_14945 = (cljs.core._GT__EQ_ === test);
var state_14957__$1 = state_14957;
if(cljs.core.truth_(inst_14945)){
var statearr_14971_14991 = state_14957__$1;
(statearr_14971_14991[(1)] = (11));

} else {
var statearr_14972_14992 = state_14957__$1;
(statearr_14972_14992[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (5))){
var _ = (function (){var statearr_14973 = state_14957;
(statearr_14973[(4)] = cljs.core.rest((state_14957[(4)])));

return statearr_14973;
})();
var state_14957__$1 = state_14957;
var ex14969 = (state_14957__$1[(2)]);
var statearr_14974_14993 = state_14957__$1;
(statearr_14974_14993[(5)] = ex14969);


if((ex14969 instanceof Error)){
var statearr_14975_14994 = state_14957__$1;
(statearr_14975_14994[(1)] = (4));

(statearr_14975_14994[(5)] = null);

} else {
throw ex14969;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (10))){
var inst_14932 = (state_14957[(11)]);
var inst_14938 = (state_14957[(10)]);
var inst_14942 = (state_14957[(8)]);
var inst_14933 = (state_14957[(12)]);
var inst_14930 = (state_14957[(13)]);
var inst_14951 = (state_14957[(2)]);
var inst_14952 = fluree.db.flake.__GT_Flake(inst_14938,inst_14930,inst_14942,inst_14932,inst_14933,inst_14951);
var _ = (function (){var statearr_14976 = state_14957;
(statearr_14976[(4)] = cljs.core.rest((state_14957[(4)])));

return statearr_14976;
})();
var state_14957__$1 = state_14957;
var statearr_14977_14995 = state_14957__$1;
(statearr_14977_14995[(2)] = inst_14952);

(statearr_14977_14995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14958 === (8))){
var inst_14934 = (state_14957[(7)]);
var state_14957__$1 = state_14957;
var statearr_14978_14996 = state_14957__$1;
(statearr_14978_14996[(2)] = inst_14934);

(statearr_14978_14996[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0 = (function (){
var statearr_14979 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14979[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__);

(statearr_14979[(1)] = (1));

return statearr_14979;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1 = (function (state_14957){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14957);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14980){var ex__2687__auto__ = e14980;
var statearr_14981_14997 = state_14957;
(statearr_14981_14997[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14957[(4)]))){
var statearr_14982_14998 = state_14957;
(statearr_14982_14998[(1)] = cljs.core.first((state_14957[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14999 = state_14957;
state_14957 = G__14999;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__ = function(state_14957){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1.call(this,state_14957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14983 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14983[(6)] = c__2706__auto__);

return statearr_14983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__5043__auto__ = fluree.db.index.leaf_QMARK_(node);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_(node);
} else {
return and__5043__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__5043__auto__)){
return fluree.db.flake.lower_than_all_QMARK_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core.not(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__15000){
var map__15001 = p__15000;
var map__15001__$1 = cljs.core.__destructure_map(map__15001);
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15001__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15001__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15001__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__15002 = cljs.core.PersistentVector.EMPTY;
var G__15002__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15002,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15003 = fluree.db.flake.s(f);
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__15003) : subject_fn.call(null,G__15003));
}))):G__15002);
var G__15002__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15002__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15004 = fluree.db.flake.p(f);
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__15004) : predicate_fn.call(null,G__15004));
}))):G__15002__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15002__$2,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15005 = fluree.db.flake.o(f);
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15005) : object_fn.call(null,G__15005));
})));
} else {
return G__15002__$2;
}
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__15006){
var map__15007 = p__15006;
var map__15007__$1 = cljs.core.__destructure_map(map__15007);
var opts = map__15007__$1;
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter(opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__15008,root,novelty,error_ch,p__15009){
var map__15010 = p__15008;
var map__15010__$1 = cljs.core.__destructure_map(map__15010);
var conn = map__15010__$1;
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15010__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__15011 = p__15009;
var map__15011__$1 = cljs.core.__destructure_map(map__15011);
var opts = map__15011__$1;
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_flake,end_flake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes(opts);
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15042){
var state_val_15043 = (state_15042[(1)]);
if((state_val_15043 === (7))){
var inst_15025 = (state_15042[(7)]);
var state_15042__$1 = state_15042;
var statearr_15044_15068 = state_15042__$1;
(statearr_15044_15068[(2)] = inst_15025);

(statearr_15044_15068[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (1))){
var state_15042__$1 = state_15042;
var statearr_15045_15069 = state_15042__$1;
(statearr_15045_15069[(2)] = null);

(statearr_15045_15069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (4))){
var inst_15012 = (state_15042[(2)]);
var inst_15013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15014 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_15015 = (new cljs.core.PersistentVector(null,3,(5),inst_15013,inst_15014,null));
var inst_15016 = cljs.core.select_keys(db,inst_15015);
var inst_15017 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_15012,"Error authorizing flake in ledger",inst_15016) : fluree.db.util.log.error.call(null,inst_15012,"Error authorizing flake in ledger",inst_15016));
var state_15042__$1 = (function (){var statearr_15047 = state_15042;
(statearr_15047[(8)] = inst_15017);

return statearr_15047;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15042__$1,(5),error_ch,inst_15012);
} else {
if((state_val_15043 === (13))){
var inst_15037 = (state_15042[(2)]);
var _ = (function (){var statearr_15048 = state_15042;
(statearr_15048[(4)] = cljs.core.rest((state_15042[(4)])));

return statearr_15048;
})();
var state_15042__$1 = state_15042;
var statearr_15049_15070 = state_15042__$1;
(statearr_15049_15070[(2)] = inst_15037);

(statearr_15049_15070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (6))){
var _ = (function (){var statearr_15050 = state_15042;
(statearr_15050[(4)] = cljs.core.rest((state_15042[(4)])));

return statearr_15050;
})();
var state_15042__$1 = state_15042;
var ex15046 = (state_15042__$1[(2)]);
var statearr_15051_15071 = state_15042__$1;
(statearr_15051_15071[(5)] = ex15046);


var statearr_15052_15072 = state_15042__$1;
(statearr_15052_15072[(1)] = (4));

(statearr_15052_15072[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (3))){
var inst_15040 = (state_15042[(2)]);
var state_15042__$1 = state_15042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15042__$1,inst_15040);
} else {
if((state_val_15043 === (12))){
var state_15042__$1 = state_15042;
var statearr_15053_15073 = state_15042__$1;
(statearr_15053_15073[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_15053_15073[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (2))){
var inst_15025 = (state_15042[(7)]);
var _ = (function (){var statearr_15054 = state_15042;
(statearr_15054[(4)] = cljs.core.cons((6),(state_15042[(4)])));

return statearr_15054;
})();
var inst_15025__$1 = fluree.db.util.schema.is_schema_flake_QMARK_(flake);
var state_15042__$1 = (function (){var statearr_15055 = state_15042;
(statearr_15055[(7)] = inst_15025__$1);

return statearr_15055;
})();
if(inst_15025__$1){
var statearr_15056_15074 = state_15042__$1;
(statearr_15056_15074[(1)] = (7));

} else {
var statearr_15057_15075 = state_15042__$1;
(statearr_15057_15075[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (11))){
var state_15042__$1 = state_15042;
var statearr_15058_15076 = state_15042__$1;
(statearr_15058_15076[(2)] = flake);

(statearr_15058_15076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (9))){
var inst_15033 = (state_15042[(2)]);
var state_15042__$1 = state_15042;
if(cljs.core.truth_(inst_15033)){
var statearr_15059_15077 = state_15042__$1;
(statearr_15059_15077[(1)] = (11));

} else {
var statearr_15060_15078 = state_15042__$1;
(statearr_15060_15078[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (5))){
var inst_15019 = (state_15042[(2)]);
var state_15042__$1 = state_15042;
var statearr_15061_15079 = state_15042__$1;
(statearr_15061_15079[(2)] = inst_15019);

(statearr_15061_15079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (10))){
var inst_15030 = (state_15042[(2)]);
var inst_15031 = fluree.db.util.async.throw_err(inst_15030);
var state_15042__$1 = state_15042;
var statearr_15062_15080 = state_15042__$1;
(statearr_15062_15080[(2)] = inst_15031);

(statearr_15062_15080[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15043 === (8))){
var inst_15028 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,flake);
var state_15042__$1 = state_15042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15042__$1,(10),inst_15028);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0 = (function (){
var statearr_15063 = [null,null,null,null,null,null,null,null,null];
(statearr_15063[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__);

(statearr_15063[(1)] = (1));

return statearr_15063;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1 = (function (state_15042){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15042);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15064){var ex__2687__auto__ = e15064;
var statearr_15065_15081 = state_15042;
(statearr_15065_15081[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15042[(4)]))){
var statearr_15066_15082 = state_15042;
(statearr_15066_15082[(1)] = cljs.core.first((state_15042[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15083 = state_15042;
state_15042 = G__15083;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__ = function(state_15042){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1.call(this,state_15042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15067 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15067[(6)] = c__2706__auto__);

return statearr_15067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function() { 
var G__15084__delegate = function (fs){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$1(fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__15084 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__15085__i = 0, G__15085__a = new Array(arguments.length -  0);
while (G__15085__i < G__15085__a.length) {G__15085__a[G__15085__i] = arguments[G__15085__i + 0]; ++G__15085__i;}
  fs = new cljs.core.IndexedSeq(G__15085__a,0,null);
} 
return G__15084__delegate.call(this,fs);};
G__15084.cljs$lang$maxFixedArity = 0;
G__15084.cljs$lang$applyTo = (function (arglist__15086){
var fs = cljs.core.seq(arglist__15086);
return G__15084__delegate(fs);
});
G__15084.cljs$core$IFn$_invoke$arity$variadic = G__15084__delegate;
return G__15084;
})()
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__15087,start,end,error_ch,flake_slices){
var map__15088 = p__15087;
var map__15088__$1 = cljs.core.__destructure_map(map__15088);
var db = map__15088__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15088__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__15089 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s)], null);
var G__15089__$1 = (cljs.core.truth_(offset)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15089,cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset)):G__15089);
var G__15089__$2 = (cljs.core.truth_(limit)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15089__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit)):G__15089__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15089__$2,cljs.core.cat);

})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__15090 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__15090__$1 = (cljs.core.truth_((function (){var or__5045__auto__ = limit;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return offset;
}
})())?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15090,fluree.db.query.range.filter_subject_page(limit,offset)):G__15090);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15090__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(flake_limit));
} else {
return G__15090__$1;
}
})();
var page_xf = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,page_xfs);
return cljs.core.async.transduce(page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__15091,error_ch,p__15092){
var map__15093 = p__15091;
var map__15093__$1 = cljs.core.__destructure_map(map__15093);
var db = map__15093__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15093__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__15094 = p__15092;
var map__15094__$1 = cljs.core.__destructure_map(map__15094);
var opts = map__15094__$1;
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15094__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var idx_cmp = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page(limit,offset,flake_limit,fluree.db.query.range.filter_authorized(db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices(conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__15095 = cljs.core.identical_QMARK_;
var expr__15096 = test;
if(cljs.core.truth_((pred__15095.cljs$core$IFn$_invoke$arity$2 ? pred__15095.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__15096) : pred__15095.call(null,cljs.core._EQ_,expr__15096)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15095.cljs$core$IFn$_invoke$arity$2 ? pred__15095.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__15096) : pred__15095.call(null,cljs.core._LT_,expr__15096)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__15095.cljs$core$IFn$_invoke$arity$2 ? pred__15095.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__15096) : pred__15095.call(null,cljs.core._LT__EQ_,expr__15096)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15095.cljs$core$IFn$_invoke$arity$2 ? pred__15095.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__15096) : pred__15095.call(null,cljs.core._GT_,expr__15096)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__15095.cljs$core$IFn$_invoke$arity$2 ? pred__15095.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__15096) : pred__15095.call(null,cljs.core._GT__EQ_,expr__15096)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15096)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__15099 = arguments.length;
switch (G__15099) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15100 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15100,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15100,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15100,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15100,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15103,idx,start_test,start_match,end_test,end_match,opts){
var map__15104 = p__15103;
var map__15104__$1 = cljs.core.__destructure_map(map__15104);
var db = map__15104__$1;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15105 = opts;
var map__15105__$1 = cljs.core.__destructure_map(map__15105);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15105__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15105__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15105__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15167){
var state_val_15168 = (state_15167[(1)]);
if((state_val_15168 === (7))){
var inst_15120 = (state_15167[(7)]);
var inst_15124 = (state_15167[(8)]);
var inst_15115 = (state_15167[(9)]);
var inst_15118 = (state_15167[(2)]);
var inst_15119 = fluree.db.util.async.throw_err(inst_15118);
var inst_15120__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_15121 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_15122 = [idx,from_t,to_t,start_test,inst_15115,end_test,inst_15119,limit];
var inst_15123 = cljs.core.PersistentHashMap.fromArrays(inst_15121,inst_15122);
var inst_15124__$1 = fluree.db.query.range.index_range_STAR_(db,inst_15120__$1,inst_15123);
var inst_15132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15133 = [inst_15120__$1,inst_15124__$1];
var inst_15134 = (new cljs.core.PersistentVector(null,2,(5),inst_15132,inst_15133,null));
var state_15167__$1 = (function (){var statearr_15169 = state_15167;
(statearr_15169[(7)] = inst_15120__$1);

(statearr_15169[(8)] = inst_15124__$1);

return statearr_15169;
})();
return cljs.core.async.ioc_alts_BANG_(state_15167__$1,(8),inst_15134);
} else {
if((state_val_15168 === (1))){
var state_15167__$1 = state_15167;
var statearr_15170_15199 = state_15167__$1;
(statearr_15170_15199[(2)] = null);

(statearr_15170_15199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (4))){
var inst_15106 = (state_15167[(2)]);
var state_15167__$1 = state_15167;
var statearr_15171_15200 = state_15167__$1;
(statearr_15171_15200[(2)] = inst_15106);

(statearr_15171_15200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (15))){
var inst_15137 = (state_15167[(10)]);
var state_15167__$1 = state_15167;
var statearr_15172_15201 = state_15167__$1;
(statearr_15172_15201[(2)] = inst_15137);

(statearr_15172_15201[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (13))){
var inst_15138 = (state_15167[(11)]);
var inst_15154 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15138,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15167__$1 = state_15167;
if(inst_15154){
var statearr_15173_15202 = state_15167__$1;
(statearr_15173_15202[(1)] = (15));

} else {
var statearr_15174_15203 = state_15167__$1;
(statearr_15174_15203[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (6))){
var inst_15114 = (state_15167[(2)]);
var inst_15115 = fluree.db.util.async.throw_err(inst_15114);
var inst_15116 = fluree.db.query.range.resolve_match_flake(db,end_test,end_parts);
var state_15167__$1 = (function (){var statearr_15175 = state_15167;
(statearr_15175[(9)] = inst_15115);

return statearr_15175;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15167__$1,(7),inst_15116);
} else {
if((state_val_15168 === (17))){
var inst_15158 = (state_15167[(2)]);
var state_15167__$1 = state_15167;
var statearr_15176_15204 = state_15167__$1;
(statearr_15176_15204[(2)] = inst_15158);

(statearr_15176_15204[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (3))){
var inst_15165 = (state_15167[(2)]);
var state_15167__$1 = state_15167;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15167__$1,inst_15165);
} else {
if((state_val_15168 === (12))){
var inst_15136 = (state_15167[(12)]);
var inst_15152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15136,(0),null);
var state_15167__$1 = state_15167;
var statearr_15177_15205 = state_15167__$1;
(statearr_15177_15205[(2)] = inst_15152);

(statearr_15177_15205[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (2))){
var _ = (function (){var statearr_15178 = state_15167;
(statearr_15178[(4)] = cljs.core.cons((5),(state_15167[(4)])));

return statearr_15178;
})();
var inst_15112 = fluree.db.query.range.resolve_match_flake(db,start_test,start_parts);
var state_15167__$1 = state_15167;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15167__$1,(6),inst_15112);
} else {
if((state_val_15168 === (11))){
var inst_15162 = (state_15167[(2)]);
var _ = (function (){var statearr_15180 = state_15167;
(statearr_15180[(4)] = cljs.core.rest((state_15167[(4)])));

return statearr_15180;
})();
var state_15167__$1 = state_15167;
var statearr_15181_15206 = state_15167__$1;
(statearr_15181_15206[(2)] = inst_15162);

(statearr_15181_15206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (9))){
var inst_15136 = (state_15167[(12)]);
var inst_15144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15136,(0),null);
var inst_15145 = (function(){throw inst_15144})();
var state_15167__$1 = state_15167;
var statearr_15182_15207 = state_15167__$1;
(statearr_15182_15207[(2)] = inst_15145);

(statearr_15182_15207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (5))){
var _ = (function (){var statearr_15183 = state_15167;
(statearr_15183[(4)] = cljs.core.rest((state_15167[(4)])));

return statearr_15183;
})();
var state_15167__$1 = state_15167;
var ex15179 = (state_15167__$1[(2)]);
var statearr_15184_15208 = state_15167__$1;
(statearr_15184_15208[(5)] = ex15179);


if((ex15179 instanceof Error)){
var statearr_15185_15209 = state_15167__$1;
(statearr_15185_15209[(1)] = (4));

(statearr_15185_15209[(5)] = null);

} else {
throw ex15179;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (14))){
var inst_15160 = (state_15167[(2)]);
var state_15167__$1 = state_15167;
var statearr_15186_15210 = state_15167__$1;
(statearr_15186_15210[(2)] = inst_15160);

(statearr_15186_15210[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (16))){
var state_15167__$1 = state_15167;
var statearr_15187_15211 = state_15167__$1;
(statearr_15187_15211[(2)] = null);

(statearr_15187_15211[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (10))){
var inst_15124 = (state_15167[(8)]);
var inst_15138 = (state_15167[(11)]);
var inst_15147 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15138,inst_15124);
var state_15167__$1 = state_15167;
if(inst_15147){
var statearr_15188_15212 = state_15167__$1;
(statearr_15188_15212[(1)] = (12));

} else {
var statearr_15189_15213 = state_15167__$1;
(statearr_15189_15213[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15168 === (8))){
var inst_15120 = (state_15167[(7)]);
var inst_15138 = (state_15167[(11)]);
var inst_15136 = (state_15167[(12)]);
var inst_15136__$1 = (state_15167[(2)]);
var inst_15137 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15136__$1,(0),null);
var inst_15138__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15136__$1,(1),null);
var inst_15139 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15138__$1,inst_15120);
var state_15167__$1 = (function (){var statearr_15190 = state_15167;
(statearr_15190[(10)] = inst_15137);

(statearr_15190[(11)] = inst_15138__$1);

(statearr_15190[(12)] = inst_15136__$1);

return statearr_15190;
})();
if(inst_15139){
var statearr_15191_15214 = state_15167__$1;
(statearr_15191_15214[(1)] = (9));

} else {
var statearr_15192_15215 = state_15167__$1;
(statearr_15192_15215[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15193 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15193[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15193[(1)] = (1));

return statearr_15193;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15167){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15167);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15194){var ex__2687__auto__ = e15194;
var statearr_15195_15216 = state_15167;
(statearr_15195_15216[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15167[(4)]))){
var statearr_15196_15217 = state_15167;
(statearr_15196_15217[(1)] = cljs.core.first((state_15167[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15218 = state_15167;
state_15167 = G__15218;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15167){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15197 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15197[(6)] = c__2706__auto__);

return statearr_15197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15220 = arguments.length;
switch (G__15220) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15221 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15221,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15221,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15221,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15221,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15224,idx,start_test,start_match,end_test,end_match,p__15225){
var map__15226 = p__15224;
var map__15226__$1 = cljs.core.__destructure_map(map__15226);
var db = map__15226__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15226__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15226__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15227 = p__15225;
var map__15227__$1 = cljs.core.__destructure_map(map__15227);
var opts = map__15227__$1;
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15227__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__15228 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15228,(0),null);
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15228,(1),null);
var o1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15228,(2),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15228,(3),null);
var op1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15228,(4),null);
var m1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15228,(5),null);
var vec__15231 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var s2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15231,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15231,(1),null);
var o2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15231,(2),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15231,(3),null);
var op2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15231,(4),null);
var m2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15231,(5),null);
var vec__15234 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_(o1))?o1:((cljs.core.boolean_QMARK_(o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
})], null);
}
})();
var vec__15237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15234,(0),null);
var o1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15237,(0),null);
var o2__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15237,(1),null);
var object_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15234,(1),null);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15305){
var state_val_15306 = (state_15305[(1)]);
if((state_val_15306 === (7))){
var inst_15252 = (state_15305[(7)]);
var inst_15260 = (state_15305[(8)]);
var inst_15262 = (state_15305[(9)]);
var inst_15258 = (state_15305[(2)]);
var inst_15259 = fluree.db.util.async.throw_err(inst_15258);
var inst_15260__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_15261 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_15252,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_15259,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1], 0));
var inst_15262__$1 = fluree.db.query.range.index_range_STAR_(db,inst_15260__$1,inst_15261);
var inst_15270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15271 = [inst_15260__$1,inst_15262__$1];
var inst_15272 = (new cljs.core.PersistentVector(null,2,(5),inst_15270,inst_15271,null));
var state_15305__$1 = (function (){var statearr_15307 = state_15305;
(statearr_15307[(8)] = inst_15260__$1);

(statearr_15307[(9)] = inst_15262__$1);

return statearr_15307;
})();
return cljs.core.async.ioc_alts_BANG_(state_15305__$1,(8),inst_15272);
} else {
if((state_val_15306 === (1))){
var state_15305__$1 = state_15305;
var statearr_15308_15337 = state_15305__$1;
(statearr_15308_15337[(2)] = null);

(statearr_15308_15337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (4))){
var inst_15240 = (state_15305[(2)]);
var state_15305__$1 = state_15305;
var statearr_15309_15338 = state_15305__$1;
(statearr_15309_15338[(2)] = inst_15240);

(statearr_15309_15338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (15))){
var inst_15275 = (state_15305[(10)]);
var state_15305__$1 = state_15305;
var statearr_15310_15339 = state_15305__$1;
(statearr_15310_15339[(2)] = inst_15275);

(statearr_15310_15339[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (13))){
var inst_15276 = (state_15305[(11)]);
var inst_15292 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15276,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15305__$1 = state_15305;
if(inst_15292){
var statearr_15311_15340 = state_15305__$1;
(statearr_15311_15340[(1)] = (15));

} else {
var statearr_15312_15341 = state_15305__$1;
(statearr_15312_15341[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (6))){
var inst_15251 = (state_15305[(2)]);
var inst_15252 = fluree.db.util.async.throw_err(inst_15251);
var inst_15253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15254 = [s2,p2,o2__$1,t2,op2,m2];
var inst_15255 = (new cljs.core.PersistentVector(null,6,(5),inst_15253,inst_15254,null));
var inst_15256 = fluree.db.query.range.resolve_match_flake(db,end_test,inst_15255);
var state_15305__$1 = (function (){var statearr_15313 = state_15305;
(statearr_15313[(7)] = inst_15252);

return statearr_15313;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15305__$1,(7),inst_15256);
} else {
if((state_val_15306 === (17))){
var inst_15296 = (state_15305[(2)]);
var state_15305__$1 = state_15305;
var statearr_15314_15342 = state_15305__$1;
(statearr_15314_15342[(2)] = inst_15296);

(statearr_15314_15342[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (3))){
var inst_15303 = (state_15305[(2)]);
var state_15305__$1 = state_15305;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15305__$1,inst_15303);
} else {
if((state_val_15306 === (12))){
var inst_15274 = (state_15305[(12)]);
var inst_15290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15274,(0),null);
var state_15305__$1 = state_15305;
var statearr_15315_15343 = state_15305__$1;
(statearr_15315_15343[(2)] = inst_15290);

(statearr_15315_15343[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (2))){
var _ = (function (){var statearr_15316 = state_15305;
(statearr_15316[(4)] = cljs.core.cons((5),(state_15305[(4)])));

return statearr_15316;
})();
var inst_15246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15247 = [s1,p1,o1__$1,t1,op1,m1];
var inst_15248 = (new cljs.core.PersistentVector(null,6,(5),inst_15246,inst_15247,null));
var inst_15249 = fluree.db.query.range.resolve_match_flake(db,start_test,inst_15248);
var state_15305__$1 = state_15305;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15305__$1,(6),inst_15249);
} else {
if((state_val_15306 === (11))){
var inst_15300 = (state_15305[(2)]);
var _ = (function (){var statearr_15318 = state_15305;
(statearr_15318[(4)] = cljs.core.rest((state_15305[(4)])));

return statearr_15318;
})();
var state_15305__$1 = state_15305;
var statearr_15319_15344 = state_15305__$1;
(statearr_15319_15344[(2)] = inst_15300);

(statearr_15319_15344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (9))){
var inst_15274 = (state_15305[(12)]);
var inst_15282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15274,(0),null);
var inst_15283 = (function(){throw inst_15282})();
var state_15305__$1 = state_15305;
var statearr_15320_15345 = state_15305__$1;
(statearr_15320_15345[(2)] = inst_15283);

(statearr_15320_15345[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (5))){
var _ = (function (){var statearr_15321 = state_15305;
(statearr_15321[(4)] = cljs.core.rest((state_15305[(4)])));

return statearr_15321;
})();
var state_15305__$1 = state_15305;
var ex15317 = (state_15305__$1[(2)]);
var statearr_15322_15346 = state_15305__$1;
(statearr_15322_15346[(5)] = ex15317);


if((ex15317 instanceof Error)){
var statearr_15323_15347 = state_15305__$1;
(statearr_15323_15347[(1)] = (4));

(statearr_15323_15347[(5)] = null);

} else {
throw ex15317;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (14))){
var inst_15298 = (state_15305[(2)]);
var state_15305__$1 = state_15305;
var statearr_15324_15348 = state_15305__$1;
(statearr_15324_15348[(2)] = inst_15298);

(statearr_15324_15348[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (16))){
var state_15305__$1 = state_15305;
var statearr_15325_15349 = state_15305__$1;
(statearr_15325_15349[(2)] = null);

(statearr_15325_15349[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (10))){
var inst_15276 = (state_15305[(11)]);
var inst_15262 = (state_15305[(9)]);
var inst_15285 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15276,inst_15262);
var state_15305__$1 = state_15305;
if(inst_15285){
var statearr_15326_15350 = state_15305__$1;
(statearr_15326_15350[(1)] = (12));

} else {
var statearr_15327_15351 = state_15305__$1;
(statearr_15327_15351[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15306 === (8))){
var inst_15276 = (state_15305[(11)]);
var inst_15260 = (state_15305[(8)]);
var inst_15274 = (state_15305[(12)]);
var inst_15274__$1 = (state_15305[(2)]);
var inst_15275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15274__$1,(0),null);
var inst_15276__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15274__$1,(1),null);
var inst_15277 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15276__$1,inst_15260);
var state_15305__$1 = (function (){var statearr_15328 = state_15305;
(statearr_15328[(10)] = inst_15275);

(statearr_15328[(11)] = inst_15276__$1);

(statearr_15328[(12)] = inst_15274__$1);

return statearr_15328;
})();
if(inst_15277){
var statearr_15329_15352 = state_15305__$1;
(statearr_15329_15352[(1)] = (9));

} else {
var statearr_15330_15353 = state_15305__$1;
(statearr_15330_15353[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15331 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15331[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15331[(1)] = (1));

return statearr_15331;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15305){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15305);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15332){var ex__2687__auto__ = e15332;
var statearr_15333_15354 = state_15305;
(statearr_15333_15354[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15305[(4)]))){
var statearr_15334_15355 = state_15305;
(statearr_15334_15355[(1)] = cljs.core.first((state_15305[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15356 = state_15305;
state_15305 = G__15356;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15305){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15335 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15335[(6)] = c__2706__auto__);

return statearr_15335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o(f))) && ((fluree.db.flake.o(f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15412){
var state_val_15413 = (state_15412[(1)]);
if((state_val_15413 === (7))){
var inst_15386 = (state_15412[(7)]);
var inst_15376 = (state_15412[(8)]);
var inst_15384 = fluree.db.flake.Flake__GT_parts(inst_15376);
var inst_15385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15384,(0),null);
var inst_15386__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15384,(1),null);
var inst_15387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15384,(2),null);
var inst_15388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15384,(3),null);
var inst_15389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15384,(4),null);
var inst_15390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15384,(5),null);
var inst_15391 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15387,inst_15386__$1);
var state_15412__$1 = (function (){var statearr_15414 = state_15412;
(statearr_15414[(7)] = inst_15386__$1);

(statearr_15414[(9)] = inst_15388);

(statearr_15414[(10)] = inst_15389);

(statearr_15414[(11)] = inst_15390);

(statearr_15414[(12)] = inst_15385);

return statearr_15414;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15412__$1,(10),inst_15391);
} else {
if((state_val_15413 === (1))){
var inst_15364 = flakes;
var inst_15365 = cljs.core.seq(inst_15364);
var inst_15366 = cljs.core.first(inst_15365);
var inst_15367 = cljs.core.next(inst_15365);
var inst_15368 = cljs.core.PersistentVector.EMPTY;
var inst_15369 = inst_15364;
var inst_15370 = inst_15368;
var state_15412__$1 = (function (){var statearr_15415 = state_15412;
(statearr_15415[(13)] = inst_15369);

(statearr_15415[(14)] = inst_15366);

(statearr_15415[(15)] = inst_15370);

(statearr_15415[(16)] = inst_15367);

return statearr_15415;
})();
var statearr_15416_15434 = state_15412__$1;
(statearr_15416_15434[(2)] = null);

(statearr_15416_15434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15413 === (4))){
var inst_15376 = (state_15412[(8)]);
var inst_15379 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15376);
var state_15412__$1 = state_15412;
if(inst_15379){
var statearr_15417_15435 = state_15412__$1;
(statearr_15417_15435[(1)] = (7));

} else {
var statearr_15418_15436 = state_15412__$1;
(statearr_15418_15436[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15413 === (6))){
var inst_15408 = (state_15412[(2)]);
var state_15412__$1 = state_15412;
var statearr_15419_15437 = state_15412__$1;
(statearr_15419_15437[(2)] = inst_15408);

(statearr_15419_15437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15413 === (3))){
var inst_15410 = (state_15412[(2)]);
var state_15412__$1 = state_15412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15412__$1,inst_15410);
} else {
if((state_val_15413 === (2))){
var inst_15369 = (state_15412[(13)]);
var inst_15376 = (state_15412[(8)]);
var inst_15375 = cljs.core.seq(inst_15369);
var inst_15376__$1 = cljs.core.first(inst_15375);
var inst_15377 = cljs.core.next(inst_15375);
var state_15412__$1 = (function (){var statearr_15420 = state_15412;
(statearr_15420[(17)] = inst_15377);

(statearr_15420[(8)] = inst_15376__$1);

return statearr_15420;
})();
if(cljs.core.truth_(inst_15376__$1)){
var statearr_15421_15438 = state_15412__$1;
(statearr_15421_15438[(1)] = (4));

} else {
var statearr_15422_15439 = state_15412__$1;
(statearr_15422_15439[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15413 === (9))){
var inst_15405 = (state_15412[(2)]);
var state_15412__$1 = state_15412;
var statearr_15423_15440 = state_15412__$1;
(statearr_15423_15440[(2)] = inst_15405);

(statearr_15423_15440[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15413 === (5))){
var inst_15370 = (state_15412[(15)]);
var state_15412__$1 = state_15412;
var statearr_15424_15441 = state_15412__$1;
(statearr_15424_15441[(2)] = inst_15370);

(statearr_15424_15441[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15413 === (10))){
var inst_15386 = (state_15412[(7)]);
var inst_15388 = (state_15412[(9)]);
var inst_15389 = (state_15412[(10)]);
var inst_15370 = (state_15412[(15)]);
var inst_15390 = (state_15412[(11)]);
var inst_15385 = (state_15412[(12)]);
var inst_15377 = (state_15412[(17)]);
var inst_15393 = (state_15412[(2)]);
var inst_15394 = fluree.db.util.async.throw_err(inst_15393);
var inst_15395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15396 = [inst_15385,inst_15386,inst_15394,inst_15388,inst_15389,inst_15390];
var inst_15397 = (new cljs.core.PersistentVector(null,6,(5),inst_15395,inst_15396,null));
var inst_15398 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15397);
var inst_15399 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15370,inst_15398);
var inst_15369 = inst_15377;
var inst_15370__$1 = inst_15399;
var state_15412__$1 = (function (){var statearr_15425 = state_15412;
(statearr_15425[(13)] = inst_15369);

(statearr_15425[(15)] = inst_15370__$1);

return statearr_15425;
})();
var statearr_15426_15442 = state_15412__$1;
(statearr_15426_15442[(2)] = null);

(statearr_15426_15442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15413 === (8))){
var inst_15370 = (state_15412[(15)]);
var inst_15377 = (state_15412[(17)]);
var inst_15376 = (state_15412[(8)]);
var inst_15402 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15370,inst_15376);
var inst_15369 = inst_15377;
var inst_15370__$1 = inst_15402;
var state_15412__$1 = (function (){var statearr_15427 = state_15412;
(statearr_15427[(13)] = inst_15369);

(statearr_15427[(15)] = inst_15370__$1);

return statearr_15427;
})();
var statearr_15428_15443 = state_15412__$1;
(statearr_15428_15443[(2)] = null);

(statearr_15428_15443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0 = (function (){
var statearr_15429 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15429[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__);

(statearr_15429[(1)] = (1));

return statearr_15429;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1 = (function (state_15412){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15412);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15430){var ex__2687__auto__ = e15430;
var statearr_15431_15444 = state_15412;
(statearr_15431_15444[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15412[(4)]))){
var statearr_15432_15445 = state_15412;
(statearr_15432_15445[(1)] = cljs.core.first((state_15412[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15446 = state_15412;
state_15412 = G__15446;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__ = function(state_15412){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1.call(this,state_15412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15433 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15433[(6)] = c__2706__auto__);

return statearr_15433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15448 = arguments.length;
switch (G__15448) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15631){
var state_val_15632 = (state_15631[(1)]);
if((state_val_15632 === (65))){
var inst_15499 = (state_15631[(7)]);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15499)){
var statearr_15633_15737 = state_15631__$1;
(statearr_15633_15737[(1)] = (68));

} else {
var statearr_15634_15738 = state_15631__$1;
(statearr_15634_15738[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (70))){
var inst_15609 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15635_15739 = state_15631__$1;
(statearr_15635_15739[(2)] = inst_15609);

(statearr_15635_15739[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (62))){
var inst_15575 = (state_15631[(2)]);
var inst_15576 = fluree.db.util.async.throw_err(inst_15575);
var inst_15577 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_15576);
var state_15631__$1 = state_15631;
var statearr_15636_15740 = state_15631__$1;
(statearr_15636_15740[(2)] = inst_15577);

(statearr_15636_15740[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (74))){
var inst_15626 = (state_15631[(2)]);
var _ = (function (){var statearr_15637 = state_15631;
(statearr_15637[(4)] = cljs.core.rest((state_15631[(4)])));

return statearr_15637;
})();
var state_15631__$1 = state_15631;
var statearr_15638_15741 = state_15631__$1;
(statearr_15638_15741[(2)] = inst_15626);

(statearr_15638_15741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (7))){
var state_15631__$1 = state_15631;
var statearr_15639_15742 = state_15631__$1;
(statearr_15639_15742[(2)] = false);

(statearr_15639_15742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (59))){
var inst_15499 = (state_15631[(7)]);
var inst_15569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15570 = [inst_15499];
var inst_15571 = (new cljs.core.PersistentVector(null,1,(5),inst_15569,inst_15570,null));
var inst_15572 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15573 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15571,inst_15572);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(62),inst_15573);
} else {
if((state_val_15632 === (20))){
var state_15631__$1 = state_15631;
var statearr_15640_15743 = state_15631__$1;
(statearr_15640_15743[(2)] = null);

(statearr_15640_15743[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (72))){
var inst_15617 = (state_15631[(8)]);
var inst_15620 = fluree.db.query.range.coerce_tag_flakes(db,inst_15617);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(75),inst_15620);
} else {
if((state_val_15632 === (58))){
var inst_15567 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15567)){
var statearr_15641_15744 = state_15631__$1;
(statearr_15641_15744[(1)] = (59));

} else {
var statearr_15642_15745 = state_15631__$1;
(statearr_15642_15745[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (60))){
var inst_15460 = (state_15631[(9)]);
var inst_15459 = (state_15631[(10)]);
var inst_15561 = (state_15631[(11)]);
var inst_15462 = (state_15631[(12)]);
var inst_15579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15580 = [inst_15460,inst_15459,null,inst_15462];
var inst_15581 = (new cljs.core.PersistentVector(null,4,(5),inst_15579,inst_15580,null));
var inst_15582 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15561);
var inst_15583 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15581,inst_15582);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(63),inst_15583);
} else {
if((state_val_15632 === (27))){
var inst_15499 = (state_15631[(7)]);
var inst_15460 = (state_15631[(9)]);
var inst_15459 = (state_15631[(10)]);
var inst_15462 = (state_15631[(12)]);
var inst_15511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15512 = [inst_15459,inst_15460,inst_15499,inst_15462];
var inst_15513 = (new cljs.core.PersistentVector(null,4,(5),inst_15511,inst_15512,null));
var inst_15514 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15513,opts);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(30),inst_15514);
} else {
if((state_val_15632 === (1))){
var state_15631__$1 = state_15631;
var statearr_15643_15746 = state_15631__$1;
(statearr_15643_15746[(2)] = null);

(statearr_15643_15746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (69))){
var state_15631__$1 = state_15631;
var statearr_15644_15747 = state_15631__$1;
(statearr_15644_15747[(2)] = null);

(statearr_15644_15747[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (24))){
var inst_15460 = (state_15631[(9)]);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15460)){
var statearr_15645_15748 = state_15631__$1;
(statearr_15645_15748[(1)] = (31));

} else {
var statearr_15646_15749 = state_15631__$1;
(statearr_15646_15749[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (55))){
var inst_15460 = (state_15631[(9)]);
var inst_15562 = (state_15631[(13)]);
var inst_15561 = (state_15631[(2)]);
var inst_15562__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15460);
var state_15631__$1 = (function (){var statearr_15647 = state_15631;
(statearr_15647[(11)] = inst_15561);

(statearr_15647[(13)] = inst_15562__$1);

return statearr_15647;
})();
if(inst_15562__$1){
var statearr_15648_15750 = state_15631__$1;
(statearr_15648_15750[(1)] = (56));

} else {
var statearr_15649_15751 = state_15631__$1;
(statearr_15649_15751[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (39))){
var inst_15529 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15650_15752 = state_15631__$1;
(statearr_15650_15752[(2)] = inst_15529);

(statearr_15650_15752[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (46))){
var inst_15553 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15553)){
var statearr_15651_15753 = state_15631__$1;
(statearr_15651_15753[(1)] = (50));

} else {
var statearr_15652_15754 = state_15631__$1;
(statearr_15652_15754[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (4))){
var inst_15449 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15653_15755 = state_15631__$1;
(statearr_15653_15755[(2)] = inst_15449);

(statearr_15653_15755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (54))){
var inst_15458 = (state_15631[(14)]);
var inst_15499 = (state_15631[(7)]);
var inst_15460 = (state_15631[(9)]);
var inst_15459 = (state_15631[(10)]);
var inst_15555 = (state_15631[(15)]);
var inst_15462 = (state_15631[(12)]);
var inst_15474 = (state_15631[(16)]);
var inst_15469 = (state_15631[(17)]);
var inst_15463 = (state_15631[(18)]);
var inst_15559 = (function (){var t = inst_15462;
var temp__5802__auto__ = inst_15555;
var p = inst_15460;
var idx_predicate_QMARK_ = inst_15463;
var o = inst_15499;
var tag_predicate_QMARK_ = inst_15469;
var s = inst_15459;
var o_coerce_QMARK_ = inst_15474;
var vec__15455 = inst_15458;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15631__$1 = state_15631;
var statearr_15654_15756 = state_15631__$1;
(statearr_15654_15756[(2)] = inst_15559);

(statearr_15654_15756[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (15))){
var inst_15461 = (state_15631[(19)]);
var inst_15480 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15461);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(18),inst_15480);
} else {
if((state_val_15632 === (48))){
var inst_15546 = (state_15631[(20)]);
var state_15631__$1 = state_15631;
var statearr_15655_15757 = state_15631__$1;
(statearr_15655_15757[(2)] = inst_15546);

(statearr_15655_15757[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (50))){
var inst_15555 = (state_15631[(15)]);
var inst_15555__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15631__$1 = (function (){var statearr_15656 = state_15631;
(statearr_15656[(15)] = inst_15555__$1);

return statearr_15656;
})();
if(cljs.core.truth_(inst_15555__$1)){
var statearr_15657_15758 = state_15631__$1;
(statearr_15657_15758[(1)] = (53));

} else {
var statearr_15658_15759 = state_15631__$1;
(statearr_15658_15759[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (75))){
var inst_15622 = (state_15631[(2)]);
var inst_15623 = fluree.db.util.async.throw_err(inst_15622);
var state_15631__$1 = state_15631;
var statearr_15659_15760 = state_15631__$1;
(statearr_15659_15760[(2)] = inst_15623);

(statearr_15659_15760[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (21))){
var inst_15495 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15660_15761 = state_15631__$1;
(statearr_15660_15761[(2)] = inst_15495);

(statearr_15660_15761[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (31))){
var inst_15522 = (state_15631[(21)]);
var inst_15499 = (state_15631[(7)]);
var inst_15522__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15499);
var state_15631__$1 = (function (){var statearr_15661 = state_15631;
(statearr_15661[(21)] = inst_15522__$1);

return statearr_15661;
})();
if(inst_15522__$1){
var statearr_15662_15762 = state_15631__$1;
(statearr_15662_15762[(1)] = (34));

} else {
var statearr_15663_15763 = state_15631__$1;
(statearr_15663_15763[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (32))){
var inst_15460 = (state_15631[(9)]);
var state_15631__$1 = state_15631;
var statearr_15664_15764 = state_15631__$1;
(statearr_15664_15764[(2)] = inst_15460);

(statearr_15664_15764[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (40))){
var inst_15499 = (state_15631[(7)]);
var inst_15460 = (state_15631[(9)]);
var inst_15459 = (state_15631[(10)]);
var inst_15462 = (state_15631[(12)]);
var inst_15537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15538 = [inst_15460,inst_15499,inst_15459,inst_15462];
var inst_15539 = (new cljs.core.PersistentVector(null,4,(5),inst_15537,inst_15538,null));
var inst_15540 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15539,opts);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(43),inst_15540);
} else {
if((state_val_15632 === (56))){
var inst_15499 = (state_15631[(7)]);
var inst_15564 = cljs.core.int_QMARK_(inst_15499);
var state_15631__$1 = state_15631;
var statearr_15665_15765 = state_15631__$1;
(statearr_15665_15765[(2)] = inst_15564);

(statearr_15665_15765[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (33))){
var inst_15535 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15535)){
var statearr_15666_15766 = state_15631__$1;
(statearr_15666_15766[(1)] = (40));

} else {
var statearr_15667_15767 = state_15631__$1;
(statearr_15667_15767[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (13))){
var inst_15461 = (state_15631[(19)]);
var inst_15478 = fluree.db.query.range.tag_string_QMARK_(inst_15461);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15478)){
var statearr_15668_15768 = state_15631__$1;
(statearr_15668_15768[(1)] = (15));

} else {
var statearr_15669_15769 = state_15631__$1;
(statearr_15669_15769[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (22))){
var inst_15491 = (state_15631[(2)]);
var inst_15492 = fluree.db.util.async.throw_err(inst_15491);
var state_15631__$1 = state_15631;
var statearr_15670_15770 = state_15631__$1;
(statearr_15670_15770[(2)] = inst_15492);

(statearr_15670_15770[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (36))){
var inst_15532 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15671_15771 = state_15631__$1;
(statearr_15671_15771[(2)] = inst_15532);

(statearr_15671_15771[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (41))){
var inst_15460 = (state_15631[(9)]);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15460)){
var statearr_15672_15772 = state_15631__$1;
(statearr_15672_15772[(1)] = (44));

} else {
var statearr_15673_15773 = state_15631__$1;
(statearr_15673_15773[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (43))){
var inst_15542 = (state_15631[(2)]);
var inst_15543 = fluree.db.util.async.throw_err(inst_15542);
var state_15631__$1 = state_15631;
var statearr_15674_15774 = state_15631__$1;
(statearr_15674_15774[(2)] = inst_15543);

(statearr_15674_15774[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (61))){
var inst_15588 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15675_15775 = state_15631__$1;
(statearr_15675_15775[(2)] = inst_15588);

(statearr_15675_15775[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (29))){
var inst_15508 = (state_15631[(2)]);
var inst_15509 = fluree.db.util.async.throw_err(inst_15508);
var state_15631__$1 = state_15631;
var statearr_15676_15776 = state_15631__$1;
(statearr_15676_15776[(2)] = inst_15509);

(statearr_15676_15776[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (44))){
var inst_15546 = (state_15631[(20)]);
var inst_15463 = (state_15631[(18)]);
var inst_15546__$1 = cljs.core.not(inst_15463);
var state_15631__$1 = (function (){var statearr_15677 = state_15631;
(statearr_15677[(20)] = inst_15546__$1);

return statearr_15677;
})();
if(inst_15546__$1){
var statearr_15678_15777 = state_15631__$1;
(statearr_15678_15777[(1)] = (47));

} else {
var statearr_15679_15778 = state_15631__$1;
(statearr_15679_15778[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (6))){
var inst_15460 = (state_15631[(9)]);
var inst_15465 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15460);
var inst_15466 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15465);
var state_15631__$1 = state_15631;
var statearr_15680_15779 = state_15631__$1;
(statearr_15680_15779[(2)] = inst_15466);

(statearr_15680_15779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (28))){
var inst_15519 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15681_15780 = state_15631__$1;
(statearr_15681_15780[(2)] = inst_15519);

(statearr_15681_15780[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (64))){
var inst_15499 = (state_15631[(7)]);
var inst_15460 = (state_15631[(9)]);
var inst_15459 = (state_15631[(10)]);
var inst_15462 = (state_15631[(12)]);
var inst_15591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15592 = [inst_15460,inst_15459,inst_15499,inst_15462];
var inst_15593 = (new cljs.core.PersistentVector(null,4,(5),inst_15591,inst_15592,null));
var inst_15594 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15593,opts);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(67),inst_15594);
} else {
if((state_val_15632 === (51))){
var inst_15460 = (state_15631[(9)]);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15460)){
var statearr_15682_15781 = state_15631__$1;
(statearr_15682_15781[(1)] = (64));

} else {
var statearr_15683_15782 = state_15631__$1;
(statearr_15683_15782[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (25))){
var inst_15617 = (state_15631[(8)]);
var inst_15469 = (state_15631[(17)]);
var inst_15617__$1 = (state_15631[(2)]);
var inst_15618 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("search res:",inst_15617__$1) : fluree.db.util.log.debug.call(null,"search res:",inst_15617__$1));
var state_15631__$1 = (function (){var statearr_15684 = state_15631;
(statearr_15684[(22)] = inst_15618);

(statearr_15684[(8)] = inst_15617__$1);

return statearr_15684;
})();
if(cljs.core.truth_(inst_15469)){
var statearr_15685_15783 = state_15631__$1;
(statearr_15685_15783[(1)] = (72));

} else {
var statearr_15686_15784 = state_15631__$1;
(statearr_15686_15784[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (34))){
var inst_15463 = (state_15631[(18)]);
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15463)){
var statearr_15687_15785 = state_15631__$1;
(statearr_15687_15785[(1)] = (37));

} else {
var statearr_15688_15786 = state_15631__$1;
(statearr_15688_15786[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (17))){
var inst_15497 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15689_15787 = state_15631__$1;
(statearr_15689_15787[(2)] = inst_15497);

(statearr_15689_15787[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (3))){
var inst_15629 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15631__$1,inst_15629);
} else {
if((state_val_15632 === (12))){
var inst_15461 = (state_15631[(19)]);
var state_15631__$1 = state_15631;
var statearr_15690_15788 = state_15631__$1;
(statearr_15690_15788[(2)] = inst_15461);

(statearr_15690_15788[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (2))){
var inst_15458 = (state_15631[(14)]);
var inst_15460 = (state_15631[(9)]);
var _ = (function (){var statearr_15691 = state_15631;
(statearr_15691[(4)] = cljs.core.cons((5),(state_15631[(4)])));

return statearr_15691;
})();
var inst_15458__$1 = fparts;
var inst_15459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15458__$1,(0),null);
var inst_15460__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15458__$1,(1),null);
var inst_15461 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15458__$1,(2),null);
var inst_15462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15458__$1,(3),null);
var inst_15463 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15460__$1);
var state_15631__$1 = (function (){var statearr_15692 = state_15631;
(statearr_15692[(14)] = inst_15458__$1);

(statearr_15692[(9)] = inst_15460__$1);

(statearr_15692[(19)] = inst_15461);

(statearr_15692[(10)] = inst_15459);

(statearr_15692[(12)] = inst_15462);

(statearr_15692[(18)] = inst_15463);

return statearr_15692;
})();
if(cljs.core.truth_(inst_15460__$1)){
var statearr_15693_15789 = state_15631__$1;
(statearr_15693_15789[(1)] = (6));

} else {
var statearr_15694_15790 = state_15631__$1;
(statearr_15694_15790[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (66))){
var inst_15611 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15695_15791 = state_15631__$1;
(statearr_15695_15791[(2)] = inst_15611);

(statearr_15695_15791[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (23))){
var inst_15460 = (state_15631[(9)]);
var inst_15501 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15460);
var state_15631__$1 = state_15631;
if(inst_15501){
var statearr_15696_15792 = state_15631__$1;
(statearr_15696_15792[(1)] = (26));

} else {
var statearr_15697_15793 = state_15631__$1;
(statearr_15697_15793[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (47))){
var inst_15499 = (state_15631[(7)]);
var state_15631__$1 = state_15631;
var statearr_15698_15794 = state_15631__$1;
(statearr_15698_15794[(2)] = inst_15499);

(statearr_15698_15794[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (35))){
var inst_15522 = (state_15631[(21)]);
var state_15631__$1 = state_15631;
var statearr_15699_15795 = state_15631__$1;
(statearr_15699_15795[(2)] = inst_15522);

(statearr_15699_15795[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (19))){
var inst_15460 = (state_15631[(9)]);
var inst_15461 = (state_15631[(19)]);
var inst_15487 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15460);
var inst_15488 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15487),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15461)].join('');
var inst_15489 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15488);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(22),inst_15489);
} else {
if((state_val_15632 === (57))){
var inst_15562 = (state_15631[(13)]);
var state_15631__$1 = state_15631;
var statearr_15700_15796 = state_15631__$1;
(statearr_15700_15796[(2)] = inst_15562);

(statearr_15700_15796[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (68))){
var inst_15499 = (state_15631[(7)]);
var inst_15460 = (state_15631[(9)]);
var inst_15459 = (state_15631[(10)]);
var inst_15462 = (state_15631[(12)]);
var inst_15600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15601 = [inst_15499,inst_15460,inst_15459,inst_15462];
var inst_15602 = (new cljs.core.PersistentVector(null,4,(5),inst_15600,inst_15601,null));
var inst_15603 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15602,opts);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(71),inst_15603);
} else {
if((state_val_15632 === (11))){
var inst_15474 = (state_15631[(16)]);
var inst_15474__$1 = (state_15631[(2)]);
var inst_15475 = cljs.core.not(inst_15474__$1);
var state_15631__$1 = (function (){var statearr_15702 = state_15631;
(statearr_15702[(16)] = inst_15474__$1);

return statearr_15702;
})();
if(inst_15475){
var statearr_15703_15797 = state_15631__$1;
(statearr_15703_15797[(1)] = (12));

} else {
var statearr_15704_15798 = state_15631__$1;
(statearr_15704_15798[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (9))){
var inst_15461 = (state_15631[(19)]);
var inst_15471 = typeof inst_15461 === 'string';
var state_15631__$1 = state_15631;
var statearr_15705_15799 = state_15631__$1;
(statearr_15705_15799[(2)] = inst_15471);

(statearr_15705_15799[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (5))){
var _ = (function (){var statearr_15706 = state_15631;
(statearr_15706[(4)] = cljs.core.rest((state_15631[(4)])));

return statearr_15706;
})();
var state_15631__$1 = state_15631;
var ex15701 = (state_15631__$1[(2)]);
var statearr_15707_15800 = state_15631__$1;
(statearr_15707_15800[(5)] = ex15701);


if((ex15701 instanceof Error)){
var statearr_15708_15801 = state_15631__$1;
(statearr_15708_15801[(1)] = (4));

(statearr_15708_15801[(5)] = null);

} else {
throw ex15701;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (14))){
var inst_15459 = (state_15631[(10)]);
var inst_15499 = (state_15631[(2)]);
var state_15631__$1 = (function (){var statearr_15709 = state_15631;
(statearr_15709[(7)] = inst_15499);

return statearr_15709;
})();
if(cljs.core.truth_(inst_15459)){
var statearr_15710_15802 = state_15631__$1;
(statearr_15710_15802[(1)] = (23));

} else {
var statearr_15711_15803 = state_15631__$1;
(statearr_15711_15803[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (45))){
var inst_15460 = (state_15631[(9)]);
var state_15631__$1 = state_15631;
var statearr_15712_15804 = state_15631__$1;
(statearr_15712_15804[(2)] = inst_15460);

(statearr_15712_15804[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (53))){
var inst_15458 = (state_15631[(14)]);
var inst_15499 = (state_15631[(7)]);
var inst_15460 = (state_15631[(9)]);
var inst_15459 = (state_15631[(10)]);
var inst_15555 = (state_15631[(15)]);
var inst_15462 = (state_15631[(12)]);
var inst_15474 = (state_15631[(16)]);
var inst_15469 = (state_15631[(17)]);
var inst_15463 = (state_15631[(18)]);
var inst_15557 = (function (){var obj_fn = inst_15555;
var t = inst_15462;
var temp__5802__auto__ = inst_15555;
var p = inst_15460;
var idx_predicate_QMARK_ = inst_15463;
var o = inst_15499;
var tag_predicate_QMARK_ = inst_15469;
var s = inst_15459;
var o_coerce_QMARK_ = inst_15474;
var vec__15455 = inst_15458;
return (function (x){
var and__5043__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_15631__$1 = state_15631;
var statearr_15713_15805 = state_15631__$1;
(statearr_15713_15805[(2)] = inst_15557);

(statearr_15713_15805[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (26))){
var inst_15459 = (state_15631[(10)]);
var inst_15462 = (state_15631[(12)]);
var inst_15503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15504 = [inst_15459,null,null,inst_15462];
var inst_15505 = (new cljs.core.PersistentVector(null,4,(5),inst_15503,inst_15504,null));
var inst_15506 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15505,opts);
var state_15631__$1 = state_15631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15631__$1,(29),inst_15506);
} else {
if((state_val_15632 === (16))){
var inst_15461 = (state_15631[(19)]);
var inst_15485 = typeof inst_15461 === 'string';
var state_15631__$1 = state_15631;
if(cljs.core.truth_(inst_15485)){
var statearr_15714_15806 = state_15631__$1;
(statearr_15714_15806[(1)] = (19));

} else {
var statearr_15715_15807 = state_15631__$1;
(statearr_15715_15807[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (38))){
var inst_15463 = (state_15631[(18)]);
var state_15631__$1 = state_15631;
var statearr_15716_15808 = state_15631__$1;
(statearr_15716_15808[(2)] = inst_15463);

(statearr_15716_15808[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (30))){
var inst_15516 = (state_15631[(2)]);
var inst_15517 = fluree.db.util.async.throw_err(inst_15516);
var state_15631__$1 = state_15631;
var statearr_15717_15809 = state_15631__$1;
(statearr_15717_15809[(2)] = inst_15517);

(statearr_15717_15809[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (73))){
var inst_15617 = (state_15631[(8)]);
var state_15631__$1 = state_15631;
var statearr_15718_15810 = state_15631__$1;
(statearr_15718_15810[(2)] = inst_15617);

(statearr_15718_15810[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (10))){
var inst_15469 = (state_15631[(17)]);
var state_15631__$1 = state_15631;
var statearr_15719_15811 = state_15631__$1;
(statearr_15719_15811[(2)] = inst_15469);

(statearr_15719_15811[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (18))){
var inst_15482 = (state_15631[(2)]);
var inst_15483 = fluree.db.util.async.throw_err(inst_15482);
var state_15631__$1 = state_15631;
var statearr_15720_15812 = state_15631__$1;
(statearr_15720_15812[(2)] = inst_15483);

(statearr_15720_15812[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (52))){
var inst_15613 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15721_15813 = state_15631__$1;
(statearr_15721_15813[(2)] = inst_15613);

(statearr_15721_15813[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (67))){
var inst_15596 = (state_15631[(2)]);
var inst_15597 = fluree.db.util.async.throw_err(inst_15596);
var state_15631__$1 = state_15631;
var statearr_15722_15814 = state_15631__$1;
(statearr_15722_15814[(2)] = inst_15597);

(statearr_15722_15814[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (71))){
var inst_15605 = (state_15631[(2)]);
var inst_15606 = fluree.db.util.async.throw_err(inst_15605);
var state_15631__$1 = state_15631;
var statearr_15723_15815 = state_15631__$1;
(statearr_15723_15815[(2)] = inst_15606);

(statearr_15723_15815[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (42))){
var inst_15615 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15724_15816 = state_15631__$1;
(statearr_15724_15816[(2)] = inst_15615);

(statearr_15724_15816[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (37))){
var inst_15499 = (state_15631[(7)]);
var inst_15525 = cljs.core.fn_QMARK_(inst_15499);
var inst_15526 = (!(inst_15525));
var state_15631__$1 = state_15631;
var statearr_15725_15817 = state_15631__$1;
(statearr_15725_15817[(2)] = inst_15526);

(statearr_15725_15817[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (63))){
var inst_15585 = (state_15631[(2)]);
var inst_15586 = fluree.db.util.async.throw_err(inst_15585);
var state_15631__$1 = state_15631;
var statearr_15726_15818 = state_15631__$1;
(statearr_15726_15818[(2)] = inst_15586);

(statearr_15726_15818[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (8))){
var inst_15469 = (state_15631[(17)]);
var inst_15469__$1 = (state_15631[(2)]);
var state_15631__$1 = (function (){var statearr_15727 = state_15631;
(statearr_15727[(17)] = inst_15469__$1);

return statearr_15727;
})();
if(cljs.core.truth_(inst_15469__$1)){
var statearr_15728_15819 = state_15631__$1;
(statearr_15728_15819[(1)] = (9));

} else {
var statearr_15729_15820 = state_15631__$1;
(statearr_15729_15820[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15632 === (49))){
var inst_15550 = (state_15631[(2)]);
var state_15631__$1 = state_15631;
var statearr_15730_15821 = state_15631__$1;
(statearr_15730_15821[(2)] = inst_15550);

(statearr_15730_15821[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15731 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15731[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15731[(1)] = (1));

return statearr_15731;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15631){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15631);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15732){var ex__2687__auto__ = e15732;
var statearr_15733_15822 = state_15631;
(statearr_15733_15822[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15631[(4)]))){
var statearr_15734_15823 = state_15631;
(statearr_15734_15823[(1)] = cljs.core.first((state_15631[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15824 = state_15631;
state_15631 = G__15824;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15631){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15735 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15735[(6)] = c__2706__auto__);

return statearr_15735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15826 = arguments.length;
switch (G__15826) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15861){
var state_val_15862 = (state_15861[(1)]);
if((state_val_15862 === (7))){
var inst_15848 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15849 = ["Invalid collection name: ",inst_15848].join('');
var inst_15850 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15851 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15852 = cljs.core.PersistentHashMap.fromArrays(inst_15850,inst_15851);
var inst_15853 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15849,inst_15852);
var inst_15854 = (function(){throw inst_15853})();
var state_15861__$1 = state_15861;
var statearr_15863_15883 = state_15861__$1;
(statearr_15863_15883[(2)] = inst_15854);

(statearr_15863_15883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15862 === (1))){
var state_15861__$1 = state_15861;
var statearr_15864_15884 = state_15861__$1;
(statearr_15864_15884[(2)] = null);

(statearr_15864_15884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15862 === (4))){
var inst_15827 = (state_15861[(2)]);
var state_15861__$1 = state_15861;
var statearr_15865_15885 = state_15861__$1;
(statearr_15865_15885[(2)] = inst_15827);

(statearr_15865_15885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15862 === (6))){
var inst_15833 = (state_15861[(7)]);
var inst_15835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15836 = fluree.db.flake.max_subject_id(inst_15833);
var inst_15837 = [inst_15836];
var inst_15838 = (new cljs.core.PersistentVector(null,1,(5),inst_15835,inst_15837,null));
var inst_15839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15840 = fluree.db.flake.min_subject_id(inst_15833);
var inst_15841 = [inst_15840];
var inst_15842 = (new cljs.core.PersistentVector(null,1,(5),inst_15839,inst_15841,null));
var inst_15843 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15838,cljs.core._LT__EQ_,inst_15842,opts);
var state_15861__$1 = state_15861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15861__$1,(9),inst_15843);
} else {
if((state_val_15862 === (3))){
var inst_15859 = (state_15861[(2)]);
var state_15861__$1 = state_15861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15861__$1,inst_15859);
} else {
if((state_val_15862 === (2))){
var inst_15833 = (state_15861[(7)]);
var _ = (function (){var statearr_15867 = state_15861;
(statearr_15867[(4)] = cljs.core.cons((5),(state_15861[(4)])));

return statearr_15867;
})();
var inst_15833__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15861__$1 = (function (){var statearr_15868 = state_15861;
(statearr_15868[(7)] = inst_15833__$1);

return statearr_15868;
})();
if(cljs.core.truth_(inst_15833__$1)){
var statearr_15869_15886 = state_15861__$1;
(statearr_15869_15886[(1)] = (6));

} else {
var statearr_15870_15887 = state_15861__$1;
(statearr_15870_15887[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15862 === (9))){
var inst_15845 = (state_15861[(2)]);
var inst_15846 = fluree.db.util.async.throw_err(inst_15845);
var state_15861__$1 = state_15861;
var statearr_15871_15888 = state_15861__$1;
(statearr_15871_15888[(2)] = inst_15846);

(statearr_15871_15888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15862 === (5))){
var _ = (function (){var statearr_15872 = state_15861;
(statearr_15872[(4)] = cljs.core.rest((state_15861[(4)])));

return statearr_15872;
})();
var state_15861__$1 = state_15861;
var ex15866 = (state_15861__$1[(2)]);
var statearr_15873_15889 = state_15861__$1;
(statearr_15873_15889[(5)] = ex15866);


var statearr_15874_15890 = state_15861__$1;
(statearr_15874_15890[(1)] = (4));

(statearr_15874_15890[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15862 === (8))){
var inst_15856 = (state_15861[(2)]);
var _ = (function (){var statearr_15875 = state_15861;
(statearr_15875[(4)] = cljs.core.rest((state_15861[(4)])));

return statearr_15875;
})();
var state_15861__$1 = state_15861;
var statearr_15876_15891 = state_15861__$1;
(statearr_15876_15891[(2)] = inst_15856);

(statearr_15876_15891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15877 = [null,null,null,null,null,null,null,null];
(statearr_15877[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15877[(1)] = (1));

return statearr_15877;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15861){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15861);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15878){var ex__2687__auto__ = e15878;
var statearr_15879_15892 = state_15861;
(statearr_15879_15892[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15861[(4)]))){
var statearr_15880_15893 = state_15861;
(statearr_15880_15893[(1)] = cljs.core.first((state_15861[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15894 = state_15861;
state_15861 = G__15894;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15861){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15881 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15881[(6)] = c__2706__auto__);

return statearr_15881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15898 = flakes;
var vec__15899 = G__15898;
var seq__15900 = cljs.core.seq(vec__15899);
var first__15901 = cljs.core.first(seq__15900);
var seq__15900__$1 = cljs.core.next(seq__15900);
var flake_SINGLEQUOTE_ = first__15901;
var r = seq__15900__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15898__$1 = G__15898;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15907 = G__15898__$1;
var seq__15908 = cljs.core.seq(vec__15907);
var first__15909 = cljs.core.first(seq__15908);
var seq__15908__$1 = cljs.core.next(seq__15908);
var flake_SINGLEQUOTE___$1 = first__15909;
var r__$1 = seq__15908__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o(flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15911){var e = e15911;
return null;
}})();
var map__15910 = cmd_map;
var map__15910__$1 = cljs.core.__destructure_map(map__15910);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15910__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15910__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15910__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15910__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15910__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15910__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15912 = r__$1;
var G__15913 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15898__$1 = G__15912;
result_STAR___$1 = G__15913;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15922 = blocks;
var vec__15923 = G__15922;
var seq__15924 = cljs.core.seq(vec__15923);
var first__15925 = cljs.core.first(seq__15924);
var seq__15924__$1 = cljs.core.next(seq__15924);
var block_SINGLEQUOTE_ = first__15925;
var r = seq__15924__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15922__$1 = G__15922;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15930 = G__15922__$1;
var seq__15931 = cljs.core.seq(vec__15930);
var first__15932 = cljs.core.first(seq__15931);
var seq__15931__$1 = cljs.core.next(seq__15931);
var block_SINGLEQUOTE___$1 = first__15932;
var r__$1 = seq__15931__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15933 = block_SINGLEQUOTE___$1;
var map__15933__$1 = cljs.core.__destructure_map(map__15933);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15933__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15933__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15933__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15914_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15914_SHARP_),(2))){
return fluree.db.flake.o(p1__15914_SHARP_);
} else {
return null;
}
});})(G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,prev_hash,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15915_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15915_SHARP_),(1))){
return fluree.db.flake.o(p1__15915_SHARP_);
} else {
return null;
}
});})(G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,prev_hash,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,prev_hash,hash,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15916_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15916_SHARP_),(5))){
return fluree.db.flake.o(p1__15916_SHARP_);
} else {
return null;
}
});})(G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,prev_hash,hash,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,prev_hash,hash,instant,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15917_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15917_SHARP_),(7))){
return fluree.db.flake.o(p1__15917_SHARP_);
} else {
return null;
}
});})(G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,prev_hash,hash,instant,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15918_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15918_SHARP_),(106));
});})(G__15922__$1,result_STAR___$1,map__15933,map__15933__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15930,seq__15931,first__15932,seq__15931__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15922,vec__15923,seq__15924,first__15925,seq__15924__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15934 = r__$1;
var G__15935 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15922__$1 = G__15934;
result_STAR___$1 = G__15935;
continue;
}
break;
}
});
