// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__18504 = arguments.length;
switch (G__18504) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__18505 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18505) : f.call(null,G__18505));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__18506 = cljs.core._deref(vol);
var G__18507 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18506,G__18507) : f.call(null,G__18506,G__18507));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__18508 = cljs.core._deref(vol);
var G__18509 = arg1;
var G__18510 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18508,G__18509,G__18510) : f.call(null,G__18508,G__18509,G__18510));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__18511 = cljs.core._deref(vol);
var G__18512 = arg1;
var G__18513 = arg2;
var G__18514 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__18511,G__18512,G__18513,G__18514) : f.call(null,G__18511,G__18512,G__18513,G__18514));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,opts,reverse_refs_specs){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18675){
var state_val_18676 = (state_18675[(1)]);
if((state_val_18676 === (7))){
var inst_18670 = (state_18675[(2)]);
var _ = (function (){var statearr_18677 = state_18675;
(statearr_18677[(4)] = cljs.core.rest((state_18675[(4)])));

return statearr_18677;
})();
var state_18675__$1 = state_18675;
var statearr_18678_18760 = state_18675__$1;
(statearr_18678_18760[(2)] = inst_18670);

(statearr_18678_18760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (20))){
var inst_18597 = (state_18675[(7)]);
var state_18675__$1 = state_18675;
var statearr_18679_18761 = state_18675__$1;
(statearr_18679_18761[(2)] = inst_18597);

(statearr_18679_18761[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (27))){
var inst_18552 = (state_18675[(8)]);
var state_18675__$1 = state_18675;
if(cljs.core.truth_(inst_18552)){
var statearr_18680_18762 = state_18675__$1;
(statearr_18680_18762[(1)] = (29));

} else {
var statearr_18681_18763 = state_18675__$1;
(statearr_18681_18763[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (1))){
var state_18675__$1 = state_18675;
var statearr_18682_18764 = state_18675__$1;
(statearr_18682_18764[(2)] = null);

(statearr_18682_18764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (24))){
var inst_18553 = (state_18675[(9)]);
var state_18675__$1 = state_18675;
var statearr_18683_18765 = state_18675__$1;
(statearr_18683_18765[(2)] = inst_18553);

(statearr_18683_18765[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (39))){
var inst_18589 = (state_18675[(10)]);
var state_18675__$1 = state_18675;
var statearr_18684_18766 = state_18675__$1;
(statearr_18684_18766[(2)] = inst_18589);

(statearr_18684_18766[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (46))){
var inst_18554 = (state_18675[(11)]);
var state_18675__$1 = state_18675;
var statearr_18685_18767 = state_18675__$1;
(statearr_18685_18767[(2)] = inst_18554);

(statearr_18685_18767[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (4))){
var inst_18516 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18686_18768 = state_18675__$1;
(statearr_18686_18768[(2)] = inst_18516);

(statearr_18686_18768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (15))){
var inst_18565 = (state_18675[(12)]);
var inst_18571 = cljs.core.count(inst_18565);
var inst_18572 = fluree.db.query.fql_resp.add_fuel(fuel,inst_18571,max_fuel);
var state_18675__$1 = state_18675;
var statearr_18687_18769 = state_18675__$1;
(statearr_18687_18769[(2)] = inst_18572);

(statearr_18687_18769[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (48))){
var inst_18534 = (state_18675[(13)]);
var inst_18541 = (state_18675[(14)]);
var inst_18656 = (state_18675[(15)]);
var inst_18664 = (state_18675[(2)]);
var inst_18665 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18534,inst_18664,inst_18656);
var inst_18533 = inst_18541;
var inst_18534__$1 = inst_18665;
var state_18675__$1 = (function (){var statearr_18688 = state_18675;
(statearr_18688[(13)] = inst_18534__$1);

(statearr_18688[(16)] = inst_18533);

return statearr_18688;
})();
var statearr_18689_18770 = state_18675__$1;
(statearr_18689_18770[(2)] = null);

(statearr_18689_18770[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (50))){
var inst_18556 = (state_18675[(17)]);
var state_18675__$1 = state_18675;
var statearr_18690_18771 = state_18675__$1;
(statearr_18690_18771[(2)] = inst_18556);

(statearr_18690_18771[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (21))){
var inst_18553 = (state_18675[(9)]);
var state_18675__$1 = state_18675;
if(cljs.core.truth_(inst_18553)){
var statearr_18692_18772 = state_18675__$1;
(statearr_18692_18772[(1)] = (23));

} else {
var statearr_18693_18773 = state_18675__$1;
(statearr_18693_18773[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (31))){
var inst_18613 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
if(cljs.core.truth_(inst_18613)){
var statearr_18694_18774 = state_18675__$1;
(statearr_18694_18774[(1)] = (32));

} else {
var statearr_18695_18775 = state_18675__$1;
(statearr_18695_18775[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (32))){
var inst_18589 = (state_18675[(10)]);
var inst_18588 = (state_18675[(18)]);
var inst_18596 = (state_18675[(19)]);
var inst_18615 = (inst_18588 + (1));
var tmp18691 = inst_18589;
var inst_18587 = inst_18596;
var inst_18588__$1 = inst_18615;
var inst_18589__$1 = tmp18691;
var state_18675__$1 = (function (){var statearr_18696 = state_18675;
(statearr_18696[(10)] = inst_18589__$1);

(statearr_18696[(18)] = inst_18588__$1);

(statearr_18696[(20)] = inst_18587);

return statearr_18696;
})();
var statearr_18697_18776 = state_18675__$1;
(statearr_18697_18776[(2)] = null);

(statearr_18697_18776[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (40))){
var state_18675__$1 = state_18675;
if(cljs.core.truth_(fuel)){
var statearr_18698_18777 = state_18675__$1;
(statearr_18698_18777[(1)] = (42));

} else {
var statearr_18699_18778 = state_18675__$1;
(statearr_18699_18778[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (33))){
var state_18675__$1 = state_18675;
var statearr_18700_18779 = state_18675__$1;
(statearr_18700_18779[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (13))){
var inst_18565 = (state_18675[(12)]);
var state_18675__$1 = state_18675;
var statearr_18702_18780 = state_18675__$1;
(statearr_18702_18780[(2)] = inst_18565);

(statearr_18702_18780[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (22))){
var inst_18606 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
if(cljs.core.truth_(inst_18606)){
var statearr_18703_18781 = state_18675__$1;
(statearr_18703_18781[(1)] = (26));

} else {
var statearr_18704_18782 = state_18675__$1;
(statearr_18704_18782[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (36))){
var state_18675__$1 = state_18675;
var statearr_18705_18783 = state_18675__$1;
(statearr_18705_18783[(2)] = null);

(statearr_18705_18783[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (41))){
var inst_18588 = (state_18675[(18)]);
var inst_18596 = (state_18675[(19)]);
var inst_18645 = (state_18675[(2)]);
var inst_18646 = (inst_18588 + (1));
var inst_18587 = inst_18596;
var inst_18588__$1 = inst_18646;
var inst_18589 = inst_18645;
var state_18675__$1 = (function (){var statearr_18706 = state_18675;
(statearr_18706[(10)] = inst_18589);

(statearr_18706[(18)] = inst_18588__$1);

(statearr_18706[(20)] = inst_18587);

return statearr_18706;
})();
var statearr_18707_18784 = state_18675__$1;
(statearr_18707_18784[(2)] = null);

(statearr_18707_18784[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (43))){
var state_18675__$1 = state_18675;
var statearr_18708_18785 = state_18675__$1;
(statearr_18708_18785[(2)] = null);

(statearr_18708_18785[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (29))){
var inst_18588 = (state_18675[(18)]);
var inst_18552 = (state_18675[(8)]);
var inst_18610 = (inst_18588 < inst_18552);
var state_18675__$1 = state_18675;
var statearr_18709_18786 = state_18675__$1;
(statearr_18709_18786[(2)] = inst_18610);

(statearr_18709_18786[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (44))){
var inst_18629 = (state_18675[(21)]);
var inst_18625 = (state_18675[(22)]);
var inst_18638 = (state_18675[(2)]);
var inst_18639 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$7(db,cache,fuel,max_fuel,inst_18629,opts,inst_18625) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_18629,opts,inst_18625));
var state_18675__$1 = (function (){var statearr_18710 = state_18675;
(statearr_18710[(23)] = inst_18638);

return statearr_18710;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18675__$1,(45),inst_18639);
} else {
if((state_val_18676 === (6))){
var inst_18540 = (state_18675[(24)]);
var inst_18533 = (state_18675[(16)]);
var inst_18539 = cljs.core.seq(inst_18533);
var inst_18540__$1 = cljs.core.first(inst_18539);
var inst_18541 = cljs.core.next(inst_18539);
var inst_18542 = cljs.core.not(inst_18540__$1);
var state_18675__$1 = (function (){var statearr_18711 = state_18675;
(statearr_18711[(24)] = inst_18540__$1);

(statearr_18711[(14)] = inst_18541);

return statearr_18711;
})();
if(inst_18542){
var statearr_18712_18787 = state_18675__$1;
(statearr_18712_18787[(1)] = (8));

} else {
var statearr_18713_18788 = state_18675__$1;
(statearr_18713_18788[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (28))){
var inst_18654 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18714_18789 = state_18675__$1;
(statearr_18714_18789[(2)] = inst_18654);

(statearr_18714_18789[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (51))){
var inst_18662 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18715_18790 = state_18675__$1;
(statearr_18715_18790[(2)] = inst_18662);

(statearr_18715_18790[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (25))){
var inst_18604 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18716_18791 = state_18675__$1;
(statearr_18716_18791[(2)] = inst_18604);

(statearr_18716_18791[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (34))){
var inst_18652 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18717_18792 = state_18675__$1;
(statearr_18717_18792[(2)] = inst_18652);

(statearr_18717_18792[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (17))){
var inst_18565 = (state_18675[(12)]);
var inst_18575 = (state_18675[(2)]);
var inst_18583 = cljs.core.seq(inst_18565);
var inst_18584 = cljs.core.first(inst_18583);
var inst_18585 = cljs.core.next(inst_18583);
var inst_18586 = cljs.core.PersistentVector.EMPTY;
var inst_18587 = inst_18565;
var inst_18588 = (0);
var inst_18589 = inst_18586;
var state_18675__$1 = (function (){var statearr_18718 = state_18675;
(statearr_18718[(25)] = inst_18584);

(statearr_18718[(10)] = inst_18589);

(statearr_18718[(18)] = inst_18588);

(statearr_18718[(26)] = inst_18575);

(statearr_18718[(27)] = inst_18585);

(statearr_18718[(20)] = inst_18587);

return statearr_18718;
})();
var statearr_18719_18793 = state_18675__$1;
(statearr_18719_18793[(2)] = null);

(statearr_18719_18793[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (3))){
var inst_18673 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18675__$1,inst_18673);
} else {
if((state_val_18676 === (12))){
var state_18675__$1 = state_18675;
var statearr_18720_18794 = state_18675__$1;
(statearr_18720_18794[(2)] = fuel);

(statearr_18720_18794[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (2))){
var _ = (function (){var statearr_18721 = state_18675;
(statearr_18721[(4)] = cljs.core.cons((5),(state_18675[(4)])));

return statearr_18721;
})();
var inst_18529 = reverse_refs_specs;
var inst_18530 = cljs.core.seq(inst_18529);
var inst_18531 = cljs.core.first(inst_18530);
var inst_18532 = cljs.core.next(inst_18530);
var inst_18533 = inst_18529;
var inst_18534 = null;
var state_18675__$1 = (function (){var statearr_18722 = state_18675;
(statearr_18722[(13)] = inst_18534);

(statearr_18722[(28)] = inst_18531);

(statearr_18722[(29)] = inst_18532);

(statearr_18722[(16)] = inst_18533);

return statearr_18722;
})();
var statearr_18723_18795 = state_18675__$1;
(statearr_18723_18795[(2)] = null);

(statearr_18723_18795[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (23))){
var inst_18553 = (state_18675[(9)]);
var inst_18588 = (state_18675[(18)]);
var inst_18601 = (inst_18588 >= inst_18553);
var state_18675__$1 = state_18675;
var statearr_18724_18796 = state_18675__$1;
(statearr_18724_18796[(2)] = inst_18601);

(statearr_18724_18796[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (47))){
var inst_18555 = (state_18675[(30)]);
var state_18675__$1 = state_18675;
if(cljs.core.truth_(inst_18555)){
var statearr_18725_18797 = state_18675__$1;
(statearr_18725_18797[(1)] = (49));

} else {
var statearr_18726_18798 = state_18675__$1;
(statearr_18726_18798[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (35))){
var inst_18595 = (state_18675[(31)]);
var inst_18619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18620 = [inst_18595];
var inst_18621 = (new cljs.core.PersistentVector(null,1,(5),inst_18619,inst_18620,null));
var inst_18622 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_18621);
var state_18675__$1 = state_18675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18675__$1,(38),inst_18622);
} else {
if((state_val_18676 === (19))){
var inst_18554 = (state_18675[(11)]);
var inst_18656 = (state_18675[(2)]);
var state_18675__$1 = (function (){var statearr_18727 = state_18675;
(statearr_18727[(15)] = inst_18656);

return statearr_18727;
})();
if(cljs.core.truth_(inst_18554)){
var statearr_18728_18799 = state_18675__$1;
(statearr_18728_18799[(1)] = (46));

} else {
var statearr_18729_18800 = state_18675__$1;
(statearr_18729_18800[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (11))){
var inst_18565 = (state_18675[(12)]);
var inst_18562 = (state_18675[(2)]);
var inst_18563 = fluree.db.util.async.throw_err(inst_18562);
var inst_18564 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.s,inst_18563);
var inst_18565__$1 = cljs.core.not_empty(inst_18564);
var state_18675__$1 = (function (){var statearr_18731 = state_18675;
(statearr_18731[(12)] = inst_18565__$1);

return statearr_18731;
})();
if(cljs.core.truth_(inst_18565__$1)){
var statearr_18732_18801 = state_18675__$1;
(statearr_18732_18801[(1)] = (12));

} else {
var statearr_18733_18802 = state_18675__$1;
(statearr_18733_18802[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (9))){
var inst_18550 = (state_18675[(32)]);
var inst_18540 = (state_18675[(24)]);
var inst_18549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18540,(0),null);
var inst_18550__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18540,(1),null);
var inst_18551 = cljs.core.__destructure_map(inst_18550__$1);
var inst_18552 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18551,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_18553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18551,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_18554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18551,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_18555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18551,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_18556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18551,new cljs.core.Keyword(null,"p","p",151049309));
var inst_18557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18558 = [subject_id,inst_18549];
var inst_18559 = (new cljs.core.PersistentVector(null,2,(5),inst_18557,inst_18558,null));
var inst_18560 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_18559);
var state_18675__$1 = (function (){var statearr_18734 = state_18675;
(statearr_18734[(9)] = inst_18553);

(statearr_18734[(32)] = inst_18550__$1);

(statearr_18734[(11)] = inst_18554);

(statearr_18734[(17)] = inst_18556);

(statearr_18734[(8)] = inst_18552);

(statearr_18734[(30)] = inst_18555);

return statearr_18734;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18675__$1,(11),inst_18560);
} else {
if((state_val_18676 === (5))){
var _ = (function (){var statearr_18735 = state_18675;
(statearr_18735[(4)] = cljs.core.rest((state_18675[(4)])));

return statearr_18735;
})();
var state_18675__$1 = state_18675;
var ex18730 = (state_18675__$1[(2)]);
var statearr_18736_18803 = state_18675__$1;
(statearr_18736_18803[(5)] = ex18730);


if((ex18730 instanceof Error)){
var statearr_18737_18804 = state_18675__$1;
(statearr_18737_18804[(1)] = (4));

(statearr_18737_18804[(5)] = null);

} else {
throw ex18730;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (14))){
var inst_18569 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
if(cljs.core.truth_(inst_18569)){
var statearr_18738_18805 = state_18675__$1;
(statearr_18738_18805[(1)] = (15));

} else {
var statearr_18739_18806 = state_18675__$1;
(statearr_18739_18806[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (45))){
var inst_18589 = (state_18675[(10)]);
var inst_18641 = (state_18675[(2)]);
var inst_18642 = fluree.db.util.async.throw_err(inst_18641);
var inst_18643 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18589,inst_18642);
var state_18675__$1 = state_18675;
var statearr_18740_18807 = state_18675__$1;
(statearr_18740_18807[(2)] = inst_18643);

(statearr_18740_18807[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (26))){
var inst_18589 = (state_18675[(10)]);
var state_18675__$1 = state_18675;
var statearr_18741_18808 = state_18675__$1;
(statearr_18741_18808[(2)] = inst_18589);

(statearr_18741_18808[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (16))){
var state_18675__$1 = state_18675;
var statearr_18742_18809 = state_18675__$1;
(statearr_18742_18809[(2)] = null);

(statearr_18742_18809[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (38))){
var inst_18625 = (state_18675[(22)]);
var inst_18550 = (state_18675[(32)]);
var inst_18624 = (state_18675[(2)]);
var inst_18625__$1 = fluree.db.util.async.throw_err(inst_18624);
var inst_18626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18627 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_18628 = (new cljs.core.PersistentVector(null,4,(5),inst_18626,inst_18627,null));
var inst_18629 = cljs.core.select_keys(inst_18550,inst_18628);
var inst_18630 = cljs.core.empty_QMARK_(inst_18625__$1);
var state_18675__$1 = (function (){var statearr_18743 = state_18675;
(statearr_18743[(21)] = inst_18629);

(statearr_18743[(22)] = inst_18625__$1);

return statearr_18743;
})();
if(inst_18630){
var statearr_18744_18810 = state_18675__$1;
(statearr_18744_18810[(1)] = (39));

} else {
var statearr_18745_18811 = state_18675__$1;
(statearr_18745_18811[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (30))){
var inst_18552 = (state_18675[(8)]);
var state_18675__$1 = state_18675;
var statearr_18746_18812 = state_18675__$1;
(statearr_18746_18812[(2)] = inst_18552);

(statearr_18746_18812[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (10))){
var inst_18668 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18747_18813 = state_18675__$1;
(statearr_18747_18813[(2)] = inst_18668);

(statearr_18747_18813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (18))){
var inst_18595 = (state_18675[(31)]);
var inst_18597 = (state_18675[(7)]);
var inst_18587 = (state_18675[(20)]);
var inst_18594 = cljs.core.seq(inst_18587);
var inst_18595__$1 = cljs.core.first(inst_18594);
var inst_18596 = cljs.core.next(inst_18594);
var inst_18597__$1 = cljs.core.not(inst_18595__$1);
var state_18675__$1 = (function (){var statearr_18748 = state_18675;
(statearr_18748[(19)] = inst_18596);

(statearr_18748[(31)] = inst_18595__$1);

(statearr_18748[(7)] = inst_18597__$1);

return statearr_18748;
})();
if(inst_18597__$1){
var statearr_18749_18814 = state_18675__$1;
(statearr_18749_18814[(1)] = (20));

} else {
var statearr_18750_18815 = state_18675__$1;
(statearr_18750_18815[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (42))){
var inst_18625 = (state_18675[(22)]);
var inst_18634 = cljs.core.count(inst_18625);
var inst_18635 = fluree.db.query.fql_resp.add_fuel(fuel,inst_18634,max_fuel);
var state_18675__$1 = state_18675;
var statearr_18751_18816 = state_18675__$1;
(statearr_18751_18816[(2)] = inst_18635);

(statearr_18751_18816[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (37))){
var inst_18650 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18752_18817 = state_18675__$1;
(statearr_18752_18817[(2)] = inst_18650);

(statearr_18752_18817[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (8))){
var inst_18534 = (state_18675[(13)]);
var state_18675__$1 = state_18675;
var statearr_18753_18818 = state_18675__$1;
(statearr_18753_18818[(2)] = inst_18534);

(statearr_18753_18818[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (49))){
var inst_18555 = (state_18675[(30)]);
var state_18675__$1 = state_18675;
var statearr_18754_18819 = state_18675__$1;
(statearr_18754_18819[(2)] = inst_18555);

(statearr_18754_18819[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0 = (function (){
var statearr_18755 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18755[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__);

(statearr_18755[(1)] = (1));

return statearr_18755;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1 = (function (state_18675){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18675);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18756){var ex__2687__auto__ = e18756;
var statearr_18757_18820 = state_18675;
(statearr_18757_18820[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18675[(4)]))){
var statearr_18758_18821 = state_18675;
(statearr_18758_18821[(1)] = cljs.core.first((state_18675[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18822 = state_18675;
state_18675 = G__18822;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__ = function(state_18675){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1.call(this,state_18675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18759 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18759[(6)] = c__2706__auto__);

return statearr_18759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__18824 = arguments.length;
switch (G__18824) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__18826 = null;
var G__18826__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__18826__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__18826__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__18826 = function(result,flake){
switch(arguments.length){
case 0:
return G__18826__0.call(this);
case 1:
return G__18826__1.call(this,result);
case 2:
return G__18826__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18826.cljs$core$IFn$_invoke$arity$0 = G__18826__0;
G__18826.cljs$core$IFn$_invoke$arity$1 = G__18826__1;
G__18826.cljs$core$IFn$_invoke$arity$2 = G__18826__2;
return G__18826;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o(flake);
var recur_pred = fluree.db.flake.p(flake);
var map__18827 = select_spec;
var map__18827__$1 = cljs.core.__destructure_map(map__18827);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18827__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18827__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18941){
var state_val_18942 = (state_18941[(1)]);
if((state_val_18942 === (7))){
var inst_18853 = flakes;
var inst_18854 = cljs.core.seq(inst_18853);
var inst_18855 = cljs.core.first(inst_18854);
var inst_18856 = cljs.core.next(inst_18854);
var inst_18857 = cljs.core.PersistentVector.EMPTY;
var inst_18858 = inst_18853;
var inst_18859 = (0);
var inst_18860 = inst_18857;
var state_18941__$1 = (function (){var statearr_18943 = state_18941;
(statearr_18943[(7)] = inst_18858);

(statearr_18943[(8)] = inst_18860);

(statearr_18943[(9)] = inst_18856);

(statearr_18943[(10)] = inst_18859);

(statearr_18943[(11)] = inst_18855);

return statearr_18943;
})();
var statearr_18944_19010 = state_18941__$1;
(statearr_18944_19010[(2)] = null);

(statearr_18944_19010[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (20))){
var state_18941__$1 = state_18941;
var statearr_18945_19011 = state_18941__$1;
(statearr_18945_19011[(2)] = results);

(statearr_18945_19011[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (27))){
var state_18941__$1 = state_18941;
var statearr_18946_19012 = state_18941__$1;
(statearr_18946_19012[(2)] = null);

(statearr_18946_19012[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (1))){
var state_18941__$1 = state_18941;
var statearr_18947_19013 = state_18941__$1;
(statearr_18947_19013[(2)] = null);

(statearr_18947_19013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (24))){
var state_18941__$1 = state_18941;
var statearr_18948_19014 = state_18941__$1;
(statearr_18948_19014[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (39))){
var inst_18860 = (state_18941[(8)]);
var inst_18922 = (state_18941[(12)]);
var inst_18867 = (state_18941[(13)]);
var inst_18925 = (state_18941[(2)]);
var inst_18926 = fluree.db.util.async.throw_err(inst_18925);
var inst_18927 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18860,inst_18926);
var inst_18858 = inst_18867;
var inst_18859 = inst_18922;
var inst_18860__$1 = inst_18927;
var state_18941__$1 = (function (){var statearr_18950 = state_18941;
(statearr_18950[(7)] = inst_18858);

(statearr_18950[(8)] = inst_18860__$1);

(statearr_18950[(10)] = inst_18859);

return statearr_18950;
})();
var statearr_18951_19015 = state_18941__$1;
(statearr_18951_19015[(2)] = null);

(statearr_18951_19015[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (4))){
var inst_18828 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
var statearr_18952_19016 = state_18941__$1;
(statearr_18952_19016[(2)] = inst_18828);

(statearr_18952_19016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (15))){
var inst_18841 = (state_18941[(14)]);
var state_18941__$1 = state_18941;
var statearr_18953_19017 = state_18941__$1;
(statearr_18953_19017[(2)] = inst_18841);

(statearr_18953_19017[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (21))){
var inst_18837 = (state_18941[(15)]);
var state_18941__$1 = state_18941;
if(cljs.core.truth_(inst_18837)){
var statearr_18954_19018 = state_18941__$1;
(statearr_18954_19018[(1)] = (23));

} else {
var statearr_18955_19019 = state_18941__$1;
(statearr_18955_19019[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (31))){
var inst_18905 = (state_18941[(16)]);
var state_18941__$1 = state_18941;
var statearr_18956_19020 = state_18941__$1;
(statearr_18956_19020[(2)] = inst_18905);

(statearr_18956_19020[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (32))){
var inst_18897 = (state_18941[(17)]);
var inst_18911 = (state_18941[(2)]);
var state_18941__$1 = (function (){var statearr_18957 = state_18941;
(statearr_18957[(18)] = inst_18911);

return statearr_18957;
})();
if(cljs.core.truth_(inst_18897)){
var statearr_18958_19021 = state_18941__$1;
(statearr_18958_19021[(1)] = (33));

} else {
var statearr_18959_19022 = state_18941__$1;
(statearr_18959_19022[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (33))){
var inst_18897 = (state_18941[(17)]);
var state_18941__$1 = state_18941;
var statearr_18960_19023 = state_18941__$1;
(statearr_18960_19023[(2)] = inst_18897);

(statearr_18960_19023[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (13))){
var inst_18877 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
if(cljs.core.truth_(inst_18877)){
var statearr_18962_19024 = state_18941__$1;
(statearr_18962_19024[(1)] = (17));

} else {
var statearr_18963_19025 = state_18941__$1;
(statearr_18963_19025[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (22))){
var inst_18894 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
var statearr_18964_19026 = state_18941__$1;
(statearr_18964_19026[(2)] = inst_18894);

(statearr_18964_19026[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (36))){
var inst_18860 = (state_18941[(8)]);
var inst_18859 = (state_18941[(10)]);
var inst_18867 = (state_18941[(13)]);
var inst_18919 = (inst_18859 + (1));
var tmp18961 = inst_18860;
var inst_18858 = inst_18867;
var inst_18859__$1 = inst_18919;
var inst_18860__$1 = tmp18961;
var state_18941__$1 = (function (){var statearr_18965 = state_18941;
(statearr_18965[(7)] = inst_18858);

(statearr_18965[(8)] = inst_18860__$1);

(statearr_18965[(10)] = inst_18859__$1);

return statearr_18965;
})();
var statearr_18966_19027 = state_18941__$1;
(statearr_18966_19027[(2)] = null);

(statearr_18966_19027[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (29))){
var inst_18904 = (state_18941[(2)]);
var inst_18905 = fluree.db.util.async.throw_err(inst_18904);
var state_18941__$1 = (function (){var statearr_18967 = state_18941;
(statearr_18967[(16)] = inst_18905);

return statearr_18967;
})();
if(cljs.core.truth_(fuel)){
var statearr_18968_19028 = state_18941__$1;
(statearr_18968_19028[(1)] = (30));

} else {
var statearr_18969_19029 = state_18941__$1;
(statearr_18969_19029[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (6))){
var state_18941__$1 = state_18941;
var statearr_18970_19030 = state_18941__$1;
(statearr_18970_19030[(2)] = results);

(statearr_18970_19030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (28))){
var inst_18890 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
var statearr_18971_19031 = state_18941__$1;
(statearr_18971_19031[(2)] = inst_18890);

(statearr_18971_19031[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (25))){
var inst_18892 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
var statearr_18972_19032 = state_18941__$1;
(statearr_18972_19032[(2)] = inst_18892);

(statearr_18972_19032[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (34))){
var inst_18911 = (state_18941[(18)]);
var inst_18914 = cljs.core.empty_QMARK_(inst_18911);
var state_18941__$1 = state_18941;
var statearr_18973_19033 = state_18941__$1;
(statearr_18973_19033[(2)] = inst_18914);

(statearr_18973_19033[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (17))){
var inst_18860 = (state_18941[(8)]);
var inst_18879 = cljs.core.empty_QMARK_(inst_18860);
var state_18941__$1 = state_18941;
if(inst_18879){
var statearr_18974_19034 = state_18941__$1;
(statearr_18974_19034[(1)] = (20));

} else {
var statearr_18975_19035 = state_18941__$1;
(statearr_18975_19035[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (3))){
var inst_18939 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18941__$1,inst_18939);
} else {
if((state_val_18942 === (12))){
var inst_18841 = (state_18941[(14)]);
var state_18941__$1 = state_18941;
if(cljs.core.truth_(inst_18841)){
var statearr_18976_19036 = state_18941__$1;
(statearr_18976_19036[(1)] = (14));

} else {
var statearr_18977_19037 = state_18941__$1;
(statearr_18977_19037[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (2))){
var _ = (function (){var statearr_18978 = state_18941;
(statearr_18978[(4)] = cljs.core.cons((5),(state_18941[(4)])));

return statearr_18978;
})();
var inst_18835 = select_spec;
var inst_18836 = cljs.core.__destructure_map(inst_18835);
var inst_18837 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18836,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_18838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18836,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_18839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18836,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_18840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18836,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_18841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18836,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_18842 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_18843 = (inst_18840 > inst_18842);
var state_18941__$1 = (function (){var statearr_18979 = state_18941;
(statearr_18979[(19)] = inst_18839);

(statearr_18979[(20)] = inst_18838);

(statearr_18979[(15)] = inst_18837);

(statearr_18979[(14)] = inst_18841);

return statearr_18979;
})();
if(cljs.core.truth_(inst_18843)){
var statearr_18980_19038 = state_18941__$1;
(statearr_18980_19038[(1)] = (6));

} else {
var statearr_18981_19039 = state_18941__$1;
(statearr_18981_19039[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (23))){
var inst_18860 = (state_18941[(8)]);
var inst_18838 = (state_18941[(20)]);
var inst_18883 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_18838,inst_18860);
var state_18941__$1 = state_18941;
var statearr_18982_19040 = state_18941__$1;
(statearr_18982_19040[(2)] = inst_18883);

(statearr_18982_19040[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (35))){
var inst_18866 = (state_18941[(21)]);
var inst_18916 = (state_18941[(2)]);
var inst_18917 = fluree.db.query.fql_resp.recur_select_spec(select_spec,inst_18866);
var state_18941__$1 = (function (){var statearr_18983 = state_18941;
(statearr_18983[(22)] = inst_18917);

return statearr_18983;
})();
if(cljs.core.truth_(inst_18916)){
var statearr_18984_19041 = state_18941__$1;
(statearr_18984_19041[(1)] = (36));

} else {
var statearr_18985_19042 = state_18941__$1;
(statearr_18985_19042[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (19))){
var inst_18932 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
var statearr_18986_19043 = state_18941__$1;
(statearr_18986_19043[(2)] = inst_18932);

(statearr_18986_19043[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (11))){
var inst_18868 = (state_18941[(23)]);
var state_18941__$1 = state_18941;
var statearr_18988_19044 = state_18941__$1;
(statearr_18988_19044[(2)] = inst_18868);

(statearr_18988_19044[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (9))){
var inst_18858 = (state_18941[(7)]);
var inst_18868 = (state_18941[(23)]);
var inst_18866 = (state_18941[(21)]);
var inst_18865 = cljs.core.seq(inst_18858);
var inst_18866__$1 = cljs.core.first(inst_18865);
var inst_18867 = cljs.core.next(inst_18865);
var inst_18868__$1 = cljs.core.not(inst_18866__$1);
var state_18941__$1 = (function (){var statearr_18989 = state_18941;
(statearr_18989[(13)] = inst_18867);

(statearr_18989[(23)] = inst_18868__$1);

(statearr_18989[(21)] = inst_18866__$1);

return statearr_18989;
})();
if(inst_18868__$1){
var statearr_18990_19045 = state_18941__$1;
(statearr_18990_19045[(1)] = (11));

} else {
var statearr_18991_19046 = state_18941__$1;
(statearr_18991_19046[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (5))){
var _ = (function (){var statearr_18992 = state_18941;
(statearr_18992[(4)] = cljs.core.rest((state_18941[(4)])));

return statearr_18992;
})();
var state_18941__$1 = state_18941;
var ex18987 = (state_18941__$1[(2)]);
var statearr_18993_19047 = state_18941__$1;
(statearr_18993_19047[(5)] = ex18987);


if((ex18987 instanceof Error)){
var statearr_18994_19048 = state_18941__$1;
(statearr_18994_19048[(1)] = (4));

(statearr_18994_19048[(5)] = null);

} else {
throw ex18987;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (14))){
var inst_18859 = (state_18941[(10)]);
var inst_18841 = (state_18941[(14)]);
var inst_18872 = (inst_18859 < inst_18841);
var state_18941__$1 = state_18941;
var statearr_18995_19049 = state_18941__$1;
(statearr_18995_19049[(2)] = inst_18872);

(statearr_18995_19049[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (26))){
var inst_18860 = (state_18941[(8)]);
var inst_18838 = (state_18941[(20)]);
var inst_18886 = cljs.core.first(inst_18860);
var inst_18887 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_18838,inst_18886);
var state_18941__$1 = state_18941;
var statearr_18996_19050 = state_18941__$1;
(statearr_18996_19050[(2)] = inst_18887);

(statearr_18996_19050[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (16))){
var inst_18875 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
var statearr_18997_19051 = state_18941__$1;
(statearr_18997_19051[(2)] = inst_18875);

(statearr_18997_19051[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (38))){
var inst_18930 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
var statearr_18998_19052 = state_18941__$1;
(statearr_18998_19052[(2)] = inst_18930);

(statearr_18998_19052[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (30))){
var inst_18905 = (state_18941[(16)]);
var inst_18907 = fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_18908 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_18907,inst_18905);
var state_18941__$1 = state_18941;
var statearr_18999_19053 = state_18941__$1;
(statearr_18999_19053[(2)] = inst_18908);

(statearr_18999_19053[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (10))){
var inst_18934 = (state_18941[(2)]);
var state_18941__$1 = state_18941;
var statearr_19000_19054 = state_18941__$1;
(statearr_19000_19054[(2)] = inst_18934);

(statearr_19000_19054[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18942 === (18))){
var inst_18839 = (state_18941[(19)]);
var inst_18866 = (state_18941[(21)]);
var inst_18896 = fluree.db.flake.o(inst_18866);
var inst_18897 = cljs.core.contains_QMARK_(inst_18839,inst_18896);
var inst_18899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18900 = [inst_18896];
var inst_18901 = (new cljs.core.PersistentVector(null,1,(5),inst_18899,inst_18900,null));
var inst_18902 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_18901);
var state_18941__$1 = (function (){var statearr_19001 = state_18941;
(statearr_19001[(17)] = inst_18897);

return statearr_19001;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18941__$1,(29),inst_18902);
} else {
if((state_val_18942 === (37))){
var inst_18859 = (state_18941[(10)]);
var inst_18917 = (state_18941[(22)]);
var inst_18911 = (state_18941[(18)]);
var inst_18922 = (inst_18859 + (1));
var inst_18923 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$7(db,cache,fuel,max_fuel,inst_18917,opts,inst_18911) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_18917,opts,inst_18911));
var state_18941__$1 = (function (){var statearr_19002 = state_18941;
(statearr_19002[(12)] = inst_18922);

return statearr_19002;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18941__$1,(39),inst_18923);
} else {
if((state_val_18942 === (8))){
var inst_18936 = (state_18941[(2)]);
var _ = (function (){var statearr_19003 = state_18941;
(statearr_19003[(4)] = cljs.core.rest((state_18941[(4)])));

return statearr_19003;
})();
var state_18941__$1 = state_18941;
var statearr_19004_19055 = state_18941__$1;
(statearr_19004_19055[(2)] = inst_18936);

(statearr_19004_19055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0 = (function (){
var statearr_19005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19005[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__);

(statearr_19005[(1)] = (1));

return statearr_19005;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1 = (function (state_18941){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18941);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19006){var ex__2687__auto__ = e19006;
var statearr_19007_19056 = state_18941;
(statearr_19007_19056[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18941[(4)]))){
var statearr_19008_19057 = state_18941;
(statearr_19008_19057[(1)] = cljs.core.first((state_18941[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19058 = state_18941;
state_18941 = G__19058;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__ = function(state_18941){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1.call(this,state_18941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19009 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19009[(6)] = c__2706__auto__);

return statearr_19009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19499){
var state_val_19500 = (state_19499[(1)]);
if((state_val_19500 === (121))){
var inst_19422 = (state_19499[(2)]);
var inst_19423 = fluree.db.util.async.throw_err(inst_19422);
var inst_19424 = cljs.core.seq(inst_19423);
var state_19499__$1 = state_19499;
if(inst_19424){
var statearr_19501_19714 = state_19499__$1;
(statearr_19501_19714[(1)] = (122));

} else {
var statearr_19502_19715 = state_19499__$1;
(statearr_19502_19715[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (65))){
var inst_19215 = (state_19499[(7)]);
var inst_19214 = (state_19499[(2)]);
var inst_19215__$1 = fluree.db.util.async.throw_err(inst_19214);
var inst_19216 = cljs.core.seq(inst_19215__$1);
var state_19499__$1 = (function (){var statearr_19503 = state_19499;
(statearr_19503[(7)] = inst_19215__$1);

return statearr_19503;
})();
if(inst_19216){
var statearr_19504_19716 = state_19499__$1;
(statearr_19504_19716[(1)] = (66));

} else {
var statearr_19505_19717 = state_19499__$1;
(statearr_19505_19717[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (70))){
var inst_19215 = (state_19499[(7)]);
var inst_19226 = cljs.core.count(inst_19215);
var inst_19227 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_19226);
var state_19499__$1 = state_19499;
var statearr_19506_19718 = state_19499__$1;
(statearr_19506_19718[(2)] = inst_19227);

(statearr_19506_19718[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (62))){
var inst_19205 = (state_19499[(8)]);
var inst_19208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19209 = fluree.db.flake.o(inst_19205);
var inst_19210 = [inst_19209];
var inst_19211 = (new cljs.core.PersistentVector(null,1,(5),inst_19208,inst_19210,null));
var inst_19212 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19211);
var state_19499__$1 = state_19499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19499__$1,(65),inst_19212);
} else {
if((state_val_19500 === (74))){
var inst_19199 = (state_19499[(9)]);
var state_19499__$1 = state_19499;
var statearr_19507_19719 = state_19499__$1;
(statearr_19507_19719[(2)] = inst_19199);

(statearr_19507_19719[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (110))){
var inst_19384 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_19385 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_19384);
var inst_19386 = inst_19385 === true;
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19386)){
var statearr_19508_19720 = state_19499__$1;
(statearr_19508_19720[(1)] = (113));

} else {
var statearr_19509_19721 = state_19499__$1;
(statearr_19509_19721[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (130))){
var inst_19494 = (state_19499[(2)]);
var _ = (function (){var statearr_19510 = state_19499;
(statearr_19510[(4)] = cljs.core.rest((state_19499[(4)])));

return statearr_19510;
})();
var state_19499__$1 = state_19499;
var statearr_19511_19722 = state_19499__$1;
(statearr_19511_19722[(2)] = inst_19494);

(statearr_19511_19722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (128))){
var inst_19469 = (state_19499[(10)]);
var inst_19472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19473 = [acc,inst_19469];
var inst_19474 = (new cljs.core.PersistentVector(null,2,(5),inst_19472,inst_19473,null));
var state_19499__$1 = state_19499;
var statearr_19512_19723 = state_19499__$1;
(statearr_19512_19723[(2)] = inst_19474);

(statearr_19512_19723[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (7))){
var inst_19072 = (state_19499[(11)]);
var state_19499__$1 = state_19499;
var statearr_19513_19724 = state_19499__$1;
(statearr_19513_19724[(2)] = inst_19072);

(statearr_19513_19724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (59))){
var inst_19463 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19514_19725 = state_19499__$1;
(statearr_19514_19725[(2)] = inst_19463);

(statearr_19514_19725[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (86))){
var inst_19293 = (state_19499[(12)]);
var inst_19293__$1 = (state_19499[(2)]);
var state_19499__$1 = (function (){var statearr_19515 = state_19499;
(statearr_19515[(12)] = inst_19293__$1);

return statearr_19515;
})();
if(cljs.core.truth_(inst_19293__$1)){
var statearr_19516_19726 = state_19499__$1;
(statearr_19516_19726[(1)] = (88));

} else {
var statearr_19517_19727 = state_19499__$1;
(statearr_19517_19727[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (20))){
var inst_19113 = (state_19499[(13)]);
var inst_19114 = (state_19499[(14)]);
var inst_19101 = (state_19499[(15)]);
var inst_19112 = (state_19499[(2)]);
var inst_19113__$1 = cljs.core.__destructure_map(inst_19101);
var inst_19114__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19113__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_19115 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19113__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_19116 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19113__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_19117 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19113__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_19118 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19113__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_19119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19113__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_19499__$1 = (function (){var statearr_19518 = state_19499;
(statearr_19518[(16)] = inst_19118);

(statearr_19518[(13)] = inst_19113__$1);

(statearr_19518[(17)] = inst_19116);

(statearr_19518[(18)] = inst_19112);

(statearr_19518[(14)] = inst_19114__$1);

(statearr_19518[(19)] = inst_19119);

(statearr_19518[(20)] = inst_19115);

(statearr_19518[(21)] = inst_19117);

return statearr_19518;
})();
if(cljs.core.truth_(inst_19114__$1)){
var statearr_19519_19728 = state_19499__$1;
(statearr_19519_19728[(1)] = (24));

} else {
var statearr_19520_19729 = state_19499__$1;
(statearr_19520_19729[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (72))){
var inst_19224 = (state_19499[(22)]);
var inst_19230 = (state_19499[(2)]);
var inst_19231 = cljs.core.seq(inst_19224);
var state_19499__$1 = (function (){var statearr_19521 = state_19499;
(statearr_19521[(23)] = inst_19230);

return statearr_19521;
})();
if(inst_19231){
var statearr_19522_19730 = state_19499__$1;
(statearr_19522_19730[(1)] = (73));

} else {
var statearr_19523_19731 = state_19499__$1;
(statearr_19523_19731[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (58))){
var inst_19101 = (state_19499[(15)]);
var inst_19246 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_19101);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19246)){
var statearr_19524_19732 = state_19499__$1;
(statearr_19524_19732[(1)] = (76));

} else {
var statearr_19525_19733 = state_19499__$1;
(statearr_19525_19733[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (60))){
var inst_19198 = (state_19499[(24)]);
var inst_19205 = (state_19499[(8)]);
var inst_19204 = cljs.core.seq(inst_19198);
var inst_19205__$1 = cljs.core.first(inst_19204);
var inst_19206 = cljs.core.next(inst_19204);
var state_19499__$1 = (function (){var statearr_19526 = state_19499;
(statearr_19526[(8)] = inst_19205__$1);

(statearr_19526[(25)] = inst_19206);

return statearr_19526;
})();
if(cljs.core.truth_(inst_19205__$1)){
var statearr_19527_19734 = state_19499__$1;
(statearr_19527_19734[(1)] = (62));

} else {
var statearr_19528_19735 = state_19499__$1;
(statearr_19528_19735[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (27))){
var inst_19118 = (state_19499[(16)]);
var inst_19122 = (state_19499[(26)]);
var inst_19122__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_19118);
var state_19499__$1 = (function (){var statearr_19529 = state_19499;
(statearr_19529[(26)] = inst_19122__$1);

return statearr_19529;
})();
if(inst_19122__$1){
var statearr_19530_19736 = state_19499__$1;
(statearr_19530_19736[(1)] = (30));

} else {
var statearr_19531_19737 = state_19499__$1;
(statearr_19531_19737[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (1))){
var state_19499__$1 = state_19499;
var statearr_19532_19738 = state_19499__$1;
(statearr_19532_19738[(2)] = null);

(statearr_19532_19738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (69))){
var inst_19220 = (state_19499[(2)]);
var inst_19221 = fluree.db.util.async.throw_err(inst_19220);
var state_19499__$1 = state_19499;
var statearr_19533_19739 = state_19499__$1;
(statearr_19533_19739[(2)] = inst_19221);

(statearr_19533_19739[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (101))){
var inst_19377 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19534_19740 = state_19499__$1;
(statearr_19534_19740[(2)] = inst_19377);

(statearr_19534_19740[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (24))){
var inst_19118 = (state_19499[(16)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19118)){
var statearr_19535_19741 = state_19499__$1;
(statearr_19535_19741[(1)] = (27));

} else {
var statearr_19536_19742 = state_19499__$1;
(statearr_19536_19742[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (102))){
var inst_19349 = (state_19499[(27)]);
var inst_19348 = (state_19499[(2)]);
var inst_19349__$1 = fluree.db.util.async.throw_err(inst_19348);
var inst_19350 = cljs.core.empty_QMARK_(inst_19349__$1);
var state_19499__$1 = (function (){var statearr_19537 = state_19499;
(statearr_19537[(27)] = inst_19349__$1);

return statearr_19537;
})();
if(inst_19350){
var statearr_19538_19743 = state_19499__$1;
(statearr_19538_19743[(1)] = (103));

} else {
var statearr_19539_19744 = state_19499__$1;
(statearr_19539_19744[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (135))){
var state_19499__$1 = state_19499;
var statearr_19540_19745 = state_19499__$1;
(statearr_19540_19745[(2)] = null);

(statearr_19540_19745[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (55))){
var inst_19101 = (state_19499[(15)]);
var inst_19174 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_19101);
var state_19499__$1 = state_19499;
var statearr_19541_19746 = state_19499__$1;
(statearr_19541_19746[(2)] = inst_19174);

(statearr_19541_19746[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (85))){
var inst_19268 = (state_19499[(28)]);
var inst_19101 = (state_19499[(15)]);
var inst_19280 = fluree.db.flake.o(inst_19268);
var inst_19281 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_19101);
var inst_19282 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_19280,inst_19281);
var state_19499__$1 = state_19499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19499__$1,(87),inst_19282);
} else {
if((state_val_19500 === (39))){
var inst_19149 = (state_19499[(29)]);
var inst_19117 = (state_19499[(21)]);
var inst_19149__$1 = cljs.core.not(inst_19117);
var state_19499__$1 = (function (){var statearr_19542 = state_19499;
(statearr_19542[(29)] = inst_19149__$1);

return statearr_19542;
})();
if(inst_19149__$1){
var statearr_19543_19747 = state_19499__$1;
(statearr_19543_19747[(1)] = (42));

} else {
var statearr_19544_19748 = state_19499__$1;
(statearr_19544_19748[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (88))){
var inst_19293 = (state_19499[(12)]);
var inst_19262 = (state_19499[(30)]);
var inst_19295 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19262,inst_19293);
var state_19499__$1 = state_19499;
var statearr_19545_19749 = state_19499__$1;
(statearr_19545_19749[(2)] = inst_19295);

(statearr_19545_19749[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (46))){
var inst_19116 = (state_19499[(17)]);
var state_19499__$1 = state_19499;
var statearr_19546_19750 = state_19499__$1;
(statearr_19546_19750[(2)] = inst_19116);

(statearr_19546_19750[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (4))){
var inst_19061 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19547_19751 = state_19499__$1;
(statearr_19547_19751[(2)] = inst_19061);

(statearr_19547_19751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (77))){
var inst_19308 = (state_19499[(31)]);
var inst_19308__$1 = componentFollow_QMARK_;
var state_19499__$1 = (function (){var statearr_19548 = state_19499;
(statearr_19548[(31)] = inst_19308__$1);

return statearr_19548;
})();
if(cljs.core.truth_(inst_19308__$1)){
var statearr_19549_19752 = state_19499__$1;
(statearr_19549_19752[(1)] = (91));

} else {
var statearr_19550_19753 = state_19499__$1;
(statearr_19550_19753[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (106))){
var inst_19329 = (state_19499[(32)]);
var inst_19363 = (state_19499[(2)]);
var inst_19364 = fluree.db.util.async.throw_err(inst_19363);
var inst_19365 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19329,inst_19364);
var state_19499__$1 = state_19499;
var statearr_19551_19754 = state_19499__$1;
(statearr_19551_19754[(2)] = inst_19365);

(statearr_19551_19754[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (119))){
var inst_19407 = (state_19499[(33)]);
var inst_19437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19438 = [inst_19407,offset_map];
var inst_19439 = (new cljs.core.PersistentVector(null,2,(5),inst_19437,inst_19438,null));
var state_19499__$1 = state_19499;
var statearr_19552_19755 = state_19499__$1;
(statearr_19552_19755[(2)] = inst_19439);

(statearr_19552_19755[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (95))){
var inst_19115 = (state_19499[(20)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19115)){
var statearr_19553_19756 = state_19499__$1;
(statearr_19553_19756[(1)] = (110));

} else {
var statearr_19554_19757 = state_19499__$1;
(statearr_19554_19757[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (54))){
var inst_19171 = (state_19499[(34)]);
var state_19499__$1 = state_19499;
var statearr_19555_19758 = state_19499__$1;
(statearr_19555_19758[(2)] = inst_19171);

(statearr_19555_19758[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (92))){
var inst_19308 = (state_19499[(31)]);
var state_19499__$1 = state_19499;
var statearr_19556_19759 = state_19499__$1;
(statearr_19556_19759[(2)] = inst_19308);

(statearr_19556_19759[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (104))){
var inst_19071 = (state_19499[(35)]);
var inst_19349 = (state_19499[(27)]);
var inst_19358 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_19359 = [true,inst_19071];
var inst_19360 = cljs.core.PersistentHashMap.fromArrays(inst_19358,inst_19359);
var inst_19361 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$7(db,cache,fuel,max_fuel,inst_19360,opts,inst_19349) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_19360,opts,inst_19349));
var state_19499__$1 = state_19499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19499__$1,(106),inst_19361);
} else {
if((state_val_19500 === (15))){
var inst_19071 = (state_19499[(35)]);
var inst_19094 = (state_19499[(36)]);
var inst_19098 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19094,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_19071);
var state_19499__$1 = state_19499;
var statearr_19557_19760 = state_19499__$1;
(statearr_19557_19760[(2)] = inst_19098);

(statearr_19557_19760[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (48))){
var inst_19165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19166 = [null,offset_map];
var inst_19167 = (new cljs.core.PersistentVector(null,2,(5),inst_19165,inst_19166,null));
var state_19499__$1 = state_19499;
var statearr_19558_19761 = state_19499__$1;
(statearr_19558_19761[(2)] = inst_19167);

(statearr_19558_19761[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (50))){
var inst_19465 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19559_19762 = state_19499__$1;
(statearr_19559_19762[(2)] = inst_19465);

(statearr_19559_19762[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (116))){
var inst_19406 = (state_19499[(37)]);
var inst_19413 = (state_19499[(38)]);
var inst_19412 = cljs.core.seq(inst_19406);
var inst_19413__$1 = cljs.core.first(inst_19412);
var inst_19414 = cljs.core.next(inst_19412);
var state_19499__$1 = (function (){var statearr_19560 = state_19499;
(statearr_19560[(38)] = inst_19413__$1);

(statearr_19560[(39)] = inst_19414);

return statearr_19560;
})();
if(cljs.core.truth_(inst_19413__$1)){
var statearr_19561_19763 = state_19499__$1;
(statearr_19561_19763[(1)] = (118));

} else {
var statearr_19562_19764 = state_19499__$1;
(statearr_19562_19764[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (75))){
var inst_19206 = (state_19499[(25)]);
var inst_19236 = (state_19499[(2)]);
var inst_19198 = inst_19206;
var inst_19199 = inst_19236;
var state_19499__$1 = (function (){var statearr_19563 = state_19499;
(statearr_19563[(24)] = inst_19198);

(statearr_19563[(9)] = inst_19199);

return statearr_19563;
})();
var statearr_19564_19765 = state_19499__$1;
(statearr_19564_19765[(2)] = null);

(statearr_19564_19765[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (99))){
var inst_19101 = (state_19499[(15)]);
var inst_19335 = (state_19499[(40)]);
var inst_19338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19339 = fluree.db.flake.o(inst_19335);
var inst_19340 = [inst_19339];
var inst_19341 = (new cljs.core.PersistentVector(null,1,(5),inst_19338,inst_19340,null));
var inst_19342 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_19343 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_19101);
var inst_19344 = [inst_19343];
var inst_19345 = cljs.core.PersistentHashMap.fromArrays(inst_19342,inst_19344);
var inst_19346 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19341,inst_19345);
var state_19499__$1 = state_19499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19499__$1,(102),inst_19346);
} else {
if((state_val_19500 === (21))){
var inst_19105 = (state_19499[(41)]);
var state_19499__$1 = state_19499;
var statearr_19565_19766 = state_19499__$1;
(statearr_19565_19766[(2)] = inst_19105);

(statearr_19565_19766[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (31))){
var inst_19122 = (state_19499[(26)]);
var state_19499__$1 = state_19499;
var statearr_19566_19767 = state_19499__$1;
(statearr_19566_19767[(2)] = inst_19122);

(statearr_19566_19767[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (113))){
var inst_19118 = (state_19499[(16)]);
var inst_19071 = (state_19499[(35)]);
var inst_19113 = (state_19499[(13)]);
var inst_19116 = (state_19499[(17)]);
var inst_19112 = (state_19499[(18)]);
var inst_19114 = (state_19499[(14)]);
var inst_19119 = (state_19499[(19)]);
var inst_19101 = (state_19499[(15)]);
var inst_19086 = (state_19499[(42)]);
var inst_19115 = (state_19499[(20)]);
var inst_19117 = (state_19499[(21)]);
var inst_19388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19389 = (function (){var p = inst_19119;
var pred_spec__$1 = inst_19086;
var orderBy = inst_19117;
var multi_QMARK_ = inst_19114;
var limit = inst_19116;
var offset = inst_19118;
var k = inst_19112;
var compact_QMARK_ = inst_19071;
var pred_spec_SINGLEQUOTE_ = inst_19101;
var ref_QMARK_ = inst_19115;
var map__19067 = inst_19113;
return (function (p1__19059_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o(p1__19059_SHARP_)]);
});
})();
var inst_19390 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_19389,flakes);
var inst_19391 = [inst_19390,offset_map];
var inst_19392 = (new cljs.core.PersistentVector(null,2,(5),inst_19388,inst_19391,null));
var state_19499__$1 = state_19499;
var statearr_19567_19768 = state_19499__$1;
(statearr_19567_19768[(2)] = inst_19392);

(statearr_19567_19768[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (32))){
var inst_19128 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19568_19769 = state_19499__$1;
(statearr_19568_19769[(2)] = inst_19128);

(statearr_19568_19769[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (136))){
var inst_19490 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19569_19770 = state_19499__$1;
(statearr_19569_19770[(2)] = inst_19490);

(statearr_19569_19770[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (40))){
var inst_19114 = (state_19499[(14)]);
var state_19499__$1 = state_19499;
var statearr_19570_19771 = state_19499__$1;
(statearr_19570_19771[(2)] = inst_19114);

(statearr_19570_19771[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (129))){
var inst_19114 = (state_19499[(14)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19114)){
var statearr_19571_19772 = state_19499__$1;
(statearr_19571_19772[(1)] = (131));

} else {
var statearr_19572_19773 = state_19499__$1;
(statearr_19572_19773[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (91))){
var inst_19101 = (state_19499[(15)]);
var inst_19310 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_19101);
var state_19499__$1 = state_19499;
var statearr_19573_19774 = state_19499__$1;
(statearr_19573_19774[(2)] = inst_19310);

(statearr_19573_19774[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (117))){
var inst_19443 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19574_19775 = state_19499__$1;
(statearr_19574_19775[(2)] = inst_19443);

(statearr_19574_19775[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (108))){
var state_19499__$1 = state_19499;
var statearr_19575_19776 = state_19499__$1;
(statearr_19575_19776[(2)] = null);

(statearr_19575_19776[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (56))){
var inst_19176 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19576_19777 = state_19499__$1;
(statearr_19576_19777[(2)] = inst_19176);

(statearr_19576_19777[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (33))){
var inst_19119 = (state_19499[(19)]);
var inst_19136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_19119);
var state_19499__$1 = (function (){var statearr_19577 = state_19499;
(statearr_19577[(43)] = inst_19136);

return statearr_19577;
})();
if(cljs.core.truth_(inst_19137)){
var statearr_19578_19778 = state_19499__$1;
(statearr_19578_19778[(1)] = (36));

} else {
var statearr_19579_19779 = state_19499__$1;
(statearr_19579_19779[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (13))){
var inst_19086 = (state_19499[(42)]);
var state_19499__$1 = state_19499;
var statearr_19580_19780 = state_19499__$1;
(statearr_19580_19780[(2)] = inst_19086);

(statearr_19580_19780[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (22))){
var inst_19101 = (state_19499[(15)]);
var inst_19108 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_19101);
var state_19499__$1 = state_19499;
var statearr_19581_19781 = state_19499__$1;
(statearr_19581_19781[(2)] = inst_19108);

(statearr_19581_19781[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (90))){
var inst_19269 = (state_19499[(44)]);
var inst_19298 = (state_19499[(2)]);
var inst_19261 = inst_19269;
var inst_19262 = inst_19298;
var state_19499__$1 = (function (){var statearr_19582 = state_19499;
(statearr_19582[(45)] = inst_19261);

(statearr_19582[(30)] = inst_19262);

return statearr_19582;
})();
var statearr_19583_19782 = state_19499__$1;
(statearr_19583_19782[(2)] = null);

(statearr_19583_19782[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (109))){
var inst_19336 = (state_19499[(46)]);
var inst_19367 = (state_19499[(47)]);
var inst_19373 = (state_19499[(2)]);
var inst_19328 = inst_19336;
var inst_19329 = inst_19367;
var state_19499__$1 = (function (){var statearr_19584 = state_19499;
(statearr_19584[(32)] = inst_19329);

(statearr_19584[(48)] = inst_19373);

(statearr_19584[(49)] = inst_19328);

return statearr_19584;
})();
var statearr_19585_19783 = state_19499__$1;
(statearr_19585_19783[(2)] = null);

(statearr_19585_19783[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (36))){
var inst_19119 = (state_19499[(19)]);
var inst_19139 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_19119,cljs.core.dec);
var state_19499__$1 = state_19499;
var statearr_19586_19784 = state_19499__$1;
(statearr_19586_19784[(2)] = inst_19139);

(statearr_19586_19784[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (41))){
var inst_19163 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19163)){
var statearr_19587_19785 = state_19499__$1;
(statearr_19587_19785[(1)] = (48));

} else {
var statearr_19588_19786 = state_19499__$1;
(statearr_19588_19786[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (118))){
var inst_19413 = (state_19499[(38)]);
var inst_19416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19417 = fluree.db.flake.o(inst_19413);
var inst_19418 = [inst_19417];
var inst_19419 = (new cljs.core.PersistentVector(null,1,(5),inst_19416,inst_19418,null));
var inst_19420 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19419);
var state_19499__$1 = state_19499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19499__$1,(121),inst_19420);
} else {
if((state_val_19500 === (89))){
var inst_19262 = (state_19499[(30)]);
var state_19499__$1 = state_19499;
var statearr_19589_19787 = state_19499__$1;
(statearr_19589_19787[(2)] = inst_19262);

(statearr_19589_19787[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (100))){
var inst_19329 = (state_19499[(32)]);
var state_19499__$1 = state_19499;
var statearr_19590_19788 = state_19499__$1;
(statearr_19590_19788[(2)] = inst_19329);

(statearr_19590_19788[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (131))){
var inst_19469 = (state_19499[(10)]);
var inst_19468 = (state_19499[(50)]);
var inst_19112 = (state_19499[(18)]);
var inst_19477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19478 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_19112,inst_19468);
var inst_19479 = [inst_19478,inst_19469];
var inst_19480 = (new cljs.core.PersistentVector(null,2,(5),inst_19477,inst_19479,null));
var state_19499__$1 = state_19499;
var statearr_19591_19789 = state_19499__$1;
(statearr_19591_19789[(2)] = inst_19480);

(statearr_19591_19789[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (122))){
var inst_19407 = (state_19499[(33)]);
var inst_19413 = (state_19499[(38)]);
var inst_19414 = (state_19499[(39)]);
var inst_19426 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_19427 = fluree.db.flake.o(inst_19413);
var inst_19428 = [inst_19427];
var inst_19429 = cljs.core.PersistentHashMap.fromArrays(inst_19426,inst_19428);
var inst_19430 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19407,inst_19429);
var inst_19406 = inst_19414;
var inst_19407__$1 = inst_19430;
var state_19499__$1 = (function (){var statearr_19592 = state_19499;
(statearr_19592[(37)] = inst_19406);

(statearr_19592[(33)] = inst_19407__$1);

return statearr_19592;
})();
var statearr_19593_19790 = state_19499__$1;
(statearr_19593_19790[(2)] = null);

(statearr_19593_19790[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (43))){
var inst_19149 = (state_19499[(29)]);
var state_19499__$1 = state_19499;
var statearr_19594_19791 = state_19499__$1;
(statearr_19594_19791[(2)] = inst_19149);

(statearr_19594_19791[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (61))){
var inst_19185 = (state_19499[(51)]);
var inst_19242 = (state_19499[(2)]);
var inst_19243 = [inst_19242,offset_map];
var inst_19244 = (new cljs.core.PersistentVector(null,2,(5),inst_19185,inst_19243,null));
var state_19499__$1 = state_19499;
var statearr_19595_19792 = state_19499__$1;
(statearr_19595_19792[(2)] = inst_19244);

(statearr_19595_19792[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (29))){
var inst_19131 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19596_19793 = state_19499__$1;
(statearr_19596_19793[(2)] = inst_19131);

(statearr_19596_19793[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (44))){
var inst_19160 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19597_19794 = state_19499__$1;
(statearr_19597_19794[(2)] = inst_19160);

(statearr_19597_19794[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (93))){
var inst_19313 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19313)){
var statearr_19598_19795 = state_19499__$1;
(statearr_19598_19795[(1)] = (94));

} else {
var statearr_19599_19796 = state_19499__$1;
(statearr_19599_19796[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (6))){
var inst_19074 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_19075 = (inst_19074 == null);
var state_19499__$1 = state_19499;
var statearr_19600_19797 = state_19499__$1;
(statearr_19600_19797[(2)] = inst_19075);

(statearr_19600_19797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (111))){
var state_19499__$1 = state_19499;
var statearr_19601_19798 = state_19499__$1;
(statearr_19601_19798[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (28))){
var inst_19118 = (state_19499[(16)]);
var state_19499__$1 = state_19499;
var statearr_19603_19799 = state_19499__$1;
(statearr_19603_19799[(2)] = inst_19118);

(statearr_19603_19799[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (134))){
var inst_19469 = (state_19499[(10)]);
var inst_19468 = (state_19499[(50)]);
var inst_19112 = (state_19499[(18)]);
var inst_19483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19484 = cljs.core.first(inst_19468);
var inst_19485 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_19112,inst_19484);
var inst_19486 = [inst_19485,inst_19469];
var inst_19487 = (new cljs.core.PersistentVector(null,2,(5),inst_19483,inst_19486,null));
var state_19499__$1 = state_19499;
var statearr_19604_19800 = state_19499__$1;
(statearr_19604_19800[(2)] = inst_19487);

(statearr_19604_19800[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (64))){
var inst_19240 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19605_19801 = state_19499__$1;
(statearr_19605_19801[(2)] = inst_19240);

(statearr_19605_19801[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (103))){
var inst_19329 = (state_19499[(32)]);
var inst_19335 = (state_19499[(40)]);
var inst_19352 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_19353 = fluree.db.flake.o(inst_19335);
var inst_19354 = [inst_19353];
var inst_19355 = cljs.core.PersistentHashMap.fromArrays(inst_19352,inst_19354);
var inst_19356 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19329,inst_19355);
var state_19499__$1 = state_19499;
var statearr_19606_19802 = state_19499__$1;
(statearr_19606_19802[(2)] = inst_19356);

(statearr_19606_19802[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (51))){
var inst_19171 = (state_19499[(34)]);
var inst_19101 = (state_19499[(15)]);
var inst_19171__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_19101);
var state_19499__$1 = (function (){var statearr_19607 = state_19499;
(statearr_19607[(34)] = inst_19171__$1);

return statearr_19607;
})();
if(cljs.core.truth_(inst_19171__$1)){
var statearr_19608_19803 = state_19499__$1;
(statearr_19608_19803[(1)] = (54));

} else {
var statearr_19609_19804 = state_19499__$1;
(statearr_19609_19804[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (25))){
var inst_19114 = (state_19499[(14)]);
var state_19499__$1 = state_19499;
var statearr_19610_19805 = state_19499__$1;
(statearr_19610_19805[(2)] = inst_19114);

(statearr_19610_19805[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (34))){
var inst_19114 = (state_19499[(14)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19114)){
var statearr_19611_19806 = state_19499__$1;
(statearr_19611_19806[(1)] = (39));

} else {
var statearr_19612_19807 = state_19499__$1;
(statearr_19612_19807[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (125))){
var inst_19118 = (state_19499[(16)]);
var inst_19071 = (state_19499[(35)]);
var inst_19113 = (state_19499[(13)]);
var inst_19116 = (state_19499[(17)]);
var inst_19112 = (state_19499[(18)]);
var inst_19114 = (state_19499[(14)]);
var inst_19119 = (state_19499[(19)]);
var inst_19101 = (state_19499[(15)]);
var inst_19086 = (state_19499[(42)]);
var inst_19115 = (state_19499[(20)]);
var inst_19117 = (state_19499[(21)]);
var inst_19448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19449 = (function (){var p = inst_19119;
var pred_spec__$1 = inst_19086;
var orderBy = inst_19117;
var multi_QMARK_ = inst_19114;
var limit = inst_19116;
var offset = inst_19118;
var k = inst_19112;
var compact_QMARK_ = inst_19071;
var pred_spec_SINGLEQUOTE_ = inst_19101;
var ref_QMARK_ = inst_19115;
var map__19067 = inst_19113;
return (function (p1__19060_SHARP_){
return fluree.db.flake.o(p1__19060_SHARP_);
});
})();
var inst_19450 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_19449,flakes);
var inst_19451 = [inst_19450,offset_map];
var inst_19452 = (new cljs.core.PersistentVector(null,2,(5),inst_19448,inst_19451,null));
var state_19499__$1 = state_19499;
var statearr_19613_19808 = state_19499__$1;
(statearr_19613_19808[(2)] = inst_19452);

(statearr_19613_19808[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (17))){
var inst_19102 = (state_19499[(52)]);
var inst_19101 = (state_19499[(15)]);
var inst_19101__$1 = (state_19499[(2)]);
var inst_19102__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_19101__$1);
var state_19499__$1 = (function (){var statearr_19614 = state_19499;
(statearr_19614[(52)] = inst_19102__$1);

(statearr_19614[(15)] = inst_19101__$1);

return statearr_19614;
})();
if(cljs.core.truth_(inst_19102__$1)){
var statearr_19615_19809 = state_19499__$1;
(statearr_19615_19809[(1)] = (18));

} else {
var statearr_19616_19810 = state_19499__$1;
(statearr_19616_19810[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (3))){
var inst_19497 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19499__$1,inst_19497);
} else {
if((state_val_19500 === (12))){
var inst_19086 = (state_19499[(42)]);
var inst_19091 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_19086,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_19499__$1 = state_19499;
var statearr_19617_19811 = state_19499__$1;
(statearr_19617_19811[(2)] = inst_19091);

(statearr_19617_19811[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (2))){
var inst_19072 = (state_19499[(11)]);
var _ = (function (){var statearr_19618 = state_19499;
(statearr_19618[(4)] = cljs.core.cons((5),(state_19499[(4)])));

return statearr_19618;
})();
var inst_19071 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_19072__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_19499__$1 = (function (){var statearr_19619 = state_19499;
(statearr_19619[(35)] = inst_19071);

(statearr_19619[(11)] = inst_19072__$1);

return statearr_19619;
})();
if(cljs.core.truth_(inst_19072__$1)){
var statearr_19620_19812 = state_19499__$1;
(statearr_19620_19812[(1)] = (6));

} else {
var statearr_19621_19813 = state_19499__$1;
(statearr_19621_19813[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (66))){
var inst_19184 = (state_19499[(53)]);
var inst_19215 = (state_19499[(7)]);
var inst_19218 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$7(db,cache,fuel,max_fuel,inst_19184,opts,inst_19215) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_19184,opts,inst_19215));
var state_19499__$1 = state_19499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19499__$1,(69),inst_19218);
} else {
if((state_val_19500 === (107))){
var inst_19349 = (state_19499[(27)]);
var inst_19369 = cljs.core.count(inst_19349);
var inst_19370 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_19369);
var state_19499__$1 = state_19499;
var statearr_19622_19814 = state_19499__$1;
(statearr_19622_19814[(2)] = inst_19370);

(statearr_19622_19814[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (23))){
var inst_19110 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19623_19815 = state_19499__$1;
(statearr_19623_19815[(2)] = inst_19110);

(statearr_19623_19815[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (47))){
var inst_19157 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19624_19816 = state_19499__$1;
(statearr_19624_19816[(2)] = inst_19157);

(statearr_19624_19816[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (35))){
var inst_19468 = (state_19499[(50)]);
var inst_19467 = (state_19499[(2)]);
var inst_19468__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19467,(0),null);
var inst_19469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19467,(1),null);
var inst_19470 = cljs.core.empty_QMARK_(inst_19468__$1);
var state_19499__$1 = (function (){var statearr_19625 = state_19499;
(statearr_19625[(10)] = inst_19469);

(statearr_19625[(50)] = inst_19468__$1);

return statearr_19625;
})();
if(inst_19470){
var statearr_19626_19817 = state_19499__$1;
(statearr_19626_19817[(1)] = (128));

} else {
var statearr_19627_19818 = state_19499__$1;
(statearr_19627_19818[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (127))){
var inst_19455 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19628_19819 = state_19499__$1;
(statearr_19628_19819[(2)] = inst_19455);

(statearr_19628_19819[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (82))){
var inst_19262 = (state_19499[(30)]);
var state_19499__$1 = state_19499;
var statearr_19629_19820 = state_19499__$1;
(statearr_19629_19820[(2)] = inst_19262);

(statearr_19629_19820[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (76))){
var inst_19248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19256 = flakes;
var inst_19257 = cljs.core.seq(inst_19256);
var inst_19258 = cljs.core.first(inst_19257);
var inst_19259 = cljs.core.next(inst_19257);
var inst_19260 = cljs.core.PersistentVector.EMPTY;
var inst_19261 = inst_19256;
var inst_19262 = inst_19260;
var state_19499__$1 = (function (){var statearr_19630 = state_19499;
(statearr_19630[(54)] = inst_19258);

(statearr_19630[(45)] = inst_19261);

(statearr_19630[(30)] = inst_19262);

(statearr_19630[(55)] = inst_19259);

(statearr_19630[(56)] = inst_19248);

return statearr_19630;
})();
var statearr_19631_19821 = state_19499__$1;
(statearr_19631_19821[(2)] = null);

(statearr_19631_19821[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (97))){
var inst_19328 = (state_19499[(49)]);
var inst_19335 = (state_19499[(40)]);
var inst_19334 = cljs.core.seq(inst_19328);
var inst_19335__$1 = cljs.core.first(inst_19334);
var inst_19336 = cljs.core.next(inst_19334);
var state_19499__$1 = (function (){var statearr_19632 = state_19499;
(statearr_19632[(46)] = inst_19336);

(statearr_19632[(40)] = inst_19335__$1);

return statearr_19632;
})();
if(cljs.core.truth_(inst_19335__$1)){
var statearr_19633_19822 = state_19499__$1;
(statearr_19633_19822[(1)] = (99));

} else {
var statearr_19634_19823 = state_19499__$1;
(statearr_19634_19823[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (19))){
var inst_19105 = (state_19499[(41)]);
var inst_19101 = (state_19499[(15)]);
var inst_19105__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_19101);
var state_19499__$1 = (function (){var statearr_19635 = state_19499;
(statearr_19635[(41)] = inst_19105__$1);

return statearr_19635;
})();
if(cljs.core.truth_(inst_19105__$1)){
var statearr_19636_19824 = state_19499__$1;
(statearr_19636_19824[(1)] = (21));

} else {
var statearr_19637_19825 = state_19499__$1;
(statearr_19637_19825[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (57))){
var inst_19101 = (state_19499[(15)]);
var inst_19181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19182 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_19183 = (new cljs.core.PersistentVector(null,3,(5),inst_19181,inst_19182,null));
var inst_19184 = cljs.core.select_keys(inst_19101,inst_19183);
var inst_19185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19193 = flakes;
var inst_19194 = cljs.core.seq(inst_19193);
var inst_19195 = cljs.core.first(inst_19194);
var inst_19196 = cljs.core.next(inst_19194);
var inst_19197 = cljs.core.PersistentVector.EMPTY;
var inst_19198 = inst_19193;
var inst_19199 = inst_19197;
var state_19499__$1 = (function (){var statearr_19638 = state_19499;
(statearr_19638[(57)] = inst_19195);

(statearr_19638[(51)] = inst_19185);

(statearr_19638[(24)] = inst_19198);

(statearr_19638[(53)] = inst_19184);

(statearr_19638[(9)] = inst_19199);

(statearr_19638[(58)] = inst_19196);

return statearr_19638;
})();
var statearr_19639_19826 = state_19499__$1;
(statearr_19639_19826[(2)] = null);

(statearr_19639_19826[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (68))){
var inst_19224 = (state_19499[(2)]);
var state_19499__$1 = (function (){var statearr_19640 = state_19499;
(statearr_19640[(22)] = inst_19224);

return statearr_19640;
})();
if(cljs.core.truth_(fuel)){
var statearr_19641_19827 = state_19499__$1;
(statearr_19641_19827[(1)] = (70));

} else {
var statearr_19642_19828 = state_19499__$1;
(statearr_19642_19828[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (11))){
var inst_19086 = (state_19499[(42)]);
var inst_19086__$1 = (state_19499[(2)]);
var inst_19088 = cljs.core.contains_QMARK_(inst_19086__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_19089 = (!(inst_19088));
var state_19499__$1 = (function (){var statearr_19643 = state_19499;
(statearr_19643[(42)] = inst_19086__$1);

return statearr_19643;
})();
if(inst_19089){
var statearr_19644_19829 = state_19499__$1;
(statearr_19644_19829[(1)] = (12));

} else {
var statearr_19645_19830 = state_19499__$1;
(statearr_19645_19830[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (115))){
var inst_19445 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19647_19831 = state_19499__$1;
(statearr_19647_19831[(2)] = inst_19445);

(statearr_19647_19831[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (9))){
var inst_19080 = cljs.core.first(flakes);
var inst_19081 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_19080);
var inst_19082 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_19083 = fluree.db.query.fql_resp.wildcard_pred_spec(db,cache,inst_19081,inst_19082);
var state_19499__$1 = state_19499;
var statearr_19648_19832 = state_19499__$1;
(statearr_19648_19832[(2)] = inst_19083);

(statearr_19648_19832[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (5))){
var _ = (function (){var statearr_19649 = state_19499;
(statearr_19649[(4)] = cljs.core.rest((state_19499[(4)])));

return statearr_19649;
})();
var state_19499__$1 = state_19499;
var ex19646 = (state_19499__$1[(2)]);
var statearr_19650_19833 = state_19499__$1;
(statearr_19650_19833[(5)] = ex19646);


if((ex19646 instanceof Error)){
var statearr_19651_19834 = state_19499__$1;
(statearr_19651_19834[(1)] = (4));

(statearr_19651_19834[(5)] = null);

} else {
throw ex19646;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (112))){
var inst_19457 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19652_19835 = state_19499__$1;
(statearr_19652_19835[(2)] = inst_19457);

(statearr_19652_19835[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (83))){
var inst_19302 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19653_19836 = state_19499__$1;
(statearr_19653_19836[(2)] = inst_19302);

(statearr_19653_19836[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (14))){
var inst_19086 = (state_19499[(42)]);
var inst_19094 = (state_19499[(2)]);
var inst_19095 = cljs.core.contains_QMARK_(inst_19086,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_19096 = (!(inst_19095));
var state_19499__$1 = (function (){var statearr_19654 = state_19499;
(statearr_19654[(36)] = inst_19094);

return statearr_19654;
})();
if(inst_19096){
var statearr_19655_19837 = state_19499__$1;
(statearr_19655_19837[(1)] = (15));

} else {
var statearr_19656_19838 = state_19499__$1;
(statearr_19656_19838[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (45))){
var inst_19116 = (state_19499[(17)]);
var inst_19112 = (state_19499[(18)]);
var inst_19152 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_19112);
var inst_19153 = cljs.core.count(inst_19152);
var inst_19154 = (inst_19153 >= inst_19116);
var state_19499__$1 = state_19499;
var statearr_19657_19839 = state_19499__$1;
(statearr_19657_19839[(2)] = inst_19154);

(statearr_19657_19839[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (53))){
var inst_19179 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19179)){
var statearr_19658_19840 = state_19499__$1;
(statearr_19658_19840[(1)] = (57));

} else {
var statearr_19659_19841 = state_19499__$1;
(statearr_19659_19841[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (78))){
var inst_19461 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19660_19842 = state_19499__$1;
(statearr_19660_19842[(2)] = inst_19461);

(statearr_19660_19842[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (132))){
var state_19499__$1 = state_19499;
var statearr_19662_19843 = state_19499__$1;
(statearr_19662_19843[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (26))){
var inst_19134 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19134)){
var statearr_19664_19844 = state_19499__$1;
(statearr_19664_19844[(1)] = (33));

} else {
var statearr_19665_19845 = state_19499__$1;
(statearr_19665_19845[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (123))){
var inst_19407 = (state_19499[(33)]);
var inst_19414 = (state_19499[(39)]);
var tmp19661 = inst_19407;
var inst_19406 = inst_19414;
var inst_19407__$1 = tmp19661;
var state_19499__$1 = (function (){var statearr_19666 = state_19499;
(statearr_19666[(37)] = inst_19406);

(statearr_19666[(33)] = inst_19407__$1);

return statearr_19666;
})();
var statearr_19667_19846 = state_19499__$1;
(statearr_19667_19846[(2)] = null);

(statearr_19667_19846[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (16))){
var inst_19094 = (state_19499[(36)]);
var state_19499__$1 = state_19499;
var statearr_19668_19847 = state_19499__$1;
(statearr_19668_19847[(2)] = inst_19094);

(statearr_19668_19847[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (133))){
var inst_19492 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19669_19848 = state_19499__$1;
(statearr_19669_19848[(2)] = inst_19492);

(statearr_19669_19848[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (81))){
var inst_19277 = (state_19499[(59)]);
var inst_19268 = (state_19499[(28)]);
var inst_19101 = (state_19499[(15)]);
var inst_19271 = cljs.core.deref(cache);
var inst_19272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19273 = fluree.db.flake.o(inst_19268);
var inst_19274 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_19101);
var inst_19275 = [inst_19273,inst_19274];
var inst_19276 = (new cljs.core.PersistentVector(null,2,(5),inst_19272,inst_19275,null));
var inst_19277__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19271,inst_19276);
var state_19499__$1 = (function (){var statearr_19670 = state_19499;
(statearr_19670[(59)] = inst_19277__$1);

return statearr_19670;
})();
if(cljs.core.truth_(inst_19277__$1)){
var statearr_19671_19849 = state_19499__$1;
(statearr_19671_19849[(1)] = (84));

} else {
var statearr_19672_19850 = state_19499__$1;
(statearr_19672_19850[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (120))){
var inst_19441 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19673_19851 = state_19499__$1;
(statearr_19673_19851[(2)] = inst_19441);

(statearr_19673_19851[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (79))){
var inst_19268 = (state_19499[(28)]);
var inst_19261 = (state_19499[(45)]);
var inst_19267 = cljs.core.seq(inst_19261);
var inst_19268__$1 = cljs.core.first(inst_19267);
var inst_19269 = cljs.core.next(inst_19267);
var state_19499__$1 = (function (){var statearr_19674 = state_19499;
(statearr_19674[(28)] = inst_19268__$1);

(statearr_19674[(44)] = inst_19269);

return statearr_19674;
})();
if(cljs.core.truth_(inst_19268__$1)){
var statearr_19675_19852 = state_19499__$1;
(statearr_19675_19852[(1)] = (81));

} else {
var statearr_19676_19853 = state_19499__$1;
(statearr_19676_19853[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (38))){
var inst_19136 = (state_19499[(43)]);
var inst_19144 = (state_19499[(2)]);
var inst_19145 = [null,inst_19144];
var inst_19146 = (new cljs.core.PersistentVector(null,2,(5),inst_19136,inst_19145,null));
var state_19499__$1 = state_19499;
var statearr_19677_19854 = state_19499__$1;
(statearr_19677_19854[(2)] = inst_19146);

(statearr_19677_19854[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (126))){
var state_19499__$1 = state_19499;
var statearr_19678_19855 = state_19499__$1;
(statearr_19678_19855[(2)] = null);

(statearr_19678_19855[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (98))){
var inst_19315 = (state_19499[(60)]);
var inst_19379 = (state_19499[(2)]);
var inst_19380 = [inst_19379,offset_map];
var inst_19381 = (new cljs.core.PersistentVector(null,2,(5),inst_19315,inst_19380,null));
var state_19499__$1 = state_19499;
var statearr_19679_19856 = state_19499__$1;
(statearr_19679_19856[(2)] = inst_19381);

(statearr_19679_19856[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (124))){
var inst_19435 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19680_19857 = state_19499__$1;
(statearr_19680_19857[(2)] = inst_19435);

(statearr_19680_19857[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (87))){
var inst_19268 = (state_19499[(28)]);
var inst_19101 = (state_19499[(15)]);
var inst_19284 = (state_19499[(2)]);
var inst_19285 = fluree.db.util.async.throw_err(inst_19284);
var inst_19286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19287 = fluree.db.flake.o(inst_19268);
var inst_19288 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_19101);
var inst_19289 = [inst_19287,inst_19288];
var inst_19290 = (new cljs.core.PersistentVector(null,2,(5),inst_19286,inst_19289,null));
var inst_19291 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_19290,inst_19285);
var state_19499__$1 = (function (){var statearr_19681 = state_19499;
(statearr_19681[(61)] = inst_19291);

return statearr_19681;
})();
var statearr_19682_19858 = state_19499__$1;
(statearr_19682_19858[(2)] = inst_19285);

(statearr_19682_19858[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (30))){
var inst_19119 = (state_19499[(19)]);
var inst_19124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_19119);
var inst_19125 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_19124);
var state_19499__$1 = state_19499;
var statearr_19683_19859 = state_19499__$1;
(statearr_19683_19859[(2)] = inst_19125);

(statearr_19683_19859[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (73))){
var inst_19199 = (state_19499[(9)]);
var inst_19224 = (state_19499[(22)]);
var inst_19233 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19199,inst_19224);
var state_19499__$1 = state_19499;
var statearr_19684_19860 = state_19499__$1;
(statearr_19684_19860[(2)] = inst_19233);

(statearr_19684_19860[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (96))){
var inst_19459 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
var statearr_19685_19861 = state_19499__$1;
(statearr_19685_19861[(2)] = inst_19459);

(statearr_19685_19861[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (10))){
var state_19499__$1 = state_19499;
var statearr_19686_19862 = state_19499__$1;
(statearr_19686_19862[(2)] = pred_spec);

(statearr_19686_19862[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (18))){
var inst_19102 = (state_19499[(52)]);
var state_19499__$1 = state_19499;
var statearr_19687_19863 = state_19499__$1;
(statearr_19687_19863[(2)] = inst_19102);

(statearr_19687_19863[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (105))){
var inst_19367 = (state_19499[(2)]);
var state_19499__$1 = (function (){var statearr_19688 = state_19499;
(statearr_19688[(47)] = inst_19367);

return statearr_19688;
})();
if(cljs.core.truth_(fuel)){
var statearr_19689_19864 = state_19499__$1;
(statearr_19689_19864[(1)] = (107));

} else {
var statearr_19690_19865 = state_19499__$1;
(statearr_19690_19865[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (52))){
var inst_19169 = (state_19499[(62)]);
var state_19499__$1 = state_19499;
var statearr_19691_19866 = state_19499__$1;
(statearr_19691_19866[(2)] = inst_19169);

(statearr_19691_19866[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (114))){
var inst_19401 = flakes;
var inst_19402 = cljs.core.seq(inst_19401);
var inst_19403 = cljs.core.first(inst_19402);
var inst_19404 = cljs.core.next(inst_19402);
var inst_19405 = cljs.core.PersistentVector.EMPTY;
var inst_19406 = inst_19401;
var inst_19407 = inst_19405;
var state_19499__$1 = (function (){var statearr_19692 = state_19499;
(statearr_19692[(63)] = inst_19404);

(statearr_19692[(64)] = inst_19403);

(statearr_19692[(37)] = inst_19406);

(statearr_19692[(33)] = inst_19407);

return statearr_19692;
})();
var statearr_19693_19867 = state_19499__$1;
(statearr_19693_19867[(2)] = null);

(statearr_19693_19867[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (67))){
var state_19499__$1 = state_19499;
var statearr_19694_19868 = state_19499__$1;
(statearr_19694_19868[(2)] = null);

(statearr_19694_19868[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (71))){
var state_19499__$1 = state_19499;
var statearr_19695_19869 = state_19499__$1;
(statearr_19695_19869[(2)] = null);

(statearr_19695_19869[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (42))){
var inst_19116 = (state_19499[(17)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19116)){
var statearr_19696_19870 = state_19499__$1;
(statearr_19696_19870[(1)] = (45));

} else {
var statearr_19697_19871 = state_19499__$1;
(statearr_19697_19871[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (80))){
var inst_19248 = (state_19499[(56)]);
var inst_19304 = (state_19499[(2)]);
var inst_19305 = [inst_19304,offset_map];
var inst_19306 = (new cljs.core.PersistentVector(null,2,(5),inst_19248,inst_19305,null));
var state_19499__$1 = state_19499;
var statearr_19698_19872 = state_19499__$1;
(statearr_19698_19872[(2)] = inst_19306);

(statearr_19698_19872[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (37))){
var inst_19118 = (state_19499[(16)]);
var inst_19119 = (state_19499[(19)]);
var inst_19141 = (inst_19118 - (1));
var inst_19142 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_19119,inst_19141);
var state_19499__$1 = state_19499;
var statearr_19699_19873 = state_19499__$1;
(statearr_19699_19873[(2)] = inst_19142);

(statearr_19699_19873[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (63))){
var inst_19199 = (state_19499[(9)]);
var state_19499__$1 = state_19499;
var statearr_19700_19874 = state_19499__$1;
(statearr_19700_19874[(2)] = inst_19199);

(statearr_19700_19874[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (94))){
var inst_19315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19323 = flakes;
var inst_19324 = cljs.core.seq(inst_19323);
var inst_19325 = cljs.core.first(inst_19324);
var inst_19326 = cljs.core.next(inst_19324);
var inst_19327 = cljs.core.PersistentVector.EMPTY;
var inst_19328 = inst_19323;
var inst_19329 = inst_19327;
var state_19499__$1 = (function (){var statearr_19701 = state_19499;
(statearr_19701[(32)] = inst_19329);

(statearr_19701[(65)] = inst_19326);

(statearr_19701[(60)] = inst_19315);

(statearr_19701[(66)] = inst_19325);

(statearr_19701[(49)] = inst_19328);

return statearr_19701;
})();
var statearr_19702_19875 = state_19499__$1;
(statearr_19702_19875[(2)] = null);

(statearr_19702_19875[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (8))){
var inst_19078 = (state_19499[(2)]);
var state_19499__$1 = state_19499;
if(cljs.core.truth_(inst_19078)){
var statearr_19703_19876 = state_19499__$1;
(statearr_19703_19876[(1)] = (9));

} else {
var statearr_19704_19877 = state_19499__$1;
(statearr_19704_19877[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (49))){
var inst_19169 = (state_19499[(62)]);
var inst_19169__$1 = cljs.core.not(recur_QMARK_);
var state_19499__$1 = (function (){var statearr_19705 = state_19499;
(statearr_19705[(62)] = inst_19169__$1);

return statearr_19705;
})();
if(inst_19169__$1){
var statearr_19706_19878 = state_19499__$1;
(statearr_19706_19878[(1)] = (51));

} else {
var statearr_19707_19879 = state_19499__$1;
(statearr_19707_19879[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19500 === (84))){
var inst_19277 = (state_19499[(59)]);
var state_19499__$1 = state_19499;
var statearr_19708_19880 = state_19499__$1;
(statearr_19708_19880[(2)] = inst_19277);

(statearr_19708_19880[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____0 = (function (){
var statearr_19709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19709[(0)] = fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__);

(statearr_19709[(1)] = (1));

return statearr_19709;
});
var fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____1 = (function (state_19499){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19499);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19710){var ex__2687__auto__ = e19710;
var statearr_19711_19881 = state_19499;
(statearr_19711_19881[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19499[(4)]))){
var statearr_19712_19882 = state_19499;
(statearr_19712_19882[(1)] = cljs.core.first((state_19499[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19883 = state_19499;
state_19499 = G__19883;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__ = function(state_19499){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____1.call(this,state_19499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$add_pred_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19713 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19713[(6)] = c__2706__auto__);

return statearr_19713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__19885 = res;
var G__19885__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__19884_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__19884_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__19885):G__19885);
var G__19885__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__19885__$1):G__19885__$1);
var G__19885__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__19885__$2):G__19885__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__19885__$3);
} else {
return G__19885__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,p__19886,flakes){
var map__19887 = p__19886;
var map__19887__$1 = cljs.core.__destructure_map(map__19887);
var opts = map__19887__$1;
var parse_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19887__$1,new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20082){
var state_val_20083 = (state_20082[(1)]);
if((state_val_20083 === (7))){
var state_20082__$1 = state_20082;
var statearr_20084_20176 = state_20082__$1;
(statearr_20084_20176[(2)] = null);

(statearr_20084_20176[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (20))){
var inst_19929 = cljs.core.PersistentHashMap.EMPTY;
var state_20082__$1 = state_20082;
var statearr_20085_20177 = state_20082__$1;
(statearr_20085_20177[(2)] = inst_19929);

(statearr_20085_20177[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (27))){
var inst_19948 = (state_20082[(7)]);
var inst_19916 = (state_20082[(8)]);
var inst_19931 = (state_20082[(9)]);
var inst_19909 = (state_20082[(10)]);
var inst_20060 = (state_20082[(2)]);
var inst_20061 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res result:",inst_20060) : fluree.db.util.log.debug.call(null,"flakes->res result:",inst_20060));
var inst_20062 = (function (){var top_level_subject = inst_19909;
var _ = inst_20061;
var select_spec = inst_19916;
var base_acc = inst_19931;
var acc_PLUS_refs = inst_19948;
var result = inst_20060;
return (function (acc,spec){
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res sort-preds acc:",acc) : fluree.db.util.log.debug.call(null,"flakes->res sort-preds acc:",acc));

if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_20063 = cljs.core.PersistentVector.EMPTY;
var inst_20064 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_19916);
var inst_20065 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_20064);
var inst_20066 = cljs.core.vals(inst_20065);
var inst_20067 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_19916);
var inst_20068 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_20067);
var inst_20069 = cljs.core.vals(inst_20068);
var inst_20070 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20066,inst_20069);
var inst_20071 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20062,inst_20063,inst_20070);
var inst_20073 = (function (){var top_level_subject = inst_19909;
var _ = inst_20061;
var select_spec = inst_19916;
var base_acc = inst_19931;
var acc_PLUS_refs = inst_19948;
var result = inst_20060;
var sort_preds = inst_20071;
return (function (acc,p__20072){
var vec__20086 = p__20072;
var select_pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20086,(0),null);
var sort_order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20086,(1),null);
var sort_pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20086,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20086,(3),null);
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res return acc:",acc) : fluree.db.util.log.debug.call(null,"flakes->res return acc:",acc));

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,select_pred,fluree.db.query.fql_resp.sort_offset_and_limit_res(sort_pred,sort_order,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,select_pred)));
});
})();
var inst_20074 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20073,inst_20060,inst_20071);
var state_20082__$1 = state_20082;
var statearr_20089_20178 = state_20082__$1;
(statearr_20089_20178[(2)] = inst_20074);

(statearr_20089_20178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (1))){
var state_20082__$1 = state_20082;
var statearr_20090_20179 = state_20082__$1;
(statearr_20090_20179[(2)] = null);

(statearr_20090_20179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (24))){
var inst_19948 = (state_20082[(7)]);
var inst_19948__$1 = (state_20082[(2)]);
var inst_19949 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res acc+refs:",inst_19948__$1) : fluree.db.util.log.debug.call(null,"flakes->res acc+refs:",inst_19948__$1));
var inst_19950 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_19951 = cljs.core.PersistentHashMap.EMPTY;
var inst_19952 = inst_19950;
var inst_19953 = inst_19948__$1;
var inst_19954 = inst_19951;
var state_20082__$1 = (function (){var statearr_20091 = state_20082;
(statearr_20091[(11)] = inst_19952);

(statearr_20091[(7)] = inst_19948__$1);

(statearr_20091[(12)] = inst_19954);

(statearr_20091[(13)] = inst_19949);

(statearr_20091[(14)] = inst_19953);

return statearr_20091;
})();
var statearr_20092_20180 = state_20082__$1;
(statearr_20092_20180[(2)] = null);

(statearr_20092_20180[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (39))){
var inst_19916 = (state_20082[(8)]);
var inst_20003 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_19916);
var state_20082__$1 = state_20082;
if(cljs.core.truth_(inst_20003)){
var statearr_20093_20181 = state_20082__$1;
(statearr_20093_20181[(1)] = (42));

} else {
var statearr_20094_20182 = state_20082__$1;
(statearr_20094_20182[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (46))){
var inst_19916 = (state_20082[(8)]);
var inst_20019 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_19916);
var state_20082__$1 = state_20082;
var statearr_20095_20183 = state_20082__$1;
(statearr_20095_20183[(2)] = inst_20019);

(statearr_20095_20183[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (4))){
var inst_19888 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
var statearr_20096_20184 = state_20082__$1;
(statearr_20096_20184[(2)] = inst_19888);

(statearr_20096_20184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (54))){
var inst_20041 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
var statearr_20097_20185 = state_20082__$1;
(statearr_20097_20185[(2)] = inst_20041);

(statearr_20097_20185[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (15))){
var inst_19918 = (state_20082[(15)]);
var inst_19916 = (state_20082[(8)]);
var inst_19916__$1 = (state_20082[(2)]);
var inst_19917 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res select-spec:",inst_19916__$1) : fluree.db.util.log.debug.call(null,"flakes->res select-spec:",inst_19916__$1));
var inst_19918__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_19916__$1);
var state_20082__$1 = (function (){var statearr_20098 = state_20082;
(statearr_20098[(15)] = inst_19918__$1);

(statearr_20098[(8)] = inst_19916__$1);

(statearr_20098[(16)] = inst_19917);

return statearr_20098;
})();
if(cljs.core.truth_(inst_19918__$1)){
var statearr_20099_20186 = state_20082__$1;
(statearr_20099_20186[(1)] = (16));

} else {
var statearr_20100_20187 = state_20082__$1;
(statearr_20100_20187[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (48))){
var inst_20022 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
if(cljs.core.truth_(inst_20022)){
var statearr_20101_20188 = state_20082__$1;
(statearr_20101_20188[(1)] = (49));

} else {
var statearr_20102_20189 = state_20082__$1;
(statearr_20102_20189[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (50))){
var state_20082__$1 = state_20082;
var statearr_20103_20190 = state_20082__$1;
(statearr_20103_20190[(1)] = (52));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (21))){
var inst_19916 = (state_20082[(8)]);
var inst_19931 = (state_20082[(9)]);
var inst_19931__$1 = (state_20082[(2)]);
var inst_19932 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res base-acc:",inst_19931__$1) : fluree.db.util.log.debug.call(null,"flakes->res base-acc:",inst_19931__$1));
var inst_19933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19934 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_19935 = (new cljs.core.PersistentVector(null,2,(5),inst_19933,inst_19934,null));
var inst_19936 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_19916,inst_19935);
var state_20082__$1 = (function (){var statearr_20105 = state_20082;
(statearr_20105[(9)] = inst_19931__$1);

(statearr_20105[(17)] = inst_19932);

return statearr_20105;
})();
if(cljs.core.truth_(inst_19936)){
var statearr_20106_20191 = state_20082__$1;
(statearr_20106_20191[(1)] = (22));

} else {
var statearr_20107_20192 = state_20082__$1;
(statearr_20107_20192[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (31))){
var inst_19962 = (state_20082[(18)]);
var inst_19965 = fluree.db.util.json.parse_json_flakes(db,inst_19962);
var state_20082__$1 = state_20082;
var statearr_20108_20193 = state_20082__$1;
(statearr_20108_20193[(2)] = inst_19965);

(statearr_20108_20193[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (32))){
var inst_19962 = (state_20082[(18)]);
var state_20082__$1 = state_20082;
var statearr_20109_20194 = state_20082__$1;
(statearr_20109_20194[(2)] = inst_19962);

(statearr_20109_20194[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (40))){
var inst_20047 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
var statearr_20110_20195 = state_20082__$1;
(statearr_20110_20195[(2)] = inst_20047);

(statearr_20110_20195[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (33))){
var inst_19916 = (state_20082[(8)]);
var inst_19968 = (state_20082[(19)]);
var inst_19974 = (state_20082[(20)]);
var inst_19968__$1 = (state_20082[(2)]);
var inst_19969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19970 = cljs.core.first(inst_19968__$1);
var inst_19971 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_19970);
var inst_19972 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_19971];
var inst_19973 = (new cljs.core.PersistentVector(null,3,(5),inst_19969,inst_19972,null));
var inst_19974__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_19916,inst_19973);
var inst_19975 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res pred-spec:",inst_19974__$1) : fluree.db.util.log.debug.call(null,"flakes->res pred-spec:",inst_19974__$1));
var inst_19976 = fluree.db.query.fql_resp.component_follow_QMARK_(inst_19974__$1,inst_19916);
var inst_19977 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_19974__$1);
var state_20082__$1 = (function (){var statearr_20111 = state_20082;
(statearr_20111[(21)] = inst_19975);

(statearr_20111[(22)] = inst_19976);

(statearr_20111[(19)] = inst_19968__$1);

(statearr_20111[(20)] = inst_19974__$1);

return statearr_20111;
})();
if(cljs.core.truth_(inst_19977)){
var statearr_20112_20196 = state_20082__$1;
(statearr_20112_20196[(1)] = (34));

} else {
var statearr_20113_20197 = state_20082__$1;
(statearr_20113_20197[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (13))){
var inst_19909 = (state_20082[(10)]);
var inst_19913 = fluree.db.query.fql_resp.full_select_spec(db,cache,base_select_spec,inst_19909);
var state_20082__$1 = state_20082;
var statearr_20114_20198 = state_20082__$1;
(statearr_20114_20198[(2)] = inst_19913);

(statearr_20114_20198[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (22))){
var inst_19916 = (state_20082[(8)]);
var inst_19938 = cljs.core.first(flakes);
var inst_19939 = fluree.db.flake.s(inst_19938);
var inst_19940 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs(inst_19916);
var inst_19941 = fluree.db.query.fql_resp.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_19939,opts,inst_19940);
var state_20082__$1 = state_20082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20082__$1,(25),inst_19941);
} else {
if((state_val_20083 === (36))){
var inst_19968 = (state_20082[(19)]);
var inst_20049 = (state_20082[(2)]);
var inst_20050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20049,(0),null);
var inst_20051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20049,(1),null);
var inst_20052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20049,(2),null);
var inst_20053 = cljs.core.first(inst_19968);
var inst_20054 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_20053);
var inst_20055 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20050,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_20054);
var inst_19952 = inst_20051;
var inst_19953 = inst_20055;
var inst_19954 = inst_20052;
var state_20082__$1 = (function (){var statearr_20115 = state_20082;
(statearr_20115[(11)] = inst_19952);

(statearr_20115[(12)] = inst_19954);

(statearr_20115[(14)] = inst_19953);

return statearr_20115;
})();
var statearr_20116_20199 = state_20082__$1;
(statearr_20116_20199[(2)] = null);

(statearr_20116_20199[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (41))){
var inst_19952 = (state_20082[(11)]);
var inst_19994 = (state_20082[(2)]);
var inst_19995 = fluree.db.util.async.throw_err(inst_19994);
var inst_19996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19995,(0),null);
var inst_19997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19995,(1),null);
var inst_19998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19999 = cljs.core.rest(inst_19952);
var inst_20000 = [inst_19996,inst_19999,inst_19997];
var inst_20001 = (new cljs.core.PersistentVector(null,3,(5),inst_19998,inst_20000,null));
var state_20082__$1 = state_20082;
var statearr_20117_20200 = state_20082__$1;
(statearr_20117_20200[(2)] = inst_20001);

(statearr_20117_20200[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (43))){
var inst_20017 = (state_20082[(23)]);
var inst_19916 = (state_20082[(8)]);
var inst_20016 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_19916);
var inst_20017__$1 = cljs.core.empty_QMARK_(inst_20016);
var state_20082__$1 = (function (){var statearr_20118 = state_20082;
(statearr_20118[(23)] = inst_20017__$1);

return statearr_20118;
})();
if(inst_20017__$1){
var statearr_20119_20201 = state_20082__$1;
(statearr_20119_20201[(1)] = (46));

} else {
var statearr_20120_20202 = state_20082__$1;
(statearr_20120_20202[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (29))){
var inst_19952 = (state_20082[(11)]);
var inst_19962 = (state_20082[(18)]);
var inst_19962__$1 = cljs.core.first(inst_19952);
var inst_19963 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res loop flakes:",inst_19962__$1) : fluree.db.util.log.debug.call(null,"flakes->res loop flakes:",inst_19962__$1));
var state_20082__$1 = (function (){var statearr_20121 = state_20082;
(statearr_20121[(18)] = inst_19962__$1);

(statearr_20121[(24)] = inst_19963);

return statearr_20121;
})();
if(cljs.core.truth_(parse_json_QMARK_)){
var statearr_20122_20203 = state_20082__$1;
(statearr_20122_20203[(1)] = (31));

} else {
var statearr_20123_20204 = state_20082__$1;
(statearr_20123_20204[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (44))){
var inst_20045 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
var statearr_20124_20205 = state_20082__$1;
(statearr_20124_20205[(2)] = inst_20045);

(statearr_20124_20205[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (6))){
var inst_19896 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res flakes:",flakes) : fluree.db.util.log.debug.call(null,"flakes->res flakes:",flakes));
var state_20082__$1 = (function (){var statearr_20125 = state_20082;
(statearr_20125[(25)] = inst_19896);

return statearr_20125;
})();
var statearr_20126_20206 = state_20082__$1;
(statearr_20126_20206[(2)] = null);

(statearr_20126_20206[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (28))){
var inst_19953 = (state_20082[(14)]);
var state_20082__$1 = state_20082;
var statearr_20127_20207 = state_20082__$1;
(statearr_20127_20207[(2)] = inst_19953);

(statearr_20127_20207[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (51))){
var inst_20043 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
var statearr_20128_20208 = state_20082__$1;
(statearr_20128_20208[(2)] = inst_20043);

(statearr_20128_20208[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (25))){
var inst_19931 = (state_20082[(9)]);
var inst_19943 = (state_20082[(2)]);
var inst_19944 = fluree.db.util.async.throw_err(inst_19943);
var inst_19945 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_19931,inst_19944], 0));
var state_20082__$1 = state_20082;
var statearr_20129_20209 = state_20082__$1;
(statearr_20129_20209[(2)] = inst_19945);

(statearr_20129_20209[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (34))){
var inst_19968 = (state_20082[(19)]);
var inst_19953 = (state_20082[(14)]);
var inst_19974 = (state_20082[(20)]);
var inst_19979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19980 = fluree.db.query.fql_resp.flake__GT_recur(db,inst_19968,inst_19974,inst_19953,fuel,max_fuel,cache,opts);
var state_20082__$1 = (function (){var statearr_20130 = state_20082;
(statearr_20130[(26)] = inst_19979);

return statearr_20130;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20082__$1,(37),inst_19980);
} else {
if((state_val_20083 === (17))){
var inst_19916 = (state_20082[(8)]);
var inst_19921 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_19916);
var state_20082__$1 = state_20082;
var statearr_20132_20210 = state_20082__$1;
(statearr_20132_20210[(2)] = inst_19921);

(statearr_20132_20210[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (3))){
var inst_20080 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20082__$1,inst_20080);
} else {
if((state_val_20083 === (12))){
var _ = (function (){var statearr_20133 = state_20082;
(statearr_20133[(4)] = cljs.core.rest((state_20082[(4)])));

return statearr_20133;
})();
var state_20082__$1 = state_20082;
var ex20131 = (state_20082__$1[(2)]);
var statearr_20134_20211 = state_20082__$1;
(statearr_20134_20211[(5)] = ex20131);


var statearr_20135_20212 = state_20082__$1;
(statearr_20135_20212[(1)] = (11));

(statearr_20135_20212[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (2))){
var _ = (function (){var statearr_20136 = state_20082;
(statearr_20136[(4)] = cljs.core.cons((5),(state_20082[(4)])));

return statearr_20136;
})();
var inst_19894 = cljs.core.not_empty(flakes);
var state_20082__$1 = state_20082;
if(cljs.core.truth_(inst_19894)){
var statearr_20137_20213 = state_20082__$1;
(statearr_20137_20213[(1)] = (6));

} else {
var statearr_20138_20214 = state_20082__$1;
(statearr_20138_20214[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (23))){
var inst_19931 = (state_20082[(9)]);
var state_20082__$1 = state_20082;
var statearr_20139_20215 = state_20082__$1;
(statearr_20139_20215[(2)] = inst_19931);

(statearr_20139_20215[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (47))){
var inst_20017 = (state_20082[(23)]);
var state_20082__$1 = state_20082;
var statearr_20140_20216 = state_20082__$1;
(statearr_20140_20216[(2)] = inst_20017);

(statearr_20140_20216[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (35))){
var inst_19974 = (state_20082[(20)]);
var state_20082__$1 = state_20082;
if(cljs.core.truth_(inst_19974)){
var statearr_20141_20217 = state_20082__$1;
(statearr_20141_20217[(1)] = (38));

} else {
var statearr_20142_20218 = state_20082__$1;
(statearr_20142_20218[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (19))){
var inst_19909 = (state_20082[(10)]);
var inst_19925 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_19926 = [inst_19909];
var inst_19927 = cljs.core.PersistentHashMap.fromArrays(inst_19925,inst_19926);
var state_20082__$1 = state_20082;
var statearr_20143_20219 = state_20082__$1;
(statearr_20143_20219[(2)] = inst_19927);

(statearr_20143_20219[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (11))){
var inst_19897 = (state_20082[(2)]);
var inst_19898 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1(inst_19897) : fluree.db.util.log.error.call(null,inst_19897));
var inst_19899 = (function(){throw inst_19897})();
var state_20082__$1 = (function (){var statearr_20145 = state_20082;
(statearr_20145[(27)] = inst_19898);

return statearr_20145;
})();
var statearr_20146_20220 = state_20082__$1;
(statearr_20146_20220[(2)] = inst_19899);

(statearr_20146_20220[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (9))){
var _ = (function (){var statearr_20147 = state_20082;
(statearr_20147[(4)] = cljs.core.cons((12),(state_20082[(4)])));

return statearr_20147;
})();
var inst_19905 = cljs.core.first(flakes);
var inst_19906 = fluree.db.flake.s(inst_19905);
var ___$1 = (function (){var statearr_20148 = state_20082;
(statearr_20148[(4)] = cljs.core.rest((state_20082[(4)])));

return statearr_20148;
})();
var state_20082__$1 = state_20082;
var statearr_20149_20221 = state_20082__$1;
(statearr_20149_20221[(2)] = inst_19906);

(statearr_20149_20221[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (5))){
var _ = (function (){var statearr_20150 = state_20082;
(statearr_20150[(4)] = cljs.core.rest((state_20082[(4)])));

return statearr_20150;
})();
var state_20082__$1 = state_20082;
var ex20144 = (state_20082__$1[(2)]);
var statearr_20151_20222 = state_20082__$1;
(statearr_20151_20222[(5)] = ex20144);


if((ex20144 instanceof Error)){
var statearr_20152_20223 = state_20082__$1;
(statearr_20152_20223[(1)] = (4));

(statearr_20152_20223[(5)] = null);

} else {
throw ex20144;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (14))){
var state_20082__$1 = state_20082;
var statearr_20153_20224 = state_20082__$1;
(statearr_20153_20224[(2)] = base_select_spec);

(statearr_20153_20224[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (45))){
var inst_19952 = (state_20082[(11)]);
var inst_19954 = (state_20082[(12)]);
var inst_20005 = (state_20082[(28)]);
var inst_20009 = (state_20082[(2)]);
var inst_20010 = fluree.db.util.async.throw_err(inst_20009);
var inst_20011 = cljs.core.first(inst_20010);
var inst_20012 = cljs.core.rest(inst_19952);
var inst_20013 = [inst_20011,inst_20012,inst_19954];
var inst_20014 = (new cljs.core.PersistentVector(null,3,(5),inst_20005,inst_20013,null));
var state_20082__$1 = state_20082;
var statearr_20154_20225 = state_20082__$1;
(statearr_20154_20225[(2)] = inst_20014);

(statearr_20154_20225[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (53))){
var state_20082__$1 = state_20082;
var statearr_20155_20226 = state_20082__$1;
(statearr_20155_20226[(2)] = null);

(statearr_20155_20226[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (26))){
var inst_19952 = (state_20082[(11)]);
var inst_19956 = cljs.core.empty_QMARK_(inst_19952);
var state_20082__$1 = state_20082;
if(inst_19956){
var statearr_20156_20227 = state_20082__$1;
(statearr_20156_20227[(1)] = (28));

} else {
var statearr_20157_20228 = state_20082__$1;
(statearr_20157_20228[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (16))){
var inst_19918 = (state_20082[(15)]);
var state_20082__$1 = state_20082;
var statearr_20158_20229 = state_20082__$1;
(statearr_20158_20229[(2)] = inst_19918);

(statearr_20158_20229[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (38))){
var inst_19954 = (state_20082[(12)]);
var inst_19976 = (state_20082[(22)]);
var inst_19968 = (state_20082[(19)]);
var inst_19953 = (state_20082[(14)]);
var inst_19974 = (state_20082[(20)]);
var inst_19992 = fluree.db.query.fql_resp.add_pred(db,cache,fuel,max_fuel,inst_19953,inst_19974,inst_19968,inst_19976,false,inst_19954,opts);
var state_20082__$1 = state_20082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20082__$1,(41),inst_19992);
} else {
if((state_val_20083 === (30))){
var inst_20058 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
var statearr_20159_20230 = state_20082__$1;
(statearr_20159_20230[(2)] = inst_20058);

(statearr_20159_20230[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (10))){
var inst_19909 = (state_20082[(10)]);
var inst_19909__$1 = (state_20082[(2)]);
var inst_19910 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("flakes->res top-level-subject:",inst_19909__$1) : fluree.db.util.log.debug.call(null,"flakes->res top-level-subject:",inst_19909__$1));
var inst_19911 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_(base_select_spec);
var state_20082__$1 = (function (){var statearr_20160 = state_20082;
(statearr_20160[(10)] = inst_19909__$1);

(statearr_20160[(29)] = inst_19910);

return statearr_20160;
})();
if(cljs.core.truth_(inst_19911)){
var statearr_20161_20231 = state_20082__$1;
(statearr_20161_20231[(1)] = (13));

} else {
var statearr_20162_20232 = state_20082__$1;
(statearr_20162_20232[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (18))){
var inst_19923 = (state_20082[(2)]);
var state_20082__$1 = state_20082;
if(cljs.core.truth_(inst_19923)){
var statearr_20163_20233 = state_20082__$1;
(statearr_20163_20233[(1)] = (19));

} else {
var statearr_20164_20234 = state_20082__$1;
(statearr_20164_20234[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (52))){
var inst_19952 = (state_20082[(11)]);
var inst_19954 = (state_20082[(12)]);
var inst_19953 = (state_20082[(14)]);
var inst_20035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20036 = cljs.core.rest(inst_19952);
var inst_20037 = [inst_19953,inst_20036,inst_19954];
var inst_20038 = (new cljs.core.PersistentVector(null,3,(5),inst_20035,inst_20037,null));
var state_20082__$1 = state_20082;
var statearr_20165_20235 = state_20082__$1;
(statearr_20165_20235[(2)] = inst_20038);

(statearr_20165_20235[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (42))){
var inst_19916 = (state_20082[(8)]);
var inst_19976 = (state_20082[(22)]);
var inst_19968 = (state_20082[(19)]);
var inst_19953 = (state_20082[(14)]);
var inst_20005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20006 = cljs.core.PersistentHashMap.EMPTY;
var inst_20007 = fluree.db.query.fql_resp.add_pred(db,cache,fuel,max_fuel,inst_19953,inst_19916,inst_19968,inst_19976,false,inst_20006,opts);
var state_20082__$1 = (function (){var statearr_20166 = state_20082;
(statearr_20166[(28)] = inst_20005);

return statearr_20166;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20082__$1,(45),inst_20007);
} else {
if((state_val_20083 === (37))){
var inst_19952 = (state_20082[(11)]);
var inst_19979 = (state_20082[(26)]);
var inst_19954 = (state_20082[(12)]);
var inst_19982 = (state_20082[(2)]);
var inst_19983 = fluree.db.util.async.throw_err(inst_19982);
var inst_19984 = cljs.core.rest(inst_19952);
var inst_19985 = [inst_19983,inst_19984,inst_19954];
var inst_19986 = (new cljs.core.PersistentVector(null,3,(5),inst_19979,inst_19985,null));
var state_20082__$1 = state_20082;
var statearr_20167_20236 = state_20082__$1;
(statearr_20167_20236[(2)] = inst_19986);

(statearr_20167_20236[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (8))){
var inst_20077 = (state_20082[(2)]);
var _ = (function (){var statearr_20168 = state_20082;
(statearr_20168[(4)] = cljs.core.rest((state_20082[(4)])));

return statearr_20168;
})();
var state_20082__$1 = state_20082;
var statearr_20169_20237 = state_20082__$1;
(statearr_20169_20237[(2)] = inst_20077);

(statearr_20169_20237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20083 === (49))){
var inst_19952 = (state_20082[(11)]);
var inst_19954 = (state_20082[(12)]);
var inst_19968 = (state_20082[(19)]);
var inst_20024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20025 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_20026 = cljs.core.first(inst_19968);
var inst_20027 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_20026);
var inst_20028 = [inst_20027];
var inst_20029 = cljs.core.PersistentHashMap.fromArrays(inst_20025,inst_20028);
var inst_20030 = cljs.core.rest(inst_19952);
var inst_20031 = [inst_20029,inst_20030,inst_19954];
var inst_20032 = (new cljs.core.PersistentVector(null,3,(5),inst_20024,inst_20031,null));
var state_20082__$1 = state_20082;
var statearr_20170_20238 = state_20082__$1;
(statearr_20170_20238[(2)] = inst_20032);

(statearr_20170_20238[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0 = (function (){
var statearr_20171 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20171[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__);

(statearr_20171[(1)] = (1));

return statearr_20171;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1 = (function (state_20082){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20082);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20172){var ex__2687__auto__ = e20172;
var statearr_20173_20239 = state_20082;
(statearr_20173_20239[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20082[(4)]))){
var statearr_20174_20240 = state_20082;
(statearr_20174_20240[(1)] = cljs.core.first((state_20082[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20241 = state_20082;
state_20082 = G__20241;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__ = function(state_20082){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1.call(this,state_20082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20175 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20175[(6)] = c__2706__auto__);

return statearr_20175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
