// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___54805 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54842){
var state_val_54843 = (state_54842[(1)]);
if((state_val_54843 === (7))){
var inst_54837 = (state_54842[(2)]);
var _ = (function (){var statearr_54844 = state_54842;
(statearr_54844[(4)] = cljs.core.rest((state_54842[(4)])));

return statearr_54844;
})();
var state_54842__$1 = state_54842;
var statearr_54845_54872 = state_54842__$1;
(statearr_54845_54872[(2)] = inst_54837);

(statearr_54845_54872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (1))){
var state_54842__$1 = state_54842;
var statearr_54846_54873 = state_54842__$1;
(statearr_54846_54873[(2)] = null);

(statearr_54846_54873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (4))){
var inst_54806 = (state_54842[(2)]);
var state_54842__$1 = state_54842;
var statearr_54847_54874 = state_54842__$1;
(statearr_54847_54874[(2)] = inst_54806);

(statearr_54847_54874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (13))){
var inst_54833 = (state_54842[(2)]);
var state_54842__$1 = state_54842;
var statearr_54848_54875 = state_54842__$1;
(statearr_54848_54875[(2)] = inst_54833);

(statearr_54848_54875[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (6))){
var inst_54814 = (state_54842[(7)]);
var inst_54812 = (state_54842[(8)]);
var inst_54817 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_54814,inst_54812);
var state_54842__$1 = state_54842;
if(inst_54817){
var statearr_54849_54876 = state_54842__$1;
(statearr_54849_54876[(1)] = (8));

} else {
var statearr_54850_54877 = state_54842__$1;
(statearr_54850_54877[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (3))){
var inst_54840 = (state_54842[(2)]);
var state_54842__$1 = state_54842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54842__$1,inst_54840);
} else {
if((state_val_54843 === (12))){
var inst_54815 = (state_54842[(9)]);
var inst_54820 = (state_54842[(10)]);
var inst_54821 = (state_54842[(11)]);
var inst_54830 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54815,inst_54820);
var inst_54814 = inst_54821;
var inst_54815__$1 = inst_54830;
var state_54842__$1 = (function (){var statearr_54851 = state_54842;
(statearr_54851[(7)] = inst_54814);

(statearr_54851[(9)] = inst_54815__$1);

return statearr_54851;
})();
var statearr_54852_54878 = state_54842__$1;
(statearr_54852_54878[(2)] = null);

(statearr_54852_54878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (2))){
var _ = (function (){var statearr_54853 = state_54842;
(statearr_54853[(4)] = cljs.core.cons((5),(state_54842[(4)])));

return statearr_54853;
})();
var inst_54812 = cljs.core.count(args);
var inst_54813 = cljs.core.PersistentVector.EMPTY;
var inst_54814 = (0);
var inst_54815 = inst_54813;
var state_54842__$1 = (function (){var statearr_54854 = state_54842;
(statearr_54854[(7)] = inst_54814);

(statearr_54854[(8)] = inst_54812);

(statearr_54854[(9)] = inst_54815);

return statearr_54854;
})();
var statearr_54855_54879 = state_54842__$1;
(statearr_54855_54879[(2)] = null);

(statearr_54855_54879[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (11))){
var inst_54820 = (state_54842[(10)]);
var state_54842__$1 = state_54842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54842__$1,(14),inst_54820);
} else {
if((state_val_54843 === (9))){
var inst_54814 = (state_54842[(7)]);
var inst_54820 = (state_54842[(10)]);
var inst_54820__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(args,inst_54814);
var inst_54821 = (inst_54814 + (1));
var inst_54822 = fluree.db.util.async.channel_QMARK_(inst_54820__$1);
var state_54842__$1 = (function (){var statearr_54857 = state_54842;
(statearr_54857[(10)] = inst_54820__$1);

(statearr_54857[(11)] = inst_54821);

return statearr_54857;
})();
if(inst_54822){
var statearr_54858_54880 = state_54842__$1;
(statearr_54858_54880[(1)] = (11));

} else {
var statearr_54859_54881 = state_54842__$1;
(statearr_54859_54881[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (5))){
var _ = (function (){var statearr_54860 = state_54842;
(statearr_54860[(4)] = cljs.core.rest((state_54842[(4)])));

return statearr_54860;
})();
var state_54842__$1 = state_54842;
var ex54856 = (state_54842__$1[(2)]);
var statearr_54861_54882 = state_54842__$1;
(statearr_54861_54882[(5)] = ex54856);


if((ex54856 instanceof Error)){
var statearr_54862_54883 = state_54842__$1;
(statearr_54862_54883[(1)] = (4));

(statearr_54862_54883[(5)] = null);

} else {
throw ex54856;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (14))){
var inst_54815 = (state_54842[(9)]);
var inst_54821 = (state_54842[(11)]);
var inst_54825 = (state_54842[(2)]);
var inst_54826 = fluree.db.util.async.throw_err(inst_54825);
var inst_54827 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54815,inst_54826);
var inst_54814 = inst_54821;
var inst_54815__$1 = inst_54827;
var state_54842__$1 = (function (){var statearr_54863 = state_54842;
(statearr_54863[(7)] = inst_54814);

(statearr_54863[(9)] = inst_54815__$1);

return statearr_54863;
})();
var statearr_54864_54884 = state_54842__$1;
(statearr_54864_54884[(2)] = null);

(statearr_54864_54884[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (10))){
var inst_54835 = (state_54842[(2)]);
var state_54842__$1 = state_54842;
var statearr_54865_54885 = state_54842__$1;
(statearr_54865_54885[(2)] = inst_54835);

(statearr_54865_54885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54843 === (8))){
var inst_54815 = (state_54842[(9)]);
var state_54842__$1 = state_54842;
var statearr_54866_54886 = state_54842__$1;
(statearr_54866_54886[(2)] = inst_54815);

(statearr_54866_54886[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0 = (function (){
var statearr_54867 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54867[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__);

(statearr_54867[(1)] = (1));

return statearr_54867;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1 = (function (state_54842){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54842);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54868){var ex__2687__auto__ = e54868;
var statearr_54869_54887 = state_54842;
(statearr_54869_54887[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54842[(4)]))){
var statearr_54870_54888 = state_54842;
(statearr_54870_54888[(1)] = cljs.core.first((state_54842[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54889 = state_54842;
state_54842 = G__54889;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = function(state_54842){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1.call(this,state_54842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54871 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54871[(6)] = c__2706__auto__);

return statearr_54871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54891 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54891,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54891,(1),null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__54890_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__54890_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54939){
var state_val_54940 = (state_54939[(1)]);
if((state_val_54940 === (7))){
var state_54939__$1 = state_54939;
var statearr_54941_54970 = state_54939__$1;
(statearr_54941_54970[(2)] = coll);

(statearr_54941_54970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (1))){
var state_54939__$1 = state_54939;
var statearr_54942_54971 = state_54939__$1;
(statearr_54942_54971[(2)] = null);

(statearr_54942_54971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (4))){
var inst_54894 = (state_54939[(2)]);
var state_54939__$1 = state_54939;
var statearr_54943_54972 = state_54939__$1;
(statearr_54943_54972[(2)] = inst_54894);

(statearr_54943_54972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (15))){
var inst_54913 = (state_54939[(7)]);
var inst_54921 = (state_54939[(2)]);
var inst_54922 = fluree.db.dbfunctions.internal.nth(inst_54913,inst_54921);
var inst_54923 = cljs.core.count(inst_54913);
var inst_54924 = ((9) + inst_54923);
var inst_54925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54926 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54928 = [inst_54913,inst_54921];
var inst_54929 = (new cljs.core.PersistentVector(null,2,(5),inst_54927,inst_54928,null));
var inst_54930 = ["nth",inst_54929,inst_54922];
var inst_54931 = cljs.core.PersistentHashMap.fromArrays(inst_54926,inst_54930);
var inst_54932 = [inst_54931,inst_54924];
var inst_54933 = (new cljs.core.PersistentVector(null,2,(5),inst_54925,inst_54932,null));
var inst_54934 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54933);
var _ = (function (){var statearr_54944 = state_54939;
(statearr_54944[(4)] = cljs.core.rest((state_54939[(4)])));

return statearr_54944;
})();
var state_54939__$1 = (function (){var statearr_54945 = state_54939;
(statearr_54945[(8)] = inst_54934);

return statearr_54945;
})();
var statearr_54946_54973 = state_54939__$1;
(statearr_54946_54973[(2)] = inst_54922);

(statearr_54946_54973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (13))){
var state_54939__$1 = state_54939;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54939__$1,(16),key);
} else {
if((state_val_54940 === (6))){
var state_54939__$1 = state_54939;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54939__$1,(9),coll);
} else {
if((state_val_54940 === (3))){
var inst_54937 = (state_54939[(2)]);
var state_54939__$1 = state_54939;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54939__$1,inst_54937);
} else {
if((state_val_54940 === (12))){
var inst_54913 = (state_54939[(2)]);
var inst_54914 = fluree.db.util.async.channel_QMARK_(key);
var state_54939__$1 = (function (){var statearr_54947 = state_54939;
(statearr_54947[(7)] = inst_54913);

return statearr_54947;
})();
if(inst_54914){
var statearr_54948_54974 = state_54939__$1;
(statearr_54948_54974[(1)] = (13));

} else {
var statearr_54949_54975 = state_54939__$1;
(statearr_54949_54975[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (2))){
var _ = (function (){var statearr_54950 = state_54939;
(statearr_54950[(4)] = cljs.core.cons((5),(state_54939[(4)])));

return statearr_54950;
})();
var inst_54900 = fluree.db.util.async.channel_QMARK_(coll);
var state_54939__$1 = state_54939;
if(inst_54900){
var statearr_54951_54976 = state_54939__$1;
(statearr_54951_54976[(1)] = (6));

} else {
var statearr_54952_54977 = state_54939__$1;
(statearr_54952_54977[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (11))){
var inst_54907 = (state_54939[(9)]);
var state_54939__$1 = state_54939;
var statearr_54954_54978 = state_54939__$1;
(statearr_54954_54978[(2)] = inst_54907);

(statearr_54954_54978[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (9))){
var inst_54903 = (state_54939[(2)]);
var inst_54904 = fluree.db.util.async.throw_err(inst_54903);
var state_54939__$1 = state_54939;
var statearr_54955_54979 = state_54939__$1;
(statearr_54955_54979[(2)] = inst_54904);

(statearr_54955_54979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (5))){
var _ = (function (){var statearr_54956 = state_54939;
(statearr_54956[(4)] = cljs.core.rest((state_54939[(4)])));

return statearr_54956;
})();
var state_54939__$1 = state_54939;
var ex54953 = (state_54939__$1[(2)]);
var statearr_54957_54980 = state_54939__$1;
(statearr_54957_54980[(5)] = ex54953);


if((ex54953 instanceof Error)){
var statearr_54958_54981 = state_54939__$1;
(statearr_54958_54981[(1)] = (4));

(statearr_54958_54981[(5)] = null);

} else {
throw ex54953;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (14))){
var state_54939__$1 = state_54939;
var statearr_54959_54982 = state_54939__$1;
(statearr_54959_54982[(2)] = key);

(statearr_54959_54982[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (16))){
var inst_54917 = (state_54939[(2)]);
var inst_54918 = fluree.db.util.async.throw_err(inst_54917);
var state_54939__$1 = state_54939;
var statearr_54960_54983 = state_54939__$1;
(statearr_54960_54983[(2)] = inst_54918);

(statearr_54960_54983[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (10))){
var inst_54907 = (state_54939[(9)]);
var inst_54910 = cljs.core.vec(inst_54907);
var state_54939__$1 = state_54939;
var statearr_54961_54984 = state_54939__$1;
(statearr_54961_54984[(2)] = inst_54910);

(statearr_54961_54984[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54940 === (8))){
var inst_54907 = (state_54939[(9)]);
var inst_54907__$1 = (state_54939[(2)]);
var inst_54908 = cljs.core.set_QMARK_(inst_54907__$1);
var state_54939__$1 = (function (){var statearr_54962 = state_54939;
(statearr_54962[(9)] = inst_54907__$1);

return statearr_54962;
})();
if(inst_54908){
var statearr_54963_54985 = state_54939__$1;
(statearr_54963_54985[(1)] = (10));

} else {
var statearr_54964_54986 = state_54939__$1;
(statearr_54964_54986[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0 = (function (){
var statearr_54965 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54965[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__);

(statearr_54965[(1)] = (1));

return statearr_54965;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1 = (function (state_54939){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54939);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54966){var ex__2687__auto__ = e54966;
var statearr_54967_54987 = state_54939;
(statearr_54967_54987[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54939[(4)]))){
var statearr_54968_54988 = state_54939;
(statearr_54968_54988[(1)] = cljs.core.first((state_54939[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54989 = state_54939;
state_54939 = G__54989;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = function(state_54939){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1.call(this,state_54939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54969 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54969[(6)] = c__2706__auto__);

return statearr_54969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the first item in a collection
 */
fluree.db.dbfunctions.fns.first = (function fluree$db$dbfunctions$fns$first(_QMARK_ctx,coll){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55025){
var state_val_55026 = (state_55025[(1)]);
if((state_val_55026 === (7))){
var state_55025__$1 = state_55025;
var statearr_55027_55051 = state_55025__$1;
(statearr_55027_55051[(2)] = coll);

(statearr_55027_55051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (1))){
var state_55025__$1 = state_55025;
var statearr_55028_55052 = state_55025__$1;
(statearr_55028_55052[(2)] = null);

(statearr_55028_55052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (4))){
var inst_54990 = (state_55025[(2)]);
var state_55025__$1 = state_55025;
var statearr_55029_55053 = state_55025__$1;
(statearr_55029_55053[(2)] = inst_54990);

(statearr_55029_55053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (6))){
var state_55025__$1 = state_55025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55025__$1,(9),coll);
} else {
if((state_val_55026 === (3))){
var inst_55023 = (state_55025[(2)]);
var state_55025__$1 = state_55025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55025__$1,inst_55023);
} else {
if((state_val_55026 === (12))){
var inst_55009 = (state_55025[(2)]);
var inst_55010 = fluree.db.dbfunctions.internal.first(inst_55009);
var inst_55011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55012 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55014 = [inst_55009];
var inst_55015 = (new cljs.core.PersistentVector(null,1,(5),inst_55013,inst_55014,null));
var inst_55016 = ["first",inst_55015,inst_55010];
var inst_55017 = cljs.core.PersistentHashMap.fromArrays(inst_55012,inst_55016);
var inst_55018 = [inst_55017,(10)];
var inst_55019 = (new cljs.core.PersistentVector(null,2,(5),inst_55011,inst_55018,null));
var inst_55020 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55019);
var _ = (function (){var statearr_55030 = state_55025;
(statearr_55030[(4)] = cljs.core.rest((state_55025[(4)])));

return statearr_55030;
})();
var state_55025__$1 = (function (){var statearr_55031 = state_55025;
(statearr_55031[(7)] = inst_55020);

return statearr_55031;
})();
var statearr_55032_55054 = state_55025__$1;
(statearr_55032_55054[(2)] = inst_55010);

(statearr_55032_55054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (2))){
var _ = (function (){var statearr_55033 = state_55025;
(statearr_55033[(4)] = cljs.core.cons((5),(state_55025[(4)])));

return statearr_55033;
})();
var inst_54996 = fluree.db.util.async.channel_QMARK_(coll);
var state_55025__$1 = state_55025;
if(inst_54996){
var statearr_55034_55055 = state_55025__$1;
(statearr_55034_55055[(1)] = (6));

} else {
var statearr_55035_55056 = state_55025__$1;
(statearr_55035_55056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (11))){
var inst_55003 = (state_55025[(8)]);
var state_55025__$1 = state_55025;
var statearr_55037_55057 = state_55025__$1;
(statearr_55037_55057[(2)] = inst_55003);

(statearr_55037_55057[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (9))){
var inst_54999 = (state_55025[(2)]);
var inst_55000 = fluree.db.util.async.throw_err(inst_54999);
var state_55025__$1 = state_55025;
var statearr_55038_55058 = state_55025__$1;
(statearr_55038_55058[(2)] = inst_55000);

(statearr_55038_55058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (5))){
var _ = (function (){var statearr_55039 = state_55025;
(statearr_55039[(4)] = cljs.core.rest((state_55025[(4)])));

return statearr_55039;
})();
var state_55025__$1 = state_55025;
var ex55036 = (state_55025__$1[(2)]);
var statearr_55040_55059 = state_55025__$1;
(statearr_55040_55059[(5)] = ex55036);


if((ex55036 instanceof Error)){
var statearr_55041_55060 = state_55025__$1;
(statearr_55041_55060[(1)] = (4));

(statearr_55041_55060[(5)] = null);

} else {
throw ex55036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (10))){
var inst_55003 = (state_55025[(8)]);
var inst_55006 = cljs.core.vec(inst_55003);
var state_55025__$1 = state_55025;
var statearr_55042_55061 = state_55025__$1;
(statearr_55042_55061[(2)] = inst_55006);

(statearr_55042_55061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55026 === (8))){
var inst_55003 = (state_55025[(8)]);
var inst_55003__$1 = (state_55025[(2)]);
var inst_55004 = cljs.core.set_QMARK_(inst_55003__$1);
var state_55025__$1 = (function (){var statearr_55043 = state_55025;
(statearr_55043[(8)] = inst_55003__$1);

return statearr_55043;
})();
if(inst_55004){
var statearr_55044_55062 = state_55025__$1;
(statearr_55044_55062[(1)] = (10));

} else {
var statearr_55045_55063 = state_55025__$1;
(statearr_55045_55063[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0 = (function (){
var statearr_55046 = [null,null,null,null,null,null,null,null,null];
(statearr_55046[(0)] = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__);

(statearr_55046[(1)] = (1));

return statearr_55046;
});
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1 = (function (state_55025){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55025);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55047){var ex__2687__auto__ = e55047;
var statearr_55048_55064 = state_55025;
(statearr_55048_55064[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55025[(4)]))){
var statearr_55049_55065 = state_55025;
(statearr_55049_55065[(1)] = cljs.core.first((state_55025[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55066 = state_55025;
state_55025 = G__55066;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__ = function(state_55025){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1.call(this,state_55025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55050 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55050[(6)] = c__2706__auto__);

return statearr_55050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55127){
var state_val_55128 = (state_55127[(1)]);
if((state_val_55128 === (7))){
var state_55127__$1 = state_55127;
var statearr_55129_55163 = state_55127__$1;
(statearr_55129_55163[(2)] = test);

(statearr_55129_55163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (20))){
var inst_55101 = (state_55127[(2)]);
var inst_55102 = fluree.db.util.async.throw_err(inst_55101);
var state_55127__$1 = state_55127;
var statearr_55130_55164 = state_55127__$1;
(statearr_55130_55164[(2)] = inst_55102);

(statearr_55130_55164[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (1))){
var state_55127__$1 = state_55127;
var statearr_55131_55165 = state_55127__$1;
(statearr_55131_55165[(2)] = null);

(statearr_55131_55165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (4))){
var inst_55067 = (state_55127[(2)]);
var state_55127__$1 = state_55127;
var statearr_55132_55166 = state_55127__$1;
(statearr_55132_55166[(2)] = inst_55067);

(statearr_55132_55166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (15))){
var inst_55085 = (state_55127[(7)]);
var inst_55093 = (state_55127[(2)]);
var inst_55094 = [inst_55093,f];
var inst_55095 = (new cljs.core.PersistentVector(null,2,(5),inst_55085,inst_55094,null));
var state_55127__$1 = state_55127;
var statearr_55133_55167 = state_55127__$1;
(statearr_55133_55167[(2)] = inst_55095);

(statearr_55133_55167[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (13))){
var state_55127__$1 = state_55127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55127__$1,(16),t);
} else {
if((state_val_55128 === (6))){
var state_55127__$1 = state_55127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55127__$1,(9),test);
} else {
if((state_val_55128 === (17))){
var state_55127__$1 = state_55127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55127__$1,(20),f);
} else {
if((state_val_55128 === (3))){
var inst_55125 = (state_55127[(2)]);
var state_55127__$1 = state_55127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55127__$1,inst_55125);
} else {
if((state_val_55128 === (12))){
var inst_55083 = (state_55127[(8)]);
var inst_55109 = (state_55127[(2)]);
var inst_55110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55109,(0),null);
var inst_55111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55109,(1),null);
var inst_55112 = fluree.db.dbfunctions.internal.if_else(inst_55083,inst_55110,inst_55111);
var inst_55113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55114 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55116 = [inst_55083,inst_55110,inst_55111];
var inst_55117 = (new cljs.core.PersistentVector(null,3,(5),inst_55115,inst_55116,null));
var inst_55118 = ["if-else",inst_55117,inst_55112];
var inst_55119 = cljs.core.PersistentHashMap.fromArrays(inst_55114,inst_55118);
var inst_55120 = [inst_55119,(10)];
var inst_55121 = (new cljs.core.PersistentVector(null,2,(5),inst_55113,inst_55120,null));
var inst_55122 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55121);
var _ = (function (){var statearr_55134 = state_55127;
(statearr_55134[(4)] = cljs.core.rest((state_55127[(4)])));

return statearr_55134;
})();
var state_55127__$1 = (function (){var statearr_55135 = state_55127;
(statearr_55135[(9)] = inst_55122);

return statearr_55135;
})();
var statearr_55136_55168 = state_55127__$1;
(statearr_55136_55168[(2)] = inst_55112);

(statearr_55136_55168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (2))){
var _ = (function (){var statearr_55137 = state_55127;
(statearr_55137[(4)] = cljs.core.cons((5),(state_55127[(4)])));

return statearr_55137;
})();
var inst_55076 = fluree.db.util.async.channel_QMARK_(test);
var state_55127__$1 = state_55127;
if(inst_55076){
var statearr_55138_55169 = state_55127__$1;
(statearr_55138_55169[(1)] = (6));

} else {
var statearr_55139_55170 = state_55127__$1;
(statearr_55139_55170[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (19))){
var inst_55097 = (state_55127[(10)]);
var inst_55105 = (state_55127[(2)]);
var inst_55106 = [f,inst_55105];
var inst_55107 = (new cljs.core.PersistentVector(null,2,(5),inst_55097,inst_55106,null));
var state_55127__$1 = state_55127;
var statearr_55140_55171 = state_55127__$1;
(statearr_55140_55171[(2)] = inst_55107);

(statearr_55140_55171[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (11))){
var inst_55097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55098 = fluree.db.util.async.channel_QMARK_(f);
var state_55127__$1 = (function (){var statearr_55142 = state_55127;
(statearr_55142[(10)] = inst_55097);

return statearr_55142;
})();
if(inst_55098){
var statearr_55143_55172 = state_55127__$1;
(statearr_55143_55172[(1)] = (17));

} else {
var statearr_55144_55173 = state_55127__$1;
(statearr_55144_55173[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (9))){
var inst_55079 = (state_55127[(2)]);
var inst_55080 = fluree.db.util.async.throw_err(inst_55079);
var state_55127__$1 = state_55127;
var statearr_55145_55174 = state_55127__$1;
(statearr_55145_55174[(2)] = inst_55080);

(statearr_55145_55174[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (5))){
var _ = (function (){var statearr_55146 = state_55127;
(statearr_55146[(4)] = cljs.core.rest((state_55127[(4)])));

return statearr_55146;
})();
var state_55127__$1 = state_55127;
var ex55141 = (state_55127__$1[(2)]);
var statearr_55147_55175 = state_55127__$1;
(statearr_55147_55175[(5)] = ex55141);


if((ex55141 instanceof Error)){
var statearr_55148_55176 = state_55127__$1;
(statearr_55148_55176[(1)] = (4));

(statearr_55148_55176[(5)] = null);

} else {
throw ex55141;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (14))){
var state_55127__$1 = state_55127;
var statearr_55149_55177 = state_55127__$1;
(statearr_55149_55177[(2)] = t);

(statearr_55149_55177[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (16))){
var inst_55089 = (state_55127[(2)]);
var inst_55090 = fluree.db.util.async.throw_err(inst_55089);
var state_55127__$1 = state_55127;
var statearr_55150_55178 = state_55127__$1;
(statearr_55150_55178[(2)] = inst_55090);

(statearr_55150_55178[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (10))){
var inst_55085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55086 = fluree.db.util.async.channel_QMARK_(t);
var state_55127__$1 = (function (){var statearr_55151 = state_55127;
(statearr_55151[(7)] = inst_55085);

return statearr_55151;
})();
if(inst_55086){
var statearr_55152_55179 = state_55127__$1;
(statearr_55152_55179[(1)] = (13));

} else {
var statearr_55153_55180 = state_55127__$1;
(statearr_55153_55180[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (18))){
var state_55127__$1 = state_55127;
var statearr_55154_55181 = state_55127__$1;
(statearr_55154_55181[(2)] = f);

(statearr_55154_55181[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55128 === (8))){
var inst_55083 = (state_55127[(8)]);
var inst_55083__$1 = (state_55127[(2)]);
var state_55127__$1 = (function (){var statearr_55155 = state_55127;
(statearr_55155[(8)] = inst_55083__$1);

return statearr_55155;
})();
if(cljs.core.truth_(inst_55083__$1)){
var statearr_55156_55182 = state_55127__$1;
(statearr_55156_55182[(1)] = (10));

} else {
var statearr_55157_55183 = state_55127__$1;
(statearr_55157_55183[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0 = (function (){
var statearr_55158 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55158[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__);

(statearr_55158[(1)] = (1));

return statearr_55158;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1 = (function (state_55127){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55127);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55159){var ex__2687__auto__ = e55159;
var statearr_55160_55184 = state_55127;
(statearr_55160_55184[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55127[(4)]))){
var statearr_55161_55185 = state_55127;
(statearr_55161_55185[(1)] = cljs.core.first((state_55127[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55186 = state_55127;
state_55127 = G__55186;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = function(state_55127){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1.call(this,state_55127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55162 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55162[(6)] = c__2706__auto__);

return statearr_55162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55216){
var state_val_55217 = (state_55216[(1)]);
if((state_val_55217 === (7))){
var state_55216__$1 = state_55216;
var statearr_55218_55237 = state_55216__$1;
(statearr_55218_55237[(2)] = arg);

(statearr_55218_55237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55217 === (1))){
var state_55216__$1 = state_55216;
var statearr_55219_55238 = state_55216__$1;
(statearr_55219_55238[(2)] = null);

(statearr_55219_55238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55217 === (4))){
var inst_55187 = (state_55216[(2)]);
var state_55216__$1 = state_55216;
var statearr_55220_55239 = state_55216__$1;
(statearr_55220_55239[(2)] = inst_55187);

(statearr_55220_55239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55217 === (6))){
var state_55216__$1 = state_55216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55216__$1,(9),arg);
} else {
if((state_val_55217 === (3))){
var inst_55214 = (state_55216[(2)]);
var state_55216__$1 = state_55216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55216__$1,inst_55214);
} else {
if((state_val_55217 === (2))){
var _ = (function (){var statearr_55222 = state_55216;
(statearr_55222[(4)] = cljs.core.cons((5),(state_55216[(4)])));

return statearr_55222;
})();
var inst_55193 = fluree.db.util.async.channel_QMARK_(arg);
var state_55216__$1 = state_55216;
if(inst_55193){
var statearr_55223_55240 = state_55216__$1;
(statearr_55223_55240[(1)] = (6));

} else {
var statearr_55224_55241 = state_55216__$1;
(statearr_55224_55241[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55217 === (9))){
var inst_55196 = (state_55216[(2)]);
var inst_55197 = fluree.db.util.async.throw_err(inst_55196);
var state_55216__$1 = state_55216;
var statearr_55225_55242 = state_55216__$1;
(statearr_55225_55242[(2)] = inst_55197);

(statearr_55225_55242[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55217 === (5))){
var _ = (function (){var statearr_55226 = state_55216;
(statearr_55226[(4)] = cljs.core.rest((state_55216[(4)])));

return statearr_55226;
})();
var state_55216__$1 = state_55216;
var ex55221 = (state_55216__$1[(2)]);
var statearr_55227_55243 = state_55216__$1;
(statearr_55227_55243[(5)] = ex55221);


if((ex55221 instanceof Error)){
var statearr_55228_55244 = state_55216__$1;
(statearr_55228_55244[(1)] = (4));

(statearr_55228_55244[(5)] = null);

} else {
throw ex55221;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55217 === (8))){
var inst_55200 = (state_55216[(2)]);
var inst_55201 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_55200);
var inst_55202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55203 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55205 = [inst_55200];
var inst_55206 = (new cljs.core.PersistentVector(null,1,(5),inst_55204,inst_55205,null));
var inst_55207 = ["nil?",inst_55206,inst_55201];
var inst_55208 = cljs.core.PersistentHashMap.fromArrays(inst_55203,inst_55207);
var inst_55209 = [inst_55208,(10)];
var inst_55210 = (new cljs.core.PersistentVector(null,2,(5),inst_55202,inst_55209,null));
var inst_55211 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55210);
var _ = (function (){var statearr_55229 = state_55216;
(statearr_55229[(4)] = cljs.core.rest((state_55216[(4)])));

return statearr_55229;
})();
var state_55216__$1 = (function (){var statearr_55230 = state_55216;
(statearr_55230[(7)] = inst_55211);

return statearr_55230;
})();
var statearr_55231_55245 = state_55216__$1;
(statearr_55231_55245[(2)] = inst_55201);

(statearr_55231_55245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_55232 = [null,null,null,null,null,null,null,null];
(statearr_55232[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__);

(statearr_55232[(1)] = (1));

return statearr_55232;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1 = (function (state_55216){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55216);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55233){var ex__2687__auto__ = e55233;
var statearr_55234_55246 = state_55216;
(statearr_55234_55246[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55216[(4)]))){
var statearr_55235_55247 = state_55216;
(statearr_55235_55247[(1)] = cljs.core.first((state_55216[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55248 = state_55216;
state_55216 = G__55248;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = function(state_55216){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1.call(this,state_55216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55236 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55236[(6)] = c__2706__auto__);

return statearr_55236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55278){
var state_val_55279 = (state_55278[(1)]);
if((state_val_55279 === (7))){
var state_55278__$1 = state_55278;
var statearr_55280_55299 = state_55278__$1;
(statearr_55280_55299[(2)] = arg);

(statearr_55280_55299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (1))){
var state_55278__$1 = state_55278;
var statearr_55281_55300 = state_55278__$1;
(statearr_55281_55300[(2)] = null);

(statearr_55281_55300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (4))){
var inst_55249 = (state_55278[(2)]);
var state_55278__$1 = state_55278;
var statearr_55282_55301 = state_55278__$1;
(statearr_55282_55301[(2)] = inst_55249);

(statearr_55282_55301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (6))){
var state_55278__$1 = state_55278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55278__$1,(9),arg);
} else {
if((state_val_55279 === (3))){
var inst_55276 = (state_55278[(2)]);
var state_55278__$1 = state_55278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55278__$1,inst_55276);
} else {
if((state_val_55279 === (2))){
var _ = (function (){var statearr_55284 = state_55278;
(statearr_55284[(4)] = cljs.core.cons((5),(state_55278[(4)])));

return statearr_55284;
})();
var inst_55255 = fluree.db.util.async.channel_QMARK_(arg);
var state_55278__$1 = state_55278;
if(inst_55255){
var statearr_55285_55302 = state_55278__$1;
(statearr_55285_55302[(1)] = (6));

} else {
var statearr_55286_55303 = state_55278__$1;
(statearr_55286_55303[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (9))){
var inst_55258 = (state_55278[(2)]);
var inst_55259 = fluree.db.util.async.throw_err(inst_55258);
var state_55278__$1 = state_55278;
var statearr_55287_55304 = state_55278__$1;
(statearr_55287_55304[(2)] = inst_55259);

(statearr_55287_55304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (5))){
var _ = (function (){var statearr_55288 = state_55278;
(statearr_55288[(4)] = cljs.core.rest((state_55278[(4)])));

return statearr_55288;
})();
var state_55278__$1 = state_55278;
var ex55283 = (state_55278__$1[(2)]);
var statearr_55289_55305 = state_55278__$1;
(statearr_55289_55305[(5)] = ex55283);


if((ex55283 instanceof Error)){
var statearr_55290_55306 = state_55278__$1;
(statearr_55290_55306[(1)] = (4));

(statearr_55290_55306[(5)] = null);

} else {
throw ex55283;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55279 === (8))){
var inst_55262 = (state_55278[(2)]);
var inst_55263 = fluree.db.dbfunctions.internal.not(inst_55262);
var inst_55264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55265 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55267 = [inst_55262];
var inst_55268 = (new cljs.core.PersistentVector(null,1,(5),inst_55266,inst_55267,null));
var inst_55269 = ["not",inst_55268,inst_55263];
var inst_55270 = cljs.core.PersistentHashMap.fromArrays(inst_55265,inst_55269);
var inst_55271 = [inst_55270,(10)];
var inst_55272 = (new cljs.core.PersistentVector(null,2,(5),inst_55264,inst_55271,null));
var inst_55273 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55272);
var _ = (function (){var statearr_55291 = state_55278;
(statearr_55291[(4)] = cljs.core.rest((state_55278[(4)])));

return statearr_55291;
})();
var state_55278__$1 = (function (){var statearr_55292 = state_55278;
(statearr_55292[(7)] = inst_55273);

return statearr_55292;
})();
var statearr_55293_55307 = state_55278__$1;
(statearr_55293_55307[(2)] = inst_55263);

(statearr_55293_55307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0 = (function (){
var statearr_55294 = [null,null,null,null,null,null,null,null];
(statearr_55294[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__);

(statearr_55294[(1)] = (1));

return statearr_55294;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1 = (function (state_55278){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55278);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55295){var ex__2687__auto__ = e55295;
var statearr_55296_55308 = state_55278;
(statearr_55296_55308[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55278[(4)]))){
var statearr_55297_55309 = state_55278;
(statearr_55297_55309[(1)] = cljs.core.first((state_55278[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55310 = state_55278;
state_55278 = G__55310;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = function(state_55278){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1.call(this,state_55278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55298 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55298[(6)] = c__2706__auto__);

return statearr_55298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55340){
var state_val_55341 = (state_55340[(1)]);
if((state_val_55341 === (7))){
var state_55340__$1 = state_55340;
var statearr_55342_55361 = state_55340__$1;
(statearr_55342_55361[(2)] = arg);

(statearr_55342_55361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55341 === (1))){
var state_55340__$1 = state_55340;
var statearr_55343_55362 = state_55340__$1;
(statearr_55343_55362[(2)] = null);

(statearr_55343_55362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55341 === (4))){
var inst_55311 = (state_55340[(2)]);
var state_55340__$1 = state_55340;
var statearr_55344_55363 = state_55340__$1;
(statearr_55344_55363[(2)] = inst_55311);

(statearr_55344_55363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55341 === (6))){
var state_55340__$1 = state_55340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55340__$1,(9),arg);
} else {
if((state_val_55341 === (3))){
var inst_55338 = (state_55340[(2)]);
var state_55340__$1 = state_55340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55340__$1,inst_55338);
} else {
if((state_val_55341 === (2))){
var _ = (function (){var statearr_55346 = state_55340;
(statearr_55346[(4)] = cljs.core.cons((5),(state_55340[(4)])));

return statearr_55346;
})();
var inst_55317 = fluree.db.util.async.channel_QMARK_(arg);
var state_55340__$1 = state_55340;
if(inst_55317){
var statearr_55347_55364 = state_55340__$1;
(statearr_55347_55364[(1)] = (6));

} else {
var statearr_55348_55365 = state_55340__$1;
(statearr_55348_55365[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55341 === (9))){
var inst_55320 = (state_55340[(2)]);
var inst_55321 = fluree.db.util.async.throw_err(inst_55320);
var state_55340__$1 = state_55340;
var statearr_55349_55366 = state_55340__$1;
(statearr_55349_55366[(2)] = inst_55321);

(statearr_55349_55366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55341 === (5))){
var _ = (function (){var statearr_55350 = state_55340;
(statearr_55350[(4)] = cljs.core.rest((state_55340[(4)])));

return statearr_55350;
})();
var state_55340__$1 = state_55340;
var ex55345 = (state_55340__$1[(2)]);
var statearr_55351_55367 = state_55340__$1;
(statearr_55351_55367[(5)] = ex55345);


if((ex55345 instanceof Error)){
var statearr_55352_55368 = state_55340__$1;
(statearr_55352_55368[(1)] = (4));

(statearr_55352_55368[(5)] = null);

} else {
throw ex55345;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55341 === (8))){
var inst_55324 = (state_55340[(2)]);
var inst_55325 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_55324);
var inst_55326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55327 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55329 = [inst_55324];
var inst_55330 = (new cljs.core.PersistentVector(null,1,(5),inst_55328,inst_55329,null));
var inst_55331 = ["empty?",inst_55330,inst_55325];
var inst_55332 = cljs.core.PersistentHashMap.fromArrays(inst_55327,inst_55331);
var inst_55333 = [inst_55332,(10)];
var inst_55334 = (new cljs.core.PersistentVector(null,2,(5),inst_55326,inst_55333,null));
var inst_55335 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55334);
var _ = (function (){var statearr_55353 = state_55340;
(statearr_55353[(4)] = cljs.core.rest((state_55340[(4)])));

return statearr_55353;
})();
var state_55340__$1 = (function (){var statearr_55354 = state_55340;
(statearr_55354[(7)] = inst_55335);

return statearr_55354;
})();
var statearr_55355_55369 = state_55340__$1;
(statearr_55355_55369[(2)] = inst_55325);

(statearr_55355_55369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_55356 = [null,null,null,null,null,null,null,null];
(statearr_55356[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__);

(statearr_55356[(1)] = (1));

return statearr_55356;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1 = (function (state_55340){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55340);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55357){var ex__2687__auto__ = e55357;
var statearr_55358_55370 = state_55340;
(statearr_55358_55370[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55340[(4)]))){
var statearr_55359_55371 = state_55340;
(statearr_55359_55371[(1)] = cljs.core.first((state_55340[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55372 = state_55340;
state_55340 = G__55372;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = function(state_55340){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1.call(this,state_55340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55360 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55360[(6)] = c__2706__auto__);

return statearr_55360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55417 = arguments.length;
var i__5770__auto___55418 = (0);
while(true){
if((i__5770__auto___55418 < len__5769__auto___55417)){
args__5775__auto__.push((arguments[i__5770__auto___55418]));

var G__55419 = (i__5770__auto___55418 + (1));
i__5770__auto___55418 = G__55419;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55400){
var state_val_55401 = (state_55400[(1)]);
if((state_val_55401 === (1))){
var state_55400__$1 = state_55400;
var statearr_55402_55420 = state_55400__$1;
(statearr_55402_55420[(2)] = null);

(statearr_55402_55420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55401 === (2))){
var _ = (function (){var statearr_55403 = state_55400;
(statearr_55403[(4)] = cljs.core.cons((5),(state_55400[(4)])));

return statearr_55403;
})();
var inst_55381 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55400__$1 = state_55400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55400__$1,(6),inst_55381);
} else {
if((state_val_55401 === (3))){
var inst_55398 = (state_55400[(2)]);
var state_55400__$1 = state_55400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55400__$1,inst_55398);
} else {
if((state_val_55401 === (4))){
var inst_55375 = (state_55400[(2)]);
var state_55400__$1 = state_55400;
var statearr_55405_55421 = state_55400__$1;
(statearr_55405_55421[(2)] = inst_55375);

(statearr_55405_55421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55401 === (5))){
var _ = (function (){var statearr_55406 = state_55400;
(statearr_55406[(4)] = cljs.core.rest((state_55400[(4)])));

return statearr_55406;
})();
var state_55400__$1 = state_55400;
var ex55404 = (state_55400__$1[(2)]);
var statearr_55407_55422 = state_55400__$1;
(statearr_55407_55422[(5)] = ex55404);


if((ex55404 instanceof Error)){
var statearr_55408_55423 = state_55400__$1;
(statearr_55408_55423[(1)] = (4));

(statearr_55408_55423[(5)] = null);

} else {
throw ex55404;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55401 === (6))){
var inst_55383 = (state_55400[(2)]);
var inst_55384 = fluree.db.util.async.throw_err(inst_55383);
var inst_55385 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_55384);
var inst_55386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55387 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55389 = [inst_55384];
var inst_55390 = (new cljs.core.PersistentVector(null,1,(5),inst_55388,inst_55389,null));
var inst_55391 = ["str",inst_55390,inst_55385];
var inst_55392 = cljs.core.PersistentHashMap.fromArrays(inst_55387,inst_55391);
var inst_55393 = [inst_55392,(10)];
var inst_55394 = (new cljs.core.PersistentVector(null,2,(5),inst_55386,inst_55393,null));
var inst_55395 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55394);
var _ = (function (){var statearr_55409 = state_55400;
(statearr_55409[(4)] = cljs.core.rest((state_55400[(4)])));

return statearr_55409;
})();
var state_55400__$1 = (function (){var statearr_55410 = state_55400;
(statearr_55410[(7)] = inst_55395);

return statearr_55410;
})();
var statearr_55411_55424 = state_55400__$1;
(statearr_55411_55424[(2)] = inst_55385);

(statearr_55411_55424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55412 = [null,null,null,null,null,null,null,null];
(statearr_55412[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55412[(1)] = (1));

return statearr_55412;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55400){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55400);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55413){var ex__2687__auto__ = e55413;
var statearr_55414_55425 = state_55400;
(statearr_55414_55425[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55400[(4)]))){
var statearr_55415_55426 = state_55400;
(statearr_55415_55426[(1)] = cljs.core.first((state_55400[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55427 = state_55400;
state_55400 = G__55427;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55400){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55416 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55416[(6)] = c__2706__auto__);

return statearr_55416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq55373){
var G__55374 = cljs.core.first(seq55373);
var seq55373__$1 = cljs.core.next(seq55373);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55374,seq55373__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55453){
var state_val_55454 = (state_55453[(1)]);
if((state_val_55454 === (1))){
var state_55453__$1 = state_55453;
var statearr_55455_55470 = state_55453__$1;
(statearr_55455_55470[(2)] = null);

(statearr_55455_55470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55454 === (2))){
var _ = (function (){var statearr_55456 = state_55453;
(statearr_55456[(4)] = cljs.core.cons((5),(state_55453[(4)])));

return statearr_55456;
})();
var inst_55434 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55453__$1 = state_55453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55453__$1,(6),inst_55434);
} else {
if((state_val_55454 === (3))){
var inst_55451 = (state_55453[(2)]);
var state_55453__$1 = state_55453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55453__$1,inst_55451);
} else {
if((state_val_55454 === (4))){
var inst_55428 = (state_55453[(2)]);
var state_55453__$1 = state_55453;
var statearr_55458_55471 = state_55453__$1;
(statearr_55458_55471[(2)] = inst_55428);

(statearr_55458_55471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55454 === (5))){
var _ = (function (){var statearr_55459 = state_55453;
(statearr_55459[(4)] = cljs.core.rest((state_55453[(4)])));

return statearr_55459;
})();
var state_55453__$1 = state_55453;
var ex55457 = (state_55453__$1[(2)]);
var statearr_55460_55472 = state_55453__$1;
(statearr_55460_55472[(5)] = ex55457);


if((ex55457 instanceof Error)){
var statearr_55461_55473 = state_55453__$1;
(statearr_55461_55473[(1)] = (4));

(statearr_55461_55473[(5)] = null);

} else {
throw ex55457;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55454 === (6))){
var inst_55436 = (state_55453[(2)]);
var inst_55437 = fluree.db.util.async.throw_err(inst_55436);
var inst_55438 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_55437);
var inst_55439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55440 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55442 = [inst_55437];
var inst_55443 = (new cljs.core.PersistentVector(null,1,(5),inst_55441,inst_55442,null));
var inst_55444 = ["subs",inst_55443,inst_55438];
var inst_55445 = cljs.core.PersistentHashMap.fromArrays(inst_55440,inst_55444);
var inst_55446 = [inst_55445,(30)];
var inst_55447 = (new cljs.core.PersistentVector(null,2,(5),inst_55439,inst_55446,null));
var inst_55448 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55447);
var _ = (function (){var statearr_55462 = state_55453;
(statearr_55462[(4)] = cljs.core.rest((state_55453[(4)])));

return statearr_55462;
})();
var state_55453__$1 = (function (){var statearr_55463 = state_55453;
(statearr_55463[(7)] = inst_55448);

return statearr_55463;
})();
var statearr_55464_55474 = state_55453__$1;
(statearr_55464_55474[(2)] = inst_55438);

(statearr_55464_55474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0 = (function (){
var statearr_55465 = [null,null,null,null,null,null,null,null];
(statearr_55465[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__);

(statearr_55465[(1)] = (1));

return statearr_55465;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1 = (function (state_55453){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55453);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55466){var ex__2687__auto__ = e55466;
var statearr_55467_55475 = state_55453;
(statearr_55467_55475[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55453[(4)]))){
var statearr_55468_55476 = state_55453;
(statearr_55468_55476[(1)] = cljs.core.first((state_55453[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55477 = state_55453;
state_55453 = G__55477;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = function(state_55453){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1.call(this,state_55453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55469 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55469[(6)] = c__2706__auto__);

return statearr_55469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55507){
var state_val_55508 = (state_55507[(1)]);
if((state_val_55508 === (7))){
var state_55507__$1 = state_55507;
var statearr_55509_55528 = state_55507__$1;
(statearr_55509_55528[(2)] = str);

(statearr_55509_55528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55508 === (1))){
var state_55507__$1 = state_55507;
var statearr_55510_55529 = state_55507__$1;
(statearr_55510_55529[(2)] = null);

(statearr_55510_55529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55508 === (4))){
var inst_55478 = (state_55507[(2)]);
var state_55507__$1 = state_55507;
var statearr_55511_55530 = state_55507__$1;
(statearr_55511_55530[(2)] = inst_55478);

(statearr_55511_55530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55508 === (6))){
var state_55507__$1 = state_55507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55507__$1,(9),str);
} else {
if((state_val_55508 === (3))){
var inst_55505 = (state_55507[(2)]);
var state_55507__$1 = state_55507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55507__$1,inst_55505);
} else {
if((state_val_55508 === (2))){
var _ = (function (){var statearr_55513 = state_55507;
(statearr_55513[(4)] = cljs.core.cons((5),(state_55507[(4)])));

return statearr_55513;
})();
var inst_55484 = fluree.db.util.async.channel_QMARK_(str);
var state_55507__$1 = state_55507;
if(inst_55484){
var statearr_55514_55531 = state_55507__$1;
(statearr_55514_55531[(1)] = (6));

} else {
var statearr_55515_55532 = state_55507__$1;
(statearr_55515_55532[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55508 === (9))){
var inst_55487 = (state_55507[(2)]);
var inst_55488 = fluree.db.util.async.throw_err(inst_55487);
var state_55507__$1 = state_55507;
var statearr_55516_55533 = state_55507__$1;
(statearr_55516_55533[(2)] = inst_55488);

(statearr_55516_55533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55508 === (5))){
var _ = (function (){var statearr_55517 = state_55507;
(statearr_55517[(4)] = cljs.core.rest((state_55507[(4)])));

return statearr_55517;
})();
var state_55507__$1 = state_55507;
var ex55512 = (state_55507__$1[(2)]);
var statearr_55518_55534 = state_55507__$1;
(statearr_55518_55534[(5)] = ex55512);


if((ex55512 instanceof Error)){
var statearr_55519_55535 = state_55507__$1;
(statearr_55519_55535[(1)] = (4));

(statearr_55519_55535[(5)] = null);

} else {
throw ex55512;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55508 === (8))){
var inst_55491 = (state_55507[(2)]);
var inst_55492 = fluree.db.dbfunctions.internal.lower_case(inst_55491);
var inst_55493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55494 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55496 = [inst_55491];
var inst_55497 = (new cljs.core.PersistentVector(null,1,(5),inst_55495,inst_55496,null));
var inst_55498 = ["lower-case",inst_55497,inst_55492];
var inst_55499 = cljs.core.PersistentHashMap.fromArrays(inst_55494,inst_55498);
var inst_55500 = [inst_55499,(10)];
var inst_55501 = (new cljs.core.PersistentVector(null,2,(5),inst_55493,inst_55500,null));
var inst_55502 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55501);
var _ = (function (){var statearr_55520 = state_55507;
(statearr_55520[(4)] = cljs.core.rest((state_55507[(4)])));

return statearr_55520;
})();
var state_55507__$1 = (function (){var statearr_55521 = state_55507;
(statearr_55521[(7)] = inst_55502);

return statearr_55521;
})();
var statearr_55522_55536 = state_55507__$1;
(statearr_55522_55536[(2)] = inst_55492);

(statearr_55522_55536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0 = (function (){
var statearr_55523 = [null,null,null,null,null,null,null,null];
(statearr_55523[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__);

(statearr_55523[(1)] = (1));

return statearr_55523;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1 = (function (state_55507){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55507);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55524){var ex__2687__auto__ = e55524;
var statearr_55525_55537 = state_55507;
(statearr_55525_55537[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55507[(4)]))){
var statearr_55526_55538 = state_55507;
(statearr_55526_55538[(1)] = cljs.core.first((state_55507[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55539 = state_55507;
state_55507 = G__55539;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = function(state_55507){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1.call(this,state_55507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55527 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55527[(6)] = c__2706__auto__);

return statearr_55527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55569){
var state_val_55570 = (state_55569[(1)]);
if((state_val_55570 === (7))){
var state_55569__$1 = state_55569;
var statearr_55571_55590 = state_55569__$1;
(statearr_55571_55590[(2)] = str);

(statearr_55571_55590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55570 === (1))){
var state_55569__$1 = state_55569;
var statearr_55572_55591 = state_55569__$1;
(statearr_55572_55591[(2)] = null);

(statearr_55572_55591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55570 === (4))){
var inst_55540 = (state_55569[(2)]);
var state_55569__$1 = state_55569;
var statearr_55573_55592 = state_55569__$1;
(statearr_55573_55592[(2)] = inst_55540);

(statearr_55573_55592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55570 === (6))){
var state_55569__$1 = state_55569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55569__$1,(9),str);
} else {
if((state_val_55570 === (3))){
var inst_55567 = (state_55569[(2)]);
var state_55569__$1 = state_55569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55569__$1,inst_55567);
} else {
if((state_val_55570 === (2))){
var _ = (function (){var statearr_55575 = state_55569;
(statearr_55575[(4)] = cljs.core.cons((5),(state_55569[(4)])));

return statearr_55575;
})();
var inst_55546 = fluree.db.util.async.channel_QMARK_(str);
var state_55569__$1 = state_55569;
if(inst_55546){
var statearr_55576_55593 = state_55569__$1;
(statearr_55576_55593[(1)] = (6));

} else {
var statearr_55577_55594 = state_55569__$1;
(statearr_55577_55594[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55570 === (9))){
var inst_55549 = (state_55569[(2)]);
var inst_55550 = fluree.db.util.async.throw_err(inst_55549);
var state_55569__$1 = state_55569;
var statearr_55578_55595 = state_55569__$1;
(statearr_55578_55595[(2)] = inst_55550);

(statearr_55578_55595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55570 === (5))){
var _ = (function (){var statearr_55579 = state_55569;
(statearr_55579[(4)] = cljs.core.rest((state_55569[(4)])));

return statearr_55579;
})();
var state_55569__$1 = state_55569;
var ex55574 = (state_55569__$1[(2)]);
var statearr_55580_55596 = state_55569__$1;
(statearr_55580_55596[(5)] = ex55574);


if((ex55574 instanceof Error)){
var statearr_55581_55597 = state_55569__$1;
(statearr_55581_55597[(1)] = (4));

(statearr_55581_55597[(5)] = null);

} else {
throw ex55574;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55570 === (8))){
var inst_55553 = (state_55569[(2)]);
var inst_55554 = fluree.db.dbfunctions.internal.upper_case(inst_55553);
var inst_55555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55556 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55558 = [inst_55553];
var inst_55559 = (new cljs.core.PersistentVector(null,1,(5),inst_55557,inst_55558,null));
var inst_55560 = ["upper-case",inst_55559,inst_55554];
var inst_55561 = cljs.core.PersistentHashMap.fromArrays(inst_55556,inst_55560);
var inst_55562 = [inst_55561,(10)];
var inst_55563 = (new cljs.core.PersistentVector(null,2,(5),inst_55555,inst_55562,null));
var inst_55564 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55563);
var _ = (function (){var statearr_55582 = state_55569;
(statearr_55582[(4)] = cljs.core.rest((state_55569[(4)])));

return statearr_55582;
})();
var state_55569__$1 = (function (){var statearr_55583 = state_55569;
(statearr_55583[(7)] = inst_55564);

return statearr_55583;
})();
var statearr_55584_55598 = state_55569__$1;
(statearr_55584_55598[(2)] = inst_55554);

(statearr_55584_55598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0 = (function (){
var statearr_55585 = [null,null,null,null,null,null,null,null];
(statearr_55585[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__);

(statearr_55585[(1)] = (1));

return statearr_55585;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1 = (function (state_55569){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55569);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55586){var ex__2687__auto__ = e55586;
var statearr_55587_55599 = state_55569;
(statearr_55587_55599[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55569[(4)]))){
var statearr_55588_55600 = state_55569;
(statearr_55588_55600[(1)] = cljs.core.first((state_55569[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55601 = state_55569;
state_55569 = G__55601;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = function(state_55569){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1.call(this,state_55569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55589 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55589[(6)] = c__2706__auto__);

return statearr_55589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__55603 = arguments.length;
switch (G__55603) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55631){
var state_val_55632 = (state_55631[(1)]);
if((state_val_55632 === (1))){
var state_55631__$1 = state_55631;
var statearr_55633_55649 = state_55631__$1;
(statearr_55633_55649[(2)] = null);

(statearr_55633_55649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55632 === (2))){
var _ = (function (){var statearr_55634 = state_55631;
(statearr_55634[(4)] = cljs.core.cons((5),(state_55631[(4)])));

return statearr_55634;
})();
var inst_55613 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_55631__$1 = state_55631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55631__$1,(6),inst_55613);
} else {
if((state_val_55632 === (3))){
var inst_55629 = (state_55631[(2)]);
var state_55631__$1 = state_55631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55631__$1,inst_55629);
} else {
if((state_val_55632 === (4))){
var inst_55604 = (state_55631[(2)]);
var state_55631__$1 = state_55631;
var statearr_55636_55650 = state_55631__$1;
(statearr_55636_55650[(2)] = inst_55604);

(statearr_55636_55650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55632 === (5))){
var _ = (function (){var statearr_55637 = state_55631;
(statearr_55637[(4)] = cljs.core.rest((state_55631[(4)])));

return statearr_55637;
})();
var state_55631__$1 = state_55631;
var ex55635 = (state_55631__$1[(2)]);
var statearr_55638_55651 = state_55631__$1;
(statearr_55638_55651[(5)] = ex55635);


if((ex55635 instanceof Error)){
var statearr_55639_55652 = state_55631__$1;
(statearr_55639_55652[(1)] = (4));

(statearr_55639_55652[(5)] = null);

} else {
throw ex55635;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55632 === (6))){
var inst_55615 = (state_55631[(2)]);
var inst_55616 = fluree.db.util.async.throw_err(inst_55615);
var inst_55617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55616,(0),null);
var inst_55618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55616,(1),null);
var inst_55619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55620 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55621 = ["?s","?ctx",inst_55617];
var inst_55622 = cljs.core.PersistentHashMap.fromArrays(inst_55620,inst_55621);
var inst_55623 = ((10) + inst_55618);
var inst_55624 = [inst_55622,inst_55623];
var inst_55625 = (new cljs.core.PersistentVector(null,2,(5),inst_55619,inst_55624,null));
var inst_55626 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55625);
var _ = (function (){var statearr_55640 = state_55631;
(statearr_55640[(4)] = cljs.core.rest((state_55631[(4)])));

return statearr_55640;
})();
var state_55631__$1 = (function (){var statearr_55641 = state_55631;
(statearr_55641[(7)] = inst_55626);

return statearr_55641;
})();
var statearr_55642_55653 = state_55631__$1;
(statearr_55642_55653[(2)] = inst_55617);

(statearr_55642_55653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55643 = [null,null,null,null,null,null,null,null];
(statearr_55643[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55643[(1)] = (1));

return statearr_55643;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55631){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55631);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55644){var ex__2687__auto__ = e55644;
var statearr_55645_55654 = state_55631;
(statearr_55645_55654[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55631[(4)]))){
var statearr_55646_55655 = state_55631;
(statearr_55646_55655[(1)] = cljs.core.first((state_55631[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55656 = state_55631;
state_55631 = G__55656;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55631){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55647 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55647[(6)] = c__2706__auto__);

return statearr_55647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__55658 = arguments.length;
switch (G__55658) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55696){
var state_val_55697 = (state_55696[(1)]);
if((state_val_55697 === (7))){
var inst_55689 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_55696__$1 = state_55696;
var statearr_55698_55718 = state_55696__$1;
(statearr_55698_55718[(2)] = inst_55689);

(statearr_55698_55718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55697 === (1))){
var state_55696__$1 = state_55696;
var statearr_55699_55719 = state_55696__$1;
(statearr_55699_55719[(2)] = null);

(statearr_55699_55719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55697 === (4))){
var inst_55659 = (state_55696[(2)]);
var state_55696__$1 = state_55696;
var statearr_55700_55720 = state_55696__$1;
(statearr_55700_55720[(2)] = inst_55659);

(statearr_55700_55720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55697 === (6))){
var inst_55670 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_55696__$1 = state_55696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55696__$1,(10),inst_55670);
} else {
if((state_val_55697 === (3))){
var inst_55694 = (state_55696[(2)]);
var state_55696__$1 = state_55696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55696__$1,inst_55694);
} else {
if((state_val_55697 === (2))){
var _ = (function (){var statearr_55702 = state_55696;
(statearr_55702[(4)] = cljs.core.cons((5),(state_55696[(4)])));

return statearr_55702;
})();
var inst_55665 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55696__$1 = state_55696;
if(cljs.core.truth_(inst_55665)){
var statearr_55703_55721 = state_55696__$1;
(statearr_55703_55721[(1)] = (6));

} else {
var statearr_55704_55722 = state_55696__$1;
(statearr_55704_55722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55697 === (9))){
var inst_55676 = (state_55696[(2)]);
var inst_55677 = fluree.db.util.async.throw_err(inst_55676);
var inst_55678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55677,(0),null);
var inst_55679 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55677,(1),null);
var inst_55680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55681 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55682 = ["?p","?ctx",inst_55678];
var inst_55683 = cljs.core.PersistentHashMap.fromArrays(inst_55681,inst_55682);
var inst_55684 = ((10) + inst_55679);
var inst_55685 = [inst_55683,inst_55684];
var inst_55686 = (new cljs.core.PersistentVector(null,2,(5),inst_55680,inst_55685,null));
var inst_55687 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55686);
var state_55696__$1 = (function (){var statearr_55705 = state_55696;
(statearr_55705[(7)] = inst_55687);

return statearr_55705;
})();
var statearr_55706_55723 = state_55696__$1;
(statearr_55706_55723[(2)] = inst_55678);

(statearr_55706_55723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55697 === (5))){
var _ = (function (){var statearr_55707 = state_55696;
(statearr_55707[(4)] = cljs.core.rest((state_55696[(4)])));

return statearr_55707;
})();
var state_55696__$1 = state_55696;
var ex55701 = (state_55696__$1[(2)]);
var statearr_55708_55724 = state_55696__$1;
(statearr_55708_55724[(5)] = ex55701);


if((ex55701 instanceof Error)){
var statearr_55709_55725 = state_55696__$1;
(statearr_55709_55725[(1)] = (4));

(statearr_55709_55725[(5)] = null);

} else {
throw ex55701;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55697 === (10))){
var inst_55672 = (state_55696[(2)]);
var inst_55673 = fluree.db.util.async.throw_err(inst_55672);
var inst_55674 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_55673);
var state_55696__$1 = state_55696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55696__$1,(9),inst_55674);
} else {
if((state_val_55697 === (8))){
var inst_55691 = (state_55696[(2)]);
var _ = (function (){var statearr_55710 = state_55696;
(statearr_55710[(4)] = cljs.core.rest((state_55696[(4)])));

return statearr_55710;
})();
var state_55696__$1 = state_55696;
var statearr_55711_55726 = state_55696__$1;
(statearr_55711_55726[(2)] = inst_55691);

(statearr_55711_55726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55712 = [null,null,null,null,null,null,null,null];
(statearr_55712[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55712[(1)] = (1));

return statearr_55712;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55696){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55696);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55713){var ex__2687__auto__ = e55713;
var statearr_55714_55727 = state_55696;
(statearr_55714_55727[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55696[(4)]))){
var statearr_55715_55728 = state_55696;
(statearr_55715_55728[(1)] = cljs.core.first((state_55696[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55729 = state_55696;
state_55696 = G__55729;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55696){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55716 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55716[(6)] = c__2706__auto__);

return statearr_55716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55778 = arguments.length;
var i__5770__auto___55779 = (0);
while(true){
if((i__5770__auto___55779 < len__5769__auto___55778)){
args__5775__auto__.push((arguments[i__5770__auto___55779]));

var G__55780 = (i__5770__auto___55779 + (1));
i__5770__auto___55779 = G__55780;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55761){
var state_val_55762 = (state_55761[(1)]);
if((state_val_55762 === (1))){
var state_55761__$1 = state_55761;
var statearr_55763_55781 = state_55761__$1;
(statearr_55763_55781[(2)] = null);

(statearr_55763_55781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55762 === (2))){
var _ = (function (){var statearr_55764 = state_55761;
(statearr_55764[(4)] = cljs.core.cons((5),(state_55761[(4)])));

return statearr_55764;
})();
var inst_55738 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55761__$1 = state_55761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55761__$1,(6),inst_55738);
} else {
if((state_val_55762 === (3))){
var inst_55759 = (state_55761[(2)]);
var state_55761__$1 = state_55761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55761__$1,inst_55759);
} else {
if((state_val_55762 === (4))){
var inst_55732 = (state_55761[(2)]);
var state_55761__$1 = state_55761;
var statearr_55766_55782 = state_55761__$1;
(statearr_55766_55782[(2)] = inst_55732);

(statearr_55766_55782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55762 === (5))){
var _ = (function (){var statearr_55767 = state_55761;
(statearr_55767[(4)] = cljs.core.rest((state_55761[(4)])));

return statearr_55767;
})();
var state_55761__$1 = state_55761;
var ex55765 = (state_55761__$1[(2)]);
var statearr_55768_55783 = state_55761__$1;
(statearr_55768_55783[(5)] = ex55765);


if((ex55765 instanceof Error)){
var statearr_55769_55784 = state_55761__$1;
(statearr_55769_55784[(1)] = (4));

(statearr_55769_55784[(5)] = null);

} else {
throw ex55765;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55762 === (6))){
var inst_55740 = (state_55761[(2)]);
var inst_55741 = fluree.db.util.async.throw_err(inst_55740);
var inst_55742 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_55741);
var inst_55743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55744 = [inst_55741];
var inst_55745 = (new cljs.core.PersistentVector(null,1,(5),inst_55743,inst_55744,null));
var inst_55746 = cljs.core.count(inst_55745);
var inst_55747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55748 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55750 = [inst_55741];
var inst_55751 = (new cljs.core.PersistentVector(null,1,(5),inst_55749,inst_55750,null));
var inst_55752 = ["and",inst_55751,inst_55742];
var inst_55753 = cljs.core.PersistentHashMap.fromArrays(inst_55748,inst_55752);
var inst_55754 = [inst_55753,inst_55746];
var inst_55755 = (new cljs.core.PersistentVector(null,2,(5),inst_55747,inst_55754,null));
var inst_55756 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55755);
var _ = (function (){var statearr_55770 = state_55761;
(statearr_55770[(4)] = cljs.core.rest((state_55761[(4)])));

return statearr_55770;
})();
var state_55761__$1 = (function (){var statearr_55771 = state_55761;
(statearr_55771[(7)] = inst_55756);

return statearr_55771;
})();
var statearr_55772_55785 = state_55761__$1;
(statearr_55772_55785[(2)] = inst_55742);

(statearr_55772_55785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55773 = [null,null,null,null,null,null,null,null];
(statearr_55773[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55773[(1)] = (1));

return statearr_55773;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55761){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55761);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55774){var ex__2687__auto__ = e55774;
var statearr_55775_55786 = state_55761;
(statearr_55775_55786[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55761[(4)]))){
var statearr_55776_55787 = state_55761;
(statearr_55776_55787[(1)] = cljs.core.first((state_55761[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55788 = state_55761;
state_55761 = G__55788;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55761){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55777 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55777[(6)] = c__2706__auto__);

return statearr_55777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq55730){
var G__55731 = cljs.core.first(seq55730);
var seq55730__$1 = cljs.core.next(seq55730);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55731,seq55730__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55837 = arguments.length;
var i__5770__auto___55838 = (0);
while(true){
if((i__5770__auto___55838 < len__5769__auto___55837)){
args__5775__auto__.push((arguments[i__5770__auto___55838]));

var G__55839 = (i__5770__auto___55838 + (1));
i__5770__auto___55838 = G__55839;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55820){
var state_val_55821 = (state_55820[(1)]);
if((state_val_55821 === (1))){
var state_55820__$1 = state_55820;
var statearr_55822_55840 = state_55820__$1;
(statearr_55822_55840[(2)] = null);

(statearr_55822_55840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (2))){
var _ = (function (){var statearr_55823 = state_55820;
(statearr_55823[(4)] = cljs.core.cons((5),(state_55820[(4)])));

return statearr_55823;
})();
var inst_55797 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55820__$1 = state_55820;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55820__$1,(6),inst_55797);
} else {
if((state_val_55821 === (3))){
var inst_55818 = (state_55820[(2)]);
var state_55820__$1 = state_55820;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55820__$1,inst_55818);
} else {
if((state_val_55821 === (4))){
var inst_55791 = (state_55820[(2)]);
var state_55820__$1 = state_55820;
var statearr_55825_55841 = state_55820__$1;
(statearr_55825_55841[(2)] = inst_55791);

(statearr_55825_55841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (5))){
var _ = (function (){var statearr_55826 = state_55820;
(statearr_55826[(4)] = cljs.core.rest((state_55820[(4)])));

return statearr_55826;
})();
var state_55820__$1 = state_55820;
var ex55824 = (state_55820__$1[(2)]);
var statearr_55827_55842 = state_55820__$1;
(statearr_55827_55842[(5)] = ex55824);


if((ex55824 instanceof Error)){
var statearr_55828_55843 = state_55820__$1;
(statearr_55828_55843[(1)] = (4));

(statearr_55828_55843[(5)] = null);

} else {
throw ex55824;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (6))){
var inst_55799 = (state_55820[(2)]);
var inst_55800 = fluree.db.util.async.throw_err(inst_55799);
var inst_55801 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_55800);
var inst_55802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55803 = [inst_55800];
var inst_55804 = (new cljs.core.PersistentVector(null,1,(5),inst_55802,inst_55803,null));
var inst_55805 = cljs.core.count(inst_55804);
var inst_55806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55807 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55809 = [inst_55800];
var inst_55810 = (new cljs.core.PersistentVector(null,1,(5),inst_55808,inst_55809,null));
var inst_55811 = ["or",inst_55810,inst_55801];
var inst_55812 = cljs.core.PersistentHashMap.fromArrays(inst_55807,inst_55811);
var inst_55813 = [inst_55812,inst_55805];
var inst_55814 = (new cljs.core.PersistentVector(null,2,(5),inst_55806,inst_55813,null));
var inst_55815 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55814);
var _ = (function (){var statearr_55829 = state_55820;
(statearr_55829[(4)] = cljs.core.rest((state_55820[(4)])));

return statearr_55829;
})();
var state_55820__$1 = (function (){var statearr_55830 = state_55820;
(statearr_55830[(7)] = inst_55815);

return statearr_55830;
})();
var statearr_55831_55844 = state_55820__$1;
(statearr_55831_55844[(2)] = inst_55801);

(statearr_55831_55844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55832 = [null,null,null,null,null,null,null,null];
(statearr_55832[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55832[(1)] = (1));

return statearr_55832;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55820){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55820);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55833){var ex__2687__auto__ = e55833;
var statearr_55834_55845 = state_55820;
(statearr_55834_55845[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55820[(4)]))){
var statearr_55835_55846 = state_55820;
(statearr_55835_55846[(1)] = cljs.core.first((state_55820[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55847 = state_55820;
state_55820 = G__55847;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55820){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55836 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55836[(6)] = c__2706__auto__);

return statearr_55836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55789){
var G__55790 = cljs.core.first(seq55789);
var seq55789__$1 = cljs.core.next(seq55789);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55790,seq55789__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55885){
var state_val_55886 = (state_55885[(1)]);
if((state_val_55886 === (7))){
var inst_55861 = fluree.db.util.async.channel_QMARK_(coll);
var state_55885__$1 = state_55885;
if(inst_55861){
var statearr_55887_55910 = state_55885__$1;
(statearr_55887_55910[(1)] = (10));

} else {
var statearr_55888_55911 = state_55885__$1;
(statearr_55888_55911[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (1))){
var state_55885__$1 = state_55885;
var statearr_55889_55912 = state_55885__$1;
(statearr_55889_55912[(2)] = null);

(statearr_55889_55912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (4))){
var inst_55848 = (state_55885[(2)]);
var state_55885__$1 = state_55885;
var statearr_55890_55913 = state_55885__$1;
(statearr_55890_55913[(2)] = inst_55848);

(statearr_55890_55913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (13))){
var inst_55864 = (state_55885[(2)]);
var inst_55865 = fluree.db.util.async.throw_err(inst_55864);
var state_55885__$1 = state_55885;
var statearr_55891_55914 = state_55885__$1;
(statearr_55891_55914[(2)] = inst_55865);

(statearr_55891_55914[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (6))){
var inst_55856 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_55885__$1 = state_55885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55885__$1,(9),inst_55856);
} else {
if((state_val_55886 === (3))){
var inst_55883 = (state_55885[(2)]);
var state_55885__$1 = state_55885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55885__$1,inst_55883);
} else {
if((state_val_55886 === (12))){
var inst_55868 = (state_55885[(2)]);
var state_55885__$1 = state_55885;
var statearr_55892_55915 = state_55885__$1;
(statearr_55892_55915[(2)] = inst_55868);

(statearr_55892_55915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (2))){
var _ = (function (){var statearr_55893 = state_55885;
(statearr_55893[(4)] = cljs.core.cons((5),(state_55885[(4)])));

return statearr_55893;
})();
var inst_55854 = cljs.core.vector_QMARK_(coll);
var state_55885__$1 = state_55885;
if(inst_55854){
var statearr_55894_55916 = state_55885__$1;
(statearr_55894_55916[(1)] = (6));

} else {
var statearr_55895_55917 = state_55885__$1;
(statearr_55895_55917[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (11))){
var state_55885__$1 = state_55885;
var statearr_55897_55918 = state_55885__$1;
(statearr_55897_55918[(2)] = coll);

(statearr_55897_55918[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (9))){
var inst_55858 = (state_55885[(2)]);
var inst_55859 = fluree.db.util.async.throw_err(inst_55858);
var state_55885__$1 = state_55885;
var statearr_55898_55919 = state_55885__$1;
(statearr_55898_55919[(2)] = inst_55859);

(statearr_55898_55919[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (5))){
var _ = (function (){var statearr_55899 = state_55885;
(statearr_55899[(4)] = cljs.core.rest((state_55885[(4)])));

return statearr_55899;
})();
var state_55885__$1 = state_55885;
var ex55896 = (state_55885__$1[(2)]);
var statearr_55900_55920 = state_55885__$1;
(statearr_55900_55920[(5)] = ex55896);


if((ex55896 instanceof Error)){
var statearr_55901_55921 = state_55885__$1;
(statearr_55901_55921[(1)] = (4));

(statearr_55901_55921[(5)] = null);

} else {
throw ex55896;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55886 === (10))){
var state_55885__$1 = state_55885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55885__$1,(13),coll);
} else {
if((state_val_55886 === (8))){
var inst_55870 = (state_55885[(2)]);
var inst_55871 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_55870);
var inst_55872 = cljs.core.count(inst_55871);
var inst_55873 = ((9) + inst_55872);
var inst_55874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55875 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55876 = ["count",inst_55870,inst_55872];
var inst_55877 = cljs.core.PersistentHashMap.fromArrays(inst_55875,inst_55876);
var inst_55878 = [inst_55877,inst_55873];
var inst_55879 = (new cljs.core.PersistentVector(null,2,(5),inst_55874,inst_55878,null));
var inst_55880 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55879);
var _ = (function (){var statearr_55902 = state_55885;
(statearr_55902[(4)] = cljs.core.rest((state_55885[(4)])));

return statearr_55902;
})();
var state_55885__$1 = (function (){var statearr_55903 = state_55885;
(statearr_55903[(7)] = inst_55880);

return statearr_55903;
})();
var statearr_55904_55922 = state_55885__$1;
(statearr_55904_55922[(2)] = inst_55872);

(statearr_55904_55922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0 = (function (){
var statearr_55905 = [null,null,null,null,null,null,null,null];
(statearr_55905[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__);

(statearr_55905[(1)] = (1));

return statearr_55905;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1 = (function (state_55885){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55885);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55906){var ex__2687__auto__ = e55906;
var statearr_55907_55923 = state_55885;
(statearr_55907_55923[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55885[(4)]))){
var statearr_55908_55924 = state_55885;
(statearr_55908_55924[(1)] = cljs.core.first((state_55885[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55925 = state_55885;
state_55885 = G__55925;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = function(state_55885){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1.call(this,state_55885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55909 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55909[(6)] = c__2706__auto__);

return statearr_55909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__55926,subject,pred){
var map__55927 = p__55926;
var map__55927__$1 = cljs.core.__destructure_map(map__55927);
var _QMARK_ctx = map__55927__$1;
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55927__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55927__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56018){
var state_val_56019 = (state_56018[(1)]);
if((state_val_56019 === (7))){
var state_56018__$1 = state_56018;
var statearr_56020_56076 = state_56018__$1;
(statearr_56020_56076[(2)] = subject);

(statearr_56020_56076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (20))){
var state_56018__$1 = state_56018;
var statearr_56021_56077 = state_56018__$1;
(statearr_56021_56077[(2)] = cache);

(statearr_56021_56077[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (27))){
var inst_55949 = (state_56018[(7)]);
var inst_55961 = (state_56018[(8)]);
var inst_55975 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_55961,inst_55949);
var state_56018__$1 = state_56018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56018__$1,(29),inst_55975);
} else {
if((state_val_56019 === (1))){
var state_56018__$1 = state_56018;
var statearr_56022_56078 = state_56018__$1;
(statearr_56022_56078[(2)] = null);

(statearr_56022_56078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (24))){
var inst_55961 = (state_56018[(8)]);
var inst_55988 = cljs.core.int_QMARK_(inst_55961);
var state_56018__$1 = state_56018;
if(inst_55988){
var statearr_56023_56079 = state_56018__$1;
(statearr_56023_56079[(1)] = (30));

} else {
var statearr_56024_56080 = state_56018__$1;
(statearr_56024_56080[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (4))){
var inst_55928 = (state_56018[(2)]);
var state_56018__$1 = state_56018;
var statearr_56025_56081 = state_56018__$1;
(statearr_56025_56081[(2)] = inst_55928);

(statearr_56025_56081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (15))){
var inst_55941 = (state_56018[(9)]);
var state_56018__$1 = state_56018;
var statearr_56026_56082 = state_56018__$1;
(statearr_56026_56082[(2)] = inst_55941);

(statearr_56026_56082[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (21))){
var inst_55962 = (state_56018[(10)]);
var state_56018__$1 = state_56018;
var statearr_56027_56083 = state_56018__$1;
(statearr_56027_56083[(2)] = inst_55962);

(statearr_56027_56083[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (31))){
var state_56018__$1 = state_56018;
var statearr_56028_56084 = state_56018__$1;
(statearr_56028_56084[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (32))){
var inst_56001 = (state_56018[(2)]);
var state_56018__$1 = state_56018;
var statearr_56030_56085 = state_56018__$1;
(statearr_56030_56085[(2)] = inst_56001);

(statearr_56030_56085[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (33))){
var inst_55992 = (state_56018[(2)]);
var inst_55993 = fluree.db.util.async.throw_err(inst_55992);
var state_56018__$1 = state_56018;
var statearr_56031_56086 = state_56018__$1;
(statearr_56031_56086[(2)] = inst_55993);

(statearr_56031_56086[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (13))){
var inst_55945 = (state_56018[(2)]);
var inst_55946 = fluree.db.util.async.throw_err(inst_55945);
var state_56018__$1 = state_56018;
var statearr_56032_56087 = state_56018__$1;
(statearr_56032_56087[(2)] = inst_55946);

(statearr_56032_56087[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (22))){
var inst_55966 = (state_56018[(2)]);
var state_56018__$1 = state_56018;
if(cljs.core.truth_(inst_55966)){
var statearr_56033_56088 = state_56018__$1;
(statearr_56033_56088[(1)] = (23));

} else {
var statearr_56034_56089 = state_56018__$1;
(statearr_56034_56089[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (36))){
var inst_55999 = (state_56018[(2)]);
var state_56018__$1 = state_56018;
var statearr_56035_56090 = state_56018__$1;
(statearr_56035_56090[(2)] = inst_55999);

(statearr_56035_56090[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (29))){
var inst_55949 = (state_56018[(7)]);
var inst_55961 = (state_56018[(8)]);
var inst_55977 = (state_56018[(2)]);
var inst_55978 = fluree.db.util.async.throw_err(inst_55977);
var inst_55979 = cljs.core._deref(cache);
var inst_55980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55981 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_55961,inst_55949];
var inst_55982 = (new cljs.core.PersistentVector(null,3,(5),inst_55980,inst_55981,null));
var inst_55983 = cljs.core.assoc_in(inst_55979,inst_55982,inst_55978);
var inst_55984 = cljs.core._vreset_BANG_(cache,inst_55983);
var state_56018__$1 = (function (){var statearr_56036 = state_56018;
(statearr_56036[(11)] = inst_55984);

return statearr_56036;
})();
var statearr_56037_56091 = state_56018__$1;
(statearr_56037_56091[(2)] = inst_55978);

(statearr_56037_56091[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (6))){
var state_56018__$1 = state_56018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56018__$1,(9),subject);
} else {
if((state_val_56019 === (28))){
var inst_55986 = (state_56018[(2)]);
var state_56018__$1 = state_56018;
var statearr_56038_56092 = state_56018__$1;
(statearr_56038_56092[(2)] = inst_55986);

(statearr_56038_56092[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (25))){
var inst_55949 = (state_56018[(7)]);
var inst_55941 = (state_56018[(9)]);
var inst_56003 = (state_56018[(2)]);
var inst_56004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56005 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56007 = [inst_55941,inst_55949];
var inst_56008 = (new cljs.core.PersistentVector(null,2,(5),inst_56006,inst_56007,null));
var inst_56009 = ["get",inst_56008,inst_56003];
var inst_56010 = cljs.core.PersistentHashMap.fromArrays(inst_56005,inst_56009);
var inst_56011 = [inst_56010,(10)];
var inst_56012 = (new cljs.core.PersistentVector(null,2,(5),inst_56004,inst_56011,null));
var inst_56013 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56012);
var _ = (function (){var statearr_56039 = state_56018;
(statearr_56039[(4)] = cljs.core.rest((state_56018[(4)])));

return statearr_56039;
})();
var state_56018__$1 = (function (){var statearr_56040 = state_56018;
(statearr_56040[(12)] = inst_56013);

return statearr_56040;
})();
var statearr_56041_56093 = state_56018__$1;
(statearr_56041_56093[(2)] = inst_56003);

(statearr_56041_56093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (34))){
var inst_55949 = (state_56018[(7)]);
var inst_55961 = (state_56018[(8)]);
var inst_55996 = fluree.db.dbfunctions.internal.get(inst_55961,inst_55949);
var state_56018__$1 = state_56018;
var statearr_56042_56094 = state_56018__$1;
(statearr_56042_56094[(2)] = inst_55996);

(statearr_56042_56094[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (17))){
var inst_55941 = (state_56018[(9)]);
var inst_55955 = cljs.core.first(inst_55941);
var state_56018__$1 = state_56018;
var statearr_56043_56095 = state_56018__$1;
(statearr_56043_56095[(2)] = inst_55955);

(statearr_56043_56095[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (3))){
var inst_56016 = (state_56018[(2)]);
var state_56018__$1 = state_56018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56018__$1,inst_56016);
} else {
if((state_val_56019 === (12))){
var inst_55941 = (state_56018[(9)]);
var inst_55949 = (state_56018[(2)]);
var inst_55950 = cljs.core.vector_QMARK_(inst_55941);
var state_56018__$1 = (function (){var statearr_56044 = state_56018;
(statearr_56044[(7)] = inst_55949);

return statearr_56044;
})();
if(inst_55950){
var statearr_56045_56096 = state_56018__$1;
(statearr_56045_56096[(1)] = (14));

} else {
var statearr_56046_56097 = state_56018__$1;
(statearr_56046_56097[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (2))){
var _ = (function (){var statearr_56047 = state_56018;
(statearr_56047[(4)] = cljs.core.cons((5),(state_56018[(4)])));

return statearr_56047;
})();
var inst_55934 = fluree.db.util.async.channel_QMARK_(subject);
var state_56018__$1 = state_56018;
if(inst_55934){
var statearr_56048_56098 = state_56018__$1;
(statearr_56048_56098[(1)] = (6));

} else {
var statearr_56049_56099 = state_56018__$1;
(statearr_56049_56099[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (23))){
var inst_55949 = (state_56018[(7)]);
var inst_55972 = (state_56018[(13)]);
var inst_55961 = (state_56018[(8)]);
var inst_55968 = cljs.core.deref(cache);
var inst_55969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55970 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_55961,inst_55949];
var inst_55971 = (new cljs.core.PersistentVector(null,3,(5),inst_55969,inst_55970,null));
var inst_55972__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_55968,inst_55971);
var state_56018__$1 = (function (){var statearr_56050 = state_56018;
(statearr_56050[(13)] = inst_55972__$1);

return statearr_56050;
})();
if(cljs.core.truth_(inst_55972__$1)){
var statearr_56051_56100 = state_56018__$1;
(statearr_56051_56100[(1)] = (26));

} else {
var statearr_56052_56101 = state_56018__$1;
(statearr_56052_56101[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (35))){
var state_56018__$1 = state_56018;
var statearr_56053_56102 = state_56018__$1;
(statearr_56053_56102[(2)] = null);

(statearr_56053_56102[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (19))){
var inst_55958 = (state_56018[(2)]);
var state_56018__$1 = state_56018;
var statearr_56054_56103 = state_56018__$1;
(statearr_56054_56103[(2)] = inst_55958);

(statearr_56054_56103[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (11))){
var state_56018__$1 = state_56018;
var statearr_56056_56104 = state_56018__$1;
(statearr_56056_56104[(2)] = pred);

(statearr_56056_56104[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (9))){
var inst_55937 = (state_56018[(2)]);
var inst_55938 = fluree.db.util.async.throw_err(inst_55937);
var state_56018__$1 = state_56018;
var statearr_56057_56105 = state_56018__$1;
(statearr_56057_56105[(2)] = inst_55938);

(statearr_56057_56105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (5))){
var _ = (function (){var statearr_56058 = state_56018;
(statearr_56058[(4)] = cljs.core.rest((state_56018[(4)])));

return statearr_56058;
})();
var state_56018__$1 = state_56018;
var ex56055 = (state_56018__$1[(2)]);
var statearr_56059_56106 = state_56018__$1;
(statearr_56059_56106[(5)] = ex56055);


if((ex56055 instanceof Error)){
var statearr_56060_56107 = state_56018__$1;
(statearr_56060_56107[(1)] = (4));

(statearr_56060_56107[(5)] = null);

} else {
throw ex56055;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (14))){
var inst_55941 = (state_56018[(9)]);
var inst_55952 = cljs.core.count(inst_55941);
var inst_55953 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55952);
var state_56018__$1 = state_56018;
if(inst_55953){
var statearr_56061_56108 = state_56018__$1;
(statearr_56061_56108[(1)] = (17));

} else {
var statearr_56062_56109 = state_56018__$1;
(statearr_56062_56109[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (26))){
var inst_55972 = (state_56018[(13)]);
var state_56018__$1 = state_56018;
var statearr_56063_56110 = state_56018__$1;
(statearr_56063_56110[(2)] = inst_55972);

(statearr_56063_56110[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (16))){
var inst_55962 = (state_56018[(10)]);
var inst_55961 = (state_56018[(8)]);
var inst_55961__$1 = (state_56018[(2)]);
var inst_55962__$1 = cljs.core.int_QMARK_(inst_55961__$1);
var state_56018__$1 = (function (){var statearr_56064 = state_56018;
(statearr_56064[(10)] = inst_55962__$1);

(statearr_56064[(8)] = inst_55961__$1);

return statearr_56064;
})();
if(inst_55962__$1){
var statearr_56065_56111 = state_56018__$1;
(statearr_56065_56111[(1)] = (20));

} else {
var statearr_56066_56112 = state_56018__$1;
(statearr_56066_56112[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (30))){
var inst_55949 = (state_56018[(7)]);
var inst_55961 = (state_56018[(8)]);
var inst_55990 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_55961,inst_55949);
var state_56018__$1 = state_56018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56018__$1,(33),inst_55990);
} else {
if((state_val_56019 === (10))){
var state_56018__$1 = state_56018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56018__$1,(13),pred);
} else {
if((state_val_56019 === (18))){
var inst_55941 = (state_56018[(9)]);
var state_56018__$1 = state_56018;
var statearr_56067_56113 = state_56018__$1;
(statearr_56067_56113[(2)] = inst_55941);

(statearr_56067_56113[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56019 === (8))){
var inst_55941 = (state_56018[(2)]);
var inst_55942 = fluree.db.util.async.channel_QMARK_(pred);
var state_56018__$1 = (function (){var statearr_56068 = state_56018;
(statearr_56068[(9)] = inst_55941);

return statearr_56068;
})();
if(inst_55942){
var statearr_56069_56114 = state_56018__$1;
(statearr_56069_56114[(1)] = (10));

} else {
var statearr_56070_56115 = state_56018__$1;
(statearr_56070_56115[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0 = (function (){
var statearr_56071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56071[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__);

(statearr_56071[(1)] = (1));

return statearr_56071;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1 = (function (state_56018){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56018);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56072){var ex__2687__auto__ = e56072;
var statearr_56073_56116 = state_56018;
(statearr_56073_56116[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56018[(4)]))){
var statearr_56074_56117 = state_56018;
(statearr_56074_56117[(1)] = cljs.core.first((state_56018[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56118 = state_56018;
state_56018 = G__56118;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = function(state_56018){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1.call(this,state_56018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56075 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56075[(6)] = c__2706__auto__);

return statearr_56075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56157){
var state_val_56158 = (state_56157[(1)]);
if((state_val_56158 === (7))){
var inst_56125 = (state_56157[(7)]);
var state_56157__$1 = state_56157;
var statearr_56159_56183 = state_56157__$1;
(statearr_56159_56183[(2)] = inst_56125);

(statearr_56159_56183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (1))){
var state_56157__$1 = state_56157;
var statearr_56160_56184 = state_56157__$1;
(statearr_56160_56184[(2)] = null);

(statearr_56160_56184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (4))){
var inst_56119 = (state_56157[(2)]);
var state_56157__$1 = state_56157;
var statearr_56161_56185 = state_56157__$1;
(statearr_56161_56185[(2)] = inst_56119);

(statearr_56161_56185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (6))){
var inst_56127 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56157__$1 = state_56157;
var statearr_56162_56186 = state_56157__$1;
(statearr_56162_56186[(2)] = inst_56127);

(statearr_56162_56186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (3))){
var inst_56155 = (state_56157[(2)]);
var state_56157__$1 = state_56157;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56157__$1,inst_56155);
} else {
if((state_val_56158 === (12))){
var inst_56137 = (state_56157[(2)]);
var inst_56138 = fluree.db.util.async.throw_err(inst_56137);
var inst_56139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56138,(0),null);
var inst_56140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56138,(1),null);
var inst_56141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56142 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56143 = ["?pO","?ctx",inst_56139];
var inst_56144 = cljs.core.PersistentHashMap.fromArrays(inst_56142,inst_56143);
var inst_56145 = ((10) + inst_56140);
var inst_56146 = [inst_56144,inst_56145];
var inst_56147 = (new cljs.core.PersistentVector(null,2,(5),inst_56141,inst_56146,null));
var inst_56148 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56147);
var state_56157__$1 = (function (){var statearr_56163 = state_56157;
(statearr_56163[(8)] = inst_56148);

return statearr_56163;
})();
var statearr_56164_56187 = state_56157__$1;
(statearr_56164_56187[(2)] = inst_56139);

(statearr_56164_56187[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (2))){
var inst_56125 = (state_56157[(7)]);
var _ = (function (){var statearr_56165 = state_56157;
(statearr_56165[(4)] = cljs.core.cons((5),(state_56157[(4)])));

return statearr_56165;
})();
var inst_56125__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56157__$1 = (function (){var statearr_56166 = state_56157;
(statearr_56166[(7)] = inst_56125__$1);

return statearr_56166;
})();
if(cljs.core.truth_(inst_56125__$1)){
var statearr_56167_56188 = state_56157__$1;
(statearr_56167_56188[(1)] = (6));

} else {
var statearr_56168_56189 = state_56157__$1;
(statearr_56168_56189[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (11))){
var inst_56152 = (state_56157[(2)]);
var _ = (function (){var statearr_56170 = state_56157;
(statearr_56170[(4)] = cljs.core.rest((state_56157[(4)])));

return statearr_56170;
})();
var state_56157__$1 = state_56157;
var statearr_56171_56190 = state_56157__$1;
(statearr_56171_56190[(2)] = inst_56152);

(statearr_56171_56190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (9))){
var inst_56135 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_56157__$1 = state_56157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56157__$1,(12),inst_56135);
} else {
if((state_val_56158 === (5))){
var _ = (function (){var statearr_56172 = state_56157;
(statearr_56172[(4)] = cljs.core.rest((state_56157[(4)])));

return statearr_56172;
})();
var state_56157__$1 = state_56157;
var ex56169 = (state_56157__$1[(2)]);
var statearr_56173_56191 = state_56157__$1;
(statearr_56173_56191[(5)] = ex56169);


if((ex56169 instanceof Error)){
var statearr_56174_56192 = state_56157__$1;
(statearr_56174_56192[(1)] = (4));

(statearr_56174_56192[(5)] = null);

} else {
throw ex56169;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (10))){
var inst_56150 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_56157__$1 = state_56157;
var statearr_56175_56193 = state_56157__$1;
(statearr_56175_56193[(2)] = inst_56150);

(statearr_56175_56193[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56158 === (8))){
var inst_56130 = (state_56157[(2)]);
var state_56157__$1 = state_56157;
if(cljs.core.truth_(inst_56130)){
var statearr_56176_56194 = state_56157__$1;
(statearr_56176_56194[(1)] = (9));

} else {
var statearr_56177_56195 = state_56157__$1;
(statearr_56177_56195[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_56178 = [null,null,null,null,null,null,null,null,null];
(statearr_56178[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_56178[(1)] = (1));

return statearr_56178;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_56157){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56157);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56179){var ex__2687__auto__ = e56179;
var statearr_56180_56196 = state_56157;
(statearr_56180_56196[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56157[(4)]))){
var statearr_56181_56197 = state_56157;
(statearr_56181_56197[(1)] = cljs.core.first((state_56157[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56198 = state_56157;
state_56157 = G__56198;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = function(state_56157){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_56157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56182 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56182[(6)] = c__2706__auto__);

return statearr_56182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56267){
var state_val_56268 = (state_56267[(1)]);
if((state_val_56268 === (7))){
var state_56267__$1 = state_56267;
var statearr_56269_56307 = state_56267__$1;
(statearr_56269_56307[(2)] = subject);

(statearr_56269_56307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (20))){
var inst_56223 = (state_56267[(7)]);
var inst_56235 = (state_56267[(8)]);
var inst_56238 = fluree.db.dbfunctions.internal.follow_subject(_QMARK_ctx,inst_56235,inst_56223);
var state_56267__$1 = state_56267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56267__$1,(23),inst_56238);
} else {
if((state_val_56268 === (1))){
var state_56267__$1 = state_56267;
var statearr_56270_56308 = state_56267__$1;
(statearr_56270_56308[(2)] = null);

(statearr_56270_56308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (4))){
var inst_56199 = (state_56267[(2)]);
var state_56267__$1 = state_56267;
var statearr_56271_56309 = state_56267__$1;
(statearr_56271_56309[(2)] = inst_56199);

(statearr_56271_56309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (15))){
var inst_56215 = (state_56267[(9)]);
var state_56267__$1 = state_56267;
var statearr_56272_56310 = state_56267__$1;
(statearr_56272_56310[(2)] = inst_56215);

(statearr_56272_56310[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (21))){
var inst_56223 = (state_56267[(7)]);
var inst_56235 = (state_56267[(8)]);
var inst_56243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56244 = fluree.db.dbfunctions.internal.get_all(inst_56235,inst_56223);
var inst_56245 = cljs.core.count(inst_56223);
var inst_56246 = ((9) + inst_56245);
var inst_56247 = [inst_56244,inst_56246];
var inst_56248 = (new cljs.core.PersistentVector(null,2,(5),inst_56243,inst_56247,null));
var state_56267__$1 = state_56267;
var statearr_56273_56311 = state_56267__$1;
(statearr_56273_56311[(2)] = inst_56248);

(statearr_56273_56311[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (13))){
var inst_56219 = (state_56267[(2)]);
var inst_56220 = fluree.db.util.async.throw_err(inst_56219);
var state_56267__$1 = state_56267;
var statearr_56274_56312 = state_56267__$1;
(statearr_56274_56312[(2)] = inst_56220);

(statearr_56274_56312[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (22))){
var inst_56223 = (state_56267[(7)]);
var inst_56215 = (state_56267[(9)]);
var inst_56250 = (state_56267[(2)]);
var inst_56251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56250,(0),null);
var inst_56252 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56250,(1),null);
var inst_56253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56254 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56256 = [inst_56215,inst_56223];
var inst_56257 = (new cljs.core.PersistentVector(null,2,(5),inst_56255,inst_56256,null));
var inst_56258 = ["get-all",inst_56257,inst_56251];
var inst_56259 = cljs.core.PersistentHashMap.fromArrays(inst_56254,inst_56258);
var inst_56260 = [inst_56259,inst_56252];
var inst_56261 = (new cljs.core.PersistentVector(null,2,(5),inst_56253,inst_56260,null));
var inst_56262 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56261);
var _ = (function (){var statearr_56275 = state_56267;
(statearr_56275[(4)] = cljs.core.rest((state_56267[(4)])));

return statearr_56275;
})();
var state_56267__$1 = (function (){var statearr_56276 = state_56267;
(statearr_56276[(10)] = inst_56262);

return statearr_56276;
})();
var statearr_56277_56313 = state_56267__$1;
(statearr_56277_56313[(2)] = inst_56251);

(statearr_56277_56313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (6))){
var state_56267__$1 = state_56267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56267__$1,(9),subject);
} else {
if((state_val_56268 === (17))){
var inst_56215 = (state_56267[(9)]);
var inst_56229 = cljs.core.first(inst_56215);
var state_56267__$1 = state_56267;
var statearr_56278_56314 = state_56267__$1;
(statearr_56278_56314[(2)] = inst_56229);

(statearr_56278_56314[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (3))){
var inst_56265 = (state_56267[(2)]);
var state_56267__$1 = state_56267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56267__$1,inst_56265);
} else {
if((state_val_56268 === (12))){
var inst_56215 = (state_56267[(9)]);
var inst_56223 = (state_56267[(2)]);
var inst_56224 = cljs.core.vector_QMARK_(inst_56215);
var state_56267__$1 = (function (){var statearr_56279 = state_56267;
(statearr_56279[(7)] = inst_56223);

return statearr_56279;
})();
if(inst_56224){
var statearr_56280_56315 = state_56267__$1;
(statearr_56280_56315[(1)] = (14));

} else {
var statearr_56281_56316 = state_56267__$1;
(statearr_56281_56316[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (2))){
var _ = (function (){var statearr_56282 = state_56267;
(statearr_56282[(4)] = cljs.core.cons((5),(state_56267[(4)])));

return statearr_56282;
})();
var inst_56208 = fluree.db.util.async.channel_QMARK_(subject);
var state_56267__$1 = state_56267;
if(inst_56208){
var statearr_56283_56317 = state_56267__$1;
(statearr_56283_56317[(1)] = (6));

} else {
var statearr_56284_56318 = state_56267__$1;
(statearr_56284_56318[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (23))){
var inst_56240 = (state_56267[(2)]);
var inst_56241 = fluree.db.util.async.throw_err(inst_56240);
var state_56267__$1 = state_56267;
var statearr_56285_56319 = state_56267__$1;
(statearr_56285_56319[(2)] = inst_56241);

(statearr_56285_56319[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (19))){
var inst_56232 = (state_56267[(2)]);
var state_56267__$1 = state_56267;
var statearr_56286_56320 = state_56267__$1;
(statearr_56286_56320[(2)] = inst_56232);

(statearr_56286_56320[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (11))){
var state_56267__$1 = state_56267;
var statearr_56288_56321 = state_56267__$1;
(statearr_56288_56321[(2)] = path);

(statearr_56288_56321[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (9))){
var inst_56211 = (state_56267[(2)]);
var inst_56212 = fluree.db.util.async.throw_err(inst_56211);
var state_56267__$1 = state_56267;
var statearr_56289_56322 = state_56267__$1;
(statearr_56289_56322[(2)] = inst_56212);

(statearr_56289_56322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (5))){
var _ = (function (){var statearr_56290 = state_56267;
(statearr_56290[(4)] = cljs.core.rest((state_56267[(4)])));

return statearr_56290;
})();
var state_56267__$1 = state_56267;
var ex56287 = (state_56267__$1[(2)]);
var statearr_56291_56323 = state_56267__$1;
(statearr_56291_56323[(5)] = ex56287);


if((ex56287 instanceof Error)){
var statearr_56292_56324 = state_56267__$1;
(statearr_56292_56324[(1)] = (4));

(statearr_56292_56324[(5)] = null);

} else {
throw ex56287;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (14))){
var inst_56215 = (state_56267[(9)]);
var inst_56226 = cljs.core.count(inst_56215);
var inst_56227 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_56226);
var state_56267__$1 = state_56267;
if(inst_56227){
var statearr_56293_56325 = state_56267__$1;
(statearr_56293_56325[(1)] = (17));

} else {
var statearr_56294_56326 = state_56267__$1;
(statearr_56294_56326[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (16))){
var inst_56235 = (state_56267[(8)]);
var inst_56235__$1 = (state_56267[(2)]);
var inst_56236 = cljs.core.int_QMARK_(inst_56235__$1);
var state_56267__$1 = (function (){var statearr_56295 = state_56267;
(statearr_56295[(8)] = inst_56235__$1);

return statearr_56295;
})();
if(inst_56236){
var statearr_56296_56327 = state_56267__$1;
(statearr_56296_56327[(1)] = (20));

} else {
var statearr_56297_56328 = state_56267__$1;
(statearr_56297_56328[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (10))){
var state_56267__$1 = state_56267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56267__$1,(13),path);
} else {
if((state_val_56268 === (18))){
var inst_56215 = (state_56267[(9)]);
var state_56267__$1 = state_56267;
var statearr_56298_56329 = state_56267__$1;
(statearr_56298_56329[(2)] = inst_56215);

(statearr_56298_56329[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (8))){
var inst_56215 = (state_56267[(2)]);
var inst_56216 = fluree.db.util.async.channel_QMARK_(path);
var state_56267__$1 = (function (){var statearr_56299 = state_56267;
(statearr_56299[(9)] = inst_56215);

return statearr_56299;
})();
if(inst_56216){
var statearr_56300_56330 = state_56267__$1;
(statearr_56300_56330[(1)] = (10));

} else {
var statearr_56301_56331 = state_56267__$1;
(statearr_56301_56331[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0 = (function (){
var statearr_56302 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_56302[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__);

(statearr_56302[(1)] = (1));

return statearr_56302;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1 = (function (state_56267){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56267);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56303){var ex__2687__auto__ = e56303;
var statearr_56304_56332 = state_56267;
(statearr_56304_56332[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56267[(4)]))){
var statearr_56305_56333 = state_56267;
(statearr_56305_56333[(1)] = cljs.core.first((state_56267[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56334 = state_56267;
state_56267 = G__56334;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = function(state_56267){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1.call(this,state_56267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56306 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56306[(6)] = c__2706__auto__);

return statearr_56306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56373){
var state_val_56374 = (state_56373[(1)]);
if((state_val_56374 === (7))){
var state_56373__$1 = state_56373;
var statearr_56375_56399 = state_56373__$1;
(statearr_56375_56399[(2)] = subject);

(statearr_56375_56399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (1))){
var state_56373__$1 = state_56373;
var statearr_56376_56400 = state_56373__$1;
(statearr_56376_56400[(2)] = null);

(statearr_56376_56400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (4))){
var inst_56335 = (state_56373[(2)]);
var state_56373__$1 = state_56373;
var statearr_56377_56401 = state_56373__$1;
(statearr_56377_56401[(2)] = inst_56335);

(statearr_56377_56401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (13))){
var inst_56352 = (state_56373[(2)]);
var inst_56353 = fluree.db.util.async.throw_err(inst_56352);
var state_56373__$1 = state_56373;
var statearr_56378_56402 = state_56373__$1;
(statearr_56378_56402[(2)] = inst_56353);

(statearr_56378_56402[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (6))){
var state_56373__$1 = state_56373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56373__$1,(9),subject);
} else {
if((state_val_56374 === (3))){
var inst_56371 = (state_56373[(2)]);
var state_56373__$1 = state_56373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56373__$1,inst_56371);
} else {
if((state_val_56374 === (12))){
var inst_56348 = (state_56373[(7)]);
var inst_56356 = (state_56373[(2)]);
var inst_56357 = fluree.db.dbfunctions.internal.get_in(inst_56348,inst_56356);
var inst_56358 = cljs.core.count(inst_56356);
var inst_56359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56360 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56362 = [inst_56348,inst_56356];
var inst_56363 = (new cljs.core.PersistentVector(null,2,(5),inst_56361,inst_56362,null));
var inst_56364 = ["get-in",inst_56363,inst_56357];
var inst_56365 = cljs.core.PersistentHashMap.fromArrays(inst_56360,inst_56364);
var inst_56366 = [inst_56365,inst_56358];
var inst_56367 = (new cljs.core.PersistentVector(null,2,(5),inst_56359,inst_56366,null));
var inst_56368 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56367);
var _ = (function (){var statearr_56379 = state_56373;
(statearr_56379[(4)] = cljs.core.rest((state_56373[(4)])));

return statearr_56379;
})();
var state_56373__$1 = (function (){var statearr_56380 = state_56373;
(statearr_56380[(8)] = inst_56368);

return statearr_56380;
})();
var statearr_56381_56403 = state_56373__$1;
(statearr_56381_56403[(2)] = inst_56357);

(statearr_56381_56403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (2))){
var _ = (function (){var statearr_56382 = state_56373;
(statearr_56382[(4)] = cljs.core.cons((5),(state_56373[(4)])));

return statearr_56382;
})();
var inst_56341 = fluree.db.util.async.channel_QMARK_(subject);
var state_56373__$1 = state_56373;
if(inst_56341){
var statearr_56383_56404 = state_56373__$1;
(statearr_56383_56404[(1)] = (6));

} else {
var statearr_56384_56405 = state_56373__$1;
(statearr_56384_56405[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (11))){
var state_56373__$1 = state_56373;
var statearr_56386_56406 = state_56373__$1;
(statearr_56386_56406[(2)] = path);

(statearr_56386_56406[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (9))){
var inst_56344 = (state_56373[(2)]);
var inst_56345 = fluree.db.util.async.throw_err(inst_56344);
var state_56373__$1 = state_56373;
var statearr_56387_56407 = state_56373__$1;
(statearr_56387_56407[(2)] = inst_56345);

(statearr_56387_56407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (5))){
var _ = (function (){var statearr_56388 = state_56373;
(statearr_56388[(4)] = cljs.core.rest((state_56373[(4)])));

return statearr_56388;
})();
var state_56373__$1 = state_56373;
var ex56385 = (state_56373__$1[(2)]);
var statearr_56389_56408 = state_56373__$1;
(statearr_56389_56408[(5)] = ex56385);


if((ex56385 instanceof Error)){
var statearr_56390_56409 = state_56373__$1;
(statearr_56390_56409[(1)] = (4));

(statearr_56390_56409[(5)] = null);

} else {
throw ex56385;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56374 === (10))){
var state_56373__$1 = state_56373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56373__$1,(13),path);
} else {
if((state_val_56374 === (8))){
var inst_56348 = (state_56373[(2)]);
var inst_56349 = fluree.db.util.async.channel_QMARK_(path);
var state_56373__$1 = (function (){var statearr_56391 = state_56373;
(statearr_56391[(7)] = inst_56348);

return statearr_56391;
})();
if(inst_56349){
var statearr_56392_56410 = state_56373__$1;
(statearr_56392_56410[(1)] = (10));

} else {
var statearr_56393_56411 = state_56373__$1;
(statearr_56393_56411[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0 = (function (){
var statearr_56394 = [null,null,null,null,null,null,null,null,null];
(statearr_56394[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__);

(statearr_56394[(1)] = (1));

return statearr_56394;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1 = (function (state_56373){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56373);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56395){var ex__2687__auto__ = e56395;
var statearr_56396_56412 = state_56373;
(statearr_56396_56412[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56373[(4)]))){
var statearr_56397_56413 = state_56373;
(statearr_56397_56413[(1)] = cljs.core.first((state_56373[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56414 = state_56373;
state_56373 = G__56414;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = function(state_56373){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1.call(this,state_56373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56398 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56398[(6)] = c__2706__auto__);

return statearr_56398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__56415,key_or_ks){
var map__56416 = p__56415;
var map__56416__$1 = cljs.core.__destructure_map(map__56416);
var _QMARK_ctx = map__56416__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56416__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_(key_or_ks)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56461){
var state_val_56462 = (state_56461[(1)]);
if((state_val_56462 === (7))){
var state_56461__$1 = state_56461;
var statearr_56463_56492 = state_56461__$1;
(statearr_56463_56492[(2)] = coll);

(statearr_56463_56492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (1))){
var state_56461__$1 = state_56461;
var statearr_56464_56493 = state_56461__$1;
(statearr_56464_56493[(2)] = null);

(statearr_56464_56493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (4))){
var inst_56417 = (state_56461[(2)]);
var state_56461__$1 = state_56461;
var statearr_56465_56494 = state_56461__$1;
(statearr_56465_56494[(2)] = inst_56417);

(statearr_56465_56494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (15))){
var inst_56437 = (state_56461[(7)]);
var inst_56445 = (state_56461[(2)]);
var inst_56446 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_56437,inst_56445);
var inst_56447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56448 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56450 = [inst_56437,inst_56445];
var inst_56451 = (new cljs.core.PersistentVector(null,2,(5),inst_56449,inst_56450,null));
var inst_56452 = ["contains?",inst_56451,inst_56446];
var inst_56453 = cljs.core.PersistentHashMap.fromArrays(inst_56448,inst_56452);
var inst_56454 = [inst_56453,(10)];
var inst_56455 = (new cljs.core.PersistentVector(null,2,(5),inst_56447,inst_56454,null));
var inst_56456 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56455);
var _ = (function (){var statearr_56466 = state_56461;
(statearr_56466[(4)] = cljs.core.rest((state_56461[(4)])));

return statearr_56466;
})();
var state_56461__$1 = (function (){var statearr_56467 = state_56461;
(statearr_56467[(8)] = inst_56456);

return statearr_56467;
})();
var statearr_56468_56495 = state_56461__$1;
(statearr_56468_56495[(2)] = inst_56446);

(statearr_56468_56495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (13))){
var state_56461__$1 = state_56461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56461__$1,(16),key);
} else {
if((state_val_56462 === (6))){
var state_56461__$1 = state_56461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56461__$1,(9),coll);
} else {
if((state_val_56462 === (3))){
var inst_56459 = (state_56461[(2)]);
var state_56461__$1 = state_56461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56461__$1,inst_56459);
} else {
if((state_val_56462 === (12))){
var inst_56437 = (state_56461[(2)]);
var inst_56438 = fluree.db.util.async.channel_QMARK_(key);
var state_56461__$1 = (function (){var statearr_56469 = state_56461;
(statearr_56469[(7)] = inst_56437);

return statearr_56469;
})();
if(inst_56438){
var statearr_56470_56496 = state_56461__$1;
(statearr_56470_56496[(1)] = (13));

} else {
var statearr_56471_56497 = state_56461__$1;
(statearr_56471_56497[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (2))){
var _ = (function (){var statearr_56472 = state_56461;
(statearr_56472[(4)] = cljs.core.cons((5),(state_56461[(4)])));

return statearr_56472;
})();
var inst_56423 = fluree.db.util.async.channel_QMARK_(coll);
var state_56461__$1 = state_56461;
if(inst_56423){
var statearr_56473_56498 = state_56461__$1;
(statearr_56473_56498[(1)] = (6));

} else {
var statearr_56474_56499 = state_56461__$1;
(statearr_56474_56499[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (11))){
var inst_56430 = (state_56461[(9)]);
var inst_56434 = cljs.core.flatten(inst_56430);
var inst_56435 = cljs.core.set(inst_56434);
var state_56461__$1 = state_56461;
var statearr_56476_56500 = state_56461__$1;
(statearr_56476_56500[(2)] = inst_56435);

(statearr_56476_56500[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (9))){
var inst_56426 = (state_56461[(2)]);
var inst_56427 = fluree.db.util.async.throw_err(inst_56426);
var state_56461__$1 = state_56461;
var statearr_56477_56501 = state_56461__$1;
(statearr_56477_56501[(2)] = inst_56427);

(statearr_56477_56501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (5))){
var _ = (function (){var statearr_56478 = state_56461;
(statearr_56478[(4)] = cljs.core.rest((state_56461[(4)])));

return statearr_56478;
})();
var state_56461__$1 = state_56461;
var ex56475 = (state_56461__$1[(2)]);
var statearr_56479_56502 = state_56461__$1;
(statearr_56479_56502[(5)] = ex56475);


if((ex56475 instanceof Error)){
var statearr_56480_56503 = state_56461__$1;
(statearr_56480_56503[(1)] = (4));

(statearr_56480_56503[(5)] = null);

} else {
throw ex56475;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (14))){
var state_56461__$1 = state_56461;
var statearr_56481_56504 = state_56461__$1;
(statearr_56481_56504[(2)] = key);

(statearr_56481_56504[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (16))){
var inst_56441 = (state_56461[(2)]);
var inst_56442 = fluree.db.util.async.throw_err(inst_56441);
var state_56461__$1 = state_56461;
var statearr_56482_56505 = state_56461__$1;
(statearr_56482_56505[(2)] = inst_56442);

(statearr_56482_56505[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (10))){
var inst_56430 = (state_56461[(9)]);
var state_56461__$1 = state_56461;
var statearr_56483_56506 = state_56461__$1;
(statearr_56483_56506[(2)] = inst_56430);

(statearr_56483_56506[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (8))){
var inst_56430 = (state_56461[(9)]);
var inst_56430__$1 = (state_56461[(2)]);
var inst_56431 = cljs.core.set_QMARK_(inst_56430__$1);
var state_56461__$1 = (function (){var statearr_56484 = state_56461;
(statearr_56484[(9)] = inst_56430__$1);

return statearr_56484;
})();
if(inst_56431){
var statearr_56485_56507 = state_56461__$1;
(statearr_56485_56507[(1)] = (10));

} else {
var statearr_56486_56508 = state_56461__$1;
(statearr_56486_56508[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_56487 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56487[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__);

(statearr_56487[(1)] = (1));

return statearr_56487;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1 = (function (state_56461){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56461);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56488){var ex__2687__auto__ = e56488;
var statearr_56489_56509 = state_56461;
(statearr_56489_56509[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56461[(4)]))){
var statearr_56490_56510 = state_56461;
(statearr_56490_56510[(1)] = cljs.core.first((state_56461[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56511 = state_56461;
state_56461 = G__56511;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = function(state_56461){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1.call(this,state_56461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56491 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56491[(6)] = c__2706__auto__);

return statearr_56491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56583 = arguments.length;
var i__5770__auto___56584 = (0);
while(true){
if((i__5770__auto___56584 < len__5769__auto___56583)){
args__5775__auto__.push((arguments[i__5770__auto___56584]));

var G__56585 = (i__5770__auto___56584 + (1));
i__5770__auto___56584 = G__56585;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56557){
var state_val_56558 = (state_56557[(1)]);
if((state_val_56558 === (7))){
var inst_56523 = (state_56557[(7)]);
var inst_56527 = cljs.core.first(inst_56523);
var inst_56528 = cljs.core.coll_QMARK_(inst_56527);
var state_56557__$1 = state_56557;
var statearr_56559_56586 = state_56557__$1;
(statearr_56559_56586[(2)] = inst_56528);

(statearr_56559_56586[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (1))){
var state_56557__$1 = state_56557;
var statearr_56560_56587 = state_56557__$1;
(statearr_56560_56587[(2)] = null);

(statearr_56560_56587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (4))){
var inst_56514 = (state_56557[(2)]);
var state_56557__$1 = state_56557;
var statearr_56561_56588 = state_56557__$1;
(statearr_56561_56588[(2)] = inst_56514);

(statearr_56561_56588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (6))){
var inst_56525 = (state_56557[(8)]);
var inst_56523 = (state_56557[(7)]);
var inst_56522 = (state_56557[(2)]);
var inst_56523__$1 = fluree.db.util.async.throw_err(inst_56522);
var inst_56524 = cljs.core.count(inst_56523__$1);
var inst_56525__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_56524);
var state_56557__$1 = (function (){var statearr_56562 = state_56557;
(statearr_56562[(8)] = inst_56525__$1);

(statearr_56562[(7)] = inst_56523__$1);

return statearr_56562;
})();
if(inst_56525__$1){
var statearr_56563_56589 = state_56557__$1;
(statearr_56563_56589[(1)] = (7));

} else {
var statearr_56564_56590 = state_56557__$1;
(statearr_56564_56590[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (3))){
var inst_56555 = (state_56557[(2)]);
var state_56557__$1 = state_56557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56557__$1,inst_56555);
} else {
if((state_val_56558 === (12))){
var inst_56536 = (state_56557[(2)]);
var inst_56537 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_56536);
var inst_56538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56539 = [inst_56536];
var inst_56540 = (new cljs.core.PersistentVector(null,1,(5),inst_56538,inst_56539,null));
var inst_56541 = cljs.core.count(inst_56540);
var inst_56542 = ((9) + inst_56541);
var inst_56543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56544 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56546 = [inst_56536];
var inst_56547 = (new cljs.core.PersistentVector(null,1,(5),inst_56545,inst_56546,null));
var inst_56548 = ["hash-set",inst_56547,inst_56537];
var inst_56549 = cljs.core.PersistentHashMap.fromArrays(inst_56544,inst_56548);
var inst_56550 = [inst_56549,inst_56542];
var inst_56551 = (new cljs.core.PersistentVector(null,2,(5),inst_56543,inst_56550,null));
var inst_56552 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56551);
var _ = (function (){var statearr_56565 = state_56557;
(statearr_56565[(4)] = cljs.core.rest((state_56557[(4)])));

return statearr_56565;
})();
var state_56557__$1 = (function (){var statearr_56566 = state_56557;
(statearr_56566[(9)] = inst_56552);

return statearr_56566;
})();
var statearr_56567_56591 = state_56557__$1;
(statearr_56567_56591[(2)] = inst_56537);

(statearr_56567_56591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (2))){
var _ = (function (){var statearr_56568 = state_56557;
(statearr_56568[(4)] = cljs.core.cons((5),(state_56557[(4)])));

return statearr_56568;
})();
var inst_56520 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56557__$1 = state_56557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56557__$1,(6),inst_56520);
} else {
if((state_val_56558 === (11))){
var inst_56523 = (state_56557[(7)]);
var state_56557__$1 = state_56557;
var statearr_56570_56592 = state_56557__$1;
(statearr_56570_56592[(2)] = inst_56523);

(statearr_56570_56592[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (9))){
var inst_56531 = (state_56557[(2)]);
var state_56557__$1 = state_56557;
if(cljs.core.truth_(inst_56531)){
var statearr_56571_56593 = state_56557__$1;
(statearr_56571_56593[(1)] = (10));

} else {
var statearr_56572_56594 = state_56557__$1;
(statearr_56572_56594[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (5))){
var _ = (function (){var statearr_56573 = state_56557;
(statearr_56573[(4)] = cljs.core.rest((state_56557[(4)])));

return statearr_56573;
})();
var state_56557__$1 = state_56557;
var ex56569 = (state_56557__$1[(2)]);
var statearr_56574_56595 = state_56557__$1;
(statearr_56574_56595[(5)] = ex56569);


if((ex56569 instanceof Error)){
var statearr_56575_56596 = state_56557__$1;
(statearr_56575_56596[(1)] = (4));

(statearr_56575_56596[(5)] = null);

} else {
throw ex56569;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (10))){
var inst_56523 = (state_56557[(7)]);
var inst_56533 = cljs.core.first(inst_56523);
var state_56557__$1 = state_56557;
var statearr_56576_56597 = state_56557__$1;
(statearr_56576_56597[(2)] = inst_56533);

(statearr_56576_56597[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (8))){
var inst_56525 = (state_56557[(8)]);
var state_56557__$1 = state_56557;
var statearr_56577_56598 = state_56557__$1;
(statearr_56577_56598[(2)] = inst_56525);

(statearr_56577_56598[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56578 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56578[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56578[(1)] = (1));

return statearr_56578;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56557){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56557);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56579){var ex__2687__auto__ = e56579;
var statearr_56580_56599 = state_56557;
(statearr_56580_56599[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56557[(4)]))){
var statearr_56581_56600 = state_56557;
(statearr_56581_56600[(1)] = cljs.core.first((state_56557[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56601 = state_56557;
state_56557 = G__56601;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56582 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56582[(6)] = c__2706__auto__);

return statearr_56582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq56512){
var G__56513 = cljs.core.first(seq56512);
var seq56512__$1 = cljs.core.next(seq56512);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56513,seq56512__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56651 = arguments.length;
var i__5770__auto___56652 = (0);
while(true){
if((i__5770__auto___56652 < len__5769__auto___56651)){
args__5775__auto__.push((arguments[i__5770__auto___56652]));

var G__56653 = (i__5770__auto___56652 + (1));
i__5770__auto___56652 = G__56653;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56634){
var state_val_56635 = (state_56634[(1)]);
if((state_val_56635 === (1))){
var state_56634__$1 = state_56634;
var statearr_56636_56654 = state_56634__$1;
(statearr_56636_56654[(2)] = null);

(statearr_56636_56654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (2))){
var _ = (function (){var statearr_56637 = state_56634;
(statearr_56637[(4)] = cljs.core.cons((5),(state_56634[(4)])));

return statearr_56637;
})();
var inst_56610 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56634__$1 = state_56634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56634__$1,(6),inst_56610);
} else {
if((state_val_56635 === (3))){
var inst_56632 = (state_56634[(2)]);
var state_56634__$1 = state_56634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56634__$1,inst_56632);
} else {
if((state_val_56635 === (4))){
var inst_56604 = (state_56634[(2)]);
var state_56634__$1 = state_56634;
var statearr_56639_56655 = state_56634__$1;
(statearr_56639_56655[(2)] = inst_56604);

(statearr_56639_56655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (5))){
var _ = (function (){var statearr_56640 = state_56634;
(statearr_56640[(4)] = cljs.core.rest((state_56634[(4)])));

return statearr_56640;
})();
var state_56634__$1 = state_56634;
var ex56638 = (state_56634__$1[(2)]);
var statearr_56641_56656 = state_56634__$1;
(statearr_56641_56656[(5)] = ex56638);


if((ex56638 instanceof Error)){
var statearr_56642_56657 = state_56634__$1;
(statearr_56642_56657[(1)] = (4));

(statearr_56642_56657[(5)] = null);

} else {
throw ex56638;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (6))){
var inst_56612 = (state_56634[(2)]);
var inst_56613 = fluree.db.util.async.throw_err(inst_56612);
var inst_56614 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_56613);
var inst_56615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56616 = [inst_56613];
var inst_56617 = (new cljs.core.PersistentVector(null,1,(5),inst_56615,inst_56616,null));
var inst_56618 = cljs.core.count(inst_56617);
var inst_56619 = ((9) + inst_56618);
var inst_56620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56621 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56623 = [inst_56613];
var inst_56624 = (new cljs.core.PersistentVector(null,1,(5),inst_56622,inst_56623,null));
var inst_56625 = ["==",inst_56624,inst_56614];
var inst_56626 = cljs.core.PersistentHashMap.fromArrays(inst_56621,inst_56625);
var inst_56627 = [inst_56626,inst_56619];
var inst_56628 = (new cljs.core.PersistentVector(null,2,(5),inst_56620,inst_56627,null));
var inst_56629 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56628);
var _ = (function (){var statearr_56643 = state_56634;
(statearr_56643[(4)] = cljs.core.rest((state_56634[(4)])));

return statearr_56643;
})();
var state_56634__$1 = (function (){var statearr_56644 = state_56634;
(statearr_56644[(7)] = inst_56629);

return statearr_56644;
})();
var statearr_56645_56658 = state_56634__$1;
(statearr_56645_56658[(2)] = inst_56614);

(statearr_56645_56658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56646 = [null,null,null,null,null,null,null,null];
(statearr_56646[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56646[(1)] = (1));

return statearr_56646;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56634){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56634);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56647){var ex__2687__auto__ = e56647;
var statearr_56648_56659 = state_56634;
(statearr_56648_56659[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56634[(4)]))){
var statearr_56649_56660 = state_56634;
(statearr_56649_56660[(1)] = cljs.core.first((state_56634[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56661 = state_56634;
state_56634 = G__56661;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56634){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56650 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56650[(6)] = c__2706__auto__);

return statearr_56650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq56602){
var G__56603 = cljs.core.first(seq56602);
var seq56602__$1 = cljs.core.next(seq56602);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56603,seq56602__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56711 = arguments.length;
var i__5770__auto___56712 = (0);
while(true){
if((i__5770__auto___56712 < len__5769__auto___56711)){
args__5775__auto__.push((arguments[i__5770__auto___56712]));

var G__56713 = (i__5770__auto___56712 + (1));
i__5770__auto___56712 = G__56713;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56694){
var state_val_56695 = (state_56694[(1)]);
if((state_val_56695 === (1))){
var state_56694__$1 = state_56694;
var statearr_56696_56714 = state_56694__$1;
(statearr_56696_56714[(2)] = null);

(statearr_56696_56714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56695 === (2))){
var _ = (function (){var statearr_56697 = state_56694;
(statearr_56697[(4)] = cljs.core.cons((5),(state_56694[(4)])));

return statearr_56697;
})();
var inst_56670 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56694__$1 = state_56694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56694__$1,(6),inst_56670);
} else {
if((state_val_56695 === (3))){
var inst_56692 = (state_56694[(2)]);
var state_56694__$1 = state_56694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56694__$1,inst_56692);
} else {
if((state_val_56695 === (4))){
var inst_56664 = (state_56694[(2)]);
var state_56694__$1 = state_56694;
var statearr_56699_56715 = state_56694__$1;
(statearr_56699_56715[(2)] = inst_56664);

(statearr_56699_56715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56695 === (5))){
var _ = (function (){var statearr_56700 = state_56694;
(statearr_56700[(4)] = cljs.core.rest((state_56694[(4)])));

return statearr_56700;
})();
var state_56694__$1 = state_56694;
var ex56698 = (state_56694__$1[(2)]);
var statearr_56701_56716 = state_56694__$1;
(statearr_56701_56716[(5)] = ex56698);


if((ex56698 instanceof Error)){
var statearr_56702_56717 = state_56694__$1;
(statearr_56702_56717[(1)] = (4));

(statearr_56702_56717[(5)] = null);

} else {
throw ex56698;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56695 === (6))){
var inst_56672 = (state_56694[(2)]);
var inst_56673 = fluree.db.util.async.throw_err(inst_56672);
var inst_56674 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_56673);
var inst_56675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56676 = [inst_56673];
var inst_56677 = (new cljs.core.PersistentVector(null,1,(5),inst_56675,inst_56676,null));
var inst_56678 = cljs.core.count(inst_56677);
var inst_56679 = ((9) + inst_56678);
var inst_56680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56681 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56683 = [inst_56673];
var inst_56684 = (new cljs.core.PersistentVector(null,1,(5),inst_56682,inst_56683,null));
var inst_56685 = [">",inst_56684,inst_56674];
var inst_56686 = cljs.core.PersistentHashMap.fromArrays(inst_56681,inst_56685);
var inst_56687 = [inst_56686,inst_56679];
var inst_56688 = (new cljs.core.PersistentVector(null,2,(5),inst_56680,inst_56687,null));
var inst_56689 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56688);
var _ = (function (){var statearr_56703 = state_56694;
(statearr_56703[(4)] = cljs.core.rest((state_56694[(4)])));

return statearr_56703;
})();
var state_56694__$1 = (function (){var statearr_56704 = state_56694;
(statearr_56704[(7)] = inst_56689);

return statearr_56704;
})();
var statearr_56705_56718 = state_56694__$1;
(statearr_56705_56718[(2)] = inst_56674);

(statearr_56705_56718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56706 = [null,null,null,null,null,null,null,null];
(statearr_56706[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56706[(1)] = (1));

return statearr_56706;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56694){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56694);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56707){var ex__2687__auto__ = e56707;
var statearr_56708_56719 = state_56694;
(statearr_56708_56719[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56694[(4)]))){
var statearr_56709_56720 = state_56694;
(statearr_56709_56720[(1)] = cljs.core.first((state_56694[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56721 = state_56694;
state_56694 = G__56721;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56694){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56710 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56710[(6)] = c__2706__auto__);

return statearr_56710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq56662){
var G__56663 = cljs.core.first(seq56662);
var seq56662__$1 = cljs.core.next(seq56662);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56663,seq56662__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56771 = arguments.length;
var i__5770__auto___56772 = (0);
while(true){
if((i__5770__auto___56772 < len__5769__auto___56771)){
args__5775__auto__.push((arguments[i__5770__auto___56772]));

var G__56773 = (i__5770__auto___56772 + (1));
i__5770__auto___56772 = G__56773;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56754){
var state_val_56755 = (state_56754[(1)]);
if((state_val_56755 === (1))){
var state_56754__$1 = state_56754;
var statearr_56756_56774 = state_56754__$1;
(statearr_56756_56774[(2)] = null);

(statearr_56756_56774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56755 === (2))){
var _ = (function (){var statearr_56757 = state_56754;
(statearr_56757[(4)] = cljs.core.cons((5),(state_56754[(4)])));

return statearr_56757;
})();
var inst_56730 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56754__$1 = state_56754;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56754__$1,(6),inst_56730);
} else {
if((state_val_56755 === (3))){
var inst_56752 = (state_56754[(2)]);
var state_56754__$1 = state_56754;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56754__$1,inst_56752);
} else {
if((state_val_56755 === (4))){
var inst_56724 = (state_56754[(2)]);
var state_56754__$1 = state_56754;
var statearr_56759_56775 = state_56754__$1;
(statearr_56759_56775[(2)] = inst_56724);

(statearr_56759_56775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56755 === (5))){
var _ = (function (){var statearr_56760 = state_56754;
(statearr_56760[(4)] = cljs.core.rest((state_56754[(4)])));

return statearr_56760;
})();
var state_56754__$1 = state_56754;
var ex56758 = (state_56754__$1[(2)]);
var statearr_56761_56776 = state_56754__$1;
(statearr_56761_56776[(5)] = ex56758);


if((ex56758 instanceof Error)){
var statearr_56762_56777 = state_56754__$1;
(statearr_56762_56777[(1)] = (4));

(statearr_56762_56777[(5)] = null);

} else {
throw ex56758;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56755 === (6))){
var inst_56732 = (state_56754[(2)]);
var inst_56733 = fluree.db.util.async.throw_err(inst_56732);
var inst_56734 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_56733);
var inst_56735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56736 = [inst_56733];
var inst_56737 = (new cljs.core.PersistentVector(null,1,(5),inst_56735,inst_56736,null));
var inst_56738 = cljs.core.count(inst_56737);
var inst_56739 = ((9) + inst_56738);
var inst_56740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56741 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56743 = [inst_56733];
var inst_56744 = (new cljs.core.PersistentVector(null,1,(5),inst_56742,inst_56743,null));
var inst_56745 = ["<",inst_56744,inst_56734];
var inst_56746 = cljs.core.PersistentHashMap.fromArrays(inst_56741,inst_56745);
var inst_56747 = [inst_56746,inst_56739];
var inst_56748 = (new cljs.core.PersistentVector(null,2,(5),inst_56740,inst_56747,null));
var inst_56749 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56748);
var _ = (function (){var statearr_56763 = state_56754;
(statearr_56763[(4)] = cljs.core.rest((state_56754[(4)])));

return statearr_56763;
})();
var state_56754__$1 = (function (){var statearr_56764 = state_56754;
(statearr_56764[(7)] = inst_56749);

return statearr_56764;
})();
var statearr_56765_56778 = state_56754__$1;
(statearr_56765_56778[(2)] = inst_56734);

(statearr_56765_56778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56766 = [null,null,null,null,null,null,null,null];
(statearr_56766[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56766[(1)] = (1));

return statearr_56766;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56754){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56754);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56767){var ex__2687__auto__ = e56767;
var statearr_56768_56779 = state_56754;
(statearr_56768_56779[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56754[(4)]))){
var statearr_56769_56780 = state_56754;
(statearr_56769_56780[(1)] = cljs.core.first((state_56754[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56781 = state_56754;
state_56754 = G__56781;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56754){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56770 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56770[(6)] = c__2706__auto__);

return statearr_56770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq56722){
var G__56723 = cljs.core.first(seq56722);
var seq56722__$1 = cljs.core.next(seq56722);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56723,seq56722__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56831 = arguments.length;
var i__5770__auto___56832 = (0);
while(true){
if((i__5770__auto___56832 < len__5769__auto___56831)){
args__5775__auto__.push((arguments[i__5770__auto___56832]));

var G__56833 = (i__5770__auto___56832 + (1));
i__5770__auto___56832 = G__56833;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56814){
var state_val_56815 = (state_56814[(1)]);
if((state_val_56815 === (1))){
var state_56814__$1 = state_56814;
var statearr_56816_56834 = state_56814__$1;
(statearr_56816_56834[(2)] = null);

(statearr_56816_56834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56815 === (2))){
var _ = (function (){var statearr_56817 = state_56814;
(statearr_56817[(4)] = cljs.core.cons((5),(state_56814[(4)])));

return statearr_56817;
})();
var inst_56790 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56814__$1 = state_56814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56814__$1,(6),inst_56790);
} else {
if((state_val_56815 === (3))){
var inst_56812 = (state_56814[(2)]);
var state_56814__$1 = state_56814;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56814__$1,inst_56812);
} else {
if((state_val_56815 === (4))){
var inst_56784 = (state_56814[(2)]);
var state_56814__$1 = state_56814;
var statearr_56819_56835 = state_56814__$1;
(statearr_56819_56835[(2)] = inst_56784);

(statearr_56819_56835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56815 === (5))){
var _ = (function (){var statearr_56820 = state_56814;
(statearr_56820[(4)] = cljs.core.rest((state_56814[(4)])));

return statearr_56820;
})();
var state_56814__$1 = state_56814;
var ex56818 = (state_56814__$1[(2)]);
var statearr_56821_56836 = state_56814__$1;
(statearr_56821_56836[(5)] = ex56818);


if((ex56818 instanceof Error)){
var statearr_56822_56837 = state_56814__$1;
(statearr_56822_56837[(1)] = (4));

(statearr_56822_56837[(5)] = null);

} else {
throw ex56818;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56815 === (6))){
var inst_56792 = (state_56814[(2)]);
var inst_56793 = fluree.db.util.async.throw_err(inst_56792);
var inst_56794 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_56793);
var inst_56795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56796 = [inst_56793];
var inst_56797 = (new cljs.core.PersistentVector(null,1,(5),inst_56795,inst_56796,null));
var inst_56798 = cljs.core.count(inst_56797);
var inst_56799 = ((9) + inst_56798);
var inst_56800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56801 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56803 = [inst_56793];
var inst_56804 = (new cljs.core.PersistentVector(null,1,(5),inst_56802,inst_56803,null));
var inst_56805 = ["<=",inst_56804,inst_56794];
var inst_56806 = cljs.core.PersistentHashMap.fromArrays(inst_56801,inst_56805);
var inst_56807 = [inst_56806,inst_56799];
var inst_56808 = (new cljs.core.PersistentVector(null,2,(5),inst_56800,inst_56807,null));
var inst_56809 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56808);
var _ = (function (){var statearr_56823 = state_56814;
(statearr_56823[(4)] = cljs.core.rest((state_56814[(4)])));

return statearr_56823;
})();
var state_56814__$1 = (function (){var statearr_56824 = state_56814;
(statearr_56824[(7)] = inst_56809);

return statearr_56824;
})();
var statearr_56825_56838 = state_56814__$1;
(statearr_56825_56838[(2)] = inst_56794);

(statearr_56825_56838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56826 = [null,null,null,null,null,null,null,null];
(statearr_56826[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56826[(1)] = (1));

return statearr_56826;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56814){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56814);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56827){var ex__2687__auto__ = e56827;
var statearr_56828_56839 = state_56814;
(statearr_56828_56839[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56814[(4)]))){
var statearr_56829_56840 = state_56814;
(statearr_56829_56840[(1)] = cljs.core.first((state_56814[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56841 = state_56814;
state_56814 = G__56841;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56814){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56830 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56830[(6)] = c__2706__auto__);

return statearr_56830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq56782){
var G__56783 = cljs.core.first(seq56782);
var seq56782__$1 = cljs.core.next(seq56782);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56783,seq56782__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56891 = arguments.length;
var i__5770__auto___56892 = (0);
while(true){
if((i__5770__auto___56892 < len__5769__auto___56891)){
args__5775__auto__.push((arguments[i__5770__auto___56892]));

var G__56893 = (i__5770__auto___56892 + (1));
i__5770__auto___56892 = G__56893;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56874){
var state_val_56875 = (state_56874[(1)]);
if((state_val_56875 === (1))){
var state_56874__$1 = state_56874;
var statearr_56876_56894 = state_56874__$1;
(statearr_56876_56894[(2)] = null);

(statearr_56876_56894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56875 === (2))){
var _ = (function (){var statearr_56877 = state_56874;
(statearr_56877[(4)] = cljs.core.cons((5),(state_56874[(4)])));

return statearr_56877;
})();
var inst_56850 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56874__$1 = state_56874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56874__$1,(6),inst_56850);
} else {
if((state_val_56875 === (3))){
var inst_56872 = (state_56874[(2)]);
var state_56874__$1 = state_56874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56874__$1,inst_56872);
} else {
if((state_val_56875 === (4))){
var inst_56844 = (state_56874[(2)]);
var state_56874__$1 = state_56874;
var statearr_56879_56895 = state_56874__$1;
(statearr_56879_56895[(2)] = inst_56844);

(statearr_56879_56895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56875 === (5))){
var _ = (function (){var statearr_56880 = state_56874;
(statearr_56880[(4)] = cljs.core.rest((state_56874[(4)])));

return statearr_56880;
})();
var state_56874__$1 = state_56874;
var ex56878 = (state_56874__$1[(2)]);
var statearr_56881_56896 = state_56874__$1;
(statearr_56881_56896[(5)] = ex56878);


if((ex56878 instanceof Error)){
var statearr_56882_56897 = state_56874__$1;
(statearr_56882_56897[(1)] = (4));

(statearr_56882_56897[(5)] = null);

} else {
throw ex56878;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56875 === (6))){
var inst_56852 = (state_56874[(2)]);
var inst_56853 = fluree.db.util.async.throw_err(inst_56852);
var inst_56854 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_56853);
var inst_56855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56856 = [inst_56853];
var inst_56857 = (new cljs.core.PersistentVector(null,1,(5),inst_56855,inst_56856,null));
var inst_56858 = cljs.core.count(inst_56857);
var inst_56859 = ((9) + inst_56858);
var inst_56860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56861 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56863 = [inst_56853];
var inst_56864 = (new cljs.core.PersistentVector(null,1,(5),inst_56862,inst_56863,null));
var inst_56865 = [">=",inst_56864,inst_56854];
var inst_56866 = cljs.core.PersistentHashMap.fromArrays(inst_56861,inst_56865);
var inst_56867 = [inst_56866,inst_56859];
var inst_56868 = (new cljs.core.PersistentVector(null,2,(5),inst_56860,inst_56867,null));
var inst_56869 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56868);
var _ = (function (){var statearr_56883 = state_56874;
(statearr_56883[(4)] = cljs.core.rest((state_56874[(4)])));

return statearr_56883;
})();
var state_56874__$1 = (function (){var statearr_56884 = state_56874;
(statearr_56884[(7)] = inst_56869);

return statearr_56884;
})();
var statearr_56885_56898 = state_56874__$1;
(statearr_56885_56898[(2)] = inst_56854);

(statearr_56885_56898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56886 = [null,null,null,null,null,null,null,null];
(statearr_56886[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56886[(1)] = (1));

return statearr_56886;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56874){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56874);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56887){var ex__2687__auto__ = e56887;
var statearr_56888_56899 = state_56874;
(statearr_56888_56899[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56874[(4)]))){
var statearr_56889_56900 = state_56874;
(statearr_56889_56900[(1)] = cljs.core.first((state_56874[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56901 = state_56874;
state_56874 = G__56901;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56874){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56890 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56890[(6)] = c__2706__auto__);

return statearr_56890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq56842){
var G__56843 = cljs.core.first(seq56842);
var seq56842__$1 = cljs.core.next(seq56842);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56843,seq56842__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56951 = arguments.length;
var i__5770__auto___56952 = (0);
while(true){
if((i__5770__auto___56952 < len__5769__auto___56951)){
args__5775__auto__.push((arguments[i__5770__auto___56952]));

var G__56953 = (i__5770__auto___56952 + (1));
i__5770__auto___56952 = G__56953;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56934){
var state_val_56935 = (state_56934[(1)]);
if((state_val_56935 === (1))){
var state_56934__$1 = state_56934;
var statearr_56936_56954 = state_56934__$1;
(statearr_56936_56954[(2)] = null);

(statearr_56936_56954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56935 === (2))){
var _ = (function (){var statearr_56937 = state_56934;
(statearr_56937[(4)] = cljs.core.cons((5),(state_56934[(4)])));

return statearr_56937;
})();
var inst_56910 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56934__$1 = state_56934;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56934__$1,(6),inst_56910);
} else {
if((state_val_56935 === (3))){
var inst_56932 = (state_56934[(2)]);
var state_56934__$1 = state_56934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56934__$1,inst_56932);
} else {
if((state_val_56935 === (4))){
var inst_56904 = (state_56934[(2)]);
var state_56934__$1 = state_56934;
var statearr_56939_56955 = state_56934__$1;
(statearr_56939_56955[(2)] = inst_56904);

(statearr_56939_56955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56935 === (5))){
var _ = (function (){var statearr_56940 = state_56934;
(statearr_56940[(4)] = cljs.core.rest((state_56934[(4)])));

return statearr_56940;
})();
var state_56934__$1 = state_56934;
var ex56938 = (state_56934__$1[(2)]);
var statearr_56941_56956 = state_56934__$1;
(statearr_56941_56956[(5)] = ex56938);


if((ex56938 instanceof Error)){
var statearr_56942_56957 = state_56934__$1;
(statearr_56942_56957[(1)] = (4));

(statearr_56942_56957[(5)] = null);

} else {
throw ex56938;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56935 === (6))){
var inst_56912 = (state_56934[(2)]);
var inst_56913 = fluree.db.util.async.throw_err(inst_56912);
var inst_56914 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_56913);
var inst_56915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56916 = [inst_56913];
var inst_56917 = (new cljs.core.PersistentVector(null,1,(5),inst_56915,inst_56916,null));
var inst_56918 = cljs.core.count(inst_56917);
var inst_56919 = ((9) + inst_56918);
var inst_56920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56921 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56923 = [inst_56913];
var inst_56924 = (new cljs.core.PersistentVector(null,1,(5),inst_56922,inst_56923,null));
var inst_56925 = ["not=",inst_56924,inst_56914];
var inst_56926 = cljs.core.PersistentHashMap.fromArrays(inst_56921,inst_56925);
var inst_56927 = [inst_56926,inst_56919];
var inst_56928 = (new cljs.core.PersistentVector(null,2,(5),inst_56920,inst_56927,null));
var inst_56929 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56928);
var _ = (function (){var statearr_56943 = state_56934;
(statearr_56943[(4)] = cljs.core.rest((state_56934[(4)])));

return statearr_56943;
})();
var state_56934__$1 = (function (){var statearr_56944 = state_56934;
(statearr_56944[(7)] = inst_56929);

return statearr_56944;
})();
var statearr_56945_56958 = state_56934__$1;
(statearr_56945_56958[(2)] = inst_56914);

(statearr_56945_56958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56946 = [null,null,null,null,null,null,null,null];
(statearr_56946[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56946[(1)] = (1));

return statearr_56946;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56934){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56934);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56947){var ex__2687__auto__ = e56947;
var statearr_56948_56959 = state_56934;
(statearr_56948_56959[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56934[(4)]))){
var statearr_56949_56960 = state_56934;
(statearr_56949_56960[(1)] = cljs.core.first((state_56934[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56961 = state_56934;
state_56934 = G__56961;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56934){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56950 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56950[(6)] = c__2706__auto__);

return statearr_56950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56902){
var G__56903 = cljs.core.first(seq56902);
var seq56902__$1 = cljs.core.next(seq56902);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56903,seq56902__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57011 = arguments.length;
var i__5770__auto___57012 = (0);
while(true){
if((i__5770__auto___57012 < len__5769__auto___57011)){
args__5775__auto__.push((arguments[i__5770__auto___57012]));

var G__57013 = (i__5770__auto___57012 + (1));
i__5770__auto___57012 = G__57013;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56994){
var state_val_56995 = (state_56994[(1)]);
if((state_val_56995 === (1))){
var state_56994__$1 = state_56994;
var statearr_56996_57014 = state_56994__$1;
(statearr_56996_57014[(2)] = null);

(statearr_56996_57014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56995 === (2))){
var _ = (function (){var statearr_56997 = state_56994;
(statearr_56997[(4)] = cljs.core.cons((5),(state_56994[(4)])));

return statearr_56997;
})();
var inst_56970 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56994__$1 = state_56994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56994__$1,(6),inst_56970);
} else {
if((state_val_56995 === (3))){
var inst_56992 = (state_56994[(2)]);
var state_56994__$1 = state_56994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56994__$1,inst_56992);
} else {
if((state_val_56995 === (4))){
var inst_56964 = (state_56994[(2)]);
var state_56994__$1 = state_56994;
var statearr_56999_57015 = state_56994__$1;
(statearr_56999_57015[(2)] = inst_56964);

(statearr_56999_57015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56995 === (5))){
var _ = (function (){var statearr_57000 = state_56994;
(statearr_57000[(4)] = cljs.core.rest((state_56994[(4)])));

return statearr_57000;
})();
var state_56994__$1 = state_56994;
var ex56998 = (state_56994__$1[(2)]);
var statearr_57001_57016 = state_56994__$1;
(statearr_57001_57016[(5)] = ex56998);


if((ex56998 instanceof Error)){
var statearr_57002_57017 = state_56994__$1;
(statearr_57002_57017[(1)] = (4));

(statearr_57002_57017[(5)] = null);

} else {
throw ex56998;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56995 === (6))){
var inst_56972 = (state_56994[(2)]);
var inst_56973 = fluree.db.util.async.throw_err(inst_56972);
var inst_56974 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_56973);
var inst_56975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56976 = [inst_56973];
var inst_56977 = (new cljs.core.PersistentVector(null,1,(5),inst_56975,inst_56976,null));
var inst_56978 = cljs.core.count(inst_56977);
var inst_56979 = ((9) + inst_56978);
var inst_56980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56981 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56983 = [inst_56973];
var inst_56984 = (new cljs.core.PersistentVector(null,1,(5),inst_56982,inst_56983,null));
var inst_56985 = ["max",inst_56984,inst_56974];
var inst_56986 = cljs.core.PersistentHashMap.fromArrays(inst_56981,inst_56985);
var inst_56987 = [inst_56986,inst_56979];
var inst_56988 = (new cljs.core.PersistentVector(null,2,(5),inst_56980,inst_56987,null));
var inst_56989 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56988);
var _ = (function (){var statearr_57003 = state_56994;
(statearr_57003[(4)] = cljs.core.rest((state_56994[(4)])));

return statearr_57003;
})();
var state_56994__$1 = (function (){var statearr_57004 = state_56994;
(statearr_57004[(7)] = inst_56989);

return statearr_57004;
})();
var statearr_57005_57018 = state_56994__$1;
(statearr_57005_57018[(2)] = inst_56974);

(statearr_57005_57018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57006 = [null,null,null,null,null,null,null,null];
(statearr_57006[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57006[(1)] = (1));

return statearr_57006;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56994){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56994);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57007){var ex__2687__auto__ = e57007;
var statearr_57008_57019 = state_56994;
(statearr_57008_57019[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56994[(4)]))){
var statearr_57009_57020 = state_56994;
(statearr_57009_57020[(1)] = cljs.core.first((state_56994[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57021 = state_56994;
state_56994 = G__57021;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56994){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57010 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57010[(6)] = c__2706__auto__);

return statearr_57010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56962){
var G__56963 = cljs.core.first(seq56962);
var seq56962__$1 = cljs.core.next(seq56962);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56963,seq56962__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57071 = arguments.length;
var i__5770__auto___57072 = (0);
while(true){
if((i__5770__auto___57072 < len__5769__auto___57071)){
args__5775__auto__.push((arguments[i__5770__auto___57072]));

var G__57073 = (i__5770__auto___57072 + (1));
i__5770__auto___57072 = G__57073;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57054){
var state_val_57055 = (state_57054[(1)]);
if((state_val_57055 === (1))){
var state_57054__$1 = state_57054;
var statearr_57056_57074 = state_57054__$1;
(statearr_57056_57074[(2)] = null);

(statearr_57056_57074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57055 === (2))){
var _ = (function (){var statearr_57057 = state_57054;
(statearr_57057[(4)] = cljs.core.cons((5),(state_57054[(4)])));

return statearr_57057;
})();
var inst_57030 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57054__$1 = state_57054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57054__$1,(6),inst_57030);
} else {
if((state_val_57055 === (3))){
var inst_57052 = (state_57054[(2)]);
var state_57054__$1 = state_57054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57054__$1,inst_57052);
} else {
if((state_val_57055 === (4))){
var inst_57024 = (state_57054[(2)]);
var state_57054__$1 = state_57054;
var statearr_57059_57075 = state_57054__$1;
(statearr_57059_57075[(2)] = inst_57024);

(statearr_57059_57075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57055 === (5))){
var _ = (function (){var statearr_57060 = state_57054;
(statearr_57060[(4)] = cljs.core.rest((state_57054[(4)])));

return statearr_57060;
})();
var state_57054__$1 = state_57054;
var ex57058 = (state_57054__$1[(2)]);
var statearr_57061_57076 = state_57054__$1;
(statearr_57061_57076[(5)] = ex57058);


if((ex57058 instanceof Error)){
var statearr_57062_57077 = state_57054__$1;
(statearr_57062_57077[(1)] = (4));

(statearr_57062_57077[(5)] = null);

} else {
throw ex57058;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57055 === (6))){
var inst_57032 = (state_57054[(2)]);
var inst_57033 = fluree.db.util.async.throw_err(inst_57032);
var inst_57034 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_57033);
var inst_57035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57036 = [inst_57033];
var inst_57037 = (new cljs.core.PersistentVector(null,1,(5),inst_57035,inst_57036,null));
var inst_57038 = cljs.core.count(inst_57037);
var inst_57039 = ((9) + inst_57038);
var inst_57040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57041 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57043 = [inst_57033];
var inst_57044 = (new cljs.core.PersistentVector(null,1,(5),inst_57042,inst_57043,null));
var inst_57045 = ["min",inst_57044,inst_57034];
var inst_57046 = cljs.core.PersistentHashMap.fromArrays(inst_57041,inst_57045);
var inst_57047 = [inst_57046,inst_57039];
var inst_57048 = (new cljs.core.PersistentVector(null,2,(5),inst_57040,inst_57047,null));
var inst_57049 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57048);
var _ = (function (){var statearr_57063 = state_57054;
(statearr_57063[(4)] = cljs.core.rest((state_57054[(4)])));

return statearr_57063;
})();
var state_57054__$1 = (function (){var statearr_57064 = state_57054;
(statearr_57064[(7)] = inst_57049);

return statearr_57064;
})();
var statearr_57065_57078 = state_57054__$1;
(statearr_57065_57078[(2)] = inst_57034);

(statearr_57065_57078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57066 = [null,null,null,null,null,null,null,null];
(statearr_57066[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57066[(1)] = (1));

return statearr_57066;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57054){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57054);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57067){var ex__2687__auto__ = e57067;
var statearr_57068_57079 = state_57054;
(statearr_57068_57079[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57054[(4)]))){
var statearr_57069_57080 = state_57054;
(statearr_57069_57080[(1)] = cljs.core.first((state_57054[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57081 = state_57054;
state_57054 = G__57081;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57054){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57070 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57070[(6)] = c__2706__auto__);

return statearr_57070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq57022){
var G__57023 = cljs.core.first(seq57022);
var seq57022__$1 = cljs.core.next(seq57022);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57023,seq57022__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__57083 = arguments.length;
switch (G__57083) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57128){
var state_val_57129 = (state_57128[(1)]);
if((state_val_57129 === (7))){
var state_57128__$1 = state_57128;
var statearr_57130_57267 = state_57128__$1;
(statearr_57130_57267[(2)] = query_map);

(statearr_57130_57267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (1))){
var state_57128__$1 = state_57128;
var statearr_57131_57268 = state_57128__$1;
(statearr_57131_57268[(2)] = null);

(statearr_57131_57268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (4))){
var inst_57084 = (state_57128[(2)]);
var state_57128__$1 = state_57128;
var statearr_57132_57269 = state_57128__$1;
(statearr_57132_57269[(2)] = inst_57084);

(statearr_57132_57269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (13))){
var inst_57106 = (state_57128[(7)]);
var inst_57110 = (state_57128[(2)]);
var inst_57111 = fluree.db.util.async.throw_err(inst_57110);
var inst_57112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57111,(0),null);
var inst_57113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57111,(1),null);
var inst_57114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57115 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57117 = [inst_57106];
var inst_57118 = (new cljs.core.PersistentVector(null,1,(5),inst_57116,inst_57117,null));
var inst_57119 = ["query",inst_57118,inst_57112];
var inst_57120 = cljs.core.PersistentHashMap.fromArrays(inst_57115,inst_57119);
var inst_57121 = [inst_57120,inst_57113];
var inst_57122 = (new cljs.core.PersistentVector(null,2,(5),inst_57114,inst_57121,null));
var inst_57123 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57122);
var _ = (function (){var statearr_57133 = state_57128;
(statearr_57133[(4)] = cljs.core.rest((state_57128[(4)])));

return statearr_57133;
})();
var state_57128__$1 = (function (){var statearr_57134 = state_57128;
(statearr_57134[(8)] = inst_57123);

return statearr_57134;
})();
var statearr_57135_57270 = state_57128__$1;
(statearr_57135_57270[(2)] = inst_57112);

(statearr_57135_57270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (6))){
var state_57128__$1 = state_57128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57128__$1,(9),query_map);
} else {
if((state_val_57129 === (3))){
var inst_57126 = (state_57128[(2)]);
var state_57128__$1 = state_57128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57128__$1,inst_57126);
} else {
if((state_val_57129 === (12))){
var inst_57106 = (state_57128[(7)]);
var inst_57106__$1 = (state_57128[(2)]);
var inst_57107 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57108 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_57107,inst_57106__$1);
var state_57128__$1 = (function (){var statearr_57136 = state_57128;
(statearr_57136[(7)] = inst_57106__$1);

return statearr_57136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57128__$1,(13),inst_57108);
} else {
if((state_val_57129 === (2))){
var _ = (function (){var statearr_57137 = state_57128;
(statearr_57137[(4)] = cljs.core.cons((5),(state_57128[(4)])));

return statearr_57137;
})();
var inst_57093 = fluree.db.util.async.channel_QMARK_(query_map);
var state_57128__$1 = state_57128;
if(inst_57093){
var statearr_57138_57271 = state_57128__$1;
(statearr_57138_57271[(1)] = (6));

} else {
var statearr_57139_57272 = state_57128__$1;
(statearr_57139_57272[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (11))){
var inst_57100 = (state_57128[(9)]);
var state_57128__$1 = state_57128;
var statearr_57141_57273 = state_57128__$1;
(statearr_57141_57273[(2)] = inst_57100);

(statearr_57141_57273[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (9))){
var inst_57096 = (state_57128[(2)]);
var inst_57097 = fluree.db.util.async.throw_err(inst_57096);
var state_57128__$1 = state_57128;
var statearr_57142_57274 = state_57128__$1;
(statearr_57142_57274[(2)] = inst_57097);

(statearr_57142_57274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (5))){
var _ = (function (){var statearr_57143 = state_57128;
(statearr_57143[(4)] = cljs.core.rest((state_57128[(4)])));

return statearr_57143;
})();
var state_57128__$1 = state_57128;
var ex57140 = (state_57128__$1[(2)]);
var statearr_57144_57275 = state_57128__$1;
(statearr_57144_57275[(5)] = ex57140);


if((ex57140 instanceof Error)){
var statearr_57145_57276 = state_57128__$1;
(statearr_57145_57276[(1)] = (4));

(statearr_57145_57276[(5)] = null);

} else {
throw ex57140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (10))){
var inst_57100 = (state_57128[(9)]);
var inst_57103 = fluree.db.util.json.parse(inst_57100);
var state_57128__$1 = state_57128;
var statearr_57146_57277 = state_57128__$1;
(statearr_57146_57277[(2)] = inst_57103);

(statearr_57146_57277[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57129 === (8))){
var inst_57100 = (state_57128[(9)]);
var inst_57100__$1 = (state_57128[(2)]);
var inst_57101 = typeof inst_57100__$1 === 'string';
var state_57128__$1 = (function (){var statearr_57147 = state_57128;
(statearr_57147[(9)] = inst_57100__$1);

return statearr_57147;
})();
if(cljs.core.truth_(inst_57101)){
var statearr_57148_57278 = state_57128__$1;
(statearr_57148_57278[(1)] = (10));

} else {
var statearr_57149_57279 = state_57128__$1;
(statearr_57149_57279[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57150 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57150[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57150[(1)] = (1));

return statearr_57150;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57128){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57128);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57151){var ex__2687__auto__ = e57151;
var statearr_57152_57280 = state_57128;
(statearr_57152_57280[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57128[(4)]))){
var statearr_57153_57281 = state_57128;
(statearr_57153_57281[(1)] = cljs.core.first((state_57128[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57282 = state_57128;
state_57128 = G__57282;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57128){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57154 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57154[(6)] = c__2706__auto__);

return statearr_57154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57225){
var state_val_57226 = (state_57225[(1)]);
if((state_val_57226 === (7))){
var state_57225__$1 = state_57225;
var statearr_57227_57283 = state_57225__$1;
(statearr_57227_57283[(2)] = select);

(statearr_57227_57283[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (20))){
var inst_57195 = (state_57225[(2)]);
var inst_57196 = fluree.db.util.async.channel_QMARK_(limit);
var state_57225__$1 = (function (){var statearr_57228 = state_57225;
(statearr_57228[(7)] = inst_57195);

return statearr_57228;
})();
if(inst_57196){
var statearr_57229_57284 = state_57225__$1;
(statearr_57229_57284[(1)] = (22));

} else {
var statearr_57230_57285 = state_57225__$1;
(statearr_57230_57285[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (1))){
var state_57225__$1 = state_57225;
var statearr_57231_57286 = state_57225__$1;
(statearr_57231_57286[(2)] = null);

(statearr_57231_57286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (24))){
var inst_57187 = (state_57225[(8)]);
var inst_57171 = (state_57225[(9)]);
var inst_57179 = (state_57225[(10)]);
var inst_57195 = (state_57225[(7)]);
var inst_57203 = (state_57225[(2)]);
var inst_57204 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57205 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_57204,inst_57171,inst_57179,inst_57187,inst_57195,inst_57203);
var state_57225__$1 = state_57225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57225__$1,(26),inst_57205);
} else {
if((state_val_57226 === (4))){
var inst_57155 = (state_57225[(2)]);
var state_57225__$1 = state_57225;
var statearr_57232_57287 = state_57225__$1;
(statearr_57232_57287[(2)] = inst_57155);

(statearr_57232_57287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (15))){
var state_57225__$1 = state_57225;
var statearr_57233_57288 = state_57225__$1;
(statearr_57233_57288[(2)] = where);

(statearr_57233_57288[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (21))){
var inst_57191 = (state_57225[(2)]);
var inst_57192 = fluree.db.util.async.throw_err(inst_57191);
var state_57225__$1 = state_57225;
var statearr_57234_57289 = state_57225__$1;
(statearr_57234_57289[(2)] = inst_57192);

(statearr_57234_57289[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (13))){
var inst_57175 = (state_57225[(2)]);
var inst_57176 = fluree.db.util.async.throw_err(inst_57175);
var state_57225__$1 = state_57225;
var statearr_57235_57290 = state_57225__$1;
(statearr_57235_57290[(2)] = inst_57176);

(statearr_57235_57290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (22))){
var state_57225__$1 = state_57225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57225__$1,(25),limit);
} else {
if((state_val_57226 === (6))){
var state_57225__$1 = state_57225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57225__$1,(9),select);
} else {
if((state_val_57226 === (25))){
var inst_57199 = (state_57225[(2)]);
var inst_57200 = fluree.db.util.async.throw_err(inst_57199);
var state_57225__$1 = state_57225;
var statearr_57236_57291 = state_57225__$1;
(statearr_57236_57291[(2)] = inst_57200);

(statearr_57236_57291[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (17))){
var inst_57183 = (state_57225[(2)]);
var inst_57184 = fluree.db.util.async.throw_err(inst_57183);
var state_57225__$1 = state_57225;
var statearr_57237_57292 = state_57225__$1;
(statearr_57237_57292[(2)] = inst_57184);

(statearr_57237_57292[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (3))){
var inst_57223 = (state_57225[(2)]);
var state_57225__$1 = state_57225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57225__$1,inst_57223);
} else {
if((state_val_57226 === (12))){
var inst_57179 = (state_57225[(2)]);
var inst_57180 = fluree.db.util.async.channel_QMARK_(where);
var state_57225__$1 = (function (){var statearr_57238 = state_57225;
(statearr_57238[(10)] = inst_57179);

return statearr_57238;
})();
if(inst_57180){
var statearr_57239_57293 = state_57225__$1;
(statearr_57239_57293[(1)] = (14));

} else {
var statearr_57240_57294 = state_57225__$1;
(statearr_57240_57294[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (2))){
var _ = (function (){var statearr_57241 = state_57225;
(statearr_57241[(4)] = cljs.core.cons((5),(state_57225[(4)])));

return statearr_57241;
})();
var inst_57164 = fluree.db.util.async.channel_QMARK_(select);
var state_57225__$1 = state_57225;
if(inst_57164){
var statearr_57242_57295 = state_57225__$1;
(statearr_57242_57295[(1)] = (6));

} else {
var statearr_57243_57296 = state_57225__$1;
(statearr_57243_57296[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (23))){
var state_57225__$1 = state_57225;
var statearr_57244_57297 = state_57225__$1;
(statearr_57244_57297[(2)] = limit);

(statearr_57244_57297[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (19))){
var state_57225__$1 = state_57225;
var statearr_57245_57298 = state_57225__$1;
(statearr_57245_57298[(2)] = block);

(statearr_57245_57298[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (11))){
var state_57225__$1 = state_57225;
var statearr_57247_57299 = state_57225__$1;
(statearr_57247_57299[(2)] = from);

(statearr_57247_57299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (9))){
var inst_57167 = (state_57225[(2)]);
var inst_57168 = fluree.db.util.async.throw_err(inst_57167);
var state_57225__$1 = state_57225;
var statearr_57248_57300 = state_57225__$1;
(statearr_57248_57300[(2)] = inst_57168);

(statearr_57248_57300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (5))){
var _ = (function (){var statearr_57249 = state_57225;
(statearr_57249[(4)] = cljs.core.rest((state_57225[(4)])));

return statearr_57249;
})();
var state_57225__$1 = state_57225;
var ex57246 = (state_57225__$1[(2)]);
var statearr_57250_57301 = state_57225__$1;
(statearr_57250_57301[(5)] = ex57246);


if((ex57246 instanceof Error)){
var statearr_57251_57302 = state_57225__$1;
(statearr_57251_57302[(1)] = (4));

(statearr_57251_57302[(5)] = null);

} else {
throw ex57246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (14))){
var state_57225__$1 = state_57225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57225__$1,(17),where);
} else {
if((state_val_57226 === (26))){
var inst_57187 = (state_57225[(8)]);
var inst_57171 = (state_57225[(9)]);
var inst_57179 = (state_57225[(10)]);
var inst_57195 = (state_57225[(7)]);
var inst_57207 = (state_57225[(2)]);
var inst_57208 = fluree.db.util.async.throw_err(inst_57207);
var inst_57209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57208,(0),null);
var inst_57210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57208,(1),null);
var inst_57211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57212 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57214 = [inst_57171,inst_57179,inst_57187,inst_57195];
var inst_57215 = (new cljs.core.PersistentVector(null,4,(5),inst_57213,inst_57214,null));
var inst_57216 = ["query",inst_57215,inst_57209];
var inst_57217 = cljs.core.PersistentHashMap.fromArrays(inst_57212,inst_57216);
var inst_57218 = [inst_57217,inst_57210];
var inst_57219 = (new cljs.core.PersistentVector(null,2,(5),inst_57211,inst_57218,null));
var inst_57220 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57219);
var _ = (function (){var statearr_57252 = state_57225;
(statearr_57252[(4)] = cljs.core.rest((state_57225[(4)])));

return statearr_57252;
})();
var state_57225__$1 = (function (){var statearr_57253 = state_57225;
(statearr_57253[(11)] = inst_57220);

return statearr_57253;
})();
var statearr_57254_57303 = state_57225__$1;
(statearr_57254_57303[(2)] = inst_57209);

(statearr_57254_57303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (16))){
var inst_57187 = (state_57225[(2)]);
var inst_57188 = fluree.db.util.async.channel_QMARK_(block);
var state_57225__$1 = (function (){var statearr_57255 = state_57225;
(statearr_57255[(8)] = inst_57187);

return statearr_57255;
})();
if(inst_57188){
var statearr_57256_57304 = state_57225__$1;
(statearr_57256_57304[(1)] = (18));

} else {
var statearr_57257_57305 = state_57225__$1;
(statearr_57257_57305[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57226 === (10))){
var state_57225__$1 = state_57225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57225__$1,(13),from);
} else {
if((state_val_57226 === (18))){
var state_57225__$1 = state_57225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57225__$1,(21),block);
} else {
if((state_val_57226 === (8))){
var inst_57171 = (state_57225[(2)]);
var inst_57172 = fluree.db.util.async.channel_QMARK_(from);
var state_57225__$1 = (function (){var statearr_57258 = state_57225;
(statearr_57258[(9)] = inst_57171);

return statearr_57258;
})();
if(inst_57172){
var statearr_57259_57306 = state_57225__$1;
(statearr_57259_57306[(1)] = (10));

} else {
var statearr_57260_57307 = state_57225__$1;
(statearr_57260_57307[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57261 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57261[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57261[(1)] = (1));

return statearr_57261;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57225){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57225);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57262){var ex__2687__auto__ = e57262;
var statearr_57263_57308 = state_57225;
(statearr_57263_57308[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57225[(4)]))){
var statearr_57264_57309 = state_57225;
(statearr_57264_57309[(1)] = cljs.core.first((state_57225[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57310 = state_57225;
state_57225 = G__57310;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57225){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57265 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57265[(6)] = c__2706__auto__);

return statearr_57265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57366){
var state_val_57367 = (state_57366[(1)]);
if((state_val_57367 === (7))){
var state_57366__$1 = state_57366;
var statearr_57368_57399 = state_57366__$1;
(statearr_57368_57399[(2)] = startSubject);

(statearr_57368_57399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (1))){
var state_57366__$1 = state_57366;
var statearr_57369_57400 = state_57366__$1;
(statearr_57369_57400[(2)] = null);

(statearr_57369_57400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (4))){
var inst_57311 = (state_57366[(2)]);
var state_57366__$1 = state_57366;
var statearr_57370_57401 = state_57366__$1;
(statearr_57370_57401[(2)] = inst_57311);

(statearr_57370_57401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (15))){
var inst_57343 = (state_57366[(2)]);
var inst_57344 = fluree.db.util.async.throw_err(inst_57343);
var inst_57345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57344,(0),null);
var inst_57346 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57344,(1),null);
var inst_57347 = cljs.core.empty_QMARK_(inst_57345);
var state_57366__$1 = (function (){var statearr_57371 = state_57366;
(statearr_57371[(7)] = inst_57346);

return statearr_57371;
})();
if(inst_57347){
var statearr_57372_57402 = state_57366__$1;
(statearr_57372_57402[(1)] = (16));

} else {
var statearr_57373_57403 = state_57366__$1;
(statearr_57373_57403[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (13))){
var inst_57331 = (state_57366[(8)]);
var inst_57339 = (state_57366[(9)]);
var inst_57327 = (state_57366[(10)]);
var inst_57339__$1 = (state_57366[(2)]);
var inst_57340 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57341 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_57340,inst_57327,inst_57331,inst_57339__$1);
var state_57366__$1 = (function (){var statearr_57374 = state_57366;
(statearr_57374[(9)] = inst_57339__$1);

return statearr_57374;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57366__$1,(15),inst_57341);
} else {
if((state_val_57367 === (6))){
var state_57366__$1 = state_57366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57366__$1,(9),startSubject);
} else {
if((state_val_57367 === (17))){
var state_57366__$1 = state_57366;
var statearr_57375_57404 = state_57366__$1;
(statearr_57375_57404[(2)] = true);

(statearr_57375_57404[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (3))){
var inst_57364 = (state_57366[(2)]);
var state_57366__$1 = state_57366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57366__$1,inst_57364);
} else {
if((state_val_57367 === (12))){
var state_57366__$1 = state_57366;
var statearr_57376_57405 = state_57366__$1;
(statearr_57376_57405[(2)] = endSubject);

(statearr_57376_57405[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (2))){
var _ = (function (){var statearr_57377 = state_57366;
(statearr_57377[(4)] = cljs.core.cons((5),(state_57366[(4)])));

return statearr_57377;
})();
var inst_57320 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_57366__$1 = state_57366;
if(inst_57320){
var statearr_57378_57406 = state_57366__$1;
(statearr_57378_57406[(1)] = (6));

} else {
var statearr_57379_57407 = state_57366__$1;
(statearr_57379_57407[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (11))){
var state_57366__$1 = state_57366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57366__$1,(14),endSubject);
} else {
if((state_val_57367 === (9))){
var inst_57323 = (state_57366[(2)]);
var inst_57324 = fluree.db.util.async.throw_err(inst_57323);
var state_57366__$1 = state_57366;
var statearr_57381_57408 = state_57366__$1;
(statearr_57381_57408[(2)] = inst_57324);

(statearr_57381_57408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (5))){
var _ = (function (){var statearr_57382 = state_57366;
(statearr_57382[(4)] = cljs.core.rest((state_57366[(4)])));

return statearr_57382;
})();
var state_57366__$1 = state_57366;
var ex57380 = (state_57366__$1[(2)]);
var statearr_57383_57409 = state_57366__$1;
(statearr_57383_57409[(5)] = ex57380);


if((ex57380 instanceof Error)){
var statearr_57384_57410 = state_57366__$1;
(statearr_57384_57410[(1)] = (4));

(statearr_57384_57410[(5)] = null);

} else {
throw ex57380;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (14))){
var inst_57335 = (state_57366[(2)]);
var inst_57336 = fluree.db.util.async.throw_err(inst_57335);
var state_57366__$1 = state_57366;
var statearr_57385_57411 = state_57366__$1;
(statearr_57385_57411[(2)] = inst_57336);

(statearr_57385_57411[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (16))){
var state_57366__$1 = state_57366;
var statearr_57386_57412 = state_57366__$1;
(statearr_57386_57412[(2)] = false);

(statearr_57386_57412[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (10))){
var inst_57330 = (state_57366[(2)]);
var inst_57331 = fluree.db.util.async.throw_err(inst_57330);
var inst_57332 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_57366__$1 = (function (){var statearr_57387 = state_57366;
(statearr_57387[(8)] = inst_57331);

return statearr_57387;
})();
if(inst_57332){
var statearr_57388_57413 = state_57366__$1;
(statearr_57388_57413[(1)] = (11));

} else {
var statearr_57389_57414 = state_57366__$1;
(statearr_57389_57414[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (18))){
var inst_57331 = (state_57366[(8)]);
var inst_57339 = (state_57366[(9)]);
var inst_57327 = (state_57366[(10)]);
var inst_57346 = (state_57366[(7)]);
var inst_57351 = (state_57366[(2)]);
var inst_57352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57353 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57355 = [inst_57327,inst_57331,inst_57339];
var inst_57356 = (new cljs.core.PersistentVector(null,3,(5),inst_57354,inst_57355,null));
var inst_57357 = ["relationship?",inst_57356,inst_57351];
var inst_57358 = cljs.core.PersistentHashMap.fromArrays(inst_57353,inst_57357);
var inst_57359 = [inst_57358,inst_57346];
var inst_57360 = (new cljs.core.PersistentVector(null,2,(5),inst_57352,inst_57359,null));
var inst_57361 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57360);
var _ = (function (){var statearr_57390 = state_57366;
(statearr_57390[(4)] = cljs.core.rest((state_57366[(4)])));

return statearr_57390;
})();
var state_57366__$1 = (function (){var statearr_57391 = state_57366;
(statearr_57391[(11)] = inst_57361);

return statearr_57391;
})();
var statearr_57392_57415 = state_57366__$1;
(statearr_57392_57415[(2)] = inst_57351);

(statearr_57392_57415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57367 === (8))){
var inst_57327 = (state_57366[(2)]);
var inst_57328 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_57366__$1 = (function (){var statearr_57393 = state_57366;
(statearr_57393[(10)] = inst_57327);

return statearr_57393;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57366__$1,(10),inst_57328);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_57394 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57394[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_57394[(1)] = (1));

return statearr_57394;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_57366){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57366);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57395){var ex__2687__auto__ = e57395;
var statearr_57396_57416 = state_57366;
(statearr_57396_57416[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57366[(4)]))){
var statearr_57397_57417 = state_57366;
(statearr_57397_57417[(1)] = cljs.core.first((state_57366[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57418 = state_57366;
state_57366 = G__57418;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = function(state_57366){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_57366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57398 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57398[(6)] = c__2706__auto__);

return statearr_57398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57455){
var state_val_57456 = (state_57455[(1)]);
if((state_val_57456 === (7))){
var state_57455__$1 = state_57455;
var statearr_57457_57477 = state_57455__$1;
(statearr_57457_57477[(2)] = pred_name);

(statearr_57457_57477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57456 === (1))){
var state_57455__$1 = state_57455;
var statearr_57458_57478 = state_57455__$1;
(statearr_57458_57478[(2)] = null);

(statearr_57458_57478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57456 === (4))){
var inst_57419 = (state_57455[(2)]);
var state_57455__$1 = state_57455;
var statearr_57459_57479 = state_57455__$1;
(statearr_57459_57479[(2)] = inst_57419);

(statearr_57459_57479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57456 === (6))){
var state_57455__$1 = state_57455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57455__$1,(9),pred_name);
} else {
if((state_val_57456 === (3))){
var inst_57453 = (state_57455[(2)]);
var state_57455__$1 = state_57455;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57455__$1,inst_57453);
} else {
if((state_val_57456 === (2))){
var _ = (function (){var statearr_57461 = state_57455;
(statearr_57461[(4)] = cljs.core.cons((5),(state_57455[(4)])));

return statearr_57461;
})();
var inst_57428 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_57455__$1 = state_57455;
if(inst_57428){
var statearr_57462_57480 = state_57455__$1;
(statearr_57462_57480[(1)] = (6));

} else {
var statearr_57463_57481 = state_57455__$1;
(statearr_57463_57481[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57456 === (9))){
var inst_57431 = (state_57455[(2)]);
var inst_57432 = fluree.db.util.async.throw_err(inst_57431);
var state_57455__$1 = state_57455;
var statearr_57464_57482 = state_57455__$1;
(statearr_57464_57482[(2)] = inst_57432);

(statearr_57464_57482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57456 === (5))){
var _ = (function (){var statearr_57465 = state_57455;
(statearr_57465[(4)] = cljs.core.rest((state_57455[(4)])));

return statearr_57465;
})();
var state_57455__$1 = state_57455;
var ex57460 = (state_57455__$1[(2)]);
var statearr_57466_57483 = state_57455__$1;
(statearr_57466_57483[(5)] = ex57460);


if((ex57460 instanceof Error)){
var statearr_57467_57484 = state_57455__$1;
(statearr_57467_57484[(1)] = (4));

(statearr_57467_57484[(5)] = null);

} else {
throw ex57460;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57456 === (10))){
var inst_57435 = (state_57455[(7)]);
var inst_57439 = (state_57455[(2)]);
var inst_57440 = fluree.db.util.async.throw_err(inst_57439);
var inst_57441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57440,(0),null);
var inst_57442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57440,(1),null);
var inst_57443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57444 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57445 = ["max-pred-val",inst_57435,inst_57441];
var inst_57446 = cljs.core.PersistentHashMap.fromArrays(inst_57444,inst_57445);
var inst_57447 = (inst_57442 + (10));
var inst_57448 = [inst_57446,inst_57447];
var inst_57449 = (new cljs.core.PersistentVector(null,2,(5),inst_57443,inst_57448,null));
var inst_57450 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57449);
var _ = (function (){var statearr_57468 = state_57455;
(statearr_57468[(4)] = cljs.core.rest((state_57455[(4)])));

return statearr_57468;
})();
var state_57455__$1 = (function (){var statearr_57469 = state_57455;
(statearr_57469[(8)] = inst_57450);

return statearr_57469;
})();
var statearr_57470_57485 = state_57455__$1;
(statearr_57470_57485[(2)] = inst_57441);

(statearr_57470_57485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57456 === (8))){
var inst_57435 = (state_57455[(7)]);
var inst_57435__$1 = (state_57455[(2)]);
var inst_57436 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57437 = fluree.db.dbfunctions.internal.max_pred_val(inst_57436,inst_57435__$1,null);
var state_57455__$1 = (function (){var statearr_57471 = state_57455;
(statearr_57471[(7)] = inst_57435__$1);

return statearr_57471;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57455__$1,(10),inst_57437);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_57472 = [null,null,null,null,null,null,null,null,null];
(statearr_57472[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__);

(statearr_57472[(1)] = (1));

return statearr_57472;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1 = (function (state_57455){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57455);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57473){var ex__2687__auto__ = e57473;
var statearr_57474_57486 = state_57455;
(statearr_57474_57486[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57455[(4)]))){
var statearr_57475_57487 = state_57455;
(statearr_57475_57487[(1)] = cljs.core.first((state_57455[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57488 = state_57455;
state_57455 = G__57488;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = function(state_57455){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1.call(this,state_57455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57476 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57476[(6)] = c__2706__auto__);

return statearr_57476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57515){
var state_val_57516 = (state_57515[(1)]);
if((state_val_57516 === (7))){
var state_57515__$1 = state_57515;
var statearr_57517_57536 = state_57515__$1;
(statearr_57517_57536[(2)] = n);

(statearr_57517_57536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57516 === (1))){
var state_57515__$1 = state_57515;
var statearr_57518_57537 = state_57515__$1;
(statearr_57518_57537[(2)] = null);

(statearr_57518_57537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57516 === (4))){
var inst_57489 = (state_57515[(2)]);
var state_57515__$1 = state_57515;
var statearr_57519_57538 = state_57515__$1;
(statearr_57519_57538[(2)] = inst_57489);

(statearr_57519_57538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57516 === (6))){
var state_57515__$1 = state_57515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57515__$1,(9),n);
} else {
if((state_val_57516 === (3))){
var inst_57513 = (state_57515[(2)]);
var state_57515__$1 = state_57515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57515__$1,inst_57513);
} else {
if((state_val_57516 === (2))){
var _ = (function (){var statearr_57521 = state_57515;
(statearr_57521[(4)] = cljs.core.cons((5),(state_57515[(4)])));

return statearr_57521;
})();
var inst_57495 = fluree.db.util.async.channel_QMARK_(n);
var state_57515__$1 = state_57515;
if(inst_57495){
var statearr_57522_57539 = state_57515__$1;
(statearr_57522_57539[(1)] = (6));

} else {
var statearr_57523_57540 = state_57515__$1;
(statearr_57523_57540[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57516 === (9))){
var inst_57498 = (state_57515[(2)]);
var inst_57499 = fluree.db.util.async.throw_err(inst_57498);
var state_57515__$1 = state_57515;
var statearr_57524_57541 = state_57515__$1;
(statearr_57524_57541[(2)] = inst_57499);

(statearr_57524_57541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57516 === (5))){
var _ = (function (){var statearr_57525 = state_57515;
(statearr_57525[(4)] = cljs.core.rest((state_57515[(4)])));

return statearr_57525;
})();
var state_57515__$1 = state_57515;
var ex57520 = (state_57515__$1[(2)]);
var statearr_57526_57542 = state_57515__$1;
(statearr_57526_57542[(5)] = ex57520);


if((ex57520 instanceof Error)){
var statearr_57527_57543 = state_57515__$1;
(statearr_57527_57543[(1)] = (4));

(statearr_57527_57543[(5)] = null);

} else {
throw ex57520;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57516 === (8))){
var inst_57502 = (state_57515[(2)]);
var inst_57503 = fluree.db.dbfunctions.internal.inc(inst_57502);
var inst_57504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57505 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57506 = ["inc",inst_57502,inst_57503];
var inst_57507 = cljs.core.PersistentHashMap.fromArrays(inst_57505,inst_57506);
var inst_57508 = [inst_57507,(10)];
var inst_57509 = (new cljs.core.PersistentVector(null,2,(5),inst_57504,inst_57508,null));
var inst_57510 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57509);
var _ = (function (){var statearr_57528 = state_57515;
(statearr_57528[(4)] = cljs.core.rest((state_57515[(4)])));

return statearr_57528;
})();
var state_57515__$1 = (function (){var statearr_57529 = state_57515;
(statearr_57529[(7)] = inst_57510);

return statearr_57529;
})();
var statearr_57530_57544 = state_57515__$1;
(statearr_57530_57544[(2)] = inst_57503);

(statearr_57530_57544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0 = (function (){
var statearr_57531 = [null,null,null,null,null,null,null,null];
(statearr_57531[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__);

(statearr_57531[(1)] = (1));

return statearr_57531;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1 = (function (state_57515){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57515);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57532){var ex__2687__auto__ = e57532;
var statearr_57533_57545 = state_57515;
(statearr_57533_57545[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57515[(4)]))){
var statearr_57534_57546 = state_57515;
(statearr_57534_57546[(1)] = cljs.core.first((state_57515[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57547 = state_57515;
state_57515 = G__57547;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = function(state_57515){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1.call(this,state_57515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57535 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57535[(6)] = c__2706__auto__);

return statearr_57535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57574){
var state_val_57575 = (state_57574[(1)]);
if((state_val_57575 === (7))){
var state_57574__$1 = state_57574;
var statearr_57576_57595 = state_57574__$1;
(statearr_57576_57595[(2)] = n);

(statearr_57576_57595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57575 === (1))){
var state_57574__$1 = state_57574;
var statearr_57577_57596 = state_57574__$1;
(statearr_57577_57596[(2)] = null);

(statearr_57577_57596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57575 === (4))){
var inst_57548 = (state_57574[(2)]);
var state_57574__$1 = state_57574;
var statearr_57578_57597 = state_57574__$1;
(statearr_57578_57597[(2)] = inst_57548);

(statearr_57578_57597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57575 === (6))){
var state_57574__$1 = state_57574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57574__$1,(9),n);
} else {
if((state_val_57575 === (3))){
var inst_57572 = (state_57574[(2)]);
var state_57574__$1 = state_57574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57574__$1,inst_57572);
} else {
if((state_val_57575 === (2))){
var _ = (function (){var statearr_57580 = state_57574;
(statearr_57580[(4)] = cljs.core.cons((5),(state_57574[(4)])));

return statearr_57580;
})();
var inst_57554 = fluree.db.util.async.channel_QMARK_(n);
var state_57574__$1 = state_57574;
if(inst_57554){
var statearr_57581_57598 = state_57574__$1;
(statearr_57581_57598[(1)] = (6));

} else {
var statearr_57582_57599 = state_57574__$1;
(statearr_57582_57599[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57575 === (9))){
var inst_57557 = (state_57574[(2)]);
var inst_57558 = fluree.db.util.async.throw_err(inst_57557);
var state_57574__$1 = state_57574;
var statearr_57583_57600 = state_57574__$1;
(statearr_57583_57600[(2)] = inst_57558);

(statearr_57583_57600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57575 === (5))){
var _ = (function (){var statearr_57584 = state_57574;
(statearr_57584[(4)] = cljs.core.rest((state_57574[(4)])));

return statearr_57584;
})();
var state_57574__$1 = state_57574;
var ex57579 = (state_57574__$1[(2)]);
var statearr_57585_57601 = state_57574__$1;
(statearr_57585_57601[(5)] = ex57579);


if((ex57579 instanceof Error)){
var statearr_57586_57602 = state_57574__$1;
(statearr_57586_57602[(1)] = (4));

(statearr_57586_57602[(5)] = null);

} else {
throw ex57579;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57575 === (8))){
var inst_57561 = (state_57574[(2)]);
var inst_57562 = fluree.db.dbfunctions.internal.dec(inst_57561);
var inst_57563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57564 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57565 = ["dec",inst_57561,inst_57562];
var inst_57566 = cljs.core.PersistentHashMap.fromArrays(inst_57564,inst_57565);
var inst_57567 = [inst_57566,(10)];
var inst_57568 = (new cljs.core.PersistentVector(null,2,(5),inst_57563,inst_57567,null));
var inst_57569 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57568);
var _ = (function (){var statearr_57587 = state_57574;
(statearr_57587[(4)] = cljs.core.rest((state_57574[(4)])));

return statearr_57587;
})();
var state_57574__$1 = (function (){var statearr_57588 = state_57574;
(statearr_57588[(7)] = inst_57569);

return statearr_57588;
})();
var statearr_57589_57603 = state_57574__$1;
(statearr_57589_57603[(2)] = inst_57562);

(statearr_57589_57603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0 = (function (){
var statearr_57590 = [null,null,null,null,null,null,null,null];
(statearr_57590[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__);

(statearr_57590[(1)] = (1));

return statearr_57590;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1 = (function (state_57574){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57574);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57591){var ex__2687__auto__ = e57591;
var statearr_57592_57604 = state_57574;
(statearr_57592_57604[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57574[(4)]))){
var statearr_57593_57605 = state_57574;
(statearr_57593_57605[(1)] = cljs.core.first((state_57574[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57606 = state_57574;
state_57574 = G__57606;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = function(state_57574){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1.call(this,state_57574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57594 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57594[(6)] = c__2706__auto__);

return statearr_57594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57656 = arguments.length;
var i__5770__auto___57657 = (0);
while(true){
if((i__5770__auto___57657 < len__5769__auto___57656)){
args__5775__auto__.push((arguments[i__5770__auto___57657]));

var G__57658 = (i__5770__auto___57657 + (1));
i__5770__auto___57657 = G__57658;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57639){
var state_val_57640 = (state_57639[(1)]);
if((state_val_57640 === (1))){
var state_57639__$1 = state_57639;
var statearr_57641_57659 = state_57639__$1;
(statearr_57641_57659[(2)] = null);

(statearr_57641_57659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57640 === (2))){
var _ = (function (){var statearr_57642 = state_57639;
(statearr_57642[(4)] = cljs.core.cons((5),(state_57639[(4)])));

return statearr_57642;
})();
var inst_57615 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57639__$1 = state_57639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57639__$1,(6),inst_57615);
} else {
if((state_val_57640 === (3))){
var inst_57637 = (state_57639[(2)]);
var state_57639__$1 = state_57639;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57639__$1,inst_57637);
} else {
if((state_val_57640 === (4))){
var inst_57609 = (state_57639[(2)]);
var state_57639__$1 = state_57639;
var statearr_57644_57660 = state_57639__$1;
(statearr_57644_57660[(2)] = inst_57609);

(statearr_57644_57660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57640 === (5))){
var _ = (function (){var statearr_57645 = state_57639;
(statearr_57645[(4)] = cljs.core.rest((state_57639[(4)])));

return statearr_57645;
})();
var state_57639__$1 = state_57639;
var ex57643 = (state_57639__$1[(2)]);
var statearr_57646_57661 = state_57639__$1;
(statearr_57646_57661[(5)] = ex57643);


if((ex57643 instanceof Error)){
var statearr_57647_57662 = state_57639__$1;
(statearr_57647_57662[(1)] = (4));

(statearr_57647_57662[(5)] = null);

} else {
throw ex57643;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57640 === (6))){
var inst_57617 = (state_57639[(2)]);
var inst_57618 = fluree.db.util.async.throw_err(inst_57617);
var inst_57619 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_57618);
var inst_57620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57621 = [inst_57618];
var inst_57622 = (new cljs.core.PersistentVector(null,1,(5),inst_57620,inst_57621,null));
var inst_57623 = cljs.core.count(inst_57622);
var inst_57624 = ((9) + inst_57623);
var inst_57625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57626 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57628 = [inst_57618];
var inst_57629 = (new cljs.core.PersistentVector(null,1,(5),inst_57627,inst_57628,null));
var inst_57630 = ["+",inst_57629,inst_57619];
var inst_57631 = cljs.core.PersistentHashMap.fromArrays(inst_57626,inst_57630);
var inst_57632 = [inst_57631,inst_57624];
var inst_57633 = (new cljs.core.PersistentVector(null,2,(5),inst_57625,inst_57632,null));
var inst_57634 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57633);
var _ = (function (){var statearr_57648 = state_57639;
(statearr_57648[(4)] = cljs.core.rest((state_57639[(4)])));

return statearr_57648;
})();
var state_57639__$1 = (function (){var statearr_57649 = state_57639;
(statearr_57649[(7)] = inst_57634);

return statearr_57649;
})();
var statearr_57650_57663 = state_57639__$1;
(statearr_57650_57663[(2)] = inst_57619);

(statearr_57650_57663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57651 = [null,null,null,null,null,null,null,null];
(statearr_57651[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57651[(1)] = (1));

return statearr_57651;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57639){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57639);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57652){var ex__2687__auto__ = e57652;
var statearr_57653_57664 = state_57639;
(statearr_57653_57664[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57639[(4)]))){
var statearr_57654_57665 = state_57639;
(statearr_57654_57665[(1)] = cljs.core.first((state_57639[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57666 = state_57639;
state_57639 = G__57666;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57639){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57655 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57655[(6)] = c__2706__auto__);

return statearr_57655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq57607){
var G__57608 = cljs.core.first(seq57607);
var seq57607__$1 = cljs.core.next(seq57607);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57608,seq57607__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57716 = arguments.length;
var i__5770__auto___57717 = (0);
while(true){
if((i__5770__auto___57717 < len__5769__auto___57716)){
args__5775__auto__.push((arguments[i__5770__auto___57717]));

var G__57718 = (i__5770__auto___57717 + (1));
i__5770__auto___57717 = G__57718;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57699){
var state_val_57700 = (state_57699[(1)]);
if((state_val_57700 === (1))){
var state_57699__$1 = state_57699;
var statearr_57701_57719 = state_57699__$1;
(statearr_57701_57719[(2)] = null);

(statearr_57701_57719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57700 === (2))){
var _ = (function (){var statearr_57702 = state_57699;
(statearr_57702[(4)] = cljs.core.cons((5),(state_57699[(4)])));

return statearr_57702;
})();
var inst_57675 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57699__$1 = state_57699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57699__$1,(6),inst_57675);
} else {
if((state_val_57700 === (3))){
var inst_57697 = (state_57699[(2)]);
var state_57699__$1 = state_57699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57699__$1,inst_57697);
} else {
if((state_val_57700 === (4))){
var inst_57669 = (state_57699[(2)]);
var state_57699__$1 = state_57699;
var statearr_57704_57720 = state_57699__$1;
(statearr_57704_57720[(2)] = inst_57669);

(statearr_57704_57720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57700 === (5))){
var _ = (function (){var statearr_57705 = state_57699;
(statearr_57705[(4)] = cljs.core.rest((state_57699[(4)])));

return statearr_57705;
})();
var state_57699__$1 = state_57699;
var ex57703 = (state_57699__$1[(2)]);
var statearr_57706_57721 = state_57699__$1;
(statearr_57706_57721[(5)] = ex57703);


if((ex57703 instanceof Error)){
var statearr_57707_57722 = state_57699__$1;
(statearr_57707_57722[(1)] = (4));

(statearr_57707_57722[(5)] = null);

} else {
throw ex57703;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57700 === (6))){
var inst_57677 = (state_57699[(2)]);
var inst_57678 = fluree.db.util.async.throw_err(inst_57677);
var inst_57679 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_57678);
var inst_57680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57681 = [inst_57678];
var inst_57682 = (new cljs.core.PersistentVector(null,1,(5),inst_57680,inst_57681,null));
var inst_57683 = cljs.core.count(inst_57682);
var inst_57684 = ((9) + inst_57683);
var inst_57685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57686 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57688 = [inst_57678];
var inst_57689 = (new cljs.core.PersistentVector(null,1,(5),inst_57687,inst_57688,null));
var inst_57690 = ["-",inst_57689,inst_57679];
var inst_57691 = cljs.core.PersistentHashMap.fromArrays(inst_57686,inst_57690);
var inst_57692 = [inst_57691,inst_57684];
var inst_57693 = (new cljs.core.PersistentVector(null,2,(5),inst_57685,inst_57692,null));
var inst_57694 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57693);
var _ = (function (){var statearr_57708 = state_57699;
(statearr_57708[(4)] = cljs.core.rest((state_57699[(4)])));

return statearr_57708;
})();
var state_57699__$1 = (function (){var statearr_57709 = state_57699;
(statearr_57709[(7)] = inst_57694);

return statearr_57709;
})();
var statearr_57710_57723 = state_57699__$1;
(statearr_57710_57723[(2)] = inst_57679);

(statearr_57710_57723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57711 = [null,null,null,null,null,null,null,null];
(statearr_57711[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57711[(1)] = (1));

return statearr_57711;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57699){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57699);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57712){var ex__2687__auto__ = e57712;
var statearr_57713_57724 = state_57699;
(statearr_57713_57724[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57699[(4)]))){
var statearr_57714_57725 = state_57699;
(statearr_57714_57725[(1)] = cljs.core.first((state_57699[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57726 = state_57699;
state_57699 = G__57726;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57699){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57715 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57715[(6)] = c__2706__auto__);

return statearr_57715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq57667){
var G__57668 = cljs.core.first(seq57667);
var seq57667__$1 = cljs.core.next(seq57667);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57668,seq57667__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57776 = arguments.length;
var i__5770__auto___57777 = (0);
while(true){
if((i__5770__auto___57777 < len__5769__auto___57776)){
args__5775__auto__.push((arguments[i__5770__auto___57777]));

var G__57778 = (i__5770__auto___57777 + (1));
i__5770__auto___57777 = G__57778;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57759){
var state_val_57760 = (state_57759[(1)]);
if((state_val_57760 === (1))){
var state_57759__$1 = state_57759;
var statearr_57761_57779 = state_57759__$1;
(statearr_57761_57779[(2)] = null);

(statearr_57761_57779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57760 === (2))){
var _ = (function (){var statearr_57762 = state_57759;
(statearr_57762[(4)] = cljs.core.cons((5),(state_57759[(4)])));

return statearr_57762;
})();
var inst_57735 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57759__$1 = state_57759;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57759__$1,(6),inst_57735);
} else {
if((state_val_57760 === (3))){
var inst_57757 = (state_57759[(2)]);
var state_57759__$1 = state_57759;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57759__$1,inst_57757);
} else {
if((state_val_57760 === (4))){
var inst_57729 = (state_57759[(2)]);
var state_57759__$1 = state_57759;
var statearr_57764_57780 = state_57759__$1;
(statearr_57764_57780[(2)] = inst_57729);

(statearr_57764_57780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57760 === (5))){
var _ = (function (){var statearr_57765 = state_57759;
(statearr_57765[(4)] = cljs.core.rest((state_57759[(4)])));

return statearr_57765;
})();
var state_57759__$1 = state_57759;
var ex57763 = (state_57759__$1[(2)]);
var statearr_57766_57781 = state_57759__$1;
(statearr_57766_57781[(5)] = ex57763);


if((ex57763 instanceof Error)){
var statearr_57767_57782 = state_57759__$1;
(statearr_57767_57782[(1)] = (4));

(statearr_57767_57782[(5)] = null);

} else {
throw ex57763;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57760 === (6))){
var inst_57737 = (state_57759[(2)]);
var inst_57738 = fluree.db.util.async.throw_err(inst_57737);
var inst_57739 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_57738);
var inst_57740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57741 = [inst_57738];
var inst_57742 = (new cljs.core.PersistentVector(null,1,(5),inst_57740,inst_57741,null));
var inst_57743 = cljs.core.count(inst_57742);
var inst_57744 = ((9) + inst_57743);
var inst_57745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57746 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57748 = [inst_57738];
var inst_57749 = (new cljs.core.PersistentVector(null,1,(5),inst_57747,inst_57748,null));
var inst_57750 = ["*",inst_57749,inst_57739];
var inst_57751 = cljs.core.PersistentHashMap.fromArrays(inst_57746,inst_57750);
var inst_57752 = [inst_57751,inst_57744];
var inst_57753 = (new cljs.core.PersistentVector(null,2,(5),inst_57745,inst_57752,null));
var inst_57754 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57753);
var _ = (function (){var statearr_57768 = state_57759;
(statearr_57768[(4)] = cljs.core.rest((state_57759[(4)])));

return statearr_57768;
})();
var state_57759__$1 = (function (){var statearr_57769 = state_57759;
(statearr_57769[(7)] = inst_57754);

return statearr_57769;
})();
var statearr_57770_57783 = state_57759__$1;
(statearr_57770_57783[(2)] = inst_57739);

(statearr_57770_57783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57771 = [null,null,null,null,null,null,null,null];
(statearr_57771[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57771[(1)] = (1));

return statearr_57771;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57759){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57759);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57772){var ex__2687__auto__ = e57772;
var statearr_57773_57784 = state_57759;
(statearr_57773_57784[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57759[(4)]))){
var statearr_57774_57785 = state_57759;
(statearr_57774_57785[(1)] = cljs.core.first((state_57759[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57786 = state_57759;
state_57759 = G__57786;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57759){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57775 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57775[(6)] = c__2706__auto__);

return statearr_57775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq57727){
var G__57728 = cljs.core.first(seq57727);
var seq57727__$1 = cljs.core.next(seq57727);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57728,seq57727__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57836 = arguments.length;
var i__5770__auto___57837 = (0);
while(true){
if((i__5770__auto___57837 < len__5769__auto___57836)){
args__5775__auto__.push((arguments[i__5770__auto___57837]));

var G__57838 = (i__5770__auto___57837 + (1));
i__5770__auto___57837 = G__57838;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57819){
var state_val_57820 = (state_57819[(1)]);
if((state_val_57820 === (1))){
var state_57819__$1 = state_57819;
var statearr_57821_57839 = state_57819__$1;
(statearr_57821_57839[(2)] = null);

(statearr_57821_57839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57820 === (2))){
var _ = (function (){var statearr_57822 = state_57819;
(statearr_57822[(4)] = cljs.core.cons((5),(state_57819[(4)])));

return statearr_57822;
})();
var inst_57795 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57819__$1 = state_57819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57819__$1,(6),inst_57795);
} else {
if((state_val_57820 === (3))){
var inst_57817 = (state_57819[(2)]);
var state_57819__$1 = state_57819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57819__$1,inst_57817);
} else {
if((state_val_57820 === (4))){
var inst_57789 = (state_57819[(2)]);
var state_57819__$1 = state_57819;
var statearr_57824_57840 = state_57819__$1;
(statearr_57824_57840[(2)] = inst_57789);

(statearr_57824_57840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57820 === (5))){
var _ = (function (){var statearr_57825 = state_57819;
(statearr_57825[(4)] = cljs.core.rest((state_57819[(4)])));

return statearr_57825;
})();
var state_57819__$1 = state_57819;
var ex57823 = (state_57819__$1[(2)]);
var statearr_57826_57841 = state_57819__$1;
(statearr_57826_57841[(5)] = ex57823);


if((ex57823 instanceof Error)){
var statearr_57827_57842 = state_57819__$1;
(statearr_57827_57842[(1)] = (4));

(statearr_57827_57842[(5)] = null);

} else {
throw ex57823;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57820 === (6))){
var inst_57797 = (state_57819[(2)]);
var inst_57798 = fluree.db.util.async.throw_err(inst_57797);
var inst_57799 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_57798);
var inst_57800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57801 = [inst_57798];
var inst_57802 = (new cljs.core.PersistentVector(null,1,(5),inst_57800,inst_57801,null));
var inst_57803 = cljs.core.count(inst_57802);
var inst_57804 = ((9) + inst_57803);
var inst_57805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57806 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57808 = [inst_57798];
var inst_57809 = (new cljs.core.PersistentVector(null,1,(5),inst_57807,inst_57808,null));
var inst_57810 = ["/",inst_57809,inst_57799];
var inst_57811 = cljs.core.PersistentHashMap.fromArrays(inst_57806,inst_57810);
var inst_57812 = [inst_57811,inst_57804];
var inst_57813 = (new cljs.core.PersistentVector(null,2,(5),inst_57805,inst_57812,null));
var inst_57814 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57813);
var _ = (function (){var statearr_57828 = state_57819;
(statearr_57828[(4)] = cljs.core.rest((state_57819[(4)])));

return statearr_57828;
})();
var state_57819__$1 = (function (){var statearr_57829 = state_57819;
(statearr_57829[(7)] = inst_57814);

return statearr_57829;
})();
var statearr_57830_57843 = state_57819__$1;
(statearr_57830_57843[(2)] = inst_57799);

(statearr_57830_57843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57831 = [null,null,null,null,null,null,null,null];
(statearr_57831[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57831[(1)] = (1));

return statearr_57831;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57819){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57819);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57832){var ex__2687__auto__ = e57832;
var statearr_57833_57844 = state_57819;
(statearr_57833_57844[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57819[(4)]))){
var statearr_57834_57845 = state_57819;
(statearr_57834_57845[(1)] = cljs.core.first((state_57819[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57846 = state_57819;
state_57819 = G__57846;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57819){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57835 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57835[(6)] = c__2706__auto__);

return statearr_57835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq57787){
var G__57788 = cljs.core.first(seq57787);
var seq57787__$1 = cljs.core.next(seq57787);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57788,seq57787__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57884){
var state_val_57885 = (state_57884[(1)]);
if((state_val_57885 === (7))){
var state_57884__$1 = state_57884;
var statearr_57886_57910 = state_57884__$1;
(statearr_57886_57910[(2)] = n);

(statearr_57886_57910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (1))){
var state_57884__$1 = state_57884;
var statearr_57887_57911 = state_57884__$1;
(statearr_57887_57911[(2)] = null);

(statearr_57887_57911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (4))){
var inst_57847 = (state_57884[(2)]);
var state_57884__$1 = state_57884;
var statearr_57888_57912 = state_57884__$1;
(statearr_57888_57912[(2)] = inst_57847);

(statearr_57888_57912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (13))){
var inst_57864 = (state_57884[(2)]);
var inst_57865 = fluree.db.util.async.throw_err(inst_57864);
var state_57884__$1 = state_57884;
var statearr_57889_57913 = state_57884__$1;
(statearr_57889_57913[(2)] = inst_57865);

(statearr_57889_57913[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (6))){
var state_57884__$1 = state_57884;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57884__$1,(9),n);
} else {
if((state_val_57885 === (3))){
var inst_57882 = (state_57884[(2)]);
var state_57884__$1 = state_57884;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57884__$1,inst_57882);
} else {
if((state_val_57885 === (12))){
var inst_57860 = (state_57884[(7)]);
var inst_57868 = (state_57884[(2)]);
var inst_57869 = fluree.db.dbfunctions.internal.quot(inst_57860,inst_57868);
var inst_57870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57871 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57873 = [inst_57860,inst_57868];
var inst_57874 = (new cljs.core.PersistentVector(null,2,(5),inst_57872,inst_57873,null));
var inst_57875 = ["quot",inst_57874,inst_57869];
var inst_57876 = cljs.core.PersistentHashMap.fromArrays(inst_57871,inst_57875);
var inst_57877 = [inst_57876,(2)];
var inst_57878 = (new cljs.core.PersistentVector(null,2,(5),inst_57870,inst_57877,null));
var inst_57879 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57878);
var _ = (function (){var statearr_57890 = state_57884;
(statearr_57890[(4)] = cljs.core.rest((state_57884[(4)])));

return statearr_57890;
})();
var state_57884__$1 = (function (){var statearr_57891 = state_57884;
(statearr_57891[(8)] = inst_57879);

return statearr_57891;
})();
var statearr_57892_57914 = state_57884__$1;
(statearr_57892_57914[(2)] = inst_57869);

(statearr_57892_57914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (2))){
var _ = (function (){var statearr_57893 = state_57884;
(statearr_57893[(4)] = cljs.core.cons((5),(state_57884[(4)])));

return statearr_57893;
})();
var inst_57853 = fluree.db.util.async.channel_QMARK_(n);
var state_57884__$1 = state_57884;
if(inst_57853){
var statearr_57894_57915 = state_57884__$1;
(statearr_57894_57915[(1)] = (6));

} else {
var statearr_57895_57916 = state_57884__$1;
(statearr_57895_57916[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (11))){
var state_57884__$1 = state_57884;
var statearr_57897_57917 = state_57884__$1;
(statearr_57897_57917[(2)] = d);

(statearr_57897_57917[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (9))){
var inst_57856 = (state_57884[(2)]);
var inst_57857 = fluree.db.util.async.throw_err(inst_57856);
var state_57884__$1 = state_57884;
var statearr_57898_57918 = state_57884__$1;
(statearr_57898_57918[(2)] = inst_57857);

(statearr_57898_57918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (5))){
var _ = (function (){var statearr_57899 = state_57884;
(statearr_57899[(4)] = cljs.core.rest((state_57884[(4)])));

return statearr_57899;
})();
var state_57884__$1 = state_57884;
var ex57896 = (state_57884__$1[(2)]);
var statearr_57900_57919 = state_57884__$1;
(statearr_57900_57919[(5)] = ex57896);


if((ex57896 instanceof Error)){
var statearr_57901_57920 = state_57884__$1;
(statearr_57901_57920[(1)] = (4));

(statearr_57901_57920[(5)] = null);

} else {
throw ex57896;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57885 === (10))){
var state_57884__$1 = state_57884;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57884__$1,(13),d);
} else {
if((state_val_57885 === (8))){
var inst_57860 = (state_57884[(2)]);
var inst_57861 = fluree.db.util.async.channel_QMARK_(d);
var state_57884__$1 = (function (){var statearr_57902 = state_57884;
(statearr_57902[(7)] = inst_57860);

return statearr_57902;
})();
if(inst_57861){
var statearr_57903_57921 = state_57884__$1;
(statearr_57903_57921[(1)] = (10));

} else {
var statearr_57904_57922 = state_57884__$1;
(statearr_57904_57922[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0 = (function (){
var statearr_57905 = [null,null,null,null,null,null,null,null,null];
(statearr_57905[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__);

(statearr_57905[(1)] = (1));

return statearr_57905;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1 = (function (state_57884){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57884);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57906){var ex__2687__auto__ = e57906;
var statearr_57907_57923 = state_57884;
(statearr_57907_57923[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57884[(4)]))){
var statearr_57908_57924 = state_57884;
(statearr_57908_57924[(1)] = cljs.core.first((state_57884[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57925 = state_57884;
state_57884 = G__57925;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = function(state_57884){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1.call(this,state_57884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57909 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57909[(6)] = c__2706__auto__);

return statearr_57909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57963){
var state_val_57964 = (state_57963[(1)]);
if((state_val_57964 === (7))){
var state_57963__$1 = state_57963;
var statearr_57965_57989 = state_57963__$1;
(statearr_57965_57989[(2)] = n);

(statearr_57965_57989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (1))){
var state_57963__$1 = state_57963;
var statearr_57966_57990 = state_57963__$1;
(statearr_57966_57990[(2)] = null);

(statearr_57966_57990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (4))){
var inst_57926 = (state_57963[(2)]);
var state_57963__$1 = state_57963;
var statearr_57967_57991 = state_57963__$1;
(statearr_57967_57991[(2)] = inst_57926);

(statearr_57967_57991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (13))){
var inst_57943 = (state_57963[(2)]);
var inst_57944 = fluree.db.util.async.throw_err(inst_57943);
var state_57963__$1 = state_57963;
var statearr_57968_57992 = state_57963__$1;
(statearr_57968_57992[(2)] = inst_57944);

(statearr_57968_57992[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (6))){
var state_57963__$1 = state_57963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57963__$1,(9),n);
} else {
if((state_val_57964 === (3))){
var inst_57961 = (state_57963[(2)]);
var state_57963__$1 = state_57963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57963__$1,inst_57961);
} else {
if((state_val_57964 === (12))){
var inst_57939 = (state_57963[(7)]);
var inst_57947 = (state_57963[(2)]);
var inst_57948 = fluree.db.dbfunctions.internal.mod(inst_57939,inst_57947);
var inst_57949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57950 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57952 = [inst_57939,inst_57947];
var inst_57953 = (new cljs.core.PersistentVector(null,2,(5),inst_57951,inst_57952,null));
var inst_57954 = ["mod",inst_57953,inst_57948];
var inst_57955 = cljs.core.PersistentHashMap.fromArrays(inst_57950,inst_57954);
var inst_57956 = [inst_57955,(2)];
var inst_57957 = (new cljs.core.PersistentVector(null,2,(5),inst_57949,inst_57956,null));
var inst_57958 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57957);
var _ = (function (){var statearr_57969 = state_57963;
(statearr_57969[(4)] = cljs.core.rest((state_57963[(4)])));

return statearr_57969;
})();
var state_57963__$1 = (function (){var statearr_57970 = state_57963;
(statearr_57970[(8)] = inst_57958);

return statearr_57970;
})();
var statearr_57971_57993 = state_57963__$1;
(statearr_57971_57993[(2)] = inst_57948);

(statearr_57971_57993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (2))){
var _ = (function (){var statearr_57972 = state_57963;
(statearr_57972[(4)] = cljs.core.cons((5),(state_57963[(4)])));

return statearr_57972;
})();
var inst_57932 = fluree.db.util.async.channel_QMARK_(n);
var state_57963__$1 = state_57963;
if(inst_57932){
var statearr_57973_57994 = state_57963__$1;
(statearr_57973_57994[(1)] = (6));

} else {
var statearr_57974_57995 = state_57963__$1;
(statearr_57974_57995[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (11))){
var state_57963__$1 = state_57963;
var statearr_57976_57996 = state_57963__$1;
(statearr_57976_57996[(2)] = d);

(statearr_57976_57996[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (9))){
var inst_57935 = (state_57963[(2)]);
var inst_57936 = fluree.db.util.async.throw_err(inst_57935);
var state_57963__$1 = state_57963;
var statearr_57977_57997 = state_57963__$1;
(statearr_57977_57997[(2)] = inst_57936);

(statearr_57977_57997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (5))){
var _ = (function (){var statearr_57978 = state_57963;
(statearr_57978[(4)] = cljs.core.rest((state_57963[(4)])));

return statearr_57978;
})();
var state_57963__$1 = state_57963;
var ex57975 = (state_57963__$1[(2)]);
var statearr_57979_57998 = state_57963__$1;
(statearr_57979_57998[(5)] = ex57975);


if((ex57975 instanceof Error)){
var statearr_57980_57999 = state_57963__$1;
(statearr_57980_57999[(1)] = (4));

(statearr_57980_57999[(5)] = null);

} else {
throw ex57975;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57964 === (10))){
var state_57963__$1 = state_57963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57963__$1,(13),d);
} else {
if((state_val_57964 === (8))){
var inst_57939 = (state_57963[(2)]);
var inst_57940 = fluree.db.util.async.channel_QMARK_(d);
var state_57963__$1 = (function (){var statearr_57981 = state_57963;
(statearr_57981[(7)] = inst_57939);

return statearr_57981;
})();
if(inst_57940){
var statearr_57982_58000 = state_57963__$1;
(statearr_57982_58000[(1)] = (10));

} else {
var statearr_57983_58001 = state_57963__$1;
(statearr_57983_58001[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0 = (function (){
var statearr_57984 = [null,null,null,null,null,null,null,null,null];
(statearr_57984[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__);

(statearr_57984[(1)] = (1));

return statearr_57984;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1 = (function (state_57963){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57963);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57985){var ex__2687__auto__ = e57985;
var statearr_57986_58002 = state_57963;
(statearr_57986_58002[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57963[(4)]))){
var statearr_57987_58003 = state_57963;
(statearr_57987_58003[(1)] = cljs.core.first((state_57963[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58004 = state_57963;
state_57963 = G__58004;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = function(state_57963){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1.call(this,state_57963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57988 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57988[(6)] = c__2706__auto__);

return statearr_57988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58042){
var state_val_58043 = (state_58042[(1)]);
if((state_val_58043 === (7))){
var state_58042__$1 = state_58042;
var statearr_58044_58068 = state_58042__$1;
(statearr_58044_58068[(2)] = n);

(statearr_58044_58068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (1))){
var state_58042__$1 = state_58042;
var statearr_58045_58069 = state_58042__$1;
(statearr_58045_58069[(2)] = null);

(statearr_58045_58069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (4))){
var inst_58005 = (state_58042[(2)]);
var state_58042__$1 = state_58042;
var statearr_58046_58070 = state_58042__$1;
(statearr_58046_58070[(2)] = inst_58005);

(statearr_58046_58070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (13))){
var inst_58022 = (state_58042[(2)]);
var inst_58023 = fluree.db.util.async.throw_err(inst_58022);
var state_58042__$1 = state_58042;
var statearr_58047_58071 = state_58042__$1;
(statearr_58047_58071[(2)] = inst_58023);

(statearr_58047_58071[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (6))){
var state_58042__$1 = state_58042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58042__$1,(9),n);
} else {
if((state_val_58043 === (3))){
var inst_58040 = (state_58042[(2)]);
var state_58042__$1 = state_58042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58042__$1,inst_58040);
} else {
if((state_val_58043 === (12))){
var inst_58018 = (state_58042[(7)]);
var inst_58026 = (state_58042[(2)]);
var inst_58027 = fluree.db.dbfunctions.internal.rem(inst_58018,inst_58026);
var inst_58028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58029 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58031 = [inst_58018,inst_58026];
var inst_58032 = (new cljs.core.PersistentVector(null,2,(5),inst_58030,inst_58031,null));
var inst_58033 = ["rem",inst_58032,inst_58027];
var inst_58034 = cljs.core.PersistentHashMap.fromArrays(inst_58029,inst_58033);
var inst_58035 = [inst_58034,(2)];
var inst_58036 = (new cljs.core.PersistentVector(null,2,(5),inst_58028,inst_58035,null));
var inst_58037 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58036);
var _ = (function (){var statearr_58048 = state_58042;
(statearr_58048[(4)] = cljs.core.rest((state_58042[(4)])));

return statearr_58048;
})();
var state_58042__$1 = (function (){var statearr_58049 = state_58042;
(statearr_58049[(8)] = inst_58037);

return statearr_58049;
})();
var statearr_58050_58072 = state_58042__$1;
(statearr_58050_58072[(2)] = inst_58027);

(statearr_58050_58072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (2))){
var _ = (function (){var statearr_58051 = state_58042;
(statearr_58051[(4)] = cljs.core.cons((5),(state_58042[(4)])));

return statearr_58051;
})();
var inst_58011 = fluree.db.util.async.channel_QMARK_(n);
var state_58042__$1 = state_58042;
if(inst_58011){
var statearr_58052_58073 = state_58042__$1;
(statearr_58052_58073[(1)] = (6));

} else {
var statearr_58053_58074 = state_58042__$1;
(statearr_58053_58074[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (11))){
var state_58042__$1 = state_58042;
var statearr_58055_58075 = state_58042__$1;
(statearr_58055_58075[(2)] = d);

(statearr_58055_58075[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (9))){
var inst_58014 = (state_58042[(2)]);
var inst_58015 = fluree.db.util.async.throw_err(inst_58014);
var state_58042__$1 = state_58042;
var statearr_58056_58076 = state_58042__$1;
(statearr_58056_58076[(2)] = inst_58015);

(statearr_58056_58076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (5))){
var _ = (function (){var statearr_58057 = state_58042;
(statearr_58057[(4)] = cljs.core.rest((state_58042[(4)])));

return statearr_58057;
})();
var state_58042__$1 = state_58042;
var ex58054 = (state_58042__$1[(2)]);
var statearr_58058_58077 = state_58042__$1;
(statearr_58058_58077[(5)] = ex58054);


if((ex58054 instanceof Error)){
var statearr_58059_58078 = state_58042__$1;
(statearr_58059_58078[(1)] = (4));

(statearr_58059_58078[(5)] = null);

} else {
throw ex58054;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58043 === (10))){
var state_58042__$1 = state_58042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58042__$1,(13),d);
} else {
if((state_val_58043 === (8))){
var inst_58018 = (state_58042[(2)]);
var inst_58019 = fluree.db.util.async.channel_QMARK_(d);
var state_58042__$1 = (function (){var statearr_58060 = state_58042;
(statearr_58060[(7)] = inst_58018);

return statearr_58060;
})();
if(inst_58019){
var statearr_58061_58079 = state_58042__$1;
(statearr_58061_58079[(1)] = (10));

} else {
var statearr_58062_58080 = state_58042__$1;
(statearr_58062_58080[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0 = (function (){
var statearr_58063 = [null,null,null,null,null,null,null,null,null];
(statearr_58063[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__);

(statearr_58063[(1)] = (1));

return statearr_58063;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1 = (function (state_58042){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58042);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58064){var ex__2687__auto__ = e58064;
var statearr_58065_58081 = state_58042;
(statearr_58065_58081[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58042[(4)]))){
var statearr_58066_58082 = state_58042;
(statearr_58066_58082[(1)] = cljs.core.first((state_58042[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58083 = state_58042;
state_58042 = G__58083;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = function(state_58042){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1.call(this,state_58042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58067 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58067[(6)] = c__2706__auto__);

return statearr_58067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58110){
var state_val_58111 = (state_58110[(1)]);
if((state_val_58111 === (7))){
var state_58110__$1 = state_58110;
var statearr_58112_58131 = state_58110__$1;
(statearr_58112_58131[(2)] = x);

(statearr_58112_58131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58111 === (1))){
var state_58110__$1 = state_58110;
var statearr_58113_58132 = state_58110__$1;
(statearr_58113_58132[(2)] = null);

(statearr_58113_58132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58111 === (4))){
var inst_58084 = (state_58110[(2)]);
var state_58110__$1 = state_58110;
var statearr_58114_58133 = state_58110__$1;
(statearr_58114_58133[(2)] = inst_58084);

(statearr_58114_58133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58111 === (6))){
var state_58110__$1 = state_58110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58110__$1,(9),x);
} else {
if((state_val_58111 === (3))){
var inst_58108 = (state_58110[(2)]);
var state_58110__$1 = state_58110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58110__$1,inst_58108);
} else {
if((state_val_58111 === (2))){
var _ = (function (){var statearr_58116 = state_58110;
(statearr_58116[(4)] = cljs.core.cons((5),(state_58110[(4)])));

return statearr_58116;
})();
var inst_58090 = fluree.db.util.async.channel_QMARK_(x);
var state_58110__$1 = state_58110;
if(inst_58090){
var statearr_58117_58134 = state_58110__$1;
(statearr_58117_58134[(1)] = (6));

} else {
var statearr_58118_58135 = state_58110__$1;
(statearr_58118_58135[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58111 === (9))){
var inst_58093 = (state_58110[(2)]);
var inst_58094 = fluree.db.util.async.throw_err(inst_58093);
var state_58110__$1 = state_58110;
var statearr_58119_58136 = state_58110__$1;
(statearr_58119_58136[(2)] = inst_58094);

(statearr_58119_58136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58111 === (5))){
var _ = (function (){var statearr_58120 = state_58110;
(statearr_58120[(4)] = cljs.core.rest((state_58110[(4)])));

return statearr_58120;
})();
var state_58110__$1 = state_58110;
var ex58115 = (state_58110__$1[(2)]);
var statearr_58121_58137 = state_58110__$1;
(statearr_58121_58137[(5)] = ex58115);


if((ex58115 instanceof Error)){
var statearr_58122_58138 = state_58110__$1;
(statearr_58122_58138[(1)] = (4));

(statearr_58122_58138[(5)] = null);

} else {
throw ex58115;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58111 === (8))){
var inst_58097 = (state_58110[(2)]);
var inst_58098 = fluree.db.dbfunctions.internal.boolean$(inst_58097);
var inst_58099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58100 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58101 = ["boolean",inst_58097,inst_58098];
var inst_58102 = cljs.core.PersistentHashMap.fromArrays(inst_58100,inst_58101);
var inst_58103 = [inst_58102,(10)];
var inst_58104 = (new cljs.core.PersistentVector(null,2,(5),inst_58099,inst_58103,null));
var inst_58105 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58104);
var _ = (function (){var statearr_58123 = state_58110;
(statearr_58123[(4)] = cljs.core.rest((state_58110[(4)])));

return statearr_58123;
})();
var state_58110__$1 = (function (){var statearr_58124 = state_58110;
(statearr_58124[(7)] = inst_58105);

return statearr_58124;
})();
var statearr_58125_58139 = state_58110__$1;
(statearr_58125_58139[(2)] = inst_58098);

(statearr_58125_58139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0 = (function (){
var statearr_58126 = [null,null,null,null,null,null,null,null];
(statearr_58126[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__);

(statearr_58126[(1)] = (1));

return statearr_58126;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1 = (function (state_58110){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58110);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58127){var ex__2687__auto__ = e58127;
var statearr_58128_58140 = state_58110;
(statearr_58128_58140[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58110[(4)]))){
var statearr_58129_58141 = state_58110;
(statearr_58129_58141[(1)] = cljs.core.first((state_58110[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58142 = state_58110;
state_58110 = G__58142;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = function(state_58110){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1.call(this,state_58110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58130 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58130[(6)] = c__2706__auto__);

return statearr_58130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58180){
var state_val_58181 = (state_58180[(1)]);
if((state_val_58181 === (7))){
var state_58180__$1 = state_58180;
var statearr_58182_58206 = state_58180__$1;
(statearr_58182_58206[(2)] = pattern);

(statearr_58182_58206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (1))){
var state_58180__$1 = state_58180;
var statearr_58183_58207 = state_58180__$1;
(statearr_58183_58207[(2)] = null);

(statearr_58183_58207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (4))){
var inst_58143 = (state_58180[(2)]);
var state_58180__$1 = state_58180;
var statearr_58184_58208 = state_58180__$1;
(statearr_58184_58208[(2)] = inst_58143);

(statearr_58184_58208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (13))){
var inst_58160 = (state_58180[(2)]);
var inst_58161 = fluree.db.util.async.throw_err(inst_58160);
var state_58180__$1 = state_58180;
var statearr_58185_58209 = state_58180__$1;
(statearr_58185_58209[(2)] = inst_58161);

(statearr_58185_58209[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (6))){
var state_58180__$1 = state_58180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58180__$1,(9),pattern);
} else {
if((state_val_58181 === (3))){
var inst_58178 = (state_58180[(2)]);
var state_58180__$1 = state_58180;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58180__$1,inst_58178);
} else {
if((state_val_58181 === (12))){
var inst_58156 = (state_58180[(7)]);
var inst_58164 = (state_58180[(2)]);
var inst_58165 = fluree.db.dbfunctions.internal.re_find(inst_58156,inst_58164);
var inst_58166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58167 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58169 = [inst_58156,inst_58164];
var inst_58170 = (new cljs.core.PersistentVector(null,2,(5),inst_58168,inst_58169,null));
var inst_58171 = ["re-find",inst_58170,inst_58165];
var inst_58172 = cljs.core.PersistentHashMap.fromArrays(inst_58167,inst_58171);
var inst_58173 = [inst_58172,(10)];
var inst_58174 = (new cljs.core.PersistentVector(null,2,(5),inst_58166,inst_58173,null));
var inst_58175 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58174);
var _ = (function (){var statearr_58186 = state_58180;
(statearr_58186[(4)] = cljs.core.rest((state_58180[(4)])));

return statearr_58186;
})();
var state_58180__$1 = (function (){var statearr_58187 = state_58180;
(statearr_58187[(8)] = inst_58175);

return statearr_58187;
})();
var statearr_58188_58210 = state_58180__$1;
(statearr_58188_58210[(2)] = inst_58165);

(statearr_58188_58210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (2))){
var _ = (function (){var statearr_58189 = state_58180;
(statearr_58189[(4)] = cljs.core.cons((5),(state_58180[(4)])));

return statearr_58189;
})();
var inst_58149 = fluree.db.util.async.channel_QMARK_(pattern);
var state_58180__$1 = state_58180;
if(inst_58149){
var statearr_58190_58211 = state_58180__$1;
(statearr_58190_58211[(1)] = (6));

} else {
var statearr_58191_58212 = state_58180__$1;
(statearr_58191_58212[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (11))){
var state_58180__$1 = state_58180;
var statearr_58193_58213 = state_58180__$1;
(statearr_58193_58213[(2)] = string);

(statearr_58193_58213[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (9))){
var inst_58152 = (state_58180[(2)]);
var inst_58153 = fluree.db.util.async.throw_err(inst_58152);
var state_58180__$1 = state_58180;
var statearr_58194_58214 = state_58180__$1;
(statearr_58194_58214[(2)] = inst_58153);

(statearr_58194_58214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (5))){
var _ = (function (){var statearr_58195 = state_58180;
(statearr_58195[(4)] = cljs.core.rest((state_58180[(4)])));

return statearr_58195;
})();
var state_58180__$1 = state_58180;
var ex58192 = (state_58180__$1[(2)]);
var statearr_58196_58215 = state_58180__$1;
(statearr_58196_58215[(5)] = ex58192);


if((ex58192 instanceof Error)){
var statearr_58197_58216 = state_58180__$1;
(statearr_58197_58216[(1)] = (4));

(statearr_58197_58216[(5)] = null);

} else {
throw ex58192;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58181 === (10))){
var state_58180__$1 = state_58180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58180__$1,(13),string);
} else {
if((state_val_58181 === (8))){
var inst_58156 = (state_58180[(2)]);
var inst_58157 = fluree.db.util.async.channel_QMARK_(string);
var state_58180__$1 = (function (){var statearr_58198 = state_58180;
(statearr_58198[(7)] = inst_58156);

return statearr_58198;
})();
if(inst_58157){
var statearr_58199_58217 = state_58180__$1;
(statearr_58199_58217[(1)] = (10));

} else {
var statearr_58200_58218 = state_58180__$1;
(statearr_58200_58218[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0 = (function (){
var statearr_58201 = [null,null,null,null,null,null,null,null,null];
(statearr_58201[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__);

(statearr_58201[(1)] = (1));

return statearr_58201;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1 = (function (state_58180){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58180);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58202){var ex__2687__auto__ = e58202;
var statearr_58203_58219 = state_58180;
(statearr_58203_58219[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58180[(4)]))){
var statearr_58204_58220 = state_58180;
(statearr_58204_58220[(1)] = cljs.core.first((state_58180[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58221 = state_58180;
state_58180 = G__58221;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = function(state_58180){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1.call(this,state_58180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58205 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58205[(6)] = c__2706__auto__);

return statearr_58205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58248){
var state_val_58249 = (state_58248[(1)]);
if((state_val_58249 === (7))){
var state_58248__$1 = state_58248;
var statearr_58250_58269 = state_58248__$1;
(statearr_58250_58269[(2)] = email);

(statearr_58250_58269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58249 === (1))){
var state_58248__$1 = state_58248;
var statearr_58251_58270 = state_58248__$1;
(statearr_58251_58270[(2)] = null);

(statearr_58251_58270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58249 === (4))){
var inst_58222 = (state_58248[(2)]);
var state_58248__$1 = state_58248;
var statearr_58252_58271 = state_58248__$1;
(statearr_58252_58271[(2)] = inst_58222);

(statearr_58252_58271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58249 === (6))){
var state_58248__$1 = state_58248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58248__$1,(9),email);
} else {
if((state_val_58249 === (3))){
var inst_58246 = (state_58248[(2)]);
var state_58248__$1 = state_58248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58248__$1,inst_58246);
} else {
if((state_val_58249 === (2))){
var _ = (function (){var statearr_58254 = state_58248;
(statearr_58254[(4)] = cljs.core.cons((5),(state_58248[(4)])));

return statearr_58254;
})();
var inst_58228 = fluree.db.util.async.channel_QMARK_(email);
var state_58248__$1 = state_58248;
if(inst_58228){
var statearr_58255_58272 = state_58248__$1;
(statearr_58255_58272[(1)] = (6));

} else {
var statearr_58256_58273 = state_58248__$1;
(statearr_58256_58273[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58249 === (9))){
var inst_58231 = (state_58248[(2)]);
var inst_58232 = fluree.db.util.async.throw_err(inst_58231);
var state_58248__$1 = state_58248;
var statearr_58257_58274 = state_58248__$1;
(statearr_58257_58274[(2)] = inst_58232);

(statearr_58257_58274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58249 === (5))){
var _ = (function (){var statearr_58258 = state_58248;
(statearr_58258[(4)] = cljs.core.rest((state_58248[(4)])));

return statearr_58258;
})();
var state_58248__$1 = state_58248;
var ex58253 = (state_58248__$1[(2)]);
var statearr_58259_58275 = state_58248__$1;
(statearr_58259_58275[(5)] = ex58253);


if((ex58253 instanceof Error)){
var statearr_58260_58276 = state_58248__$1;
(statearr_58260_58276[(1)] = (4));

(statearr_58260_58276[(5)] = null);

} else {
throw ex58253;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58249 === (8))){
var inst_58235 = (state_58248[(2)]);
var inst_58236 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_58235);
var inst_58237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58238 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58239 = ["re-find",inst_58235,inst_58236];
var inst_58240 = cljs.core.PersistentHashMap.fromArrays(inst_58238,inst_58239);
var inst_58241 = [inst_58240,(10)];
var inst_58242 = (new cljs.core.PersistentVector(null,2,(5),inst_58237,inst_58241,null));
var inst_58243 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58242);
var _ = (function (){var statearr_58261 = state_58248;
(statearr_58261[(4)] = cljs.core.rest((state_58248[(4)])));

return statearr_58261;
})();
var state_58248__$1 = (function (){var statearr_58262 = state_58248;
(statearr_58262[(7)] = inst_58243);

return statearr_58262;
})();
var statearr_58263_58277 = state_58248__$1;
(statearr_58263_58277[(2)] = inst_58236);

(statearr_58263_58277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_58264 = [null,null,null,null,null,null,null,null];
(statearr_58264[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__);

(statearr_58264[(1)] = (1));

return statearr_58264;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1 = (function (state_58248){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58248);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58265){var ex__2687__auto__ = e58265;
var statearr_58266_58278 = state_58248;
(statearr_58266_58278[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58248[(4)]))){
var statearr_58267_58279 = state_58248;
(statearr_58267_58279[(1)] = cljs.core.first((state_58248[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58280 = state_58248;
state_58248 = G__58280;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = function(state_58248){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1.call(this,state_58248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58268 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58268[(6)] = c__2706__auto__);

return statearr_58268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58327){
var state_val_58328 = (state_58327[(1)]);
if((state_val_58328 === (7))){
var inst_58297 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_58327__$1 = state_58327;
if(cljs.core.truth_(inst_58297)){
var statearr_58329_58356 = state_58327__$1;
(statearr_58329_58356[(1)] = (9));

} else {
var statearr_58330_58357 = state_58327__$1;
(statearr_58330_58357[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (1))){
var state_58327__$1 = state_58327;
var statearr_58331_58358 = state_58327__$1;
(statearr_58331_58358[(2)] = null);

(statearr_58331_58358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (4))){
var inst_58281 = (state_58327[(2)]);
var state_58327__$1 = state_58327;
var statearr_58332_58359 = state_58327__$1;
(statearr_58332_58359[(2)] = inst_58281);

(statearr_58332_58359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (15))){
var inst_58308 = (state_58327[(2)]);
var state_58327__$1 = state_58327;
var statearr_58333_58360 = state_58327__$1;
(statearr_58333_58360[(2)] = inst_58308);

(statearr_58333_58360[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (13))){
var inst_58305 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_58327__$1 = state_58327;
var statearr_58334_58361 = state_58327__$1;
(statearr_58334_58361[(2)] = inst_58305);

(statearr_58334_58361[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (6))){
var inst_58292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58293 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_58294 = [inst_58293,(0)];
var inst_58295 = (new cljs.core.PersistentVector(null,2,(5),inst_58292,inst_58294,null));
var state_58327__$1 = state_58327;
var statearr_58335_58362 = state_58327__$1;
(statearr_58335_58362[(2)] = inst_58295);

(statearr_58335_58362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (3))){
var inst_58325 = (state_58327[(2)]);
var state_58327__$1 = state_58327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58327__$1,inst_58325);
} else {
if((state_val_58328 === (12))){
var inst_58301 = (state_58327[(2)]);
var inst_58302 = fluree.db.util.async.throw_err(inst_58301);
var state_58327__$1 = state_58327;
var statearr_58336_58363 = state_58327__$1;
(statearr_58336_58363[(2)] = inst_58302);

(statearr_58336_58363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (2))){
var _ = (function (){var statearr_58337 = state_58327;
(statearr_58337[(4)] = cljs.core.cons((5),(state_58327[(4)])));

return statearr_58337;
})();
var inst_58290 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_58327__$1 = state_58327;
if(cljs.core.truth_(inst_58290)){
var statearr_58338_58364 = state_58327__$1;
(statearr_58338_58364[(1)] = (6));

} else {
var statearr_58339_58365 = state_58327__$1;
(statearr_58339_58365[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (11))){
var inst_58310 = (state_58327[(2)]);
var state_58327__$1 = state_58327;
var statearr_58341_58366 = state_58327__$1;
(statearr_58341_58366[(2)] = inst_58310);

(statearr_58341_58366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (9))){
var inst_58299 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_58327__$1 = state_58327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58327__$1,(12),inst_58299);
} else {
if((state_val_58328 === (5))){
var _ = (function (){var statearr_58342 = state_58327;
(statearr_58342[(4)] = cljs.core.rest((state_58327[(4)])));

return statearr_58342;
})();
var state_58327__$1 = state_58327;
var ex58340 = (state_58327__$1[(2)]);
var statearr_58343_58367 = state_58327__$1;
(statearr_58343_58367[(5)] = ex58340);


if((ex58340 instanceof Error)){
var statearr_58344_58368 = state_58327__$1;
(statearr_58344_58368[(1)] = (4));

(statearr_58344_58368[(5)] = null);

} else {
throw ex58340;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (14))){
var state_58327__$1 = state_58327;
var statearr_58345_58369 = state_58327__$1;
(statearr_58345_58369[(2)] = null);

(statearr_58345_58369[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (10))){
var state_58327__$1 = state_58327;
var statearr_58346_58370 = state_58327__$1;
(statearr_58346_58370[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58328 === (8))){
var inst_58312 = (state_58327[(2)]);
var inst_58313 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_58312,(0),null);
var inst_58314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_58312,(1),null);
var inst_58315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58316 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58317 = ["?user_id","?ctx",inst_58313];
var inst_58318 = cljs.core.PersistentHashMap.fromArrays(inst_58316,inst_58317);
var inst_58319 = ((10) + inst_58314);
var inst_58320 = [inst_58318,inst_58319];
var inst_58321 = (new cljs.core.PersistentVector(null,2,(5),inst_58315,inst_58320,null));
var inst_58322 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58321);
var _ = (function (){var statearr_58348 = state_58327;
(statearr_58348[(4)] = cljs.core.rest((state_58327[(4)])));

return statearr_58348;
})();
var state_58327__$1 = (function (){var statearr_58349 = state_58327;
(statearr_58349[(7)] = inst_58322);

return statearr_58349;
})();
var statearr_58350_58371 = state_58327__$1;
(statearr_58350_58371[(2)] = inst_58313);

(statearr_58350_58371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0 = (function (){
var statearr_58351 = [null,null,null,null,null,null,null,null];
(statearr_58351[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__);

(statearr_58351[(1)] = (1));

return statearr_58351;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1 = (function (state_58327){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58327);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58352){var ex__2687__auto__ = e58352;
var statearr_58353_58372 = state_58327;
(statearr_58353_58372[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58327[(4)]))){
var statearr_58354_58373 = state_58327;
(statearr_58354_58373[(1)] = cljs.core.first((state_58327[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58374 = state_58327;
state_58327 = G__58374;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = function(state_58327){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1.call(this,state_58327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58355 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58355[(6)] = c__2706__auto__);

return statearr_58355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58402){
var state_val_58403 = (state_58402[(1)]);
if((state_val_58403 === (7))){
var inst_58395 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_58402__$1 = state_58402;
var statearr_58404_58423 = state_58402__$1;
(statearr_58404_58423[(2)] = inst_58395);

(statearr_58404_58423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58403 === (1))){
var state_58402__$1 = state_58402;
var statearr_58405_58424 = state_58402__$1;
(statearr_58405_58424[(2)] = null);

(statearr_58405_58424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58403 === (4))){
var inst_58375 = (state_58402[(2)]);
var state_58402__$1 = state_58402;
var statearr_58406_58425 = state_58402__$1;
(statearr_58406_58425[(2)] = inst_58375);

(statearr_58406_58425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58403 === (6))){
var inst_58383 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_58402__$1 = state_58402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58402__$1,(9),inst_58383);
} else {
if((state_val_58403 === (3))){
var inst_58400 = (state_58402[(2)]);
var state_58402__$1 = state_58402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58402__$1,inst_58400);
} else {
if((state_val_58403 === (2))){
var _ = (function (){var statearr_58408 = state_58402;
(statearr_58408[(4)] = cljs.core.cons((5),(state_58402[(4)])));

return statearr_58408;
})();
var inst_58381 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_58402__$1 = state_58402;
if(cljs.core.truth_(inst_58381)){
var statearr_58409_58426 = state_58402__$1;
(statearr_58409_58426[(1)] = (6));

} else {
var statearr_58410_58427 = state_58402__$1;
(statearr_58410_58427[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58403 === (9))){
var inst_58385 = (state_58402[(2)]);
var inst_58386 = fluree.db.util.async.throw_err(inst_58385);
var inst_58387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58388 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58389 = ["?auth_id","?ctx",inst_58386];
var inst_58390 = cljs.core.PersistentHashMap.fromArrays(inst_58388,inst_58389);
var inst_58391 = [inst_58390,(10)];
var inst_58392 = (new cljs.core.PersistentVector(null,2,(5),inst_58387,inst_58391,null));
var inst_58393 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58392);
var state_58402__$1 = (function (){var statearr_58411 = state_58402;
(statearr_58411[(7)] = inst_58393);

return statearr_58411;
})();
var statearr_58412_58428 = state_58402__$1;
(statearr_58412_58428[(2)] = inst_58386);

(statearr_58412_58428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58403 === (5))){
var _ = (function (){var statearr_58413 = state_58402;
(statearr_58413[(4)] = cljs.core.rest((state_58402[(4)])));

return statearr_58413;
})();
var state_58402__$1 = state_58402;
var ex58407 = (state_58402__$1[(2)]);
var statearr_58414_58429 = state_58402__$1;
(statearr_58414_58429[(5)] = ex58407);


if((ex58407 instanceof Error)){
var statearr_58415_58430 = state_58402__$1;
(statearr_58415_58430[(1)] = (4));

(statearr_58415_58430[(5)] = null);

} else {
throw ex58407;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58403 === (8))){
var inst_58397 = (state_58402[(2)]);
var _ = (function (){var statearr_58416 = state_58402;
(statearr_58416[(4)] = cljs.core.rest((state_58402[(4)])));

return statearr_58416;
})();
var state_58402__$1 = state_58402;
var statearr_58417_58431 = state_58402__$1;
(statearr_58417_58431[(2)] = inst_58397);

(statearr_58417_58431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_58418 = [null,null,null,null,null,null,null,null];
(statearr_58418[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_58418[(1)] = (1));

return statearr_58418;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_58402){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58402);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58419){var ex__2687__auto__ = e58419;
var statearr_58420_58432 = state_58402;
(statearr_58420_58432[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58402[(4)]))){
var statearr_58421_58433 = state_58402;
(statearr_58421_58433[(1)] = cljs.core.first((state_58402[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58434 = state_58402;
state_58402 = G__58434;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_58402){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_58402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58422 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58422[(6)] = c__2706__auto__);

return statearr_58422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__58436 = arguments.length;
switch (G__58436) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58478){
var state_val_58479 = (state_58478[(1)]);
if((state_val_58479 === (7))){
var state_58478__$1 = state_58478;
var statearr_58480_58510 = state_58478__$1;
(statearr_58480_58510[(2)] = seed);

(statearr_58480_58510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (1))){
var state_58478__$1 = state_58478;
var statearr_58481_58511 = state_58478__$1;
(statearr_58481_58511[(2)] = null);

(statearr_58481_58511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (4))){
var inst_58437 = (state_58478[(2)]);
var state_58478__$1 = state_58478;
var statearr_58482_58512 = state_58478__$1;
(statearr_58482_58512[(2)] = inst_58437);

(statearr_58482_58512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (15))){
var state_58478__$1 = state_58478;
var statearr_58483_58513 = state_58478__$1;
(statearr_58483_58513[(2)] = (10));

(statearr_58483_58513[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (13))){
var inst_58454 = (state_58478[(2)]);
var inst_58455 = fluree.db.util.async.throw_err(inst_58454);
var state_58478__$1 = state_58478;
var statearr_58484_58514 = state_58478__$1;
(statearr_58484_58514[(2)] = inst_58455);

(statearr_58484_58514[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (6))){
var state_58478__$1 = state_58478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58478__$1,(9),seed);
} else {
if((state_val_58479 === (3))){
var inst_58476 = (state_58478[(2)]);
var state_58478__$1 = state_58478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58478__$1,inst_58476);
} else {
if((state_val_58479 === (12))){
var inst_58458 = (state_58478[(7)]);
var inst_58458__$1 = (state_58478[(2)]);
var state_58478__$1 = (function (){var statearr_58485 = state_58478;
(statearr_58485[(7)] = inst_58458__$1);

return statearr_58485;
})();
if(cljs.core.truth_(inst_58458__$1)){
var statearr_58486_58515 = state_58478__$1;
(statearr_58486_58515[(1)] = (14));

} else {
var statearr_58487_58516 = state_58478__$1;
(statearr_58487_58516[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (2))){
var _ = (function (){var statearr_58488 = state_58478;
(statearr_58488[(4)] = cljs.core.cons((5),(state_58478[(4)])));

return statearr_58488;
})();
var inst_58443 = fluree.db.util.async.channel_QMARK_(seed);
var state_58478__$1 = state_58478;
if(inst_58443){
var statearr_58489_58517 = state_58478__$1;
(statearr_58489_58517[(1)] = (6));

} else {
var statearr_58490_58518 = state_58478__$1;
(statearr_58490_58518[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (11))){
var state_58478__$1 = state_58478;
var statearr_58492_58519 = state_58478__$1;
(statearr_58492_58519[(2)] = max);

(statearr_58492_58519[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (9))){
var inst_58446 = (state_58478[(2)]);
var inst_58447 = fluree.db.util.async.throw_err(inst_58446);
var state_58478__$1 = state_58478;
var statearr_58493_58520 = state_58478__$1;
(statearr_58493_58520[(2)] = inst_58447);

(statearr_58493_58520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (5))){
var _ = (function (){var statearr_58494 = state_58478;
(statearr_58494[(4)] = cljs.core.rest((state_58478[(4)])));

return statearr_58494;
})();
var state_58478__$1 = state_58478;
var ex58491 = (state_58478__$1[(2)]);
var statearr_58495_58521 = state_58478__$1;
(statearr_58495_58521[(5)] = ex58491);


if((ex58491 instanceof Error)){
var statearr_58496_58522 = state_58478__$1;
(statearr_58496_58522[(1)] = (4));

(statearr_58496_58522[(5)] = null);

} else {
throw ex58491;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (14))){
var inst_58458 = (state_58478[(7)]);
var state_58478__$1 = state_58478;
var statearr_58497_58523 = state_58478__$1;
(statearr_58497_58523[(2)] = inst_58458);

(statearr_58497_58523[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (16))){
var inst_58450 = (state_58478[(8)]);
var inst_58462 = (state_58478[(2)]);
var inst_58463 = fluree.db.dbfunctions.internal.rand(inst_58450,inst_58462);
var inst_58464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58465 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58467 = [max,seed];
var inst_58468 = (new cljs.core.PersistentVector(null,2,(5),inst_58466,inst_58467,null));
var inst_58469 = ["rand",inst_58468,inst_58463];
var inst_58470 = cljs.core.PersistentHashMap.fromArrays(inst_58465,inst_58469);
var inst_58471 = [inst_58470,(10)];
var inst_58472 = (new cljs.core.PersistentVector(null,2,(5),inst_58464,inst_58471,null));
var inst_58473 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58472);
var _ = (function (){var statearr_58498 = state_58478;
(statearr_58498[(4)] = cljs.core.rest((state_58478[(4)])));

return statearr_58498;
})();
var state_58478__$1 = (function (){var statearr_58499 = state_58478;
(statearr_58499[(9)] = inst_58473);

return statearr_58499;
})();
var statearr_58500_58524 = state_58478__$1;
(statearr_58500_58524[(2)] = inst_58463);

(statearr_58500_58524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58479 === (10))){
var state_58478__$1 = state_58478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58478__$1,(13),max);
} else {
if((state_val_58479 === (8))){
var inst_58450 = (state_58478[(2)]);
var inst_58451 = fluree.db.util.async.channel_QMARK_(max);
var state_58478__$1 = (function (){var statearr_58501 = state_58478;
(statearr_58501[(8)] = inst_58450);

return statearr_58501;
})();
if(inst_58451){
var statearr_58502_58525 = state_58478__$1;
(statearr_58502_58525[(1)] = (10));

} else {
var statearr_58503_58526 = state_58478__$1;
(statearr_58503_58526[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_58504 = [null,null,null,null,null,null,null,null,null,null];
(statearr_58504[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_58504[(1)] = (1));

return statearr_58504;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_58478){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58478);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58505){var ex__2687__auto__ = e58505;
var statearr_58506_58527 = state_58478;
(statearr_58506_58527[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58478[(4)]))){
var statearr_58507_58528 = state_58478;
(statearr_58507_58528[(1)] = cljs.core.first((state_58478[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58529 = state_58478;
state_58478 = G__58529;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_58478){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_58478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58508 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58508[(6)] = c__2706__auto__);

return statearr_58508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58550){
var state_val_58551 = (state_58550[(1)]);
if((state_val_58551 === (1))){
var state_58550__$1 = state_58550;
var statearr_58552_58567 = state_58550__$1;
(statearr_58552_58567[(2)] = null);

(statearr_58552_58567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58551 === (2))){
var _ = (function (){var statearr_58553 = state_58550;
(statearr_58553[(4)] = cljs.core.cons((5),(state_58550[(4)])));

return statearr_58553;
})();
var inst_58536 = cljs.core.random_uuid();
var inst_58537 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58536);
var inst_58538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58539 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58540 = cljs.core.PersistentVector.EMPTY;
var inst_58541 = ["uuid",inst_58540,inst_58537];
var inst_58542 = cljs.core.PersistentHashMap.fromArrays(inst_58539,inst_58541);
var inst_58543 = [inst_58542,(10)];
var inst_58544 = (new cljs.core.PersistentVector(null,2,(5),inst_58538,inst_58543,null));
var inst_58545 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58544);
var ___$1 = (function (){var statearr_58554 = state_58550;
(statearr_58554[(4)] = cljs.core.rest((state_58550[(4)])));

return statearr_58554;
})();
var state_58550__$1 = (function (){var statearr_58555 = state_58550;
(statearr_58555[(7)] = inst_58545);

return statearr_58555;
})();
var statearr_58556_58568 = state_58550__$1;
(statearr_58556_58568[(2)] = inst_58537);

(statearr_58556_58568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58551 === (3))){
var inst_58548 = (state_58550[(2)]);
var state_58550__$1 = state_58550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58550__$1,inst_58548);
} else {
if((state_val_58551 === (4))){
var inst_58530 = (state_58550[(2)]);
var state_58550__$1 = state_58550;
var statearr_58558_58569 = state_58550__$1;
(statearr_58558_58569[(2)] = inst_58530);

(statearr_58558_58569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58551 === (5))){
var _ = (function (){var statearr_58559 = state_58550;
(statearr_58559[(4)] = cljs.core.rest((state_58550[(4)])));

return statearr_58559;
})();
var state_58550__$1 = state_58550;
var ex58557 = (state_58550__$1[(2)]);
var statearr_58560_58570 = state_58550__$1;
(statearr_58560_58570[(5)] = ex58557);


if((ex58557 instanceof Error)){
var statearr_58561_58571 = state_58550__$1;
(statearr_58561_58571[(1)] = (4));

(statearr_58561_58571[(5)] = null);

} else {
throw ex58557;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0 = (function (){
var statearr_58562 = [null,null,null,null,null,null,null,null];
(statearr_58562[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__);

(statearr_58562[(1)] = (1));

return statearr_58562;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1 = (function (state_58550){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58550);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58563){var ex__2687__auto__ = e58563;
var statearr_58564_58572 = state_58550;
(statearr_58564_58572[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58550[(4)]))){
var statearr_58565_58573 = state_58550;
(statearr_58565_58573[(1)] = cljs.core.first((state_58550[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58574 = state_58550;
state_58550 = G__58574;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = function(state_58550){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1.call(this,state_58550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58566 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58566[(6)] = c__2706__auto__);

return statearr_58566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58604){
var state_val_58605 = (state_58604[(1)]);
if((state_val_58605 === (7))){
var state_58604__$1 = state_58604;
var statearr_58606_58625 = state_58604__$1;
(statearr_58606_58625[(2)] = num);

(statearr_58606_58625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58605 === (1))){
var state_58604__$1 = state_58604;
var statearr_58607_58626 = state_58604__$1;
(statearr_58607_58626[(2)] = null);

(statearr_58607_58626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58605 === (4))){
var inst_58575 = (state_58604[(2)]);
var state_58604__$1 = state_58604;
var statearr_58608_58627 = state_58604__$1;
(statearr_58608_58627[(2)] = inst_58575);

(statearr_58608_58627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58605 === (6))){
var state_58604__$1 = state_58604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58604__$1,(9),num);
} else {
if((state_val_58605 === (3))){
var inst_58602 = (state_58604[(2)]);
var state_58604__$1 = state_58604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58604__$1,inst_58602);
} else {
if((state_val_58605 === (2))){
var _ = (function (){var statearr_58610 = state_58604;
(statearr_58610[(4)] = cljs.core.cons((5),(state_58604[(4)])));

return statearr_58610;
})();
var inst_58581 = fluree.db.util.async.channel_QMARK_(num);
var state_58604__$1 = state_58604;
if(inst_58581){
var statearr_58611_58628 = state_58604__$1;
(statearr_58611_58628[(1)] = (6));

} else {
var statearr_58612_58629 = state_58604__$1;
(statearr_58612_58629[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58605 === (9))){
var inst_58584 = (state_58604[(2)]);
var inst_58585 = fluree.db.util.async.throw_err(inst_58584);
var state_58604__$1 = state_58604;
var statearr_58613_58630 = state_58604__$1;
(statearr_58613_58630[(2)] = inst_58585);

(statearr_58613_58630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58605 === (5))){
var _ = (function (){var statearr_58614 = state_58604;
(statearr_58614[(4)] = cljs.core.rest((state_58604[(4)])));

return statearr_58614;
})();
var state_58604__$1 = state_58604;
var ex58609 = (state_58604__$1[(2)]);
var statearr_58615_58631 = state_58604__$1;
(statearr_58615_58631[(5)] = ex58609);


if((ex58609 instanceof Error)){
var statearr_58616_58632 = state_58604__$1;
(statearr_58616_58632[(1)] = (4));

(statearr_58616_58632[(5)] = null);

} else {
throw ex58609;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58605 === (8))){
var inst_58588 = (state_58604[(2)]);
var inst_58589 = fluree.db.dbfunctions.internal.ceil(inst_58588);
var inst_58590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58591 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58593 = [fluree.db.dbfunctions.fns.ceil];
var inst_58594 = (new cljs.core.PersistentVector(null,1,(5),inst_58592,inst_58593,null));
var inst_58595 = ["",inst_58594,inst_58589];
var inst_58596 = cljs.core.PersistentHashMap.fromArrays(inst_58591,inst_58595);
var inst_58597 = [inst_58596,(10)];
var inst_58598 = (new cljs.core.PersistentVector(null,2,(5),inst_58590,inst_58597,null));
var inst_58599 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58598);
var _ = (function (){var statearr_58617 = state_58604;
(statearr_58617[(4)] = cljs.core.rest((state_58604[(4)])));

return statearr_58617;
})();
var state_58604__$1 = (function (){var statearr_58618 = state_58604;
(statearr_58618[(7)] = inst_58599);

return statearr_58618;
})();
var statearr_58619_58633 = state_58604__$1;
(statearr_58619_58633[(2)] = inst_58589);

(statearr_58619_58633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0 = (function (){
var statearr_58620 = [null,null,null,null,null,null,null,null];
(statearr_58620[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__);

(statearr_58620[(1)] = (1));

return statearr_58620;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1 = (function (state_58604){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58604);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58621){var ex__2687__auto__ = e58621;
var statearr_58622_58634 = state_58604;
(statearr_58622_58634[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58604[(4)]))){
var statearr_58623_58635 = state_58604;
(statearr_58623_58635[(1)] = cljs.core.first((state_58604[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58636 = state_58604;
state_58604 = G__58636;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = function(state_58604){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1.call(this,state_58604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58624 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58624[(6)] = c__2706__auto__);

return statearr_58624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58666){
var state_val_58667 = (state_58666[(1)]);
if((state_val_58667 === (7))){
var state_58666__$1 = state_58666;
var statearr_58668_58687 = state_58666__$1;
(statearr_58668_58687[(2)] = num);

(statearr_58668_58687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58667 === (1))){
var state_58666__$1 = state_58666;
var statearr_58669_58688 = state_58666__$1;
(statearr_58669_58688[(2)] = null);

(statearr_58669_58688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58667 === (4))){
var inst_58637 = (state_58666[(2)]);
var state_58666__$1 = state_58666;
var statearr_58670_58689 = state_58666__$1;
(statearr_58670_58689[(2)] = inst_58637);

(statearr_58670_58689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58667 === (6))){
var state_58666__$1 = state_58666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58666__$1,(9),num);
} else {
if((state_val_58667 === (3))){
var inst_58664 = (state_58666[(2)]);
var state_58666__$1 = state_58666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58666__$1,inst_58664);
} else {
if((state_val_58667 === (2))){
var _ = (function (){var statearr_58672 = state_58666;
(statearr_58672[(4)] = cljs.core.cons((5),(state_58666[(4)])));

return statearr_58672;
})();
var inst_58643 = fluree.db.util.async.channel_QMARK_(num);
var state_58666__$1 = state_58666;
if(inst_58643){
var statearr_58673_58690 = state_58666__$1;
(statearr_58673_58690[(1)] = (6));

} else {
var statearr_58674_58691 = state_58666__$1;
(statearr_58674_58691[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58667 === (9))){
var inst_58646 = (state_58666[(2)]);
var inst_58647 = fluree.db.util.async.throw_err(inst_58646);
var state_58666__$1 = state_58666;
var statearr_58675_58692 = state_58666__$1;
(statearr_58675_58692[(2)] = inst_58647);

(statearr_58675_58692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58667 === (5))){
var _ = (function (){var statearr_58676 = state_58666;
(statearr_58676[(4)] = cljs.core.rest((state_58666[(4)])));

return statearr_58676;
})();
var state_58666__$1 = state_58666;
var ex58671 = (state_58666__$1[(2)]);
var statearr_58677_58693 = state_58666__$1;
(statearr_58677_58693[(5)] = ex58671);


if((ex58671 instanceof Error)){
var statearr_58678_58694 = state_58666__$1;
(statearr_58678_58694[(1)] = (4));

(statearr_58678_58694[(5)] = null);

} else {
throw ex58671;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58667 === (8))){
var inst_58650 = (state_58666[(2)]);
var inst_58651 = fluree.db.dbfunctions.internal.floor(inst_58650);
var inst_58652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58653 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58655 = [fluree.db.dbfunctions.fns.floor];
var inst_58656 = (new cljs.core.PersistentVector(null,1,(5),inst_58654,inst_58655,null));
var inst_58657 = ["",inst_58656,inst_58651];
var inst_58658 = cljs.core.PersistentHashMap.fromArrays(inst_58653,inst_58657);
var inst_58659 = [inst_58658,(10)];
var inst_58660 = (new cljs.core.PersistentVector(null,2,(5),inst_58652,inst_58659,null));
var inst_58661 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58660);
var _ = (function (){var statearr_58679 = state_58666;
(statearr_58679[(4)] = cljs.core.rest((state_58666[(4)])));

return statearr_58679;
})();
var state_58666__$1 = (function (){var statearr_58680 = state_58666;
(statearr_58680[(7)] = inst_58661);

return statearr_58680;
})();
var statearr_58681_58695 = state_58666__$1;
(statearr_58681_58695[(2)] = inst_58651);

(statearr_58681_58695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0 = (function (){
var statearr_58682 = [null,null,null,null,null,null,null,null];
(statearr_58682[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__);

(statearr_58682[(1)] = (1));

return statearr_58682;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1 = (function (state_58666){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58666);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58683){var ex__2687__auto__ = e58683;
var statearr_58684_58696 = state_58666;
(statearr_58684_58696[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58666[(4)]))){
var statearr_58685_58697 = state_58666;
(statearr_58685_58697[(1)] = cljs.core.first((state_58666[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58698 = state_58666;
state_58666 = G__58698;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = function(state_58666){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1.call(this,state_58666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58686 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58686[(6)] = c__2706__auto__);

return statearr_58686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58723){
var state_val_58724 = (state_58723[(1)]);
if((state_val_58724 === (1))){
var state_58723__$1 = state_58723;
var statearr_58725_58740 = state_58723__$1;
(statearr_58725_58740[(2)] = null);

(statearr_58725_58740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58724 === (2))){
var _ = (function (){var statearr_58726 = state_58723;
(statearr_58726[(4)] = cljs.core.cons((5),(state_58723[(4)])));

return statearr_58726;
})();
var inst_58705 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_58723__$1 = state_58723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58723__$1,(6),inst_58705);
} else {
if((state_val_58724 === (3))){
var inst_58721 = (state_58723[(2)]);
var state_58723__$1 = state_58723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58723__$1,inst_58721);
} else {
if((state_val_58724 === (4))){
var inst_58699 = (state_58723[(2)]);
var state_58723__$1 = state_58723;
var statearr_58728_58741 = state_58723__$1;
(statearr_58728_58741[(2)] = inst_58699);

(statearr_58728_58741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58724 === (5))){
var _ = (function (){var statearr_58729 = state_58723;
(statearr_58729[(4)] = cljs.core.rest((state_58723[(4)])));

return statearr_58729;
})();
var state_58723__$1 = state_58723;
var ex58727 = (state_58723__$1[(2)]);
var statearr_58730_58742 = state_58723__$1;
(statearr_58730_58742[(5)] = ex58727);


if((ex58727 instanceof Error)){
var statearr_58731_58743 = state_58723__$1;
(statearr_58731_58743[(1)] = (4));

(statearr_58731_58743[(5)] = null);

} else {
throw ex58727;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58724 === (6))){
var inst_58707 = (state_58723[(2)]);
var inst_58708 = fluree.db.util.async.throw_err(inst_58707);
var inst_58709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58710 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58712 = [compare_val,new_val];
var inst_58713 = (new cljs.core.PersistentVector(null,2,(5),inst_58711,inst_58712,null));
var inst_58714 = ["",inst_58713,inst_58708];
var inst_58715 = cljs.core.PersistentHashMap.fromArrays(inst_58710,inst_58714);
var inst_58716 = [inst_58715,(10)];
var inst_58717 = (new cljs.core.PersistentVector(null,2,(5),inst_58709,inst_58716,null));
var inst_58718 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58717);
var _ = (function (){var statearr_58732 = state_58723;
(statearr_58732[(4)] = cljs.core.rest((state_58723[(4)])));

return statearr_58732;
})();
var state_58723__$1 = (function (){var statearr_58733 = state_58723;
(statearr_58733[(7)] = inst_58718);

return statearr_58733;
})();
var statearr_58734_58744 = state_58723__$1;
(statearr_58734_58744[(2)] = inst_58708);

(statearr_58734_58744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_58735 = [null,null,null,null,null,null,null,null];
(statearr_58735[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__);

(statearr_58735[(1)] = (1));

return statearr_58735;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1 = (function (state_58723){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58723);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58736){var ex__2687__auto__ = e58736;
var statearr_58737_58745 = state_58723;
(statearr_58737_58745[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58723[(4)]))){
var statearr_58738_58746 = state_58723;
(statearr_58738_58746[(1)] = cljs.core.first((state_58723[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58747 = state_58723;
state_58723 = G__58747;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = function(state_58723){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1.call(this,state_58723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58739 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58739[(6)] = c__2706__auto__);

return statearr_58739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
