// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.load');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
sci.impl.load.handle_refer_all = (function sci$impl$load$handle_refer_all(the_current_ns,the_loaded_ns,include_sym_QMARK_,rename_sym,only){
var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns);
var only__$1 = (cljs.core.truth_(only)?cljs.core.set.call(null,only):null);
var referred__$1 = cljs.core.reduce.call(null,(function (ns,p__32212){
var vec__32213 = p__32212;
var k = cljs.core.nth.call(null,vec__32213,(0),null);
var v = cljs.core.nth.call(null,vec__32213,(1),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = (k instanceof cljs.core.Symbol);
if(and__5043__auto__){
var and__5043__auto____$1 = include_sym_QMARK_.call(null,k);
if(cljs.core.truth_(and__5043__auto____$1)){
return ((cljs.core.not.call(null,only__$1)) || (cljs.core.contains_QMARK_.call(null,only__$1,k)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.assoc.call(null,ns,rename_sym.call(null,k),v);
} else {
return ns;
}
}),referred,the_loaded_ns);
return cljs.core.assoc.call(null,the_current_ns,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
});
sci.impl.load.handle_require_libspec_env = (function sci$impl$load$handle_require_libspec_env(_ctx,env,current_ns,the_loaded_ns,lib_name,p__32216){
var map__32217 = p__32216;
var map__32217__$1 = cljs.core.__destructure_map.call(null,map__32217);
var _parsed_libspec = map__32217__$1;
var as = cljs.core.get.call(null,map__32217__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var refer = cljs.core.get.call(null,map__32217__$1,new cljs.core.Keyword(null,"refer","refer",-964295553));
var rename = cljs.core.get.call(null,map__32217__$1,new cljs.core.Keyword(null,"rename","rename",1508157613));
var exclude = cljs.core.get.call(null,map__32217__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
var only = cljs.core.get.call(null,map__32217__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var use = cljs.core.get.call(null,map__32217__$1,new cljs.core.Keyword(null,"use","use",-1846382424));
var the_current_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null));
var the_current_ns__$1 = (cljs.core.truth_(as)?cljs.core.assoc_in.call(null,the_current_ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aliases","aliases",1346874714),as], null),lib_name):the_current_ns);
var rename_sym = (cljs.core.truth_(rename)?(function (sym){
var or__5045__auto__ = rename.call(null,sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return sym;
}
}):cljs.core.identity);
var include_sym_QMARK_ = (cljs.core.truth_(exclude)?(function (){var excludes = cljs.core.set.call(null,exclude);
return (function (sym){
return (!(cljs.core.contains_QMARK_.call(null,excludes,sym)));
});
})():cljs.core.constantly.call(null,true));
var the_current_ns__$2 = (cljs.core.truth_(refer)?(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,"all","all",892129742),refer);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return use;
}
})())?sci.impl.load.handle_refer_all.call(null,the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,null):((cljs.core.sequential_QMARK_.call(null,refer))?(function (){var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns__$1);
var referred__$1 = cljs.core.reduce.call(null,(function (ns,sym){
if(cljs.core.truth_(include_sym_QMARK_.call(null,sym))){
return cljs.core.assoc.call(null,ns,rename_sym.call(null,sym),(function (){var temp__5802__auto__ = cljs.core.find.call(null,the_loaded_ns,sym);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__32218 = temp__5802__auto__;
var _k = cljs.core.nth.call(null,vec__32218,(0),null);
var v = cljs.core.nth.call(null,vec__32218,(1),null);
return v;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')));
}
})());
} else {
return ns;
}
}),referred,refer);
return cljs.core.assoc.call(null,the_current_ns__$1,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
})():(function(){throw (new Error(":refer value must be a sequential collection of symbols"))})()
)):(cljs.core.truth_(use)?sci.impl.load.handle_refer_all.call(null,the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,only):the_current_ns__$1
));
var env__$1 = cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null),the_current_ns__$2);
var temp__5804__auto___32222 = (function (){var G__32221 = the_loaded_ns;
var G__32221__$1 = (((G__32221 == null))?null:new cljs.core.Keyword(null,"obj","obj",981763962).cljs$core$IFn$_invoke$arity$1(G__32221));
var G__32221__$2 = (((G__32221__$1 == null))?null:cljs.core.meta.call(null,G__32221__$1));
if((G__32221__$2 == null)){
return null;
} else {
return new cljs.core.Keyword("sci.impl","required-fn","sci.impl/required-fn",2082701278).cljs$core$IFn$_invoke$arity$1(G__32221__$2);
}
})();
if(cljs.core.truth_(temp__5804__auto___32222)){
var on_loaded_32223 = temp__5804__auto___32222;
on_loaded_32223.call(null,cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return env__$1;
});
sci.impl.load.add_loaded_lib = (function sci$impl$load$add_loaded_lib(env,lib){
cljs.core.swap_BANG_.call(null,env,cljs.core.update,new cljs.core.Keyword(null,"loaded-libs","loaded-libs",-1156389652),(function (loaded_libs){
if((loaded_libs == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([lib]);
} else {
return cljs.core.conj.call(null,loaded_libs,lib);
}
}));

return null;
});
sci.impl.load.handle_require_libspec = (function sci$impl$load$handle_require_libspec(ctx,lib,opts){
var env_STAR_ = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
var env = cljs.core.deref.call(null,env_STAR_);
var cnn = sci.impl.utils.current_ns_name.call(null);
var lib__$1 = cljs.core.get.call(null,new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821).cljs$core$IFn$_invoke$arity$1(env),lib,lib);
var temp__5802__auto__ = new cljs.core.Keyword(null,"as-alias","as-alias",82482467).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var as_alias = temp__5802__auto__;
return cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,null,lib__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),as_alias], null)));
} else {
var map__32224 = opts;
var map__32224__$1 = cljs.core.__destructure_map.call(null,map__32224);
var reload = cljs.core.get.call(null,map__32224__$1,new cljs.core.Keyword(null,"reload","reload",863702807));
var reload_all = cljs.core.get.call(null,map__32224__$1,new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
var namespaces = cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var reload_STAR_ = (function (){var or__5045__auto__ = reload;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = reload_all;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(ctx);
}
}
})();
var temp__5802__auto___32227__$1 = (cljs.core.truth_(reload_STAR_)?null:cljs.core.get.call(null,namespaces,lib__$1));
if(cljs.core.truth_(temp__5802__auto___32227__$1)){
var the_loaded_ns_32228 = temp__5802__auto___32227__$1;
var loading_32229 = new cljs.core.Keyword(null,"loading","loading",-737050189).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_((function (){var and__5043__auto__ = loading_32229;
if(cljs.core.truth_(and__5043__auto__)){
return (((!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"loaded-libs","loaded-libs",-1156389652).cljs$core$IFn$_invoke$arity$1(env),lib__$1)))) && (cljs.core.nat_int_QMARK_.call(null,loading_32229.indexOf(lib__$1))));
} else {
return and__5043__auto__;
}
})())){
sci.impl.utils.throw_error_with_location.call(null,(function (){var lib_emphasized = ["[ ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib__$1)," ]"].join('');
var loading__$1 = cljs.core.conj.call(null,loading_32229,lib__$1);
var loading__$2 = cljs.core.replace.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([lib__$1,lib_emphasized]),loading__$1);
return ["Cyclic load dependency: ",clojure.string.join.call(null,"->",loading__$2)].join('');
})(),lib__$1);
} else {
cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,the_loaded_ns_32228,lib__$1,opts));
}
} else {
var temp__5802__auto___32230__$2 = new cljs.core.Keyword(null,"load-fn","load-fn",-2121144334).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_(temp__5802__auto___32230__$2)){
var load_fn_32231 = temp__5802__auto___32230__$2;
var curr_ns_32232 = cljs.core.deref.call(null,sci.impl.utils.current_ns);
var temp__5802__auto___32233__$3 = load_fn_32231.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),lib__$1,new cljs.core.Keyword(null,"libname","libname",135992497),lib__$1,new cljs.core.Keyword(null,"ctx","ctx",-493610118),ctx,new cljs.core.Keyword(null,"opts","opts",155075701),opts,new cljs.core.Keyword(null,"ns","ns",441598760),sci.impl.types.getName.call(null,curr_ns_32232),new cljs.core.Keyword(null,"reload","reload",863702807),(function (){var or__5045__auto__ = reload;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return reload_all;
}
})()], null));
if(cljs.core.truth_(temp__5802__auto___32233__$3)){
var map__32225_32234 = temp__5802__auto___32233__$3;
var map__32225_32235__$1 = cljs.core.__destructure_map.call(null,map__32225_32234);
var file_32236 = cljs.core.get.call(null,map__32225_32235__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var source_32237 = cljs.core.get.call(null,map__32225_32235__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var handled_32238 = cljs.core.get.call(null,map__32225_32235__$1,new cljs.core.Keyword(null,"handled","handled",1889700151));
var ctx_32239__$1 = cljs.core.update.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"reload-all","reload-all",761570200),reload_all),new cljs.core.Keyword(null,"loading","loading",-737050189),(function (loading){
if((loading == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib__$1], null);
} else {
return cljs.core.conj.call(null,loading,lib__$1);
}
}));
if(cljs.core.truth_(source_32237)){
try{sci.impl.vars.push_thread_bindings.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.utils.current_ns,curr_ns_32232,sci.impl.utils.current_file,file_32236]));

try{cljs.core.deref.call(null,sci.impl.utils.eval_string_STAR_).call(null,ctx_32239__$1,source_32237);
}finally {sci.impl.vars.pop_thread_bindings.call(null);
}}catch (e32226){if((e32226 instanceof Error)){
var e_32240 = e32226;
cljs.core.swap_BANG_.call(null,env_STAR_,cljs.core.update,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.dissoc,lib__$1);

throw e_32240;
} else {
throw e32226;

}
}} else {
}

if(cljs.core.truth_(handled_32238)){
} else {
cljs.core.swap_BANG_.call(null,env_STAR_,(function (env__$1){
var namespaces__$1 = cljs.core.get.call(null,env__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var the_loaded_ns = cljs.core.get.call(null,namespaces__$1,lib__$1);
return sci.impl.load.handle_require_libspec_env.call(null,ctx,env__$1,cnn,the_loaded_ns,lib__$1,opts);
}));
}
} else {
var or__5045__auto___32241 = (cljs.core.truth_(reload_STAR_)?(function (){var temp__5804__auto__ = cljs.core.get.call(null,namespaces,lib__$1);
if(cljs.core.truth_(temp__5804__auto__)){
var the_loaded_ns = temp__5804__auto__;
return cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,the_loaded_ns,lib__$1,opts));
} else {
return null;
}
})():null);
if(cljs.core.truth_(or__5045__auto___32241)){
} else {
throw (new Error(["Could not find namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib__$1),"."].join('')));
}
}
} else {
throw (new Error(["Could not find namespace ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib__$1),"."].join('')));
}
}

sci.impl.load.add_loaded_lib.call(null,env_STAR_,lib__$1);

return null;
}
});
sci.impl.load.load_lib = (function sci$impl$load$load_lib(var_args){
var args__5775__auto__ = [];
var len__5769__auto___32246 = arguments.length;
var i__5770__auto___32247 = (0);
while(true){
if((i__5770__auto___32247 < len__5769__auto___32246)){
args__5775__auto__.push((arguments[i__5770__auto___32247]));

var G__32248 = (i__5770__auto___32247 + (1));
i__5770__auto___32247 = G__32248;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return sci.impl.load.load_lib.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(sci.impl.load.load_lib.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,prefix,lib,options){
if(cljs.core.truth_((function (){var and__5043__auto__ = prefix;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.name.call(null,lib).indexOf(".") > (0));
} else {
return and__5043__auto__;
}
})())){
sci.impl.utils.throw_error_with_location.call(null,["Found lib name '",cljs.core.name.call(null,lib),"' containing period with prefix '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),"'.  lib names inside prefix lists must not contain periods"].join(''),lib);
} else {
}

var lib__$1 = (cljs.core.truth_(prefix)?cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib)].join('')):lib);
var opts = cljs.core.apply.call(null,cljs.core.hash_map,options);
return sci.impl.load.handle_require_libspec.call(null,ctx,lib__$1,opts);
}));

(sci.impl.load.load_lib.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(sci.impl.load.load_lib.cljs$lang$applyTo = (function (seq32242){
var G__32243 = cljs.core.first.call(null,seq32242);
var seq32242__$1 = cljs.core.next.call(null,seq32242);
var G__32244 = cljs.core.first.call(null,seq32242__$1);
var seq32242__$2 = cljs.core.next.call(null,seq32242__$1);
var G__32245 = cljs.core.first.call(null,seq32242__$2);
var seq32242__$3 = cljs.core.next.call(null,seq32242__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32243,G__32244,G__32245,seq32242__$3);
}));

/**
 * Prepends a symbol or a seq to coll
 */
sci.impl.load.prependss = (function sci$impl$load$prependss(x,coll){
if((x instanceof cljs.core.Symbol)){
return cljs.core.cons.call(null,x,coll);
} else {
return cljs.core.concat.call(null,x,coll);
}
});
/**
 * Returns true if x is a libspec
 */
sci.impl.load.libspec_QMARK_ = (function sci$impl$load$libspec_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) || (((cljs.core.vector_QMARK_.call(null,x)) && ((((cljs.core.second.call(null,x) == null)) || ((cljs.core.second.call(null,x) instanceof cljs.core.Keyword)))))));
});
/**
 * Loads libs, evaling libspecs, prefix lists, and flags for
 *   forwarding to load-lib
 */
sci.impl.load.load_libs = (function sci$impl$load$load_libs(ctx,kw,args){
var args_STAR_ = cljs.core.cons.call(null,kw,args);
var flags = cljs.core.filter.call(null,cljs.core.keyword_QMARK_,args_STAR_);
var opts = cljs.core.interleave.call(null,flags,cljs.core.repeat.call(null,true));
var args_STAR___$1 = cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.keyword_QMARK_),args_STAR_);
var supported_32281 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"use","use",-1846382424),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"require","require",-468001333),null,new cljs.core.Keyword(null,"verbose","verbose",1694226060),null,new cljs.core.Keyword(null,"reload","reload",863702807),null,new cljs.core.Keyword(null,"reload-all","reload-all",761570200),null,new cljs.core.Keyword(null,"refer","refer",-964295553),null], null), null);
var unsupported_32282 = cljs.core.seq.call(null,cljs.core.remove.call(null,supported_32281,flags));
if(unsupported_32282){
sci.impl.utils.throw_error_with_location.call(null,cljs.core.apply.call(null,cljs.core.str,"Unsupported option(s) supplied: ",cljs.core.interpose.call(null,",",unsupported_32282)),args);
} else {
}

if(cljs.core.seq.call(null,args_STAR___$1)){
} else {
sci.impl.utils.throw_error_with_location.call(null,"Nothing specified to load",args);
}

var seq__32249 = cljs.core.seq.call(null,args_STAR___$1);
var chunk__32250 = null;
var count__32251 = (0);
var i__32252 = (0);
while(true){
if((i__32252 < count__32251)){
var arg = cljs.core._nth.call(null,chunk__32250,i__32252);
if(sci.impl.load.libspec_QMARK_.call(null,arg)){
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,null,sci.impl.load.prependss.call(null,arg,opts));
} else {
var vec__32267_32283 = arg;
var seq__32268_32284 = cljs.core.seq.call(null,vec__32267_32283);
var first__32269_32285 = cljs.core.first.call(null,seq__32268_32284);
var seq__32268_32286__$1 = cljs.core.next.call(null,seq__32268_32284);
var prefix_32287 = first__32269_32285;
var args_STAR__32288__$2 = seq__32268_32286__$1;
if((prefix_32287 == null)){
sci.impl.utils.throw_error_with_location.call(null,"prefix cannot be nil",args);
} else {
}

var seq__32270_32289 = cljs.core.seq.call(null,args_STAR__32288__$2);
var chunk__32271_32290 = null;
var count__32272_32291 = (0);
var i__32273_32292 = (0);
while(true){
if((i__32273_32292 < count__32272_32291)){
var arg_32293__$1 = cljs.core._nth.call(null,chunk__32271_32290,i__32273_32292);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_32287,sci.impl.load.prependss.call(null,arg_32293__$1,opts));


var G__32294 = seq__32270_32289;
var G__32295 = chunk__32271_32290;
var G__32296 = count__32272_32291;
var G__32297 = (i__32273_32292 + (1));
seq__32270_32289 = G__32294;
chunk__32271_32290 = G__32295;
count__32272_32291 = G__32296;
i__32273_32292 = G__32297;
continue;
} else {
var temp__5804__auto___32298 = cljs.core.seq.call(null,seq__32270_32289);
if(temp__5804__auto___32298){
var seq__32270_32299__$1 = temp__5804__auto___32298;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32270_32299__$1)){
var c__5568__auto___32300 = cljs.core.chunk_first.call(null,seq__32270_32299__$1);
var G__32301 = cljs.core.chunk_rest.call(null,seq__32270_32299__$1);
var G__32302 = c__5568__auto___32300;
var G__32303 = cljs.core.count.call(null,c__5568__auto___32300);
var G__32304 = (0);
seq__32270_32289 = G__32301;
chunk__32271_32290 = G__32302;
count__32272_32291 = G__32303;
i__32273_32292 = G__32304;
continue;
} else {
var arg_32305__$1 = cljs.core.first.call(null,seq__32270_32299__$1);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_32287,sci.impl.load.prependss.call(null,arg_32305__$1,opts));


var G__32306 = cljs.core.next.call(null,seq__32270_32299__$1);
var G__32307 = null;
var G__32308 = (0);
var G__32309 = (0);
seq__32270_32289 = G__32306;
chunk__32271_32290 = G__32307;
count__32272_32291 = G__32308;
i__32273_32292 = G__32309;
continue;
}
} else {
}
}
break;
}
}


var G__32310 = seq__32249;
var G__32311 = chunk__32250;
var G__32312 = count__32251;
var G__32313 = (i__32252 + (1));
seq__32249 = G__32310;
chunk__32250 = G__32311;
count__32251 = G__32312;
i__32252 = G__32313;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__32249);
if(temp__5804__auto__){
var seq__32249__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32249__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__32249__$1);
var G__32314 = cljs.core.chunk_rest.call(null,seq__32249__$1);
var G__32315 = c__5568__auto__;
var G__32316 = cljs.core.count.call(null,c__5568__auto__);
var G__32317 = (0);
seq__32249 = G__32314;
chunk__32250 = G__32315;
count__32251 = G__32316;
i__32252 = G__32317;
continue;
} else {
var arg = cljs.core.first.call(null,seq__32249__$1);
if(sci.impl.load.libspec_QMARK_.call(null,arg)){
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,null,sci.impl.load.prependss.call(null,arg,opts));
} else {
var vec__32274_32318 = arg;
var seq__32275_32319 = cljs.core.seq.call(null,vec__32274_32318);
var first__32276_32320 = cljs.core.first.call(null,seq__32275_32319);
var seq__32275_32321__$1 = cljs.core.next.call(null,seq__32275_32319);
var prefix_32322 = first__32276_32320;
var args_STAR__32323__$2 = seq__32275_32321__$1;
if((prefix_32322 == null)){
sci.impl.utils.throw_error_with_location.call(null,"prefix cannot be nil",args);
} else {
}

var seq__32277_32324 = cljs.core.seq.call(null,args_STAR__32323__$2);
var chunk__32278_32325 = null;
var count__32279_32326 = (0);
var i__32280_32327 = (0);
while(true){
if((i__32280_32327 < count__32279_32326)){
var arg_32328__$1 = cljs.core._nth.call(null,chunk__32278_32325,i__32280_32327);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_32322,sci.impl.load.prependss.call(null,arg_32328__$1,opts));


var G__32329 = seq__32277_32324;
var G__32330 = chunk__32278_32325;
var G__32331 = count__32279_32326;
var G__32332 = (i__32280_32327 + (1));
seq__32277_32324 = G__32329;
chunk__32278_32325 = G__32330;
count__32279_32326 = G__32331;
i__32280_32327 = G__32332;
continue;
} else {
var temp__5804__auto___32333__$1 = cljs.core.seq.call(null,seq__32277_32324);
if(temp__5804__auto___32333__$1){
var seq__32277_32334__$1 = temp__5804__auto___32333__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32277_32334__$1)){
var c__5568__auto___32335 = cljs.core.chunk_first.call(null,seq__32277_32334__$1);
var G__32336 = cljs.core.chunk_rest.call(null,seq__32277_32334__$1);
var G__32337 = c__5568__auto___32335;
var G__32338 = cljs.core.count.call(null,c__5568__auto___32335);
var G__32339 = (0);
seq__32277_32324 = G__32336;
chunk__32278_32325 = G__32337;
count__32279_32326 = G__32338;
i__32280_32327 = G__32339;
continue;
} else {
var arg_32340__$1 = cljs.core.first.call(null,seq__32277_32334__$1);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_32322,sci.impl.load.prependss.call(null,arg_32340__$1,opts));


var G__32341 = cljs.core.next.call(null,seq__32277_32334__$1);
var G__32342 = null;
var G__32343 = (0);
var G__32344 = (0);
seq__32277_32324 = G__32341;
chunk__32278_32325 = G__32342;
count__32279_32326 = G__32343;
i__32280_32327 = G__32344;
continue;
}
} else {
}
}
break;
}
}


var G__32345 = cljs.core.next.call(null,seq__32249__$1);
var G__32346 = null;
var G__32347 = (0);
var G__32348 = (0);
seq__32249 = G__32345;
chunk__32250 = G__32346;
count__32251 = G__32347;
i__32252 = G__32348;
continue;
}
} else {
return null;
}
}
break;
}
});
sci.impl.load.eval_require = (function sci$impl$load$eval_require(var_args){
var args__5775__auto__ = [];
var len__5769__auto___32351 = arguments.length;
var i__5770__auto___32352 = (0);
while(true){
if((i__5770__auto___32352 < len__5769__auto___32351)){
args__5775__auto__.push((arguments[i__5770__auto___32352]));

var G__32353 = (i__5770__auto___32352 + (1));
i__5770__auto___32352 = G__32353;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.load.eval_require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.load.eval_require.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return sci.impl.load.load_libs.call(null,ctx,new cljs.core.Keyword(null,"require","require",-468001333),args);
}));

(sci.impl.load.eval_require.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.load.eval_require.cljs$lang$applyTo = (function (seq32349){
var G__32350 = cljs.core.first.call(null,seq32349);
var seq32349__$1 = cljs.core.next.call(null,seq32349);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32350,seq32349__$1);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_require_state,sci.impl.load.eval_require);
sci.impl.load.eval_use = (function sci$impl$load$eval_use(var_args){
var args__5775__auto__ = [];
var len__5769__auto___32356 = arguments.length;
var i__5770__auto___32357 = (0);
while(true){
if((i__5770__auto___32357 < len__5769__auto___32356)){
args__5775__auto__.push((arguments[i__5770__auto___32357]));

var G__32358 = (i__5770__auto___32357 + (1));
i__5770__auto___32357 = G__32358;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.load.eval_use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.load.eval_use.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return sci.impl.load.load_libs.call(null,ctx,new cljs.core.Keyword(null,"use","use",-1846382424),args);
}));

(sci.impl.load.eval_use.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.load.eval_use.cljs$lang$applyTo = (function (seq32354){
var G__32355 = cljs.core.first.call(null,seq32354);
var seq32354__$1 = cljs.core.next.call(null,seq32354);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32355,seq32354__$1);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_use_state,sci.impl.load.eval_use);
sci.impl.load.eval_refer_clojure = (function sci$impl$load$eval_refer_clojure(ctx,exprs){
var ns_sym = new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null);
var exprs__$1 = exprs;
while(true){
if(cljs.core.truth_(exprs__$1)){
var vec__32359 = exprs__$1;
var k = cljs.core.nth.call(null,vec__32359,(0),null);
var v = cljs.core.nth.call(null,vec__32359,(1),null);
var G__32362_32367 = k;
var G__32362_32368__$1 = (((G__32362_32367 instanceof cljs.core.Keyword))?G__32362_32367.fqn:null);
switch (G__32362_32368__$1) {
case "exclude":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__32362_32367,G__32362_32368__$1,vec__32359,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.utils.current_ns_name.call(null);
return cljs.core.update_in.call(null,env,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),v);
});})(exprs__$1,G__32362_32367,G__32362_32368__$1,vec__32359,k,v,ns_sym))
);

break;
case "only":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__32362_32367,G__32362_32368__$1,vec__32359,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.utils.current_ns_name.call(null);
var other_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),ns_sym], null));
var other_vars = cljs.core.select_keys.call(null,other_ns,v);
return cljs.core.update_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),cljs.core.merge,other_vars);
});})(exprs__$1,G__32362_32367,G__32362_32368__$1,vec__32359,k,v,ns_sym))
);

break;
case "rename":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__32362_32367,G__32362_32368__$1,vec__32359,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.utils.current_ns_name.call(null);
var namespaces = new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469).cljs$core$IFn$_invoke$arity$1(env);
var the_current_ns = cljs.core.get.call(null,namespaces,cnn);
var other_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),ns_sym], null));
var the_current_ns__$1 = cljs.core.reduce.call(null,((function (exprs__$1,cnn,namespaces,the_current_ns,other_ns,G__32362_32367,G__32362_32368__$1,vec__32359,k,v,ns_sym){
return (function (acc,p__32363){
var vec__32364 = p__32363;
var original_name = cljs.core.nth.call(null,vec__32364,(0),null);
var new_name = cljs.core.nth.call(null,vec__32364,(1),null);
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"refers","refers",158076809),new_name], null),cljs.core.get.call(null,other_ns,original_name)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),original_name);
});})(exprs__$1,cnn,namespaces,the_current_ns,other_ns,G__32362_32367,G__32362_32368__$1,vec__32359,k,v,ns_sym))
,the_current_ns,v);
return cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});})(exprs__$1,G__32362_32367,G__32362_32368__$1,vec__32359,k,v,ns_sym))
);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32362_32368__$1)].join('')));

}

var G__32370 = cljs.core.nnext.call(null,exprs__$1);
exprs__$1 = G__32370;
continue;
} else {
return null;
}
break;
}
});
sci.impl.load.eval_refer_STAR_ = (function sci$impl$load$eval_refer_STAR_(env,ns_sym,filters){

var cnn = sci.impl.utils.current_ns_name.call(null);
var namespaces = new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469).cljs$core$IFn$_invoke$arity$1(env);
var ns = (function (){var or__5045__auto__ = cljs.core.get.call(null,namespaces,ns_sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw (new Error(["No namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_sym)].join('')));
}
})();
var fs = cljs.core.apply.call(null,cljs.core.hash_map,filters);
var public_keys = cljs.core.filter.call(null,cljs.core.symbol_QMARK_,cljs.core.keys.call(null,ns));
var rename = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"rename","rename",1508157613).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var exclude = cljs.core.set.call(null,new cljs.core.Keyword(null,"exclude","exclude",-1230250334).cljs$core$IFn$_invoke$arity$1(fs));
var to_do = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"refer","refer",-964295553).cljs$core$IFn$_invoke$arity$1(fs)))?public_keys:(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"refer","refer",-964295553).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"only","only",1907811652).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return public_keys;
}
}
})());
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = to_do;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.sequential_QMARK_.call(null,to_do)));
} else {
return and__5043__auto__;
}
})())?(function(){throw (new Error(":only/:refer value must be a sequential collection of symbols"))})():null);
var the_current_ns = cljs.core.get.call(null,namespaces,cnn);
var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns);
var referred__$1 = cljs.core.reduce.call(null,(function (referred__$1,sym){
if(cljs.core.not.call(null,exclude.call(null,sym))){
var v = cljs.core.get.call(null,ns,sym);
if(cljs.core.truth_(v)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')
));
}

return cljs.core.assoc.call(null,referred__$1,(function (){var or__5045__auto__ = rename.call(null,sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return sym;
}
})(),v);
} else {
return referred__$1;
}
}),referred,to_do);
var the_current_ns__$1 = cljs.core.assoc.call(null,the_current_ns,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
var namespaces__$1 = cljs.core.assoc.call(null,namespaces,cnn,the_current_ns__$1);
var env__$1 = cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),namespaces__$1);
return env__$1;
});
/**
 * The function equivalent of :refer is handled differently than what we
 *   did before (this is more like what Clojure itself does.) For
 *   referring clojure.core we still use the old code.
 */
sci.impl.load.eval_refer = (function sci$impl$load$eval_refer(var_args){
var args__5775__auto__ = [];
var len__5769__auto___32374 = arguments.length;
var i__5770__auto___32375 = (0);
while(true){
if((i__5770__auto___32375 < len__5769__auto___32374)){
args__5775__auto__.push((arguments[i__5770__auto___32375]));

var G__32376 = (i__5770__auto___32375 + (1));
i__5770__auto___32375 = G__32376;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return sci.impl.load.eval_refer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(sci.impl.load.eval_refer.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,ns_sym,filters){
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null),ns_sym)){
sci.impl.load.eval_refer_clojure.call(null,ctx,filters);
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),sci.impl.load.eval_refer_STAR_,ns_sym,filters);
}

return null;
}));

(sci.impl.load.eval_refer.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(sci.impl.load.eval_refer.cljs$lang$applyTo = (function (seq32371){
var G__32372 = cljs.core.first.call(null,seq32371);
var seq32371__$1 = cljs.core.next.call(null,seq32371);
var G__32373 = cljs.core.first.call(null,seq32371__$1);
var seq32371__$2 = cljs.core.next.call(null,seq32371__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32372,G__32373,seq32371__$2);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_refer_state,sci.impl.load.eval_refer);
