// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__22636 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__22636,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__22636;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__22637 = opts;
var map__22637__$1 = cljs.core.__destructure_map.call(null,map__22637);
var request_timeout = cljs.core.get.call(null,map__22637__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__22637__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__22637__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__22638 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__22638__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__22638,headers):G__22638);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__22638__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__22638__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__22639 = opts;
var map__22639__$1 = cljs.core.__destructure_map.call(null,map__22639);
var request_timeout = cljs.core.get.call(null,map__22639__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__22639__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__22639__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__22639__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__22639__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__22640 = cljs.core.PersistentArrayMap.EMPTY;
var G__22640__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__22640,headers):G__22640);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__22640__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__22640__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__22641 = output_format;
var G__22641__$1 = (((G__22641 instanceof cljs.core.Keyword))?G__22641.fqn:null);
switch (G__22641__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__22643 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__22643,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__22643;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22675){
var state_val_22676 = (state_22675[(1)]);
if((state_val_22676 === (7))){
var inst_22671 = (state_22675[(2)]);
var state_22675__$1 = state_22675;
var statearr_22677_22702 = state_22675__$1;
(statearr_22677_22702[(2)] = inst_22671);

(statearr_22677_22702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22676 === (1))){
var state_22675__$1 = state_22675;
var statearr_22678_22703 = state_22675__$1;
(statearr_22678_22703[(2)] = null);

(statearr_22678_22703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22676 === (4))){
var inst_22646 = (state_22675[(7)]);
var inst_22646__$1 = (state_22675[(2)]);
var inst_22647 = (inst_22646__$1 == null);
var state_22675__$1 = (function (){var statearr_22679 = state_22675;
(statearr_22679[(7)] = inst_22646__$1);

return statearr_22679;
})();
if(cljs.core.truth_(inst_22647)){
var statearr_22680_22704 = state_22675__$1;
(statearr_22680_22704[(1)] = (5));

} else {
var statearr_22681_22705 = state_22675__$1;
(statearr_22681_22705[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22676 === (6))){
var inst_22646 = (state_22675[(7)]);
var inst_22654 = cljs.core.nth.call(null,inst_22646,(0),null);
var inst_22655 = cljs.core.nth.call(null,inst_22646,(1),null);
var state_22675__$1 = (function (){var statearr_22682 = state_22675;
(statearr_22682[(8)] = inst_22655);

(statearr_22682[(9)] = inst_22654);

return statearr_22682;
})();
var statearr_22683_22706 = state_22675__$1;
(statearr_22683_22706[(2)] = null);

(statearr_22683_22706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22676 === (3))){
var inst_22673 = (state_22675[(2)]);
var state_22675__$1 = state_22675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22675__$1,inst_22673);
} else {
if((state_val_22676 === (2))){
var state_22675__$1 = state_22675;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22675__$1,(4),pub_chan);
} else {
if((state_val_22676 === (11))){
var _ = (function (){var statearr_22685 = state_22675;
(statearr_22685[(4)] = cljs.core.rest.call(null,(state_22675[(4)])));

return statearr_22685;
})();
var state_22675__$1 = state_22675;
var ex22684 = (state_22675__$1[(2)]);
var statearr_22686_22707 = state_22675__$1;
(statearr_22686_22707[(5)] = ex22684);


var statearr_22687_22708 = state_22675__$1;
(statearr_22687_22708[(1)] = (10));

(statearr_22687_22708[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22676 === (9))){
var inst_22668 = (state_22675[(2)]);
var state_22675__$1 = (function (){var statearr_22688 = state_22675;
(statearr_22688[(10)] = inst_22668);

return statearr_22688;
})();
var statearr_22689_22709 = state_22675__$1;
(statearr_22689_22709[(2)] = null);

(statearr_22689_22709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22676 === (5))){
var inst_22649 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_22675__$1 = state_22675;
var statearr_22690_22710 = state_22675__$1;
(statearr_22690_22710[(2)] = inst_22649);

(statearr_22690_22710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22676 === (10))){
var inst_22655 = (state_22675[(8)]);
var inst_22654 = (state_22675[(9)]);
var inst_22656 = (state_22675[(2)]);
var inst_22657 = fluree.db.util.log.error.call(null,inst_22656,"Error sending websocket message:",inst_22654);
var inst_22658 = cljs.core.async.put_BANG_.call(null,inst_22655,false);
var state_22675__$1 = (function (){var statearr_22691 = state_22675;
(statearr_22691[(11)] = inst_22657);

return statearr_22691;
})();
var statearr_22692_22711 = state_22675__$1;
(statearr_22692_22711[(2)] = inst_22658);

(statearr_22692_22711[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22676 === (8))){
var inst_22655 = (state_22675[(8)]);
var inst_22654 = (state_22675[(9)]);
var _ = (function (){var statearr_22693 = state_22675;
(statearr_22693[(4)] = cljs.core.cons.call(null,(11),(state_22675[(4)])));

return statearr_22693;
})();
var inst_22664 = ws.send(inst_22654);
var inst_22665 = cljs.core.async.put_BANG_.call(null,inst_22655,true);
var ___$1 = (function (){var statearr_22694 = state_22675;
(statearr_22694[(4)] = cljs.core.rest.call(null,(state_22675[(4)])));

return statearr_22694;
})();
var state_22675__$1 = (function (){var statearr_22695 = state_22675;
(statearr_22695[(12)] = inst_22664);

return statearr_22695;
})();
var statearr_22696_22712 = state_22675__$1;
(statearr_22696_22712[(2)] = inst_22665);

(statearr_22696_22712[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0 = (function (){
var statearr_22697 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22697[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__);

(statearr_22697[(1)] = (1));

return statearr_22697;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1 = (function (state_22675){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_22675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22698){var ex__2687__auto__ = e22698;
var statearr_22699_22713 = state_22675;
(statearr_22699_22713[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_22675[(4)]))){
var statearr_22700_22714 = state_22675;
(statearr_22700_22714[(1)] = cljs.core.first.call(null,(state_22675[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22715 = state_22675;
state_22675 = G__22715;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__ = function(state_22675){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1.call(this,state_22675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22701 = f__2707__auto__.call(null);
(statearr_22701[(6)] = c__2706__auto__);

return statearr_22701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2706__auto___22753 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22740){
var state_val_22741 = (state_22740[(1)]);
if((state_val_22741 === (1))){
var inst_22719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22720 = [open_QMARK_,timeout_chan];
var inst_22721 = (new cljs.core.PersistentVector(null,2,(5),inst_22719,inst_22720,null));
var state_22740__$1 = state_22740;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22740__$1,(2),inst_22721,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_22741 === (2))){
var inst_22723 = (state_22740[(2)]);
var inst_22724 = cljs.core.nth.call(null,inst_22723,(0),null);
var inst_22725 = cljs.core.nth.call(null,inst_22723,(1),null);
var inst_22726 = cljs.core._EQ_.call(null,inst_22725,timeout_chan);
var state_22740__$1 = (function (){var statearr_22742 = state_22740;
(statearr_22742[(7)] = inst_22724);

return statearr_22742;
})();
if(inst_22726){
var statearr_22743_22754 = state_22740__$1;
(statearr_22743_22754[(1)] = (3));

} else {
var statearr_22744_22755 = state_22740__$1;
(statearr_22744_22755[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22741 === (3))){
var inst_22728 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_22729 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22730 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_22731 = cljs.core.PersistentHashMap.fromArrays(inst_22729,inst_22730);
var inst_22732 = cljs.core.ex_info.call(null,inst_22728,inst_22731);
var inst_22733 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_22732);
var inst_22734 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_22740__$1 = (function (){var statearr_22745 = state_22740;
(statearr_22745[(8)] = inst_22733);

return statearr_22745;
})();
var statearr_22746_22756 = state_22740__$1;
(statearr_22746_22756[(2)] = inst_22734);

(statearr_22746_22756[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22741 === (4))){
var inst_22736 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_22740__$1 = state_22740;
var statearr_22747_22757 = state_22740__$1;
(statearr_22747_22757[(2)] = inst_22736);

(statearr_22747_22757[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22741 === (5))){
var inst_22738 = (state_22740[(2)]);
var state_22740__$1 = state_22740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22740__$1,inst_22738);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_22748 = [null,null,null,null,null,null,null,null,null];
(statearr_22748[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__);

(statearr_22748[(1)] = (1));

return statearr_22748;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1 = (function (state_22740){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_22740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22749){var ex__2687__auto__ = e22749;
var statearr_22750_22758 = state_22740;
(statearr_22750_22758[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_22740[(4)]))){
var statearr_22751_22759 = state_22740;
(statearr_22751_22759[(1)] = cljs.core.first.call(null,(state_22740[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22760 = state_22740;
state_22740 = G__22760;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__ = function(state_22740){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1.call(this,state_22740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22752 = f__2707__auto__.call(null);
(statearr_22752[(6)] = c__2706__auto___22753);

return statearr_22752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
