// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
fluree.db.util.schema.schema_sid_start = fluree.db.flake.min_subject_id.call(null,(0));
fluree.db.util.schema.schema_sid_end = fluree.db.flake.max_subject_id.call(null,(1));
fluree.db.util.schema.collection_sid_start = fluree.db.flake.min_subject_id.call(null,(1));
fluree.db.util.schema.collection_sid_end = fluree.db.flake.max_subject_id.call(null,(1));
fluree.db.util.schema.predicate_sid_start = fluree.db.flake.min_subject_id.call(null,(0));
fluree.db.util.schema.predicate_sid_end = fluree.db.flake.max_subject_id.call(null,(0));
fluree.db.util.schema.setting_sid_start = fluree.db.flake.min_subject_id.call(null,(9));
fluree.db.util.schema.setting_sid_end = fluree.db.flake.max_subject_id.call(null,(9));
fluree.db.util.schema.auth_sid_start = fluree.db.flake.min_subject_id.call(null,(6));
fluree.db.util.schema.auth_sid_end = fluree.db.flake.max_subject_id.call(null,(6));
fluree.db.util.schema.role_sid_start = fluree.db.flake.min_subject_id.call(null,(7));
fluree.db.util.schema.role_sid_end = fluree.db.flake.max_subject_id.call(null,(7));
fluree.db.util.schema.rule_sid_start = fluree.db.flake.min_subject_id.call(null,(8));
fluree.db.util.schema.rule_sid_end = fluree.db.flake.max_subject_id.call(null,(8));
fluree.db.util.schema.fn_sid_start = fluree.db.flake.min_subject_id.call(null,(4));
fluree.db.util.schema.fn_sid_end = fluree.db.flake.max_subject_id.call(null,(4));
fluree.db.util.schema.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.util.schema.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
fluree.db.util.schema.sys_collection_end = fluree.db.flake.max_subject_id.call(null,(19));
/**
 * Returns true if this flake is for tx-meta
 */
fluree.db.util.schema.is_tx_meta_flake_QMARK_ = (function fluree$db$util$schema$is_tx_meta_flake_QMARK_(f){
return (fluree.db.flake.s.call(null,f) < (0));
});
/**
 * Returns true if collection id is a schema flake.
 */
fluree.db.util.schema.is_schema_cid_QMARK_ = (function fluree$db$util$schema$is_schema_cid_QMARK_(cid){
return ((cljs.core._EQ_.call(null,cid,(0))) || (cljs.core._EQ_.call(null,cid,(1))));
});
/**
 * Returns true if flake is a schema flake.
 */
fluree.db.util.schema.is_schema_flake_QMARK_ = (function fluree$db$util$schema$is_schema_flake_QMARK_(f){
return (((fluree.db.util.schema.schema_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.schema_sid_end)));
});
/**
 * Returns true if flake is a in a system collection.
 */
fluree.db.util.schema.is_system_flake_QMARK_ = (function fluree$db$util$schema$is_system_flake_QMARK_(f){
return ((((0) <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.sys_collection_end)));
});
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.util.schema.is_setting_flake_QMARK_ = (function fluree$db$util$schema$is_setting_flake_QMARK_(f){
return (((fluree.db.util.schema.setting_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.setting_sid_end)));
});
/**
 * Returns true if flake is a language flake.
 */
fluree.db.util.schema.is_language_flake_QMARK_ = (function fluree$db$util$schema$is_language_flake_QMARK_(f){
return cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,f),(117));
});
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.util.schema.is_genesis_flake_QMARK_ = (function fluree$db$util$schema$is_genesis_flake_QMARK_(f){
if((((fluree.db.util.schema.tag_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.tag_sid_end)))){
return true;
} else {
if(fluree.db.util.schema.is_setting_flake_QMARK_.call(null,f)){
return true;
} else {
if((((fluree.db.util.schema.auth_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.auth_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.role_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.role_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.rule_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.rule_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.fn_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.fn_sid_end)))){
return true;
} else {
if((((((fluree.db.util.schema.collection_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.collection_sid_end)))) && ((fluree.db.flake.sid__GT_i.call(null,fluree.db.flake.s.call(null,f)) <= (19))))){
return true;
} else {
if((((((fluree.db.util.schema.predicate_sid_start <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.util.schema.predicate_sid_end)))) && ((fluree.db.flake.sid__GT_i.call(null,fluree.db.flake.s.call(null,f)) <= (999))))){
return true;
} else {
return false;

}
}
}
}
}
}
}
}
});
fluree.db.util.schema.add_to_post_preds_QMARK_ = (function fluree$db$util$schema$add_to_post_preds_QMARK_(flakes,pred_ecount){
return cljs.core.keep.call(null,(function (p1__13856_SHARP_){
var f = p1__13856_SHARP_;
if(((((cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,f),(15))) || (cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,f),(13))))) && (((cljs.core._EQ_.call(null,fluree.db.flake.o.call(null,f),true)) && ((pred_ecount >= fluree.db.flake.s.call(null,f))))))){
return fluree.db.flake.s.call(null,f);
} else {
return null;
}
}),flakes);
});
/**
 * Returns any predicate subject flakes that are removing
 *   an existing index, either via index: true or unique: true.
 */
fluree.db.util.schema.remove_from_post_preds = (function fluree$db$util$schema$remove_from_post_preds(flakes){
return cljs.core.keep.call(null,(function (p1__13857_SHARP_){
var f = p1__13857_SHARP_;
if(((fluree.db.flake.op.call(null,f) === true) && (((((cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,f),(15))) || (cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,f),(13))))) && (cljs.core._EQ_.call(null,fluree.db.flake.o.call(null,f),false)))))){
return fluree.db.flake.s.call(null,f);
} else {
return null;
}
}),flakes);
});
/**
 * Returns true if any of the provided flakes are a schema flake.
 */
fluree.db.util.schema.schema_change_QMARK_ = (function fluree$db$util$schema$schema_change_QMARK_(flakes){
return cljs.core.some.call(null,fluree.db.util.schema.is_schema_flake_QMARK_,flakes);
});
fluree.db.util.schema.setting_change_QMARK_ = (function fluree$db$util$schema$setting_change_QMARK_(flakes){
return cljs.core.some.call(null,fluree.db.util.schema.is_setting_flake_QMARK_,flakes);
});
/**
 * Returns true if any of the provided flakes are in any system collection.
 */
fluree.db.util.schema.system_change_QMARK_ = (function fluree$db$util$schema$system_change_QMARK_(flakes){
return cljs.core.some.call(null,fluree.db.util.schema.is_system_flake_QMARK_,flakes);
});
/**
 * Returns the language being added, if any. Else returns nil.
 */
fluree.db.util.schema.get_language_change = (function fluree$db$util$schema$get_language_change(flakes){
return cljs.core.some.call(null,(function (p1__13858_SHARP_){
var f = p1__13858_SHARP_;
if(((fluree.db.util.schema.is_language_flake_QMARK_.call(null,f)) && (((fluree.db.util.schema.is_setting_flake_QMARK_.call(null,f)) && (fluree.db.flake.op.call(null,f) === true))))){
return fluree.db.flake.o.call(null,f);
} else {
return null;
}
}),flakes);
});
/**
 * Returns true if flake is a schema flake.
 */
fluree.db.util.schema.is_pred_flake_QMARK_ = (function fluree$db$util$schema$is_pred_flake_QMARK_(f){
return (((fluree.db.flake.MIN_PREDICATE_ID <= fluree.db.flake.s.call(null,f))) && ((fluree.db.flake.s.call(null,f) <= fluree.db.flake.MAX_PREDICATE_ID)));
});
/**
 * Returns true if there are any predicate changes present in set of flakes.
 */
fluree.db.util.schema.pred_change_QMARK_ = (function fluree$db$util$schema$pred_change_QMARK_(flakes){
return cljs.core.some.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
});
