// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27145,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27149 = k27145;
var G__27149__$1 = (((G__27149 instanceof cljs.core.Keyword))?G__27149.fqn:null);
switch (G__27149__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27145,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__27150){
var vec__27151 = p__27150;
var k__5367__auto__ = cljs.core.nth.call(null,vec__27151,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__27151,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27144){
var self__ = this;
var G__27144__$1 = this;
return (new cljs.core.RecordIter((0),G__27144__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27146,other27147){
var self__ = this;
var this27146__$1 = this;
return (((!((other27147 == null)))) && ((((this27146__$1.constructor === other27147.constructor)) && (((cljs.core._EQ_.call(null,this27146__$1.conn,other27147.conn)) && (((cljs.core._EQ_.call(null,this27146__$1.network,other27147.network)) && (((cljs.core._EQ_.call(null,this27146__$1.ledger_id,other27147.ledger_id)) && (((cljs.core._EQ_.call(null,this27146__$1.db_name,other27147.db_name)) && (((cljs.core._EQ_.call(null,this27146__$1.update_chan,other27147.update_chan)) && (((cljs.core._EQ_.call(null,this27146__$1.transact_chan,other27147.transact_chan)) && (((cljs.core._EQ_.call(null,this27146__$1.state,other27147.state)) && (((cljs.core._EQ_.call(null,this27146__$1.schema_cache,other27147.schema_cache)) && (((cljs.core._EQ_.call(null,this27146__$1.blank_db,other27147.blank_db)) && (((cljs.core._EQ_.call(null,this27146__$1.close,other27147.close)) && (((cljs.core._EQ_.call(null,this27146__$1.id,other27147.id)) && (cljs.core._EQ_.call(null,this27146__$1.__extmap,other27147.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27145){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27154 = k27145;
var G__27154__$1 = (((G__27154 instanceof cljs.core.Keyword))?G__27154.fqn:null);
switch (G__27154__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27145);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27144){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27155 = cljs.core.keyword_identical_QMARK_;
var expr__27156 = k__5352__auto__;
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27156))){
return (new fluree.db.session.DbSession(G__27144,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,G__27144,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27144,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__27144,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__27144,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__27144,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__27144,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27144,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27144,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27144,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27155.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__27156))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27144,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__27144),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27144){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27144,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27148){
var extmap__5385__auto__ = (function (){var G__27158 = cljs.core.dissoc.call(null,G__27148,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__27148)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27158);
} else {
return G__27158;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27148),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27148),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27161 = session;
var map__27161__$1 = cljs.core.__destructure_map.call(null,map__27161);
var network = cljs.core.get.call(null,map__27161__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27161__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27203){
var state_val_27204 = (state_27203[(1)]);
if((state_val_27204 === (7))){
var inst_27177 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_27178 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27179 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27180 = cljs.core.PersistentHashMap.fromArrays(inst_27178,inst_27179);
var inst_27181 = cljs.core.ex_info.call(null,inst_27177,inst_27180);
var inst_27182 = (function(){throw inst_27181})();
var state_27203__$1 = state_27203;
var statearr_27205_27228 = state_27203__$1;
(statearr_27205_27228[(2)] = inst_27182);

(statearr_27205_27228[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (1))){
var state_27203__$1 = state_27203;
var statearr_27206_27229 = state_27203__$1;
(statearr_27206_27229[(2)] = null);

(statearr_27206_27229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (4))){
var inst_27162 = (state_27203[(2)]);
var state_27203__$1 = state_27203;
var statearr_27207_27230 = state_27203__$1;
(statearr_27207_27230[(2)] = inst_27162);

(statearr_27207_27230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (6))){
var inst_27174 = (state_27203[(7)]);
var inst_27173 = (state_27203[(2)]);
var inst_27174__$1 = fluree.db.util.async.throw_err.call(null,inst_27173);
var inst_27175 = cljs.core.empty_QMARK_.call(null,inst_27174__$1);
var state_27203__$1 = (function (){var statearr_27208 = state_27203;
(statearr_27208[(7)] = inst_27174__$1);

return statearr_27208;
})();
if(inst_27175){
var statearr_27209_27231 = state_27203__$1;
(statearr_27209_27231[(1)] = (7));

} else {
var statearr_27210_27232 = state_27203__$1;
(statearr_27210_27232[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (3))){
var inst_27201 = (state_27203[(2)]);
var state_27203__$1 = state_27203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27203__$1,inst_27201);
} else {
if((state_val_27204 === (12))){
var inst_27196 = (state_27203[(2)]);
var state_27203__$1 = state_27203;
var statearr_27211_27233 = state_27203__$1;
(statearr_27211_27233[(2)] = inst_27196);

(statearr_27211_27233[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (2))){
var _ = (function (){var statearr_27212 = state_27203;
(statearr_27212[(4)] = cljs.core.cons.call(null,(5),(state_27203[(4)])));

return statearr_27212;
})();
var inst_27168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27169 = [network,ledger_id];
var inst_27170 = (new cljs.core.PersistentVector(null,2,(5),inst_27168,inst_27169,null));
var inst_27171 = fluree.db.operations.ledger_info_async.call(null,conn,inst_27170);
var state_27203__$1 = state_27203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27203__$1,(6),inst_27171);
} else {
if((state_val_27204 === (11))){
var inst_27174 = (state_27203[(7)]);
var state_27203__$1 = state_27203;
var statearr_27214_27234 = state_27203__$1;
(statearr_27214_27234[(2)] = inst_27174);

(statearr_27214_27234[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (9))){
var inst_27198 = (state_27203[(2)]);
var _ = (function (){var statearr_27215 = state_27203;
(statearr_27215[(4)] = cljs.core.rest.call(null,(state_27203[(4)])));

return statearr_27215;
})();
var state_27203__$1 = state_27203;
var statearr_27216_27235 = state_27203__$1;
(statearr_27216_27235[(2)] = inst_27198);

(statearr_27216_27235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (5))){
var _ = (function (){var statearr_27217 = state_27203;
(statearr_27217[(4)] = cljs.core.rest.call(null,(state_27203[(4)])));

return statearr_27217;
})();
var state_27203__$1 = state_27203;
var ex27213 = (state_27203__$1[(2)]);
var statearr_27218_27236 = state_27203__$1;
(statearr_27218_27236[(5)] = ex27213);


if((ex27213 instanceof Error)){
var statearr_27219_27237 = state_27203__$1;
(statearr_27219_27237[(1)] = (4));

(statearr_27219_27237[(5)] = null);

} else {
throw ex27213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (10))){
var inst_27174 = (state_27203[(7)]);
var inst_27187 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27174);
var inst_27188 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27187),"."].join('');
var inst_27189 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27190 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27191 = cljs.core.PersistentHashMap.fromArrays(inst_27189,inst_27190);
var inst_27192 = cljs.core.ex_info.call(null,inst_27188,inst_27191);
var inst_27193 = (function(){throw inst_27192})();
var state_27203__$1 = state_27203;
var statearr_27220_27238 = state_27203__$1;
(statearr_27220_27238[(2)] = inst_27193);

(statearr_27220_27238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27204 === (8))){
var inst_27174 = (state_27203[(7)]);
var inst_27184 = fluree.db.session.ready_QMARK_.call(null,inst_27174);
var inst_27185 = (!(inst_27184));
var state_27203__$1 = state_27203;
if(inst_27185){
var statearr_27221_27239 = state_27203__$1;
(statearr_27221_27239[(1)] = (10));

} else {
var statearr_27222_27240 = state_27203__$1;
(statearr_27222_27240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0 = (function (){
var statearr_27223 = [null,null,null,null,null,null,null,null];
(statearr_27223[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2684__auto__);

(statearr_27223[(1)] = (1));

return statearr_27223;
});
var fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1 = (function (state_27203){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27224){var ex__2687__auto__ = e27224;
var statearr_27225_27241 = state_27203;
(statearr_27225_27241[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27203[(4)]))){
var statearr_27226_27242 = state_27203;
(statearr_27226_27242[(1)] = cljs.core.first.call(null,(state_27203[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27243 = state_27203;
state_27203 = G__27243;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__ = function(state_27203){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1.call(this,state_27203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2684__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2684__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27227 = f__2707__auto__.call(null);
(statearr_27227[(6)] = c__2706__auto__);

return statearr_27227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__27244){
var map__27245 = p__27244;
var map__27245__$1 = cljs.core.__destructure_map.call(null,map__27245);
var blank_db = map__27245__$1;
var network = cljs.core.get.call(null,map__27245__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27245__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27320){
var state_val_27321 = (state_27320[(1)]);
if((state_val_27321 === (7))){
var inst_27263 = (state_27320[(7)]);
var inst_27262 = (state_27320[(2)]);
var inst_27263__$1 = fluree.db.util.async.throw_err.call(null,inst_27262);
var state_27320__$1 = (function (){var statearr_27322 = state_27320;
(statearr_27322[(7)] = inst_27263__$1);

return statearr_27322;
})();
if(cljs.core.truth_(inst_27263__$1)){
var statearr_27323_27358 = state_27320__$1;
(statearr_27323_27358[(1)] = (8));

} else {
var statearr_27324_27359 = state_27320__$1;
(statearr_27324_27359[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (20))){
var inst_27268 = (state_27320[(8)]);
var inst_27301 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27268)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27302 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27303 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27304 = cljs.core.PersistentHashMap.fromArrays(inst_27302,inst_27303);
var inst_27305 = cljs.core.ex_info.call(null,inst_27301,inst_27304);
var inst_27306 = (function(){throw inst_27305})();
var state_27320__$1 = state_27320;
var statearr_27325_27360 = state_27320__$1;
(statearr_27325_27360[(2)] = inst_27306);

(statearr_27325_27360[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (1))){
var state_27320__$1 = state_27320;
var statearr_27326_27361 = state_27320__$1;
(statearr_27326_27361[(2)] = null);

(statearr_27326_27361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (4))){
var inst_27246 = (state_27320[(2)]);
var state_27320__$1 = state_27320;
var statearr_27327_27362 = state_27320__$1;
(statearr_27327_27362[(2)] = inst_27246);

(statearr_27327_27362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (15))){
var inst_27310 = (state_27320[(2)]);
var state_27320__$1 = state_27320;
var statearr_27328_27363 = state_27320__$1;
(statearr_27328_27363[(2)] = inst_27310);

(statearr_27328_27363[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (21))){
var inst_27308 = (state_27320[(2)]);
var state_27320__$1 = state_27320;
var statearr_27329_27364 = state_27320__$1;
(statearr_27329_27364[(2)] = inst_27308);

(statearr_27329_27364[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (13))){
var inst_27267 = (state_27320[(9)]);
var inst_27272 = fluree.db.query.schema.schema_map.call(null,inst_27267);
var inst_27273 = fluree.db.query.schema.setting_map.call(null,inst_27267);
var inst_27274 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_27267);
var inst_27275 = cljs.core.swap_BANG_.call(null,inst_27274,cljs.core.empty);
var state_27320__$1 = (function (){var statearr_27330 = state_27320;
(statearr_27330[(10)] = inst_27275);

(statearr_27330[(11)] = inst_27273);

return statearr_27330;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27320__$1,(16),inst_27272);
} else {
if((state_val_27321 === (22))){
var inst_27268 = (state_27320[(8)]);
var inst_27296 = (state_27320[(2)]);
var inst_27297 = fluree.db.util.async.throw_err.call(null,inst_27296);
var inst_27298 = (inst_27268 + (1));
var inst_27267 = inst_27297;
var inst_27268__$1 = inst_27298;
var state_27320__$1 = (function (){var statearr_27331 = state_27320;
(statearr_27331[(8)] = inst_27268__$1);

(statearr_27331[(9)] = inst_27267);

return statearr_27331;
})();
var statearr_27332_27365 = state_27320__$1;
(statearr_27332_27365[(2)] = null);

(statearr_27332_27365[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (6))){
var inst_27255 = (state_27320[(2)]);
var inst_27256 = fluree.db.util.async.throw_err.call(null,inst_27255);
var inst_27257 = cljs.core.__destructure_map.call(null,inst_27256);
var inst_27258 = cljs.core.get.call(null,inst_27257,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27259 = cljs.core.get.call(null,inst_27257,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_27260 = fluree.db.storage.core.reify_db.call(null,conn,network,ledger_id,blank_db,inst_27259);
var state_27320__$1 = (function (){var statearr_27333 = state_27320;
(statearr_27333[(12)] = inst_27258);

return statearr_27333;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27320__$1,(7),inst_27260);
} else {
if((state_val_27321 === (17))){
var inst_27278 = (state_27320[(13)]);
var inst_27267 = (state_27320[(9)]);
var inst_27280 = (state_27320[(2)]);
var inst_27281 = fluree.db.util.async.throw_err.call(null,inst_27280);
var inst_27282 = cljs.core.assoc.call(null,inst_27267,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27278,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27281);
var state_27320__$1 = state_27320;
var statearr_27334_27366 = state_27320__$1;
(statearr_27334_27366[(2)] = inst_27282);

(statearr_27334_27366[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (3))){
var inst_27318 = (state_27320[(2)]);
var state_27320__$1 = state_27320;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27320__$1,inst_27318);
} else {
if((state_val_27321 === (12))){
var inst_27312 = (state_27320[(2)]);
var state_27320__$1 = state_27320;
var statearr_27335_27367 = state_27320__$1;
(statearr_27335_27367[(2)] = inst_27312);

(statearr_27335_27367[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (2))){
var _ = (function (){var statearr_27336 = state_27320;
(statearr_27336[(4)] = cljs.core.cons.call(null,(5),(state_27320[(4)])));

return statearr_27336;
})();
var inst_27253 = fluree.db.session.load_ledger_info.call(null,conn,network,ledger_id);
var state_27320__$1 = state_27320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27320__$1,(6),inst_27253);
} else {
if((state_val_27321 === (19))){
var inst_27287 = (state_27320[(14)]);
var inst_27267 = (state_27320[(9)]);
var inst_27290 = cljs.core.__destructure_map.call(null,inst_27287);
var inst_27291 = cljs.core.get.call(null,inst_27290,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27292 = cljs.core.get.call(null,inst_27290,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27293 = cljs.core.get.call(null,inst_27290,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27294 = fluree.db.dbproto._with.call(null,inst_27267,inst_27292,inst_27291);
var state_27320__$1 = (function (){var statearr_27337 = state_27320;
(statearr_27337[(15)] = inst_27293);

return statearr_27337;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27320__$1,(22),inst_27294);
} else {
if((state_val_27321 === (11))){
var inst_27268 = (state_27320[(8)]);
var inst_27258 = (state_27320[(12)]);
var inst_27270 = (inst_27268 > inst_27258);
var state_27320__$1 = state_27320;
if(cljs.core.truth_(inst_27270)){
var statearr_27339_27368 = state_27320__$1;
(statearr_27339_27368[(1)] = (13));

} else {
var statearr_27340_27369 = state_27320__$1;
(statearr_27340_27369[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (9))){
var state_27320__$1 = state_27320;
var statearr_27341_27370 = state_27320__$1;
(statearr_27341_27370[(2)] = null);

(statearr_27341_27370[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (5))){
var _ = (function (){var statearr_27342 = state_27320;
(statearr_27342[(4)] = cljs.core.rest.call(null,(state_27320[(4)])));

return statearr_27342;
})();
var state_27320__$1 = state_27320;
var ex27338 = (state_27320__$1[(2)]);
var statearr_27343_27371 = state_27320__$1;
(statearr_27343_27371[(5)] = ex27338);


if((ex27338 instanceof Error)){
var statearr_27344_27372 = state_27320__$1;
(statearr_27344_27372[(1)] = (4));

(statearr_27344_27372[(5)] = null);

} else {
throw ex27338;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (14))){
var inst_27268 = (state_27320[(8)]);
var inst_27284 = fluree.db.storage.core.read_block.call(null,conn,network,ledger_id,inst_27268);
var state_27320__$1 = state_27320;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27320__$1,(18),inst_27284);
} else {
if((state_val_27321 === (16))){
var inst_27273 = (state_27320[(11)]);
var inst_27277 = (state_27320[(2)]);
var inst_27278 = fluree.db.util.async.throw_err.call(null,inst_27277);
var state_27320__$1 = (function (){var statearr_27345 = state_27320;
(statearr_27345[(13)] = inst_27278);

return statearr_27345;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27320__$1,(17),inst_27273);
} else {
if((state_val_27321 === (10))){
var inst_27315 = (state_27320[(2)]);
var _ = (function (){var statearr_27346 = state_27320;
(statearr_27346[(4)] = cljs.core.rest.call(null,(state_27320[(4)])));

return statearr_27346;
})();
var state_27320__$1 = state_27320;
var statearr_27347_27373 = state_27320__$1;
(statearr_27347_27373[(2)] = inst_27315);

(statearr_27347_27373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (18))){
var inst_27287 = (state_27320[(14)]);
var inst_27286 = (state_27320[(2)]);
var inst_27287__$1 = fluree.db.util.async.throw_err.call(null,inst_27286);
var state_27320__$1 = (function (){var statearr_27348 = state_27320;
(statearr_27348[(14)] = inst_27287__$1);

return statearr_27348;
})();
if(cljs.core.truth_(inst_27287__$1)){
var statearr_27349_27374 = state_27320__$1;
(statearr_27349_27374[(1)] = (19));

} else {
var statearr_27350_27375 = state_27320__$1;
(statearr_27350_27375[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27321 === (8))){
var inst_27263 = (state_27320[(7)]);
var inst_27265 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27263);
var inst_27266 = (inst_27265 + (1));
var inst_27267 = inst_27263;
var inst_27268 = inst_27266;
var state_27320__$1 = (function (){var statearr_27351 = state_27320;
(statearr_27351[(8)] = inst_27268);

(statearr_27351[(9)] = inst_27267);

return statearr_27351;
})();
var statearr_27352_27376 = state_27320__$1;
(statearr_27352_27376[(2)] = null);

(statearr_27352_27376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2684__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2684__auto____0 = (function (){
var statearr_27353 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27353[(0)] = fluree$db$session$load_current_db_$_state_machine__2684__auto__);

(statearr_27353[(1)] = (1));

return statearr_27353;
});
var fluree$db$session$load_current_db_$_state_machine__2684__auto____1 = (function (state_27320){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27320);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27354){var ex__2687__auto__ = e27354;
var statearr_27355_27377 = state_27320;
(statearr_27355_27377[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27320[(4)]))){
var statearr_27356_27378 = state_27320;
(statearr_27356_27378[(1)] = cljs.core.first.call(null,(state_27320[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27379 = state_27320;
state_27320 = G__27379;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2684__auto__ = function(state_27320){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2684__auto____1.call(this,state_27320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2684__auto____0;
fluree$db$session$load_current_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2684__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27357 = f__2707__auto__.call(null);
(statearr_27357[(6)] = c__2706__auto__);

return statearr_27357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27380,old_db_ch,new_db_ch){
var map__27381 = p__27380;
var map__27381__$1 = cljs.core.__destructure_map.call(null,map__27381);
var state = cljs.core.get.call(null,map__27381__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (p__27382){
var map__27383 = p__27382;
var map__27383__$1 = cljs.core.__destructure_map.call(null,map__27383);
var s = map__27383__$1;
var current = cljs.core.get.call(null,map__27383__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.call(null,current,old_db_ch)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27384){
var map__27385 = p__27384;
var map__27385__$1 = cljs.core.__destructure_map.call(null,map__27385);
var state = cljs.core.get.call(null,map__27385__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27386){
var map__27387 = p__27386;
var map__27387__$1 = cljs.core.__destructure_map.call(null,map__27387);
var conn = cljs.core.get.call(null,map__27387__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.call(null,map__27387__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.call(null,map__27387__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.call(null);
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2706__auto___27424 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27407){
var state_val_27408 = (state_27407[(1)]);
if((state_val_27408 === (1))){
var state_27407__$1 = state_27407;
var statearr_27409_27425 = state_27407__$1;
(statearr_27409_27425[(2)] = null);

(statearr_27409_27425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (2))){
var _ = (function (){var statearr_27410 = state_27407;
(statearr_27410[(4)] = cljs.core.cons.call(null,(5),(state_27407[(4)])));

return statearr_27410;
})();
var inst_27397 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27407__$1 = state_27407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27407__$1,(6),inst_27397);
} else {
if((state_val_27408 === (3))){
var inst_27405 = (state_27407[(2)]);
var state_27407__$1 = state_27407;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27407__$1,inst_27405);
} else {
if((state_val_27408 === (4))){
var inst_27388 = (state_27407[(2)]);
var inst_27389 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27390 = fluree.db.util.log.error.call(null,inst_27388,"Error reloading db");
var inst_27391 = cljs.core.async.put_BANG_.call(null,db_ch,inst_27388);
var state_27407__$1 = (function (){var statearr_27412 = state_27407;
(statearr_27412[(7)] = inst_27390);

(statearr_27412[(8)] = inst_27389);

return statearr_27412;
})();
var statearr_27413_27426 = state_27407__$1;
(statearr_27413_27426[(2)] = inst_27391);

(statearr_27413_27426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (5))){
var _ = (function (){var statearr_27414 = state_27407;
(statearr_27414[(4)] = cljs.core.rest.call(null,(state_27407[(4)])));

return statearr_27414;
})();
var state_27407__$1 = state_27407;
var ex27411 = (state_27407__$1[(2)]);
var statearr_27415_27427 = state_27407__$1;
(statearr_27415_27427[(5)] = ex27411);


var statearr_27416_27428 = state_27407__$1;
(statearr_27416_27428[(1)] = (4));

(statearr_27416_27428[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (6))){
var inst_27399 = (state_27407[(2)]);
var inst_27400 = fluree.db.util.async.throw_err.call(null,inst_27399);
var state_27407__$1 = state_27407;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27407__$1,(7),db_ch,inst_27400);
} else {
if((state_val_27408 === (7))){
var inst_27402 = (state_27407[(2)]);
var _ = (function (){var statearr_27417 = state_27407;
(statearr_27417[(4)] = cljs.core.rest.call(null,(state_27407[(4)])));

return statearr_27417;
})();
var state_27407__$1 = state_27407;
var statearr_27418_27429 = state_27407__$1;
(statearr_27418_27429[(2)] = inst_27402);

(statearr_27418_27429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0 = (function (){
var statearr_27419 = [null,null,null,null,null,null,null,null,null];
(statearr_27419[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__);

(statearr_27419[(1)] = (1));

return statearr_27419;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1 = (function (state_27407){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27407);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27420){var ex__2687__auto__ = e27420;
var statearr_27421_27430 = state_27407;
(statearr_27421_27430[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27407[(4)]))){
var statearr_27422_27431 = state_27407;
(statearr_27422_27431[(1)] = cljs.core.first.call(null,(state_27407[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27432 = state_27407;
state_27407 = G__27432;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__ = function(state_27407){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1.call(this,state_27407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2684__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27423 = f__2707__auto__.call(null);
(statearr_27423[(6)] = c__2706__auto___27424);

return statearr_27423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27434 = arguments.length;
switch (G__27434) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27435){
var map__27436 = p__27435;
var map__27436__$1 = cljs.core.__destructure_map.call(null,map__27436);
var session = map__27436__$1;
var blank_db = cljs.core.get.call(null,map__27436__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.call(null,session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27437,blank_db){
var map__27438 = p__27437;
var map__27438__$1 = cljs.core.__destructure_map.call(null,map__27438);
var session = map__27438__$1;
var conn = cljs.core.get.call(null,map__27438__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.call(null,map__27438__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (s){
return cljs.core.update.call(null,cljs.core.assoc.call(null,s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null)),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.call(null);
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (s){
if(cljs.core.not.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.call(null,cur_ch,state_ch)){
var c__2706__auto___27476 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27458){
var state_val_27459 = (state_27458[(1)]);
if((state_val_27459 === (1))){
var state_27458__$1 = state_27458;
var statearr_27460_27477 = state_27458__$1;
(statearr_27460_27477[(2)] = null);

(statearr_27460_27477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27459 === (2))){
var _ = (function (){var statearr_27461 = state_27458;
(statearr_27461[(4)] = cljs.core.cons.call(null,(5),(state_27458[(4)])));

return statearr_27461;
})();
var inst_27448 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27458__$1 = state_27458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27458__$1,(6),inst_27448);
} else {
if((state_val_27459 === (3))){
var inst_27456 = (state_27458[(2)]);
var state_27458__$1 = state_27458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27458__$1,inst_27456);
} else {
if((state_val_27459 === (4))){
var inst_27439 = (state_27458[(2)]);
var inst_27440 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27441 = fluree.db.util.log.error.call(null,inst_27439,"Error loading current db");
var inst_27442 = cljs.core.async.put_BANG_.call(null,cur_ch,inst_27439);
var state_27458__$1 = (function (){var statearr_27463 = state_27458;
(statearr_27463[(7)] = inst_27440);

(statearr_27463[(8)] = inst_27441);

return statearr_27463;
})();
var statearr_27464_27478 = state_27458__$1;
(statearr_27464_27478[(2)] = inst_27442);

(statearr_27464_27478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27459 === (5))){
var _ = (function (){var statearr_27465 = state_27458;
(statearr_27465[(4)] = cljs.core.rest.call(null,(state_27458[(4)])));

return statearr_27465;
})();
var state_27458__$1 = state_27458;
var ex27462 = (state_27458__$1[(2)]);
var statearr_27466_27479 = state_27458__$1;
(statearr_27466_27479[(5)] = ex27462);


var statearr_27467_27480 = state_27458__$1;
(statearr_27467_27480[(1)] = (4));

(statearr_27467_27480[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27459 === (6))){
var inst_27450 = (state_27458[(2)]);
var inst_27451 = fluree.db.util.async.throw_err.call(null,inst_27450);
var state_27458__$1 = state_27458;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27458__$1,(7),cur_ch,inst_27451);
} else {
if((state_val_27459 === (7))){
var inst_27453 = (state_27458[(2)]);
var _ = (function (){var statearr_27468 = state_27458;
(statearr_27468[(4)] = cljs.core.rest.call(null,(state_27458[(4)])));

return statearr_27468;
})();
var state_27458__$1 = state_27458;
var statearr_27469_27481 = state_27458__$1;
(statearr_27469_27481[(2)] = inst_27453);

(statearr_27469_27481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27470 = [null,null,null,null,null,null,null,null,null];
(statearr_27470[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27470[(1)] = (1));

return statearr_27470;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27458){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27471){var ex__2687__auto__ = e27471;
var statearr_27472_27482 = state_27458;
(statearr_27472_27482[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27458[(4)]))){
var statearr_27473_27483 = state_27458;
(statearr_27473_27483[(1)] = cljs.core.first.call(null,(state_27458[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27484 = state_27458;
state_27458 = G__27484;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27458){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27474 = f__2707__auto__.call(null);
(statearr_27474[(6)] = c__2706__auto___27476);

return statearr_27474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger named testledger on network testnet.
 *   - [testnet testledger] - already in form of [network ledger-id]
 * 
 *   The two-arity version of this exists for backwards compatibility. It doesn't do anything with the
 *   conn arg so there is also a single-arity version that just takes the ledger name.
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(var_args){
var G__27486 = arguments.length;
switch (G__27486) {
case 1:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1 = (function (ledger){
return fluree.db.session.resolve_ledger.call(null,null,ledger);
}));

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2 = (function (_conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var ledger_id = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return ledger_id;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
}
}));

(fluree.db.session.resolve_ledger.cljs$lang$maxFixedArity = 2);

if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27489){
var state_val_27490 = (state_27489[(1)]);
if((state_val_27490 === (1))){
var state_27489__$1 = state_27489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27489__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27491 = [null,null,null,null,null,null,null];
(statearr_27491[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27491[(1)] = (1));

return statearr_27491;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27489){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27492){var ex__2687__auto__ = e27492;
var statearr_27493_27496 = state_27489;
(statearr_27493_27496[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27489[(4)]))){
var statearr_27494_27497 = state_27489;
(statearr_27494_27497[(1)] = cljs.core.first.call(null,(state_27489[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27498 = state_27489;
state_27489 = G__27498;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27489){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27495 = f__2707__auto__.call(null);
(statearr_27495[(6)] = c__2706__auto__);

return statearr_27495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27499){
var map__27500 = p__27499;
var map__27500__$1 = cljs.core.__destructure_map.call(null,map__27500);
var data = map__27500__$1;
var block = cljs.core.get.call(null,map__27500__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27500__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27500__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27559){
var state_val_27560 = (state_27559[(1)]);
if((state_val_27560 === (7))){
var inst_27511 = (state_27559[(7)]);
var inst_27514 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27515 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27516 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27514),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27515),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27511),". No-op."].join('');
var inst_27517 = fluree.db.util.log.info.call(null,inst_27516);
var state_27559__$1 = state_27559;
var statearr_27561_27595 = state_27559__$1;
(statearr_27561_27595[(2)] = inst_27517);

(statearr_27561_27595[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (1))){
var state_27559__$1 = state_27559;
var statearr_27562_27596 = state_27559__$1;
(statearr_27562_27596[(2)] = null);

(statearr_27562_27596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (4))){
var inst_27501 = (state_27559[(2)]);
var state_27559__$1 = state_27559;
var statearr_27563_27597 = state_27559__$1;
(statearr_27563_27597[(2)] = inst_27501);

(statearr_27563_27597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (15))){
var inst_27540 = (state_27559[(2)]);
var state_27559__$1 = state_27559;
var statearr_27564_27598 = state_27559__$1;
(statearr_27564_27598[(2)] = inst_27540);

(statearr_27564_27598[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (13))){
var inst_27531 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27533 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27534 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27535 = [inst_27533,inst_27534];
var inst_27536 = (new cljs.core.PersistentVector(null,2,(5),inst_27532,inst_27535,null));
var inst_27537 = fluree.db.conn_events.process_event.call(null,inst_27531,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_27536,data);
var state_27559__$1 = state_27559;
var statearr_27565_27599 = state_27559__$1;
(statearr_27565_27599[(2)] = inst_27537);

(statearr_27565_27599[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (6))){
var inst_27510 = (state_27559[(8)]);
var inst_27511 = (state_27559[(7)]);
var inst_27509 = (state_27559[(2)]);
var inst_27510__$1 = fluree.db.util.async.throw_err.call(null,inst_27509);
var inst_27511__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27510__$1);
var inst_27512 = (block <= inst_27511__$1);
var state_27559__$1 = (function (){var statearr_27566 = state_27559;
(statearr_27566[(8)] = inst_27510__$1);

(statearr_27566[(7)] = inst_27511__$1);

return statearr_27566;
})();
if(cljs.core.truth_(inst_27512)){
var statearr_27567_27600 = state_27559__$1;
(statearr_27567_27600[(1)] = (7));

} else {
var statearr_27568_27601 = state_27559__$1;
(statearr_27568_27601[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (17))){
var state_27559__$1 = state_27559;
var statearr_27569_27602 = state_27559__$1;
(statearr_27569_27602[(2)] = null);

(statearr_27569_27602[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (3))){
var inst_27557 = (state_27559[(2)]);
var state_27559__$1 = state_27559;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27559__$1,inst_27557);
} else {
if((state_val_27560 === (12))){
var inst_27552 = (state_27559[(2)]);
var state_27559__$1 = state_27559;
var statearr_27570_27603 = state_27559__$1;
(statearr_27570_27603[(2)] = inst_27552);

(statearr_27570_27603[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (2))){
var inst_27507 = (state_27559[(9)]);
var _ = (function (){var statearr_27571 = state_27559;
(statearr_27571[(4)] = cljs.core.cons.call(null,(5),(state_27559[(4)])));

return statearr_27571;
})();
var inst_27507__$1 = fluree.db.session.current_db.call(null,session);
var state_27559__$1 = (function (){var statearr_27572 = state_27559;
(statearr_27572[(9)] = inst_27507__$1);

return statearr_27572;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27559__$1,(6),inst_27507__$1);
} else {
if((state_val_27560 === (11))){
var state_27559__$1 = state_27559;
var statearr_27574_27604 = state_27559__$1;
(statearr_27574_27604[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (9))){
var inst_27554 = (state_27559[(2)]);
var _ = (function (){var statearr_27576 = state_27559;
(statearr_27576[(4)] = cljs.core.rest.call(null,(state_27559[(4)])));

return statearr_27576;
})();
var state_27559__$1 = state_27559;
var statearr_27577_27605 = state_27559__$1;
(statearr_27577_27605[(2)] = inst_27554);

(statearr_27577_27605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (5))){
var _ = (function (){var statearr_27578 = state_27559;
(statearr_27578[(4)] = cljs.core.rest.call(null,(state_27559[(4)])));

return statearr_27578;
})();
var state_27559__$1 = state_27559;
var ex27573 = (state_27559__$1[(2)]);
var statearr_27579_27606 = state_27559__$1;
(statearr_27579_27606[(5)] = ex27573);


if((ex27573 instanceof Error)){
var statearr_27580_27607 = state_27559__$1;
(statearr_27580_27607[(1)] = (4));

(statearr_27580_27607[(5)] = null);

} else {
throw ex27573;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (14))){
var state_27559__$1 = state_27559;
var statearr_27581_27608 = state_27559__$1;
(statearr_27581_27608[(2)] = null);

(statearr_27581_27608[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (16))){
var inst_27511 = (state_27559[(7)]);
var inst_27543 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27544 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27545 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27543),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27544),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27511),". Forcing a db reload."].join('');
var inst_27546 = fluree.db.util.log.info.call(null,inst_27545);
var inst_27547 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27559__$1 = (function (){var statearr_27582 = state_27559;
(statearr_27582[(10)] = inst_27546);

return statearr_27582;
})();
var statearr_27583_27609 = state_27559__$1;
(statearr_27583_27609[(2)] = inst_27547);

(statearr_27583_27609[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (10))){
var inst_27510 = (state_27559[(8)]);
var inst_27511 = (state_27559[(7)]);
var inst_27507 = (state_27559[(9)]);
var inst_27522 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27523 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27524 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27522),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27523),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27525 = fluree.db.util.log.trace.call(null,inst_27524);
var inst_27526 = (function (){var current_db_ch = inst_27507;
var current_db = inst_27510;
var current_block = inst_27511;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,f);
}
});
})();
var inst_27527 = cljs.core.map.call(null,inst_27526,flakes);
var inst_27528 = fluree.db.dbproto._with.call(null,inst_27510,block,inst_27527);
var inst_27529 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27507,inst_27528);
var state_27559__$1 = (function (){var statearr_27584 = state_27559;
(statearr_27584[(11)] = inst_27525);

return statearr_27584;
})();
if(inst_27529){
var statearr_27585_27610 = state_27559__$1;
(statearr_27585_27610[(1)] = (13));

} else {
var statearr_27586_27611 = state_27559__$1;
(statearr_27586_27611[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (18))){
var inst_27550 = (state_27559[(2)]);
var state_27559__$1 = state_27559;
var statearr_27587_27612 = state_27559__$1;
(statearr_27587_27612[(2)] = inst_27550);

(statearr_27587_27612[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27560 === (8))){
var inst_27511 = (state_27559[(7)]);
var inst_27519 = ((1) + inst_27511);
var inst_27520 = cljs.core._EQ_.call(null,block,inst_27519);
var state_27559__$1 = state_27559;
if(inst_27520){
var statearr_27588_27613 = state_27559__$1;
(statearr_27588_27613[(1)] = (10));

} else {
var statearr_27589_27614 = state_27559__$1;
(statearr_27589_27614[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27590 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27590[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27590[(1)] = (1));

return statearr_27590;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27559){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27559);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27591){var ex__2687__auto__ = e27591;
var statearr_27592_27615 = state_27559;
(statearr_27592_27615[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27559[(4)]))){
var statearr_27593_27616 = state_27559;
(statearr_27593_27616[(1)] = cljs.core.first.call(null,(state_27559[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27617 = state_27559;
state_27559 = G__27617;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27559){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27594 = f__2707__auto__.call(null);
(statearr_27594[(6)] = c__2706__auto__);

return statearr_27594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27624){
var state_val_27625 = (state_27624[(1)]);
if((state_val_27625 === (1))){
var inst_27618 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_27619 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27620 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27621 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27619),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27620)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27622 = fluree.db.util.log.debug.call(null,inst_27621);
var state_27624__$1 = (function (){var statearr_27626 = state_27624;
(statearr_27626[(7)] = inst_27622);

(statearr_27626[(8)] = inst_27618);

return statearr_27626;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27624__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27627 = [null,null,null,null,null,null,null,null,null];
(statearr_27627[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27627[(1)] = (1));

return statearr_27627;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27624){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27628){var ex__2687__auto__ = e27628;
var statearr_27629_27632 = state_27624;
(statearr_27629_27632[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27624[(4)]))){
var statearr_27630_27633 = state_27624;
(statearr_27630_27633[(1)] = cljs.core.first.call(null,(state_27624[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27634 = state_27624;
state_27624 = G__27634;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27624){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27631 = f__2707__auto__.call(null);
(statearr_27631[(6)] = c__2706__auto__);

return statearr_27631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27636 = arguments.length;
switch (G__27636) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27637){
var map__27638 = p__27637;
var map__27638__$1 = cljs.core.__destructure_map.call(null,map__27638);
var session = map__27638__$1;
var conn = cljs.core.get.call(null,map__27638__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__27638__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__27638__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__27638__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__27638__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27638__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.call(null,map__27638__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27691){
var state_val_27692 = (state_27691[(1)]);
if((state_val_27692 === (7))){
var inst_27687 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
var statearr_27693_27724 = state_27691__$1;
(statearr_27693_27724[(2)] = inst_27687);

(statearr_27693_27724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (1))){
var state_27691__$1 = state_27691;
var statearr_27694_27725 = state_27691__$1;
(statearr_27694_27725[(2)] = null);

(statearr_27694_27725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (4))){
var inst_27643 = (state_27691[(7)]);
var inst_27642 = (state_27691[(2)]);
var inst_27643__$1 = fluree.db.util.async.throw_err.call(null,inst_27642);
var inst_27644 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_27645 = (inst_27643__$1 == null);
var state_27691__$1 = (function (){var statearr_27695 = state_27691;
(statearr_27695[(8)] = inst_27644);

(statearr_27695[(7)] = inst_27643__$1);

return statearr_27695;
})();
if(cljs.core.truth_(inst_27645)){
var statearr_27696_27726 = state_27691__$1;
(statearr_27696_27726[(1)] = (5));

} else {
var statearr_27697_27727 = state_27691__$1;
(statearr_27697_27727[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (15))){
var inst_27679 = (state_27691[(2)]);
var state_27691__$1 = (function (){var statearr_27698 = state_27691;
(statearr_27698[(9)] = inst_27679);

return statearr_27698;
})();
var statearr_27699_27728 = state_27691__$1;
(statearr_27699_27728[(2)] = null);

(statearr_27699_27728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (13))){
var inst_27683 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
var statearr_27701_27729 = state_27691__$1;
(statearr_27701_27729[(2)] = inst_27683);

(statearr_27701_27729[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (6))){
var inst_27644 = (state_27691[(8)]);
var inst_27650 = (inst_27644 == null);
var state_27691__$1 = state_27691;
if(cljs.core.truth_(inst_27650)){
var statearr_27702_27730 = state_27691__$1;
(statearr_27702_27730[(1)] = (8));

} else {
var statearr_27703_27731 = state_27691__$1;
(statearr_27703_27731[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (17))){
var _ = (function (){var statearr_27704 = state_27691;
(statearr_27704[(4)] = cljs.core.rest.call(null,(state_27691[(4)])));

return statearr_27704;
})();
var state_27691__$1 = state_27691;
var ex27700 = (state_27691__$1[(2)]);
var statearr_27705_27732 = state_27691__$1;
(statearr_27705_27732[(5)] = ex27700);


var statearr_27706_27733 = state_27691__$1;
(statearr_27706_27733[(1)] = (16));

(statearr_27706_27733[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (3))){
var inst_27689 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27691__$1,inst_27689);
} else {
if((state_val_27692 === (12))){
var state_27691__$1 = state_27691;
var statearr_27707_27734 = state_27691__$1;
(statearr_27707_27734[(2)] = null);

(statearr_27707_27734[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (2))){
var state_27691__$1 = state_27691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27691__$1,(4),update_chan);
} else {
if((state_val_27692 === (11))){
var state_27691__$1 = state_27691;
var statearr_27708_27735 = state_27691__$1;
(statearr_27708_27735[(2)] = null);

(statearr_27708_27735[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (9))){
var state_27691__$1 = state_27691;
var statearr_27709_27736 = state_27691__$1;
(statearr_27709_27736[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (5))){
var inst_27647 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27648 = fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27647);
var state_27691__$1 = state_27691;
var statearr_27711_27737 = state_27691__$1;
(statearr_27711_27737[(2)] = inst_27648);

(statearr_27711_27737[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (14))){
var inst_27644 = (state_27691[(8)]);
var inst_27643 = (state_27691[(7)]);
var _ = (function (){var statearr_27712 = state_27691;
(statearr_27712[(4)] = cljs.core.cons.call(null,(17),(state_27691[(4)])));

return statearr_27712;
})();
var inst_27667 = cljs.core.nth.call(null,inst_27643,(0),null);
var inst_27668 = cljs.core.nth.call(null,inst_27643,(1),null);
var inst_27669 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27670 = cljs.core.pr_str.call(null,inst_27643);
var inst_27671 = fluree.db.util.core.trunc.call(null,inst_27670,(200));
var inst_27672 = fluree.db.util.log.trace.call(null,inst_27669,inst_27671);
var inst_27673 = fluree.db.session.process_ledger_update.call(null,inst_27644,inst_27667,inst_27668);
var state_27691__$1 = (function (){var statearr_27713 = state_27691;
(statearr_27713[(10)] = inst_27672);

return statearr_27713;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27691__$1,(18),inst_27673);
} else {
if((state_val_27692 === (16))){
var inst_27643 = (state_27691[(7)]);
var inst_27657 = (state_27691[(2)]);
var inst_27658 = fluree.db.util.log.error.call(null,inst_27657,"Exception processing ledger updates for message: ",inst_27643);
var state_27691__$1 = state_27691;
var statearr_27714_27738 = state_27691__$1;
(statearr_27714_27738[(2)] = inst_27658);

(statearr_27714_27738[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (10))){
var inst_27685 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
var statearr_27715_27739 = state_27691__$1;
(statearr_27715_27739[(2)] = inst_27685);

(statearr_27715_27739[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (18))){
var inst_27675 = (state_27691[(2)]);
var inst_27676 = fluree.db.util.async.throw_err.call(null,inst_27675);
var _ = (function (){var statearr_27716 = state_27691;
(statearr_27716[(4)] = cljs.core.rest.call(null,(state_27691[(4)])));

return statearr_27716;
})();
var state_27691__$1 = state_27691;
var statearr_27717_27740 = state_27691__$1;
(statearr_27717_27740[(2)] = inst_27676);

(statearr_27717_27740[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (8))){
var inst_27643 = (state_27691[(7)]);
var inst_27652 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27653 = cljs.core.first.call(null,inst_27643);
var inst_27654 = fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27652,"Message: ",inst_27653);
var state_27691__$1 = state_27691;
var statearr_27718_27741 = state_27691__$1;
(statearr_27718_27741[(2)] = inst_27654);

(statearr_27718_27741[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0 = (function (){
var statearr_27719 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27719[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__);

(statearr_27719[(1)] = (1));

return statearr_27719;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1 = (function (state_27691){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27720){var ex__2687__auto__ = e27720;
var statearr_27721_27742 = state_27691;
(statearr_27721_27742[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27691[(4)]))){
var statearr_27722_27743 = state_27691;
(statearr_27722_27743[(1)] = cljs.core.first.call(null,(state_27691[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27744 = state_27691;
state_27691 = G__27744;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__ = function(state_27691){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1.call(this,state_27691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2684__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27723 = f__2707__auto__.call(null);
(statearr_27723[(6)] = c__2706__auto__);

return statearr_27723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27745){
var map__27746 = p__27745;
var map__27746__$1 = cljs.core.__destructure_map.call(null,map__27746);
var network = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__27746__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.call(null),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null),network,null,conn]));
var current_db_fn = cljs.core.partial.call(null,fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27750 = block_result;
var map__27750__$1 = cljs.core.__destructure_map.call(null,map__27750);
var block = cljs.core.get.call(null,map__27750__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__27750__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__27750__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__27750__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__27750__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__27751 = tx_result;
var map__27751__$1 = cljs.core.__destructure_map.call(null,map__27751);
var t = cljs.core.get.call(null,map__27751__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__27751__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__27747_SHARP_){
return cljs.core._EQ_.call(null,t,fluree.db.flake.t.call(null,p1__27747_SHARP_));
}):(function (p1__27748_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__27748_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__27749_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__27749_SHARP_))){
return cljs.core.nth.call(null,p1__27749_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27752 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__27752,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__27752,(1),null);
var error = cljs.core.nth.call(null,vec__27752,(2),null);
var message = cljs.core.nth.call(null,vec__27752,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));

var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27756 = arguments.length;
switch (G__27756) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27757){
var map__27758 = p__27757;
var map__27758__$1 = cljs.core.__destructure_map.call(null,map__27758);
var state = cljs.core.get.call(null,map__27758__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__27758__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__27758__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__27758__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27759 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__27759,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__27759,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__27759,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27762 = cljs.core.seq.call(null,tids);
var chunk__27763 = null;
var count__27764 = (0);
var i__27765 = (0);
while(true){
if((i__27765 < count__27764)){
var tid = cljs.core._nth.call(null,chunk__27763,i__27765);
var temp__5804__auto___27878__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27878__$1)){
var keyed_callbacks_27879 = temp__5804__auto___27878__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27880 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27806_27881 = cljs.core.seq.call(null,keyed_callbacks_27879);
var chunk__27807_27882 = null;
var count__27808_27883 = (0);
var i__27809_27884 = (0);
while(true){
if((i__27809_27884 < count__27808_27883)){
var vec__27818_27885 = cljs.core._nth.call(null,chunk__27807_27882,i__27809_27884);
var k_27886 = cljs.core.nth.call(null,vec__27818_27885,(0),null);
var f_27887 = cljs.core.nth.call(null,vec__27818_27885,(1),null);
try{f_27887.call(null,tx_response_27880);
}catch (e27821){var e_27888 = e27821;
fluree.db.util.log.error.call(null,e_27888,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27889 = seq__27806_27881;
var G__27890 = chunk__27807_27882;
var G__27891 = count__27808_27883;
var G__27892 = (i__27809_27884 + (1));
seq__27806_27881 = G__27889;
chunk__27807_27882 = G__27890;
count__27808_27883 = G__27891;
i__27809_27884 = G__27892;
continue;
} else {
var temp__5804__auto___27893__$2 = cljs.core.seq.call(null,seq__27806_27881);
if(temp__5804__auto___27893__$2){
var seq__27806_27894__$1 = temp__5804__auto___27893__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27806_27894__$1)){
var c__5568__auto___27895 = cljs.core.chunk_first.call(null,seq__27806_27894__$1);
var G__27896 = cljs.core.chunk_rest.call(null,seq__27806_27894__$1);
var G__27897 = c__5568__auto___27895;
var G__27898 = cljs.core.count.call(null,c__5568__auto___27895);
var G__27899 = (0);
seq__27806_27881 = G__27896;
chunk__27807_27882 = G__27897;
count__27808_27883 = G__27898;
i__27809_27884 = G__27899;
continue;
} else {
var vec__27822_27900 = cljs.core.first.call(null,seq__27806_27894__$1);
var k_27901 = cljs.core.nth.call(null,vec__27822_27900,(0),null);
var f_27902 = cljs.core.nth.call(null,vec__27822_27900,(1),null);
try{f_27902.call(null,tx_response_27880);
}catch (e27825){var e_27903 = e27825;
fluree.db.util.log.error.call(null,e_27903,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27904 = cljs.core.next.call(null,seq__27806_27894__$1);
var G__27905 = null;
var G__27906 = (0);
var G__27907 = (0);
seq__27806_27881 = G__27904;
chunk__27807_27882 = G__27905;
count__27808_27883 = G__27906;
i__27809_27884 = G__27907;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27908 = seq__27762;
var G__27909 = chunk__27763;
var G__27910 = count__27764;
var G__27911 = (i__27765 + (1));
seq__27762 = G__27908;
chunk__27763 = G__27909;
count__27764 = G__27910;
i__27765 = G__27911;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__27762);
if(temp__5804__auto____$1){
var seq__27762__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27762__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27762__$1);
var G__27912 = cljs.core.chunk_rest.call(null,seq__27762__$1);
var G__27913 = c__5568__auto__;
var G__27914 = cljs.core.count.call(null,c__5568__auto__);
var G__27915 = (0);
seq__27762 = G__27912;
chunk__27763 = G__27913;
count__27764 = G__27914;
i__27765 = G__27915;
continue;
} else {
var tid = cljs.core.first.call(null,seq__27762__$1);
var temp__5804__auto___27916__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27916__$2)){
var keyed_callbacks_27917 = temp__5804__auto___27916__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27918 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27826_27919 = cljs.core.seq.call(null,keyed_callbacks_27917);
var chunk__27827_27920 = null;
var count__27828_27921 = (0);
var i__27829_27922 = (0);
while(true){
if((i__27829_27922 < count__27828_27921)){
var vec__27838_27923 = cljs.core._nth.call(null,chunk__27827_27920,i__27829_27922);
var k_27924 = cljs.core.nth.call(null,vec__27838_27923,(0),null);
var f_27925 = cljs.core.nth.call(null,vec__27838_27923,(1),null);
try{f_27925.call(null,tx_response_27918);
}catch (e27841){var e_27926 = e27841;
fluree.db.util.log.error.call(null,e_27926,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27927 = seq__27826_27919;
var G__27928 = chunk__27827_27920;
var G__27929 = count__27828_27921;
var G__27930 = (i__27829_27922 + (1));
seq__27826_27919 = G__27927;
chunk__27827_27920 = G__27928;
count__27828_27921 = G__27929;
i__27829_27922 = G__27930;
continue;
} else {
var temp__5804__auto___27931__$3 = cljs.core.seq.call(null,seq__27826_27919);
if(temp__5804__auto___27931__$3){
var seq__27826_27932__$1 = temp__5804__auto___27931__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27826_27932__$1)){
var c__5568__auto___27933 = cljs.core.chunk_first.call(null,seq__27826_27932__$1);
var G__27934 = cljs.core.chunk_rest.call(null,seq__27826_27932__$1);
var G__27935 = c__5568__auto___27933;
var G__27936 = cljs.core.count.call(null,c__5568__auto___27933);
var G__27937 = (0);
seq__27826_27919 = G__27934;
chunk__27827_27920 = G__27935;
count__27828_27921 = G__27936;
i__27829_27922 = G__27937;
continue;
} else {
var vec__27842_27938 = cljs.core.first.call(null,seq__27826_27932__$1);
var k_27939 = cljs.core.nth.call(null,vec__27842_27938,(0),null);
var f_27940 = cljs.core.nth.call(null,vec__27842_27938,(1),null);
try{f_27940.call(null,tx_response_27918);
}catch (e27845){var e_27941 = e27845;
fluree.db.util.log.error.call(null,e_27941,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27942 = cljs.core.next.call(null,seq__27826_27932__$1);
var G__27943 = null;
var G__27944 = (0);
var G__27945 = (0);
seq__27826_27919 = G__27942;
chunk__27827_27920 = G__27943;
count__27828_27921 = G__27944;
i__27829_27922 = G__27945;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27946 = cljs.core.next.call(null,seq__27762__$1);
var G__27947 = null;
var G__27948 = (0);
var G__27949 = (0);
seq__27762 = G__27946;
chunk__27763 = G__27947;
count__27764 = G__27948;
i__27765 = G__27949;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27950 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2706__auto___27951 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27862){
var state_val_27863 = (state_27862[(1)]);
if((state_val_27863 === (1))){
var state_27862__$1 = state_27862;
var statearr_27864_27952 = state_27862__$1;
(statearr_27864_27952[(2)] = null);

(statearr_27864_27952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (2))){
var inst_27847 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27862__$1 = state_27862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27862__$1,(4),inst_27847);
} else {
if((state_val_27863 === (3))){
var inst_27860 = (state_27862[(2)]);
var state_27862__$1 = state_27862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27862__$1,inst_27860);
} else {
if((state_val_27863 === (4))){
var inst_27849 = (state_27862[(7)]);
var inst_27849__$1 = (state_27862[(2)]);
var inst_27850 = (inst_27849__$1 == null);
var state_27862__$1 = (function (){var statearr_27865 = state_27862;
(statearr_27865[(7)] = inst_27849__$1);

return statearr_27865;
})();
if(cljs.core.truth_(inst_27850)){
var statearr_27866_27953 = state_27862__$1;
(statearr_27866_27953[(1)] = (5));

} else {
var statearr_27867_27954 = state_27862__$1;
(statearr_27867_27954[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (5))){
var inst_27852 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27853 = fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_27852);
var state_27862__$1 = state_27862;
var statearr_27868_27955 = state_27862__$1;
(statearr_27868_27955[(2)] = inst_27853);

(statearr_27868_27955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (6))){
var inst_27849 = (state_27862[(7)]);
var inst_27855 = transact_handler_27950.call(null,conn,inst_27849);
var state_27862__$1 = (function (){var statearr_27869 = state_27862;
(statearr_27869[(8)] = inst_27855);

return statearr_27869;
})();
var statearr_27870_27956 = state_27862__$1;
(statearr_27870_27956[(2)] = null);

(statearr_27870_27956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27863 === (7))){
var inst_27858 = (state_27862[(2)]);
var state_27862__$1 = state_27862;
var statearr_27871_27957 = state_27862__$1;
(statearr_27871_27957[(2)] = inst_27858);

(statearr_27871_27957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2684__auto__ = null;
var fluree$db$session$state_machine__2684__auto____0 = (function (){
var statearr_27872 = [null,null,null,null,null,null,null,null,null];
(statearr_27872[(0)] = fluree$db$session$state_machine__2684__auto__);

(statearr_27872[(1)] = (1));

return statearr_27872;
});
var fluree$db$session$state_machine__2684__auto____1 = (function (state_27862){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27873){var ex__2687__auto__ = e27873;
var statearr_27874_27958 = state_27862;
(statearr_27874_27958[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27862[(4)]))){
var statearr_27875_27959 = state_27862;
(statearr_27875_27959[(1)] = cljs.core.first.call(null,(state_27862[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27960 = state_27862;
state_27862 = G__27960;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$session$state_machine__2684__auto__ = function(state_27862){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2684__auto____1.call(this,state_27862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2684__auto____0;
fluree$db$session$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2684__auto____1;
return fluree$db$session$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27876 = f__2707__auto__.call(null);
(statearr_27876[(6)] = c__2706__auto___27951);

return statearr_27876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27963 = arguments.length;
switch (G__27963) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27964 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__27961_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__27961_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27964);
} else {
return G__27964;
}
})();
var seq__27965 = cljs.core.seq.call(null,sessions);
var chunk__27966 = null;
var count__27967 = (0);
var i__27968 = (0);
while(true){
if((i__27968 < count__27967)){
var session = cljs.core._nth.call(null,chunk__27966,i__27968);
fluree.db.session.close.call(null,session);


var G__27970 = seq__27965;
var G__27971 = chunk__27966;
var G__27972 = count__27967;
var G__27973 = (i__27968 + (1));
seq__27965 = G__27970;
chunk__27966 = G__27971;
count__27967 = G__27972;
i__27968 = G__27973;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__27965);
if(temp__5804__auto__){
var seq__27965__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27965__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27965__$1);
var G__27974 = cljs.core.chunk_rest.call(null,seq__27965__$1);
var G__27975 = c__5568__auto__;
var G__27976 = cljs.core.count.call(null,c__5568__auto__);
var G__27977 = (0);
seq__27965 = G__27974;
chunk__27966 = G__27975;
count__27967 = G__27976;
i__27968 = G__27977;
continue;
} else {
var session = cljs.core.first.call(null,seq__27965__$1);
fluree.db.session.close.call(null,session);


var G__27978 = cljs.core.next.call(null,seq__27965__$1);
var G__27979 = null;
var G__27980 = (0);
var G__27981 = (0);
seq__27965 = G__27978;
chunk__27966 = G__27979;
count__27967 = G__27980;
i__27968 = G__27981;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
