// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__20536,error_ch,vars,p__20537,parse_json_QMARK_){
var map__20538 = p__20536;
var map__20538__$1 = cljs.core.__destructure_map.call(null,map__20538);
var db = map__20538__$1;
var conn = cljs.core.get.call(null,map__20538__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.call(null,map__20538__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.call(null,map__20538__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__20539 = p__20537;
var map__20539__$1 = cljs.core.__destructure_map.call(null,map__20539);
var _where_clause = map__20539__$1;
var p = cljs.core.get.call(null,map__20539__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__20539__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.call(null,map__20539__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
fluree.db.util.log.debug.call(null,"subjects-chan");

var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.call(null,vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__20540 = (function (){var G__20543 = idx;
var G__20543__$1 = (((G__20543 instanceof cljs.core.Keyword))?G__20543.fqn:null);
switch (G__20543__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20543__$1)].join('')));

}
})();
var fflake = cljs.core.nth.call(null,vec__20540,(0),null);
var lflake = cljs.core.nth.call(null,vec__20540,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__20534_SHARP_){
return cljs.core._EQ_.call(null,o_STAR_,fluree.db.flake.o.call(null,p1__20534_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.call(null,o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__20535_SHARP_){
return f.call(null,fluree.db.flake.o.call(null,p1__20535_SHARP_));
});
})():null));
var idx_root = cljs.core.get.call(null,db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,fflake,lflake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var xf = (cljs.core.truth_(filter_fn)?cljs.core.map.call(null,(function (flakes){
return cljs.core.filter.call(null,filter_fn,flakes);
})):null);
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),xf], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,cljs.core.get.call(null,novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.call(null,resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.call(null,(10),cljs.core.comp.call(null,cljs.core.map.call(null,fluree.db.flake.s),cljs.core.dedupe.call(null)));
var c__2706__auto___20613 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20582){
var state_val_20583 = (state_20582[(1)]);
if((state_val_20583 === (7))){
var inst_20578 = (state_20582[(2)]);
var state_20582__$1 = state_20582;
var statearr_20584_20614 = state_20582__$1;
(statearr_20584_20614[(2)] = inst_20578);

(statearr_20584_20614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (1))){
var state_20582__$1 = state_20582;
var statearr_20585_20615 = state_20582__$1;
(statearr_20585_20615[(2)] = null);

(statearr_20585_20615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (4))){
var inst_20546 = (state_20582[(7)]);
var inst_20546__$1 = (state_20582[(2)]);
var inst_20547 = (inst_20546__$1 == null);
var state_20582__$1 = (function (){var statearr_20586 = state_20582;
(statearr_20586[(7)] = inst_20546__$1);

return statearr_20586;
})();
if(cljs.core.truth_(inst_20547)){
var statearr_20587_20616 = state_20582__$1;
(statearr_20587_20616[(1)] = (5));

} else {
var statearr_20588_20617 = state_20582__$1;
(statearr_20588_20617[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (15))){
var state_20582__$1 = state_20582;
var statearr_20589_20618 = state_20582__$1;
(statearr_20589_20618[(2)] = false);

(statearr_20589_20618[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (13))){
var inst_20558 = (state_20582[(2)]);
var state_20582__$1 = state_20582;
if(cljs.core.truth_(inst_20558)){
var statearr_20590_20619 = state_20582__$1;
(statearr_20590_20619[(1)] = (14));

} else {
var statearr_20591_20620 = state_20582__$1;
(statearr_20591_20620[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (6))){
var inst_20546 = (state_20582[(7)]);
var inst_20551 = cljs.core.seq.call(null,inst_20546);
var inst_20552 = inst_20551;
var inst_20553 = (0);
var state_20582__$1 = (function (){var statearr_20592 = state_20582;
(statearr_20592[(8)] = inst_20553);

(statearr_20592[(9)] = inst_20552);

return statearr_20592;
})();
var statearr_20593_20621 = state_20582__$1;
(statearr_20593_20621[(2)] = null);

(statearr_20593_20621[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (17))){
var state_20582__$1 = state_20582;
var statearr_20594_20622 = state_20582__$1;
(statearr_20594_20622[(2)] = null);

(statearr_20594_20622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (3))){
var inst_20580 = (state_20582[(2)]);
var state_20582__$1 = state_20582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20582__$1,inst_20580);
} else {
if((state_val_20583 === (12))){
var inst_20568 = (state_20582[(2)]);
var state_20582__$1 = state_20582;
var statearr_20595_20623 = state_20582__$1;
(statearr_20595_20623[(2)] = inst_20568);

(statearr_20595_20623[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (2))){
var state_20582__$1 = state_20582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20582__$1,(4),tree_chan);
} else {
if((state_val_20583 === (19))){
var inst_20576 = (state_20582[(2)]);
var state_20582__$1 = state_20582;
var statearr_20596_20624 = state_20582__$1;
(statearr_20596_20624[(2)] = inst_20576);

(statearr_20596_20624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (11))){
var state_20582__$1 = state_20582;
var statearr_20597_20625 = state_20582__$1;
(statearr_20597_20625[(2)] = true);

(statearr_20597_20625[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (9))){
var inst_20570 = (state_20582[(2)]);
var state_20582__$1 = state_20582;
if(cljs.core.truth_(inst_20570)){
var statearr_20598_20626 = state_20582__$1;
(statearr_20598_20626[(1)] = (17));

} else {
var statearr_20599_20627 = state_20582__$1;
(statearr_20599_20627[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (5))){
var inst_20549 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_20582__$1 = state_20582;
var statearr_20600_20628 = state_20582__$1;
(statearr_20600_20628[(2)] = inst_20549);

(statearr_20600_20628[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (14))){
var inst_20553 = (state_20582[(8)]);
var inst_20552 = (state_20582[(9)]);
var inst_20560 = cljs.core.next.call(null,inst_20552);
var inst_20561 = (inst_20553 + (1));
var inst_20552__$1 = inst_20560;
var inst_20553__$1 = inst_20561;
var state_20582__$1 = (function (){var statearr_20601 = state_20582;
(statearr_20601[(8)] = inst_20553__$1);

(statearr_20601[(9)] = inst_20552__$1);

return statearr_20601;
})();
var statearr_20602_20629 = state_20582__$1;
(statearr_20602_20629[(2)] = null);

(statearr_20602_20629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (16))){
var inst_20565 = (state_20582[(2)]);
var state_20582__$1 = state_20582;
var statearr_20603_20630 = state_20582__$1;
(statearr_20603_20630[(2)] = inst_20565);

(statearr_20603_20630[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (10))){
var inst_20552 = (state_20582[(9)]);
var inst_20556 = cljs.core.first.call(null,inst_20552);
var state_20582__$1 = state_20582;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20582__$1,(13),return_chan,inst_20556);
} else {
if((state_val_20583 === (18))){
var inst_20574 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_20582__$1 = state_20582;
var statearr_20604_20631 = state_20582__$1;
(statearr_20604_20631[(2)] = inst_20574);

(statearr_20604_20631[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20583 === (8))){
var inst_20552 = (state_20582[(9)]);
var state_20582__$1 = state_20582;
if(cljs.core.truth_(inst_20552)){
var statearr_20605_20632 = state_20582__$1;
(statearr_20605_20632[(1)] = (10));

} else {
var statearr_20606_20633 = state_20582__$1;
(statearr_20606_20633[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0 = (function (){
var statearr_20607 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20607[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__);

(statearr_20607[(1)] = (1));

return statearr_20607;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1 = (function (state_20582){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20608){var ex__2687__auto__ = e20608;
var statearr_20609_20634 = state_20582;
(statearr_20609_20634[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20582[(4)]))){
var statearr_20610_20635 = state_20582;
(statearr_20610_20635[(1)] = cljs.core.first.call(null,(state_20582[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20636 = state_20582;
state_20582 = G__20636;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__ = function(state_20582){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1.call(this,state_20582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20611 = f__2707__auto__.call(null);
(statearr_20611[(6)] = c__2706__auto___20613);

return statearr_20611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__20637){
var map__20638 = p__20637;
var map__20638__$1 = cljs.core.__destructure_map.call(null,map__20638);
var _opts = map__20638__$1;
var db = cljs.core.get.call(null,map__20638__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.call(null,map__20638__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__20638__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.call(null,map__20638__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.call(null,map__20638__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.call(null,map__20638__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.call(null,map__20638__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn.call(null,db):null);
return (function (sid,port){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20683){
var state_val_20684 = (state_20683[(1)]);
if((state_val_20684 === (7))){
var inst_20654 = (state_20683[(7)]);
var inst_20656 = fluree.db.query.subject_crawl.common.filter_subject.call(null,vars,filter_map,inst_20654);
var state_20683__$1 = state_20683;
var statearr_20685_20721 = state_20683__$1;
(statearr_20685_20721[(2)] = inst_20656);

(statearr_20685_20721[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (1))){
var state_20683__$1 = state_20683;
var statearr_20686_20722 = state_20683__$1;
(statearr_20686_20722[(2)] = null);

(statearr_20686_20722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (4))){
var inst_20639 = (state_20683[(2)]);
var inst_20640 = cljs.core.async.put_BANG_.call(null,error_ch,inst_20639);
var inst_20641 = cljs.core.async.close_BANG_.call(null,port);
var state_20683__$1 = (function (){var statearr_20687 = state_20683;
(statearr_20687[(8)] = inst_20641);

(statearr_20687[(9)] = inst_20640);

return statearr_20687;
})();
var statearr_20688_20723 = state_20683__$1;
(statearr_20688_20723[(2)] = null);

(statearr_20688_20723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (15))){
var inst_20671 = (state_20683[(10)]);
var inst_20671__$1 = (state_20683[(2)]);
var inst_20672 = cljs.core.seq.call(null,inst_20671__$1);
var state_20683__$1 = (function (){var statearr_20689 = state_20683;
(statearr_20689[(10)] = inst_20671__$1);

return statearr_20689;
})();
if(inst_20672){
var statearr_20690_20724 = state_20683__$1;
(statearr_20690_20724[(1)] = (17));

} else {
var statearr_20691_20725 = state_20683__$1;
(statearr_20691_20725[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (13))){
var inst_20664 = (state_20683[(11)]);
var state_20683__$1 = state_20683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20683__$1,(16),inst_20664);
} else {
if((state_val_20684 === (6))){
var inst_20653 = (state_20683[(2)]);
var inst_20654 = fluree.db.util.async.throw_err.call(null,inst_20653);
var state_20683__$1 = (function (){var statearr_20692 = state_20683;
(statearr_20692[(7)] = inst_20654);

return statearr_20692;
})();
if(cljs.core.truth_(filter_map)){
var statearr_20693_20726 = state_20683__$1;
(statearr_20693_20726[(1)] = (7));

} else {
var statearr_20694_20727 = state_20683__$1;
(statearr_20694_20727[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (17))){
var inst_20671 = (state_20683[(10)]);
var inst_20674 = cljs.core.async.put_BANG_.call(null,port,inst_20671);
var state_20683__$1 = state_20683;
var statearr_20695_20728 = state_20683__$1;
(statearr_20695_20728[(2)] = inst_20674);

(statearr_20695_20728[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (3))){
var inst_20681 = (state_20683[(2)]);
var state_20683__$1 = state_20683;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20683__$1,inst_20681);
} else {
if((state_val_20684 === (12))){
var inst_20664 = (state_20683[(2)]);
var state_20683__$1 = (function (){var statearr_20696 = state_20683;
(statearr_20696[(11)] = inst_20664);

return statearr_20696;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_20697_20729 = state_20683__$1;
(statearr_20697_20729[(1)] = (13));

} else {
var statearr_20698_20730 = state_20683__$1;
(statearr_20698_20730[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (2))){
var _ = (function (){var statearr_20699 = state_20683;
(statearr_20699[(4)] = cljs.core.cons.call(null,(5),(state_20683[(4)])));

return statearr_20699;
})();
var inst_20648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20649 = [sid];
var inst_20650 = (new cljs.core.PersistentVector(null,1,(5),inst_20648,inst_20649,null));
var inst_20651 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20650);
var state_20683__$1 = state_20683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20683__$1,(6),inst_20651);
} else {
if((state_val_20684 === (19))){
var inst_20677 = (state_20683[(2)]);
var inst_20678 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_20700 = state_20683;
(statearr_20700[(4)] = cljs.core.rest.call(null,(state_20683[(4)])));

return statearr_20700;
})();
var state_20683__$1 = (function (){var statearr_20701 = state_20683;
(statearr_20701[(12)] = inst_20677);

return statearr_20701;
})();
var statearr_20702_20731 = state_20683__$1;
(statearr_20702_20731[(2)] = inst_20678);

(statearr_20702_20731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (11))){
var inst_20659 = (state_20683[(13)]);
var state_20683__$1 = state_20683;
var statearr_20704_20732 = state_20683__$1;
(statearr_20704_20732[(2)] = inst_20659);

(statearr_20704_20732[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (9))){
var inst_20659 = (state_20683[(2)]);
var state_20683__$1 = (function (){var statearr_20705 = state_20683;
(statearr_20705[(13)] = inst_20659);

return statearr_20705;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_20706_20733 = state_20683__$1;
(statearr_20706_20733[(1)] = (10));

} else {
var statearr_20707_20734 = state_20683__$1;
(statearr_20707_20734[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (5))){
var _ = (function (){var statearr_20708 = state_20683;
(statearr_20708[(4)] = cljs.core.rest.call(null,(state_20683[(4)])));

return statearr_20708;
})();
var state_20683__$1 = state_20683;
var ex20703 = (state_20683__$1[(2)]);
var statearr_20709_20735 = state_20683__$1;
(statearr_20709_20735[(5)] = ex20703);


var statearr_20710_20736 = state_20683__$1;
(statearr_20710_20736[(1)] = (4));

(statearr_20710_20736[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (14))){
var inst_20664 = (state_20683[(11)]);
var state_20683__$1 = state_20683;
var statearr_20711_20737 = state_20683__$1;
(statearr_20711_20737[(2)] = inst_20664);

(statearr_20711_20737[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (16))){
var inst_20667 = (state_20683[(2)]);
var inst_20668 = fluree.db.util.async.throw_err.call(null,inst_20667);
var state_20683__$1 = state_20683;
var statearr_20712_20738 = state_20683__$1;
(statearr_20712_20738[(2)] = inst_20668);

(statearr_20712_20738[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (10))){
var inst_20659 = (state_20683[(13)]);
var inst_20661 = permissions.call(null,inst_20659);
var state_20683__$1 = state_20683;
var statearr_20713_20739 = state_20683__$1;
(statearr_20713_20739[(2)] = inst_20661);

(statearr_20713_20739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (18))){
var state_20683__$1 = state_20683;
var statearr_20714_20740 = state_20683__$1;
(statearr_20714_20740[(2)] = null);

(statearr_20714_20740[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20684 === (8))){
var inst_20654 = (state_20683[(7)]);
var state_20683__$1 = state_20683;
var statearr_20715_20741 = state_20683__$1;
(statearr_20715_20741[(2)] = inst_20654);

(statearr_20715_20741[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0 = (function (){
var statearr_20716 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20716[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__);

(statearr_20716[(1)] = (1));

return statearr_20716;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1 = (function (state_20683){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20717){var ex__2687__auto__ = e20717;
var statearr_20718_20742 = state_20683;
(statearr_20718_20742[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20683[(4)]))){
var statearr_20719_20743 = state_20683;
(statearr_20719_20743[(1)] = cljs.core.first.call(null,(state_20683[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20744 = state_20683;
state_20683 = G__20744;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__ = function(state_20683){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1.call(this,state_20683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20720 = f__2707__auto__.call(null);
(statearr_20720[(6)] = c__2706__auto__);

return statearr_20720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__20745){
var map__20746 = p__20745;
var map__20746__$1 = cljs.core.__destructure_map.call(null,map__20746);
var f_where = map__20746__$1;
var o = cljs.core.get.call(null,map__20746__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
fluree.db.util.log.debug.call(null,"subjects-id-chan f-where:",f_where);

var return_ch = cljs.core.async.chan.call(null);
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.call(null,["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2706__auto___20783 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20766){
var state_val_20767 = (state_20766[(1)]);
if((state_val_20767 === (7))){
var inst_20754 = (state_20766[(7)]);
var inst_20757 = cljs.core.async.put_BANG_.call(null,error_ch,inst_20754);
var state_20766__$1 = state_20766;
var statearr_20768_20784 = state_20766__$1;
(statearr_20768_20784[(2)] = inst_20757);

(statearr_20768_20784[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20767 === (1))){
var inst_20747 = typeof _id_val === 'number';
var state_20766__$1 = state_20766;
if(cljs.core.truth_(inst_20747)){
var statearr_20769_20785 = state_20766__$1;
(statearr_20769_20785[(1)] = (2));

} else {
var statearr_20770_20786 = state_20766__$1;
(statearr_20770_20786[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20767 === (4))){
var inst_20763 = (state_20766[(2)]);
var inst_20764 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_20766__$1 = (function (){var statearr_20771 = state_20766;
(statearr_20771[(8)] = inst_20763);

return statearr_20771;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20766__$1,inst_20764);
} else {
if((state_val_20767 === (6))){
var inst_20754 = (state_20766[(7)]);
var inst_20754__$1 = (state_20766[(2)]);
var inst_20755 = fluree.db.util.core.exception_QMARK_.call(null,inst_20754__$1);
var state_20766__$1 = (function (){var statearr_20772 = state_20766;
(statearr_20772[(7)] = inst_20754__$1);

return statearr_20772;
})();
if(inst_20755){
var statearr_20773_20787 = state_20766__$1;
(statearr_20773_20787[(1)] = (7));

} else {
var statearr_20774_20788 = state_20766__$1;
(statearr_20774_20788[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20767 === (3))){
var inst_20752 = fluree.db.dbproto._subid.call(null,db,_id_val);
var state_20766__$1 = state_20766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20766__$1,(6),inst_20752);
} else {
if((state_val_20767 === (2))){
var state_20766__$1 = state_20766;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20766__$1,(5),return_ch,_id_val);
} else {
if((state_val_20767 === (9))){
var inst_20761 = (state_20766[(2)]);
var state_20766__$1 = state_20766;
var statearr_20775_20789 = state_20766__$1;
(statearr_20775_20789[(2)] = inst_20761);

(statearr_20775_20789[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20767 === (5))){
var inst_20750 = (state_20766[(2)]);
var state_20766__$1 = state_20766;
var statearr_20776_20790 = state_20766__$1;
(statearr_20776_20790[(2)] = inst_20750);

(statearr_20776_20790[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20767 === (8))){
var inst_20754 = (state_20766[(7)]);
var inst_20759 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20754);
var state_20766__$1 = state_20766;
var statearr_20777_20791 = state_20766__$1;
(statearr_20777_20791[(2)] = inst_20759);

(statearr_20777_20791[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0 = (function (){
var statearr_20778 = [null,null,null,null,null,null,null,null,null];
(statearr_20778[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__);

(statearr_20778[(1)] = (1));

return statearr_20778;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1 = (function (state_20766){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20779){var ex__2687__auto__ = e20779;
var statearr_20780_20792 = state_20766;
(statearr_20780_20792[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20766[(4)]))){
var statearr_20781_20793 = state_20766;
(statearr_20781_20793[(1)] = cljs.core.first.call(null,(state_20766[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20794 = state_20766;
state_20766 = G__20794;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__ = function(state_20766){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1.call(this,state_20766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20782 = f__2707__auto__.call(null);
(statearr_20782[(6)] = c__2706__auto___20783);

return statearr_20782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return return_ch;
});
/**
 * If the predicate is a ref? type with an 'o' value, it must be resolved into a subject id.
 */
fluree.db.query.subject_crawl.subject.resolve_o_ident = (function fluree$db$query$subject_crawl$subject$resolve_o_ident(db,p__20795){
var map__20796 = p__20795;
var map__20796__$1 = cljs.core.__destructure_map.call(null,map__20796);
var where_clause = map__20796__$1;
var o = cljs.core.get.call(null,map__20796__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20820){
var state_val_20821 = (state_20820[(1)]);
if((state_val_20821 === (7))){
var inst_20807 = (state_20820[(7)]);
var state_20820__$1 = state_20820;
var statearr_20822_20841 = state_20820__$1;
(statearr_20822_20841[(2)] = inst_20807);

(statearr_20822_20841[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20821 === (1))){
var state_20820__$1 = state_20820;
var statearr_20823_20842 = state_20820__$1;
(statearr_20823_20842[(2)] = null);

(statearr_20823_20842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20821 === (4))){
var inst_20797 = (state_20820[(2)]);
var state_20820__$1 = state_20820;
var statearr_20824_20843 = state_20820__$1;
(statearr_20824_20843[(2)] = inst_20797);

(statearr_20824_20843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20821 === (6))){
var inst_20807 = (state_20820[(7)]);
var inst_20806 = (state_20820[(2)]);
var inst_20807__$1 = fluree.db.util.async.throw_err.call(null,inst_20806);
var state_20820__$1 = (function (){var statearr_20825 = state_20820;
(statearr_20825[(7)] = inst_20807__$1);

return statearr_20825;
})();
if(cljs.core.truth_(inst_20807__$1)){
var statearr_20826_20844 = state_20820__$1;
(statearr_20826_20844[(1)] = (7));

} else {
var statearr_20827_20845 = state_20820__$1;
(statearr_20827_20845[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20821 === (3))){
var inst_20818 = (state_20820[(2)]);
var state_20820__$1 = state_20820;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20820__$1,inst_20818);
} else {
if((state_val_20821 === (2))){
var _ = (function (){var statearr_20829 = state_20820;
(statearr_20829[(4)] = cljs.core.cons.call(null,(5),(state_20820[(4)])));

return statearr_20829;
})();
var inst_20803 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(o);
var inst_20804 = fluree.db.dbproto._subid.call(null,db,inst_20803);
var state_20820__$1 = state_20820;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20820__$1,(6),inst_20804);
} else {
if((state_val_20821 === (9))){
var inst_20811 = (state_20820[(2)]);
var inst_20812 = [new cljs.core.Keyword(null,"value","value",305978217)];
var inst_20813 = [inst_20811];
var inst_20814 = cljs.core.PersistentHashMap.fromArrays(inst_20812,inst_20813);
var inst_20815 = cljs.core.assoc.call(null,where_clause,new cljs.core.Keyword(null,"o","o",-1350007228),inst_20814);
var _ = (function (){var statearr_20830 = state_20820;
(statearr_20830[(4)] = cljs.core.rest.call(null,(state_20820[(4)])));

return statearr_20830;
})();
var state_20820__$1 = state_20820;
var statearr_20831_20846 = state_20820__$1;
(statearr_20831_20846[(2)] = inst_20815);

(statearr_20831_20846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20821 === (5))){
var _ = (function (){var statearr_20832 = state_20820;
(statearr_20832[(4)] = cljs.core.rest.call(null,(state_20820[(4)])));

return statearr_20832;
})();
var state_20820__$1 = state_20820;
var ex20828 = (state_20820__$1[(2)]);
var statearr_20833_20847 = state_20820__$1;
(statearr_20833_20847[(5)] = ex20828);


if((ex20828 instanceof Error)){
var statearr_20834_20848 = state_20820__$1;
(statearr_20834_20848[(1)] = (4));

(statearr_20834_20848[(5)] = null);

} else {
throw ex20828;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20821 === (8))){
var state_20820__$1 = state_20820;
var statearr_20835_20849 = state_20820__$1;
(statearr_20835_20849[(2)] = (0));

(statearr_20835_20849[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0 = (function (){
var statearr_20836 = [null,null,null,null,null,null,null,null];
(statearr_20836[(0)] = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__);

(statearr_20836[(1)] = (1));

return statearr_20836;
});
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1 = (function (state_20820){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20837){var ex__2687__auto__ = e20837;
var statearr_20838_20850 = state_20820;
(statearr_20838_20850[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20820[(4)]))){
var statearr_20839_20851 = state_20820;
(statearr_20839_20851[(1)] = cljs.core.first.call(null,(state_20820[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20852 = state_20820;
state_20820 = G__20852;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__ = function(state_20820){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1.call(this,state_20820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20840 = f__2707__auto__.call(null);
(statearr_20840[(6)] = c__2706__auto__);

return statearr_20840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__20853){
var map__20854 = p__20853;
var map__20854__$1 = cljs.core.__destructure_map.call(null,map__20854);
var opts = map__20854__$1;
var finish_fn = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var vars = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var f_where = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var parallelism = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var limit = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var ident_vars = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var db = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"db","db",993250759));
var offset = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var error_ch = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var parse_json_QMARK_ = cljs.core.get.call(null,map__20854__$1,new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20949){
var state_val_20950 = (state_20949[(1)]);
if((state_val_20950 === (7))){
var state_20949__$1 = state_20949;
var statearr_20951_21003 = state_20949__$1;
(statearr_20951_21003[(2)] = vars);

(statearr_20951_21003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (20))){
var inst_20902 = (state_20949[(7)]);
var inst_20912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20913 = [error_ch,inst_20902];
var inst_20914 = (new cljs.core.PersistentVector(null,2,(5),inst_20912,inst_20913,null));
var state_20949__$1 = state_20949;
return cljs.core.async.ioc_alts_BANG_.call(null,state_20949__$1,(22),inst_20914);
} else {
if((state_val_20950 === (27))){
var state_20949__$1 = state_20949;
var statearr_20952_21004 = state_20949__$1;
(statearr_20952_21004[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (1))){
var state_20949__$1 = state_20949;
var statearr_20954_21005 = state_20949__$1;
(statearr_20954_21005[(2)] = null);

(statearr_20954_21005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (24))){
var inst_20917 = (state_20949[(8)]);
var inst_20926 = (inst_20917 == null);
var state_20949__$1 = state_20949;
if(cljs.core.truth_(inst_20926)){
var statearr_20955_21006 = state_20949__$1;
(statearr_20955_21006[(1)] = (26));

} else {
var statearr_20956_21007 = state_20949__$1;
(statearr_20956_21007[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (4))){
var inst_20855 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
var statearr_20957_21008 = state_20949__$1;
(statearr_20957_21008[(2)] = inst_20855);

(statearr_20957_21008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (15))){
var inst_20888 = (state_20949[(9)]);
var inst_20888__$1 = (state_20949[(2)]);
var inst_20889 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_20888__$1);
var inst_20890 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_20889);
var state_20949__$1 = (function (){var statearr_20958 = state_20949;
(statearr_20958[(9)] = inst_20888__$1);

return statearr_20958;
})();
if(inst_20890){
var statearr_20959_21009 = state_20949__$1;
(statearr_20959_21009[(1)] = (17));

} else {
var statearr_20960_21010 = state_20949__$1;
(statearr_20960_21010[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (21))){
var inst_20944 = (state_20949[(2)]);
var _ = (function (){var statearr_20961 = state_20949;
(statearr_20961[(4)] = cljs.core.rest.call(null,(state_20949[(4)])));

return statearr_20961;
})();
var state_20949__$1 = state_20949;
var statearr_20962_21011 = state_20949__$1;
(statearr_20962_21011[(2)] = inst_20944);

(statearr_20962_21011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (31))){
var inst_20938 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
var statearr_20963_21012 = state_20949__$1;
(statearr_20963_21012[(2)] = inst_20938);

(statearr_20963_21012[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (13))){
var inst_20882 = fluree.db.query.subject_crawl.subject.resolve_o_ident.call(null,db,f_where);
var state_20949__$1 = state_20949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20949__$1,(16),inst_20882);
} else {
if((state_val_20950 === (22))){
var inst_20916 = (state_20949[(2)]);
var inst_20917 = cljs.core.nth.call(null,inst_20916,(0),null);
var inst_20918 = cljs.core.nth.call(null,inst_20916,(1),null);
var inst_20919 = cljs.core._EQ_.call(null,inst_20918,error_ch);
var state_20949__$1 = (function (){var statearr_20964 = state_20949;
(statearr_20964[(8)] = inst_20917);

return statearr_20964;
})();
if(inst_20919){
var statearr_20965_21013 = state_20949__$1;
(statearr_20965_21013[(1)] = (23));

} else {
var statearr_20966_21014 = state_20949__$1;
(statearr_20966_21014[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (29))){
var inst_20907 = (state_20949[(10)]);
var inst_20917 = (state_20949[(8)]);
var inst_20934 = cljs.core.conj.call(null,inst_20907,inst_20917);
var inst_20907__$1 = inst_20934;
var state_20949__$1 = (function (){var statearr_20967 = state_20949;
(statearr_20967[(10)] = inst_20907__$1);

return statearr_20967;
})();
var statearr_20968_21015 = state_20949__$1;
(statearr_20968_21015[(2)] = null);

(statearr_20968_21015[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (6))){
var inst_20868 = fluree.db.query.subject_crawl.common.resolve_ident_vars.call(null,db,vars,ident_vars);
var state_20949__$1 = state_20949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20949__$1,(9),inst_20868);
} else {
if((state_val_20950 === (28))){
var inst_20940 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
var statearr_20969_21016 = state_20949__$1;
(statearr_20969_21016[(2)] = inst_20940);

(statearr_20969_21016[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (25))){
var inst_20942 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
var statearr_20970_21017 = state_20949__$1;
(statearr_20970_21017[(2)] = inst_20942);

(statearr_20970_21017[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (17))){
var inst_20874 = (state_20949[(11)]);
var inst_20888 = (state_20949[(9)]);
var inst_20892 = fluree.db.query.subject_crawl.subject.subjects_id_chan.call(null,db,error_ch,inst_20874,inst_20888);
var state_20949__$1 = state_20949;
var statearr_20971_21018 = state_20949__$1;
(statearr_20971_21018[(2)] = inst_20892);

(statearr_20971_21018[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (3))){
var inst_20947 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20949__$1,inst_20947);
} else {
if((state_val_20950 === (12))){
var inst_20880 = (state_20949[(2)]);
var state_20949__$1 = state_20949;
if(cljs.core.truth_(inst_20880)){
var statearr_20972_21019 = state_20949__$1;
(statearr_20972_21019[(1)] = (13));

} else {
var statearr_20973_21020 = state_20949__$1;
(statearr_20973_21020[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (2))){
var _ = (function (){var statearr_20974 = state_20949;
(statearr_20974[(4)] = cljs.core.cons.call(null,(5),(state_20949[(4)])));

return statearr_20974;
})();
var inst_20861 = fluree.db.util.log.debug.call(null,"subj-crawl opts:",opts);
var inst_20863 = f_where;
var inst_20864 = cljs.core.__destructure_map.call(null,inst_20863);
var inst_20865 = cljs.core.get.call(null,inst_20864,new cljs.core.Keyword(null,"o","o",-1350007228));
var inst_20866 = cljs.core.get.call(null,inst_20864,new cljs.core.Keyword(null,"p-ref?","p-ref?",-1416067934));
var state_20949__$1 = (function (){var statearr_20975 = state_20949;
(statearr_20975[(12)] = inst_20861);

(statearr_20975[(13)] = inst_20866);

(statearr_20975[(14)] = inst_20865);

return statearr_20975;
})();
if(cljs.core.truth_(ident_vars)){
var statearr_20976_21021 = state_20949__$1;
(statearr_20976_21021[(1)] = (6));

} else {
var statearr_20977_21022 = state_20949__$1;
(statearr_20977_21022[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (23))){
var inst_20896 = (state_20949[(15)]);
var inst_20902 = (state_20949[(7)]);
var inst_20901 = (state_20949[(16)]);
var inst_20917 = (state_20949[(8)]);
var inst_20921 = cljs.core.async.close_BANG_.call(null,inst_20896);
var inst_20922 = cljs.core.async.close_BANG_.call(null,inst_20901);
var inst_20923 = cljs.core.async.close_BANG_.call(null,inst_20902);
var inst_20924 = (function(){throw inst_20917})();
var state_20949__$1 = (function (){var statearr_20978 = state_20949;
(statearr_20978[(17)] = inst_20923);

(statearr_20978[(18)] = inst_20921);

(statearr_20978[(19)] = inst_20922);

return statearr_20978;
})();
var statearr_20979_21023 = state_20949__$1;
(statearr_20979_21023[(2)] = inst_20924);

(statearr_20979_21023[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (19))){
var inst_20875 = (state_20949[(20)]);
var inst_20896 = (state_20949[(15)]);
var inst_20902 = (state_20949[(7)]);
var inst_20901 = (state_20949[(16)]);
var inst_20896__$1 = (state_20949[(2)]);
var inst_20897 = fluree.db.query.subject_crawl.subject.flakes_xf.call(null,inst_20875);
var inst_20898 = cljs.core.drop.call(null,offset);
var inst_20899 = cljs.core.take.call(null,limit);
var inst_20900 = cljs.core.comp.call(null,inst_20898,inst_20899);
var inst_20901__$1 = cljs.core.async.chan.call(null,(32),inst_20900);
var inst_20902__$1 = cljs.core.async.chan.call(null);
var inst_20903 = cljs.core.async.pipeline_async.call(null,parallelism,inst_20901__$1,inst_20897,inst_20896__$1);
var inst_20904 = fluree.db.query.subject_crawl.common.result_af.call(null,inst_20875);
var inst_20905 = cljs.core.async.pipeline_async.call(null,parallelism,inst_20902__$1,inst_20904,inst_20901__$1);
var inst_20906 = cljs.core.PersistentVector.EMPTY;
var inst_20907 = inst_20906;
var state_20949__$1 = (function (){var statearr_20980 = state_20949;
(statearr_20980[(21)] = inst_20903);

(statearr_20980[(22)] = inst_20905);

(statearr_20980[(15)] = inst_20896__$1);

(statearr_20980[(7)] = inst_20902__$1);

(statearr_20980[(16)] = inst_20901__$1);

(statearr_20980[(10)] = inst_20907);

return statearr_20980;
})();
var statearr_20981_21024 = state_20949__$1;
(statearr_20981_21024[(2)] = null);

(statearr_20981_21024[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (11))){
var inst_20866 = (state_20949[(13)]);
var state_20949__$1 = state_20949;
var statearr_20983_21025 = state_20949__$1;
(statearr_20983_21025[(2)] = inst_20866);

(statearr_20983_21025[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (9))){
var inst_20870 = (state_20949[(2)]);
var inst_20871 = fluree.db.util.async.throw_err.call(null,inst_20870);
var state_20949__$1 = state_20949;
var statearr_20984_21026 = state_20949__$1;
(statearr_20984_21026[(2)] = inst_20871);

(statearr_20984_21026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (5))){
var _ = (function (){var statearr_20985 = state_20949;
(statearr_20985[(4)] = cljs.core.rest.call(null,(state_20949[(4)])));

return statearr_20985;
})();
var state_20949__$1 = state_20949;
var ex20982 = (state_20949__$1[(2)]);
var statearr_20986_21027 = state_20949__$1;
(statearr_20986_21027[(5)] = ex20982);


if((ex20982 instanceof Error)){
var statearr_20987_21028 = state_20949__$1;
(statearr_20987_21028[(1)] = (4));

(statearr_20987_21028[(5)] = null);

} else {
throw ex20982;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (14))){
var state_20949__$1 = state_20949;
var statearr_20988_21029 = state_20949__$1;
(statearr_20988_21029[(2)] = f_where);

(statearr_20988_21029[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (26))){
var inst_20896 = (state_20949[(15)]);
var inst_20902 = (state_20949[(7)]);
var inst_20901 = (state_20949[(16)]);
var inst_20907 = (state_20949[(10)]);
var inst_20928 = cljs.core.async.close_BANG_.call(null,inst_20896);
var inst_20929 = cljs.core.async.close_BANG_.call(null,inst_20901);
var inst_20930 = cljs.core.async.close_BANG_.call(null,inst_20902);
var inst_20931 = finish_fn.call(null,inst_20907);
var state_20949__$1 = (function (){var statearr_20989 = state_20949;
(statearr_20989[(23)] = inst_20930);

(statearr_20989[(24)] = inst_20929);

(statearr_20989[(25)] = inst_20928);

return statearr_20989;
})();
var statearr_20990_21030 = state_20949__$1;
(statearr_20990_21030[(2)] = inst_20931);

(statearr_20990_21030[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (16))){
var inst_20884 = (state_20949[(2)]);
var inst_20885 = fluree.db.util.async.throw_err.call(null,inst_20884);
var state_20949__$1 = state_20949;
var statearr_20991_21031 = state_20949__$1;
(statearr_20991_21031[(2)] = inst_20885);

(statearr_20991_21031[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (30))){
var state_20949__$1 = state_20949;
var statearr_20992_21032 = state_20949__$1;
(statearr_20992_21032[(2)] = null);

(statearr_20992_21032[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (10))){
var inst_20865 = (state_20949[(14)]);
var inst_20877 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(inst_20865);
var state_20949__$1 = state_20949;
var statearr_20993_21033 = state_20949__$1;
(statearr_20993_21033[(2)] = inst_20877);

(statearr_20993_21033[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (18))){
var inst_20874 = (state_20949[(11)]);
var inst_20888 = (state_20949[(9)]);
var inst_20894 = fluree.db.query.subject_crawl.subject.subjects_chan.call(null,db,error_ch,inst_20874,inst_20888,parse_json_QMARK_);
var state_20949__$1 = state_20949;
var statearr_20994_21034 = state_20949__$1;
(statearr_20994_21034[(2)] = inst_20894);

(statearr_20994_21034[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20950 === (8))){
var inst_20874 = (state_20949[(11)]);
var inst_20866 = (state_20949[(13)]);
var inst_20874__$1 = (state_20949[(2)]);
var inst_20875 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_20874__$1);
var state_20949__$1 = (function (){var statearr_20995 = state_20949;
(statearr_20995[(20)] = inst_20875);

(statearr_20995[(11)] = inst_20874__$1);

return statearr_20995;
})();
if(cljs.core.truth_(inst_20866)){
var statearr_20996_21035 = state_20949__$1;
(statearr_20996_21035[(1)] = (10));

} else {
var statearr_20997_21036 = state_20949__$1;
(statearr_20997_21036[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0 = (function (){
var statearr_20998 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20998[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__);

(statearr_20998[(1)] = (1));

return statearr_20998;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1 = (function (state_20949){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20999){var ex__2687__auto__ = e20999;
var statearr_21000_21037 = state_20949;
(statearr_21000_21037[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20949[(4)]))){
var statearr_21001_21038 = state_20949;
(statearr_21001_21038[(1)] = cljs.core.first.call(null,(state_20949[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21039 = state_20949;
state_20949 = G__21039;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__ = function(state_20949){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1.call(this,state_20949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21002 = f__2707__auto__.call(null);
(statearr_21002[(6)] = c__2706__auto__);

return statearr_21002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
