// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.reparse');
goog.require('cljs.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
/**
 * A filtering function in the :o space may utilize other supplied variables
 *   from {:vars {}} in the original query. This places those vars into the proper
 *   calling order of the function parameters that was generated during parsing.
 */
fluree.db.query.subject_crawl.reparse.fill_fn_params = (function fluree$db$query$subject_crawl$reparse$fill_fn_params(params,obj_val,obj_var,supplied_vars){
return cljs.core.reduce.call(null,(function (acc,param){
if(cljs.core._EQ_.call(null,param,obj_var)){
return cljs.core.conj.call(null,acc,obj_val);
} else {
if(cljs.core.contains_QMARK_.call(null,supplied_vars,param)){
return cljs.core.conj.call(null,acc,cljs.core.get.call(null,supplied_vars,param));
} else {
throw cljs.core.ex_info.call(null,["Variable used in filter function not included in 'vars' map: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}
}),cljs.core.PersistentVector.EMPTY,params);
});
/**
 * Merges all subsequent where clauses (rest where) for simple-subject-crawl
 *   into a map containing predicate filters.
 * 
 *   A simple-subject crawl will get a list of subjects and then pull all
 *   flakes for that subject in one lookup, instead of traditionally with multiple
 *   where clauses doing individual lookups per clauses.
 * 
 *   Instead of a lookup for every where clause, we therefore filter the subject
 *   flakes for the criteria of each where clause. This generates a single data
 *   structure that allows that filtering to happen. It looks like:
 * 
 *   {:required-p #{1001 1002 ...} - each where statement has a predicate that *must* be present
 * 1001 [(> % 42) (< % 10)] - for predicate 1001, list of filtering fns for the .-o value of each flake
 * 1002 [(= % hi)] }
 * 
 * Note that for multi-cardinality predicates, the prediate filters must pass for just one flake
 *   
 */
fluree.db.query.subject_crawl.reparse.merge_wheres_to_filter = (function fluree$db$query$subject_crawl$reparse$merge_wheres_to_filter(first_s,rest_where,supplied_vars){
var G__21563 = rest_where;
var vec__21564 = G__21563;
var seq__21565 = cljs.core.seq.call(null,vec__21564);
var first__21566 = cljs.core.first.call(null,seq__21565);
var seq__21565__$1 = cljs.core.next.call(null,seq__21565);
var map__21567 = first__21566;
var map__21567__$1 = cljs.core.__destructure_map.call(null,map__21567);
var where_smt = map__21567__$1;
var type = cljs.core.get.call(null,map__21567__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var s = cljs.core.get.call(null,map__21567__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p = cljs.core.get.call(null,map__21567__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__21567__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r = seq__21565__$1;
var required_p = cljs.core.PersistentHashSet.EMPTY;
var filter_map = cljs.core.PersistentArrayMap.EMPTY;
var G__21563__$1 = G__21563;
var required_p__$1 = required_p;
var filter_map__$1 = filter_map;
while(true){
var vec__21574 = G__21563__$1;
var seq__21575 = cljs.core.seq.call(null,vec__21574);
var first__21576 = cljs.core.first.call(null,seq__21575);
var seq__21575__$1 = cljs.core.next.call(null,seq__21575);
var map__21577 = first__21576;
var map__21577__$1 = cljs.core.__destructure_map.call(null,map__21577);
var where_smt__$1 = map__21577__$1;
var type__$1 = cljs.core.get.call(null,map__21577__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var s__$1 = cljs.core.get.call(null,map__21577__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p__$1 = cljs.core.get.call(null,map__21577__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o__$1 = cljs.core.get.call(null,map__21577__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r__$1 = seq__21575__$1;
var required_p__$2 = required_p__$1;
var filter_map__$2 = filter_map__$1;
if(cljs.core.truth_(where_smt__$1)){
if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tuple","tuple",-472667284),type__$1)) && (cljs.core._EQ_.call(null,first_s,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(s__$1))))){
var map__21578 = o__$1;
var map__21578__$1 = cljs.core.__destructure_map.call(null,map__21578);
var value = cljs.core.get.call(null,map__21578__$1,new cljs.core.Keyword(null,"value","value",305978217));
var filter = cljs.core.get.call(null,map__21578__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var variable = cljs.core.get.call(null,map__21578__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var f = (cljs.core.truth_(value)?((function (G__21563__$1,required_p__$1,filter_map__$1,map__21578,map__21578__$1,value,filter,variable,vec__21574,seq__21575,first__21576,seq__21575__$1,map__21577,map__21577__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__21563,vec__21564,seq__21565,first__21566,seq__21565__$1,map__21567,map__21567__$1,where_smt,type,s,p,o,r,required_p,filter_map){
return (function (flake,_){
return cljs.core._EQ_.call(null,value,fluree.db.flake.o.call(null,flake));
});})(G__21563__$1,required_p__$1,filter_map__$1,map__21578,map__21578__$1,value,filter,variable,vec__21574,seq__21575,first__21576,seq__21575__$1,map__21577,map__21577__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__21563,vec__21564,seq__21565,first__21566,seq__21565__$1,map__21567,map__21567__$1,where_smt,type,s,p,o,r,required_p,filter_map))
:(cljs.core.truth_(filter)?(function (){var map__21579 = filter;
var map__21579__$1 = cljs.core.__destructure_map.call(null,map__21579);
var params = cljs.core.get.call(null,map__21579__$1,new cljs.core.Keyword(null,"params","params",710516235));
var variable__$1 = cljs.core.get.call(null,map__21579__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var function$ = cljs.core.get.call(null,map__21579__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,params))){
return ((function (G__21563__$1,required_p__$1,filter_map__$1,map__21579,map__21579__$1,params,variable__$1,function$,map__21578,map__21578__$1,value,filter,variable,vec__21574,seq__21575,first__21576,seq__21575__$1,map__21577,map__21577__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__21563,vec__21564,seq__21565,first__21566,seq__21565__$1,map__21567,map__21567__$1,where_smt,type,s,p,o,r,required_p,filter_map){
return (function (flake,_){
return function$.call(null,fluree.db.flake.o.call(null,flake));
});
;})(G__21563__$1,required_p__$1,filter_map__$1,map__21579,map__21579__$1,params,variable__$1,function$,map__21578,map__21578__$1,value,filter,variable,vec__21574,seq__21575,first__21576,seq__21575__$1,map__21577,map__21577__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__21563,vec__21564,seq__21565,first__21566,seq__21565__$1,map__21567,map__21567__$1,where_smt,type,s,p,o,r,required_p,filter_map))
} else {
return ((function (G__21563__$1,required_p__$1,filter_map__$1,map__21579,map__21579__$1,params,variable__$1,function$,map__21578,map__21578__$1,value,filter,variable,vec__21574,seq__21575,first__21576,seq__21575__$1,map__21577,map__21577__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__21563,vec__21564,seq__21565,first__21566,seq__21565__$1,map__21567,map__21567__$1,where_smt,type,s,p,o,r,required_p,filter_map){
return (function (flake,vars){
var params__$1 = fluree.db.query.subject_crawl.reparse.fill_fn_params.call(null,params,fluree.db.flake.o.call(null,flake),variable__$1,vars);
fluree.db.util.log.debug.call(null,["Calling query-filter fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(filter)),"with params: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params__$1),"."].join(''));

return cljs.core.apply.call(null,function$,params__$1);
});
;})(G__21563__$1,required_p__$1,filter_map__$1,map__21579,map__21579__$1,params,variable__$1,function$,map__21578,map__21578__$1,value,filter,variable,vec__21574,seq__21575,first__21576,seq__21575__$1,map__21577,map__21577__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__21563,vec__21564,seq__21565,first__21566,seq__21565__$1,map__21567,map__21567__$1,where_smt,type,s,p,o,r,required_p,filter_map))
}
})():(cljs.core.truth_((function (){var and__5043__auto__ = variable;
if(cljs.core.truth_(and__5043__auto__)){
return supplied_vars.call(null,variable);
} else {
return and__5043__auto__;
}
})())?((function (G__21563__$1,required_p__$1,filter_map__$1,map__21578,map__21578__$1,value,filter,variable,vec__21574,seq__21575,first__21576,seq__21575__$1,map__21577,map__21577__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__21563,vec__21564,seq__21565,first__21566,seq__21565__$1,map__21567,map__21567__$1,where_smt,type,s,p,o,r,required_p,filter_map){
return (function (flake,vars){
return cljs.core._EQ_.call(null,fluree.db.flake.o.call(null,flake),cljs.core.get.call(null,vars,variable));
});})(G__21563__$1,required_p__$1,filter_map__$1,map__21578,map__21578__$1,value,filter,variable,vec__21574,seq__21575,first__21576,seq__21575__$1,map__21577,map__21577__$1,where_smt__$1,type__$1,s__$1,p__$1,o__$1,r__$1,required_p__$2,filter_map__$2,G__21563,vec__21564,seq__21565,first__21566,seq__21565__$1,map__21567,map__21567__$1,where_smt,type,s,p,o,r,required_p,filter_map))
:null)));
var G__21580 = r__$1;
var G__21581 = cljs.core.conj.call(null,required_p__$2,p__$1);
var G__21582 = (cljs.core.truth_(f)?cljs.core.update.call(null,filter_map__$2,p__$1,fluree.db.util.core.conjv,f):filter_map__$2);
G__21563__$1 = G__21580;
required_p__$1 = G__21581;
filter_map__$1 = G__21582;
continue;
} else {
return null;
}
} else {
return cljs.core.assoc.call(null,filter_map__$2,new cljs.core.Keyword(null,"required-p","required-p",-2091946078),required_p__$2);
}
break;
}
});
/**
 * Revises where clause for simple-subject-crawl query to optimize processing.
 *   If where does not end up meeting simple-subject-crawl criteria, returns nil
 *   so other strategies can be tried.
 */
fluree.db.query.subject_crawl.reparse.simple_subject_merge_where = (function fluree$db$query$subject_crawl$reparse$simple_subject_merge_where(p__21583){
var map__21584 = p__21583;
var map__21584__$1 = cljs.core.__destructure_map.call(null,map__21584);
var parsed_query = map__21584__$1;
var where = cljs.core.get.call(null,map__21584__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var supplied_vars = cljs.core.get.call(null,map__21584__$1,new cljs.core.Keyword(null,"supplied-vars","supplied-vars",-919438628));
var first_where = cljs.core.first.call(null,where);
var rest_where = cljs.core.rest.call(null,where);
var first_type = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(first_where);
var first_s = (cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("rdf","type","rdf/type",1175423232),null,new cljs.core.Keyword(null,"_id","_id",-789960287),null,new cljs.core.Keyword(null,"tuple","tuple",-472667284),null], null), null).call(null,first_type);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(first_where));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(first_where)):null);
if(cljs.core.truth_(first_s)){
if(cljs.core.empty_QMARK_.call(null,rest_where)){
return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"strategy","strategy",-1471631918),new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044));
} else {
var temp__5802__auto__ = fluree.db.query.subject_crawl.reparse.merge_wheres_to_filter.call(null,first_s,rest_where,supplied_vars);
if(cljs.core.truth_(temp__5802__auto__)){
var subj_filter_map = temp__5802__auto__;
return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_where,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020),subj_filter_map], null)], null),new cljs.core.Keyword(null,"strategy","strategy",-1471631918),new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044));
} else {
return null;
}
}
} else {
return null;
}
});
/**
 * Returns true if, when given parsed query, the select statement is a
 *   subject crawl - meaning there is nothing else in the :select except a
 *   graph crawl on a list of subjects
 */
fluree.db.query.subject_crawl.reparse.subject_crawl_QMARK_ = (function fluree$db$query$subject_crawl$reparse$subject_crawl_QMARK_(p__21585){
var map__21586 = p__21585;
var map__21586__$1 = cljs.core.__destructure_map.call(null,map__21586);
var _parsed_query = map__21586__$1;
var select = cljs.core.get.call(null,map__21586__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var and__5043__auto__ = new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444).cljs$core$IFn$_invoke$arity$1(select);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375).cljs$core$IFn$_invoke$arity$1(select));
} else {
return and__5043__auto__;
}
});
/**
 * Simple subject crawl is where the same variable is used in the leading
 *   position of each where statement.
 */
fluree.db.query.subject_crawl.reparse.simple_subject_crawl_QMARK_ = (function fluree$db$query$subject_crawl$reparse$simple_subject_crawl_QMARK_(p__21588){
var map__21589 = p__21588;
var map__21589__$1 = cljs.core.__destructure_map.call(null,map__21589);
var _parsed_query = map__21589__$1;
var where = cljs.core.get.call(null,map__21589__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var select = cljs.core.get.call(null,map__21589__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var select_var = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
if(cljs.core.truth_(select_var)){
return cljs.core.every_QMARK_.call(null,(function (p1__21587_SHARP_){
return ((cljs.core._EQ_.call(null,select_var,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(p1__21587_SHARP_)))) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(p1__21587_SHARP_))));
}),where);
} else {
return null;
}
});
/**
 * Returns true if query contains a single subject crawl.
 *   e.g.
 *   {:select {?subjects ['*']
 * :where [...]}
 */
fluree.db.query.subject_crawl.reparse.re_parse_as_simple_subj_crawl = (function fluree$db$query$subject_crawl$reparse$re_parse_as_simple_subj_crawl(parsed_query){
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.query.subject_crawl.reparse.subject_crawl_QMARK_.call(null,parsed_query);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = fluree.db.query.subject_crawl.reparse.simple_subject_crawl_QMARK_.call(null,parsed_query);
if(cljs.core.truth_(and__5043__auto____$1)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"group-by","group-by",-379139802).cljs$core$IFn$_invoke$arity$1(parsed_query))) && (cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492),(function (){var G__21590 = parsed_query;
var G__21590__$1 = (((G__21590 == null))?null:new cljs.core.Keyword(null,"order-by","order-by",1527318070).cljs$core$IFn$_invoke$arity$1(G__21590));
if((G__21590__$1 == null)){
return null;
} else {
return new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(G__21590__$1);
}
})())));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return fluree.db.query.subject_crawl.reparse.simple_subject_merge_where.call(null,parsed_query);
} else {
return null;
}
});
