// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__21359){
var map__21360 = p__21359;
var map__21360__$1 = cljs.core.__destructure_map.call(null,map__21360);
var parsed_query = map__21360__$1;
var select = cljs.core.get.call(null,map__21360__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.call(null,map__21360__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db.call(null,db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__21361){
var map__21362 = p__21361;
var map__21362__$1 = cljs.core.__destructure_map.call(null,map__21362);
var opts = map__21362__$1;
var rdf_type_QMARK_ = cljs.core.get.call(null,map__21362__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.call(null,map__21362__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21406){
var state_val_21407 = (state_21406[(1)]);
if((state_val_21407 === (7))){
var inst_21385 = (state_21406[(7)]);
var inst_21387 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,inst_21385);
var state_21406__$1 = state_21406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21406__$1,(10),inst_21387);
} else {
if((state_val_21407 === (1))){
var inst_21370 = vars;
var inst_21371 = cljs.core.seq.call(null,inst_21370);
var inst_21372 = cljs.core.first.call(null,inst_21371);
var inst_21373 = cljs.core.next.call(null,inst_21371);
var inst_21374 = cljs.core.PersistentVector.EMPTY;
var inst_21375 = inst_21370;
var inst_21376 = inst_21374;
var state_21406__$1 = (function (){var statearr_21408 = state_21406;
(statearr_21408[(8)] = inst_21376);

(statearr_21408[(9)] = inst_21372);

(statearr_21408[(10)] = inst_21373);

(statearr_21408[(11)] = inst_21375);

return statearr_21408;
})();
var statearr_21409_21427 = state_21406__$1;
(statearr_21409_21427[(2)] = null);

(statearr_21409_21427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (4))){
var inst_21382 = (state_21406[(12)]);
var inst_21385 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_21382);
var state_21406__$1 = (function (){var statearr_21410 = state_21406;
(statearr_21410[(7)] = inst_21385);

return statearr_21410;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_21411_21428 = state_21406__$1;
(statearr_21411_21428[(1)] = (7));

} else {
var statearr_21412_21429 = state_21406__$1;
(statearr_21412_21429[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (6))){
var inst_21402 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
var statearr_21413_21430 = state_21406__$1;
(statearr_21413_21430[(2)] = inst_21402);

(statearr_21413_21430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (3))){
var inst_21404 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21406__$1,inst_21404);
} else {
if((state_val_21407 === (2))){
var inst_21382 = (state_21406[(12)]);
var inst_21375 = (state_21406[(11)]);
var inst_21381 = cljs.core.seq.call(null,inst_21375);
var inst_21382__$1 = cljs.core.first.call(null,inst_21381);
var inst_21383 = cljs.core.next.call(null,inst_21381);
var state_21406__$1 = (function (){var statearr_21414 = state_21406;
(statearr_21414[(12)] = inst_21382__$1);

(statearr_21414[(13)] = inst_21383);

return statearr_21414;
})();
if(cljs.core.truth_(inst_21382__$1)){
var statearr_21415_21431 = state_21406__$1;
(statearr_21415_21431[(1)] = (4));

} else {
var statearr_21416_21432 = state_21406__$1;
(statearr_21416_21432[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (11))){
var inst_21394 = (state_21406[(2)]);
var inst_21395 = fluree.db.util.async.throw_err.call(null,inst_21394);
var state_21406__$1 = state_21406;
var statearr_21417_21433 = state_21406__$1;
(statearr_21417_21433[(2)] = inst_21395);

(statearr_21417_21433[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (9))){
var inst_21376 = (state_21406[(8)]);
var inst_21383 = (state_21406[(13)]);
var inst_21397 = (state_21406[(2)]);
var inst_21398 = cljs.core.into.call(null,inst_21376,inst_21397);
var inst_21375 = inst_21383;
var inst_21376__$1 = inst_21398;
var state_21406__$1 = (function (){var statearr_21418 = state_21406;
(statearr_21418[(8)] = inst_21376__$1);

(statearr_21418[(11)] = inst_21375);

return statearr_21418;
})();
var statearr_21419_21434 = state_21406__$1;
(statearr_21419_21434[(2)] = null);

(statearr_21419_21434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (5))){
var inst_21376 = (state_21406[(8)]);
var state_21406__$1 = state_21406;
var statearr_21420_21435 = state_21406__$1;
(statearr_21420_21435[(2)] = inst_21376);

(statearr_21420_21435[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (10))){
var inst_21389 = (state_21406[(2)]);
var inst_21390 = fluree.db.util.async.throw_err.call(null,inst_21389);
var state_21406__$1 = state_21406;
var statearr_21421_21436 = state_21406__$1;
(statearr_21421_21436[(2)] = inst_21390);

(statearr_21421_21436[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (8))){
var inst_21385 = (state_21406[(7)]);
var inst_21392 = fluree.db.query.subject_crawl.subject.subj_crawl.call(null,inst_21385);
var state_21406__$1 = state_21406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21406__$1,(11),inst_21392);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0 = (function (){
var statearr_21422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21422[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__);

(statearr_21422[(1)] = (1));

return statearr_21422;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1 = (function (state_21406){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_21406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21423){var ex__2687__auto__ = e21423;
var statearr_21424_21437 = state_21406;
(statearr_21424_21437[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_21406[(4)]))){
var statearr_21425_21438 = state_21406;
(statearr_21425_21438[(1)] = cljs.core.first.call(null,(state_21406[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21439 = state_21406;
state_21406 = G__21439;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__ = function(state_21406){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1.call(this,state_21406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21426 = f__2707__auto__.call(null);
(statearr_21426[(6)] = c__2706__auto__);

return statearr_21426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__21441){
var map__21442 = p__21441;
var map__21442__$1 = cljs.core.__destructure_map.call(null,map__21442);
var parsed_query = map__21442__$1;
var selectOne_QMARK_ = cljs.core.get.call(null,map__21442__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.call(null,map__21442__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.call(null,map__21442__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var limit = cljs.core.get.call(null,map__21442__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var fns = (function (){var G__21443 = cljs.core.PersistentVector.EMPTY;
var G__21443__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.call(null,G__21443,(function (result){
return cljs.core.first.call(null,result);
})):G__21443);
var G__21443__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.call(null,G__21443__$1,(function (){var select_var = cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.call(null,(function (p1__21440_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__21440_SHARP_]);
}),result);
});
})()):G__21443__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.call(null,G__21443__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results.call(null,result,order_by,limit);
}));
} else {
return G__21443__$2;
}
})();
if(cljs.core.empty_QMARK_.call(null,fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.call(null,cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__21444){
var map__21445 = p__21444;
var map__21445__$1 = cljs.core.__destructure_map.call(null,map__21445);
var parsed_query = map__21445__$1;
var vars = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var ident_vars = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var offset = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var opts = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var order_by = cljs.core.get.call(null,map__21445__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
fluree.db.util.log.debug.call(null,"Running simple subject crawl query:",parsed_query);

var error_ch = cljs.core.async.chan.call(null);
var f_where = cljs.core.first.call(null,where);
var rdf_type_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,where));
var cache = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_.call(null,(0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec.call(null,db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn.call(null,parsed_query);
var opts__$1 = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,(cljs.core.truth_(order_by)?(9007199254740991):limit),ident_vars,offset,db,error_ch,cljs.core.not.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877).cljs$core$IFn$_invoke$arity$1(opts),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
fluree.db.util.log.debug.call(null,"simple-subject-crawl opts:",opts__$1);

if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding.call(null,opts__$1);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,opts__$1);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl.call(null,opts__$1);
}
}
});
