// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__20173){
var map__20174 = p__20173;
var map__20174__$1 = cljs.core.__destructure_map.call(null,map__20174);
var start_test = cljs.core.get.call(null,map__20174__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.call(null,map__20174__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.call(null,map__20174__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.call(null,map__20174__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.call(null,map__20174__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.call(null,cljs.core.comp,(function (){var G__20175 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.call(null,G__20175,xf);
} else {
return G__20175;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__20176){
var map__20177 = p__20176;
var map__20177__$1 = cljs.core.__destructure_map.call(null,map__20177);
var _opts = map__20177__$1;
var db = cljs.core.get.call(null,map__20177__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.call(null,map__20177__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.call(null,map__20177__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__20177__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.call(null,map__20177__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.call(null,map__20177__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var parse_json_QMARK_ = cljs.core.get.call(null,map__20177__$1,new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877));
return (function (flakes,port){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20222){
var state_val_20223 = (state_20222[(1)]);
if((state_val_20223 === (7))){
var inst_20187 = (state_20222[(7)]);
var inst_20191 = [new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877)];
var inst_20192 = [parse_json_QMARK_];
var inst_20193 = cljs.core.PersistentHashMap.fromArrays(inst_20191,inst_20192);
var inst_20194 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel_vol,max_fuel,select_spec,inst_20193,inst_20187);
var state_20222__$1 = state_20222;
var statearr_20224_20260 = state_20222__$1;
(statearr_20224_20260[(2)] = inst_20194);

(statearr_20224_20260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (1))){
var state_20222__$1 = state_20222;
var statearr_20225_20261 = state_20222__$1;
(statearr_20225_20261[(2)] = null);

(statearr_20225_20261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (4))){
var inst_20178 = (state_20222[(2)]);
var inst_20179 = cljs.core.async.put_BANG_.call(null,error_ch,inst_20178);
var inst_20180 = cljs.core.async.close_BANG_.call(null,port);
var state_20222__$1 = (function (){var statearr_20226 = state_20222;
(statearr_20226[(8)] = inst_20179);

(statearr_20226[(9)] = inst_20180);

return statearr_20226;
})();
var statearr_20227_20262 = state_20222__$1;
(statearr_20227_20262[(2)] = null);

(statearr_20227_20262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (15))){
var inst_20210 = (state_20222[(10)]);
var inst_20210__$1 = (state_20222[(2)]);
var inst_20211 = (inst_20210__$1 == null);
var state_20222__$1 = (function (){var statearr_20228 = state_20222;
(statearr_20228[(10)] = inst_20210__$1);

return statearr_20228;
})();
if(cljs.core.truth_(inst_20211)){
var statearr_20229_20263 = state_20222__$1;
(statearr_20229_20263[(1)] = (16));

} else {
var statearr_20230_20264 = state_20222__$1;
(statearr_20230_20264[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (13))){
var state_20222__$1 = state_20222;
var statearr_20231_20265 = state_20222__$1;
(statearr_20231_20265[(2)] = null);

(statearr_20231_20265[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (6))){
var state_20222__$1 = state_20222;
var statearr_20232_20266 = state_20222__$1;
(statearr_20232_20266[(2)] = null);

(statearr_20232_20266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (17))){
var inst_20210 = (state_20222[(10)]);
var inst_20214 = cljs.core.async.put_BANG_.call(null,port,inst_20210);
var state_20222__$1 = state_20222;
var statearr_20233_20267 = state_20222__$1;
(statearr_20233_20267[(2)] = inst_20214);

(statearr_20233_20267[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (3))){
var inst_20220 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20222__$1,inst_20220);
} else {
if((state_val_20223 === (12))){
var inst_20201 = (state_20222[(2)]);
var inst_20202 = fluree.db.util.async.throw_err.call(null,inst_20201);
var state_20222__$1 = state_20222;
var statearr_20234_20268 = state_20222__$1;
(statearr_20234_20268[(2)] = inst_20202);

(statearr_20234_20268[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (2))){
var inst_20187 = (state_20222[(7)]);
var _ = (function (){var statearr_20235 = state_20222;
(statearr_20235[(4)] = cljs.core.cons.call(null,(5),(state_20222[(4)])));

return statearr_20235;
})();
var inst_20187__$1 = flakes;
var inst_20188 = (inst_20187__$1 == null);
var state_20222__$1 = (function (){var statearr_20236 = state_20222;
(statearr_20236[(7)] = inst_20187__$1);

return statearr_20236;
})();
if(cljs.core.truth_(inst_20188)){
var statearr_20237_20269 = state_20222__$1;
(statearr_20237_20269[(1)] = (6));

} else {
var statearr_20238_20270 = state_20222__$1;
(statearr_20238_20270[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (11))){
var inst_20204 = (state_20222[(11)]);
var inst_20204__$1 = (state_20222[(2)]);
var inst_20205 = (inst_20204__$1 == null);
var state_20222__$1 = (function (){var statearr_20240 = state_20222;
(statearr_20240[(11)] = inst_20204__$1);

return statearr_20240;
})();
if(cljs.core.truth_(inst_20205)){
var statearr_20241_20271 = state_20222__$1;
(statearr_20241_20271[(1)] = (13));

} else {
var statearr_20242_20272 = state_20222__$1;
(statearr_20242_20272[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (9))){
var state_20222__$1 = state_20222;
var statearr_20243_20273 = state_20222__$1;
(statearr_20243_20273[(2)] = null);

(statearr_20243_20273[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (5))){
var _ = (function (){var statearr_20244 = state_20222;
(statearr_20244[(4)] = cljs.core.rest.call(null,(state_20222[(4)])));

return statearr_20244;
})();
var state_20222__$1 = state_20222;
var ex20239 = (state_20222__$1[(2)]);
var statearr_20245_20274 = state_20222__$1;
(statearr_20245_20274[(5)] = ex20239);


var statearr_20246_20275 = state_20222__$1;
(statearr_20246_20275[(1)] = (4));

(statearr_20246_20275[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (14))){
var inst_20204 = (state_20222[(11)]);
var inst_20208 = cljs.core.not_empty.call(null,inst_20204);
var state_20222__$1 = state_20222;
var statearr_20247_20276 = state_20222__$1;
(statearr_20247_20276[(2)] = inst_20208);

(statearr_20247_20276[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (16))){
var state_20222__$1 = state_20222;
var statearr_20248_20277 = state_20222__$1;
(statearr_20248_20277[(2)] = null);

(statearr_20248_20277[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (10))){
var inst_20196 = (state_20222[(12)]);
var state_20222__$1 = state_20222;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20222__$1,(12),inst_20196);
} else {
if((state_val_20223 === (18))){
var inst_20216 = (state_20222[(2)]);
var inst_20217 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_20249 = state_20222;
(statearr_20249[(4)] = cljs.core.rest.call(null,(state_20222[(4)])));

return statearr_20249;
})();
var state_20222__$1 = (function (){var statearr_20250 = state_20222;
(statearr_20250[(13)] = inst_20216);

return statearr_20250;
})();
var statearr_20251_20278 = state_20222__$1;
(statearr_20251_20278[(2)] = inst_20217);

(statearr_20251_20278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (8))){
var inst_20196 = (state_20222[(12)]);
var inst_20196__$1 = (state_20222[(2)]);
var inst_20197 = (inst_20196__$1 == null);
var state_20222__$1 = (function (){var statearr_20252 = state_20222;
(statearr_20252[(12)] = inst_20196__$1);

return statearr_20252;
})();
if(cljs.core.truth_(inst_20197)){
var statearr_20253_20279 = state_20222__$1;
(statearr_20253_20279[(1)] = (9));

} else {
var statearr_20254_20280 = state_20222__$1;
(statearr_20254_20280[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0 = (function (){
var statearr_20255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20255[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__);

(statearr_20255[(1)] = (1));

return statearr_20255;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1 = (function (state_20222){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20222);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20256){var ex__2687__auto__ = e20256;
var statearr_20257_20281 = state_20222;
(statearr_20257_20281[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20222[(4)]))){
var statearr_20258_20282 = state_20222;
(statearr_20258_20282[(1)] = cljs.core.first.call(null,(state_20222[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20283 = state_20222;
state_20222 = G__20283;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__ = function(state_20222){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1.call(this,state_20222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20259 = f__2707__auto__.call(null);
(statearr_20259[(6)] = c__2706__auto__);

return statearr_20259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__20284){
var map__20285 = p__20284;
var map__20285__$1 = cljs.core.__destructure_map.call(null,map__20285);
var db = map__20285__$1;
var permissions = cljs.core.get.call(null,map__20285__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_.call(null,permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.call(null,coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_.call(null,cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_.call(null,coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.call(null,filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20316){
var state_val_20317 = (state_20316[(1)]);
if((state_val_20317 === (7))){
var inst_20292 = (state_20316[(7)]);
var inst_20302 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_20292);
var state_20316__$1 = state_20316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20316__$1,(10),inst_20302);
} else {
if((state_val_20317 === (1))){
var state_20316__$1 = state_20316;
var statearr_20318_20341 = state_20316__$1;
(statearr_20318_20341[(2)] = null);

(statearr_20318_20341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (4))){
var inst_20286 = (state_20316[(2)]);
var state_20316__$1 = state_20316;
var statearr_20319_20342 = state_20316__$1;
(statearr_20319_20342[(2)] = inst_20286);

(statearr_20319_20342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (13))){
var inst_20309 = (state_20316[(2)]);
var state_20316__$1 = state_20316;
var statearr_20320_20343 = state_20316__$1;
(statearr_20320_20343[(2)] = inst_20309);

(statearr_20320_20343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (6))){
var inst_20297 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,flakes);
var state_20316__$1 = state_20316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20316__$1,(9),inst_20297);
} else {
if((state_val_20317 === (3))){
var inst_20314 = (state_20316[(2)]);
var state_20316__$1 = state_20316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20316__$1,inst_20314);
} else {
if((state_val_20317 === (12))){
var state_20316__$1 = state_20316;
var statearr_20321_20344 = state_20316__$1;
(statearr_20321_20344[(2)] = null);

(statearr_20321_20344[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (2))){
var inst_20292 = (state_20316[(7)]);
var _ = (function (){var statearr_20322 = state_20316;
(statearr_20322[(4)] = cljs.core.cons.call(null,(5),(state_20316[(4)])));

return statearr_20322;
})();
var inst_20292__$1 = cljs.core.first.call(null,flakes);
var inst_20293 = fluree.db.flake.s.call(null,inst_20292__$1);
var inst_20294 = fluree.db.flake.sid__GT_cid.call(null,inst_20293);
var inst_20295 = filter_predicates_QMARK_.call(null,inst_20294);
var state_20316__$1 = (function (){var statearr_20323 = state_20316;
(statearr_20323[(7)] = inst_20292__$1);

return statearr_20323;
})();
if(cljs.core.truth_(inst_20295)){
var statearr_20324_20345 = state_20316__$1;
(statearr_20324_20345[(1)] = (6));

} else {
var statearr_20325_20346 = state_20316__$1;
(statearr_20325_20346[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (11))){
var state_20316__$1 = state_20316;
var statearr_20327_20347 = state_20316__$1;
(statearr_20327_20347[(2)] = flakes);

(statearr_20327_20347[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (9))){
var inst_20299 = (state_20316[(2)]);
var inst_20300 = fluree.db.util.async.throw_err.call(null,inst_20299);
var state_20316__$1 = state_20316;
var statearr_20328_20348 = state_20316__$1;
(statearr_20328_20348[(2)] = inst_20300);

(statearr_20328_20348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (5))){
var _ = (function (){var statearr_20329 = state_20316;
(statearr_20329[(4)] = cljs.core.rest.call(null,(state_20316[(4)])));

return statearr_20329;
})();
var state_20316__$1 = state_20316;
var ex20326 = (state_20316__$1[(2)]);
var statearr_20330_20349 = state_20316__$1;
(statearr_20330_20349[(5)] = ex20326);


if((ex20326 instanceof Error)){
var statearr_20331_20350 = state_20316__$1;
(statearr_20331_20350[(1)] = (4));

(statearr_20331_20350[(5)] = null);

} else {
throw ex20326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (10))){
var inst_20304 = (state_20316[(2)]);
var inst_20305 = fluree.db.util.async.throw_err.call(null,inst_20304);
var state_20316__$1 = state_20316;
if(cljs.core.truth_(inst_20305)){
var statearr_20332_20351 = state_20316__$1;
(statearr_20332_20351[(1)] = (11));

} else {
var statearr_20333_20352 = state_20316__$1;
(statearr_20333_20352[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20317 === (8))){
var inst_20311 = (state_20316[(2)]);
var _ = (function (){var statearr_20334 = state_20316;
(statearr_20334[(4)] = cljs.core.rest.call(null,(state_20316[(4)])));

return statearr_20334;
})();
var state_20316__$1 = state_20316;
var statearr_20335_20353 = state_20316__$1;
(statearr_20335_20353[(2)] = inst_20311);

(statearr_20335_20353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_20336 = [null,null,null,null,null,null,null,null];
(statearr_20336[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__);

(statearr_20336[(1)] = (1));

return statearr_20336;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1 = (function (state_20316){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20337){var ex__2687__auto__ = e20337;
var statearr_20338_20354 = state_20316;
(statearr_20338_20354[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20316[(4)]))){
var statearr_20339_20355 = state_20316;
(statearr_20339_20355[(1)] = cljs.core.first.call(null,(state_20316[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20356 = state_20316;
state_20316 = G__20356;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__ = function(state_20316){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1.call(this,state_20316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20340 = f__2707__auto__.call(null);
(statearr_20340[(6)] = c__2706__auto__);

return statearr_20340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some.call(null,(function (p1__20357_SHARP_){
return filter_fn.call(null,p1__20357_SHARP_,vars);
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__20361 = filter_fns;
var vec__20362 = G__20361;
var seq__20363 = cljs.core.seq.call(null,vec__20362);
var first__20364 = cljs.core.first.call(null,seq__20363);
var seq__20363__$1 = cljs.core.next.call(null,seq__20363);
var filter_fn = first__20364;
var r_fns = seq__20363__$1;
var G__20361__$1 = G__20361;
while(true){
var vec__20365 = G__20361__$1;
var seq__20366 = cljs.core.seq.call(null,vec__20365);
var first__20367 = cljs.core.first.call(null,seq__20366);
var seq__20366__$1 = cljs.core.next.call(null,seq__20366);
var filter_fn__$1 = first__20367;
var r_fns__$1 = seq__20366__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_.call(null,filter_fn__$1,vars,pred_flakes))){
var G__20368 = r_fns__$1;
G__20361__$1 = G__20368;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__20372 = cljs.core.partition_by.call(null,fluree.db.flake.p,flakes);
var vec__20373 = G__20372;
var seq__20374 = cljs.core.seq.call(null,vec__20373);
var first__20375 = cljs.core.first.call(null,seq__20374);
var seq__20374__$1 = cljs.core.next.call(null,seq__20374);
var p_flakes = first__20375;
var r = seq__20374__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__20372__$1 = G__20372;
var required_p__$1 = required_p;
while(true){
var vec__20379 = G__20372__$1;
var seq__20380 = cljs.core.seq.call(null,vec__20379);
var first__20381 = cljs.core.first.call(null,seq__20380);
var seq__20380__$1 = cljs.core.next.call(null,seq__20380);
var p_flakes__$1 = first__20381;
var r__$1 = seq__20380__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p.call(null,cljs.core.first.call(null,p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.call(null,filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_.call(null,filter_fns,vars,p_flakes__$1)){
var G__20382 = r__$1;
var G__20383 = cljs.core.disj.call(null,required_p__$2,p);
G__20372__$1 = G__20382;
required_p__$1 = G__20383;
continue;
} else {
return null;
}
} else {
var G__20384 = r__$1;
var G__20385 = cljs.core.disj.call(null,required_p__$2,p);
G__20372__$1 = G__20384;
required_p__$1 = G__20385;
continue;
}
} else {
if(cljs.core.empty_QMARK_.call(null,required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__20386,limit){
var map__20387 = p__20386;
var map__20387__$1 = cljs.core.__destructure_map.call(null,map__20387);
var type = cljs.core.get.call(null,map__20387__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.call(null,map__20387__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.call(null,map__20387__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.call(null,"Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var sorted = (function (){var G__20388 = cljs.core.sort_by.call(null,(function (result){
return cljs.core.get.call(null,result,predicate);
}),results);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),order)){
return cljs.core.reverse.call(null,G__20388);
} else {
return G__20388;
}
})();
return cljs.core.vec.call(null,cljs.core.take.call(null,limit,sorted));
}
});
/**
 * When some variables may be idents (two-tuples) they need to get resolved into
 *   subject _id values before executing query.
 */
fluree.db.query.subject_crawl.common.resolve_ident_vars = (function fluree$db$query$subject_crawl$common$resolve_ident_vars(db,vars,ident_vars){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20458){
var state_val_20459 = (state_20458[(1)]);
if((state_val_20459 === (7))){
var inst_20453 = (state_20458[(2)]);
var _ = (function (){var statearr_20460 = state_20458;
(statearr_20460[(4)] = cljs.core.rest.call(null,(state_20458[(4)])));

return statearr_20460;
})();
var state_20458__$1 = state_20458;
var statearr_20461_20503 = state_20458__$1;
(statearr_20461_20503[(2)] = inst_20453);

(statearr_20461_20503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (20))){
var inst_20408 = (state_20458[(7)]);
var inst_20414 = (state_20458[(8)]);
var inst_20415 = (state_20458[(9)]);
var inst_20431 = (state_20458[(2)]);
var inst_20432 = cljs.core.assoc.call(null,inst_20408,inst_20414,inst_20431);
var inst_20407 = inst_20415;
var inst_20408__$1 = inst_20432;
var state_20458__$1 = (function (){var statearr_20462 = state_20458;
(statearr_20462[(7)] = inst_20408__$1);

(statearr_20462[(10)] = inst_20407);

return statearr_20462;
})();
var statearr_20463_20504 = state_20458__$1;
(statearr_20463_20504[(2)] = null);

(statearr_20463_20504[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (1))){
var state_20458__$1 = state_20458;
var statearr_20464_20505 = state_20458__$1;
(statearr_20464_20505[(2)] = null);

(statearr_20464_20505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (4))){
var inst_20389 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20465_20506 = state_20458__$1;
(statearr_20465_20506[(2)] = inst_20389);

(statearr_20465_20506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (15))){
var state_20458__$1 = state_20458;
var statearr_20466_20507 = state_20458__$1;
(statearr_20466_20507[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (21))){
var inst_20417 = (state_20458[(11)]);
var inst_20414 = (state_20458[(8)]);
var inst_20436 = ["Invalid identity provided in variable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20414),". Must be a two-tuple identity, IRI, or integer id. ","Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20417)].join('');
var inst_20437 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20438 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20439 = cljs.core.PersistentHashMap.fromArrays(inst_20437,inst_20438);
var inst_20440 = cljs.core.ex_info.call(null,inst_20436,inst_20439);
var inst_20441 = (function(){throw inst_20440})();
var state_20458__$1 = state_20458;
var statearr_20468_20508 = state_20458__$1;
(statearr_20468_20508[(2)] = inst_20441);

(statearr_20468_20508[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (13))){
var inst_20448 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20469_20509 = state_20458__$1;
(statearr_20469_20509[(2)] = inst_20448);

(statearr_20469_20509[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (22))){
var state_20458__$1 = state_20458;
var statearr_20470_20510 = state_20458__$1;
(statearr_20470_20510[(2)] = null);

(statearr_20470_20510[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (6))){
var inst_20407 = (state_20458[(10)]);
var inst_20414 = (state_20458[(8)]);
var inst_20413 = cljs.core.seq.call(null,inst_20407);
var inst_20414__$1 = cljs.core.first.call(null,inst_20413);
var inst_20415 = cljs.core.next.call(null,inst_20413);
var state_20458__$1 = (function (){var statearr_20471 = state_20458;
(statearr_20471[(8)] = inst_20414__$1);

(statearr_20471[(9)] = inst_20415);

return statearr_20471;
})();
if(cljs.core.truth_(inst_20414__$1)){
var statearr_20472_20511 = state_20458__$1;
(statearr_20472_20511[(1)] = (8));

} else {
var statearr_20473_20512 = state_20458__$1;
(statearr_20473_20512[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (17))){
var inst_20427 = (state_20458[(12)]);
var inst_20426 = (state_20458[(2)]);
var inst_20427__$1 = fluree.db.util.async.throw_err.call(null,inst_20426);
var state_20458__$1 = (function (){var statearr_20474 = state_20458;
(statearr_20474[(12)] = inst_20427__$1);

return statearr_20474;
})();
if(cljs.core.truth_(inst_20427__$1)){
var statearr_20475_20513 = state_20458__$1;
(statearr_20475_20513[(1)] = (18));

} else {
var statearr_20476_20514 = state_20458__$1;
(statearr_20476_20514[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (3))){
var inst_20456 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20458__$1,inst_20456);
} else {
if((state_val_20459 === (12))){
var inst_20417 = (state_20458[(11)]);
var inst_20422 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_20417);
var state_20458__$1 = state_20458;
if(inst_20422){
var statearr_20477_20515 = state_20458__$1;
(statearr_20477_20515[(1)] = (14));

} else {
var statearr_20478_20516 = state_20458__$1;
(statearr_20478_20516[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (2))){
var _ = (function (){var statearr_20479 = state_20458;
(statearr_20479[(4)] = cljs.core.cons.call(null,(5),(state_20458[(4)])));

return statearr_20479;
})();
var inst_20402 = ident_vars;
var inst_20403 = cljs.core.seq.call(null,inst_20402);
var inst_20404 = cljs.core.first.call(null,inst_20403);
var inst_20405 = cljs.core.next.call(null,inst_20403);
var inst_20406 = vars;
var inst_20407 = inst_20402;
var inst_20408 = inst_20406;
var state_20458__$1 = (function (){var statearr_20480 = state_20458;
(statearr_20480[(7)] = inst_20408);

(statearr_20480[(13)] = inst_20404);

(statearr_20480[(10)] = inst_20407);

(statearr_20480[(14)] = inst_20405);

return statearr_20480;
})();
var statearr_20481_20517 = state_20458__$1;
(statearr_20481_20517[(2)] = null);

(statearr_20481_20517[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (23))){
var inst_20444 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20483_20518 = state_20458__$1;
(statearr_20483_20518[(2)] = inst_20444);

(statearr_20483_20518[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (19))){
var state_20458__$1 = state_20458;
var statearr_20484_20519 = state_20458__$1;
(statearr_20484_20519[(2)] = (0));

(statearr_20484_20519[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (11))){
var inst_20408 = (state_20458[(7)]);
var inst_20415 = (state_20458[(9)]);
var tmp20482 = inst_20408;
var inst_20407 = inst_20415;
var inst_20408__$1 = tmp20482;
var state_20458__$1 = (function (){var statearr_20486 = state_20458;
(statearr_20486[(7)] = inst_20408__$1);

(statearr_20486[(10)] = inst_20407);

return statearr_20486;
})();
var statearr_20487_20520 = state_20458__$1;
(statearr_20487_20520[(2)] = null);

(statearr_20487_20520[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (9))){
var inst_20408 = (state_20458[(7)]);
var state_20458__$1 = state_20458;
var statearr_20488_20521 = state_20458__$1;
(statearr_20488_20521[(2)] = inst_20408);

(statearr_20488_20521[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (5))){
var _ = (function (){var statearr_20489 = state_20458;
(statearr_20489[(4)] = cljs.core.rest.call(null,(state_20458[(4)])));

return statearr_20489;
})();
var state_20458__$1 = state_20458;
var ex20485 = (state_20458__$1[(2)]);
var statearr_20490_20522 = state_20458__$1;
(statearr_20490_20522[(5)] = ex20485);


if((ex20485 instanceof Error)){
var statearr_20491_20523 = state_20458__$1;
(statearr_20491_20523[(1)] = (4));

(statearr_20491_20523[(5)] = null);

} else {
throw ex20485;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (14))){
var inst_20417 = (state_20458[(11)]);
var inst_20424 = fluree.db.dbproto._subid.call(null,db,inst_20417);
var state_20458__$1 = state_20458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20458__$1,(17),inst_20424);
} else {
if((state_val_20459 === (16))){
var inst_20446 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20492_20524 = state_20458__$1;
(statearr_20492_20524[(2)] = inst_20446);

(statearr_20492_20524[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (10))){
var inst_20451 = (state_20458[(2)]);
var state_20458__$1 = state_20458;
var statearr_20493_20525 = state_20458__$1;
(statearr_20493_20525[(2)] = inst_20451);

(statearr_20493_20525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (18))){
var inst_20427 = (state_20458[(12)]);
var state_20458__$1 = state_20458;
var statearr_20494_20526 = state_20458__$1;
(statearr_20494_20526[(2)] = inst_20427);

(statearr_20494_20526[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20459 === (8))){
var inst_20417 = (state_20458[(11)]);
var inst_20414 = (state_20458[(8)]);
var inst_20417__$1 = cljs.core.get.call(null,vars,inst_20414);
var inst_20418 = cljs.core.int_QMARK_.call(null,inst_20417__$1);
var state_20458__$1 = (function (){var statearr_20495 = state_20458;
(statearr_20495[(11)] = inst_20417__$1);

return statearr_20495;
})();
if(inst_20418){
var statearr_20496_20527 = state_20458__$1;
(statearr_20496_20527[(1)] = (11));

} else {
var statearr_20497_20528 = state_20458__$1;
(statearr_20497_20528[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0 = (function (){
var statearr_20498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20498[(0)] = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__);

(statearr_20498[(1)] = (1));

return statearr_20498;
});
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1 = (function (state_20458){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_20458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20499){var ex__2687__auto__ = e20499;
var statearr_20500_20529 = state_20458;
(statearr_20500_20529[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_20458[(4)]))){
var statearr_20501_20530 = state_20458;
(statearr_20501_20530[(1)] = cljs.core.first.call(null,(state_20458[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20531 = state_20458;
state_20458 = G__20531;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__ = function(state_20458){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1.call(this,state_20458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20502 = f__2707__auto__.call(null);
(statearr_20502[(6)] = c__2706__auto__);

return statearr_20502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
