// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14862 = match;
var p1 = cljs.core.nth.call(null,vec__14862,(0),null);
var p2 = cljs.core.nth.call(null,vec__14862,(1),null);
var p3 = cljs.core.nth.call(null,vec__14862,(2),null);
var p4 = cljs.core.nth.call(null,vec__14862,(3),null);
var op = cljs.core.nth.call(null,vec__14862,(4),null);
var m = cljs.core.nth.call(null,vec__14862,(5),null);
var G__14865 = idx;
var G__14865__$1 = (((G__14865 instanceof cljs.core.Keyword))?G__14865.fqn:null);
switch (G__14865__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate.call(null,db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate.call(null,db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate.call(null,db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14865__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14867 = idx;
var G__14867__$1 = (((G__14867 instanceof cljs.core.Keyword))?G__14867.fqn:null);
switch (G__14867__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14867__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14869 = idx;
var G__14869__$1 = (((G__14869 instanceof cljs.core.Keyword))?G__14869.fqn:null);
switch (G__14869__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14869__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.call(null);
if(cljs.core.not.call(null,id)){
cljs.core.async.close_BANG_.call(null,out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_.call(null,id)){
cljs.core.async.pipe.call(null,fluree.db.dbproto._subid.call(null,db,id),out);
} else {
cljs.core.async.put_BANG_.call(null,out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14909){
var state_val_14910 = (state_14909[(1)]);
if((state_val_14910 === (7))){
var inst_14886 = (state_14909[(7)]);
var inst_14893 = (state_14909[(2)]);
var inst_14894 = fluree.db.util.async.throw_err.call(null,inst_14893);
var state_14909__$1 = (function (){var statearr_14911 = state_14909;
(statearr_14911[(8)] = inst_14894);

return statearr_14911;
})();
if(cljs.core.truth_(inst_14886)){
var statearr_14912_14936 = state_14909__$1;
(statearr_14912_14936[(1)] = (8));

} else {
var statearr_14913_14937 = state_14909__$1;
(statearr_14913_14937[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (1))){
var state_14909__$1 = state_14909;
var statearr_14914_14938 = state_14909__$1;
(statearr_14914_14938[(2)] = null);

(statearr_14914_14938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (4))){
var inst_14871 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
var statearr_14915_14939 = state_14909__$1;
(statearr_14915_14939[(2)] = inst_14871);

(statearr_14915_14939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (13))){
var inst_14901 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
var statearr_14916_14940 = state_14909__$1;
(statearr_14916_14940[(2)] = inst_14901);

(statearr_14916_14940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (6))){
var inst_14883 = (state_14909[(9)]);
var inst_14889 = (state_14909[(2)]);
var inst_14890 = fluree.db.util.async.throw_err.call(null,inst_14889);
var inst_14891 = fluree.db.query.range.resolve_subid.call(null,db,inst_14883);
var state_14909__$1 = (function (){var statearr_14917 = state_14909;
(statearr_14917[(10)] = inst_14890);

return statearr_14917;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14909__$1,(7),inst_14891);
} else {
if((state_val_14910 === (3))){
var inst_14907 = (state_14909[(2)]);
var state_14909__$1 = state_14909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14909__$1,inst_14907);
} else {
if((state_val_14910 === (12))){
var state_14909__$1 = state_14909;
var statearr_14918_14941 = state_14909__$1;
(statearr_14918_14941[(2)] = (2147483647));

(statearr_14918_14941[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (2))){
var _ = (function (){var statearr_14919 = state_14909;
(statearr_14919[(4)] = cljs.core.cons.call(null,(5),(state_14909[(4)])));

return statearr_14919;
})();
var inst_14880 = parts;
var inst_14881 = cljs.core.nth.call(null,inst_14880,(0),null);
var inst_14882 = cljs.core.nth.call(null,inst_14880,(1),null);
var inst_14883 = cljs.core.nth.call(null,inst_14880,(2),null);
var inst_14884 = cljs.core.nth.call(null,inst_14880,(3),null);
var inst_14885 = cljs.core.nth.call(null,inst_14880,(4),null);
var inst_14886 = cljs.core.nth.call(null,inst_14880,(5),null);
var inst_14887 = fluree.db.query.range.resolve_subid.call(null,db,inst_14881);
var state_14909__$1 = (function (){var statearr_14920 = state_14909;
(statearr_14920[(7)] = inst_14886);

(statearr_14920[(9)] = inst_14883);

(statearr_14920[(11)] = inst_14882);

(statearr_14920[(12)] = inst_14884);

(statearr_14920[(13)] = inst_14885);

return statearr_14920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14909__$1,(6),inst_14887);
} else {
if((state_val_14910 === (11))){
var state_14909__$1 = state_14909;
var statearr_14922_14942 = state_14909__$1;
(statearr_14922_14942[(2)] = (-2147483647));

(statearr_14922_14942[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (9))){
var inst_14897 = (cljs.core._GT__EQ_ === test);
var state_14909__$1 = state_14909;
if(cljs.core.truth_(inst_14897)){
var statearr_14923_14943 = state_14909__$1;
(statearr_14923_14943[(1)] = (11));

} else {
var statearr_14924_14944 = state_14909__$1;
(statearr_14924_14944[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (5))){
var _ = (function (){var statearr_14925 = state_14909;
(statearr_14925[(4)] = cljs.core.rest.call(null,(state_14909[(4)])));

return statearr_14925;
})();
var state_14909__$1 = state_14909;
var ex14921 = (state_14909__$1[(2)]);
var statearr_14926_14945 = state_14909__$1;
(statearr_14926_14945[(5)] = ex14921);


if((ex14921 instanceof Error)){
var statearr_14927_14946 = state_14909__$1;
(statearr_14927_14946[(1)] = (4));

(statearr_14927_14946[(5)] = null);

} else {
throw ex14921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (10))){
var inst_14882 = (state_14909[(11)]);
var inst_14884 = (state_14909[(12)]);
var inst_14890 = (state_14909[(10)]);
var inst_14885 = (state_14909[(13)]);
var inst_14894 = (state_14909[(8)]);
var inst_14903 = (state_14909[(2)]);
var inst_14904 = fluree.db.flake.__GT_Flake.call(null,inst_14890,inst_14882,inst_14894,inst_14884,inst_14885,inst_14903);
var _ = (function (){var statearr_14928 = state_14909;
(statearr_14928[(4)] = cljs.core.rest.call(null,(state_14909[(4)])));

return statearr_14928;
})();
var state_14909__$1 = state_14909;
var statearr_14929_14947 = state_14909__$1;
(statearr_14929_14947[(2)] = inst_14904);

(statearr_14929_14947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14910 === (8))){
var inst_14886 = (state_14909[(7)]);
var state_14909__$1 = state_14909;
var statearr_14930_14948 = state_14909__$1;
(statearr_14930_14948[(2)] = inst_14886);

(statearr_14930_14948[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0 = (function (){
var statearr_14931 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14931[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__);

(statearr_14931[(1)] = (1));

return statearr_14931;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1 = (function (state_14909){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_14909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14932){var ex__2687__auto__ = e14932;
var statearr_14933_14949 = state_14909;
(statearr_14933_14949[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_14909[(4)]))){
var statearr_14934_14950 = state_14909;
(statearr_14934_14950[(1)] = cljs.core.first.call(null,(state_14909[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14951 = state_14909;
state_14909 = G__14951;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__ = function(state_14909){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1.call(this,state_14909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14935 = f__2707__auto__.call(null);
(statearr_14935[(6)] = c__2706__auto__);

return statearr_14935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__5043__auto__ = fluree.db.index.leaf_QMARK_.call(null,node);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_.call(null,node);
} else {
return and__5043__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not.call(null,(function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__5043__auto__)){
return fluree.db.flake.lower_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_.call(null,new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__14952){
var map__14953 = p__14952;
var map__14953__$1 = cljs.core.__destructure_map.call(null,map__14953);
var subject_fn = cljs.core.get.call(null,map__14953__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.call(null,map__14953__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.call(null,map__14953__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__14954 = cljs.core.PersistentVector.EMPTY;
var G__14954__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.call(null,G__14954,cljs.core.filter.call(null,(function (f){
return subject_fn.call(null,fluree.db.flake.s.call(null,f));
}))):G__14954);
var G__14954__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.call(null,G__14954__$1,cljs.core.filter.call(null,(function (f){
return predicate_fn.call(null,fluree.db.flake.p.call(null,f));
}))):G__14954__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.call(null,G__14954__$2,cljs.core.filter.call(null,(function (f){
return object_fn.call(null,fluree.db.flake.o.call(null,f));
})));
} else {
return G__14954__$2;
}
})();
return cljs.core.apply.call(null,cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__14955){
var map__14956 = p__14955;
var map__14956__$1 = cljs.core.__destructure_map.call(null,map__14956);
var opts = map__14956__$1;
var start_flake = cljs.core.get.call(null,map__14956__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.call(null,map__14956__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.call(null,map__14956__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.call(null,map__14956__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.call(null,(function (flakes){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter.call(null,opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__14957,root,novelty,error_ch,p__14958){
var map__14959 = p__14957;
var map__14959__$1 = cljs.core.__destructure_map.call(null,map__14959);
var conn = map__14959__$1;
var async_cache = cljs.core.get.call(null,map__14959__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__14960 = p__14958;
var map__14960__$1 = cljs.core.__destructure_map.call(null,map__14960);
var opts = map__14960__$1;
var from_t = cljs.core.get.call(null,map__14960__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.call(null,map__14960__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.call(null,map__14960__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__14960__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,start_flake,end_flake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes.call(null,opts);
return fluree.db.index.tree_chan.call(null,resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.call(null,f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14991){
var state_val_14992 = (state_14991[(1)]);
if((state_val_14992 === (7))){
var inst_14974 = (state_14991[(7)]);
var state_14991__$1 = state_14991;
var statearr_14993_15017 = state_14991__$1;
(statearr_14993_15017[(2)] = inst_14974);

(statearr_14993_15017[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (1))){
var state_14991__$1 = state_14991;
var statearr_14994_15018 = state_14991__$1;
(statearr_14994_15018[(2)] = null);

(statearr_14994_15018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (4))){
var inst_14961 = (state_14991[(2)]);
var inst_14962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14963 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_14964 = (new cljs.core.PersistentVector(null,3,(5),inst_14962,inst_14963,null));
var inst_14965 = cljs.core.select_keys.call(null,db,inst_14964);
var inst_14966 = fluree.db.util.log.error.call(null,inst_14961,"Error authorizing flake in ledger",inst_14965);
var state_14991__$1 = (function (){var statearr_14996 = state_14991;
(statearr_14996[(8)] = inst_14966);

return statearr_14996;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14991__$1,(5),error_ch,inst_14961);
} else {
if((state_val_14992 === (13))){
var inst_14986 = (state_14991[(2)]);
var _ = (function (){var statearr_14997 = state_14991;
(statearr_14997[(4)] = cljs.core.rest.call(null,(state_14991[(4)])));

return statearr_14997;
})();
var state_14991__$1 = state_14991;
var statearr_14998_15019 = state_14991__$1;
(statearr_14998_15019[(2)] = inst_14986);

(statearr_14998_15019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (6))){
var _ = (function (){var statearr_14999 = state_14991;
(statearr_14999[(4)] = cljs.core.rest.call(null,(state_14991[(4)])));

return statearr_14999;
})();
var state_14991__$1 = state_14991;
var ex14995 = (state_14991__$1[(2)]);
var statearr_15000_15020 = state_14991__$1;
(statearr_15000_15020[(5)] = ex14995);


var statearr_15001_15021 = state_14991__$1;
(statearr_15001_15021[(1)] = (4));

(statearr_15001_15021[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (3))){
var inst_14989 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14991__$1,inst_14989);
} else {
if((state_val_14992 === (12))){
var state_14991__$1 = state_14991;
var statearr_15002_15022 = state_14991__$1;
(statearr_15002_15022[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_15002_15022[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (2))){
var inst_14974 = (state_14991[(7)]);
var _ = (function (){var statearr_15003 = state_14991;
(statearr_15003[(4)] = cljs.core.cons.call(null,(6),(state_14991[(4)])));

return statearr_15003;
})();
var inst_14974__$1 = fluree.db.util.schema.is_schema_flake_QMARK_.call(null,flake);
var state_14991__$1 = (function (){var statearr_15004 = state_14991;
(statearr_15004[(7)] = inst_14974__$1);

return statearr_15004;
})();
if(inst_14974__$1){
var statearr_15005_15023 = state_14991__$1;
(statearr_15005_15023[(1)] = (7));

} else {
var statearr_15006_15024 = state_14991__$1;
(statearr_15006_15024[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (11))){
var state_14991__$1 = state_14991;
var statearr_15007_15025 = state_14991__$1;
(statearr_15007_15025[(2)] = flake);

(statearr_15007_15025[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (9))){
var inst_14982 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
if(cljs.core.truth_(inst_14982)){
var statearr_15008_15026 = state_14991__$1;
(statearr_15008_15026[(1)] = (11));

} else {
var statearr_15009_15027 = state_14991__$1;
(statearr_15009_15027[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (5))){
var inst_14968 = (state_14991[(2)]);
var state_14991__$1 = state_14991;
var statearr_15010_15028 = state_14991__$1;
(statearr_15010_15028[(2)] = inst_14968);

(statearr_15010_15028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (10))){
var inst_14979 = (state_14991[(2)]);
var inst_14980 = fluree.db.util.async.throw_err.call(null,inst_14979);
var state_14991__$1 = state_14991;
var statearr_15011_15029 = state_14991__$1;
(statearr_15011_15029[(2)] = inst_14980);

(statearr_15011_15029[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14992 === (8))){
var inst_14977 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,flake);
var state_14991__$1 = state_14991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14991__$1,(10),inst_14977);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0 = (function (){
var statearr_15012 = [null,null,null,null,null,null,null,null,null];
(statearr_15012[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__);

(statearr_15012[(1)] = (1));

return statearr_15012;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1 = (function (state_14991){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_14991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15013){var ex__2687__auto__ = e15013;
var statearr_15014_15030 = state_14991;
(statearr_15014_15030[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_14991[(4)]))){
var statearr_15015_15031 = state_14991;
(statearr_15015_15031[(1)] = cljs.core.first.call(null,(state_14991[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15032 = state_14991;
state_14991 = G__15032;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__ = function(state_14991){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1.call(this,state_14991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15016 = f__2707__auto__.call(null);
(statearr_15016[(6)] = c__2706__auto__);

return statearr_15016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.call(null,(function() { 
var G__15033__delegate = function (fs){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.remove.call(null,fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__15033 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__15034__i = 0, G__15034__a = new Array(arguments.length -  0);
while (G__15034__i < G__15034__a.length) {G__15034__a[G__15034__i] = arguments[G__15034__i + 0]; ++G__15034__i;}
  fs = new cljs.core.IndexedSeq(G__15034__a,0,null);
} 
return G__15033__delegate.call(this,fs);};
G__15033.cljs$lang$maxFixedArity = 0;
G__15033.cljs$lang$applyTo = (function (arglist__15035){
var fs = cljs.core.seq(arglist__15035);
return G__15033__delegate(fs);
});
G__15033.cljs$core$IFn$_invoke$arity$variadic = G__15033__delegate;
return G__15033;
})()
,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__15036,start,end,error_ch,flake_slices){
var map__15037 = p__15036;
var map__15037__$1 = cljs.core.__destructure_map.call(null,map__15037);
var db = map__15037__$1;
var permissions = cljs.core.get.call(null,map__15037__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__15038 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.call(null,fluree.db.flake.s)], null);
var G__15038__$1 = (cljs.core.truth_(offset)?cljs.core.conj.call(null,G__15038,cljs.core.drop.call(null,offset)):G__15038);
var G__15038__$2 = (cljs.core.truth_(limit)?cljs.core.conj.call(null,G__15038__$1,cljs.core.take.call(null,limit)):G__15038__$1);
return cljs.core.conj.call(null,G__15038__$2,cljs.core.cat);

})();
return cljs.core.apply.call(null,cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__15039 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__15039__$1 = (cljs.core.truth_((function (){var or__5045__auto__ = limit;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return offset;
}
})())?cljs.core.conj.call(null,G__15039,fluree.db.query.range.filter_subject_page.call(null,limit,offset)):G__15039);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.call(null,G__15039__$1,cljs.core.take.call(null,flake_limit));
} else {
return G__15039__$1;
}
})();
var page_xf = cljs.core.apply.call(null,cljs.core.comp,page_xfs);
return cljs.core.async.transduce.call(null,page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__15040,error_ch,p__15041){
var map__15042 = p__15040;
var map__15042__$1 = cljs.core.__destructure_map.call(null,map__15042);
var db = map__15042__$1;
var conn = cljs.core.get.call(null,map__15042__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__15043 = p__15041;
var map__15043__$1 = cljs.core.__destructure_map.call(null,map__15043);
var opts = map__15043__$1;
var idx = cljs.core.get.call(null,map__15043__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.call(null,map__15043__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.call(null,map__15043__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.call(null,map__15043__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__15043__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.call(null,map__15043__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.call(null,db,idx);
var idx_cmp = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page.call(null,limit,offset,flake_limit,fluree.db.query.range.filter_authorized.call(null,db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices.call(null,conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__15044 = cljs.core.identical_QMARK_;
var expr__15045 = test;
if(cljs.core.truth_(pred__15044.call(null,cljs.core._EQ_,expr__15045))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15044.call(null,cljs.core._LT_,expr__15045))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__15044.call(null,cljs.core._LT__EQ_,expr__15045))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__15044.call(null,cljs.core._GT_,expr__15045))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__15044.call(null,cljs.core._GT__EQ_,expr__15045))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15045)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__15048 = arguments.length;
switch (G__15048) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15049 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__15049,(0),null);
var start_match = cljs.core.nth.call(null,vec__15049,(1),null);
var end_test = cljs.core.nth.call(null,vec__15049,(2),null);
var end_match = cljs.core.nth.call(null,vec__15049,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15052,idx,start_test,start_match,end_test,end_match,opts){
var map__15053 = p__15052;
var map__15053__$1 = cljs.core.__destructure_map.call(null,map__15053);
var db = map__15053__$1;
var t = cljs.core.get.call(null,map__15053__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15054 = opts;
var map__15054__$1 = cljs.core.__destructure_map.call(null,map__15054);
var limit = cljs.core.get.call(null,map__15054__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.call(null,map__15054__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.call(null,map__15054__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15116){
var state_val_15117 = (state_15116[(1)]);
if((state_val_15117 === (7))){
var inst_15064 = (state_15116[(7)]);
var inst_15069 = (state_15116[(8)]);
var inst_15073 = (state_15116[(9)]);
var inst_15067 = (state_15116[(2)]);
var inst_15068 = fluree.db.util.async.throw_err.call(null,inst_15067);
var inst_15069__$1 = cljs.core.async.chan.call(null);
var inst_15070 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_15071 = [idx,from_t,to_t,start_test,inst_15064,end_test,inst_15068,limit];
var inst_15072 = cljs.core.PersistentHashMap.fromArrays(inst_15070,inst_15071);
var inst_15073__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_15069__$1,inst_15072);
var inst_15081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15082 = [inst_15069__$1,inst_15073__$1];
var inst_15083 = (new cljs.core.PersistentVector(null,2,(5),inst_15081,inst_15082,null));
var state_15116__$1 = (function (){var statearr_15118 = state_15116;
(statearr_15118[(8)] = inst_15069__$1);

(statearr_15118[(9)] = inst_15073__$1);

return statearr_15118;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15116__$1,(8),inst_15083);
} else {
if((state_val_15117 === (1))){
var state_15116__$1 = state_15116;
var statearr_15119_15148 = state_15116__$1;
(statearr_15119_15148[(2)] = null);

(statearr_15119_15148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (4))){
var inst_15055 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
var statearr_15120_15149 = state_15116__$1;
(statearr_15120_15149[(2)] = inst_15055);

(statearr_15120_15149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (15))){
var inst_15086 = (state_15116[(10)]);
var state_15116__$1 = state_15116;
var statearr_15121_15150 = state_15116__$1;
(statearr_15121_15150[(2)] = inst_15086);

(statearr_15121_15150[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (13))){
var inst_15087 = (state_15116[(11)]);
var inst_15103 = cljs.core._EQ_.call(null,inst_15087,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15116__$1 = state_15116;
if(inst_15103){
var statearr_15122_15151 = state_15116__$1;
(statearr_15122_15151[(1)] = (15));

} else {
var statearr_15123_15152 = state_15116__$1;
(statearr_15123_15152[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (6))){
var inst_15063 = (state_15116[(2)]);
var inst_15064 = fluree.db.util.async.throw_err.call(null,inst_15063);
var inst_15065 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,end_parts);
var state_15116__$1 = (function (){var statearr_15124 = state_15116;
(statearr_15124[(7)] = inst_15064);

return statearr_15124;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15116__$1,(7),inst_15065);
} else {
if((state_val_15117 === (17))){
var inst_15107 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
var statearr_15125_15153 = state_15116__$1;
(statearr_15125_15153[(2)] = inst_15107);

(statearr_15125_15153[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (3))){
var inst_15114 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15116__$1,inst_15114);
} else {
if((state_val_15117 === (12))){
var inst_15085 = (state_15116[(12)]);
var inst_15101 = cljs.core.nth.call(null,inst_15085,(0),null);
var state_15116__$1 = state_15116;
var statearr_15126_15154 = state_15116__$1;
(statearr_15126_15154[(2)] = inst_15101);

(statearr_15126_15154[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (2))){
var _ = (function (){var statearr_15127 = state_15116;
(statearr_15127[(4)] = cljs.core.cons.call(null,(5),(state_15116[(4)])));

return statearr_15127;
})();
var inst_15061 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,start_parts);
var state_15116__$1 = state_15116;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15116__$1,(6),inst_15061);
} else {
if((state_val_15117 === (11))){
var inst_15111 = (state_15116[(2)]);
var _ = (function (){var statearr_15129 = state_15116;
(statearr_15129[(4)] = cljs.core.rest.call(null,(state_15116[(4)])));

return statearr_15129;
})();
var state_15116__$1 = state_15116;
var statearr_15130_15155 = state_15116__$1;
(statearr_15130_15155[(2)] = inst_15111);

(statearr_15130_15155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (9))){
var inst_15085 = (state_15116[(12)]);
var inst_15093 = cljs.core.nth.call(null,inst_15085,(0),null);
var inst_15094 = (function(){throw inst_15093})();
var state_15116__$1 = state_15116;
var statearr_15131_15156 = state_15116__$1;
(statearr_15131_15156[(2)] = inst_15094);

(statearr_15131_15156[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (5))){
var _ = (function (){var statearr_15132 = state_15116;
(statearr_15132[(4)] = cljs.core.rest.call(null,(state_15116[(4)])));

return statearr_15132;
})();
var state_15116__$1 = state_15116;
var ex15128 = (state_15116__$1[(2)]);
var statearr_15133_15157 = state_15116__$1;
(statearr_15133_15157[(5)] = ex15128);


if((ex15128 instanceof Error)){
var statearr_15134_15158 = state_15116__$1;
(statearr_15134_15158[(1)] = (4));

(statearr_15134_15158[(5)] = null);

} else {
throw ex15128;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (14))){
var inst_15109 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
var statearr_15135_15159 = state_15116__$1;
(statearr_15135_15159[(2)] = inst_15109);

(statearr_15135_15159[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (16))){
var state_15116__$1 = state_15116;
var statearr_15136_15160 = state_15116__$1;
(statearr_15136_15160[(2)] = null);

(statearr_15136_15160[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (10))){
var inst_15087 = (state_15116[(11)]);
var inst_15073 = (state_15116[(9)]);
var inst_15096 = cljs.core._EQ_.call(null,inst_15087,inst_15073);
var state_15116__$1 = state_15116;
if(inst_15096){
var statearr_15137_15161 = state_15116__$1;
(statearr_15137_15161[(1)] = (12));

} else {
var statearr_15138_15162 = state_15116__$1;
(statearr_15138_15162[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15117 === (8))){
var inst_15087 = (state_15116[(11)]);
var inst_15069 = (state_15116[(8)]);
var inst_15085 = (state_15116[(12)]);
var inst_15085__$1 = (state_15116[(2)]);
var inst_15086 = cljs.core.nth.call(null,inst_15085__$1,(0),null);
var inst_15087__$1 = cljs.core.nth.call(null,inst_15085__$1,(1),null);
var inst_15088 = cljs.core._EQ_.call(null,inst_15087__$1,inst_15069);
var state_15116__$1 = (function (){var statearr_15139 = state_15116;
(statearr_15139[(11)] = inst_15087__$1);

(statearr_15139[(10)] = inst_15086);

(statearr_15139[(12)] = inst_15085__$1);

return statearr_15139;
})();
if(inst_15088){
var statearr_15140_15163 = state_15116__$1;
(statearr_15140_15163[(1)] = (9));

} else {
var statearr_15141_15164 = state_15116__$1;
(statearr_15141_15164[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15142 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15142[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15142[(1)] = (1));

return statearr_15142;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15116){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_15116);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15143){var ex__2687__auto__ = e15143;
var statearr_15144_15165 = state_15116;
(statearr_15144_15165[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_15116[(4)]))){
var statearr_15145_15166 = state_15116;
(statearr_15145_15166[(1)] = cljs.core.first.call(null,(state_15116[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15167 = state_15116;
state_15116 = G__15167;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15116){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15146 = f__2707__auto__.call(null);
(statearr_15146[(6)] = c__2706__auto__);

return statearr_15146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15169 = arguments.length;
switch (G__15169) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15170 = fluree.db.query.range.expand_range_interval.call(null,idx,test,match);
var start_test = cljs.core.nth.call(null,vec__15170,(0),null);
var start_match = cljs.core.nth.call(null,vec__15170,(1),null);
var end_test = cljs.core.nth.call(null,vec__15170,(2),null);
var end_match = cljs.core.nth.call(null,vec__15170,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15173,idx,start_test,start_match,end_test,end_match,p__15174){
var map__15175 = p__15173;
var map__15175__$1 = cljs.core.__destructure_map.call(null,map__15175);
var db = map__15175__$1;
var permissions = cljs.core.get.call(null,map__15175__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.call(null,map__15175__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15176 = p__15174;
var map__15176__$1 = cljs.core.__destructure_map.call(null,map__15176);
var opts = map__15176__$1;
var object_fn = cljs.core.get.call(null,map__15176__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__15177 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var s1 = cljs.core.nth.call(null,vec__15177,(0),null);
var p1 = cljs.core.nth.call(null,vec__15177,(1),null);
var o1 = cljs.core.nth.call(null,vec__15177,(2),null);
var t1 = cljs.core.nth.call(null,vec__15177,(3),null);
var op1 = cljs.core.nth.call(null,vec__15177,(4),null);
var m1 = cljs.core.nth.call(null,vec__15177,(5),null);
var vec__15180 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var s2 = cljs.core.nth.call(null,vec__15180,(0),null);
var p2 = cljs.core.nth.call(null,vec__15180,(1),null);
var o2 = cljs.core.nth.call(null,vec__15180,(2),null);
var t2 = cljs.core.nth.call(null,vec__15180,(3),null);
var op2 = cljs.core.nth.call(null,vec__15180,(4),null);
var m2 = cljs.core.nth.call(null,vec__15180,(5),null);
var vec__15183 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_.call(null,o1))?o1:((cljs.core.boolean_QMARK_.call(null,o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.call(null,o,bool);
})], null);
}
})();
var vec__15186 = cljs.core.nth.call(null,vec__15183,(0),null);
var o1__$1 = cljs.core.nth.call(null,vec__15186,(0),null);
var o2__$1 = cljs.core.nth.call(null,vec__15186,(1),null);
var object_fn__$1 = cljs.core.nth.call(null,vec__15183,(1),null);
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15254){
var state_val_15255 = (state_15254[(1)]);
if((state_val_15255 === (7))){
var inst_15211 = (state_15254[(7)]);
var inst_15209 = (state_15254[(8)]);
var inst_15201 = (state_15254[(9)]);
var inst_15207 = (state_15254[(2)]);
var inst_15208 = fluree.db.util.async.throw_err.call(null,inst_15207);
var inst_15209__$1 = cljs.core.async.chan.call(null);
var inst_15210 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_15201,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_15208,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1);
var inst_15211__$1 = fluree.db.query.range.index_range_STAR_.call(null,db,inst_15209__$1,inst_15210);
var inst_15219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15220 = [inst_15209__$1,inst_15211__$1];
var inst_15221 = (new cljs.core.PersistentVector(null,2,(5),inst_15219,inst_15220,null));
var state_15254__$1 = (function (){var statearr_15256 = state_15254;
(statearr_15256[(7)] = inst_15211__$1);

(statearr_15256[(8)] = inst_15209__$1);

return statearr_15256;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15254__$1,(8),inst_15221);
} else {
if((state_val_15255 === (1))){
var state_15254__$1 = state_15254;
var statearr_15257_15286 = state_15254__$1;
(statearr_15257_15286[(2)] = null);

(statearr_15257_15286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (4))){
var inst_15189 = (state_15254[(2)]);
var state_15254__$1 = state_15254;
var statearr_15258_15287 = state_15254__$1;
(statearr_15258_15287[(2)] = inst_15189);

(statearr_15258_15287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (15))){
var inst_15224 = (state_15254[(10)]);
var state_15254__$1 = state_15254;
var statearr_15259_15288 = state_15254__$1;
(statearr_15259_15288[(2)] = inst_15224);

(statearr_15259_15288[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (13))){
var inst_15225 = (state_15254[(11)]);
var inst_15241 = cljs.core._EQ_.call(null,inst_15225,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15254__$1 = state_15254;
if(inst_15241){
var statearr_15260_15289 = state_15254__$1;
(statearr_15260_15289[(1)] = (15));

} else {
var statearr_15261_15290 = state_15254__$1;
(statearr_15261_15290[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (6))){
var inst_15200 = (state_15254[(2)]);
var inst_15201 = fluree.db.util.async.throw_err.call(null,inst_15200);
var inst_15202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15203 = [s2,p2,o2__$1,t2,op2,m2];
var inst_15204 = (new cljs.core.PersistentVector(null,6,(5),inst_15202,inst_15203,null));
var inst_15205 = fluree.db.query.range.resolve_match_flake.call(null,db,end_test,inst_15204);
var state_15254__$1 = (function (){var statearr_15262 = state_15254;
(statearr_15262[(9)] = inst_15201);

return statearr_15262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15254__$1,(7),inst_15205);
} else {
if((state_val_15255 === (17))){
var inst_15245 = (state_15254[(2)]);
var state_15254__$1 = state_15254;
var statearr_15263_15291 = state_15254__$1;
(statearr_15263_15291[(2)] = inst_15245);

(statearr_15263_15291[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (3))){
var inst_15252 = (state_15254[(2)]);
var state_15254__$1 = state_15254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15254__$1,inst_15252);
} else {
if((state_val_15255 === (12))){
var inst_15223 = (state_15254[(12)]);
var inst_15239 = cljs.core.nth.call(null,inst_15223,(0),null);
var state_15254__$1 = state_15254;
var statearr_15264_15292 = state_15254__$1;
(statearr_15264_15292[(2)] = inst_15239);

(statearr_15264_15292[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (2))){
var _ = (function (){var statearr_15265 = state_15254;
(statearr_15265[(4)] = cljs.core.cons.call(null,(5),(state_15254[(4)])));

return statearr_15265;
})();
var inst_15195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15196 = [s1,p1,o1__$1,t1,op1,m1];
var inst_15197 = (new cljs.core.PersistentVector(null,6,(5),inst_15195,inst_15196,null));
var inst_15198 = fluree.db.query.range.resolve_match_flake.call(null,db,start_test,inst_15197);
var state_15254__$1 = state_15254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15254__$1,(6),inst_15198);
} else {
if((state_val_15255 === (11))){
var inst_15249 = (state_15254[(2)]);
var _ = (function (){var statearr_15267 = state_15254;
(statearr_15267[(4)] = cljs.core.rest.call(null,(state_15254[(4)])));

return statearr_15267;
})();
var state_15254__$1 = state_15254;
var statearr_15268_15293 = state_15254__$1;
(statearr_15268_15293[(2)] = inst_15249);

(statearr_15268_15293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (9))){
var inst_15223 = (state_15254[(12)]);
var inst_15231 = cljs.core.nth.call(null,inst_15223,(0),null);
var inst_15232 = (function(){throw inst_15231})();
var state_15254__$1 = state_15254;
var statearr_15269_15294 = state_15254__$1;
(statearr_15269_15294[(2)] = inst_15232);

(statearr_15269_15294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (5))){
var _ = (function (){var statearr_15270 = state_15254;
(statearr_15270[(4)] = cljs.core.rest.call(null,(state_15254[(4)])));

return statearr_15270;
})();
var state_15254__$1 = state_15254;
var ex15266 = (state_15254__$1[(2)]);
var statearr_15271_15295 = state_15254__$1;
(statearr_15271_15295[(5)] = ex15266);


if((ex15266 instanceof Error)){
var statearr_15272_15296 = state_15254__$1;
(statearr_15272_15296[(1)] = (4));

(statearr_15272_15296[(5)] = null);

} else {
throw ex15266;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (14))){
var inst_15247 = (state_15254[(2)]);
var state_15254__$1 = state_15254;
var statearr_15273_15297 = state_15254__$1;
(statearr_15273_15297[(2)] = inst_15247);

(statearr_15273_15297[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (16))){
var state_15254__$1 = state_15254;
var statearr_15274_15298 = state_15254__$1;
(statearr_15274_15298[(2)] = null);

(statearr_15274_15298[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (10))){
var inst_15225 = (state_15254[(11)]);
var inst_15211 = (state_15254[(7)]);
var inst_15234 = cljs.core._EQ_.call(null,inst_15225,inst_15211);
var state_15254__$1 = state_15254;
if(inst_15234){
var statearr_15275_15299 = state_15254__$1;
(statearr_15275_15299[(1)] = (12));

} else {
var statearr_15276_15300 = state_15254__$1;
(statearr_15276_15300[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15255 === (8))){
var inst_15225 = (state_15254[(11)]);
var inst_15209 = (state_15254[(8)]);
var inst_15223 = (state_15254[(12)]);
var inst_15223__$1 = (state_15254[(2)]);
var inst_15224 = cljs.core.nth.call(null,inst_15223__$1,(0),null);
var inst_15225__$1 = cljs.core.nth.call(null,inst_15223__$1,(1),null);
var inst_15226 = cljs.core._EQ_.call(null,inst_15225__$1,inst_15209);
var state_15254__$1 = (function (){var statearr_15277 = state_15254;
(statearr_15277[(10)] = inst_15224);

(statearr_15277[(11)] = inst_15225__$1);

(statearr_15277[(12)] = inst_15223__$1);

return statearr_15277;
})();
if(inst_15226){
var statearr_15278_15301 = state_15254__$1;
(statearr_15278_15301[(1)] = (9));

} else {
var statearr_15279_15302 = state_15254__$1;
(statearr_15279_15302[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15280 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15280[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15280[(1)] = (1));

return statearr_15280;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15254){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_15254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15281){var ex__2687__auto__ = e15281;
var statearr_15282_15303 = state_15254;
(statearr_15282_15303[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_15254[(4)]))){
var statearr_15283_15304 = state_15254;
(statearr_15283_15304[(1)] = cljs.core.first.call(null,(state_15254[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15305 = state_15254;
state_15254 = G__15305;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15254){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15284 = f__2707__auto__.call(null);
(statearr_15284[(6)] = c__2706__auto__);

return statearr_15284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o.call(null,f))) && ((fluree.db.flake.o.call(null,f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15361){
var state_val_15362 = (state_15361[(1)]);
if((state_val_15362 === (7))){
var inst_15335 = (state_15361[(7)]);
var inst_15325 = (state_15361[(8)]);
var inst_15333 = fluree.db.flake.Flake__GT_parts.call(null,inst_15325);
var inst_15334 = cljs.core.nth.call(null,inst_15333,(0),null);
var inst_15335__$1 = cljs.core.nth.call(null,inst_15333,(1),null);
var inst_15336 = cljs.core.nth.call(null,inst_15333,(2),null);
var inst_15337 = cljs.core.nth.call(null,inst_15333,(3),null);
var inst_15338 = cljs.core.nth.call(null,inst_15333,(4),null);
var inst_15339 = cljs.core.nth.call(null,inst_15333,(5),null);
var inst_15340 = fluree.db.dbproto._tag.call(null,db,inst_15336,inst_15335__$1);
var state_15361__$1 = (function (){var statearr_15363 = state_15361;
(statearr_15363[(7)] = inst_15335__$1);

(statearr_15363[(9)] = inst_15339);

(statearr_15363[(10)] = inst_15334);

(statearr_15363[(11)] = inst_15338);

(statearr_15363[(12)] = inst_15337);

return statearr_15363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15361__$1,(10),inst_15340);
} else {
if((state_val_15362 === (1))){
var inst_15313 = flakes;
var inst_15314 = cljs.core.seq.call(null,inst_15313);
var inst_15315 = cljs.core.first.call(null,inst_15314);
var inst_15316 = cljs.core.next.call(null,inst_15314);
var inst_15317 = cljs.core.PersistentVector.EMPTY;
var inst_15318 = inst_15313;
var inst_15319 = inst_15317;
var state_15361__$1 = (function (){var statearr_15364 = state_15361;
(statearr_15364[(13)] = inst_15315);

(statearr_15364[(14)] = inst_15319);

(statearr_15364[(15)] = inst_15318);

(statearr_15364[(16)] = inst_15316);

return statearr_15364;
})();
var statearr_15365_15383 = state_15361__$1;
(statearr_15365_15383[(2)] = null);

(statearr_15365_15383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15362 === (4))){
var inst_15325 = (state_15361[(8)]);
var inst_15328 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_15325);
var state_15361__$1 = state_15361;
if(inst_15328){
var statearr_15366_15384 = state_15361__$1;
(statearr_15366_15384[(1)] = (7));

} else {
var statearr_15367_15385 = state_15361__$1;
(statearr_15367_15385[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15362 === (6))){
var inst_15357 = (state_15361[(2)]);
var state_15361__$1 = state_15361;
var statearr_15368_15386 = state_15361__$1;
(statearr_15368_15386[(2)] = inst_15357);

(statearr_15368_15386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15362 === (3))){
var inst_15359 = (state_15361[(2)]);
var state_15361__$1 = state_15361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15361__$1,inst_15359);
} else {
if((state_val_15362 === (2))){
var inst_15318 = (state_15361[(15)]);
var inst_15325 = (state_15361[(8)]);
var inst_15324 = cljs.core.seq.call(null,inst_15318);
var inst_15325__$1 = cljs.core.first.call(null,inst_15324);
var inst_15326 = cljs.core.next.call(null,inst_15324);
var state_15361__$1 = (function (){var statearr_15369 = state_15361;
(statearr_15369[(17)] = inst_15326);

(statearr_15369[(8)] = inst_15325__$1);

return statearr_15369;
})();
if(cljs.core.truth_(inst_15325__$1)){
var statearr_15370_15387 = state_15361__$1;
(statearr_15370_15387[(1)] = (4));

} else {
var statearr_15371_15388 = state_15361__$1;
(statearr_15371_15388[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15362 === (9))){
var inst_15354 = (state_15361[(2)]);
var state_15361__$1 = state_15361;
var statearr_15372_15389 = state_15361__$1;
(statearr_15372_15389[(2)] = inst_15354);

(statearr_15372_15389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15362 === (5))){
var inst_15319 = (state_15361[(14)]);
var state_15361__$1 = state_15361;
var statearr_15373_15390 = state_15361__$1;
(statearr_15373_15390[(2)] = inst_15319);

(statearr_15373_15390[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15362 === (10))){
var inst_15335 = (state_15361[(7)]);
var inst_15326 = (state_15361[(17)]);
var inst_15339 = (state_15361[(9)]);
var inst_15319 = (state_15361[(14)]);
var inst_15334 = (state_15361[(10)]);
var inst_15338 = (state_15361[(11)]);
var inst_15337 = (state_15361[(12)]);
var inst_15342 = (state_15361[(2)]);
var inst_15343 = fluree.db.util.async.throw_err.call(null,inst_15342);
var inst_15344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15345 = [inst_15334,inst_15335,inst_15343,inst_15337,inst_15338,inst_15339];
var inst_15346 = (new cljs.core.PersistentVector(null,6,(5),inst_15344,inst_15345,null));
var inst_15347 = fluree.db.flake.parts__GT_Flake.call(null,inst_15346);
var inst_15348 = cljs.core.conj.call(null,inst_15319,inst_15347);
var inst_15318 = inst_15326;
var inst_15319__$1 = inst_15348;
var state_15361__$1 = (function (){var statearr_15374 = state_15361;
(statearr_15374[(14)] = inst_15319__$1);

(statearr_15374[(15)] = inst_15318);

return statearr_15374;
})();
var statearr_15375_15391 = state_15361__$1;
(statearr_15375_15391[(2)] = null);

(statearr_15375_15391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15362 === (8))){
var inst_15326 = (state_15361[(17)]);
var inst_15319 = (state_15361[(14)]);
var inst_15325 = (state_15361[(8)]);
var inst_15351 = cljs.core.conj.call(null,inst_15319,inst_15325);
var inst_15318 = inst_15326;
var inst_15319__$1 = inst_15351;
var state_15361__$1 = (function (){var statearr_15376 = state_15361;
(statearr_15376[(14)] = inst_15319__$1);

(statearr_15376[(15)] = inst_15318);

return statearr_15376;
})();
var statearr_15377_15392 = state_15361__$1;
(statearr_15377_15392[(2)] = null);

(statearr_15377_15392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0 = (function (){
var statearr_15378 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15378[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__);

(statearr_15378[(1)] = (1));

return statearr_15378;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1 = (function (state_15361){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_15361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15379){var ex__2687__auto__ = e15379;
var statearr_15380_15393 = state_15361;
(statearr_15380_15393[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_15361[(4)]))){
var statearr_15381_15394 = state_15361;
(statearr_15381_15394[(1)] = cljs.core.first.call(null,(state_15361[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15395 = state_15361;
state_15361 = G__15395;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__ = function(state_15361){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1.call(this,state_15361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15382 = f__2707__auto__.call(null);
(statearr_15382[(6)] = c__2706__auto__);

return statearr_15382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15397 = arguments.length;
switch (G__15397) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15580){
var state_val_15581 = (state_15580[(1)]);
if((state_val_15581 === (65))){
var inst_15448 = (state_15580[(7)]);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15448)){
var statearr_15582_15686 = state_15580__$1;
(statearr_15582_15686[(1)] = (68));

} else {
var statearr_15583_15687 = state_15580__$1;
(statearr_15583_15687[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (70))){
var inst_15558 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15584_15688 = state_15580__$1;
(statearr_15584_15688[(2)] = inst_15558);

(statearr_15584_15688[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (62))){
var inst_15524 = (state_15580[(2)]);
var inst_15525 = fluree.db.util.async.throw_err.call(null,inst_15524);
var inst_15526 = cljs.core.take.call(null,(1),inst_15525);
var state_15580__$1 = state_15580;
var statearr_15585_15689 = state_15580__$1;
(statearr_15585_15689[(2)] = inst_15526);

(statearr_15585_15689[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (74))){
var inst_15575 = (state_15580[(2)]);
var _ = (function (){var statearr_15586 = state_15580;
(statearr_15586[(4)] = cljs.core.rest.call(null,(state_15580[(4)])));

return statearr_15586;
})();
var state_15580__$1 = state_15580;
var statearr_15587_15690 = state_15580__$1;
(statearr_15587_15690[(2)] = inst_15575);

(statearr_15587_15690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (7))){
var state_15580__$1 = state_15580;
var statearr_15588_15691 = state_15580__$1;
(statearr_15588_15691[(2)] = false);

(statearr_15588_15691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (59))){
var inst_15448 = (state_15580[(7)]);
var inst_15518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15519 = [inst_15448];
var inst_15520 = (new cljs.core.PersistentVector(null,1,(5),inst_15518,inst_15519,null));
var inst_15521 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15522 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15520,inst_15521);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(62),inst_15522);
} else {
if((state_val_15581 === (20))){
var state_15580__$1 = state_15580;
var statearr_15589_15692 = state_15580__$1;
(statearr_15589_15692[(2)] = null);

(statearr_15589_15692[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (72))){
var inst_15566 = (state_15580[(8)]);
var inst_15569 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_15566);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(75),inst_15569);
} else {
if((state_val_15581 === (58))){
var inst_15516 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15516)){
var statearr_15590_15693 = state_15580__$1;
(statearr_15590_15693[(1)] = (59));

} else {
var statearr_15591_15694 = state_15580__$1;
(statearr_15591_15694[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (60))){
var inst_15409 = (state_15580[(9)]);
var inst_15408 = (state_15580[(10)]);
var inst_15510 = (state_15580[(11)]);
var inst_15411 = (state_15580[(12)]);
var inst_15528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15529 = [inst_15409,inst_15408,null,inst_15411];
var inst_15530 = (new cljs.core.PersistentVector(null,4,(5),inst_15528,inst_15529,null));
var inst_15531 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15510);
var inst_15532 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15530,inst_15531);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(63),inst_15532);
} else {
if((state_val_15581 === (27))){
var inst_15409 = (state_15580[(9)]);
var inst_15408 = (state_15580[(10)]);
var inst_15448 = (state_15580[(7)]);
var inst_15411 = (state_15580[(12)]);
var inst_15460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15461 = [inst_15408,inst_15409,inst_15448,inst_15411];
var inst_15462 = (new cljs.core.PersistentVector(null,4,(5),inst_15460,inst_15461,null));
var inst_15463 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15462,opts);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(30),inst_15463);
} else {
if((state_val_15581 === (1))){
var state_15580__$1 = state_15580;
var statearr_15592_15695 = state_15580__$1;
(statearr_15592_15695[(2)] = null);

(statearr_15592_15695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (69))){
var state_15580__$1 = state_15580;
var statearr_15593_15696 = state_15580__$1;
(statearr_15593_15696[(2)] = null);

(statearr_15593_15696[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (24))){
var inst_15409 = (state_15580[(9)]);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15409)){
var statearr_15594_15697 = state_15580__$1;
(statearr_15594_15697[(1)] = (31));

} else {
var statearr_15595_15698 = state_15580__$1;
(statearr_15595_15698[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (55))){
var inst_15409 = (state_15580[(9)]);
var inst_15511 = (state_15580[(13)]);
var inst_15510 = (state_15580[(2)]);
var inst_15511__$1 = cljs.core._EQ_.call(null,"_id",inst_15409);
var state_15580__$1 = (function (){var statearr_15596 = state_15580;
(statearr_15596[(13)] = inst_15511__$1);

(statearr_15596[(11)] = inst_15510);

return statearr_15596;
})();
if(inst_15511__$1){
var statearr_15597_15699 = state_15580__$1;
(statearr_15597_15699[(1)] = (56));

} else {
var statearr_15598_15700 = state_15580__$1;
(statearr_15598_15700[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (39))){
var inst_15478 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15599_15701 = state_15580__$1;
(statearr_15599_15701[(2)] = inst_15478);

(statearr_15599_15701[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (46))){
var inst_15502 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15502)){
var statearr_15600_15702 = state_15580__$1;
(statearr_15600_15702[(1)] = (50));

} else {
var statearr_15601_15703 = state_15580__$1;
(statearr_15601_15703[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (4))){
var inst_15398 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15602_15704 = state_15580__$1;
(statearr_15602_15704[(2)] = inst_15398);

(statearr_15602_15704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (54))){
var inst_15409 = (state_15580[(9)]);
var inst_15423 = (state_15580[(14)]);
var inst_15418 = (state_15580[(15)]);
var inst_15408 = (state_15580[(10)]);
var inst_15407 = (state_15580[(16)]);
var inst_15412 = (state_15580[(17)]);
var inst_15448 = (state_15580[(7)]);
var inst_15504 = (state_15580[(18)]);
var inst_15411 = (state_15580[(12)]);
var inst_15508 = (function (){var t = inst_15411;
var temp__5802__auto__ = inst_15504;
var p = inst_15409;
var idx_predicate_QMARK_ = inst_15412;
var o = inst_15448;
var vec__15404 = inst_15407;
var tag_predicate_QMARK_ = inst_15418;
var s = inst_15408;
var o_coerce_QMARK_ = inst_15423;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_15580__$1 = state_15580;
var statearr_15603_15705 = state_15580__$1;
(statearr_15603_15705[(2)] = inst_15508);

(statearr_15603_15705[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (15))){
var inst_15410 = (state_15580[(19)]);
var inst_15429 = fluree.db.dbproto._tag_id.call(null,db,inst_15410);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(18),inst_15429);
} else {
if((state_val_15581 === (48))){
var inst_15495 = (state_15580[(20)]);
var state_15580__$1 = state_15580;
var statearr_15604_15706 = state_15580__$1;
(statearr_15604_15706[(2)] = inst_15495);

(statearr_15604_15706[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (50))){
var inst_15504 = (state_15580[(18)]);
var inst_15504__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15580__$1 = (function (){var statearr_15605 = state_15580;
(statearr_15605[(18)] = inst_15504__$1);

return statearr_15605;
})();
if(cljs.core.truth_(inst_15504__$1)){
var statearr_15606_15707 = state_15580__$1;
(statearr_15606_15707[(1)] = (53));

} else {
var statearr_15607_15708 = state_15580__$1;
(statearr_15607_15708[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (75))){
var inst_15571 = (state_15580[(2)]);
var inst_15572 = fluree.db.util.async.throw_err.call(null,inst_15571);
var state_15580__$1 = state_15580;
var statearr_15608_15709 = state_15580__$1;
(statearr_15608_15709[(2)] = inst_15572);

(statearr_15608_15709[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (21))){
var inst_15444 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15609_15710 = state_15580__$1;
(statearr_15609_15710[(2)] = inst_15444);

(statearr_15609_15710[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (31))){
var inst_15448 = (state_15580[(7)]);
var inst_15471 = (state_15580[(21)]);
var inst_15471__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_15448);
var state_15580__$1 = (function (){var statearr_15610 = state_15580;
(statearr_15610[(21)] = inst_15471__$1);

return statearr_15610;
})();
if(inst_15471__$1){
var statearr_15611_15711 = state_15580__$1;
(statearr_15611_15711[(1)] = (34));

} else {
var statearr_15612_15712 = state_15580__$1;
(statearr_15612_15712[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (32))){
var inst_15409 = (state_15580[(9)]);
var state_15580__$1 = state_15580;
var statearr_15613_15713 = state_15580__$1;
(statearr_15613_15713[(2)] = inst_15409);

(statearr_15613_15713[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (40))){
var inst_15409 = (state_15580[(9)]);
var inst_15408 = (state_15580[(10)]);
var inst_15448 = (state_15580[(7)]);
var inst_15411 = (state_15580[(12)]);
var inst_15486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15487 = [inst_15409,inst_15448,inst_15408,inst_15411];
var inst_15488 = (new cljs.core.PersistentVector(null,4,(5),inst_15486,inst_15487,null));
var inst_15489 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15488,opts);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(43),inst_15489);
} else {
if((state_val_15581 === (56))){
var inst_15448 = (state_15580[(7)]);
var inst_15513 = cljs.core.int_QMARK_.call(null,inst_15448);
var state_15580__$1 = state_15580;
var statearr_15614_15714 = state_15580__$1;
(statearr_15614_15714[(2)] = inst_15513);

(statearr_15614_15714[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (33))){
var inst_15484 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15484)){
var statearr_15615_15715 = state_15580__$1;
(statearr_15615_15715[(1)] = (40));

} else {
var statearr_15616_15716 = state_15580__$1;
(statearr_15616_15716[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (13))){
var inst_15410 = (state_15580[(19)]);
var inst_15427 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_15410);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15427)){
var statearr_15617_15717 = state_15580__$1;
(statearr_15617_15717[(1)] = (15));

} else {
var statearr_15618_15718 = state_15580__$1;
(statearr_15618_15718[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (22))){
var inst_15440 = (state_15580[(2)]);
var inst_15441 = fluree.db.util.async.throw_err.call(null,inst_15440);
var state_15580__$1 = state_15580;
var statearr_15619_15719 = state_15580__$1;
(statearr_15619_15719[(2)] = inst_15441);

(statearr_15619_15719[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (36))){
var inst_15481 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15620_15720 = state_15580__$1;
(statearr_15620_15720[(2)] = inst_15481);

(statearr_15620_15720[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (41))){
var inst_15409 = (state_15580[(9)]);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15409)){
var statearr_15621_15721 = state_15580__$1;
(statearr_15621_15721[(1)] = (44));

} else {
var statearr_15622_15722 = state_15580__$1;
(statearr_15622_15722[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (43))){
var inst_15491 = (state_15580[(2)]);
var inst_15492 = fluree.db.util.async.throw_err.call(null,inst_15491);
var state_15580__$1 = state_15580;
var statearr_15623_15723 = state_15580__$1;
(statearr_15623_15723[(2)] = inst_15492);

(statearr_15623_15723[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (61))){
var inst_15537 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15624_15724 = state_15580__$1;
(statearr_15624_15724[(2)] = inst_15537);

(statearr_15624_15724[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (29))){
var inst_15457 = (state_15580[(2)]);
var inst_15458 = fluree.db.util.async.throw_err.call(null,inst_15457);
var state_15580__$1 = state_15580;
var statearr_15625_15725 = state_15580__$1;
(statearr_15625_15725[(2)] = inst_15458);

(statearr_15625_15725[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (44))){
var inst_15412 = (state_15580[(17)]);
var inst_15495 = (state_15580[(20)]);
var inst_15495__$1 = cljs.core.not.call(null,inst_15412);
var state_15580__$1 = (function (){var statearr_15626 = state_15580;
(statearr_15626[(20)] = inst_15495__$1);

return statearr_15626;
})();
if(inst_15495__$1){
var statearr_15627_15726 = state_15580__$1;
(statearr_15627_15726[(1)] = (47));

} else {
var statearr_15628_15727 = state_15580__$1;
(statearr_15628_15727[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (6))){
var inst_15409 = (state_15580[(9)]);
var inst_15414 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15409);
var inst_15415 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15414);
var state_15580__$1 = state_15580;
var statearr_15629_15728 = state_15580__$1;
(statearr_15629_15728[(2)] = inst_15415);

(statearr_15629_15728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (28))){
var inst_15468 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15630_15729 = state_15580__$1;
(statearr_15630_15729[(2)] = inst_15468);

(statearr_15630_15729[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (64))){
var inst_15409 = (state_15580[(9)]);
var inst_15408 = (state_15580[(10)]);
var inst_15448 = (state_15580[(7)]);
var inst_15411 = (state_15580[(12)]);
var inst_15540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15541 = [inst_15409,inst_15408,inst_15448,inst_15411];
var inst_15542 = (new cljs.core.PersistentVector(null,4,(5),inst_15540,inst_15541,null));
var inst_15543 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15542,opts);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(67),inst_15543);
} else {
if((state_val_15581 === (51))){
var inst_15409 = (state_15580[(9)]);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15409)){
var statearr_15631_15730 = state_15580__$1;
(statearr_15631_15730[(1)] = (64));

} else {
var statearr_15632_15731 = state_15580__$1;
(statearr_15632_15731[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (25))){
var inst_15418 = (state_15580[(15)]);
var inst_15566 = (state_15580[(8)]);
var inst_15566__$1 = (state_15580[(2)]);
var inst_15567 = fluree.db.util.log.debug.call(null,"search res:",inst_15566__$1);
var state_15580__$1 = (function (){var statearr_15633 = state_15580;
(statearr_15633[(22)] = inst_15567);

(statearr_15633[(8)] = inst_15566__$1);

return statearr_15633;
})();
if(cljs.core.truth_(inst_15418)){
var statearr_15634_15732 = state_15580__$1;
(statearr_15634_15732[(1)] = (72));

} else {
var statearr_15635_15733 = state_15580__$1;
(statearr_15635_15733[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (34))){
var inst_15412 = (state_15580[(17)]);
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15412)){
var statearr_15636_15734 = state_15580__$1;
(statearr_15636_15734[(1)] = (37));

} else {
var statearr_15637_15735 = state_15580__$1;
(statearr_15637_15735[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (17))){
var inst_15446 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15638_15736 = state_15580__$1;
(statearr_15638_15736[(2)] = inst_15446);

(statearr_15638_15736[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (3))){
var inst_15578 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15580__$1,inst_15578);
} else {
if((state_val_15581 === (12))){
var inst_15410 = (state_15580[(19)]);
var state_15580__$1 = state_15580;
var statearr_15639_15737 = state_15580__$1;
(statearr_15639_15737[(2)] = inst_15410);

(statearr_15639_15737[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (2))){
var inst_15409 = (state_15580[(9)]);
var inst_15407 = (state_15580[(16)]);
var _ = (function (){var statearr_15640 = state_15580;
(statearr_15640[(4)] = cljs.core.cons.call(null,(5),(state_15580[(4)])));

return statearr_15640;
})();
var inst_15407__$1 = fparts;
var inst_15408 = cljs.core.nth.call(null,inst_15407__$1,(0),null);
var inst_15409__$1 = cljs.core.nth.call(null,inst_15407__$1,(1),null);
var inst_15410 = cljs.core.nth.call(null,inst_15407__$1,(2),null);
var inst_15411 = cljs.core.nth.call(null,inst_15407__$1,(3),null);
var inst_15412 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15409__$1);
var state_15580__$1 = (function (){var statearr_15641 = state_15580;
(statearr_15641[(9)] = inst_15409__$1);

(statearr_15641[(10)] = inst_15408);

(statearr_15641[(16)] = inst_15407__$1);

(statearr_15641[(17)] = inst_15412);

(statearr_15641[(12)] = inst_15411);

(statearr_15641[(19)] = inst_15410);

return statearr_15641;
})();
if(cljs.core.truth_(inst_15409__$1)){
var statearr_15642_15738 = state_15580__$1;
(statearr_15642_15738[(1)] = (6));

} else {
var statearr_15643_15739 = state_15580__$1;
(statearr_15643_15739[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (66))){
var inst_15560 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15644_15740 = state_15580__$1;
(statearr_15644_15740[(2)] = inst_15560);

(statearr_15644_15740[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (23))){
var inst_15409 = (state_15580[(9)]);
var inst_15450 = cljs.core._EQ_.call(null,"_id",inst_15409);
var state_15580__$1 = state_15580;
if(inst_15450){
var statearr_15645_15741 = state_15580__$1;
(statearr_15645_15741[(1)] = (26));

} else {
var statearr_15646_15742 = state_15580__$1;
(statearr_15646_15742[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (47))){
var inst_15448 = (state_15580[(7)]);
var state_15580__$1 = state_15580;
var statearr_15647_15743 = state_15580__$1;
(statearr_15647_15743[(2)] = inst_15448);

(statearr_15647_15743[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (35))){
var inst_15471 = (state_15580[(21)]);
var state_15580__$1 = state_15580;
var statearr_15648_15744 = state_15580__$1;
(statearr_15648_15744[(2)] = inst_15471);

(statearr_15648_15744[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (19))){
var inst_15409 = (state_15580[(9)]);
var inst_15410 = (state_15580[(19)]);
var inst_15436 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15409);
var inst_15437 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15436),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15410)].join('');
var inst_15438 = fluree.db.dbproto._tag_id.call(null,db,inst_15437);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(22),inst_15438);
} else {
if((state_val_15581 === (57))){
var inst_15511 = (state_15580[(13)]);
var state_15580__$1 = state_15580;
var statearr_15649_15745 = state_15580__$1;
(statearr_15649_15745[(2)] = inst_15511);

(statearr_15649_15745[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (68))){
var inst_15409 = (state_15580[(9)]);
var inst_15408 = (state_15580[(10)]);
var inst_15448 = (state_15580[(7)]);
var inst_15411 = (state_15580[(12)]);
var inst_15549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15550 = [inst_15448,inst_15409,inst_15408,inst_15411];
var inst_15551 = (new cljs.core.PersistentVector(null,4,(5),inst_15549,inst_15550,null));
var inst_15552 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15551,opts);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(71),inst_15552);
} else {
if((state_val_15581 === (11))){
var inst_15423 = (state_15580[(14)]);
var inst_15423__$1 = (state_15580[(2)]);
var inst_15424 = cljs.core.not.call(null,inst_15423__$1);
var state_15580__$1 = (function (){var statearr_15651 = state_15580;
(statearr_15651[(14)] = inst_15423__$1);

return statearr_15651;
})();
if(inst_15424){
var statearr_15652_15746 = state_15580__$1;
(statearr_15652_15746[(1)] = (12));

} else {
var statearr_15653_15747 = state_15580__$1;
(statearr_15653_15747[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (9))){
var inst_15410 = (state_15580[(19)]);
var inst_15420 = typeof inst_15410 === 'string';
var state_15580__$1 = state_15580;
var statearr_15654_15748 = state_15580__$1;
(statearr_15654_15748[(2)] = inst_15420);

(statearr_15654_15748[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (5))){
var _ = (function (){var statearr_15655 = state_15580;
(statearr_15655[(4)] = cljs.core.rest.call(null,(state_15580[(4)])));

return statearr_15655;
})();
var state_15580__$1 = state_15580;
var ex15650 = (state_15580__$1[(2)]);
var statearr_15656_15749 = state_15580__$1;
(statearr_15656_15749[(5)] = ex15650);


if((ex15650 instanceof Error)){
var statearr_15657_15750 = state_15580__$1;
(statearr_15657_15750[(1)] = (4));

(statearr_15657_15750[(5)] = null);

} else {
throw ex15650;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (14))){
var inst_15408 = (state_15580[(10)]);
var inst_15448 = (state_15580[(2)]);
var state_15580__$1 = (function (){var statearr_15658 = state_15580;
(statearr_15658[(7)] = inst_15448);

return statearr_15658;
})();
if(cljs.core.truth_(inst_15408)){
var statearr_15659_15751 = state_15580__$1;
(statearr_15659_15751[(1)] = (23));

} else {
var statearr_15660_15752 = state_15580__$1;
(statearr_15660_15752[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (45))){
var inst_15409 = (state_15580[(9)]);
var state_15580__$1 = state_15580;
var statearr_15661_15753 = state_15580__$1;
(statearr_15661_15753[(2)] = inst_15409);

(statearr_15661_15753[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (53))){
var inst_15409 = (state_15580[(9)]);
var inst_15423 = (state_15580[(14)]);
var inst_15418 = (state_15580[(15)]);
var inst_15408 = (state_15580[(10)]);
var inst_15407 = (state_15580[(16)]);
var inst_15412 = (state_15580[(17)]);
var inst_15448 = (state_15580[(7)]);
var inst_15504 = (state_15580[(18)]);
var inst_15411 = (state_15580[(12)]);
var inst_15506 = (function (){var obj_fn = inst_15504;
var t = inst_15411;
var temp__5802__auto__ = inst_15504;
var p = inst_15409;
var idx_predicate_QMARK_ = inst_15412;
var o = inst_15448;
var vec__15404 = inst_15407;
var tag_predicate_QMARK_ = inst_15418;
var s = inst_15408;
var o_coerce_QMARK_ = inst_15423;
return (function (x){
var and__5043__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_15580__$1 = state_15580;
var statearr_15662_15754 = state_15580__$1;
(statearr_15662_15754[(2)] = inst_15506);

(statearr_15662_15754[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (26))){
var inst_15408 = (state_15580[(10)]);
var inst_15411 = (state_15580[(12)]);
var inst_15452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15453 = [inst_15408,null,null,inst_15411];
var inst_15454 = (new cljs.core.PersistentVector(null,4,(5),inst_15452,inst_15453,null));
var inst_15455 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15454,opts);
var state_15580__$1 = state_15580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15580__$1,(29),inst_15455);
} else {
if((state_val_15581 === (16))){
var inst_15410 = (state_15580[(19)]);
var inst_15434 = typeof inst_15410 === 'string';
var state_15580__$1 = state_15580;
if(cljs.core.truth_(inst_15434)){
var statearr_15663_15755 = state_15580__$1;
(statearr_15663_15755[(1)] = (19));

} else {
var statearr_15664_15756 = state_15580__$1;
(statearr_15664_15756[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (38))){
var inst_15412 = (state_15580[(17)]);
var state_15580__$1 = state_15580;
var statearr_15665_15757 = state_15580__$1;
(statearr_15665_15757[(2)] = inst_15412);

(statearr_15665_15757[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (30))){
var inst_15465 = (state_15580[(2)]);
var inst_15466 = fluree.db.util.async.throw_err.call(null,inst_15465);
var state_15580__$1 = state_15580;
var statearr_15666_15758 = state_15580__$1;
(statearr_15666_15758[(2)] = inst_15466);

(statearr_15666_15758[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (73))){
var inst_15566 = (state_15580[(8)]);
var state_15580__$1 = state_15580;
var statearr_15667_15759 = state_15580__$1;
(statearr_15667_15759[(2)] = inst_15566);

(statearr_15667_15759[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (10))){
var inst_15418 = (state_15580[(15)]);
var state_15580__$1 = state_15580;
var statearr_15668_15760 = state_15580__$1;
(statearr_15668_15760[(2)] = inst_15418);

(statearr_15668_15760[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (18))){
var inst_15431 = (state_15580[(2)]);
var inst_15432 = fluree.db.util.async.throw_err.call(null,inst_15431);
var state_15580__$1 = state_15580;
var statearr_15669_15761 = state_15580__$1;
(statearr_15669_15761[(2)] = inst_15432);

(statearr_15669_15761[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (52))){
var inst_15562 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15670_15762 = state_15580__$1;
(statearr_15670_15762[(2)] = inst_15562);

(statearr_15670_15762[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (67))){
var inst_15545 = (state_15580[(2)]);
var inst_15546 = fluree.db.util.async.throw_err.call(null,inst_15545);
var state_15580__$1 = state_15580;
var statearr_15671_15763 = state_15580__$1;
(statearr_15671_15763[(2)] = inst_15546);

(statearr_15671_15763[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (71))){
var inst_15554 = (state_15580[(2)]);
var inst_15555 = fluree.db.util.async.throw_err.call(null,inst_15554);
var state_15580__$1 = state_15580;
var statearr_15672_15764 = state_15580__$1;
(statearr_15672_15764[(2)] = inst_15555);

(statearr_15672_15764[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (42))){
var inst_15564 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15673_15765 = state_15580__$1;
(statearr_15673_15765[(2)] = inst_15564);

(statearr_15673_15765[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (37))){
var inst_15448 = (state_15580[(7)]);
var inst_15474 = cljs.core.fn_QMARK_.call(null,inst_15448);
var inst_15475 = (!(inst_15474));
var state_15580__$1 = state_15580;
var statearr_15674_15766 = state_15580__$1;
(statearr_15674_15766[(2)] = inst_15475);

(statearr_15674_15766[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (63))){
var inst_15534 = (state_15580[(2)]);
var inst_15535 = fluree.db.util.async.throw_err.call(null,inst_15534);
var state_15580__$1 = state_15580;
var statearr_15675_15767 = state_15580__$1;
(statearr_15675_15767[(2)] = inst_15535);

(statearr_15675_15767[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (8))){
var inst_15418 = (state_15580[(15)]);
var inst_15418__$1 = (state_15580[(2)]);
var state_15580__$1 = (function (){var statearr_15676 = state_15580;
(statearr_15676[(15)] = inst_15418__$1);

return statearr_15676;
})();
if(cljs.core.truth_(inst_15418__$1)){
var statearr_15677_15768 = state_15580__$1;
(statearr_15677_15768[(1)] = (9));

} else {
var statearr_15678_15769 = state_15580__$1;
(statearr_15678_15769[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15581 === (49))){
var inst_15499 = (state_15580[(2)]);
var state_15580__$1 = state_15580;
var statearr_15679_15770 = state_15580__$1;
(statearr_15679_15770[(2)] = inst_15499);

(statearr_15679_15770[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15680 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15680[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15680[(1)] = (1));

return statearr_15680;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15580){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_15580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15681){var ex__2687__auto__ = e15681;
var statearr_15682_15771 = state_15580;
(statearr_15682_15771[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_15580[(4)]))){
var statearr_15683_15772 = state_15580;
(statearr_15683_15772[(1)] = cljs.core.first.call(null,(state_15580[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15773 = state_15580;
state_15580 = G__15773;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15580){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15684 = f__2707__auto__.call(null);
(statearr_15684[(6)] = c__2706__auto__);

return statearr_15684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15775 = arguments.length;
switch (G__15775) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15810){
var state_val_15811 = (state_15810[(1)]);
if((state_val_15811 === (7))){
var inst_15797 = cljs.core.pr_str.call(null,name);
var inst_15798 = ["Invalid collection name: ",inst_15797].join('');
var inst_15799 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15800 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15801 = cljs.core.PersistentHashMap.fromArrays(inst_15799,inst_15800);
var inst_15802 = cljs.core.ex_info.call(null,inst_15798,inst_15801);
var inst_15803 = (function(){throw inst_15802})();
var state_15810__$1 = state_15810;
var statearr_15812_15832 = state_15810__$1;
(statearr_15812_15832[(2)] = inst_15803);

(statearr_15812_15832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15811 === (1))){
var state_15810__$1 = state_15810;
var statearr_15813_15833 = state_15810__$1;
(statearr_15813_15833[(2)] = null);

(statearr_15813_15833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15811 === (4))){
var inst_15776 = (state_15810[(2)]);
var state_15810__$1 = state_15810;
var statearr_15814_15834 = state_15810__$1;
(statearr_15814_15834[(2)] = inst_15776);

(statearr_15814_15834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15811 === (6))){
var inst_15782 = (state_15810[(7)]);
var inst_15784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15785 = fluree.db.flake.max_subject_id.call(null,inst_15782);
var inst_15786 = [inst_15785];
var inst_15787 = (new cljs.core.PersistentVector(null,1,(5),inst_15784,inst_15786,null));
var inst_15788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15789 = fluree.db.flake.min_subject_id.call(null,inst_15782);
var inst_15790 = [inst_15789];
var inst_15791 = (new cljs.core.PersistentVector(null,1,(5),inst_15788,inst_15790,null));
var inst_15792 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15787,cljs.core._LT__EQ_,inst_15791,opts);
var state_15810__$1 = state_15810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15810__$1,(9),inst_15792);
} else {
if((state_val_15811 === (3))){
var inst_15808 = (state_15810[(2)]);
var state_15810__$1 = state_15810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15810__$1,inst_15808);
} else {
if((state_val_15811 === (2))){
var inst_15782 = (state_15810[(7)]);
var _ = (function (){var statearr_15816 = state_15810;
(statearr_15816[(4)] = cljs.core.cons.call(null,(5),(state_15810[(4)])));

return statearr_15816;
})();
var inst_15782__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15810__$1 = (function (){var statearr_15817 = state_15810;
(statearr_15817[(7)] = inst_15782__$1);

return statearr_15817;
})();
if(cljs.core.truth_(inst_15782__$1)){
var statearr_15818_15835 = state_15810__$1;
(statearr_15818_15835[(1)] = (6));

} else {
var statearr_15819_15836 = state_15810__$1;
(statearr_15819_15836[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15811 === (9))){
var inst_15794 = (state_15810[(2)]);
var inst_15795 = fluree.db.util.async.throw_err.call(null,inst_15794);
var state_15810__$1 = state_15810;
var statearr_15820_15837 = state_15810__$1;
(statearr_15820_15837[(2)] = inst_15795);

(statearr_15820_15837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15811 === (5))){
var _ = (function (){var statearr_15821 = state_15810;
(statearr_15821[(4)] = cljs.core.rest.call(null,(state_15810[(4)])));

return statearr_15821;
})();
var state_15810__$1 = state_15810;
var ex15815 = (state_15810__$1[(2)]);
var statearr_15822_15838 = state_15810__$1;
(statearr_15822_15838[(5)] = ex15815);


var statearr_15823_15839 = state_15810__$1;
(statearr_15823_15839[(1)] = (4));

(statearr_15823_15839[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15811 === (8))){
var inst_15805 = (state_15810[(2)]);
var _ = (function (){var statearr_15824 = state_15810;
(statearr_15824[(4)] = cljs.core.rest.call(null,(state_15810[(4)])));

return statearr_15824;
})();
var state_15810__$1 = state_15810;
var statearr_15825_15840 = state_15810__$1;
(statearr_15825_15840[(2)] = inst_15805);

(statearr_15825_15840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15826 = [null,null,null,null,null,null,null,null];
(statearr_15826[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15826[(1)] = (1));

return statearr_15826;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15810){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_15810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15827){var ex__2687__auto__ = e15827;
var statearr_15828_15841 = state_15810;
(statearr_15828_15841[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_15810[(4)]))){
var statearr_15829_15842 = state_15810;
(statearr_15829_15842[(1)] = cljs.core.first.call(null,(state_15810[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15843 = state_15810;
state_15810 = G__15843;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15810){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15830 = f__2707__auto__.call(null);
(statearr_15830[(6)] = c__2706__auto__);

return statearr_15830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15847 = flakes;
var vec__15848 = G__15847;
var seq__15849 = cljs.core.seq.call(null,vec__15848);
var first__15850 = cljs.core.first.call(null,seq__15849);
var seq__15849__$1 = cljs.core.next.call(null,seq__15849);
var flake_SINGLEQUOTE_ = first__15850;
var r = seq__15849__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15847__$1 = G__15847;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15856 = G__15847__$1;
var seq__15857 = cljs.core.seq.call(null,vec__15856);
var first__15858 = cljs.core.first.call(null,seq__15857);
var seq__15857__$1 = cljs.core.next.call(null,seq__15857);
var flake_SINGLEQUOTE___$1 = first__15858;
var r__$1 = seq__15857__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o.call(null,flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15860){var e = e15860;
return null;
}})();
var map__15859 = cmd_map;
var map__15859__$1 = cljs.core.__destructure_map.call(null,map__15859);
var type = cljs.core.get.call(null,map__15859__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15859__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15859__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15859__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15859__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15859__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15861 = r__$1;
var G__15862 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15847__$1 = G__15861;
result_STAR___$1 = G__15862;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15871 = blocks;
var vec__15872 = G__15871;
var seq__15873 = cljs.core.seq.call(null,vec__15872);
var first__15874 = cljs.core.first.call(null,seq__15873);
var seq__15873__$1 = cljs.core.next.call(null,seq__15873);
var block_SINGLEQUOTE_ = first__15874;
var r = seq__15873__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15871__$1 = G__15871;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15879 = G__15871__$1;
var seq__15880 = cljs.core.seq.call(null,vec__15879);
var first__15881 = cljs.core.first.call(null,seq__15880);
var seq__15880__$1 = cljs.core.next.call(null,seq__15880);
var block_SINGLEQUOTE___$1 = first__15881;
var r__$1 = seq__15880__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15882 = block_SINGLEQUOTE___$1;
var map__15882__$1 = cljs.core.__destructure_map.call(null,map__15882);
var block = cljs.core.get.call(null,map__15882__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15882__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15882__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15863_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15863_SHARP_),(2))){
return fluree.db.flake.o.call(null,p1__15863_SHARP_);
} else {
return null;
}
});})(G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,prev_hash,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15864_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15864_SHARP_),(1))){
return fluree.db.flake.o.call(null,p1__15864_SHARP_);
} else {
return null;
}
});})(G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,prev_hash,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,prev_hash,hash,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15865_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15865_SHARP_),(5))){
return fluree.db.flake.o.call(null,p1__15865_SHARP_);
} else {
return null;
}
});})(G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,prev_hash,hash,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,prev_hash,hash,instant,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15866_SHARP_){
if(cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15866_SHARP_),(7))){
return fluree.db.flake.o.call(null,p1__15866_SHARP_);
} else {
return null;
}
});})(G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,prev_hash,hash,instant,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15867_SHARP_){
return cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,p1__15867_SHARP_),(106));
});})(G__15871__$1,result_STAR___$1,map__15882,map__15882__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15879,seq__15880,first__15881,seq__15880__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15871,vec__15872,seq__15873,first__15874,seq__15873__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15883 = r__$1;
var G__15884 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15871__$1 = G__15883;
result_STAR___$1 = G__15884;
continue;
}
break;
}
});
