// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.analytical');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24758 = arguments.length;
switch (G__24758) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24761 = arguments.length;
switch (G__24761) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24763 = null;
var G__24763__0 = (function (){
return xf.call(null);
});
var G__24763__1 = (function (result){
return xf.call(null,result);
});
var G__24763__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__24763 = function(result,flake){
switch(arguments.length){
case 0:
return G__24763__0.call(this);
case 1:
return G__24763__1.call(this,result);
case 2:
return G__24763__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24763.cljs$core$IFn$_invoke$arity$0 = G__24763__0;
G__24763.cljs$core$IFn$_invoke$arity$1 = G__24763__1;
G__24763.cljs$core$IFn$_invoke$arity$2 = G__24763__2;
return G__24763;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24764_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24764_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24768 = vars;
var vec__24769 = G__24768;
var seq__24770 = cljs.core.seq.call(null,vec__24769);
var first__24771 = cljs.core.first.call(null,seq__24770);
var seq__24770__$1 = cljs.core.next.call(null,seq__24770);
var var$ = first__24771;
var r = seq__24770__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24768__$1 = G__24768;
var all_vars__$1 = all_vars;
while(true){
var vec__24775 = G__24768__$1;
var seq__24776 = cljs.core.seq.call(null,vec__24775);
var first__24777 = cljs.core.first.call(null,seq__24776);
var seq__24776__$1 = cljs.core.next.call(null,seq__24776);
var var$__$1 = first__24777;
var r__$1 = seq__24776__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24778 = r__$1;
var G__24779 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24768__$1 = G__24778;
all_vars__$1 = G__24779;
continue;
} else {
var G__24780 = r__$1;
var G__24781 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24768__$1 = G__24780;
all_vars__$1 = G__24781;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24782){
var vec__24783 = p__24782;
var tuple_index = cljs.core.nth.call(null,vec__24783,(0),null);
var query_map = cljs.core.nth.call(null,vec__24783,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24797){
var state_val_24798 = (state_24797[(1)]);
if((state_val_24798 === (1))){
var inst_24786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24787 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24788 = [query_map,_id,query_opts];
var inst_24789 = cljs.core.PersistentHashMap.fromArrays(inst_24787,inst_24788);
var inst_24790 = fluree.db.query.fql.query.call(null,db,inst_24789);
var state_24797__$1 = (function (){var statearr_24799 = state_24797;
(statearr_24799[(7)] = inst_24786);

return statearr_24799;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24797__$1,(2),inst_24790);
} else {
if((state_val_24798 === (2))){
var inst_24786 = (state_24797[(7)]);
var inst_24792 = (state_24797[(2)]);
var inst_24793 = fluree.db.util.async.throw_err.call(null,inst_24792);
var inst_24794 = [tuple_index,inst_24793];
var inst_24795 = (new cljs.core.PersistentVector(null,2,(5),inst_24786,inst_24794,null));
var state_24797__$1 = state_24797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24797__$1,inst_24795);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0 = (function (){
var statearr_24800 = [null,null,null,null,null,null,null,null];
(statearr_24800[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2684__auto__);

(statearr_24800[(1)] = (1));

return statearr_24800;
});
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1 = (function (state_24797){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_24797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24801){var ex__2687__auto__ = e24801;
var statearr_24802_24805 = state_24797;
(statearr_24802_24805[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_24797[(4)]))){
var statearr_24803_24806 = state_24797;
(statearr_24803_24806[(1)] = cljs.core.first.call(null,(state_24797[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24807 = state_24797;
state_24797 = G__24807;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__ = function(state_24797){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1.call(this,state_24797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24804 = f__2707__auto__.call(null);
(statearr_24804[(6)] = c__2706__auto__);

return statearr_24804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24808 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__24808,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__24808,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24871){
var state_val_24872 = (state_24871[(1)]);
if((state_val_24872 === (7))){
var inst_24866 = (state_24871[(2)]);
var _ = (function (){var statearr_24873 = state_24871;
(statearr_24873[(4)] = cljs.core.rest.call(null,(state_24871[(4)])));

return statearr_24873;
})();
var state_24871__$1 = state_24871;
var statearr_24874_24965 = state_24871__$1;
(statearr_24874_24965[(2)] = inst_24866);

(statearr_24874_24965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (20))){
var inst_24857 = (state_24871[(2)]);
var state_24871__$1 = state_24871;
var statearr_24875_24966 = state_24871__$1;
(statearr_24875_24966[(2)] = inst_24857);

(statearr_24875_24966[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (1))){
var state_24871__$1 = state_24871;
var statearr_24876_24967 = state_24871__$1;
(statearr_24876_24967[(2)] = null);

(statearr_24876_24967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (4))){
var inst_24813 = (state_24871[(2)]);
var state_24871__$1 = state_24871;
var statearr_24877_24968 = state_24871__$1;
(statearr_24877_24968[(2)] = inst_24813);

(statearr_24877_24968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (15))){
var inst_24833 = (state_24871[(7)]);
var inst_24842 = cljs.core.second.call(null,inst_24833);
var inst_24843 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24842);
var inst_24844 = (inst_24843 > max_fuel);
var state_24871__$1 = state_24871;
if(cljs.core.truth_(inst_24844)){
var statearr_24878_24969 = state_24871__$1;
(statearr_24878_24969[(1)] = (18));

} else {
var statearr_24879_24970 = state_24871__$1;
(statearr_24879_24970[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (13))){
var state_24871__$1 = state_24871;
var statearr_24880_24971 = state_24871__$1;
(statearr_24880_24971[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (6))){
var inst_24821 = (state_24871[(8)]);
var state_24871__$1 = state_24871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24871__$1,(8),inst_24821);
} else {
if((state_val_24872 === (17))){
var inst_24860 = (state_24871[(2)]);
var state_24871__$1 = state_24871;
var statearr_24882_24972 = state_24871__$1;
(statearr_24882_24972[(2)] = inst_24860);

(statearr_24882_24972[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (3))){
var inst_24869 = (state_24871[(2)]);
var state_24871__$1 = state_24871;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24871__$1,inst_24869);
} else {
if((state_val_24872 === (12))){
var inst_24822 = (state_24871[(9)]);
var inst_24833 = (state_24871[(7)]);
var inst_24839 = inst_24822.call(null);
var state_24871__$1 = (function (){var statearr_24883 = state_24871;
(statearr_24883[(10)] = inst_24839);

return statearr_24883;
})();
var statearr_24884_24973 = state_24871__$1;
(statearr_24884_24973[(2)] = inst_24833);

(statearr_24884_24973[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (2))){
var inst_24822 = (state_24871[(9)]);
var inst_24821 = (state_24871[(8)]);
var _ = (function (){var statearr_24885 = state_24871;
(statearr_24885[(4)] = cljs.core.cons.call(null,(5),(state_24871[(4)])));

return statearr_24885;
})();
var inst_24819 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_24820 = cljs.core.async.chan.call(null);
var inst_24821__$1 = cljs.core.async.chan.call(null);
var inst_24822__$1 = (function (){var expandMaps = inst_24819;
var queue_ch = inst_24820;
var res_ch = inst_24821__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_24823 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24824 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24825 = cljs.core.assoc.call(null,inst_24823,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24824);
var inst_24826 = (function (){var expandMaps = inst_24819;
var queue_ch = inst_24820;
var res_ch = inst_24821__$1;
var stop_BANG_ = inst_24822__$1;
var opts_STAR_ = inst_24825;
return (function (tuple_res,port){
var c__2706__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24918){
var state_val_24919 = (state_24918[(1)]);
if((state_val_24919 === (7))){
var state_24918__$1 = state_24918;
var statearr_24920_24974 = state_24918__$1;
(statearr_24920_24974[(2)] = tuple_res);

(statearr_24920_24974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24919 === (1))){
var state_24918__$1 = state_24918;
var statearr_24921_24975 = state_24918__$1;
(statearr_24921_24975[(2)] = null);

(statearr_24921_24975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24919 === (4))){
var inst_24886 = (state_24918[(2)]);
var inst_24887 = cljs.core.async.put_BANG_.call(null,port,inst_24886);
var inst_24888 = cljs.core.async.close_BANG_.call(null,port);
var state_24918__$1 = (function (){var statearr_24922 = state_24918;
(statearr_24922[(7)] = inst_24887);

return statearr_24922;
})();
var statearr_24923_24976 = state_24918__$1;
(statearr_24923_24976[(2)] = inst_24888);

(statearr_24923_24976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24919 === (6))){
var inst_24895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24896 = [tuple_res];
var inst_24897 = (new cljs.core.PersistentVector(null,1,(5),inst_24895,inst_24896,null));
var state_24918__$1 = state_24918;
var statearr_24924_24977 = state_24918__$1;
(statearr_24924_24977[(2)] = inst_24897);

(statearr_24924_24977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24919 === (3))){
var inst_24916 = (state_24918[(2)]);
var state_24918__$1 = state_24918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24918__$1,inst_24916);
} else {
if((state_val_24919 === (2))){
var ___$1 = (function (){var statearr_24926 = state_24918;
(statearr_24926[(4)] = cljs.core.cons.call(null,(5),(state_24918[(4)])));

return statearr_24926;
})();
var state_24918__$1 = state_24918;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24927_24978 = state_24918__$1;
(statearr_24927_24978[(1)] = (6));

} else {
var statearr_24928_24979 = state_24918__$1;
(statearr_24928_24979[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24919 === (9))){
var inst_24900 = (state_24918[(8)]);
var inst_24902 = (state_24918[(9)]);
var inst_24909 = (state_24918[(2)]);
var inst_24910 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_24900,inst_24909);
var inst_24911 = inst_24902.call(null,inst_24910);
var inst_24912 = cljs.core.async.put_BANG_.call(null,port,inst_24911);
var inst_24913 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_24929 = state_24918;
(statearr_24929[(4)] = cljs.core.rest.call(null,(state_24918[(4)])));

return statearr_24929;
})();
var state_24918__$1 = (function (){var statearr_24930 = state_24918;
(statearr_24930[(10)] = inst_24912);

return statearr_24930;
})();
var statearr_24931_24980 = state_24918__$1;
(statearr_24931_24980[(2)] = inst_24913);

(statearr_24931_24980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24919 === (5))){
var ___$1 = (function (){var statearr_24932 = state_24918;
(statearr_24932[(4)] = cljs.core.rest.call(null,(state_24918[(4)])));

return statearr_24932;
})();
var state_24918__$1 = state_24918;
var ex24925 = (state_24918__$1[(2)]);
var statearr_24933_24981 = state_24918__$1;
(statearr_24933_24981[(5)] = ex24925);


var statearr_24934_24982 = state_24918__$1;
(statearr_24934_24982[(1)] = (4));

(statearr_24934_24982[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24919 === (8))){
var inst_24900 = (state_24918[(8)]);
var inst_24900__$1 = (state_24918[(2)]);
var inst_24901 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24902 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24900__$1;
var query_fuel = inst_24901;
return (function (p1__24812_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__24812_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24812_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_24903 = cljs.core.PersistentVector.EMPTY;
var inst_24904 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24900__$1;
var query_fuel = inst_24901;
return (function (p1__24811_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24811_SHARP_);
});
})();
var inst_24905 = cljs.core.keep.call(null,inst_24904,expandMaps);
var inst_24906 = cljs.core.async.merge.call(null,inst_24905);
var inst_24907 = cljs.core.async.into.call(null,inst_24903,inst_24906);
var state_24918__$1 = (function (){var statearr_24935 = state_24918;
(statearr_24935[(8)] = inst_24900__$1);

(statearr_24935[(9)] = inst_24902);

return statearr_24935;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24918__$1,(9),inst_24907);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0 = (function (){
var statearr_24936 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24936[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__);

(statearr_24936[(1)] = (1));

return statearr_24936;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1 = (function (state_24918){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_24918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24937){var ex__2687__auto__ = e24937;
var statearr_24938_24983 = state_24918;
(statearr_24938_24983[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_24918[(4)]))){
var statearr_24939_24984 = state_24918;
(statearr_24939_24984[(1)] = cljs.core.first.call(null,(state_24918[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24985 = state_24918;
state_24918 = G__24985;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = function(state_24918){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1.call(this,state_24918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24940 = f__2707__auto__.call(null);
(statearr_24940[(6)] = c__2706__auto____$1);

return statearr_24940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto____$1;
});
})();
var inst_24827 = cljs.core.async.onto_chan_BANG_.call(null,inst_24820,tuples_res);
var inst_24828 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24821__$1,inst_24826,inst_24820);
var inst_24829 = cljs.core.PersistentVector.EMPTY;
var inst_24830 = inst_24829;
var state_24871__$1 = (function (){var statearr_24941 = state_24871;
(statearr_24941[(11)] = inst_24827);

(statearr_24941[(9)] = inst_24822__$1);

(statearr_24941[(8)] = inst_24821__$1);

(statearr_24941[(12)] = inst_24828);

(statearr_24941[(13)] = inst_24830);

return statearr_24941;
})();
var statearr_24942_24986 = state_24871__$1;
(statearr_24942_24986[(2)] = null);

(statearr_24942_24986[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (19))){
var inst_24833 = (state_24871[(7)]);
var inst_24830 = (state_24871[(13)]);
var inst_24853 = cljs.core.first.call(null,inst_24833);
var inst_24854 = cljs.core.conj.call(null,inst_24830,inst_24853);
var inst_24830__$1 = inst_24854;
var state_24871__$1 = (function (){var statearr_24943 = state_24871;
(statearr_24943[(13)] = inst_24830__$1);

return statearr_24943;
})();
var statearr_24944_24987 = state_24871__$1;
(statearr_24944_24987[(2)] = null);

(statearr_24944_24987[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (11))){
var inst_24864 = (state_24871[(2)]);
var state_24871__$1 = state_24871;
var statearr_24946_24988 = state_24871__$1;
(statearr_24946_24988[(2)] = inst_24864);

(statearr_24946_24988[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (9))){
var inst_24830 = (state_24871[(13)]);
var state_24871__$1 = state_24871;
var statearr_24947_24989 = state_24871__$1;
(statearr_24947_24989[(2)] = inst_24830);

(statearr_24947_24989[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (5))){
var _ = (function (){var statearr_24948 = state_24871;
(statearr_24948[(4)] = cljs.core.rest.call(null,(state_24871[(4)])));

return statearr_24948;
})();
var state_24871__$1 = state_24871;
var ex24945 = (state_24871__$1[(2)]);
var statearr_24949_24990 = state_24871__$1;
(statearr_24949_24990[(5)] = ex24945);


if((ex24945 instanceof Error)){
var statearr_24950_24991 = state_24871__$1;
(statearr_24950_24991[(1)] = (4));

(statearr_24950_24991[(5)] = null);

} else {
throw ex24945;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (14))){
var inst_24862 = (state_24871[(2)]);
var state_24871__$1 = state_24871;
var statearr_24951_24992 = state_24871__$1;
(statearr_24951_24992[(2)] = inst_24862);

(statearr_24951_24992[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (16))){
var state_24871__$1 = state_24871;
var statearr_24952_24993 = state_24871__$1;
(statearr_24952_24993[(2)] = null);

(statearr_24952_24993[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (10))){
var inst_24833 = (state_24871[(7)]);
var inst_24837 = fluree.db.util.core.exception_QMARK_.call(null,inst_24833);
var state_24871__$1 = state_24871;
if(inst_24837){
var statearr_24953_24994 = state_24871__$1;
(statearr_24953_24994[(1)] = (12));

} else {
var statearr_24954_24995 = state_24871__$1;
(statearr_24954_24995[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (18))){
var inst_24822 = (state_24871[(9)]);
var inst_24846 = inst_24822.call(null);
var inst_24847 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24848 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24849 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24850 = cljs.core.PersistentHashMap.fromArrays(inst_24848,inst_24849);
var inst_24851 = cljs.core.ex_info.call(null,inst_24847,inst_24850);
var state_24871__$1 = (function (){var statearr_24955 = state_24871;
(statearr_24955[(14)] = inst_24846);

return statearr_24955;
})();
var statearr_24956_24996 = state_24871__$1;
(statearr_24956_24996[(2)] = inst_24851);

(statearr_24956_24996[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24872 === (8))){
var inst_24833 = (state_24871[(7)]);
var inst_24833__$1 = (state_24871[(2)]);
var inst_24834 = (inst_24833__$1 == null);
var state_24871__$1 = (function (){var statearr_24957 = state_24871;
(statearr_24957[(7)] = inst_24833__$1);

return statearr_24957;
})();
if(cljs.core.truth_(inst_24834)){
var statearr_24958_24997 = state_24871__$1;
(statearr_24958_24997[(1)] = (9));

} else {
var statearr_24959_24998 = state_24871__$1;
(statearr_24959_24998[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0 = (function (){
var statearr_24960 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24960[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__);

(statearr_24960[(1)] = (1));

return statearr_24960;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1 = (function (state_24871){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_24871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24961){var ex__2687__auto__ = e24961;
var statearr_24962_24999 = state_24871;
(statearr_24962_24999[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_24871[(4)]))){
var statearr_24963_25000 = state_24871;
(statearr_24963_25000[(1)] = cljs.core.first.call(null,(state_24871[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25001 = state_24871;
state_24871 = G__25001;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = function(state_24871){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1.call(this,state_24871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24964 = f__2707__auto__.call(null);
(statearr_24964[(6)] = c__2706__auto__);

return statearr_24964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__25002 = select;
var map__25002__$1 = cljs.core.__destructure_map.call(null,map__25002);
var as = cljs.core.get.call(null,map__25002__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__25002__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__25002__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__25005 = orderBy;
var order = cljs.core.nth.call(null,vec__25005,(0),null);
var var$ = cljs.core.nth.call(null,vec__25005,(1),null);
var option = cljs.core.nth.call(null,vec__25005,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__25003_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__25003_SHARP_,compare_idx));
}):(function (p1__25004_SHARP_){
return cljs.core.nth.call(null,p1__25004_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__25010 = arguments.length;
switch (G__25010) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__25011,p__25012,group_limit,opts){
var map__25013 = p__25011;
var map__25013__$1 = cljs.core.__destructure_map.call(null,map__25013);
var res = map__25013__$1;
var vars = cljs.core.get.call(null,map__25013__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25014 = p__25012;
var map__25014__$1 = cljs.core.__destructure_map.call(null,map__25014);
var select_spec = map__25014__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__25014__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25151){
var state_val_25152 = (state_25151[(1)]);
if((state_val_25152 === (7))){
var inst_25021 = (state_25151[(7)]);
var state_25151__$1 = state_25151;
var statearr_25153_25255 = state_25151__$1;
(statearr_25153_25255[(2)] = inst_25021);

(statearr_25153_25255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (59))){
var inst_25144 = (state_25151[(2)]);
var state_25151__$1 = state_25151;
var statearr_25154_25256 = state_25151__$1;
(statearr_25154_25256[(2)] = inst_25144);

(statearr_25154_25256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (20))){
var inst_25060 = (state_25151[(8)]);
var inst_25057 = (state_25151[(9)]);
var inst_25056 = (state_25151[(2)]);
var inst_25057__$1 = cljs.core.__destructure_map.call(null,inst_25056);
var inst_25058 = cljs.core.get.call(null,inst_25057__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25059 = cljs.core.get.call(null,inst_25057__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25060__$1 = offset;
var state_25151__$1 = (function (){var statearr_25155 = state_25151;
(statearr_25155[(10)] = inst_25059);

(statearr_25155[(8)] = inst_25060__$1);

(statearr_25155[(9)] = inst_25057__$1);

(statearr_25155[(11)] = inst_25058);

return statearr_25155;
})();
if(cljs.core.truth_(inst_25060__$1)){
var statearr_25156_25257 = state_25151__$1;
(statearr_25156_25257[(1)] = (21));

} else {
var statearr_25157_25258 = state_25151__$1;
(statearr_25157_25258[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (58))){
var inst_25136 = (state_25151[(12)]);
var state_25151__$1 = state_25151;
var statearr_25158_25259 = state_25151__$1;
(statearr_25158_25259[(2)] = inst_25136);

(statearr_25158_25259[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (60))){
var inst_25140 = (state_25151[(2)]);
var inst_25141 = fluree.db.util.async.throw_err.call(null,inst_25140);
var state_25151__$1 = state_25151;
var statearr_25159_25260 = state_25151__$1;
(statearr_25159_25260[(2)] = inst_25141);

(statearr_25159_25260[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (27))){
var inst_25072 = cljs.core.not.call(null,inVector_QMARK_);
var state_25151__$1 = state_25151;
var statearr_25160_25261 = state_25151__$1;
(statearr_25160_25261[(2)] = inst_25072);

(statearr_25160_25261[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (1))){
var state_25151__$1 = state_25151;
var statearr_25161_25262 = state_25151__$1;
(statearr_25161_25262[(2)] = null);

(statearr_25161_25262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (24))){
var state_25151__$1 = state_25151;
var statearr_25162_25263 = state_25151__$1;
(statearr_25162_25263[(2)] = offset);

(statearr_25162_25263[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (55))){
var inst_25130 = (state_25151[(13)]);
var state_25151__$1 = state_25151;
var statearr_25163_25264 = state_25151__$1;
(statearr_25163_25264[(2)] = inst_25130);

(statearr_25163_25264[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (39))){
var inst_25098 = (state_25151[(14)]);
var inst_25100 = cljs.core.distinct.call(null);
var inst_25101 = cljs.core.conj.call(null,inst_25098,inst_25100);
var state_25151__$1 = state_25151;
var statearr_25164_25265 = state_25151__$1;
(statearr_25164_25265[(2)] = inst_25101);

(statearr_25164_25265[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (46))){
var inst_25110 = (state_25151[(15)]);
var state_25151__$1 = state_25151;
var statearr_25165_25266 = state_25151__$1;
(statearr_25165_25266[(2)] = inst_25110);

(statearr_25165_25266[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (4))){
var inst_25015 = (state_25151[(2)]);
var state_25151__$1 = state_25151;
var statearr_25166_25267 = state_25151__$1;
(statearr_25166_25267[(2)] = inst_25015);

(statearr_25166_25267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (54))){
var inst_25124 = (state_25151[(16)]);
var inst_25130 = (state_25151[(13)]);
var inst_25132 = cljs.core.PersistentVector.EMPTY;
var inst_25133 = cljs.core.into.call(null,inst_25132,inst_25124,inst_25130);
var state_25151__$1 = state_25151;
var statearr_25167_25268 = state_25151__$1;
(statearr_25167_25268[(2)] = inst_25133);

(statearr_25167_25268[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (15))){
var inst_25042 = (state_25151[(17)]);
var inst_25044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25045 = [inst_25042];
var inst_25046 = (new cljs.core.PersistentVector(null,1,(5),inst_25044,inst_25045,null));
var state_25151__$1 = state_25151;
var statearr_25168_25269 = state_25151__$1;
(statearr_25168_25269[(2)] = inst_25046);

(statearr_25168_25269[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (48))){
var inst_25116 = (state_25151[(18)]);
var inst_25059 = (state_25151[(10)]);
var inst_25069 = (state_25151[(19)]);
var inst_25075 = (state_25151[(20)]);
var inst_25057 = (state_25151[(9)]);
var inst_25058 = (state_25151[(11)]);
var inst_25080 = (state_25151[(21)]);
var inst_25118 = (function (){var map__25051 = inst_25057;
var headers = inst_25058;
var tuples = inst_25059;
var offset_SINGLEQUOTE_ = inst_25069;
var single_result_QMARK_ = inst_25075;
var pp_keys = inst_25080;
var G__25081 = inst_25116;
return (function (p1__25008_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__25008_SHARP_);
});
})();
var inst_25119 = cljs.core.map.call(null,inst_25118);
var inst_25120 = cljs.core.conj.call(null,inst_25116,inst_25119);
var state_25151__$1 = state_25151;
var statearr_25169_25270 = state_25151__$1;
(statearr_25169_25270[(2)] = inst_25120);

(statearr_25169_25270[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (50))){
var inst_25123 = (state_25151[(2)]);
var inst_25124 = cljs.core.apply.call(null,cljs.core.comp,inst_25123);
var state_25151__$1 = (function (){var statearr_25170 = state_25151;
(statearr_25170[(16)] = inst_25124);

return statearr_25170;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25171_25271 = state_25151__$1;
(statearr_25171_25271[(1)] = (51));

} else {
var statearr_25172_25272 = state_25151__$1;
(statearr_25172_25272[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (21))){
var inst_25062 = cljs.core.not.call(null,groupBy);
var state_25151__$1 = state_25151;
var statearr_25173_25273 = state_25151__$1;
(statearr_25173_25273[(2)] = inst_25062);

(statearr_25173_25273[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (31))){
var state_25151__$1 = state_25151;
var statearr_25174_25274 = state_25151__$1;
(statearr_25174_25274[(2)] = null);

(statearr_25174_25274[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (32))){
var inst_25075 = (state_25151[(20)]);
var inst_25058 = (state_25151[(11)]);
var inst_25080 = (state_25151[(2)]);
var inst_25082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25083 = fluree.db.query.fql.select_tuples_fn.call(null,inst_25058,vars,select);
var inst_25084 = cljs.core.map.call(null,inst_25083);
var inst_25085 = [inst_25084];
var inst_25086 = (new cljs.core.PersistentVector(null,1,(5),inst_25082,inst_25085,null));
var state_25151__$1 = (function (){var statearr_25175 = state_25151;
(statearr_25175[(22)] = inst_25086);

(statearr_25175[(21)] = inst_25080);

return statearr_25175;
})();
if(cljs.core.truth_(inst_25075)){
var statearr_25176_25275 = state_25151__$1;
(statearr_25176_25275[(1)] = (33));

} else {
var statearr_25177_25276 = state_25151__$1;
(statearr_25177_25276[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (40))){
var inst_25098 = (state_25151[(14)]);
var state_25151__$1 = state_25151;
var statearr_25178_25277 = state_25151__$1;
(statearr_25178_25277[(2)] = inst_25098);

(statearr_25178_25277[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (56))){
var inst_25136 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25179 = state_25151;
(statearr_25179[(12)] = inst_25136);

return statearr_25179;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25180_25278 = state_25151__$1;
(statearr_25180_25278[(1)] = (57));

} else {
var statearr_25181_25279 = state_25151__$1;
(statearr_25181_25279[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (33))){
var inst_25086 = (state_25151[(22)]);
var inst_25088 = cljs.core.map.call(null,cljs.core.first);
var inst_25089 = cljs.core.conj.call(null,inst_25086,inst_25088);
var state_25151__$1 = state_25151;
var statearr_25182_25280 = state_25151__$1;
(statearr_25182_25280[(2)] = inst_25089);

(statearr_25182_25280[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (13))){
var inst_25031 = (state_25151[(23)]);
var state_25151__$1 = state_25151;
var statearr_25183_25281 = state_25151__$1;
(statearr_25183_25281[(2)] = inst_25031);

(statearr_25183_25281[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (22))){
var inst_25060 = (state_25151[(8)]);
var state_25151__$1 = state_25151;
var statearr_25184_25282 = state_25151__$1;
(statearr_25184_25282[(2)] = inst_25060);

(statearr_25184_25282[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (36))){
var inst_25092 = (state_25151[(24)]);
var inst_25094 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_25095 = cljs.core.conj.call(null,inst_25092,inst_25094);
var state_25151__$1 = state_25151;
var statearr_25185_25283 = state_25151__$1;
(statearr_25185_25283[(2)] = inst_25095);

(statearr_25185_25283[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (41))){
var inst_25069 = (state_25151[(19)]);
var inst_25104 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25186 = state_25151;
(statearr_25186[(25)] = inst_25104);

return statearr_25186;
})();
if(cljs.core.truth_(inst_25069)){
var statearr_25187_25284 = state_25151__$1;
(statearr_25187_25284[(1)] = (42));

} else {
var statearr_25188_25285 = state_25151__$1;
(statearr_25188_25285[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (43))){
var inst_25104 = (state_25151[(25)]);
var state_25151__$1 = state_25151;
var statearr_25189_25286 = state_25151__$1;
(statearr_25189_25286[(2)] = inst_25104);

(statearr_25189_25286[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (29))){
var inst_25075 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25190 = state_25151;
(statearr_25190[(20)] = inst_25075);

return statearr_25190;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25191_25287 = state_25151__$1;
(statearr_25191_25287[(1)] = (30));

} else {
var statearr_25192_25288 = state_25151__$1;
(statearr_25192_25288[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (44))){
var inst_25110 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25193 = state_25151;
(statearr_25193[(15)] = inst_25110);

return statearr_25193;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25194_25289 = state_25151__$1;
(statearr_25194_25289[(1)] = (45));

} else {
var statearr_25195_25290 = state_25151__$1;
(statearr_25195_25290[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (6))){
var inst_25023 = cljs.core.count.call(null,select);
var inst_25024 = cljs.core._EQ_.call(null,(1),inst_25023);
var state_25151__$1 = state_25151;
var statearr_25196_25291 = state_25151__$1;
(statearr_25196_25291[(2)] = inst_25024);

(statearr_25196_25291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (28))){
var inst_25070 = (state_25151[(26)]);
var state_25151__$1 = state_25151;
var statearr_25197_25292 = state_25151__$1;
(statearr_25197_25292[(2)] = inst_25070);

(statearr_25197_25292[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (51))){
var inst_25059 = (state_25151[(10)]);
var inst_25058 = (state_25151[(11)]);
var inst_25127 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_25058,orderBy,inst_25059);
var state_25151__$1 = state_25151;
var statearr_25198_25293 = state_25151__$1;
(statearr_25198_25293[(2)] = inst_25127);

(statearr_25198_25293[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (25))){
var state_25151__$1 = state_25151;
var statearr_25199_25294 = state_25151__$1;
(statearr_25199_25294[(2)] = null);

(statearr_25199_25294[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (34))){
var inst_25086 = (state_25151[(22)]);
var state_25151__$1 = state_25151;
var statearr_25200_25295 = state_25151__$1;
(statearr_25200_25295[(2)] = inst_25086);

(statearr_25200_25295[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (17))){
var inst_25049 = (state_25151[(2)]);
var state_25151__$1 = state_25151;
var statearr_25201_25296 = state_25151__$1;
(statearr_25201_25296[(2)] = inst_25049);

(statearr_25201_25296[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (3))){
var inst_25149 = (state_25151[(2)]);
var state_25151__$1 = state_25151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25151__$1,inst_25149);
} else {
if((state_val_25152 === (12))){
var inst_25031 = (state_25151[(23)]);
var inst_25033 = cljs.core.first.call(null,select);
var inst_25034 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25033);
var inst_25035 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25034);
var inst_25036 = cljs.core.subs.call(null,inst_25035,(1));
var inst_25037 = [inst_25036];
var inst_25038 = [inst_25031];
var inst_25039 = cljs.core.PersistentHashMap.fromArrays(inst_25037,inst_25038);
var state_25151__$1 = state_25151;
var statearr_25202_25297 = state_25151__$1;
(statearr_25202_25297[(2)] = inst_25039);

(statearr_25202_25297[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (2))){
var inst_25021 = (state_25151[(7)]);
var _ = (function (){var statearr_25203 = state_25151;
(statearr_25203[(4)] = cljs.core.cons.call(null,(5),(state_25151[(4)])));

return statearr_25203;
})();
var inst_25021__$1 = aggregates;
var state_25151__$1 = (function (){var statearr_25204 = state_25151;
(statearr_25204[(7)] = inst_25021__$1);

return statearr_25204;
})();
if(cljs.core.truth_(inst_25021__$1)){
var statearr_25205_25298 = state_25151__$1;
(statearr_25205_25298[(1)] = (6));

} else {
var statearr_25206_25299 = state_25151__$1;
(statearr_25206_25299[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (23))){
var inst_25065 = (state_25151[(2)]);
var state_25151__$1 = state_25151;
if(cljs.core.truth_(inst_25065)){
var statearr_25207_25300 = state_25151__$1;
(statearr_25207_25300[(1)] = (24));

} else {
var statearr_25208_25301 = state_25151__$1;
(statearr_25208_25301[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (47))){
var inst_25116 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25209 = state_25151;
(statearr_25209[(18)] = inst_25116);

return statearr_25209;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25210_25302 = state_25151__$1;
(statearr_25210_25302[(1)] = (48));

} else {
var statearr_25211_25303 = state_25151__$1;
(statearr_25211_25303[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (35))){
var inst_25092 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25212 = state_25151;
(statearr_25212[(24)] = inst_25092);

return statearr_25212;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25213_25304 = state_25151__$1;
(statearr_25213_25304[(1)] = (36));

} else {
var statearr_25214_25305 = state_25151__$1;
(statearr_25214_25305[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (19))){
var state_25151__$1 = state_25151;
var statearr_25215_25306 = state_25151__$1;
(statearr_25215_25306[(2)] = res);

(statearr_25215_25306[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (57))){
var inst_25075 = (state_25151[(20)]);
var inst_25080 = (state_25151[(21)]);
var inst_25136 = (state_25151[(12)]);
var inst_25138 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_25080,inst_25075,db,fuel,max_fuel,opts,(8),inst_25136);
var state_25151__$1 = state_25151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25151__$1,(60),inst_25138);
} else {
if((state_val_25152 === (11))){
var inst_25146 = (state_25151[(2)]);
var _ = (function (){var statearr_25217 = state_25151;
(statearr_25217[(4)] = cljs.core.rest.call(null,(state_25151[(4)])));

return statearr_25217;
})();
var state_25151__$1 = state_25151;
var statearr_25218_25307 = state_25151__$1;
(statearr_25218_25307[(2)] = inst_25146);

(statearr_25218_25307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (9))){
var inst_25029 = cljs.core.first.call(null,aggregates);
var inst_25030 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_25029);
var inst_25031 = cljs.core.second.call(null,inst_25030);
var state_25151__$1 = (function (){var statearr_25219 = state_25151;
(statearr_25219[(23)] = inst_25031);

return statearr_25219;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25220_25308 = state_25151__$1;
(statearr_25220_25308[(1)] = (12));

} else {
var statearr_25221_25309 = state_25151__$1;
(statearr_25221_25309[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (5))){
var _ = (function (){var statearr_25222 = state_25151;
(statearr_25222[(4)] = cljs.core.rest.call(null,(state_25151[(4)])));

return statearr_25222;
})();
var state_25151__$1 = state_25151;
var ex25216 = (state_25151__$1[(2)]);
var statearr_25223_25310 = state_25151__$1;
(statearr_25223_25310[(5)] = ex25216);


if((ex25216 instanceof Error)){
var statearr_25224_25311 = state_25151__$1;
(statearr_25224_25311[(1)] = (4));

(statearr_25224_25311[(5)] = null);

} else {
throw ex25216;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (14))){
var inst_25042 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25225 = state_25151;
(statearr_25225[(17)] = inst_25042);

return statearr_25225;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25226_25312 = state_25151__$1;
(statearr_25226_25312[(1)] = (15));

} else {
var statearr_25227_25313 = state_25151__$1;
(statearr_25227_25313[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (45))){
var inst_25110 = (state_25151[(15)]);
var inst_25112 = cljs.core.take.call(null,group_limit);
var inst_25113 = cljs.core.conj.call(null,inst_25110,inst_25112);
var state_25151__$1 = state_25151;
var statearr_25228_25314 = state_25151__$1;
(statearr_25228_25314[(2)] = inst_25113);

(statearr_25228_25314[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (53))){
var inst_25130 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25229 = state_25151;
(statearr_25229[(13)] = inst_25130);

return statearr_25229;
})();
var statearr_25230_25315 = state_25151__$1;
(statearr_25230_25315[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (26))){
var inst_25070 = (state_25151[(26)]);
var inst_25069 = (state_25151[(2)]);
var inst_25070__$1 = cljs.core.not.call(null,prettyPrint);
var state_25151__$1 = (function (){var statearr_25232 = state_25151;
(statearr_25232[(19)] = inst_25069);

(statearr_25232[(26)] = inst_25070__$1);

return statearr_25232;
})();
if(inst_25070__$1){
var statearr_25233_25316 = state_25151__$1;
(statearr_25233_25316[(1)] = (27));

} else {
var statearr_25234_25317 = state_25151__$1;
(statearr_25234_25317[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (16))){
var inst_25042 = (state_25151[(17)]);
var state_25151__$1 = state_25151;
var statearr_25235_25318 = state_25151__$1;
(statearr_25235_25318[(2)] = inst_25042);

(statearr_25235_25318[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (38))){
var inst_25098 = (state_25151[(2)]);
var state_25151__$1 = (function (){var statearr_25236 = state_25151;
(statearr_25236[(14)] = inst_25098);

return statearr_25236;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25237_25319 = state_25151__$1;
(statearr_25237_25319[(1)] = (39));

} else {
var statearr_25238_25320 = state_25151__$1;
(statearr_25238_25320[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (30))){
var inst_25077 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_25151__$1 = state_25151;
var statearr_25239_25321 = state_25151__$1;
(statearr_25239_25321[(2)] = inst_25077);

(statearr_25239_25321[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (10))){
var state_25151__$1 = state_25151;
if(cljs.core.truth_(aggregates)){
var statearr_25240_25322 = state_25151__$1;
(statearr_25240_25322[(1)] = (18));

} else {
var statearr_25241_25323 = state_25151__$1;
(statearr_25241_25323[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (18))){
var inst_25053 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_25151__$1 = state_25151;
var statearr_25242_25324 = state_25151__$1;
(statearr_25242_25324[(2)] = inst_25053);

(statearr_25242_25324[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (52))){
var inst_25059 = (state_25151[(10)]);
var state_25151__$1 = state_25151;
var statearr_25243_25325 = state_25151__$1;
(statearr_25243_25325[(2)] = inst_25059);

(statearr_25243_25325[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (42))){
var inst_25104 = (state_25151[(25)]);
var inst_25069 = (state_25151[(19)]);
var inst_25106 = cljs.core.drop.call(null,inst_25069);
var inst_25107 = cljs.core.conj.call(null,inst_25104,inst_25106);
var state_25151__$1 = state_25151;
var statearr_25244_25326 = state_25151__$1;
(statearr_25244_25326[(2)] = inst_25107);

(statearr_25244_25326[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (37))){
var inst_25092 = (state_25151[(24)]);
var state_25151__$1 = state_25151;
var statearr_25245_25327 = state_25151__$1;
(statearr_25245_25327[(2)] = inst_25092);

(statearr_25245_25327[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (8))){
var inst_25027 = (state_25151[(2)]);
var state_25151__$1 = state_25151;
if(cljs.core.truth_(inst_25027)){
var statearr_25246_25328 = state_25151__$1;
(statearr_25246_25328[(1)] = (9));

} else {
var statearr_25247_25329 = state_25151__$1;
(statearr_25247_25329[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25152 === (49))){
var inst_25116 = (state_25151[(18)]);
var state_25151__$1 = state_25151;
var statearr_25248_25330 = state_25151__$1;
(statearr_25248_25330[(2)] = inst_25116);

(statearr_25248_25330[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2684__auto__ = null;
var fluree$db$query$fql$state_machine__2684__auto____0 = (function (){
var statearr_25249 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25249[(0)] = fluree$db$query$fql$state_machine__2684__auto__);

(statearr_25249[(1)] = (1));

return statearr_25249;
});
var fluree$db$query$fql$state_machine__2684__auto____1 = (function (state_25151){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_25151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25250){var ex__2687__auto__ = e25250;
var statearr_25251_25331 = state_25151;
(statearr_25251_25331[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_25151[(4)]))){
var statearr_25252_25332 = state_25151;
(statearr_25252_25332[(1)] = cljs.core.first.call(null,(state_25151[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25333 = state_25151;
state_25151 = G__25333;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2684__auto__ = function(state_25151){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2684__auto____1.call(this,state_25151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2684__auto____0;
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2684__auto____1;
return fluree$db$query$fql$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25253 = f__2707__auto__.call(null);
(statearr_25253[(6)] = c__2706__auto__);

return statearr_25253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25336,groupBy){
var map__25337 = p__25336;
var map__25337__$1 = cljs.core.__destructure_map.call(null,map__25337);
var res = map__25337__$1;
var headers = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25338 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25338,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25338,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25334_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25334_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25335_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25335_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25341 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25341,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25341,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25344,headers,group_map){
var map__25345 = p__25344;
var map__25345__$1 = cljs.core.__destructure_map.call(null,map__25345);
var having = map__25345__$1;
var params = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,params,headers);
var filtered = (function (){var G__25352 = group_map;
var vec__25353 = G__25352;
var seq__25354 = cljs.core.seq.call(null,vec__25353);
var first__25355 = cljs.core.first.call(null,seq__25354);
var seq__25354__$1 = cljs.core.next.call(null,seq__25354);
var vec__25356 = first__25355;
var k = cljs.core.nth.call(null,vec__25356,(0),null);
var tuples = cljs.core.nth.call(null,vec__25356,(1),null);
var r = seq__25354__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25352__$1 = G__25352;
var acc__$1 = acc;
while(true){
var vec__25366 = G__25352__$1;
var seq__25367 = cljs.core.seq.call(null,vec__25366);
var first__25368 = cljs.core.first.call(null,seq__25367);
var seq__25367__$1 = cljs.core.next.call(null,seq__25367);
var vec__25369 = first__25368;
var k__$1 = cljs.core.nth.call(null,vec__25369,(0),null);
var tuples__$1 = cljs.core.nth.call(null,vec__25369,(1),null);
var r__$1 = seq__25367__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten.call(null,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,tuples__$1));
var res = (function (){try{return function$.call(null,argument);
}catch (e25372){var e = e25372;
fluree.db.util.log.error.call(null,e,["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join(''));

throw cljs.core.ex_info.call(null,["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message.call(null,e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25373 = r__$1;
var G__25374 = cljs.core.assoc.call(null,acc__$2,k__$1,tuples__$1);
G__25352__$1 = G__25373;
acc__$1 = G__25374;
continue;
} else {
var G__25375 = r__$1;
var G__25376 = acc__$2;
G__25352__$1 = G__25375;
acc__$1 = G__25376;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25377,p__25378,opts){
var map__25379 = p__25377;
var map__25379__$1 = cljs.core.__destructure_map.call(null,map__25379);
var res = map__25379__$1;
var headers = cljs.core.get.call(null,map__25379__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25379__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25380 = p__25378;
var map__25380__$1 = cljs.core.__destructure_map.call(null,map__25380);
var select_spec = map__25380__$1;
var groupBy = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25504){
var state_val_25505 = (state_25504[(1)]);
if((state_val_25505 === (7))){
var state_25504__$1 = state_25504;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25506_25579 = state_25504__$1;
(statearr_25506_25579[(1)] = (30));

} else {
var statearr_25507_25580 = state_25504__$1;
(statearr_25507_25580[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (20))){
var inst_25411 = (state_25504[(2)]);
var state_25504__$1 = (function (){var statearr_25508 = state_25504;
(statearr_25508[(7)] = inst_25411);

return statearr_25508;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25509_25581 = state_25504__$1;
(statearr_25509_25581[(1)] = (21));

} else {
var statearr_25510_25582 = state_25504__$1;
(statearr_25510_25582[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (27))){
var inst_25437 = (state_25504[(8)]);
var state_25504__$1 = state_25504;
var statearr_25511_25583 = state_25504__$1;
(statearr_25511_25583[(2)] = inst_25437);

(statearr_25511_25583[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (1))){
var state_25504__$1 = state_25504;
var statearr_25512_25584 = state_25504__$1;
(statearr_25512_25584[(2)] = null);

(statearr_25512_25584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (24))){
var inst_25448 = (state_25504[(9)]);
var inst_25436 = (state_25504[(10)]);
var inst_25445 = cljs.core.seq.call(null,inst_25436);
var inst_25446 = cljs.core.first.call(null,inst_25445);
var inst_25447 = cljs.core.next.call(null,inst_25445);
var inst_25448__$1 = cljs.core.nth.call(null,inst_25446,(0),null);
var inst_25449 = cljs.core.nth.call(null,inst_25446,(1),null);
var state_25504__$1 = (function (){var statearr_25513 = state_25504;
(statearr_25513[(9)] = inst_25448__$1);

(statearr_25513[(11)] = inst_25447);

(statearr_25513[(12)] = inst_25449);

return statearr_25513;
})();
if(cljs.core.truth_(inst_25448__$1)){
var statearr_25514_25585 = state_25504__$1;
(statearr_25514_25585[(1)] = (26));

} else {
var statearr_25515_25586 = state_25504__$1;
(statearr_25515_25586[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (39))){
var inst_25485 = (state_25504[(2)]);
var state_25504__$1 = state_25504;
var statearr_25516_25587 = state_25504__$1;
(statearr_25516_25587[(2)] = inst_25485);

(statearr_25516_25587[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (4))){
var inst_25381 = (state_25504[(2)]);
var state_25504__$1 = state_25504;
var statearr_25517_25588 = state_25504__$1;
(statearr_25517_25588[(2)] = inst_25381);

(statearr_25517_25588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (15))){
var inst_25401 = (state_25504[(13)]);
var inst_25403 = cljs.core.drop.call(null,offset,inst_25401);
var state_25504__$1 = state_25504;
var statearr_25518_25589 = state_25504__$1;
(statearr_25518_25589[(2)] = inst_25403);

(statearr_25518_25589[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (21))){
var inst_25411 = (state_25504[(7)]);
var inst_25413 = cljs.core.take.call(null,(1),inst_25411);
var state_25504__$1 = state_25504;
var statearr_25519_25590 = state_25504__$1;
(statearr_25519_25590[(2)] = inst_25413);

(statearr_25519_25590[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (31))){
var state_25504__$1 = state_25504;
var statearr_25520_25591 = state_25504__$1;
(statearr_25520_25591[(2)] = limit);

(statearr_25520_25591[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (32))){
var inst_25471 = (state_25504[(2)]);
var inst_25472 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_25471,opts);
var state_25504__$1 = state_25504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25504__$1,(33),inst_25472);
} else {
if((state_val_25505 === (40))){
var inst_25475 = (state_25504[(14)]);
var inst_25488 = cljs.core.first.call(null,inst_25475);
var state_25504__$1 = state_25504;
var statearr_25521_25592 = state_25504__$1;
(statearr_25521_25592[(2)] = inst_25488);

(statearr_25521_25592[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (33))){
var inst_25475 = (state_25504[(14)]);
var inst_25474 = (state_25504[(2)]);
var inst_25475__$1 = fluree.db.util.async.throw_err.call(null,inst_25474);
var inst_25476 = cljs.core.coll_QMARK_.call(null,inst_25475__$1);
var inst_25477 = (!(inst_25476));
var state_25504__$1 = (function (){var statearr_25522 = state_25504;
(statearr_25522[(14)] = inst_25475__$1);

return statearr_25522;
})();
if(inst_25477){
var statearr_25523_25593 = state_25504__$1;
(statearr_25523_25593[(1)] = (34));

} else {
var statearr_25524_25594 = state_25504__$1;
(statearr_25524_25594[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (13))){
var inst_25396 = (state_25504[(15)]);
var state_25504__$1 = state_25504;
var statearr_25525_25595 = state_25504__$1;
(statearr_25525_25595[(2)] = inst_25396);

(statearr_25525_25595[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (22))){
var inst_25411 = (state_25504[(7)]);
var state_25504__$1 = state_25504;
var statearr_25526_25596 = state_25504__$1;
(statearr_25526_25596[(2)] = inst_25411);

(statearr_25526_25596[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (36))){
var inst_25497 = (state_25504[(2)]);
var state_25504__$1 = state_25504;
var statearr_25527_25597 = state_25504__$1;
(statearr_25527_25597[(2)] = inst_25497);

(statearr_25527_25597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (41))){
var state_25504__$1 = state_25504;
var statearr_25528_25598 = state_25504__$1;
(statearr_25528_25598[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (43))){
var inst_25475 = (state_25504[(14)]);
var state_25504__$1 = state_25504;
var statearr_25530_25599 = state_25504__$1;
(statearr_25530_25599[(2)] = inst_25475);

(statearr_25530_25599[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (29))){
var inst_25437 = (state_25504[(8)]);
var inst_25448 = (state_25504[(9)]);
var inst_25447 = (state_25504[(11)]);
var inst_25458 = (state_25504[(2)]);
var inst_25459 = fluree.db.util.async.throw_err.call(null,inst_25458);
var inst_25460 = cljs.core.assoc.call(null,inst_25437,inst_25448,inst_25459);
var inst_25436 = inst_25447;
var inst_25437__$1 = inst_25460;
var state_25504__$1 = (function (){var statearr_25531 = state_25504;
(statearr_25531[(8)] = inst_25437__$1);

(statearr_25531[(10)] = inst_25436);

return statearr_25531;
})();
var statearr_25532_25600 = state_25504__$1;
(statearr_25532_25600[(2)] = null);

(statearr_25532_25600[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (44))){
var state_25504__$1 = state_25504;
var statearr_25533_25601 = state_25504__$1;
(statearr_25533_25601[(2)] = null);

(statearr_25533_25601[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (6))){
var inst_25388 = (state_25504[(16)]);
var inst_25388__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25390 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25504__$1 = (function (){var statearr_25534 = state_25504;
(statearr_25534[(17)] = inst_25390);

(statearr_25534[(16)] = inst_25388__$1);

return statearr_25534;
})();
if(cljs.core.truth_(inst_25388__$1)){
var statearr_25535_25602 = state_25504__$1;
(statearr_25535_25602[(1)] = (9));

} else {
var statearr_25536_25603 = state_25504__$1;
(statearr_25536_25603[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (28))){
var inst_25464 = (state_25504[(2)]);
var state_25504__$1 = state_25504;
var statearr_25537_25604 = state_25504__$1;
(statearr_25537_25604[(2)] = inst_25464);

(statearr_25537_25604[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (25))){
var inst_25466 = (state_25504[(2)]);
var state_25504__$1 = state_25504;
var statearr_25538_25605 = state_25504__$1;
(statearr_25538_25605[(2)] = inst_25466);

(statearr_25538_25605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (34))){
var state_25504__$1 = state_25504;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25539_25606 = state_25504__$1;
(statearr_25539_25606[(1)] = (37));

} else {
var statearr_25540_25607 = state_25504__$1;
(statearr_25540_25607[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (17))){
var inst_25406 = (state_25504[(2)]);
var state_25504__$1 = (function (){var statearr_25541 = state_25504;
(statearr_25541[(18)] = inst_25406);

return statearr_25541;
})();
if(cljs.core.truth_(limit)){
var statearr_25542_25608 = state_25504__$1;
(statearr_25542_25608[(1)] = (18));

} else {
var statearr_25543_25609 = state_25504__$1;
(statearr_25543_25609[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (3))){
var inst_25502 = (state_25504[(2)]);
var state_25504__$1 = state_25504;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25504__$1,inst_25502);
} else {
if((state_val_25505 === (12))){
var inst_25396 = (state_25504[(15)]);
var inst_25398 = fluree.db.query.fql.filter_having.call(null,having,headers,inst_25396);
var state_25504__$1 = state_25504;
var statearr_25544_25610 = state_25504__$1;
(statearr_25544_25610[(2)] = inst_25398);

(statearr_25544_25610[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (2))){
var _ = (function (){var statearr_25545 = state_25504;
(statearr_25545[(4)] = cljs.core.cons.call(null,(5),(state_25504[(4)])));

return statearr_25545;
})();
var state_25504__$1 = state_25504;
if(cljs.core.truth_(groupBy)){
var statearr_25546_25611 = state_25504__$1;
(statearr_25546_25611[(1)] = (6));

} else {
var statearr_25547_25612 = state_25504__$1;
(statearr_25547_25612[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (23))){
var inst_25416 = (state_25504[(2)]);
var inst_25430 = cljs.core.seq.call(null,inst_25416);
var inst_25431 = cljs.core.first.call(null,inst_25430);
var inst_25432 = cljs.core.next.call(null,inst_25430);
var inst_25433 = cljs.core.nth.call(null,inst_25431,(0),null);
var inst_25434 = cljs.core.nth.call(null,inst_25431,(1),null);
var inst_25435 = cljs.core.PersistentHashMap.EMPTY;
var inst_25436 = inst_25416;
var inst_25437 = inst_25435;
var state_25504__$1 = (function (){var statearr_25548 = state_25504;
(statearr_25548[(8)] = inst_25437);

(statearr_25548[(19)] = inst_25433);

(statearr_25548[(20)] = inst_25432);

(statearr_25548[(10)] = inst_25436);

(statearr_25548[(21)] = inst_25434);

return statearr_25548;
})();
var statearr_25549_25613 = state_25504__$1;
(statearr_25549_25613[(2)] = null);

(statearr_25549_25613[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (35))){
var state_25504__$1 = state_25504;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25550_25614 = state_25504__$1;
(statearr_25550_25614[(1)] = (40));

} else {
var statearr_25551_25615 = state_25504__$1;
(statearr_25551_25615[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (19))){
var inst_25406 = (state_25504[(18)]);
var state_25504__$1 = state_25504;
var statearr_25552_25616 = state_25504__$1;
(statearr_25552_25616[(2)] = inst_25406);

(statearr_25552_25616[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (11))){
var inst_25396 = (state_25504[(2)]);
var state_25504__$1 = (function (){var statearr_25554 = state_25504;
(statearr_25554[(15)] = inst_25396);

return statearr_25554;
})();
if(cljs.core.truth_(having)){
var statearr_25555_25617 = state_25504__$1;
(statearr_25555_25617[(1)] = (12));

} else {
var statearr_25556_25618 = state_25504__$1;
(statearr_25556_25618[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (9))){
var inst_25390 = (state_25504[(17)]);
var inst_25388 = (state_25504[(16)]);
var inst_25392 = cljs.core.sorted_map_by.call(null,inst_25388);
var inst_25393 = cljs.core.into.call(null,inst_25392,inst_25390);
var state_25504__$1 = state_25504;
var statearr_25557_25619 = state_25504__$1;
(statearr_25557_25619[(2)] = inst_25393);

(statearr_25557_25619[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (5))){
var _ = (function (){var statearr_25558 = state_25504;
(statearr_25558[(4)] = cljs.core.rest.call(null,(state_25504[(4)])));

return statearr_25558;
})();
var state_25504__$1 = state_25504;
var ex25553 = (state_25504__$1[(2)]);
var statearr_25559_25620 = state_25504__$1;
(statearr_25559_25620[(5)] = ex25553);


if((ex25553 instanceof Error)){
var statearr_25560_25621 = state_25504__$1;
(statearr_25560_25621[(1)] = (4));

(statearr_25560_25621[(5)] = null);

} else {
throw ex25553;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (14))){
var inst_25401 = (state_25504[(2)]);
var state_25504__$1 = (function (){var statearr_25561 = state_25504;
(statearr_25561[(13)] = inst_25401);

return statearr_25561;
})();
if(cljs.core.truth_(offset)){
var statearr_25562_25622 = state_25504__$1;
(statearr_25562_25622[(1)] = (15));

} else {
var statearr_25563_25623 = state_25504__$1;
(statearr_25563_25623[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (45))){
var inst_25493 = (state_25504[(2)]);
var state_25504__$1 = state_25504;
var statearr_25564_25624 = state_25504__$1;
(statearr_25564_25624[(2)] = inst_25493);

(statearr_25564_25624[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (26))){
var inst_25449 = (state_25504[(12)]);
var inst_25451 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25452 = [headers,vars,inst_25449];
var inst_25453 = cljs.core.PersistentHashMap.fromArrays(inst_25451,inst_25452);
var inst_25454 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25455 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25456 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25453,inst_25454,inst_25455);
var state_25504__$1 = state_25504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25504__$1,(29),inst_25456);
} else {
if((state_val_25505 === (16))){
var inst_25401 = (state_25504[(13)]);
var state_25504__$1 = state_25504;
var statearr_25565_25625 = state_25504__$1;
(statearr_25565_25625[(2)] = inst_25401);

(statearr_25565_25625[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (38))){
var inst_25475 = (state_25504[(14)]);
var state_25504__$1 = state_25504;
var statearr_25566_25626 = state_25504__$1;
(statearr_25566_25626[(2)] = inst_25475);

(statearr_25566_25626[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (30))){
var state_25504__$1 = state_25504;
var statearr_25567_25627 = state_25504__$1;
(statearr_25567_25627[(2)] = (1));

(statearr_25567_25627[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (10))){
var inst_25390 = (state_25504[(17)]);
var state_25504__$1 = state_25504;
var statearr_25568_25628 = state_25504__$1;
(statearr_25568_25628[(2)] = inst_25390);

(statearr_25568_25628[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (18))){
var inst_25406 = (state_25504[(18)]);
var inst_25408 = cljs.core.take.call(null,limit,inst_25406);
var state_25504__$1 = state_25504;
var statearr_25569_25629 = state_25504__$1;
(statearr_25569_25629[(2)] = inst_25408);

(statearr_25569_25629[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (42))){
var inst_25495 = (state_25504[(2)]);
var state_25504__$1 = state_25504;
var statearr_25570_25630 = state_25504__$1;
(statearr_25570_25630[(2)] = inst_25495);

(statearr_25570_25630[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (37))){
var inst_25475 = (state_25504[(14)]);
var inst_25480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25481 = [inst_25475];
var inst_25482 = (new cljs.core.PersistentVector(null,1,(5),inst_25480,inst_25481,null));
var state_25504__$1 = state_25504;
var statearr_25571_25631 = state_25504__$1;
(statearr_25571_25631[(2)] = inst_25482);

(statearr_25571_25631[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25505 === (8))){
var inst_25499 = (state_25504[(2)]);
var _ = (function (){var statearr_25572 = state_25504;
(statearr_25572[(4)] = cljs.core.rest.call(null,(state_25504[(4)])));

return statearr_25572;
})();
var state_25504__$1 = state_25504;
var statearr_25573_25632 = state_25504__$1;
(statearr_25573_25632[(2)] = inst_25499);

(statearr_25573_25632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0 = (function (){
var statearr_25574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25574[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__);

(statearr_25574[(1)] = (1));

return statearr_25574;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1 = (function (state_25504){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_25504);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25575){var ex__2687__auto__ = e25575;
var statearr_25576_25633 = state_25504;
(statearr_25576_25633[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_25504[(4)]))){
var statearr_25577_25634 = state_25504;
(statearr_25577_25634[(1)] = cljs.core.first.call(null,(state_25504[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25635 = state_25504;
state_25504 = G__25635;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__ = function(state_25504){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1.call(this,state_25504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25578 = f__2707__auto__.call(null);
(statearr_25578[(6)] = c__2706__auto__);

return statearr_25578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.process_ad_hoc_query = (function fluree$db$query$fql$process_ad_hoc_query(p__25636){
var map__25637 = p__25636;
var map__25637__$1 = cljs.core.__destructure_map.call(null,map__25637);
var opts = map__25637__$1;
var db = cljs.core.get.call(null,map__25637__$1,new cljs.core.Keyword(null,"db","db",993250759));
var parsed_query = cljs.core.get.call(null,map__25637__$1,new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689));
var fuel = cljs.core.get.call(null,map__25637__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.call(null,map__25637__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
fluree.db.util.log.debug.call(null,"process-ad-hoc-query opts:",opts);

var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25658){
var state_val_25659 = (state_25658[(1)]);
if((state_val_25659 === (1))){
var state_25658__$1 = state_25658;
var statearr_25660_25675 = state_25658__$1;
(statearr_25660_25675[(2)] = null);

(statearr_25660_25675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25659 === (2))){
var _ = (function (){var statearr_25661 = state_25658;
(statearr_25661[(4)] = cljs.core.cons.call(null,(5),(state_25658[(4)])));

return statearr_25661;
})();
var inst_25644 = fluree.db.query.analytical.q.call(null,opts);
var state_25658__$1 = state_25658;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25658__$1,(6),inst_25644);
} else {
if((state_val_25659 === (3))){
var inst_25656 = (state_25658[(2)]);
var state_25658__$1 = state_25658;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25658__$1,inst_25656);
} else {
if((state_val_25659 === (4))){
var inst_25638 = (state_25658[(2)]);
var state_25658__$1 = state_25658;
var statearr_25663_25676 = state_25658__$1;
(statearr_25663_25676[(2)] = inst_25638);

(statearr_25663_25676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25659 === (5))){
var _ = (function (){var statearr_25664 = state_25658;
(statearr_25664[(4)] = cljs.core.rest.call(null,(state_25658[(4)])));

return statearr_25664;
})();
var state_25658__$1 = state_25658;
var ex25662 = (state_25658__$1[(2)]);
var statearr_25665_25677 = state_25658__$1;
(statearr_25665_25677[(5)] = ex25662);


if((ex25662 instanceof Error)){
var statearr_25666_25678 = state_25658__$1;
(statearr_25666_25678[(1)] = (4));

(statearr_25666_25678[(5)] = null);

} else {
throw ex25662;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25659 === (6))){
var inst_25646 = (state_25658[(2)]);
var inst_25647 = fluree.db.util.async.throw_err.call(null,inst_25646);
var inst_25648 = fluree.db.util.log.debug.call(null,"process-ad-hoc-query where-result:",inst_25647);
var inst_25649 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25650 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_25647,inst_25649,opts);
var state_25658__$1 = (function (){var statearr_25667 = state_25658;
(statearr_25667[(7)] = inst_25648);

return statearr_25667;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25658__$1,(7),inst_25650);
} else {
if((state_val_25659 === (7))){
var inst_25652 = (state_25658[(2)]);
var inst_25653 = fluree.db.util.async.throw_err.call(null,inst_25652);
var _ = (function (){var statearr_25668 = state_25658;
(statearr_25668[(4)] = cljs.core.rest.call(null,(state_25658[(4)])));

return statearr_25668;
})();
var state_25658__$1 = state_25658;
var statearr_25669_25679 = state_25658__$1;
(statearr_25669_25679[(2)] = inst_25653);

(statearr_25669_25679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0 = (function (){
var statearr_25670 = [null,null,null,null,null,null,null,null];
(statearr_25670[(0)] = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__);

(statearr_25670[(1)] = (1));

return statearr_25670;
});
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1 = (function (state_25658){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_25658);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25671){var ex__2687__auto__ = e25671;
var statearr_25672_25680 = state_25658;
(statearr_25672_25680[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_25658[(4)]))){
var statearr_25673_25681 = state_25658;
(statearr_25673_25681[(1)] = cljs.core.first.call(null,(state_25658[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25682 = state_25658;
state_25658 = G__25682;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__ = function(state_25658){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1.call(this,state_25658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0;
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1;
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25674 = f__2707__auto__.call(null);
(statearr_25674[(6)] = c__2706__auto__);

return statearr_25674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.relationship_binding = (function fluree$db$query$fql$relationship_binding(p__25683){
var map__25684 = p__25683;
var map__25684__$1 = cljs.core.__destructure_map.call(null,map__25684);
var opts = map__25684__$1;
var vars = cljs.core.get.call(null,map__25684__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25720){
var state_val_25721 = (state_25720[(1)]);
if((state_val_25721 === (1))){
var inst_25692 = vars;
var inst_25693 = cljs.core.seq.call(null,inst_25692);
var inst_25694 = cljs.core.first.call(null,inst_25693);
var inst_25695 = cljs.core.next.call(null,inst_25693);
var inst_25696 = cljs.core.PersistentVector.EMPTY;
var inst_25697 = inst_25692;
var inst_25698 = inst_25696;
var state_25720__$1 = (function (){var statearr_25722 = state_25720;
(statearr_25722[(7)] = inst_25697);

(statearr_25722[(8)] = inst_25694);

(statearr_25722[(9)] = inst_25698);

(statearr_25722[(10)] = inst_25695);

return statearr_25722;
})();
var statearr_25723_25736 = state_25720__$1;
(statearr_25723_25736[(2)] = null);

(statearr_25723_25736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25721 === (2))){
var inst_25704 = (state_25720[(11)]);
var inst_25697 = (state_25720[(7)]);
var inst_25703 = cljs.core.seq.call(null,inst_25697);
var inst_25704__$1 = cljs.core.first.call(null,inst_25703);
var inst_25705 = cljs.core.next.call(null,inst_25703);
var state_25720__$1 = (function (){var statearr_25724 = state_25720;
(statearr_25724[(12)] = inst_25705);

(statearr_25724[(11)] = inst_25704__$1);

return statearr_25724;
})();
if(cljs.core.truth_(inst_25704__$1)){
var statearr_25725_25737 = state_25720__$1;
(statearr_25725_25737[(1)] = (4));

} else {
var statearr_25726_25738 = state_25720__$1;
(statearr_25726_25738[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25721 === (3))){
var inst_25718 = (state_25720[(2)]);
var state_25720__$1 = state_25720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25720__$1,inst_25718);
} else {
if((state_val_25721 === (4))){
var inst_25704 = (state_25720[(11)]);
var inst_25707 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_25704);
var inst_25708 = fluree.db.query.fql.process_ad_hoc_query.call(null,inst_25707);
var state_25720__$1 = state_25720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25720__$1,(7),inst_25708);
} else {
if((state_val_25721 === (5))){
var inst_25698 = (state_25720[(9)]);
var state_25720__$1 = state_25720;
var statearr_25727_25739 = state_25720__$1;
(statearr_25727_25739[(2)] = inst_25698);

(statearr_25727_25739[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25721 === (6))){
var inst_25716 = (state_25720[(2)]);
var state_25720__$1 = state_25720;
var statearr_25728_25740 = state_25720__$1;
(statearr_25728_25740[(2)] = inst_25716);

(statearr_25728_25740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25721 === (7))){
var inst_25705 = (state_25720[(12)]);
var inst_25698 = (state_25720[(9)]);
var inst_25710 = (state_25720[(2)]);
var inst_25711 = fluree.db.util.async.throw_err.call(null,inst_25710);
var inst_25712 = cljs.core.into.call(null,inst_25698,inst_25711);
var inst_25697 = inst_25705;
var inst_25698__$1 = inst_25712;
var state_25720__$1 = (function (){var statearr_25729 = state_25720;
(statearr_25729[(7)] = inst_25697);

(statearr_25729[(9)] = inst_25698__$1);

return statearr_25729;
})();
var statearr_25730_25741 = state_25720__$1;
(statearr_25730_25741[(2)] = null);

(statearr_25730_25741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0 = (function (){
var statearr_25731 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25731[(0)] = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__);

(statearr_25731[(1)] = (1));

return statearr_25731;
});
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1 = (function (state_25720){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_25720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25732){var ex__2687__auto__ = e25732;
var statearr_25733_25742 = state_25720;
(statearr_25733_25742[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_25720[(4)]))){
var statearr_25734_25743 = state_25720;
(statearr_25734_25743[(1)] = cljs.core.first.call(null,(state_25720[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25744 = state_25720;
state_25720 = G__25744;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__ = function(state_25720){
switch(arguments.length){
case 0:
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1.call(this,state_25720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0;
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1;
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25735 = f__2707__auto__.call(null);
(statearr_25735[(6)] = c__2706__auto__);

return statearr_25735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,p__25745,query_map){
var map__25746 = p__25745;
var map__25746__$1 = cljs.core.__destructure_map.call(null,map__25746);
var parsed_query = map__25746__$1;
var rel_binding_QMARK_ = cljs.core.get.call(null,map__25746__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var vars = cljs.core.get.call(null,map__25746__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
fluree.db.util.log.debug.call(null,"Running ad hoc query:",query_map);

var map__25747 = query_map;
var map__25747__$1 = cljs.core.__destructure_map.call(null,map__25747);
var selectOne = cljs.core.get.call(null,map__25747__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var limit = cljs.core.get.call(null,map__25747__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25747__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25747__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var orderBy = cljs.core.get.call(null,map__25747__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.call(null,map__25747__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var prettyPrint = cljs.core.get.call(null,map__25747__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var opts = cljs.core.get.call(null,map__25747__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var opts_SINGLEQUOTE_ = cljs.core.dissoc.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877),new cljs.core.Keyword(null,"parseJSON","parseJSON",1986764220).cljs$core$IFn$_invoke$arity$1(opts)),new cljs.core.Keyword(null,"parseJSON","parseJSON",1986764220));
var opts_SINGLEQUOTE___$1 = (function (){var G__25748 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts_SINGLEQUOTE_);
var G__25748__$1 = (cljs.core.truth_(selectOne)?cljs.core.assoc.call(null,G__25748,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1)):G__25748);
return cljs.core.assoc.call(null,G__25748__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"fuel","fuel",10405485),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})(),new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689),parsed_query,new cljs.core.Keyword(null,"query-map","query-map",-808576972),query_map,new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars);

})();
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.fql.relationship_binding.call(null,opts_SINGLEQUOTE___$1);
} else {
return fluree.db.query.fql.process_ad_hoc_query.call(null,opts_SINGLEQUOTE___$1);
}
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25749,p__25750){
var map__25751 = p__25749;
var map__25751__$1 = cljs.core.__destructure_map.call(null,map__25751);
var db = map__25751__$1;
var network = cljs.core.get.call(null,map__25751__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__25751__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.call(null,map__25751__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.call(null,map__25751__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.call(null,map__25751__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25752 = p__25750;
var map__25752__$1 = cljs.core.__destructure_map.call(null,map__25752);
var query_map = map__25752__$1;
var opts = cljs.core.get.call(null,map__25752__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
return oc.call(null,cache_key,(function (_){
var pc = cljs.core.async.promise_chan.call(null);
var c__2706__auto___25769 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25762){
var state_val_25763 = (state_25762[(1)]);
if((state_val_25763 === (1))){
var inst_25753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25754 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25755 = (new cljs.core.PersistentVector(null,2,(5),inst_25753,inst_25754,null));
var inst_25756 = cljs.core.assoc_in.call(null,query_map,inst_25755,false);
var inst_25757 = fluree.db.query.fql.query.call(null,db,inst_25756);
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25762__$1,(2),inst_25757);
} else {
if((state_val_25763 === (2))){
var inst_25759 = (state_25762[(2)]);
var inst_25760 = cljs.core.async.put_BANG_.call(null,pc,inst_25759);
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25762__$1,inst_25760);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0 = (function (){
var statearr_25764 = [null,null,null,null,null,null,null];
(statearr_25764[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2684__auto__);

(statearr_25764[(1)] = (1));

return statearr_25764;
});
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1 = (function (state_25762){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_25762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25765){var ex__2687__auto__ = e25765;
var statearr_25766_25770 = state_25762;
(statearr_25766_25770[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_25762[(4)]))){
var statearr_25767_25771 = state_25762;
(statearr_25767_25771[(1)] = cljs.core.first.call(null,(state_25762[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25772 = state_25762;
state_25762 = G__25772;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__ = function(state_25762){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1.call(this,state_25762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25768 = f__2707__auto__.call(null);
(statearr_25768[(6)] = c__2706__auto___25769);

return statearr_25768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return pc;
}));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25773){
var map__25774 = p__25773;
var map__25774__$1 = cljs.core.__destructure_map.call(null,map__25774);
var _query_map = map__25774__$1;
var opts = cljs.core.get.call(null,map__25774__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",query_map);

if(fluree.db.query.fql.cache_QMARK_.call(null,query_map)){
return fluree.db.query.fql.cache_query.call(null,db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse.call(null,db,query_map);
var db_STAR_ = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl.call(null,db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query.call(null,db_STAR_,parsed_query,query_map);
}
}
});
