// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set.call(null,cljs.core.keys.call(null,fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_14520 = (function (r,node){
var x__5393__auto__ = (((r == null))?null:r);
var m__5394__auto__ = (fluree.db.index.resolve[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,r,node);
} else {
var m__5392__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,r,node);
} else {
throw cljs.core.missing_protocol.call(null,"Resolver.resolve",r);
}
}
});
/**
 * Populate the supplied index branch or leaf node maps with either the child
 *   node attributes or the flakes they store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_14520.call(null,r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14542){
var state_val_14543 = (state_14542[(1)]);
if((state_val_14543 === (1))){
var state_14542__$1 = state_14542;
var statearr_14544_14559 = state_14542__$1;
(statearr_14544_14559[(2)] = null);

(statearr_14544_14559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14543 === (2))){
var _ = (function (){var statearr_14545 = state_14542;
(statearr_14545[(4)] = cljs.core.cons.call(null,(6),(state_14542[(4)])));

return statearr_14545;
})();
var inst_14534 = fluree.db.index.resolve.call(null,r,node);
var state_14542__$1 = state_14542;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14542__$1,(7),inst_14534);
} else {
if((state_val_14543 === (3))){
var inst_14540 = (state_14542[(2)]);
var state_14542__$1 = state_14542;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14542__$1,inst_14540);
} else {
if((state_val_14543 === (4))){
var inst_14521 = (state_14542[(2)]);
var inst_14522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14523 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_14524 = (new cljs.core.PersistentVector(null,3,(5),inst_14522,inst_14523,null));
var inst_14525 = cljs.core.select_keys.call(null,node,inst_14524);
var inst_14526 = fluree.db.util.log.error.call(null,inst_14521,"Error resolving index node:",inst_14525);
var state_14542__$1 = (function (){var statearr_14547 = state_14542;
(statearr_14547[(7)] = inst_14526);

return statearr_14547;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14542__$1,(5),error_ch,inst_14521);
} else {
if((state_val_14543 === (5))){
var inst_14528 = (state_14542[(2)]);
var state_14542__$1 = state_14542;
var statearr_14548_14560 = state_14542__$1;
(statearr_14548_14560[(2)] = inst_14528);

(statearr_14548_14560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14543 === (6))){
var _ = (function (){var statearr_14549 = state_14542;
(statearr_14549[(4)] = cljs.core.rest.call(null,(state_14542[(4)])));

return statearr_14549;
})();
var state_14542__$1 = state_14542;
var ex14546 = (state_14542__$1[(2)]);
var statearr_14550_14561 = state_14542__$1;
(statearr_14550_14561[(5)] = ex14546);


var statearr_14551_14562 = state_14542__$1;
(statearr_14551_14562[(1)] = (4));

(statearr_14551_14562[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14543 === (7))){
var inst_14536 = (state_14542[(2)]);
var inst_14537 = fluree.db.util.async.throw_err.call(null,inst_14536);
var _ = (function (){var statearr_14552 = state_14542;
(statearr_14552[(4)] = cljs.core.rest.call(null,(state_14542[(4)])));

return statearr_14552;
})();
var state_14542__$1 = state_14542;
var statearr_14553_14563 = state_14542__$1;
(statearr_14553_14563[(2)] = inst_14537);

(statearr_14553_14563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2684__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2684__auto____0 = (function (){
var statearr_14554 = [null,null,null,null,null,null,null,null];
(statearr_14554[(0)] = fluree$db$index$try_resolve_$_state_machine__2684__auto__);

(statearr_14554[(1)] = (1));

return statearr_14554;
});
var fluree$db$index$try_resolve_$_state_machine__2684__auto____1 = (function (state_14542){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_14542);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14555){var ex__2687__auto__ = e14555;
var statearr_14556_14564 = state_14542;
(statearr_14556_14564[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_14542[(4)]))){
var statearr_14557_14565 = state_14542;
(statearr_14557_14565[(1)] = cljs.core.first.call(null,(state_14542[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14566 = state_14542;
state_14542 = G__14566;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2684__auto__ = function(state_14542){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2684__auto____1.call(this,state_14542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2684__auto____0;
fluree$db$index$try_resolve_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2684__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14558 = f__2707__auto__.call(null);
(statearr_14558[(6)] = c__2706__auto__);

return statearr_14558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_.call(null,node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_.call(null,node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
/**
 * Clear the populated child node attributes from the supplied `node` map if it
 *   represents a branch, or the populated flakes if `node` represents a leaf.
 */
fluree.db.index.unresolve = (function fluree$db$index$unresolve(node){
if(fluree.db.index.leaf_QMARK_.call(null,node)){
return cljs.core.dissoc.call(null,node,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
} else {
if(fluree.db.index.branch_QMARK_.call(null,node)){
return cljs.core.dissoc.call(null,node,new cljs.core.Keyword(null,"children","children",-940561982));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.index.branch_QMARK_.call(null,branch);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_.call(null,branch);
} else {
return and__5043__auto__;
}
})())){
var map__14567 = branch;
var map__14567__$1 = cljs.core.__destructure_map.call(null,map__14567);
var children = cljs.core.get.call(null,map__14567__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val.call(null,(function (){var or__5045__auto__ = clojure.data.avl.nearest.call(null,children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.first.call(null,children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14603){
var state_val_14604 = (state_14603[(1)]);
if((state_val_14604 === (7))){
var inst_14574 = (state_14603[(7)]);
var state_14603__$1 = state_14603;
var statearr_14605_14636 = state_14603__$1;
(statearr_14605_14636[(2)] = inst_14574);

(statearr_14605_14636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (1))){
var state_14603__$1 = state_14603;
var statearr_14606_14637 = state_14603__$1;
(statearr_14606_14637[(2)] = null);

(statearr_14606_14637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (4))){
var inst_14568 = (state_14603[(2)]);
var state_14603__$1 = state_14603;
var statearr_14607_14638 = state_14603__$1;
(statearr_14607_14638[(2)] = inst_14568);

(statearr_14607_14638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (15))){
var inst_14582 = (state_14603[(8)]);
var inst_14587 = fluree.db.index.resolve.call(null,r,inst_14582);
var state_14603__$1 = state_14603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14603__$1,(17),inst_14587);
} else {
if((state_val_14604 === (13))){
var inst_14595 = (state_14603[(2)]);
var state_14603__$1 = state_14603;
var statearr_14608_14639 = state_14603__$1;
(statearr_14608_14639[(2)] = inst_14595);

(statearr_14608_14639[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (6))){
var inst_14576 = fluree.db.index.resolved_QMARK_.call(null,branch);
var state_14603__$1 = state_14603;
var statearr_14609_14640 = state_14603__$1;
(statearr_14609_14640[(2)] = inst_14576);

(statearr_14609_14640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (17))){
var inst_14589 = (state_14603[(2)]);
var inst_14590 = fluree.db.util.async.throw_err.call(null,inst_14589);
var inst_14582 = inst_14590;
var state_14603__$1 = (function (){var statearr_14610 = state_14603;
(statearr_14610[(8)] = inst_14582);

return statearr_14610;
})();
var statearr_14611_14641 = state_14603__$1;
(statearr_14611_14641[(2)] = null);

(statearr_14611_14641[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (3))){
var inst_14601 = (state_14603[(2)]);
var state_14603__$1 = state_14603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14603__$1,inst_14601);
} else {
if((state_val_14604 === (12))){
var inst_14582 = (state_14603[(8)]);
var inst_14584 = fluree.db.index.leaf_QMARK_.call(null,inst_14582);
var state_14603__$1 = state_14603;
if(inst_14584){
var statearr_14612_14642 = state_14603__$1;
(statearr_14612_14642[(1)] = (14));

} else {
var statearr_14613_14643 = state_14603__$1;
(statearr_14613_14643[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (2))){
var inst_14574 = (state_14603[(7)]);
var _ = (function (){var statearr_14614 = state_14603;
(statearr_14614[(4)] = cljs.core.cons.call(null,(5),(state_14603[(4)])));

return statearr_14614;
})();
var inst_14574__$1 = fluree.db.index.branch_QMARK_.call(null,branch);
var state_14603__$1 = (function (){var statearr_14615 = state_14603;
(statearr_14615[(7)] = inst_14574__$1);

return statearr_14615;
})();
if(inst_14574__$1){
var statearr_14616_14644 = state_14603__$1;
(statearr_14616_14644[(1)] = (6));

} else {
var statearr_14617_14645 = state_14603__$1;
(statearr_14617_14645[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (11))){
var inst_14598 = (state_14603[(2)]);
var _ = (function (){var statearr_14619 = state_14603;
(statearr_14619[(4)] = cljs.core.rest.call(null,(state_14603[(4)])));

return statearr_14619;
})();
var state_14603__$1 = state_14603;
var statearr_14620_14646 = state_14603__$1;
(statearr_14620_14646[(2)] = inst_14598);

(statearr_14620_14646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (9))){
var inst_14581 = fluree.db.index.lookup.call(null,branch,flake);
var inst_14582 = inst_14581;
var state_14603__$1 = (function (){var statearr_14621 = state_14603;
(statearr_14621[(8)] = inst_14582);

return statearr_14621;
})();
var statearr_14622_14647 = state_14603__$1;
(statearr_14622_14647[(2)] = null);

(statearr_14622_14647[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (5))){
var _ = (function (){var statearr_14623 = state_14603;
(statearr_14623[(4)] = cljs.core.rest.call(null,(state_14603[(4)])));

return statearr_14623;
})();
var state_14603__$1 = state_14603;
var ex14618 = (state_14603__$1[(2)]);
var statearr_14624_14648 = state_14603__$1;
(statearr_14624_14648[(5)] = ex14618);


if((ex14618 instanceof Error)){
var statearr_14625_14649 = state_14603__$1;
(statearr_14625_14649[(1)] = (4));

(statearr_14625_14649[(5)] = null);

} else {
throw ex14618;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (14))){
var inst_14582 = (state_14603[(8)]);
var state_14603__$1 = state_14603;
var statearr_14626_14650 = state_14603__$1;
(statearr_14626_14650[(2)] = inst_14582);

(statearr_14626_14650[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (16))){
var inst_14593 = (state_14603[(2)]);
var state_14603__$1 = state_14603;
var statearr_14627_14651 = state_14603__$1;
(statearr_14627_14651[(2)] = inst_14593);

(statearr_14627_14651[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (10))){
var state_14603__$1 = state_14603;
var statearr_14628_14652 = state_14603__$1;
(statearr_14628_14652[(2)] = null);

(statearr_14628_14652[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14604 === (8))){
var inst_14579 = (state_14603[(2)]);
var state_14603__$1 = state_14603;
if(cljs.core.truth_(inst_14579)){
var statearr_14629_14653 = state_14603__$1;
(statearr_14629_14653[(1)] = (9));

} else {
var statearr_14630_14654 = state_14603__$1;
(statearr_14630_14654[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_14631 = [null,null,null,null,null,null,null,null,null];
(statearr_14631[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2684__auto__);

(statearr_14631[(1)] = (1));

return statearr_14631;
});
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1 = (function (state_14603){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_14603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14632){var ex__2687__auto__ = e14632;
var statearr_14633_14655 = state_14603;
(statearr_14633_14655[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_14603[(4)]))){
var statearr_14634_14656 = state_14603;
(statearr_14634_14656[(1)] = cljs.core.first.call(null,(state_14603[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14657 = state_14603;
state_14603 = G__14657;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__ = function(state_14603){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1.call(this,state_14603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14635 = f__2707__auto__.call(null);
(statearr_14635[(6)] = c__2706__auto__);

return statearr_14635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.call(null,cljs.core.update.call(null,leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.call(null,cljs.core._PLUS_,size,cljs.core.map.call(null,fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14658 = new_leaf;
var G__14658__$1 = (((G__14658 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14658));
if((G__14658__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__14658__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.call(null,new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.call(null,cljs.core.update.call(null,leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.call(null,cljs.core._,size,cljs.core.map.call(null,fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14659 = new_leaf;
var G__14659__$1 = (((G__14659 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14659));
if((G__14659__$1 == null)){
return null;
} else {
return cljs.core.first.call(null,G__14659__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.call(null,new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by.call(null,cmp);
return fluree.db.index.add_flakes.call(null,cljs.core.assoc.call(null,fluree.db.index.empty_leaf.call(null,network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14660,p__14661){
var map__14662 = p__14660;
var map__14662__$1 = cljs.core.__destructure_map.call(null,map__14662);
var branch = map__14662__$1;
var cmp = cljs.core.get.call(null,map__14662__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.call(null,map__14662__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.call(null,map__14662__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14662__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14663 = p__14661;
var map__14663__$1 = cljs.core.__destructure_map.call(null,map__14663);
var node = map__14663__$1;
var node_first = cljs.core.get.call(null,map__14663__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.call(null,map__14663__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_.call(null,branch)))){
return false;
} else {
var and__5043__auto__ = (function (){var or__5045__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (!((cmp.call(null,first_flake,node_first) > (0))));
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!((cmp.call(null,node_rhs,rhs) > (0))))))));
} else {
return and__5043__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14664){
var map__14665 = p__14664;
var map__14665__$1 = cljs.core.__destructure_map.call(null,map__14665);
var node = map__14665__$1;
var first = cljs.core.get.call(null,map__14665__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var child_node = fluree.db.index.unresolve.call(null,node);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,child_node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__5775__auto__ = [];
var len__5769__auto___14668 = arguments.length;
var i__5770__auto___14669 = (0);
while(true){
if((i__5770__auto___14669 < len__5769__auto___14668)){
args__5775__auto__.push((arguments[i__5770__auto___14669]));

var G__14670 = (i__5770__auto___14669 + (1));
i__5770__auto___14669 = G__14670;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.call(null,fluree.db.index.child_entry,child_nodes));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14666){
var G__14667 = cljs.core.first.call(null,seq14666);
var seq14666__$1 = cljs.core.next.call(null,seq14666);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14667,seq14666__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf.call(null,network,ledger_id,cmp);
var children = fluree.db.index.child_map.call(null,cmp,child_node);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14671,new_child_nodes){
var map__14672 = p__14671;
var map__14672__$1 = cljs.core.__destructure_map.call(null,map__14672);
var branch = map__14672__$1;
var comparator = cljs.core.get.call(null,map__14672__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.call(null,map__14672__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.call(null,fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__5045__auto__ = (function (){var G__14673 = new_kids;
var G__14673__$1 = (((G__14673 == null))?null:cljs.core.first.call(null,G__14673));
if((G__14673__$1 == null)){
return null;
} else {
return cljs.core.key.call(null,G__14673__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.call(null,cljs.core._PLUS_,size,cljs.core.map.call(null,new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids);
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children.call(null,fluree.db.index.empty_branch.call(null,network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t.call(null,flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.call(null,cljs.core.partial.call(null,fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all.call(null,flakes,fluree.db.index.filter_after.call(null,t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14674,through_t,novelty){
var map__14675 = p__14674;
var map__14675__$1 = cljs.core.__destructure_map.call(null,map__14675);
var node = map__14675__$1;
var first_flake = cljs.core.get.call(null,map__14675__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.call(null,map__14675__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14675__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
fluree.db.util.log.debug.call(null,"novelty-subrange: first-flake:",first_flake,"\nrhs:",rhs,"\nleftmost?",leftmost_QMARK_);

var subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through.call(null,through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.call(null,(function (flakes__$1){
var last_flake = cljs.core.last.call(null,flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op.call(null,last_flake))){
return cljs.core.butlast.call(null,flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.partition_by.call(null,cljs.core.juxt.call(null,fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.partial.call(null,fluree.db.index.after_t_QMARK_,t)),flakes)));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14676,novelty,from_t,to_t){
var map__14677 = p__14676;
var map__14677__$1 = cljs.core.__destructure_map.call(null,map__14677);
var leaf = map__14677__$1;
var leaf_t = cljs.core.get.call(null,map__14677__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__14677__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14678 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all.call(null,G__14678,fluree.db.index.novelty_subrange.call(null,leaf,to_t,novelty));
} else {
return G__14678;
}
})();
var stale_flakes = fluree.db.index.stale_by.call(null,from_t,latest);
var subsequent = fluree.db.index.filter_after.call(null,to_t,latest);
var out_of_range = cljs.core.concat.call(null,stale_flakes,subsequent);
return fluree.db.flake.disj_all.call(null,latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14684){
var self__ = this;
var map__14685 = p__14684;
var map__14685__$1 = cljs.core.__destructure_map.call(null,map__14685);
var node = map__14685__$1;
var id = cljs.core.get.call(null,map__14685__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.call(null,map__14685__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.call(null,map__14685__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_.call(null,node)){
return fluree.db.index.resolve.call(null,self__.node_resolver,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null),(function (___$2){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14703){
var state_val_14704 = (state_14703[(1)]);
if((state_val_14704 === (1))){
var state_14703__$1 = state_14703;
var statearr_14705_14729 = state_14703__$1;
(statearr_14705_14729[(2)] = null);

(statearr_14705_14729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14704 === (2))){
var ___$3 = (function (){var statearr_14706 = state_14703;
(statearr_14706[(4)] = cljs.core.cons.call(null,(5),(state_14703[(4)])));

return statearr_14706;
})();
var inst_14692 = fluree.db.index.resolve.call(null,self__.node_resolver,node);
var state_14703__$1 = state_14703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14703__$1,(6),inst_14692);
} else {
if((state_val_14704 === (3))){
var inst_14701 = (state_14703[(2)]);
var state_14703__$1 = state_14703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14703__$1,inst_14701);
} else {
if((state_val_14704 === (4))){
var inst_14686 = (state_14703[(2)]);
var state_14703__$1 = state_14703;
var statearr_14708_14730 = state_14703__$1;
(statearr_14708_14730[(2)] = inst_14686);

(statearr_14708_14730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14704 === (5))){
var ___$3 = (function (){var statearr_14709 = state_14703;
(statearr_14709[(4)] = cljs.core.rest.call(null,(state_14703[(4)])));

return statearr_14709;
})();
var state_14703__$1 = state_14703;
var ex14707 = (state_14703__$1[(2)]);
var statearr_14710_14731 = state_14703__$1;
(statearr_14710_14731[(5)] = ex14707);


if((ex14707 instanceof Error)){
var statearr_14711_14732 = state_14703__$1;
(statearr_14711_14732[(1)] = (4));

(statearr_14711_14732[(5)] = null);

} else {
throw ex14707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14704 === (6))){
var inst_14694 = (state_14703[(2)]);
var inst_14695 = fluree.db.util.async.throw_err.call(null,inst_14694);
var inst_14696 = fluree.db.index.t_range.call(null,inst_14695,self__.novelty,self__.from_t,self__.to_t);
var inst_14697 = cljs.core.dissoc.call(null,inst_14695,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14698 = cljs.core.assoc.call(null,inst_14697,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14696);
var ___$3 = (function (){var statearr_14712 = state_14703;
(statearr_14712[(4)] = cljs.core.rest.call(null,(state_14703[(4)])));

return statearr_14712;
})();
var state_14703__$1 = state_14703;
var statearr_14713_14733 = state_14703__$1;
(statearr_14713_14733[(2)] = inst_14698);

(statearr_14713_14733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2684__auto__ = null;
var fluree$db$index$state_machine__2684__auto____0 = (function (){
var statearr_14714 = [null,null,null,null,null,null,null];
(statearr_14714[(0)] = fluree$db$index$state_machine__2684__auto__);

(statearr_14714[(1)] = (1));

return statearr_14714;
});
var fluree$db$index$state_machine__2684__auto____1 = (function (state_14703){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_14703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14715){var ex__2687__auto__ = e14715;
var statearr_14716_14734 = state_14703;
(statearr_14716_14734[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_14703[(4)]))){
var statearr_14717_14735 = state_14703;
(statearr_14717_14735[(1)] = cljs.core.first.call(null,(state_14703[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14736 = state_14703;
state_14703 = G__14736;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$state_machine__2684__auto__ = function(state_14703){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2684__auto____1.call(this,state_14703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2684__auto____0;
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2684__auto____1;
return fluree$db$index$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14718 = f__2707__auto__.call(null);
(statearr_14718[(6)] = c__2706__auto__);

return statearr_14718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k14680,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__14719 = k14680;
var G__14719__$1 = (((G__14719 instanceof cljs.core.Keyword))?G__14719.fqn:null);
switch (G__14719__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k14680,else__5346__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__14720){
var vec__14721 = p__14720;
var k__5367__auto__ = cljs.core.nth.call(null,vec__14721,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__14721,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14679){
var self__ = this;
var G__14679__$1 = this;
return (new cljs.core.RecordIter((0),G__14679__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14681,other14682){
var self__ = this;
var this14681__$1 = this;
return (((!((other14682 == null)))) && ((((this14681__$1.constructor === other14682.constructor)) && (((cljs.core._EQ_.call(null,this14681__$1.node_resolver,other14682.node_resolver)) && (((cljs.core._EQ_.call(null,this14681__$1.novelty,other14682.novelty)) && (((cljs.core._EQ_.call(null,this14681__$1.from_t,other14682.from_t)) && (((cljs.core._EQ_.call(null,this14681__$1.to_t,other14682.to_t)) && (((cljs.core._EQ_.call(null,this14681__$1.async_cache,other14682.async_cache)) && (cljs.core._EQ_.call(null,this14681__$1.__extmap,other14682.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k14680){
var self__ = this;
var this__5350__auto____$1 = this;
var G__14724 = k14680;
var G__14724__$1 = (((G__14724 instanceof cljs.core.Keyword))?G__14724.fqn:null);
switch (G__14724__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k14680);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__14679){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__14725 = cljs.core.keyword_identical_QMARK_;
var expr__14726 = k__5352__auto__;
if(cljs.core.truth_(pred__14725.call(null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),expr__14726))){
return (new fluree.db.index.CachedTRangeResolver(G__14679,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14725.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__14726))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14679,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14725.call(null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),expr__14726))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14679,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14725.call(null,new cljs.core.Keyword(null,"to-t","to-t",569467359),expr__14726))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14679,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__14725.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__14726))){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14679,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__14679),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__14679){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14679,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14683){
var extmap__5385__auto__ = (function (){var G__14728 = cljs.core.dissoc.call(null,G__14683,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
if(cljs.core.record_QMARK_.call(null,G__14683)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__14728);
} else {
return G__14728;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14683),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14683),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14683),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14683),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14683),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14739,t,idx_novelty){
var map__14740 = p__14739;
var map__14740__$1 = cljs.core.__destructure_map.call(null,map__14740);
var leaf = map__14740__$1;
var leaf_t = cljs.core.get.call(null,map__14740__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.call(null,map__14740__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.call(null,map__14740__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.call(null,map__14740__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.call(null,leaf_t,t)){
return leaf;
} else {
var G__14741 = leaf;
var G__14741__$1 = (((leaf_t > t))?fluree.db.index.add_flakes.call(null,G__14741,fluree.db.index.novelty_subrange.call(null,leaf,t,idx_novelty)):G__14741);
var G__14741__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes.call(null,G__14741__$1,fluree.db.index.filter_after.call(null,t,flakes)):G__14741__$1);
return cljs.core.assoc.call(null,G__14741__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.call(null,node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.call(null,node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_(resolve_QMARK_.call(null,node))){
return fluree.db.index.try_resolve.call(null,r,error_ch,node);
} else {
var G__14742 = cljs.core.async.chan.call(null);
cljs.core.async.put_BANG_.call(null,G__14742,node);

return G__14742;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_.call(null,branch))){
return cljs.core.async.map.call(null,cljs.core.vector,cljs.core.map.call(null,(function (p__14743){
var vec__14744 = p__14743;
var _ = cljs.core.nth.call(null,vec__14744,(0),null);
var child = cljs.core.nth.call(null,vec__14744,(1),null);
return fluree.db.index.resolve_when.call(null,r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14749){
var state_val_14750 = (state_14749[(1)]);
if((state_val_14750 === (1))){
var inst_14747 = cljs.core.PersistentVector.EMPTY;
var state_14749__$1 = state_14749;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14749__$1,inst_14747);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0 = (function (){
var statearr_14751 = [null,null,null,null,null,null,null];
(statearr_14751[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2684__auto__);

(statearr_14751[(1)] = (1));

return statearr_14751;
});
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1 = (function (state_14749){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_14749);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14752){var ex__2687__auto__ = e14752;
var statearr_14753_14756 = state_14749;
(statearr_14753_14756[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_14749[(4)]))){
var statearr_14754_14757 = state_14749;
(statearr_14754_14757[(1)] = cljs.core.first.call(null,(state_14749[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14758 = state_14749;
state_14749 = G__14758;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__ = function(state_14749){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1.call(this,state_14749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14755 = f__2707__auto__.call(null);
(statearr_14755[(6)] = c__2706__auto__);

return statearr_14755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14760 = arguments.length;
switch (G__14760) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.call(null,r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.call(null,n,xf);
var c__2706__auto___14838 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14806){
var state_val_14807 = (state_14806[(1)]);
if((state_val_14807 === (7))){
var inst_14801 = (state_14806[(2)]);
var state_14806__$1 = state_14806;
var statearr_14808_14839 = state_14806__$1;
(statearr_14808_14839[(2)] = inst_14801);

(statearr_14808_14839[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (1))){
var inst_14761 = fluree.db.index.resolve_when.call(null,r,resolve_QMARK_,error_ch,root);
var state_14806__$1 = state_14806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14806__$1,(2),inst_14761);
} else {
if((state_val_14807 === (4))){
var inst_14803 = (state_14806[(2)]);
var inst_14804 = cljs.core.async.close_BANG_.call(null,out);
var state_14806__$1 = (function (){var statearr_14809 = state_14806;
(statearr_14809[(7)] = inst_14803);

return statearr_14809;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14806__$1,inst_14804);
} else {
if((state_val_14807 === (15))){
var state_14806__$1 = state_14806;
var statearr_14810_14840 = state_14806__$1;
(statearr_14810_14840[(2)] = null);

(statearr_14810_14840[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (13))){
var inst_14798 = (state_14806[(2)]);
var state_14806__$1 = state_14806;
var statearr_14811_14841 = state_14806__$1;
(statearr_14811_14841[(2)] = inst_14798);

(statearr_14811_14841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (6))){
var state_14806__$1 = state_14806;
var statearr_14812_14842 = state_14806__$1;
(statearr_14812_14842[(2)] = null);

(statearr_14812_14842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (17))){
var inst_14783 = (state_14806[(2)]);
var state_14806__$1 = state_14806;
var statearr_14813_14843 = state_14806__$1;
(statearr_14813_14843[(2)] = inst_14783);

(statearr_14813_14843[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (3))){
var inst_14769 = (state_14806[(8)]);
var inst_14767 = (state_14806[(9)]);
var inst_14769__$1 = cljs.core.peek.call(null,inst_14767);
var state_14806__$1 = (function (){var statearr_14814 = state_14806;
(statearr_14814[(8)] = inst_14769__$1);

return statearr_14814;
})();
if(cljs.core.truth_(inst_14769__$1)){
var statearr_14815_14844 = state_14806__$1;
(statearr_14815_14844[(1)] = (5));

} else {
var statearr_14816_14845 = state_14806__$1;
(statearr_14816_14845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (12))){
var inst_14769 = (state_14806[(8)]);
var inst_14789 = fluree.db.index.resolve_children_when.call(null,r,resolve_QMARK_,error_ch,inst_14769);
var state_14806__$1 = state_14806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14806__$1,(18),inst_14789);
} else {
if((state_val_14807 === (2))){
var inst_14763 = (state_14806[(2)]);
var inst_14764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14765 = [inst_14763];
var inst_14766 = (new cljs.core.PersistentVector(null,1,(5),inst_14764,inst_14765,null));
var inst_14767 = inst_14766;
var state_14806__$1 = (function (){var statearr_14817 = state_14806;
(statearr_14817[(9)] = inst_14767);

return statearr_14817;
})();
var statearr_14818_14846 = state_14806__$1;
(statearr_14818_14846[(2)] = null);

(statearr_14818_14846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (11))){
var inst_14769 = (state_14806[(8)]);
var inst_14779 = include_QMARK_.call(null,inst_14769);
var state_14806__$1 = state_14806;
if(cljs.core.truth_(inst_14779)){
var statearr_14819_14847 = state_14806__$1;
(statearr_14819_14847[(1)] = (14));

} else {
var statearr_14820_14848 = state_14806__$1;
(statearr_14820_14848[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (9))){
var inst_14769 = (state_14806[(8)]);
var inst_14775 = fluree.db.index.expanded_QMARK_.call(null,inst_14769);
var state_14806__$1 = state_14806;
var statearr_14821_14849 = state_14806__$1;
(statearr_14821_14849[(2)] = inst_14775);

(statearr_14821_14849[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (5))){
var inst_14772 = (state_14806[(10)]);
var inst_14769 = (state_14806[(8)]);
var inst_14767 = (state_14806[(9)]);
var inst_14771 = cljs.core.pop.call(null,inst_14767);
var inst_14772__$1 = fluree.db.index.leaf_QMARK_.call(null,inst_14769);
var state_14806__$1 = (function (){var statearr_14822 = state_14806;
(statearr_14822[(11)] = inst_14771);

(statearr_14822[(10)] = inst_14772__$1);

return statearr_14822;
})();
if(inst_14772__$1){
var statearr_14823_14850 = state_14806__$1;
(statearr_14823_14850[(1)] = (8));

} else {
var statearr_14824_14851 = state_14806__$1;
(statearr_14824_14851[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (14))){
var inst_14769 = (state_14806[(8)]);
var inst_14781 = fluree.db.index.unmark_expanded.call(null,inst_14769);
var state_14806__$1 = state_14806;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14806__$1,(17),out,inst_14781);
} else {
if((state_val_14807 === (16))){
var inst_14771 = (state_14806[(11)]);
var inst_14786 = (state_14806[(2)]);
var inst_14767 = inst_14771;
var state_14806__$1 = (function (){var statearr_14825 = state_14806;
(statearr_14825[(12)] = inst_14786);

(statearr_14825[(9)] = inst_14767);

return statearr_14825;
})();
var statearr_14826_14852 = state_14806__$1;
(statearr_14826_14852[(2)] = null);

(statearr_14826_14852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (10))){
var inst_14777 = (state_14806[(2)]);
var state_14806__$1 = state_14806;
if(cljs.core.truth_(inst_14777)){
var statearr_14827_14853 = state_14806__$1;
(statearr_14827_14853[(1)] = (11));

} else {
var statearr_14828_14854 = state_14806__$1;
(statearr_14828_14854[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (18))){
var inst_14771 = (state_14806[(11)]);
var inst_14769 = (state_14806[(8)]);
var inst_14791 = (state_14806[(2)]);
var inst_14792 = fluree.db.index.mark_expanded.call(null,inst_14769);
var inst_14793 = cljs.core.conj.call(null,inst_14771,inst_14792);
var inst_14794 = cljs.core.rseq.call(null,inst_14791);
var inst_14795 = cljs.core.into.call(null,inst_14793,inst_14794);
var inst_14767 = inst_14795;
var state_14806__$1 = (function (){var statearr_14829 = state_14806;
(statearr_14829[(9)] = inst_14767);

return statearr_14829;
})();
var statearr_14830_14855 = state_14806__$1;
(statearr_14830_14855[(2)] = null);

(statearr_14830_14855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14807 === (8))){
var inst_14772 = (state_14806[(10)]);
var state_14806__$1 = state_14806;
var statearr_14831_14856 = state_14806__$1;
(statearr_14831_14856[(2)] = inst_14772);

(statearr_14831_14856[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2684__auto__ = null;
var fluree$db$index$state_machine__2684__auto____0 = (function (){
var statearr_14832 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14832[(0)] = fluree$db$index$state_machine__2684__auto__);

(statearr_14832[(1)] = (1));

return statearr_14832;
});
var fluree$db$index$state_machine__2684__auto____1 = (function (state_14806){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_14806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14833){var ex__2687__auto__ = e14833;
var statearr_14834_14857 = state_14806;
(statearr_14834_14857[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_14806[(4)]))){
var statearr_14835_14858 = state_14806;
(statearr_14835_14858[(1)] = cljs.core.first.call(null,(state_14806[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14859 = state_14806;
state_14806 = G__14859;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$state_machine__2684__auto__ = function(state_14806){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2684__auto____1.call(this,state_14806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2684__auto____0;
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2684__auto____1;
return fluree$db$index$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14836 = f__2707__auto__.call(null);
(statearr_14836[(6)] = c__2706__auto___14838);

return statearr_14836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

