// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25777 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__25777,(0),null);
var network = cljs.core.nth.call(null,vec__25777,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__25777,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_.call(null,fluree.db.graphdb.exclude_predicates,fluree.db.flake.p.call(null,f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement.call(null,fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25780){
var map__25781 = p__25780;
var map__25781__$1 = cljs.core.__destructure_map.call(null,map__25781);
var opts = map__25781__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__25781__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25841){
var state_val_25842 = (state_25841[(1)]);
if((state_val_25842 === (7))){
var inst_25812 = cljs.core.not.call(null,reindex_QMARK_);
var state_25841__$1 = state_25841;
var statearr_25843_25867 = state_25841__$1;
(statearr_25843_25867[(2)] = inst_25812);

(statearr_25843_25867[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (1))){
var state_25841__$1 = state_25841;
var statearr_25844_25868 = state_25841__$1;
(statearr_25844_25868[(2)] = null);

(statearr_25844_25868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (4))){
var inst_25782 = (state_25841[(2)]);
var state_25841__$1 = state_25841;
var statearr_25845_25869 = state_25841__$1;
(statearr_25845_25869[(2)] = inst_25782);

(statearr_25845_25869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (6))){
var inst_25796 = (state_25841[(7)]);
var inst_25802 = (state_25841[(8)]);
var inst_25810 = (state_25841[(9)]);
var inst_25795 = (state_25841[(2)]);
var inst_25796__$1 = fluree.db.util.async.throw_err.call(null,inst_25795);
var inst_25797 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25798 = cljs.core.__destructure_map.call(null,inst_25797);
var inst_25799 = cljs.core.get.call(null,inst_25798,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25800 = cljs.core.get.call(null,inst_25798,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25801 = fluree.db.flake.size_bytes.call(null,inst_25796__$1);
var inst_25802__$1 = (inst_25800 + inst_25801);
var inst_25803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25804 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25805 = (new cljs.core.PersistentVector(null,2,(5),inst_25803,inst_25804,null));
var inst_25806 = cljs.core.get_in.call(null,db,inst_25805);
var inst_25807 = cljs.core.__destructure_map.call(null,inst_25806);
var inst_25808 = cljs.core.get.call(null,inst_25807,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25809 = cljs.core.get.call(null,inst_25807,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25810__$1 = (inst_25802__$1 > inst_25809);
var state_25841__$1 = (function (){var statearr_25846 = state_25841;
(statearr_25846[(7)] = inst_25796__$1);

(statearr_25846[(8)] = inst_25802__$1);

(statearr_25846[(9)] = inst_25810__$1);

(statearr_25846[(10)] = inst_25799);

(statearr_25846[(11)] = inst_25808);

return statearr_25846;
})();
if(cljs.core.truth_(inst_25810__$1)){
var statearr_25847_25870 = state_25841__$1;
(statearr_25847_25870[(1)] = (7));

} else {
var statearr_25848_25871 = state_25841__$1;
(statearr_25848_25871[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (3))){
var inst_25839 = (state_25841[(2)]);
var state_25841__$1 = state_25841;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25841__$1,inst_25839);
} else {
if((state_val_25842 === (12))){
var inst_25796 = (state_25841[(7)]);
var inst_25802 = (state_25841[(8)]);
var inst_25799 = (state_25841[(10)]);
var inst_25825 = (state_25841[(2)]);
var inst_25826 = cljs.core.into.call(null,inst_25799,inst_25796);
var inst_25827 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25828 = cljs.core.swap_BANG_.call(null,inst_25827,cljs.core.empty);
var inst_25829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25830 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25831 = (new cljs.core.PersistentVector(null,2,(5),inst_25829,inst_25830,null));
var inst_25832 = cljs.core.assoc_in.call(null,db,inst_25831,inst_25826);
var inst_25833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25834 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25835 = (new cljs.core.PersistentVector(null,2,(5),inst_25833,inst_25834,null));
var inst_25836 = cljs.core.assoc_in.call(null,inst_25832,inst_25835,inst_25802);
var _ = (function (){var statearr_25849 = state_25841;
(statearr_25849[(4)] = cljs.core.rest.call(null,(state_25841[(4)])));

return statearr_25849;
})();
var state_25841__$1 = (function (){var statearr_25850 = state_25841;
(statearr_25850[(12)] = inst_25825);

(statearr_25850[(13)] = inst_25828);

return statearr_25850;
})();
var statearr_25851_25872 = state_25841__$1;
(statearr_25851_25872[(2)] = inst_25836);

(statearr_25851_25872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (2))){
var _ = (function (){var statearr_25852 = state_25841;
(statearr_25852[(4)] = cljs.core.cons.call(null,(5),(state_25841[(4)])));

return statearr_25852;
})();
var inst_25790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25791 = [pred_id];
var inst_25792 = (new cljs.core.PersistentVector(null,1,(5),inst_25790,inst_25791,null));
var inst_25793 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25792);
var state_25841__$1 = state_25841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25841__$1,(6),inst_25793);
} else {
if((state_val_25842 === (11))){
var state_25841__$1 = state_25841;
var statearr_25854_25873 = state_25841__$1;
(statearr_25854_25873[(2)] = null);

(statearr_25854_25873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (9))){
var inst_25815 = (state_25841[(2)]);
var state_25841__$1 = state_25841;
if(cljs.core.truth_(inst_25815)){
var statearr_25855_25874 = state_25841__$1;
(statearr_25855_25874[(1)] = (10));

} else {
var statearr_25856_25875 = state_25841__$1;
(statearr_25856_25875[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (5))){
var _ = (function (){var statearr_25857 = state_25841;
(statearr_25857[(4)] = cljs.core.rest.call(null,(state_25841[(4)])));

return statearr_25857;
})();
var state_25841__$1 = state_25841;
var ex25853 = (state_25841__$1[(2)]);
var statearr_25858_25876 = state_25841__$1;
(statearr_25858_25876[(5)] = ex25853);


if((ex25853 instanceof Error)){
var statearr_25859_25877 = state_25841__$1;
(statearr_25859_25877[(1)] = (4));

(statearr_25859_25877[(5)] = null);

} else {
throw ex25853;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (10))){
var inst_25817 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25818 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25819 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25820 = cljs.core.PersistentHashMap.fromArrays(inst_25818,inst_25819);
var inst_25821 = cljs.core.ex_info.call(null,inst_25817,inst_25820);
var inst_25822 = (function(){throw inst_25821})();
var state_25841__$1 = state_25841;
var statearr_25860_25878 = state_25841__$1;
(statearr_25860_25878[(2)] = inst_25822);

(statearr_25860_25878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25842 === (8))){
var inst_25810 = (state_25841[(9)]);
var state_25841__$1 = state_25841;
var statearr_25861_25879 = state_25841__$1;
(statearr_25861_25879[(2)] = inst_25810);

(statearr_25861_25879[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0 = (function (){
var statearr_25862 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25862[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__);

(statearr_25862[(1)] = (1));

return statearr_25862;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1 = (function (state_25841){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_25841);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25863){var ex__2687__auto__ = e25863;
var statearr_25864_25880 = state_25841;
(statearr_25864_25880[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_25841[(4)]))){
var statearr_25865_25881 = state_25841;
(statearr_25865_25881[(1)] = cljs.core.first.call(null,(state_25841[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25882 = state_25841;
state_25841 = G__25882;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__ = function(state_25841){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1.call(this,state_25841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25866 = f__2707__auto__.call(null);
(statearr_25866[(6)] = c__2706__auto__);

return statearr_25866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25885 = arguments.length;
switch (G__25885) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26085){
var state_val_26086 = (state_26085[(1)]);
if((state_val_26086 === (7))){
var state_26085__$1 = state_26085;
var statearr_26087_26154 = state_26085__$1;
(statearr_26087_26154[(2)] = null);

(statearr_26087_26154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (20))){
var inst_26005 = (state_26085[(7)]);
var inst_25922 = (state_26085[(8)]);
var inst_26006 = (state_26085[(9)]);
var inst_25972 = (state_26085[(10)]);
var inst_25921 = (state_26085[(11)]);
var inst_26010 = (state_26085[(12)]);
var inst_26009 = (state_26085[(13)]);
var inst_26007 = (state_26085[(14)]);
var inst_26008 = (state_26085[(15)]);
var inst_26020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26021 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26022 = (new cljs.core.PersistentVector(null,2,(5),inst_26020,inst_26021,null));
var inst_26023 = cljs.core.get_in.call(null,inst_25972,inst_26022);
var inst_26024 = (inst_26023 + inst_25921);
var inst_26025 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26026 = [inst_26005,inst_26006,inst_26007,inst_26008,inst_26009,inst_26024];
var inst_26027 = cljs.core.PersistentHashMap.fromArrays(inst_26025,inst_26026);
var inst_26028 = cljs.core.assoc.call(null,inst_25972,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26010,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26027);
var state_26085__$1 = (function (){var statearr_26088 = state_26085;
(statearr_26088[(16)] = inst_26028);

return statearr_26088;
})();
if(cljs.core.truth_(inst_25922)){
var statearr_26089_26155 = state_26085__$1;
(statearr_26089_26155[(1)] = (23));

} else {
var statearr_26090_26156 = state_26085__$1;
(statearr_26090_26156[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (27))){
var inst_26028 = (state_26085[(16)]);
var state_26085__$1 = state_26085;
var statearr_26091_26157 = state_26085__$1;
(statearr_26091_26157[(2)] = inst_26028);

(statearr_26091_26157[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (1))){
var state_26085__$1 = state_26085;
var statearr_26092_26158 = state_26085__$1;
(statearr_26092_26158[(2)] = null);

(statearr_26092_26158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (24))){
var inst_26028 = (state_26085[(16)]);
var inst_26032 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26028);
var inst_26033 = (inst_26032 == null);
var state_26085__$1 = state_26085;
var statearr_26093_26159 = state_26085__$1;
(statearr_26093_26159[(2)] = inst_26033);

(statearr_26093_26159[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (39))){
var inst_26058 = (state_26085[(17)]);
var inst_26060 = (state_26085[(18)]);
var inst_26017 = (state_26085[(19)]);
var inst_26067 = (state_26085[(20)]);
var inst_26009 = (state_26085[(13)]);
var inst_26016 = (state_26085[(21)]);
var inst_26059 = (state_26085[(22)]);
var inst_26074 = (state_26085[(2)]);
var inst_26075 = cljs.core.conj.call(null,inst_26009,inst_26016);
var inst_26004 = inst_26017;
var inst_26005 = inst_26059;
var inst_26006 = inst_26060;
var inst_26007 = inst_26067;
var inst_26008 = inst_26074;
var inst_26009__$1 = inst_26075;
var inst_26010 = inst_26058;
var state_26085__$1 = (function (){var statearr_26094 = state_26085;
(statearr_26094[(7)] = inst_26005);

(statearr_26094[(9)] = inst_26006);

(statearr_26094[(12)] = inst_26010);

(statearr_26094[(13)] = inst_26009__$1);

(statearr_26094[(23)] = inst_26004);

(statearr_26094[(14)] = inst_26007);

(statearr_26094[(15)] = inst_26008);

return statearr_26094;
})();
var statearr_26095_26160 = state_26085__$1;
(statearr_26095_26160[(2)] = null);

(statearr_26095_26160[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (4))){
var inst_25886 = (state_26085[(2)]);
var state_26085__$1 = state_26085;
var statearr_26096_26161 = state_26085__$1;
(statearr_26096_26161[(2)] = inst_25886);

(statearr_26096_26161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (15))){
var inst_25944 = (state_26085[(24)]);
var state_26085__$1 = state_26085;
var statearr_26097_26162 = state_26085__$1;
(statearr_26097_26162[(2)] = inst_25944);

(statearr_26097_26162[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (21))){
var inst_25982 = (state_26085[(25)]);
var inst_25920 = (state_26085[(26)]);
var inst_26017 = (state_26085[(19)]);
var inst_26005 = (state_26085[(7)]);
var inst_25922 = (state_26085[(8)]);
var inst_26006 = (state_26085[(9)]);
var inst_25908 = (state_26085[(27)]);
var inst_25972 = (state_26085[(10)]);
var inst_25909 = (state_26085[(28)]);
var inst_25912 = (state_26085[(29)]);
var inst_25921 = (state_26085[(11)]);
var inst_25893 = (state_26085[(30)]);
var inst_26010 = (state_26085[(12)]);
var inst_26009 = (state_26085[(13)]);
var inst_26004 = (state_26085[(23)]);
var inst_25931 = (state_26085[(31)]);
var inst_26016 = (state_26085[(21)]);
var inst_25981 = (state_26085[(32)]);
var inst_25925 = (state_26085[(33)]);
var inst_26007 = (state_26085[(14)]);
var inst_25923 = (state_26085[(34)]);
var inst_25916 = (state_26085[(35)]);
var inst_26008 = (state_26085[(15)]);
var inst_26055 = fluree.db.flake.s.call(null,inst_26016);
var inst_26056 = fluree.db.flake.sid__GT_cid.call(null,inst_26055);
var inst_26057 = (function (){var flakes_bytes = inst_25921;
var t = inst_25893;
var spot = inst_26005;
var add_flakes = inst_25909;
var root_setting_change_QMARK_ = inst_25923;
var ref_QMARK__map = inst_25920;
var r = inst_26017;
var psot = inst_26006;
var add_pred_to_idx_QMARK_ = inst_25931;
var _ = inst_25908;
var tspo = inst_26009;
var vec__26012 = inst_26004;
var G__25976 = inst_26004;
var cid = inst_26056;
var ecount = inst_26010;
var pred_ecount = inst_25925;
var db_STAR_ = inst_25972;
var seq__25978 = inst_25982;
var system_change_QMARK_ = inst_25922;
var seq__26013 = inst_26017;
var vec__25977 = inst_25909;
var add_preds = inst_25912;
var opst = inst_26008;
var first__25979 = inst_25981;
var idx_QMARK__map = inst_25916;
var post = inst_26007;
var first__26014 = inst_26016;
var f = inst_26016;
return (function (p1__25883_SHARP_){
if(cljs.core.truth_(p1__25883_SHARP_)){
var x__5130__auto__ = p1__25883_SHARP_;
var y__5131__auto__ = fluree.db.flake.s.call(null,f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s.call(null,f);
}
});
})();
var inst_26058 = cljs.core.update.call(null,inst_26010,inst_26056,inst_26057);
var inst_26059 = cljs.core.conj.call(null,inst_26005,inst_26016);
var inst_26060 = cljs.core.conj.call(null,inst_26006,inst_26016);
var inst_26061 = fluree.db.flake.p.call(null,inst_26016);
var inst_26062 = cljs.core.get.call(null,inst_25916,inst_26061);
var state_26085__$1 = (function (){var statearr_26098 = state_26085;
(statearr_26098[(17)] = inst_26058);

(statearr_26098[(18)] = inst_26060);

(statearr_26098[(22)] = inst_26059);

return statearr_26098;
})();
if(cljs.core.truth_(inst_26062)){
var statearr_26099_26163 = state_26085__$1;
(statearr_26099_26163[(1)] = (34));

} else {
var statearr_26100_26164 = state_26085__$1;
(statearr_26100_26164[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (31))){
var inst_26044 = (state_26085[(36)]);
var state_26085__$1 = state_26085;
var statearr_26101_26165 = state_26085__$1;
(statearr_26101_26165[(2)] = inst_26044);

(statearr_26101_26165[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (32))){
var inst_26053 = (state_26085[(2)]);
var state_26085__$1 = state_26085;
var statearr_26102_26166 = state_26085__$1;
(statearr_26102_26166[(2)] = inst_26053);

(statearr_26102_26166[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (33))){
var inst_26044 = (state_26085[(36)]);
var inst_26048 = (state_26085[(2)]);
var inst_26049 = fluree.db.util.async.throw_err.call(null,inst_26048);
var inst_26050 = cljs.core.assoc.call(null,inst_26044,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26049);
var state_26085__$1 = state_26085;
var statearr_26103_26167 = state_26085__$1;
(statearr_26103_26167[(2)] = inst_26050);

(statearr_26103_26167[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (13))){
var inst_25972 = (state_26085[(10)]);
var inst_25909 = (state_26085[(28)]);
var inst_25921 = (state_26085[(11)]);
var inst_25893 = (state_26085[(30)]);
var inst_25962 = (state_26085[(2)]);
var inst_25963 = cljs.core.assoc.call(null,inst_25962,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25893);
var inst_25964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25965 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25966 = (new cljs.core.PersistentVector(null,2,(5),inst_25964,inst_25965,null));
var inst_25967 = cljs.core.update_in.call(null,inst_25963,inst_25966,cljs.core._PLUS_,inst_25921);
var inst_25968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25969 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25970 = (new cljs.core.PersistentVector(null,2,(5),inst_25968,inst_25969,null));
var inst_25971 = cljs.core.count.call(null,inst_25909);
var inst_25972__$1 = cljs.core.update_in.call(null,inst_25967,inst_25970,cljs.core._PLUS_,inst_25971);
var inst_25980 = cljs.core.seq.call(null,inst_25909);
var inst_25981 = cljs.core.first.call(null,inst_25980);
var inst_25982 = cljs.core.next.call(null,inst_25980);
var inst_25983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25984 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25985 = (new cljs.core.PersistentVector(null,2,(5),inst_25983,inst_25984,null));
var inst_25986 = cljs.core.get_in.call(null,inst_25972__$1,inst_25985);
var inst_25987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25988 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25989 = (new cljs.core.PersistentVector(null,2,(5),inst_25987,inst_25988,null));
var inst_25990 = cljs.core.get_in.call(null,inst_25972__$1,inst_25989);
var inst_25991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25992 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25993 = (new cljs.core.PersistentVector(null,2,(5),inst_25991,inst_25992,null));
var inst_25994 = cljs.core.get_in.call(null,inst_25972__$1,inst_25993);
var inst_25995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25996 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25997 = (new cljs.core.PersistentVector(null,2,(5),inst_25995,inst_25996,null));
var inst_25998 = cljs.core.get_in.call(null,inst_25972__$1,inst_25997);
var inst_25999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26000 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_26001 = (new cljs.core.PersistentVector(null,2,(5),inst_25999,inst_26000,null));
var inst_26002 = cljs.core.get_in.call(null,inst_25972__$1,inst_26001);
var inst_26003 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26004 = inst_25909;
var inst_26005 = inst_25986;
var inst_26006 = inst_25990;
var inst_26007 = inst_25994;
var inst_26008 = inst_25998;
var inst_26009 = inst_26002;
var inst_26010 = inst_26003;
var state_26085__$1 = (function (){var statearr_26104 = state_26085;
(statearr_26104[(25)] = inst_25982);

(statearr_26104[(7)] = inst_26005);

(statearr_26104[(9)] = inst_26006);

(statearr_26104[(10)] = inst_25972__$1);

(statearr_26104[(12)] = inst_26010);

(statearr_26104[(13)] = inst_26009);

(statearr_26104[(23)] = inst_26004);

(statearr_26104[(32)] = inst_25981);

(statearr_26104[(14)] = inst_26007);

(statearr_26104[(15)] = inst_26008);

return statearr_26104;
})();
var statearr_26105_26168 = state_26085__$1;
(statearr_26105_26168[(2)] = null);

(statearr_26105_26168[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (22))){
var inst_26078 = (state_26085[(2)]);
var state_26085__$1 = state_26085;
var statearr_26106_26169 = state_26085__$1;
(statearr_26106_26169[(2)] = inst_26078);

(statearr_26106_26169[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (36))){
var inst_25920 = (state_26085[(26)]);
var inst_26016 = (state_26085[(21)]);
var inst_26067 = (state_26085[(2)]);
var inst_26068 = fluree.db.flake.p.call(null,inst_26016);
var inst_26069 = cljs.core.get.call(null,inst_25920,inst_26068);
var state_26085__$1 = (function (){var statearr_26107 = state_26085;
(statearr_26107[(20)] = inst_26067);

return statearr_26107;
})();
if(cljs.core.truth_(inst_26069)){
var statearr_26108_26170 = state_26085__$1;
(statearr_26108_26170[(1)] = (37));

} else {
var statearr_26109_26171 = state_26085__$1;
(statearr_26109_26171[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (29))){
var inst_26028 = (state_26085[(16)]);
var inst_26039 = (state_26085[(2)]);
var inst_26040 = fluree.db.util.async.throw_err.call(null,inst_26039);
var inst_26041 = cljs.core.assoc.call(null,inst_26028,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26040);
var state_26085__$1 = state_26085;
var statearr_26110_26172 = state_26085__$1;
(statearr_26110_26172[(2)] = inst_26041);

(statearr_26110_26172[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (6))){
var inst_25893 = (state_26085[(30)]);
var inst_25898 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25899 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25900 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25898)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25899)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25893),"."].join('');
var inst_25901 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25902 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25903 = cljs.core.PersistentHashMap.fromArrays(inst_25901,inst_25902);
var inst_25904 = cljs.core.ex_info.call(null,inst_25900,inst_25903);
var inst_25905 = (function(){throw inst_25904})();
var state_26085__$1 = state_26085;
var statearr_26111_26173 = state_26085__$1;
(statearr_26111_26173[(2)] = inst_25905);

(statearr_26111_26173[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (28))){
var inst_25923 = (state_26085[(34)]);
var inst_26044 = (state_26085[(2)]);
var state_26085__$1 = (function (){var statearr_26112 = state_26085;
(statearr_26112[(36)] = inst_26044);

return statearr_26112;
})();
if(cljs.core.truth_(inst_25923)){
var statearr_26113_26174 = state_26085__$1;
(statearr_26113_26174[(1)] = (30));

} else {
var statearr_26114_26175 = state_26085__$1;
(statearr_26114_26175[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (25))){
var inst_26035 = (state_26085[(2)]);
var state_26085__$1 = state_26085;
if(cljs.core.truth_(inst_26035)){
var statearr_26115_26176 = state_26085__$1;
(statearr_26115_26176[(1)] = (26));

} else {
var statearr_26116_26177 = state_26085__$1;
(statearr_26116_26177[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (34))){
var inst_26016 = (state_26085[(21)]);
var inst_26007 = (state_26085[(14)]);
var inst_26064 = cljs.core.conj.call(null,inst_26007,inst_26016);
var state_26085__$1 = state_26085;
var statearr_26117_26178 = state_26085__$1;
(statearr_26117_26178[(2)] = inst_26064);

(statearr_26117_26178[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (17))){
var inst_25951 = (state_26085[(37)]);
var inst_25955 = (state_26085[(2)]);
var inst_25956 = fluree.db.util.async.throw_err.call(null,inst_25955);
var inst_25943 = inst_25951;
var inst_25944 = inst_25956;
var state_26085__$1 = (function (){var statearr_26118 = state_26085;
(statearr_26118[(38)] = inst_25943);

(statearr_26118[(24)] = inst_25944);

return statearr_26118;
})();
var statearr_26119_26179 = state_26085__$1;
(statearr_26119_26179[(2)] = null);

(statearr_26119_26179[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (3))){
var inst_26083 = (state_26085[(2)]);
var state_26085__$1 = state_26085;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26085__$1,inst_26083);
} else {
if((state_val_26086 === (12))){
var inst_25943 = (state_26085[(38)]);
var inst_25950 = (state_26085[(39)]);
var inst_25949 = cljs.core.seq.call(null,inst_25943);
var inst_25950__$1 = cljs.core.first.call(null,inst_25949);
var inst_25951 = cljs.core.next.call(null,inst_25949);
var state_26085__$1 = (function (){var statearr_26120 = state_26085;
(statearr_26120[(37)] = inst_25951);

(statearr_26120[(39)] = inst_25950__$1);

return statearr_26120;
})();
if(cljs.core.truth_(inst_25950__$1)){
var statearr_26121_26180 = state_26085__$1;
(statearr_26121_26180[(1)] = (14));

} else {
var statearr_26122_26181 = state_26085__$1;
(statearr_26122_26181[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (2))){
var inst_25893 = (state_26085[(30)]);
var _ = (function (){var statearr_26123 = state_26085;
(statearr_26123[(4)] = cljs.core.cons.call(null,(5),(state_26085[(4)])));

return statearr_26123;
})();
var inst_25892 = cljs.core.first.call(null,flakes);
var inst_25893__$1 = fluree.db.flake.t.call(null,inst_25892);
var inst_25894 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25895 = (inst_25894 - (1));
var inst_25896 = cljs.core.not_EQ_.call(null,inst_25893__$1,inst_25895);
var state_26085__$1 = (function (){var statearr_26124 = state_26085;
(statearr_26124[(30)] = inst_25893__$1);

return statearr_26124;
})();
if(inst_25896){
var statearr_26125_26182 = state_26085__$1;
(statearr_26125_26182[(1)] = (6));

} else {
var statearr_26126_26183 = state_26085__$1;
(statearr_26126_26183[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (23))){
var inst_25922 = (state_26085[(8)]);
var state_26085__$1 = state_26085;
var statearr_26127_26184 = state_26085__$1;
(statearr_26127_26184[(2)] = inst_25922);

(statearr_26127_26184[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (35))){
var inst_26007 = (state_26085[(14)]);
var state_26085__$1 = state_26085;
var statearr_26128_26185 = state_26085__$1;
(statearr_26128_26185[(2)] = inst_26007);

(statearr_26128_26185[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (19))){
var inst_26080 = (state_26085[(2)]);
var _ = (function (){var statearr_26129 = state_26085;
(statearr_26129[(4)] = cljs.core.rest.call(null,(state_26085[(4)])));

return statearr_26129;
})();
var state_26085__$1 = state_26085;
var statearr_26130_26186 = state_26085__$1;
(statearr_26130_26186[(2)] = inst_26080);

(statearr_26130_26186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (11))){
var inst_25931 = (state_26085[(31)]);
var inst_25931__$1 = (state_26085[(2)]);
var inst_25939 = cljs.core.seq.call(null,inst_25931__$1);
var inst_25940 = cljs.core.first.call(null,inst_25939);
var inst_25941 = cljs.core.next.call(null,inst_25939);
var inst_25942 = db;
var inst_25943 = inst_25931__$1;
var inst_25944 = inst_25942;
var state_26085__$1 = (function (){var statearr_26132 = state_26085;
(statearr_26132[(40)] = inst_25941);

(statearr_26132[(38)] = inst_25943);

(statearr_26132[(41)] = inst_25940);

(statearr_26132[(24)] = inst_25944);

(statearr_26132[(31)] = inst_25931__$1);

return statearr_26132;
})();
var statearr_26133_26187 = state_26085__$1;
(statearr_26133_26187[(2)] = null);

(statearr_26133_26187[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (9))){
var inst_25909 = (state_26085[(28)]);
var inst_25925 = (state_26085[(33)]);
var inst_25927 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_25909,inst_25925);
var state_26085__$1 = state_26085;
var statearr_26134_26188 = state_26085__$1;
(statearr_26134_26188[(2)] = inst_25927);

(statearr_26134_26188[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (5))){
var _ = (function (){var statearr_26135 = state_26085;
(statearr_26135[(4)] = cljs.core.rest.call(null,(state_26085[(4)])));

return statearr_26135;
})();
var state_26085__$1 = state_26085;
var ex26131 = (state_26085__$1[(2)]);
var statearr_26136_26189 = state_26085__$1;
(statearr_26136_26189[(5)] = ex26131);


if((ex26131 instanceof Error)){
var statearr_26137_26190 = state_26085__$1;
(statearr_26137_26190[(1)] = (4));

(statearr_26137_26190[(5)] = null);

} else {
throw ex26131;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (14))){
var inst_25944 = (state_26085[(24)]);
var inst_25950 = (state_26085[(39)]);
var inst_25953 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_25944,inst_25950,opts);
var state_26085__$1 = state_26085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26085__$1,(17),inst_25953);
} else {
if((state_val_26086 === (26))){
var inst_26028 = (state_26085[(16)]);
var inst_26037 = fluree.db.query.schema.schema_map.call(null,inst_26028);
var state_26085__$1 = state_26085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26085__$1,(29),inst_26037);
} else {
if((state_val_26086 === (16))){
var inst_25960 = (state_26085[(2)]);
var state_26085__$1 = state_26085;
var statearr_26138_26191 = state_26085__$1;
(statearr_26138_26191[(2)] = inst_25960);

(statearr_26138_26191[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (38))){
var inst_26008 = (state_26085[(15)]);
var state_26085__$1 = state_26085;
var statearr_26139_26192 = state_26085__$1;
(statearr_26139_26192[(2)] = inst_26008);

(statearr_26139_26192[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (30))){
var inst_26028 = (state_26085[(16)]);
var inst_26046 = fluree.db.query.schema.setting_map.call(null,inst_26028);
var state_26085__$1 = state_26085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26085__$1,(33),inst_26046);
} else {
if((state_val_26086 === (10))){
var inst_25929 = cljs.core.PersistentVector.EMPTY;
var state_26085__$1 = state_26085;
var statearr_26140_26193 = state_26085__$1;
(statearr_26140_26193[(2)] = inst_25929);

(statearr_26140_26193[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (18))){
var inst_26004 = (state_26085[(23)]);
var inst_26016 = (state_26085[(21)]);
var inst_26015 = cljs.core.seq.call(null,inst_26004);
var inst_26016__$1 = cljs.core.first.call(null,inst_26015);
var inst_26017 = cljs.core.next.call(null,inst_26015);
var inst_26018 = cljs.core.not.call(null,inst_26016__$1);
var state_26085__$1 = (function (){var statearr_26141 = state_26085;
(statearr_26141[(19)] = inst_26017);

(statearr_26141[(21)] = inst_26016__$1);

return statearr_26141;
})();
if(inst_26018){
var statearr_26142_26194 = state_26085__$1;
(statearr_26142_26194[(1)] = (20));

} else {
var statearr_26143_26195 = state_26085__$1;
(statearr_26143_26195[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (37))){
var inst_26016 = (state_26085[(21)]);
var inst_26008 = (state_26085[(15)]);
var inst_26071 = cljs.core.conj.call(null,inst_26008,inst_26016);
var state_26085__$1 = state_26085;
var statearr_26144_26196 = state_26085__$1;
(statearr_26144_26196[(2)] = inst_26071);

(statearr_26144_26196[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26086 === (8))){
var inst_25922 = (state_26085[(8)]);
var inst_25908 = (state_26085[(27)]);
var inst_25909 = (state_26085[(28)]);
var inst_25912 = (state_26085[(29)]);
var inst_25893 = (state_26085[(30)]);
var inst_25916 = (state_26085[(35)]);
var inst_25908__$1 = (state_26085[(2)]);
var inst_25909__$1 = cljs.core.filter.call(null,fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25910 = cljs.core.PersistentHashSet.EMPTY;
var inst_25911 = cljs.core.map.call(null,fluree.db.flake.p,inst_25909__$1);
var inst_25912__$1 = cljs.core.into.call(null,inst_25910,inst_25911);
var inst_25913 = cljs.core.PersistentHashMap.EMPTY;
var inst_25914 = (function (){var t = inst_25893;
var _ = inst_25908__$1;
var add_flakes = inst_25909__$1;
var add_preds = inst_25912__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25915 = cljs.core.map.call(null,inst_25914,inst_25912__$1);
var inst_25916__$1 = cljs.core.into.call(null,inst_25913,inst_25915);
var inst_25917 = cljs.core.PersistentHashMap.EMPTY;
var inst_25918 = (function (){var t = inst_25893;
var _ = inst_25908__$1;
var add_flakes = inst_25909__$1;
var add_preds = inst_25912__$1;
var idx_QMARK__map = inst_25916__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25919 = cljs.core.map.call(null,inst_25918,inst_25912__$1);
var inst_25920 = cljs.core.into.call(null,inst_25917,inst_25919);
var inst_25921 = fluree.db.flake.size_bytes.call(null,inst_25909__$1);
var inst_25922__$1 = fluree.db.util.schema.system_change_QMARK_.call(null,inst_25909__$1);
var inst_25923 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_25909__$1);
var inst_25924 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25925 = cljs.core.get.call(null,inst_25924,(0));
var state_26085__$1 = (function (){var statearr_26145 = state_26085;
(statearr_26145[(26)] = inst_25920);

(statearr_26145[(8)] = inst_25922__$1);

(statearr_26145[(27)] = inst_25908__$1);

(statearr_26145[(28)] = inst_25909__$1);

(statearr_26145[(29)] = inst_25912__$1);

(statearr_26145[(11)] = inst_25921);

(statearr_26145[(33)] = inst_25925);

(statearr_26145[(34)] = inst_25923);

(statearr_26145[(35)] = inst_25916__$1);

return statearr_26145;
})();
if(cljs.core.truth_(inst_25922__$1)){
var statearr_26146_26197 = state_26085__$1;
(statearr_26146_26197[(1)] = (9));

} else {
var statearr_26147_26198 = state_26085__$1;
(statearr_26147_26198[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26148 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26148[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26148[(1)] = (1));

return statearr_26148;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26085){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_26085);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26149){var ex__2687__auto__ = e26149;
var statearr_26150_26199 = state_26085;
(statearr_26150_26199[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_26085[(4)]))){
var statearr_26151_26200 = state_26085;
(statearr_26151_26200[(1)] = cljs.core.first.call(null,(state_26085[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26201 = state_26085;
state_26085 = G__26201;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26085){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26152 = f__2707__auto__.call(null);
(statearr_26152[(6)] = c__2706__auto__);

return statearr_26152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26203 = arguments.length;
switch (G__26203) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2706__auto___26350 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26299){
var state_val_26300 = (state_26299[(1)]);
if((state_val_26300 === (7))){
var state_26299__$1 = state_26299;
var statearr_26301_26351 = state_26299__$1;
(statearr_26301_26351[(2)] = null);

(statearr_26301_26351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (20))){
var inst_26248 = (state_26299[(7)]);
var inst_26249 = (state_26299[(8)]);
var inst_26247 = (state_26299[(9)]);
var inst_26268 = (inst_26247 + (1));
var inst_26269 = cljs.core.assoc.call(null,inst_26249,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26268);
var inst_26270 = fluree.db.graphdb.with_t.call(null,inst_26269,inst_26248,opts);
var state_26299__$1 = state_26299;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26299__$1,(23),inst_26270);
} else {
if((state_val_26300 === (1))){
var state_26299__$1 = state_26299;
var statearr_26302_26352 = state_26299__$1;
(statearr_26302_26352[(2)] = null);

(statearr_26302_26352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (24))){
var inst_26273 = (state_26299[(10)]);
var inst_26276 = cljs.core.assoc.call(null,inst_26273,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26299__$1 = state_26299;
var statearr_26303_26353 = state_26299__$1;
(statearr_26303_26353[(2)] = inst_26276);

(statearr_26303_26353[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (4))){
var inst_26204 = (state_26299[(2)]);
var inst_26205 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26204);
var state_26299__$1 = state_26299;
var statearr_26304_26354 = state_26299__$1;
(statearr_26304_26354[(2)] = inst_26205);

(statearr_26304_26354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (15))){
var inst_26255 = (state_26299[(11)]);
var state_26299__$1 = state_26299;
var statearr_26305_26355 = state_26299__$1;
(statearr_26305_26355[(2)] = inst_26255);

(statearr_26305_26355[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (21))){
var state_26299__$1 = state_26299;
var statearr_26306_26356 = state_26299__$1;
(statearr_26306_26356[(2)] = null);

(statearr_26306_26356[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (13))){
var inst_26291 = (state_26299[(2)]);
var inst_26292 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26291);
var state_26299__$1 = state_26299;
var statearr_26307_26357 = state_26299__$1;
(statearr_26307_26357[(2)] = inst_26292);

(statearr_26307_26357[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (22))){
var inst_26287 = (state_26299[(2)]);
var state_26299__$1 = state_26299;
var statearr_26308_26358 = state_26299__$1;
(statearr_26308_26358[(2)] = inst_26287);

(statearr_26308_26358[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (6))){
var inst_26215 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_26216 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26217 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26215)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26216)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26218 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26219 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26220 = cljs.core.PersistentHashMap.fromArrays(inst_26218,inst_26219);
var inst_26221 = cljs.core.ex_info.call(null,inst_26217,inst_26220);
var inst_26222 = (function(){throw inst_26221})();
var state_26299__$1 = state_26299;
var statearr_26311_26359 = state_26299__$1;
(statearr_26311_26359[(2)] = inst_26222);

(statearr_26311_26359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (25))){
var inst_26273 = (state_26299[(10)]);
var inst_26256 = (state_26299[(12)]);
var inst_26255 = (state_26299[(11)]);
var inst_26278 = fluree.db.flake.t.call(null,inst_26255);
var inst_26279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26280 = [inst_26255];
var inst_26281 = (new cljs.core.PersistentVector(null,1,(5),inst_26279,inst_26280,null));
var inst_26246 = inst_26256;
var inst_26247 = inst_26278;
var inst_26248 = inst_26281;
var inst_26249 = inst_26273;
var state_26299__$1 = (function (){var statearr_26312 = state_26299;
(statearr_26312[(7)] = inst_26248);

(statearr_26312[(8)] = inst_26249);

(statearr_26312[(9)] = inst_26247);

(statearr_26312[(13)] = inst_26246);

return statearr_26312;
})();
var statearr_26313_26360 = state_26299__$1;
(statearr_26313_26360[(2)] = null);

(statearr_26313_26360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (17))){
var inst_26248 = (state_26299[(7)]);
var inst_26249 = (state_26299[(8)]);
var inst_26256 = (state_26299[(12)]);
var inst_26255 = (state_26299[(11)]);
var inst_26247 = (state_26299[(9)]);
var inst_26264 = cljs.core.conj.call(null,inst_26248,inst_26255);
var tmp26309 = inst_26249;
var tmp26310 = inst_26247;
var inst_26246 = inst_26256;
var inst_26247__$1 = tmp26310;
var inst_26248__$1 = inst_26264;
var inst_26249__$1 = tmp26309;
var state_26299__$1 = (function (){var statearr_26314 = state_26299;
(statearr_26314[(7)] = inst_26248__$1);

(statearr_26314[(8)] = inst_26249__$1);

(statearr_26314[(9)] = inst_26247__$1);

(statearr_26314[(13)] = inst_26246);

return statearr_26314;
})();
var statearr_26315_26361 = state_26299__$1;
(statearr_26315_26361[(2)] = null);

(statearr_26315_26361[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (3))){
var inst_26297 = (state_26299[(2)]);
var state_26299__$1 = state_26299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26299__$1,inst_26297);
} else {
if((state_val_26300 === (12))){
var inst_26255 = (state_26299[(11)]);
var inst_26246 = (state_26299[(13)]);
var inst_26254 = cljs.core.seq.call(null,inst_26246);
var inst_26255__$1 = cljs.core.first.call(null,inst_26254);
var inst_26256 = cljs.core.next.call(null,inst_26254);
var state_26299__$1 = (function (){var statearr_26316 = state_26299;
(statearr_26316[(12)] = inst_26256);

(statearr_26316[(11)] = inst_26255__$1);

return statearr_26316;
})();
if(cljs.core.truth_(inst_26255__$1)){
var statearr_26317_26362 = state_26299__$1;
(statearr_26317_26362[(1)] = (14));

} else {
var statearr_26318_26363 = state_26299__$1;
(statearr_26318_26363[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (2))){
var _ = (function (){var statearr_26319 = state_26299;
(statearr_26319[(4)] = cljs.core.cons.call(null,(5),(state_26299[(4)])));

return statearr_26319;
})();
var inst_26211 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26212 = (inst_26211 + (1));
var inst_26213 = cljs.core.not_EQ_.call(null,block,inst_26212);
var state_26299__$1 = state_26299;
if(inst_26213){
var statearr_26320_26364 = state_26299__$1;
(statearr_26320_26364[(1)] = (6));

} else {
var statearr_26321_26365 = state_26299__$1;
(statearr_26321_26365[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (23))){
var inst_26255 = (state_26299[(11)]);
var inst_26272 = (state_26299[(2)]);
var inst_26273 = fluree.db.util.async.throw_err.call(null,inst_26272);
var inst_26274 = (inst_26255 == null);
var state_26299__$1 = (function (){var statearr_26322 = state_26299;
(statearr_26322[(10)] = inst_26273);

return statearr_26322;
})();
if(cljs.core.truth_(inst_26274)){
var statearr_26323_26366 = state_26299__$1;
(statearr_26323_26366[(1)] = (24));

} else {
var statearr_26324_26367 = state_26299__$1;
(statearr_26324_26367[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (19))){
var inst_26289 = (state_26299[(2)]);
var state_26299__$1 = state_26299;
var statearr_26325_26368 = state_26299__$1;
(statearr_26325_26368[(2)] = inst_26289);

(statearr_26325_26368[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (11))){
var inst_26294 = (state_26299[(2)]);
var _ = (function (){var statearr_26327 = state_26299;
(statearr_26327[(4)] = cljs.core.rest.call(null,(state_26299[(4)])));

return statearr_26327;
})();
var state_26299__$1 = state_26299;
var statearr_26328_26369 = state_26299__$1;
(statearr_26328_26369[(2)] = inst_26294);

(statearr_26328_26369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (9))){
var inst_26228 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26229 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26228);
var state_26299__$1 = state_26299;
var statearr_26329_26370 = state_26299__$1;
(statearr_26329_26370[(2)] = inst_26229);

(statearr_26329_26370[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (5))){
var _ = (function (){var statearr_26330 = state_26299;
(statearr_26330[(4)] = cljs.core.rest.call(null,(state_26299[(4)])));

return statearr_26330;
})();
var state_26299__$1 = state_26299;
var ex26326 = (state_26299__$1[(2)]);
var statearr_26331_26371 = state_26299__$1;
(statearr_26331_26371[(5)] = ex26326);


var statearr_26332_26372 = state_26299__$1;
(statearr_26332_26372[(1)] = (4));

(statearr_26332_26372[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (14))){
var inst_26255 = (state_26299[(11)]);
var inst_26247 = (state_26299[(9)]);
var inst_26258 = fluree.db.flake.t.call(null,inst_26255);
var inst_26259 = cljs.core._EQ_.call(null,inst_26247,inst_26258);
var state_26299__$1 = state_26299;
var statearr_26333_26373 = state_26299__$1;
(statearr_26333_26373[(2)] = inst_26259);

(statearr_26333_26373[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (26))){
var inst_26284 = (state_26299[(2)]);
var state_26299__$1 = state_26299;
var statearr_26334_26374 = state_26299__$1;
(statearr_26334_26374[(2)] = inst_26284);

(statearr_26334_26374[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (16))){
var inst_26262 = (state_26299[(2)]);
var state_26299__$1 = state_26299;
if(cljs.core.truth_(inst_26262)){
var statearr_26335_26375 = state_26299__$1;
(statearr_26335_26375[(1)] = (17));

} else {
var statearr_26336_26376 = state_26299__$1;
(statearr_26336_26376[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (10))){
var inst_26231 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26239 = cljs.core.seq.call(null,inst_26231);
var inst_26240 = cljs.core.first.call(null,inst_26239);
var inst_26241 = cljs.core.next.call(null,inst_26239);
var inst_26242 = cljs.core.first.call(null,inst_26231);
var inst_26243 = fluree.db.flake.t.call(null,inst_26242);
var inst_26244 = cljs.core.PersistentVector.EMPTY;
var inst_26245 = db;
var inst_26246 = inst_26231;
var inst_26247 = inst_26243;
var inst_26248 = inst_26244;
var inst_26249 = inst_26245;
var state_26299__$1 = (function (){var statearr_26337 = state_26299;
(statearr_26337[(7)] = inst_26248);

(statearr_26337[(8)] = inst_26249);

(statearr_26337[(14)] = inst_26240);

(statearr_26337[(9)] = inst_26247);

(statearr_26337[(13)] = inst_26246);

(statearr_26337[(15)] = inst_26241);

return statearr_26337;
})();
var statearr_26338_26377 = state_26299__$1;
(statearr_26338_26377[(2)] = null);

(statearr_26338_26377[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (18))){
var state_26299__$1 = state_26299;
var statearr_26339_26378 = state_26299__$1;
(statearr_26339_26378[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26300 === (8))){
var inst_26225 = (state_26299[(2)]);
var inst_26226 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26299__$1 = (function (){var statearr_26341 = state_26299;
(statearr_26341[(16)] = inst_26225);

return statearr_26341;
})();
if(inst_26226){
var statearr_26342_26379 = state_26299__$1;
(statearr_26342_26379[(1)] = (9));

} else {
var statearr_26343_26380 = state_26299__$1;
(statearr_26343_26380[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26344[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26344[(1)] = (1));

return statearr_26344;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26299){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_26299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26345){var ex__2687__auto__ = e26345;
var statearr_26346_26381 = state_26299;
(statearr_26346_26381[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_26299[(4)]))){
var statearr_26347_26382 = state_26299;
(statearr_26347_26382[(1)] = cljs.core.first.call(null,(state_26299[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26383 = state_26299;
state_26299 = G__26383;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26299){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26348 = f__2707__auto__.call(null);
(statearr_26348[(6)] = c__2706__auto___26350);

return statearr_26348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26435){
var state_val_26436 = (state_26435[(1)]);
if((state_val_26436 === (7))){
var state_26435__$1 = state_26435;
var statearr_26437_26464 = state_26435__$1;
(statearr_26437_26464[(2)] = tt_id);

(statearr_26437_26464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (1))){
var state_26435__$1 = state_26435;
var statearr_26438_26465 = state_26435__$1;
(statearr_26438_26465[(2)] = null);

(statearr_26438_26465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (4))){
var inst_26384 = (state_26435[(2)]);
var state_26435__$1 = state_26435;
var statearr_26439_26466 = state_26435__$1;
(statearr_26439_26466[(2)] = inst_26384);

(statearr_26439_26466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (13))){
var inst_26428 = (state_26435[(2)]);
var state_26435__$1 = state_26435;
var statearr_26440_26467 = state_26435__$1;
(statearr_26440_26467[(2)] = inst_26428);

(statearr_26440_26467[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (6))){
var inst_26392 = cljs.core.random_uuid.call(null);
var state_26435__$1 = state_26435;
var statearr_26441_26468 = state_26435__$1;
(statearr_26441_26468[(2)] = inst_26392);

(statearr_26441_26468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (3))){
var inst_26433 = (state_26435[(2)]);
var state_26435__$1 = state_26435;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26435__$1,inst_26433);
} else {
if((state_val_26436 === (12))){
var inst_26411 = (state_26435[(7)]);
var state_26435__$1 = state_26435;
var statearr_26442_26469 = state_26435__$1;
(statearr_26442_26469[(2)] = inst_26411);

(statearr_26442_26469[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (2))){
var _ = (function (){var statearr_26443 = state_26435;
(statearr_26443[(4)] = cljs.core.cons.call(null,(5),(state_26435[(4)])));

return statearr_26443;
})();
var inst_26390 = (tt_id == null);
var state_26435__$1 = state_26435;
if(cljs.core.truth_(inst_26390)){
var statearr_26444_26470 = state_26435__$1;
(statearr_26444_26470[(1)] = (6));

} else {
var statearr_26445_26471 = state_26435__$1;
(statearr_26445_26471[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (11))){
var inst_26418 = (state_26435[(8)]);
var inst_26411 = (state_26435[(7)]);
var inst_26421 = fluree.db.graphdb.with_t.call(null,inst_26411,inst_26418);
var state_26435__$1 = state_26435;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26435__$1,(14),inst_26421);
} else {
if((state_val_26436 === (9))){
var inst_26412 = (state_26435[(9)]);
var inst_26418 = (state_26435[(8)]);
var inst_26417 = cljs.core.seq.call(null,inst_26412);
var inst_26418__$1 = cljs.core.first.call(null,inst_26417);
var inst_26419 = cljs.core.next.call(null,inst_26417);
var state_26435__$1 = (function (){var statearr_26447 = state_26435;
(statearr_26447[(8)] = inst_26418__$1);

(statearr_26447[(10)] = inst_26419);

return statearr_26447;
})();
if(cljs.core.truth_(inst_26418__$1)){
var statearr_26448_26472 = state_26435__$1;
(statearr_26448_26472[(1)] = (11));

} else {
var statearr_26449_26473 = state_26435__$1;
(statearr_26449_26473[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (5))){
var _ = (function (){var statearr_26450 = state_26435;
(statearr_26450[(4)] = cljs.core.rest.call(null,(state_26435[(4)])));

return statearr_26450;
})();
var state_26435__$1 = state_26435;
var ex26446 = (state_26435__$1[(2)]);
var statearr_26451_26474 = state_26435__$1;
(statearr_26451_26474[(5)] = ex26446);


if((ex26446 instanceof Error)){
var statearr_26452_26475 = state_26435__$1;
(statearr_26452_26475[(1)] = (4));

(statearr_26452_26475[(5)] = null);

} else {
throw ex26446;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (14))){
var inst_26419 = (state_26435[(10)]);
var inst_26423 = (state_26435[(2)]);
var inst_26424 = fluree.db.util.async.throw_err.call(null,inst_26423);
var inst_26411 = inst_26424;
var inst_26412 = inst_26419;
var state_26435__$1 = (function (){var statearr_26453 = state_26435;
(statearr_26453[(9)] = inst_26412);

(statearr_26453[(7)] = inst_26411);

return statearr_26453;
})();
var statearr_26454_26476 = state_26435__$1;
(statearr_26454_26476[(2)] = null);

(statearr_26454_26476[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (10))){
var inst_26430 = (state_26435[(2)]);
var _ = (function (){var statearr_26455 = state_26435;
(statearr_26455[(4)] = cljs.core.rest.call(null,(state_26435[(4)])));

return statearr_26455;
})();
var state_26435__$1 = state_26435;
var statearr_26456_26477 = state_26435__$1;
(statearr_26456_26477[(2)] = inst_26430);

(statearr_26456_26477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26436 === (8))){
var inst_26395 = (state_26435[(2)]);
var inst_26396 = (function (){var tt_id__$1 = inst_26395;
return (function (db_STAR_,idx){
return cljs.core.update.call(null,db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26397 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26395);
var inst_26398 = cljs.core.reduce.call(null,inst_26396,inst_26397,fluree.db.index.types);
var inst_26399 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26400 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26399);
var inst_26408 = cljs.core.seq.call(null,inst_26400);
var inst_26409 = cljs.core.first.call(null,inst_26408);
var inst_26410 = cljs.core.next.call(null,inst_26408);
var inst_26411 = inst_26398;
var inst_26412 = inst_26400;
var state_26435__$1 = (function (){var statearr_26457 = state_26435;
(statearr_26457[(9)] = inst_26412);

(statearr_26457[(7)] = inst_26411);

(statearr_26457[(11)] = inst_26409);

(statearr_26457[(12)] = inst_26410);

return statearr_26457;
})();
var statearr_26458_26478 = state_26435__$1;
(statearr_26458_26478[(2)] = null);

(statearr_26458_26478[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0 = (function (){
var statearr_26459 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26459[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__);

(statearr_26459[(1)] = (1));

return statearr_26459;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1 = (function (state_26435){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_26435);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26460){var ex__2687__auto__ = e26460;
var statearr_26461_26479 = state_26435;
(statearr_26461_26479[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_26435[(4)]))){
var statearr_26462_26480 = state_26435;
(statearr_26462_26480[(1)] = cljs.core.first.call(null,(state_26435[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26481 = state_26435;
state_26435 = G__26481;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__ = function(state_26435){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1.call(this,state_26435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26463 = f__2707__auto__.call(null);
(statearr_26463[(6)] = c__2706__auto__);

return statearr_26463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2706__auto___26668 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26599){
var state_val_26600 = (state_26599[(1)]);
if((state_val_26600 === (7))){
var inst_26509 = (state_26599[(7)]);
var inst_26509__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26599__$1 = (function (){var statearr_26601 = state_26599;
(statearr_26601[(7)] = inst_26509__$1);

return statearr_26601;
})();
if(inst_26509__$1){
var statearr_26602_26669 = state_26599__$1;
(statearr_26602_26669[(1)] = (13));

} else {
var statearr_26603_26670 = state_26599__$1;
(statearr_26603_26670[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (20))){
var state_26599__$1 = state_26599;
var statearr_26604_26671 = state_26599__$1;
(statearr_26604_26671[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (27))){
var inst_26545 = (state_26599[(8)]);
var inst_26549 = fluree.db.flake.s.call(null,inst_26545);
var state_26599__$1 = state_26599;
var statearr_26606_26672 = state_26599__$1;
(statearr_26606_26672[(2)] = inst_26549);

(statearr_26606_26672[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (1))){
var state_26599__$1 = state_26599;
var statearr_26607_26673 = state_26599__$1;
(statearr_26607_26673[(2)] = null);

(statearr_26607_26673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (24))){
var inst_26539 = (state_26599[(9)]);
var inst_26543 = cljs.core.first.call(null,inst_26539);
var state_26599__$1 = state_26599;
var statearr_26608_26674 = state_26599__$1;
(statearr_26608_26674[(2)] = inst_26543);

(statearr_26608_26674[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (39))){
var state_26599__$1 = state_26599;
var statearr_26609_26675 = state_26599__$1;
(statearr_26609_26675[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (4))){
var inst_26482 = (state_26599[(2)]);
var inst_26483 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26484 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26485 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26486 = cljs.core.PersistentHashMap.fromArrays(inst_26484,inst_26485);
var inst_26487 = cljs.core.ex_info.call(null,inst_26483,inst_26486,inst_26482);
var inst_26488 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26487);
var state_26599__$1 = state_26599;
var statearr_26611_26676 = state_26599__$1;
(statearr_26611_26676[(2)] = inst_26488);

(statearr_26611_26676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (15))){
var inst_26516 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
if(cljs.core.truth_(inst_26516)){
var statearr_26612_26677 = state_26599__$1;
(statearr_26612_26677[(1)] = (16));

} else {
var statearr_26613_26678 = state_26599__$1;
(statearr_26613_26678[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (21))){
var inst_26565 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26614_26679 = state_26599__$1;
(statearr_26614_26679[(2)] = inst_26565);

(statearr_26614_26679[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (31))){
var inst_26563 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26615_26680 = state_26599__$1;
(statearr_26615_26680[(2)] = inst_26563);

(statearr_26615_26680[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (32))){
var inst_26569 = (state_26599[(10)]);
var inst_26571 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26569);
var state_26599__$1 = state_26599;
var statearr_26616_26681 = state_26599__$1;
(statearr_26616_26681[(2)] = inst_26571);

(statearr_26616_26681[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (40))){
var inst_26592 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26617_26682 = state_26599__$1;
(statearr_26617_26682[(2)] = inst_26592);

(statearr_26617_26682[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (33))){
var inst_26569 = (state_26599[(10)]);
var inst_26573 = (state_26599[(11)]);
var inst_26573__$1 = (inst_26569 == null);
var state_26599__$1 = (function (){var statearr_26618 = state_26599;
(statearr_26618[(11)] = inst_26573__$1);

return statearr_26618;
})();
if(cljs.core.truth_(inst_26573__$1)){
var statearr_26619_26683 = state_26599__$1;
(statearr_26619_26683[(1)] = (35));

} else {
var statearr_26620_26684 = state_26599__$1;
(statearr_26620_26684[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (13))){
var inst_26511 = cljs.core.first.call(null,ident);
var inst_26512 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26511);
var inst_26513 = (inst_26512 == null);
var state_26599__$1 = state_26599;
var statearr_26621_26685 = state_26599__$1;
(statearr_26621_26685[(2)] = inst_26513);

(statearr_26621_26685[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (22))){
var inst_26539 = (state_26599[(9)]);
var inst_26538 = (state_26599[(2)]);
var inst_26539__$1 = fluree.db.util.async.throw_err.call(null,inst_26538);
var inst_26540 = (inst_26539__$1 == null);
var state_26599__$1 = (function (){var statearr_26622 = state_26599;
(statearr_26622[(9)] = inst_26539__$1);

return statearr_26622;
})();
if(cljs.core.truth_(inst_26540)){
var statearr_26623_26686 = state_26599__$1;
(statearr_26623_26686[(1)] = (23));

} else {
var statearr_26624_26687 = state_26599__$1;
(statearr_26624_26687[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (36))){
var inst_26573 = (state_26599[(11)]);
var state_26599__$1 = state_26599;
var statearr_26625_26688 = state_26599__$1;
(statearr_26625_26688[(2)] = inst_26573);

(statearr_26625_26688[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (41))){
var inst_26587 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_26599__$1 = state_26599;
var statearr_26626_26689 = state_26599__$1;
(statearr_26626_26689[(2)] = inst_26587);

(statearr_26626_26689[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (43))){
var inst_26590 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26627_26690 = state_26599__$1;
(statearr_26627_26690[(2)] = inst_26590);

(statearr_26627_26690[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (29))){
var inst_26554 = cljs.core.pr_str.call(null,ident);
var inst_26555 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26554].join('');
var inst_26556 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26557 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26558 = cljs.core.PersistentHashMap.fromArrays(inst_26556,inst_26557);
var inst_26559 = cljs.core.ex_info.call(null,inst_26555,inst_26558);
var inst_26560 = (function(){throw inst_26559})();
var state_26599__$1 = state_26599;
var statearr_26628_26691 = state_26599__$1;
(statearr_26628_26691[(2)] = inst_26560);

(statearr_26628_26691[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (6))){
var inst_26496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26497 = [ident];
var inst_26498 = (new cljs.core.PersistentVector(null,1,(5),inst_26496,inst_26497,null));
var inst_26499 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26498);
var state_26599__$1 = state_26599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26599__$1,(9),inst_26499);
} else {
if((state_val_26600 === (28))){
var inst_26551 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26629_26692 = state_26599__$1;
(statearr_26629_26692[(2)] = inst_26551);

(statearr_26629_26692[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (25))){
var inst_26545 = (state_26599[(8)]);
var inst_26545__$1 = (state_26599[(2)]);
var inst_26546 = (inst_26545__$1 == null);
var state_26599__$1 = (function (){var statearr_26630 = state_26599;
(statearr_26630[(8)] = inst_26545__$1);

return statearr_26630;
})();
if(cljs.core.truth_(inst_26546)){
var statearr_26631_26693 = state_26599__$1;
(statearr_26631_26693[(1)] = (26));

} else {
var statearr_26632_26694 = state_26599__$1;
(statearr_26632_26694[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (34))){
var inst_26594 = (state_26599[(2)]);
var _ = (function (){var statearr_26633 = state_26599;
(statearr_26633[(4)] = cljs.core.rest.call(null,(state_26599[(4)])));

return statearr_26633;
})();
var state_26599__$1 = state_26599;
var statearr_26634_26695 = state_26599__$1;
(statearr_26634_26695[(2)] = inst_26594);

(statearr_26634_26695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (17))){
var inst_26527 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26599__$1 = state_26599;
if(inst_26527){
var statearr_26635_26696 = state_26599__$1;
(statearr_26635_26696[(1)] = (19));

} else {
var statearr_26636_26697 = state_26599__$1;
(statearr_26636_26697[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (3))){
var inst_26597 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26599__$1,inst_26597);
} else {
if((state_val_26600 === (12))){
var inst_26507 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26637_26698 = state_26599__$1;
(statearr_26637_26698[(2)] = inst_26507);

(statearr_26637_26698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (2))){
var _ = (function (){var statearr_26638 = state_26599;
(statearr_26638[(4)] = cljs.core.cons.call(null,(5),(state_26599[(4)])));

return statearr_26638;
})();
var inst_26494 = typeof ident === 'number';
var state_26599__$1 = state_26599;
if(cljs.core.truth_(inst_26494)){
var statearr_26639_26699 = state_26599__$1;
(statearr_26639_26699[(1)] = (6));

} else {
var statearr_26640_26700 = state_26599__$1;
(statearr_26640_26700[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (23))){
var state_26599__$1 = state_26599;
var statearr_26641_26701 = state_26599__$1;
(statearr_26641_26701[(2)] = null);

(statearr_26641_26701[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (35))){
var state_26599__$1 = state_26599;
var statearr_26642_26702 = state_26599__$1;
(statearr_26642_26702[(2)] = strict_QMARK_);

(statearr_26642_26702[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (19))){
var inst_26530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26531 = cljs.core.first.call(null,ident);
var inst_26532 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26531);
var inst_26533 = cljs.core.second.call(null,ident);
var inst_26534 = [inst_26532,inst_26533];
var inst_26535 = (new cljs.core.PersistentVector(null,2,(5),inst_26530,inst_26534,null));
var inst_26536 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26535);
var state_26599__$1 = state_26599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26599__$1,(22),inst_26536);
} else {
if((state_val_26600 === (11))){
var state_26599__$1 = state_26599;
var statearr_26644_26703 = state_26599__$1;
(statearr_26644_26703[(2)] = null);

(statearr_26644_26703[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (9))){
var inst_26501 = (state_26599[(2)]);
var inst_26502 = fluree.db.util.async.throw_err.call(null,inst_26501);
var inst_26503 = cljs.core.not_empty.call(null,inst_26502);
var state_26599__$1 = state_26599;
if(cljs.core.truth_(inst_26503)){
var statearr_26645_26704 = state_26599__$1;
(statearr_26645_26704[(1)] = (10));

} else {
var statearr_26646_26705 = state_26599__$1;
(statearr_26646_26705[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (5))){
var _ = (function (){var statearr_26647 = state_26599;
(statearr_26647[(4)] = cljs.core.rest.call(null,(state_26599[(4)])));

return statearr_26647;
})();
var state_26599__$1 = state_26599;
var ex26643 = (state_26599__$1[(2)]);
var statearr_26648_26706 = state_26599__$1;
(statearr_26648_26706[(5)] = ex26643);


var statearr_26649_26707 = state_26599__$1;
(statearr_26649_26707[(1)] = (4));

(statearr_26649_26707[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (14))){
var inst_26509 = (state_26599[(7)]);
var state_26599__$1 = state_26599;
var statearr_26650_26708 = state_26599__$1;
(statearr_26650_26708[(2)] = inst_26509);

(statearr_26650_26708[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (26))){
var state_26599__$1 = state_26599;
var statearr_26651_26709 = state_26599__$1;
(statearr_26651_26709[(2)] = null);

(statearr_26651_26709[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (16))){
var inst_26518 = cljs.core.first.call(null,ident);
var inst_26519 = cljs.core.pr_str.call(null,inst_26518);
var inst_26520 = ["Subject ID lookup failed. The predicate ",inst_26519," does not exist."].join('');
var inst_26521 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26522 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26523 = cljs.core.PersistentHashMap.fromArrays(inst_26521,inst_26522);
var inst_26524 = cljs.core.ex_info.call(null,inst_26520,inst_26523);
var inst_26525 = (function(){throw inst_26524})();
var state_26599__$1 = state_26599;
var statearr_26652_26710 = state_26599__$1;
(statearr_26652_26710[(2)] = inst_26525);

(statearr_26652_26710[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (38))){
var inst_26579 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26580 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26581 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26582 = cljs.core.PersistentHashMap.fromArrays(inst_26580,inst_26581);
var inst_26583 = cljs.core.ex_info.call(null,inst_26579,inst_26582);
var inst_26584 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26583);
var state_26599__$1 = state_26599;
var statearr_26653_26711 = state_26599__$1;
(statearr_26653_26711[(2)] = inst_26584);

(statearr_26653_26711[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (30))){
var state_26599__$1 = state_26599;
var statearr_26654_26712 = state_26599__$1;
(statearr_26654_26712[(2)] = null);

(statearr_26654_26712[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (10))){
var state_26599__$1 = state_26599;
var statearr_26655_26713 = state_26599__$1;
(statearr_26655_26713[(2)] = ident);

(statearr_26655_26713[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (18))){
var inst_26567 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
var statearr_26656_26714 = state_26599__$1;
(statearr_26656_26714[(2)] = inst_26567);

(statearr_26656_26714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (42))){
var state_26599__$1 = state_26599;
var statearr_26657_26715 = state_26599__$1;
(statearr_26657_26715[(2)] = null);

(statearr_26657_26715[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (37))){
var inst_26577 = (state_26599[(2)]);
var state_26599__$1 = state_26599;
if(cljs.core.truth_(inst_26577)){
var statearr_26658_26716 = state_26599__$1;
(statearr_26658_26716[(1)] = (38));

} else {
var statearr_26659_26717 = state_26599__$1;
(statearr_26659_26717[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26600 === (8))){
var inst_26569 = (state_26599[(10)]);
var inst_26569__$1 = (state_26599[(2)]);
var state_26599__$1 = (function (){var statearr_26660 = state_26599;
(statearr_26660[(10)] = inst_26569__$1);

return statearr_26660;
})();
if(cljs.core.truth_(inst_26569__$1)){
var statearr_26661_26718 = state_26599__$1;
(statearr_26661_26718[(1)] = (32));

} else {
var statearr_26662_26719 = state_26599__$1;
(statearr_26662_26719[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2684__auto____0 = (function (){
var statearr_26663 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26663[(0)] = fluree$db$graphdb$subid_$_state_machine__2684__auto__);

(statearr_26663[(1)] = (1));

return statearr_26663;
});
var fluree$db$graphdb$subid_$_state_machine__2684__auto____1 = (function (state_26599){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_26599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26664){var ex__2687__auto__ = e26664;
var statearr_26665_26720 = state_26599;
(statearr_26665_26720[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_26599[(4)]))){
var statearr_26666_26721 = state_26599;
(statearr_26666_26721[(1)] = cljs.core.first.call(null,(state_26599[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26722 = state_26599;
state_26599 = G__26722;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2684__auto__ = function(state_26599){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2684__auto____1.call(this,state_26599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2684__auto____0;
fluree$db$graphdb$subid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2684__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26667 = f__2707__auto__.call(null);
(statearr_26667[(6)] = c__2706__auto___26668);

return statearr_26667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26723){
var map__26724 = p__26723;
var map__26724__$1 = cljs.core.__destructure_map.call(null,map__26724);
var db = map__26724__$1;
var current_db_fn = cljs.core.get.call(null,map__26724__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__26724__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26740){
var state_val_26741 = (state_26740[(1)]);
if((state_val_26741 === (1))){
var state_26740__$1 = state_26740;
var statearr_26742_26756 = state_26740__$1;
(statearr_26742_26756[(2)] = null);

(statearr_26742_26756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (2))){
var _ = (function (){var statearr_26743 = state_26740;
(statearr_26743[(4)] = cljs.core.cons.call(null,(5),(state_26740[(4)])));

return statearr_26743;
})();
var inst_26731 = current_db_fn.call(null,db);
var state_26740__$1 = state_26740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26740__$1,(6),inst_26731);
} else {
if((state_val_26741 === (3))){
var inst_26738 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26740__$1,inst_26738);
} else {
if((state_val_26741 === (4))){
var inst_26725 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
var statearr_26745_26757 = state_26740__$1;
(statearr_26745_26757[(2)] = inst_26725);

(statearr_26745_26757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (5))){
var _ = (function (){var statearr_26746 = state_26740;
(statearr_26746[(4)] = cljs.core.rest.call(null,(state_26740[(4)])));

return statearr_26746;
})();
var state_26740__$1 = state_26740;
var ex26744 = (state_26740__$1[(2)]);
var statearr_26747_26758 = state_26740__$1;
(statearr_26747_26758[(5)] = ex26744);


if((ex26744 instanceof Error)){
var statearr_26748_26759 = state_26740__$1;
(statearr_26748_26759[(1)] = (4));

(statearr_26748_26759[(5)] = null);

} else {
throw ex26744;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26741 === (6))){
var inst_26733 = (state_26740[(2)]);
var inst_26734 = fluree.db.util.async.throw_err.call(null,inst_26733);
var inst_26735 = cljs.core.assoc.call(null,inst_26734,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26749 = state_26740;
(statearr_26749[(4)] = cljs.core.rest.call(null,(state_26740[(4)])));

return statearr_26749;
})();
var state_26740__$1 = state_26740;
var statearr_26750_26760 = state_26740__$1;
(statearr_26750_26760[(2)] = inst_26735);

(statearr_26750_26760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0 = (function (){
var statearr_26751 = [null,null,null,null,null,null,null];
(statearr_26751[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__);

(statearr_26751[(1)] = (1));

return statearr_26751;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1 = (function (state_26740){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_26740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26752){var ex__2687__auto__ = e26752;
var statearr_26753_26761 = state_26740;
(statearr_26753_26761[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_26740[(4)]))){
var statearr_26754_26762 = state_26740;
(statearr_26754_26762[(1)] = cljs.core.first.call(null,(state_26740[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26763 = state_26740;
state_26740 = G__26763;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__ = function(state_26740){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1.call(this,state_26740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26755 = f__2707__auto__.call(null);
(statearr_26755[(6)] = c__2706__auto__);

return statearr_26755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26764,property,collection){
var map__26765 = p__26764;
var map__26765__$1 = cljs.core.__destructure_map.call(null,map__26765);
var schema = cljs.core.get.call(null,map__26765__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26766,property,predicate){
var map__26767 = p__26766;
var map__26767__$1 = cljs.core.__destructure_map.call(null,map__26767);
var this$ = map__26767__$1;
var schema = cljs.core.get.call(null,map__26767__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26768 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26768);
} else {
return G__26768;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26770 = arguments.length;
switch (G__26770) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26802){
var state_val_26803 = (state_26802[(1)]);
if((state_val_26803 === (7))){
var state_26802__$1 = state_26802;
var statearr_26804_26898 = state_26802__$1;
(statearr_26804_26898[(2)] = null);

(statearr_26804_26898[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (1))){
var state_26802__$1 = state_26802;
var statearr_26805_26899 = state_26802__$1;
(statearr_26805_26899[(2)] = null);

(statearr_26805_26899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (4))){
var inst_26771 = (state_26802[(2)]);
var state_26802__$1 = state_26802;
var statearr_26806_26900 = state_26802__$1;
(statearr_26806_26900[(2)] = inst_26771);

(statearr_26806_26900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (6))){
var inst_26785 = (state_26802[(7)]);
var inst_26784 = (state_26802[(2)]);
var inst_26785__$1 = fluree.db.util.async.throw_err.call(null,inst_26784);
var inst_26786 = (inst_26785__$1 == null);
var state_26802__$1 = (function (){var statearr_26807 = state_26802;
(statearr_26807[(7)] = inst_26785__$1);

return statearr_26807;
})();
if(cljs.core.truth_(inst_26786)){
var statearr_26808_26901 = state_26802__$1;
(statearr_26808_26901[(1)] = (7));

} else {
var statearr_26809_26902 = state_26802__$1;
(statearr_26809_26902[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (3))){
var inst_26800 = (state_26802[(2)]);
var state_26802__$1 = state_26802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26802__$1,inst_26800);
} else {
if((state_val_26803 === (12))){
var inst_26797 = (state_26802[(2)]);
var _ = (function (){var statearr_26810 = state_26802;
(statearr_26810[(4)] = cljs.core.rest.call(null,(state_26802[(4)])));

return statearr_26810;
})();
var state_26802__$1 = state_26802;
var statearr_26811_26903 = state_26802__$1;
(statearr_26811_26903[(2)] = inst_26797);

(statearr_26811_26903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (2))){
var _ = (function (){var statearr_26812 = state_26802;
(statearr_26812[(4)] = cljs.core.cons.call(null,(5),(state_26802[(4)])));

return statearr_26812;
})();
var inst_26778 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26780 = [tag_id,(30)];
var inst_26781 = (new cljs.core.PersistentVector(null,2,(5),inst_26779,inst_26780,null));
var inst_26782 = fluree.db.query.range.index_range.call(null,inst_26778,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26781);
var state_26802__$1 = state_26802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26802__$1,(6),inst_26782);
} else {
if((state_val_26803 === (11))){
var inst_26791 = (state_26802[(8)]);
var inst_26795 = fluree.db.flake.o.call(null,inst_26791);
var state_26802__$1 = state_26802;
var statearr_26814_26904 = state_26802__$1;
(statearr_26814_26904[(2)] = inst_26795);

(statearr_26814_26904[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (9))){
var inst_26791 = (state_26802[(8)]);
var inst_26791__$1 = (state_26802[(2)]);
var inst_26792 = (inst_26791__$1 == null);
var state_26802__$1 = (function (){var statearr_26815 = state_26802;
(statearr_26815[(8)] = inst_26791__$1);

return statearr_26815;
})();
if(cljs.core.truth_(inst_26792)){
var statearr_26816_26905 = state_26802__$1;
(statearr_26816_26905[(1)] = (10));

} else {
var statearr_26817_26906 = state_26802__$1;
(statearr_26817_26906[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (5))){
var _ = (function (){var statearr_26818 = state_26802;
(statearr_26818[(4)] = cljs.core.rest.call(null,(state_26802[(4)])));

return statearr_26818;
})();
var state_26802__$1 = state_26802;
var ex26813 = (state_26802__$1[(2)]);
var statearr_26819_26907 = state_26802__$1;
(statearr_26819_26907[(5)] = ex26813);


if((ex26813 instanceof Error)){
var statearr_26820_26908 = state_26802__$1;
(statearr_26820_26908[(1)] = (4));

(statearr_26820_26908[(5)] = null);

} else {
throw ex26813;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (10))){
var state_26802__$1 = state_26802;
var statearr_26821_26909 = state_26802__$1;
(statearr_26821_26909[(2)] = null);

(statearr_26821_26909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26803 === (8))){
var inst_26785 = (state_26802[(7)]);
var inst_26789 = cljs.core.first.call(null,inst_26785);
var state_26802__$1 = state_26802;
var statearr_26822_26910 = state_26802__$1;
(statearr_26822_26910[(2)] = inst_26789);

(statearr_26822_26910[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26823 = [null,null,null,null,null,null,null,null,null];
(statearr_26823[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26823[(1)] = (1));

return statearr_26823;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26802){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_26802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26824){var ex__2687__auto__ = e26824;
var statearr_26825_26911 = state_26802;
(statearr_26825_26911[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_26802[(4)]))){
var statearr_26826_26912 = state_26802;
(statearr_26826_26912[(1)] = cljs.core.first.call(null,(state_26802[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26913 = state_26802;
state_26802 = G__26913;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26802){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26827 = f__2707__auto__.call(null);
(statearr_26827[(6)] = c__2706__auto__);

return statearr_26827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26863){
var state_val_26864 = (state_26863[(1)]);
if((state_val_26864 === (7))){
var inst_26837 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26863__$1 = state_26863;
var statearr_26865_26914 = state_26863__$1;
(statearr_26865_26914[(2)] = inst_26837);

(statearr_26865_26914[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (1))){
var state_26863__$1 = state_26863;
var statearr_26866_26915 = state_26863__$1;
(statearr_26866_26915[(2)] = null);

(statearr_26866_26915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (4))){
var inst_26828 = (state_26863[(2)]);
var state_26863__$1 = state_26863;
var statearr_26867_26916 = state_26863__$1;
(statearr_26867_26916[(2)] = inst_26828);

(statearr_26867_26916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (15))){
var inst_26858 = (state_26863[(2)]);
var _ = (function (){var statearr_26868 = state_26863;
(statearr_26868[(4)] = cljs.core.rest.call(null,(state_26863[(4)])));

return statearr_26868;
})();
var state_26863__$1 = state_26863;
var statearr_26869_26917 = state_26863__$1;
(statearr_26869_26917[(2)] = inst_26858);

(statearr_26869_26917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (13))){
var inst_26843 = (state_26863[(7)]);
var inst_26849 = clojure.string.includes_QMARK_.call(null,inst_26843,":");
var state_26863__$1 = state_26863;
if(inst_26849){
var statearr_26870_26918 = state_26863__$1;
(statearr_26870_26918[(1)] = (16));

} else {
var statearr_26871_26919 = state_26863__$1;
(statearr_26871_26919[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (6))){
var state_26863__$1 = state_26863;
var statearr_26872_26920 = state_26863__$1;
(statearr_26872_26920[(2)] = pred);

(statearr_26872_26920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (17))){
var inst_26843 = (state_26863[(7)]);
var state_26863__$1 = state_26863;
var statearr_26873_26921 = state_26863__$1;
(statearr_26873_26921[(2)] = inst_26843);

(statearr_26873_26921[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (3))){
var inst_26861 = (state_26863[(2)]);
var state_26863__$1 = state_26863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26863__$1,inst_26861);
} else {
if((state_val_26864 === (12))){
var inst_26847 = (state_26863[(2)]);
var state_26863__$1 = state_26863;
if(cljs.core.truth_(inst_26847)){
var statearr_26874_26922 = state_26863__$1;
(statearr_26874_26922[(1)] = (13));

} else {
var statearr_26875_26923 = state_26863__$1;
(statearr_26875_26923[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (2))){
var _ = (function (){var statearr_26876 = state_26863;
(statearr_26876[(4)] = cljs.core.cons.call(null,(5),(state_26863[(4)])));

return statearr_26876;
})();
var inst_26834 = typeof pred === 'string';
var state_26863__$1 = state_26863;
if(cljs.core.truth_(inst_26834)){
var statearr_26877_26924 = state_26863__$1;
(statearr_26877_26924[(1)] = (6));

} else {
var statearr_26878_26925 = state_26863__$1;
(statearr_26878_26925[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (11))){
var inst_26839 = (state_26863[(8)]);
var state_26863__$1 = state_26863;
var statearr_26880_26926 = state_26863__$1;
(statearr_26880_26926[(2)] = inst_26839);

(statearr_26880_26926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (9))){
var inst_26839 = (state_26863[(8)]);
var inst_26842 = (state_26863[(2)]);
var inst_26843 = fluree.db.util.async.throw_err.call(null,inst_26842);
var state_26863__$1 = (function (){var statearr_26881 = state_26863;
(statearr_26881[(7)] = inst_26843);

return statearr_26881;
})();
if(cljs.core.truth_(inst_26839)){
var statearr_26882_26927 = state_26863__$1;
(statearr_26882_26927[(1)] = (10));

} else {
var statearr_26883_26928 = state_26863__$1;
(statearr_26883_26928[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (5))){
var _ = (function (){var statearr_26884 = state_26863;
(statearr_26884[(4)] = cljs.core.rest.call(null,(state_26863[(4)])));

return statearr_26884;
})();
var state_26863__$1 = state_26863;
var ex26879 = (state_26863__$1[(2)]);
var statearr_26885_26929 = state_26863__$1;
(statearr_26885_26929[(5)] = ex26879);


if((ex26879 instanceof Error)){
var statearr_26886_26930 = state_26863__$1;
(statearr_26886_26930[(1)] = (4));

(statearr_26886_26930[(5)] = null);

} else {
throw ex26879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (14))){
var state_26863__$1 = state_26863;
var statearr_26887_26931 = state_26863__$1;
(statearr_26887_26931[(2)] = null);

(statearr_26887_26931[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (16))){
var inst_26843 = (state_26863[(7)]);
var inst_26851 = clojure.string.split.call(null,inst_26843,/:/);
var inst_26852 = cljs.core.second.call(null,inst_26851);
var state_26863__$1 = state_26863;
var statearr_26888_26932 = state_26863__$1;
(statearr_26888_26932[(2)] = inst_26852);

(statearr_26888_26932[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (10))){
var inst_26843 = (state_26863[(7)]);
var state_26863__$1 = state_26863;
var statearr_26889_26933 = state_26863__$1;
(statearr_26889_26933[(2)] = inst_26843);

(statearr_26889_26933[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (18))){
var inst_26855 = (state_26863[(2)]);
var state_26863__$1 = state_26863;
var statearr_26890_26934 = state_26863__$1;
(statearr_26890_26934[(2)] = inst_26855);

(statearr_26890_26934[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26864 === (8))){
var inst_26839 = (state_26863[(2)]);
var inst_26840 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_26863__$1 = (function (){var statearr_26891 = state_26863;
(statearr_26891[(8)] = inst_26839);

return statearr_26891;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26863__$1,(9),inst_26840);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26892 = [null,null,null,null,null,null,null,null,null];
(statearr_26892[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26892[(1)] = (1));

return statearr_26892;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26863){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_26863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26893){var ex__2687__auto__ = e26893;
var statearr_26894_26935 = state_26863;
(statearr_26894_26935[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_26863[(4)]))){
var statearr_26895_26936 = state_26863;
(statearr_26895_26936[(1)] = cljs.core.first.call(null,(state_26863[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26937 = state_26863;
state_26863 = G__26937;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26863){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26896 = f__2707__auto__.call(null);
(statearr_26896[(6)] = c__2706__auto__);

return statearr_26896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26939 = arguments.length;
switch (G__26939) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26972){
var state_val_26973 = (state_26972[(1)]);
if((state_val_26973 === (7))){
var state_26972__$1 = state_26972;
var statearr_26974_27062 = state_26972__$1;
(statearr_26974_27062[(2)] = null);

(statearr_26974_27062[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (1))){
var state_26972__$1 = state_26972;
var statearr_26975_27063 = state_26972__$1;
(statearr_26975_27063[(2)] = null);

(statearr_26975_27063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (4))){
var inst_26940 = (state_26972[(2)]);
var state_26972__$1 = state_26972;
var statearr_26976_27064 = state_26972__$1;
(statearr_26976_27064[(2)] = inst_26940);

(statearr_26976_27064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (6))){
var inst_26955 = (state_26972[(7)]);
var inst_26954 = (state_26972[(2)]);
var inst_26955__$1 = fluree.db.util.async.throw_err.call(null,inst_26954);
var inst_26956 = (inst_26955__$1 == null);
var state_26972__$1 = (function (){var statearr_26977 = state_26972;
(statearr_26977[(7)] = inst_26955__$1);

return statearr_26977;
})();
if(cljs.core.truth_(inst_26956)){
var statearr_26978_27065 = state_26972__$1;
(statearr_26978_27065[(1)] = (7));

} else {
var statearr_26979_27066 = state_26972__$1;
(statearr_26979_27066[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (3))){
var inst_26970 = (state_26972[(2)]);
var state_26972__$1 = state_26972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26972__$1,inst_26970);
} else {
if((state_val_26973 === (12))){
var inst_26967 = (state_26972[(2)]);
var _ = (function (){var statearr_26980 = state_26972;
(statearr_26980[(4)] = cljs.core.rest.call(null,(state_26972[(4)])));

return statearr_26980;
})();
var state_26972__$1 = state_26972;
var statearr_26981_27067 = state_26972__$1;
(statearr_26981_27067[(2)] = inst_26967);

(statearr_26981_27067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (2))){
var _ = (function (){var statearr_26982 = state_26972;
(statearr_26982[(4)] = cljs.core.cons.call(null,(5),(state_26972[(4)])));

return statearr_26982;
})();
var inst_26946 = (30);
var inst_26948 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26950 = [inst_26946,tag_name];
var inst_26951 = (new cljs.core.PersistentVector(null,2,(5),inst_26949,inst_26950,null));
var inst_26952 = fluree.db.query.range.index_range.call(null,inst_26948,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26951);
var state_26972__$1 = state_26972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26972__$1,(6),inst_26952);
} else {
if((state_val_26973 === (11))){
var inst_26961 = (state_26972[(8)]);
var inst_26965 = fluree.db.flake.s.call(null,inst_26961);
var state_26972__$1 = state_26972;
var statearr_26984_27068 = state_26972__$1;
(statearr_26984_27068[(2)] = inst_26965);

(statearr_26984_27068[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (9))){
var inst_26961 = (state_26972[(8)]);
var inst_26961__$1 = (state_26972[(2)]);
var inst_26962 = (inst_26961__$1 == null);
var state_26972__$1 = (function (){var statearr_26985 = state_26972;
(statearr_26985[(8)] = inst_26961__$1);

return statearr_26985;
})();
if(cljs.core.truth_(inst_26962)){
var statearr_26986_27069 = state_26972__$1;
(statearr_26986_27069[(1)] = (10));

} else {
var statearr_26987_27070 = state_26972__$1;
(statearr_26987_27070[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (5))){
var _ = (function (){var statearr_26988 = state_26972;
(statearr_26988[(4)] = cljs.core.rest.call(null,(state_26972[(4)])));

return statearr_26988;
})();
var state_26972__$1 = state_26972;
var ex26983 = (state_26972__$1[(2)]);
var statearr_26989_27071 = state_26972__$1;
(statearr_26989_27071[(5)] = ex26983);


if((ex26983 instanceof Error)){
var statearr_26990_27072 = state_26972__$1;
(statearr_26990_27072[(1)] = (4));

(statearr_26990_27072[(5)] = null);

} else {
throw ex26983;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (10))){
var state_26972__$1 = state_26972;
var statearr_26991_27073 = state_26972__$1;
(statearr_26991_27073[(2)] = null);

(statearr_26991_27073[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26973 === (8))){
var inst_26955 = (state_26972[(7)]);
var inst_26959 = cljs.core.first.call(null,inst_26955);
var state_26972__$1 = state_26972;
var statearr_26992_27074 = state_26972__$1;
(statearr_26992_27074[(2)] = inst_26959);

(statearr_26992_27074[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26993 = [null,null,null,null,null,null,null,null,null];
(statearr_26993[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26993[(1)] = (1));

return statearr_26993;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26972){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_26972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26994){var ex__2687__auto__ = e26994;
var statearr_26995_27075 = state_26972;
(statearr_26995_27075[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_26972[(4)]))){
var statearr_26996_27076 = state_26972;
(statearr_26996_27076[(1)] = cljs.core.first.call(null,(state_26972[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27077 = state_26972;
state_26972 = G__27077;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26972){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26997 = f__2707__auto__.call(null);
(statearr_26997[(6)] = c__2706__auto__);

return statearr_26997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27032){
var state_val_27033 = (state_27032[(1)]);
if((state_val_27033 === (7))){
var inst_27011 = typeof pred === 'string';
var state_27032__$1 = state_27032;
if(cljs.core.truth_(inst_27011)){
var statearr_27034_27078 = state_27032__$1;
(statearr_27034_27078[(1)] = (10));

} else {
var statearr_27035_27079 = state_27032__$1;
(statearr_27035_27079[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (1))){
var state_27032__$1 = state_27032;
var statearr_27036_27080 = state_27032__$1;
(statearr_27036_27080[(2)] = null);

(statearr_27036_27080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (4))){
var inst_26998 = (state_27032[(2)]);
var state_27032__$1 = state_27032;
var statearr_27037_27081 = state_27032__$1;
(statearr_27037_27081[(2)] = inst_26998);

(statearr_27037_27081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (15))){
var inst_27025 = (state_27032[(2)]);
var state_27032__$1 = state_27032;
var statearr_27038_27082 = state_27032__$1;
(statearr_27038_27082[(2)] = inst_27025);

(statearr_27038_27082[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (13))){
var inst_27016 = (state_27032[(7)]);
var inst_27018 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27016),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27019 = fluree.db.dbproto._tag_id.call(null,this$,inst_27018);
var state_27032__$1 = state_27032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27032__$1,(16),inst_27019);
} else {
if((state_val_27033 === (6))){
var inst_27006 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_27032__$1 = state_27032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27032__$1,(9),inst_27006);
} else {
if((state_val_27033 === (3))){
var inst_27030 = (state_27032[(2)]);
var state_27032__$1 = state_27032;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27032__$1,inst_27030);
} else {
if((state_val_27033 === (12))){
var inst_27016 = (state_27032[(7)]);
var inst_27016__$1 = (state_27032[(2)]);
var state_27032__$1 = (function (){var statearr_27039 = state_27032;
(statearr_27039[(7)] = inst_27016__$1);

return statearr_27039;
})();
if(cljs.core.truth_(inst_27016__$1)){
var statearr_27040_27083 = state_27032__$1;
(statearr_27040_27083[(1)] = (13));

} else {
var statearr_27041_27084 = state_27032__$1;
(statearr_27041_27084[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (2))){
var _ = (function (){var statearr_27042 = state_27032;
(statearr_27042[(4)] = cljs.core.cons.call(null,(5),(state_27032[(4)])));

return statearr_27042;
})();
var inst_27004 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27032__$1 = state_27032;
if(inst_27004){
var statearr_27043_27085 = state_27032__$1;
(statearr_27043_27085[(1)] = (6));

} else {
var statearr_27044_27086 = state_27032__$1;
(statearr_27044_27086[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (11))){
var inst_27014 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27032__$1 = state_27032;
var statearr_27046_27087 = state_27032__$1;
(statearr_27046_27087[(2)] = inst_27014);

(statearr_27046_27087[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (9))){
var inst_27008 = (state_27032[(2)]);
var inst_27009 = fluree.db.util.async.throw_err.call(null,inst_27008);
var state_27032__$1 = state_27032;
var statearr_27047_27088 = state_27032__$1;
(statearr_27047_27088[(2)] = inst_27009);

(statearr_27047_27088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (5))){
var _ = (function (){var statearr_27048 = state_27032;
(statearr_27048[(4)] = cljs.core.rest.call(null,(state_27032[(4)])));

return statearr_27048;
})();
var state_27032__$1 = state_27032;
var ex27045 = (state_27032__$1[(2)]);
var statearr_27049_27089 = state_27032__$1;
(statearr_27049_27089[(5)] = ex27045);


if((ex27045 instanceof Error)){
var statearr_27050_27090 = state_27032__$1;
(statearr_27050_27090[(1)] = (4));

(statearr_27050_27090[(5)] = null);

} else {
throw ex27045;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (14))){
var state_27032__$1 = state_27032;
var statearr_27051_27091 = state_27032__$1;
(statearr_27051_27091[(2)] = null);

(statearr_27051_27091[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (16))){
var inst_27021 = (state_27032[(2)]);
var inst_27022 = fluree.db.util.async.throw_err.call(null,inst_27021);
var state_27032__$1 = state_27032;
var statearr_27052_27092 = state_27032__$1;
(statearr_27052_27092[(2)] = inst_27022);

(statearr_27052_27092[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (10))){
var state_27032__$1 = state_27032;
var statearr_27053_27093 = state_27032__$1;
(statearr_27053_27093[(2)] = pred);

(statearr_27053_27093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27033 === (8))){
var inst_27027 = (state_27032[(2)]);
var _ = (function (){var statearr_27054 = state_27032;
(statearr_27054[(4)] = cljs.core.rest.call(null,(state_27032[(4)])));

return statearr_27054;
})();
var state_27032__$1 = state_27032;
var statearr_27055_27094 = state_27032__$1;
(statearr_27055_27094[(2)] = inst_27027);

(statearr_27055_27094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_27056 = [null,null,null,null,null,null,null,null];
(statearr_27056[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_27056[(1)] = (1));

return statearr_27056;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_27032){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_27032);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27057){var ex__2687__auto__ = e27057;
var statearr_27058_27095 = state_27032;
(statearr_27058_27095[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_27032[(4)]))){
var statearr_27059_27096 = state_27032;
(statearr_27059_27096[(1)] = cljs.core.first.call(null,(state_27032[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27097 = state_27032;
state_27032 = G__27097;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_27032){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_27032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27060 = f__2707__auto__.call(null);
(statearr_27060[(6)] = c__2706__auto__);

return statearr_27060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27099,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27103 = k27099;
var G__27103__$1 = (((G__27103 instanceof cljs.core.Keyword))?G__27103.fqn:null);
switch (G__27103__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27099,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__27104){
var vec__27105 = p__27104;
var k__5367__auto__ = cljs.core.nth.call(null,vec__27105,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__27105,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27098){
var self__ = this;
var G__27098__$1 = this;
return (new cljs.core.RecordIter((0),G__27098__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27100,other27101){
var self__ = this;
var this27100__$1 = this;
return (((!((other27101 == null)))) && ((((this27100__$1.constructor === other27101.constructor)) && (((cljs.core._EQ_.call(null,this27100__$1.conn,other27101.conn)) && (((cljs.core._EQ_.call(null,this27100__$1.network,other27101.network)) && (((cljs.core._EQ_.call(null,this27100__$1.ledger_id,other27101.ledger_id)) && (((cljs.core._EQ_.call(null,this27100__$1.block,other27101.block)) && (((cljs.core._EQ_.call(null,this27100__$1.t,other27101.t)) && (((cljs.core._EQ_.call(null,this27100__$1.tt_id,other27101.tt_id)) && (((cljs.core._EQ_.call(null,this27100__$1.stats,other27101.stats)) && (((cljs.core._EQ_.call(null,this27100__$1.spot,other27101.spot)) && (((cljs.core._EQ_.call(null,this27100__$1.psot,other27101.psot)) && (((cljs.core._EQ_.call(null,this27100__$1.post,other27101.post)) && (((cljs.core._EQ_.call(null,this27100__$1.opst,other27101.opst)) && (((cljs.core._EQ_.call(null,this27100__$1.tspo,other27101.tspo)) && (((cljs.core._EQ_.call(null,this27100__$1.schema,other27101.schema)) && (((cljs.core._EQ_.call(null,this27100__$1.settings,other27101.settings)) && (((cljs.core._EQ_.call(null,this27100__$1.comparators,other27101.comparators)) && (((cljs.core._EQ_.call(null,this27100__$1.schema_cache,other27101.schema_cache)) && (((cljs.core._EQ_.call(null,this27100__$1.novelty,other27101.novelty)) && (((cljs.core._EQ_.call(null,this27100__$1.permissions,other27101.permissions)) && (((cljs.core._EQ_.call(null,this27100__$1.fork,other27101.fork)) && (((cljs.core._EQ_.call(null,this27100__$1.fork_block,other27101.fork_block)) && (((cljs.core._EQ_.call(null,this27100__$1.current_db_fn,other27101.current_db_fn)) && (cljs.core._EQ_.call(null,this27100__$1.__extmap,other27101.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27099){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27108 = k27099;
var G__27108__$1 = (((G__27108 instanceof cljs.core.Keyword))?G__27108.fqn:null);
switch (G__27108__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27099);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27098){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27109 = cljs.core.keyword_identical_QMARK_;
var expr__27110 = k__5352__auto__;
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27110))){
return (new fluree.db.graphdb.GraphDb(G__27098,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27098,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27098,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__27098,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__27098,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__27098,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__27098,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__27098,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27098,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27098,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27098,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27098,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__27098,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__27098,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__27098,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__27098,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__27098,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__27098,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__27098,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27098,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27109.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__27110))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27098,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__27098),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27098){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27098,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27102){
var extmap__5385__auto__ = (function (){var G__27112 = cljs.core.dissoc.call(null,G__27102,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__27102)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27112);
} else {
return G__27112;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27102),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27102),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.call(null,(function (m,idx){
return cljs.core.assoc.call(null,m,idx,clojure.data.avl.sorted_set_by.call(null,cljs.core.get.call(null,comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__27115 = fluree.db.index.default_comparators;
var map__27115__$1 = cljs.core.__destructure_map.call(null,map__27115);
var spot_cmp = cljs.core.get.call(null,map__27115__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.call(null,map__27115__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.call(null,map__27115__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.call(null,map__27115__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.call(null,map__27115__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch.call(null,network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch.call(null,network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch.call(null,network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch.call(null,network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch.call(null,network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
