// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__72516 = arguments.length;
switch (G__72516) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72561){
var state_val_72562 = (state_72561[(1)]);
if((state_val_72562 === (7))){
var inst_72531 = typeof user === 'string';
var state_72561__$1 = state_72561;
if(cljs.core.truth_(inst_72531)){
var statearr_72563_72592 = state_72561__$1;
(statearr_72563_72592[(1)] = (9));

} else {
var statearr_72564_72593 = state_72561__$1;
(statearr_72564_72593[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (1))){
var state_72561__$1 = state_72561;
var statearr_72565_72594 = state_72561__$1;
(statearr_72565_72594[(2)] = null);

(statearr_72565_72594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (4))){
var inst_72517 = (state_72561[(2)]);
var inst_72518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72519 = [inst_72517];
var inst_72520 = (new cljs.core.PersistentVector(null,1,(5),inst_72518,inst_72519,null));
var inst_72521 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72520);
var inst_72522 = reject.call(null,inst_72517);
var state_72561__$1 = (function (){var statearr_72566 = state_72561;
(statearr_72566[(7)] = inst_72521);

return statearr_72566;
})();
var statearr_72567_72595 = state_72561__$1;
(statearr_72567_72595[(2)] = inst_72522);

(statearr_72567_72595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (15))){
var inst_72550 = (state_72561[(2)]);
var inst_72551 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_72550);
var inst_72552 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72553 = cljs.core.constantly.call(null,inst_72551);
var inst_72554 = cljs.core.swap_BANG_.call(null,inst_72552,inst_72553);
var inst_72555 = fluree.db.connection.add_token.call(null,conn,inst_72551);
var inst_72556 = resolve.call(null,inst_72550);
var _ = (function (){var statearr_72568 = state_72561;
(statearr_72568[(4)] = cljs.core.rest.call(null,(state_72561[(4)])));

return statearr_72568;
})();
var state_72561__$1 = (function (){var statearr_72569 = state_72561;
(statearr_72569[(8)] = inst_72554);

(statearr_72569[(9)] = inst_72555);

return statearr_72569;
})();
var statearr_72570_72596 = state_72561__$1;
(statearr_72570_72596[(2)] = inst_72556);

(statearr_72570_72596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (13))){
var state_72561__$1 = state_72561;
var statearr_72571_72597 = state_72561__$1;
(statearr_72571_72597[(2)] = null);

(statearr_72571_72597[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (6))){
var state_72561__$1 = state_72561;
var statearr_72572_72598 = state_72561__$1;
(statearr_72572_72598[(2)] = user);

(statearr_72572_72598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (3))){
var inst_72559 = (state_72561[(2)]);
var state_72561__$1 = state_72561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72561__$1,inst_72559);
} else {
if((state_val_72562 === (12))){
var state_72561__$1 = state_72561;
var statearr_72573_72599 = state_72561__$1;
(statearr_72573_72599[(2)] = user);

(statearr_72573_72599[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (2))){
var _ = (function (){var statearr_72574 = state_72561;
(statearr_72574[(4)] = cljs.core.cons.call(null,(5),(state_72561[(4)])));

return statearr_72574;
})();
var inst_72528 = typeof user === 'number';
var state_72561__$1 = state_72561;
if(cljs.core.truth_(inst_72528)){
var statearr_72575_72600 = state_72561__$1;
(statearr_72575_72600[(1)] = (6));

} else {
var statearr_72576_72601 = state_72561__$1;
(statearr_72576_72601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (11))){
var inst_72542 = (state_72561[(2)]);
var state_72561__$1 = state_72561;
var statearr_72578_72602 = state_72561__$1;
(statearr_72578_72602[(2)] = inst_72542);

(statearr_72578_72602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (9))){
var inst_72533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72534 = ["_user/username",user];
var inst_72535 = (new cljs.core.PersistentVector(null,2,(5),inst_72533,inst_72534,null));
var state_72561__$1 = state_72561;
var statearr_72579_72603 = state_72561__$1;
(statearr_72579_72603[(2)] = inst_72535);

(statearr_72579_72603[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (5))){
var _ = (function (){var statearr_72580 = state_72561;
(statearr_72580[(4)] = cljs.core.rest.call(null,(state_72561[(4)])));

return statearr_72580;
})();
var state_72561__$1 = state_72561;
var ex72577 = (state_72561__$1[(2)]);
var statearr_72581_72604 = state_72561__$1;
(statearr_72581_72604[(5)] = ex72577);


var statearr_72582_72605 = state_72561__$1;
(statearr_72582_72605[(1)] = (4));

(statearr_72582_72605[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (14))){
var inst_72540 = (state_72561[(2)]);
var state_72561__$1 = state_72561;
var statearr_72583_72606 = state_72561__$1;
(statearr_72583_72606[(2)] = inst_72540);

(statearr_72583_72606[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (10))){
var state_72561__$1 = state_72561;
var statearr_72584_72607 = state_72561__$1;
(statearr_72584_72607[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72562 === (8))){
var inst_72544 = (state_72561[(2)]);
var inst_72545 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_72546 = [account,inst_72544,password,expireSeconds,syncTo];
var inst_72547 = cljs.core.PersistentHashMap.fromArrays(inst_72545,inst_72546);
var inst_72548 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_72547);
var state_72561__$1 = state_72561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72561__$1,(15),inst_72548);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_72586 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72586[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_72586[(1)] = (1));

return statearr_72586;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_72561){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72587){var ex__2687__auto__ = e72587;
var statearr_72588_72608 = state_72561;
(statearr_72588_72608[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72561[(4)]))){
var statearr_72589_72609 = state_72561;
(statearr_72589_72609[(1)] = cljs.core.first.call(null,(state_72561[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72610 = state_72561;
state_72561 = G__72610;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_72561){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_72561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72590 = f__2707__auto__.call(null);
(statearr_72590[(6)] = c__2706__auto__);

return statearr_72590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__72612 = arguments.length;
switch (G__72612) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72621){
var state_val_72622 = (state_72621[(1)]);
if((state_val_72622 === (1))){
var inst_72613 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72615 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_72616 = (new cljs.core.PersistentVector(null,4,(5),inst_72614,inst_72615,null));
var inst_72617 = cljs.core.async.put_BANG_.call(null,inst_72613,inst_72616);
var inst_72618 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__72623 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__72624 = null;
var count__72625 = (0);
var i__72626 = (0);
while(true){
if((i__72626 < count__72625)){
var k = cljs.core._nth.call(null,chunk__72624,i__72626);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__72634 = seq__72623;
var G__72635 = chunk__72624;
var G__72636 = count__72625;
var G__72637 = (i__72626 + (1));
seq__72623 = G__72634;
chunk__72624 = G__72635;
count__72625 = G__72636;
i__72626 = G__72637;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__72623);
if(temp__5804__auto__){
var seq__72623__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72623__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__72623__$1);
var G__72638 = cljs.core.chunk_rest.call(null,seq__72623__$1);
var G__72639 = c__5568__auto__;
var G__72640 = cljs.core.count.call(null,c__5568__auto__);
var G__72641 = (0);
seq__72623 = G__72638;
chunk__72624 = G__72639;
count__72625 = G__72640;
i__72626 = G__72641;
continue;
} else {
var k = cljs.core.first.call(null,seq__72623__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__72642 = cljs.core.next.call(null,seq__72623__$1);
var G__72643 = null;
var G__72644 = (0);
var G__72645 = (0);
seq__72623 = G__72642;
chunk__72624 = G__72643;
count__72625 = G__72644;
i__72626 = G__72645;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_72619 = cljs.core.async.take_BANG_.call(null,pc,inst_72618);
var state_72621__$1 = (function (){var statearr_72627 = state_72621;
(statearr_72627[(7)] = inst_72617);

return statearr_72627;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72621__$1,inst_72619);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_72628 = [null,null,null,null,null,null,null,null];
(statearr_72628[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_72628[(1)] = (1));

return statearr_72628;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_72621){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72621);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72629){var ex__2687__auto__ = e72629;
var statearr_72630_72646 = state_72621;
(statearr_72630_72646[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72621[(4)]))){
var statearr_72631_72647 = state_72621;
(statearr_72631_72647[(1)] = cljs.core.first.call(null,(state_72621[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72648 = state_72621;
state_72621 = G__72648;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_72621){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_72621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72632 = f__2707__auto__.call(null);
(statearr_72632[(6)] = c__2706__auto__);

return statearr_72632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__72650 = arguments.length;
switch (G__72650) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72687){
var state_val_72688 = (state_72687[(1)]);
if((state_val_72688 === (1))){
var state_72687__$1 = state_72687;
var statearr_72689_72710 = state_72687__$1;
(statearr_72689_72710[(2)] = null);

(statearr_72689_72710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72688 === (2))){
var _ = (function (){var statearr_72690 = state_72687;
(statearr_72690[(4)] = cljs.core.cons.call(null,(5),(state_72687[(4)])));

return statearr_72690;
})();
var inst_72662 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_72663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72664 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_72665 = (new cljs.core.PersistentVector(null,1,(5),inst_72663,inst_72664,null));
var inst_72666 = cljs.core.PersistentHashMap.EMPTY;
var inst_72667 = cljs.core.atom.call(null,inst_72666);
var inst_72668 = cljs.core.assoc_in.call(null,inst_72662,inst_72665,inst_72667);
var inst_72669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72670 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72671 = (new cljs.core.PersistentVector(null,1,(5),inst_72669,inst_72670,null));
var inst_72672 = cljs.core.PersistentHashMap.EMPTY;
var inst_72673 = cljs.core.atom.call(null,inst_72672);
var inst_72674 = cljs.core.assoc_in.call(null,inst_72668,inst_72671,inst_72673);
var inst_72675 = cljs.core.async.promise_chan.call(null);
var inst_72676 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_72674);
var inst_72677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72678 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_72675,null];
var inst_72679 = (new cljs.core.PersistentVector(null,4,(5),inst_72677,inst_72678,null));
var inst_72680 = cljs.core.async.put_BANG_.call(null,inst_72676,inst_72679);
var inst_72681 = (function (){var conn = inst_72674;
var pc = inst_72675;
return (function (x){
if((x == null)){
} else {
var seq__72691_72711 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__72692_72712 = null;
var count__72693_72713 = (0);
var i__72694_72714 = (0);
while(true){
if((i__72694_72714 < count__72693_72713)){
var k_72715 = cljs.core._nth.call(null,chunk__72692_72712,i__72694_72714);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72715], null),cljs.core.get.call(null,x,k_72715,null));


var G__72716 = seq__72691_72711;
var G__72717 = chunk__72692_72712;
var G__72718 = count__72693_72713;
var G__72719 = (i__72694_72714 + (1));
seq__72691_72711 = G__72716;
chunk__72692_72712 = G__72717;
count__72693_72713 = G__72718;
i__72694_72714 = G__72719;
continue;
} else {
var temp__5804__auto___72720 = cljs.core.seq.call(null,seq__72691_72711);
if(temp__5804__auto___72720){
var seq__72691_72721__$1 = temp__5804__auto___72720;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72691_72721__$1)){
var c__5568__auto___72722 = cljs.core.chunk_first.call(null,seq__72691_72721__$1);
var G__72723 = cljs.core.chunk_rest.call(null,seq__72691_72721__$1);
var G__72724 = c__5568__auto___72722;
var G__72725 = cljs.core.count.call(null,c__5568__auto___72722);
var G__72726 = (0);
seq__72691_72711 = G__72723;
chunk__72692_72712 = G__72724;
count__72693_72713 = G__72725;
i__72694_72714 = G__72726;
continue;
} else {
var k_72727 = cljs.core.first.call(null,seq__72691_72721__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72727], null),cljs.core.get.call(null,x,k_72727,null));


var G__72728 = cljs.core.next.call(null,seq__72691_72721__$1);
var G__72729 = null;
var G__72730 = (0);
var G__72731 = (0);
seq__72691_72711 = G__72728;
chunk__72692_72712 = G__72729;
count__72693_72713 = G__72730;
i__72694_72714 = G__72731;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_72682 = cljs.core.async.take_BANG_.call(null,inst_72675,inst_72681);
var ___$1 = (function (){var statearr_72695 = state_72687;
(statearr_72695[(4)] = cljs.core.rest.call(null,(state_72687[(4)])));

return statearr_72695;
})();
var state_72687__$1 = (function (){var statearr_72696 = state_72687;
(statearr_72696[(7)] = inst_72680);

return statearr_72696;
})();
var statearr_72697_72732 = state_72687__$1;
(statearr_72697_72732[(2)] = inst_72682);

(statearr_72697_72732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72688 === (3))){
var inst_72685 = (state_72687[(2)]);
var state_72687__$1 = state_72687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72687__$1,inst_72685);
} else {
if((state_val_72688 === (4))){
var inst_72651 = (state_72687[(2)]);
var inst_72652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72653 = [inst_72651];
var inst_72654 = (new cljs.core.PersistentVector(null,1,(5),inst_72652,inst_72653,null));
var inst_72655 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72654);
var inst_72656 = reject.call(null,inst_72651);
var state_72687__$1 = (function (){var statearr_72699 = state_72687;
(statearr_72699[(8)] = inst_72655);

return statearr_72699;
})();
var statearr_72700_72733 = state_72687__$1;
(statearr_72700_72733[(2)] = inst_72656);

(statearr_72700_72733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72688 === (5))){
var _ = (function (){var statearr_72701 = state_72687;
(statearr_72701[(4)] = cljs.core.rest.call(null,(state_72687[(4)])));

return statearr_72701;
})();
var state_72687__$1 = state_72687;
var ex72698 = (state_72687__$1[(2)]);
var statearr_72702_72734 = state_72687__$1;
(statearr_72702_72734[(5)] = ex72698);


var statearr_72703_72735 = state_72687__$1;
(statearr_72703_72735[(1)] = (4));

(statearr_72703_72735[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_72704 = [null,null,null,null,null,null,null,null,null];
(statearr_72704[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_72704[(1)] = (1));

return statearr_72704;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_72687){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72705){var ex__2687__auto__ = e72705;
var statearr_72706_72736 = state_72687;
(statearr_72706_72736[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72687[(4)]))){
var statearr_72707_72737 = state_72687;
(statearr_72707_72737[(1)] = cljs.core.first.call(null,(state_72687[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72738 = state_72687;
state_72687 = G__72738;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_72687){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_72687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72708 = f__2707__auto__.call(null);
(statearr_72708[(6)] = c__2706__auto__);

return statearr_72708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__72740 = arguments.length;
switch (G__72740) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__72742 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__72742,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__72742,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__72745 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__72745,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__72745,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72798){
var state_val_72799 = (state_72798[(1)]);
if((state_val_72799 === (7))){
var inst_72759 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72760 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72761 = cljs.core.PersistentHashMap.fromArrays(inst_72759,inst_72760);
var inst_72762 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72761);
var inst_72763 = (function(){throw inst_72762})();
var state_72798__$1 = state_72798;
var statearr_72800_72829 = state_72798__$1;
(statearr_72800_72829[(2)] = inst_72763);

(statearr_72800_72829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (1))){
var state_72798__$1 = state_72798;
var statearr_72801_72830 = state_72798__$1;
(statearr_72801_72830[(2)] = null);

(statearr_72801_72830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (4))){
var inst_72748 = (state_72798[(2)]);
var inst_72749 = cljs.core.clj__GT_js.call(null,inst_72748);
var inst_72750 = reject.call(null,inst_72749);
var state_72798__$1 = state_72798;
var statearr_72802_72831 = state_72798__$1;
(statearr_72802_72831[(2)] = inst_72750);

(statearr_72802_72831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (13))){
var inst_72777 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72778 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72779 = cljs.core.PersistentHashMap.fromArrays(inst_72777,inst_72778);
var inst_72780 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_72779);
var inst_72781 = (function(){throw inst_72780})();
var state_72798__$1 = state_72798;
var statearr_72803_72832 = state_72798__$1;
(statearr_72803_72832[(2)] = inst_72781);

(statearr_72803_72832[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (6))){
var state_72798__$1 = state_72798;
var statearr_72804_72833 = state_72798__$1;
(statearr_72804_72833[(2)] = null);

(statearr_72804_72833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (3))){
var inst_72796 = (state_72798[(2)]);
var state_72798__$1 = state_72798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72798__$1,inst_72796);
} else {
if((state_val_72799 === (12))){
var state_72798__$1 = state_72798;
var statearr_72805_72834 = state_72798__$1;
(statearr_72805_72834[(2)] = null);

(statearr_72805_72834[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (2))){
var _ = (function (){var statearr_72806 = state_72798;
(statearr_72806[(4)] = cljs.core.cons.call(null,(5),(state_72798[(4)])));

return statearr_72806;
})();
var inst_72756 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72798__$1 = state_72798;
if(cljs.core.truth_(inst_72756)){
var statearr_72807_72835 = state_72798__$1;
(statearr_72807_72835[(1)] = (6));

} else {
var statearr_72808_72836 = state_72798__$1;
(statearr_72808_72836[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (11))){
var inst_72774 = (state_72798[(2)]);
var state_72798__$1 = (function (){var statearr_72810 = state_72798;
(statearr_72810[(7)] = inst_72774);

return statearr_72810;
})();
if(cljs.core.truth_(password)){
var statearr_72811_72837 = state_72798__$1;
(statearr_72811_72837[(1)] = (12));

} else {
var statearr_72812_72838 = state_72798__$1;
(statearr_72812_72838[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (9))){
var state_72798__$1 = state_72798;
var statearr_72813_72839 = state_72798__$1;
(statearr_72813_72839[(2)] = null);

(statearr_72813_72839[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (5))){
var _ = (function (){var statearr_72814 = state_72798;
(statearr_72814[(4)] = cljs.core.rest.call(null,(state_72798[(4)])));

return statearr_72814;
})();
var state_72798__$1 = state_72798;
var ex72809 = (state_72798__$1[(2)]);
var statearr_72815_72840 = state_72798__$1;
(statearr_72815_72840[(5)] = ex72809);


var statearr_72816_72841 = state_72798__$1;
(statearr_72816_72841[(1)] = (4));

(statearr_72816_72841[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (14))){
var inst_72783 = (state_72798[(2)]);
var inst_72784 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_72785 = fluree.db.util.core.without_nils.call(null,inst_72784);
var inst_72786 = cljs.core.async.promise_chan.call(null);
var inst_72787 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72789 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_72785,inst_72786,null];
var inst_72790 = (new cljs.core.PersistentVector(null,4,(5),inst_72788,inst_72789,null));
var inst_72791 = cljs.core.async.put_BANG_.call(null,inst_72787,inst_72790);
var inst_72792 = (function (){var _ = inst_72783;
var data = inst_72785;
var pc = inst_72786;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_72793 = cljs.core.async.take_BANG_.call(null,inst_72786,inst_72792);
var _ = (function (){var statearr_72817 = state_72798;
(statearr_72817[(4)] = cljs.core.rest.call(null,(state_72798[(4)])));

return statearr_72817;
})();
var state_72798__$1 = (function (){var statearr_72818 = state_72798;
(statearr_72818[(8)] = inst_72791);

return statearr_72818;
})();
var statearr_72819_72842 = state_72798__$1;
(statearr_72819_72842[(2)] = inst_72793);

(statearr_72819_72842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (10))){
var inst_72768 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72769 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72770 = cljs.core.PersistentHashMap.fromArrays(inst_72768,inst_72769);
var inst_72771 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_72770);
var inst_72772 = (function(){throw inst_72771})();
var state_72798__$1 = state_72798;
var statearr_72820_72843 = state_72798__$1;
(statearr_72820_72843[(2)] = inst_72772);

(statearr_72820_72843[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72799 === (8))){
var inst_72765 = (state_72798[(2)]);
var state_72798__$1 = (function (){var statearr_72821 = state_72798;
(statearr_72821[(9)] = inst_72765);

return statearr_72821;
})();
if(cljs.core.truth_(ledger)){
var statearr_72822_72844 = state_72798__$1;
(statearr_72822_72844[(1)] = (9));

} else {
var statearr_72823_72845 = state_72798__$1;
(statearr_72823_72845[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_72824 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72824[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2684__auto__);

(statearr_72824[(1)] = (1));

return statearr_72824;
});
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1 = (function (state_72798){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72825){var ex__2687__auto__ = e72825;
var statearr_72826_72846 = state_72798;
(statearr_72826_72846[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72798[(4)]))){
var statearr_72827_72847 = state_72798;
(statearr_72827_72847[(1)] = cljs.core.first.call(null,(state_72798[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72848 = state_72798;
state_72798 = G__72848;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = function(state_72798){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1.call(this,state_72798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72828 = f__2707__auto__.call(null);
(statearr_72828[(6)] = c__2706__auto__);

return statearr_72828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__72850 = arguments.length;
switch (G__72850) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72917){
var state_val_72918 = (state_72917[(1)]);
if((state_val_72918 === (7))){
var inst_72862 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72863 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72864 = cljs.core.PersistentHashMap.fromArrays(inst_72862,inst_72863);
var inst_72865 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72864);
var inst_72866 = (function(){throw inst_72865})();
var state_72917__$1 = state_72917;
var statearr_72919_72958 = state_72917__$1;
(statearr_72919_72958[(2)] = inst_72866);

(statearr_72919_72958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (20))){
var inst_72900 = (state_72917[(2)]);
var inst_72901 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72902 = [ledger,password,user,auth,expire];
var inst_72903 = cljs.core.PersistentHashMap.fromArrays(inst_72901,inst_72902);
var inst_72904 = fluree.db.util.core.without_nils.call(null,inst_72903);
var inst_72905 = cljs.core.async.promise_chan.call(null);
var inst_72906 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72908 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_72904,inst_72905,null];
var inst_72909 = (new cljs.core.PersistentVector(null,4,(5),inst_72907,inst_72908,null));
var inst_72910 = cljs.core.async.put_BANG_.call(null,inst_72906,inst_72909);
var inst_72911 = (function (){var _ = inst_72900;
var data = inst_72904;
var pc = inst_72905;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_72912 = cljs.core.async.take_BANG_.call(null,inst_72905,inst_72911);
var _ = (function (){var statearr_72920 = state_72917;
(statearr_72920[(4)] = cljs.core.rest.call(null,(state_72917[(4)])));

return statearr_72920;
})();
var state_72917__$1 = (function (){var statearr_72921 = state_72917;
(statearr_72921[(7)] = inst_72910);

return statearr_72921;
})();
var statearr_72922_72959 = state_72917__$1;
(statearr_72922_72959[(2)] = inst_72912);

(statearr_72922_72959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (1))){
var state_72917__$1 = state_72917;
var statearr_72923_72960 = state_72917__$1;
(statearr_72923_72960[(2)] = null);

(statearr_72923_72960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (4))){
var inst_72851 = (state_72917[(2)]);
var inst_72852 = cljs.core.clj__GT_js.call(null,inst_72851);
var inst_72853 = reject.call(null,inst_72852);
var state_72917__$1 = state_72917;
var statearr_72924_72961 = state_72917__$1;
(statearr_72924_72961[(2)] = inst_72853);

(statearr_72924_72961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (15))){
var inst_72887 = (state_72917[(8)]);
var state_72917__$1 = state_72917;
var statearr_72925_72962 = state_72917__$1;
(statearr_72925_72962[(2)] = inst_72887);

(statearr_72925_72962[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (13))){
var inst_72880 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72881 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72882 = cljs.core.PersistentHashMap.fromArrays(inst_72880,inst_72881);
var inst_72883 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_72882);
var inst_72884 = (function(){throw inst_72883})();
var state_72917__$1 = state_72917;
var statearr_72926_72963 = state_72917__$1;
(statearr_72926_72963[(2)] = inst_72884);

(statearr_72926_72963[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (6))){
var state_72917__$1 = state_72917;
var statearr_72927_72964 = state_72917__$1;
(statearr_72927_72964[(2)] = null);

(statearr_72927_72964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (17))){
var inst_72891 = (state_72917[(2)]);
var state_72917__$1 = state_72917;
if(cljs.core.truth_(inst_72891)){
var statearr_72928_72965 = state_72917__$1;
(statearr_72928_72965[(1)] = (18));

} else {
var statearr_72929_72966 = state_72917__$1;
(statearr_72929_72966[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (3))){
var inst_72915 = (state_72917[(2)]);
var state_72917__$1 = state_72917;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72917__$1,inst_72915);
} else {
if((state_val_72918 === (12))){
var state_72917__$1 = state_72917;
var statearr_72930_72967 = state_72917__$1;
(statearr_72930_72967[(2)] = null);

(statearr_72930_72967[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (2))){
var _ = (function (){var statearr_72931 = state_72917;
(statearr_72931[(4)] = cljs.core.cons.call(null,(5),(state_72917[(4)])));

return statearr_72931;
})();
var inst_72859 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72917__$1 = state_72917;
if(cljs.core.truth_(inst_72859)){
var statearr_72932_72968 = state_72917__$1;
(statearr_72932_72968[(1)] = (6));

} else {
var statearr_72933_72969 = state_72917__$1;
(statearr_72933_72969[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (19))){
var inst_72894 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72895 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72896 = cljs.core.PersistentHashMap.fromArrays(inst_72894,inst_72895);
var inst_72897 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_72896);
var inst_72898 = (function(){throw inst_72897})();
var state_72917__$1 = state_72917;
var statearr_72934_72970 = state_72917__$1;
(statearr_72934_72970[(2)] = inst_72898);

(statearr_72934_72970[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (11))){
var inst_72877 = (state_72917[(2)]);
var state_72917__$1 = (function (){var statearr_72936 = state_72917;
(statearr_72936[(9)] = inst_72877);

return statearr_72936;
})();
if(cljs.core.truth_(password)){
var statearr_72937_72971 = state_72917__$1;
(statearr_72937_72971[(1)] = (12));

} else {
var statearr_72938_72972 = state_72917__$1;
(statearr_72938_72972[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (9))){
var state_72917__$1 = state_72917;
var statearr_72939_72973 = state_72917__$1;
(statearr_72939_72973[(2)] = null);

(statearr_72939_72973[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (5))){
var _ = (function (){var statearr_72940 = state_72917;
(statearr_72940[(4)] = cljs.core.rest.call(null,(state_72917[(4)])));

return statearr_72940;
})();
var state_72917__$1 = state_72917;
var ex72935 = (state_72917__$1[(2)]);
var statearr_72941_72974 = state_72917__$1;
(statearr_72941_72974[(5)] = ex72935);


var statearr_72942_72975 = state_72917__$1;
(statearr_72942_72975[(1)] = (4));

(statearr_72942_72975[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (14))){
var inst_72887 = (state_72917[(8)]);
var inst_72886 = (state_72917[(2)]);
var inst_72887__$1 = user;
var state_72917__$1 = (function (){var statearr_72943 = state_72917;
(statearr_72943[(10)] = inst_72886);

(statearr_72943[(8)] = inst_72887__$1);

return statearr_72943;
})();
if(cljs.core.truth_(inst_72887__$1)){
var statearr_72944_72976 = state_72917__$1;
(statearr_72944_72976[(1)] = (15));

} else {
var statearr_72945_72977 = state_72917__$1;
(statearr_72945_72977[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (16))){
var state_72917__$1 = state_72917;
var statearr_72946_72978 = state_72917__$1;
(statearr_72946_72978[(2)] = auth);

(statearr_72946_72978[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (10))){
var inst_72871 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72872 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72873 = cljs.core.PersistentHashMap.fromArrays(inst_72871,inst_72872);
var inst_72874 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_72873);
var inst_72875 = (function(){throw inst_72874})();
var state_72917__$1 = state_72917;
var statearr_72947_72979 = state_72917__$1;
(statearr_72947_72979[(2)] = inst_72875);

(statearr_72947_72979[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (18))){
var state_72917__$1 = state_72917;
var statearr_72948_72980 = state_72917__$1;
(statearr_72948_72980[(2)] = null);

(statearr_72948_72980[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72918 === (8))){
var inst_72868 = (state_72917[(2)]);
var state_72917__$1 = (function (){var statearr_72949 = state_72917;
(statearr_72949[(11)] = inst_72868);

return statearr_72949;
})();
if(cljs.core.truth_(ledger)){
var statearr_72950_72981 = state_72917__$1;
(statearr_72950_72981[(1)] = (9));

} else {
var statearr_72951_72982 = state_72917__$1;
(statearr_72951_72982[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_72952 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72952[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_72952[(1)] = (1));

return statearr_72952;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_72917){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_72917);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72953){var ex__2687__auto__ = e72953;
var statearr_72954_72983 = state_72917;
(statearr_72954_72983[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_72917[(4)]))){
var statearr_72955_72984 = state_72917;
(statearr_72955_72984[(1)] = cljs.core.first.call(null,(state_72917[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72985 = state_72917;
state_72917 = G__72985;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_72917){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_72917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72956 = f__2707__auto__.call(null);
(statearr_72956[(6)] = c__2706__auto__);

return statearr_72956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__72987 = arguments.length;
switch (G__72987) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73022){
var state_val_73023 = (state_73022[(1)]);
if((state_val_73023 === (1))){
var state_73022__$1 = state_73022;
var statearr_73024_73044 = state_73022__$1;
(statearr_73024_73044[(2)] = null);

(statearr_73024_73044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73023 === (2))){
var _ = (function (){var statearr_73025 = state_73022;
(statearr_73025[(4)] = cljs.core.cons.call(null,(5),(state_73022[(4)])));

return statearr_73025;
})();
var inst_72996 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_73022__$1 = state_73022;
if(cljs.core.truth_(inst_72996)){
var statearr_73026_73045 = state_73022__$1;
(statearr_73026_73045[(1)] = (6));

} else {
var statearr_73027_73046 = state_73022__$1;
(statearr_73027_73046[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73023 === (3))){
var inst_73020 = (state_73022[(2)]);
var state_73022__$1 = state_73022;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73022__$1,inst_73020);
} else {
if((state_val_73023 === (4))){
var inst_72988 = (state_73022[(2)]);
var inst_72989 = cljs.core.clj__GT_js.call(null,inst_72988);
var inst_72990 = reject.call(null,inst_72989);
var state_73022__$1 = state_73022;
var statearr_73029_73047 = state_73022__$1;
(statearr_73029_73047[(2)] = inst_72990);

(statearr_73029_73047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73023 === (5))){
var _ = (function (){var statearr_73030 = state_73022;
(statearr_73030[(4)] = cljs.core.rest.call(null,(state_73022[(4)])));

return statearr_73030;
})();
var state_73022__$1 = state_73022;
var ex73028 = (state_73022__$1[(2)]);
var statearr_73031_73048 = state_73022__$1;
(statearr_73031_73048[(5)] = ex73028);


var statearr_73032_73049 = state_73022__$1;
(statearr_73032_73049[(1)] = (4));

(statearr_73032_73049[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73023 === (6))){
var state_73022__$1 = state_73022;
var statearr_73033_73050 = state_73022__$1;
(statearr_73033_73050[(2)] = null);

(statearr_73033_73050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73023 === (7))){
var inst_72999 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73000 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73001 = cljs.core.PersistentHashMap.fromArrays(inst_72999,inst_73000);
var inst_73002 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_73001);
var inst_73003 = (function(){throw inst_73002})();
var state_73022__$1 = state_73022;
var statearr_73034_73051 = state_73022__$1;
(statearr_73034_73051[(2)] = inst_73003);

(statearr_73034_73051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73023 === (8))){
var inst_73005 = (state_73022[(2)]);
var inst_73006 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_73007 = [jwt,expire];
var inst_73008 = cljs.core.PersistentHashMap.fromArrays(inst_73006,inst_73007);
var inst_73009 = fluree.db.util.core.without_nils.call(null,inst_73008);
var inst_73010 = cljs.core.async.promise_chan.call(null);
var inst_73011 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73013 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_73009,inst_73010,null];
var inst_73014 = (new cljs.core.PersistentVector(null,4,(5),inst_73012,inst_73013,null));
var inst_73015 = cljs.core.async.put_BANG_.call(null,inst_73011,inst_73014);
var inst_73016 = (function (){var _ = inst_73005;
var data = inst_73009;
var pc = inst_73010;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_73017 = cljs.core.async.take_BANG_.call(null,inst_73010,inst_73016);
var _ = (function (){var statearr_73035 = state_73022;
(statearr_73035[(4)] = cljs.core.rest.call(null,(state_73022[(4)])));

return statearr_73035;
})();
var state_73022__$1 = (function (){var statearr_73036 = state_73022;
(statearr_73036[(7)] = inst_73015);

return statearr_73036;
})();
var statearr_73037_73052 = state_73022__$1;
(statearr_73037_73052[(2)] = inst_73017);

(statearr_73037_73052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_73038 = [null,null,null,null,null,null,null,null];
(statearr_73038[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_73038[(1)] = (1));

return statearr_73038;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_73022){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_73022);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73039){var ex__2687__auto__ = e73039;
var statearr_73040_73053 = state_73022;
(statearr_73040_73053[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_73022[(4)]))){
var statearr_73041_73054 = state_73022;
(statearr_73041_73054[(1)] = cljs.core.first.call(null,(state_73022[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73055 = state_73022;
state_73022 = G__73055;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_73022){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_73022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73042 = f__2707__auto__.call(null);
(statearr_73042[(6)] = c__2706__auto__);

return statearr_73042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

