// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__69168 = arguments.length;
switch (G__69168) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2706__auto___69316 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69255){
var state_val_69256 = (state_69255[(1)]);
if((state_val_69256 === (7))){
var inst_69186 = (state_69255[(7)]);
var inst_69189 = cljs.core.not_EQ_.call(null,(0),inst_69186);
var state_69255__$1 = state_69255;
var statearr_69257_69317 = state_69255__$1;
(statearr_69257_69317[(2)] = inst_69189);

(statearr_69257_69317[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (20))){
var inst_69210 = (state_69255[(8)]);
var inst_69181 = (state_69255[(9)]);
var inst_69214 = fluree.db.auth.roles.call(null,inst_69181,inst_69210);
var state_69255__$1 = state_69255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69255__$1,(23),inst_69214);
} else {
if((state_val_69256 === (27))){
var inst_69181 = (state_69255[(9)]);
var inst_69229 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69230 = fluree.db.time_travel.as_of_block.call(null,inst_69181,inst_69229);
var state_69255__$1 = state_69255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69255__$1,(30),inst_69230);
} else {
if((state_val_69256 === (1))){
var state_69255__$1 = state_69255;
var statearr_69258_69318 = state_69255__$1;
(statearr_69258_69318[(2)] = null);

(statearr_69258_69318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (24))){
var inst_69222 = (state_69255[(10)]);
var inst_69181 = (state_69255[(9)]);
var inst_69224 = fluree.db.permissions.permission_map.call(null,inst_69181,inst_69222,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_69255__$1 = state_69255;
var statearr_69259_69319 = state_69255__$1;
(statearr_69259_69319[(2)] = inst_69224);

(statearr_69259_69319[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (4))){
var inst_69169 = (state_69255[(2)]);
var inst_69170 = cljs.core.async.put_BANG_.call(null,pc,inst_69169);
var inst_69171 = cljs.core.async.close_BANG_.call(null,pc);
var state_69255__$1 = (function (){var statearr_69260 = state_69255;
(statearr_69260[(11)] = inst_69170);

return statearr_69260;
})();
var statearr_69261_69320 = state_69255__$1;
(statearr_69261_69320[(2)] = inst_69171);

(statearr_69261_69320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (15))){
var inst_69186 = (state_69255[(7)]);
var inst_69200 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69186)," unknown."].join('');
var inst_69201 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69202 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_69203 = cljs.core.PersistentHashMap.fromArrays(inst_69201,inst_69202);
var inst_69204 = cljs.core.ex_info.call(null,inst_69200,inst_69203);
var inst_69205 = (function(){throw inst_69204})();
var state_69255__$1 = state_69255;
var statearr_69262_69321 = state_69255__$1;
(statearr_69262_69321[(2)] = inst_69205);

(statearr_69262_69321[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (21))){
var state_69255__$1 = state_69255;
var statearr_69263_69322 = state_69255__$1;
(statearr_69263_69322[(2)] = null);

(statearr_69263_69322[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (31))){
var inst_69186 = (state_69255[(7)]);
var inst_69236 = (state_69255[(12)]);
var inst_69238 = cljs.core.assoc.call(null,inst_69236,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_69186);
var state_69255__$1 = state_69255;
var statearr_69264_69323 = state_69255__$1;
(statearr_69264_69323[(2)] = inst_69238);

(statearr_69264_69323[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (32))){
var inst_69236 = (state_69255[(12)]);
var state_69255__$1 = state_69255;
var statearr_69265_69324 = state_69255__$1;
(statearr_69265_69324[(2)] = inst_69236);

(statearr_69265_69324[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (33))){
var inst_69222 = (state_69255[(10)]);
var inst_69241 = (state_69255[(2)]);
var state_69255__$1 = (function (){var statearr_69266 = state_69255;
(statearr_69266[(13)] = inst_69241);

return statearr_69266;
})();
if(cljs.core.truth_(inst_69222)){
var statearr_69267_69325 = state_69255__$1;
(statearr_69267_69325[(1)] = (34));

} else {
var statearr_69268_69326 = state_69255__$1;
(statearr_69268_69326[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (13))){
var inst_69197 = (state_69255[(14)]);
var inst_69196 = (state_69255[(2)]);
var inst_69197__$1 = fluree.db.util.async.throw_err.call(null,inst_69196);
var state_69255__$1 = (function (){var statearr_69269 = state_69255;
(statearr_69269[(14)] = inst_69197__$1);

return statearr_69269;
})();
if(cljs.core.truth_(inst_69197__$1)){
var statearr_69270_69327 = state_69255__$1;
(statearr_69270_69327[(1)] = (14));

} else {
var statearr_69271_69328 = state_69255__$1;
(statearr_69271_69328[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (22))){
var inst_69220 = (state_69255[(2)]);
var state_69255__$1 = state_69255;
var statearr_69272_69329 = state_69255__$1;
(statearr_69272_69329[(2)] = inst_69220);

(statearr_69272_69329[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (36))){
var inst_69249 = (state_69255[(2)]);
var inst_69250 = cljs.core.async.put_BANG_.call(null,pc,inst_69249);
var _ = (function (){var statearr_69273 = state_69255;
(statearr_69273[(4)] = cljs.core.rest.call(null,(state_69255[(4)])));

return statearr_69273;
})();
var state_69255__$1 = state_69255;
var statearr_69274_69330 = state_69255__$1;
(statearr_69274_69330[(2)] = inst_69250);

(statearr_69274_69330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (29))){
var inst_69186 = (state_69255[(7)]);
var inst_69236 = (state_69255[(2)]);
var state_69255__$1 = (function (){var statearr_69275 = state_69255;
(statearr_69275[(12)] = inst_69236);

return statearr_69275;
})();
if(cljs.core.truth_(inst_69186)){
var statearr_69276_69331 = state_69255__$1;
(statearr_69276_69331[(1)] = (31));

} else {
var statearr_69277_69332 = state_69255__$1;
(statearr_69277_69332[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (6))){
var inst_69186 = (state_69255[(7)]);
var inst_69180 = (state_69255[(2)]);
var inst_69181 = fluree.db.util.async.throw_err.call(null,inst_69180);
var inst_69182 = opts;
var inst_69183 = cljs.core.__destructure_map.call(null,inst_69182);
var inst_69184 = cljs.core.get.call(null,inst_69183,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_69185 = cljs.core.get.call(null,inst_69183,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_69186__$1 = cljs.core.get.call(null,inst_69183,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69187 = cljs.core.get.call(null,inst_69183,new cljs.core.Keyword(null,"block","block",664686210));
var state_69255__$1 = (function (){var statearr_69278 = state_69255;
(statearr_69278[(15)] = inst_69187);

(statearr_69278[(7)] = inst_69186__$1);

(statearr_69278[(16)] = inst_69184);

(statearr_69278[(9)] = inst_69181);

(statearr_69278[(17)] = inst_69185);

return statearr_69278;
})();
if(cljs.core.truth_(inst_69186__$1)){
var statearr_69279_69333 = state_69255__$1;
(statearr_69279_69333[(1)] = (7));

} else {
var statearr_69280_69334 = state_69255__$1;
(statearr_69280_69334[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (28))){
var inst_69181 = (state_69255[(9)]);
var state_69255__$1 = state_69255;
var statearr_69281_69335 = state_69255__$1;
(statearr_69281_69335[(2)] = inst_69181);

(statearr_69281_69335[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (25))){
var state_69255__$1 = state_69255;
var statearr_69282_69336 = state_69255__$1;
(statearr_69282_69336[(2)] = null);

(statearr_69282_69336[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (34))){
var inst_69227 = (state_69255[(18)]);
var state_69255__$1 = state_69255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69255__$1,(37),inst_69227);
} else {
if((state_val_69256 === (17))){
var inst_69184 = (state_69255[(16)]);
var state_69255__$1 = state_69255;
var statearr_69283_69337 = state_69255__$1;
(statearr_69283_69337[(2)] = inst_69184);

(statearr_69283_69337[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (3))){
var inst_69253 = (state_69255[(2)]);
var state_69255__$1 = state_69255;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69255__$1,inst_69253);
} else {
if((state_val_69256 === (12))){
var inst_69184 = (state_69255[(16)]);
var inst_69210 = (state_69255[(2)]);
var state_69255__$1 = (function (){var statearr_69284 = state_69255;
(statearr_69284[(8)] = inst_69210);

return statearr_69284;
})();
if(cljs.core.truth_(inst_69184)){
var statearr_69285_69338 = state_69255__$1;
(statearr_69285_69338[(1)] = (17));

} else {
var statearr_69286_69339 = state_69255__$1;
(statearr_69286_69339[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (2))){
var _ = (function (){var statearr_69287 = state_69255;
(statearr_69287[(4)] = cljs.core.cons.call(null,(5),(state_69255[(4)])));

return statearr_69287;
})();
var inst_69178 = fluree.db.session.db.call(null,conn,ledger,null);
var state_69255__$1 = state_69255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69255__$1,(6),inst_69178);
} else {
if((state_val_69256 === (23))){
var inst_69216 = (state_69255[(2)]);
var inst_69217 = fluree.db.util.async.throw_err.call(null,inst_69216);
var state_69255__$1 = state_69255;
var statearr_69288_69340 = state_69255__$1;
(statearr_69288_69340[(2)] = inst_69217);

(statearr_69288_69340[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (35))){
var inst_69241 = (state_69255[(13)]);
var state_69255__$1 = state_69255;
var statearr_69289_69341 = state_69255__$1;
(statearr_69289_69341[(2)] = inst_69241);

(statearr_69289_69341[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (19))){
var inst_69222 = (state_69255[(10)]);
var inst_69222__$1 = (state_69255[(2)]);
var state_69255__$1 = (function (){var statearr_69290 = state_69255;
(statearr_69290[(10)] = inst_69222__$1);

return statearr_69290;
})();
if(cljs.core.truth_(inst_69222__$1)){
var statearr_69291_69342 = state_69255__$1;
(statearr_69291_69342[(1)] = (24));

} else {
var statearr_69292_69343 = state_69255__$1;
(statearr_69292_69343[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (11))){
var state_69255__$1 = state_69255;
var statearr_69294_69344 = state_69255__$1;
(statearr_69294_69344[(2)] = null);

(statearr_69294_69344[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (9))){
var inst_69192 = (state_69255[(2)]);
var state_69255__$1 = state_69255;
if(cljs.core.truth_(inst_69192)){
var statearr_69295_69345 = state_69255__$1;
(statearr_69295_69345[(1)] = (10));

} else {
var statearr_69296_69346 = state_69255__$1;
(statearr_69296_69346[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (5))){
var _ = (function (){var statearr_69297 = state_69255;
(statearr_69297[(4)] = cljs.core.rest.call(null,(state_69255[(4)])));

return statearr_69297;
})();
var state_69255__$1 = state_69255;
var ex69293 = (state_69255__$1[(2)]);
var statearr_69298_69347 = state_69255__$1;
(statearr_69298_69347[(5)] = ex69293);


var statearr_69299_69348 = state_69255__$1;
(statearr_69299_69348[(1)] = (4));

(statearr_69299_69348[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (14))){
var inst_69197 = (state_69255[(14)]);
var state_69255__$1 = state_69255;
var statearr_69300_69349 = state_69255__$1;
(statearr_69300_69349[(2)] = inst_69197);

(statearr_69300_69349[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (26))){
var inst_69187 = (state_69255[(15)]);
var inst_69227 = (state_69255[(2)]);
var state_69255__$1 = (function (){var statearr_69301 = state_69255;
(statearr_69301[(18)] = inst_69227);

return statearr_69301;
})();
if(cljs.core.truth_(inst_69187)){
var statearr_69302_69350 = state_69255__$1;
(statearr_69302_69350[(1)] = (27));

} else {
var statearr_69303_69351 = state_69255__$1;
(statearr_69303_69351[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (16))){
var inst_69207 = (state_69255[(2)]);
var state_69255__$1 = state_69255;
var statearr_69304_69352 = state_69255__$1;
(statearr_69304_69352[(2)] = inst_69207);

(statearr_69304_69352[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (30))){
var inst_69232 = (state_69255[(2)]);
var inst_69233 = fluree.db.util.async.throw_err.call(null,inst_69232);
var state_69255__$1 = state_69255;
var statearr_69305_69353 = state_69255__$1;
(statearr_69305_69353[(2)] = inst_69233);

(statearr_69305_69353[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (10))){
var inst_69186 = (state_69255[(7)]);
var inst_69181 = (state_69255[(9)]);
var inst_69194 = fluree.db.dbproto._subid.call(null,inst_69181,inst_69186);
var state_69255__$1 = state_69255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69255__$1,(13),inst_69194);
} else {
if((state_val_69256 === (18))){
var inst_69210 = (state_69255[(8)]);
var state_69255__$1 = state_69255;
if(cljs.core.truth_(inst_69210)){
var statearr_69306_69354 = state_69255__$1;
(statearr_69306_69354[(1)] = (20));

} else {
var statearr_69307_69355 = state_69255__$1;
(statearr_69307_69355[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (37))){
var inst_69241 = (state_69255[(13)]);
var inst_69244 = (state_69255[(2)]);
var inst_69245 = fluree.db.util.async.throw_err.call(null,inst_69244);
var inst_69246 = cljs.core.assoc.call(null,inst_69241,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_69245);
var state_69255__$1 = state_69255;
var statearr_69308_69356 = state_69255__$1;
(statearr_69308_69356[(2)] = inst_69246);

(statearr_69308_69356[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69256 === (8))){
var inst_69186 = (state_69255[(7)]);
var state_69255__$1 = state_69255;
var statearr_69309_69357 = state_69255__$1;
(statearr_69309_69357[(2)] = inst_69186);

(statearr_69309_69357[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2684__auto__ = null;
var fluree$db$api$query$state_machine__2684__auto____0 = (function (){
var statearr_69310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69310[(0)] = fluree$db$api$query$state_machine__2684__auto__);

(statearr_69310[(1)] = (1));

return statearr_69310;
});
var fluree$db$api$query$state_machine__2684__auto____1 = (function (state_69255){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_69255);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69311){var ex__2687__auto__ = e69311;
var statearr_69312_69358 = state_69255;
(statearr_69312_69358[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_69255[(4)]))){
var statearr_69313_69359 = state_69255;
(statearr_69313_69359[(1)] = cljs.core.first.call(null,(state_69255[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69360 = state_69255;
state_69255 = G__69360;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2684__auto__ = function(state_69255){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2684__auto____1.call(this,state_69255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2684__auto____0;
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2684__auto____1;
return fluree$db$api$query$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69314 = f__2707__auto__.call(null);
(statearr_69314[(6)] = c__2706__auto___69316);

return statearr_69314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69501){
var state_val_69502 = (state_69501[(1)]);
if((state_val_69502 === (7))){
var inst_69381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69382 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69383 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69384 = [inst_69382,inst_69383];
var inst_69385 = (new cljs.core.PersistentVector(null,2,(5),inst_69381,inst_69384,null));
var state_69501__$1 = state_69501;
var statearr_69503_69573 = state_69501__$1;
(statearr_69503_69573[(2)] = inst_69385);

(statearr_69503_69573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (20))){
var inst_69411 = (state_69501[(7)]);
var state_69501__$1 = state_69501;
var statearr_69504_69574 = state_69501__$1;
(statearr_69504_69574[(2)] = inst_69411);

(statearr_69504_69574[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (27))){
var state_69501__$1 = state_69501;
var statearr_69505_69575 = state_69501__$1;
(statearr_69505_69575[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (1))){
var state_69501__$1 = state_69501;
var statearr_69507_69576 = state_69501__$1;
(statearr_69507_69576[(2)] = null);

(statearr_69507_69576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (24))){
var inst_69410 = (state_69501[(8)]);
var state_69501__$1 = state_69501;
if(cljs.core.truth_(inst_69410)){
var statearr_69508_69577 = state_69501__$1;
(statearr_69508_69577[(1)] = (26));

} else {
var statearr_69509_69578 = state_69501__$1;
(statearr_69509_69578[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (39))){
var inst_69457 = (state_69501[(9)]);
var inst_69456 = (state_69501[(10)]);
var inst_69482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69483 = [inst_69456,inst_69457];
var inst_69484 = (new cljs.core.PersistentVector(null,2,(5),inst_69482,inst_69483,null));
var state_69501__$1 = state_69501;
var statearr_69510_69579 = state_69501__$1;
(statearr_69510_69579[(2)] = inst_69484);

(statearr_69510_69579[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (4))){
var inst_69361 = (state_69501[(2)]);
var state_69501__$1 = state_69501;
var statearr_69511_69580 = state_69501__$1;
(statearr_69511_69580[(2)] = inst_69361);

(statearr_69511_69580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (15))){
var inst_69390 = (state_69501[(11)]);
var inst_69395 = (state_69501[(12)]);
var inst_69404 = (state_69501[(2)]);
var inst_69405 = [inst_69395,inst_69404];
var inst_69406 = (new cljs.core.PersistentVector(null,2,(5),inst_69390,inst_69405,null));
var state_69501__$1 = state_69501;
var statearr_69512_69581 = state_69501__$1;
(statearr_69512_69581[(2)] = inst_69406);

(statearr_69512_69581[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (21))){
var inst_69410 = (state_69501[(8)]);
var state_69501__$1 = state_69501;
var statearr_69513_69582 = state_69501__$1;
(statearr_69513_69582[(2)] = inst_69410);

(statearr_69513_69582[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (31))){
var inst_69451 = (state_69501[(2)]);
var state_69501__$1 = state_69501;
var statearr_69514_69583 = state_69501__$1;
(statearr_69514_69583[(2)] = inst_69451);

(statearr_69514_69583[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (32))){
var inst_69457 = (state_69501[(9)]);
var inst_69460 = cljs.core.pos_int_QMARK_.call(null,inst_69457);
var state_69501__$1 = state_69501;
var statearr_69515_69584 = state_69501__$1;
(statearr_69515_69584[(2)] = inst_69460);

(statearr_69515_69584[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (40))){
var inst_69488 = (state_69501[(13)]);
var inst_69412 = (state_69501[(14)]);
var inst_69486 = (state_69501[(2)]);
var inst_69487 = cljs.core.nth.call(null,inst_69486,(0),null);
var inst_69488__$1 = cljs.core.nth.call(null,inst_69486,(1),null);
var inst_69489 = (inst_69488__$1 > inst_69412);
var state_69501__$1 = (function (){var statearr_69516 = state_69501;
(statearr_69516[(15)] = inst_69487);

(statearr_69516[(13)] = inst_69488__$1);

return statearr_69516;
})();
if(cljs.core.truth_(inst_69489)){
var statearr_69517_69585 = state_69501__$1;
(statearr_69517_69585[(1)] = (41));

} else {
var statearr_69518_69586 = state_69501__$1;
(statearr_69518_69586[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (33))){
var inst_69458 = (state_69501[(16)]);
var state_69501__$1 = state_69501;
var statearr_69519_69587 = state_69501__$1;
(statearr_69519_69587[(2)] = inst_69458);

(statearr_69519_69587[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (13))){
var inst_69396 = (state_69501[(17)]);
var inst_69398 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_69396);
var state_69501__$1 = state_69501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69501__$1,(16),inst_69398);
} else {
if((state_val_69502 === (22))){
var inst_69429 = (state_69501[(2)]);
var state_69501__$1 = state_69501;
if(cljs.core.truth_(inst_69429)){
var statearr_69520_69588 = state_69501__$1;
(statearr_69520_69588[(1)] = (23));

} else {
var statearr_69521_69589 = state_69501__$1;
(statearr_69521_69589[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (36))){
var state_69501__$1 = state_69501;
var statearr_69522_69590 = state_69501__$1;
(statearr_69522_69590[(2)] = null);

(statearr_69522_69590[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (41))){
var inst_69412 = (state_69501[(14)]);
var state_69501__$1 = state_69501;
var statearr_69523_69591 = state_69501__$1;
(statearr_69523_69591[(2)] = inst_69412);

(statearr_69523_69591[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (43))){
var inst_69487 = (state_69501[(15)]);
var inst_69493 = (state_69501[(2)]);
var inst_69494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69495 = [inst_69487,inst_69493];
var inst_69496 = (new cljs.core.PersistentVector(null,2,(5),inst_69494,inst_69495,null));
var _ = (function (){var statearr_69524 = state_69501;
(statearr_69524[(4)] = cljs.core.rest.call(null,(state_69501[(4)])));

return statearr_69524;
})();
var state_69501__$1 = state_69501;
var statearr_69525_69592 = state_69501__$1;
(statearr_69525_69592[(2)] = inst_69496);

(statearr_69525_69592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (29))){
var inst_69387 = (state_69501[(18)]);
var inst_69442 = cljs.core.pr_str.call(null,inst_69387);
var inst_69443 = ["Invalid block range provided: ",inst_69442].join('');
var inst_69444 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69445 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69446 = cljs.core.PersistentHashMap.fromArrays(inst_69444,inst_69445);
var inst_69447 = cljs.core.ex_info.call(null,inst_69443,inst_69446);
var inst_69448 = (function(){throw inst_69447})();
var state_69501__$1 = state_69501;
var statearr_69526_69593 = state_69501__$1;
(statearr_69526_69593[(2)] = inst_69448);

(statearr_69526_69593[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (6))){
var inst_69379 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_69501__$1 = state_69501;
var statearr_69527_69594 = state_69501__$1;
(statearr_69527_69594[(2)] = inst_69379);

(statearr_69527_69594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (28))){
var inst_69453 = (state_69501[(2)]);
var state_69501__$1 = state_69501;
var statearr_69528_69595 = state_69501__$1;
(statearr_69528_69595[(2)] = inst_69453);

(statearr_69528_69595[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (25))){
var inst_69458 = (state_69501[(16)]);
var inst_69456 = (state_69501[(10)]);
var inst_69455 = (state_69501[(2)]);
var inst_69456__$1 = cljs.core.nth.call(null,inst_69455,(0),null);
var inst_69457 = cljs.core.nth.call(null,inst_69455,(1),null);
var inst_69458__$1 = cljs.core.pos_int_QMARK_.call(null,inst_69456__$1);
var state_69501__$1 = (function (){var statearr_69529 = state_69501;
(statearr_69529[(9)] = inst_69457);

(statearr_69529[(16)] = inst_69458__$1);

(statearr_69529[(10)] = inst_69456__$1);

return statearr_69529;
})();
if(inst_69458__$1){
var statearr_69530_69596 = state_69501__$1;
(statearr_69530_69596[(1)] = (32));

} else {
var statearr_69531_69597 = state_69501__$1;
(statearr_69531_69597[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (34))){
var inst_69463 = (state_69501[(2)]);
var inst_69464 = cljs.core.not.call(null,inst_69463);
var state_69501__$1 = state_69501;
if(inst_69464){
var statearr_69532_69598 = state_69501__$1;
(statearr_69532_69598[(1)] = (35));

} else {
var statearr_69533_69599 = state_69501__$1;
(statearr_69533_69599[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (17))){
var inst_69410 = (state_69501[(8)]);
var inst_69412 = (state_69501[(14)]);
var inst_69415 = cljs.core.pr_str.call(null,inst_69410);
var inst_69416 = cljs.core.pr_str.call(null,inst_69412);
var inst_69417 = ["Start block is out of range for this ledger. Start block provided: ",inst_69415,". Database block: ",inst_69416].join('');
var inst_69418 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69419 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69420 = cljs.core.PersistentHashMap.fromArrays(inst_69418,inst_69419);
var inst_69421 = cljs.core.ex_info.call(null,inst_69417,inst_69420);
var inst_69422 = (function(){throw inst_69421})();
var state_69501__$1 = state_69501;
var statearr_69534_69600 = state_69501__$1;
(statearr_69534_69600[(2)] = inst_69422);

(statearr_69534_69600[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (3))){
var inst_69499 = (state_69501[(2)]);
var state_69501__$1 = state_69501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69501__$1,inst_69499);
} else {
if((state_val_69502 === (12))){
var inst_69396 = (state_69501[(17)]);
var inst_69387 = (state_69501[(18)]);
var inst_69394 = (state_69501[(2)]);
var inst_69395 = fluree.db.util.async.throw_err.call(null,inst_69394);
var inst_69396__$1 = cljs.core.second.call(null,inst_69387);
var state_69501__$1 = (function (){var statearr_69535 = state_69501;
(statearr_69535[(17)] = inst_69396__$1);

(statearr_69535[(12)] = inst_69395);

return statearr_69535;
})();
if(cljs.core.truth_(inst_69396__$1)){
var statearr_69536_69601 = state_69501__$1;
(statearr_69536_69601[(1)] = (13));

} else {
var statearr_69537_69602 = state_69501__$1;
(statearr_69537_69602[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (2))){
var _ = (function (){var statearr_69538 = state_69501;
(statearr_69538[(4)] = cljs.core.cons.call(null,(5),(state_69501[(4)])));

return statearr_69538;
})();
var inst_69376 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69377 = cljs.core.sequential_QMARK_.call(null,inst_69376);
var state_69501__$1 = state_69501;
if(inst_69377){
var statearr_69539_69603 = state_69501__$1;
(statearr_69539_69603[(1)] = (6));

} else {
var statearr_69540_69604 = state_69501__$1;
(statearr_69540_69604[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (23))){
var inst_69411 = (state_69501[(7)]);
var inst_69410 = (state_69501[(8)]);
var inst_69431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69432 = [inst_69410,inst_69411];
var inst_69433 = (new cljs.core.PersistentVector(null,2,(5),inst_69431,inst_69432,null));
var state_69501__$1 = state_69501;
var statearr_69541_69605 = state_69501__$1;
(statearr_69541_69605[(2)] = inst_69433);

(statearr_69541_69605[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (35))){
var inst_69387 = (state_69501[(18)]);
var inst_69466 = cljs.core.pr_str.call(null,inst_69387);
var inst_69467 = ["Invalid block range provided: ",inst_69466].join('');
var inst_69468 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69469 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69470 = cljs.core.PersistentHashMap.fromArrays(inst_69468,inst_69469);
var inst_69471 = cljs.core.ex_info.call(null,inst_69467,inst_69470);
var inst_69472 = (function(){throw inst_69471})();
var state_69501__$1 = state_69501;
var statearr_69542_69606 = state_69501__$1;
(statearr_69542_69606[(2)] = inst_69472);

(statearr_69542_69606[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (19))){
var inst_69410 = (state_69501[(8)]);
var inst_69425 = (state_69501[(2)]);
var state_69501__$1 = (function (){var statearr_69543 = state_69501;
(statearr_69543[(19)] = inst_69425);

return statearr_69543;
})();
if(cljs.core.truth_(inst_69410)){
var statearr_69544_69607 = state_69501__$1;
(statearr_69544_69607[(1)] = (20));

} else {
var statearr_69545_69608 = state_69501__$1;
(statearr_69545_69608[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (11))){
var inst_69410 = (state_69501[(8)]);
var inst_69412 = (state_69501[(14)]);
var inst_69409 = (state_69501[(2)]);
var inst_69410__$1 = cljs.core.nth.call(null,inst_69409,(0),null);
var inst_69411 = cljs.core.nth.call(null,inst_69409,(1),null);
var inst_69412__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69413 = (inst_69410__$1 > inst_69412__$1);
var state_69501__$1 = (function (){var statearr_69547 = state_69501;
(statearr_69547[(7)] = inst_69411);

(statearr_69547[(8)] = inst_69410__$1);

(statearr_69547[(14)] = inst_69412__$1);

return statearr_69547;
})();
if(cljs.core.truth_(inst_69413)){
var statearr_69548_69609 = state_69501__$1;
(statearr_69548_69609[(1)] = (17));

} else {
var statearr_69549_69610 = state_69501__$1;
(statearr_69549_69610[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (9))){
var inst_69387 = (state_69501[(18)]);
var inst_69390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69391 = cljs.core.first.call(null,inst_69387);
var inst_69392 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_69391);
var state_69501__$1 = (function (){var statearr_69550 = state_69501;
(statearr_69550[(11)] = inst_69390);

return statearr_69550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69501__$1,(12),inst_69392);
} else {
if((state_val_69502 === (5))){
var _ = (function (){var statearr_69551 = state_69501;
(statearr_69551[(4)] = cljs.core.rest.call(null,(state_69501[(4)])));

return statearr_69551;
})();
var state_69501__$1 = state_69501;
var ex69546 = (state_69501__$1[(2)]);
var statearr_69552_69611 = state_69501__$1;
(statearr_69552_69611[(5)] = ex69546);


if((ex69546 instanceof Error)){
var statearr_69553_69612 = state_69501__$1;
(statearr_69553_69612[(1)] = (4));

(statearr_69553_69612[(5)] = null);

} else {
throw ex69546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (14))){
var state_69501__$1 = state_69501;
var statearr_69554_69613 = state_69501__$1;
(statearr_69554_69613[(2)] = null);

(statearr_69554_69613[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (26))){
var inst_69410 = (state_69501[(8)]);
var inst_69436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69437 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69438 = [inst_69410,inst_69437];
var inst_69439 = (new cljs.core.PersistentVector(null,2,(5),inst_69436,inst_69438,null));
var state_69501__$1 = state_69501;
var statearr_69555_69614 = state_69501__$1;
(statearr_69555_69614[(2)] = inst_69439);

(statearr_69555_69614[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (16))){
var inst_69400 = (state_69501[(2)]);
var inst_69401 = fluree.db.util.async.throw_err.call(null,inst_69400);
var state_69501__$1 = state_69501;
var statearr_69556_69615 = state_69501__$1;
(statearr_69556_69615[(2)] = inst_69401);

(statearr_69556_69615[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (38))){
var inst_69457 = (state_69501[(9)]);
var inst_69456 = (state_69501[(10)]);
var inst_69478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69479 = [inst_69457,inst_69456];
var inst_69480 = (new cljs.core.PersistentVector(null,2,(5),inst_69478,inst_69479,null));
var state_69501__$1 = state_69501;
var statearr_69557_69616 = state_69501__$1;
(statearr_69557_69616[(2)] = inst_69480);

(statearr_69557_69616[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (30))){
var state_69501__$1 = state_69501;
var statearr_69558_69617 = state_69501__$1;
(statearr_69558_69617[(2)] = null);

(statearr_69558_69617[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (10))){
var inst_69387 = (state_69501[(18)]);
var state_69501__$1 = state_69501;
var statearr_69559_69618 = state_69501__$1;
(statearr_69559_69618[(2)] = inst_69387);

(statearr_69559_69618[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (18))){
var state_69501__$1 = state_69501;
var statearr_69560_69619 = state_69501__$1;
(statearr_69560_69619[(2)] = null);

(statearr_69560_69619[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (42))){
var inst_69488 = (state_69501[(13)]);
var state_69501__$1 = state_69501;
var statearr_69561_69620 = state_69501__$1;
(statearr_69561_69620[(2)] = inst_69488);

(statearr_69561_69620[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (37))){
var inst_69457 = (state_69501[(9)]);
var inst_69456 = (state_69501[(10)]);
var inst_69475 = (state_69501[(2)]);
var inst_69476 = (inst_69457 < inst_69456);
var state_69501__$1 = (function (){var statearr_69562 = state_69501;
(statearr_69562[(20)] = inst_69475);

return statearr_69562;
})();
if(cljs.core.truth_(inst_69476)){
var statearr_69563_69621 = state_69501__$1;
(statearr_69563_69621[(1)] = (38));

} else {
var statearr_69564_69622 = state_69501__$1;
(statearr_69564_69622[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69502 === (8))){
var inst_69387 = (state_69501[(18)]);
var inst_69387__$1 = (state_69501[(2)]);
var inst_69388 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_69387__$1);
var state_69501__$1 = (function (){var statearr_69565 = state_69501;
(statearr_69565[(18)] = inst_69387__$1);

return statearr_69565;
})();
if(cljs.core.truth_(inst_69388)){
var statearr_69566_69623 = state_69501__$1;
(statearr_69566_69623[(1)] = (9));

} else {
var statearr_69567_69624 = state_69501__$1;
(statearr_69567_69624[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_69568 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69568[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__);

(statearr_69568[(1)] = (1));

return statearr_69568;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_69501){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_69501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69569){var ex__2687__auto__ = e69569;
var statearr_69570_69625 = state_69501;
(statearr_69570_69625[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_69501[(4)]))){
var statearr_69571_69626 = state_69501;
(statearr_69571_69626[(1)] = cljs.core.first.call(null,(state_69501[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69627 = state_69501;
state_69501 = G__69627;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = function(state_69501){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_69501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69572 = f__2707__auto__.call(null);
(statearr_69572[(6)] = c__2706__auto__);

return statearr_69572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69779){
var state_val_69780 = (state_69779[(1)]);
if((state_val_69780 === (7))){
var inst_69689 = (state_69779[(2)]);
var inst_69690 = cljs.core.nth.call(null,inst_69689,(0),null);
var inst_69691 = cljs.core.nth.call(null,inst_69689,(1),null);
var inst_69699 = cljs.core.vals.call(null,inst_69691);
var inst_69700 = cljs.core.seq.call(null,inst_69699);
var inst_69701 = cljs.core.first.call(null,inst_69700);
var inst_69702 = cljs.core.next.call(null,inst_69700);
var inst_69703 = cljs.core.PersistentVector.EMPTY;
var inst_69704 = inst_69699;
var inst_69705 = inst_69703;
var state_69779__$1 = (function (){var statearr_69781 = state_69779;
(statearr_69781[(7)] = inst_69702);

(statearr_69781[(8)] = inst_69705);

(statearr_69781[(9)] = inst_69690);

(statearr_69781[(10)] = inst_69704);

(statearr_69781[(11)] = inst_69701);

return statearr_69781;
})();
var statearr_69782_69835 = state_69779__$1;
(statearr_69782_69835[(2)] = null);

(statearr_69782_69835[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (20))){
var inst_69711 = (state_69779[(12)]);
var inst_69716 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69717 = cljs.core.PersistentHashMap.EMPTY;
var inst_69718 = [true,inst_69717];
var inst_69719 = cljs.core.PersistentHashMap.fromArrays(inst_69716,inst_69718);
var inst_69720 = cljs.core.PersistentHashMap.EMPTY;
var inst_69721 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_69719,inst_69720,inst_69711);
var state_69779__$1 = state_69779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69779__$1,(22),inst_69721);
} else {
if((state_val_69780 === (27))){
var inst_69767 = (state_69779[(2)]);
var state_69779__$1 = state_69779;
var statearr_69783_69836 = state_69779__$1;
(statearr_69783_69836[(2)] = inst_69767);

(statearr_69783_69836[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (1))){
var state_69779__$1 = state_69779;
var statearr_69784_69837 = state_69779__$1;
(statearr_69784_69837[(2)] = null);

(statearr_69784_69837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (24))){
var inst_69730 = (state_69779[(13)]);
var inst_69769 = (state_69779[(2)]);
var inst_69770 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_69771 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69772 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69773 = [inst_69771,inst_69772,inst_69730,inst_69769];
var inst_69774 = cljs.core.PersistentHashMap.fromArrays(inst_69770,inst_69773);
var _ = (function (){var statearr_69786 = state_69779;
(statearr_69786[(4)] = cljs.core.rest.call(null,(state_69779[(4)])));

return statearr_69786;
})();
var state_69779__$1 = state_69779;
var statearr_69787_69838 = state_69779__$1;
(statearr_69787_69838[(2)] = inst_69774);

(statearr_69787_69838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (4))){
var inst_69630 = (state_69779[(2)]);
var state_69779__$1 = state_69779;
var statearr_69788_69839 = state_69779__$1;
(statearr_69788_69839[(2)] = inst_69630);

(statearr_69788_69839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (15))){
var inst_69670 = (state_69779[(14)]);
var inst_69675 = (state_69779[(15)]);
var inst_69661 = (state_69779[(16)]);
var inst_69648 = (state_69779[(17)]);
var inst_69653 = (state_69779[(18)]);
var inst_69660 = (state_69779[(19)]);
var inst_69646 = (state_69779[(20)]);
var inst_69652 = (state_69779[(21)]);
var inst_69649 = (state_69779[(22)]);
var inst_69668 = (state_69779[(23)]);
var inst_69654 = (state_69779[(24)]);
var inst_69681 = (function (){var seq__69644 = inst_69649;
var vec__69656 = inst_69652;
var subject = inst_69668;
var flake = inst_69660;
var first__69658 = inst_69660;
var r = inst_69661;
var asserted_subjects = inst_69653;
var vec__69643 = inst_69646;
var flake_SINGLEQUOTE_ = inst_69675;
var retracted_subjects = inst_69654;
var G__69642 = inst_69652;
var asserted_QMARK_ = inst_69670;
var seq__69657 = inst_69661;
var first__69645 = inst_69648;
return (function (p1__69629_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__69629_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69682 = cljs.core.update.call(null,inst_69654,inst_69668,inst_69681);
var tmp69785 = inst_69653;
var inst_69652__$1 = inst_69661;
var inst_69653__$1 = tmp69785;
var inst_69654__$1 = inst_69682;
var state_69779__$1 = (function (){var statearr_69789 = state_69779;
(statearr_69789[(18)] = inst_69653__$1);

(statearr_69789[(21)] = inst_69652__$1);

(statearr_69789[(24)] = inst_69654__$1);

return statearr_69789;
})();
var statearr_69790_69840 = state_69779__$1;
(statearr_69790_69840[(2)] = null);

(statearr_69790_69840[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (21))){
var inst_69728 = (state_69779[(2)]);
var state_69779__$1 = state_69779;
var statearr_69791_69841 = state_69779__$1;
(statearr_69791_69841[(2)] = inst_69728);

(statearr_69791_69841[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (13))){
var inst_69670 = (state_69779[(14)]);
var inst_69675 = (state_69779[(2)]);
var state_69779__$1 = (function (){var statearr_69792 = state_69779;
(statearr_69792[(15)] = inst_69675);

return statearr_69792;
})();
if(cljs.core.truth_(inst_69670)){
var statearr_69793_69842 = state_69779__$1;
(statearr_69793_69842[(1)] = (14));

} else {
var statearr_69794_69843 = state_69779__$1;
(statearr_69794_69843[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (22))){
var inst_69705 = (state_69779[(8)]);
var inst_69712 = (state_69779[(25)]);
var inst_69723 = (state_69779[(2)]);
var inst_69724 = fluree.db.util.async.throw_err.call(null,inst_69723);
var inst_69725 = cljs.core.conj.call(null,inst_69705,inst_69724);
var inst_69704 = inst_69712;
var inst_69705__$1 = inst_69725;
var state_69779__$1 = (function (){var statearr_69795 = state_69779;
(statearr_69795[(8)] = inst_69705__$1);

(statearr_69795[(10)] = inst_69704);

return statearr_69795;
})();
var statearr_69796_69844 = state_69779__$1;
(statearr_69796_69844[(2)] = null);

(statearr_69796_69844[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (6))){
var inst_69660 = (state_69779[(19)]);
var inst_69652 = (state_69779[(21)]);
var inst_69659 = cljs.core.seq.call(null,inst_69652);
var inst_69660__$1 = cljs.core.first.call(null,inst_69659);
var inst_69661 = cljs.core.next.call(null,inst_69659);
var inst_69662 = cljs.core.not.call(null,inst_69660__$1);
var state_69779__$1 = (function (){var statearr_69797 = state_69779;
(statearr_69797[(16)] = inst_69661);

(statearr_69797[(19)] = inst_69660__$1);

return statearr_69797;
})();
if(inst_69662){
var statearr_69798_69845 = state_69779__$1;
(statearr_69798_69845[(1)] = (8));

} else {
var statearr_69799_69846 = state_69779__$1;
(statearr_69799_69846[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (28))){
var inst_69744 = (state_69779[(26)]);
var inst_69751 = (state_69779[(27)]);
var inst_69762 = (state_69779[(2)]);
var inst_69763 = fluree.db.util.async.throw_err.call(null,inst_69762);
var inst_69764 = cljs.core.conj.call(null,inst_69744,inst_69763);
var inst_69743 = inst_69751;
var inst_69744__$1 = inst_69764;
var state_69779__$1 = (function (){var statearr_69800 = state_69779;
(statearr_69800[(26)] = inst_69744__$1);

(statearr_69800[(28)] = inst_69743);

return statearr_69800;
})();
var statearr_69801_69847 = state_69779__$1;
(statearr_69801_69847[(2)] = null);

(statearr_69801_69847[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (25))){
var inst_69744 = (state_69779[(26)]);
var state_69779__$1 = state_69779;
var statearr_69802_69848 = state_69779__$1;
(statearr_69802_69848[(2)] = inst_69744);

(statearr_69802_69848[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (17))){
var inst_69711 = (state_69779[(12)]);
var inst_69704 = (state_69779[(10)]);
var inst_69710 = cljs.core.seq.call(null,inst_69704);
var inst_69711__$1 = cljs.core.first.call(null,inst_69710);
var inst_69712 = cljs.core.next.call(null,inst_69710);
var inst_69713 = cljs.core.not.call(null,inst_69711__$1);
var state_69779__$1 = (function (){var statearr_69803 = state_69779;
(statearr_69803[(12)] = inst_69711__$1);

(statearr_69803[(25)] = inst_69712);

return statearr_69803;
})();
if(inst_69713){
var statearr_69804_69849 = state_69779__$1;
(statearr_69804_69849[(1)] = (19));

} else {
var statearr_69805_69850 = state_69779__$1;
(statearr_69805_69850[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (3))){
var inst_69777 = (state_69779[(2)]);
var state_69779__$1 = state_69779;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69779__$1,inst_69777);
} else {
if((state_val_69780 === (12))){
var inst_69660 = (state_69779[(19)]);
var inst_69673 = fluree.db.flake.flip_flake.call(null,inst_69660);
var state_69779__$1 = state_69779;
var statearr_69806_69851 = state_69779__$1;
(statearr_69806_69851[(2)] = inst_69673);

(statearr_69806_69851[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (2))){
var inst_69646 = (state_69779[(20)]);
var _ = (function (){var statearr_69807 = state_69779;
(statearr_69807[(4)] = cljs.core.cons.call(null,(5),(state_69779[(4)])));

return statearr_69807;
})();
var inst_69646__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69647 = cljs.core.seq.call(null,inst_69646__$1);
var inst_69648 = cljs.core.first.call(null,inst_69647);
var inst_69649 = cljs.core.next.call(null,inst_69647);
var inst_69650 = cljs.core.PersistentHashMap.EMPTY;
var inst_69651 = cljs.core.PersistentHashMap.EMPTY;
var inst_69652 = inst_69646__$1;
var inst_69653 = inst_69650;
var inst_69654 = inst_69651;
var state_69779__$1 = (function (){var statearr_69808 = state_69779;
(statearr_69808[(17)] = inst_69648);

(statearr_69808[(18)] = inst_69653);

(statearr_69808[(20)] = inst_69646__$1);

(statearr_69808[(21)] = inst_69652);

(statearr_69808[(22)] = inst_69649);

(statearr_69808[(24)] = inst_69654);

return statearr_69808;
})();
var statearr_69809_69852 = state_69779__$1;
(statearr_69809_69852[(2)] = null);

(statearr_69809_69852[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (23))){
var inst_69750 = (state_69779[(29)]);
var inst_69743 = (state_69779[(28)]);
var inst_69749 = cljs.core.seq.call(null,inst_69743);
var inst_69750__$1 = cljs.core.first.call(null,inst_69749);
var inst_69751 = cljs.core.next.call(null,inst_69749);
var inst_69752 = cljs.core.not.call(null,inst_69750__$1);
var state_69779__$1 = (function (){var statearr_69810 = state_69779;
(statearr_69810[(29)] = inst_69750__$1);

(statearr_69810[(27)] = inst_69751);

return statearr_69810;
})();
if(inst_69752){
var statearr_69811_69853 = state_69779__$1;
(statearr_69811_69853[(1)] = (25));

} else {
var statearr_69812_69854 = state_69779__$1;
(statearr_69812_69854[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (19))){
var inst_69705 = (state_69779[(8)]);
var state_69779__$1 = state_69779;
var statearr_69813_69855 = state_69779__$1;
(statearr_69813_69855[(2)] = inst_69705);

(statearr_69813_69855[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (11))){
var inst_69660 = (state_69779[(19)]);
var state_69779__$1 = state_69779;
var statearr_69815_69856 = state_69779__$1;
(statearr_69815_69856[(2)] = inst_69660);

(statearr_69815_69856[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (9))){
var inst_69670 = (state_69779[(14)]);
var inst_69660 = (state_69779[(19)]);
var inst_69668 = fluree.db.flake.s.call(null,inst_69660);
var inst_69669 = fluree.db.flake.op.call(null,inst_69660);
var inst_69670__$1 = inst_69669 === true;
var state_69779__$1 = (function (){var statearr_69817 = state_69779;
(statearr_69817[(14)] = inst_69670__$1);

(statearr_69817[(23)] = inst_69668);

return statearr_69817;
})();
if(cljs.core.truth_(inst_69670__$1)){
var statearr_69818_69857 = state_69779__$1;
(statearr_69818_69857[(1)] = (11));

} else {
var statearr_69819_69858 = state_69779__$1;
(statearr_69819_69858[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (5))){
var _ = (function (){var statearr_69820 = state_69779;
(statearr_69820[(4)] = cljs.core.rest.call(null,(state_69779[(4)])));

return statearr_69820;
})();
var state_69779__$1 = state_69779;
var ex69814 = (state_69779__$1[(2)]);
var statearr_69821_69859 = state_69779__$1;
(statearr_69821_69859[(5)] = ex69814);


if((ex69814 instanceof Error)){
var statearr_69822_69860 = state_69779__$1;
(statearr_69822_69860[(1)] = (4));

(statearr_69822_69860[(5)] = null);

} else {
throw ex69814;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (14))){
var inst_69670 = (state_69779[(14)]);
var inst_69675 = (state_69779[(15)]);
var inst_69661 = (state_69779[(16)]);
var inst_69648 = (state_69779[(17)]);
var inst_69653 = (state_69779[(18)]);
var inst_69660 = (state_69779[(19)]);
var inst_69646 = (state_69779[(20)]);
var inst_69652 = (state_69779[(21)]);
var inst_69649 = (state_69779[(22)]);
var inst_69668 = (state_69779[(23)]);
var inst_69654 = (state_69779[(24)]);
var inst_69677 = (function (){var seq__69644 = inst_69649;
var vec__69656 = inst_69652;
var subject = inst_69668;
var flake = inst_69660;
var first__69658 = inst_69660;
var r = inst_69661;
var asserted_subjects = inst_69653;
var vec__69643 = inst_69646;
var flake_SINGLEQUOTE_ = inst_69675;
var retracted_subjects = inst_69654;
var G__69642 = inst_69652;
var asserted_QMARK_ = inst_69670;
var seq__69657 = inst_69661;
var first__69645 = inst_69648;
return (function (p1__69628_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__69628_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69678 = cljs.core.update.call(null,inst_69653,inst_69668,inst_69677);
var tmp69816 = inst_69654;
var inst_69652__$1 = inst_69661;
var inst_69653__$1 = inst_69678;
var inst_69654__$1 = tmp69816;
var state_69779__$1 = (function (){var statearr_69823 = state_69779;
(statearr_69823[(18)] = inst_69653__$1);

(statearr_69823[(21)] = inst_69652__$1);

(statearr_69823[(24)] = inst_69654__$1);

return statearr_69823;
})();
var statearr_69824_69861 = state_69779__$1;
(statearr_69824_69861[(2)] = null);

(statearr_69824_69861[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (26))){
var inst_69750 = (state_69779[(29)]);
var inst_69755 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69756 = cljs.core.PersistentHashMap.EMPTY;
var inst_69757 = [true,inst_69756];
var inst_69758 = cljs.core.PersistentHashMap.fromArrays(inst_69755,inst_69757);
var inst_69759 = cljs.core.PersistentHashMap.EMPTY;
var inst_69760 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_69758,inst_69759,inst_69750);
var state_69779__$1 = state_69779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69779__$1,(28),inst_69760);
} else {
if((state_val_69780 === (16))){
var inst_69685 = (state_69779[(2)]);
var state_69779__$1 = state_69779;
var statearr_69825_69862 = state_69779__$1;
(statearr_69825_69862[(2)] = inst_69685);

(statearr_69825_69862[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (10))){
var inst_69687 = (state_69779[(2)]);
var state_69779__$1 = state_69779;
var statearr_69826_69863 = state_69779__$1;
(statearr_69826_69863[(2)] = inst_69687);

(statearr_69826_69863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (18))){
var inst_69690 = (state_69779[(9)]);
var inst_69730 = (state_69779[(2)]);
var inst_69738 = cljs.core.vals.call(null,inst_69690);
var inst_69739 = cljs.core.seq.call(null,inst_69738);
var inst_69740 = cljs.core.first.call(null,inst_69739);
var inst_69741 = cljs.core.next.call(null,inst_69739);
var inst_69742 = cljs.core.PersistentVector.EMPTY;
var inst_69743 = inst_69738;
var inst_69744 = inst_69742;
var state_69779__$1 = (function (){var statearr_69827 = state_69779;
(statearr_69827[(30)] = inst_69740);

(statearr_69827[(31)] = inst_69741);

(statearr_69827[(26)] = inst_69744);

(statearr_69827[(28)] = inst_69743);

(statearr_69827[(13)] = inst_69730);

return statearr_69827;
})();
var statearr_69828_69864 = state_69779__$1;
(statearr_69828_69864[(2)] = null);

(statearr_69828_69864[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69780 === (8))){
var inst_69653 = (state_69779[(18)]);
var inst_69654 = (state_69779[(24)]);
var inst_69664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69665 = [inst_69653,inst_69654];
var inst_69666 = (new cljs.core.PersistentVector(null,2,(5),inst_69664,inst_69665,null));
var state_69779__$1 = state_69779;
var statearr_69829_69865 = state_69779__$1;
(statearr_69829_69865[(2)] = inst_69666);

(statearr_69829_69865[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_69830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69830[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_69830[(1)] = (1));

return statearr_69830;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_69779){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_69779);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69831){var ex__2687__auto__ = e69831;
var statearr_69832_69866 = state_69779;
(statearr_69832_69866[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_69779[(4)]))){
var statearr_69833_69867 = state_69779;
(statearr_69833_69867[(1)] = cljs.core.first.call(null,(state_69779[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69868 = state_69779;
state_69779 = G__69868;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_69779){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_69779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69834 = f__2707__auto__.call(null);
(statearr_69834[(6)] = c__2706__auto__);

return statearr_69834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69900){
var state_val_69901 = (state_69900[(1)]);
if((state_val_69901 === (1))){
var inst_69869 = cljs.core.volatile_BANG_.call(null,(0));
var inst_69870 = cljs.core.PersistentHashMap.EMPTY;
var inst_69871 = cljs.core.volatile_BANG_.call(null,inst_69870);
var inst_69872 = cljs.core.first.call(null,resp);
var inst_69873 = cljs.core.rest.call(null,resp);
var inst_69874 = cljs.core.PersistentVector.EMPTY;
var inst_69875 = inst_69869;
var inst_69876 = inst_69871;
var inst_69877 = inst_69872;
var inst_69878 = inst_69873;
var inst_69879 = inst_69874;
var state_69900__$1 = (function (){var statearr_69902 = state_69900;
(statearr_69902[(7)] = inst_69875);

(statearr_69902[(8)] = inst_69879);

(statearr_69902[(9)] = inst_69877);

(statearr_69902[(10)] = inst_69876);

(statearr_69902[(11)] = inst_69878);

return statearr_69902;
})();
var statearr_69903_69918 = state_69900__$1;
(statearr_69903_69918[(2)] = null);

(statearr_69903_69918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69901 === (2))){
var inst_69875 = (state_69900[(7)]);
var inst_69877 = (state_69900[(9)]);
var inst_69876 = (state_69900[(10)]);
var inst_69881 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_69877,inst_69876,inst_69875);
var state_69900__$1 = state_69900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69900__$1,(4),inst_69881);
} else {
if((state_val_69901 === (3))){
var inst_69898 = (state_69900[(2)]);
var state_69900__$1 = state_69900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69900__$1,inst_69898);
} else {
if((state_val_69901 === (4))){
var inst_69879 = (state_69900[(8)]);
var inst_69878 = (state_69900[(11)]);
var inst_69883 = (state_69900[(2)]);
var inst_69884 = fluree.db.util.async.throw_err.call(null,inst_69883);
var inst_69885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69886 = [inst_69884];
var inst_69887 = (new cljs.core.PersistentVector(null,1,(5),inst_69885,inst_69886,null));
var inst_69888 = cljs.core.concat.call(null,inst_69879,inst_69887);
var inst_69889 = cljs.core.first.call(null,inst_69878);
var state_69900__$1 = (function (){var statearr_69906 = state_69900;
(statearr_69906[(12)] = inst_69888);

return statearr_69906;
})();
if(cljs.core.truth_(inst_69889)){
var statearr_69907_69919 = state_69900__$1;
(statearr_69907_69919[(1)] = (5));

} else {
var statearr_69908_69920 = state_69900__$1;
(statearr_69908_69920[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69901 === (5))){
var inst_69875 = (state_69900[(7)]);
var inst_69888 = (state_69900[(12)]);
var inst_69876 = (state_69900[(10)]);
var inst_69878 = (state_69900[(11)]);
var inst_69891 = cljs.core.first.call(null,inst_69878);
var inst_69892 = cljs.core.rest.call(null,inst_69878);
var tmp69904 = inst_69875;
var tmp69905 = inst_69876;
var inst_69875__$1 = tmp69904;
var inst_69876__$1 = tmp69905;
var inst_69877 = inst_69891;
var inst_69878__$1 = inst_69892;
var inst_69879 = inst_69888;
var state_69900__$1 = (function (){var statearr_69909 = state_69900;
(statearr_69909[(7)] = inst_69875__$1);

(statearr_69909[(8)] = inst_69879);

(statearr_69909[(9)] = inst_69877);

(statearr_69909[(10)] = inst_69876__$1);

(statearr_69909[(11)] = inst_69878__$1);

return statearr_69909;
})();
var statearr_69910_69921 = state_69900__$1;
(statearr_69910_69921[(2)] = null);

(statearr_69910_69921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69901 === (6))){
var inst_69888 = (state_69900[(12)]);
var state_69900__$1 = state_69900;
var statearr_69911_69922 = state_69900__$1;
(statearr_69911_69922[(2)] = inst_69888);

(statearr_69911_69922[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69901 === (7))){
var inst_69896 = (state_69900[(2)]);
var state_69900__$1 = state_69900;
var statearr_69912_69923 = state_69900__$1;
(statearr_69912_69923[(2)] = inst_69896);

(statearr_69912_69923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_69913 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69913[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__);

(statearr_69913[(1)] = (1));

return statearr_69913;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1 = (function (state_69900){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_69900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69914){var ex__2687__auto__ = e69914;
var statearr_69915_69924 = state_69900;
(statearr_69915_69924[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_69900[(4)]))){
var statearr_69916_69925 = state_69900;
(statearr_69916_69925[(1)] = cljs.core.first.call(null,(state_69900[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69926 = state_69900;
state_69900 = G__69926;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = function(state_69900){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1.call(this,state_69900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69917 = f__2707__auto__.call(null);
(statearr_69917[(6)] = c__2706__auto__);

return statearr_69917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__69928 = arguments.length;
switch (G__69928) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__69930){
var map__69931 = p__69930;
var map__69931__$1 = cljs.core.__destructure_map.call(null,map__69931);
var query = map__69931__$1;
var opts = cljs.core.get.call(null,map__69931__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70016){
var state_val_70017 = (state_70016[(1)]);
if((state_val_70017 === (7))){
var inst_69942 = (state_70016[(7)]);
var inst_69946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69947 = ["_auth/id",inst_69942];
var inst_69948 = (new cljs.core.PersistentVector(null,2,(5),inst_69946,inst_69947,null));
var state_70016__$1 = state_70016;
var statearr_70018_70062 = state_70016__$1;
(statearr_70018_70062[(2)] = inst_69948);

(statearr_70018_70062[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (20))){
var inst_69996 = (state_70016[(2)]);
var inst_69997 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_70016__$1 = (function (){var statearr_70019 = state_70016;
(statearr_70019[(8)] = inst_69996);

return statearr_70019;
})();
if(cljs.core.truth_(inst_69997)){
var statearr_70020_70063 = state_70016__$1;
(statearr_70020_70063[(1)] = (22));

} else {
var statearr_70021_70064 = state_70016__$1;
(statearr_70021_70064[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (27))){
var inst_69999 = (state_70016[(9)]);
var inst_69943 = (state_70016[(10)]);
var inst_70005 = (state_70016[(2)]);
var inst_70006 = fluree.db.util.core.response_time_formatted.call(null,inst_69943);
var inst_70007 = [(200),inst_70005,(100),inst_70006];
var inst_70008 = cljs.core.PersistentHashMap.fromArrays(inst_69999,inst_70007);
var state_70016__$1 = state_70016;
var statearr_70022_70065 = state_70016__$1;
(statearr_70022_70065[(2)] = inst_70008);

(statearr_70022_70065[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (1))){
var state_70016__$1 = state_70016;
var statearr_70023_70066 = state_70016__$1;
(statearr_70023_70066[(2)] = null);

(statearr_70023_70066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (24))){
var inst_70011 = (state_70016[(2)]);
var _ = (function (){var statearr_70024 = state_70016;
(statearr_70024[(4)] = cljs.core.rest.call(null,(state_70016[(4)])));

return statearr_70024;
})();
var state_70016__$1 = state_70016;
var statearr_70025_70067 = state_70016__$1;
(statearr_70025_70067[(2)] = inst_70011);

(statearr_70025_70067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (4))){
var inst_69932 = (state_70016[(2)]);
var state_70016__$1 = state_70016;
var statearr_70026_70068 = state_70016__$1;
(statearr_70026_70068[(2)] = inst_69932);

(statearr_70026_70068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (15))){
var inst_69983 = (state_70016[(11)]);
var state_70016__$1 = state_70016;
var statearr_70027_70069 = state_70016__$1;
(statearr_70027_70069[(2)] = inst_69983);

(statearr_70027_70069[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (21))){
var inst_69992 = (state_70016[(2)]);
var inst_69993 = fluree.db.util.async.throw_err.call(null,inst_69992);
var state_70016__$1 = state_70016;
var statearr_70028_70070 = state_70016__$1;
(statearr_70028_70070[(2)] = inst_69993);

(statearr_70028_70070[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (13))){
var inst_69941 = (state_70016[(12)]);
var inst_69983 = (state_70016[(11)]);
var inst_69982 = (state_70016[(2)]);
var inst_69983__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_69941);
var state_70016__$1 = (function (){var statearr_70029 = state_70016;
(statearr_70029[(11)] = inst_69983__$1);

(statearr_70029[(13)] = inst_69982);

return statearr_70029;
})();
if(cljs.core.truth_(inst_69983__$1)){
var statearr_70030_70071 = state_70016__$1;
(statearr_70030_70071[(1)] = (15));

} else {
var statearr_70031_70072 = state_70016__$1;
(statearr_70031_70072[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (22))){
var inst_69996 = (state_70016[(8)]);
var inst_69999 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70000 = cljs.core.sequential_QMARK_.call(null,inst_69996);
var state_70016__$1 = (function (){var statearr_70032 = state_70016;
(statearr_70032[(9)] = inst_69999);

return statearr_70032;
})();
if(inst_70000){
var statearr_70033_70073 = state_70016__$1;
(statearr_70033_70073[(1)] = (25));

} else {
var statearr_70034_70074 = state_70016__$1;
(statearr_70034_70074[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (6))){
var inst_69957 = (state_70016[(14)]);
var inst_69941 = (state_70016[(12)]);
var inst_69956 = (state_70016[(2)]);
var inst_69957__$1 = fluree.db.util.async.throw_err.call(null,inst_69956);
var inst_69958 = fluree.db.api.query.resolve_block_range.call(null,inst_69957__$1,inst_69941);
var state_70016__$1 = (function (){var statearr_70035 = state_70016;
(statearr_70035[(14)] = inst_69957__$1);

return statearr_70035;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70016__$1,(10),inst_69958);
} else {
if((state_val_70017 === (25))){
var inst_69996 = (state_70016[(8)]);
var inst_70002 = cljs.core.doall.call(null,inst_69996);
var state_70016__$1 = state_70016;
var statearr_70036_70075 = state_70016__$1;
(statearr_70036_70075[(2)] = inst_70002);

(statearr_70036_70075[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (17))){
var inst_69988 = (state_70016[(2)]);
var state_70016__$1 = state_70016;
if(cljs.core.truth_(inst_69988)){
var statearr_70037_70076 = state_70016__$1;
(statearr_70037_70076[(1)] = (18));

} else {
var statearr_70038_70077 = state_70016__$1;
(statearr_70038_70077[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (3))){
var inst_70014 = (state_70016[(2)]);
var state_70016__$1 = state_70016;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70016__$1,inst_70014);
} else {
if((state_val_70017 === (12))){
var inst_69941 = (state_70016[(12)]);
var inst_69974 = cljs.core.pr_str.call(null,inst_69941);
var inst_69975 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_69974].join('');
var inst_69976 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69977 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69978 = cljs.core.PersistentHashMap.fromArrays(inst_69976,inst_69977);
var inst_69979 = cljs.core.ex_info.call(null,inst_69975,inst_69978);
var inst_69980 = (function(){throw inst_69979})();
var state_70016__$1 = state_70016;
var statearr_70039_70078 = state_70016__$1;
(statearr_70039_70078[(2)] = inst_69980);

(statearr_70039_70078[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (2))){
var inst_69942 = (state_70016[(7)]);
var _ = (function (){var statearr_70040 = state_70016;
(statearr_70040[(4)] = cljs.core.cons.call(null,(5),(state_70016[(4)])));

return statearr_70040;
})();
var inst_69941 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_69942__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69943 = fluree.db.util.core.current_time_millis.call(null);
var inst_69944 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_70016__$1 = (function (){var statearr_70041 = state_70016;
(statearr_70041[(12)] = inst_69941);

(statearr_70041[(10)] = inst_69943);

(statearr_70041[(7)] = inst_69942__$1);

(statearr_70041[(15)] = inst_69944);

return statearr_70041;
})();
if(cljs.core.truth_(inst_69942__$1)){
var statearr_70042_70079 = state_70016__$1;
(statearr_70042_70079[(1)] = (7));

} else {
var statearr_70043_70080 = state_70016__$1;
(statearr_70043_70080[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (23))){
var inst_69996 = (state_70016[(8)]);
var state_70016__$1 = state_70016;
var statearr_70044_70081 = state_70016__$1;
(statearr_70044_70081[(2)] = inst_69996);

(statearr_70044_70081[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (19))){
var inst_69982 = (state_70016[(13)]);
var state_70016__$1 = state_70016;
var statearr_70045_70082 = state_70016__$1;
(statearr_70045_70082[(2)] = inst_69982);

(statearr_70045_70082[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (11))){
var inst_69963 = (state_70016[(16)]);
var inst_69957 = (state_70016[(14)]);
var inst_69962 = (state_70016[(17)]);
var inst_69969 = fluree.db.api.query.block_range.call(null,inst_69957,inst_69962,inst_69963,opts);
var state_70016__$1 = state_70016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70016__$1,(14),inst_69969);
} else {
if((state_val_70017 === (9))){
var inst_69944 = (state_70016[(15)]);
var inst_69951 = (state_70016[(2)]);
var inst_69952 = [inst_69951];
var inst_69953 = cljs.core.PersistentHashMap.fromArrays(inst_69944,inst_69952);
var inst_69954 = fluree.db.api.query.db.call(null,conn,ledger,inst_69953);
var state_70016__$1 = state_70016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70016__$1,(6),inst_69954);
} else {
if((state_val_70017 === (5))){
var _ = (function (){var statearr_70047 = state_70016;
(statearr_70047[(4)] = cljs.core.rest.call(null,(state_70016[(4)])));

return statearr_70047;
})();
var state_70016__$1 = state_70016;
var ex70046 = (state_70016__$1[(2)]);
var statearr_70048_70083 = state_70016__$1;
(statearr_70048_70083[(5)] = ex70046);


if((ex70046 instanceof Error)){
var statearr_70049_70084 = state_70016__$1;
(statearr_70049_70084[(1)] = (4));

(statearr_70049_70084[(5)] = null);

} else {
throw ex70046;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (14))){
var inst_69971 = (state_70016[(2)]);
var inst_69972 = fluree.db.util.async.throw_err.call(null,inst_69971);
var state_70016__$1 = state_70016;
var statearr_70050_70085 = state_70016__$1;
(statearr_70050_70085[(2)] = inst_69972);

(statearr_70050_70085[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (26))){
var inst_69996 = (state_70016[(8)]);
var state_70016__$1 = state_70016;
var statearr_70051_70086 = state_70016__$1;
(statearr_70051_70086[(2)] = inst_69996);

(statearr_70051_70086[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (16))){
var inst_69941 = (state_70016[(12)]);
var inst_69986 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_69941);
var state_70016__$1 = state_70016;
var statearr_70052_70087 = state_70016__$1;
(statearr_70052_70087[(2)] = inst_69986);

(statearr_70052_70087[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (10))){
var inst_69941 = (state_70016[(12)]);
var inst_69960 = (state_70016[(2)]);
var inst_69961 = fluree.db.util.async.throw_err.call(null,inst_69960);
var inst_69962 = cljs.core.nth.call(null,inst_69961,(0),null);
var inst_69963 = cljs.core.nth.call(null,inst_69961,(1),null);
var inst_69964 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_69965 = cljs.core.dissoc.call(null,inst_69941,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_69966 = cljs.core.keys.call(null,inst_69965);
var inst_69967 = cljs.core._EQ_.call(null,inst_69964,inst_69966);
var state_70016__$1 = (function (){var statearr_70053 = state_70016;
(statearr_70053[(16)] = inst_69963);

(statearr_70053[(17)] = inst_69962);

return statearr_70053;
})();
if(inst_69967){
var statearr_70054_70088 = state_70016__$1;
(statearr_70054_70088[(1)] = (11));

} else {
var statearr_70055_70089 = state_70016__$1;
(statearr_70055_70089[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70017 === (18))){
var inst_69957 = (state_70016[(14)]);
var inst_69982 = (state_70016[(13)]);
var inst_69990 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_69957,inst_69982);
var state_70016__$1 = state_70016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70016__$1,(21),inst_69990);
} else {
if((state_val_70017 === (8))){
var state_70016__$1 = state_70016;
var statearr_70056_70090 = state_70016__$1;
(statearr_70056_70090[(2)] = null);

(statearr_70056_70090[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_70057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70057[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2684__auto__);

(statearr_70057[(1)] = (1));

return statearr_70057;
});
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1 = (function (state_70016){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_70016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70058){var ex__2687__auto__ = e70058;
var statearr_70059_70091 = state_70016;
(statearr_70059_70091[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_70016[(4)]))){
var statearr_70060_70092 = state_70016;
(statearr_70060_70092[(1)] = cljs.core.first.call(null,(state_70016[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70093 = state_70016;
state_70016 = G__70093;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = function(state_70016){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1.call(this,state_70016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70061 = f__2707__auto__.call(null);
(statearr_70061[(6)] = c__2706__auto__);

return statearr_70061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__70094 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__70094,(0),null);
var p = cljs.core.nth.call(null,vec__70094,(1),null);
var o = cljs.core.nth.call(null,vec__70094,(2),null);
var t = cljs.core.nth.call(null,vec__70094,(3),null);
var vec__70097 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__70097,(0),null);
var idx = cljs.core.nth.call(null,vec__70097,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__70100 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t.call(null,flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__70100,(0),null);
var id = cljs.core.nth.call(null,vec__70100,(1),null);
var or__5045__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70104 = arguments.length;
var i__5770__auto___70105 = (0);
while(true){
if((i__5770__auto___70105 < len__5769__auto___70104)){
args__5775__auto__.push((arguments[i__5770__auto___70105]));

var G__70106 = (i__5770__auto___70105 + (1));
i__5770__auto___70105 = G__70106;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq70103){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq70103));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70302){
var state_val_70303 = (state_70302[(1)]);
if((state_val_70303 === (7))){
var inst_70222 = (state_70302[(7)]);
var inst_70229 = (state_70302[(8)]);
var inst_70228 = cljs.core.seq.call(null,inst_70222);
var inst_70229__$1 = cljs.core.first.call(null,inst_70228);
var inst_70230 = cljs.core.next.call(null,inst_70228);
var state_70302__$1 = (function (){var statearr_70304 = state_70302;
(statearr_70304[(9)] = inst_70230);

(statearr_70304[(8)] = inst_70229__$1);

return statearr_70304;
})();
if(cljs.core.truth_(inst_70229__$1)){
var statearr_70305_70405 = state_70302__$1;
(statearr_70305_70405[(1)] = (9));

} else {
var statearr_70306_70406 = state_70302__$1;
(statearr_70306_70406[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (20))){
var inst_70292 = (state_70302[(2)]);
var state_70302__$1 = state_70302;
var statearr_70307_70407 = state_70302__$1;
(statearr_70307_70407[(2)] = inst_70292);

(statearr_70307_70407[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (27))){
var inst_70268 = (state_70302[(10)]);
var inst_70247 = (state_70302[(11)]);
var inst_70250 = (state_70302[(12)]);
var inst_70270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70271 = [inst_70250,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_70272 = (new cljs.core.PersistentVector(null,2,(5),inst_70270,inst_70271,null));
var inst_70273 = cljs.core.update_in.call(null,inst_70268,inst_70272,fluree.db.api.query.min_safe,inst_70247);
var state_70302__$1 = state_70302;
var statearr_70308_70408 = state_70302__$1;
(statearr_70308_70408[(2)] = inst_70273);

(statearr_70308_70408[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (1))){
var state_70302__$1 = state_70302;
var statearr_70309_70409 = state_70302__$1;
(statearr_70309_70409[(2)] = null);

(statearr_70309_70409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (24))){
var inst_70229 = (state_70302[(8)]);
var inst_70260 = (state_70302[(13)]);
var inst_70250 = (state_70302[(12)]);
var inst_70262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70263 = [inst_70250,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_70264 = (new cljs.core.PersistentVector(null,2,(5),inst_70262,inst_70263,null));
var inst_70265 = cljs.core.update_in.call(null,inst_70260,inst_70264,cljs.core.conj,inst_70229);
var state_70302__$1 = state_70302;
var statearr_70311_70410 = state_70302__$1;
(statearr_70311_70410[(2)] = inst_70265);

(statearr_70311_70410[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (4))){
var inst_70108 = (state_70302[(2)]);
var state_70302__$1 = state_70302;
var statearr_70312_70411 = state_70302__$1;
(statearr_70312_70411[(2)] = inst_70108);

(statearr_70312_70411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (15))){
var inst_70230 = (state_70302[(9)]);
var inst_70223 = (state_70302[(14)]);
var tmp70310 = inst_70223;
var inst_70222 = inst_70230;
var inst_70223__$1 = tmp70310;
var state_70302__$1 = (function (){var statearr_70313 = state_70302;
(statearr_70313[(7)] = inst_70222);

(statearr_70313[(14)] = inst_70223__$1);

return statearr_70313;
})();
var statearr_70314_70412 = state_70302__$1;
(statearr_70314_70412[(2)] = null);

(statearr_70314_70412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (21))){
var inst_70223 = (state_70302[(14)]);
var inst_70250 = (state_70302[(12)]);
var inst_70254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70255 = [inst_70250,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70256 = (new cljs.core.PersistentVector(null,2,(5),inst_70254,inst_70255,null));
var inst_70257 = cljs.core.assoc_in.call(null,inst_70223,inst_70256,inst_70250);
var state_70302__$1 = state_70302;
var statearr_70315_70413 = state_70302__$1;
(statearr_70315_70413[(2)] = inst_70257);

(statearr_70315_70413[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (31))){
var inst_70276 = (state_70302[(15)]);
var state_70302__$1 = state_70302;
var statearr_70316_70414 = state_70302__$1;
(statearr_70316_70414[(2)] = inst_70276);

(statearr_70316_70414[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (32))){
var inst_70230 = (state_70302[(9)]);
var inst_70284 = (state_70302[(2)]);
var inst_70222 = inst_70230;
var inst_70223 = inst_70284;
var state_70302__$1 = (function (){var statearr_70317 = state_70302;
(statearr_70317[(7)] = inst_70222);

(statearr_70317[(14)] = inst_70223);

return statearr_70317;
})();
var statearr_70318_70415 = state_70302__$1;
(statearr_70318_70415[(2)] = null);

(statearr_70318_70415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (33))){
var inst_70223 = (state_70302[(14)]);
var state_70302__$1 = state_70302;
var statearr_70319_70416 = state_70302__$1;
(statearr_70319_70416[(2)] = inst_70223);

(statearr_70319_70416[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (13))){
var inst_70232 = (state_70302[(16)]);
var state_70302__$1 = state_70302;
var statearr_70320_70417 = state_70302__$1;
(statearr_70320_70417[(2)] = inst_70232);

(statearr_70320_70417[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (22))){
var inst_70223 = (state_70302[(14)]);
var state_70302__$1 = state_70302;
var statearr_70321_70418 = state_70302__$1;
(statearr_70321_70418[(2)] = inst_70223);

(statearr_70321_70418[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (29))){
var inst_70276 = (state_70302[(2)]);
var state_70302__$1 = (function (){var statearr_70322 = state_70302;
(statearr_70322[(15)] = inst_70276);

return statearr_70322;
})();
if(cljs.core.truth_(show_auth)){
var statearr_70323_70419 = state_70302__$1;
(statearr_70323_70419[(1)] = (30));

} else {
var statearr_70324_70420 = state_70302__$1;
(statearr_70324_70420[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (6))){
var inst_70208 = (state_70302[(2)]);
var inst_70209 = fluree.db.util.async.throw_err.call(null,inst_70208);
var inst_70217 = resp;
var inst_70218 = cljs.core.seq.call(null,inst_70217);
var inst_70219 = cljs.core.first.call(null,inst_70218);
var inst_70220 = cljs.core.next.call(null,inst_70218);
var inst_70221 = cljs.core.PersistentHashMap.EMPTY;
var inst_70222 = inst_70217;
var inst_70223 = inst_70221;
var state_70302__$1 = (function (){var statearr_70325 = state_70302;
(statearr_70325[(17)] = inst_70219);

(statearr_70325[(18)] = inst_70220);

(statearr_70325[(19)] = inst_70209);

(statearr_70325[(7)] = inst_70222);

(statearr_70325[(14)] = inst_70223);

return statearr_70325;
})();
var statearr_70326_70421 = state_70302__$1;
(statearr_70326_70421[(2)] = null);

(statearr_70326_70421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (28))){
var inst_70268 = (state_70302[(10)]);
var state_70302__$1 = state_70302;
var statearr_70327_70422 = state_70302__$1;
(statearr_70327_70422[(2)] = inst_70268);

(statearr_70327_70422[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (25))){
var inst_70260 = (state_70302[(13)]);
var state_70302__$1 = state_70302;
var statearr_70328_70423 = state_70302__$1;
(statearr_70328_70423[(2)] = inst_70260);

(statearr_70328_70423[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (34))){
var state_70302__$1 = state_70302;
var statearr_70329_70424 = state_70302__$1;
(statearr_70329_70424[(2)] = null);

(statearr_70329_70424[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (17))){
var inst_70294 = (state_70302[(2)]);
var state_70302__$1 = state_70302;
var statearr_70330_70425 = state_70302__$1;
(statearr_70330_70425[(2)] = inst_70294);

(statearr_70330_70425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (3))){
var inst_70300 = (state_70302[(2)]);
var state_70302__$1 = state_70302;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70302__$1,inst_70300);
} else {
if((state_val_70303 === (12))){
var inst_70209 = (state_70302[(19)]);
var inst_70229 = (state_70302[(8)]);
var inst_70234 = fluree.db.api.query.auth_match.call(null,auth,inst_70209,inst_70229);
var inst_70235 = cljs.core.not.call(null,inst_70234);
var state_70302__$1 = state_70302;
var statearr_70331_70426 = state_70302__$1;
(statearr_70331_70426[(2)] = inst_70235);

(statearr_70331_70426[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (2))){
var _ = (function (){var statearr_70332 = state_70302;
(statearr_70332[(4)] = cljs.core.cons.call(null,(5),(state_70302[(4)])));

return statearr_70332;
})();
var inst_70114 = (function (){return (function (p1__70107_SHARP_){
return fluree.db.flake.t.call(null,p1__70107_SHARP_);
});
})();
var inst_70115 = cljs.core.map.call(null,inst_70114,resp);
var inst_70116 = cljs.core.set.call(null,inst_70115);
var inst_70204 = cljs.core.async.chan.call(null,(1));
var inst_70205 = (function (){var ts = inst_70116;
var c__2706__auto____$1 = inst_70204;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70202){
var state_val_70203 = (state_70202[(1)]);
if((state_val_70203 === (7))){
var inst_70148 = (state_70202[(7)]);
var inst_70136 = (state_70202[(8)]);
var inst_70130 = (state_70202[(9)]);
var inst_70142 = (state_70202[(10)]);
var inst_70141 = (state_70202[(2)]);
var inst_70142__$1 = fluree.db.util.async.throw_err.call(null,inst_70141);
var inst_70144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70145 = [inst_70136,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70146 = (new cljs.core.PersistentVector(null,2,(5),inst_70144,inst_70145,null));
var inst_70147 = cljs.core.assoc_in.call(null,inst_70130,inst_70146,inst_70142__$1);
var inst_70148__$1 = auth;
var state_70202__$1 = (function (){var statearr_70333 = state_70202;
(statearr_70333[(7)] = inst_70148__$1);

(statearr_70333[(11)] = inst_70147);

(statearr_70333[(10)] = inst_70142__$1);

return statearr_70333;
})();
if(cljs.core.truth_(inst_70148__$1)){
var statearr_70334_70427 = state_70202__$1;
(statearr_70334_70427[(1)] = (8));

} else {
var statearr_70335_70428 = state_70202__$1;
(statearr_70335_70428[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (1))){
var inst_70124 = (state_70202[(12)]);
var inst_70124__$1 = ts;
var inst_70125 = cljs.core.seq.call(null,inst_70124__$1);
var inst_70126 = cljs.core.first.call(null,inst_70125);
var inst_70127 = cljs.core.next.call(null,inst_70125);
var inst_70128 = cljs.core.PersistentHashMap.EMPTY;
var inst_70129 = inst_70124__$1;
var inst_70130 = inst_70128;
var state_70202__$1 = (function (){var statearr_70336 = state_70202;
(statearr_70336[(13)] = inst_70126);

(statearr_70336[(14)] = inst_70127);

(statearr_70336[(9)] = inst_70130);

(statearr_70336[(12)] = inst_70124__$1);

(statearr_70336[(15)] = inst_70129);

return statearr_70336;
})();
var statearr_70337_70429 = state_70202__$1;
(statearr_70337_70429[(2)] = null);

(statearr_70337_70429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (4))){
var inst_70136 = (state_70202[(8)]);
var inst_70139 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_70136);
var state_70202__$1 = state_70202;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70202__$1,(7),inst_70139);
} else {
if((state_val_70203 === (13))){
var inst_70137 = (state_70202[(16)]);
var inst_70194 = (state_70202[(2)]);
var inst_70129 = inst_70137;
var inst_70130 = inst_70194;
var state_70202__$1 = (function (){var statearr_70338 = state_70202;
(statearr_70338[(9)] = inst_70130);

(statearr_70338[(15)] = inst_70129);

return statearr_70338;
})();
var statearr_70339_70430 = state_70202__$1;
(statearr_70339_70430[(2)] = null);

(statearr_70339_70430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (6))){
var inst_70198 = (state_70202[(2)]);
var state_70202__$1 = state_70202;
var statearr_70340_70431 = state_70202__$1;
(statearr_70340_70431[(2)] = inst_70198);

(statearr_70340_70431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (3))){
var inst_70200 = (state_70202[(2)]);
var state_70202__$1 = state_70202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70202__$1,inst_70200);
} else {
if((state_val_70203 === (12))){
var inst_70147 = (state_70202[(11)]);
var state_70202__$1 = state_70202;
var statearr_70341_70432 = state_70202__$1;
(statearr_70341_70432[(2)] = inst_70147);

(statearr_70341_70432[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (2))){
var inst_70136 = (state_70202[(8)]);
var inst_70129 = (state_70202[(15)]);
var inst_70135 = cljs.core.seq.call(null,inst_70129);
var inst_70136__$1 = cljs.core.first.call(null,inst_70135);
var inst_70137 = cljs.core.next.call(null,inst_70135);
var state_70202__$1 = (function (){var statearr_70342 = state_70202;
(statearr_70342[(8)] = inst_70136__$1);

(statearr_70342[(16)] = inst_70137);

return statearr_70342;
})();
if(cljs.core.truth_(inst_70136__$1)){
var statearr_70343_70433 = state_70202__$1;
(statearr_70343_70433[(1)] = (4));

} else {
var statearr_70344_70434 = state_70202__$1;
(statearr_70344_70434[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (11))){
var inst_70126 = (state_70202[(13)]);
var inst_70136 = (state_70202[(8)]);
var inst_70127 = (state_70202[(14)]);
var inst_70130 = (state_70202[(9)]);
var inst_70124 = (state_70202[(12)]);
var inst_70129 = (state_70202[(15)]);
var inst_70137 = (state_70202[(16)]);
var inst_70147 = (state_70202[(11)]);
var inst_70142 = (state_70202[(10)]);
var inst_70154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70155 = [inst_70136,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70156 = (new cljs.core.PersistentVector(null,2,(5),inst_70154,inst_70155,null));
var inst_70169 = cljs.core.async.chan.call(null,(1));
var inst_70170 = (function (){var t = inst_70136;
var seq__70133 = inst_70137;
var first__70134 = inst_70136;
var seq__70122 = inst_70127;
var block = inst_70142;
var r = inst_70137;
var G__70120 = inst_70129;
var acc = inst_70130;
var first__70123 = inst_70126;
var vec__70121 = inst_70124;
var c__2706__auto____$2 = inst_70169;
var vec__70132 = inst_70129;
var G__70143 = inst_70147;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70167){
var state_val_70168 = (state_70167[(1)]);
if((state_val_70168 === (1))){
var state_70167__$1 = state_70167;
var statearr_70345_70435 = state_70167__$1;
(statearr_70345_70435[(2)] = null);

(statearr_70345_70435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (2))){
var ___$1 = (function (){var statearr_70346 = state_70167;
(statearr_70346[(4)] = cljs.core.cons.call(null,(5),(state_70167[(4)])));

return statearr_70346;
})();
var ___$2 = (function (){var statearr_70347 = state_70167;
(statearr_70347[(4)] = cljs.core.rest.call(null,(state_70167[(4)])));

return statearr_70347;
})();
var state_70167__$1 = state_70167;
var statearr_70348_70436 = state_70167__$1;
(statearr_70348_70436[(2)] = db);

(statearr_70348_70436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (3))){
var inst_70165 = (state_70167[(2)]);
var state_70167__$1 = state_70167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70167__$1,inst_70165);
} else {
if((state_val_70168 === (4))){
var inst_70157 = (state_70167[(2)]);
var state_70167__$1 = state_70167;
var statearr_70350_70437 = state_70167__$1;
(statearr_70350_70437[(2)] = inst_70157);

(statearr_70350_70437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (5))){
var ___$1 = (function (){var statearr_70351 = state_70167;
(statearr_70351[(4)] = cljs.core.rest.call(null,(state_70167[(4)])));

return statearr_70351;
})();
var state_70167__$1 = state_70167;
var ex70349 = (state_70167__$1[(2)]);
var statearr_70352_70438 = state_70167__$1;
(statearr_70352_70438[(5)] = ex70349);


if((ex70349 instanceof Error)){
var statearr_70353_70439 = state_70167__$1;
(statearr_70353_70439[(1)] = (4));

(statearr_70353_70439[(5)] = null);

} else {
throw ex70349;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_70354 = [null,null,null,null,null,null,null];
(statearr_70354[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_70354[(1)] = (1));

return statearr_70354;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_70167){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_70167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70355){var ex__2687__auto__ = e70355;
var statearr_70356_70440 = state_70167;
(statearr_70356_70440[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_70167[(4)]))){
var statearr_70357_70441 = state_70167;
(statearr_70357_70441[(1)] = cljs.core.first.call(null,(state_70167[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70442 = state_70167;
state_70167 = G__70442;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_70167){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_70167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70358 = f__2707__auto__.call(null);
(statearr_70358[(6)] = c__2706__auto____$2);

return statearr_70358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
});
})();
var inst_70171 = cljs.core.async.impl.dispatch.run.call(null,inst_70170);
var inst_70172 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_70173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70174 = ["?auth","?id"];
var inst_70175 = (new cljs.core.PersistentVector(null,2,(5),inst_70173,inst_70174,null));
var inst_70176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70178 = [inst_70136,"_tx/auth","?auth"];
var inst_70179 = (new cljs.core.PersistentVector(null,3,(5),inst_70177,inst_70178,null));
var inst_70180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70181 = ["?auth","_auth/id","?id"];
var inst_70182 = (new cljs.core.PersistentVector(null,3,(5),inst_70180,inst_70181,null));
var inst_70183 = [inst_70179,inst_70182];
var inst_70184 = (new cljs.core.PersistentVector(null,2,(5),inst_70176,inst_70183,null));
var inst_70185 = [inst_70175,inst_70184];
var inst_70186 = cljs.core.PersistentHashMap.fromArrays(inst_70172,inst_70185);
var inst_70187 = fluree.db.api.query.query_async.call(null,inst_70169,inst_70186);
var state_70202__$1 = (function (){var statearr_70359 = state_70202;
(statearr_70359[(17)] = inst_70171);

(statearr_70359[(18)] = inst_70156);

return statearr_70359;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70202__$1,(14),inst_70187);
} else {
if((state_val_70203 === (9))){
var state_70202__$1 = state_70202;
var statearr_70360_70443 = state_70202__$1;
(statearr_70360_70443[(2)] = show_auth);

(statearr_70360_70443[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (5))){
var inst_70130 = (state_70202[(9)]);
var state_70202__$1 = state_70202;
var statearr_70361_70444 = state_70202__$1;
(statearr_70361_70444[(2)] = inst_70130);

(statearr_70361_70444[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (14))){
var inst_70156 = (state_70202[(18)]);
var inst_70147 = (state_70202[(11)]);
var inst_70189 = (state_70202[(2)]);
var inst_70190 = fluree.db.util.async.throw_err.call(null,inst_70189);
var inst_70191 = cljs.core.assoc_in.call(null,inst_70147,inst_70156,inst_70190);
var state_70202__$1 = state_70202;
var statearr_70362_70445 = state_70202__$1;
(statearr_70362_70445[(2)] = inst_70191);

(statearr_70362_70445[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (10))){
var inst_70152 = (state_70202[(2)]);
var state_70202__$1 = state_70202;
if(cljs.core.truth_(inst_70152)){
var statearr_70363_70446 = state_70202__$1;
(statearr_70363_70446[(1)] = (11));

} else {
var statearr_70364_70447 = state_70202__$1;
(statearr_70364_70447[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70203 === (8))){
var inst_70148 = (state_70202[(7)]);
var state_70202__$1 = state_70202;
var statearr_70365_70448 = state_70202__$1;
(statearr_70365_70448[(2)] = inst_70148);

(statearr_70365_70448[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_70366 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70366[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_70366[(1)] = (1));

return statearr_70366;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_70202){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_70202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70367){var ex__2687__auto__ = e70367;
var statearr_70368_70449 = state_70202;
(statearr_70368_70449[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_70202[(4)]))){
var statearr_70369_70450 = state_70202;
(statearr_70369_70450[(1)] = cljs.core.first.call(null,(state_70202[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70451 = state_70202;
state_70202 = G__70451;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_70202){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_70202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70370 = f__2707__auto__.call(null);
(statearr_70370[(6)] = c__2706__auto____$1);

return statearr_70370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
});
})();
var inst_70206 = cljs.core.async.impl.dispatch.run.call(null,inst_70205);
var state_70302__$1 = (function (){var statearr_70371 = state_70302;
(statearr_70371[(20)] = inst_70206);

return statearr_70371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70302__$1,(6),inst_70204);
} else {
if((state_val_70303 === (23))){
var inst_70260 = (state_70302[(2)]);
var state_70302__$1 = (function (){var statearr_70372 = state_70302;
(statearr_70372[(13)] = inst_70260);

return statearr_70372;
})();
var statearr_70373_70452 = state_70302__$1;
(statearr_70373_70452[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (35))){
var inst_70290 = (state_70302[(2)]);
var state_70302__$1 = state_70302;
var statearr_70375_70453 = state_70302__$1;
(statearr_70375_70453[(2)] = inst_70290);

(statearr_70375_70453[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (19))){
var state_70302__$1 = state_70302;
var statearr_70376_70454 = state_70302__$1;
(statearr_70376_70454[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (11))){
var inst_70241 = (state_70302[(2)]);
var state_70302__$1 = state_70302;
if(cljs.core.truth_(inst_70241)){
var statearr_70379_70455 = state_70302__$1;
(statearr_70379_70455[(1)] = (15));

} else {
var statearr_70380_70456 = state_70302__$1;
(statearr_70380_70456[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (9))){
var inst_70232 = (state_70302[(16)]);
var inst_70232__$1 = auth;
var state_70302__$1 = (function (){var statearr_70381 = state_70302;
(statearr_70381[(16)] = inst_70232__$1);

return statearr_70381;
})();
if(cljs.core.truth_(inst_70232__$1)){
var statearr_70382_70457 = state_70302__$1;
(statearr_70382_70457[(1)] = (12));

} else {
var statearr_70383_70458 = state_70302__$1;
(statearr_70383_70458[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (5))){
var _ = (function (){var statearr_70384 = state_70302;
(statearr_70384[(4)] = cljs.core.rest.call(null,(state_70302[(4)])));

return statearr_70384;
})();
var state_70302__$1 = state_70302;
var ex70378 = (state_70302__$1[(2)]);
var statearr_70385_70459 = state_70302__$1;
(statearr_70385_70459[(5)] = ex70378);


if((ex70378 instanceof Error)){
var statearr_70386_70460 = state_70302__$1;
(statearr_70386_70460[(1)] = (4));

(statearr_70386_70460[(5)] = null);

} else {
throw ex70378;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (14))){
var inst_70238 = (state_70302[(2)]);
var state_70302__$1 = state_70302;
var statearr_70387_70461 = state_70302__$1;
(statearr_70387_70461[(2)] = inst_70238);

(statearr_70387_70461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (26))){
var inst_70268 = (state_70302[(2)]);
var state_70302__$1 = (function (){var statearr_70388 = state_70302;
(statearr_70388[(10)] = inst_70268);

return statearr_70388;
})();
var statearr_70389_70462 = state_70302__$1;
(statearr_70389_70462[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (16))){
var inst_70229 = (state_70302[(8)]);
var state_70302__$1 = state_70302;
if(cljs.core.truth_(inst_70229)){
var statearr_70391_70463 = state_70302__$1;
(statearr_70391_70463[(1)] = (18));

} else {
var statearr_70392_70464 = state_70302__$1;
(statearr_70392_70464[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (30))){
var inst_70251 = (state_70302[(21)]);
var inst_70276 = (state_70302[(15)]);
var inst_70250 = (state_70302[(12)]);
var inst_70278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70279 = [inst_70250,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70280 = (new cljs.core.PersistentVector(null,2,(5),inst_70278,inst_70279,null));
var inst_70281 = cljs.core.assoc_in.call(null,inst_70276,inst_70280,inst_70251);
var state_70302__$1 = state_70302;
var statearr_70393_70465 = state_70302__$1;
(statearr_70393_70465[(2)] = inst_70281);

(statearr_70393_70465[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (10))){
var inst_70229 = (state_70302[(8)]);
var state_70302__$1 = state_70302;
var statearr_70394_70466 = state_70302__$1;
(statearr_70394_70466[(2)] = inst_70229);

(statearr_70394_70466[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (18))){
var inst_70209 = (state_70302[(19)]);
var inst_70247 = (state_70302[(11)]);
var inst_70229 = (state_70302[(8)]);
var inst_70247__$1 = fluree.db.flake.t.call(null,inst_70229);
var inst_70248 = cljs.core.get.call(null,inst_70209,inst_70247__$1);
var inst_70249 = cljs.core.__destructure_map.call(null,inst_70248);
var inst_70250 = cljs.core.get.call(null,inst_70249,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70251 = cljs.core.get.call(null,inst_70249,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_70302__$1 = (function (){var statearr_70395 = state_70302;
(statearr_70395[(21)] = inst_70251);

(statearr_70395[(11)] = inst_70247__$1);

(statearr_70395[(12)] = inst_70250);

return statearr_70395;
})();
var statearr_70396_70467 = state_70302__$1;
(statearr_70396_70467[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70303 === (8))){
var inst_70296 = (state_70302[(2)]);
var inst_70297 = cljs.core.vals.call(null,inst_70296);
var _ = (function (){var statearr_70398 = state_70302;
(statearr_70398[(4)] = cljs.core.rest.call(null,(state_70302[(4)])));

return statearr_70398;
})();
var state_70302__$1 = state_70302;
var statearr_70399_70468 = state_70302__$1;
(statearr_70399_70468[(2)] = inst_70297);

(statearr_70399_70468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_70400 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70400[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_70400[(1)] = (1));

return statearr_70400;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_70302){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_70302);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70401){var ex__2687__auto__ = e70401;
var statearr_70402_70469 = state_70302;
(statearr_70402_70469[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_70302[(4)]))){
var statearr_70403_70470 = state_70302;
(statearr_70403_70470[(1)] = cljs.core.first.call(null,(state_70302[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70471 = state_70302;
state_70302 = G__70471;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_70302){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_70302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70404 = f__2707__auto__.call(null);
(statearr_70404[(6)] = c__2706__auto__);

return statearr_70404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70595){
var state_val_70596 = (state_70595[(1)]);
if((state_val_70596 === (7))){
var inst_70494 = (state_70595[(7)]);
var inst_70496 = fluree.db.api.query.resolve_block_range.call(null,inst_70494,query_map);
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70595__$1,(10),inst_70496);
} else {
if((state_val_70596 === (20))){
var inst_70520 = (state_70595[(2)]);
var inst_70521 = fluree.db.util.async.throw_err.call(null,inst_70520);
var inst_70522 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70521);
var inst_70523 = (inst_70522 - (1));
var state_70595__$1 = state_70595;
var statearr_70597_70660 = state_70595__$1;
(statearr_70597_70660[(2)] = inst_70523);

(statearr_70597_70660[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (27))){
var state_70595__$1 = state_70595;
var statearr_70598_70661 = state_70595__$1;
(statearr_70598_70661[(2)] = null);

(statearr_70598_70661[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (1))){
var state_70595__$1 = state_70595;
var statearr_70599_70662 = state_70595__$1;
(statearr_70599_70662[(2)] = null);

(statearr_70599_70662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (24))){
var inst_70530 = (state_70595[(2)]);
var inst_70531 = fluree.db.util.async.throw_err.call(null,inst_70530);
var inst_70532 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70531);
var state_70595__$1 = state_70595;
var statearr_70600_70663 = state_70595__$1;
(statearr_70600_70663[(2)] = inst_70532);

(statearr_70600_70663[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (39))){
var inst_70567 = (state_70595[(2)]);
var inst_70568 = fluree.db.util.async.throw_err.call(null,inst_70567);
var state_70595__$1 = state_70595;
var statearr_70601_70664 = state_70595__$1;
(statearr_70601_70664[(2)] = inst_70568);

(statearr_70601_70664[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (4))){
var inst_70472 = (state_70595[(2)]);
var state_70595__$1 = state_70595;
var statearr_70602_70665 = state_70595__$1;
(statearr_70602_70665[(2)] = inst_70472);

(statearr_70602_70665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (15))){
var inst_70503 = (state_70595[(8)]);
var state_70595__$1 = state_70595;
var statearr_70603_70666 = state_70595__$1;
(statearr_70603_70666[(2)] = inst_70503);

(statearr_70603_70666[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (21))){
var inst_70504 = (state_70595[(9)]);
var inst_70494 = (state_70595[(7)]);
var inst_70528 = fluree.db.time_travel.as_of_block.call(null,inst_70494,inst_70504);
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70595__$1,(24),inst_70528);
} else {
if((state_val_70596 === (31))){
var inst_70488 = (state_70595[(10)]);
var state_70595__$1 = state_70595;
var statearr_70604_70667 = state_70595__$1;
(statearr_70604_70667[(2)] = inst_70488);

(statearr_70604_70667[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (32))){
var inst_70494 = (state_70595[(7)]);
var inst_70551 = (state_70595[(11)]);
var inst_70546 = (state_70595[(12)]);
var inst_70555 = (state_70595[(2)]);
var inst_70556 = fluree.db.api.query.format_history_resp.call(null,inst_70494,inst_70546,inst_70551,inst_70555);
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70595__$1,(29),inst_70556);
} else {
if((state_val_70596 === (40))){
var inst_70572 = (state_70595[(13)]);
var inst_70546 = (state_70595[(12)]);
var inst_70574 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_70575 = cljs.core.count.call(null,inst_70546);
var inst_70576 = [inst_70572,inst_70575,(200)];
var inst_70577 = cljs.core.PersistentHashMap.fromArrays(inst_70574,inst_70576);
var state_70595__$1 = state_70595;
var statearr_70605_70668 = state_70595__$1;
(statearr_70605_70668[(2)] = inst_70577);

(statearr_70605_70668[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (33))){
var inst_70487 = (state_70595[(14)]);
var state_70595__$1 = state_70595;
var statearr_70606_70669 = state_70595__$1;
(statearr_70606_70669[(2)] = inst_70487);

(statearr_70606_70669[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (13))){
var inst_70590 = (state_70595[(2)]);
var _ = (function (){var statearr_70607 = state_70595;
(statearr_70607[(4)] = cljs.core.rest.call(null,(state_70595[(4)])));

return statearr_70607;
})();
var state_70595__$1 = state_70595;
var statearr_70608_70670 = state_70595__$1;
(statearr_70608_70670[(2)] = inst_70590);

(statearr_70608_70670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (22))){
var inst_70494 = (state_70595[(7)]);
var inst_70534 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70494);
var state_70595__$1 = state_70595;
var statearr_70609_70671 = state_70595__$1;
(statearr_70609_70671[(2)] = inst_70534);

(statearr_70609_70671[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (36))){
var inst_70559 = (state_70595[(15)]);
var inst_70494 = (state_70595[(7)]);
var inst_70565 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_70494,inst_70559);
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70595__$1,(39),inst_70565);
} else {
if((state_val_70596 === (41))){
var inst_70572 = (state_70595[(13)]);
var state_70595__$1 = state_70595;
var statearr_70610_70672 = state_70595__$1;
(statearr_70610_70672[(2)] = inst_70572);

(statearr_70610_70672[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (29))){
var inst_70487 = (state_70595[(14)]);
var inst_70558 = (state_70595[(2)]);
var inst_70559 = fluree.db.util.async.throw_err.call(null,inst_70558);
var state_70595__$1 = (function (){var statearr_70611 = state_70595;
(statearr_70611[(15)] = inst_70559);

return statearr_70611;
})();
if(cljs.core.truth_(inst_70487)){
var statearr_70612_70673 = state_70595__$1;
(statearr_70612_70673[(1)] = (33));

} else {
var statearr_70613_70674 = state_70595__$1;
(statearr_70613_70674[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (6))){
var inst_70484 = (state_70595[(16)]);
var inst_70493 = (state_70595[(2)]);
var inst_70494 = fluree.db.util.async.throw_err.call(null,inst_70493);
var state_70595__$1 = (function (){var statearr_70614 = state_70595;
(statearr_70614[(7)] = inst_70494);

return statearr_70614;
})();
if(cljs.core.truth_(inst_70484)){
var statearr_70615_70675 = state_70595__$1;
(statearr_70615_70675[(1)] = (7));

} else {
var statearr_70616_70676 = state_70595__$1;
(statearr_70616_70676[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (28))){
var inst_70489 = (state_70595[(17)]);
var inst_70551 = (state_70595[(2)]);
var state_70595__$1 = (function (){var statearr_70617 = state_70595;
(statearr_70617[(11)] = inst_70551);

return statearr_70617;
})();
if(cljs.core.truth_(inst_70489)){
var statearr_70618_70677 = state_70595__$1;
(statearr_70618_70677[(1)] = (30));

} else {
var statearr_70619_70678 = state_70595__$1;
(statearr_70619_70678[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (25))){
var inst_70490 = (state_70595[(18)]);
var inst_70545 = (state_70595[(2)]);
var inst_70546 = fluree.db.util.async.throw_err.call(null,inst_70545);
var state_70595__$1 = (function (){var statearr_70620 = state_70595;
(statearr_70620[(12)] = inst_70546);

return statearr_70620;
})();
if(cljs.core.truth_(inst_70490)){
var statearr_70621_70679 = state_70595__$1;
(statearr_70621_70679[(1)] = (26));

} else {
var statearr_70622_70680 = state_70595__$1;
(statearr_70622_70680[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (34))){
var inst_70486 = (state_70595[(19)]);
var state_70595__$1 = state_70595;
var statearr_70623_70681 = state_70595__$1;
(statearr_70623_70681[(2)] = inst_70486);

(statearr_70623_70681[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (17))){
var inst_70494 = (state_70595[(7)]);
var inst_70503 = (state_70595[(8)]);
var inst_70517 = (inst_70503 - (1));
var inst_70518 = fluree.db.time_travel.as_of_block.call(null,inst_70494,inst_70517);
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70595__$1,(20),inst_70518);
} else {
if((state_val_70596 === (3))){
var inst_70593 = (state_70595[(2)]);
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70595__$1,inst_70593);
} else {
if((state_val_70596 === (12))){
var inst_70582 = cljs.core.pr_str.call(null,query_map);
var inst_70583 = ["History query not properly formatted. Provided ",inst_70582].join('');
var inst_70584 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70585 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70586 = cljs.core.PersistentHashMap.fromArrays(inst_70584,inst_70585);
var inst_70587 = cljs.core.ex_info.call(null,inst_70583,inst_70586);
var inst_70588 = (function(){throw inst_70587})();
var state_70595__$1 = state_70595;
var statearr_70624_70682 = state_70595__$1;
(statearr_70624_70682[(2)] = inst_70588);

(statearr_70624_70682[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (2))){
var _ = (function (){var statearr_70625 = state_70595;
(statearr_70625[(4)] = cljs.core.cons.call(null,(5),(state_70595[(4)])));

return statearr_70625;
})();
var inst_70482 = query_map;
var inst_70483 = cljs.core.__destructure_map.call(null,inst_70482);
var inst_70484 = cljs.core.get.call(null,inst_70483,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70485 = cljs.core.get.call(null,inst_70483,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_70486 = cljs.core.get.call(null,inst_70483,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_70487 = cljs.core.get.call(null,inst_70483,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_70488 = cljs.core.get.call(null,inst_70483,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_70489 = cljs.core.get.call(null,inst_70483,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_70490 = cljs.core.get.call(null,inst_70483,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70491 = cljs.core.get.call(null,inst_70483,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_70595__$1 = (function (){var statearr_70626 = state_70595;
(statearr_70626[(10)] = inst_70488);

(statearr_70626[(16)] = inst_70484);

(statearr_70626[(18)] = inst_70490);

(statearr_70626[(20)] = inst_70485);

(statearr_70626[(14)] = inst_70487);

(statearr_70626[(21)] = inst_70491);

(statearr_70626[(17)] = inst_70489);

(statearr_70626[(19)] = inst_70486);

return statearr_70626;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70595__$1,(6),sources);
} else {
if((state_val_70596 === (23))){
var inst_70494 = (state_70595[(7)]);
var inst_70526 = (state_70595[(22)]);
var inst_70485 = (state_70595[(20)]);
var inst_70536 = (state_70595[(2)]);
var inst_70537 = fluree.db.api.query.get_history_pattern.call(null,inst_70485);
var inst_70538 = cljs.core.nth.call(null,inst_70537,(0),null);
var inst_70539 = cljs.core.nth.call(null,inst_70537,(1),null);
var inst_70540 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_70541 = [inst_70526,inst_70536];
var inst_70542 = cljs.core.PersistentHashMap.fromArrays(inst_70540,inst_70541);
var inst_70543 = fluree.db.query.range.time_range.call(null,inst_70494,inst_70539,cljs.core._EQ_,inst_70538,inst_70542);
var state_70595__$1 = state_70595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70595__$1,(25),inst_70543);
} else {
if((state_val_70596 === (35))){
var inst_70563 = (state_70595[(2)]);
var state_70595__$1 = state_70595;
if(cljs.core.truth_(inst_70563)){
var statearr_70627_70683 = state_70595__$1;
(statearr_70627_70683[(1)] = (36));

} else {
var statearr_70628_70684 = state_70595__$1;
(statearr_70628_70684[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (19))){
var inst_70504 = (state_70595[(9)]);
var inst_70526 = (state_70595[(2)]);
var state_70595__$1 = (function (){var statearr_70629 = state_70595;
(statearr_70629[(22)] = inst_70526);

return statearr_70629;
})();
if(cljs.core.truth_(inst_70504)){
var statearr_70630_70685 = state_70595__$1;
(statearr_70630_70685[(1)] = (21));

} else {
var statearr_70631_70686 = state_70595__$1;
(statearr_70631_70686[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (11))){
var inst_70491 = (state_70595[(21)]);
var inst_70503 = (state_70595[(8)]);
var inst_70510 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70491);
var state_70595__$1 = (function (){var statearr_70633 = state_70595;
(statearr_70633[(23)] = inst_70510);

return statearr_70633;
})();
if(cljs.core.truth_(inst_70503)){
var statearr_70634_70687 = state_70595__$1;
(statearr_70634_70687[(1)] = (14));

} else {
var statearr_70635_70688 = state_70595__$1;
(statearr_70635_70688[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (9))){
var inst_70502 = (state_70595[(2)]);
var inst_70503 = cljs.core.nth.call(null,inst_70502,(0),null);
var inst_70504 = cljs.core.nth.call(null,inst_70502,(1),null);
var inst_70505 = cljs.core.contains_QMARK_.call(null,query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_70595__$1 = (function (){var statearr_70636 = state_70595;
(statearr_70636[(9)] = inst_70504);

(statearr_70636[(8)] = inst_70503);

return statearr_70636;
})();
if(inst_70505){
var statearr_70637_70689 = state_70595__$1;
(statearr_70637_70689[(1)] = (11));

} else {
var statearr_70638_70690 = state_70595__$1;
(statearr_70638_70690[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (5))){
var _ = (function (){var statearr_70639 = state_70595;
(statearr_70639[(4)] = cljs.core.rest.call(null,(state_70595[(4)])));

return statearr_70639;
})();
var state_70595__$1 = state_70595;
var ex70632 = (state_70595__$1[(2)]);
var statearr_70640_70691 = state_70595__$1;
(statearr_70640_70691[(5)] = ex70632);


if((ex70632 instanceof Error)){
var statearr_70641_70692 = state_70595__$1;
(statearr_70641_70692[(1)] = (4));

(statearr_70641_70692[(5)] = null);

} else {
throw ex70632;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (14))){
var inst_70503 = (state_70595[(8)]);
var inst_70512 = cljs.core.not_EQ_.call(null,(1),inst_70503);
var state_70595__$1 = state_70595;
var statearr_70642_70693 = state_70595__$1;
(statearr_70642_70693[(2)] = inst_70512);

(statearr_70642_70693[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (26))){
var inst_70490 = (state_70595[(18)]);
var inst_70548 = cljs.core.set.call(null,inst_70490);
var state_70595__$1 = state_70595;
var statearr_70643_70694 = state_70595__$1;
(statearr_70643_70694[(2)] = inst_70548);

(statearr_70643_70694[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (16))){
var inst_70515 = (state_70595[(2)]);
var state_70595__$1 = state_70595;
if(cljs.core.truth_(inst_70515)){
var statearr_70644_70695 = state_70595__$1;
(statearr_70644_70695[(1)] = (17));

} else {
var statearr_70645_70696 = state_70595__$1;
(statearr_70645_70696[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (38))){
var inst_70510 = (state_70595[(23)]);
var inst_70572 = (state_70595[(2)]);
var state_70595__$1 = (function (){var statearr_70646 = state_70595;
(statearr_70646[(13)] = inst_70572);

return statearr_70646;
})();
if(cljs.core.truth_(inst_70510)){
var statearr_70647_70697 = state_70595__$1;
(statearr_70647_70697[(1)] = (40));

} else {
var statearr_70648_70698 = state_70595__$1;
(statearr_70648_70698[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (30))){
var inst_70489 = (state_70595[(17)]);
var state_70595__$1 = state_70595;
var statearr_70649_70699 = state_70595__$1;
(statearr_70649_70699[(2)] = inst_70489);

(statearr_70649_70699[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (10))){
var inst_70498 = (state_70595[(2)]);
var inst_70499 = fluree.db.util.async.throw_err.call(null,inst_70498);
var state_70595__$1 = state_70595;
var statearr_70650_70700 = state_70595__$1;
(statearr_70650_70700[(2)] = inst_70499);

(statearr_70650_70700[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (18))){
var state_70595__$1 = state_70595;
var statearr_70651_70701 = state_70595__$1;
(statearr_70651_70701[(2)] = (-1));

(statearr_70651_70701[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (42))){
var inst_70580 = (state_70595[(2)]);
var state_70595__$1 = state_70595;
var statearr_70652_70702 = state_70595__$1;
(statearr_70652_70702[(2)] = inst_70580);

(statearr_70652_70702[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (37))){
var inst_70559 = (state_70595[(15)]);
var inst_70570 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_70559);
var state_70595__$1 = state_70595;
var statearr_70653_70703 = state_70595__$1;
(statearr_70653_70703[(2)] = inst_70570);

(statearr_70653_70703[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70596 === (8))){
var state_70595__$1 = state_70595;
var statearr_70654_70704 = state_70595__$1;
(statearr_70654_70704[(2)] = null);

(statearr_70654_70704[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_70655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70655[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2684__auto__);

(statearr_70655[(1)] = (1));

return statearr_70655;
});
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1 = (function (state_70595){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_70595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70656){var ex__2687__auto__ = e70656;
var statearr_70657_70705 = state_70595;
(statearr_70657_70705[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_70595[(4)]))){
var statearr_70658_70706 = state_70595;
(statearr_70658_70706[(1)] = cljs.core.first.call(null,(state_70595[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70707 = state_70595;
state_70595 = G__70707;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = function(state_70595){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1.call(this,state_70595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70659 = f__2707__auto__.call(null);
(statearr_70659[(6)] = c__2706__auto__);

return statearr_70659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70840){
var state_val_70841 = (state_70840[(1)]);
if((state_val_70841 === (7))){
var inst_70737 = cljs.core.pr_str.call(null,flureeQL);
var inst_70738 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_70737].join('');
var inst_70739 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70740 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70741 = cljs.core.PersistentHashMap.fromArrays(inst_70739,inst_70740);
var inst_70742 = cljs.core.ex_info.call(null,inst_70738,inst_70741);
var inst_70743 = (function(){throw inst_70742})();
var state_70840__$1 = state_70840;
var statearr_70842_70921 = state_70840__$1;
(statearr_70842_70921[(2)] = inst_70743);

(statearr_70842_70921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (20))){
var inst_70775 = (state_70840[(2)]);
var state_70840__$1 = state_70840;
if(cljs.core.truth_(inst_70775)){
var statearr_70843_70922 = state_70840__$1;
(statearr_70843_70922[(1)] = (21));

} else {
var statearr_70844_70923 = state_70840__$1;
(statearr_70844_70923[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (27))){
var inst_70719 = (state_70840[(7)]);
var state_70840__$1 = state_70840;
var statearr_70845_70924 = state_70840__$1;
(statearr_70845_70924[(2)] = inst_70719);

(statearr_70845_70924[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (1))){
var state_70840__$1 = state_70840;
var statearr_70846_70925 = state_70840__$1;
(statearr_70846_70925[(2)] = null);

(statearr_70846_70925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (24))){
var inst_70781 = (state_70840[(8)]);
var state_70840__$1 = state_70840;
var statearr_70847_70926 = state_70840__$1;
(statearr_70847_70926[(2)] = inst_70781);

(statearr_70847_70926[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (39))){
var inst_70725 = (state_70840[(9)]);
var state_70840__$1 = state_70840;
if(cljs.core.truth_(inst_70725)){
var statearr_70848_70927 = state_70840__$1;
(statearr_70848_70927[(1)] = (42));

} else {
var statearr_70849_70928 = state_70840__$1;
(statearr_70849_70928[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (46))){
var inst_70813 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70814 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70815 = cljs.core.PersistentHashMap.fromArrays(inst_70813,inst_70814);
var inst_70816 = cljs.core.ex_info.call(null,"Invalid query.",inst_70815);
var inst_70817 = (function(){throw inst_70816})();
var state_70840__$1 = state_70840;
var statearr_70850_70929 = state_70840__$1;
(statearr_70850_70929[(2)] = inst_70817);

(statearr_70850_70929[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (4))){
var inst_70709 = (state_70840[(2)]);
var state_70840__$1 = state_70840;
var statearr_70851_70930 = state_70840__$1;
(statearr_70851_70930[(2)] = inst_70709);

(statearr_70851_70930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (15))){
var inst_70722 = (state_70840[(10)]);
var inst_70760 = (state_70840[(11)]);
var inst_70762 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_70760);
var inst_70763 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_70760);
var inst_70764 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_70760);
var inst_70765 = fluree.db.api.query.get_sources.call(null,inst_70762,inst_70763,inst_70764,inst_70722);
var state_70840__$1 = state_70840;
var statearr_70852_70931 = state_70840__$1;
(statearr_70852_70931[(2)] = inst_70765);

(statearr_70852_70931[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (48))){
var inst_70770 = (state_70840[(12)]);
var inst_70824 = (state_70840[(2)]);
var inst_70825 = fluree.db.util.async.throw_err.call(null,inst_70824);
var state_70840__$1 = (function (){var statearr_70853 = state_70840;
(statearr_70853[(13)] = inst_70825);

return statearr_70853;
})();
if(cljs.core.truth_(inst_70770)){
var statearr_70854_70932 = state_70840__$1;
(statearr_70854_70932[(1)] = (49));

} else {
var statearr_70855_70933 = state_70840__$1;
(statearr_70855_70933[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (50))){
var inst_70825 = (state_70840[(13)]);
var state_70840__$1 = state_70840;
var statearr_70856_70934 = state_70840__$1;
(statearr_70856_70934[(2)] = inst_70825);

(statearr_70856_70934[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (21))){
var inst_70777 = cljs.core.volatile_BANG_.call(null,(0));
var state_70840__$1 = state_70840;
var statearr_70857_70935 = state_70840__$1;
(statearr_70857_70935[(2)] = inst_70777);

(statearr_70857_70935[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (31))){
var inst_70723 = (state_70840[(14)]);
var state_70840__$1 = state_70840;
if(cljs.core.truth_(inst_70723)){
var statearr_70858_70936 = state_70840__$1;
(statearr_70858_70936[(1)] = (33));

} else {
var statearr_70859_70937 = state_70840__$1;
(statearr_70859_70937[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (32))){
var inst_70800 = (state_70840[(2)]);
var state_70840__$1 = state_70840;
var statearr_70860_70938 = state_70840__$1;
(statearr_70860_70938[(2)] = inst_70800);

(statearr_70860_70938[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (40))){
var inst_70802 = (state_70840[(15)]);
var state_70840__$1 = state_70840;
var statearr_70861_70939 = state_70840__$1;
(statearr_70861_70939[(2)] = inst_70802);

(statearr_70861_70939[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (33))){
var inst_70723 = (state_70840[(14)]);
var state_70840__$1 = state_70840;
var statearr_70862_70940 = state_70840__$1;
(statearr_70862_70940[(2)] = inst_70723);

(statearr_70862_70940[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (13))){
var inst_70720 = (state_70840[(16)]);
var inst_70749 = (state_70840[(2)]);
var inst_70750 = fluree.db.util.async.throw_err.call(null,inst_70749);
var inst_70751 = fluree.db.time_travel.as_of_block.call(null,inst_70750,inst_70720);
var state_70840__$1 = state_70840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70840__$1,(12),inst_70751);
} else {
if((state_val_70841 === (22))){
var state_70840__$1 = state_70840;
var statearr_70863_70941 = state_70840__$1;
(statearr_70863_70941[(2)] = null);

(statearr_70863_70941[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (36))){
var inst_70727 = (state_70840[(17)]);
var state_70840__$1 = state_70840;
var statearr_70864_70942 = state_70840__$1;
(statearr_70864_70942[(2)] = inst_70727);

(statearr_70864_70942[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (41))){
var inst_70810 = (state_70840[(2)]);
var state_70840__$1 = state_70840;
if(cljs.core.truth_(inst_70810)){
var statearr_70865_70943 = state_70840__$1;
(statearr_70865_70943[(1)] = (45));

} else {
var statearr_70866_70944 = state_70840__$1;
(statearr_70866_70944[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (43))){
var inst_70721 = (state_70840[(18)]);
var state_70840__$1 = state_70840;
var statearr_70867_70945 = state_70840__$1;
(statearr_70867_70945[(2)] = inst_70721);

(statearr_70867_70945[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (29))){
var inst_70802 = (state_70840[(15)]);
var inst_70802__$1 = (state_70840[(2)]);
var state_70840__$1 = (function (){var statearr_70868 = state_70840;
(statearr_70868[(15)] = inst_70802__$1);

return statearr_70868;
})();
if(cljs.core.truth_(inst_70802__$1)){
var statearr_70869_70946 = state_70840__$1;
(statearr_70869_70946[(1)] = (39));

} else {
var statearr_70870_70947 = state_70840__$1;
(statearr_70870_70947[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (44))){
var inst_70807 = (state_70840[(2)]);
var state_70840__$1 = state_70840;
var statearr_70871_70948 = state_70840__$1;
(statearr_70871_70948[(2)] = inst_70807);

(statearr_70871_70948[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (6))){
var state_70840__$1 = state_70840;
var statearr_70872_70949 = state_70840__$1;
(statearr_70872_70949[(2)] = null);

(statearr_70872_70949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (28))){
var inst_70724 = (state_70840[(19)]);
var state_70840__$1 = state_70840;
if(cljs.core.truth_(inst_70724)){
var statearr_70873_70950 = state_70840__$1;
(statearr_70873_70950[(1)] = (30));

} else {
var statearr_70874_70951 = state_70840__$1;
(statearr_70874_70951[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (51))){
var inst_70835 = (state_70840[(2)]);
var _ = (function (){var statearr_70875 = state_70840;
(statearr_70875[(4)] = cljs.core.rest.call(null,(state_70840[(4)])));

return statearr_70875;
})();
var state_70840__$1 = state_70840;
var statearr_70876_70952 = state_70840__$1;
(statearr_70876_70952[(2)] = inst_70835);

(statearr_70876_70952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (25))){
var state_70840__$1 = state_70840;
var statearr_70877_70953 = state_70840__$1;
(statearr_70877_70953[(2)] = (1000000));

(statearr_70877_70953[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (34))){
var inst_70727 = (state_70840[(17)]);
var state_70840__$1 = state_70840;
if(cljs.core.truth_(inst_70727)){
var statearr_70878_70954 = state_70840__$1;
(statearr_70878_70954[(1)] = (36));

} else {
var statearr_70879_70955 = state_70840__$1;
(statearr_70879_70955[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (17))){
var inst_70771 = (state_70840[(20)]);
var inst_70726 = (state_70840[(21)]);
var inst_70769 = (state_70840[(2)]);
var inst_70770 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70726);
var inst_70771__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70726);
var state_70840__$1 = (function (){var statearr_70880 = state_70840;
(statearr_70880[(12)] = inst_70770);

(statearr_70880[(20)] = inst_70771__$1);

(statearr_70880[(22)] = inst_70769);

return statearr_70880;
})();
if(cljs.core.truth_(inst_70771__$1)){
var statearr_70881_70956 = state_70840__$1;
(statearr_70881_70956[(1)] = (18));

} else {
var statearr_70882_70957 = state_70840__$1;
(statearr_70882_70957[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (3))){
var inst_70838 = (state_70840[(2)]);
var state_70840__$1 = state_70840;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70840__$1,inst_70838);
} else {
if((state_val_70841 === (12))){
var inst_70753 = (state_70840[(2)]);
var inst_70754 = fluree.db.util.async.throw_err.call(null,inst_70753);
var state_70840__$1 = state_70840;
var statearr_70883_70958 = state_70840__$1;
(statearr_70883_70958[(2)] = inst_70754);

(statearr_70883_70958[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (2))){
var inst_70727 = (state_70840[(17)]);
var inst_70724 = (state_70840[(19)]);
var inst_70725 = (state_70840[(9)]);
var inst_70718 = (state_70840[(23)]);
var inst_70726 = (state_70840[(21)]);
var inst_70722 = (state_70840[(10)]);
var inst_70721 = (state_70840[(18)]);
var inst_70719 = (state_70840[(7)]);
var inst_70720 = (state_70840[(16)]);
var inst_70723 = (state_70840[(14)]);
var _ = (function (){var statearr_70884 = state_70840;
(statearr_70884[(4)] = cljs.core.cons.call(null,(5),(state_70840[(4)])));

return statearr_70884;
})();
var inst_70716 = flureeQL;
var inst_70717 = cljs.core.__destructure_map.call(null,inst_70716);
var inst_70718__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_70719__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_70720__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70721__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_70722__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_70723__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_70724__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_70725__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_70726__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70727__$1 = cljs.core.get.call(null,inst_70717,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_70728 = (function (){var construct = inst_70718__$1;
var select = inst_70719__$1;
var block = inst_70720__$1;
var where = inst_70721__$1;
var prefixes = inst_70722__$1;
var map__70715 = inst_70717;
var selectDistinct = inst_70723__$1;
var selectOne = inst_70724__$1;
var from = inst_70725__$1;
var opts = inst_70726__$1;
var selectReduced = inst_70727__$1;
return (function (p1__70708_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__70708_SHARP_);
});
})();
var inst_70729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70730 = [inst_70719__$1,inst_70724__$1,inst_70723__$1,inst_70727__$1];
var inst_70731 = (new cljs.core.PersistentVector(null,4,(5),inst_70729,inst_70730,null));
var inst_70732 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_70731);
var inst_70733 = cljs.core.count.call(null,inst_70732);
var inst_70734 = inst_70728.call(null,inst_70733);
var state_70840__$1 = (function (){var statearr_70885 = state_70840;
(statearr_70885[(17)] = inst_70727__$1);

(statearr_70885[(19)] = inst_70724__$1);

(statearr_70885[(9)] = inst_70725__$1);

(statearr_70885[(23)] = inst_70718__$1);

(statearr_70885[(21)] = inst_70726__$1);

(statearr_70885[(10)] = inst_70722__$1);

(statearr_70885[(18)] = inst_70721__$1);

(statearr_70885[(7)] = inst_70719__$1);

(statearr_70885[(16)] = inst_70720__$1);

(statearr_70885[(14)] = inst_70723__$1);

return statearr_70885;
})();
if(cljs.core.truth_(inst_70734)){
var statearr_70886_70959 = state_70840__$1;
(statearr_70886_70959[(1)] = (6));

} else {
var statearr_70887_70960 = state_70840__$1;
(statearr_70887_70960[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (23))){
var inst_70726 = (state_70840[(21)]);
var inst_70781 = (state_70840[(8)]);
var inst_70780 = (state_70840[(2)]);
var inst_70781__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70726);
var state_70840__$1 = (function (){var statearr_70888 = state_70840;
(statearr_70888[(24)] = inst_70780);

(statearr_70888[(8)] = inst_70781__$1);

return statearr_70888;
})();
if(cljs.core.truth_(inst_70781__$1)){
var statearr_70889_70961 = state_70840__$1;
(statearr_70889_70961[(1)] = (24));

} else {
var statearr_70890_70962 = state_70840__$1;
(statearr_70890_70962[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (47))){
var inst_70786 = (state_70840[(25)]);
var inst_70760 = (state_70840[(11)]);
var inst_70819 = (state_70840[(2)]);
var inst_70820 = fluree.db.util.core.current_time_millis.call(null);
var inst_70821 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70786);
var inst_70822 = fluree.db.query.fql.query.call(null,inst_70760,inst_70821);
var state_70840__$1 = (function (){var statearr_70891 = state_70840;
(statearr_70891[(26)] = inst_70819);

(statearr_70891[(27)] = inst_70820);

return statearr_70891;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70840__$1,(48),inst_70822);
} else {
if((state_val_70841 === (35))){
var inst_70798 = (state_70840[(2)]);
var state_70840__$1 = state_70840;
var statearr_70892_70963 = state_70840__$1;
(statearr_70892_70963[(2)] = inst_70798);

(statearr_70892_70963[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (19))){
var inst_70770 = (state_70840[(12)]);
var state_70840__$1 = state_70840;
var statearr_70893_70964 = state_70840__$1;
(statearr_70893_70964[(2)] = inst_70770);

(statearr_70893_70964[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (11))){
var inst_70722 = (state_70840[(10)]);
var inst_70760 = (state_70840[(2)]);
var state_70840__$1 = (function (){var statearr_70895 = state_70840;
(statearr_70895[(11)] = inst_70760);

return statearr_70895;
})();
if(cljs.core.truth_(inst_70722)){
var statearr_70896_70965 = state_70840__$1;
(statearr_70896_70965[(1)] = (15));

} else {
var statearr_70897_70966 = state_70840__$1;
(statearr_70897_70966[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (9))){
var inst_70746 = (state_70840[(28)]);
var state_70840__$1 = state_70840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70840__$1,(13),inst_70746);
} else {
if((state_val_70841 === (5))){
var _ = (function (){var statearr_70898 = state_70840;
(statearr_70898[(4)] = cljs.core.rest.call(null,(state_70840[(4)])));

return statearr_70898;
})();
var state_70840__$1 = state_70840;
var ex70894 = (state_70840__$1[(2)]);
var statearr_70899_70967 = state_70840__$1;
(statearr_70899_70967[(5)] = ex70894);


if((ex70894 instanceof Error)){
var statearr_70900_70968 = state_70840__$1;
(statearr_70900_70968[(1)] = (4));

(statearr_70900_70968[(5)] = null);

} else {
throw ex70894;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (14))){
var inst_70757 = (state_70840[(2)]);
var inst_70758 = fluree.db.util.async.throw_err.call(null,inst_70757);
var state_70840__$1 = state_70840;
var statearr_70901_70969 = state_70840__$1;
(statearr_70901_70969[(2)] = inst_70758);

(statearr_70901_70969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (45))){
var state_70840__$1 = state_70840;
var statearr_70902_70970 = state_70840__$1;
(statearr_70902_70970[(2)] = null);

(statearr_70902_70970[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (26))){
var inst_70780 = (state_70840[(24)]);
var inst_70769 = (state_70840[(22)]);
var inst_70726 = (state_70840[(21)]);
var inst_70719 = (state_70840[(7)]);
var inst_70785 = (state_70840[(2)]);
var inst_70786 = cljs.core.assoc.call(null,inst_70726,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_70769,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_70785,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_70780);
var state_70840__$1 = (function (){var statearr_70903 = state_70840;
(statearr_70903[(25)] = inst_70786);

return statearr_70903;
})();
if(cljs.core.truth_(inst_70719)){
var statearr_70904_70971 = state_70840__$1;
(statearr_70904_70971[(1)] = (27));

} else {
var statearr_70905_70972 = state_70840__$1;
(statearr_70905_70972[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (16))){
var inst_70767 = cljs.core.PersistentHashMap.EMPTY;
var state_70840__$1 = state_70840;
var statearr_70906_70973 = state_70840__$1;
(statearr_70906_70973[(2)] = inst_70767);

(statearr_70906_70973[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (38))){
var inst_70796 = (state_70840[(2)]);
var state_70840__$1 = state_70840;
var statearr_70907_70974 = state_70840__$1;
(statearr_70907_70974[(2)] = inst_70796);

(statearr_70907_70974[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (30))){
var inst_70724 = (state_70840[(19)]);
var state_70840__$1 = state_70840;
var statearr_70908_70975 = state_70840__$1;
(statearr_70908_70975[(2)] = inst_70724);

(statearr_70908_70975[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (10))){
var inst_70746 = (state_70840[(28)]);
var state_70840__$1 = state_70840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70840__$1,(14),inst_70746);
} else {
if((state_val_70841 === (18))){
var inst_70771 = (state_70840[(20)]);
var state_70840__$1 = state_70840;
var statearr_70909_70976 = state_70840__$1;
(statearr_70909_70976[(2)] = inst_70771);

(statearr_70909_70976[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (42))){
var inst_70725 = (state_70840[(9)]);
var state_70840__$1 = state_70840;
var statearr_70910_70977 = state_70840__$1;
(statearr_70910_70977[(2)] = inst_70725);

(statearr_70910_70977[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (37))){
var inst_70718 = (state_70840[(23)]);
var state_70840__$1 = state_70840;
var statearr_70911_70978 = state_70840__$1;
(statearr_70911_70978[(2)] = inst_70718);

(statearr_70911_70978[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (8))){
var inst_70720 = (state_70840[(16)]);
var inst_70745 = (state_70840[(2)]);
var inst_70746 = sources;
var state_70840__$1 = (function (){var statearr_70912 = state_70840;
(statearr_70912[(29)] = inst_70745);

(statearr_70912[(28)] = inst_70746);

return statearr_70912;
})();
if(cljs.core.truth_(inst_70720)){
var statearr_70913_70979 = state_70840__$1;
(statearr_70913_70979[(1)] = (9));

} else {
var statearr_70914_70980 = state_70840__$1;
(statearr_70914_70980[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70841 === (49))){
var inst_70780 = (state_70840[(24)]);
var inst_70825 = (state_70840[(13)]);
var inst_70820 = (state_70840[(27)]);
var inst_70760 = (state_70840[(11)]);
var inst_70827 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70828 = cljs.core.deref.call(null,inst_70780);
var inst_70829 = fluree.db.util.core.response_time_formatted.call(null,inst_70820);
var inst_70830 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_70760);
var inst_70831 = [(200),inst_70825,inst_70828,inst_70829,inst_70830];
var inst_70832 = cljs.core.PersistentHashMap.fromArrays(inst_70827,inst_70831);
var state_70840__$1 = state_70840;
var statearr_70915_70981 = state_70840__$1;
(statearr_70915_70981[(2)] = inst_70832);

(statearr_70915_70981[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_70916 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70916[(0)] = fluree$db$api$query$query_async_$_state_machine__2684__auto__);

(statearr_70916[(1)] = (1));

return statearr_70916;
});
var fluree$db$api$query$query_async_$_state_machine__2684__auto____1 = (function (state_70840){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_70840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70917){var ex__2687__auto__ = e70917;
var statearr_70918_70982 = state_70840;
(statearr_70918_70982[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_70840[(4)]))){
var statearr_70919_70983 = state_70840;
(statearr_70919_70983[(1)] = cljs.core.first.call(null,(state_70840[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70984 = state_70840;
state_70840 = G__70984;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2684__auto__ = function(state_70840){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____1.call(this,state_70840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70920 = f__2707__auto__.call(null);
(statearr_70920[(6)] = c__2706__auto__);

return statearr_70920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71125){
var state_val_71126 = (state_71125[(1)]);
if((state_val_71126 === (7))){
var inst_71120 = (state_71125[(2)]);
var _ = (function (){var statearr_71127 = state_71125;
(statearr_71127[(4)] = cljs.core.rest.call(null,(state_71125[(4)])));

return statearr_71127;
})();
var state_71125__$1 = state_71125;
var statearr_71128_71204 = state_71125__$1;
(statearr_71128_71204[(2)] = inst_71120);

(statearr_71128_71204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (20))){
var inst_71092 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
var statearr_71129_71205 = state_71125__$1;
(statearr_71129_71205[(2)] = inst_71092);

(statearr_71129_71205[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (27))){
var inst_71072 = (state_71125[(7)]);
var state_71125__$1 = state_71125;
var statearr_71130_71206 = state_71125__$1;
(statearr_71130_71206[(2)] = inst_71072);

(statearr_71130_71206[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (1))){
var state_71125__$1 = state_71125;
var statearr_71131_71207 = state_71125__$1;
(statearr_71131_71207[(2)] = null);

(statearr_71131_71207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (24))){
var inst_71069 = (state_71125[(8)]);
var state_71125__$1 = state_71125;
var statearr_71132_71208 = state_71125__$1;
(statearr_71132_71208[(2)] = inst_71069);

(statearr_71132_71208[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (39))){
var inst_71059 = (state_71125[(9)]);
var inst_71037 = (state_71125[(10)]);
var inst_71026 = (state_71125[(11)]);
var inst_71103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71104 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_71037];
var inst_71105 = (new cljs.core.PersistentVector(null,2,(5),inst_71103,inst_71104,null));
var inst_71106 = cljs.core.assoc_in.call(null,inst_71026,inst_71105,inst_71059);
var state_71125__$1 = state_71125;
var statearr_71133_71209 = state_71125__$1;
(statearr_71133_71209[(2)] = inst_71106);

(statearr_71133_71209[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (4))){
var inst_70985 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
var statearr_71134_71210 = state_71125__$1;
(statearr_71134_71210[(2)] = inst_70985);

(statearr_71134_71210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (15))){
var inst_71024 = (state_71125[(12)]);
var inst_71059 = (state_71125[(9)]);
var inst_71062 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_71059);
var inst_71063 = (inst_71024 == null);
var state_71125__$1 = (function (){var statearr_71135 = state_71125;
(statearr_71135[(13)] = inst_71062);

return statearr_71135;
})();
if(cljs.core.truth_(inst_71063)){
var statearr_71136_71211 = state_71125__$1;
(statearr_71136_71211[(1)] = (18));

} else {
var statearr_71137_71212 = state_71125__$1;
(statearr_71137_71212[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (21))){
var inst_71062 = (state_71125[(13)]);
var state_71125__$1 = state_71125;
var statearr_71138_71213 = state_71125__$1;
(statearr_71138_71213[(2)] = inst_71062);

(statearr_71138_71213[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (31))){
var state_71125__$1 = state_71125;
var statearr_71139_71214 = state_71125__$1;
(statearr_71139_71214[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (32))){
var inst_71088 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
var statearr_71141_71215 = state_71125__$1;
(statearr_71141_71215[(2)] = inst_71088);

(statearr_71141_71215[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (40))){
var inst_71057 = (state_71125[(14)]);
var state_71125__$1 = state_71125;
if(cljs.core.truth_(inst_71057)){
var statearr_71142_71216 = state_71125__$1;
(statearr_71142_71216[(1)] = (42));

} else {
var statearr_71143_71217 = state_71125__$1;
(statearr_71143_71217[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (33))){
var inst_71024 = (state_71125[(12)]);
var inst_71062 = (state_71125[(13)]);
var inst_71083 = ((inst_71062 > inst_71024) ? inst_71062 : inst_71024);
var state_71125__$1 = state_71125;
var statearr_71144_71218 = state_71125__$1;
(statearr_71144_71218[(2)] = inst_71083);

(statearr_71144_71218[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (13))){
var inst_71048 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
var statearr_71145_71219 = state_71125__$1;
(statearr_71145_71219[(2)] = inst_71048);

(statearr_71145_71219[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (22))){
var inst_71069 = (state_71125[(8)]);
var inst_71062 = (state_71125[(13)]);
var inst_71069__$1 = cljs.core._EQ_.call(null,(200),inst_71062);
var state_71125__$1 = (function (){var statearr_71146 = state_71125;
(statearr_71146[(8)] = inst_71069__$1);

return statearr_71146;
})();
if(inst_71069__$1){
var statearr_71147_71220 = state_71125__$1;
(statearr_71147_71220[(1)] = (24));

} else {
var statearr_71148_71221 = state_71125__$1;
(statearr_71148_71221[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (36))){
var inst_71059 = (state_71125[(9)]);
var inst_71025 = (state_71125[(15)]);
var inst_71097 = cljs.core.get.call(null,inst_71059,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_71098 = (inst_71025 + inst_71097);
var state_71125__$1 = state_71125;
var statearr_71149_71222 = state_71125__$1;
(statearr_71149_71222[(2)] = inst_71098);

(statearr_71149_71222[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (41))){
var inst_71036 = (state_71125[(16)]);
var inst_71095 = (state_71125[(17)]);
var inst_71101 = (state_71125[(18)]);
var inst_71115 = (state_71125[(2)]);
var inst_71023 = inst_71036;
var inst_71024 = inst_71095;
var inst_71025 = inst_71101;
var inst_71026 = inst_71115;
var state_71125__$1 = (function (){var statearr_71150 = state_71125;
(statearr_71150[(12)] = inst_71024);

(statearr_71150[(15)] = inst_71025);

(statearr_71150[(19)] = inst_71023);

(statearr_71150[(11)] = inst_71026);

return statearr_71150;
})();
var statearr_71151_71223 = state_71125__$1;
(statearr_71151_71223[(2)] = null);

(statearr_71151_71223[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (43))){
var inst_71059 = (state_71125[(9)]);
var state_71125__$1 = state_71125;
var statearr_71152_71224 = state_71125__$1;
(statearr_71152_71224[(2)] = inst_71059);

(statearr_71152_71224[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (29))){
var inst_71077 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
var statearr_71153_71225 = state_71125__$1;
(statearr_71153_71225[(2)] = inst_71077);

(statearr_71153_71225[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (44))){
var inst_71037 = (state_71125[(10)]);
var inst_71026 = (state_71125[(11)]);
var inst_71112 = (state_71125[(2)]);
var inst_71113 = cljs.core.assoc.call(null,inst_71026,inst_71037,inst_71112);
var state_71125__$1 = state_71125;
var statearr_71154_71226 = state_71125__$1;
(statearr_71154_71226[(2)] = inst_71113);

(statearr_71154_71226[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (6))){
var inst_71038 = (state_71125[(20)]);
var inst_71023 = (state_71125[(19)]);
var inst_71034 = cljs.core.seq.call(null,inst_71023);
var inst_71035 = cljs.core.first.call(null,inst_71034);
var inst_71036 = cljs.core.next.call(null,inst_71034);
var inst_71037 = cljs.core.nth.call(null,inst_71035,(0),null);
var inst_71038__$1 = cljs.core.nth.call(null,inst_71035,(1),null);
var inst_71039 = (inst_71038__$1 == null);
var state_71125__$1 = (function (){var statearr_71155 = state_71125;
(statearr_71155[(16)] = inst_71036);

(statearr_71155[(20)] = inst_71038__$1);

(statearr_71155[(10)] = inst_71037);

return statearr_71155;
})();
if(cljs.core.truth_(inst_71039)){
var statearr_71156_71227 = state_71125__$1;
(statearr_71156_71227[(1)] = (8));

} else {
var statearr_71157_71228 = state_71125__$1;
(statearr_71157_71228[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (28))){
var inst_71024 = (state_71125[(12)]);
var inst_71075 = cljs.core._EQ_.call(null,(207),inst_71024);
var state_71125__$1 = state_71125;
var statearr_71158_71229 = state_71125__$1;
(statearr_71158_71229[(2)] = inst_71075);

(statearr_71158_71229[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (25))){
var inst_71072 = (state_71125[(7)]);
var inst_71024 = (state_71125[(12)]);
var inst_71072__$1 = cljs.core._EQ_.call(null,(200),inst_71024);
var state_71125__$1 = (function (){var statearr_71159 = state_71125;
(statearr_71159[(7)] = inst_71072__$1);

return statearr_71159;
})();
if(inst_71072__$1){
var statearr_71160_71230 = state_71125__$1;
(statearr_71160_71230[(1)] = (27));

} else {
var statearr_71161_71231 = state_71125__$1;
(statearr_71161_71231[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (34))){
var state_71125__$1 = state_71125;
var statearr_71162_71232 = state_71125__$1;
(statearr_71162_71232[(2)] = null);

(statearr_71162_71232[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (17))){
var inst_71056 = (state_71125[(21)]);
var inst_71095 = (state_71125[(2)]);
var state_71125__$1 = (function (){var statearr_71163 = state_71125;
(statearr_71163[(17)] = inst_71095);

return statearr_71163;
})();
if(cljs.core.truth_(inst_71056)){
var statearr_71164_71233 = state_71125__$1;
(statearr_71164_71233[(1)] = (36));

} else {
var statearr_71165_71234 = state_71125__$1;
(statearr_71165_71234[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (3))){
var inst_71123 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71125__$1,inst_71123);
} else {
if((state_val_71126 === (12))){
var inst_71026 = (state_71125[(11)]);
var state_71125__$1 = state_71125;
var statearr_71166_71235 = state_71125__$1;
(statearr_71166_71235[(2)] = inst_71026);

(statearr_71166_71235[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (2))){
var inst_71000 = (state_71125[(22)]);
var inst_70995 = (state_71125[(23)]);
var inst_70999 = (state_71125[(24)]);
var _ = (function (){var statearr_71167 = state_71125;
(statearr_71167[(4)] = cljs.core.cons.call(null,(5),(state_71125[(4)])));

return statearr_71167;
})();
var inst_70991 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_70992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70993 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_70994 = (new cljs.core.PersistentVector(null,2,(5),inst_70992,inst_70993,null));
var inst_70995__$1 = cljs.core.get_in.call(null,flureeQL,inst_70994);
var inst_70996 = (function (){var global_block = inst_70991;
var global_meta_QMARK_ = inst_70995__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_70997 = cljs.core.PersistentHashMap.EMPTY;
var inst_70998 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_70999__$1 = cljs.core.reduce_kv.call(null,inst_70996,inst_70997,inst_70998);
var inst_71000__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_71002 = (function (){var global_block = inst_70991;
var global_meta_QMARK_ = inst_70995__$1;
var queries = inst_70999__$1;
var start_time = inst_71000__$1;
return (function (p__71001){
var vec__71168 = p__71001;
var alias = cljs.core.nth.call(null,vec__71168,(0),null);
var q = cljs.core.nth.call(null,vec__71168,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_71003 = cljs.core.map.call(null,inst_71002,inst_70999__$1);
var inst_71017 = cljs.core.seq.call(null,inst_71003);
var inst_71018 = cljs.core.first.call(null,inst_71017);
var inst_71019 = cljs.core.next.call(null,inst_71017);
var inst_71020 = cljs.core.nth.call(null,inst_71018,(0),null);
var inst_71021 = cljs.core.nth.call(null,inst_71018,(1),null);
var inst_71022 = cljs.core.PersistentHashMap.EMPTY;
var inst_71023 = inst_71003;
var inst_71024 = null;
var inst_71025 = (0);
var inst_71026 = inst_71022;
var state_71125__$1 = (function (){var statearr_71171 = state_71125;
(statearr_71171[(22)] = inst_71000__$1);

(statearr_71171[(12)] = inst_71024);

(statearr_71171[(25)] = inst_71019);

(statearr_71171[(23)] = inst_70995__$1);

(statearr_71171[(26)] = inst_71020);

(statearr_71171[(15)] = inst_71025);

(statearr_71171[(27)] = inst_71021);

(statearr_71171[(19)] = inst_71023);

(statearr_71171[(11)] = inst_71026);

(statearr_71171[(24)] = inst_70999__$1);

return statearr_71171;
})();
var statearr_71172_71236 = state_71125__$1;
(statearr_71172_71236[(2)] = null);

(statearr_71172_71236[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (23))){
var inst_71090 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
var statearr_71173_71237 = state_71125__$1;
(statearr_71173_71237[(2)] = inst_71090);

(statearr_71173_71237[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (35))){
var inst_71086 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
var statearr_71174_71238 = state_71125__$1;
(statearr_71174_71238[(2)] = inst_71086);

(statearr_71174_71238[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (19))){
var inst_71024 = (state_71125[(12)]);
var inst_71062 = (state_71125[(13)]);
var inst_71066 = cljs.core._EQ_.call(null,inst_71024,inst_71062);
var state_71125__$1 = state_71125;
if(inst_71066){
var statearr_71175_71239 = state_71125__$1;
(statearr_71175_71239[(1)] = (21));

} else {
var statearr_71176_71240 = state_71125__$1;
(statearr_71176_71240[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (11))){
var inst_71000 = (state_71125[(22)]);
var inst_71024 = (state_71125[(12)]);
var inst_71025 = (state_71125[(15)]);
var inst_71026 = (state_71125[(11)]);
var inst_71042 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71043 = fluree.db.util.core.response_time_formatted.call(null,inst_71000);
var inst_71044 = [inst_71026,inst_71025,inst_71024,inst_71043];
var inst_71045 = cljs.core.PersistentHashMap.fromArrays(inst_71042,inst_71044);
var state_71125__$1 = state_71125;
var statearr_71178_71241 = state_71125__$1;
(statearr_71178_71241[(2)] = inst_71045);

(statearr_71178_71241[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (9))){
var inst_71038 = (state_71125[(20)]);
var inst_71037 = (state_71125[(10)]);
var inst_70999 = (state_71125[(24)]);
var inst_71051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71052 = [inst_71037,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_71053 = (new cljs.core.PersistentVector(null,2,(5),inst_71051,inst_71052,null));
var inst_71054 = cljs.core.get_in.call(null,inst_70999,inst_71053);
var inst_71055 = cljs.core.__destructure_map.call(null,inst_71054);
var inst_71056 = cljs.core.get.call(null,inst_71055,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_71057 = cljs.core.get.call(null,inst_71055,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_71125__$1 = (function (){var statearr_71179 = state_71125;
(statearr_71179[(21)] = inst_71056);

(statearr_71179[(14)] = inst_71057);

return statearr_71179;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71125__$1,(14),inst_71038);
} else {
if((state_val_71126 === (5))){
var _ = (function (){var statearr_71180 = state_71125;
(statearr_71180[(4)] = cljs.core.rest.call(null,(state_71125[(4)])));

return statearr_71180;
})();
var state_71125__$1 = state_71125;
var ex71177 = (state_71125__$1[(2)]);
var statearr_71181_71242 = state_71125__$1;
(statearr_71181_71242[(5)] = ex71177);


var statearr_71182_71243 = state_71125__$1;
(statearr_71182_71243[(1)] = (4));

(statearr_71182_71243[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (14))){
var inst_71059 = (state_71125[(9)]);
var inst_71056 = (state_71125[(21)]);
var inst_71059__$1 = (state_71125[(2)]);
var inst_71060 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_71059__$1);
var state_71125__$1 = (function (){var statearr_71183 = state_71125;
(statearr_71183[(9)] = inst_71059__$1);

(statearr_71183[(28)] = inst_71060);

return statearr_71183;
})();
if(cljs.core.truth_(inst_71056)){
var statearr_71184_71244 = state_71125__$1;
(statearr_71184_71244[(1)] = (15));

} else {
var statearr_71185_71245 = state_71125__$1;
(statearr_71185_71245[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (26))){
var inst_71079 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
if(cljs.core.truth_(inst_71079)){
var statearr_71186_71246 = state_71125__$1;
(statearr_71186_71246[(1)] = (30));

} else {
var statearr_71187_71247 = state_71125__$1;
(statearr_71187_71247[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (16))){
var state_71125__$1 = state_71125;
var statearr_71188_71248 = state_71125__$1;
(statearr_71188_71248[(2)] = null);

(statearr_71188_71248[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (38))){
var inst_71060 = (state_71125[(28)]);
var inst_71101 = (state_71125[(2)]);
var state_71125__$1 = (function (){var statearr_71189 = state_71125;
(statearr_71189[(18)] = inst_71101);

return statearr_71189;
})();
if(cljs.core.truth_(inst_71060)){
var statearr_71190_71249 = state_71125__$1;
(statearr_71190_71249[(1)] = (39));

} else {
var statearr_71191_71250 = state_71125__$1;
(statearr_71191_71250[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (30))){
var state_71125__$1 = state_71125;
var statearr_71192_71251 = state_71125__$1;
(statearr_71192_71251[(2)] = (207));

(statearr_71192_71251[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (10))){
var inst_71118 = (state_71125[(2)]);
var state_71125__$1 = state_71125;
var statearr_71193_71252 = state_71125__$1;
(statearr_71193_71252[(2)] = inst_71118);

(statearr_71193_71252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (18))){
var inst_71062 = (state_71125[(13)]);
var state_71125__$1 = state_71125;
var statearr_71194_71253 = state_71125__$1;
(statearr_71194_71253[(2)] = inst_71062);

(statearr_71194_71253[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (42))){
var inst_71059 = (state_71125[(9)]);
var inst_71109 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_71059);
var state_71125__$1 = state_71125;
var statearr_71195_71254 = state_71125__$1;
(statearr_71195_71254[(2)] = inst_71109);

(statearr_71195_71254[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (37))){
var state_71125__$1 = state_71125;
var statearr_71196_71255 = state_71125__$1;
(statearr_71196_71255[(2)] = null);

(statearr_71196_71255[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71126 === (8))){
var inst_70995 = (state_71125[(23)]);
var state_71125__$1 = state_71125;
if(cljs.core.truth_(inst_70995)){
var statearr_71197_71256 = state_71125__$1;
(statearr_71197_71256[(1)] = (11));

} else {
var statearr_71198_71257 = state_71125__$1;
(statearr_71198_71257[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_71199 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71199[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__);

(statearr_71199[(1)] = (1));

return statearr_71199;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1 = (function (state_71125){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__.call(null,state_71125);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71200){var ex__2687__auto__ = e71200;
var statearr_71201_71258 = state_71125;
(statearr_71201_71258[(2)] = ex__2687__auto__);


if(cljs.core.seq.call(null,(state_71125[(4)]))){
var statearr_71202_71259 = state_71125;
(statearr_71202_71259[(1)] = cljs.core.first.call(null,(state_71125[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71260 = state_71125;
state_71125 = G__71260;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = function(state_71125){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1.call(this,state_71125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71203 = f__2707__auto__.call(null);
(statearr_71203[(6)] = c__2706__auto__);

return statearr_71203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__71261 = query_type;
var G__71261__$1 = (((G__71261 instanceof cljs.core.Keyword))?G__71261.fqn:null);
switch (G__71261__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__71261__$1)].join('')));

}
});
