// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('alphabase.base64url');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('goog.crypt.base64');
alphabase.base64url.base64url_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.";
alphabase.base64url.base64url_set = cljs.core.set.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.");
/**
 * Converts a byte array into a base64URL string.
 */
alphabase.base64url.encode = (function alphabase$base64url$encode(ba){
return goog.crypt.base64.encodeByteArray(ba,goog.crypt.base64.Alphabet.WEBSAFE);
});
/**
 * Decodes a base64URL string into a byte array.
 */
alphabase.base64url.decode = (function alphabase$base64url$decode(b64url_string){
return goog.crypt.base64.decodeStringToByteArray(b64url_string);
});
alphabase.base64url.base64url_QMARK_ = (function alphabase$base64url$base64url_QMARK_(x){
return ((typeof x === 'string') && (clojure.set.subset_QMARK_.call(null,cljs.core.set.call(null,x),alphabase.base64url.base64url_set)));
});
