// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('alphabase.base58');
goog.require('cljs.core');
goog.require('alphabase.codec');
goog.require('clojure.set');
alphabase.base58.base58_chars = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
alphabase.base58.base58_set = cljs.core.set.call(null,"123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz");
/**
 * Test if input is base58.
 */
alphabase.base58.base58_QMARK_ = (function alphabase$base58$base58_QMARK_(x){
return ((typeof x === 'string') && (clojure.set.subset_QMARK_.call(null,cljs.core.set.call(null,x),alphabase.base58.base58_set)));
});
/**
 * Converts a byte array into a base58-check string.
 */
alphabase.base58.encode = (function alphabase$base58$encode(ba){
return alphabase.codec.encode.call(null,"123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz",ba);
});
/**
 * Decodes a base58-check string into a byte array.
 */
alphabase.base58.decode = (function alphabase$base58$decode(b58_string){
return alphabase.codec.decode.call(null,"123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz",b58_string);
});
