(ns alphabase.base32
  "Base32 lower case, no padding per rfc4648."
  (:require [alphabase.codec :as abc]
            [clojure.set :as set]))

#?(:clj (set! *warn-on-reflection* true))

(def ^:const base32-chars "abcdefghijklmnopqrstuvwxyz234567")
(def ^:const base32-set (set base32-chars))

(defn base32?
  "Test if input is base32."
  [x]
  (and (string? x) (set/subset? (set x) base32-set)))


(defn encode
  "Converts a byte array into a base32 string."
  ^String
  [ba]
  (abc/encode base32-chars ba))


(defn decode
  "Decodes a base32 string into a byte array."
  ^bytes
  [b32-string]
  (abc/decode base32-chars b32-string))

