// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__77492 = opts_SINGLEQUOTE_;
var map__77492__$1 = cljs.core.__destructure_map(map__77492);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77492__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__77494 = arguments.length;
switch (G__77494) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__77497 = arguments.length;
switch (G__77497) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__77500 = arguments.length;
switch (G__77500) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__77503 = arguments.length;
switch (G__77503) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__77506 = arguments.length;
switch (G__77506) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__77509 = arguments.length;
switch (G__77509) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___77518 = arguments.length;
var i__5770__auto___77519 = (0);
while(true){
if((i__5770__auto___77519 < len__5769__auto___77518)){
args__5775__auto__.push((arguments[i__5770__auto___77519]));

var G__77520 = (i__5770__auto___77519 + (1));
i__5770__auto___77519 = G__77520;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__77514){
var vec__77515 = p__77514;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77515,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq77511){
var G__77512 = cljs.core.first(seq77511);
var seq77511__$1 = cljs.core.next(seq77511);
var G__77513 = cljs.core.first(seq77511__$1);
var seq77511__$2 = cljs.core.next(seq77511__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__77512,G__77513,seq77511__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77542){
var state_val_77543 = (state_77542[(1)]);
if((state_val_77543 === (1))){
var state_77542__$1 = state_77542;
var statearr_77544_77559 = state_77542__$1;
(statearr_77544_77559[(2)] = null);

(statearr_77544_77559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77543 === (2))){
var _ = (function (){var statearr_77545 = state_77542;
(statearr_77545[(4)] = cljs.core.cons((5),(state_77542[(4)])));

return statearr_77545;
})();
var state_77542__$1 = state_77542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77542__$1,(6),db);
} else {
if((state_val_77543 === (3))){
var inst_77540 = (state_77542[(2)]);
var state_77542__$1 = state_77542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77542__$1,inst_77540);
} else {
if((state_val_77543 === (4))){
var inst_77521 = (state_77542[(2)]);
var inst_77522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77523 = [inst_77521];
var inst_77524 = (new cljs.core.PersistentVector(null,1,(5),inst_77522,inst_77523,null));
var inst_77525 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77524);
var inst_77526 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77521) : reject.call(null,inst_77521));
var state_77542__$1 = (function (){var statearr_77547 = state_77542;
(statearr_77547[(7)] = inst_77525);

return statearr_77547;
})();
var statearr_77548_77560 = state_77542__$1;
(statearr_77548_77560[(2)] = inst_77526);

(statearr_77548_77560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77543 === (5))){
var _ = (function (){var statearr_77549 = state_77542;
(statearr_77549[(4)] = cljs.core.rest((state_77542[(4)])));

return statearr_77549;
})();
var state_77542__$1 = state_77542;
var ex77546 = (state_77542__$1[(2)]);
var statearr_77550_77561 = state_77542__$1;
(statearr_77550_77561[(5)] = ex77546);


var statearr_77551_77562 = state_77542__$1;
(statearr_77551_77562[(1)] = (4));

(statearr_77551_77562[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77543 === (6))){
var inst_77533 = (state_77542[(2)]);
var inst_77534 = fluree.db.util.async.throw_err(inst_77533);
var inst_77535 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_77534);
var inst_77536 = cljs.core.clj__GT_js(inst_77535);
var inst_77537 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77536) : resolve.call(null,inst_77536));
var _ = (function (){var statearr_77552 = state_77542;
(statearr_77552[(4)] = cljs.core.rest((state_77542[(4)])));

return statearr_77552;
})();
var state_77542__$1 = state_77542;
var statearr_77553_77563 = state_77542__$1;
(statearr_77553_77563[(2)] = inst_77537);

(statearr_77553_77563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2684__auto__ = null;
var flureedb$db_schema_$_state_machine__2684__auto____0 = (function (){
var statearr_77554 = [null,null,null,null,null,null,null,null];
(statearr_77554[(0)] = flureedb$db_schema_$_state_machine__2684__auto__);

(statearr_77554[(1)] = (1));

return statearr_77554;
});
var flureedb$db_schema_$_state_machine__2684__auto____1 = (function (state_77542){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77542);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77555){var ex__2687__auto__ = e77555;
var statearr_77556_77564 = state_77542;
(statearr_77556_77564[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77542[(4)]))){
var statearr_77557_77565 = state_77542;
(statearr_77557_77565[(1)] = cljs.core.first((state_77542[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77566 = state_77542;
state_77542 = G__77566;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2684__auto__ = function(state_77542){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2684__auto____1.call(this,state_77542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2684__auto____0;
flureedb$db_schema_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2684__auto____1;
return flureedb$db_schema_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77558 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77558[(6)] = c__2706__auto__);

return statearr_77558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__77568 = arguments.length;
switch (G__77568) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77641){
var state_val_77642 = (state_77641[(1)]);
if((state_val_77642 === (7))){
var inst_77584 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_77641__$1 = state_77641;
var statearr_77643_77688 = state_77641__$1;
(statearr_77643_77688[(2)] = inst_77584);

(statearr_77643_77688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (20))){
var inst_77592 = (state_77641[(7)]);
var inst_77616 = (state_77641[(2)]);
var state_77641__$1 = (function (){var statearr_77644 = state_77641;
(statearr_77644[(8)] = inst_77616);

return statearr_77644;
})();
if(cljs.core.truth_(inst_77592)){
var statearr_77645_77689 = state_77641__$1;
(statearr_77645_77689[(1)] = (21));

} else {
var statearr_77646_77690 = state_77641__$1;
(statearr_77646_77690[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (1))){
var state_77641__$1 = state_77641;
var statearr_77647_77691 = state_77641__$1;
(statearr_77647_77691[(2)] = null);

(statearr_77647_77691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (24))){
var inst_77623 = (state_77641[(2)]);
var inst_77624 = fluree.db.util.async.throw_err(inst_77623);
var state_77641__$1 = state_77641;
var statearr_77648_77692 = state_77641__$1;
(statearr_77648_77692[(2)] = inst_77624);

(statearr_77648_77692[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (4))){
var inst_77569 = (state_77641[(2)]);
var inst_77570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77571 = [inst_77569];
var inst_77572 = (new cljs.core.PersistentVector(null,1,(5),inst_77570,inst_77571,null));
var inst_77573 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77572);
var inst_77574 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77569) : reject.call(null,inst_77569));
var state_77641__$1 = (function (){var statearr_77649 = state_77641;
(statearr_77649[(9)] = inst_77573);

return statearr_77649;
})();
var statearr_77650_77693 = state_77641__$1;
(statearr_77650_77693[(2)] = inst_77574);

(statearr_77650_77693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (15))){
var inst_77605 = (state_77641[(10)]);
var inst_77607 = fluree.db.util.core.without_nils(inst_77605);
var inst_77608 = fluree.db.util.json.stringify(inst_77607);
var state_77641__$1 = state_77641;
var statearr_77651_77694 = state_77641__$1;
(statearr_77651_77694[(2)] = inst_77608);

(statearr_77651_77694[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (21))){
var inst_77616 = (state_77641[(8)]);
var inst_77611 = (state_77641[(11)]);
var inst_77618 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_77619 = [inst_77611,inst_77616];
var inst_77620 = cljs.core.PersistentHashMap.fromArrays(inst_77618,inst_77619);
var inst_77621 = fluree.db.operations.command_async(conn,inst_77620);
var state_77641__$1 = state_77641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77641__$1,(24),inst_77621);
} else {
if((state_val_77642 === (13))){
var inst_77593 = (state_77641[(12)]);
var inst_77600 = (inst_77593 + (30000));
var state_77641__$1 = state_77641;
var statearr_77652_77695 = state_77641__$1;
(statearr_77652_77695[(2)] = inst_77600);

(statearr_77652_77695[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (22))){
var inst_77605 = (state_77641[(10)]);
var inst_77626 = fluree.db.operations.unsigned_command_async(conn,inst_77605);
var state_77641__$1 = state_77641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77641__$1,(25),inst_77626);
} else {
if((state_val_77642 === (6))){
var state_77641__$1 = state_77641;
var statearr_77653_77696 = state_77641__$1;
(statearr_77653_77696[(2)] = null);

(statearr_77653_77696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (25))){
var inst_77628 = (state_77641[(2)]);
var inst_77629 = fluree.db.util.async.throw_err(inst_77628);
var state_77641__$1 = state_77641;
var statearr_77654_77697 = state_77641__$1;
(statearr_77654_77697[(2)] = inst_77629);

(statearr_77654_77697[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (17))){
var inst_77592 = (state_77641[(7)]);
var inst_77611 = (state_77641[(2)]);
var state_77641__$1 = (function (){var statearr_77655 = state_77641;
(statearr_77655[(11)] = inst_77611);

return statearr_77655;
})();
if(cljs.core.truth_(inst_77592)){
var statearr_77656_77698 = state_77641__$1;
(statearr_77656_77698[(1)] = (18));

} else {
var statearr_77657_77699 = state_77641__$1;
(statearr_77657_77699[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (3))){
var inst_77639 = (state_77641[(2)]);
var state_77641__$1 = state_77641;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77641__$1,inst_77639);
} else {
if((state_val_77642 === (12))){
var inst_77590 = (state_77641[(13)]);
var state_77641__$1 = state_77641;
var statearr_77658_77700 = state_77641__$1;
(statearr_77658_77700[(2)] = inst_77590);

(statearr_77658_77700[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (2))){
var _ = (function (){var statearr_77659 = state_77641;
(statearr_77659[(4)] = cljs.core.cons((5),(state_77641[(4)])));

return statearr_77659;
})();
var inst_77581 = (opts == null);
var state_77641__$1 = state_77641;
if(cljs.core.truth_(inst_77581)){
var statearr_77660_77701 = state_77641__$1;
(statearr_77660_77701[(1)] = (6));

} else {
var statearr_77661_77702 = state_77641__$1;
(statearr_77661_77702[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (23))){
var inst_77631 = (state_77641[(2)]);
var inst_77632 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_77633 = [(200),inst_77631];
var inst_77634 = cljs.core.PersistentHashMap.fromArrays(inst_77632,inst_77633);
var inst_77635 = cljs.core.clj__GT_js(inst_77634);
var inst_77636 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77635) : resolve.call(null,inst_77635));
var _ = (function (){var statearr_77662 = state_77641;
(statearr_77662[(4)] = cljs.core.rest((state_77641[(4)])));

return statearr_77662;
})();
var state_77641__$1 = state_77641;
var statearr_77663_77703 = state_77641__$1;
(statearr_77663_77703[(2)] = inst_77636);

(statearr_77663_77703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (19))){
var state_77641__$1 = state_77641;
var statearr_77664_77704 = state_77641__$1;
(statearr_77664_77704[(2)] = null);

(statearr_77664_77704[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (11))){
var inst_77590 = (state_77641[(13)]);
var inst_77597 = (state_77641[(2)]);
var state_77641__$1 = (function (){var statearr_77666 = state_77641;
(statearr_77666[(14)] = inst_77597);

return statearr_77666;
})();
if(cljs.core.truth_(inst_77590)){
var statearr_77667_77705 = state_77641__$1;
(statearr_77667_77705[(1)] = (12));

} else {
var statearr_77668_77706 = state_77641__$1;
(statearr_77668_77706[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (9))){
var inst_77589 = (state_77641[(15)]);
var state_77641__$1 = state_77641;
var statearr_77669_77707 = state_77641__$1;
(statearr_77669_77707[(2)] = inst_77589);

(statearr_77669_77707[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (5))){
var _ = (function (){var statearr_77670 = state_77641;
(statearr_77670[(4)] = cljs.core.rest((state_77641[(4)])));

return statearr_77670;
})();
var state_77641__$1 = state_77641;
var ex77665 = (state_77641__$1[(2)]);
var statearr_77671_77708 = state_77641__$1;
(statearr_77671_77708[(5)] = ex77665);


var statearr_77672_77709 = state_77641__$1;
(statearr_77672_77709[(1)] = (4));

(statearr_77672_77709[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (14))){
var inst_77597 = (state_77641[(14)]);
var inst_77592 = (state_77641[(7)]);
var inst_77602 = (state_77641[(2)]);
var inst_77603 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_77604 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_77597,inst_77602];
var inst_77605 = cljs.core.PersistentHashMap.fromArrays(inst_77603,inst_77604);
var state_77641__$1 = (function (){var statearr_77673 = state_77641;
(statearr_77673[(10)] = inst_77605);

return statearr_77673;
})();
if(cljs.core.truth_(inst_77592)){
var statearr_77674_77710 = state_77641__$1;
(statearr_77674_77710[(1)] = (15));

} else {
var statearr_77675_77711 = state_77641__$1;
(statearr_77675_77711[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (16))){
var state_77641__$1 = state_77641;
var statearr_77676_77712 = state_77641__$1;
(statearr_77676_77712[(2)] = null);

(statearr_77676_77712[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (10))){
var inst_77593 = (state_77641[(12)]);
var state_77641__$1 = state_77641;
var statearr_77677_77713 = state_77641__$1;
(statearr_77677_77713[(2)] = inst_77593);

(statearr_77677_77713[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (18))){
var inst_77611 = (state_77641[(11)]);
var inst_77592 = (state_77641[(7)]);
var inst_77613 = fluree.crypto.sign_message(inst_77611,inst_77592);
var state_77641__$1 = state_77641;
var statearr_77678_77714 = state_77641__$1;
(statearr_77678_77714[(2)] = inst_77613);

(statearr_77678_77714[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77642 === (8))){
var inst_77589 = (state_77641[(15)]);
var inst_77586 = (state_77641[(2)]);
var inst_77587 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_77586);
var inst_77588 = cljs.core.__destructure_map(inst_77586);
var inst_77589__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77588,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_77590 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77588,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_77591 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_77588,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_77592 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77588,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_77593 = fluree.db.util.core.current_time_millis();
var state_77641__$1 = (function (){var statearr_77679 = state_77641;
(statearr_77679[(16)] = inst_77587);

(statearr_77679[(12)] = inst_77593);

(statearr_77679[(13)] = inst_77590);

(statearr_77679[(7)] = inst_77592);

(statearr_77679[(17)] = inst_77591);

(statearr_77679[(15)] = inst_77589__$1);

return statearr_77679;
})();
if(cljs.core.truth_(inst_77589__$1)){
var statearr_77680_77715 = state_77641__$1;
(statearr_77680_77715[(1)] = (9));

} else {
var statearr_77681_77716 = state_77641__$1;
(statearr_77681_77716[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_77682 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77682[(0)] = flureedb$state_machine__2684__auto__);

(statearr_77682[(1)] = (1));

return statearr_77682;
});
var flureedb$state_machine__2684__auto____1 = (function (state_77641){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77641);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77683){var ex__2687__auto__ = e77683;
var statearr_77684_77717 = state_77641;
(statearr_77684_77717[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77641[(4)]))){
var statearr_77685_77718 = state_77641;
(statearr_77685_77718[(1)] = cljs.core.first((state_77641[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77719 = state_77641;
state_77641 = G__77719;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_77641){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_77641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77686 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77686[(6)] = c__2706__auto__);

return statearr_77686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77741){
var state_val_77742 = (state_77741[(1)]);
if((state_val_77742 === (1))){
var state_77741__$1 = state_77741;
var statearr_77743_77758 = state_77741__$1;
(statearr_77743_77758[(2)] = null);

(statearr_77743_77758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77742 === (2))){
var _ = (function (){var statearr_77744 = state_77741;
(statearr_77744[(4)] = cljs.core.cons((5),(state_77741[(4)])));

return statearr_77744;
})();
var inst_77731 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_77741__$1 = state_77741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77741__$1,(6),inst_77731);
} else {
if((state_val_77742 === (3))){
var inst_77739 = (state_77741[(2)]);
var state_77741__$1 = state_77741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77741__$1,inst_77739);
} else {
if((state_val_77742 === (4))){
var inst_77720 = (state_77741[(2)]);
var inst_77721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77722 = [inst_77720];
var inst_77723 = (new cljs.core.PersistentVector(null,1,(5),inst_77721,inst_77722,null));
var inst_77724 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77723);
var inst_77725 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77720) : reject.call(null,inst_77720));
var state_77741__$1 = (function (){var statearr_77746 = state_77741;
(statearr_77746[(7)] = inst_77724);

return statearr_77746;
})();
var statearr_77747_77759 = state_77741__$1;
(statearr_77747_77759[(2)] = inst_77725);

(statearr_77747_77759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77742 === (5))){
var _ = (function (){var statearr_77748 = state_77741;
(statearr_77748[(4)] = cljs.core.rest((state_77741[(4)])));

return statearr_77748;
})();
var state_77741__$1 = state_77741;
var ex77745 = (state_77741__$1[(2)]);
var statearr_77749_77760 = state_77741__$1;
(statearr_77749_77760[(5)] = ex77745);


var statearr_77750_77761 = state_77741__$1;
(statearr_77750_77761[(1)] = (4));

(statearr_77750_77761[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77742 === (6))){
var inst_77733 = (state_77741[(2)]);
var inst_77734 = fluree.db.util.async.throw_err(inst_77733);
var inst_77735 = cljs.core.clj__GT_js(inst_77734);
var inst_77736 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77735) : resolve.call(null,inst_77735));
var _ = (function (){var statearr_77751 = state_77741;
(statearr_77751[(4)] = cljs.core.rest((state_77741[(4)])));

return statearr_77751;
})();
var state_77741__$1 = state_77741;
var statearr_77752_77762 = state_77741__$1;
(statearr_77752_77762[(2)] = inst_77736);

(statearr_77752_77762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2684__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2684__auto____0 = (function (){
var statearr_77753 = [null,null,null,null,null,null,null,null];
(statearr_77753[(0)] = flureedb$ledger_stats_$_state_machine__2684__auto__);

(statearr_77753[(1)] = (1));

return statearr_77753;
});
var flureedb$ledger_stats_$_state_machine__2684__auto____1 = (function (state_77741){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77741);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77754){var ex__2687__auto__ = e77754;
var statearr_77755_77763 = state_77741;
(statearr_77755_77763[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77741[(4)]))){
var statearr_77756_77764 = state_77741;
(statearr_77756_77764[(1)] = cljs.core.first((state_77741[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77765 = state_77741;
state_77741 = G__77765;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2684__auto__ = function(state_77741){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2684__auto____1.call(this,state_77741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2684__auto____0;
flureedb$ledger_stats_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2684__auto____1;
return flureedb$ledger_stats_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77757 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77757[(6)] = c__2706__auto__);

return statearr_77757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than ledger-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not ledger-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the ledger-id, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__77767 = arguments.length;
switch (G__77767) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_77894){
var state_val_77895 = (state_77894[(1)]);
if((state_val_77895 === (7))){
var inst_77793 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_77894__$1 = state_77894;
var statearr_77896_77966 = state_77894__$1;
(statearr_77896_77966[(2)] = inst_77793);

(statearr_77896_77966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (20))){
var inst_77800 = (state_77894[(7)]);
var inst_77839 = (state_77894[(2)]);
var inst_77840 = fluree.db.util.core.current_time_millis();
var state_77894__$1 = (function (){var statearr_77897 = state_77894;
(statearr_77897[(8)] = inst_77840);

(statearr_77897[(9)] = inst_77839);

return statearr_77897;
})();
if(cljs.core.truth_(inst_77800)){
var statearr_77898_77967 = state_77894__$1;
(statearr_77898_77967[(1)] = (21));

} else {
var statearr_77899_77968 = state_77894__$1;
(statearr_77899_77968[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (27))){
var inst_77808 = (state_77894[(10)]);
var inst_77853 = (state_77894[(11)]);
var inst_77855 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_77853,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_77808);
var state_77894__$1 = state_77894;
var statearr_77900_77969 = state_77894__$1;
(statearr_77900_77969[(2)] = inst_77855);

(statearr_77900_77969[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (1))){
var state_77894__$1 = state_77894;
var statearr_77901_77970 = state_77894__$1;
(statearr_77901_77970[(2)] = null);

(statearr_77901_77970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (24))){
var inst_77806 = (state_77894[(12)]);
var state_77894__$1 = state_77894;
var statearr_77902_77971 = state_77894__$1;
(statearr_77902_77971[(2)] = inst_77806);

(statearr_77902_77971[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (39))){
var inst_77876 = (state_77894[(2)]);
var inst_77877 = fluree.db.util.async.throw_err(inst_77876);
var state_77894__$1 = state_77894;
var statearr_77903_77972 = state_77894__$1;
(statearr_77903_77972[(2)] = inst_77877);

(statearr_77903_77972[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (4))){
var inst_77768 = (state_77894[(2)]);
var inst_77769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77770 = [inst_77768];
var inst_77771 = (new cljs.core.PersistentVector(null,1,(5),inst_77769,inst_77770,null));
var inst_77772 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77771);
var inst_77773 = cljs.core.ex_data(inst_77768);
var inst_77774 = cljs.core.ex_message(inst_77768);
var inst_77775 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_77773,new cljs.core.Keyword(null,"message","message",-406056002),inst_77774);
var inst_77776 = cljs.core.clj__GT_js(inst_77775);
var inst_77777 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77776) : reject.call(null,inst_77776));
var state_77894__$1 = (function (){var statearr_77904 = state_77894;
(statearr_77904[(13)] = inst_77772);

return statearr_77904;
})();
var statearr_77905_77973 = state_77894__$1;
(statearr_77905_77973[(2)] = inst_77777);

(statearr_77905_77973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (15))){
var inst_77829 = (state_77894[(14)]);
var inst_77831 = fluree.db.graphdb.validate_ledger_name(inst_77829,"alias");
var state_77894__$1 = state_77894;
var statearr_77906_77974 = state_77894__$1;
(statearr_77906_77974[(2)] = inst_77831);

(statearr_77906_77974[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (21))){
var inst_77800 = (state_77894[(7)]);
var state_77894__$1 = state_77894;
var statearr_77907_77975 = state_77894__$1;
(statearr_77907_77975[(2)] = inst_77800);

(statearr_77907_77975[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (31))){
var state_77894__$1 = state_77894;
var statearr_77908_77976 = state_77894__$1;
(statearr_77908_77976[(2)] = null);

(statearr_77908_77976[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (32))){
var inst_77802 = (state_77894[(15)]);
var inst_77864 = (state_77894[(2)]);
var state_77894__$1 = (function (){var statearr_77909 = state_77894;
(statearr_77909[(16)] = inst_77864);

return statearr_77909;
})();
if(cljs.core.truth_(inst_77802)){
var statearr_77910_77977 = state_77894__$1;
(statearr_77910_77977[(1)] = (33));

} else {
var statearr_77911_77978 = state_77894__$1;
(statearr_77911_77978[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (40))){
var inst_77881 = (state_77894[(2)]);
var inst_77882 = fluree.db.util.async.throw_err(inst_77881);
var state_77894__$1 = state_77894;
var statearr_77912_77979 = state_77894__$1;
(statearr_77912_77979[(2)] = inst_77882);

(statearr_77912_77979[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (33))){
var inst_77864 = (state_77894[(16)]);
var inst_77802 = (state_77894[(15)]);
var inst_77866 = fluree.crypto.sign_message(inst_77864,inst_77802);
var state_77894__$1 = state_77894;
var statearr_77913_77980 = state_77894__$1;
(statearr_77913_77980[(2)] = inst_77866);

(statearr_77913_77980[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (13))){
var state_77894__$1 = state_77894;
var statearr_77914_77981 = state_77894__$1;
(statearr_77914_77981[(2)] = null);

(statearr_77914_77981[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (22))){
var inst_77840 = (state_77894[(8)]);
var state_77894__$1 = state_77894;
var statearr_77915_77982 = state_77894__$1;
(statearr_77915_77982[(2)] = inst_77840);

(statearr_77915_77982[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (36))){
var inst_77864 = (state_77894[(16)]);
var inst_77869 = (state_77894[(17)]);
var inst_77871 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_77872 = [inst_77864,inst_77869];
var inst_77873 = cljs.core.PersistentHashMap.fromArrays(inst_77871,inst_77872);
var inst_77874 = fluree.db.operations.command_async(conn,inst_77873);
var state_77894__$1 = state_77894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77894__$1,(39),inst_77874);
} else {
if((state_val_77895 === (29))){
var inst_77802 = (state_77894[(15)]);
var inst_77858 = (state_77894[(2)]);
var state_77894__$1 = (function (){var statearr_77916 = state_77894;
(statearr_77916[(18)] = inst_77858);

return statearr_77916;
})();
if(cljs.core.truth_(inst_77802)){
var statearr_77917_77983 = state_77894__$1;
(statearr_77917_77983[(1)] = (30));

} else {
var statearr_77918_77984 = state_77894__$1;
(statearr_77918_77984[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (6))){
var state_77894__$1 = state_77894;
var statearr_77919_77985 = state_77894__$1;
(statearr_77919_77985[(2)] = null);

(statearr_77919_77985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (28))){
var inst_77853 = (state_77894[(11)]);
var state_77894__$1 = state_77894;
var statearr_77920_77986 = state_77894__$1;
(statearr_77920_77986[(2)] = inst_77853);

(statearr_77920_77986[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (25))){
var inst_77840 = (state_77894[(8)]);
var inst_77847 = (inst_77840 + (30000));
var state_77894__$1 = state_77894;
var statearr_77921_77987 = state_77894__$1;
(statearr_77921_77987[(2)] = inst_77847);

(statearr_77921_77987[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (34))){
var state_77894__$1 = state_77894;
var statearr_77922_77988 = state_77894__$1;
(statearr_77922_77988[(2)] = null);

(statearr_77922_77988[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (17))){
var inst_77810 = (state_77894[(19)]);
var inst_77834 = (state_77894[(2)]);
var state_77894__$1 = (function (){var statearr_77923 = state_77894;
(statearr_77923[(20)] = inst_77834);

return statearr_77923;
})();
if(cljs.core.truth_(inst_77810)){
var statearr_77924_77989 = state_77894__$1;
(statearr_77924_77989[(1)] = (18));

} else {
var statearr_77925_77990 = state_77894__$1;
(statearr_77925_77990[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (3))){
var inst_77892 = (state_77894[(2)]);
var state_77894__$1 = state_77894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77894__$1,inst_77892);
} else {
if((state_val_77895 === (12))){
var inst_77824 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_77894__$1 = state_77894;
var statearr_77926_77991 = state_77894__$1;
(statearr_77926_77991[(2)] = inst_77824);

(statearr_77926_77991[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (2))){
var _ = (function (){var statearr_77927 = state_77894;
(statearr_77927[(4)] = cljs.core.cons((5),(state_77894[(4)])));

return statearr_77927;
})();
var inst_77790 = (opts == null);
var state_77894__$1 = state_77894;
if(cljs.core.truth_(inst_77790)){
var statearr_77928_77992 = state_77894__$1;
(statearr_77928_77992[(1)] = (6));

} else {
var statearr_77929_77993 = state_77894__$1;
(statearr_77929_77993[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (23))){
var inst_77806 = (state_77894[(12)]);
var inst_77844 = (state_77894[(2)]);
var state_77894__$1 = (function (){var statearr_77930 = state_77894;
(statearr_77930[(21)] = inst_77844);

return statearr_77930;
})();
if(cljs.core.truth_(inst_77806)){
var statearr_77931_77994 = state_77894__$1;
(statearr_77931_77994[(1)] = (24));

} else {
var statearr_77932_77995 = state_77894__$1;
(statearr_77932_77995[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (35))){
var inst_77802 = (state_77894[(15)]);
var inst_77869 = (state_77894[(2)]);
var state_77894__$1 = (function (){var statearr_77933 = state_77894;
(statearr_77933[(17)] = inst_77869);

return statearr_77933;
})();
if(cljs.core.truth_(inst_77802)){
var statearr_77934_77996 = state_77894__$1;
(statearr_77934_77996[(1)] = (36));

} else {
var statearr_77935_77997 = state_77894__$1;
(statearr_77935_77997[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (19))){
var state_77894__$1 = state_77894;
var statearr_77936_77998 = state_77894__$1;
(statearr_77936_77998[(2)] = null);

(statearr_77936_77998[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (11))){
var inst_77813 = (state_77894[(22)]);
var inst_77810 = (state_77894[(19)]);
var inst_77820 = (state_77894[(23)]);
var inst_77820__$1 = (state_77894[(2)]);
var inst_77821 = fluree.db.graphdb.validate_ledger_name(inst_77820__$1,"ledger");
var inst_77822 = fluree.db.graphdb.validate_ledger_name(inst_77813,"network");
var state_77894__$1 = (function (){var statearr_77938 = state_77894;
(statearr_77938[(24)] = inst_77822);

(statearr_77938[(25)] = inst_77821);

(statearr_77938[(23)] = inst_77820__$1);

return statearr_77938;
})();
if(cljs.core.truth_(inst_77810)){
var statearr_77939_77999 = state_77894__$1;
(statearr_77939_77999[(1)] = (12));

} else {
var statearr_77940_78000 = state_77894__$1;
(statearr_77940_78000[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (9))){
var inst_77814 = (state_77894[(26)]);
var inst_77817 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_77814,(1));
var state_77894__$1 = state_77894;
var statearr_77941_78001 = state_77894__$1;
(statearr_77941_78001[(2)] = inst_77817);

(statearr_77941_78001[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (5))){
var _ = (function (){var statearr_77942 = state_77894;
(statearr_77942[(4)] = cljs.core.rest((state_77894[(4)])));

return statearr_77942;
})();
var state_77894__$1 = state_77894;
var ex77937 = (state_77894__$1[(2)]);
var statearr_77943_78002 = state_77894__$1;
(statearr_77943_78002[(5)] = ex77937);


var statearr_77944_78003 = state_77894__$1;
(statearr_77944_78003[(1)] = (4));

(statearr_77944_78003[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (14))){
var inst_77810 = (state_77894[(19)]);
var inst_77827 = (state_77894[(2)]);
var inst_77828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77827,(0),null);
var inst_77829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77827,(1),null);
var state_77894__$1 = (function (){var statearr_77945 = state_77894;
(statearr_77945[(27)] = inst_77828);

(statearr_77945[(14)] = inst_77829);

return statearr_77945;
})();
if(cljs.core.truth_(inst_77810)){
var statearr_77946_78004 = state_77894__$1;
(statearr_77946_78004[(1)] = (15));

} else {
var statearr_77947_78005 = state_77894__$1;
(statearr_77947_78005[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (26))){
var inst_77811 = (state_77894[(28)]);
var inst_77809 = (state_77894[(29)]);
var inst_77813 = (state_77894[(22)]);
var inst_77844 = (state_77894[(21)]);
var inst_77808 = (state_77894[(10)]);
var inst_77799 = (state_77894[(30)]);
var inst_77804 = (state_77894[(31)]);
var inst_77807 = (state_77894[(32)]);
var inst_77801 = (state_77894[(33)]);
var inst_77805 = (state_77894[(34)]);
var inst_77803 = (state_77894[(35)]);
var inst_77820 = (state_77894[(23)]);
var inst_77839 = (state_77894[(9)]);
var inst_77849 = (state_77894[(2)]);
var inst_77850 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_77851 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77813),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77820)].join('');
var inst_77852 = [inst_77851,inst_77804,inst_77805,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_77849,inst_77807,inst_77839,inst_77811,inst_77809,inst_77799,inst_77844,inst_77801,inst_77803];
var inst_77853 = cljs.core.PersistentHashMap.fromArrays(inst_77850,inst_77852);
var state_77894__$1 = (function (){var statearr_77948 = state_77894;
(statearr_77948[(11)] = inst_77853);

return statearr_77948;
})();
if(cljs.core.truth_(inst_77808)){
var statearr_77949_78006 = state_77894__$1;
(statearr_77949_78006[(1)] = (27));

} else {
var statearr_77950_78007 = state_77894__$1;
(statearr_77950_78007[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (16))){
var state_77894__$1 = state_77894;
var statearr_77951_78008 = state_77894__$1;
(statearr_77951_78008[(2)] = null);

(statearr_77951_78008[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (38))){
var inst_77884 = (state_77894[(2)]);
var inst_77885 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_77886 = [(200),inst_77884];
var inst_77887 = cljs.core.PersistentHashMap.fromArrays(inst_77885,inst_77886);
var inst_77888 = cljs.core.clj__GT_js(inst_77887);
var inst_77889 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77888) : resolve.call(null,inst_77888));
var _ = (function (){var statearr_77952 = state_77894;
(statearr_77952[(4)] = cljs.core.rest((state_77894[(4)])));

return statearr_77952;
})();
var state_77894__$1 = state_77894;
var statearr_77953_78009 = state_77894__$1;
(statearr_77953_78009[(2)] = inst_77889);

(statearr_77953_78009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (30))){
var inst_77858 = (state_77894[(18)]);
var inst_77860 = fluree.db.util.core.without_nils(inst_77858);
var inst_77861 = fluree.db.util.json.stringify(inst_77860);
var state_77894__$1 = state_77894;
var statearr_77954_78010 = state_77894__$1;
(statearr_77954_78010[(2)] = inst_77861);

(statearr_77954_78010[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (10))){
var inst_77814 = (state_77894[(26)]);
var state_77894__$1 = state_77894;
var statearr_77955_78011 = state_77894__$1;
(statearr_77955_78011[(2)] = inst_77814);

(statearr_77955_78011[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (18))){
var inst_77828 = (state_77894[(27)]);
var inst_77829 = (state_77894[(14)]);
var inst_77836 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77828),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77829)].join('');
var state_77894__$1 = state_77894;
var statearr_77956_78012 = state_77894__$1;
(statearr_77956_78012[(2)] = inst_77836);

(statearr_77956_78012[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77895 === (37))){
var inst_77858 = (state_77894[(18)]);
var inst_77879 = fluree.db.operations.unsigned_command_async(conn,inst_77858);
var state_77894__$1 = state_77894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77894__$1,(40),inst_77879);
} else {
if((state_val_77895 === (8))){
var inst_77814 = (state_77894[(26)]);
var inst_77795 = (state_77894[(2)]);
var inst_77796 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_77795);
var inst_77797 = cljs.core.__destructure_map(inst_77795);
var inst_77798 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_77797,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_77799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_77800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_77801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_77802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_77803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_77804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_77805 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_77806 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_77807 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_77808 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_77809 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_77810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_77811 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_77797,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_77812 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_77813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77812,(0),null);
var inst_77814__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77812,(1),null);
var inst_77815 = clojure.string.starts_with_QMARK_(inst_77814__$1,"$");
var state_77894__$1 = (function (){var statearr_77957 = state_77894;
(statearr_77957[(28)] = inst_77811);

(statearr_77957[(29)] = inst_77809);

(statearr_77957[(22)] = inst_77813);

(statearr_77957[(10)] = inst_77808);

(statearr_77957[(30)] = inst_77799);

(statearr_77957[(31)] = inst_77804);

(statearr_77957[(32)] = inst_77807);

(statearr_77957[(33)] = inst_77801);

(statearr_77957[(26)] = inst_77814__$1);

(statearr_77957[(34)] = inst_77805);

(statearr_77957[(36)] = inst_77796);

(statearr_77957[(12)] = inst_77806);

(statearr_77957[(15)] = inst_77802);

(statearr_77957[(19)] = inst_77810);

(statearr_77957[(37)] = inst_77798);

(statearr_77957[(35)] = inst_77803);

(statearr_77957[(7)] = inst_77800);

return statearr_77957;
})();
if(inst_77815){
var statearr_77958_78013 = state_77894__$1;
(statearr_77958_78013[(1)] = (9));

} else {
var statearr_77959_78014 = state_77894__$1;
(statearr_77959_78014[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_77960 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77960[(0)] = flureedb$state_machine__2684__auto__);

(statearr_77960[(1)] = (1));

return statearr_77960;
});
var flureedb$state_machine__2684__auto____1 = (function (state_77894){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_77894);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e77961){var ex__2687__auto__ = e77961;
var statearr_77962_78015 = state_77894;
(statearr_77962_78015[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_77894[(4)]))){
var statearr_77963_78016 = state_77894;
(statearr_77963_78016[(1)] = cljs.core.first((state_77894[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78017 = state_77894;
state_77894 = G__78017;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_77894){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_77894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_77964 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_77964[(6)] = c__2706__auto__);

return statearr_77964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78040){
var state_val_78041 = (state_78040[(1)]);
if((state_val_78041 === (1))){
var state_78040__$1 = state_78040;
var statearr_78042_78058 = state_78040__$1;
(statearr_78042_78058[(2)] = null);

(statearr_78042_78058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78041 === (2))){
var _ = (function (){var statearr_78043 = state_78040;
(statearr_78043[(4)] = cljs.core.cons((5),(state_78040[(4)])));

return statearr_78043;
})();
var inst_78030 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_78031 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_78040__$1 = (function (){var statearr_78044 = state_78040;
(statearr_78044[(7)] = inst_78030);

return statearr_78044;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78040__$1,(6),inst_78031);
} else {
if((state_val_78041 === (3))){
var inst_78038 = (state_78040[(2)]);
var state_78040__$1 = state_78040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78040__$1,inst_78038);
} else {
if((state_val_78041 === (4))){
var inst_78018 = (state_78040[(2)]);
var inst_78019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78020 = [inst_78018];
var inst_78021 = (new cljs.core.PersistentVector(null,1,(5),inst_78019,inst_78020,null));
var inst_78022 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78021);
var inst_78023 = cljs.core.clj__GT_js(inst_78018);
var inst_78024 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78023) : reject.call(null,inst_78023));
var state_78040__$1 = (function (){var statearr_78046 = state_78040;
(statearr_78046[(8)] = inst_78022);

return statearr_78046;
})();
var statearr_78047_78059 = state_78040__$1;
(statearr_78047_78059[(2)] = inst_78024);

(statearr_78047_78059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78041 === (5))){
var _ = (function (){var statearr_78048 = state_78040;
(statearr_78048[(4)] = cljs.core.rest((state_78040[(4)])));

return statearr_78048;
})();
var state_78040__$1 = state_78040;
var ex78045 = (state_78040__$1[(2)]);
var statearr_78049_78060 = state_78040__$1;
(statearr_78049_78060[(5)] = ex78045);


var statearr_78050_78061 = state_78040__$1;
(statearr_78050_78061[(1)] = (4));

(statearr_78050_78061[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78041 === (6))){
var inst_78033 = (state_78040[(2)]);
var inst_78034 = cljs.core.clj__GT_js(inst_78033);
var inst_78035 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78034) : resolve.call(null,inst_78034));
var _ = (function (){var statearr_78051 = state_78040;
(statearr_78051[(4)] = cljs.core.rest((state_78040[(4)])));

return statearr_78051;
})();
var state_78040__$1 = state_78040;
var statearr_78052_78062 = state_78040__$1;
(statearr_78052_78062[(2)] = inst_78035);

(statearr_78052_78062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2684__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2684__auto____0 = (function (){
var statearr_78053 = [null,null,null,null,null,null,null,null,null];
(statearr_78053[(0)] = flureedb$monitor_tx_$_state_machine__2684__auto__);

(statearr_78053[(1)] = (1));

return statearr_78053;
});
var flureedb$monitor_tx_$_state_machine__2684__auto____1 = (function (state_78040){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78040);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78054){var ex__2687__auto__ = e78054;
var statearr_78055_78063 = state_78040;
(statearr_78055_78063[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78040[(4)]))){
var statearr_78056_78064 = state_78040;
(statearr_78056_78064[(1)] = cljs.core.first((state_78040[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78065 = state_78040;
state_78040 = G__78065;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2684__auto__ = function(state_78040){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2684__auto____1.call(this,state_78040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2684__auto____0;
flureedb$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2684__auto____1;
return flureedb$monitor_tx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78057 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78057[(6)] = c__2706__auto__);

return statearr_78057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__78067 = arguments.length;
switch (G__78067) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78096){
var state_val_78097 = (state_78096[(1)]);
if((state_val_78097 === (7))){
var inst_78082 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78096__$1 = state_78096;
var statearr_78098_78119 = state_78096__$1;
(statearr_78098_78119[(2)] = inst_78082);

(statearr_78098_78119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78097 === (1))){
var state_78096__$1 = state_78096;
var statearr_78099_78120 = state_78096__$1;
(statearr_78099_78120[(2)] = null);

(statearr_78099_78120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78097 === (4))){
var inst_78068 = (state_78096[(2)]);
var inst_78069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78070 = [inst_78068];
var inst_78071 = (new cljs.core.PersistentVector(null,1,(5),inst_78069,inst_78070,null));
var inst_78072 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78071);
var inst_78073 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78068) : reject.call(null,inst_78068));
var state_78096__$1 = (function (){var statearr_78100 = state_78096;
(statearr_78100[(7)] = inst_78072);

return statearr_78100;
})();
var statearr_78101_78121 = state_78096__$1;
(statearr_78101_78121[(2)] = inst_78073);

(statearr_78101_78121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78097 === (6))){
var state_78096__$1 = state_78096;
var statearr_78102_78122 = state_78096__$1;
(statearr_78102_78122[(2)] = null);

(statearr_78102_78122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78097 === (3))){
var inst_78094 = (state_78096[(2)]);
var state_78096__$1 = state_78096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78096__$1,inst_78094);
} else {
if((state_val_78097 === (2))){
var _ = (function (){var statearr_78104 = state_78096;
(statearr_78104[(4)] = cljs.core.cons((5),(state_78096[(4)])));

return statearr_78104;
})();
var inst_78079 = (opts == null);
var state_78096__$1 = state_78096;
if(cljs.core.truth_(inst_78079)){
var statearr_78105_78123 = state_78096__$1;
(statearr_78105_78123[(1)] = (6));

} else {
var statearr_78106_78124 = state_78096__$1;
(statearr_78106_78124[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78097 === (9))){
var inst_78089 = (state_78096[(2)]);
var inst_78090 = cljs.core.clj__GT_js(inst_78089);
var inst_78091 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78090) : resolve.call(null,inst_78090));
var _ = (function (){var statearr_78107 = state_78096;
(statearr_78107[(4)] = cljs.core.rest((state_78096[(4)])));

return statearr_78107;
})();
var state_78096__$1 = state_78096;
var statearr_78108_78125 = state_78096__$1;
(statearr_78108_78125[(2)] = inst_78091);

(statearr_78108_78125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78097 === (5))){
var _ = (function (){var statearr_78109 = state_78096;
(statearr_78109[(4)] = cljs.core.rest((state_78096[(4)])));

return statearr_78109;
})();
var state_78096__$1 = state_78096;
var ex78103 = (state_78096__$1[(2)]);
var statearr_78110_78126 = state_78096__$1;
(statearr_78110_78126[(5)] = ex78103);


var statearr_78111_78127 = state_78096__$1;
(statearr_78111_78127[(1)] = (4));

(statearr_78111_78127[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78097 === (8))){
var inst_78084 = (state_78096[(2)]);
var inst_78085 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_78084);
var inst_78086 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78087 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_78086,inst_78084);
var state_78096__$1 = (function (){var statearr_78112 = state_78096;
(statearr_78112[(8)] = inst_78085);

return statearr_78112;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78096__$1,(9),inst_78087);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_78113 = [null,null,null,null,null,null,null,null,null];
(statearr_78113[(0)] = flureedb$state_machine__2684__auto__);

(statearr_78113[(1)] = (1));

return statearr_78113;
});
var flureedb$state_machine__2684__auto____1 = (function (state_78096){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78096);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78114){var ex__2687__auto__ = e78114;
var statearr_78115_78128 = state_78096;
(statearr_78115_78128[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78096[(4)]))){
var statearr_78116_78129 = state_78096;
(statearr_78116_78129[(1)] = cljs.core.first((state_78096[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78130 = state_78096;
state_78096 = G__78130;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_78096){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_78096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78117 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78117[(6)] = c__2706__auto__);

return statearr_78117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__78132 = arguments.length;
switch (G__78132) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78164){
var state_val_78165 = (state_78164[(1)]);
if((state_val_78165 === (7))){
var inst_78147 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78164__$1 = state_78164;
var statearr_78166_78187 = state_78164__$1;
(statearr_78166_78187[(2)] = inst_78147);

(statearr_78166_78187[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78165 === (1))){
var state_78164__$1 = state_78164;
var statearr_78167_78188 = state_78164__$1;
(statearr_78167_78188[(2)] = null);

(statearr_78167_78188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78165 === (4))){
var inst_78133 = (state_78164[(2)]);
var inst_78134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78135 = [inst_78133];
var inst_78136 = (new cljs.core.PersistentVector(null,1,(5),inst_78134,inst_78135,null));
var inst_78137 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78136);
var inst_78138 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78133) : reject.call(null,inst_78133));
var state_78164__$1 = (function (){var statearr_78168 = state_78164;
(statearr_78168[(7)] = inst_78137);

return statearr_78168;
})();
var statearr_78169_78189 = state_78164__$1;
(statearr_78169_78189[(2)] = inst_78138);

(statearr_78169_78189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78165 === (6))){
var state_78164__$1 = state_78164;
var statearr_78170_78190 = state_78164__$1;
(statearr_78170_78190[(2)] = null);

(statearr_78170_78190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78165 === (3))){
var inst_78162 = (state_78164[(2)]);
var state_78164__$1 = state_78164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78164__$1,inst_78162);
} else {
if((state_val_78165 === (2))){
var _ = (function (){var statearr_78172 = state_78164;
(statearr_78172[(4)] = cljs.core.cons((5),(state_78164[(4)])));

return statearr_78172;
})();
var inst_78144 = (opts == null);
var state_78164__$1 = state_78164;
if(cljs.core.truth_(inst_78144)){
var statearr_78173_78191 = state_78164__$1;
(statearr_78173_78191[(1)] = (6));

} else {
var statearr_78174_78192 = state_78164__$1;
(statearr_78174_78192[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78165 === (9))){
var inst_78149 = (state_78164[(8)]);
var inst_78152 = (state_78164[(2)]);
var inst_78153 = fluree.db.util.async.throw_err(inst_78152);
var inst_78154 = fluree.db.query.block.block_range(inst_78153,start,end,inst_78149);
var state_78164__$1 = state_78164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78164__$1,(10),inst_78154);
} else {
if((state_val_78165 === (5))){
var _ = (function (){var statearr_78175 = state_78164;
(statearr_78175[(4)] = cljs.core.rest((state_78164[(4)])));

return statearr_78175;
})();
var state_78164__$1 = state_78164;
var ex78171 = (state_78164__$1[(2)]);
var statearr_78176_78193 = state_78164__$1;
(statearr_78176_78193[(5)] = ex78171);


var statearr_78177_78194 = state_78164__$1;
(statearr_78177_78194[(1)] = (4));

(statearr_78177_78194[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78165 === (10))){
var inst_78156 = (state_78164[(2)]);
var inst_78157 = fluree.db.util.async.throw_err(inst_78156);
var inst_78158 = cljs.core.clj__GT_js(inst_78157);
var inst_78159 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78158) : resolve.call(null,inst_78158));
var _ = (function (){var statearr_78178 = state_78164;
(statearr_78178[(4)] = cljs.core.rest((state_78164[(4)])));

return statearr_78178;
})();
var state_78164__$1 = state_78164;
var statearr_78179_78195 = state_78164__$1;
(statearr_78179_78195[(2)] = inst_78159);

(statearr_78179_78195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78165 === (8))){
var inst_78149 = (state_78164[(8)]);
var inst_78149__$1 = (state_78164[(2)]);
var inst_78150 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78149__$1], 0));
var state_78164__$1 = (function (){var statearr_78180 = state_78164;
(statearr_78180[(8)] = inst_78149__$1);

return statearr_78180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78164__$1,(9),inst_78150);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_78181 = [null,null,null,null,null,null,null,null,null];
(statearr_78181[(0)] = flureedb$state_machine__2684__auto__);

(statearr_78181[(1)] = (1));

return statearr_78181;
});
var flureedb$state_machine__2684__auto____1 = (function (state_78164){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78164);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78182){var ex__2687__auto__ = e78182;
var statearr_78183_78196 = state_78164;
(statearr_78183_78196[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78164[(4)]))){
var statearr_78184_78197 = state_78164;
(statearr_78184_78197[(1)] = cljs.core.first((state_78164[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78198 = state_78164;
state_78164 = G__78198;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_78164){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_78164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78185 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78185[(6)] = c__2706__auto__);

return statearr_78185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__78200 = arguments.length;
switch (G__78200) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78238){
var state_val_78239 = (state_78238[(1)]);
if((state_val_78239 === (7))){
var inst_78216 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78238__$1 = state_78238;
var statearr_78240_78261 = state_78238__$1;
(statearr_78240_78261[(2)] = inst_78216);

(statearr_78240_78261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78239 === (1))){
var state_78238__$1 = state_78238;
var statearr_78241_78262 = state_78238__$1;
(statearr_78241_78262[(2)] = null);

(statearr_78241_78262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78239 === (4))){
var inst_78201 = (state_78238[(2)]);
var inst_78202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78203 = [inst_78201];
var inst_78204 = (new cljs.core.PersistentVector(null,1,(5),inst_78202,inst_78203,null));
var inst_78205 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78204);
var inst_78206 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78201) : reject.call(null,inst_78201));
var state_78238__$1 = (function (){var statearr_78242 = state_78238;
(statearr_78242[(7)] = inst_78205);

return statearr_78242;
})();
var statearr_78243_78263 = state_78238__$1;
(statearr_78243_78263[(2)] = inst_78206);

(statearr_78243_78263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78239 === (6))){
var state_78238__$1 = state_78238;
var statearr_78244_78264 = state_78238__$1;
(statearr_78244_78264[(2)] = null);

(statearr_78244_78264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78239 === (3))){
var inst_78236 = (state_78238[(2)]);
var state_78238__$1 = state_78238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78238__$1,inst_78236);
} else {
if((state_val_78239 === (2))){
var _ = (function (){var statearr_78246 = state_78238;
(statearr_78246[(4)] = cljs.core.cons((5),(state_78238[(4)])));

return statearr_78246;
})();
var inst_78213 = (opts == null);
var state_78238__$1 = state_78238;
if(cljs.core.truth_(inst_78213)){
var statearr_78247_78265 = state_78238__$1;
(statearr_78247_78265[(1)] = (6));

} else {
var statearr_78248_78266 = state_78238__$1;
(statearr_78248_78266[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78239 === (9))){
var inst_78218 = (state_78238[(8)]);
var inst_78221 = (state_78238[(9)]);
var inst_78222 = (state_78238[(10)]);
var inst_78225 = (state_78238[(2)]);
var inst_78226 = fluree.db.util.async.throw_err(inst_78225);
var inst_78227 = fluree.db.query.block.block_range(inst_78226,inst_78221,inst_78222,inst_78218);
var state_78238__$1 = state_78238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78238__$1,(10),inst_78227);
} else {
if((state_val_78239 === (5))){
var _ = (function (){var statearr_78249 = state_78238;
(statearr_78249[(4)] = cljs.core.rest((state_78238[(4)])));

return statearr_78249;
})();
var state_78238__$1 = state_78238;
var ex78245 = (state_78238__$1[(2)]);
var statearr_78250_78267 = state_78238__$1;
(statearr_78250_78267[(5)] = ex78245);


var statearr_78251_78268 = state_78238__$1;
(statearr_78251_78268[(1)] = (4));

(statearr_78251_78268[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78239 === (10))){
var inst_78229 = (state_78238[(2)]);
var inst_78230 = fluree.db.util.async.throw_err(inst_78229);
var inst_78231 = fluree.db.query.range.block_with_tx_data(inst_78230);
var inst_78232 = cljs.core.clj__GT_js(inst_78231);
var inst_78233 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78232) : resolve.call(null,inst_78232));
var _ = (function (){var statearr_78252 = state_78238;
(statearr_78252[(4)] = cljs.core.rest((state_78238[(4)])));

return statearr_78252;
})();
var state_78238__$1 = state_78238;
var statearr_78253_78269 = state_78238__$1;
(statearr_78253_78269[(2)] = inst_78233);

(statearr_78253_78269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78239 === (8))){
var inst_78218 = (state_78238[(8)]);
var inst_78218__$1 = (state_78238[(2)]);
var inst_78219 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78220 = cljs.core.__destructure_map(inst_78219);
var inst_78221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78220,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_78222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78220,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_78223 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78218__$1], 0));
var state_78238__$1 = (function (){var statearr_78254 = state_78238;
(statearr_78254[(8)] = inst_78218__$1);

(statearr_78254[(9)] = inst_78221);

(statearr_78254[(10)] = inst_78222);

return statearr_78254;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78238__$1,(9),inst_78223);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_78255 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_78255[(0)] = flureedb$state_machine__2684__auto__);

(statearr_78255[(1)] = (1));

return statearr_78255;
});
var flureedb$state_machine__2684__auto____1 = (function (state_78238){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78238);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78256){var ex__2687__auto__ = e78256;
var statearr_78257_78270 = state_78238;
(statearr_78257_78270[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78238[(4)]))){
var statearr_78258_78271 = state_78238;
(statearr_78258_78271[(1)] = cljs.core.first((state_78238[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78272 = state_78238;
state_78238 = G__78272;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_78238){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_78238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78259 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78259[(6)] = c__2706__auto__);

return statearr_78259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__78274 = arguments.length;
switch (G__78274) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78344){
var state_val_78345 = (state_78344[(1)]);
if((state_val_78345 === (7))){
var inst_78290 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78344__$1 = state_78344;
var statearr_78346_78387 = state_78344__$1;
(statearr_78346_78387[(2)] = inst_78290);

(statearr_78346_78387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (20))){
var inst_78286 = (state_78344[(7)]);
var inst_78292 = (state_78344[(8)]);
var inst_78328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78329 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_78330 = (new cljs.core.PersistentVector(null,1,(5),inst_78328,inst_78329,null));
var inst_78331 = cljs.core.assoc_in(inst_78292,inst_78330,new cljs.core.Keyword(null,"block","block",664686210));
var inst_78332 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_78286,inst_78331);
var state_78344__$1 = state_78344;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78344__$1,(23),inst_78332);
} else {
if((state_val_78345 === (1))){
var state_78344__$1 = state_78344;
var statearr_78347_78388 = state_78344__$1;
(statearr_78347_78388[(2)] = null);

(statearr_78347_78388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (4))){
var inst_78275 = (state_78344[(2)]);
var inst_78276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78277 = [inst_78275];
var inst_78278 = (new cljs.core.PersistentVector(null,1,(5),inst_78276,inst_78277,null));
var inst_78279 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78278);
var inst_78280 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78275) : reject.call(null,inst_78275));
var state_78344__$1 = (function (){var statearr_78348 = state_78344;
(statearr_78348[(9)] = inst_78279);

return statearr_78348;
})();
var statearr_78349_78389 = state_78344__$1;
(statearr_78349_78389[(2)] = inst_78280);

(statearr_78349_78389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (15))){
var inst_78316 = (state_78344[(2)]);
var inst_78317 = fluree.db.util.async.throw_err(inst_78316);
var state_78344__$1 = state_78344;
var statearr_78350_78390 = state_78344__$1;
(statearr_78350_78390[(2)] = inst_78317);

(statearr_78350_78390[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (21))){
var inst_78337 = (state_78344[(2)]);
var inst_78338 = cljs.core.clj__GT_js(inst_78337);
var inst_78339 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78338) : resolve.call(null,inst_78338));
var _ = (function (){var statearr_78351 = state_78344;
(statearr_78351[(4)] = cljs.core.rest((state_78344[(4)])));

return statearr_78351;
})();
var state_78344__$1 = state_78344;
var statearr_78352_78391 = state_78344__$1;
(statearr_78352_78391[(2)] = inst_78339);

(statearr_78352_78391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (13))){
var state_78344__$1 = state_78344;
var statearr_78353_78392 = state_78344__$1;
(statearr_78353_78392[(2)] = null);

(statearr_78353_78392[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (22))){
var inst_78325 = (state_78344[(2)]);
var inst_78326 = fluree.db.util.async.throw_err(inst_78325);
var state_78344__$1 = state_78344;
var statearr_78354_78393 = state_78344__$1;
(statearr_78354_78393[(2)] = inst_78326);

(statearr_78354_78393[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (6))){
var state_78344__$1 = state_78344;
var statearr_78355_78394 = state_78344__$1;
(statearr_78355_78394[(2)] = null);

(statearr_78355_78394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (17))){
var state_78344__$1 = state_78344;
var statearr_78356_78395 = state_78344__$1;
(statearr_78356_78395[(2)] = null);

(statearr_78356_78395[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (3))){
var inst_78342 = (state_78344[(2)]);
var state_78344__$1 = state_78344;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78344__$1,inst_78342);
} else {
if((state_val_78345 === (12))){
var inst_78300 = (state_78344[(10)]);
var inst_78304 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_78344__$1 = (function (){var statearr_78357 = state_78344;
(statearr_78357[(11)] = inst_78304);

return statearr_78357;
})();
if(cljs.core.truth_(inst_78300)){
var statearr_78358_78396 = state_78344__$1;
(statearr_78358_78396[(1)] = (16));

} else {
var statearr_78359_78397 = state_78344__$1;
(statearr_78359_78397[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (2))){
var _ = (function (){var statearr_78360 = state_78344;
(statearr_78360[(4)] = cljs.core.cons((5),(state_78344[(4)])));

return statearr_78360;
})();
var inst_78286 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78287 = (opts == null);
var state_78344__$1 = (function (){var statearr_78361 = state_78344;
(statearr_78361[(7)] = inst_78286);

return statearr_78361;
})();
if(cljs.core.truth_(inst_78287)){
var statearr_78362_78398 = state_78344__$1;
(statearr_78362_78398[(1)] = (6));

} else {
var statearr_78363_78399 = state_78344__$1;
(statearr_78363_78399[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (23))){
var inst_78334 = (state_78344[(2)]);
var inst_78335 = fluree.db.util.async.throw_err(inst_78334);
var state_78344__$1 = state_78344;
var statearr_78364_78400 = state_78344__$1;
(statearr_78364_78400[(2)] = inst_78335);

(statearr_78364_78400[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (19))){
var inst_78320 = (state_78344[(12)]);
var inst_78286 = (state_78344[(7)]);
var inst_78292 = (state_78344[(8)]);
var inst_78323 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_78320,inst_78286,inst_78292);
var state_78344__$1 = state_78344;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78344__$1,(22),inst_78323);
} else {
if((state_val_78345 === (11))){
var inst_78294 = (state_78344[(13)]);
var inst_78292 = (state_78344[(8)]);
var inst_78300 = (state_78344[(2)]);
var inst_78301 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_78292);
var inst_78302 = (inst_78294 == null);
var state_78344__$1 = (function (){var statearr_78366 = state_78344;
(statearr_78366[(10)] = inst_78300);

(statearr_78366[(14)] = inst_78301);

return statearr_78366;
})();
if(cljs.core.truth_(inst_78302)){
var statearr_78367_78401 = state_78344__$1;
(statearr_78367_78401[(1)] = (12));

} else {
var statearr_78368_78402 = state_78344__$1;
(statearr_78368_78402[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (9))){
var inst_78295 = (state_78344[(15)]);
var state_78344__$1 = state_78344;
var statearr_78369_78403 = state_78344__$1;
(statearr_78369_78403[(2)] = inst_78295);

(statearr_78369_78403[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (5))){
var _ = (function (){var statearr_78370 = state_78344;
(statearr_78370[(4)] = cljs.core.rest((state_78344[(4)])));

return statearr_78370;
})();
var state_78344__$1 = state_78344;
var ex78365 = (state_78344__$1[(2)]);
var statearr_78371_78404 = state_78344__$1;
(statearr_78371_78404[(5)] = ex78365);


var statearr_78372_78405 = state_78344__$1;
(statearr_78372_78405[(1)] = (4));

(statearr_78372_78405[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (14))){
var inst_78294 = (state_78344[(13)]);
var inst_78320 = (state_78344[(2)]);
var inst_78321 = (inst_78294 == null);
var state_78344__$1 = (function (){var statearr_78373 = state_78344;
(statearr_78373[(12)] = inst_78320);

return statearr_78373;
})();
if(cljs.core.truth_(inst_78321)){
var statearr_78374_78406 = state_78344__$1;
(statearr_78374_78406[(1)] = (19));

} else {
var statearr_78375_78407 = state_78344__$1;
(statearr_78375_78407[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (16))){
var inst_78300 = (state_78344[(10)]);
var inst_78306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78307 = ["_auth/id",inst_78300];
var inst_78308 = (new cljs.core.PersistentVector(null,2,(5),inst_78306,inst_78307,null));
var state_78344__$1 = state_78344;
var statearr_78376_78408 = state_78344__$1;
(statearr_78376_78408[(2)] = inst_78308);

(statearr_78376_78408[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (10))){
var inst_78292 = (state_78344[(8)]);
var inst_78298 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_78292);
var state_78344__$1 = state_78344;
var statearr_78377_78409 = state_78344__$1;
(statearr_78377_78409[(2)] = inst_78298);

(statearr_78377_78409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78345 === (18))){
var inst_78304 = (state_78344[(11)]);
var inst_78301 = (state_78344[(14)]);
var inst_78311 = (state_78344[(2)]);
var inst_78312 = [inst_78311,inst_78301];
var inst_78313 = cljs.core.PersistentHashMap.fromArrays(inst_78304,inst_78312);
var inst_78314 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_78313], 0));
var state_78344__$1 = state_78344;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78344__$1,(15),inst_78314);
} else {
if((state_val_78345 === (8))){
var inst_78292 = (state_78344[(8)]);
var inst_78295 = (state_78344[(15)]);
var inst_78292__$1 = (state_78344[(2)]);
var inst_78293 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_78292__$1);
var inst_78294 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_78292__$1);
var inst_78295__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_78292__$1);
var state_78344__$1 = (function (){var statearr_78378 = state_78344;
(statearr_78378[(16)] = inst_78293);

(statearr_78378[(13)] = inst_78294);

(statearr_78378[(8)] = inst_78292__$1);

(statearr_78378[(15)] = inst_78295__$1);

return statearr_78378;
})();
if(cljs.core.truth_(inst_78295__$1)){
var statearr_78379_78410 = state_78344__$1;
(statearr_78379_78410[(1)] = (9));

} else {
var statearr_78380_78411 = state_78344__$1;
(statearr_78380_78411[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_78381 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78381[(0)] = flureedb$state_machine__2684__auto__);

(statearr_78381[(1)] = (1));

return statearr_78381;
});
var flureedb$state_machine__2684__auto____1 = (function (state_78344){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78344);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78382){var ex__2687__auto__ = e78382;
var statearr_78383_78412 = state_78344;
(statearr_78383_78412[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78344[(4)]))){
var statearr_78384_78413 = state_78344;
(statearr_78384_78413[(1)] = cljs.core.first((state_78344[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78414 = state_78344;
state_78344 = G__78414;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_78344){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_78344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78385 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78385[(6)] = c__2706__auto__);

return statearr_78385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78437){
var state_val_78438 = (state_78437[(1)]);
if((state_val_78438 === (1))){
var state_78437__$1 = state_78437;
var statearr_78439_78454 = state_78437__$1;
(statearr_78439_78454[(2)] = null);

(statearr_78439_78454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78438 === (2))){
var _ = (function (){var statearr_78440 = state_78437;
(statearr_78440[(4)] = cljs.core.cons((5),(state_78437[(4)])));

return statearr_78440;
})();
var inst_78426 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78427 = fluree.db.api.query.history_query_async(sources,inst_78426);
var state_78437__$1 = state_78437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78437__$1,(6),inst_78427);
} else {
if((state_val_78438 === (3))){
var inst_78435 = (state_78437[(2)]);
var state_78437__$1 = state_78437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78437__$1,inst_78435);
} else {
if((state_val_78438 === (4))){
var inst_78415 = (state_78437[(2)]);
var inst_78416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78417 = [inst_78415];
var inst_78418 = (new cljs.core.PersistentVector(null,1,(5),inst_78416,inst_78417,null));
var inst_78419 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78418);
var inst_78420 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78415) : reject.call(null,inst_78415));
var state_78437__$1 = (function (){var statearr_78442 = state_78437;
(statearr_78442[(7)] = inst_78419);

return statearr_78442;
})();
var statearr_78443_78455 = state_78437__$1;
(statearr_78443_78455[(2)] = inst_78420);

(statearr_78443_78455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78438 === (5))){
var _ = (function (){var statearr_78444 = state_78437;
(statearr_78444[(4)] = cljs.core.rest((state_78437[(4)])));

return statearr_78444;
})();
var state_78437__$1 = state_78437;
var ex78441 = (state_78437__$1[(2)]);
var statearr_78445_78456 = state_78437__$1;
(statearr_78445_78456[(5)] = ex78441);


var statearr_78446_78457 = state_78437__$1;
(statearr_78446_78457[(1)] = (4));

(statearr_78446_78457[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78438 === (6))){
var inst_78429 = (state_78437[(2)]);
var inst_78430 = fluree.db.util.async.throw_err(inst_78429);
var inst_78431 = cljs.core.clj__GT_js(inst_78430);
var inst_78432 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78431) : resolve.call(null,inst_78431));
var _ = (function (){var statearr_78447 = state_78437;
(statearr_78447[(4)] = cljs.core.rest((state_78437[(4)])));

return statearr_78447;
})();
var state_78437__$1 = state_78437;
var statearr_78448_78458 = state_78437__$1;
(statearr_78448_78458[(2)] = inst_78432);

(statearr_78448_78458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2684__auto__ = null;
var flureedb$history_query_$_state_machine__2684__auto____0 = (function (){
var statearr_78449 = [null,null,null,null,null,null,null,null];
(statearr_78449[(0)] = flureedb$history_query_$_state_machine__2684__auto__);

(statearr_78449[(1)] = (1));

return statearr_78449;
});
var flureedb$history_query_$_state_machine__2684__auto____1 = (function (state_78437){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78437);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78450){var ex__2687__auto__ = e78450;
var statearr_78451_78459 = state_78437;
(statearr_78451_78459[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78437[(4)]))){
var statearr_78452_78460 = state_78437;
(statearr_78452_78460[(1)] = cljs.core.first((state_78437[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78461 = state_78437;
state_78437 = G__78461;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2684__auto__ = function(state_78437){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2684__auto____1.call(this,state_78437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2684__auto____0;
flureedb$history_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2684__auto____1;
return flureedb$history_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78453 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78453[(6)] = c__2706__auto__);

return statearr_78453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78484){
var state_val_78485 = (state_78484[(1)]);
if((state_val_78485 === (1))){
var state_78484__$1 = state_78484;
var statearr_78486_78501 = state_78484__$1;
(statearr_78486_78501[(2)] = null);

(statearr_78486_78501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78485 === (2))){
var _ = (function (){var statearr_78487 = state_78484;
(statearr_78487[(4)] = cljs.core.cons((5),(state_78484[(4)])));

return statearr_78487;
})();
var inst_78473 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78474 = fluree.db.api.query.multi_query_async(sources,inst_78473);
var state_78484__$1 = state_78484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78484__$1,(6),inst_78474);
} else {
if((state_val_78485 === (3))){
var inst_78482 = (state_78484[(2)]);
var state_78484__$1 = state_78484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78484__$1,inst_78482);
} else {
if((state_val_78485 === (4))){
var inst_78462 = (state_78484[(2)]);
var inst_78463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78464 = [inst_78462];
var inst_78465 = (new cljs.core.PersistentVector(null,1,(5),inst_78463,inst_78464,null));
var inst_78466 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78465);
var inst_78467 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78462) : reject.call(null,inst_78462));
var state_78484__$1 = (function (){var statearr_78489 = state_78484;
(statearr_78489[(7)] = inst_78466);

return statearr_78489;
})();
var statearr_78490_78502 = state_78484__$1;
(statearr_78490_78502[(2)] = inst_78467);

(statearr_78490_78502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78485 === (5))){
var _ = (function (){var statearr_78491 = state_78484;
(statearr_78491[(4)] = cljs.core.rest((state_78484[(4)])));

return statearr_78491;
})();
var state_78484__$1 = state_78484;
var ex78488 = (state_78484__$1[(2)]);
var statearr_78492_78503 = state_78484__$1;
(statearr_78492_78503[(5)] = ex78488);


var statearr_78493_78504 = state_78484__$1;
(statearr_78493_78504[(1)] = (4));

(statearr_78493_78504[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78485 === (6))){
var inst_78476 = (state_78484[(2)]);
var inst_78477 = fluree.db.util.async.throw_err(inst_78476);
var inst_78478 = cljs.core.clj__GT_js(inst_78477);
var inst_78479 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78478) : resolve.call(null,inst_78478));
var _ = (function (){var statearr_78494 = state_78484;
(statearr_78494[(4)] = cljs.core.rest((state_78484[(4)])));

return statearr_78494;
})();
var state_78484__$1 = state_78484;
var statearr_78495_78505 = state_78484__$1;
(statearr_78495_78505[(2)] = inst_78479);

(statearr_78495_78505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2684__auto__ = null;
var flureedb$multi_query_$_state_machine__2684__auto____0 = (function (){
var statearr_78496 = [null,null,null,null,null,null,null,null];
(statearr_78496[(0)] = flureedb$multi_query_$_state_machine__2684__auto__);

(statearr_78496[(1)] = (1));

return statearr_78496;
});
var flureedb$multi_query_$_state_machine__2684__auto____1 = (function (state_78484){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78484);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78497){var ex__2687__auto__ = e78497;
var statearr_78498_78506 = state_78484;
(statearr_78498_78506[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78484[(4)]))){
var statearr_78499_78507 = state_78484;
(statearr_78499_78507[(1)] = cljs.core.first((state_78484[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78508 = state_78484;
state_78484 = G__78508;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2684__auto__ = function(state_78484){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2684__auto____1.call(this,state_78484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2684__auto____0;
flureedb$multi_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2684__auto____1;
return flureedb$multi_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78500 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78500[(6)] = c__2706__auto__);

return statearr_78500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78531){
var state_val_78532 = (state_78531[(1)]);
if((state_val_78532 === (1))){
var state_78531__$1 = state_78531;
var statearr_78533_78548 = state_78531__$1;
(statearr_78533_78548[(2)] = null);

(statearr_78533_78548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78532 === (2))){
var _ = (function (){var statearr_78534 = state_78531;
(statearr_78534[(4)] = cljs.core.cons((5),(state_78531[(4)])));

return statearr_78534;
})();
var inst_78521 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78522 = fluree.db.api.query.query_async(sources,inst_78521);
var state_78531__$1 = state_78531;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78531__$1,(6),inst_78522);
} else {
if((state_val_78532 === (3))){
var inst_78529 = (state_78531[(2)]);
var state_78531__$1 = state_78531;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78531__$1,inst_78529);
} else {
if((state_val_78532 === (4))){
var inst_78509 = (state_78531[(2)]);
var inst_78510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78511 = [inst_78509];
var inst_78512 = (new cljs.core.PersistentVector(null,1,(5),inst_78510,inst_78511,null));
var inst_78513 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78512);
var inst_78514 = cljs.core.clj__GT_js(inst_78509);
var inst_78515 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78514) : reject.call(null,inst_78514));
var state_78531__$1 = (function (){var statearr_78536 = state_78531;
(statearr_78536[(7)] = inst_78513);

return statearr_78536;
})();
var statearr_78537_78549 = state_78531__$1;
(statearr_78537_78549[(2)] = inst_78515);

(statearr_78537_78549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78532 === (5))){
var _ = (function (){var statearr_78538 = state_78531;
(statearr_78538[(4)] = cljs.core.rest((state_78531[(4)])));

return statearr_78538;
})();
var state_78531__$1 = state_78531;
var ex78535 = (state_78531__$1[(2)]);
var statearr_78539_78550 = state_78531__$1;
(statearr_78539_78550[(5)] = ex78535);


var statearr_78540_78551 = state_78531__$1;
(statearr_78540_78551[(1)] = (4));

(statearr_78540_78551[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78532 === (6))){
var inst_78524 = (state_78531[(2)]);
var inst_78525 = cljs.core.clj__GT_js(inst_78524);
var inst_78526 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78525) : resolve.call(null,inst_78525));
var _ = (function (){var statearr_78541 = state_78531;
(statearr_78541[(4)] = cljs.core.rest((state_78531[(4)])));

return statearr_78541;
})();
var state_78531__$1 = state_78531;
var statearr_78542_78552 = state_78531__$1;
(statearr_78542_78552[(2)] = inst_78526);

(statearr_78542_78552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2684__auto__ = null;
var flureedb$query_$_state_machine__2684__auto____0 = (function (){
var statearr_78543 = [null,null,null,null,null,null,null,null];
(statearr_78543[(0)] = flureedb$query_$_state_machine__2684__auto__);

(statearr_78543[(1)] = (1));

return statearr_78543;
});
var flureedb$query_$_state_machine__2684__auto____1 = (function (state_78531){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78531);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78544){var ex__2687__auto__ = e78544;
var statearr_78545_78553 = state_78531;
(statearr_78545_78553[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78531[(4)]))){
var statearr_78546_78554 = state_78531;
(statearr_78546_78554[(1)] = cljs.core.first((state_78531[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78555 = state_78531;
state_78531 = G__78555;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2684__auto__ = function(state_78531){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2684__auto____1.call(this,state_78531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2684__auto____0;
flureedb$query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2684__auto____1;
return flureedb$query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78547 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78547[(6)] = c__2706__auto__);

return statearr_78547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__78557 = arguments.length;
switch (G__78557) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_78587){
var state_val_78588 = (state_78587[(1)]);
if((state_val_78588 === (7))){
var inst_78574 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_78587__$1 = state_78587;
var statearr_78589_78610 = state_78587__$1;
(statearr_78589_78610[(2)] = inst_78574);

(statearr_78589_78610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78588 === (1))){
var state_78587__$1 = state_78587;
var statearr_78590_78611 = state_78587__$1;
(statearr_78590_78611[(2)] = null);

(statearr_78590_78611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78588 === (4))){
var inst_78558 = (state_78587[(2)]);
var inst_78559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78560 = [inst_78558];
var inst_78561 = (new cljs.core.PersistentVector(null,1,(5),inst_78559,inst_78560,null));
var inst_78562 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78561);
var inst_78563 = cljs.core.clj__GT_js(inst_78558);
var inst_78564 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78563) : reject.call(null,inst_78563));
var state_78587__$1 = (function (){var statearr_78591 = state_78587;
(statearr_78591[(7)] = inst_78562);

return statearr_78591;
})();
var statearr_78592_78612 = state_78587__$1;
(statearr_78592_78612[(2)] = inst_78564);

(statearr_78592_78612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78588 === (6))){
var state_78587__$1 = state_78587;
var statearr_78593_78613 = state_78587__$1;
(statearr_78593_78613[(2)] = null);

(statearr_78593_78613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78588 === (3))){
var inst_78585 = (state_78587[(2)]);
var state_78587__$1 = state_78587;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78587__$1,inst_78585);
} else {
if((state_val_78588 === (2))){
var _ = (function (){var statearr_78595 = state_78587;
(statearr_78595[(4)] = cljs.core.cons((5),(state_78587[(4)])));

return statearr_78595;
})();
var inst_78570 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_78571 = (opts == null);
var state_78587__$1 = (function (){var statearr_78596 = state_78587;
(statearr_78596[(8)] = inst_78570);

return statearr_78596;
})();
if(cljs.core.truth_(inst_78571)){
var statearr_78597_78614 = state_78587__$1;
(statearr_78597_78614[(1)] = (6));

} else {
var statearr_78598_78615 = state_78587__$1;
(statearr_78598_78615[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78588 === (9))){
var inst_78579 = (state_78587[(2)]);
var inst_78580 = fluree.db.util.async.throw_err(inst_78579);
var inst_78581 = cljs.core.clj__GT_js(inst_78580);
var inst_78582 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_78581) : resolve.call(null,inst_78581));
var _ = (function (){var statearr_78599 = state_78587;
(statearr_78599[(4)] = cljs.core.rest((state_78587[(4)])));

return statearr_78599;
})();
var state_78587__$1 = state_78587;
var statearr_78600_78616 = state_78587__$1;
(statearr_78600_78616[(2)] = inst_78582);

(statearr_78600_78616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78588 === (5))){
var _ = (function (){var statearr_78601 = state_78587;
(statearr_78601[(4)] = cljs.core.rest((state_78587[(4)])));

return statearr_78601;
})();
var state_78587__$1 = state_78587;
var ex78594 = (state_78587__$1[(2)]);
var statearr_78602_78617 = state_78587__$1;
(statearr_78602_78617[(5)] = ex78594);


var statearr_78603_78618 = state_78587__$1;
(statearr_78603_78618[(1)] = (4));

(statearr_78603_78618[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78588 === (8))){
var inst_78570 = (state_78587[(8)]);
var inst_78576 = (state_78587[(2)]);
var inst_78577 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_78570,inst_78576);
var state_78587__$1 = state_78587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78587__$1,(9),inst_78577);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_78604 = [null,null,null,null,null,null,null,null,null];
(statearr_78604[(0)] = flureedb$state_machine__2684__auto__);

(statearr_78604[(1)] = (1));

return statearr_78604;
});
var flureedb$state_machine__2684__auto____1 = (function (state_78587){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_78587);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e78605){var ex__2687__auto__ = e78605;
var statearr_78606_78619 = state_78587;
(statearr_78606_78619[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_78587[(4)]))){
var statearr_78607_78620 = state_78587;
(statearr_78607_78620[(1)] = cljs.core.first((state_78587[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78621 = state_78587;
state_78587 = G__78621;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_78587){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_78587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_78608 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_78608[(6)] = c__2706__auto__);

return statearr_78608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
