// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('goog.object');
goog.scope(function(){
fluree.db.util.json.goog$module$goog$object = goog.module.get('goog.object');
});
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__14421 = arguments.length;
switch (G__14421) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__14422 = options;
var map__14422__$1 = cljs.core.__destructure_map(map__14422);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14422__$1,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675));
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__14461_14494 = cljs.core.seq(x__$1);
var chunk__14462_14495 = null;
var count__14463_14496 = (0);
var i__14464_14497 = (0);
while(true){
if((i__14464_14497 < count__14463_14496)){
var vec__14477_14498 = chunk__14462_14495.cljs$core$IIndexed$_nth$arity$2(null,i__14464_14497);
var k_14499 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14477_14498,(0),null);
var v_14500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14477_14498,(1),null);
var G__14480_14501 = m;
var G__14481_14502 = keyfn(k_14499);
var G__14482_14503 = fluree$db$util$json$thisfn(v_14500);
fluree.db.util.json.goog$module$goog$object.set.call(null,G__14480_14501,G__14481_14502,G__14482_14503);


var G__14504 = seq__14461_14494;
var G__14505 = chunk__14462_14495;
var G__14506 = count__14463_14496;
var G__14507 = (i__14464_14497 + (1));
seq__14461_14494 = G__14504;
chunk__14462_14495 = G__14505;
count__14463_14496 = G__14506;
i__14464_14497 = G__14507;
continue;
} else {
var temp__5804__auto___14508 = cljs.core.seq(seq__14461_14494);
if(temp__5804__auto___14508){
var seq__14461_14509__$1 = temp__5804__auto___14508;
if(cljs.core.chunked_seq_QMARK_(seq__14461_14509__$1)){
var c__5568__auto___14510 = cljs.core.chunk_first(seq__14461_14509__$1);
var G__14511 = cljs.core.chunk_rest(seq__14461_14509__$1);
var G__14512 = c__5568__auto___14510;
var G__14513 = cljs.core.count(c__5568__auto___14510);
var G__14514 = (0);
seq__14461_14494 = G__14511;
chunk__14462_14495 = G__14512;
count__14463_14496 = G__14513;
i__14464_14497 = G__14514;
continue;
} else {
var vec__14483_14515 = cljs.core.first(seq__14461_14509__$1);
var k_14516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14483_14515,(0),null);
var v_14517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14483_14515,(1),null);
var G__14486_14518 = m;
var G__14487_14519 = keyfn(k_14516);
var G__14488_14520 = fluree$db$util$json$thisfn(v_14517);
fluree.db.util.json.goog$module$goog$object.set.call(null,G__14486_14518,G__14487_14519,G__14488_14520);


var G__14521 = cljs.core.next(seq__14461_14509__$1);
var G__14522 = null;
var G__14523 = (0);
var G__14524 = (0);
seq__14461_14494 = G__14521;
chunk__14462_14495 = G__14522;
count__14463_14496 = G__14523;
i__14464_14497 = G__14524;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__14489_14525 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__14490_14526 = null;
var count__14491_14527 = (0);
var i__14492_14528 = (0);
while(true){
if((i__14492_14528 < count__14491_14527)){
var x_14529__$2 = chunk__14490_14526.cljs$core$IIndexed$_nth$arity$2(null,i__14492_14528);
arr.push(x_14529__$2);


var G__14530 = seq__14489_14525;
var G__14531 = chunk__14490_14526;
var G__14532 = count__14491_14527;
var G__14533 = (i__14492_14528 + (1));
seq__14489_14525 = G__14530;
chunk__14490_14526 = G__14531;
count__14491_14527 = G__14532;
i__14492_14528 = G__14533;
continue;
} else {
var temp__5804__auto___14534 = cljs.core.seq(seq__14489_14525);
if(temp__5804__auto___14534){
var seq__14489_14535__$1 = temp__5804__auto___14534;
if(cljs.core.chunked_seq_QMARK_(seq__14489_14535__$1)){
var c__5568__auto___14536 = cljs.core.chunk_first(seq__14489_14535__$1);
var G__14537 = cljs.core.chunk_rest(seq__14489_14535__$1);
var G__14538 = c__5568__auto___14536;
var G__14539 = cljs.core.count(c__5568__auto___14536);
var G__14540 = (0);
seq__14489_14525 = G__14537;
chunk__14490_14526 = G__14538;
count__14491_14527 = G__14539;
i__14492_14528 = G__14540;
continue;
} else {
var x_14541__$2 = cljs.core.first(seq__14489_14535__$1);
arr.push(x_14541__$2);


var G__14542 = cljs.core.next(seq__14489_14535__$1);
var G__14543 = null;
var G__14544 = (0);
var G__14545 = (0);
seq__14489_14525 = G__14542;
chunk__14490_14526 = G__14543;
count__14491_14527 = G__14544;
i__14492_14528 = G__14545;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
fluree.db.util.json.parse_json_flakes = (function fluree$db$util$json$parse_json_flakes(db,flakes){
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("parse-json-flakes flakes:",flakes) : fluree.db.util.log.debug.call(null,"parse-json-flakes flakes:",flakes));

return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14546_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"json","json",1279968570),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),fluree.db.flake.p(p1__14546_SHARP_)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(p1__14546_SHARP_,new cljs.core.Keyword(null,"o","o",-1350007228),fluree.db.util.json.parse);
} else {
return p1__14546_SHARP_;
}
}),flakes);
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14547_SHARP_){
var G__14548 = (depth - (1));
var G__14549 = p1__14547_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__14548,G__14549) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__14548,G__14549));
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__14550 = cljs.core.get_global_hierarchy;
return (fexpr__14550.cljs$core$IFn$_invoke$arity$0 ? fexpr__14550.cljs$core$IFn$_invoke$arity$0() : fexpr__14550.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__5043__auto__ = (function (){var or__5045__auto__ = (function (){var G__14551 = new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__14551) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__14551));
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return ((cljs.core.map_QMARK_(new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__5043__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__14552_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__14552_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));
