// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__20607,error_ch,vars,p__20608,parse_json_QMARK_){
var map__20609 = p__20607;
var map__20609__$1 = cljs.core.__destructure_map(map__20609);
var db = map__20609__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20609__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20609__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20609__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__20610 = p__20608;
var map__20610__$1 = cljs.core.__destructure_map(map__20610);
var _where_clause = map__20610__$1;
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20610__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20610__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20610__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1("subjects-chan") : fluree.db.util.log.debug.call(null,"subjects-chan"));

var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__20611 = (function (){var G__20614 = idx;
var G__20614__$1 = (((G__20614 instanceof cljs.core.Keyword))?G__20614.fqn:null);
switch (G__20614__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20614__$1)].join('')));

}
})();
var fflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20611,(0),null);
var lflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20611,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__20605_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o_STAR_,fluree.db.flake.o(p1__20605_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__20606_SHARP_){
var G__20615 = fluree.db.flake.o(p1__20606_SHARP_);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__20615) : f.call(null,G__20615));
});
})():null));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fflake,lflake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var xf = (cljs.core.truth_(filter_fn)?cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(filter_fn,flakes);
})):null);
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),xf], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,cljs.core.get.cljs$core$IFn$_invoke$arity$2(novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((10),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s),cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0()));
var c__2706__auto___20685 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20654){
var state_val_20655 = (state_20654[(1)]);
if((state_val_20655 === (7))){
var inst_20650 = (state_20654[(2)]);
var state_20654__$1 = state_20654;
var statearr_20656_20686 = state_20654__$1;
(statearr_20656_20686[(2)] = inst_20650);

(statearr_20656_20686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (1))){
var state_20654__$1 = state_20654;
var statearr_20657_20687 = state_20654__$1;
(statearr_20657_20687[(2)] = null);

(statearr_20657_20687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (4))){
var inst_20618 = (state_20654[(7)]);
var inst_20618__$1 = (state_20654[(2)]);
var inst_20619 = (inst_20618__$1 == null);
var state_20654__$1 = (function (){var statearr_20658 = state_20654;
(statearr_20658[(7)] = inst_20618__$1);

return statearr_20658;
})();
if(cljs.core.truth_(inst_20619)){
var statearr_20659_20688 = state_20654__$1;
(statearr_20659_20688[(1)] = (5));

} else {
var statearr_20660_20689 = state_20654__$1;
(statearr_20660_20689[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (15))){
var state_20654__$1 = state_20654;
var statearr_20661_20690 = state_20654__$1;
(statearr_20661_20690[(2)] = false);

(statearr_20661_20690[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (13))){
var inst_20630 = (state_20654[(2)]);
var state_20654__$1 = state_20654;
if(cljs.core.truth_(inst_20630)){
var statearr_20662_20691 = state_20654__$1;
(statearr_20662_20691[(1)] = (14));

} else {
var statearr_20663_20692 = state_20654__$1;
(statearr_20663_20692[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (6))){
var inst_20618 = (state_20654[(7)]);
var inst_20623 = cljs.core.seq(inst_20618);
var inst_20624 = inst_20623;
var inst_20625 = (0);
var state_20654__$1 = (function (){var statearr_20664 = state_20654;
(statearr_20664[(8)] = inst_20625);

(statearr_20664[(9)] = inst_20624);

return statearr_20664;
})();
var statearr_20665_20693 = state_20654__$1;
(statearr_20665_20693[(2)] = null);

(statearr_20665_20693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (17))){
var state_20654__$1 = state_20654;
var statearr_20666_20694 = state_20654__$1;
(statearr_20666_20694[(2)] = null);

(statearr_20666_20694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (3))){
var inst_20652 = (state_20654[(2)]);
var state_20654__$1 = state_20654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20654__$1,inst_20652);
} else {
if((state_val_20655 === (12))){
var inst_20640 = (state_20654[(2)]);
var state_20654__$1 = state_20654;
var statearr_20667_20695 = state_20654__$1;
(statearr_20667_20695[(2)] = inst_20640);

(statearr_20667_20695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (2))){
var state_20654__$1 = state_20654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20654__$1,(4),tree_chan);
} else {
if((state_val_20655 === (19))){
var inst_20648 = (state_20654[(2)]);
var state_20654__$1 = state_20654;
var statearr_20668_20696 = state_20654__$1;
(statearr_20668_20696[(2)] = inst_20648);

(statearr_20668_20696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (11))){
var state_20654__$1 = state_20654;
var statearr_20669_20697 = state_20654__$1;
(statearr_20669_20697[(2)] = true);

(statearr_20669_20697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (9))){
var inst_20642 = (state_20654[(2)]);
var state_20654__$1 = state_20654;
if(cljs.core.truth_(inst_20642)){
var statearr_20670_20698 = state_20654__$1;
(statearr_20670_20698[(1)] = (17));

} else {
var statearr_20671_20699 = state_20654__$1;
(statearr_20671_20699[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (5))){
var inst_20621 = cljs.core.async.close_BANG_(return_chan);
var state_20654__$1 = state_20654;
var statearr_20672_20700 = state_20654__$1;
(statearr_20672_20700[(2)] = inst_20621);

(statearr_20672_20700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (14))){
var inst_20625 = (state_20654[(8)]);
var inst_20624 = (state_20654[(9)]);
var inst_20632 = cljs.core.next(inst_20624);
var inst_20633 = (inst_20625 + (1));
var inst_20624__$1 = inst_20632;
var inst_20625__$1 = inst_20633;
var state_20654__$1 = (function (){var statearr_20673 = state_20654;
(statearr_20673[(8)] = inst_20625__$1);

(statearr_20673[(9)] = inst_20624__$1);

return statearr_20673;
})();
var statearr_20674_20701 = state_20654__$1;
(statearr_20674_20701[(2)] = null);

(statearr_20674_20701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (16))){
var inst_20637 = (state_20654[(2)]);
var state_20654__$1 = state_20654;
var statearr_20675_20702 = state_20654__$1;
(statearr_20675_20702[(2)] = inst_20637);

(statearr_20675_20702[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (10))){
var inst_20624 = (state_20654[(9)]);
var inst_20628 = cljs.core.first(inst_20624);
var state_20654__$1 = state_20654;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20654__$1,(13),return_chan,inst_20628);
} else {
if((state_val_20655 === (18))){
var inst_20646 = cljs.core.async.close_BANG_(return_chan);
var state_20654__$1 = state_20654;
var statearr_20676_20703 = state_20654__$1;
(statearr_20676_20703[(2)] = inst_20646);

(statearr_20676_20703[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20655 === (8))){
var inst_20624 = (state_20654[(9)]);
var state_20654__$1 = state_20654;
if(cljs.core.truth_(inst_20624)){
var statearr_20677_20704 = state_20654__$1;
(statearr_20677_20704[(1)] = (10));

} else {
var statearr_20678_20705 = state_20654__$1;
(statearr_20678_20705[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0 = (function (){
var statearr_20679 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20679[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__);

(statearr_20679[(1)] = (1));

return statearr_20679;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1 = (function (state_20654){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20654);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20680){var ex__2687__auto__ = e20680;
var statearr_20681_20706 = state_20654;
(statearr_20681_20706[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20654[(4)]))){
var statearr_20682_20707 = state_20654;
(statearr_20682_20707[(1)] = cljs.core.first((state_20654[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20708 = state_20654;
state_20654 = G__20708;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__ = function(state_20654){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1.call(this,state_20654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20683 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20683[(6)] = c__2706__auto___20685);

return statearr_20683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__20709){
var map__20710 = p__20709;
var map__20710__$1 = cljs.core.__destructure_map(map__20710);
var _opts = map__20710__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20710__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20710__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20710__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20710__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20710__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20710__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20710__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn(db):null);
return (function (sid,port){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20755){
var state_val_20756 = (state_20755[(1)]);
if((state_val_20756 === (7))){
var inst_20726 = (state_20755[(7)]);
var inst_20728 = fluree.db.query.subject_crawl.common.filter_subject(vars,filter_map,inst_20726);
var state_20755__$1 = state_20755;
var statearr_20757_20793 = state_20755__$1;
(statearr_20757_20793[(2)] = inst_20728);

(statearr_20757_20793[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (1))){
var state_20755__$1 = state_20755;
var statearr_20758_20794 = state_20755__$1;
(statearr_20758_20794[(2)] = null);

(statearr_20758_20794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (4))){
var inst_20711 = (state_20755[(2)]);
var inst_20712 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_20711);
var inst_20713 = cljs.core.async.close_BANG_(port);
var state_20755__$1 = (function (){var statearr_20759 = state_20755;
(statearr_20759[(8)] = inst_20713);

(statearr_20759[(9)] = inst_20712);

return statearr_20759;
})();
var statearr_20760_20795 = state_20755__$1;
(statearr_20760_20795[(2)] = null);

(statearr_20760_20795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (15))){
var inst_20743 = (state_20755[(10)]);
var inst_20743__$1 = (state_20755[(2)]);
var inst_20744 = cljs.core.seq(inst_20743__$1);
var state_20755__$1 = (function (){var statearr_20761 = state_20755;
(statearr_20761[(10)] = inst_20743__$1);

return statearr_20761;
})();
if(inst_20744){
var statearr_20762_20796 = state_20755__$1;
(statearr_20762_20796[(1)] = (17));

} else {
var statearr_20763_20797 = state_20755__$1;
(statearr_20763_20797[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (13))){
var inst_20736 = (state_20755[(11)]);
var state_20755__$1 = state_20755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20755__$1,(16),inst_20736);
} else {
if((state_val_20756 === (6))){
var inst_20725 = (state_20755[(2)]);
var inst_20726 = fluree.db.util.async.throw_err(inst_20725);
var state_20755__$1 = (function (){var statearr_20764 = state_20755;
(statearr_20764[(7)] = inst_20726);

return statearr_20764;
})();
if(cljs.core.truth_(filter_map)){
var statearr_20765_20798 = state_20755__$1;
(statearr_20765_20798[(1)] = (7));

} else {
var statearr_20766_20799 = state_20755__$1;
(statearr_20766_20799[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (17))){
var inst_20743 = (state_20755[(10)]);
var inst_20746 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_20743);
var state_20755__$1 = state_20755;
var statearr_20767_20800 = state_20755__$1;
(statearr_20767_20800[(2)] = inst_20746);

(statearr_20767_20800[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (3))){
var inst_20753 = (state_20755[(2)]);
var state_20755__$1 = state_20755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20755__$1,inst_20753);
} else {
if((state_val_20756 === (12))){
var inst_20736 = (state_20755[(2)]);
var state_20755__$1 = (function (){var statearr_20768 = state_20755;
(statearr_20768[(11)] = inst_20736);

return statearr_20768;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_20769_20801 = state_20755__$1;
(statearr_20769_20801[(1)] = (13));

} else {
var statearr_20770_20802 = state_20755__$1;
(statearr_20770_20802[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (2))){
var _ = (function (){var statearr_20771 = state_20755;
(statearr_20771[(4)] = cljs.core.cons((5),(state_20755[(4)])));

return statearr_20771;
})();
var inst_20720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20721 = [sid];
var inst_20722 = (new cljs.core.PersistentVector(null,1,(5),inst_20720,inst_20721,null));
var inst_20723 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20722);
var state_20755__$1 = state_20755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20755__$1,(6),inst_20723);
} else {
if((state_val_20756 === (19))){
var inst_20749 = (state_20755[(2)]);
var inst_20750 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_20772 = state_20755;
(statearr_20772[(4)] = cljs.core.rest((state_20755[(4)])));

return statearr_20772;
})();
var state_20755__$1 = (function (){var statearr_20773 = state_20755;
(statearr_20773[(12)] = inst_20749);

return statearr_20773;
})();
var statearr_20774_20803 = state_20755__$1;
(statearr_20774_20803[(2)] = inst_20750);

(statearr_20774_20803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (11))){
var inst_20731 = (state_20755[(13)]);
var state_20755__$1 = state_20755;
var statearr_20776_20804 = state_20755__$1;
(statearr_20776_20804[(2)] = inst_20731);

(statearr_20776_20804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (9))){
var inst_20731 = (state_20755[(2)]);
var state_20755__$1 = (function (){var statearr_20777 = state_20755;
(statearr_20777[(13)] = inst_20731);

return statearr_20777;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_20778_20805 = state_20755__$1;
(statearr_20778_20805[(1)] = (10));

} else {
var statearr_20779_20806 = state_20755__$1;
(statearr_20779_20806[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (5))){
var _ = (function (){var statearr_20780 = state_20755;
(statearr_20780[(4)] = cljs.core.rest((state_20755[(4)])));

return statearr_20780;
})();
var state_20755__$1 = state_20755;
var ex20775 = (state_20755__$1[(2)]);
var statearr_20781_20807 = state_20755__$1;
(statearr_20781_20807[(5)] = ex20775);


var statearr_20782_20808 = state_20755__$1;
(statearr_20782_20808[(1)] = (4));

(statearr_20782_20808[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (14))){
var inst_20736 = (state_20755[(11)]);
var state_20755__$1 = state_20755;
var statearr_20783_20809 = state_20755__$1;
(statearr_20783_20809[(2)] = inst_20736);

(statearr_20783_20809[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (16))){
var inst_20739 = (state_20755[(2)]);
var inst_20740 = fluree.db.util.async.throw_err(inst_20739);
var state_20755__$1 = state_20755;
var statearr_20784_20810 = state_20755__$1;
(statearr_20784_20810[(2)] = inst_20740);

(statearr_20784_20810[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (10))){
var inst_20731 = (state_20755[(13)]);
var inst_20733 = (permissions.cljs$core$IFn$_invoke$arity$1 ? permissions.cljs$core$IFn$_invoke$arity$1(inst_20731) : permissions.call(null,inst_20731));
var state_20755__$1 = state_20755;
var statearr_20785_20811 = state_20755__$1;
(statearr_20785_20811[(2)] = inst_20733);

(statearr_20785_20811[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (18))){
var state_20755__$1 = state_20755;
var statearr_20786_20812 = state_20755__$1;
(statearr_20786_20812[(2)] = null);

(statearr_20786_20812[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20756 === (8))){
var inst_20726 = (state_20755[(7)]);
var state_20755__$1 = state_20755;
var statearr_20787_20813 = state_20755__$1;
(statearr_20787_20813[(2)] = inst_20726);

(statearr_20787_20813[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0 = (function (){
var statearr_20788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20788[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__);

(statearr_20788[(1)] = (1));

return statearr_20788;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1 = (function (state_20755){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20755);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20789){var ex__2687__auto__ = e20789;
var statearr_20790_20814 = state_20755;
(statearr_20790_20814[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20755[(4)]))){
var statearr_20791_20815 = state_20755;
(statearr_20791_20815[(1)] = cljs.core.first((state_20755[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20816 = state_20755;
state_20755 = G__20816;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__ = function(state_20755){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1.call(this,state_20755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20792 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20792[(6)] = c__2706__auto__);

return statearr_20792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__20817){
var map__20818 = p__20817;
var map__20818__$1 = cljs.core.__destructure_map(map__20818);
var f_where = map__20818__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20818__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("subjects-id-chan f-where:",f_where) : fluree.db.util.log.debug.call(null,"subjects-id-chan f-where:",f_where));

var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2706__auto___20855 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20838){
var state_val_20839 = (state_20838[(1)]);
if((state_val_20839 === (7))){
var inst_20826 = (state_20838[(7)]);
var inst_20829 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_20826);
var state_20838__$1 = state_20838;
var statearr_20840_20856 = state_20838__$1;
(statearr_20840_20856[(2)] = inst_20829);

(statearr_20840_20856[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (1))){
var inst_20819 = typeof _id_val === 'number';
var state_20838__$1 = state_20838;
if(cljs.core.truth_(inst_20819)){
var statearr_20841_20857 = state_20838__$1;
(statearr_20841_20857[(1)] = (2));

} else {
var statearr_20842_20858 = state_20838__$1;
(statearr_20842_20858[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (4))){
var inst_20835 = (state_20838[(2)]);
var inst_20836 = cljs.core.async.close_BANG_(return_ch);
var state_20838__$1 = (function (){var statearr_20843 = state_20838;
(statearr_20843[(8)] = inst_20835);

return statearr_20843;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20838__$1,inst_20836);
} else {
if((state_val_20839 === (6))){
var inst_20826 = (state_20838[(7)]);
var inst_20826__$1 = (state_20838[(2)]);
var inst_20827 = fluree.db.util.core.exception_QMARK_(inst_20826__$1);
var state_20838__$1 = (function (){var statearr_20844 = state_20838;
(statearr_20844[(7)] = inst_20826__$1);

return statearr_20844;
})();
if(inst_20827){
var statearr_20845_20859 = state_20838__$1;
(statearr_20845_20859[(1)] = (7));

} else {
var statearr_20846_20860 = state_20838__$1;
(statearr_20846_20860[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (3))){
var inst_20824 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,_id_val);
var state_20838__$1 = state_20838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20838__$1,(6),inst_20824);
} else {
if((state_val_20839 === (2))){
var state_20838__$1 = state_20838;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20838__$1,(5),return_ch,_id_val);
} else {
if((state_val_20839 === (9))){
var inst_20833 = (state_20838[(2)]);
var state_20838__$1 = state_20838;
var statearr_20847_20861 = state_20838__$1;
(statearr_20847_20861[(2)] = inst_20833);

(statearr_20847_20861[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (5))){
var inst_20822 = (state_20838[(2)]);
var state_20838__$1 = state_20838;
var statearr_20848_20862 = state_20838__$1;
(statearr_20848_20862[(2)] = inst_20822);

(statearr_20848_20862[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20839 === (8))){
var inst_20826 = (state_20838[(7)]);
var inst_20831 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_20826);
var state_20838__$1 = state_20838;
var statearr_20849_20863 = state_20838__$1;
(statearr_20849_20863[(2)] = inst_20831);

(statearr_20849_20863[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0 = (function (){
var statearr_20850 = [null,null,null,null,null,null,null,null,null];
(statearr_20850[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__);

(statearr_20850[(1)] = (1));

return statearr_20850;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1 = (function (state_20838){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20838);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20851){var ex__2687__auto__ = e20851;
var statearr_20852_20864 = state_20838;
(statearr_20852_20864[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20838[(4)]))){
var statearr_20853_20865 = state_20838;
(statearr_20853_20865[(1)] = cljs.core.first((state_20838[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20866 = state_20838;
state_20838 = G__20866;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__ = function(state_20838){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1.call(this,state_20838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20854 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20854[(6)] = c__2706__auto___20855);

return statearr_20854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_ch;
});
/**
 * If the predicate is a ref? type with an 'o' value, it must be resolved into a subject id.
 */
fluree.db.query.subject_crawl.subject.resolve_o_ident = (function fluree$db$query$subject_crawl$subject$resolve_o_ident(db,p__20867){
var map__20868 = p__20867;
var map__20868__$1 = cljs.core.__destructure_map(map__20868);
var where_clause = map__20868__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20868__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20892){
var state_val_20893 = (state_20892[(1)]);
if((state_val_20893 === (7))){
var inst_20879 = (state_20892[(7)]);
var state_20892__$1 = state_20892;
var statearr_20894_20913 = state_20892__$1;
(statearr_20894_20913[(2)] = inst_20879);

(statearr_20894_20913[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (1))){
var state_20892__$1 = state_20892;
var statearr_20895_20914 = state_20892__$1;
(statearr_20895_20914[(2)] = null);

(statearr_20895_20914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (4))){
var inst_20869 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
var statearr_20896_20915 = state_20892__$1;
(statearr_20896_20915[(2)] = inst_20869);

(statearr_20896_20915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (6))){
var inst_20879 = (state_20892[(7)]);
var inst_20878 = (state_20892[(2)]);
var inst_20879__$1 = fluree.db.util.async.throw_err(inst_20878);
var state_20892__$1 = (function (){var statearr_20897 = state_20892;
(statearr_20897[(7)] = inst_20879__$1);

return statearr_20897;
})();
if(cljs.core.truth_(inst_20879__$1)){
var statearr_20898_20916 = state_20892__$1;
(statearr_20898_20916[(1)] = (7));

} else {
var statearr_20899_20917 = state_20892__$1;
(statearr_20899_20917[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (3))){
var inst_20890 = (state_20892[(2)]);
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20892__$1,inst_20890);
} else {
if((state_val_20893 === (2))){
var _ = (function (){var statearr_20901 = state_20892;
(statearr_20901[(4)] = cljs.core.cons((5),(state_20892[(4)])));

return statearr_20901;
})();
var inst_20875 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(o);
var inst_20876 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20875);
var state_20892__$1 = state_20892;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20892__$1,(6),inst_20876);
} else {
if((state_val_20893 === (9))){
var inst_20883 = (state_20892[(2)]);
var inst_20884 = [new cljs.core.Keyword(null,"value","value",305978217)];
var inst_20885 = [inst_20883];
var inst_20886 = cljs.core.PersistentHashMap.fromArrays(inst_20884,inst_20885);
var inst_20887 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(where_clause,new cljs.core.Keyword(null,"o","o",-1350007228),inst_20886);
var _ = (function (){var statearr_20902 = state_20892;
(statearr_20902[(4)] = cljs.core.rest((state_20892[(4)])));

return statearr_20902;
})();
var state_20892__$1 = state_20892;
var statearr_20903_20918 = state_20892__$1;
(statearr_20903_20918[(2)] = inst_20887);

(statearr_20903_20918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (5))){
var _ = (function (){var statearr_20904 = state_20892;
(statearr_20904[(4)] = cljs.core.rest((state_20892[(4)])));

return statearr_20904;
})();
var state_20892__$1 = state_20892;
var ex20900 = (state_20892__$1[(2)]);
var statearr_20905_20919 = state_20892__$1;
(statearr_20905_20919[(5)] = ex20900);


if((ex20900 instanceof Error)){
var statearr_20906_20920 = state_20892__$1;
(statearr_20906_20920[(1)] = (4));

(statearr_20906_20920[(5)] = null);

} else {
throw ex20900;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20893 === (8))){
var state_20892__$1 = state_20892;
var statearr_20907_20921 = state_20892__$1;
(statearr_20907_20921[(2)] = (0));

(statearr_20907_20921[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0 = (function (){
var statearr_20908 = [null,null,null,null,null,null,null,null];
(statearr_20908[(0)] = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__);

(statearr_20908[(1)] = (1));

return statearr_20908;
});
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1 = (function (state_20892){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20892);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20909){var ex__2687__auto__ = e20909;
var statearr_20910_20922 = state_20892;
(statearr_20910_20922[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20892[(4)]))){
var statearr_20911_20923 = state_20892;
(statearr_20911_20923[(1)] = cljs.core.first((state_20892[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20924 = state_20892;
state_20892 = G__20924;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__ = function(state_20892){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1.call(this,state_20892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20912 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20912[(6)] = c__2706__auto__);

return statearr_20912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__20925){
var map__20926 = p__20925;
var map__20926__$1 = cljs.core.__destructure_map(map__20926);
var opts = map__20926__$1;
var finish_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var f_where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var ident_vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"db","db",993250759));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var parse_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20926__$1,new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21021){
var state_val_21022 = (state_21021[(1)]);
if((state_val_21022 === (7))){
var state_21021__$1 = state_21021;
var statearr_21023_21075 = state_21021__$1;
(statearr_21023_21075[(2)] = vars);

(statearr_21023_21075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (20))){
var inst_20974 = (state_21021[(7)]);
var inst_20984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20985 = [error_ch,inst_20974];
var inst_20986 = (new cljs.core.PersistentVector(null,2,(5),inst_20984,inst_20985,null));
var state_21021__$1 = state_21021;
return cljs.core.async.ioc_alts_BANG_(state_21021__$1,(22),inst_20986);
} else {
if((state_val_21022 === (27))){
var state_21021__$1 = state_21021;
var statearr_21024_21076 = state_21021__$1;
(statearr_21024_21076[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (1))){
var state_21021__$1 = state_21021;
var statearr_21026_21077 = state_21021__$1;
(statearr_21026_21077[(2)] = null);

(statearr_21026_21077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (24))){
var inst_20989 = (state_21021[(8)]);
var inst_20998 = (inst_20989 == null);
var state_21021__$1 = state_21021;
if(cljs.core.truth_(inst_20998)){
var statearr_21027_21078 = state_21021__$1;
(statearr_21027_21078[(1)] = (26));

} else {
var statearr_21028_21079 = state_21021__$1;
(statearr_21028_21079[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (4))){
var inst_20927 = (state_21021[(2)]);
var state_21021__$1 = state_21021;
var statearr_21029_21080 = state_21021__$1;
(statearr_21029_21080[(2)] = inst_20927);

(statearr_21029_21080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (15))){
var inst_20960 = (state_21021[(9)]);
var inst_20960__$1 = (state_21021[(2)]);
var inst_20961 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_20960__$1);
var inst_20962 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"_id","_id",-789960287),inst_20961);
var state_21021__$1 = (function (){var statearr_21030 = state_21021;
(statearr_21030[(9)] = inst_20960__$1);

return statearr_21030;
})();
if(inst_20962){
var statearr_21031_21081 = state_21021__$1;
(statearr_21031_21081[(1)] = (17));

} else {
var statearr_21032_21082 = state_21021__$1;
(statearr_21032_21082[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (21))){
var inst_21016 = (state_21021[(2)]);
var _ = (function (){var statearr_21033 = state_21021;
(statearr_21033[(4)] = cljs.core.rest((state_21021[(4)])));

return statearr_21033;
})();
var state_21021__$1 = state_21021;
var statearr_21034_21083 = state_21021__$1;
(statearr_21034_21083[(2)] = inst_21016);

(statearr_21034_21083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (31))){
var inst_21010 = (state_21021[(2)]);
var state_21021__$1 = state_21021;
var statearr_21035_21084 = state_21021__$1;
(statearr_21035_21084[(2)] = inst_21010);

(statearr_21035_21084[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (13))){
var inst_20954 = fluree.db.query.subject_crawl.subject.resolve_o_ident(db,f_where);
var state_21021__$1 = state_21021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21021__$1,(16),inst_20954);
} else {
if((state_val_21022 === (22))){
var inst_20988 = (state_21021[(2)]);
var inst_20989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20988,(0),null);
var inst_20990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20988,(1),null);
var inst_20991 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20990,error_ch);
var state_21021__$1 = (function (){var statearr_21036 = state_21021;
(statearr_21036[(8)] = inst_20989);

return statearr_21036;
})();
if(inst_20991){
var statearr_21037_21085 = state_21021__$1;
(statearr_21037_21085[(1)] = (23));

} else {
var statearr_21038_21086 = state_21021__$1;
(statearr_21038_21086[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (29))){
var inst_20989 = (state_21021[(8)]);
var inst_20979 = (state_21021[(10)]);
var inst_21006 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20979,inst_20989);
var inst_20979__$1 = inst_21006;
var state_21021__$1 = (function (){var statearr_21039 = state_21021;
(statearr_21039[(10)] = inst_20979__$1);

return statearr_21039;
})();
var statearr_21040_21087 = state_21021__$1;
(statearr_21040_21087[(2)] = null);

(statearr_21040_21087[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (6))){
var inst_20940 = fluree.db.query.subject_crawl.common.resolve_ident_vars(db,vars,ident_vars);
var state_21021__$1 = state_21021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21021__$1,(9),inst_20940);
} else {
if((state_val_21022 === (28))){
var inst_21012 = (state_21021[(2)]);
var state_21021__$1 = state_21021;
var statearr_21041_21088 = state_21021__$1;
(statearr_21041_21088[(2)] = inst_21012);

(statearr_21041_21088[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (25))){
var inst_21014 = (state_21021[(2)]);
var state_21021__$1 = state_21021;
var statearr_21042_21089 = state_21021__$1;
(statearr_21042_21089[(2)] = inst_21014);

(statearr_21042_21089[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (17))){
var inst_20946 = (state_21021[(11)]);
var inst_20960 = (state_21021[(9)]);
var inst_20964 = fluree.db.query.subject_crawl.subject.subjects_id_chan(db,error_ch,inst_20946,inst_20960);
var state_21021__$1 = state_21021;
var statearr_21043_21090 = state_21021__$1;
(statearr_21043_21090[(2)] = inst_20964);

(statearr_21043_21090[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (3))){
var inst_21019 = (state_21021[(2)]);
var state_21021__$1 = state_21021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21021__$1,inst_21019);
} else {
if((state_val_21022 === (12))){
var inst_20952 = (state_21021[(2)]);
var state_21021__$1 = state_21021;
if(cljs.core.truth_(inst_20952)){
var statearr_21044_21091 = state_21021__$1;
(statearr_21044_21091[(1)] = (13));

} else {
var statearr_21045_21092 = state_21021__$1;
(statearr_21045_21092[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (2))){
var _ = (function (){var statearr_21046 = state_21021;
(statearr_21046[(4)] = cljs.core.cons((5),(state_21021[(4)])));

return statearr_21046;
})();
var inst_20933 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("subj-crawl opts:",opts) : fluree.db.util.log.debug.call(null,"subj-crawl opts:",opts));
var inst_20935 = f_where;
var inst_20936 = cljs.core.__destructure_map(inst_20935);
var inst_20937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20936,new cljs.core.Keyword(null,"o","o",-1350007228));
var inst_20938 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20936,new cljs.core.Keyword(null,"p-ref?","p-ref?",-1416067934));
var state_21021__$1 = (function (){var statearr_21047 = state_21021;
(statearr_21047[(12)] = inst_20933);

(statearr_21047[(13)] = inst_20937);

(statearr_21047[(14)] = inst_20938);

return statearr_21047;
})();
if(cljs.core.truth_(ident_vars)){
var statearr_21048_21093 = state_21021__$1;
(statearr_21048_21093[(1)] = (6));

} else {
var statearr_21049_21094 = state_21021__$1;
(statearr_21049_21094[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (23))){
var inst_20974 = (state_21021[(7)]);
var inst_20973 = (state_21021[(15)]);
var inst_20968 = (state_21021[(16)]);
var inst_20989 = (state_21021[(8)]);
var inst_20993 = cljs.core.async.close_BANG_(inst_20968);
var inst_20994 = cljs.core.async.close_BANG_(inst_20973);
var inst_20995 = cljs.core.async.close_BANG_(inst_20974);
var inst_20996 = (function(){throw inst_20989})();
var state_21021__$1 = (function (){var statearr_21050 = state_21021;
(statearr_21050[(17)] = inst_20994);

(statearr_21050[(18)] = inst_20995);

(statearr_21050[(19)] = inst_20993);

return statearr_21050;
})();
var statearr_21051_21095 = state_21021__$1;
(statearr_21051_21095[(2)] = inst_20996);

(statearr_21051_21095[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (19))){
var inst_20974 = (state_21021[(7)]);
var inst_20973 = (state_21021[(15)]);
var inst_20968 = (state_21021[(16)]);
var inst_20947 = (state_21021[(20)]);
var inst_20968__$1 = (state_21021[(2)]);
var inst_20969 = fluree.db.query.subject_crawl.subject.flakes_xf(inst_20947);
var inst_20970 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_20971 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_20972 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_20970,inst_20971);
var inst_20973__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((32),inst_20972);
var inst_20974__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_20975 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_20973__$1,inst_20969,inst_20968__$1);
var inst_20976 = fluree.db.query.subject_crawl.common.result_af(inst_20947);
var inst_20977 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_20974__$1,inst_20976,inst_20973__$1);
var inst_20978 = cljs.core.PersistentVector.EMPTY;
var inst_20979 = inst_20978;
var state_21021__$1 = (function (){var statearr_21052 = state_21021;
(statearr_21052[(7)] = inst_20974__$1);

(statearr_21052[(15)] = inst_20973__$1);

(statearr_21052[(16)] = inst_20968__$1);

(statearr_21052[(10)] = inst_20979);

(statearr_21052[(21)] = inst_20975);

(statearr_21052[(22)] = inst_20977);

return statearr_21052;
})();
var statearr_21053_21096 = state_21021__$1;
(statearr_21053_21096[(2)] = null);

(statearr_21053_21096[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (11))){
var inst_20938 = (state_21021[(14)]);
var state_21021__$1 = state_21021;
var statearr_21055_21097 = state_21021__$1;
(statearr_21055_21097[(2)] = inst_20938);

(statearr_21055_21097[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (9))){
var inst_20942 = (state_21021[(2)]);
var inst_20943 = fluree.db.util.async.throw_err(inst_20942);
var state_21021__$1 = state_21021;
var statearr_21056_21098 = state_21021__$1;
(statearr_21056_21098[(2)] = inst_20943);

(statearr_21056_21098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (5))){
var _ = (function (){var statearr_21057 = state_21021;
(statearr_21057[(4)] = cljs.core.rest((state_21021[(4)])));

return statearr_21057;
})();
var state_21021__$1 = state_21021;
var ex21054 = (state_21021__$1[(2)]);
var statearr_21058_21099 = state_21021__$1;
(statearr_21058_21099[(5)] = ex21054);


if((ex21054 instanceof Error)){
var statearr_21059_21100 = state_21021__$1;
(statearr_21059_21100[(1)] = (4));

(statearr_21059_21100[(5)] = null);

} else {
throw ex21054;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (14))){
var state_21021__$1 = state_21021;
var statearr_21060_21101 = state_21021__$1;
(statearr_21060_21101[(2)] = f_where);

(statearr_21060_21101[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (26))){
var inst_20974 = (state_21021[(7)]);
var inst_20973 = (state_21021[(15)]);
var inst_20968 = (state_21021[(16)]);
var inst_20979 = (state_21021[(10)]);
var inst_21000 = cljs.core.async.close_BANG_(inst_20968);
var inst_21001 = cljs.core.async.close_BANG_(inst_20973);
var inst_21002 = cljs.core.async.close_BANG_(inst_20974);
var inst_21003 = (finish_fn.cljs$core$IFn$_invoke$arity$1 ? finish_fn.cljs$core$IFn$_invoke$arity$1(inst_20979) : finish_fn.call(null,inst_20979));
var state_21021__$1 = (function (){var statearr_21061 = state_21021;
(statearr_21061[(23)] = inst_21002);

(statearr_21061[(24)] = inst_21001);

(statearr_21061[(25)] = inst_21000);

return statearr_21061;
})();
var statearr_21062_21102 = state_21021__$1;
(statearr_21062_21102[(2)] = inst_21003);

(statearr_21062_21102[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (16))){
var inst_20956 = (state_21021[(2)]);
var inst_20957 = fluree.db.util.async.throw_err(inst_20956);
var state_21021__$1 = state_21021;
var statearr_21063_21103 = state_21021__$1;
(statearr_21063_21103[(2)] = inst_20957);

(statearr_21063_21103[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (30))){
var state_21021__$1 = state_21021;
var statearr_21064_21104 = state_21021__$1;
(statearr_21064_21104[(2)] = null);

(statearr_21064_21104[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (10))){
var inst_20937 = (state_21021[(13)]);
var inst_20949 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(inst_20937);
var state_21021__$1 = state_21021;
var statearr_21065_21105 = state_21021__$1;
(statearr_21065_21105[(2)] = inst_20949);

(statearr_21065_21105[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (18))){
var inst_20946 = (state_21021[(11)]);
var inst_20960 = (state_21021[(9)]);
var inst_20966 = fluree.db.query.subject_crawl.subject.subjects_chan(db,error_ch,inst_20946,inst_20960,parse_json_QMARK_);
var state_21021__$1 = state_21021;
var statearr_21066_21106 = state_21021__$1;
(statearr_21066_21106[(2)] = inst_20966);

(statearr_21066_21106[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21022 === (8))){
var inst_20946 = (state_21021[(11)]);
var inst_20938 = (state_21021[(14)]);
var inst_20946__$1 = (state_21021[(2)]);
var inst_20947 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_20946__$1);
var state_21021__$1 = (function (){var statearr_21067 = state_21021;
(statearr_21067[(11)] = inst_20946__$1);

(statearr_21067[(20)] = inst_20947);

return statearr_21067;
})();
if(cljs.core.truth_(inst_20938)){
var statearr_21068_21107 = state_21021__$1;
(statearr_21068_21107[(1)] = (10));

} else {
var statearr_21069_21108 = state_21021__$1;
(statearr_21069_21108[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0 = (function (){
var statearr_21070 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21070[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__);

(statearr_21070[(1)] = (1));

return statearr_21070;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1 = (function (state_21021){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21021);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21071){var ex__2687__auto__ = e21071;
var statearr_21072_21109 = state_21021;
(statearr_21072_21109[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21021[(4)]))){
var statearr_21073_21110 = state_21021;
(statearr_21073_21110[(1)] = cljs.core.first((state_21021[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21111 = state_21021;
state_21021 = G__21111;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__ = function(state_21021){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1.call(this,state_21021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21074 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21074[(6)] = c__2706__auto__);

return statearr_21074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
