// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.analytical');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24899 = arguments.length;
switch (G__24899) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__24900 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__24900) : f.call(null,G__24900));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__24901 = cljs.core._deref(vol);
var G__24902 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24901,G__24902) : f.call(null,G__24901,G__24902));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__24903 = cljs.core._deref(vol);
var G__24904 = arg1;
var G__24905 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24903,G__24904,G__24905) : f.call(null,G__24903,G__24904,G__24905));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__24906 = cljs.core._deref(vol);
var G__24907 = arg1;
var G__24908 = arg2;
var G__24909 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__24906,G__24907,G__24908,G__24909) : f.call(null,G__24906,G__24907,G__24908,G__24909));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24912 = arguments.length;
switch (G__24912) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24914 = null;
var G__24914__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__24914__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__24914__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__24914 = function(result,flake){
switch(arguments.length){
case 0:
return G__24914__0.call(this);
case 1:
return G__24914__1.call(this,result);
case 2:
return G__24914__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24914.cljs$core$IFn$_invoke$arity$0 = G__24914__0;
G__24914.cljs$core$IFn$_invoke$arity$1 = G__24914__1;
G__24914.cljs$core$IFn$_invoke$arity$2 = G__24914__2;
return G__24914;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24915_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24915_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24919 = vars;
var vec__24920 = G__24919;
var seq__24921 = cljs.core.seq(vec__24920);
var first__24922 = cljs.core.first(seq__24921);
var seq__24921__$1 = cljs.core.next(seq__24921);
var var$ = first__24922;
var r = seq__24921__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24919__$1 = G__24919;
var all_vars__$1 = all_vars;
while(true){
var vec__24927 = G__24919__$1;
var seq__24928 = cljs.core.seq(vec__24927);
var first__24929 = cljs.core.first(seq__24928);
var seq__24928__$1 = cljs.core.next(seq__24928);
var var$__$1 = first__24929;
var r__$1 = seq__24928__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24930 = cljs.core.set(all_vars__$2);
return (fexpr__24930.cljs$core$IFn$_invoke$arity$1 ? fexpr__24930.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24930.call(null,var$__$1));
})())){
var G__24931 = r__$1;
var G__24932 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24919__$1 = G__24931;
all_vars__$1 = G__24932;
continue;
} else {
var G__24933 = r__$1;
var G__24934 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24919__$1 = G__24933;
all_vars__$1 = G__24934;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24935){
var vec__24936 = p__24935;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24936,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24936,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24950){
var state_val_24951 = (state_24950[(1)]);
if((state_val_24951 === (1))){
var inst_24939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24940 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24941 = [query_map,_id,query_opts];
var inst_24942 = cljs.core.PersistentHashMap.fromArrays(inst_24940,inst_24941);
var inst_24943 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24942) : fluree.db.query.fql.query.call(null,db,inst_24942));
var state_24950__$1 = (function (){var statearr_24952 = state_24950;
(statearr_24952[(7)] = inst_24939);

return statearr_24952;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24950__$1,(2),inst_24943);
} else {
if((state_val_24951 === (2))){
var inst_24939 = (state_24950[(7)]);
var inst_24945 = (state_24950[(2)]);
var inst_24946 = fluree.db.util.async.throw_err(inst_24945);
var inst_24947 = [tuple_index,inst_24946];
var inst_24948 = (new cljs.core.PersistentVector(null,2,(5),inst_24939,inst_24947,null));
var state_24950__$1 = state_24950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24950__$1,inst_24948);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0 = (function (){
var statearr_24953 = [null,null,null,null,null,null,null,null];
(statearr_24953[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2684__auto__);

(statearr_24953[(1)] = (1));

return statearr_24953;
});
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1 = (function (state_24950){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24950);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24954){var ex__2687__auto__ = e24954;
var statearr_24955_24958 = state_24950;
(statearr_24955_24958[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24950[(4)]))){
var statearr_24956_24959 = state_24950;
(statearr_24956_24959[(1)] = cljs.core.first((state_24950[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24960 = state_24950;
state_24950 = G__24960;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__ = function(state_24950){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1.call(this,state_24950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24957 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24957[(6)] = c__2706__auto__);

return statearr_24957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24961 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24961,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24961,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25024){
var state_val_25025 = (state_25024[(1)]);
if((state_val_25025 === (7))){
var inst_25019 = (state_25024[(2)]);
var _ = (function (){var statearr_25026 = state_25024;
(statearr_25026[(4)] = cljs.core.rest((state_25024[(4)])));

return statearr_25026;
})();
var state_25024__$1 = state_25024;
var statearr_25027_25118 = state_25024__$1;
(statearr_25027_25118[(2)] = inst_25019);

(statearr_25027_25118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (20))){
var inst_25010 = (state_25024[(2)]);
var state_25024__$1 = state_25024;
var statearr_25028_25119 = state_25024__$1;
(statearr_25028_25119[(2)] = inst_25010);

(statearr_25028_25119[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (1))){
var state_25024__$1 = state_25024;
var statearr_25029_25120 = state_25024__$1;
(statearr_25029_25120[(2)] = null);

(statearr_25029_25120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (4))){
var inst_24966 = (state_25024[(2)]);
var state_25024__$1 = state_25024;
var statearr_25030_25121 = state_25024__$1;
(statearr_25030_25121[(2)] = inst_24966);

(statearr_25030_25121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (15))){
var inst_24986 = (state_25024[(7)]);
var inst_24995 = cljs.core.second(inst_24986);
var inst_24996 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24995);
var inst_24997 = (inst_24996 > max_fuel);
var state_25024__$1 = state_25024;
if(cljs.core.truth_(inst_24997)){
var statearr_25031_25122 = state_25024__$1;
(statearr_25031_25122[(1)] = (18));

} else {
var statearr_25032_25123 = state_25024__$1;
(statearr_25032_25123[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (13))){
var state_25024__$1 = state_25024;
var statearr_25033_25124 = state_25024__$1;
(statearr_25033_25124[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (6))){
var inst_24974 = (state_25024[(8)]);
var state_25024__$1 = state_25024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25024__$1,(8),inst_24974);
} else {
if((state_val_25025 === (17))){
var inst_25013 = (state_25024[(2)]);
var state_25024__$1 = state_25024;
var statearr_25035_25125 = state_25024__$1;
(statearr_25035_25125[(2)] = inst_25013);

(statearr_25035_25125[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (3))){
var inst_25022 = (state_25024[(2)]);
var state_25024__$1 = state_25024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25024__$1,inst_25022);
} else {
if((state_val_25025 === (12))){
var inst_24986 = (state_25024[(7)]);
var inst_24975 = (state_25024[(9)]);
var inst_24992 = (inst_24975.cljs$core$IFn$_invoke$arity$0 ? inst_24975.cljs$core$IFn$_invoke$arity$0() : inst_24975.call(null));
var state_25024__$1 = (function (){var statearr_25036 = state_25024;
(statearr_25036[(10)] = inst_24992);

return statearr_25036;
})();
var statearr_25037_25126 = state_25024__$1;
(statearr_25037_25126[(2)] = inst_24986);

(statearr_25037_25126[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (2))){
var inst_24975 = (state_25024[(9)]);
var inst_24974 = (state_25024[(8)]);
var _ = (function (){var statearr_25038 = state_25024;
(statearr_25038[(4)] = cljs.core.cons((5),(state_25024[(4)])));

return statearr_25038;
})();
var inst_24972 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24973 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24974__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24975__$1 = (function (){var expandMaps = inst_24972;
var queue_ch = inst_24973;
var res_ch = inst_24974__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24976 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24977 = cljs.core.volatile_BANG_((0));
var inst_24978 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24976,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24977);
var inst_24979 = (function (){var expandMaps = inst_24972;
var queue_ch = inst_24973;
var res_ch = inst_24974__$1;
var stop_BANG_ = inst_24975__$1;
var opts_STAR_ = inst_24978;
return (function (tuple_res,port){
var c__2706__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25071){
var state_val_25072 = (state_25071[(1)]);
if((state_val_25072 === (7))){
var state_25071__$1 = state_25071;
var statearr_25073_25127 = state_25071__$1;
(statearr_25073_25127[(2)] = tuple_res);

(statearr_25073_25127[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (1))){
var state_25071__$1 = state_25071;
var statearr_25074_25128 = state_25071__$1;
(statearr_25074_25128[(2)] = null);

(statearr_25074_25128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (4))){
var inst_25039 = (state_25071[(2)]);
var inst_25040 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_25039);
var inst_25041 = cljs.core.async.close_BANG_(port);
var state_25071__$1 = (function (){var statearr_25075 = state_25071;
(statearr_25075[(7)] = inst_25040);

return statearr_25075;
})();
var statearr_25076_25129 = state_25071__$1;
(statearr_25076_25129[(2)] = inst_25041);

(statearr_25076_25129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (6))){
var inst_25048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25049 = [tuple_res];
var inst_25050 = (new cljs.core.PersistentVector(null,1,(5),inst_25048,inst_25049,null));
var state_25071__$1 = state_25071;
var statearr_25077_25130 = state_25071__$1;
(statearr_25077_25130[(2)] = inst_25050);

(statearr_25077_25130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (3))){
var inst_25069 = (state_25071[(2)]);
var state_25071__$1 = state_25071;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25071__$1,inst_25069);
} else {
if((state_val_25072 === (2))){
var ___$1 = (function (){var statearr_25079 = state_25071;
(statearr_25079[(4)] = cljs.core.cons((5),(state_25071[(4)])));

return statearr_25079;
})();
var state_25071__$1 = state_25071;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_25080_25131 = state_25071__$1;
(statearr_25080_25131[(1)] = (6));

} else {
var statearr_25081_25132 = state_25071__$1;
(statearr_25081_25132[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (9))){
var inst_25053 = (state_25071[(8)]);
var inst_25055 = (state_25071[(9)]);
var inst_25062 = (state_25071[(2)]);
var inst_25063 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_25053,inst_25062);
var inst_25064 = (inst_25055.cljs$core$IFn$_invoke$arity$1 ? inst_25055.cljs$core$IFn$_invoke$arity$1(inst_25063) : inst_25055.call(null,inst_25063));
var inst_25065 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_25064);
var inst_25066 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_25082 = state_25071;
(statearr_25082[(4)] = cljs.core.rest((state_25071[(4)])));

return statearr_25082;
})();
var state_25071__$1 = (function (){var statearr_25083 = state_25071;
(statearr_25083[(10)] = inst_25065);

return statearr_25083;
})();
var statearr_25084_25133 = state_25071__$1;
(statearr_25084_25133[(2)] = inst_25066);

(statearr_25084_25133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (5))){
var ___$1 = (function (){var statearr_25085 = state_25071;
(statearr_25085[(4)] = cljs.core.rest((state_25071[(4)])));

return statearr_25085;
})();
var state_25071__$1 = state_25071;
var ex25078 = (state_25071__$1[(2)]);
var statearr_25086_25134 = state_25071__$1;
(statearr_25086_25134[(5)] = ex25078);


var statearr_25087_25135 = state_25071__$1;
(statearr_25087_25135[(1)] = (4));

(statearr_25087_25135[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25072 === (8))){
var inst_25053 = (state_25071[(8)]);
var inst_25053__$1 = (state_25071[(2)]);
var inst_25054 = cljs.core.volatile_BANG_((0));
var inst_25055 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25053__$1;
var query_fuel = inst_25054;
return (function (p1__24965_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24965_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24965_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_25056 = cljs.core.PersistentVector.EMPTY;
var inst_25057 = (function (){var tuple_res_SINGLEQUOTE_ = inst_25053__$1;
var query_fuel = inst_25054;
return (function (p1__24964_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24964_SHARP_);
});
})();
var inst_25058 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_25057,expandMaps);
var inst_25059 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_25058);
var inst_25060 = cljs.core.async.into(inst_25056,inst_25059);
var state_25071__$1 = (function (){var statearr_25088 = state_25071;
(statearr_25088[(8)] = inst_25053__$1);

(statearr_25088[(9)] = inst_25055);

return statearr_25088;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25071__$1,(9),inst_25060);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0 = (function (){
var statearr_25089 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25089[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__);

(statearr_25089[(1)] = (1));

return statearr_25089;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1 = (function (state_25071){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25071);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25090){var ex__2687__auto__ = e25090;
var statearr_25091_25136 = state_25071;
(statearr_25091_25136[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25071[(4)]))){
var statearr_25092_25137 = state_25071;
(statearr_25092_25137[(1)] = cljs.core.first((state_25071[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25138 = state_25071;
state_25071 = G__25138;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = function(state_25071){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1.call(this,state_25071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25093 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25093[(6)] = c__2706__auto____$1);

return statearr_25093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto____$1;
});
})();
var inst_24980 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24973,tuples_res);
var inst_24981 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24974__$1,inst_24979,inst_24973);
var inst_24982 = cljs.core.PersistentVector.EMPTY;
var inst_24983 = inst_24982;
var state_25024__$1 = (function (){var statearr_25094 = state_25024;
(statearr_25094[(11)] = inst_24981);

(statearr_25094[(12)] = inst_24980);

(statearr_25094[(9)] = inst_24975__$1);

(statearr_25094[(13)] = inst_24983);

(statearr_25094[(8)] = inst_24974__$1);

return statearr_25094;
})();
var statearr_25095_25139 = state_25024__$1;
(statearr_25095_25139[(2)] = null);

(statearr_25095_25139[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (19))){
var inst_24986 = (state_25024[(7)]);
var inst_24983 = (state_25024[(13)]);
var inst_25006 = cljs.core.first(inst_24986);
var inst_25007 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24983,inst_25006);
var inst_24983__$1 = inst_25007;
var state_25024__$1 = (function (){var statearr_25096 = state_25024;
(statearr_25096[(13)] = inst_24983__$1);

return statearr_25096;
})();
var statearr_25097_25140 = state_25024__$1;
(statearr_25097_25140[(2)] = null);

(statearr_25097_25140[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (11))){
var inst_25017 = (state_25024[(2)]);
var state_25024__$1 = state_25024;
var statearr_25099_25141 = state_25024__$1;
(statearr_25099_25141[(2)] = inst_25017);

(statearr_25099_25141[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (9))){
var inst_24983 = (state_25024[(13)]);
var state_25024__$1 = state_25024;
var statearr_25100_25142 = state_25024__$1;
(statearr_25100_25142[(2)] = inst_24983);

(statearr_25100_25142[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (5))){
var _ = (function (){var statearr_25101 = state_25024;
(statearr_25101[(4)] = cljs.core.rest((state_25024[(4)])));

return statearr_25101;
})();
var state_25024__$1 = state_25024;
var ex25098 = (state_25024__$1[(2)]);
var statearr_25102_25143 = state_25024__$1;
(statearr_25102_25143[(5)] = ex25098);


if((ex25098 instanceof Error)){
var statearr_25103_25144 = state_25024__$1;
(statearr_25103_25144[(1)] = (4));

(statearr_25103_25144[(5)] = null);

} else {
throw ex25098;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (14))){
var inst_25015 = (state_25024[(2)]);
var state_25024__$1 = state_25024;
var statearr_25104_25145 = state_25024__$1;
(statearr_25104_25145[(2)] = inst_25015);

(statearr_25104_25145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (16))){
var state_25024__$1 = state_25024;
var statearr_25105_25146 = state_25024__$1;
(statearr_25105_25146[(2)] = null);

(statearr_25105_25146[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (10))){
var inst_24986 = (state_25024[(7)]);
var inst_24990 = fluree.db.util.core.exception_QMARK_(inst_24986);
var state_25024__$1 = state_25024;
if(inst_24990){
var statearr_25106_25147 = state_25024__$1;
(statearr_25106_25147[(1)] = (12));

} else {
var statearr_25107_25148 = state_25024__$1;
(statearr_25107_25148[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (18))){
var inst_24975 = (state_25024[(9)]);
var inst_24999 = (inst_24975.cljs$core$IFn$_invoke$arity$0 ? inst_24975.cljs$core$IFn$_invoke$arity$0() : inst_24975.call(null));
var inst_25000 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_25001 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25002 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_25003 = cljs.core.PersistentHashMap.fromArrays(inst_25001,inst_25002);
var inst_25004 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25000,inst_25003);
var state_25024__$1 = (function (){var statearr_25108 = state_25024;
(statearr_25108[(14)] = inst_24999);

return statearr_25108;
})();
var statearr_25109_25149 = state_25024__$1;
(statearr_25109_25149[(2)] = inst_25004);

(statearr_25109_25149[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25025 === (8))){
var inst_24986 = (state_25024[(7)]);
var inst_24986__$1 = (state_25024[(2)]);
var inst_24987 = (inst_24986__$1 == null);
var state_25024__$1 = (function (){var statearr_25110 = state_25024;
(statearr_25110[(7)] = inst_24986__$1);

return statearr_25110;
})();
if(cljs.core.truth_(inst_24987)){
var statearr_25111_25150 = state_25024__$1;
(statearr_25111_25150[(1)] = (9));

} else {
var statearr_25112_25151 = state_25024__$1;
(statearr_25112_25151[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0 = (function (){
var statearr_25113 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25113[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__);

(statearr_25113[(1)] = (1));

return statearr_25113;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1 = (function (state_25024){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25024);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25114){var ex__2687__auto__ = e25114;
var statearr_25115_25152 = state_25024;
(statearr_25115_25152[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25024[(4)]))){
var statearr_25116_25153 = state_25024;
(statearr_25116_25153[(1)] = cljs.core.first((state_25024[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25154 = state_25024;
state_25024 = G__25154;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = function(state_25024){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1.call(this,state_25024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25117 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25117[(6)] = c__2706__auto__);

return statearr_25117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__25155 = select;
var map__25155__$1 = cljs.core.__destructure_map(map__25155);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25155__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25155__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25155__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__25158 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25158,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25158,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25158,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__25156_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25156_SHARP_,compare_idx));
}):(function (p1__25157_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25157_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__25163 = arguments.length;
switch (G__25163) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__25164,p__25165,group_limit,opts){
var map__25166 = p__25164;
var map__25166__$1 = cljs.core.__destructure_map(map__25166);
var res = map__25166__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25166__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25167 = p__25165;
var map__25167__$1 = cljs.core.__destructure_map(map__25167);
var select_spec = map__25167__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25167__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25304){
var state_val_25305 = (state_25304[(1)]);
if((state_val_25305 === (7))){
var inst_25174 = (state_25304[(7)]);
var state_25304__$1 = state_25304;
var statearr_25306_25408 = state_25304__$1;
(statearr_25306_25408[(2)] = inst_25174);

(statearr_25306_25408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (59))){
var inst_25297 = (state_25304[(2)]);
var state_25304__$1 = state_25304;
var statearr_25307_25409 = state_25304__$1;
(statearr_25307_25409[(2)] = inst_25297);

(statearr_25307_25409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (20))){
var inst_25210 = (state_25304[(8)]);
var inst_25213 = (state_25304[(9)]);
var inst_25209 = (state_25304[(2)]);
var inst_25210__$1 = cljs.core.__destructure_map(inst_25209);
var inst_25211 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25210__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25212 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25210__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25213__$1 = offset;
var state_25304__$1 = (function (){var statearr_25308 = state_25304;
(statearr_25308[(8)] = inst_25210__$1);

(statearr_25308[(10)] = inst_25211);

(statearr_25308[(9)] = inst_25213__$1);

(statearr_25308[(11)] = inst_25212);

return statearr_25308;
})();
if(cljs.core.truth_(inst_25213__$1)){
var statearr_25309_25410 = state_25304__$1;
(statearr_25309_25410[(1)] = (21));

} else {
var statearr_25310_25411 = state_25304__$1;
(statearr_25310_25411[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (58))){
var inst_25289 = (state_25304[(12)]);
var state_25304__$1 = state_25304;
var statearr_25311_25412 = state_25304__$1;
(statearr_25311_25412[(2)] = inst_25289);

(statearr_25311_25412[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (60))){
var inst_25293 = (state_25304[(2)]);
var inst_25294 = fluree.db.util.async.throw_err(inst_25293);
var state_25304__$1 = state_25304;
var statearr_25312_25413 = state_25304__$1;
(statearr_25312_25413[(2)] = inst_25294);

(statearr_25312_25413[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (27))){
var inst_25225 = cljs.core.not(inVector_QMARK_);
var state_25304__$1 = state_25304;
var statearr_25313_25414 = state_25304__$1;
(statearr_25313_25414[(2)] = inst_25225);

(statearr_25313_25414[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (1))){
var state_25304__$1 = state_25304;
var statearr_25314_25415 = state_25304__$1;
(statearr_25314_25415[(2)] = null);

(statearr_25314_25415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (24))){
var state_25304__$1 = state_25304;
var statearr_25315_25416 = state_25304__$1;
(statearr_25315_25416[(2)] = offset);

(statearr_25315_25416[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (55))){
var inst_25283 = (state_25304[(13)]);
var state_25304__$1 = state_25304;
var statearr_25316_25417 = state_25304__$1;
(statearr_25316_25417[(2)] = inst_25283);

(statearr_25316_25417[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (39))){
var inst_25251 = (state_25304[(14)]);
var inst_25253 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25254 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25251,inst_25253);
var state_25304__$1 = state_25304;
var statearr_25317_25418 = state_25304__$1;
(statearr_25317_25418[(2)] = inst_25254);

(statearr_25317_25418[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (46))){
var inst_25263 = (state_25304[(15)]);
var state_25304__$1 = state_25304;
var statearr_25318_25419 = state_25304__$1;
(statearr_25318_25419[(2)] = inst_25263);

(statearr_25318_25419[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (4))){
var inst_25168 = (state_25304[(2)]);
var state_25304__$1 = state_25304;
var statearr_25319_25420 = state_25304__$1;
(statearr_25319_25420[(2)] = inst_25168);

(statearr_25319_25420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (54))){
var inst_25283 = (state_25304[(13)]);
var inst_25277 = (state_25304[(16)]);
var inst_25285 = cljs.core.PersistentVector.EMPTY;
var inst_25286 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_25285,inst_25277,inst_25283);
var state_25304__$1 = state_25304;
var statearr_25320_25421 = state_25304__$1;
(statearr_25320_25421[(2)] = inst_25286);

(statearr_25320_25421[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (15))){
var inst_25195 = (state_25304[(17)]);
var inst_25197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25198 = [inst_25195];
var inst_25199 = (new cljs.core.PersistentVector(null,1,(5),inst_25197,inst_25198,null));
var state_25304__$1 = state_25304;
var statearr_25321_25422 = state_25304__$1;
(statearr_25321_25422[(2)] = inst_25199);

(statearr_25321_25422[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (48))){
var inst_25228 = (state_25304[(18)]);
var inst_25210 = (state_25304[(8)]);
var inst_25269 = (state_25304[(19)]);
var inst_25211 = (state_25304[(10)]);
var inst_25233 = (state_25304[(20)]);
var inst_25212 = (state_25304[(11)]);
var inst_25222 = (state_25304[(21)]);
var inst_25271 = (function (){var map__25204 = inst_25210;
var headers = inst_25211;
var tuples = inst_25212;
var offset_SINGLEQUOTE_ = inst_25222;
var single_result_QMARK_ = inst_25228;
var pp_keys = inst_25233;
var G__25234 = inst_25269;
return (function (p1__25161_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__25161_SHARP_);
});
})();
var inst_25272 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25271);
var inst_25273 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25269,inst_25272);
var state_25304__$1 = state_25304;
var statearr_25322_25423 = state_25304__$1;
(statearr_25322_25423[(2)] = inst_25273);

(statearr_25322_25423[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (50))){
var inst_25276 = (state_25304[(2)]);
var inst_25277 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_25276);
var state_25304__$1 = (function (){var statearr_25323 = state_25304;
(statearr_25323[(16)] = inst_25277);

return statearr_25323;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25324_25424 = state_25304__$1;
(statearr_25324_25424[(1)] = (51));

} else {
var statearr_25325_25425 = state_25304__$1;
(statearr_25325_25425[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (21))){
var inst_25215 = cljs.core.not(groupBy);
var state_25304__$1 = state_25304;
var statearr_25326_25426 = state_25304__$1;
(statearr_25326_25426[(2)] = inst_25215);

(statearr_25326_25426[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (31))){
var state_25304__$1 = state_25304;
var statearr_25327_25427 = state_25304__$1;
(statearr_25327_25427[(2)] = null);

(statearr_25327_25427[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (32))){
var inst_25228 = (state_25304[(18)]);
var inst_25211 = (state_25304[(10)]);
var inst_25233 = (state_25304[(2)]);
var inst_25235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25236 = fluree.db.query.fql.select_tuples_fn(inst_25211,vars,select);
var inst_25237 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25236);
var inst_25238 = [inst_25237];
var inst_25239 = (new cljs.core.PersistentVector(null,1,(5),inst_25235,inst_25238,null));
var state_25304__$1 = (function (){var statearr_25328 = state_25304;
(statearr_25328[(20)] = inst_25233);

(statearr_25328[(22)] = inst_25239);

return statearr_25328;
})();
if(cljs.core.truth_(inst_25228)){
var statearr_25329_25428 = state_25304__$1;
(statearr_25329_25428[(1)] = (33));

} else {
var statearr_25330_25429 = state_25304__$1;
(statearr_25330_25429[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (40))){
var inst_25251 = (state_25304[(14)]);
var state_25304__$1 = state_25304;
var statearr_25331_25430 = state_25304__$1;
(statearr_25331_25430[(2)] = inst_25251);

(statearr_25331_25430[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (56))){
var inst_25289 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25332 = state_25304;
(statearr_25332[(12)] = inst_25289);

return statearr_25332;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25333_25431 = state_25304__$1;
(statearr_25333_25431[(1)] = (57));

} else {
var statearr_25334_25432 = state_25304__$1;
(statearr_25334_25432[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (33))){
var inst_25239 = (state_25304[(22)]);
var inst_25241 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_25242 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25239,inst_25241);
var state_25304__$1 = state_25304;
var statearr_25335_25433 = state_25304__$1;
(statearr_25335_25433[(2)] = inst_25242);

(statearr_25335_25433[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (13))){
var inst_25184 = (state_25304[(23)]);
var state_25304__$1 = state_25304;
var statearr_25336_25434 = state_25304__$1;
(statearr_25336_25434[(2)] = inst_25184);

(statearr_25336_25434[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (22))){
var inst_25213 = (state_25304[(9)]);
var state_25304__$1 = state_25304;
var statearr_25337_25435 = state_25304__$1;
(statearr_25337_25435[(2)] = inst_25213);

(statearr_25337_25435[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (36))){
var inst_25245 = (state_25304[(24)]);
var inst_25247 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_25248 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25245,inst_25247);
var state_25304__$1 = state_25304;
var statearr_25338_25436 = state_25304__$1;
(statearr_25338_25436[(2)] = inst_25248);

(statearr_25338_25436[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (41))){
var inst_25222 = (state_25304[(21)]);
var inst_25257 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25339 = state_25304;
(statearr_25339[(25)] = inst_25257);

return statearr_25339;
})();
if(cljs.core.truth_(inst_25222)){
var statearr_25340_25437 = state_25304__$1;
(statearr_25340_25437[(1)] = (42));

} else {
var statearr_25341_25438 = state_25304__$1;
(statearr_25341_25438[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (43))){
var inst_25257 = (state_25304[(25)]);
var state_25304__$1 = state_25304;
var statearr_25342_25439 = state_25304__$1;
(statearr_25342_25439[(2)] = inst_25257);

(statearr_25342_25439[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (29))){
var inst_25228 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25343 = state_25304;
(statearr_25343[(18)] = inst_25228);

return statearr_25343;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25344_25440 = state_25304__$1;
(statearr_25344_25440[(1)] = (30));

} else {
var statearr_25345_25441 = state_25304__$1;
(statearr_25345_25441[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (44))){
var inst_25263 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25346 = state_25304;
(statearr_25346[(15)] = inst_25263);

return statearr_25346;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25347_25442 = state_25304__$1;
(statearr_25347_25442[(1)] = (45));

} else {
var statearr_25348_25443 = state_25304__$1;
(statearr_25348_25443[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (6))){
var inst_25176 = cljs.core.count(select);
var inst_25177 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_25176);
var state_25304__$1 = state_25304;
var statearr_25349_25444 = state_25304__$1;
(statearr_25349_25444[(2)] = inst_25177);

(statearr_25349_25444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (28))){
var inst_25223 = (state_25304[(26)]);
var state_25304__$1 = state_25304;
var statearr_25350_25445 = state_25304__$1;
(statearr_25350_25445[(2)] = inst_25223);

(statearr_25350_25445[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (51))){
var inst_25211 = (state_25304[(10)]);
var inst_25212 = (state_25304[(11)]);
var inst_25280 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_25211,orderBy,inst_25212);
var state_25304__$1 = state_25304;
var statearr_25351_25446 = state_25304__$1;
(statearr_25351_25446[(2)] = inst_25280);

(statearr_25351_25446[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (25))){
var state_25304__$1 = state_25304;
var statearr_25352_25447 = state_25304__$1;
(statearr_25352_25447[(2)] = null);

(statearr_25352_25447[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (34))){
var inst_25239 = (state_25304[(22)]);
var state_25304__$1 = state_25304;
var statearr_25353_25448 = state_25304__$1;
(statearr_25353_25448[(2)] = inst_25239);

(statearr_25353_25448[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (17))){
var inst_25202 = (state_25304[(2)]);
var state_25304__$1 = state_25304;
var statearr_25354_25449 = state_25304__$1;
(statearr_25354_25449[(2)] = inst_25202);

(statearr_25354_25449[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (3))){
var inst_25302 = (state_25304[(2)]);
var state_25304__$1 = state_25304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25304__$1,inst_25302);
} else {
if((state_val_25305 === (12))){
var inst_25184 = (state_25304[(23)]);
var inst_25186 = cljs.core.first(select);
var inst_25187 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25186);
var inst_25188 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25187);
var inst_25189 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_25188,(1));
var inst_25190 = [inst_25189];
var inst_25191 = [inst_25184];
var inst_25192 = cljs.core.PersistentHashMap.fromArrays(inst_25190,inst_25191);
var state_25304__$1 = state_25304;
var statearr_25355_25450 = state_25304__$1;
(statearr_25355_25450[(2)] = inst_25192);

(statearr_25355_25450[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (2))){
var inst_25174 = (state_25304[(7)]);
var _ = (function (){var statearr_25356 = state_25304;
(statearr_25356[(4)] = cljs.core.cons((5),(state_25304[(4)])));

return statearr_25356;
})();
var inst_25174__$1 = aggregates;
var state_25304__$1 = (function (){var statearr_25357 = state_25304;
(statearr_25357[(7)] = inst_25174__$1);

return statearr_25357;
})();
if(cljs.core.truth_(inst_25174__$1)){
var statearr_25358_25451 = state_25304__$1;
(statearr_25358_25451[(1)] = (6));

} else {
var statearr_25359_25452 = state_25304__$1;
(statearr_25359_25452[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (23))){
var inst_25218 = (state_25304[(2)]);
var state_25304__$1 = state_25304;
if(cljs.core.truth_(inst_25218)){
var statearr_25360_25453 = state_25304__$1;
(statearr_25360_25453[(1)] = (24));

} else {
var statearr_25361_25454 = state_25304__$1;
(statearr_25361_25454[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (47))){
var inst_25269 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25362 = state_25304;
(statearr_25362[(19)] = inst_25269);

return statearr_25362;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25363_25455 = state_25304__$1;
(statearr_25363_25455[(1)] = (48));

} else {
var statearr_25364_25456 = state_25304__$1;
(statearr_25364_25456[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (35))){
var inst_25245 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25365 = state_25304;
(statearr_25365[(24)] = inst_25245);

return statearr_25365;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25366_25457 = state_25304__$1;
(statearr_25366_25457[(1)] = (36));

} else {
var statearr_25367_25458 = state_25304__$1;
(statearr_25367_25458[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (19))){
var state_25304__$1 = state_25304;
var statearr_25368_25459 = state_25304__$1;
(statearr_25368_25459[(2)] = res);

(statearr_25368_25459[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (57))){
var inst_25228 = (state_25304[(18)]);
var inst_25289 = (state_25304[(12)]);
var inst_25233 = (state_25304[(20)]);
var inst_25291 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_25233,inst_25228,db,fuel,max_fuel,opts,(8),inst_25289);
var state_25304__$1 = state_25304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25304__$1,(60),inst_25291);
} else {
if((state_val_25305 === (11))){
var inst_25299 = (state_25304[(2)]);
var _ = (function (){var statearr_25370 = state_25304;
(statearr_25370[(4)] = cljs.core.rest((state_25304[(4)])));

return statearr_25370;
})();
var state_25304__$1 = state_25304;
var statearr_25371_25460 = state_25304__$1;
(statearr_25371_25460[(2)] = inst_25299);

(statearr_25371_25460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (9))){
var inst_25182 = cljs.core.first(aggregates);
var inst_25183 = fluree.db.query.analytical.calculate_aggregate(res,inst_25182);
var inst_25184 = cljs.core.second(inst_25183);
var state_25304__$1 = (function (){var statearr_25372 = state_25304;
(statearr_25372[(23)] = inst_25184);

return statearr_25372;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25373_25461 = state_25304__$1;
(statearr_25373_25461[(1)] = (12));

} else {
var statearr_25374_25462 = state_25304__$1;
(statearr_25374_25462[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (5))){
var _ = (function (){var statearr_25375 = state_25304;
(statearr_25375[(4)] = cljs.core.rest((state_25304[(4)])));

return statearr_25375;
})();
var state_25304__$1 = state_25304;
var ex25369 = (state_25304__$1[(2)]);
var statearr_25376_25463 = state_25304__$1;
(statearr_25376_25463[(5)] = ex25369);


if((ex25369 instanceof Error)){
var statearr_25377_25464 = state_25304__$1;
(statearr_25377_25464[(1)] = (4));

(statearr_25377_25464[(5)] = null);

} else {
throw ex25369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (14))){
var inst_25195 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25378 = state_25304;
(statearr_25378[(17)] = inst_25195);

return statearr_25378;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25379_25465 = state_25304__$1;
(statearr_25379_25465[(1)] = (15));

} else {
var statearr_25380_25466 = state_25304__$1;
(statearr_25380_25466[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (45))){
var inst_25263 = (state_25304[(15)]);
var inst_25265 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_25266 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25263,inst_25265);
var state_25304__$1 = state_25304;
var statearr_25381_25467 = state_25304__$1;
(statearr_25381_25467[(2)] = inst_25266);

(statearr_25381_25467[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (53))){
var inst_25283 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25382 = state_25304;
(statearr_25382[(13)] = inst_25283);

return statearr_25382;
})();
var statearr_25383_25468 = state_25304__$1;
(statearr_25383_25468[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (26))){
var inst_25223 = (state_25304[(26)]);
var inst_25222 = (state_25304[(2)]);
var inst_25223__$1 = cljs.core.not(prettyPrint);
var state_25304__$1 = (function (){var statearr_25385 = state_25304;
(statearr_25385[(26)] = inst_25223__$1);

(statearr_25385[(21)] = inst_25222);

return statearr_25385;
})();
if(inst_25223__$1){
var statearr_25386_25469 = state_25304__$1;
(statearr_25386_25469[(1)] = (27));

} else {
var statearr_25387_25470 = state_25304__$1;
(statearr_25387_25470[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (16))){
var inst_25195 = (state_25304[(17)]);
var state_25304__$1 = state_25304;
var statearr_25388_25471 = state_25304__$1;
(statearr_25388_25471[(2)] = inst_25195);

(statearr_25388_25471[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (38))){
var inst_25251 = (state_25304[(2)]);
var state_25304__$1 = (function (){var statearr_25389 = state_25304;
(statearr_25389[(14)] = inst_25251);

return statearr_25389;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25390_25472 = state_25304__$1;
(statearr_25390_25472[(1)] = (39));

} else {
var statearr_25391_25473 = state_25304__$1;
(statearr_25391_25473[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (30))){
var inst_25230 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25304__$1 = state_25304;
var statearr_25392_25474 = state_25304__$1;
(statearr_25392_25474[(2)] = inst_25230);

(statearr_25392_25474[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (10))){
var state_25304__$1 = state_25304;
if(cljs.core.truth_(aggregates)){
var statearr_25393_25475 = state_25304__$1;
(statearr_25393_25475[(1)] = (18));

} else {
var statearr_25394_25476 = state_25304__$1;
(statearr_25394_25476[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (18))){
var inst_25206 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25304__$1 = state_25304;
var statearr_25395_25477 = state_25304__$1;
(statearr_25395_25477[(2)] = inst_25206);

(statearr_25395_25477[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (52))){
var inst_25212 = (state_25304[(11)]);
var state_25304__$1 = state_25304;
var statearr_25396_25478 = state_25304__$1;
(statearr_25396_25478[(2)] = inst_25212);

(statearr_25396_25478[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (42))){
var inst_25257 = (state_25304[(25)]);
var inst_25222 = (state_25304[(21)]);
var inst_25259 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_25222);
var inst_25260 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25257,inst_25259);
var state_25304__$1 = state_25304;
var statearr_25397_25479 = state_25304__$1;
(statearr_25397_25479[(2)] = inst_25260);

(statearr_25397_25479[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (37))){
var inst_25245 = (state_25304[(24)]);
var state_25304__$1 = state_25304;
var statearr_25398_25480 = state_25304__$1;
(statearr_25398_25480[(2)] = inst_25245);

(statearr_25398_25480[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (8))){
var inst_25180 = (state_25304[(2)]);
var state_25304__$1 = state_25304;
if(cljs.core.truth_(inst_25180)){
var statearr_25399_25481 = state_25304__$1;
(statearr_25399_25481[(1)] = (9));

} else {
var statearr_25400_25482 = state_25304__$1;
(statearr_25400_25482[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25305 === (49))){
var inst_25269 = (state_25304[(19)]);
var state_25304__$1 = state_25304;
var statearr_25401_25483 = state_25304__$1;
(statearr_25401_25483[(2)] = inst_25269);

(statearr_25401_25483[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2684__auto__ = null;
var fluree$db$query$fql$state_machine__2684__auto____0 = (function (){
var statearr_25402 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25402[(0)] = fluree$db$query$fql$state_machine__2684__auto__);

(statearr_25402[(1)] = (1));

return statearr_25402;
});
var fluree$db$query$fql$state_machine__2684__auto____1 = (function (state_25304){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25304);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25403){var ex__2687__auto__ = e25403;
var statearr_25404_25484 = state_25304;
(statearr_25404_25484[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25304[(4)]))){
var statearr_25405_25485 = state_25304;
(statearr_25405_25485[(1)] = cljs.core.first((state_25304[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25486 = state_25304;
state_25304 = G__25486;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2684__auto__ = function(state_25304){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2684__auto____1.call(this,state_25304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2684__auto____0;
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2684__auto____1;
return fluree$db$query$fql$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25406 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25406[(6)] = c__2706__auto__);

return statearr_25406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25489,groupBy){
var map__25490 = p__25489;
var map__25490__$1 = cljs.core.__destructure_map(map__25490);
var res = map__25490__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25490__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25490__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25491 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25491,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25491,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25487_SHARP_){
return fluree.db.util.core.index_of(headers,p1__25487_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25488_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__25488_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25494 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25494,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25494,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25497,headers,group_map){
var map__25498 = p__25497;
var map__25498__$1 = cljs.core.__destructure_map(map__25498);
var having = map__25498__$1;
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25498__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25498__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes(params,headers);
var filtered = (function (){var G__25505 = group_map;
var vec__25506 = G__25505;
var seq__25507 = cljs.core.seq(vec__25506);
var first__25508 = cljs.core.first(seq__25507);
var seq__25507__$1 = cljs.core.next(seq__25507);
var vec__25509 = first__25508;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25509,(0),null);
var tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25509,(1),null);
var r = seq__25507__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25505__$1 = G__25505;
var acc__$1 = acc;
while(true){
var vec__25521 = G__25505__$1;
var seq__25522 = cljs.core.seq(vec__25521);
var first__25523 = cljs.core.first(seq__25522);
var seq__25522__$1 = cljs.core.next(seq__25522);
var vec__25524 = first__25523;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25524,(0),null);
var tuples__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25524,(1),null);
var r__$1 = seq__25522__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten(fluree.db.query.analytical.transform_tuples_to_idxs(idxs,tuples__$1));
var res = (function (){try{return (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(argument) : function$.call(null,argument));
}catch (e25527){var e = e25527;
var G__25528_25530 = e;
var G__25529_25531 = ["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__25528_25530,G__25529_25531) : fluree.db.util.log.error.call(null,G__25528_25530,G__25529_25531));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message(e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25532 = r__$1;
var G__25533 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc__$2,k__$1,tuples__$1);
G__25505__$1 = G__25532;
acc__$1 = G__25533;
continue;
} else {
var G__25534 = r__$1;
var G__25535 = acc__$2;
G__25505__$1 = G__25534;
acc__$1 = G__25535;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25536,p__25537,opts){
var map__25538 = p__25536;
var map__25538__$1 = cljs.core.__destructure_map(map__25538);
var res = map__25538__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25538__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25538__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25539 = p__25537;
var map__25539__$1 = cljs.core.__destructure_map(map__25539);
var select_spec = map__25539__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25539__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25539__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25539__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25539__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25539__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25539__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25539__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25539__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25663){
var state_val_25664 = (state_25663[(1)]);
if((state_val_25664 === (7))){
var state_25663__$1 = state_25663;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25665_25738 = state_25663__$1;
(statearr_25665_25738[(1)] = (30));

} else {
var statearr_25666_25739 = state_25663__$1;
(statearr_25666_25739[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (20))){
var inst_25570 = (state_25663[(2)]);
var state_25663__$1 = (function (){var statearr_25667 = state_25663;
(statearr_25667[(7)] = inst_25570);

return statearr_25667;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25668_25740 = state_25663__$1;
(statearr_25668_25740[(1)] = (21));

} else {
var statearr_25669_25741 = state_25663__$1;
(statearr_25669_25741[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (27))){
var inst_25596 = (state_25663[(8)]);
var state_25663__$1 = state_25663;
var statearr_25670_25742 = state_25663__$1;
(statearr_25670_25742[(2)] = inst_25596);

(statearr_25670_25742[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (1))){
var state_25663__$1 = state_25663;
var statearr_25671_25743 = state_25663__$1;
(statearr_25671_25743[(2)] = null);

(statearr_25671_25743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (24))){
var inst_25595 = (state_25663[(9)]);
var inst_25607 = (state_25663[(10)]);
var inst_25604 = cljs.core.seq(inst_25595);
var inst_25605 = cljs.core.first(inst_25604);
var inst_25606 = cljs.core.next(inst_25604);
var inst_25607__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25605,(0),null);
var inst_25608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25605,(1),null);
var state_25663__$1 = (function (){var statearr_25672 = state_25663;
(statearr_25672[(11)] = inst_25608);

(statearr_25672[(10)] = inst_25607__$1);

(statearr_25672[(12)] = inst_25606);

return statearr_25672;
})();
if(cljs.core.truth_(inst_25607__$1)){
var statearr_25673_25744 = state_25663__$1;
(statearr_25673_25744[(1)] = (26));

} else {
var statearr_25674_25745 = state_25663__$1;
(statearr_25674_25745[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (39))){
var inst_25644 = (state_25663[(2)]);
var state_25663__$1 = state_25663;
var statearr_25675_25746 = state_25663__$1;
(statearr_25675_25746[(2)] = inst_25644);

(statearr_25675_25746[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (4))){
var inst_25540 = (state_25663[(2)]);
var state_25663__$1 = state_25663;
var statearr_25676_25747 = state_25663__$1;
(statearr_25676_25747[(2)] = inst_25540);

(statearr_25676_25747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (15))){
var inst_25560 = (state_25663[(13)]);
var inst_25562 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_25560);
var state_25663__$1 = state_25663;
var statearr_25677_25748 = state_25663__$1;
(statearr_25677_25748[(2)] = inst_25562);

(statearr_25677_25748[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (21))){
var inst_25570 = (state_25663[(7)]);
var inst_25572 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_25570);
var state_25663__$1 = state_25663;
var statearr_25678_25749 = state_25663__$1;
(statearr_25678_25749[(2)] = inst_25572);

(statearr_25678_25749[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (31))){
var state_25663__$1 = state_25663;
var statearr_25679_25750 = state_25663__$1;
(statearr_25679_25750[(2)] = limit);

(statearr_25679_25750[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (32))){
var inst_25630 = (state_25663[(2)]);
var inst_25631 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25630,opts);
var state_25663__$1 = state_25663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25663__$1,(33),inst_25631);
} else {
if((state_val_25664 === (40))){
var inst_25634 = (state_25663[(14)]);
var inst_25647 = cljs.core.first(inst_25634);
var state_25663__$1 = state_25663;
var statearr_25680_25751 = state_25663__$1;
(statearr_25680_25751[(2)] = inst_25647);

(statearr_25680_25751[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (33))){
var inst_25634 = (state_25663[(14)]);
var inst_25633 = (state_25663[(2)]);
var inst_25634__$1 = fluree.db.util.async.throw_err(inst_25633);
var inst_25635 = cljs.core.coll_QMARK_(inst_25634__$1);
var inst_25636 = (!(inst_25635));
var state_25663__$1 = (function (){var statearr_25681 = state_25663;
(statearr_25681[(14)] = inst_25634__$1);

return statearr_25681;
})();
if(inst_25636){
var statearr_25682_25752 = state_25663__$1;
(statearr_25682_25752[(1)] = (34));

} else {
var statearr_25683_25753 = state_25663__$1;
(statearr_25683_25753[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (13))){
var inst_25555 = (state_25663[(15)]);
var state_25663__$1 = state_25663;
var statearr_25684_25754 = state_25663__$1;
(statearr_25684_25754[(2)] = inst_25555);

(statearr_25684_25754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (22))){
var inst_25570 = (state_25663[(7)]);
var state_25663__$1 = state_25663;
var statearr_25685_25755 = state_25663__$1;
(statearr_25685_25755[(2)] = inst_25570);

(statearr_25685_25755[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (36))){
var inst_25656 = (state_25663[(2)]);
var state_25663__$1 = state_25663;
var statearr_25686_25756 = state_25663__$1;
(statearr_25686_25756[(2)] = inst_25656);

(statearr_25686_25756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (41))){
var state_25663__$1 = state_25663;
var statearr_25687_25757 = state_25663__$1;
(statearr_25687_25757[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (43))){
var inst_25634 = (state_25663[(14)]);
var state_25663__$1 = state_25663;
var statearr_25689_25758 = state_25663__$1;
(statearr_25689_25758[(2)] = inst_25634);

(statearr_25689_25758[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (29))){
var inst_25607 = (state_25663[(10)]);
var inst_25606 = (state_25663[(12)]);
var inst_25596 = (state_25663[(8)]);
var inst_25617 = (state_25663[(2)]);
var inst_25618 = fluree.db.util.async.throw_err(inst_25617);
var inst_25619 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25596,inst_25607,inst_25618);
var inst_25595 = inst_25606;
var inst_25596__$1 = inst_25619;
var state_25663__$1 = (function (){var statearr_25690 = state_25663;
(statearr_25690[(9)] = inst_25595);

(statearr_25690[(8)] = inst_25596__$1);

return statearr_25690;
})();
var statearr_25691_25759 = state_25663__$1;
(statearr_25691_25759[(2)] = null);

(statearr_25691_25759[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (44))){
var state_25663__$1 = state_25663;
var statearr_25692_25760 = state_25663__$1;
(statearr_25692_25760[(2)] = null);

(statearr_25692_25760[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (6))){
var inst_25547 = (state_25663[(16)]);
var inst_25547__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25549 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25663__$1 = (function (){var statearr_25693 = state_25663;
(statearr_25693[(17)] = inst_25549);

(statearr_25693[(16)] = inst_25547__$1);

return statearr_25693;
})();
if(cljs.core.truth_(inst_25547__$1)){
var statearr_25694_25761 = state_25663__$1;
(statearr_25694_25761[(1)] = (9));

} else {
var statearr_25695_25762 = state_25663__$1;
(statearr_25695_25762[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (28))){
var inst_25623 = (state_25663[(2)]);
var state_25663__$1 = state_25663;
var statearr_25696_25763 = state_25663__$1;
(statearr_25696_25763[(2)] = inst_25623);

(statearr_25696_25763[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (25))){
var inst_25625 = (state_25663[(2)]);
var state_25663__$1 = state_25663;
var statearr_25697_25764 = state_25663__$1;
(statearr_25697_25764[(2)] = inst_25625);

(statearr_25697_25764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (34))){
var state_25663__$1 = state_25663;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25698_25765 = state_25663__$1;
(statearr_25698_25765[(1)] = (37));

} else {
var statearr_25699_25766 = state_25663__$1;
(statearr_25699_25766[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (17))){
var inst_25565 = (state_25663[(2)]);
var state_25663__$1 = (function (){var statearr_25700 = state_25663;
(statearr_25700[(18)] = inst_25565);

return statearr_25700;
})();
if(cljs.core.truth_(limit)){
var statearr_25701_25767 = state_25663__$1;
(statearr_25701_25767[(1)] = (18));

} else {
var statearr_25702_25768 = state_25663__$1;
(statearr_25702_25768[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (3))){
var inst_25661 = (state_25663[(2)]);
var state_25663__$1 = state_25663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25663__$1,inst_25661);
} else {
if((state_val_25664 === (12))){
var inst_25555 = (state_25663[(15)]);
var inst_25557 = fluree.db.query.fql.filter_having(having,headers,inst_25555);
var state_25663__$1 = state_25663;
var statearr_25703_25769 = state_25663__$1;
(statearr_25703_25769[(2)] = inst_25557);

(statearr_25703_25769[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (2))){
var _ = (function (){var statearr_25704 = state_25663;
(statearr_25704[(4)] = cljs.core.cons((5),(state_25663[(4)])));

return statearr_25704;
})();
var state_25663__$1 = state_25663;
if(cljs.core.truth_(groupBy)){
var statearr_25705_25770 = state_25663__$1;
(statearr_25705_25770[(1)] = (6));

} else {
var statearr_25706_25771 = state_25663__$1;
(statearr_25706_25771[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (23))){
var inst_25575 = (state_25663[(2)]);
var inst_25589 = cljs.core.seq(inst_25575);
var inst_25590 = cljs.core.first(inst_25589);
var inst_25591 = cljs.core.next(inst_25589);
var inst_25592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25590,(0),null);
var inst_25593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25590,(1),null);
var inst_25594 = cljs.core.PersistentHashMap.EMPTY;
var inst_25595 = inst_25575;
var inst_25596 = inst_25594;
var state_25663__$1 = (function (){var statearr_25707 = state_25663;
(statearr_25707[(19)] = inst_25591);

(statearr_25707[(9)] = inst_25595);

(statearr_25707[(20)] = inst_25593);

(statearr_25707[(21)] = inst_25592);

(statearr_25707[(8)] = inst_25596);

return statearr_25707;
})();
var statearr_25708_25772 = state_25663__$1;
(statearr_25708_25772[(2)] = null);

(statearr_25708_25772[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (35))){
var state_25663__$1 = state_25663;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25709_25773 = state_25663__$1;
(statearr_25709_25773[(1)] = (40));

} else {
var statearr_25710_25774 = state_25663__$1;
(statearr_25710_25774[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (19))){
var inst_25565 = (state_25663[(18)]);
var state_25663__$1 = state_25663;
var statearr_25711_25775 = state_25663__$1;
(statearr_25711_25775[(2)] = inst_25565);

(statearr_25711_25775[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (11))){
var inst_25555 = (state_25663[(2)]);
var state_25663__$1 = (function (){var statearr_25713 = state_25663;
(statearr_25713[(15)] = inst_25555);

return statearr_25713;
})();
if(cljs.core.truth_(having)){
var statearr_25714_25776 = state_25663__$1;
(statearr_25714_25776[(1)] = (12));

} else {
var statearr_25715_25777 = state_25663__$1;
(statearr_25715_25777[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (9))){
var inst_25549 = (state_25663[(17)]);
var inst_25547 = (state_25663[(16)]);
var inst_25551 = cljs.core.sorted_map_by(inst_25547);
var inst_25552 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25551,inst_25549);
var state_25663__$1 = state_25663;
var statearr_25716_25778 = state_25663__$1;
(statearr_25716_25778[(2)] = inst_25552);

(statearr_25716_25778[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (5))){
var _ = (function (){var statearr_25717 = state_25663;
(statearr_25717[(4)] = cljs.core.rest((state_25663[(4)])));

return statearr_25717;
})();
var state_25663__$1 = state_25663;
var ex25712 = (state_25663__$1[(2)]);
var statearr_25718_25779 = state_25663__$1;
(statearr_25718_25779[(5)] = ex25712);


if((ex25712 instanceof Error)){
var statearr_25719_25780 = state_25663__$1;
(statearr_25719_25780[(1)] = (4));

(statearr_25719_25780[(5)] = null);

} else {
throw ex25712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (14))){
var inst_25560 = (state_25663[(2)]);
var state_25663__$1 = (function (){var statearr_25720 = state_25663;
(statearr_25720[(13)] = inst_25560);

return statearr_25720;
})();
if(cljs.core.truth_(offset)){
var statearr_25721_25781 = state_25663__$1;
(statearr_25721_25781[(1)] = (15));

} else {
var statearr_25722_25782 = state_25663__$1;
(statearr_25722_25782[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (45))){
var inst_25652 = (state_25663[(2)]);
var state_25663__$1 = state_25663;
var statearr_25723_25783 = state_25663__$1;
(statearr_25723_25783[(2)] = inst_25652);

(statearr_25723_25783[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (26))){
var inst_25608 = (state_25663[(11)]);
var inst_25610 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25611 = [headers,vars,inst_25608];
var inst_25612 = cljs.core.PersistentHashMap.fromArrays(inst_25610,inst_25611);
var inst_25613 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25614 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25615 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25612,inst_25613,inst_25614);
var state_25663__$1 = state_25663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25663__$1,(29),inst_25615);
} else {
if((state_val_25664 === (16))){
var inst_25560 = (state_25663[(13)]);
var state_25663__$1 = state_25663;
var statearr_25724_25784 = state_25663__$1;
(statearr_25724_25784[(2)] = inst_25560);

(statearr_25724_25784[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (38))){
var inst_25634 = (state_25663[(14)]);
var state_25663__$1 = state_25663;
var statearr_25725_25785 = state_25663__$1;
(statearr_25725_25785[(2)] = inst_25634);

(statearr_25725_25785[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (30))){
var state_25663__$1 = state_25663;
var statearr_25726_25786 = state_25663__$1;
(statearr_25726_25786[(2)] = (1));

(statearr_25726_25786[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (10))){
var inst_25549 = (state_25663[(17)]);
var state_25663__$1 = state_25663;
var statearr_25727_25787 = state_25663__$1;
(statearr_25727_25787[(2)] = inst_25549);

(statearr_25727_25787[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (18))){
var inst_25565 = (state_25663[(18)]);
var inst_25567 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_25565);
var state_25663__$1 = state_25663;
var statearr_25728_25788 = state_25663__$1;
(statearr_25728_25788[(2)] = inst_25567);

(statearr_25728_25788[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (42))){
var inst_25654 = (state_25663[(2)]);
var state_25663__$1 = state_25663;
var statearr_25729_25789 = state_25663__$1;
(statearr_25729_25789[(2)] = inst_25654);

(statearr_25729_25789[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (37))){
var inst_25634 = (state_25663[(14)]);
var inst_25639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25640 = [inst_25634];
var inst_25641 = (new cljs.core.PersistentVector(null,1,(5),inst_25639,inst_25640,null));
var state_25663__$1 = state_25663;
var statearr_25730_25790 = state_25663__$1;
(statearr_25730_25790[(2)] = inst_25641);

(statearr_25730_25790[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25664 === (8))){
var inst_25658 = (state_25663[(2)]);
var _ = (function (){var statearr_25731 = state_25663;
(statearr_25731[(4)] = cljs.core.rest((state_25663[(4)])));

return statearr_25731;
})();
var state_25663__$1 = state_25663;
var statearr_25732_25791 = state_25663__$1;
(statearr_25732_25791[(2)] = inst_25658);

(statearr_25732_25791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0 = (function (){
var statearr_25733 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25733[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__);

(statearr_25733[(1)] = (1));

return statearr_25733;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1 = (function (state_25663){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25663);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25734){var ex__2687__auto__ = e25734;
var statearr_25735_25792 = state_25663;
(statearr_25735_25792[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25663[(4)]))){
var statearr_25736_25793 = state_25663;
(statearr_25736_25793[(1)] = cljs.core.first((state_25663[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25794 = state_25663;
state_25663 = G__25794;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__ = function(state_25663){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1.call(this,state_25663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25737 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25737[(6)] = c__2706__auto__);

return statearr_25737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.process_ad_hoc_query = (function fluree$db$query$fql$process_ad_hoc_query(p__25795){
var map__25796 = p__25795;
var map__25796__$1 = cljs.core.__destructure_map(map__25796);
var opts = map__25796__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25796__$1,new cljs.core.Keyword(null,"db","db",993250759));
var parsed_query = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25796__$1,new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25796__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25796__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("process-ad-hoc-query opts:",opts) : fluree.db.util.log.debug.call(null,"process-ad-hoc-query opts:",opts));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25817){
var state_val_25818 = (state_25817[(1)]);
if((state_val_25818 === (1))){
var state_25817__$1 = state_25817;
var statearr_25819_25834 = state_25817__$1;
(statearr_25819_25834[(2)] = null);

(statearr_25819_25834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25818 === (2))){
var _ = (function (){var statearr_25820 = state_25817;
(statearr_25820[(4)] = cljs.core.cons((5),(state_25817[(4)])));

return statearr_25820;
})();
var inst_25803 = fluree.db.query.analytical.q(opts);
var state_25817__$1 = state_25817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25817__$1,(6),inst_25803);
} else {
if((state_val_25818 === (3))){
var inst_25815 = (state_25817[(2)]);
var state_25817__$1 = state_25817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25817__$1,inst_25815);
} else {
if((state_val_25818 === (4))){
var inst_25797 = (state_25817[(2)]);
var state_25817__$1 = state_25817;
var statearr_25822_25835 = state_25817__$1;
(statearr_25822_25835[(2)] = inst_25797);

(statearr_25822_25835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25818 === (5))){
var _ = (function (){var statearr_25823 = state_25817;
(statearr_25823[(4)] = cljs.core.rest((state_25817[(4)])));

return statearr_25823;
})();
var state_25817__$1 = state_25817;
var ex25821 = (state_25817__$1[(2)]);
var statearr_25824_25836 = state_25817__$1;
(statearr_25824_25836[(5)] = ex25821);


if((ex25821 instanceof Error)){
var statearr_25825_25837 = state_25817__$1;
(statearr_25825_25837[(1)] = (4));

(statearr_25825_25837[(5)] = null);

} else {
throw ex25821;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25818 === (6))){
var inst_25805 = (state_25817[(2)]);
var inst_25806 = fluree.db.util.async.throw_err(inst_25805);
var inst_25807 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("process-ad-hoc-query where-result:",inst_25806) : fluree.db.util.log.debug.call(null,"process-ad-hoc-query where-result:",inst_25806));
var inst_25808 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25809 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_25806,inst_25808,opts);
var state_25817__$1 = (function (){var statearr_25826 = state_25817;
(statearr_25826[(7)] = inst_25807);

return statearr_25826;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25817__$1,(7),inst_25809);
} else {
if((state_val_25818 === (7))){
var inst_25811 = (state_25817[(2)]);
var inst_25812 = fluree.db.util.async.throw_err(inst_25811);
var _ = (function (){var statearr_25827 = state_25817;
(statearr_25827[(4)] = cljs.core.rest((state_25817[(4)])));

return statearr_25827;
})();
var state_25817__$1 = state_25817;
var statearr_25828_25838 = state_25817__$1;
(statearr_25828_25838[(2)] = inst_25812);

(statearr_25828_25838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0 = (function (){
var statearr_25829 = [null,null,null,null,null,null,null,null];
(statearr_25829[(0)] = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__);

(statearr_25829[(1)] = (1));

return statearr_25829;
});
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1 = (function (state_25817){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25817);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25830){var ex__2687__auto__ = e25830;
var statearr_25831_25839 = state_25817;
(statearr_25831_25839[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25817[(4)]))){
var statearr_25832_25840 = state_25817;
(statearr_25832_25840[(1)] = cljs.core.first((state_25817[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25841 = state_25817;
state_25817 = G__25841;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__ = function(state_25817){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1.call(this,state_25817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0;
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1;
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25833 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25833[(6)] = c__2706__auto__);

return statearr_25833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.relationship_binding = (function fluree$db$query$fql$relationship_binding(p__25842){
var map__25843 = p__25842;
var map__25843__$1 = cljs.core.__destructure_map(map__25843);
var opts = map__25843__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25843__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25879){
var state_val_25880 = (state_25879[(1)]);
if((state_val_25880 === (1))){
var inst_25851 = vars;
var inst_25852 = cljs.core.seq(inst_25851);
var inst_25853 = cljs.core.first(inst_25852);
var inst_25854 = cljs.core.next(inst_25852);
var inst_25855 = cljs.core.PersistentVector.EMPTY;
var inst_25856 = inst_25851;
var inst_25857 = inst_25855;
var state_25879__$1 = (function (){var statearr_25881 = state_25879;
(statearr_25881[(7)] = inst_25853);

(statearr_25881[(8)] = inst_25857);

(statearr_25881[(9)] = inst_25856);

(statearr_25881[(10)] = inst_25854);

return statearr_25881;
})();
var statearr_25882_25895 = state_25879__$1;
(statearr_25882_25895[(2)] = null);

(statearr_25882_25895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25880 === (2))){
var inst_25863 = (state_25879[(11)]);
var inst_25856 = (state_25879[(9)]);
var inst_25862 = cljs.core.seq(inst_25856);
var inst_25863__$1 = cljs.core.first(inst_25862);
var inst_25864 = cljs.core.next(inst_25862);
var state_25879__$1 = (function (){var statearr_25883 = state_25879;
(statearr_25883[(11)] = inst_25863__$1);

(statearr_25883[(12)] = inst_25864);

return statearr_25883;
})();
if(cljs.core.truth_(inst_25863__$1)){
var statearr_25884_25896 = state_25879__$1;
(statearr_25884_25896[(1)] = (4));

} else {
var statearr_25885_25897 = state_25879__$1;
(statearr_25885_25897[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25880 === (3))){
var inst_25877 = (state_25879[(2)]);
var state_25879__$1 = state_25879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25879__$1,inst_25877);
} else {
if((state_val_25880 === (4))){
var inst_25863 = (state_25879[(11)]);
var inst_25866 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_25863);
var inst_25867 = fluree.db.query.fql.process_ad_hoc_query(inst_25866);
var state_25879__$1 = state_25879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25879__$1,(7),inst_25867);
} else {
if((state_val_25880 === (5))){
var inst_25857 = (state_25879[(8)]);
var state_25879__$1 = state_25879;
var statearr_25886_25898 = state_25879__$1;
(statearr_25886_25898[(2)] = inst_25857);

(statearr_25886_25898[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25880 === (6))){
var inst_25875 = (state_25879[(2)]);
var state_25879__$1 = state_25879;
var statearr_25887_25899 = state_25879__$1;
(statearr_25887_25899[(2)] = inst_25875);

(statearr_25887_25899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25880 === (7))){
var inst_25857 = (state_25879[(8)]);
var inst_25864 = (state_25879[(12)]);
var inst_25869 = (state_25879[(2)]);
var inst_25870 = fluree.db.util.async.throw_err(inst_25869);
var inst_25871 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25857,inst_25870);
var inst_25856 = inst_25864;
var inst_25857__$1 = inst_25871;
var state_25879__$1 = (function (){var statearr_25888 = state_25879;
(statearr_25888[(8)] = inst_25857__$1);

(statearr_25888[(9)] = inst_25856);

return statearr_25888;
})();
var statearr_25889_25900 = state_25879__$1;
(statearr_25889_25900[(2)] = null);

(statearr_25889_25900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0 = (function (){
var statearr_25890 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25890[(0)] = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__);

(statearr_25890[(1)] = (1));

return statearr_25890;
});
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1 = (function (state_25879){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25879);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25891){var ex__2687__auto__ = e25891;
var statearr_25892_25901 = state_25879;
(statearr_25892_25901[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25879[(4)]))){
var statearr_25893_25902 = state_25879;
(statearr_25893_25902[(1)] = cljs.core.first((state_25879[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25903 = state_25879;
state_25879 = G__25903;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__ = function(state_25879){
switch(arguments.length){
case 0:
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1.call(this,state_25879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0;
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1;
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25894 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25894[(6)] = c__2706__auto__);

return statearr_25894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,p__25904,query_map){
var map__25905 = p__25904;
var map__25905__$1 = cljs.core.__destructure_map(map__25905);
var parsed_query = map__25905__$1;
var rel_binding_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25905__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25905__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("Running ad hoc query:",query_map) : fluree.db.util.log.debug.call(null,"Running ad hoc query:",query_map));

var map__25906 = query_map;
var map__25906__$1 = cljs.core.__destructure_map(map__25906);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25906__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25906__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25906__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25906__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25906__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25906__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25906__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25906__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var opts_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877),new cljs.core.Keyword(null,"parseJSON","parseJSON",1986764220).cljs$core$IFn$_invoke$arity$1(opts)),new cljs.core.Keyword(null,"parseJSON","parseJSON",1986764220));
var opts_SINGLEQUOTE___$1 = (function (){var G__25907 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts_SINGLEQUOTE_], 0));
var G__25907__$1 = (cljs.core.truth_(selectOne)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25907,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1)):G__25907);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__25907__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})(),new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689),parsed_query,new cljs.core.Keyword(null,"query-map","query-map",-808576972),query_map,new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars], 0));

})();
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.fql.relationship_binding(opts_SINGLEQUOTE___$1);
} else {
return fluree.db.query.fql.process_ad_hoc_query(opts_SINGLEQUOTE___$1);
}
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25908,p__25909){
var map__25910 = p__25908;
var map__25910__$1 = cljs.core.__destructure_map(map__25910);
var db = map__25910__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25910__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25910__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25910__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25910__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25910__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25911 = p__25909;
var map__25911__$1 = cljs.core.__destructure_map(map__25911);
var query_map = map__25911__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25911__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.cljs$core$IFn$_invoke$arity$5(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
var G__25912 = cache_key;
var G__25913 = (function (_){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___25930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25923){
var state_val_25924 = (state_25923[(1)]);
if((state_val_25924 === (1))){
var inst_25914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25915 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25916 = (new cljs.core.PersistentVector(null,2,(5),inst_25914,inst_25915,null));
var inst_25917 = cljs.core.assoc_in(query_map,inst_25916,false);
var inst_25918 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_25917) : fluree.db.query.fql.query.call(null,db,inst_25917));
var state_25923__$1 = state_25923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25923__$1,(2),inst_25918);
} else {
if((state_val_25924 === (2))){
var inst_25920 = (state_25923[(2)]);
var inst_25921 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_25920);
var state_25923__$1 = state_25923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25923__$1,inst_25921);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0 = (function (){
var statearr_25925 = [null,null,null,null,null,null,null];
(statearr_25925[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2684__auto__);

(statearr_25925[(1)] = (1));

return statearr_25925;
});
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1 = (function (state_25923){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25923);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25926){var ex__2687__auto__ = e25926;
var statearr_25927_25931 = state_25923;
(statearr_25927_25931[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25923[(4)]))){
var statearr_25928_25932 = state_25923;
(statearr_25928_25932[(1)] = cljs.core.first((state_25923[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25933 = state_25923;
state_25923 = G__25933;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__ = function(state_25923){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1.call(this,state_25923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25929 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25929[(6)] = c__2706__auto___25930);

return statearr_25929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
});
return (oc.cljs$core$IFn$_invoke$arity$2 ? oc.cljs$core$IFn$_invoke$arity$2(G__25912,G__25913) : oc.call(null,G__25912,G__25913));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25934){
var map__25935 = p__25934;
var map__25935__$1 = cljs.core.__destructure_map(map__25935);
var _query_map = map__25935__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25935__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2("Running query:",query_map) : fluree.db.util.log.debug.call(null,"Running query:",query_map));

if(fluree.db.query.fql.cache_QMARK_(query_map)){
return fluree.db.query.fql.cache_query(db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse(db,query_map);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl(db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query(db_STAR_,parsed_query,query_map);
}
}
});
