// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__22882_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22882_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__22886 = coll;
var vec__22887 = G__22886;
var seq__22888 = cljs.core.seq(vec__22887);
var first__22889 = cljs.core.first(seq__22888);
var seq__22888__$1 = cljs.core.next(seq__22888);
var clause = first__22889;
var r = seq__22888__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__22886__$1 = G__22886;
var res__$1 = res;
while(true){
var vec__22893 = G__22886__$1;
var seq__22894 = cljs.core.seq(vec__22893);
var first__22895 = cljs.core.first(seq__22894);
var seq__22894__$1 = cljs.core.next(seq__22894);
var clause__$1 = first__22895;
var r__$1 = seq__22894__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__22896 = r__$1;
var G__22897 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__22886__$1 = G__22896;
res__$1 = G__22897;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__22898){
var map__22899 = p__22898;
var map__22899__$1 = cljs.core.__destructure_map(map__22899);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22899__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__22903 = coll;
var vec__22904 = G__22903;
var seq__22905 = cljs.core.seq(vec__22904);
var first__22906 = cljs.core.first(seq__22905);
var seq__22905__$1 = cljs.core.next(seq__22905);
var clause = first__22906;
var r = seq__22905__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__22903__$1 = G__22903;
var res__$1 = res;
while(true){
var vec__22910 = G__22903__$1;
var seq__22911 = cljs.core.seq(vec__22910);
var first__22912 = cljs.core.first(seq__22911);
var seq__22911__$1 = cljs.core.next(seq__22911);
var clause__$1 = first__22912;
var r__$1 = seq__22911__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__22913 = r__$1;
var G__22914 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__22903__$1 = G__22913;
res__$1 = G__22914;
continue;
} else {
var G__22915 = r__$1;
var G__22916 = res__$2;
G__22903__$1 = G__22915;
res__$1 = G__22916;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__22920 = coll;
var vec__22921 = G__22920;
var seq__22922 = cljs.core.seq(vec__22921);
var first__22923 = cljs.core.first(seq__22922);
var seq__22922__$1 = cljs.core.next(seq__22922);
var clause = first__22923;
var r = seq__22922__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__22920__$1 = G__22920;
var res__$1 = res;
while(true){
var vec__22927 = G__22920__$1;
var seq__22928 = cljs.core.seq(vec__22927);
var first__22929 = cljs.core.first(seq__22928);
var seq__22928__$1 = cljs.core.next(seq__22928);
var clause__$1 = first__22929;
var r__$1 = seq__22928__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__22930 = r__$1;
var G__22931 = res__$2;
G__22920__$1 = G__22930;
res__$1 = G__22931;
continue;
} else {
var G__22932 = r__$1;
var G__22933 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__22920__$1 = G__22932;
res__$1 = G__22933;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__22936 = clause;
var G__22936__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__22936):G__22936);
var G__22936__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__22936__$1)
;
var G__22936__$3 = (function (){var fexpr__22937 = (function (p1__22934_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22934_SHARP_)," ."].join('');
});
return fexpr__22937(G__22936__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__22938 = (function (p1__22935_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22935_SHARP_),"}"].join('');
});
return fexpr__22938(G__22936__$3);
} else {
return G__22936__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__22942 = opts;
var map__22942__$1 = cljs.core.__destructure_map(map__22942);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22942__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22942__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22942__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22942__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22942__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__22939_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__22939_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__22940_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__22940_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__22941_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__22941_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22956){
var state_val_22957 = (state_22956[(1)]);
if((state_val_22957 === (1))){
var inst_22943 = fluree.db.util.core.url_encode(query);
var inst_22944 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_22943)].join('');
var inst_22945 = ["User-Agent","Accept"];
var inst_22946 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_22947 = cljs.core.PersistentHashMap.fromArrays(inst_22945,inst_22946);
var inst_22948 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_22949 = [inst_22947,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_22950 = cljs.core.PersistentHashMap.fromArrays(inst_22948,inst_22949);
var inst_22951 = fluree.db.util.xhttp.get(inst_22944,inst_22950);
var state_22956__$1 = state_22956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22956__$1,(2),inst_22951);
} else {
if((state_val_22957 === (2))){
var inst_22953 = (state_22956[(2)]);
var inst_22954 = fluree.db.util.async.throw_err(inst_22953);
var state_22956__$1 = state_22956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22956__$1,inst_22954);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0 = (function (){
var statearr_22958 = [null,null,null,null,null,null,null];
(statearr_22958[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__);

(statearr_22958[(1)] = (1));

return statearr_22958;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1 = (function (state_22956){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22956);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22959){var ex__2687__auto__ = e22959;
var statearr_22960_22963 = state_22956;
(statearr_22960_22963[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22956[(4)]))){
var statearr_22961_22964 = state_22956;
(statearr_22961_22964[(1)] = cljs.core.first((state_22956[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22965 = state_22956;
state_22956 = G__22965;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__ = function(state_22956){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1.call(this,state_22956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22962 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22962[(6)] = c__2706__auto__);

return statearr_22962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22983){
var state_val_22984 = (state_22983[(1)]);
if((state_val_22984 === (1))){
var inst_22966 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_22983__$1 = state_22983;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22983__$1,(2),inst_22966);
} else {
if((state_val_22984 === (2))){
var inst_22969 = (state_22983[(7)]);
var inst_22968 = (state_22983[(2)]);
var inst_22969__$1 = fluree.db.util.async.throw_err(inst_22968);
var inst_22970 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_22969__$1);
var inst_22971 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_22970);
var state_22983__$1 = (function (){var statearr_22985 = state_22983;
(statearr_22985[(7)] = inst_22969__$1);

return statearr_22985;
})();
if(inst_22971){
var statearr_22986_22995 = state_22983__$1;
(statearr_22986_22995[(1)] = (3));

} else {
var statearr_22987_22996 = state_22983__$1;
(statearr_22987_22996[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22984 === (3))){
var inst_22969 = (state_22983[(7)]);
var state_22983__$1 = state_22983;
var statearr_22988_22997 = state_22983__$1;
(statearr_22988_22997[(2)] = inst_22969);

(statearr_22988_22997[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22984 === (4))){
var inst_22969 = (state_22983[(7)]);
var inst_22974 = (function (){var body = inst_22969;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_22975 = cljs.core.second(inst_22969);
var inst_22976 = cljs.core.second(inst_22975);
var inst_22977 = cljs.core.first(inst_22976);
var inst_22978 = cljs.core.second(inst_22977);
var inst_22979 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22974,inst_22978);
var state_22983__$1 = state_22983;
var statearr_22989_22998 = state_22983__$1;
(statearr_22989_22998[(2)] = inst_22979);

(statearr_22989_22998[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22984 === (5))){
var inst_22981 = (state_22983[(2)]);
var state_22983__$1 = state_22983;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22983__$1,inst_22981);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0 = (function (){
var statearr_22990 = [null,null,null,null,null,null,null,null];
(statearr_22990[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__);

(statearr_22990[(1)] = (1));

return statearr_22990;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1 = (function (state_22983){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22983);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22991){var ex__2687__auto__ = e22991;
var statearr_22992_22999 = state_22983;
(statearr_22992_22999[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22983[(4)]))){
var statearr_22993_23000 = state_22983;
(statearr_22993_23000[(1)] = cljs.core.first((state_22983[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23001 = state_22983;
state_22983 = G__23001;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__ = function(state_22983){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1.call(this,state_22983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22994 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22994[(6)] = c__2706__auto__);

return statearr_22994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23002_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__23002_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23003_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__23003_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23004_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__23004_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23004_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__23004_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23050){
var state_val_23051 = (state_23050[(1)]);
if((state_val_23051 === (7))){
var inst_23015 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_23050__$1 = state_23050;
var statearr_23052_23080 = state_23050__$1;
(statearr_23052_23080[(2)] = inst_23015);

(statearr_23052_23080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (1))){
var state_23050__$1 = state_23050;
var statearr_23053_23081 = state_23050__$1;
(statearr_23053_23081[(2)] = null);

(statearr_23053_23081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (4))){
var inst_23005 = (state_23050[(2)]);
var state_23050__$1 = state_23050;
var statearr_23054_23082 = state_23050__$1;
(statearr_23054_23082[(2)] = inst_23005);

(statearr_23054_23082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (15))){
var inst_23029 = (state_23050[(7)]);
var inst_23024 = (state_23050[(8)]);
var inst_23023 = (state_23050[(9)]);
var inst_23034 = (state_23050[(2)]);
var inst_23035 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_23029,(0),inst_23034);
var inst_23036 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23037 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_23023);
var inst_23038 = [inst_23024,inst_23037];
var inst_23039 = cljs.core.PersistentHashMap.fromArrays(inst_23036,inst_23038);
var inst_23040 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_23035,inst_23039);
var inst_23041 = (function(){throw inst_23040})();
var state_23050__$1 = state_23050;
var statearr_23055_23083 = state_23050__$1;
(statearr_23055_23083[(2)] = inst_23041);

(statearr_23055_23083[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (13))){
var inst_23028 = (state_23050[(10)]);
var state_23050__$1 = state_23050;
var statearr_23056_23084 = state_23050__$1;
(statearr_23056_23084[(2)] = inst_23028);

(statearr_23056_23084[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (6))){
var state_23050__$1 = state_23050;
var statearr_23057_23085 = state_23050__$1;
(statearr_23057_23085[(2)] = null);

(statearr_23057_23085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (3))){
var inst_23048 = (state_23050[(2)]);
var state_23050__$1 = state_23050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23050__$1,inst_23048);
} else {
if((state_val_23051 === (12))){
var inst_23045 = (state_23050[(2)]);
var _ = (function (){var statearr_23058 = state_23050;
(statearr_23058[(4)] = cljs.core.rest((state_23050[(4)])));

return statearr_23058;
})();
var state_23050__$1 = state_23050;
var statearr_23059_23086 = state_23050__$1;
(statearr_23059_23086[(2)] = inst_23045);

(statearr_23059_23086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (2))){
var _ = (function (){var statearr_23060 = state_23050;
(statearr_23060[(4)] = cljs.core.cons((5),(state_23050[(4)])));

return statearr_23060;
})();
var inst_23012 = cljs.core.empty_QMARK_(matching_vars);
var state_23050__$1 = state_23050;
if(inst_23012){
var statearr_23061_23087 = state_23050__$1;
(statearr_23061_23087[(1)] = (6));

} else {
var statearr_23062_23088 = state_23050__$1;
(statearr_23062_23088[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (11))){
var inst_23023 = (state_23050[(9)]);
var inst_23043 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_23023,all_vars);
var state_23050__$1 = state_23050;
var statearr_23064_23089 = state_23050__$1;
(statearr_23064_23089[(2)] = inst_23043);

(statearr_23064_23089[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (9))){
var inst_23024 = (state_23050[(8)]);
var inst_23023 = (state_23050[(9)]);
var inst_23021 = (state_23050[(2)]);
var inst_23022 = fluree.db.util.async.throw_err(inst_23021);
var inst_23023__$1 = cljs.core.__destructure_map(inst_23022);
var inst_23024__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23023__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_23025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23023__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_23026 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_23024__$1);
var state_23050__$1 = (function (){var statearr_23065 = state_23050;
(statearr_23065[(8)] = inst_23024__$1);

(statearr_23065[(9)] = inst_23023__$1);

(statearr_23065[(11)] = inst_23025);

return statearr_23065;
})();
if(inst_23026){
var statearr_23066_23090 = state_23050__$1;
(statearr_23066_23090[(1)] = (10));

} else {
var statearr_23067_23091 = state_23050__$1;
(statearr_23067_23091[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (5))){
var _ = (function (){var statearr_23068 = state_23050;
(statearr_23068[(4)] = cljs.core.rest((state_23050[(4)])));

return statearr_23068;
})();
var state_23050__$1 = state_23050;
var ex23063 = (state_23050__$1[(2)]);
var statearr_23069_23092 = state_23050__$1;
(statearr_23069_23092[(5)] = ex23063);


if((ex23063 instanceof Error)){
var statearr_23070_23093 = state_23050__$1;
(statearr_23070_23093[(1)] = (4));

(statearr_23070_23093[(5)] = null);

} else {
throw ex23063;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (14))){
var state_23050__$1 = state_23050;
var statearr_23071_23094 = state_23050__$1;
(statearr_23071_23094[(2)] = (1000));

(statearr_23071_23094[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (10))){
var inst_23023 = (state_23050[(9)]);
var inst_23025 = (state_23050[(11)]);
var inst_23028 = (state_23050[(10)]);
var inst_23028__$1 = cljs.core.count(inst_23025);
var inst_23029 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_23023);
var inst_23030 = (inst_23028__$1 < (1000));
var state_23050__$1 = (function (){var statearr_23072 = state_23050;
(statearr_23072[(7)] = inst_23029);

(statearr_23072[(10)] = inst_23028__$1);

return statearr_23072;
})();
if(cljs.core.truth_(inst_23030)){
var statearr_23073_23095 = state_23050__$1;
(statearr_23073_23095[(1)] = (13));

} else {
var statearr_23074_23096 = state_23050__$1;
(statearr_23074_23096[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23051 === (8))){
var inst_23017 = (state_23050[(2)]);
var inst_23018 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_23017,optional_clauses);
var inst_23019 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_23018);
var state_23050__$1 = state_23050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23050__$1,(9),inst_23019);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_23075 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23075[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__);

(statearr_23075[(1)] = (1));

return statearr_23075;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1 = (function (state_23050){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23050);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23076){var ex__2687__auto__ = e23076;
var statearr_23077_23097 = state_23050;
(statearr_23077_23097[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23050[(4)]))){
var statearr_23078_23098 = state_23050;
(statearr_23078_23098[(1)] = cljs.core.first((state_23050[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23099 = state_23050;
state_23050 = G__23099;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__ = function(state_23050){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1.call(this,state_23050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23079 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23079[(6)] = c__2706__auto__);

return statearr_23079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
