// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e23102){var e = e23102;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__23103_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__23103_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__23103_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__23103_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__23103_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__23104_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__23104_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__23105_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__23105_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_(key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__23110 = fluree.db.query.analytical_filter.extract_filter_fn(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23110,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23110,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__23106_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__23106_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__5043__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__23113 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23113,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23113,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__23107_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__23107_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__23108_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__23108_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__23109_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__23109_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (tuple){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23116_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__23116_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(headers,var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes(vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs(idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__23117 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__23117) : intersecting_vars.call(null,G__23117));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__23120,optional_QMARK_,fuel,max_fuel){
var map__23121 = p__23120;
var map__23121__$1 = cljs.core.__destructure_map(map__23121);
var res = map__23121__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23121__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23187){
var state_val_23188 = (state_23187[(1)]);
if((state_val_23188 === (7))){
var inst_23176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23177 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_23178 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23177,clause);
var inst_23179 = [null,inst_23178];
var inst_23180 = (new cljs.core.PersistentVector(null,2,(5),inst_23176,inst_23179,null));
var state_23187__$1 = state_23187;
var statearr_23189_23217 = state_23187__$1;
(statearr_23189_23217[(2)] = inst_23180);

(statearr_23189_23217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (1))){
var state_23187__$1 = state_23187;
var statearr_23190_23218 = state_23187__$1;
(statearr_23190_23218[(2)] = null);

(statearr_23190_23218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (4))){
var inst_23122 = (state_23187[(2)]);
var state_23187__$1 = state_23187;
var statearr_23191_23219 = state_23187__$1;
(statearr_23191_23219[(2)] = inst_23122);

(statearr_23191_23219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (15))){
var inst_23165 = (state_23187[(2)]);
var inst_23166 = fluree.db.util.async.throw_err(inst_23165);
var inst_23167 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_23166);
var inst_23168 = cljs.core.count(inst_23167);
var inst_23169 = fluree.db.query.analytical.add_fuel(inst_23168,fuel,max_fuel);
var inst_23170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23171 = [inst_23166,r];
var inst_23172 = (new cljs.core.PersistentVector(null,2,(5),inst_23170,inst_23171,null));
var state_23187__$1 = (function (){var statearr_23192 = state_23187;
(statearr_23192[(7)] = inst_23169);

return statearr_23192;
})();
var statearr_23193_23220 = state_23187__$1;
(statearr_23193_23220[(2)] = inst_23172);

(statearr_23193_23220[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (13))){
var inst_23131 = (state_23187[(8)]);
var inst_23144 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_23145 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_23144);
var inst_23146 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_23131);
var inst_23147 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_23146);
var inst_23148 = cljs.core.set(inst_23147);
var inst_23149 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_23145);
var inst_23150 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_23149);
var inst_23151 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23148,inst_23150);
var inst_23152 = (function (){var all_wd = inst_23131;
var optional = inst_23145;
var all_wd_vars = inst_23148;
var all_vars = inst_23151;
return (function (p1__23118_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__23118_SHARP_) : all_vars.call(null,p1__23118_SHARP_));
});
})();
var inst_23153 = cljs.core.keys(vars);
var inst_23154 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23152,inst_23153);
var inst_23155 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_23154);
var inst_23156 = cljs.core.set(inst_23155);
var inst_23157 = (function (){var all_wd = inst_23131;
var optional = inst_23145;
var all_wd_vars = inst_23148;
var all_vars = inst_23151;
var intersecting_vars = inst_23156;
return (function (p1__23119_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__23119_SHARP_);
});
})();
var inst_23158 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23157,inst_23131);
var inst_23159 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_23158);
var inst_23160 = fluree.db.query.analytical.select_from_tuples(inst_23159,res);
var inst_23161 = fluree.db.query.analytical.replace_vars_wikidata(inst_23131,inst_23156,vars);
var inst_23162 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_23156,inst_23151);
var inst_23163 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_23161,inst_23159,inst_23160,inst_23162,inst_23145);
var state_23187__$1 = state_23187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23187__$1,(15),inst_23163);
} else {
if((state_val_23188 === (6))){
var inst_23132 = (state_23187[(9)]);
var inst_23130 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_23131 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_23130);
var inst_23132__$1 = optional_QMARK_;
var state_23187__$1 = (function (){var statearr_23194 = state_23187;
(statearr_23194[(8)] = inst_23131);

(statearr_23194[(9)] = inst_23132__$1);

return statearr_23194;
})();
if(cljs.core.truth_(inst_23132__$1)){
var statearr_23195_23221 = state_23187__$1;
(statearr_23195_23221[(1)] = (9));

} else {
var statearr_23196_23222 = state_23187__$1;
(statearr_23196_23222[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (3))){
var inst_23185 = (state_23187[(2)]);
var state_23187__$1 = state_23187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23187__$1,inst_23185);
} else {
if((state_val_23188 === (12))){
var inst_23140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23141 = [null,r];
var inst_23142 = (new cljs.core.PersistentVector(null,2,(5),inst_23140,inst_23141,null));
var state_23187__$1 = state_23187;
var statearr_23197_23223 = state_23187__$1;
(statearr_23197_23223[(2)] = inst_23142);

(statearr_23197_23223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (2))){
var _ = (function (){var statearr_23198 = state_23187;
(statearr_23198[(4)] = cljs.core.cons((5),(state_23187[(4)])));

return statearr_23198;
})();
var inst_23128 = (r == null);
var state_23187__$1 = state_23187;
if(cljs.core.truth_(inst_23128)){
var statearr_23199_23224 = state_23187__$1;
(statearr_23199_23224[(1)] = (6));

} else {
var statearr_23200_23225 = state_23187__$1;
(statearr_23200_23225[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (11))){
var inst_23138 = (state_23187[(2)]);
var state_23187__$1 = state_23187;
if(cljs.core.truth_(inst_23138)){
var statearr_23202_23226 = state_23187__$1;
(statearr_23202_23226[(1)] = (12));

} else {
var statearr_23203_23227 = state_23187__$1;
(statearr_23203_23227[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (9))){
var inst_23131 = (state_23187[(8)]);
var inst_23134 = cljs.core.empty_QMARK_(inst_23131);
var inst_23135 = (!(inst_23134));
var state_23187__$1 = state_23187;
var statearr_23204_23228 = state_23187__$1;
(statearr_23204_23228[(2)] = inst_23135);

(statearr_23204_23228[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (5))){
var _ = (function (){var statearr_23205 = state_23187;
(statearr_23205[(4)] = cljs.core.rest((state_23187[(4)])));

return statearr_23205;
})();
var state_23187__$1 = state_23187;
var ex23201 = (state_23187__$1[(2)]);
var statearr_23206_23229 = state_23187__$1;
(statearr_23206_23229[(5)] = ex23201);


if((ex23201 instanceof Error)){
var statearr_23207_23230 = state_23187__$1;
(statearr_23207_23230[(1)] = (4));

(statearr_23207_23230[(5)] = null);

} else {
throw ex23201;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (14))){
var inst_23174 = (state_23187[(2)]);
var state_23187__$1 = state_23187;
var statearr_23208_23231 = state_23187__$1;
(statearr_23208_23231[(2)] = inst_23174);

(statearr_23208_23231[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (10))){
var inst_23132 = (state_23187[(9)]);
var state_23187__$1 = state_23187;
var statearr_23209_23232 = state_23187__$1;
(statearr_23209_23232[(2)] = inst_23132);

(statearr_23209_23232[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23188 === (8))){
var inst_23182 = (state_23187[(2)]);
var _ = (function (){var statearr_23210 = state_23187;
(statearr_23210[(4)] = cljs.core.rest((state_23187[(4)])));

return statearr_23210;
})();
var state_23187__$1 = state_23187;
var statearr_23211_23233 = state_23187__$1;
(statearr_23211_23233[(2)] = inst_23182);

(statearr_23211_23233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_23212 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23212[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__);

(statearr_23212[(1)] = (1));

return statearr_23212;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1 = (function (state_23187){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23187);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23213){var ex__2687__auto__ = e23213;
var statearr_23214_23234 = state_23187;
(statearr_23214_23234[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23187[(4)]))){
var statearr_23215_23235 = state_23187;
(statearr_23215_23235[(1)] = cljs.core.first((state_23187[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23236 = state_23187;
state_23187 = G__23236;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__ = function(state_23187){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1.call(this,state_23187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23216 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23216[(6)] = c__2706__auto__);

return statearr_23216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find(/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find(/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__23238 = arguments.length;
switch (G__23238) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23332){
var state_val_23333 = (state_23332[(1)]);
if((state_val_23333 === (7))){
var inst_23245 = (state_23332[(7)]);
var inst_23255 = clojure.string.starts_with_QMARK_(inst_23245,"$fdb");
var state_23332__$1 = state_23332;
if(inst_23255){
var statearr_23334_23383 = state_23332__$1;
(statearr_23334_23383[(1)] = (9));

} else {
var statearr_23335_23384 = state_23332__$1;
(statearr_23335_23384[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (20))){
var state_23332__$1 = state_23332;
var statearr_23336_23385 = state_23332__$1;
(statearr_23336_23385[(2)] = null);

(statearr_23336_23385[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (27))){
var inst_23295 = (state_23332[(8)]);
var state_23332__$1 = state_23332;
var statearr_23337_23386 = state_23332__$1;
(statearr_23337_23386[(2)] = inst_23295);

(statearr_23337_23386[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (1))){
var state_23332__$1 = state_23332;
var statearr_23338_23387 = state_23332__$1;
(statearr_23338_23387[(2)] = null);

(statearr_23338_23387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (24))){
var inst_23318 = (state_23332[(2)]);
var state_23332__$1 = state_23332;
var statearr_23339_23388 = state_23332__$1;
(statearr_23339_23388[(2)] = inst_23318);

(statearr_23339_23388[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (4))){
var inst_23239 = (state_23332[(2)]);
var state_23332__$1 = state_23332;
var statearr_23340_23389 = state_23332__$1;
(statearr_23340_23389[(2)] = inst_23239);

(statearr_23340_23389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (15))){
var inst_23262 = (state_23332[(9)]);
var inst_23268 = (state_23332[(2)]);
var inst_23269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23270 = cljs.core.PersistentVector.EMPTY;
var inst_23271 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_23272 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23270,inst_23271);
var inst_23273 = [inst_23262,inst_23272];
var inst_23274 = (new cljs.core.PersistentVector(null,2,(5),inst_23269,inst_23273,null));
var state_23332__$1 = (function (){var statearr_23341 = state_23332;
(statearr_23341[(10)] = inst_23268);

return statearr_23341;
})();
var statearr_23342_23390 = state_23332__$1;
(statearr_23342_23390[(2)] = inst_23274);

(statearr_23342_23390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (21))){
var inst_23321 = (state_23332[(2)]);
var state_23332__$1 = state_23332;
var statearr_23343_23391 = state_23332__$1;
(statearr_23343_23391[(2)] = inst_23321);

(statearr_23343_23391[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (13))){
var inst_23262 = (state_23332[(9)]);
var inst_23265 = (function(){throw inst_23262})();
var state_23332__$1 = state_23332;
var statearr_23344_23392 = state_23332__$1;
(statearr_23344_23392[(2)] = inst_23265);

(statearr_23344_23392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (22))){
var inst_23284 = (state_23332[(11)]);
var inst_23286 = (state_23332[(12)]);
var inst_23288 = fluree.db.query.analytical.parse_block_from_source(inst_23284);
var inst_23289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23290 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_23286];
var inst_23291 = (new cljs.core.PersistentVector(null,2,(5),inst_23289,inst_23290,null));
var inst_23292 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_23291);
var state_23332__$1 = (function (){var statearr_23345 = state_23332;
(statearr_23345[(13)] = inst_23288);

return statearr_23345;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23332__$1,(25),inst_23292);
} else {
if((state_val_23333 === (29))){
var inst_23299 = (state_23332[(2)]);
var inst_23300 = fluree.db.util.async.throw_err(inst_23299);
var state_23332__$1 = state_23332;
var statearr_23346_23393 = state_23332__$1;
(statearr_23346_23393[(2)] = inst_23300);

(statearr_23346_23393[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (6))){
var inst_23248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23249 = cljs.core.PersistentVector.EMPTY;
var inst_23250 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_23251 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23249,inst_23250);
var inst_23252 = [db,inst_23251];
var inst_23253 = (new cljs.core.PersistentVector(null,2,(5),inst_23248,inst_23252,null));
var state_23332__$1 = state_23332;
var statearr_23347_23394 = state_23332__$1;
(statearr_23347_23394[(2)] = inst_23253);

(statearr_23347_23394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (28))){
var inst_23303 = (state_23332[(2)]);
var inst_23304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23305 = cljs.core.PersistentVector.EMPTY;
var inst_23306 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_23307 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23305,inst_23306);
var inst_23308 = [inst_23303,inst_23307];
var inst_23309 = (new cljs.core.PersistentVector(null,2,(5),inst_23304,inst_23308,null));
var state_23332__$1 = state_23332;
var statearr_23348_23395 = state_23332__$1;
(statearr_23348_23395[(2)] = inst_23309);

(statearr_23348_23395[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (25))){
var inst_23288 = (state_23332[(13)]);
var inst_23294 = (state_23332[(2)]);
var inst_23295 = fluree.db.util.async.throw_err(inst_23294);
var state_23332__$1 = (function (){var statearr_23349 = state_23332;
(statearr_23349[(8)] = inst_23295);

return statearr_23349;
})();
if(cljs.core.truth_(inst_23288)){
var statearr_23350_23396 = state_23332__$1;
(statearr_23350_23396[(1)] = (26));

} else {
var statearr_23351_23397 = state_23332__$1;
(statearr_23351_23397[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (17))){
var state_23332__$1 = state_23332;
var statearr_23352_23398 = state_23332__$1;
(statearr_23352_23398[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (3))){
var inst_23330 = (state_23332[(2)]);
var state_23332__$1 = state_23332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23332__$1,inst_23330);
} else {
if((state_val_23333 === (12))){
var inst_23262 = (state_23332[(9)]);
var inst_23261 = (state_23332[(2)]);
var inst_23262__$1 = fluree.db.util.async.throw_err(inst_23261);
var inst_23263 = fluree.db.util.core.exception_QMARK_(inst_23262__$1);
var state_23332__$1 = (function (){var statearr_23354 = state_23332;
(statearr_23354[(9)] = inst_23262__$1);

return statearr_23354;
})();
if(inst_23263){
var statearr_23355_23399 = state_23332__$1;
(statearr_23355_23399[(1)] = (13));

} else {
var statearr_23356_23400 = state_23332__$1;
(statearr_23356_23400[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (2))){
var inst_23245 = (state_23332[(7)]);
var _ = (function (){var statearr_23357 = state_23332;
(statearr_23357[(4)] = cljs.core.cons((5),(state_23332[(4)])));

return statearr_23357;
})();
var inst_23245__$1 = cljs.core.first(clause);
var inst_23246 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_23245__$1);
var state_23332__$1 = (function (){var statearr_23358 = state_23332;
(statearr_23358[(7)] = inst_23245__$1);

return statearr_23358;
})();
if(inst_23246){
var statearr_23359_23401 = state_23332__$1;
(statearr_23359_23401[(1)] = (6));

} else {
var statearr_23360_23402 = state_23332__$1;
(statearr_23360_23402[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (23))){
var inst_23245 = (state_23332[(7)]);
var inst_23311 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23245)," is not supported in Fluree"].join('');
var inst_23312 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23313 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23314 = cljs.core.PersistentHashMap.fromArrays(inst_23312,inst_23313);
var inst_23315 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_23311,inst_23314);
var inst_23316 = (function(){throw inst_23315})();
var state_23332__$1 = state_23332;
var statearr_23361_23403 = state_23332__$1;
(statearr_23361_23403[(2)] = inst_23316);

(statearr_23361_23403[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (19))){
var inst_23245 = (state_23332[(7)]);
var inst_23286 = (state_23332[(12)]);
var inst_23283 = fluree.db.query.analytical.isolate_source_name(inst_23245);
var inst_23284 = fluree.db.query.analytical.isolate_source_block(inst_23245);
var inst_23285 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_23283);
var inst_23286__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_23285);
var state_23332__$1 = (function (){var statearr_23362 = state_23332;
(statearr_23362[(11)] = inst_23284);

(statearr_23362[(12)] = inst_23286__$1);

return statearr_23362;
})();
if(cljs.core.truth_(inst_23286__$1)){
var statearr_23363_23404 = state_23332__$1;
(statearr_23363_23404[(1)] = (22));

} else {
var statearr_23364_23405 = state_23332__$1;
(statearr_23364_23405[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (11))){
var inst_23325 = (state_23332[(2)]);
var state_23332__$1 = state_23332;
var statearr_23366_23406 = state_23332__$1;
(statearr_23366_23406[(2)] = inst_23325);

(statearr_23366_23406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (9))){
var inst_23245 = (state_23332[(7)]);
var inst_23257 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_23245,(4));
var inst_23258 = fluree.db.query.analytical.parse_block_from_source(inst_23257);
var inst_23259 = fluree.db.time_travel.as_of_block(db,inst_23258);
var state_23332__$1 = state_23332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23332__$1,(12),inst_23259);
} else {
if((state_val_23333 === (5))){
var _ = (function (){var statearr_23367 = state_23332;
(statearr_23367[(4)] = cljs.core.rest((state_23332[(4)])));

return statearr_23367;
})();
var state_23332__$1 = state_23332;
var ex23365 = (state_23332__$1[(2)]);
var statearr_23368_23407 = state_23332__$1;
(statearr_23368_23407[(5)] = ex23365);


if((ex23365 instanceof Error)){
var statearr_23369_23408 = state_23332__$1;
(statearr_23369_23408[(1)] = (4));

(statearr_23369_23408[(5)] = null);

} else {
throw ex23365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (14))){
var state_23332__$1 = state_23332;
var statearr_23370_23409 = state_23332__$1;
(statearr_23370_23409[(2)] = null);

(statearr_23370_23409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (26))){
var inst_23288 = (state_23332[(13)]);
var inst_23295 = (state_23332[(8)]);
var inst_23297 = fluree.db.time_travel.as_of_block(inst_23295,inst_23288);
var state_23332__$1 = state_23332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23332__$1,(29),inst_23297);
} else {
if((state_val_23333 === (16))){
var inst_23278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23279 = ["$wd",clause];
var inst_23280 = (new cljs.core.PersistentVector(null,2,(5),inst_23278,inst_23279,null));
var state_23332__$1 = state_23332;
var statearr_23371_23410 = state_23332__$1;
(statearr_23371_23410[(2)] = inst_23280);

(statearr_23371_23410[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (10))){
var inst_23245 = (state_23332[(7)]);
var inst_23276 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_23245);
var state_23332__$1 = state_23332;
if(inst_23276){
var statearr_23372_23411 = state_23332__$1;
(statearr_23372_23411[(1)] = (16));

} else {
var statearr_23373_23412 = state_23332__$1;
(statearr_23373_23412[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (18))){
var inst_23323 = (state_23332[(2)]);
var state_23332__$1 = state_23332;
var statearr_23374_23413 = state_23332__$1;
(statearr_23374_23413[(2)] = inst_23323);

(statearr_23374_23413[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23333 === (8))){
var inst_23327 = (state_23332[(2)]);
var _ = (function (){var statearr_23375 = state_23332;
(statearr_23375[(4)] = cljs.core.rest((state_23332[(4)])));

return statearr_23375;
})();
var state_23332__$1 = state_23332;
var statearr_23376_23414 = state_23332__$1;
(statearr_23376_23414[(2)] = inst_23327);

(statearr_23376_23414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2684__auto__ = null;
var fluree$db$query$analytical$state_machine__2684__auto____0 = (function (){
var statearr_23377 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23377[(0)] = fluree$db$query$analytical$state_machine__2684__auto__);

(statearr_23377[(1)] = (1));

return statearr_23377;
});
var fluree$db$query$analytical$state_machine__2684__auto____1 = (function (state_23332){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23332);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23378){var ex__2687__auto__ = e23378;
var statearr_23379_23415 = state_23332;
(statearr_23379_23415[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23332[(4)]))){
var statearr_23380_23416 = state_23332;
(statearr_23380_23416[(1)] = cljs.core.first((state_23332[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23417 = state_23332;
state_23332 = G__23417;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2684__auto__ = function(state_23332){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2684__auto____1.call(this,state_23332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2684__auto____0;
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2684__auto____1;
return fluree$db$query$analytical$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23381 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23381[(6)] = c__2706__auto__);

return statearr_23381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__23418){
var vec__23419 = p__23418;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23419,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23419,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23422_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__23422_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__23426 = subjects;
var vec__23427 = G__23426;
var seq__23428 = cljs.core.seq(vec__23427);
var first__23429 = cljs.core.first(seq__23428);
var seq__23428__$1 = cljs.core.next(seq__23428);
var subject = first__23429;
var r = seq__23428__$1;
var acc = expanded_map;
var G__23426__$1 = G__23426;
var acc__$1 = acc;
while(true){
var vec__23433 = G__23426__$1;
var seq__23434 = cljs.core.seq(vec__23433);
var first__23435 = cljs.core.first(seq__23434);
var seq__23434__$1 = cljs.core.next(seq__23434);
var subject__$1 = first__23435;
var r__$1 = seq__23434__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__23436 = r__$1;
var G__23437 = acc__$2;
G__23426__$1 = G__23436;
acc__$1 = G__23437;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__23426__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__23433,seq__23434,first__23435,seq__23434__$1,subject__$1,r__$1,acc__$2,G__23426,vec__23427,seq__23428,first__23429,seq__23428__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__23426__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__23433,seq__23434,first__23435,seq__23434__$1,subject__$1,r__$1,acc__$2,G__23426,vec__23427,seq__23428,first__23429,seq__23428__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__23426__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__23433,seq__23434,first__23435,seq__23434__$1,subject__$1,r__$1,acc__$2,G__23426,vec__23427,seq__23428,first__23429,seq__23428__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__23426__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__23433,seq__23434,first__23435,seq__23434__$1,subject__$1,r__$1,acc__$2,G__23426,vec__23427,seq__23428,first__23429,seq__23428__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__23426__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__23433,seq__23434,first__23435,seq__23434__$1,subject__$1,r__$1,acc__$2,G__23426,vec__23427,seq__23428,first__23429,seq__23428__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__23426__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__23433,seq__23434,first__23435,seq__23434__$1,subject__$1,r__$1,acc__$2,G__23426,vec__23427,seq__23428,first__23429,seq__23428__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__23438 = r__$1;
var G__23439 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__23426__$1 = G__23438;
acc__$1 = G__23439;
continue;
} else {
var G__23440 = subjects;
var G__23441 = acc_STAR_;
G__23426__$1 = G__23440;
acc__$1 = G__23441;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23442_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__23442_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23533){
var state_val_23534 = (state_23533[(1)]);
if((state_val_23534 === (7))){
var state_23533__$1 = state_23533;
var statearr_23535_23581 = state_23533__$1;
(statearr_23535_23581[(2)] = (100));

(statearr_23535_23581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (20))){
var inst_23482 = (state_23533[(7)]);
var state_23533__$1 = state_23533;
var statearr_23536_23582 = state_23533__$1;
(statearr_23536_23582[(2)] = inst_23482);

(statearr_23536_23582[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (1))){
var state_23533__$1 = state_23533;
var statearr_23537_23583 = state_23533__$1;
(statearr_23537_23583[(2)] = null);

(statearr_23537_23583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (24))){
var inst_23520 = (state_23533[(8)]);
var inst_23519 = (state_23533[(9)]);
var inst_23454 = (state_23533[(10)]);
var inst_23521 = (state_23533[(11)]);
var inst_23524 = (function (){var max_depth = inst_23454;
var recur_map__$1 = inst_23520;
var subjects = inst_23519;
var tuples = inst_23521;
return (function (p1__23443_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__23443_SHARP_)],null));
});
})();
var inst_23525 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23524,inst_23521);
var inst_23526 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_23525);
var state_23533__$1 = state_23533;
var statearr_23538_23584 = state_23533__$1;
(statearr_23538_23584[(2)] = inst_23526);

(statearr_23538_23584[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (4))){
var inst_23444 = (state_23533[(2)]);
var state_23533__$1 = state_23533;
var statearr_23539_23585 = state_23533__$1;
(statearr_23539_23585[(2)] = inst_23444);

(statearr_23539_23585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (15))){
var inst_23467 = (state_23533[(12)]);
var inst_23478 = cljs.core.PersistentVector.EMPTY;
var inst_23479 = cljs.core.seq(inst_23467);
var inst_23480 = cljs.core.first(inst_23479);
var inst_23481 = cljs.core.next(inst_23479);
var inst_23482 = inst_23478;
var inst_23483 = inst_23467;
var state_23533__$1 = (function (){var statearr_23540 = state_23533;
(statearr_23540[(13)] = inst_23480);

(statearr_23540[(7)] = inst_23482);

(statearr_23540[(14)] = inst_23481);

(statearr_23540[(15)] = inst_23483);

return statearr_23540;
})();
var statearr_23541_23586 = state_23533__$1;
(statearr_23541_23586[(2)] = null);

(statearr_23541_23586[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (21))){
var inst_23503 = (state_23533[(2)]);
var state_23533__$1 = state_23533;
var statearr_23542_23587 = state_23533__$1;
(statearr_23542_23587[(2)] = inst_23503);

(statearr_23542_23587[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (13))){
var inst_23516 = (state_23533[(2)]);
var state_23533__$1 = state_23533;
var statearr_23543_23588 = state_23533__$1;
(statearr_23543_23588[(2)] = inst_23516);

(statearr_23543_23588[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (22))){
var inst_23482 = (state_23533[(7)]);
var inst_23490 = (state_23533[(16)]);
var inst_23497 = (state_23533[(2)]);
var inst_23498 = fluree.db.util.async.throw_err(inst_23497);
var inst_23499 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23482,inst_23498);
var inst_23482__$1 = inst_23499;
var inst_23483 = inst_23490;
var state_23533__$1 = (function (){var statearr_23544 = state_23533;
(statearr_23544[(7)] = inst_23482__$1);

(statearr_23544[(15)] = inst_23483);

return statearr_23544;
})();
var statearr_23545_23589 = state_23533__$1;
(statearr_23545_23589[(2)] = null);

(statearr_23545_23589[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (6))){
var inst_23450 = (state_23533[(17)]);
var state_23533__$1 = state_23533;
var statearr_23546_23590 = state_23533__$1;
(statearr_23546_23590[(2)] = inst_23450);

(statearr_23546_23590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (25))){
var inst_23528 = (state_23533[(2)]);
var _ = (function (){var statearr_23547 = state_23533;
(statearr_23547[(4)] = cljs.core.rest((state_23533[(4)])));

return statearr_23547;
})();
var state_23533__$1 = state_23533;
var statearr_23548_23591 = state_23533__$1;
(statearr_23548_23591[(2)] = inst_23528);

(statearr_23548_23591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (17))){
var inst_23489 = (state_23533[(18)]);
var inst_23483 = (state_23533[(15)]);
var inst_23488 = cljs.core.seq(inst_23483);
var inst_23489__$1 = cljs.core.first(inst_23488);
var inst_23490 = cljs.core.next(inst_23488);
var state_23533__$1 = (function (){var statearr_23549 = state_23533;
(statearr_23549[(18)] = inst_23489__$1);

(statearr_23549[(16)] = inst_23490);

return statearr_23549;
})();
if(cljs.core.truth_(inst_23489__$1)){
var statearr_23550_23592 = state_23533__$1;
(statearr_23550_23592[(1)] = (19));

} else {
var statearr_23551_23593 = state_23533__$1;
(statearr_23551_23593[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (3))){
var inst_23531 = (state_23533[(2)]);
var state_23533__$1 = state_23533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23533__$1,inst_23531);
} else {
if((state_val_23534 === (12))){
var inst_23467 = (state_23533[(12)]);
var inst_23456 = (state_23533[(19)]);
var inst_23462 = cljs.core.vals(inst_23456);
var inst_23463 = cljs.core.flatten(inst_23462);
var inst_23464 = cljs.core.set(inst_23463);
var inst_23465 = cljs.core.keys(inst_23456);
var inst_23466 = cljs.core.set(inst_23465);
var inst_23467__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_23464,inst_23466);
var inst_23468 = cljs.core.empty_QMARK_(inst_23467__$1);
var state_23533__$1 = (function (){var statearr_23552 = state_23533;
(statearr_23552[(12)] = inst_23467__$1);

return statearr_23552;
})();
if(inst_23468){
var statearr_23553_23594 = state_23533__$1;
(statearr_23553_23594[(1)] = (14));

} else {
var statearr_23554_23595 = state_23533__$1;
(statearr_23554_23595[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (2))){
var inst_23450 = (state_23533[(17)]);
var _ = (function (){var statearr_23555 = state_23533;
(statearr_23555[(4)] = cljs.core.cons((5),(state_23533[(4)])));

return statearr_23555;
})();
var inst_23450__$1 = depth;
var state_23533__$1 = (function (){var statearr_23556 = state_23533;
(statearr_23556[(17)] = inst_23450__$1);

return statearr_23556;
})();
if(cljs.core.truth_(inst_23450__$1)){
var statearr_23557_23596 = state_23533__$1;
(statearr_23557_23596[(1)] = (6));

} else {
var statearr_23558_23597 = state_23533__$1;
(statearr_23558_23597[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (23))){
var inst_23521 = (state_23533[(11)]);
var state_23533__$1 = state_23533;
var statearr_23559_23598 = state_23533__$1;
(statearr_23559_23598[(2)] = inst_23521);

(statearr_23559_23598[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (19))){
var inst_23489 = (state_23533[(18)]);
var inst_23492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23493 = [inst_23489,predicate];
var inst_23494 = (new cljs.core.PersistentVector(null,2,(5),inst_23492,inst_23493,null));
var inst_23495 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23494);
var state_23533__$1 = state_23533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23533__$1,(22),inst_23495);
} else {
if((state_val_23534 === (11))){
var inst_23456 = (state_23533[(19)]);
var state_23533__$1 = state_23533;
var statearr_23561_23599 = state_23533__$1;
(statearr_23561_23599[(2)] = inst_23456);

(statearr_23561_23599[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (9))){
var inst_23454 = (state_23533[(10)]);
var inst_23457 = (state_23533[(20)]);
var inst_23459 = (inst_23457 >= inst_23454);
var state_23533__$1 = state_23533;
if(cljs.core.truth_(inst_23459)){
var statearr_23562_23600 = state_23533__$1;
(statearr_23562_23600[(1)] = (11));

} else {
var statearr_23563_23601 = state_23533__$1;
(statearr_23563_23601[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (5))){
var _ = (function (){var statearr_23564 = state_23533;
(statearr_23564[(4)] = cljs.core.rest((state_23533[(4)])));

return statearr_23564;
})();
var state_23533__$1 = state_23533;
var ex23560 = (state_23533__$1[(2)]);
var statearr_23565_23602 = state_23533__$1;
(statearr_23565_23602[(5)] = ex23560);


if((ex23560 instanceof Error)){
var statearr_23566_23603 = state_23533__$1;
(statearr_23566_23603[(1)] = (4));

(statearr_23566_23603[(5)] = null);

} else {
throw ex23560;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (14))){
var inst_23456 = (state_23533[(19)]);
var state_23533__$1 = state_23533;
var statearr_23567_23604 = state_23533__$1;
(statearr_23567_23604[(2)] = inst_23456);

(statearr_23567_23604[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (16))){
var inst_23514 = (state_23533[(2)]);
var state_23533__$1 = state_23533;
var statearr_23568_23605 = state_23533__$1;
(statearr_23568_23605[(2)] = inst_23514);

(statearr_23568_23605[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (10))){
var inst_23520 = (state_23533[(8)]);
var inst_23519 = (state_23533[(9)]);
var inst_23518 = (state_23533[(2)]);
var inst_23519__$1 = cljs.core.keys(inst_23518);
var inst_23520__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_23519__$1,inst_23518);
var inst_23521 = fluree.db.query.analytical.recur_map__GT_tuples(inst_23519__$1,inst_23520__$1);
var state_23533__$1 = (function (){var statearr_23569 = state_23533;
(statearr_23569[(8)] = inst_23520__$1);

(statearr_23569[(9)] = inst_23519__$1);

(statearr_23569[(11)] = inst_23521);

return statearr_23569;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_23570_23606 = state_23533__$1;
(statearr_23570_23606[(1)] = (23));

} else {
var statearr_23571_23607 = state_23533__$1;
(statearr_23571_23607[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (18))){
var inst_23457 = (state_23533[(20)]);
var inst_23456 = (state_23533[(19)]);
var inst_23505 = (state_23533[(2)]);
var inst_23506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23507 = [(0),(2)];
var inst_23508 = (new cljs.core.PersistentVector(null,2,(5),inst_23506,inst_23507,null));
var inst_23509 = fluree.db.query.analytical.transform_tuples_to_idxs(inst_23508,inst_23505);
var inst_23510 = fluree.db.query.analytical.tuples__GT_map(inst_23456,inst_23509);
var inst_23511 = (inst_23457 + (1));
var inst_23456__$1 = inst_23510;
var inst_23457__$1 = inst_23511;
var state_23533__$1 = (function (){var statearr_23572 = state_23533;
(statearr_23572[(20)] = inst_23457__$1);

(statearr_23572[(19)] = inst_23456__$1);

return statearr_23572;
})();
var statearr_23573_23608 = state_23533__$1;
(statearr_23573_23608[(2)] = null);

(statearr_23573_23608[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23534 === (8))){
var inst_23454 = (state_23533[(2)]);
var inst_23455 = recur_map;
var inst_23456 = inst_23455;
var inst_23457 = (1);
var state_23533__$1 = (function (){var statearr_23574 = state_23533;
(statearr_23574[(10)] = inst_23454);

(statearr_23574[(20)] = inst_23457);

(statearr_23574[(19)] = inst_23456);

return statearr_23574;
})();
var statearr_23575_23609 = state_23533__$1;
(statearr_23575_23609[(2)] = null);

(statearr_23575_23609[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0 = (function (){
var statearr_23576 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23576[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__);

(statearr_23576[(1)] = (1));

return statearr_23576;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1 = (function (state_23533){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23533);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23577){var ex__2687__auto__ = e23577;
var statearr_23578_23610 = state_23533;
(statearr_23578_23610[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23533[(4)]))){
var statearr_23579_23611 = state_23533;
(statearr_23579_23611[(1)] = cljs.core.first((state_23533[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23612 = state_23533;
state_23533 = G__23612;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__ = function(state_23533){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1.call(this,state_23533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23580 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23580[(6)] = c__2706__auto__);

return statearr_23580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__23613,clause,fuel,max_fuel,opts){
var map__23614 = p__23613;
var map__23614__$1 = cljs.core.__destructure_map(map__23614);
var res = map__23614__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23614__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23614__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23614__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23731){
var state_val_23732 = (state_23731[(1)]);
if((state_val_23732 === (7))){
var inst_23631 = (state_23731[(7)]);
var state_23731__$1 = state_23731;
var statearr_23733_23791 = state_23731__$1;
(statearr_23733_23791[(2)] = inst_23631);

(statearr_23733_23791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (20))){
var inst_23641 = (state_23731[(8)]);
var inst_23684 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23641)].join('');
var inst_23685 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23686 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23687 = cljs.core.PersistentHashMap.fromArrays(inst_23685,inst_23686);
var inst_23688 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_23684,inst_23687);
var inst_23689 = (function(){throw inst_23688})();
var state_23731__$1 = state_23731;
var statearr_23734_23792 = state_23731__$1;
(statearr_23734_23792[(2)] = inst_23689);

(statearr_23734_23792[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (27))){
var inst_23713 = (state_23731[(2)]);
var state_23731__$1 = state_23731;
var statearr_23735_23793 = state_23731__$1;
(statearr_23735_23793[(2)] = inst_23713);

(statearr_23735_23793[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (1))){
var state_23731__$1 = state_23731;
var statearr_23736_23794 = state_23731__$1;
(statearr_23736_23794[(2)] = null);

(statearr_23736_23794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (24))){
var inst_23668 = (state_23731[(9)]);
var inst_23667 = (state_23731[(10)]);
var inst_23632 = (state_23731[(11)]);
var inst_23715 = (state_23731[(2)]);
var inst_23716 = fluree.db.query.analytical.tuples__GT_recur(db,inst_23668,inst_23715,inst_23632,inst_23667);
var state_23731__$1 = state_23731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23731__$1,(31),inst_23716);
} else {
if((state_val_23732 === (4))){
var inst_23615 = (state_23731[(2)]);
var state_23731__$1 = state_23731;
var statearr_23737_23795 = state_23731__$1;
(statearr_23737_23795[(2)] = inst_23615);

(statearr_23737_23795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (15))){
var inst_23629 = (state_23731[(12)]);
var inst_23722 = (state_23731[(2)]);
var inst_23723 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_23724 = cljs.core.keys(inst_23629);
var inst_23725 = [inst_23724,vars,inst_23722];
var inst_23726 = cljs.core.PersistentHashMap.fromArrays(inst_23723,inst_23725);
var _ = (function (){var statearr_23738 = state_23731;
(statearr_23738[(4)] = cljs.core.rest((state_23731[(4)])));

return statearr_23738;
})();
var state_23731__$1 = state_23731;
var statearr_23739_23796 = state_23731__$1;
(statearr_23739_23796[(2)] = inst_23726);

(statearr_23739_23796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (21))){
var inst_23667 = (state_23731[(10)]);
var inst_23691 = (state_23731[(2)]);
var state_23731__$1 = (function (){var statearr_23740 = state_23731;
(statearr_23740[(13)] = inst_23691);

return statearr_23740;
})();
if(cljs.core.truth_(inst_23667)){
var statearr_23741_23797 = state_23731__$1;
(statearr_23741_23797[(1)] = (22));

} else {
var statearr_23742_23798 = state_23731__$1;
(statearr_23742_23798[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (31))){
var inst_23718 = (state_23731[(2)]);
var inst_23719 = fluree.db.util.async.throw_err(inst_23718);
var state_23731__$1 = state_23731;
var statearr_23743_23799 = state_23731__$1;
(statearr_23743_23799[(2)] = inst_23719);

(statearr_23743_23799[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (13))){
var inst_23668 = (state_23731[(9)]);
var inst_23641 = (state_23731[(8)]);
var inst_23665 = cljs.core.first(inst_23641);
var inst_23666 = cljs.core.first(clause);
var inst_23667 = fluree.db.query.analytical.variable_QMARK_(inst_23666);
var inst_23668__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_23641,(1));
var inst_23669 = fluree.db.query.analytical.variable_QMARK_(inst_23668__$1);
var state_23731__$1 = (function (){var statearr_23744 = state_23731;
(statearr_23744[(14)] = inst_23665);

(statearr_23744[(9)] = inst_23668__$1);

(statearr_23744[(10)] = inst_23667);

return statearr_23744;
})();
if(cljs.core.truth_(inst_23669)){
var statearr_23745_23800 = state_23731__$1;
(statearr_23745_23800[(1)] = (16));

} else {
var statearr_23746_23801 = state_23731__$1;
(statearr_23746_23801[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (22))){
var inst_23663 = (state_23731[(15)]);
var inst_23693 = cljs.core.PersistentHashMap.EMPTY;
var inst_23694 = fluree.db.query.analytical.tuples__GT_map(inst_23693,inst_23663);
var state_23731__$1 = state_23731;
var statearr_23747_23802 = state_23731__$1;
(statearr_23747_23802[(2)] = inst_23694);

(statearr_23747_23802[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (29))){
var state_23731__$1 = state_23731;
var statearr_23748_23803 = state_23731__$1;
(statearr_23748_23803[(2)] = null);

(statearr_23748_23803[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (6))){
var inst_23643 = (state_23731[(16)]);
var state_23731__$1 = state_23731;
var statearr_23749_23804 = state_23731__$1;
(statearr_23749_23804[(2)] = inst_23643);

(statearr_23749_23804[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (28))){
var inst_23663 = (state_23731[(15)]);
var inst_23659 = (state_23731[(17)]);
var inst_23704 = cljs.core.PersistentHashMap.EMPTY;
var inst_23705 = cljs.core.first(inst_23659);
var inst_23706 = cljs.core.first(inst_23705);
var inst_23707 = cljs.core.flatten(inst_23663);
var inst_23708 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23704,inst_23706,inst_23707);
var state_23731__$1 = state_23731;
var statearr_23750_23805 = state_23731__$1;
(statearr_23750_23805[(2)] = inst_23708);

(statearr_23750_23805[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (25))){
var inst_23663 = (state_23731[(15)]);
var inst_23665 = (state_23731[(14)]);
var inst_23698 = cljs.core.PersistentHashMap.EMPTY;
var inst_23699 = cljs.core.flatten(inst_23663);
var inst_23700 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23698,inst_23665,inst_23699);
var state_23731__$1 = state_23731;
var statearr_23751_23806 = state_23731__$1;
(statearr_23751_23806[(2)] = inst_23700);

(statearr_23751_23806[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (17))){
var state_23731__$1 = state_23731;
var statearr_23752_23807 = state_23731__$1;
(statearr_23752_23807[(2)] = null);

(statearr_23752_23807[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (3))){
var inst_23729 = (state_23731[(2)]);
var state_23731__$1 = state_23731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23731__$1,inst_23729);
} else {
if((state_val_23732 === (12))){
var inst_23659 = (state_23731[(17)]);
var inst_23629 = (state_23731[(12)]);
var inst_23632 = (state_23731[(11)]);
var inst_23659__$1 = (state_23731[(2)]);
var inst_23660 = cljs.core.count(inst_23659__$1);
var inst_23661 = fluree.db.query.analytical.add_fuel(inst_23660,fuel,max_fuel);
var inst_23662 = cljs.core.vals(inst_23629);
var inst_23663 = fluree.db.query.analytical.transform_tuples_to_idxs(inst_23662,inst_23659__$1);
var state_23731__$1 = (function (){var statearr_23753 = state_23731;
(statearr_23753[(18)] = inst_23661);

(statearr_23753[(15)] = inst_23663);

(statearr_23753[(17)] = inst_23659__$1);

return statearr_23753;
})();
if(cljs.core.truth_(inst_23632)){
var statearr_23754_23808 = state_23731__$1;
(statearr_23754_23808[(1)] = (13));

} else {
var statearr_23755_23809 = state_23731__$1;
(statearr_23755_23809[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (2))){
var inst_23643 = (state_23731[(16)]);
var inst_23631 = (state_23731[(7)]);
var inst_23629 = (state_23731[(12)]);
var inst_23632 = (state_23731[(11)]);
var _ = (function (){var statearr_23756 = state_23731;
(statearr_23756[(4)] = cljs.core.cons((5),(state_23731[(4)])));

return statearr_23756;
})();
var inst_23625 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_23626 = cljs.core.__destructure_map(inst_23625);
var inst_23627 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23626,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_23628 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23626,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_23629__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23626,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_23630 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_23631__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_23627);
var inst_23632__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23627);
var inst_23634 = (function (){var map__23621 = inst_23626;
var search_opts = inst_23627;
var search = inst_23628;
var rel = inst_23629__$1;
var common_keys = inst_23630;
var object_fn = inst_23631__$1;
var recur_depth = inst_23632__$1;
return (function (p__23633,common_key){
var vec__23757 = p__23633;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23757,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23757,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__23760 = cljs.core._EQ_;
var expr__23761 = idx_of;
if(cljs.core.truth_((pred__23760.cljs$core$IFn$_invoke$arity$2 ? pred__23760.cljs$core$IFn$_invoke$arity$2((0),expr__23761) : pred__23760.call(null,(0),expr__23761)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__23760.cljs$core$IFn$_invoke$arity$2 ? pred__23760.cljs$core$IFn$_invoke$arity$2((1),expr__23761) : pred__23760.call(null,(1),expr__23761)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__23760.cljs$core$IFn$_invoke$arity$2 ? pred__23760.cljs$core$IFn$_invoke$arity$2((2),expr__23761) : pred__23760.call(null,(2),expr__23761)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__23761)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_23635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23636 = cljs.core.PersistentHashMap.EMPTY;
var inst_23637 = [inst_23636,inst_23628];
var inst_23638 = (new cljs.core.PersistentVector(null,2,(5),inst_23635,inst_23637,null));
var inst_23639 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23634,inst_23638,inst_23630);
var inst_23640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23639,(0),null);
var inst_23641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23639,(1),null);
var inst_23642 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_23643__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_23640);
var state_23731__$1 = (function (){var statearr_23763 = state_23731;
(statearr_23763[(19)] = inst_23642);

(statearr_23763[(16)] = inst_23643__$1);

(statearr_23763[(7)] = inst_23631__$1);

(statearr_23763[(8)] = inst_23641);

(statearr_23763[(12)] = inst_23629__$1);

(statearr_23763[(11)] = inst_23632__$1);

return statearr_23763;
})();
if(cljs.core.truth_(inst_23643__$1)){
var statearr_23764_23810 = state_23731__$1;
(statearr_23764_23810[(1)] = (6));

} else {
var statearr_23765_23811 = state_23731__$1;
(statearr_23765_23811[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (23))){
var inst_23665 = (state_23731[(14)]);
var inst_23696 = typeof inst_23665 === 'number';
var state_23731__$1 = state_23731;
if(cljs.core.truth_(inst_23696)){
var statearr_23766_23812 = state_23731__$1;
(statearr_23766_23812[(1)] = (25));

} else {
var statearr_23767_23813 = state_23731__$1;
(statearr_23767_23813[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (19))){
var state_23731__$1 = state_23731;
var statearr_23768_23814 = state_23731__$1;
(statearr_23768_23814[(2)] = null);

(statearr_23768_23814[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (11))){
var inst_23653 = (state_23731[(20)]);
var state_23731__$1 = state_23731;
var statearr_23770_23815 = state_23731__$1;
(statearr_23770_23815[(2)] = inst_23653);

(statearr_23770_23815[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (9))){
var inst_23652 = (state_23731[(2)]);
var inst_23653 = fluree.db.util.async.throw_err(inst_23652);
var inst_23654 = new cljs.core.Keyword(null,"parse-json?","parse-json?",140680877).cljs$core$IFn$_invoke$arity$1(opts);
var state_23731__$1 = (function (){var statearr_23771 = state_23731;
(statearr_23771[(20)] = inst_23653);

return statearr_23771;
})();
if(cljs.core.truth_(inst_23654)){
var statearr_23772_23816 = state_23731__$1;
(statearr_23772_23816[(1)] = (10));

} else {
var statearr_23773_23817 = state_23731__$1;
(statearr_23773_23817[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (5))){
var _ = (function (){var statearr_23774 = state_23731;
(statearr_23774[(4)] = cljs.core.rest((state_23731[(4)])));

return statearr_23774;
})();
var state_23731__$1 = state_23731;
var ex23769 = (state_23731__$1[(2)]);
var statearr_23775_23818 = state_23731__$1;
(statearr_23775_23818[(5)] = ex23769);


if((ex23769 instanceof Error)){
var statearr_23776_23819 = state_23731__$1;
(statearr_23776_23819[(1)] = (4));

(statearr_23776_23819[(5)] = null);

} else {
throw ex23769;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (14))){
var inst_23663 = (state_23731[(15)]);
var state_23731__$1 = state_23731;
var statearr_23777_23820 = state_23731__$1;
(statearr_23777_23820[(2)] = inst_23663);

(statearr_23777_23820[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (26))){
var inst_23665 = (state_23731[(14)]);
var inst_23702 = cljs.core.coll_QMARK_(inst_23665);
var state_23731__$1 = state_23731;
if(inst_23702){
var statearr_23778_23821 = state_23731__$1;
(statearr_23778_23821[(1)] = (28));

} else {
var statearr_23779_23822 = state_23731__$1;
(statearr_23779_23822[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (16))){
var inst_23641 = (state_23731[(8)]);
var inst_23671 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23641)].join('');
var inst_23672 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23673 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23674 = cljs.core.PersistentHashMap.fromArrays(inst_23672,inst_23673);
var inst_23675 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_23671,inst_23674);
var inst_23676 = (function(){throw inst_23675})();
var state_23731__$1 = state_23731;
var statearr_23780_23823 = state_23731__$1;
(statearr_23780_23823[(2)] = inst_23676);

(statearr_23780_23823[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (30))){
var inst_23711 = (state_23731[(2)]);
var state_23731__$1 = state_23731;
var statearr_23781_23824 = state_23731__$1;
(statearr_23781_23824[(2)] = inst_23711);

(statearr_23781_23824[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (10))){
var inst_23653 = (state_23731[(20)]);
var inst_23656 = fluree.db.util.json.parse_json_flakes(db,inst_23653);
var state_23731__$1 = state_23731;
var statearr_23782_23825 = state_23731__$1;
(statearr_23782_23825[(2)] = inst_23656);

(statearr_23782_23825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (18))){
var inst_23679 = (state_23731[(2)]);
var inst_23680 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_23681 = fluree.db.query.analytical.variable_QMARK_(inst_23680);
var state_23731__$1 = (function (){var statearr_23783 = state_23731;
(statearr_23783[(21)] = inst_23679);

return statearr_23783;
})();
if(cljs.core.truth_(inst_23681)){
var statearr_23784_23826 = state_23731__$1;
(statearr_23784_23826[(1)] = (19));

} else {
var statearr_23785_23827 = state_23731__$1;
(statearr_23785_23827[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23732 === (8))){
var inst_23642 = (state_23731[(19)]);
var inst_23641 = (state_23731[(8)]);
var inst_23647 = (state_23731[(2)]);
var inst_23648 = [inst_23647];
var inst_23649 = cljs.core.PersistentHashMap.fromArrays(inst_23642,inst_23648);
var inst_23650 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_23641,inst_23649);
var state_23731__$1 = state_23731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23731__$1,(9),inst_23650);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_23786 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23786[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__);

(statearr_23786[(1)] = (1));

return statearr_23786;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1 = (function (state_23731){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23731);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23787){var ex__2687__auto__ = e23787;
var statearr_23788_23828 = state_23731;
(statearr_23788_23828[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23731[(4)]))){
var statearr_23789_23829 = state_23731;
(statearr_23789_23829[(1)] = cljs.core.first((state_23731[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23830 = state_23731;
state_23731 = G__23830;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__ = function(state_23731){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1.call(this,state_23731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23790 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23790[(6)] = c__2706__auto__);

return statearr_23790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__23831,res,clause){
var map__23832 = p__23831;
var map__23832__$1 = cljs.core.__destructure_map(map__23832);
var db = map__23832__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23832__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23832__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23832__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23946){
var state_val_23947 = (state_23946[(1)]);
if((state_val_23947 === (7))){
var inst_23841 = (state_23946[(7)]);
var state_23946__$1 = state_23946;
var statearr_23948_23993 = state_23946__$1;
(statearr_23948_23993[(2)] = inst_23841);

(statearr_23948_23993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (20))){
var inst_23841 = (state_23946[(7)]);
var inst_23877 = (state_23946[(8)]);
var inst_23843 = (state_23946[(9)]);
var inst_23878 = (state_23946[(10)]);
var inst_23875 = (state_23946[(11)]);
var inst_23893 = (state_23946[(2)]);
var inst_23894 = (function (){var subject_var = inst_23841;
var object_var = inst_23843;
var partition = inst_23875;
var max_sid = inst_23877;
var min_sid = inst_23878;
var flakes = inst_23893;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_23895 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_23894);
var inst_23896 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_23897 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23895,inst_23896);
var inst_23898 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_23899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23900 = [inst_23841];
var inst_23901 = (new cljs.core.PersistentVector(null,1,(5),inst_23899,inst_23900,null));
var inst_23902 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23897,inst_23893);
var inst_23903 = cljs.core.PersistentHashMap.EMPTY;
var inst_23904 = [inst_23901,inst_23902,inst_23903];
var inst_23905 = cljs.core.PersistentHashMap.fromArrays(inst_23898,inst_23904);
var state_23946__$1 = state_23946;
var statearr_23949_23994 = state_23946__$1;
(statearr_23949_23994[(2)] = inst_23905);

(statearr_23949_23994[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (27))){
var inst_23843 = (state_23946[(9)]);
var inst_23919 = (state_23946[(2)]);
var inst_23920 = fluree.db.flake.sid__GT_cid(inst_23919);
var inst_23921 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_23920);
var inst_23922 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_23923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23924 = [inst_23843];
var inst_23925 = (new cljs.core.PersistentVector(null,1,(5),inst_23923,inst_23924,null));
var inst_23926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23928 = [inst_23921];
var inst_23929 = (new cljs.core.PersistentVector(null,1,(5),inst_23927,inst_23928,null));
var inst_23930 = [inst_23929];
var inst_23931 = (new cljs.core.PersistentVector(null,1,(5),inst_23926,inst_23930,null));
var inst_23932 = cljs.core.PersistentHashMap.EMPTY;
var inst_23933 = [inst_23925,inst_23931,inst_23932];
var inst_23934 = cljs.core.PersistentHashMap.fromArrays(inst_23922,inst_23933);
var state_23946__$1 = state_23946;
var statearr_23950_23995 = state_23946__$1;
(statearr_23950_23995[(2)] = inst_23934);

(statearr_23950_23995[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (1))){
var state_23946__$1 = state_23946;
var statearr_23951_23996 = state_23946__$1;
(statearr_23951_23996[(2)] = null);

(statearr_23951_23996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (24))){
var inst_23937 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
var statearr_23952_23997 = state_23946__$1;
(statearr_23952_23997[(2)] = inst_23937);

(statearr_23952_23997[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (4))){
var inst_23834 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
var statearr_23953_23998 = state_23946__$1;
(statearr_23953_23998[(2)] = inst_23834);

(statearr_23953_23998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (15))){
var inst_23841 = (state_23946[(7)]);
var inst_23843 = (state_23946[(9)]);
var inst_23862 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_23863 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_23864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23865 = [inst_23841];
var inst_23866 = (new cljs.core.PersistentVector(null,1,(5),inst_23864,inst_23865,null));
var inst_23867 = (function (){var subject_var = inst_23841;
var object_var = inst_23843;
var min_sid = inst_23862;
var max_sid = (0);
return (function (p1__23833_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__23833_SHARP_);
});
})();
var inst_23868 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_23862,(0));
var inst_23869 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23867,inst_23868);
var inst_23870 = cljs.core.PersistentHashMap.EMPTY;
var inst_23871 = [inst_23866,inst_23869,inst_23870];
var inst_23872 = cljs.core.PersistentHashMap.fromArrays(inst_23863,inst_23871);
var state_23946__$1 = state_23946;
var statearr_23954_23999 = state_23946__$1;
(statearr_23954_23999[(2)] = inst_23872);

(statearr_23954_23999[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (21))){
var inst_23888 = (state_23946[(2)]);
var inst_23889 = fluree.db.util.async.throw_err(inst_23888);
var state_23946__$1 = state_23946;
var statearr_23955_24000 = state_23946__$1;
(statearr_23955_24000[(2)] = inst_23889);

(statearr_23955_24000[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (13))){
var inst_23843 = (state_23946[(9)]);
var state_23946__$1 = state_23946;
if(cljs.core.truth_(inst_23843)){
var statearr_23956_24001 = state_23946__$1;
(statearr_23956_24001[(1)] = (22));

} else {
var statearr_23957_24002 = state_23946__$1;
(statearr_23957_24002[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (22))){
var inst_23910 = (state_23946[(12)]);
var inst_23910__$1 = cljs.core.first(clause);
var inst_23911 = typeof inst_23910__$1 === 'number';
var state_23946__$1 = (function (){var statearr_23958 = state_23946;
(statearr_23958[(12)] = inst_23910__$1);

return statearr_23958;
})();
if(cljs.core.truth_(inst_23911)){
var statearr_23959_24003 = state_23946__$1;
(statearr_23959_24003[(1)] = (25));

} else {
var statearr_23960_24004 = state_23946__$1;
(statearr_23960_24004[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (6))){
var inst_23843 = (state_23946[(9)]);
var state_23946__$1 = state_23946;
var statearr_23961_24005 = state_23946__$1;
(statearr_23961_24005[(2)] = inst_23843);

(statearr_23961_24005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (28))){
var inst_23916 = (state_23946[(2)]);
var inst_23917 = fluree.db.util.async.throw_err(inst_23916);
var state_23946__$1 = state_23946;
var statearr_23962_24006 = state_23946__$1;
(statearr_23962_24006[(2)] = inst_23917);

(statearr_23962_24006[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (25))){
var inst_23910 = (state_23946[(12)]);
var state_23946__$1 = state_23946;
var statearr_23963_24007 = state_23946__$1;
(statearr_23963_24007[(2)] = inst_23910);

(statearr_23963_24007[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (17))){
var inst_23907 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
var statearr_23964_24008 = state_23946__$1;
(statearr_23964_24008[(2)] = inst_23907);

(statearr_23964_24008[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (3))){
var inst_23944 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23946__$1,inst_23944);
} else {
if((state_val_23947 === (12))){
var inst_23856 = ["_tx",null,"_block",null];
var inst_23857 = (new cljs.core.PersistentArrayMap(null,2,inst_23856,null));
var inst_23858 = (new cljs.core.PersistentHashSet(null,inst_23857,null));
var inst_23859 = cljs.core.last(clause);
var inst_23860 = (inst_23858.cljs$core$IFn$_invoke$arity$1 ? inst_23858.cljs$core$IFn$_invoke$arity$1(inst_23859) : inst_23858.call(null,inst_23859));
var state_23946__$1 = state_23946;
if(cljs.core.truth_(inst_23860)){
var statearr_23965_24009 = state_23946__$1;
(statearr_23965_24009[(1)] = (15));

} else {
var statearr_23966_24010 = state_23946__$1;
(statearr_23966_24010[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (2))){
var inst_23841 = (state_23946[(7)]);
var _ = (function (){var statearr_23967 = state_23946;
(statearr_23967[(4)] = cljs.core.cons((5),(state_23946[(4)])));

return statearr_23967;
})();
var inst_23840 = cljs.core.first(clause);
var inst_23841__$1 = fluree.db.query.analytical.variable_QMARK_(inst_23840);
var inst_23842 = cljs.core.last(clause);
var inst_23843 = fluree.db.query.analytical.variable_QMARK_(inst_23842);
var state_23946__$1 = (function (){var statearr_23968 = state_23946;
(statearr_23968[(7)] = inst_23841__$1);

(statearr_23968[(9)] = inst_23843);

return statearr_23968;
})();
if(cljs.core.truth_(inst_23841__$1)){
var statearr_23969_24011 = state_23946__$1;
(statearr_23969_24011[(1)] = (6));

} else {
var statearr_23970_24012 = state_23946__$1;
(statearr_23970_24012[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (23))){
var state_23946__$1 = state_23946;
var statearr_23971_24013 = state_23946__$1;
(statearr_23971_24013[(2)] = null);

(statearr_23971_24013[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (19))){
var inst_23891 = cljs.core.PersistentVector.EMPTY;
var state_23946__$1 = state_23946;
var statearr_23972_24014 = state_23946__$1;
(statearr_23972_24014[(2)] = inst_23891);

(statearr_23972_24014[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (11))){
var inst_23941 = (state_23946[(2)]);
var _ = (function (){var statearr_23974 = state_23946;
(statearr_23974[(4)] = cljs.core.rest((state_23946[(4)])));

return statearr_23974;
})();
var state_23946__$1 = state_23946;
var statearr_23975_24015 = state_23946__$1;
(statearr_23975_24015[(2)] = inst_23941);

(statearr_23975_24015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (9))){
var inst_23849 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23850 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23851 = cljs.core.PersistentHashMap.fromArrays(inst_23849,inst_23850);
var inst_23852 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_23851);
var inst_23853 = (function(){throw inst_23852})();
var state_23946__$1 = state_23946;
var statearr_23976_24016 = state_23946__$1;
(statearr_23976_24016[(2)] = inst_23853);

(statearr_23976_24016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (5))){
var _ = (function (){var statearr_23977 = state_23946;
(statearr_23977[(4)] = cljs.core.rest((state_23946[(4)])));

return statearr_23977;
})();
var state_23946__$1 = state_23946;
var ex23973 = (state_23946__$1[(2)]);
var statearr_23978_24017 = state_23946__$1;
(statearr_23978_24017[(5)] = ex23973);


if((ex23973 instanceof Error)){
var statearr_23979_24018 = state_23946__$1;
(statearr_23979_24018[(1)] = (4));

(statearr_23979_24018[(5)] = null);

} else {
throw ex23973;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (14))){
var inst_23939 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
var statearr_23980_24019 = state_23946__$1;
(statearr_23980_24019[(2)] = inst_23939);

(statearr_23980_24019[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (26))){
var inst_23910 = (state_23946[(12)]);
var inst_23914 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23910);
var state_23946__$1 = state_23946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23946__$1,(28),inst_23914);
} else {
if((state_val_23947 === (16))){
var inst_23877 = (state_23946[(8)]);
var inst_23875 = (state_23946[(11)]);
var inst_23874 = cljs.core.last(clause);
var inst_23875__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_23874);
var inst_23876 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_23877__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23876,inst_23875__$1);
var inst_23878 = fluree.db.flake.min_subject_id(inst_23875__$1);
var state_23946__$1 = (function (){var statearr_23981 = state_23946;
(statearr_23981[(8)] = inst_23877__$1);

(statearr_23981[(10)] = inst_23878);

(statearr_23981[(11)] = inst_23875__$1);

return statearr_23981;
})();
if(cljs.core.truth_(inst_23877__$1)){
var statearr_23982_24020 = state_23946__$1;
(statearr_23982_24020[(1)] = (18));

} else {
var statearr_23983_24021 = state_23946__$1;
(statearr_23983_24021[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (10))){
var inst_23841 = (state_23946[(7)]);
var state_23946__$1 = state_23946;
if(cljs.core.truth_(inst_23841)){
var statearr_23984_24022 = state_23946__$1;
(statearr_23984_24022[(1)] = (12));

} else {
var statearr_23985_24023 = state_23946__$1;
(statearr_23985_24023[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (18))){
var inst_23877 = (state_23946[(8)]);
var inst_23878 = (state_23946[(10)]);
var inst_23880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23881 = [inst_23877];
var inst_23882 = (new cljs.core.PersistentVector(null,1,(5),inst_23880,inst_23881,null));
var inst_23883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23884 = [inst_23878];
var inst_23885 = (new cljs.core.PersistentVector(null,1,(5),inst_23883,inst_23884,null));
var inst_23886 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_23882,cljs.core._LT__EQ_,inst_23885);
var state_23946__$1 = state_23946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23946__$1,(21),inst_23886);
} else {
if((state_val_23947 === (8))){
var inst_23847 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
if(cljs.core.truth_(inst_23847)){
var statearr_23986_24024 = state_23946__$1;
(statearr_23986_24024[(1)] = (9));

} else {
var statearr_23987_24025 = state_23946__$1;
(statearr_23987_24025[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_23988 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23988[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__);

(statearr_23988[(1)] = (1));

return statearr_23988;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1 = (function (state_23946){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23946);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23989){var ex__2687__auto__ = e23989;
var statearr_23990_24026 = state_23946;
(statearr_23990_24026[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23946[(4)]))){
var statearr_23991_24027 = state_23946;
(statearr_23991_24027[(1)] = cljs.core.first((state_23946[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24028 = state_23946;
state_23946 = G__24028;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__ = function(state_23946){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1.call(this,state_23946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23992 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23992[(6)] = c__2706__auto__);

return statearr_23992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__24035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__24035 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__24035;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__24036(s__24037){
return (new cljs.core.LazySeq(null,(function (){
var s__24037__$1 = s__24037;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__24037__$1);
if(temp__5804__auto__){
var s__24037__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__24037__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__24037__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__24039 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__24038 = (0);
while(true){
if((i__24038 < size__5522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__24038);
var delta = (x - mean);
cljs.core.chunk_append(b__24039,(delta * delta));

var G__24041 = (i__24038 + (1));
i__24038 = G__24041;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__24039),fluree$db$query$analytical$variance_$_iter__24036(cljs.core.chunk_rest(s__24037__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__24039),null);
}
} else {
var x = cljs.core.first(s__24037__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__24036(cljs.core.rest(s__24037__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__24040 = variance(coll);
return Math.sqrt(G__24040);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__24042 = null;
var G__24042__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__24042__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__24042 = function(n,coll){
switch(arguments.length){
case 1:
return G__24042__1.call(this,n);
case 2:
return G__24042__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24042.cljs$core$IFn$_invoke$arity$1 = G__24042__1;
G__24042.cljs$core$IFn$_invoke$arity$2 = G__24042__2;
return G__24042;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__24043 = null;
var G__24043__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__24043__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__24043 = function(n,coll){
switch(arguments.length){
case 1:
return G__24043__1.call(this,n);
case 2:
return G__24043__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24043.cljs$core$IFn$_invoke$arity$1 = G__24043__1;
G__24043.cljs$core$IFn$_invoke$arity$2 = G__24043__2;
return G__24043;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__24044 = null;
var G__24044__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__24044__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__24044 = function(n,coll){
switch(arguments.length){
case 1:
return G__24044__1.call(this,n);
case 2:
return G__24044__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24044.cljs$core$IFn$_invoke$arity$1 = G__24044__1;
G__24044.cljs$core$IFn$_invoke$arity$2 = G__24044__2;
return G__24044;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count(parsed_code);
var vec__24045 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parsed_code),cljs.core.second(parsed_code),cljs.core.last(parsed_code)], null):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(parsed_code)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parsed_code),null,cljs.core.last(parsed_code)], null)):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24045,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24045,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24045,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__24048 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__24051 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__24051) : agg_fn.call(null,G__24051));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24048,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24048,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0)),")"].join('');
if(cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(code_str);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_(code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__24052 = aggregate_fn_map;
var map__24052__$1 = cljs.core.__destructure_map(map__24052);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24052__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24052__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24052__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(agg_params) : function$.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__24054 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24054,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24054,(1),null);
var map__24057 = res__$1;
var map__24057__$1 = cljs.core.__destructure_map(map__24057);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24057__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24057__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24053_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__24053_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24058_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__24058_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24059_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__24059_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__24060_SHARP_,p2__24061_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__24060_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__24061_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24062_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__24062_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__24065,row,b_tuple){
var vec__24066 = p__24065;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24066,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24066,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24063_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__24063_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24064_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__24064_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24069_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__24069_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24070_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__24070_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__24075 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__24077 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__24076 = (function (p1__24071_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__24071_SHARP_);
});
return fexpr__24076(G__24077);
})()),cljs.core.set(b_idxs));
var fexpr__24074 = (function (p1__24072_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__24072_SHARP_);
});
return fexpr__24074(G__24075);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24073_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__24073_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24078_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__24078_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24079_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__24079_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__24084 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__24086 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__24085 = (function (p1__24080_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__24080_SHARP_);
});
return fexpr__24085(G__24086);
})()),cljs.core.set(b_idxs));
var fexpr__24083 = (function (p1__24081_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__24081_SHARP_);
});
return fexpr__24083(G__24084);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24082_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__24082_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__24088 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24088,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24088,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__24087_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__24087_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var vec__24093 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24093,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24093,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24091_SHARP_){
return fluree.db.util.core.index_of(headers,p1__24091_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__24092_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__24092_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__24096,filters,optional_QMARK_){
var map__24097 = p__24096;
var map__24097__$1 = cljs.core.__destructure_map(map__24097);
var tuple_map = map__24097__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24097__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24097__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24097__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__24098 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24098,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24098,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__24101 = res;
var map__24101__$1 = cljs.core.__destructure_map(map__24101);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24101__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24101__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24157){
var state_val_24158 = (state_24157[(1)]);
if((state_val_24158 === (7))){
var inst_24131 = (state_24157[(7)]);
var inst_24129 = (state_24157[(2)]);
var inst_24130 = fluree.db.util.async.throw_err(inst_24129);
var inst_24131__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24130,(0),null);
var inst_24132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24130,(1),null);
var inst_24133 = (inst_24131__$1 == null);
var state_24157__$1 = (function (){var statearr_24159 = state_24157;
(statearr_24159[(7)] = inst_24131__$1);

(statearr_24159[(8)] = inst_24132);

return statearr_24159;
})();
if(cljs.core.truth_(inst_24133)){
var statearr_24160_24189 = state_24157__$1;
(statearr_24160_24189[(1)] = (8));

} else {
var statearr_24161_24190 = state_24157__$1;
(statearr_24161_24190[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (1))){
var inst_24109 = optional_clauses;
var inst_24110 = cljs.core.seq(inst_24109);
var inst_24111 = cljs.core.first(inst_24110);
var inst_24112 = cljs.core.next(inst_24110);
var inst_24113 = where_tuples;
var inst_24114 = inst_24109;
var inst_24115 = inst_24113;
var state_24157__$1 = (function (){var statearr_24162 = state_24157;
(statearr_24162[(9)] = inst_24114);

(statearr_24162[(10)] = inst_24111);

(statearr_24162[(11)] = inst_24115);

(statearr_24162[(12)] = inst_24112);

return statearr_24162;
})();
var statearr_24163_24191 = state_24157__$1;
(statearr_24163_24191[(2)] = null);

(statearr_24163_24191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (4))){
var inst_24121 = (state_24157[(13)]);
var inst_24122 = (state_24157[(14)]);
var inst_24115 = (state_24157[(11)]);
var inst_24127 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_24115,inst_24121,inst_24122,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_24115,inst_24121,inst_24122,true,fuel,max_fuel,opts));
var state_24157__$1 = state_24157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24157__$1,(7),inst_24127);
} else {
if((state_val_24158 === (15))){
var state_24157__$1 = state_24157;
var statearr_24164_24192 = state_24157__$1;
(statearr_24164_24192[(2)] = null);

(statearr_24164_24192[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (13))){
var inst_24148 = (state_24157[(2)]);
var state_24157__$1 = state_24157;
var statearr_24165_24193 = state_24157__$1;
(statearr_24165_24193[(2)] = inst_24148);

(statearr_24165_24193[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (6))){
var inst_24153 = (state_24157[(2)]);
var state_24157__$1 = state_24157;
var statearr_24166_24194 = state_24157__$1;
(statearr_24166_24194[(2)] = inst_24153);

(statearr_24166_24194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (3))){
var inst_24155 = (state_24157[(2)]);
var state_24157__$1 = state_24157;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24157__$1,inst_24155);
} else {
if((state_val_24158 === (12))){
var state_24157__$1 = state_24157;
var statearr_24167_24195 = state_24157__$1;
(statearr_24167_24195[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (2))){
var inst_24114 = (state_24157[(9)]);
var inst_24121 = (state_24157[(13)]);
var inst_24120 = cljs.core.seq(inst_24114);
var inst_24121__$1 = cljs.core.first(inst_24120);
var inst_24122 = cljs.core.next(inst_24120);
var state_24157__$1 = (function (){var statearr_24169 = state_24157;
(statearr_24169[(13)] = inst_24121__$1);

(statearr_24169[(14)] = inst_24122);

return statearr_24169;
})();
if(cljs.core.truth_(inst_24121__$1)){
var statearr_24170_24196 = state_24157__$1;
(statearr_24170_24196[(1)] = (4));

} else {
var statearr_24171_24197 = state_24157__$1;
(statearr_24171_24197[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (11))){
var inst_24131 = (state_24157[(7)]);
var inst_24132 = (state_24157[(8)]);
var inst_24114 = inst_24132;
var inst_24115 = inst_24131;
var state_24157__$1 = (function (){var statearr_24172 = state_24157;
(statearr_24172[(9)] = inst_24114);

(statearr_24172[(11)] = inst_24115);

return statearr_24172;
})();
var statearr_24173_24198 = state_24157__$1;
(statearr_24173_24198[(2)] = null);

(statearr_24173_24198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (9))){
var inst_24121 = (state_24157[(13)]);
var inst_24137 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_24121);
var state_24157__$1 = state_24157;
if(cljs.core.truth_(inst_24137)){
var statearr_24174_24199 = state_24157__$1;
(statearr_24174_24199[(1)] = (11));

} else {
var statearr_24175_24200 = state_24157__$1;
(statearr_24175_24200[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (5))){
var inst_24115 = (state_24157[(11)]);
var state_24157__$1 = state_24157;
var statearr_24176_24201 = state_24157__$1;
(statearr_24176_24201[(2)] = inst_24115);

(statearr_24176_24201[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (14))){
var inst_24131 = (state_24157[(7)]);
var inst_24115 = (state_24157[(11)]);
var inst_24132 = (state_24157[(8)]);
var inst_24142 = fluree.db.query.analytical.left_outer_join(inst_24115,inst_24131);
var inst_24114 = inst_24132;
var inst_24115__$1 = inst_24142;
var state_24157__$1 = (function (){var statearr_24177 = state_24157;
(statearr_24177[(9)] = inst_24114);

(statearr_24177[(11)] = inst_24115__$1);

return statearr_24177;
})();
var statearr_24178_24202 = state_24157__$1;
(statearr_24178_24202[(2)] = null);

(statearr_24178_24202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (16))){
var inst_24146 = (state_24157[(2)]);
var state_24157__$1 = state_24157;
var statearr_24180_24203 = state_24157__$1;
(statearr_24180_24203[(2)] = inst_24146);

(statearr_24180_24203[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (10))){
var inst_24150 = (state_24157[(2)]);
var state_24157__$1 = state_24157;
var statearr_24181_24204 = state_24157__$1;
(statearr_24181_24204[(2)] = inst_24150);

(statearr_24181_24204[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24158 === (8))){
var inst_24115 = (state_24157[(11)]);
var inst_24132 = (state_24157[(8)]);
var tmp24179 = inst_24115;
var inst_24114 = inst_24132;
var inst_24115__$1 = tmp24179;
var state_24157__$1 = (function (){var statearr_24182 = state_24157;
(statearr_24182[(9)] = inst_24114);

(statearr_24182[(11)] = inst_24115__$1);

return statearr_24182;
})();
var statearr_24183_24205 = state_24157__$1;
(statearr_24183_24205[(2)] = null);

(statearr_24183_24205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0 = (function (){
var statearr_24184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24184[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__);

(statearr_24184[(1)] = (1));

return statearr_24184;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1 = (function (state_24157){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24157);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24185){var ex__2687__auto__ = e24185;
var statearr_24186_24206 = state_24157;
(statearr_24186_24206[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24157[(4)]))){
var statearr_24187_24207 = state_24157;
(statearr_24187_24207[(1)] = cljs.core.first((state_24157[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24208 = state_24157;
state_24157 = G__24208;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__ = function(state_24157){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1.call(this,state_24157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24188 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24188[(6)] = c__2706__auto__);

return statearr_24188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__24210){
var vec__24211 = p__24210;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24211,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24211,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24209_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__24209_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__24215,p__24216,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__24217 = p__24215;
var map__24217__$1 = cljs.core.__destructure_map(map__24217);
var q_map = map__24217__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24217__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__24218 = p__24216;
var map__24218__$1 = cljs.core.__destructure_map(map__24218);
var res = map__24218__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24218__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24455){
var state_val_24456 = (state_24455[(1)]);
if((state_val_24456 === (65))){
var inst_24404 = (state_24455[(7)]);
var inst_24405 = (state_24455[(8)]);
var inst_24416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24417 = fluree.db.query.analytical.full_text__GT_tuples(inst_24404,res,inst_24405);
var inst_24418 = [inst_24417,r];
var inst_24419 = (new cljs.core.PersistentVector(null,2,(5),inst_24416,inst_24418,null));
var state_24455__$1 = state_24455;
var statearr_24457_24570 = state_24455__$1;
(statearr_24457_24570[(2)] = inst_24419);

(statearr_24457_24570[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (70))){
var inst_24431 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24458_24571 = state_24455__$1;
(statearr_24458_24571[(2)] = inst_24431);

(statearr_24458_24571[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (62))){
var inst_24405 = (state_24455[(8)]);
var inst_24413 = cljs.core.second(inst_24405);
var inst_24414 = clojure.string.starts_with_QMARK_(inst_24413,"fullText:");
var state_24455__$1 = state_24455;
if(inst_24414){
var statearr_24459_24572 = state_24455__$1;
(statearr_24459_24572[(1)] = (65));

} else {
var statearr_24460_24573 = state_24455__$1;
(statearr_24460_24573[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (7))){
var inst_24324 = (state_24455[(9)]);
var inst_24323 = cljs.core.count(clause);
var inst_24324__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_24323);
var state_24455__$1 = (function (){var statearr_24461 = state_24455;
(statearr_24461[(9)] = inst_24324__$1);

return statearr_24461;
})();
if(inst_24324__$1){
var statearr_24462_24574 = state_24455__$1;
(statearr_24462_24574[(1)] = (31));

} else {
var statearr_24463_24575 = state_24455__$1;
(statearr_24463_24575[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (59))){
var inst_24438 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24464_24576 = state_24455__$1;
(statearr_24464_24576[(2)] = inst_24438);

(statearr_24464_24576[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (20))){
var inst_24287 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24465_24577 = state_24455__$1;
(statearr_24465_24577[(2)] = inst_24287);

(statearr_24465_24577[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (58))){
var state_24455__$1 = state_24455;
var statearr_24466_24578 = state_24455__$1;
(statearr_24466_24578[(2)] = null);

(statearr_24466_24578[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (60))){
var inst_24404 = (state_24455[(7)]);
var inst_24402 = (state_24455[(2)]);
var inst_24403 = fluree.db.util.async.throw_err(inst_24402);
var inst_24404__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24403,(0),null);
var inst_24405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24403,(1),null);
var inst_24406 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_24404__$1);
var state_24455__$1 = (function (){var statearr_24467 = state_24455;
(statearr_24467[(7)] = inst_24404__$1);

(statearr_24467[(8)] = inst_24405);

return statearr_24467;
})();
if(inst_24406){
var statearr_24468_24579 = state_24455__$1;
(statearr_24468_24579[(1)] = (61));

} else {
var statearr_24469_24580 = state_24455__$1;
(statearr_24469_24580[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (27))){
var inst_24317 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24470_24581 = state_24455__$1;
(statearr_24470_24581[(2)] = inst_24317);

(statearr_24470_24581[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (1))){
var state_24455__$1 = state_24455;
var statearr_24471_24582 = state_24455__$1;
(statearr_24471_24582[(2)] = null);

(statearr_24471_24582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (69))){
var state_24455__$1 = state_24455;
var statearr_24472_24583 = state_24455__$1;
(statearr_24472_24583[(2)] = null);

(statearr_24472_24583[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (24))){
var inst_24281 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24473_24584 = state_24455__$1;
(statearr_24473_24584[(2)] = inst_24281);

(statearr_24473_24584[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (55))){
var inst_24387 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_24388 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24389 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24390 = cljs.core.PersistentHashMap.fromArrays(inst_24388,inst_24389);
var inst_24391 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24387,inst_24390);
var inst_24392 = (function(){throw inst_24391})();
var state_24455__$1 = state_24455;
var statearr_24474_24585 = state_24455__$1;
(statearr_24474_24585[(2)] = inst_24392);

(statearr_24474_24585[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (39))){
var inst_24344 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
if(cljs.core.truth_(inst_24344)){
var statearr_24475_24586 = state_24455__$1;
(statearr_24475_24586[(1)] = (40));

} else {
var statearr_24476_24587 = state_24455__$1;
(statearr_24476_24587[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (46))){
var inst_24444 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24477_24588 = state_24455__$1;
(statearr_24477_24588[(2)] = inst_24444);

(statearr_24477_24588[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (4))){
var inst_24219 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24478_24589 = state_24455__$1;
(statearr_24478_24589[(2)] = inst_24219);

(statearr_24478_24589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (54))){
var inst_24380 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_24381 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24382 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24383 = cljs.core.PersistentHashMap.fromArrays(inst_24381,inst_24382);
var inst_24384 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24380,inst_24383);
var inst_24385 = (function(){throw inst_24384})();
var state_24455__$1 = state_24455;
var statearr_24479_24590 = state_24455__$1;
(statearr_24479_24590[(2)] = inst_24385);

(statearr_24479_24590[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (15))){
var inst_24319 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24480_24591 = state_24455__$1;
(statearr_24480_24591[(2)] = inst_24319);

(statearr_24480_24591[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (48))){
var inst_24368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24369 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_24370 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_24369);
var inst_24371 = [inst_24370,r];
var inst_24372 = (new cljs.core.PersistentVector(null,2,(5),inst_24368,inst_24371,null));
var state_24455__$1 = state_24455;
var statearr_24481_24592 = state_24455__$1;
(statearr_24481_24592[(2)] = inst_24372);

(statearr_24481_24592[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (50))){
var inst_24442 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24482_24593 = state_24455__$1;
(statearr_24482_24593[(2)] = inst_24442);

(statearr_24482_24593[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (21))){
var inst_24264 = (state_24455[(10)]);
var inst_24232 = (state_24455[(11)]);
var inst_24255 = (state_24455[(12)]);
var inst_24228 = (state_24455[(13)]);
var inst_24265 = (state_24455[(14)]);
var inst_24253 = (state_24455[(15)]);
var inst_24258 = (state_24455[(16)]);
var inst_24257 = (state_24455[(17)]);
var inst_24256 = (state_24455[(18)]);
var inst_24269 = (state_24455[(2)]);
var inst_24270 = fluree.db.util.async.throw_err(inst_24269);
var inst_24271 = (function (){var seq__24261 = inst_24265;
var new_res = inst_24270;
var rest = inst_24265;
var seq__24251 = inst_24256;
var tuples = inst_24258;
var vec__24250 = inst_24253;
var G__24249 = inst_24257;
var pred__24229 = inst_24232;
var first__24262 = inst_24264;
var first__24252 = inst_24255;
var vec__24260 = inst_24257;
var segment_type = inst_24228;
var clause_group = inst_24264;
var expr__24230 = inst_24228;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_24272 = cljs.core.keys(vars);
var inst_24273 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_24271,inst_24270,inst_24272);
var inst_24274 = fluree.db.query.analytical.res_absorb_vars(inst_24273);
var state_24455__$1 = (function (){var statearr_24483 = state_24455;
(statearr_24483[(19)] = inst_24274);

return statearr_24483;
})();
if(cljs.core.truth_(inst_24258)){
var statearr_24484_24594 = state_24455__$1;
(statearr_24484_24594[(1)] = (22));

} else {
var statearr_24485_24595 = state_24455__$1;
(statearr_24485_24595[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (31))){
var inst_24326 = cljs.core.second(clause);
var inst_24327 = clojure.string.starts_with_QMARK_(inst_24326,"fullText:");
var state_24455__$1 = state_24455;
var statearr_24486_24596 = state_24455__$1;
(statearr_24486_24596[(2)] = inst_24327);

(statearr_24486_24596[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (32))){
var inst_24324 = (state_24455[(9)]);
var state_24455__$1 = state_24455;
var statearr_24487_24597 = state_24455__$1;
(statearr_24487_24597[(2)] = inst_24324);

(statearr_24487_24597[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (40))){
var inst_24346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24347 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_24455__$1 = (function (){var statearr_24488 = state_24455;
(statearr_24488[(20)] = inst_24346);

return statearr_24488;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24455__$1,(43),inst_24347);
} else {
if((state_val_24456 === (56))){
var inst_24394 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24489_24598 = state_24455__$1;
(statearr_24489_24598[(2)] = inst_24394);

(statearr_24489_24598[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (33))){
var inst_24330 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
if(cljs.core.truth_(inst_24330)){
var statearr_24490_24599 = state_24455__$1;
(statearr_24490_24599[(1)] = (34));

} else {
var statearr_24491_24600 = state_24455__$1;
(statearr_24491_24600[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (13))){
var inst_24253 = (state_24455[(15)]);
var inst_24253__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_24254 = cljs.core.seq(inst_24253__$1);
var inst_24255 = cljs.core.first(inst_24254);
var inst_24256 = cljs.core.next(inst_24254);
var inst_24257 = inst_24253__$1;
var inst_24258 = null;
var state_24455__$1 = (function (){var statearr_24492 = state_24455;
(statearr_24492[(12)] = inst_24255);

(statearr_24492[(15)] = inst_24253__$1);

(statearr_24492[(16)] = inst_24258);

(statearr_24492[(17)] = inst_24257);

(statearr_24492[(18)] = inst_24256);

return statearr_24492;
})();
var statearr_24493_24601 = state_24455__$1;
(statearr_24493_24601[(2)] = null);

(statearr_24493_24601[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (22))){
var inst_24274 = (state_24455[(19)]);
var inst_24265 = (state_24455[(14)]);
var inst_24258 = (state_24455[(16)]);
var inst_24276 = fluree.db.query.union.results(inst_24258,inst_24274);
var inst_24257 = inst_24265;
var inst_24258__$1 = inst_24276;
var state_24455__$1 = (function (){var statearr_24494 = state_24455;
(statearr_24494[(16)] = inst_24258__$1);

(statearr_24494[(17)] = inst_24257);

return statearr_24494;
})();
var statearr_24495_24602 = state_24455__$1;
(statearr_24495_24602[(2)] = null);

(statearr_24495_24602[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (36))){
var inst_24448 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24496_24603 = state_24455__$1;
(statearr_24496_24603[(2)] = inst_24448);

(statearr_24496_24603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (41))){
var inst_24354 = cljs.core.count(clause);
var inst_24355 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_24354);
var state_24455__$1 = state_24455;
if(inst_24355){
var statearr_24497_24604 = state_24455__$1;
(statearr_24497_24604[(1)] = (44));

} else {
var statearr_24498_24605 = state_24455__$1;
(statearr_24498_24605[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (43))){
var inst_24346 = (state_24455[(20)]);
var inst_24349 = (state_24455[(2)]);
var inst_24350 = fluree.db.util.async.throw_err(inst_24349);
var inst_24351 = [inst_24350,r];
var inst_24352 = (new cljs.core.PersistentVector(null,2,(5),inst_24346,inst_24351,null));
var state_24455__$1 = state_24455;
var statearr_24499_24606 = state_24455__$1;
(statearr_24499_24606[(2)] = inst_24352);

(statearr_24499_24606[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (61))){
var inst_24405 = (state_24455[(8)]);
var inst_24408 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_24405,r,res,optional_QMARK_,fuel,max_fuel);
var state_24455__$1 = state_24455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24455__$1,(64),inst_24408);
} else {
if((state_val_24456 === (29))){
var inst_24228 = (state_24455[(13)]);
var inst_24311 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24228)].join('');
var inst_24312 = (new Error(inst_24311));
var inst_24313 = (function(){throw inst_24312})();
var state_24455__$1 = state_24455;
var statearr_24500_24607 = state_24455__$1;
(statearr_24500_24607[(2)] = inst_24313);

(statearr_24500_24607[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (44))){
var inst_24357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24358 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel,opts);
var state_24455__$1 = (function (){var statearr_24501 = state_24455;
(statearr_24501[(21)] = inst_24357);

return statearr_24501;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24455__$1,(47),inst_24358);
} else {
if((state_val_24456 === (6))){
var inst_24232 = (state_24455[(11)]);
var inst_24228 = (state_24455[(13)]);
var inst_24227 = cljs.core.keys(clause);
var inst_24228__$1 = cljs.core.first(inst_24227);
var inst_24232__$1 = cljs.core._EQ_;
var inst_24233 = (function (){var G__24502 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__24503 = inst_24228__$1;
return (inst_24232__$1.cljs$core$IFn$_invoke$arity$2 ? inst_24232__$1.cljs$core$IFn$_invoke$arity$2(G__24502,G__24503) : inst_24232__$1.call(null,G__24502,G__24503));
})();
var state_24455__$1 = (function (){var statearr_24504 = state_24455;
(statearr_24504[(11)] = inst_24232__$1);

(statearr_24504[(13)] = inst_24228__$1);

return statearr_24504;
})();
if(cljs.core.truth_(inst_24233)){
var statearr_24505_24608 = state_24455__$1;
(statearr_24505_24608[(1)] = (9));

} else {
var statearr_24506_24609 = state_24455__$1;
(statearr_24506_24609[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (28))){
var inst_24305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24306 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_24307 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_24306,optional_QMARK_);
var inst_24308 = [inst_24307,r];
var inst_24309 = (new cljs.core.PersistentVector(null,2,(5),inst_24305,inst_24308,null));
var state_24455__$1 = state_24455;
var statearr_24507_24610 = state_24455__$1;
(statearr_24507_24610[(2)] = inst_24309);

(statearr_24507_24610[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (64))){
var inst_24410 = (state_24455[(2)]);
var inst_24411 = fluree.db.util.async.throw_err(inst_24410);
var state_24455__$1 = state_24455;
var statearr_24508_24611 = state_24455__$1;
(statearr_24508_24611[(2)] = inst_24411);

(statearr_24508_24611[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (51))){
var inst_24377 = cljs.core.first(clause);
var inst_24378 = cljs.core.sequential_QMARK_(inst_24377);
var state_24455__$1 = state_24455;
if(inst_24378){
var statearr_24509_24612 = state_24455__$1;
(statearr_24509_24612[(1)] = (54));

} else {
var statearr_24510_24613 = state_24455__$1;
(statearr_24510_24613[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (25))){
var inst_24232 = (state_24455[(11)]);
var inst_24228 = (state_24455[(13)]);
var inst_24293 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_24294 = (function (){var segment_type = inst_24228;
var pred__24229 = inst_24232;
var expr__24230 = inst_24228;
var bindings = inst_24293;
return (function (p1__24214_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__24214_SHARP_);
});
})();
var inst_24295 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24294,inst_24293);
var inst_24296 = cljs.core.PersistentHashMap.EMPTY;
var inst_24297 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24296,inst_24295);
var inst_24298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24299 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_24297);
var inst_24300 = [inst_24299,r];
var inst_24301 = (new cljs.core.PersistentVector(null,2,(5),inst_24298,inst_24300,null));
var state_24455__$1 = state_24455;
var statearr_24511_24614 = state_24455__$1;
(statearr_24511_24614[(2)] = inst_24301);

(statearr_24511_24614[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (34))){
var inst_24332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24333 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_24334 = [inst_24333,r];
var inst_24335 = (new cljs.core.PersistentVector(null,2,(5),inst_24332,inst_24334,null));
var state_24455__$1 = state_24455;
var statearr_24512_24615 = state_24455__$1;
(statearr_24512_24615[(2)] = inst_24335);

(statearr_24512_24615[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (17))){
var inst_24289 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24513_24616 = state_24455__$1;
(statearr_24513_24616[(2)] = inst_24289);

(statearr_24513_24616[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (3))){
var inst_24453 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24455__$1,inst_24453);
} else {
if((state_val_24456 === (12))){
var inst_24235 = (state_24455[(22)]);
var inst_24239 = (state_24455[(2)]);
var inst_24240 = fluree.db.util.async.throw_err(inst_24239);
var inst_24241 = [inst_24240,r];
var inst_24242 = (new cljs.core.PersistentVector(null,2,(5),inst_24235,inst_24241,null));
var state_24455__$1 = state_24455;
var statearr_24514_24617 = state_24455__$1;
(statearr_24514_24617[(2)] = inst_24242);

(statearr_24514_24617[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (2))){
var _ = (function (){var statearr_24515 = state_24455;
(statearr_24515[(4)] = cljs.core.cons((5),(state_24455[(4)])));

return statearr_24515;
})();
var inst_24225 = cljs.core.map_QMARK_(clause);
var state_24455__$1 = state_24455;
if(inst_24225){
var statearr_24516_24618 = state_24455__$1;
(statearr_24516_24618[(1)] = (6));

} else {
var statearr_24517_24619 = state_24455__$1;
(statearr_24517_24619[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (66))){
var state_24455__$1 = state_24455;
var statearr_24518_24620 = state_24455__$1;
(statearr_24518_24620[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (23))){
var inst_24274 = (state_24455[(19)]);
var inst_24265 = (state_24455[(14)]);
var inst_24257 = inst_24265;
var inst_24258 = inst_24274;
var state_24455__$1 = (function (){var statearr_24520 = state_24455;
(statearr_24520[(16)] = inst_24258);

(statearr_24520[(17)] = inst_24257);

return statearr_24520;
})();
var statearr_24521_24621 = state_24455__$1;
(statearr_24521_24621[(2)] = null);

(statearr_24521_24621[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (47))){
var inst_24357 = (state_24455[(21)]);
var inst_24360 = (state_24455[(2)]);
var inst_24361 = fluree.db.util.async.throw_err(inst_24360);
var inst_24362 = [inst_24361,r];
var inst_24363 = (new cljs.core.PersistentVector(null,2,(5),inst_24357,inst_24362,null));
var state_24455__$1 = state_24455;
var statearr_24522_24622 = state_24455__$1;
(statearr_24522_24622[(2)] = inst_24363);

(statearr_24522_24622[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (35))){
var inst_24338 = (state_24455[(23)]);
var inst_24337 = cljs.core.count(clause);
var inst_24338__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_24337);
var state_24455__$1 = (function (){var statearr_24523 = state_24455;
(statearr_24523[(23)] = inst_24338__$1);

return statearr_24523;
})();
if(inst_24338__$1){
var statearr_24524_24623 = state_24455__$1;
(statearr_24524_24623[(1)] = (37));

} else {
var statearr_24525_24624 = state_24455__$1;
(statearr_24525_24624[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (19))){
var inst_24258 = (state_24455[(16)]);
var inst_24283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24284 = [inst_24258,r];
var inst_24285 = (new cljs.core.PersistentVector(null,2,(5),inst_24283,inst_24284,null));
var state_24455__$1 = state_24455;
var statearr_24526_24625 = state_24455__$1;
(statearr_24526_24625[(2)] = inst_24285);

(statearr_24526_24625[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (57))){
var inst_24400 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_24455__$1 = state_24455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24455__$1,(60),inst_24400);
} else {
if((state_val_24456 === (68))){
var inst_24404 = (state_24455[(7)]);
var inst_24405 = (state_24455[(8)]);
var inst_24422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24423 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_24404,res,inst_24405,fuel,max_fuel,opts);
var state_24455__$1 = (function (){var statearr_24527 = state_24455;
(statearr_24527[(24)] = inst_24422);

return statearr_24527;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24455__$1,(71),inst_24423);
} else {
if((state_val_24456 === (11))){
var inst_24321 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24529_24626 = state_24455__$1;
(statearr_24529_24626[(2)] = inst_24321);

(statearr_24529_24626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (9))){
var inst_24235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24236 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_24237 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_24236,res,fuel,max_fuel,opts);
var state_24455__$1 = (function (){var statearr_24530 = state_24455;
(statearr_24530[(22)] = inst_24235);

return statearr_24530;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24455__$1,(12),inst_24237);
} else {
if((state_val_24456 === (5))){
var _ = (function (){var statearr_24531 = state_24455;
(statearr_24531[(4)] = cljs.core.rest((state_24455[(4)])));

return statearr_24531;
})();
var state_24455__$1 = state_24455;
var ex24528 = (state_24455__$1[(2)]);
var statearr_24532_24627 = state_24455__$1;
(statearr_24532_24627[(5)] = ex24528);


if((ex24528 instanceof Error)){
var statearr_24533_24628 = state_24455__$1;
(statearr_24533_24628[(1)] = (4));

(statearr_24533_24628[(5)] = null);

} else {
throw ex24528;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (14))){
var inst_24232 = (state_24455[(11)]);
var inst_24228 = (state_24455[(13)]);
var inst_24291 = (function (){var G__24534 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__24535 = inst_24228;
return (inst_24232.cljs$core$IFn$_invoke$arity$2 ? inst_24232.cljs$core$IFn$_invoke$arity$2(G__24534,G__24535) : inst_24232.call(null,G__24534,G__24535));
})();
var state_24455__$1 = state_24455;
if(cljs.core.truth_(inst_24291)){
var statearr_24536_24629 = state_24455__$1;
(statearr_24536_24629[(1)] = (25));

} else {
var statearr_24537_24630 = state_24455__$1;
(statearr_24537_24630[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (45))){
var inst_24365 = cljs.core.count(clause);
var inst_24366 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_24365);
var state_24455__$1 = state_24455;
if(inst_24366){
var statearr_24538_24631 = state_24455__$1;
(statearr_24538_24631[(1)] = (48));

} else {
var statearr_24539_24632 = state_24455__$1;
(statearr_24539_24632[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (53))){
var inst_24440 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24540_24633 = state_24455__$1;
(statearr_24540_24633[(2)] = inst_24440);

(statearr_24540_24633[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (26))){
var inst_24232 = (state_24455[(11)]);
var inst_24228 = (state_24455[(13)]);
var inst_24303 = (function (){var G__24541 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__24542 = inst_24228;
return (inst_24232.cljs$core$IFn$_invoke$arity$2 ? inst_24232.cljs$core$IFn$_invoke$arity$2(G__24541,G__24542) : inst_24232.call(null,G__24541,G__24542));
})();
var state_24455__$1 = state_24455;
if(cljs.core.truth_(inst_24303)){
var statearr_24543_24634 = state_24455__$1;
(statearr_24543_24634[(1)] = (28));

} else {
var statearr_24544_24635 = state_24455__$1;
(statearr_24544_24635[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (16))){
var inst_24264 = (state_24455[(10)]);
var inst_24257 = (state_24455[(17)]);
var inst_24263 = cljs.core.seq(inst_24257);
var inst_24264__$1 = cljs.core.first(inst_24263);
var inst_24265 = cljs.core.next(inst_24263);
var state_24455__$1 = (function (){var statearr_24545 = state_24455;
(statearr_24545[(10)] = inst_24264__$1);

(statearr_24545[(14)] = inst_24265);

return statearr_24545;
})();
if(cljs.core.truth_(inst_24264__$1)){
var statearr_24546_24636 = state_24455__$1;
(statearr_24546_24636[(1)] = (18));

} else {
var statearr_24547_24637 = state_24455__$1;
(statearr_24547_24637[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (38))){
var inst_24338 = (state_24455[(23)]);
var state_24455__$1 = state_24455;
var statearr_24548_24638 = state_24455__$1;
(statearr_24548_24638[(2)] = inst_24338);

(statearr_24548_24638[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (30))){
var inst_24315 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24549_24639 = state_24455__$1;
(statearr_24549_24639[(2)] = inst_24315);

(statearr_24549_24639[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (10))){
var inst_24232 = (state_24455[(11)]);
var inst_24228 = (state_24455[(13)]);
var inst_24244 = (function (){var G__24550 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__24551 = inst_24228;
return (inst_24232.cljs$core$IFn$_invoke$arity$2 ? inst_24232.cljs$core$IFn$_invoke$arity$2(G__24550,G__24551) : inst_24232.call(null,G__24550,G__24551));
})();
var state_24455__$1 = state_24455;
if(cljs.core.truth_(inst_24244)){
var statearr_24552_24640 = state_24455__$1;
(statearr_24552_24640[(1)] = (13));

} else {
var statearr_24553_24641 = state_24455__$1;
(statearr_24553_24641[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (18))){
var inst_24264 = (state_24455[(10)]);
var inst_24267 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_24264,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_24264,q_map,vars,fuel,max_fuel,opts));
var state_24455__$1 = state_24455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24455__$1,(21),inst_24267);
} else {
if((state_val_24456 === (52))){
var state_24455__$1 = state_24455;
var statearr_24554_24642 = state_24455__$1;
(statearr_24554_24642[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (67))){
var inst_24433 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24556_24643 = state_24455__$1;
(statearr_24556_24643[(2)] = inst_24433);

(statearr_24556_24643[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (71))){
var inst_24422 = (state_24455[(24)]);
var inst_24425 = (state_24455[(2)]);
var inst_24426 = fluree.db.util.async.throw_err(inst_24425);
var inst_24427 = [inst_24426,r];
var inst_24428 = (new cljs.core.PersistentVector(null,2,(5),inst_24422,inst_24427,null));
var state_24455__$1 = state_24455;
var statearr_24557_24644 = state_24455__$1;
(statearr_24557_24644[(2)] = inst_24428);

(statearr_24557_24644[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (42))){
var inst_24446 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24558_24645 = state_24455__$1;
(statearr_24558_24645[(2)] = inst_24446);

(statearr_24558_24645[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (37))){
var inst_24340 = cljs.core.second(clause);
var inst_24341 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24340,"rdf:type");
var state_24455__$1 = state_24455;
var statearr_24559_24646 = state_24455__$1;
(statearr_24559_24646[(2)] = inst_24341);

(statearr_24559_24646[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (63))){
var inst_24435 = (state_24455[(2)]);
var state_24455__$1 = state_24455;
var statearr_24560_24647 = state_24455__$1;
(statearr_24560_24647[(2)] = inst_24435);

(statearr_24560_24647[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (8))){
var inst_24450 = (state_24455[(2)]);
var _ = (function (){var statearr_24561 = state_24455;
(statearr_24561[(4)] = cljs.core.rest((state_24455[(4)])));

return statearr_24561;
})();
var state_24455__$1 = state_24455;
var statearr_24562_24648 = state_24455__$1;
(statearr_24562_24648[(2)] = inst_24450);

(statearr_24562_24648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24456 === (49))){
var inst_24374 = cljs.core.count(clause);
var inst_24375 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24374);
var state_24455__$1 = state_24455;
if(inst_24375){
var statearr_24563_24649 = state_24455__$1;
(statearr_24563_24649[(1)] = (51));

} else {
var statearr_24564_24650 = state_24455__$1;
(statearr_24564_24650[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_24565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24565[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__);

(statearr_24565[(1)] = (1));

return statearr_24565;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1 = (function (state_24455){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24455);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24566){var ex__2687__auto__ = e24566;
var statearr_24567_24651 = state_24455;
(statearr_24567_24651[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24455[(4)]))){
var statearr_24568_24652 = state_24455;
(statearr_24568_24652[(1)] = cljs.core.first((state_24455[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24653 = state_24455;
state_24455 = G__24653;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__ = function(state_24455){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1.call(this,state_24455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24569 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24569[(6)] = c__2706__auto__);

return statearr_24569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__24655 = arguments.length;
switch (G__24655) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24734){
var state_val_24735 = (state_24734[(1)]);
if((state_val_24735 === (7))){
var inst_24729 = (state_24734[(2)]);
var _ = (function (){var statearr_24736 = state_24734;
(statearr_24736[(4)] = cljs.core.rest((state_24734[(4)])));

return statearr_24736;
})();
var state_24734__$1 = state_24734;
var statearr_24737_24785 = state_24734__$1;
(statearr_24737_24785[(2)] = inst_24729);

(statearr_24737_24785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (20))){
var inst_24694 = (state_24734[(7)]);
var inst_24706 = (state_24734[(2)]);
var inst_24676 = inst_24694;
var inst_24677 = inst_24706;
var state_24734__$1 = (function (){var statearr_24738 = state_24734;
(statearr_24738[(8)] = inst_24677);

(statearr_24738[(9)] = inst_24676);

return statearr_24738;
})();
var statearr_24739_24786 = state_24734__$1;
(statearr_24739_24786[(2)] = null);

(statearr_24739_24786[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (1))){
var state_24734__$1 = state_24734;
var statearr_24740_24787 = state_24734__$1;
(statearr_24740_24787[(2)] = null);

(statearr_24740_24787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (24))){
var inst_24693 = (state_24734[(10)]);
var inst_24677 = (state_24734[(8)]);
var inst_24694 = (state_24734[(7)]);
var inst_24714 = fluree.db.query.analytical.inner_join(inst_24677,inst_24693);
var inst_24676 = inst_24694;
var inst_24677__$1 = inst_24714;
var state_24734__$1 = (function (){var statearr_24741 = state_24734;
(statearr_24741[(8)] = inst_24677__$1);

(statearr_24741[(9)] = inst_24676);

return statearr_24741;
})();
var statearr_24742_24788 = state_24734__$1;
(statearr_24742_24788[(2)] = null);

(statearr_24742_24788[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (4))){
var inst_24656 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24744_24789 = state_24734__$1;
(statearr_24744_24789[(2)] = inst_24656);

(statearr_24744_24789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (15))){
var inst_24693 = (state_24734[(10)]);
var state_24734__$1 = state_24734;
if(cljs.core.truth_(inst_24693)){
var statearr_24745_24790 = state_24734__$1;
(statearr_24745_24790[(1)] = (18));

} else {
var statearr_24746_24791 = state_24734__$1;
(statearr_24746_24791[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (21))){
var inst_24677 = (state_24734[(8)]);
var inst_24694 = (state_24734[(7)]);
var tmp24743 = inst_24677;
var inst_24676 = inst_24694;
var inst_24677__$1 = tmp24743;
var state_24734__$1 = (function (){var statearr_24747 = state_24734;
(statearr_24747[(8)] = inst_24677__$1);

(statearr_24747[(9)] = inst_24676);

return statearr_24747;
})();
var statearr_24748_24792 = state_24734__$1;
(statearr_24748_24792[(2)] = null);

(statearr_24748_24792[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (13))){
var inst_24677 = (state_24734[(8)]);
var inst_24700 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_24677,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_24701 = cljs.core.empty_QMARK_(inst_24700);
var state_24734__$1 = state_24734;
if(inst_24701){
var statearr_24749_24793 = state_24734__$1;
(statearr_24749_24793[(1)] = (15));

} else {
var statearr_24750_24794 = state_24734__$1;
(statearr_24750_24794[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (22))){
var state_24734__$1 = state_24734;
var statearr_24751_24795 = state_24734__$1;
(statearr_24751_24795[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (6))){
var inst_24683 = (state_24734[(11)]);
var inst_24676 = (state_24734[(9)]);
var inst_24682 = cljs.core.seq(inst_24676);
var inst_24683__$1 = cljs.core.first(inst_24682);
var inst_24684 = cljs.core.next(inst_24682);
var state_24734__$1 = (function (){var statearr_24753 = state_24734;
(statearr_24753[(11)] = inst_24683__$1);

(statearr_24753[(12)] = inst_24684);

return statearr_24753;
})();
if(cljs.core.truth_(inst_24683__$1)){
var statearr_24754_24796 = state_24734__$1;
(statearr_24754_24796[(1)] = (8));

} else {
var statearr_24755_24797 = state_24734__$1;
(statearr_24755_24797[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (25))){
var state_24734__$1 = state_24734;
var statearr_24756_24798 = state_24734__$1;
(statearr_24756_24798[(2)] = null);

(statearr_24756_24798[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (17))){
var inst_24722 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24757_24799 = state_24734__$1;
(statearr_24757_24799[(2)] = inst_24722);

(statearr_24757_24799[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (3))){
var inst_24732 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24734__$1,inst_24732);
} else {
if((state_val_24735 === (12))){
var inst_24693 = (state_24734[(10)]);
var inst_24694 = (state_24734[(7)]);
var inst_24676 = inst_24694;
var inst_24677 = inst_24693;
var state_24734__$1 = (function (){var statearr_24758 = state_24734;
(statearr_24758[(8)] = inst_24677);

(statearr_24758[(9)] = inst_24676);

return statearr_24758;
})();
var statearr_24759_24800 = state_24734__$1;
(statearr_24759_24800[(2)] = null);

(statearr_24759_24800[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (2))){
var _ = (function (){var statearr_24760 = state_24734;
(statearr_24760[(4)] = cljs.core.cons((5),(state_24734[(4)])));

return statearr_24760;
})();
var inst_24669 = where;
var inst_24670 = cljs.core.seq(inst_24669);
var inst_24671 = cljs.core.first(inst_24670);
var inst_24672 = cljs.core.next(inst_24670);
var inst_24673 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_24674 = [vars];
var inst_24675 = cljs.core.PersistentHashMap.fromArrays(inst_24673,inst_24674);
var inst_24676 = inst_24669;
var inst_24677 = inst_24675;
var state_24734__$1 = (function (){var statearr_24761 = state_24734;
(statearr_24761[(13)] = inst_24672);

(statearr_24761[(14)] = inst_24671);

(statearr_24761[(8)] = inst_24677);

(statearr_24761[(9)] = inst_24676);

return statearr_24761;
})();
var statearr_24762_24801 = state_24734__$1;
(statearr_24762_24801[(2)] = null);

(statearr_24762_24801[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (23))){
var inst_24720 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24763_24802 = state_24734__$1;
(statearr_24763_24802[(2)] = inst_24720);

(statearr_24763_24802[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (19))){
var inst_24677 = (state_24734[(8)]);
var state_24734__$1 = state_24734;
var statearr_24764_24803 = state_24734__$1;
(statearr_24764_24803[(2)] = inst_24677);

(statearr_24764_24803[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (11))){
var inst_24683 = (state_24734[(11)]);
var inst_24691 = (state_24734[(2)]);
var inst_24692 = fluree.db.util.async.throw_err(inst_24691);
var inst_24693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24692,(0),null);
var inst_24694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24692,(1),null);
var inst_24695 = cljs.core.count(inst_24683);
var inst_24696 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_24695);
var state_24734__$1 = (function (){var statearr_24766 = state_24734;
(statearr_24766[(10)] = inst_24693);

(statearr_24766[(7)] = inst_24694);

return statearr_24766;
})();
if(inst_24696){
var statearr_24767_24804 = state_24734__$1;
(statearr_24767_24804[(1)] = (12));

} else {
var statearr_24768_24805 = state_24734__$1;
(statearr_24768_24805[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (9))){
var inst_24677 = (state_24734[(8)]);
var state_24734__$1 = state_24734;
var statearr_24769_24806 = state_24734__$1;
(statearr_24769_24806[(2)] = inst_24677);

(statearr_24769_24806[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (5))){
var _ = (function (){var statearr_24770 = state_24734;
(statearr_24770[(4)] = cljs.core.rest((state_24734[(4)])));

return statearr_24770;
})();
var state_24734__$1 = state_24734;
var ex24765 = (state_24734__$1[(2)]);
var statearr_24771_24807 = state_24734__$1;
(statearr_24771_24807[(5)] = ex24765);


if((ex24765 instanceof Error)){
var statearr_24772_24808 = state_24734__$1;
(statearr_24772_24808[(1)] = (4));

(statearr_24772_24808[(5)] = null);

} else {
throw ex24765;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (14))){
var inst_24724 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24773_24809 = state_24734__$1;
(statearr_24773_24809[(2)] = inst_24724);

(statearr_24773_24809[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (26))){
var inst_24718 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24774_24810 = state_24734__$1;
(statearr_24774_24810[(2)] = inst_24718);

(statearr_24774_24810[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (16))){
var inst_24693 = (state_24734[(10)]);
var inst_24709 = (inst_24693 == null);
var state_24734__$1 = state_24734;
if(cljs.core.truth_(inst_24709)){
var statearr_24775_24811 = state_24734__$1;
(statearr_24775_24811[(1)] = (21));

} else {
var statearr_24776_24812 = state_24734__$1;
(statearr_24776_24812[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (10))){
var inst_24727 = (state_24734[(2)]);
var state_24734__$1 = state_24734;
var statearr_24777_24813 = state_24734__$1;
(statearr_24777_24813[(2)] = inst_24727);

(statearr_24777_24813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (18))){
var inst_24693 = (state_24734[(10)]);
var state_24734__$1 = state_24734;
var statearr_24778_24814 = state_24734__$1;
(statearr_24778_24814[(2)] = inst_24693);

(statearr_24778_24814[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24735 === (8))){
var inst_24683 = (state_24734[(11)]);
var inst_24677 = (state_24734[(8)]);
var inst_24684 = (state_24734[(12)]);
var inst_24689 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_24677,inst_24683,inst_24684,false,fuel,max_fuel,opts);
var state_24734__$1 = state_24734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24734__$1,(11),inst_24689);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2684__auto__ = null;
var fluree$db$query$analytical$state_machine__2684__auto____0 = (function (){
var statearr_24779 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24779[(0)] = fluree$db$query$analytical$state_machine__2684__auto__);

(statearr_24779[(1)] = (1));

return statearr_24779;
});
var fluree$db$query$analytical$state_machine__2684__auto____1 = (function (state_24734){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24734);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24780){var ex__2687__auto__ = e24780;
var statearr_24781_24815 = state_24734;
(statearr_24781_24815[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24734[(4)]))){
var statearr_24782_24816 = state_24734;
(statearr_24782_24816[(1)] = cljs.core.first((state_24734[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24817 = state_24734;
state_24734 = G__24817;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2684__auto__ = function(state_24734){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2684__auto____1.call(this,state_24734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2684__auto____0;
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2684__auto____1;
return fluree$db$query$analytical$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24783 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24783[(6)] = c__2706__auto__);

return statearr_24783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(p__24818){
var map__24819 = p__24818;
var map__24819__$1 = cljs.core.__destructure_map(map__24819);
var opts = map__24819__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var query_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"query-map","query-map",-808576972));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24853){
var state_val_24854 = (state_24853[(1)]);
if((state_val_24854 === (7))){
var inst_24835 = (state_24853[(7)]);
var inst_24830 = (state_24853[(8)]);
var inst_24837 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,query_map,inst_24830,inst_24835,fuel,max_fuel,opts);
var state_24853__$1 = state_24853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24853__$1,(10),inst_24837);
} else {
if((state_val_24854 === (1))){
var state_24853__$1 = state_24853;
var statearr_24855_24880 = state_24853__$1;
(statearr_24855_24880[(2)] = null);

(statearr_24855_24880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (4))){
var inst_24820 = (state_24853[(2)]);
var state_24853__$1 = state_24853;
var statearr_24856_24881 = state_24853__$1;
(statearr_24856_24881[(2)] = inst_24820);

(statearr_24856_24881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (13))){
var inst_24848 = (state_24853[(2)]);
var _ = (function (){var statearr_24857 = state_24853;
(statearr_24857[(4)] = cljs.core.rest((state_24853[(4)])));

return statearr_24857;
})();
var state_24853__$1 = state_24853;
var statearr_24858_24882 = state_24853__$1;
(statearr_24858_24882[(2)] = inst_24848);

(statearr_24858_24882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (6))){
var inst_24830 = (state_24853[(8)]);
var inst_24834 = (state_24853[(2)]);
var inst_24835 = fluree.db.util.async.throw_err(inst_24834);
var state_24853__$1 = (function (){var statearr_24859 = state_24853;
(statearr_24859[(7)] = inst_24835);

return statearr_24859;
})();
if(cljs.core.truth_(inst_24830)){
var statearr_24860_24883 = state_24853__$1;
(statearr_24860_24883[(1)] = (7));

} else {
var statearr_24861_24884 = state_24853__$1;
(statearr_24861_24884[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (3))){
var inst_24851 = (state_24853[(2)]);
var state_24853__$1 = state_24853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24853__$1,inst_24851);
} else {
if((state_val_24854 === (12))){
var inst_24843 = (state_24853[(9)]);
var state_24853__$1 = state_24853;
var statearr_24862_24885 = state_24853__$1;
(statearr_24862_24885[(2)] = inst_24843);

(statearr_24862_24885[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (2))){
var _ = (function (){var statearr_24863 = state_24853;
(statearr_24863[(4)] = cljs.core.cons((5),(state_24853[(4)])));

return statearr_24863;
})();
var inst_24827 = query_map;
var inst_24828 = cljs.core.__destructure_map(inst_24827);
var inst_24829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24828,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_24830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24828,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_24831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24828,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_24832 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_24829,query_map,vars,fuel,max_fuel,opts);
var state_24853__$1 = (function (){var statearr_24864 = state_24853;
(statearr_24864[(10)] = inst_24831);

(statearr_24864[(8)] = inst_24830);

return statearr_24864;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24853__$1,(6),inst_24832);
} else {
if((state_val_24854 === (11))){
var inst_24831 = (state_24853[(10)]);
var inst_24843 = (state_24853[(9)]);
var inst_24845 = fluree.db.query.analytical.tuples__GT_filtered(inst_24843,inst_24831,null);
var state_24853__$1 = state_24853;
var statearr_24866_24886 = state_24853__$1;
(statearr_24866_24886[(2)] = inst_24845);

(statearr_24866_24886[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (9))){
var inst_24831 = (state_24853[(10)]);
var inst_24843 = (state_24853[(2)]);
var state_24853__$1 = (function (){var statearr_24867 = state_24853;
(statearr_24867[(9)] = inst_24843);

return statearr_24867;
})();
if(cljs.core.truth_(inst_24831)){
var statearr_24868_24887 = state_24853__$1;
(statearr_24868_24887[(1)] = (11));

} else {
var statearr_24869_24888 = state_24853__$1;
(statearr_24869_24888[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (5))){
var _ = (function (){var statearr_24870 = state_24853;
(statearr_24870[(4)] = cljs.core.rest((state_24853[(4)])));

return statearr_24870;
})();
var state_24853__$1 = state_24853;
var ex24865 = (state_24853__$1[(2)]);
var statearr_24871_24889 = state_24853__$1;
(statearr_24871_24889[(5)] = ex24865);


if((ex24865 instanceof Error)){
var statearr_24872_24890 = state_24853__$1;
(statearr_24872_24890[(1)] = (4));

(statearr_24872_24890[(5)] = null);

} else {
throw ex24865;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (10))){
var inst_24839 = (state_24853[(2)]);
var inst_24840 = fluree.db.util.async.throw_err(inst_24839);
var state_24853__$1 = state_24853;
var statearr_24873_24891 = state_24853__$1;
(statearr_24873_24891[(2)] = inst_24840);

(statearr_24873_24891[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24854 === (8))){
var inst_24835 = (state_24853[(7)]);
var state_24853__$1 = state_24853;
var statearr_24874_24892 = state_24853__$1;
(statearr_24874_24892[(2)] = inst_24835);

(statearr_24874_24892[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2684__auto____0 = (function (){
var statearr_24875 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24875[(0)] = fluree$db$query$analytical$q_$_state_machine__2684__auto__);

(statearr_24875[(1)] = (1));

return statearr_24875;
});
var fluree$db$query$analytical$q_$_state_machine__2684__auto____1 = (function (state_24853){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24853);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24876){var ex__2687__auto__ = e24876;
var statearr_24877_24893 = state_24853;
(statearr_24877_24893[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24853[(4)]))){
var statearr_24878_24894 = state_24853;
(statearr_24878_24894[(1)] = cljs.core.first((state_24853[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24895 = state_24853;
state_24853 = G__24895;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2684__auto__ = function(state_24853){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2684__auto____1.call(this,state_24853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2684__auto____0;
fluree$db$query$analytical$q_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24879 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24879[(6)] = c__2706__auto__);

return statearr_24879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
