// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___64548 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64585){
var state_val_64586 = (state_64585[(1)]);
if((state_val_64586 === (7))){
var inst_64580 = (state_64585[(2)]);
var _ = (function (){var statearr_64587 = state_64585;
(statearr_64587[(4)] = cljs.core.rest((state_64585[(4)])));

return statearr_64587;
})();
var state_64585__$1 = state_64585;
var statearr_64588_64615 = state_64585__$1;
(statearr_64588_64615[(2)] = inst_64580);

(statearr_64588_64615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (1))){
var state_64585__$1 = state_64585;
var statearr_64589_64616 = state_64585__$1;
(statearr_64589_64616[(2)] = null);

(statearr_64589_64616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (4))){
var inst_64549 = (state_64585[(2)]);
var state_64585__$1 = state_64585;
var statearr_64590_64617 = state_64585__$1;
(statearr_64590_64617[(2)] = inst_64549);

(statearr_64590_64617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (13))){
var inst_64576 = (state_64585[(2)]);
var state_64585__$1 = state_64585;
var statearr_64591_64618 = state_64585__$1;
(statearr_64591_64618[(2)] = inst_64576);

(statearr_64591_64618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (6))){
var inst_64557 = (state_64585[(7)]);
var inst_64555 = (state_64585[(8)]);
var inst_64560 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64557,inst_64555);
var state_64585__$1 = state_64585;
if(inst_64560){
var statearr_64592_64619 = state_64585__$1;
(statearr_64592_64619[(1)] = (8));

} else {
var statearr_64593_64620 = state_64585__$1;
(statearr_64593_64620[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (3))){
var inst_64583 = (state_64585[(2)]);
var state_64585__$1 = state_64585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64585__$1,inst_64583);
} else {
if((state_val_64586 === (12))){
var inst_64563 = (state_64585[(9)]);
var inst_64558 = (state_64585[(10)]);
var inst_64564 = (state_64585[(11)]);
var inst_64573 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_64558,inst_64563);
var inst_64557 = inst_64564;
var inst_64558__$1 = inst_64573;
var state_64585__$1 = (function (){var statearr_64594 = state_64585;
(statearr_64594[(7)] = inst_64557);

(statearr_64594[(10)] = inst_64558__$1);

return statearr_64594;
})();
var statearr_64595_64621 = state_64585__$1;
(statearr_64595_64621[(2)] = null);

(statearr_64595_64621[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (2))){
var _ = (function (){var statearr_64596 = state_64585;
(statearr_64596[(4)] = cljs.core.cons((5),(state_64585[(4)])));

return statearr_64596;
})();
var inst_64555 = cljs.core.count(args);
var inst_64556 = cljs.core.PersistentVector.EMPTY;
var inst_64557 = (0);
var inst_64558 = inst_64556;
var state_64585__$1 = (function (){var statearr_64597 = state_64585;
(statearr_64597[(7)] = inst_64557);

(statearr_64597[(10)] = inst_64558);

(statearr_64597[(8)] = inst_64555);

return statearr_64597;
})();
var statearr_64598_64622 = state_64585__$1;
(statearr_64598_64622[(2)] = null);

(statearr_64598_64622[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (11))){
var inst_64563 = (state_64585[(9)]);
var state_64585__$1 = state_64585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64585__$1,(14),inst_64563);
} else {
if((state_val_64586 === (9))){
var inst_64557 = (state_64585[(7)]);
var inst_64563 = (state_64585[(9)]);
var inst_64563__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(args,inst_64557);
var inst_64564 = (inst_64557 + (1));
var inst_64565 = fluree.db.util.async.channel_QMARK_(inst_64563__$1);
var state_64585__$1 = (function (){var statearr_64600 = state_64585;
(statearr_64600[(9)] = inst_64563__$1);

(statearr_64600[(11)] = inst_64564);

return statearr_64600;
})();
if(inst_64565){
var statearr_64601_64623 = state_64585__$1;
(statearr_64601_64623[(1)] = (11));

} else {
var statearr_64602_64624 = state_64585__$1;
(statearr_64602_64624[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (5))){
var _ = (function (){var statearr_64603 = state_64585;
(statearr_64603[(4)] = cljs.core.rest((state_64585[(4)])));

return statearr_64603;
})();
var state_64585__$1 = state_64585;
var ex64599 = (state_64585__$1[(2)]);
var statearr_64604_64625 = state_64585__$1;
(statearr_64604_64625[(5)] = ex64599);


if((ex64599 instanceof Error)){
var statearr_64605_64626 = state_64585__$1;
(statearr_64605_64626[(1)] = (4));

(statearr_64605_64626[(5)] = null);

} else {
throw ex64599;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (14))){
var inst_64558 = (state_64585[(10)]);
var inst_64564 = (state_64585[(11)]);
var inst_64568 = (state_64585[(2)]);
var inst_64569 = fluree.db.util.async.throw_err(inst_64568);
var inst_64570 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_64558,inst_64569);
var inst_64557 = inst_64564;
var inst_64558__$1 = inst_64570;
var state_64585__$1 = (function (){var statearr_64606 = state_64585;
(statearr_64606[(7)] = inst_64557);

(statearr_64606[(10)] = inst_64558__$1);

return statearr_64606;
})();
var statearr_64607_64627 = state_64585__$1;
(statearr_64607_64627[(2)] = null);

(statearr_64607_64627[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (10))){
var inst_64578 = (state_64585[(2)]);
var state_64585__$1 = state_64585;
var statearr_64608_64628 = state_64585__$1;
(statearr_64608_64628[(2)] = inst_64578);

(statearr_64608_64628[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64586 === (8))){
var inst_64558 = (state_64585[(10)]);
var state_64585__$1 = state_64585;
var statearr_64609_64629 = state_64585__$1;
(statearr_64609_64629[(2)] = inst_64558);

(statearr_64609_64629[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0 = (function (){
var statearr_64610 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64610[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__);

(statearr_64610[(1)] = (1));

return statearr_64610;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1 = (function (state_64585){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64585);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64611){var ex__2687__auto__ = e64611;
var statearr_64612_64630 = state_64585;
(statearr_64612_64630[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64585[(4)]))){
var statearr_64613_64631 = state_64585;
(statearr_64613_64631[(1)] = cljs.core.first((state_64585[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64632 = state_64585;
state_64585 = G__64632;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = function(state_64585){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1.call(this,state_64585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64614 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64614[(6)] = c__2706__auto__);

return statearr_64614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__64634 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64634,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64634,(1),null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__64633_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__64633_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64682){
var state_val_64683 = (state_64682[(1)]);
if((state_val_64683 === (7))){
var state_64682__$1 = state_64682;
var statearr_64684_64713 = state_64682__$1;
(statearr_64684_64713[(2)] = coll);

(statearr_64684_64713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (1))){
var state_64682__$1 = state_64682;
var statearr_64685_64714 = state_64682__$1;
(statearr_64685_64714[(2)] = null);

(statearr_64685_64714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (4))){
var inst_64637 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
var statearr_64686_64715 = state_64682__$1;
(statearr_64686_64715[(2)] = inst_64637);

(statearr_64686_64715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (15))){
var inst_64656 = (state_64682[(7)]);
var inst_64664 = (state_64682[(2)]);
var inst_64665 = fluree.db.dbfunctions.internal.nth(inst_64656,inst_64664);
var inst_64666 = cljs.core.count(inst_64656);
var inst_64667 = ((9) + inst_64666);
var inst_64668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64669 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64671 = [inst_64656,inst_64664];
var inst_64672 = (new cljs.core.PersistentVector(null,2,(5),inst_64670,inst_64671,null));
var inst_64673 = ["nth",inst_64672,inst_64665];
var inst_64674 = cljs.core.PersistentHashMap.fromArrays(inst_64669,inst_64673);
var inst_64675 = [inst_64674,inst_64667];
var inst_64676 = (new cljs.core.PersistentVector(null,2,(5),inst_64668,inst_64675,null));
var inst_64677 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64676);
var _ = (function (){var statearr_64687 = state_64682;
(statearr_64687[(4)] = cljs.core.rest((state_64682[(4)])));

return statearr_64687;
})();
var state_64682__$1 = (function (){var statearr_64688 = state_64682;
(statearr_64688[(8)] = inst_64677);

return statearr_64688;
})();
var statearr_64689_64716 = state_64682__$1;
(statearr_64689_64716[(2)] = inst_64665);

(statearr_64689_64716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (13))){
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64682__$1,(16),key);
} else {
if((state_val_64683 === (6))){
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64682__$1,(9),coll);
} else {
if((state_val_64683 === (3))){
var inst_64680 = (state_64682[(2)]);
var state_64682__$1 = state_64682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64682__$1,inst_64680);
} else {
if((state_val_64683 === (12))){
var inst_64656 = (state_64682[(2)]);
var inst_64657 = fluree.db.util.async.channel_QMARK_(key);
var state_64682__$1 = (function (){var statearr_64690 = state_64682;
(statearr_64690[(7)] = inst_64656);

return statearr_64690;
})();
if(inst_64657){
var statearr_64691_64717 = state_64682__$1;
(statearr_64691_64717[(1)] = (13));

} else {
var statearr_64692_64718 = state_64682__$1;
(statearr_64692_64718[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (2))){
var _ = (function (){var statearr_64693 = state_64682;
(statearr_64693[(4)] = cljs.core.cons((5),(state_64682[(4)])));

return statearr_64693;
})();
var inst_64643 = fluree.db.util.async.channel_QMARK_(coll);
var state_64682__$1 = state_64682;
if(inst_64643){
var statearr_64694_64719 = state_64682__$1;
(statearr_64694_64719[(1)] = (6));

} else {
var statearr_64695_64720 = state_64682__$1;
(statearr_64695_64720[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (11))){
var inst_64650 = (state_64682[(9)]);
var state_64682__$1 = state_64682;
var statearr_64697_64721 = state_64682__$1;
(statearr_64697_64721[(2)] = inst_64650);

(statearr_64697_64721[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (9))){
var inst_64646 = (state_64682[(2)]);
var inst_64647 = fluree.db.util.async.throw_err(inst_64646);
var state_64682__$1 = state_64682;
var statearr_64698_64722 = state_64682__$1;
(statearr_64698_64722[(2)] = inst_64647);

(statearr_64698_64722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (5))){
var _ = (function (){var statearr_64699 = state_64682;
(statearr_64699[(4)] = cljs.core.rest((state_64682[(4)])));

return statearr_64699;
})();
var state_64682__$1 = state_64682;
var ex64696 = (state_64682__$1[(2)]);
var statearr_64700_64723 = state_64682__$1;
(statearr_64700_64723[(5)] = ex64696);


if((ex64696 instanceof Error)){
var statearr_64701_64724 = state_64682__$1;
(statearr_64701_64724[(1)] = (4));

(statearr_64701_64724[(5)] = null);

} else {
throw ex64696;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (14))){
var state_64682__$1 = state_64682;
var statearr_64702_64725 = state_64682__$1;
(statearr_64702_64725[(2)] = key);

(statearr_64702_64725[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (16))){
var inst_64660 = (state_64682[(2)]);
var inst_64661 = fluree.db.util.async.throw_err(inst_64660);
var state_64682__$1 = state_64682;
var statearr_64703_64726 = state_64682__$1;
(statearr_64703_64726[(2)] = inst_64661);

(statearr_64703_64726[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (10))){
var inst_64650 = (state_64682[(9)]);
var inst_64653 = cljs.core.vec(inst_64650);
var state_64682__$1 = state_64682;
var statearr_64704_64727 = state_64682__$1;
(statearr_64704_64727[(2)] = inst_64653);

(statearr_64704_64727[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64683 === (8))){
var inst_64650 = (state_64682[(9)]);
var inst_64650__$1 = (state_64682[(2)]);
var inst_64651 = cljs.core.set_QMARK_(inst_64650__$1);
var state_64682__$1 = (function (){var statearr_64705 = state_64682;
(statearr_64705[(9)] = inst_64650__$1);

return statearr_64705;
})();
if(inst_64651){
var statearr_64706_64728 = state_64682__$1;
(statearr_64706_64728[(1)] = (10));

} else {
var statearr_64707_64729 = state_64682__$1;
(statearr_64707_64729[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0 = (function (){
var statearr_64708 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64708[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__);

(statearr_64708[(1)] = (1));

return statearr_64708;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1 = (function (state_64682){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64682);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64709){var ex__2687__auto__ = e64709;
var statearr_64710_64730 = state_64682;
(statearr_64710_64730[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64682[(4)]))){
var statearr_64711_64731 = state_64682;
(statearr_64711_64731[(1)] = cljs.core.first((state_64682[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64732 = state_64682;
state_64682 = G__64732;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = function(state_64682){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1.call(this,state_64682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64712 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64712[(6)] = c__2706__auto__);

return statearr_64712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the first item in a collection
 */
fluree.db.dbfunctions.fns.first = (function fluree$db$dbfunctions$fns$first(_QMARK_ctx,coll){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64768){
var state_val_64769 = (state_64768[(1)]);
if((state_val_64769 === (7))){
var state_64768__$1 = state_64768;
var statearr_64770_64794 = state_64768__$1;
(statearr_64770_64794[(2)] = coll);

(statearr_64770_64794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (1))){
var state_64768__$1 = state_64768;
var statearr_64771_64795 = state_64768__$1;
(statearr_64771_64795[(2)] = null);

(statearr_64771_64795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (4))){
var inst_64733 = (state_64768[(2)]);
var state_64768__$1 = state_64768;
var statearr_64772_64796 = state_64768__$1;
(statearr_64772_64796[(2)] = inst_64733);

(statearr_64772_64796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (6))){
var state_64768__$1 = state_64768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64768__$1,(9),coll);
} else {
if((state_val_64769 === (3))){
var inst_64766 = (state_64768[(2)]);
var state_64768__$1 = state_64768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64768__$1,inst_64766);
} else {
if((state_val_64769 === (12))){
var inst_64752 = (state_64768[(2)]);
var inst_64753 = fluree.db.dbfunctions.internal.first(inst_64752);
var inst_64754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64755 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64757 = [inst_64752];
var inst_64758 = (new cljs.core.PersistentVector(null,1,(5),inst_64756,inst_64757,null));
var inst_64759 = ["first",inst_64758,inst_64753];
var inst_64760 = cljs.core.PersistentHashMap.fromArrays(inst_64755,inst_64759);
var inst_64761 = [inst_64760,(10)];
var inst_64762 = (new cljs.core.PersistentVector(null,2,(5),inst_64754,inst_64761,null));
var inst_64763 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64762);
var _ = (function (){var statearr_64773 = state_64768;
(statearr_64773[(4)] = cljs.core.rest((state_64768[(4)])));

return statearr_64773;
})();
var state_64768__$1 = (function (){var statearr_64774 = state_64768;
(statearr_64774[(7)] = inst_64763);

return statearr_64774;
})();
var statearr_64775_64797 = state_64768__$1;
(statearr_64775_64797[(2)] = inst_64753);

(statearr_64775_64797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (2))){
var _ = (function (){var statearr_64776 = state_64768;
(statearr_64776[(4)] = cljs.core.cons((5),(state_64768[(4)])));

return statearr_64776;
})();
var inst_64739 = fluree.db.util.async.channel_QMARK_(coll);
var state_64768__$1 = state_64768;
if(inst_64739){
var statearr_64777_64798 = state_64768__$1;
(statearr_64777_64798[(1)] = (6));

} else {
var statearr_64778_64799 = state_64768__$1;
(statearr_64778_64799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (11))){
var inst_64746 = (state_64768[(8)]);
var state_64768__$1 = state_64768;
var statearr_64780_64800 = state_64768__$1;
(statearr_64780_64800[(2)] = inst_64746);

(statearr_64780_64800[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (9))){
var inst_64742 = (state_64768[(2)]);
var inst_64743 = fluree.db.util.async.throw_err(inst_64742);
var state_64768__$1 = state_64768;
var statearr_64781_64801 = state_64768__$1;
(statearr_64781_64801[(2)] = inst_64743);

(statearr_64781_64801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (5))){
var _ = (function (){var statearr_64782 = state_64768;
(statearr_64782[(4)] = cljs.core.rest((state_64768[(4)])));

return statearr_64782;
})();
var state_64768__$1 = state_64768;
var ex64779 = (state_64768__$1[(2)]);
var statearr_64783_64802 = state_64768__$1;
(statearr_64783_64802[(5)] = ex64779);


if((ex64779 instanceof Error)){
var statearr_64784_64803 = state_64768__$1;
(statearr_64784_64803[(1)] = (4));

(statearr_64784_64803[(5)] = null);

} else {
throw ex64779;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (10))){
var inst_64746 = (state_64768[(8)]);
var inst_64749 = cljs.core.vec(inst_64746);
var state_64768__$1 = state_64768;
var statearr_64785_64804 = state_64768__$1;
(statearr_64785_64804[(2)] = inst_64749);

(statearr_64785_64804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64769 === (8))){
var inst_64746 = (state_64768[(8)]);
var inst_64746__$1 = (state_64768[(2)]);
var inst_64747 = cljs.core.set_QMARK_(inst_64746__$1);
var state_64768__$1 = (function (){var statearr_64786 = state_64768;
(statearr_64786[(8)] = inst_64746__$1);

return statearr_64786;
})();
if(inst_64747){
var statearr_64787_64805 = state_64768__$1;
(statearr_64787_64805[(1)] = (10));

} else {
var statearr_64788_64806 = state_64768__$1;
(statearr_64788_64806[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0 = (function (){
var statearr_64789 = [null,null,null,null,null,null,null,null,null];
(statearr_64789[(0)] = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__);

(statearr_64789[(1)] = (1));

return statearr_64789;
});
var fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1 = (function (state_64768){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64768);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64790){var ex__2687__auto__ = e64790;
var statearr_64791_64807 = state_64768;
(statearr_64791_64807[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64768[(4)]))){
var statearr_64792_64808 = state_64768;
(statearr_64792_64808[(1)] = cljs.core.first((state_64768[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64809 = state_64768;
state_64768 = G__64809;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__ = function(state_64768){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1.call(this,state_64768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$first_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64793 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64793[(6)] = c__2706__auto__);

return statearr_64793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64870){
var state_val_64871 = (state_64870[(1)]);
if((state_val_64871 === (7))){
var state_64870__$1 = state_64870;
var statearr_64872_64906 = state_64870__$1;
(statearr_64872_64906[(2)] = test);

(statearr_64872_64906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (20))){
var inst_64844 = (state_64870[(2)]);
var inst_64845 = fluree.db.util.async.throw_err(inst_64844);
var state_64870__$1 = state_64870;
var statearr_64873_64907 = state_64870__$1;
(statearr_64873_64907[(2)] = inst_64845);

(statearr_64873_64907[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (1))){
var state_64870__$1 = state_64870;
var statearr_64874_64908 = state_64870__$1;
(statearr_64874_64908[(2)] = null);

(statearr_64874_64908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (4))){
var inst_64810 = (state_64870[(2)]);
var state_64870__$1 = state_64870;
var statearr_64875_64909 = state_64870__$1;
(statearr_64875_64909[(2)] = inst_64810);

(statearr_64875_64909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (15))){
var inst_64828 = (state_64870[(7)]);
var inst_64836 = (state_64870[(2)]);
var inst_64837 = [inst_64836,f];
var inst_64838 = (new cljs.core.PersistentVector(null,2,(5),inst_64828,inst_64837,null));
var state_64870__$1 = state_64870;
var statearr_64876_64910 = state_64870__$1;
(statearr_64876_64910[(2)] = inst_64838);

(statearr_64876_64910[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (13))){
var state_64870__$1 = state_64870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64870__$1,(16),t);
} else {
if((state_val_64871 === (6))){
var state_64870__$1 = state_64870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64870__$1,(9),test);
} else {
if((state_val_64871 === (17))){
var state_64870__$1 = state_64870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64870__$1,(20),f);
} else {
if((state_val_64871 === (3))){
var inst_64868 = (state_64870[(2)]);
var state_64870__$1 = state_64870;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64870__$1,inst_64868);
} else {
if((state_val_64871 === (12))){
var inst_64826 = (state_64870[(8)]);
var inst_64852 = (state_64870[(2)]);
var inst_64853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64852,(0),null);
var inst_64854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64852,(1),null);
var inst_64855 = fluree.db.dbfunctions.internal.if_else(inst_64826,inst_64853,inst_64854);
var inst_64856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64857 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64859 = [inst_64826,inst_64853,inst_64854];
var inst_64860 = (new cljs.core.PersistentVector(null,3,(5),inst_64858,inst_64859,null));
var inst_64861 = ["if-else",inst_64860,inst_64855];
var inst_64862 = cljs.core.PersistentHashMap.fromArrays(inst_64857,inst_64861);
var inst_64863 = [inst_64862,(10)];
var inst_64864 = (new cljs.core.PersistentVector(null,2,(5),inst_64856,inst_64863,null));
var inst_64865 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64864);
var _ = (function (){var statearr_64877 = state_64870;
(statearr_64877[(4)] = cljs.core.rest((state_64870[(4)])));

return statearr_64877;
})();
var state_64870__$1 = (function (){var statearr_64878 = state_64870;
(statearr_64878[(9)] = inst_64865);

return statearr_64878;
})();
var statearr_64879_64911 = state_64870__$1;
(statearr_64879_64911[(2)] = inst_64855);

(statearr_64879_64911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (2))){
var _ = (function (){var statearr_64880 = state_64870;
(statearr_64880[(4)] = cljs.core.cons((5),(state_64870[(4)])));

return statearr_64880;
})();
var inst_64819 = fluree.db.util.async.channel_QMARK_(test);
var state_64870__$1 = state_64870;
if(inst_64819){
var statearr_64881_64912 = state_64870__$1;
(statearr_64881_64912[(1)] = (6));

} else {
var statearr_64882_64913 = state_64870__$1;
(statearr_64882_64913[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (19))){
var inst_64840 = (state_64870[(10)]);
var inst_64848 = (state_64870[(2)]);
var inst_64849 = [f,inst_64848];
var inst_64850 = (new cljs.core.PersistentVector(null,2,(5),inst_64840,inst_64849,null));
var state_64870__$1 = state_64870;
var statearr_64883_64914 = state_64870__$1;
(statearr_64883_64914[(2)] = inst_64850);

(statearr_64883_64914[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (11))){
var inst_64840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64841 = fluree.db.util.async.channel_QMARK_(f);
var state_64870__$1 = (function (){var statearr_64885 = state_64870;
(statearr_64885[(10)] = inst_64840);

return statearr_64885;
})();
if(inst_64841){
var statearr_64886_64915 = state_64870__$1;
(statearr_64886_64915[(1)] = (17));

} else {
var statearr_64887_64916 = state_64870__$1;
(statearr_64887_64916[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (9))){
var inst_64822 = (state_64870[(2)]);
var inst_64823 = fluree.db.util.async.throw_err(inst_64822);
var state_64870__$1 = state_64870;
var statearr_64888_64917 = state_64870__$1;
(statearr_64888_64917[(2)] = inst_64823);

(statearr_64888_64917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (5))){
var _ = (function (){var statearr_64889 = state_64870;
(statearr_64889[(4)] = cljs.core.rest((state_64870[(4)])));

return statearr_64889;
})();
var state_64870__$1 = state_64870;
var ex64884 = (state_64870__$1[(2)]);
var statearr_64890_64918 = state_64870__$1;
(statearr_64890_64918[(5)] = ex64884);


if((ex64884 instanceof Error)){
var statearr_64891_64919 = state_64870__$1;
(statearr_64891_64919[(1)] = (4));

(statearr_64891_64919[(5)] = null);

} else {
throw ex64884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (14))){
var state_64870__$1 = state_64870;
var statearr_64892_64920 = state_64870__$1;
(statearr_64892_64920[(2)] = t);

(statearr_64892_64920[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (16))){
var inst_64832 = (state_64870[(2)]);
var inst_64833 = fluree.db.util.async.throw_err(inst_64832);
var state_64870__$1 = state_64870;
var statearr_64893_64921 = state_64870__$1;
(statearr_64893_64921[(2)] = inst_64833);

(statearr_64893_64921[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (10))){
var inst_64828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64829 = fluree.db.util.async.channel_QMARK_(t);
var state_64870__$1 = (function (){var statearr_64894 = state_64870;
(statearr_64894[(7)] = inst_64828);

return statearr_64894;
})();
if(inst_64829){
var statearr_64895_64922 = state_64870__$1;
(statearr_64895_64922[(1)] = (13));

} else {
var statearr_64896_64923 = state_64870__$1;
(statearr_64896_64923[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (18))){
var state_64870__$1 = state_64870;
var statearr_64897_64924 = state_64870__$1;
(statearr_64897_64924[(2)] = f);

(statearr_64897_64924[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64871 === (8))){
var inst_64826 = (state_64870[(8)]);
var inst_64826__$1 = (state_64870[(2)]);
var state_64870__$1 = (function (){var statearr_64898 = state_64870;
(statearr_64898[(8)] = inst_64826__$1);

return statearr_64898;
})();
if(cljs.core.truth_(inst_64826__$1)){
var statearr_64899_64925 = state_64870__$1;
(statearr_64899_64925[(1)] = (10));

} else {
var statearr_64900_64926 = state_64870__$1;
(statearr_64900_64926[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0 = (function (){
var statearr_64901 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64901[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__);

(statearr_64901[(1)] = (1));

return statearr_64901;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1 = (function (state_64870){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64870);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64902){var ex__2687__auto__ = e64902;
var statearr_64903_64927 = state_64870;
(statearr_64903_64927[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64870[(4)]))){
var statearr_64904_64928 = state_64870;
(statearr_64904_64928[(1)] = cljs.core.first((state_64870[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64929 = state_64870;
state_64870 = G__64929;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = function(state_64870){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1.call(this,state_64870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64905 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64905[(6)] = c__2706__auto__);

return statearr_64905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64959){
var state_val_64960 = (state_64959[(1)]);
if((state_val_64960 === (7))){
var state_64959__$1 = state_64959;
var statearr_64961_64980 = state_64959__$1;
(statearr_64961_64980[(2)] = arg);

(statearr_64961_64980[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (1))){
var state_64959__$1 = state_64959;
var statearr_64962_64981 = state_64959__$1;
(statearr_64962_64981[(2)] = null);

(statearr_64962_64981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (4))){
var inst_64930 = (state_64959[(2)]);
var state_64959__$1 = state_64959;
var statearr_64963_64982 = state_64959__$1;
(statearr_64963_64982[(2)] = inst_64930);

(statearr_64963_64982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (6))){
var state_64959__$1 = state_64959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64959__$1,(9),arg);
} else {
if((state_val_64960 === (3))){
var inst_64957 = (state_64959[(2)]);
var state_64959__$1 = state_64959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64959__$1,inst_64957);
} else {
if((state_val_64960 === (2))){
var _ = (function (){var statearr_64965 = state_64959;
(statearr_64965[(4)] = cljs.core.cons((5),(state_64959[(4)])));

return statearr_64965;
})();
var inst_64936 = fluree.db.util.async.channel_QMARK_(arg);
var state_64959__$1 = state_64959;
if(inst_64936){
var statearr_64966_64983 = state_64959__$1;
(statearr_64966_64983[(1)] = (6));

} else {
var statearr_64967_64984 = state_64959__$1;
(statearr_64967_64984[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (9))){
var inst_64939 = (state_64959[(2)]);
var inst_64940 = fluree.db.util.async.throw_err(inst_64939);
var state_64959__$1 = state_64959;
var statearr_64968_64985 = state_64959__$1;
(statearr_64968_64985[(2)] = inst_64940);

(statearr_64968_64985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (5))){
var _ = (function (){var statearr_64969 = state_64959;
(statearr_64969[(4)] = cljs.core.rest((state_64959[(4)])));

return statearr_64969;
})();
var state_64959__$1 = state_64959;
var ex64964 = (state_64959__$1[(2)]);
var statearr_64970_64986 = state_64959__$1;
(statearr_64970_64986[(5)] = ex64964);


if((ex64964 instanceof Error)){
var statearr_64971_64987 = state_64959__$1;
(statearr_64971_64987[(1)] = (4));

(statearr_64971_64987[(5)] = null);

} else {
throw ex64964;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (8))){
var inst_64943 = (state_64959[(2)]);
var inst_64944 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_64943);
var inst_64945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64946 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64948 = [inst_64943];
var inst_64949 = (new cljs.core.PersistentVector(null,1,(5),inst_64947,inst_64948,null));
var inst_64950 = ["nil?",inst_64949,inst_64944];
var inst_64951 = cljs.core.PersistentHashMap.fromArrays(inst_64946,inst_64950);
var inst_64952 = [inst_64951,(10)];
var inst_64953 = (new cljs.core.PersistentVector(null,2,(5),inst_64945,inst_64952,null));
var inst_64954 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64953);
var _ = (function (){var statearr_64972 = state_64959;
(statearr_64972[(4)] = cljs.core.rest((state_64959[(4)])));

return statearr_64972;
})();
var state_64959__$1 = (function (){var statearr_64973 = state_64959;
(statearr_64973[(7)] = inst_64954);

return statearr_64973;
})();
var statearr_64974_64988 = state_64959__$1;
(statearr_64974_64988[(2)] = inst_64944);

(statearr_64974_64988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_64975 = [null,null,null,null,null,null,null,null];
(statearr_64975[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__);

(statearr_64975[(1)] = (1));

return statearr_64975;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1 = (function (state_64959){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64959);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64976){var ex__2687__auto__ = e64976;
var statearr_64977_64989 = state_64959;
(statearr_64977_64989[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64959[(4)]))){
var statearr_64978_64990 = state_64959;
(statearr_64978_64990[(1)] = cljs.core.first((state_64959[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64991 = state_64959;
state_64959 = G__64991;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = function(state_64959){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1.call(this,state_64959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64979 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64979[(6)] = c__2706__auto__);

return statearr_64979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65021){
var state_val_65022 = (state_65021[(1)]);
if((state_val_65022 === (7))){
var state_65021__$1 = state_65021;
var statearr_65023_65042 = state_65021__$1;
(statearr_65023_65042[(2)] = arg);

(statearr_65023_65042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65022 === (1))){
var state_65021__$1 = state_65021;
var statearr_65024_65043 = state_65021__$1;
(statearr_65024_65043[(2)] = null);

(statearr_65024_65043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65022 === (4))){
var inst_64992 = (state_65021[(2)]);
var state_65021__$1 = state_65021;
var statearr_65025_65044 = state_65021__$1;
(statearr_65025_65044[(2)] = inst_64992);

(statearr_65025_65044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65022 === (6))){
var state_65021__$1 = state_65021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65021__$1,(9),arg);
} else {
if((state_val_65022 === (3))){
var inst_65019 = (state_65021[(2)]);
var state_65021__$1 = state_65021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65021__$1,inst_65019);
} else {
if((state_val_65022 === (2))){
var _ = (function (){var statearr_65027 = state_65021;
(statearr_65027[(4)] = cljs.core.cons((5),(state_65021[(4)])));

return statearr_65027;
})();
var inst_64998 = fluree.db.util.async.channel_QMARK_(arg);
var state_65021__$1 = state_65021;
if(inst_64998){
var statearr_65028_65045 = state_65021__$1;
(statearr_65028_65045[(1)] = (6));

} else {
var statearr_65029_65046 = state_65021__$1;
(statearr_65029_65046[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65022 === (9))){
var inst_65001 = (state_65021[(2)]);
var inst_65002 = fluree.db.util.async.throw_err(inst_65001);
var state_65021__$1 = state_65021;
var statearr_65030_65047 = state_65021__$1;
(statearr_65030_65047[(2)] = inst_65002);

(statearr_65030_65047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65022 === (5))){
var _ = (function (){var statearr_65031 = state_65021;
(statearr_65031[(4)] = cljs.core.rest((state_65021[(4)])));

return statearr_65031;
})();
var state_65021__$1 = state_65021;
var ex65026 = (state_65021__$1[(2)]);
var statearr_65032_65048 = state_65021__$1;
(statearr_65032_65048[(5)] = ex65026);


if((ex65026 instanceof Error)){
var statearr_65033_65049 = state_65021__$1;
(statearr_65033_65049[(1)] = (4));

(statearr_65033_65049[(5)] = null);

} else {
throw ex65026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65022 === (8))){
var inst_65005 = (state_65021[(2)]);
var inst_65006 = fluree.db.dbfunctions.internal.not(inst_65005);
var inst_65007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65008 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65010 = [inst_65005];
var inst_65011 = (new cljs.core.PersistentVector(null,1,(5),inst_65009,inst_65010,null));
var inst_65012 = ["not",inst_65011,inst_65006];
var inst_65013 = cljs.core.PersistentHashMap.fromArrays(inst_65008,inst_65012);
var inst_65014 = [inst_65013,(10)];
var inst_65015 = (new cljs.core.PersistentVector(null,2,(5),inst_65007,inst_65014,null));
var inst_65016 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65015);
var _ = (function (){var statearr_65034 = state_65021;
(statearr_65034[(4)] = cljs.core.rest((state_65021[(4)])));

return statearr_65034;
})();
var state_65021__$1 = (function (){var statearr_65035 = state_65021;
(statearr_65035[(7)] = inst_65016);

return statearr_65035;
})();
var statearr_65036_65050 = state_65021__$1;
(statearr_65036_65050[(2)] = inst_65006);

(statearr_65036_65050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0 = (function (){
var statearr_65037 = [null,null,null,null,null,null,null,null];
(statearr_65037[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__);

(statearr_65037[(1)] = (1));

return statearr_65037;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1 = (function (state_65021){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65021);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65038){var ex__2687__auto__ = e65038;
var statearr_65039_65051 = state_65021;
(statearr_65039_65051[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65021[(4)]))){
var statearr_65040_65052 = state_65021;
(statearr_65040_65052[(1)] = cljs.core.first((state_65021[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65053 = state_65021;
state_65021 = G__65053;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = function(state_65021){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1.call(this,state_65021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65041 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65041[(6)] = c__2706__auto__);

return statearr_65041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65083){
var state_val_65084 = (state_65083[(1)]);
if((state_val_65084 === (7))){
var state_65083__$1 = state_65083;
var statearr_65085_65104 = state_65083__$1;
(statearr_65085_65104[(2)] = arg);

(statearr_65085_65104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65084 === (1))){
var state_65083__$1 = state_65083;
var statearr_65086_65105 = state_65083__$1;
(statearr_65086_65105[(2)] = null);

(statearr_65086_65105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65084 === (4))){
var inst_65054 = (state_65083[(2)]);
var state_65083__$1 = state_65083;
var statearr_65087_65106 = state_65083__$1;
(statearr_65087_65106[(2)] = inst_65054);

(statearr_65087_65106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65084 === (6))){
var state_65083__$1 = state_65083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65083__$1,(9),arg);
} else {
if((state_val_65084 === (3))){
var inst_65081 = (state_65083[(2)]);
var state_65083__$1 = state_65083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65083__$1,inst_65081);
} else {
if((state_val_65084 === (2))){
var _ = (function (){var statearr_65089 = state_65083;
(statearr_65089[(4)] = cljs.core.cons((5),(state_65083[(4)])));

return statearr_65089;
})();
var inst_65060 = fluree.db.util.async.channel_QMARK_(arg);
var state_65083__$1 = state_65083;
if(inst_65060){
var statearr_65090_65107 = state_65083__$1;
(statearr_65090_65107[(1)] = (6));

} else {
var statearr_65091_65108 = state_65083__$1;
(statearr_65091_65108[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65084 === (9))){
var inst_65063 = (state_65083[(2)]);
var inst_65064 = fluree.db.util.async.throw_err(inst_65063);
var state_65083__$1 = state_65083;
var statearr_65092_65109 = state_65083__$1;
(statearr_65092_65109[(2)] = inst_65064);

(statearr_65092_65109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65084 === (5))){
var _ = (function (){var statearr_65093 = state_65083;
(statearr_65093[(4)] = cljs.core.rest((state_65083[(4)])));

return statearr_65093;
})();
var state_65083__$1 = state_65083;
var ex65088 = (state_65083__$1[(2)]);
var statearr_65094_65110 = state_65083__$1;
(statearr_65094_65110[(5)] = ex65088);


if((ex65088 instanceof Error)){
var statearr_65095_65111 = state_65083__$1;
(statearr_65095_65111[(1)] = (4));

(statearr_65095_65111[(5)] = null);

} else {
throw ex65088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65084 === (8))){
var inst_65067 = (state_65083[(2)]);
var inst_65068 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_65067);
var inst_65069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65070 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65072 = [inst_65067];
var inst_65073 = (new cljs.core.PersistentVector(null,1,(5),inst_65071,inst_65072,null));
var inst_65074 = ["empty?",inst_65073,inst_65068];
var inst_65075 = cljs.core.PersistentHashMap.fromArrays(inst_65070,inst_65074);
var inst_65076 = [inst_65075,(10)];
var inst_65077 = (new cljs.core.PersistentVector(null,2,(5),inst_65069,inst_65076,null));
var inst_65078 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65077);
var _ = (function (){var statearr_65096 = state_65083;
(statearr_65096[(4)] = cljs.core.rest((state_65083[(4)])));

return statearr_65096;
})();
var state_65083__$1 = (function (){var statearr_65097 = state_65083;
(statearr_65097[(7)] = inst_65078);

return statearr_65097;
})();
var statearr_65098_65112 = state_65083__$1;
(statearr_65098_65112[(2)] = inst_65068);

(statearr_65098_65112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_65099 = [null,null,null,null,null,null,null,null];
(statearr_65099[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__);

(statearr_65099[(1)] = (1));

return statearr_65099;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1 = (function (state_65083){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65083);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65100){var ex__2687__auto__ = e65100;
var statearr_65101_65113 = state_65083;
(statearr_65101_65113[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65083[(4)]))){
var statearr_65102_65114 = state_65083;
(statearr_65102_65114[(1)] = cljs.core.first((state_65083[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65115 = state_65083;
state_65083 = G__65115;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = function(state_65083){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1.call(this,state_65083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65103 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65103[(6)] = c__2706__auto__);

return statearr_65103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65160 = arguments.length;
var i__5770__auto___65161 = (0);
while(true){
if((i__5770__auto___65161 < len__5769__auto___65160)){
args__5775__auto__.push((arguments[i__5770__auto___65161]));

var G__65162 = (i__5770__auto___65161 + (1));
i__5770__auto___65161 = G__65162;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65143){
var state_val_65144 = (state_65143[(1)]);
if((state_val_65144 === (1))){
var state_65143__$1 = state_65143;
var statearr_65145_65163 = state_65143__$1;
(statearr_65145_65163[(2)] = null);

(statearr_65145_65163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65144 === (2))){
var _ = (function (){var statearr_65146 = state_65143;
(statearr_65146[(4)] = cljs.core.cons((5),(state_65143[(4)])));

return statearr_65146;
})();
var inst_65124 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65143__$1 = state_65143;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65143__$1,(6),inst_65124);
} else {
if((state_val_65144 === (3))){
var inst_65141 = (state_65143[(2)]);
var state_65143__$1 = state_65143;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65143__$1,inst_65141);
} else {
if((state_val_65144 === (4))){
var inst_65118 = (state_65143[(2)]);
var state_65143__$1 = state_65143;
var statearr_65148_65164 = state_65143__$1;
(statearr_65148_65164[(2)] = inst_65118);

(statearr_65148_65164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65144 === (5))){
var _ = (function (){var statearr_65149 = state_65143;
(statearr_65149[(4)] = cljs.core.rest((state_65143[(4)])));

return statearr_65149;
})();
var state_65143__$1 = state_65143;
var ex65147 = (state_65143__$1[(2)]);
var statearr_65150_65165 = state_65143__$1;
(statearr_65150_65165[(5)] = ex65147);


if((ex65147 instanceof Error)){
var statearr_65151_65166 = state_65143__$1;
(statearr_65151_65166[(1)] = (4));

(statearr_65151_65166[(5)] = null);

} else {
throw ex65147;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65144 === (6))){
var inst_65126 = (state_65143[(2)]);
var inst_65127 = fluree.db.util.async.throw_err(inst_65126);
var inst_65128 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_65127);
var inst_65129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65130 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65132 = [inst_65127];
var inst_65133 = (new cljs.core.PersistentVector(null,1,(5),inst_65131,inst_65132,null));
var inst_65134 = ["str",inst_65133,inst_65128];
var inst_65135 = cljs.core.PersistentHashMap.fromArrays(inst_65130,inst_65134);
var inst_65136 = [inst_65135,(10)];
var inst_65137 = (new cljs.core.PersistentVector(null,2,(5),inst_65129,inst_65136,null));
var inst_65138 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65137);
var _ = (function (){var statearr_65152 = state_65143;
(statearr_65152[(4)] = cljs.core.rest((state_65143[(4)])));

return statearr_65152;
})();
var state_65143__$1 = (function (){var statearr_65153 = state_65143;
(statearr_65153[(7)] = inst_65138);

return statearr_65153;
})();
var statearr_65154_65167 = state_65143__$1;
(statearr_65154_65167[(2)] = inst_65128);

(statearr_65154_65167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65155 = [null,null,null,null,null,null,null,null];
(statearr_65155[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65155[(1)] = (1));

return statearr_65155;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65143){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65143);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65156){var ex__2687__auto__ = e65156;
var statearr_65157_65168 = state_65143;
(statearr_65157_65168[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65143[(4)]))){
var statearr_65158_65169 = state_65143;
(statearr_65158_65169[(1)] = cljs.core.first((state_65143[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65170 = state_65143;
state_65143 = G__65170;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65143){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65159 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65159[(6)] = c__2706__auto__);

return statearr_65159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq65116){
var G__65117 = cljs.core.first(seq65116);
var seq65116__$1 = cljs.core.next(seq65116);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65117,seq65116__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65196){
var state_val_65197 = (state_65196[(1)]);
if((state_val_65197 === (1))){
var state_65196__$1 = state_65196;
var statearr_65198_65213 = state_65196__$1;
(statearr_65198_65213[(2)] = null);

(statearr_65198_65213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65197 === (2))){
var _ = (function (){var statearr_65199 = state_65196;
(statearr_65199[(4)] = cljs.core.cons((5),(state_65196[(4)])));

return statearr_65199;
})();
var inst_65177 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65196__$1 = state_65196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65196__$1,(6),inst_65177);
} else {
if((state_val_65197 === (3))){
var inst_65194 = (state_65196[(2)]);
var state_65196__$1 = state_65196;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65196__$1,inst_65194);
} else {
if((state_val_65197 === (4))){
var inst_65171 = (state_65196[(2)]);
var state_65196__$1 = state_65196;
var statearr_65201_65214 = state_65196__$1;
(statearr_65201_65214[(2)] = inst_65171);

(statearr_65201_65214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65197 === (5))){
var _ = (function (){var statearr_65202 = state_65196;
(statearr_65202[(4)] = cljs.core.rest((state_65196[(4)])));

return statearr_65202;
})();
var state_65196__$1 = state_65196;
var ex65200 = (state_65196__$1[(2)]);
var statearr_65203_65215 = state_65196__$1;
(statearr_65203_65215[(5)] = ex65200);


if((ex65200 instanceof Error)){
var statearr_65204_65216 = state_65196__$1;
(statearr_65204_65216[(1)] = (4));

(statearr_65204_65216[(5)] = null);

} else {
throw ex65200;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65197 === (6))){
var inst_65179 = (state_65196[(2)]);
var inst_65180 = fluree.db.util.async.throw_err(inst_65179);
var inst_65181 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_65180);
var inst_65182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65183 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65185 = [inst_65180];
var inst_65186 = (new cljs.core.PersistentVector(null,1,(5),inst_65184,inst_65185,null));
var inst_65187 = ["subs",inst_65186,inst_65181];
var inst_65188 = cljs.core.PersistentHashMap.fromArrays(inst_65183,inst_65187);
var inst_65189 = [inst_65188,(30)];
var inst_65190 = (new cljs.core.PersistentVector(null,2,(5),inst_65182,inst_65189,null));
var inst_65191 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65190);
var _ = (function (){var statearr_65205 = state_65196;
(statearr_65205[(4)] = cljs.core.rest((state_65196[(4)])));

return statearr_65205;
})();
var state_65196__$1 = (function (){var statearr_65206 = state_65196;
(statearr_65206[(7)] = inst_65191);

return statearr_65206;
})();
var statearr_65207_65217 = state_65196__$1;
(statearr_65207_65217[(2)] = inst_65181);

(statearr_65207_65217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0 = (function (){
var statearr_65208 = [null,null,null,null,null,null,null,null];
(statearr_65208[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__);

(statearr_65208[(1)] = (1));

return statearr_65208;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1 = (function (state_65196){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65196);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65209){var ex__2687__auto__ = e65209;
var statearr_65210_65218 = state_65196;
(statearr_65210_65218[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65196[(4)]))){
var statearr_65211_65219 = state_65196;
(statearr_65211_65219[(1)] = cljs.core.first((state_65196[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65220 = state_65196;
state_65196 = G__65220;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = function(state_65196){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1.call(this,state_65196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65212 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65212[(6)] = c__2706__auto__);

return statearr_65212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65250){
var state_val_65251 = (state_65250[(1)]);
if((state_val_65251 === (7))){
var state_65250__$1 = state_65250;
var statearr_65252_65271 = state_65250__$1;
(statearr_65252_65271[(2)] = str);

(statearr_65252_65271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65251 === (1))){
var state_65250__$1 = state_65250;
var statearr_65253_65272 = state_65250__$1;
(statearr_65253_65272[(2)] = null);

(statearr_65253_65272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65251 === (4))){
var inst_65221 = (state_65250[(2)]);
var state_65250__$1 = state_65250;
var statearr_65254_65273 = state_65250__$1;
(statearr_65254_65273[(2)] = inst_65221);

(statearr_65254_65273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65251 === (6))){
var state_65250__$1 = state_65250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65250__$1,(9),str);
} else {
if((state_val_65251 === (3))){
var inst_65248 = (state_65250[(2)]);
var state_65250__$1 = state_65250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65250__$1,inst_65248);
} else {
if((state_val_65251 === (2))){
var _ = (function (){var statearr_65256 = state_65250;
(statearr_65256[(4)] = cljs.core.cons((5),(state_65250[(4)])));

return statearr_65256;
})();
var inst_65227 = fluree.db.util.async.channel_QMARK_(str);
var state_65250__$1 = state_65250;
if(inst_65227){
var statearr_65257_65274 = state_65250__$1;
(statearr_65257_65274[(1)] = (6));

} else {
var statearr_65258_65275 = state_65250__$1;
(statearr_65258_65275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65251 === (9))){
var inst_65230 = (state_65250[(2)]);
var inst_65231 = fluree.db.util.async.throw_err(inst_65230);
var state_65250__$1 = state_65250;
var statearr_65259_65276 = state_65250__$1;
(statearr_65259_65276[(2)] = inst_65231);

(statearr_65259_65276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65251 === (5))){
var _ = (function (){var statearr_65260 = state_65250;
(statearr_65260[(4)] = cljs.core.rest((state_65250[(4)])));

return statearr_65260;
})();
var state_65250__$1 = state_65250;
var ex65255 = (state_65250__$1[(2)]);
var statearr_65261_65277 = state_65250__$1;
(statearr_65261_65277[(5)] = ex65255);


if((ex65255 instanceof Error)){
var statearr_65262_65278 = state_65250__$1;
(statearr_65262_65278[(1)] = (4));

(statearr_65262_65278[(5)] = null);

} else {
throw ex65255;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65251 === (8))){
var inst_65234 = (state_65250[(2)]);
var inst_65235 = fluree.db.dbfunctions.internal.lower_case(inst_65234);
var inst_65236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65237 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65239 = [inst_65234];
var inst_65240 = (new cljs.core.PersistentVector(null,1,(5),inst_65238,inst_65239,null));
var inst_65241 = ["lower-case",inst_65240,inst_65235];
var inst_65242 = cljs.core.PersistentHashMap.fromArrays(inst_65237,inst_65241);
var inst_65243 = [inst_65242,(10)];
var inst_65244 = (new cljs.core.PersistentVector(null,2,(5),inst_65236,inst_65243,null));
var inst_65245 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65244);
var _ = (function (){var statearr_65263 = state_65250;
(statearr_65263[(4)] = cljs.core.rest((state_65250[(4)])));

return statearr_65263;
})();
var state_65250__$1 = (function (){var statearr_65264 = state_65250;
(statearr_65264[(7)] = inst_65245);

return statearr_65264;
})();
var statearr_65265_65279 = state_65250__$1;
(statearr_65265_65279[(2)] = inst_65235);

(statearr_65265_65279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0 = (function (){
var statearr_65266 = [null,null,null,null,null,null,null,null];
(statearr_65266[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__);

(statearr_65266[(1)] = (1));

return statearr_65266;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1 = (function (state_65250){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65250);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65267){var ex__2687__auto__ = e65267;
var statearr_65268_65280 = state_65250;
(statearr_65268_65280[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65250[(4)]))){
var statearr_65269_65281 = state_65250;
(statearr_65269_65281[(1)] = cljs.core.first((state_65250[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65282 = state_65250;
state_65250 = G__65282;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = function(state_65250){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1.call(this,state_65250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65270 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65270[(6)] = c__2706__auto__);

return statearr_65270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65312){
var state_val_65313 = (state_65312[(1)]);
if((state_val_65313 === (7))){
var state_65312__$1 = state_65312;
var statearr_65314_65333 = state_65312__$1;
(statearr_65314_65333[(2)] = str);

(statearr_65314_65333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65313 === (1))){
var state_65312__$1 = state_65312;
var statearr_65315_65334 = state_65312__$1;
(statearr_65315_65334[(2)] = null);

(statearr_65315_65334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65313 === (4))){
var inst_65283 = (state_65312[(2)]);
var state_65312__$1 = state_65312;
var statearr_65316_65335 = state_65312__$1;
(statearr_65316_65335[(2)] = inst_65283);

(statearr_65316_65335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65313 === (6))){
var state_65312__$1 = state_65312;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65312__$1,(9),str);
} else {
if((state_val_65313 === (3))){
var inst_65310 = (state_65312[(2)]);
var state_65312__$1 = state_65312;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65312__$1,inst_65310);
} else {
if((state_val_65313 === (2))){
var _ = (function (){var statearr_65318 = state_65312;
(statearr_65318[(4)] = cljs.core.cons((5),(state_65312[(4)])));

return statearr_65318;
})();
var inst_65289 = fluree.db.util.async.channel_QMARK_(str);
var state_65312__$1 = state_65312;
if(inst_65289){
var statearr_65319_65336 = state_65312__$1;
(statearr_65319_65336[(1)] = (6));

} else {
var statearr_65320_65337 = state_65312__$1;
(statearr_65320_65337[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65313 === (9))){
var inst_65292 = (state_65312[(2)]);
var inst_65293 = fluree.db.util.async.throw_err(inst_65292);
var state_65312__$1 = state_65312;
var statearr_65321_65338 = state_65312__$1;
(statearr_65321_65338[(2)] = inst_65293);

(statearr_65321_65338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65313 === (5))){
var _ = (function (){var statearr_65322 = state_65312;
(statearr_65322[(4)] = cljs.core.rest((state_65312[(4)])));

return statearr_65322;
})();
var state_65312__$1 = state_65312;
var ex65317 = (state_65312__$1[(2)]);
var statearr_65323_65339 = state_65312__$1;
(statearr_65323_65339[(5)] = ex65317);


if((ex65317 instanceof Error)){
var statearr_65324_65340 = state_65312__$1;
(statearr_65324_65340[(1)] = (4));

(statearr_65324_65340[(5)] = null);

} else {
throw ex65317;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65313 === (8))){
var inst_65296 = (state_65312[(2)]);
var inst_65297 = fluree.db.dbfunctions.internal.upper_case(inst_65296);
var inst_65298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65299 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65301 = [inst_65296];
var inst_65302 = (new cljs.core.PersistentVector(null,1,(5),inst_65300,inst_65301,null));
var inst_65303 = ["upper-case",inst_65302,inst_65297];
var inst_65304 = cljs.core.PersistentHashMap.fromArrays(inst_65299,inst_65303);
var inst_65305 = [inst_65304,(10)];
var inst_65306 = (new cljs.core.PersistentVector(null,2,(5),inst_65298,inst_65305,null));
var inst_65307 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65306);
var _ = (function (){var statearr_65325 = state_65312;
(statearr_65325[(4)] = cljs.core.rest((state_65312[(4)])));

return statearr_65325;
})();
var state_65312__$1 = (function (){var statearr_65326 = state_65312;
(statearr_65326[(7)] = inst_65307);

return statearr_65326;
})();
var statearr_65327_65341 = state_65312__$1;
(statearr_65327_65341[(2)] = inst_65297);

(statearr_65327_65341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0 = (function (){
var statearr_65328 = [null,null,null,null,null,null,null,null];
(statearr_65328[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__);

(statearr_65328[(1)] = (1));

return statearr_65328;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1 = (function (state_65312){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65312);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65329){var ex__2687__auto__ = e65329;
var statearr_65330_65342 = state_65312;
(statearr_65330_65342[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65312[(4)]))){
var statearr_65331_65343 = state_65312;
(statearr_65331_65343[(1)] = cljs.core.first((state_65312[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65344 = state_65312;
state_65312 = G__65344;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = function(state_65312){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1.call(this,state_65312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65332 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65332[(6)] = c__2706__auto__);

return statearr_65332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__65346 = arguments.length;
switch (G__65346) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65374){
var state_val_65375 = (state_65374[(1)]);
if((state_val_65375 === (1))){
var state_65374__$1 = state_65374;
var statearr_65376_65392 = state_65374__$1;
(statearr_65376_65392[(2)] = null);

(statearr_65376_65392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65375 === (2))){
var _ = (function (){var statearr_65377 = state_65374;
(statearr_65377[(4)] = cljs.core.cons((5),(state_65374[(4)])));

return statearr_65377;
})();
var inst_65356 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_65374__$1 = state_65374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65374__$1,(6),inst_65356);
} else {
if((state_val_65375 === (3))){
var inst_65372 = (state_65374[(2)]);
var state_65374__$1 = state_65374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65374__$1,inst_65372);
} else {
if((state_val_65375 === (4))){
var inst_65347 = (state_65374[(2)]);
var state_65374__$1 = state_65374;
var statearr_65379_65393 = state_65374__$1;
(statearr_65379_65393[(2)] = inst_65347);

(statearr_65379_65393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65375 === (5))){
var _ = (function (){var statearr_65380 = state_65374;
(statearr_65380[(4)] = cljs.core.rest((state_65374[(4)])));

return statearr_65380;
})();
var state_65374__$1 = state_65374;
var ex65378 = (state_65374__$1[(2)]);
var statearr_65381_65394 = state_65374__$1;
(statearr_65381_65394[(5)] = ex65378);


if((ex65378 instanceof Error)){
var statearr_65382_65395 = state_65374__$1;
(statearr_65382_65395[(1)] = (4));

(statearr_65382_65395[(5)] = null);

} else {
throw ex65378;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65375 === (6))){
var inst_65358 = (state_65374[(2)]);
var inst_65359 = fluree.db.util.async.throw_err(inst_65358);
var inst_65360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65359,(0),null);
var inst_65361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65359,(1),null);
var inst_65362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65363 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65364 = ["?s","?ctx",inst_65360];
var inst_65365 = cljs.core.PersistentHashMap.fromArrays(inst_65363,inst_65364);
var inst_65366 = ((10) + inst_65361);
var inst_65367 = [inst_65365,inst_65366];
var inst_65368 = (new cljs.core.PersistentVector(null,2,(5),inst_65362,inst_65367,null));
var inst_65369 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65368);
var _ = (function (){var statearr_65383 = state_65374;
(statearr_65383[(4)] = cljs.core.rest((state_65374[(4)])));

return statearr_65383;
})();
var state_65374__$1 = (function (){var statearr_65384 = state_65374;
(statearr_65384[(7)] = inst_65369);

return statearr_65384;
})();
var statearr_65385_65396 = state_65374__$1;
(statearr_65385_65396[(2)] = inst_65360);

(statearr_65385_65396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65386 = [null,null,null,null,null,null,null,null];
(statearr_65386[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65386[(1)] = (1));

return statearr_65386;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65374){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65374);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65387){var ex__2687__auto__ = e65387;
var statearr_65388_65397 = state_65374;
(statearr_65388_65397[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65374[(4)]))){
var statearr_65389_65398 = state_65374;
(statearr_65389_65398[(1)] = cljs.core.first((state_65374[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65399 = state_65374;
state_65374 = G__65399;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65374){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65390 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65390[(6)] = c__2706__auto__);

return statearr_65390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__65401 = arguments.length;
switch (G__65401) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65439){
var state_val_65440 = (state_65439[(1)]);
if((state_val_65440 === (7))){
var inst_65432 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_65439__$1 = state_65439;
var statearr_65441_65461 = state_65439__$1;
(statearr_65441_65461[(2)] = inst_65432);

(statearr_65441_65461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (1))){
var state_65439__$1 = state_65439;
var statearr_65442_65462 = state_65439__$1;
(statearr_65442_65462[(2)] = null);

(statearr_65442_65462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (4))){
var inst_65402 = (state_65439[(2)]);
var state_65439__$1 = state_65439;
var statearr_65443_65463 = state_65439__$1;
(statearr_65443_65463[(2)] = inst_65402);

(statearr_65443_65463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (6))){
var inst_65413 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_65439__$1 = state_65439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65439__$1,(10),inst_65413);
} else {
if((state_val_65440 === (3))){
var inst_65437 = (state_65439[(2)]);
var state_65439__$1 = state_65439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65439__$1,inst_65437);
} else {
if((state_val_65440 === (2))){
var _ = (function (){var statearr_65445 = state_65439;
(statearr_65445[(4)] = cljs.core.cons((5),(state_65439[(4)])));

return statearr_65445;
})();
var inst_65408 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65439__$1 = state_65439;
if(cljs.core.truth_(inst_65408)){
var statearr_65446_65464 = state_65439__$1;
(statearr_65446_65464[(1)] = (6));

} else {
var statearr_65447_65465 = state_65439__$1;
(statearr_65447_65465[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (9))){
var inst_65419 = (state_65439[(2)]);
var inst_65420 = fluree.db.util.async.throw_err(inst_65419);
var inst_65421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65420,(0),null);
var inst_65422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65420,(1),null);
var inst_65423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65424 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65425 = ["?p","?ctx",inst_65421];
var inst_65426 = cljs.core.PersistentHashMap.fromArrays(inst_65424,inst_65425);
var inst_65427 = ((10) + inst_65422);
var inst_65428 = [inst_65426,inst_65427];
var inst_65429 = (new cljs.core.PersistentVector(null,2,(5),inst_65423,inst_65428,null));
var inst_65430 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65429);
var state_65439__$1 = (function (){var statearr_65448 = state_65439;
(statearr_65448[(7)] = inst_65430);

return statearr_65448;
})();
var statearr_65449_65466 = state_65439__$1;
(statearr_65449_65466[(2)] = inst_65421);

(statearr_65449_65466[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (5))){
var _ = (function (){var statearr_65450 = state_65439;
(statearr_65450[(4)] = cljs.core.rest((state_65439[(4)])));

return statearr_65450;
})();
var state_65439__$1 = state_65439;
var ex65444 = (state_65439__$1[(2)]);
var statearr_65451_65467 = state_65439__$1;
(statearr_65451_65467[(5)] = ex65444);


if((ex65444 instanceof Error)){
var statearr_65452_65468 = state_65439__$1;
(statearr_65452_65468[(1)] = (4));

(statearr_65452_65468[(5)] = null);

} else {
throw ex65444;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65440 === (10))){
var inst_65415 = (state_65439[(2)]);
var inst_65416 = fluree.db.util.async.throw_err(inst_65415);
var inst_65417 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_65416);
var state_65439__$1 = state_65439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65439__$1,(9),inst_65417);
} else {
if((state_val_65440 === (8))){
var inst_65434 = (state_65439[(2)]);
var _ = (function (){var statearr_65453 = state_65439;
(statearr_65453[(4)] = cljs.core.rest((state_65439[(4)])));

return statearr_65453;
})();
var state_65439__$1 = state_65439;
var statearr_65454_65469 = state_65439__$1;
(statearr_65454_65469[(2)] = inst_65434);

(statearr_65454_65469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65455 = [null,null,null,null,null,null,null,null];
(statearr_65455[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65455[(1)] = (1));

return statearr_65455;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65439){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65439);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65456){var ex__2687__auto__ = e65456;
var statearr_65457_65470 = state_65439;
(statearr_65457_65470[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65439[(4)]))){
var statearr_65458_65471 = state_65439;
(statearr_65458_65471[(1)] = cljs.core.first((state_65439[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65472 = state_65439;
state_65439 = G__65472;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65439){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65459 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65459[(6)] = c__2706__auto__);

return statearr_65459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65521 = arguments.length;
var i__5770__auto___65522 = (0);
while(true){
if((i__5770__auto___65522 < len__5769__auto___65521)){
args__5775__auto__.push((arguments[i__5770__auto___65522]));

var G__65523 = (i__5770__auto___65522 + (1));
i__5770__auto___65522 = G__65523;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65504){
var state_val_65505 = (state_65504[(1)]);
if((state_val_65505 === (1))){
var state_65504__$1 = state_65504;
var statearr_65506_65524 = state_65504__$1;
(statearr_65506_65524[(2)] = null);

(statearr_65506_65524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65505 === (2))){
var _ = (function (){var statearr_65507 = state_65504;
(statearr_65507[(4)] = cljs.core.cons((5),(state_65504[(4)])));

return statearr_65507;
})();
var inst_65481 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65504__$1 = state_65504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65504__$1,(6),inst_65481);
} else {
if((state_val_65505 === (3))){
var inst_65502 = (state_65504[(2)]);
var state_65504__$1 = state_65504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65504__$1,inst_65502);
} else {
if((state_val_65505 === (4))){
var inst_65475 = (state_65504[(2)]);
var state_65504__$1 = state_65504;
var statearr_65509_65525 = state_65504__$1;
(statearr_65509_65525[(2)] = inst_65475);

(statearr_65509_65525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65505 === (5))){
var _ = (function (){var statearr_65510 = state_65504;
(statearr_65510[(4)] = cljs.core.rest((state_65504[(4)])));

return statearr_65510;
})();
var state_65504__$1 = state_65504;
var ex65508 = (state_65504__$1[(2)]);
var statearr_65511_65526 = state_65504__$1;
(statearr_65511_65526[(5)] = ex65508);


if((ex65508 instanceof Error)){
var statearr_65512_65527 = state_65504__$1;
(statearr_65512_65527[(1)] = (4));

(statearr_65512_65527[(5)] = null);

} else {
throw ex65508;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65505 === (6))){
var inst_65483 = (state_65504[(2)]);
var inst_65484 = fluree.db.util.async.throw_err(inst_65483);
var inst_65485 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_65484);
var inst_65486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65487 = [inst_65484];
var inst_65488 = (new cljs.core.PersistentVector(null,1,(5),inst_65486,inst_65487,null));
var inst_65489 = cljs.core.count(inst_65488);
var inst_65490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65491 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65493 = [inst_65484];
var inst_65494 = (new cljs.core.PersistentVector(null,1,(5),inst_65492,inst_65493,null));
var inst_65495 = ["and",inst_65494,inst_65485];
var inst_65496 = cljs.core.PersistentHashMap.fromArrays(inst_65491,inst_65495);
var inst_65497 = [inst_65496,inst_65489];
var inst_65498 = (new cljs.core.PersistentVector(null,2,(5),inst_65490,inst_65497,null));
var inst_65499 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65498);
var _ = (function (){var statearr_65513 = state_65504;
(statearr_65513[(4)] = cljs.core.rest((state_65504[(4)])));

return statearr_65513;
})();
var state_65504__$1 = (function (){var statearr_65514 = state_65504;
(statearr_65514[(7)] = inst_65499);

return statearr_65514;
})();
var statearr_65515_65528 = state_65504__$1;
(statearr_65515_65528[(2)] = inst_65485);

(statearr_65515_65528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65516 = [null,null,null,null,null,null,null,null];
(statearr_65516[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65516[(1)] = (1));

return statearr_65516;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65504){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65504);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65517){var ex__2687__auto__ = e65517;
var statearr_65518_65529 = state_65504;
(statearr_65518_65529[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65504[(4)]))){
var statearr_65519_65530 = state_65504;
(statearr_65519_65530[(1)] = cljs.core.first((state_65504[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65531 = state_65504;
state_65504 = G__65531;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65504){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65520 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65520[(6)] = c__2706__auto__);

return statearr_65520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq65473){
var G__65474 = cljs.core.first(seq65473);
var seq65473__$1 = cljs.core.next(seq65473);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65474,seq65473__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65580 = arguments.length;
var i__5770__auto___65581 = (0);
while(true){
if((i__5770__auto___65581 < len__5769__auto___65580)){
args__5775__auto__.push((arguments[i__5770__auto___65581]));

var G__65582 = (i__5770__auto___65581 + (1));
i__5770__auto___65581 = G__65582;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65563){
var state_val_65564 = (state_65563[(1)]);
if((state_val_65564 === (1))){
var state_65563__$1 = state_65563;
var statearr_65565_65583 = state_65563__$1;
(statearr_65565_65583[(2)] = null);

(statearr_65565_65583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65564 === (2))){
var _ = (function (){var statearr_65566 = state_65563;
(statearr_65566[(4)] = cljs.core.cons((5),(state_65563[(4)])));

return statearr_65566;
})();
var inst_65540 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65563__$1 = state_65563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65563__$1,(6),inst_65540);
} else {
if((state_val_65564 === (3))){
var inst_65561 = (state_65563[(2)]);
var state_65563__$1 = state_65563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65563__$1,inst_65561);
} else {
if((state_val_65564 === (4))){
var inst_65534 = (state_65563[(2)]);
var state_65563__$1 = state_65563;
var statearr_65568_65584 = state_65563__$1;
(statearr_65568_65584[(2)] = inst_65534);

(statearr_65568_65584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65564 === (5))){
var _ = (function (){var statearr_65569 = state_65563;
(statearr_65569[(4)] = cljs.core.rest((state_65563[(4)])));

return statearr_65569;
})();
var state_65563__$1 = state_65563;
var ex65567 = (state_65563__$1[(2)]);
var statearr_65570_65585 = state_65563__$1;
(statearr_65570_65585[(5)] = ex65567);


if((ex65567 instanceof Error)){
var statearr_65571_65586 = state_65563__$1;
(statearr_65571_65586[(1)] = (4));

(statearr_65571_65586[(5)] = null);

} else {
throw ex65567;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65564 === (6))){
var inst_65542 = (state_65563[(2)]);
var inst_65543 = fluree.db.util.async.throw_err(inst_65542);
var inst_65544 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_65543);
var inst_65545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65546 = [inst_65543];
var inst_65547 = (new cljs.core.PersistentVector(null,1,(5),inst_65545,inst_65546,null));
var inst_65548 = cljs.core.count(inst_65547);
var inst_65549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65550 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65552 = [inst_65543];
var inst_65553 = (new cljs.core.PersistentVector(null,1,(5),inst_65551,inst_65552,null));
var inst_65554 = ["or",inst_65553,inst_65544];
var inst_65555 = cljs.core.PersistentHashMap.fromArrays(inst_65550,inst_65554);
var inst_65556 = [inst_65555,inst_65548];
var inst_65557 = (new cljs.core.PersistentVector(null,2,(5),inst_65549,inst_65556,null));
var inst_65558 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65557);
var _ = (function (){var statearr_65572 = state_65563;
(statearr_65572[(4)] = cljs.core.rest((state_65563[(4)])));

return statearr_65572;
})();
var state_65563__$1 = (function (){var statearr_65573 = state_65563;
(statearr_65573[(7)] = inst_65558);

return statearr_65573;
})();
var statearr_65574_65587 = state_65563__$1;
(statearr_65574_65587[(2)] = inst_65544);

(statearr_65574_65587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_65575 = [null,null,null,null,null,null,null,null];
(statearr_65575[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_65575[(1)] = (1));

return statearr_65575;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_65563){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65563);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65576){var ex__2687__auto__ = e65576;
var statearr_65577_65588 = state_65563;
(statearr_65577_65588[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65563[(4)]))){
var statearr_65578_65589 = state_65563;
(statearr_65578_65589[(1)] = cljs.core.first((state_65563[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65590 = state_65563;
state_65563 = G__65590;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_65563){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_65563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65579 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65579[(6)] = c__2706__auto__);

return statearr_65579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq65532){
var G__65533 = cljs.core.first(seq65532);
var seq65532__$1 = cljs.core.next(seq65532);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65533,seq65532__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65628){
var state_val_65629 = (state_65628[(1)]);
if((state_val_65629 === (7))){
var inst_65604 = fluree.db.util.async.channel_QMARK_(coll);
var state_65628__$1 = state_65628;
if(inst_65604){
var statearr_65630_65653 = state_65628__$1;
(statearr_65630_65653[(1)] = (10));

} else {
var statearr_65631_65654 = state_65628__$1;
(statearr_65631_65654[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (1))){
var state_65628__$1 = state_65628;
var statearr_65632_65655 = state_65628__$1;
(statearr_65632_65655[(2)] = null);

(statearr_65632_65655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (4))){
var inst_65591 = (state_65628[(2)]);
var state_65628__$1 = state_65628;
var statearr_65633_65656 = state_65628__$1;
(statearr_65633_65656[(2)] = inst_65591);

(statearr_65633_65656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (13))){
var inst_65607 = (state_65628[(2)]);
var inst_65608 = fluree.db.util.async.throw_err(inst_65607);
var state_65628__$1 = state_65628;
var statearr_65634_65657 = state_65628__$1;
(statearr_65634_65657[(2)] = inst_65608);

(statearr_65634_65657[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (6))){
var inst_65599 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_65628__$1 = state_65628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65628__$1,(9),inst_65599);
} else {
if((state_val_65629 === (3))){
var inst_65626 = (state_65628[(2)]);
var state_65628__$1 = state_65628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65628__$1,inst_65626);
} else {
if((state_val_65629 === (12))){
var inst_65611 = (state_65628[(2)]);
var state_65628__$1 = state_65628;
var statearr_65635_65658 = state_65628__$1;
(statearr_65635_65658[(2)] = inst_65611);

(statearr_65635_65658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (2))){
var _ = (function (){var statearr_65636 = state_65628;
(statearr_65636[(4)] = cljs.core.cons((5),(state_65628[(4)])));

return statearr_65636;
})();
var inst_65597 = cljs.core.vector_QMARK_(coll);
var state_65628__$1 = state_65628;
if(inst_65597){
var statearr_65637_65659 = state_65628__$1;
(statearr_65637_65659[(1)] = (6));

} else {
var statearr_65638_65660 = state_65628__$1;
(statearr_65638_65660[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (11))){
var state_65628__$1 = state_65628;
var statearr_65640_65661 = state_65628__$1;
(statearr_65640_65661[(2)] = coll);

(statearr_65640_65661[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (9))){
var inst_65601 = (state_65628[(2)]);
var inst_65602 = fluree.db.util.async.throw_err(inst_65601);
var state_65628__$1 = state_65628;
var statearr_65641_65662 = state_65628__$1;
(statearr_65641_65662[(2)] = inst_65602);

(statearr_65641_65662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (5))){
var _ = (function (){var statearr_65642 = state_65628;
(statearr_65642[(4)] = cljs.core.rest((state_65628[(4)])));

return statearr_65642;
})();
var state_65628__$1 = state_65628;
var ex65639 = (state_65628__$1[(2)]);
var statearr_65643_65663 = state_65628__$1;
(statearr_65643_65663[(5)] = ex65639);


if((ex65639 instanceof Error)){
var statearr_65644_65664 = state_65628__$1;
(statearr_65644_65664[(1)] = (4));

(statearr_65644_65664[(5)] = null);

} else {
throw ex65639;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65629 === (10))){
var state_65628__$1 = state_65628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65628__$1,(13),coll);
} else {
if((state_val_65629 === (8))){
var inst_65613 = (state_65628[(2)]);
var inst_65614 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_65613);
var inst_65615 = cljs.core.count(inst_65614);
var inst_65616 = ((9) + inst_65615);
var inst_65617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65618 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65619 = ["count",inst_65613,inst_65615];
var inst_65620 = cljs.core.PersistentHashMap.fromArrays(inst_65618,inst_65619);
var inst_65621 = [inst_65620,inst_65616];
var inst_65622 = (new cljs.core.PersistentVector(null,2,(5),inst_65617,inst_65621,null));
var inst_65623 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65622);
var _ = (function (){var statearr_65645 = state_65628;
(statearr_65645[(4)] = cljs.core.rest((state_65628[(4)])));

return statearr_65645;
})();
var state_65628__$1 = (function (){var statearr_65646 = state_65628;
(statearr_65646[(7)] = inst_65623);

return statearr_65646;
})();
var statearr_65647_65665 = state_65628__$1;
(statearr_65647_65665[(2)] = inst_65615);

(statearr_65647_65665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0 = (function (){
var statearr_65648 = [null,null,null,null,null,null,null,null];
(statearr_65648[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__);

(statearr_65648[(1)] = (1));

return statearr_65648;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1 = (function (state_65628){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65628);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65649){var ex__2687__auto__ = e65649;
var statearr_65650_65666 = state_65628;
(statearr_65650_65666[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65628[(4)]))){
var statearr_65651_65667 = state_65628;
(statearr_65651_65667[(1)] = cljs.core.first((state_65628[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65668 = state_65628;
state_65628 = G__65668;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = function(state_65628){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1.call(this,state_65628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65652 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65652[(6)] = c__2706__auto__);

return statearr_65652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__65669,subject,pred){
var map__65670 = p__65669;
var map__65670__$1 = cljs.core.__destructure_map(map__65670);
var _QMARK_ctx = map__65670__$1;
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65670__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65670__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65761){
var state_val_65762 = (state_65761[(1)]);
if((state_val_65762 === (7))){
var state_65761__$1 = state_65761;
var statearr_65763_65819 = state_65761__$1;
(statearr_65763_65819[(2)] = subject);

(statearr_65763_65819[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (20))){
var state_65761__$1 = state_65761;
var statearr_65764_65820 = state_65761__$1;
(statearr_65764_65820[(2)] = cache);

(statearr_65764_65820[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (27))){
var inst_65692 = (state_65761[(7)]);
var inst_65704 = (state_65761[(8)]);
var inst_65718 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_65704,inst_65692);
var state_65761__$1 = state_65761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65761__$1,(29),inst_65718);
} else {
if((state_val_65762 === (1))){
var state_65761__$1 = state_65761;
var statearr_65765_65821 = state_65761__$1;
(statearr_65765_65821[(2)] = null);

(statearr_65765_65821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (24))){
var inst_65704 = (state_65761[(8)]);
var inst_65731 = cljs.core.int_QMARK_(inst_65704);
var state_65761__$1 = state_65761;
if(inst_65731){
var statearr_65766_65822 = state_65761__$1;
(statearr_65766_65822[(1)] = (30));

} else {
var statearr_65767_65823 = state_65761__$1;
(statearr_65767_65823[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (4))){
var inst_65671 = (state_65761[(2)]);
var state_65761__$1 = state_65761;
var statearr_65768_65824 = state_65761__$1;
(statearr_65768_65824[(2)] = inst_65671);

(statearr_65768_65824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (15))){
var inst_65684 = (state_65761[(9)]);
var state_65761__$1 = state_65761;
var statearr_65769_65825 = state_65761__$1;
(statearr_65769_65825[(2)] = inst_65684);

(statearr_65769_65825[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (21))){
var inst_65705 = (state_65761[(10)]);
var state_65761__$1 = state_65761;
var statearr_65770_65826 = state_65761__$1;
(statearr_65770_65826[(2)] = inst_65705);

(statearr_65770_65826[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (31))){
var state_65761__$1 = state_65761;
var statearr_65771_65827 = state_65761__$1;
(statearr_65771_65827[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (32))){
var inst_65744 = (state_65761[(2)]);
var state_65761__$1 = state_65761;
var statearr_65773_65828 = state_65761__$1;
(statearr_65773_65828[(2)] = inst_65744);

(statearr_65773_65828[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (33))){
var inst_65735 = (state_65761[(2)]);
var inst_65736 = fluree.db.util.async.throw_err(inst_65735);
var state_65761__$1 = state_65761;
var statearr_65774_65829 = state_65761__$1;
(statearr_65774_65829[(2)] = inst_65736);

(statearr_65774_65829[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (13))){
var inst_65688 = (state_65761[(2)]);
var inst_65689 = fluree.db.util.async.throw_err(inst_65688);
var state_65761__$1 = state_65761;
var statearr_65775_65830 = state_65761__$1;
(statearr_65775_65830[(2)] = inst_65689);

(statearr_65775_65830[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (22))){
var inst_65709 = (state_65761[(2)]);
var state_65761__$1 = state_65761;
if(cljs.core.truth_(inst_65709)){
var statearr_65776_65831 = state_65761__$1;
(statearr_65776_65831[(1)] = (23));

} else {
var statearr_65777_65832 = state_65761__$1;
(statearr_65777_65832[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (36))){
var inst_65742 = (state_65761[(2)]);
var state_65761__$1 = state_65761;
var statearr_65778_65833 = state_65761__$1;
(statearr_65778_65833[(2)] = inst_65742);

(statearr_65778_65833[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (29))){
var inst_65692 = (state_65761[(7)]);
var inst_65704 = (state_65761[(8)]);
var inst_65720 = (state_65761[(2)]);
var inst_65721 = fluree.db.util.async.throw_err(inst_65720);
var inst_65722 = cljs.core._deref(cache);
var inst_65723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65724 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_65704,inst_65692];
var inst_65725 = (new cljs.core.PersistentVector(null,3,(5),inst_65723,inst_65724,null));
var inst_65726 = cljs.core.assoc_in(inst_65722,inst_65725,inst_65721);
var inst_65727 = cljs.core._vreset_BANG_(cache,inst_65726);
var state_65761__$1 = (function (){var statearr_65779 = state_65761;
(statearr_65779[(11)] = inst_65727);

return statearr_65779;
})();
var statearr_65780_65834 = state_65761__$1;
(statearr_65780_65834[(2)] = inst_65721);

(statearr_65780_65834[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (6))){
var state_65761__$1 = state_65761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65761__$1,(9),subject);
} else {
if((state_val_65762 === (28))){
var inst_65729 = (state_65761[(2)]);
var state_65761__$1 = state_65761;
var statearr_65781_65835 = state_65761__$1;
(statearr_65781_65835[(2)] = inst_65729);

(statearr_65781_65835[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (25))){
var inst_65684 = (state_65761[(9)]);
var inst_65692 = (state_65761[(7)]);
var inst_65746 = (state_65761[(2)]);
var inst_65747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65748 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65750 = [inst_65684,inst_65692];
var inst_65751 = (new cljs.core.PersistentVector(null,2,(5),inst_65749,inst_65750,null));
var inst_65752 = ["get",inst_65751,inst_65746];
var inst_65753 = cljs.core.PersistentHashMap.fromArrays(inst_65748,inst_65752);
var inst_65754 = [inst_65753,(10)];
var inst_65755 = (new cljs.core.PersistentVector(null,2,(5),inst_65747,inst_65754,null));
var inst_65756 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65755);
var _ = (function (){var statearr_65782 = state_65761;
(statearr_65782[(4)] = cljs.core.rest((state_65761[(4)])));

return statearr_65782;
})();
var state_65761__$1 = (function (){var statearr_65783 = state_65761;
(statearr_65783[(12)] = inst_65756);

return statearr_65783;
})();
var statearr_65784_65836 = state_65761__$1;
(statearr_65784_65836[(2)] = inst_65746);

(statearr_65784_65836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (34))){
var inst_65692 = (state_65761[(7)]);
var inst_65704 = (state_65761[(8)]);
var inst_65739 = fluree.db.dbfunctions.internal.get(inst_65704,inst_65692);
var state_65761__$1 = state_65761;
var statearr_65785_65837 = state_65761__$1;
(statearr_65785_65837[(2)] = inst_65739);

(statearr_65785_65837[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (17))){
var inst_65684 = (state_65761[(9)]);
var inst_65698 = cljs.core.first(inst_65684);
var state_65761__$1 = state_65761;
var statearr_65786_65838 = state_65761__$1;
(statearr_65786_65838[(2)] = inst_65698);

(statearr_65786_65838[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (3))){
var inst_65759 = (state_65761[(2)]);
var state_65761__$1 = state_65761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65761__$1,inst_65759);
} else {
if((state_val_65762 === (12))){
var inst_65684 = (state_65761[(9)]);
var inst_65692 = (state_65761[(2)]);
var inst_65693 = cljs.core.vector_QMARK_(inst_65684);
var state_65761__$1 = (function (){var statearr_65787 = state_65761;
(statearr_65787[(7)] = inst_65692);

return statearr_65787;
})();
if(inst_65693){
var statearr_65788_65839 = state_65761__$1;
(statearr_65788_65839[(1)] = (14));

} else {
var statearr_65789_65840 = state_65761__$1;
(statearr_65789_65840[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (2))){
var _ = (function (){var statearr_65790 = state_65761;
(statearr_65790[(4)] = cljs.core.cons((5),(state_65761[(4)])));

return statearr_65790;
})();
var inst_65677 = fluree.db.util.async.channel_QMARK_(subject);
var state_65761__$1 = state_65761;
if(inst_65677){
var statearr_65791_65841 = state_65761__$1;
(statearr_65791_65841[(1)] = (6));

} else {
var statearr_65792_65842 = state_65761__$1;
(statearr_65792_65842[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (23))){
var inst_65715 = (state_65761[(13)]);
var inst_65692 = (state_65761[(7)]);
var inst_65704 = (state_65761[(8)]);
var inst_65711 = cljs.core.deref(cache);
var inst_65712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65713 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_65704,inst_65692];
var inst_65714 = (new cljs.core.PersistentVector(null,3,(5),inst_65712,inst_65713,null));
var inst_65715__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_65711,inst_65714);
var state_65761__$1 = (function (){var statearr_65793 = state_65761;
(statearr_65793[(13)] = inst_65715__$1);

return statearr_65793;
})();
if(cljs.core.truth_(inst_65715__$1)){
var statearr_65794_65843 = state_65761__$1;
(statearr_65794_65843[(1)] = (26));

} else {
var statearr_65795_65844 = state_65761__$1;
(statearr_65795_65844[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (35))){
var state_65761__$1 = state_65761;
var statearr_65796_65845 = state_65761__$1;
(statearr_65796_65845[(2)] = null);

(statearr_65796_65845[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (19))){
var inst_65701 = (state_65761[(2)]);
var state_65761__$1 = state_65761;
var statearr_65797_65846 = state_65761__$1;
(statearr_65797_65846[(2)] = inst_65701);

(statearr_65797_65846[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (11))){
var state_65761__$1 = state_65761;
var statearr_65799_65847 = state_65761__$1;
(statearr_65799_65847[(2)] = pred);

(statearr_65799_65847[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (9))){
var inst_65680 = (state_65761[(2)]);
var inst_65681 = fluree.db.util.async.throw_err(inst_65680);
var state_65761__$1 = state_65761;
var statearr_65800_65848 = state_65761__$1;
(statearr_65800_65848[(2)] = inst_65681);

(statearr_65800_65848[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (5))){
var _ = (function (){var statearr_65801 = state_65761;
(statearr_65801[(4)] = cljs.core.rest((state_65761[(4)])));

return statearr_65801;
})();
var state_65761__$1 = state_65761;
var ex65798 = (state_65761__$1[(2)]);
var statearr_65802_65849 = state_65761__$1;
(statearr_65802_65849[(5)] = ex65798);


if((ex65798 instanceof Error)){
var statearr_65803_65850 = state_65761__$1;
(statearr_65803_65850[(1)] = (4));

(statearr_65803_65850[(5)] = null);

} else {
throw ex65798;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (14))){
var inst_65684 = (state_65761[(9)]);
var inst_65695 = cljs.core.count(inst_65684);
var inst_65696 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65695);
var state_65761__$1 = state_65761;
if(inst_65696){
var statearr_65804_65851 = state_65761__$1;
(statearr_65804_65851[(1)] = (17));

} else {
var statearr_65805_65852 = state_65761__$1;
(statearr_65805_65852[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (26))){
var inst_65715 = (state_65761[(13)]);
var state_65761__$1 = state_65761;
var statearr_65806_65853 = state_65761__$1;
(statearr_65806_65853[(2)] = inst_65715);

(statearr_65806_65853[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (16))){
var inst_65705 = (state_65761[(10)]);
var inst_65704 = (state_65761[(8)]);
var inst_65704__$1 = (state_65761[(2)]);
var inst_65705__$1 = cljs.core.int_QMARK_(inst_65704__$1);
var state_65761__$1 = (function (){var statearr_65807 = state_65761;
(statearr_65807[(10)] = inst_65705__$1);

(statearr_65807[(8)] = inst_65704__$1);

return statearr_65807;
})();
if(inst_65705__$1){
var statearr_65808_65854 = state_65761__$1;
(statearr_65808_65854[(1)] = (20));

} else {
var statearr_65809_65855 = state_65761__$1;
(statearr_65809_65855[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (30))){
var inst_65692 = (state_65761[(7)]);
var inst_65704 = (state_65761[(8)]);
var inst_65733 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_65704,inst_65692);
var state_65761__$1 = state_65761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65761__$1,(33),inst_65733);
} else {
if((state_val_65762 === (10))){
var state_65761__$1 = state_65761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65761__$1,(13),pred);
} else {
if((state_val_65762 === (18))){
var inst_65684 = (state_65761[(9)]);
var state_65761__$1 = state_65761;
var statearr_65810_65856 = state_65761__$1;
(statearr_65810_65856[(2)] = inst_65684);

(statearr_65810_65856[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65762 === (8))){
var inst_65684 = (state_65761[(2)]);
var inst_65685 = fluree.db.util.async.channel_QMARK_(pred);
var state_65761__$1 = (function (){var statearr_65811 = state_65761;
(statearr_65811[(9)] = inst_65684);

return statearr_65811;
})();
if(inst_65685){
var statearr_65812_65857 = state_65761__$1;
(statearr_65812_65857[(1)] = (10));

} else {
var statearr_65813_65858 = state_65761__$1;
(statearr_65813_65858[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0 = (function (){
var statearr_65814 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65814[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__);

(statearr_65814[(1)] = (1));

return statearr_65814;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1 = (function (state_65761){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65761);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65815){var ex__2687__auto__ = e65815;
var statearr_65816_65859 = state_65761;
(statearr_65816_65859[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65761[(4)]))){
var statearr_65817_65860 = state_65761;
(statearr_65817_65860[(1)] = cljs.core.first((state_65761[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65861 = state_65761;
state_65761 = G__65861;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = function(state_65761){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1.call(this,state_65761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65818 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65818[(6)] = c__2706__auto__);

return statearr_65818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65900){
var state_val_65901 = (state_65900[(1)]);
if((state_val_65901 === (7))){
var inst_65868 = (state_65900[(7)]);
var state_65900__$1 = state_65900;
var statearr_65902_65926 = state_65900__$1;
(statearr_65902_65926[(2)] = inst_65868);

(statearr_65902_65926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (1))){
var state_65900__$1 = state_65900;
var statearr_65903_65927 = state_65900__$1;
(statearr_65903_65927[(2)] = null);

(statearr_65903_65927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (4))){
var inst_65862 = (state_65900[(2)]);
var state_65900__$1 = state_65900;
var statearr_65904_65928 = state_65900__$1;
(statearr_65904_65928[(2)] = inst_65862);

(statearr_65904_65928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (6))){
var inst_65870 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65900__$1 = state_65900;
var statearr_65905_65929 = state_65900__$1;
(statearr_65905_65929[(2)] = inst_65870);

(statearr_65905_65929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (3))){
var inst_65898 = (state_65900[(2)]);
var state_65900__$1 = state_65900;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65900__$1,inst_65898);
} else {
if((state_val_65901 === (12))){
var inst_65880 = (state_65900[(2)]);
var inst_65881 = fluree.db.util.async.throw_err(inst_65880);
var inst_65882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65881,(0),null);
var inst_65883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65881,(1),null);
var inst_65884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65885 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65886 = ["?pO","?ctx",inst_65882];
var inst_65887 = cljs.core.PersistentHashMap.fromArrays(inst_65885,inst_65886);
var inst_65888 = ((10) + inst_65883);
var inst_65889 = [inst_65887,inst_65888];
var inst_65890 = (new cljs.core.PersistentVector(null,2,(5),inst_65884,inst_65889,null));
var inst_65891 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65890);
var state_65900__$1 = (function (){var statearr_65906 = state_65900;
(statearr_65906[(8)] = inst_65891);

return statearr_65906;
})();
var statearr_65907_65930 = state_65900__$1;
(statearr_65907_65930[(2)] = inst_65882);

(statearr_65907_65930[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (2))){
var inst_65868 = (state_65900[(7)]);
var _ = (function (){var statearr_65908 = state_65900;
(statearr_65908[(4)] = cljs.core.cons((5),(state_65900[(4)])));

return statearr_65908;
})();
var inst_65868__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65900__$1 = (function (){var statearr_65909 = state_65900;
(statearr_65909[(7)] = inst_65868__$1);

return statearr_65909;
})();
if(cljs.core.truth_(inst_65868__$1)){
var statearr_65910_65931 = state_65900__$1;
(statearr_65910_65931[(1)] = (6));

} else {
var statearr_65911_65932 = state_65900__$1;
(statearr_65911_65932[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (11))){
var inst_65895 = (state_65900[(2)]);
var _ = (function (){var statearr_65913 = state_65900;
(statearr_65913[(4)] = cljs.core.rest((state_65900[(4)])));

return statearr_65913;
})();
var state_65900__$1 = state_65900;
var statearr_65914_65933 = state_65900__$1;
(statearr_65914_65933[(2)] = inst_65895);

(statearr_65914_65933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (9))){
var inst_65878 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_65900__$1 = state_65900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65900__$1,(12),inst_65878);
} else {
if((state_val_65901 === (5))){
var _ = (function (){var statearr_65915 = state_65900;
(statearr_65915[(4)] = cljs.core.rest((state_65900[(4)])));

return statearr_65915;
})();
var state_65900__$1 = state_65900;
var ex65912 = (state_65900__$1[(2)]);
var statearr_65916_65934 = state_65900__$1;
(statearr_65916_65934[(5)] = ex65912);


if((ex65912 instanceof Error)){
var statearr_65917_65935 = state_65900__$1;
(statearr_65917_65935[(1)] = (4));

(statearr_65917_65935[(5)] = null);

} else {
throw ex65912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (10))){
var inst_65893 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_65900__$1 = state_65900;
var statearr_65918_65936 = state_65900__$1;
(statearr_65918_65936[(2)] = inst_65893);

(statearr_65918_65936[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65901 === (8))){
var inst_65873 = (state_65900[(2)]);
var state_65900__$1 = state_65900;
if(cljs.core.truth_(inst_65873)){
var statearr_65919_65937 = state_65900__$1;
(statearr_65919_65937[(1)] = (9));

} else {
var statearr_65920_65938 = state_65900__$1;
(statearr_65920_65938[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_65921 = [null,null,null,null,null,null,null,null,null];
(statearr_65921[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_65921[(1)] = (1));

return statearr_65921;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_65900){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65900);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65922){var ex__2687__auto__ = e65922;
var statearr_65923_65939 = state_65900;
(statearr_65923_65939[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65900[(4)]))){
var statearr_65924_65940 = state_65900;
(statearr_65924_65940[(1)] = cljs.core.first((state_65900[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65941 = state_65900;
state_65900 = G__65941;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = function(state_65900){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_65900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65925 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65925[(6)] = c__2706__auto__);

return statearr_65925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66010){
var state_val_66011 = (state_66010[(1)]);
if((state_val_66011 === (7))){
var state_66010__$1 = state_66010;
var statearr_66012_66050 = state_66010__$1;
(statearr_66012_66050[(2)] = subject);

(statearr_66012_66050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (20))){
var inst_65966 = (state_66010[(7)]);
var inst_65978 = (state_66010[(8)]);
var inst_65981 = fluree.db.dbfunctions.internal.follow_subject(_QMARK_ctx,inst_65978,inst_65966);
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66010__$1,(23),inst_65981);
} else {
if((state_val_66011 === (1))){
var state_66010__$1 = state_66010;
var statearr_66013_66051 = state_66010__$1;
(statearr_66013_66051[(2)] = null);

(statearr_66013_66051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (4))){
var inst_65942 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66014_66052 = state_66010__$1;
(statearr_66014_66052[(2)] = inst_65942);

(statearr_66014_66052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (15))){
var inst_65958 = (state_66010[(9)]);
var state_66010__$1 = state_66010;
var statearr_66015_66053 = state_66010__$1;
(statearr_66015_66053[(2)] = inst_65958);

(statearr_66015_66053[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (21))){
var inst_65966 = (state_66010[(7)]);
var inst_65978 = (state_66010[(8)]);
var inst_65986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65987 = fluree.db.dbfunctions.internal.get_all(inst_65978,inst_65966);
var inst_65988 = cljs.core.count(inst_65966);
var inst_65989 = ((9) + inst_65988);
var inst_65990 = [inst_65987,inst_65989];
var inst_65991 = (new cljs.core.PersistentVector(null,2,(5),inst_65986,inst_65990,null));
var state_66010__$1 = state_66010;
var statearr_66016_66054 = state_66010__$1;
(statearr_66016_66054[(2)] = inst_65991);

(statearr_66016_66054[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (13))){
var inst_65962 = (state_66010[(2)]);
var inst_65963 = fluree.db.util.async.throw_err(inst_65962);
var state_66010__$1 = state_66010;
var statearr_66017_66055 = state_66010__$1;
(statearr_66017_66055[(2)] = inst_65963);

(statearr_66017_66055[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (22))){
var inst_65958 = (state_66010[(9)]);
var inst_65966 = (state_66010[(7)]);
var inst_65993 = (state_66010[(2)]);
var inst_65994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65993,(0),null);
var inst_65995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65993,(1),null);
var inst_65996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65997 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65999 = [inst_65958,inst_65966];
var inst_66000 = (new cljs.core.PersistentVector(null,2,(5),inst_65998,inst_65999,null));
var inst_66001 = ["get-all",inst_66000,inst_65994];
var inst_66002 = cljs.core.PersistentHashMap.fromArrays(inst_65997,inst_66001);
var inst_66003 = [inst_66002,inst_65995];
var inst_66004 = (new cljs.core.PersistentVector(null,2,(5),inst_65996,inst_66003,null));
var inst_66005 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66004);
var _ = (function (){var statearr_66018 = state_66010;
(statearr_66018[(4)] = cljs.core.rest((state_66010[(4)])));

return statearr_66018;
})();
var state_66010__$1 = (function (){var statearr_66019 = state_66010;
(statearr_66019[(10)] = inst_66005);

return statearr_66019;
})();
var statearr_66020_66056 = state_66010__$1;
(statearr_66020_66056[(2)] = inst_65994);

(statearr_66020_66056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (6))){
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66010__$1,(9),subject);
} else {
if((state_val_66011 === (17))){
var inst_65958 = (state_66010[(9)]);
var inst_65972 = cljs.core.first(inst_65958);
var state_66010__$1 = state_66010;
var statearr_66021_66057 = state_66010__$1;
(statearr_66021_66057[(2)] = inst_65972);

(statearr_66021_66057[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (3))){
var inst_66008 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66010__$1,inst_66008);
} else {
if((state_val_66011 === (12))){
var inst_65958 = (state_66010[(9)]);
var inst_65966 = (state_66010[(2)]);
var inst_65967 = cljs.core.vector_QMARK_(inst_65958);
var state_66010__$1 = (function (){var statearr_66022 = state_66010;
(statearr_66022[(7)] = inst_65966);

return statearr_66022;
})();
if(inst_65967){
var statearr_66023_66058 = state_66010__$1;
(statearr_66023_66058[(1)] = (14));

} else {
var statearr_66024_66059 = state_66010__$1;
(statearr_66024_66059[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (2))){
var _ = (function (){var statearr_66025 = state_66010;
(statearr_66025[(4)] = cljs.core.cons((5),(state_66010[(4)])));

return statearr_66025;
})();
var inst_65951 = fluree.db.util.async.channel_QMARK_(subject);
var state_66010__$1 = state_66010;
if(inst_65951){
var statearr_66026_66060 = state_66010__$1;
(statearr_66026_66060[(1)] = (6));

} else {
var statearr_66027_66061 = state_66010__$1;
(statearr_66027_66061[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (23))){
var inst_65983 = (state_66010[(2)]);
var inst_65984 = fluree.db.util.async.throw_err(inst_65983);
var state_66010__$1 = state_66010;
var statearr_66028_66062 = state_66010__$1;
(statearr_66028_66062[(2)] = inst_65984);

(statearr_66028_66062[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (19))){
var inst_65975 = (state_66010[(2)]);
var state_66010__$1 = state_66010;
var statearr_66029_66063 = state_66010__$1;
(statearr_66029_66063[(2)] = inst_65975);

(statearr_66029_66063[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (11))){
var state_66010__$1 = state_66010;
var statearr_66031_66064 = state_66010__$1;
(statearr_66031_66064[(2)] = path);

(statearr_66031_66064[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (9))){
var inst_65954 = (state_66010[(2)]);
var inst_65955 = fluree.db.util.async.throw_err(inst_65954);
var state_66010__$1 = state_66010;
var statearr_66032_66065 = state_66010__$1;
(statearr_66032_66065[(2)] = inst_65955);

(statearr_66032_66065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (5))){
var _ = (function (){var statearr_66033 = state_66010;
(statearr_66033[(4)] = cljs.core.rest((state_66010[(4)])));

return statearr_66033;
})();
var state_66010__$1 = state_66010;
var ex66030 = (state_66010__$1[(2)]);
var statearr_66034_66066 = state_66010__$1;
(statearr_66034_66066[(5)] = ex66030);


if((ex66030 instanceof Error)){
var statearr_66035_66067 = state_66010__$1;
(statearr_66035_66067[(1)] = (4));

(statearr_66035_66067[(5)] = null);

} else {
throw ex66030;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (14))){
var inst_65958 = (state_66010[(9)]);
var inst_65969 = cljs.core.count(inst_65958);
var inst_65970 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65969);
var state_66010__$1 = state_66010;
if(inst_65970){
var statearr_66036_66068 = state_66010__$1;
(statearr_66036_66068[(1)] = (17));

} else {
var statearr_66037_66069 = state_66010__$1;
(statearr_66037_66069[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (16))){
var inst_65978 = (state_66010[(8)]);
var inst_65978__$1 = (state_66010[(2)]);
var inst_65979 = cljs.core.int_QMARK_(inst_65978__$1);
var state_66010__$1 = (function (){var statearr_66038 = state_66010;
(statearr_66038[(8)] = inst_65978__$1);

return statearr_66038;
})();
if(inst_65979){
var statearr_66039_66070 = state_66010__$1;
(statearr_66039_66070[(1)] = (20));

} else {
var statearr_66040_66071 = state_66010__$1;
(statearr_66040_66071[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (10))){
var state_66010__$1 = state_66010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66010__$1,(13),path);
} else {
if((state_val_66011 === (18))){
var inst_65958 = (state_66010[(9)]);
var state_66010__$1 = state_66010;
var statearr_66041_66072 = state_66010__$1;
(statearr_66041_66072[(2)] = inst_65958);

(statearr_66041_66072[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66011 === (8))){
var inst_65958 = (state_66010[(2)]);
var inst_65959 = fluree.db.util.async.channel_QMARK_(path);
var state_66010__$1 = (function (){var statearr_66042 = state_66010;
(statearr_66042[(9)] = inst_65958);

return statearr_66042;
})();
if(inst_65959){
var statearr_66043_66073 = state_66010__$1;
(statearr_66043_66073[(1)] = (10));

} else {
var statearr_66044_66074 = state_66010__$1;
(statearr_66044_66074[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0 = (function (){
var statearr_66045 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_66045[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__);

(statearr_66045[(1)] = (1));

return statearr_66045;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1 = (function (state_66010){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66010);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66046){var ex__2687__auto__ = e66046;
var statearr_66047_66075 = state_66010;
(statearr_66047_66075[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66010[(4)]))){
var statearr_66048_66076 = state_66010;
(statearr_66048_66076[(1)] = cljs.core.first((state_66010[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66077 = state_66010;
state_66010 = G__66077;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = function(state_66010){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1.call(this,state_66010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66049 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66049[(6)] = c__2706__auto__);

return statearr_66049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66116){
var state_val_66117 = (state_66116[(1)]);
if((state_val_66117 === (7))){
var state_66116__$1 = state_66116;
var statearr_66118_66142 = state_66116__$1;
(statearr_66118_66142[(2)] = subject);

(statearr_66118_66142[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (1))){
var state_66116__$1 = state_66116;
var statearr_66119_66143 = state_66116__$1;
(statearr_66119_66143[(2)] = null);

(statearr_66119_66143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (4))){
var inst_66078 = (state_66116[(2)]);
var state_66116__$1 = state_66116;
var statearr_66120_66144 = state_66116__$1;
(statearr_66120_66144[(2)] = inst_66078);

(statearr_66120_66144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (13))){
var inst_66095 = (state_66116[(2)]);
var inst_66096 = fluree.db.util.async.throw_err(inst_66095);
var state_66116__$1 = state_66116;
var statearr_66121_66145 = state_66116__$1;
(statearr_66121_66145[(2)] = inst_66096);

(statearr_66121_66145[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (6))){
var state_66116__$1 = state_66116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66116__$1,(9),subject);
} else {
if((state_val_66117 === (3))){
var inst_66114 = (state_66116[(2)]);
var state_66116__$1 = state_66116;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66116__$1,inst_66114);
} else {
if((state_val_66117 === (12))){
var inst_66091 = (state_66116[(7)]);
var inst_66099 = (state_66116[(2)]);
var inst_66100 = fluree.db.dbfunctions.internal.get_in(inst_66091,inst_66099);
var inst_66101 = cljs.core.count(inst_66099);
var inst_66102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66103 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66105 = [inst_66091,inst_66099];
var inst_66106 = (new cljs.core.PersistentVector(null,2,(5),inst_66104,inst_66105,null));
var inst_66107 = ["get-in",inst_66106,inst_66100];
var inst_66108 = cljs.core.PersistentHashMap.fromArrays(inst_66103,inst_66107);
var inst_66109 = [inst_66108,inst_66101];
var inst_66110 = (new cljs.core.PersistentVector(null,2,(5),inst_66102,inst_66109,null));
var inst_66111 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66110);
var _ = (function (){var statearr_66122 = state_66116;
(statearr_66122[(4)] = cljs.core.rest((state_66116[(4)])));

return statearr_66122;
})();
var state_66116__$1 = (function (){var statearr_66123 = state_66116;
(statearr_66123[(8)] = inst_66111);

return statearr_66123;
})();
var statearr_66124_66146 = state_66116__$1;
(statearr_66124_66146[(2)] = inst_66100);

(statearr_66124_66146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (2))){
var _ = (function (){var statearr_66125 = state_66116;
(statearr_66125[(4)] = cljs.core.cons((5),(state_66116[(4)])));

return statearr_66125;
})();
var inst_66084 = fluree.db.util.async.channel_QMARK_(subject);
var state_66116__$1 = state_66116;
if(inst_66084){
var statearr_66126_66147 = state_66116__$1;
(statearr_66126_66147[(1)] = (6));

} else {
var statearr_66127_66148 = state_66116__$1;
(statearr_66127_66148[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (11))){
var state_66116__$1 = state_66116;
var statearr_66129_66149 = state_66116__$1;
(statearr_66129_66149[(2)] = path);

(statearr_66129_66149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (9))){
var inst_66087 = (state_66116[(2)]);
var inst_66088 = fluree.db.util.async.throw_err(inst_66087);
var state_66116__$1 = state_66116;
var statearr_66130_66150 = state_66116__$1;
(statearr_66130_66150[(2)] = inst_66088);

(statearr_66130_66150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (5))){
var _ = (function (){var statearr_66131 = state_66116;
(statearr_66131[(4)] = cljs.core.rest((state_66116[(4)])));

return statearr_66131;
})();
var state_66116__$1 = state_66116;
var ex66128 = (state_66116__$1[(2)]);
var statearr_66132_66151 = state_66116__$1;
(statearr_66132_66151[(5)] = ex66128);


if((ex66128 instanceof Error)){
var statearr_66133_66152 = state_66116__$1;
(statearr_66133_66152[(1)] = (4));

(statearr_66133_66152[(5)] = null);

} else {
throw ex66128;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66117 === (10))){
var state_66116__$1 = state_66116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66116__$1,(13),path);
} else {
if((state_val_66117 === (8))){
var inst_66091 = (state_66116[(2)]);
var inst_66092 = fluree.db.util.async.channel_QMARK_(path);
var state_66116__$1 = (function (){var statearr_66134 = state_66116;
(statearr_66134[(7)] = inst_66091);

return statearr_66134;
})();
if(inst_66092){
var statearr_66135_66153 = state_66116__$1;
(statearr_66135_66153[(1)] = (10));

} else {
var statearr_66136_66154 = state_66116__$1;
(statearr_66136_66154[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0 = (function (){
var statearr_66137 = [null,null,null,null,null,null,null,null,null];
(statearr_66137[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__);

(statearr_66137[(1)] = (1));

return statearr_66137;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1 = (function (state_66116){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66116);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66138){var ex__2687__auto__ = e66138;
var statearr_66139_66155 = state_66116;
(statearr_66139_66155[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66116[(4)]))){
var statearr_66140_66156 = state_66116;
(statearr_66140_66156[(1)] = cljs.core.first((state_66116[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66157 = state_66116;
state_66116 = G__66157;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = function(state_66116){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1.call(this,state_66116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66141 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66141[(6)] = c__2706__auto__);

return statearr_66141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__66158,key_or_ks){
var map__66159 = p__66158;
var map__66159__$1 = cljs.core.__destructure_map(map__66159);
var _QMARK_ctx = map__66159__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66159__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_(key_or_ks)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66204){
var state_val_66205 = (state_66204[(1)]);
if((state_val_66205 === (7))){
var state_66204__$1 = state_66204;
var statearr_66206_66235 = state_66204__$1;
(statearr_66206_66235[(2)] = coll);

(statearr_66206_66235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (1))){
var state_66204__$1 = state_66204;
var statearr_66207_66236 = state_66204__$1;
(statearr_66207_66236[(2)] = null);

(statearr_66207_66236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (4))){
var inst_66160 = (state_66204[(2)]);
var state_66204__$1 = state_66204;
var statearr_66208_66237 = state_66204__$1;
(statearr_66208_66237[(2)] = inst_66160);

(statearr_66208_66237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (15))){
var inst_66180 = (state_66204[(7)]);
var inst_66188 = (state_66204[(2)]);
var inst_66189 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_66180,inst_66188);
var inst_66190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66191 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66193 = [inst_66180,inst_66188];
var inst_66194 = (new cljs.core.PersistentVector(null,2,(5),inst_66192,inst_66193,null));
var inst_66195 = ["contains?",inst_66194,inst_66189];
var inst_66196 = cljs.core.PersistentHashMap.fromArrays(inst_66191,inst_66195);
var inst_66197 = [inst_66196,(10)];
var inst_66198 = (new cljs.core.PersistentVector(null,2,(5),inst_66190,inst_66197,null));
var inst_66199 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66198);
var _ = (function (){var statearr_66209 = state_66204;
(statearr_66209[(4)] = cljs.core.rest((state_66204[(4)])));

return statearr_66209;
})();
var state_66204__$1 = (function (){var statearr_66210 = state_66204;
(statearr_66210[(8)] = inst_66199);

return statearr_66210;
})();
var statearr_66211_66238 = state_66204__$1;
(statearr_66211_66238[(2)] = inst_66189);

(statearr_66211_66238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (13))){
var state_66204__$1 = state_66204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66204__$1,(16),key);
} else {
if((state_val_66205 === (6))){
var state_66204__$1 = state_66204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66204__$1,(9),coll);
} else {
if((state_val_66205 === (3))){
var inst_66202 = (state_66204[(2)]);
var state_66204__$1 = state_66204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66204__$1,inst_66202);
} else {
if((state_val_66205 === (12))){
var inst_66180 = (state_66204[(2)]);
var inst_66181 = fluree.db.util.async.channel_QMARK_(key);
var state_66204__$1 = (function (){var statearr_66212 = state_66204;
(statearr_66212[(7)] = inst_66180);

return statearr_66212;
})();
if(inst_66181){
var statearr_66213_66239 = state_66204__$1;
(statearr_66213_66239[(1)] = (13));

} else {
var statearr_66214_66240 = state_66204__$1;
(statearr_66214_66240[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (2))){
var _ = (function (){var statearr_66215 = state_66204;
(statearr_66215[(4)] = cljs.core.cons((5),(state_66204[(4)])));

return statearr_66215;
})();
var inst_66166 = fluree.db.util.async.channel_QMARK_(coll);
var state_66204__$1 = state_66204;
if(inst_66166){
var statearr_66216_66241 = state_66204__$1;
(statearr_66216_66241[(1)] = (6));

} else {
var statearr_66217_66242 = state_66204__$1;
(statearr_66217_66242[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (11))){
var inst_66173 = (state_66204[(9)]);
var inst_66177 = cljs.core.flatten(inst_66173);
var inst_66178 = cljs.core.set(inst_66177);
var state_66204__$1 = state_66204;
var statearr_66219_66243 = state_66204__$1;
(statearr_66219_66243[(2)] = inst_66178);

(statearr_66219_66243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (9))){
var inst_66169 = (state_66204[(2)]);
var inst_66170 = fluree.db.util.async.throw_err(inst_66169);
var state_66204__$1 = state_66204;
var statearr_66220_66244 = state_66204__$1;
(statearr_66220_66244[(2)] = inst_66170);

(statearr_66220_66244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (5))){
var _ = (function (){var statearr_66221 = state_66204;
(statearr_66221[(4)] = cljs.core.rest((state_66204[(4)])));

return statearr_66221;
})();
var state_66204__$1 = state_66204;
var ex66218 = (state_66204__$1[(2)]);
var statearr_66222_66245 = state_66204__$1;
(statearr_66222_66245[(5)] = ex66218);


if((ex66218 instanceof Error)){
var statearr_66223_66246 = state_66204__$1;
(statearr_66223_66246[(1)] = (4));

(statearr_66223_66246[(5)] = null);

} else {
throw ex66218;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (14))){
var state_66204__$1 = state_66204;
var statearr_66224_66247 = state_66204__$1;
(statearr_66224_66247[(2)] = key);

(statearr_66224_66247[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (16))){
var inst_66184 = (state_66204[(2)]);
var inst_66185 = fluree.db.util.async.throw_err(inst_66184);
var state_66204__$1 = state_66204;
var statearr_66225_66248 = state_66204__$1;
(statearr_66225_66248[(2)] = inst_66185);

(statearr_66225_66248[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (10))){
var inst_66173 = (state_66204[(9)]);
var state_66204__$1 = state_66204;
var statearr_66226_66249 = state_66204__$1;
(statearr_66226_66249[(2)] = inst_66173);

(statearr_66226_66249[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66205 === (8))){
var inst_66173 = (state_66204[(9)]);
var inst_66173__$1 = (state_66204[(2)]);
var inst_66174 = cljs.core.set_QMARK_(inst_66173__$1);
var state_66204__$1 = (function (){var statearr_66227 = state_66204;
(statearr_66227[(9)] = inst_66173__$1);

return statearr_66227;
})();
if(inst_66174){
var statearr_66228_66250 = state_66204__$1;
(statearr_66228_66250[(1)] = (10));

} else {
var statearr_66229_66251 = state_66204__$1;
(statearr_66229_66251[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_66230 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66230[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__);

(statearr_66230[(1)] = (1));

return statearr_66230;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1 = (function (state_66204){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66204);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66231){var ex__2687__auto__ = e66231;
var statearr_66232_66252 = state_66204;
(statearr_66232_66252[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66204[(4)]))){
var statearr_66233_66253 = state_66204;
(statearr_66233_66253[(1)] = cljs.core.first((state_66204[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66254 = state_66204;
state_66204 = G__66254;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = function(state_66204){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1.call(this,state_66204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66234 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66234[(6)] = c__2706__auto__);

return statearr_66234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66326 = arguments.length;
var i__5770__auto___66327 = (0);
while(true){
if((i__5770__auto___66327 < len__5769__auto___66326)){
args__5775__auto__.push((arguments[i__5770__auto___66327]));

var G__66328 = (i__5770__auto___66327 + (1));
i__5770__auto___66327 = G__66328;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66300){
var state_val_66301 = (state_66300[(1)]);
if((state_val_66301 === (7))){
var inst_66266 = (state_66300[(7)]);
var inst_66270 = cljs.core.first(inst_66266);
var inst_66271 = cljs.core.coll_QMARK_(inst_66270);
var state_66300__$1 = state_66300;
var statearr_66302_66329 = state_66300__$1;
(statearr_66302_66329[(2)] = inst_66271);

(statearr_66302_66329[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (1))){
var state_66300__$1 = state_66300;
var statearr_66303_66330 = state_66300__$1;
(statearr_66303_66330[(2)] = null);

(statearr_66303_66330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (4))){
var inst_66257 = (state_66300[(2)]);
var state_66300__$1 = state_66300;
var statearr_66304_66331 = state_66300__$1;
(statearr_66304_66331[(2)] = inst_66257);

(statearr_66304_66331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (6))){
var inst_66268 = (state_66300[(8)]);
var inst_66266 = (state_66300[(7)]);
var inst_66265 = (state_66300[(2)]);
var inst_66266__$1 = fluree.db.util.async.throw_err(inst_66265);
var inst_66267 = cljs.core.count(inst_66266__$1);
var inst_66268__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66267);
var state_66300__$1 = (function (){var statearr_66305 = state_66300;
(statearr_66305[(8)] = inst_66268__$1);

(statearr_66305[(7)] = inst_66266__$1);

return statearr_66305;
})();
if(inst_66268__$1){
var statearr_66306_66332 = state_66300__$1;
(statearr_66306_66332[(1)] = (7));

} else {
var statearr_66307_66333 = state_66300__$1;
(statearr_66307_66333[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (3))){
var inst_66298 = (state_66300[(2)]);
var state_66300__$1 = state_66300;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66300__$1,inst_66298);
} else {
if((state_val_66301 === (12))){
var inst_66279 = (state_66300[(2)]);
var inst_66280 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_66279);
var inst_66281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66282 = [inst_66279];
var inst_66283 = (new cljs.core.PersistentVector(null,1,(5),inst_66281,inst_66282,null));
var inst_66284 = cljs.core.count(inst_66283);
var inst_66285 = ((9) + inst_66284);
var inst_66286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66287 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66289 = [inst_66279];
var inst_66290 = (new cljs.core.PersistentVector(null,1,(5),inst_66288,inst_66289,null));
var inst_66291 = ["hash-set",inst_66290,inst_66280];
var inst_66292 = cljs.core.PersistentHashMap.fromArrays(inst_66287,inst_66291);
var inst_66293 = [inst_66292,inst_66285];
var inst_66294 = (new cljs.core.PersistentVector(null,2,(5),inst_66286,inst_66293,null));
var inst_66295 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66294);
var _ = (function (){var statearr_66308 = state_66300;
(statearr_66308[(4)] = cljs.core.rest((state_66300[(4)])));

return statearr_66308;
})();
var state_66300__$1 = (function (){var statearr_66309 = state_66300;
(statearr_66309[(9)] = inst_66295);

return statearr_66309;
})();
var statearr_66310_66334 = state_66300__$1;
(statearr_66310_66334[(2)] = inst_66280);

(statearr_66310_66334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (2))){
var _ = (function (){var statearr_66311 = state_66300;
(statearr_66311[(4)] = cljs.core.cons((5),(state_66300[(4)])));

return statearr_66311;
})();
var inst_66263 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66300__$1 = state_66300;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66300__$1,(6),inst_66263);
} else {
if((state_val_66301 === (11))){
var inst_66266 = (state_66300[(7)]);
var state_66300__$1 = state_66300;
var statearr_66313_66335 = state_66300__$1;
(statearr_66313_66335[(2)] = inst_66266);

(statearr_66313_66335[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (9))){
var inst_66274 = (state_66300[(2)]);
var state_66300__$1 = state_66300;
if(cljs.core.truth_(inst_66274)){
var statearr_66314_66336 = state_66300__$1;
(statearr_66314_66336[(1)] = (10));

} else {
var statearr_66315_66337 = state_66300__$1;
(statearr_66315_66337[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (5))){
var _ = (function (){var statearr_66316 = state_66300;
(statearr_66316[(4)] = cljs.core.rest((state_66300[(4)])));

return statearr_66316;
})();
var state_66300__$1 = state_66300;
var ex66312 = (state_66300__$1[(2)]);
var statearr_66317_66338 = state_66300__$1;
(statearr_66317_66338[(5)] = ex66312);


if((ex66312 instanceof Error)){
var statearr_66318_66339 = state_66300__$1;
(statearr_66318_66339[(1)] = (4));

(statearr_66318_66339[(5)] = null);

} else {
throw ex66312;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (10))){
var inst_66266 = (state_66300[(7)]);
var inst_66276 = cljs.core.first(inst_66266);
var state_66300__$1 = state_66300;
var statearr_66319_66340 = state_66300__$1;
(statearr_66319_66340[(2)] = inst_66276);

(statearr_66319_66340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66301 === (8))){
var inst_66268 = (state_66300[(8)]);
var state_66300__$1 = state_66300;
var statearr_66320_66341 = state_66300__$1;
(statearr_66320_66341[(2)] = inst_66268);

(statearr_66320_66341[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66321 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66321[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66321[(1)] = (1));

return statearr_66321;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66300){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66300);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66322){var ex__2687__auto__ = e66322;
var statearr_66323_66342 = state_66300;
(statearr_66323_66342[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66300[(4)]))){
var statearr_66324_66343 = state_66300;
(statearr_66324_66343[(1)] = cljs.core.first((state_66300[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66344 = state_66300;
state_66300 = G__66344;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66300){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66325 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66325[(6)] = c__2706__auto__);

return statearr_66325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq66255){
var G__66256 = cljs.core.first(seq66255);
var seq66255__$1 = cljs.core.next(seq66255);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66256,seq66255__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66394 = arguments.length;
var i__5770__auto___66395 = (0);
while(true){
if((i__5770__auto___66395 < len__5769__auto___66394)){
args__5775__auto__.push((arguments[i__5770__auto___66395]));

var G__66396 = (i__5770__auto___66395 + (1));
i__5770__auto___66395 = G__66396;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66377){
var state_val_66378 = (state_66377[(1)]);
if((state_val_66378 === (1))){
var state_66377__$1 = state_66377;
var statearr_66379_66397 = state_66377__$1;
(statearr_66379_66397[(2)] = null);

(statearr_66379_66397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66378 === (2))){
var _ = (function (){var statearr_66380 = state_66377;
(statearr_66380[(4)] = cljs.core.cons((5),(state_66377[(4)])));

return statearr_66380;
})();
var inst_66353 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66377__$1 = state_66377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66377__$1,(6),inst_66353);
} else {
if((state_val_66378 === (3))){
var inst_66375 = (state_66377[(2)]);
var state_66377__$1 = state_66377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66377__$1,inst_66375);
} else {
if((state_val_66378 === (4))){
var inst_66347 = (state_66377[(2)]);
var state_66377__$1 = state_66377;
var statearr_66382_66398 = state_66377__$1;
(statearr_66382_66398[(2)] = inst_66347);

(statearr_66382_66398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66378 === (5))){
var _ = (function (){var statearr_66383 = state_66377;
(statearr_66383[(4)] = cljs.core.rest((state_66377[(4)])));

return statearr_66383;
})();
var state_66377__$1 = state_66377;
var ex66381 = (state_66377__$1[(2)]);
var statearr_66384_66399 = state_66377__$1;
(statearr_66384_66399[(5)] = ex66381);


if((ex66381 instanceof Error)){
var statearr_66385_66400 = state_66377__$1;
(statearr_66385_66400[(1)] = (4));

(statearr_66385_66400[(5)] = null);

} else {
throw ex66381;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66378 === (6))){
var inst_66355 = (state_66377[(2)]);
var inst_66356 = fluree.db.util.async.throw_err(inst_66355);
var inst_66357 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_66356);
var inst_66358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66359 = [inst_66356];
var inst_66360 = (new cljs.core.PersistentVector(null,1,(5),inst_66358,inst_66359,null));
var inst_66361 = cljs.core.count(inst_66360);
var inst_66362 = ((9) + inst_66361);
var inst_66363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66364 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66366 = [inst_66356];
var inst_66367 = (new cljs.core.PersistentVector(null,1,(5),inst_66365,inst_66366,null));
var inst_66368 = ["==",inst_66367,inst_66357];
var inst_66369 = cljs.core.PersistentHashMap.fromArrays(inst_66364,inst_66368);
var inst_66370 = [inst_66369,inst_66362];
var inst_66371 = (new cljs.core.PersistentVector(null,2,(5),inst_66363,inst_66370,null));
var inst_66372 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66371);
var _ = (function (){var statearr_66386 = state_66377;
(statearr_66386[(4)] = cljs.core.rest((state_66377[(4)])));

return statearr_66386;
})();
var state_66377__$1 = (function (){var statearr_66387 = state_66377;
(statearr_66387[(7)] = inst_66372);

return statearr_66387;
})();
var statearr_66388_66401 = state_66377__$1;
(statearr_66388_66401[(2)] = inst_66357);

(statearr_66388_66401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66389 = [null,null,null,null,null,null,null,null];
(statearr_66389[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66389[(1)] = (1));

return statearr_66389;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66377){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66377);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66390){var ex__2687__auto__ = e66390;
var statearr_66391_66402 = state_66377;
(statearr_66391_66402[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66377[(4)]))){
var statearr_66392_66403 = state_66377;
(statearr_66392_66403[(1)] = cljs.core.first((state_66377[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66404 = state_66377;
state_66377 = G__66404;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66377){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66393 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66393[(6)] = c__2706__auto__);

return statearr_66393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq66345){
var G__66346 = cljs.core.first(seq66345);
var seq66345__$1 = cljs.core.next(seq66345);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66346,seq66345__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66454 = arguments.length;
var i__5770__auto___66455 = (0);
while(true){
if((i__5770__auto___66455 < len__5769__auto___66454)){
args__5775__auto__.push((arguments[i__5770__auto___66455]));

var G__66456 = (i__5770__auto___66455 + (1));
i__5770__auto___66455 = G__66456;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66437){
var state_val_66438 = (state_66437[(1)]);
if((state_val_66438 === (1))){
var state_66437__$1 = state_66437;
var statearr_66439_66457 = state_66437__$1;
(statearr_66439_66457[(2)] = null);

(statearr_66439_66457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66438 === (2))){
var _ = (function (){var statearr_66440 = state_66437;
(statearr_66440[(4)] = cljs.core.cons((5),(state_66437[(4)])));

return statearr_66440;
})();
var inst_66413 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66437__$1 = state_66437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66437__$1,(6),inst_66413);
} else {
if((state_val_66438 === (3))){
var inst_66435 = (state_66437[(2)]);
var state_66437__$1 = state_66437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66437__$1,inst_66435);
} else {
if((state_val_66438 === (4))){
var inst_66407 = (state_66437[(2)]);
var state_66437__$1 = state_66437;
var statearr_66442_66458 = state_66437__$1;
(statearr_66442_66458[(2)] = inst_66407);

(statearr_66442_66458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66438 === (5))){
var _ = (function (){var statearr_66443 = state_66437;
(statearr_66443[(4)] = cljs.core.rest((state_66437[(4)])));

return statearr_66443;
})();
var state_66437__$1 = state_66437;
var ex66441 = (state_66437__$1[(2)]);
var statearr_66444_66459 = state_66437__$1;
(statearr_66444_66459[(5)] = ex66441);


if((ex66441 instanceof Error)){
var statearr_66445_66460 = state_66437__$1;
(statearr_66445_66460[(1)] = (4));

(statearr_66445_66460[(5)] = null);

} else {
throw ex66441;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66438 === (6))){
var inst_66415 = (state_66437[(2)]);
var inst_66416 = fluree.db.util.async.throw_err(inst_66415);
var inst_66417 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_66416);
var inst_66418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66419 = [inst_66416];
var inst_66420 = (new cljs.core.PersistentVector(null,1,(5),inst_66418,inst_66419,null));
var inst_66421 = cljs.core.count(inst_66420);
var inst_66422 = ((9) + inst_66421);
var inst_66423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66424 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66426 = [inst_66416];
var inst_66427 = (new cljs.core.PersistentVector(null,1,(5),inst_66425,inst_66426,null));
var inst_66428 = [">",inst_66427,inst_66417];
var inst_66429 = cljs.core.PersistentHashMap.fromArrays(inst_66424,inst_66428);
var inst_66430 = [inst_66429,inst_66422];
var inst_66431 = (new cljs.core.PersistentVector(null,2,(5),inst_66423,inst_66430,null));
var inst_66432 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66431);
var _ = (function (){var statearr_66446 = state_66437;
(statearr_66446[(4)] = cljs.core.rest((state_66437[(4)])));

return statearr_66446;
})();
var state_66437__$1 = (function (){var statearr_66447 = state_66437;
(statearr_66447[(7)] = inst_66432);

return statearr_66447;
})();
var statearr_66448_66461 = state_66437__$1;
(statearr_66448_66461[(2)] = inst_66417);

(statearr_66448_66461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66449 = [null,null,null,null,null,null,null,null];
(statearr_66449[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66449[(1)] = (1));

return statearr_66449;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66437){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66437);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66450){var ex__2687__auto__ = e66450;
var statearr_66451_66462 = state_66437;
(statearr_66451_66462[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66437[(4)]))){
var statearr_66452_66463 = state_66437;
(statearr_66452_66463[(1)] = cljs.core.first((state_66437[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66464 = state_66437;
state_66437 = G__66464;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66437){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66453 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66453[(6)] = c__2706__auto__);

return statearr_66453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq66405){
var G__66406 = cljs.core.first(seq66405);
var seq66405__$1 = cljs.core.next(seq66405);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66406,seq66405__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66514 = arguments.length;
var i__5770__auto___66515 = (0);
while(true){
if((i__5770__auto___66515 < len__5769__auto___66514)){
args__5775__auto__.push((arguments[i__5770__auto___66515]));

var G__66516 = (i__5770__auto___66515 + (1));
i__5770__auto___66515 = G__66516;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66497){
var state_val_66498 = (state_66497[(1)]);
if((state_val_66498 === (1))){
var state_66497__$1 = state_66497;
var statearr_66499_66517 = state_66497__$1;
(statearr_66499_66517[(2)] = null);

(statearr_66499_66517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66498 === (2))){
var _ = (function (){var statearr_66500 = state_66497;
(statearr_66500[(4)] = cljs.core.cons((5),(state_66497[(4)])));

return statearr_66500;
})();
var inst_66473 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66497__$1 = state_66497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66497__$1,(6),inst_66473);
} else {
if((state_val_66498 === (3))){
var inst_66495 = (state_66497[(2)]);
var state_66497__$1 = state_66497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66497__$1,inst_66495);
} else {
if((state_val_66498 === (4))){
var inst_66467 = (state_66497[(2)]);
var state_66497__$1 = state_66497;
var statearr_66502_66518 = state_66497__$1;
(statearr_66502_66518[(2)] = inst_66467);

(statearr_66502_66518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66498 === (5))){
var _ = (function (){var statearr_66503 = state_66497;
(statearr_66503[(4)] = cljs.core.rest((state_66497[(4)])));

return statearr_66503;
})();
var state_66497__$1 = state_66497;
var ex66501 = (state_66497__$1[(2)]);
var statearr_66504_66519 = state_66497__$1;
(statearr_66504_66519[(5)] = ex66501);


if((ex66501 instanceof Error)){
var statearr_66505_66520 = state_66497__$1;
(statearr_66505_66520[(1)] = (4));

(statearr_66505_66520[(5)] = null);

} else {
throw ex66501;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66498 === (6))){
var inst_66475 = (state_66497[(2)]);
var inst_66476 = fluree.db.util.async.throw_err(inst_66475);
var inst_66477 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_66476);
var inst_66478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66479 = [inst_66476];
var inst_66480 = (new cljs.core.PersistentVector(null,1,(5),inst_66478,inst_66479,null));
var inst_66481 = cljs.core.count(inst_66480);
var inst_66482 = ((9) + inst_66481);
var inst_66483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66484 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66486 = [inst_66476];
var inst_66487 = (new cljs.core.PersistentVector(null,1,(5),inst_66485,inst_66486,null));
var inst_66488 = ["<",inst_66487,inst_66477];
var inst_66489 = cljs.core.PersistentHashMap.fromArrays(inst_66484,inst_66488);
var inst_66490 = [inst_66489,inst_66482];
var inst_66491 = (new cljs.core.PersistentVector(null,2,(5),inst_66483,inst_66490,null));
var inst_66492 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66491);
var _ = (function (){var statearr_66506 = state_66497;
(statearr_66506[(4)] = cljs.core.rest((state_66497[(4)])));

return statearr_66506;
})();
var state_66497__$1 = (function (){var statearr_66507 = state_66497;
(statearr_66507[(7)] = inst_66492);

return statearr_66507;
})();
var statearr_66508_66521 = state_66497__$1;
(statearr_66508_66521[(2)] = inst_66477);

(statearr_66508_66521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66509 = [null,null,null,null,null,null,null,null];
(statearr_66509[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66509[(1)] = (1));

return statearr_66509;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66497){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66497);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66510){var ex__2687__auto__ = e66510;
var statearr_66511_66522 = state_66497;
(statearr_66511_66522[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66497[(4)]))){
var statearr_66512_66523 = state_66497;
(statearr_66512_66523[(1)] = cljs.core.first((state_66497[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66524 = state_66497;
state_66497 = G__66524;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66497){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66513 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66513[(6)] = c__2706__auto__);

return statearr_66513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq66465){
var G__66466 = cljs.core.first(seq66465);
var seq66465__$1 = cljs.core.next(seq66465);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66466,seq66465__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66574 = arguments.length;
var i__5770__auto___66575 = (0);
while(true){
if((i__5770__auto___66575 < len__5769__auto___66574)){
args__5775__auto__.push((arguments[i__5770__auto___66575]));

var G__66576 = (i__5770__auto___66575 + (1));
i__5770__auto___66575 = G__66576;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66557){
var state_val_66558 = (state_66557[(1)]);
if((state_val_66558 === (1))){
var state_66557__$1 = state_66557;
var statearr_66559_66577 = state_66557__$1;
(statearr_66559_66577[(2)] = null);

(statearr_66559_66577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66558 === (2))){
var _ = (function (){var statearr_66560 = state_66557;
(statearr_66560[(4)] = cljs.core.cons((5),(state_66557[(4)])));

return statearr_66560;
})();
var inst_66533 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66557__$1 = state_66557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66557__$1,(6),inst_66533);
} else {
if((state_val_66558 === (3))){
var inst_66555 = (state_66557[(2)]);
var state_66557__$1 = state_66557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66557__$1,inst_66555);
} else {
if((state_val_66558 === (4))){
var inst_66527 = (state_66557[(2)]);
var state_66557__$1 = state_66557;
var statearr_66562_66578 = state_66557__$1;
(statearr_66562_66578[(2)] = inst_66527);

(statearr_66562_66578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66558 === (5))){
var _ = (function (){var statearr_66563 = state_66557;
(statearr_66563[(4)] = cljs.core.rest((state_66557[(4)])));

return statearr_66563;
})();
var state_66557__$1 = state_66557;
var ex66561 = (state_66557__$1[(2)]);
var statearr_66564_66579 = state_66557__$1;
(statearr_66564_66579[(5)] = ex66561);


if((ex66561 instanceof Error)){
var statearr_66565_66580 = state_66557__$1;
(statearr_66565_66580[(1)] = (4));

(statearr_66565_66580[(5)] = null);

} else {
throw ex66561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66558 === (6))){
var inst_66535 = (state_66557[(2)]);
var inst_66536 = fluree.db.util.async.throw_err(inst_66535);
var inst_66537 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_66536);
var inst_66538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66539 = [inst_66536];
var inst_66540 = (new cljs.core.PersistentVector(null,1,(5),inst_66538,inst_66539,null));
var inst_66541 = cljs.core.count(inst_66540);
var inst_66542 = ((9) + inst_66541);
var inst_66543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66544 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66546 = [inst_66536];
var inst_66547 = (new cljs.core.PersistentVector(null,1,(5),inst_66545,inst_66546,null));
var inst_66548 = ["<=",inst_66547,inst_66537];
var inst_66549 = cljs.core.PersistentHashMap.fromArrays(inst_66544,inst_66548);
var inst_66550 = [inst_66549,inst_66542];
var inst_66551 = (new cljs.core.PersistentVector(null,2,(5),inst_66543,inst_66550,null));
var inst_66552 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66551);
var _ = (function (){var statearr_66566 = state_66557;
(statearr_66566[(4)] = cljs.core.rest((state_66557[(4)])));

return statearr_66566;
})();
var state_66557__$1 = (function (){var statearr_66567 = state_66557;
(statearr_66567[(7)] = inst_66552);

return statearr_66567;
})();
var statearr_66568_66581 = state_66557__$1;
(statearr_66568_66581[(2)] = inst_66537);

(statearr_66568_66581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66569 = [null,null,null,null,null,null,null,null];
(statearr_66569[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66569[(1)] = (1));

return statearr_66569;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66557){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66557);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66570){var ex__2687__auto__ = e66570;
var statearr_66571_66582 = state_66557;
(statearr_66571_66582[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66557[(4)]))){
var statearr_66572_66583 = state_66557;
(statearr_66572_66583[(1)] = cljs.core.first((state_66557[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66584 = state_66557;
state_66557 = G__66584;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66573 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66573[(6)] = c__2706__auto__);

return statearr_66573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq66525){
var G__66526 = cljs.core.first(seq66525);
var seq66525__$1 = cljs.core.next(seq66525);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66526,seq66525__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66634 = arguments.length;
var i__5770__auto___66635 = (0);
while(true){
if((i__5770__auto___66635 < len__5769__auto___66634)){
args__5775__auto__.push((arguments[i__5770__auto___66635]));

var G__66636 = (i__5770__auto___66635 + (1));
i__5770__auto___66635 = G__66636;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66617){
var state_val_66618 = (state_66617[(1)]);
if((state_val_66618 === (1))){
var state_66617__$1 = state_66617;
var statearr_66619_66637 = state_66617__$1;
(statearr_66619_66637[(2)] = null);

(statearr_66619_66637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66618 === (2))){
var _ = (function (){var statearr_66620 = state_66617;
(statearr_66620[(4)] = cljs.core.cons((5),(state_66617[(4)])));

return statearr_66620;
})();
var inst_66593 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66617__$1 = state_66617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66617__$1,(6),inst_66593);
} else {
if((state_val_66618 === (3))){
var inst_66615 = (state_66617[(2)]);
var state_66617__$1 = state_66617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66617__$1,inst_66615);
} else {
if((state_val_66618 === (4))){
var inst_66587 = (state_66617[(2)]);
var state_66617__$1 = state_66617;
var statearr_66622_66638 = state_66617__$1;
(statearr_66622_66638[(2)] = inst_66587);

(statearr_66622_66638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66618 === (5))){
var _ = (function (){var statearr_66623 = state_66617;
(statearr_66623[(4)] = cljs.core.rest((state_66617[(4)])));

return statearr_66623;
})();
var state_66617__$1 = state_66617;
var ex66621 = (state_66617__$1[(2)]);
var statearr_66624_66639 = state_66617__$1;
(statearr_66624_66639[(5)] = ex66621);


if((ex66621 instanceof Error)){
var statearr_66625_66640 = state_66617__$1;
(statearr_66625_66640[(1)] = (4));

(statearr_66625_66640[(5)] = null);

} else {
throw ex66621;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66618 === (6))){
var inst_66595 = (state_66617[(2)]);
var inst_66596 = fluree.db.util.async.throw_err(inst_66595);
var inst_66597 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_66596);
var inst_66598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66599 = [inst_66596];
var inst_66600 = (new cljs.core.PersistentVector(null,1,(5),inst_66598,inst_66599,null));
var inst_66601 = cljs.core.count(inst_66600);
var inst_66602 = ((9) + inst_66601);
var inst_66603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66604 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66606 = [inst_66596];
var inst_66607 = (new cljs.core.PersistentVector(null,1,(5),inst_66605,inst_66606,null));
var inst_66608 = [">=",inst_66607,inst_66597];
var inst_66609 = cljs.core.PersistentHashMap.fromArrays(inst_66604,inst_66608);
var inst_66610 = [inst_66609,inst_66602];
var inst_66611 = (new cljs.core.PersistentVector(null,2,(5),inst_66603,inst_66610,null));
var inst_66612 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66611);
var _ = (function (){var statearr_66626 = state_66617;
(statearr_66626[(4)] = cljs.core.rest((state_66617[(4)])));

return statearr_66626;
})();
var state_66617__$1 = (function (){var statearr_66627 = state_66617;
(statearr_66627[(7)] = inst_66612);

return statearr_66627;
})();
var statearr_66628_66641 = state_66617__$1;
(statearr_66628_66641[(2)] = inst_66597);

(statearr_66628_66641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66629 = [null,null,null,null,null,null,null,null];
(statearr_66629[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66629[(1)] = (1));

return statearr_66629;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66617){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66617);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66630){var ex__2687__auto__ = e66630;
var statearr_66631_66642 = state_66617;
(statearr_66631_66642[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66617[(4)]))){
var statearr_66632_66643 = state_66617;
(statearr_66632_66643[(1)] = cljs.core.first((state_66617[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66644 = state_66617;
state_66617 = G__66644;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66617){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66633 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66633[(6)] = c__2706__auto__);

return statearr_66633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq66585){
var G__66586 = cljs.core.first(seq66585);
var seq66585__$1 = cljs.core.next(seq66585);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66586,seq66585__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66694 = arguments.length;
var i__5770__auto___66695 = (0);
while(true){
if((i__5770__auto___66695 < len__5769__auto___66694)){
args__5775__auto__.push((arguments[i__5770__auto___66695]));

var G__66696 = (i__5770__auto___66695 + (1));
i__5770__auto___66695 = G__66696;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66677){
var state_val_66678 = (state_66677[(1)]);
if((state_val_66678 === (1))){
var state_66677__$1 = state_66677;
var statearr_66679_66697 = state_66677__$1;
(statearr_66679_66697[(2)] = null);

(statearr_66679_66697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66678 === (2))){
var _ = (function (){var statearr_66680 = state_66677;
(statearr_66680[(4)] = cljs.core.cons((5),(state_66677[(4)])));

return statearr_66680;
})();
var inst_66653 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66677__$1 = state_66677;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66677__$1,(6),inst_66653);
} else {
if((state_val_66678 === (3))){
var inst_66675 = (state_66677[(2)]);
var state_66677__$1 = state_66677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66677__$1,inst_66675);
} else {
if((state_val_66678 === (4))){
var inst_66647 = (state_66677[(2)]);
var state_66677__$1 = state_66677;
var statearr_66682_66698 = state_66677__$1;
(statearr_66682_66698[(2)] = inst_66647);

(statearr_66682_66698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66678 === (5))){
var _ = (function (){var statearr_66683 = state_66677;
(statearr_66683[(4)] = cljs.core.rest((state_66677[(4)])));

return statearr_66683;
})();
var state_66677__$1 = state_66677;
var ex66681 = (state_66677__$1[(2)]);
var statearr_66684_66699 = state_66677__$1;
(statearr_66684_66699[(5)] = ex66681);


if((ex66681 instanceof Error)){
var statearr_66685_66700 = state_66677__$1;
(statearr_66685_66700[(1)] = (4));

(statearr_66685_66700[(5)] = null);

} else {
throw ex66681;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66678 === (6))){
var inst_66655 = (state_66677[(2)]);
var inst_66656 = fluree.db.util.async.throw_err(inst_66655);
var inst_66657 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_66656);
var inst_66658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66659 = [inst_66656];
var inst_66660 = (new cljs.core.PersistentVector(null,1,(5),inst_66658,inst_66659,null));
var inst_66661 = cljs.core.count(inst_66660);
var inst_66662 = ((9) + inst_66661);
var inst_66663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66664 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66666 = [inst_66656];
var inst_66667 = (new cljs.core.PersistentVector(null,1,(5),inst_66665,inst_66666,null));
var inst_66668 = ["not=",inst_66667,inst_66657];
var inst_66669 = cljs.core.PersistentHashMap.fromArrays(inst_66664,inst_66668);
var inst_66670 = [inst_66669,inst_66662];
var inst_66671 = (new cljs.core.PersistentVector(null,2,(5),inst_66663,inst_66670,null));
var inst_66672 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66671);
var _ = (function (){var statearr_66686 = state_66677;
(statearr_66686[(4)] = cljs.core.rest((state_66677[(4)])));

return statearr_66686;
})();
var state_66677__$1 = (function (){var statearr_66687 = state_66677;
(statearr_66687[(7)] = inst_66672);

return statearr_66687;
})();
var statearr_66688_66701 = state_66677__$1;
(statearr_66688_66701[(2)] = inst_66657);

(statearr_66688_66701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66689 = [null,null,null,null,null,null,null,null];
(statearr_66689[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66689[(1)] = (1));

return statearr_66689;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66677){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66677);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66690){var ex__2687__auto__ = e66690;
var statearr_66691_66702 = state_66677;
(statearr_66691_66702[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66677[(4)]))){
var statearr_66692_66703 = state_66677;
(statearr_66692_66703[(1)] = cljs.core.first((state_66677[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66704 = state_66677;
state_66677 = G__66704;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66677){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66693 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66693[(6)] = c__2706__auto__);

return statearr_66693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq66645){
var G__66646 = cljs.core.first(seq66645);
var seq66645__$1 = cljs.core.next(seq66645);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66646,seq66645__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66754 = arguments.length;
var i__5770__auto___66755 = (0);
while(true){
if((i__5770__auto___66755 < len__5769__auto___66754)){
args__5775__auto__.push((arguments[i__5770__auto___66755]));

var G__66756 = (i__5770__auto___66755 + (1));
i__5770__auto___66755 = G__66756;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66737){
var state_val_66738 = (state_66737[(1)]);
if((state_val_66738 === (1))){
var state_66737__$1 = state_66737;
var statearr_66739_66757 = state_66737__$1;
(statearr_66739_66757[(2)] = null);

(statearr_66739_66757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66738 === (2))){
var _ = (function (){var statearr_66740 = state_66737;
(statearr_66740[(4)] = cljs.core.cons((5),(state_66737[(4)])));

return statearr_66740;
})();
var inst_66713 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66737__$1 = state_66737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66737__$1,(6),inst_66713);
} else {
if((state_val_66738 === (3))){
var inst_66735 = (state_66737[(2)]);
var state_66737__$1 = state_66737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66737__$1,inst_66735);
} else {
if((state_val_66738 === (4))){
var inst_66707 = (state_66737[(2)]);
var state_66737__$1 = state_66737;
var statearr_66742_66758 = state_66737__$1;
(statearr_66742_66758[(2)] = inst_66707);

(statearr_66742_66758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66738 === (5))){
var _ = (function (){var statearr_66743 = state_66737;
(statearr_66743[(4)] = cljs.core.rest((state_66737[(4)])));

return statearr_66743;
})();
var state_66737__$1 = state_66737;
var ex66741 = (state_66737__$1[(2)]);
var statearr_66744_66759 = state_66737__$1;
(statearr_66744_66759[(5)] = ex66741);


if((ex66741 instanceof Error)){
var statearr_66745_66760 = state_66737__$1;
(statearr_66745_66760[(1)] = (4));

(statearr_66745_66760[(5)] = null);

} else {
throw ex66741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66738 === (6))){
var inst_66715 = (state_66737[(2)]);
var inst_66716 = fluree.db.util.async.throw_err(inst_66715);
var inst_66717 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_66716);
var inst_66718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66719 = [inst_66716];
var inst_66720 = (new cljs.core.PersistentVector(null,1,(5),inst_66718,inst_66719,null));
var inst_66721 = cljs.core.count(inst_66720);
var inst_66722 = ((9) + inst_66721);
var inst_66723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66724 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66726 = [inst_66716];
var inst_66727 = (new cljs.core.PersistentVector(null,1,(5),inst_66725,inst_66726,null));
var inst_66728 = ["max",inst_66727,inst_66717];
var inst_66729 = cljs.core.PersistentHashMap.fromArrays(inst_66724,inst_66728);
var inst_66730 = [inst_66729,inst_66722];
var inst_66731 = (new cljs.core.PersistentVector(null,2,(5),inst_66723,inst_66730,null));
var inst_66732 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66731);
var _ = (function (){var statearr_66746 = state_66737;
(statearr_66746[(4)] = cljs.core.rest((state_66737[(4)])));

return statearr_66746;
})();
var state_66737__$1 = (function (){var statearr_66747 = state_66737;
(statearr_66747[(7)] = inst_66732);

return statearr_66747;
})();
var statearr_66748_66761 = state_66737__$1;
(statearr_66748_66761[(2)] = inst_66717);

(statearr_66748_66761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66749 = [null,null,null,null,null,null,null,null];
(statearr_66749[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66749[(1)] = (1));

return statearr_66749;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66737){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66737);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66750){var ex__2687__auto__ = e66750;
var statearr_66751_66762 = state_66737;
(statearr_66751_66762[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66737[(4)]))){
var statearr_66752_66763 = state_66737;
(statearr_66752_66763[(1)] = cljs.core.first((state_66737[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66764 = state_66737;
state_66737 = G__66764;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66737){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66753 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66753[(6)] = c__2706__auto__);

return statearr_66753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq66705){
var G__66706 = cljs.core.first(seq66705);
var seq66705__$1 = cljs.core.next(seq66705);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66706,seq66705__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66814 = arguments.length;
var i__5770__auto___66815 = (0);
while(true){
if((i__5770__auto___66815 < len__5769__auto___66814)){
args__5775__auto__.push((arguments[i__5770__auto___66815]));

var G__66816 = (i__5770__auto___66815 + (1));
i__5770__auto___66815 = G__66816;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66797){
var state_val_66798 = (state_66797[(1)]);
if((state_val_66798 === (1))){
var state_66797__$1 = state_66797;
var statearr_66799_66817 = state_66797__$1;
(statearr_66799_66817[(2)] = null);

(statearr_66799_66817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66798 === (2))){
var _ = (function (){var statearr_66800 = state_66797;
(statearr_66800[(4)] = cljs.core.cons((5),(state_66797[(4)])));

return statearr_66800;
})();
var inst_66773 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66797__$1 = state_66797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66797__$1,(6),inst_66773);
} else {
if((state_val_66798 === (3))){
var inst_66795 = (state_66797[(2)]);
var state_66797__$1 = state_66797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66797__$1,inst_66795);
} else {
if((state_val_66798 === (4))){
var inst_66767 = (state_66797[(2)]);
var state_66797__$1 = state_66797;
var statearr_66802_66818 = state_66797__$1;
(statearr_66802_66818[(2)] = inst_66767);

(statearr_66802_66818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66798 === (5))){
var _ = (function (){var statearr_66803 = state_66797;
(statearr_66803[(4)] = cljs.core.rest((state_66797[(4)])));

return statearr_66803;
})();
var state_66797__$1 = state_66797;
var ex66801 = (state_66797__$1[(2)]);
var statearr_66804_66819 = state_66797__$1;
(statearr_66804_66819[(5)] = ex66801);


if((ex66801 instanceof Error)){
var statearr_66805_66820 = state_66797__$1;
(statearr_66805_66820[(1)] = (4));

(statearr_66805_66820[(5)] = null);

} else {
throw ex66801;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66798 === (6))){
var inst_66775 = (state_66797[(2)]);
var inst_66776 = fluree.db.util.async.throw_err(inst_66775);
var inst_66777 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_66776);
var inst_66778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66779 = [inst_66776];
var inst_66780 = (new cljs.core.PersistentVector(null,1,(5),inst_66778,inst_66779,null));
var inst_66781 = cljs.core.count(inst_66780);
var inst_66782 = ((9) + inst_66781);
var inst_66783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66784 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66786 = [inst_66776];
var inst_66787 = (new cljs.core.PersistentVector(null,1,(5),inst_66785,inst_66786,null));
var inst_66788 = ["min",inst_66787,inst_66777];
var inst_66789 = cljs.core.PersistentHashMap.fromArrays(inst_66784,inst_66788);
var inst_66790 = [inst_66789,inst_66782];
var inst_66791 = (new cljs.core.PersistentVector(null,2,(5),inst_66783,inst_66790,null));
var inst_66792 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66791);
var _ = (function (){var statearr_66806 = state_66797;
(statearr_66806[(4)] = cljs.core.rest((state_66797[(4)])));

return statearr_66806;
})();
var state_66797__$1 = (function (){var statearr_66807 = state_66797;
(statearr_66807[(7)] = inst_66792);

return statearr_66807;
})();
var statearr_66808_66821 = state_66797__$1;
(statearr_66808_66821[(2)] = inst_66777);

(statearr_66808_66821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66809 = [null,null,null,null,null,null,null,null];
(statearr_66809[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66809[(1)] = (1));

return statearr_66809;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66797){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66797);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66810){var ex__2687__auto__ = e66810;
var statearr_66811_66822 = state_66797;
(statearr_66811_66822[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66797[(4)]))){
var statearr_66812_66823 = state_66797;
(statearr_66812_66823[(1)] = cljs.core.first((state_66797[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66824 = state_66797;
state_66797 = G__66824;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66797){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66813 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66813[(6)] = c__2706__auto__);

return statearr_66813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq66765){
var G__66766 = cljs.core.first(seq66765);
var seq66765__$1 = cljs.core.next(seq66765);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66766,seq66765__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__66826 = arguments.length;
switch (G__66826) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66871){
var state_val_66872 = (state_66871[(1)]);
if((state_val_66872 === (7))){
var state_66871__$1 = state_66871;
var statearr_66873_67010 = state_66871__$1;
(statearr_66873_67010[(2)] = query_map);

(statearr_66873_67010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (1))){
var state_66871__$1 = state_66871;
var statearr_66874_67011 = state_66871__$1;
(statearr_66874_67011[(2)] = null);

(statearr_66874_67011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (4))){
var inst_66827 = (state_66871[(2)]);
var state_66871__$1 = state_66871;
var statearr_66875_67012 = state_66871__$1;
(statearr_66875_67012[(2)] = inst_66827);

(statearr_66875_67012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (13))){
var inst_66849 = (state_66871[(7)]);
var inst_66853 = (state_66871[(2)]);
var inst_66854 = fluree.db.util.async.throw_err(inst_66853);
var inst_66855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66854,(0),null);
var inst_66856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66854,(1),null);
var inst_66857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66858 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66860 = [inst_66849];
var inst_66861 = (new cljs.core.PersistentVector(null,1,(5),inst_66859,inst_66860,null));
var inst_66862 = ["query",inst_66861,inst_66855];
var inst_66863 = cljs.core.PersistentHashMap.fromArrays(inst_66858,inst_66862);
var inst_66864 = [inst_66863,inst_66856];
var inst_66865 = (new cljs.core.PersistentVector(null,2,(5),inst_66857,inst_66864,null));
var inst_66866 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66865);
var _ = (function (){var statearr_66876 = state_66871;
(statearr_66876[(4)] = cljs.core.rest((state_66871[(4)])));

return statearr_66876;
})();
var state_66871__$1 = (function (){var statearr_66877 = state_66871;
(statearr_66877[(8)] = inst_66866);

return statearr_66877;
})();
var statearr_66878_67013 = state_66871__$1;
(statearr_66878_67013[(2)] = inst_66855);

(statearr_66878_67013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (6))){
var state_66871__$1 = state_66871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66871__$1,(9),query_map);
} else {
if((state_val_66872 === (3))){
var inst_66869 = (state_66871[(2)]);
var state_66871__$1 = state_66871;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66871__$1,inst_66869);
} else {
if((state_val_66872 === (12))){
var inst_66849 = (state_66871[(7)]);
var inst_66849__$1 = (state_66871[(2)]);
var inst_66850 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66851 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_66850,inst_66849__$1);
var state_66871__$1 = (function (){var statearr_66879 = state_66871;
(statearr_66879[(7)] = inst_66849__$1);

return statearr_66879;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66871__$1,(13),inst_66851);
} else {
if((state_val_66872 === (2))){
var _ = (function (){var statearr_66880 = state_66871;
(statearr_66880[(4)] = cljs.core.cons((5),(state_66871[(4)])));

return statearr_66880;
})();
var inst_66836 = fluree.db.util.async.channel_QMARK_(query_map);
var state_66871__$1 = state_66871;
if(inst_66836){
var statearr_66881_67014 = state_66871__$1;
(statearr_66881_67014[(1)] = (6));

} else {
var statearr_66882_67015 = state_66871__$1;
(statearr_66882_67015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (11))){
var inst_66843 = (state_66871[(9)]);
var state_66871__$1 = state_66871;
var statearr_66884_67016 = state_66871__$1;
(statearr_66884_67016[(2)] = inst_66843);

(statearr_66884_67016[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (9))){
var inst_66839 = (state_66871[(2)]);
var inst_66840 = fluree.db.util.async.throw_err(inst_66839);
var state_66871__$1 = state_66871;
var statearr_66885_67017 = state_66871__$1;
(statearr_66885_67017[(2)] = inst_66840);

(statearr_66885_67017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (5))){
var _ = (function (){var statearr_66886 = state_66871;
(statearr_66886[(4)] = cljs.core.rest((state_66871[(4)])));

return statearr_66886;
})();
var state_66871__$1 = state_66871;
var ex66883 = (state_66871__$1[(2)]);
var statearr_66887_67018 = state_66871__$1;
(statearr_66887_67018[(5)] = ex66883);


if((ex66883 instanceof Error)){
var statearr_66888_67019 = state_66871__$1;
(statearr_66888_67019[(1)] = (4));

(statearr_66888_67019[(5)] = null);

} else {
throw ex66883;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (10))){
var inst_66843 = (state_66871[(9)]);
var inst_66846 = fluree.db.util.json.parse(inst_66843);
var state_66871__$1 = state_66871;
var statearr_66889_67020 = state_66871__$1;
(statearr_66889_67020[(2)] = inst_66846);

(statearr_66889_67020[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66872 === (8))){
var inst_66843 = (state_66871[(9)]);
var inst_66843__$1 = (state_66871[(2)]);
var inst_66844 = typeof inst_66843__$1 === 'string';
var state_66871__$1 = (function (){var statearr_66890 = state_66871;
(statearr_66890[(9)] = inst_66843__$1);

return statearr_66890;
})();
if(cljs.core.truth_(inst_66844)){
var statearr_66891_67021 = state_66871__$1;
(statearr_66891_67021[(1)] = (10));

} else {
var statearr_66892_67022 = state_66871__$1;
(statearr_66892_67022[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_66893 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66893[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_66893[(1)] = (1));

return statearr_66893;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66871){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66871);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66894){var ex__2687__auto__ = e66894;
var statearr_66895_67023 = state_66871;
(statearr_66895_67023[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66871[(4)]))){
var statearr_66896_67024 = state_66871;
(statearr_66896_67024[(1)] = cljs.core.first((state_66871[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67025 = state_66871;
state_66871 = G__67025;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66871){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66897 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66897[(6)] = c__2706__auto__);

return statearr_66897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66968){
var state_val_66969 = (state_66968[(1)]);
if((state_val_66969 === (7))){
var state_66968__$1 = state_66968;
var statearr_66970_67026 = state_66968__$1;
(statearr_66970_67026[(2)] = select);

(statearr_66970_67026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (20))){
var inst_66938 = (state_66968[(2)]);
var inst_66939 = fluree.db.util.async.channel_QMARK_(limit);
var state_66968__$1 = (function (){var statearr_66971 = state_66968;
(statearr_66971[(7)] = inst_66938);

return statearr_66971;
})();
if(inst_66939){
var statearr_66972_67027 = state_66968__$1;
(statearr_66972_67027[(1)] = (22));

} else {
var statearr_66973_67028 = state_66968__$1;
(statearr_66973_67028[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (1))){
var state_66968__$1 = state_66968;
var statearr_66974_67029 = state_66968__$1;
(statearr_66974_67029[(2)] = null);

(statearr_66974_67029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (24))){
var inst_66922 = (state_66968[(8)]);
var inst_66914 = (state_66968[(9)]);
var inst_66938 = (state_66968[(7)]);
var inst_66930 = (state_66968[(10)]);
var inst_66946 = (state_66968[(2)]);
var inst_66947 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66948 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_66947,inst_66914,inst_66922,inst_66930,inst_66938,inst_66946);
var state_66968__$1 = state_66968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66968__$1,(26),inst_66948);
} else {
if((state_val_66969 === (4))){
var inst_66898 = (state_66968[(2)]);
var state_66968__$1 = state_66968;
var statearr_66975_67030 = state_66968__$1;
(statearr_66975_67030[(2)] = inst_66898);

(statearr_66975_67030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (15))){
var state_66968__$1 = state_66968;
var statearr_66976_67031 = state_66968__$1;
(statearr_66976_67031[(2)] = where);

(statearr_66976_67031[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (21))){
var inst_66934 = (state_66968[(2)]);
var inst_66935 = fluree.db.util.async.throw_err(inst_66934);
var state_66968__$1 = state_66968;
var statearr_66977_67032 = state_66968__$1;
(statearr_66977_67032[(2)] = inst_66935);

(statearr_66977_67032[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (13))){
var inst_66918 = (state_66968[(2)]);
var inst_66919 = fluree.db.util.async.throw_err(inst_66918);
var state_66968__$1 = state_66968;
var statearr_66978_67033 = state_66968__$1;
(statearr_66978_67033[(2)] = inst_66919);

(statearr_66978_67033[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (22))){
var state_66968__$1 = state_66968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66968__$1,(25),limit);
} else {
if((state_val_66969 === (6))){
var state_66968__$1 = state_66968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66968__$1,(9),select);
} else {
if((state_val_66969 === (25))){
var inst_66942 = (state_66968[(2)]);
var inst_66943 = fluree.db.util.async.throw_err(inst_66942);
var state_66968__$1 = state_66968;
var statearr_66979_67034 = state_66968__$1;
(statearr_66979_67034[(2)] = inst_66943);

(statearr_66979_67034[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (17))){
var inst_66926 = (state_66968[(2)]);
var inst_66927 = fluree.db.util.async.throw_err(inst_66926);
var state_66968__$1 = state_66968;
var statearr_66980_67035 = state_66968__$1;
(statearr_66980_67035[(2)] = inst_66927);

(statearr_66980_67035[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (3))){
var inst_66966 = (state_66968[(2)]);
var state_66968__$1 = state_66968;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66968__$1,inst_66966);
} else {
if((state_val_66969 === (12))){
var inst_66922 = (state_66968[(2)]);
var inst_66923 = fluree.db.util.async.channel_QMARK_(where);
var state_66968__$1 = (function (){var statearr_66981 = state_66968;
(statearr_66981[(8)] = inst_66922);

return statearr_66981;
})();
if(inst_66923){
var statearr_66982_67036 = state_66968__$1;
(statearr_66982_67036[(1)] = (14));

} else {
var statearr_66983_67037 = state_66968__$1;
(statearr_66983_67037[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (2))){
var _ = (function (){var statearr_66984 = state_66968;
(statearr_66984[(4)] = cljs.core.cons((5),(state_66968[(4)])));

return statearr_66984;
})();
var inst_66907 = fluree.db.util.async.channel_QMARK_(select);
var state_66968__$1 = state_66968;
if(inst_66907){
var statearr_66985_67038 = state_66968__$1;
(statearr_66985_67038[(1)] = (6));

} else {
var statearr_66986_67039 = state_66968__$1;
(statearr_66986_67039[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (23))){
var state_66968__$1 = state_66968;
var statearr_66987_67040 = state_66968__$1;
(statearr_66987_67040[(2)] = limit);

(statearr_66987_67040[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (19))){
var state_66968__$1 = state_66968;
var statearr_66988_67041 = state_66968__$1;
(statearr_66988_67041[(2)] = block);

(statearr_66988_67041[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (11))){
var state_66968__$1 = state_66968;
var statearr_66990_67042 = state_66968__$1;
(statearr_66990_67042[(2)] = from);

(statearr_66990_67042[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (9))){
var inst_66910 = (state_66968[(2)]);
var inst_66911 = fluree.db.util.async.throw_err(inst_66910);
var state_66968__$1 = state_66968;
var statearr_66991_67043 = state_66968__$1;
(statearr_66991_67043[(2)] = inst_66911);

(statearr_66991_67043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (5))){
var _ = (function (){var statearr_66992 = state_66968;
(statearr_66992[(4)] = cljs.core.rest((state_66968[(4)])));

return statearr_66992;
})();
var state_66968__$1 = state_66968;
var ex66989 = (state_66968__$1[(2)]);
var statearr_66993_67044 = state_66968__$1;
(statearr_66993_67044[(5)] = ex66989);


if((ex66989 instanceof Error)){
var statearr_66994_67045 = state_66968__$1;
(statearr_66994_67045[(1)] = (4));

(statearr_66994_67045[(5)] = null);

} else {
throw ex66989;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (14))){
var state_66968__$1 = state_66968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66968__$1,(17),where);
} else {
if((state_val_66969 === (26))){
var inst_66922 = (state_66968[(8)]);
var inst_66914 = (state_66968[(9)]);
var inst_66938 = (state_66968[(7)]);
var inst_66930 = (state_66968[(10)]);
var inst_66950 = (state_66968[(2)]);
var inst_66951 = fluree.db.util.async.throw_err(inst_66950);
var inst_66952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66951,(0),null);
var inst_66953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66951,(1),null);
var inst_66954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66955 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66957 = [inst_66914,inst_66922,inst_66930,inst_66938];
var inst_66958 = (new cljs.core.PersistentVector(null,4,(5),inst_66956,inst_66957,null));
var inst_66959 = ["query",inst_66958,inst_66952];
var inst_66960 = cljs.core.PersistentHashMap.fromArrays(inst_66955,inst_66959);
var inst_66961 = [inst_66960,inst_66953];
var inst_66962 = (new cljs.core.PersistentVector(null,2,(5),inst_66954,inst_66961,null));
var inst_66963 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66962);
var _ = (function (){var statearr_66995 = state_66968;
(statearr_66995[(4)] = cljs.core.rest((state_66968[(4)])));

return statearr_66995;
})();
var state_66968__$1 = (function (){var statearr_66996 = state_66968;
(statearr_66996[(11)] = inst_66963);

return statearr_66996;
})();
var statearr_66997_67046 = state_66968__$1;
(statearr_66997_67046[(2)] = inst_66952);

(statearr_66997_67046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (16))){
var inst_66930 = (state_66968[(2)]);
var inst_66931 = fluree.db.util.async.channel_QMARK_(block);
var state_66968__$1 = (function (){var statearr_66998 = state_66968;
(statearr_66998[(10)] = inst_66930);

return statearr_66998;
})();
if(inst_66931){
var statearr_66999_67047 = state_66968__$1;
(statearr_66999_67047[(1)] = (18));

} else {
var statearr_67000_67048 = state_66968__$1;
(statearr_67000_67048[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66969 === (10))){
var state_66968__$1 = state_66968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66968__$1,(13),from);
} else {
if((state_val_66969 === (18))){
var state_66968__$1 = state_66968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66968__$1,(21),block);
} else {
if((state_val_66969 === (8))){
var inst_66914 = (state_66968[(2)]);
var inst_66915 = fluree.db.util.async.channel_QMARK_(from);
var state_66968__$1 = (function (){var statearr_67001 = state_66968;
(statearr_67001[(9)] = inst_66914);

return statearr_67001;
})();
if(inst_66915){
var statearr_67002_67049 = state_66968__$1;
(statearr_67002_67049[(1)] = (10));

} else {
var statearr_67003_67050 = state_66968__$1;
(statearr_67003_67050[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_67004 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67004[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_67004[(1)] = (1));

return statearr_67004;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_66968){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66968);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67005){var ex__2687__auto__ = e67005;
var statearr_67006_67051 = state_66968;
(statearr_67006_67051[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66968[(4)]))){
var statearr_67007_67052 = state_66968;
(statearr_67007_67052[(1)] = cljs.core.first((state_66968[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67053 = state_66968;
state_66968 = G__67053;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_66968){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_66968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67008 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67008[(6)] = c__2706__auto__);

return statearr_67008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67109){
var state_val_67110 = (state_67109[(1)]);
if((state_val_67110 === (7))){
var state_67109__$1 = state_67109;
var statearr_67111_67142 = state_67109__$1;
(statearr_67111_67142[(2)] = startSubject);

(statearr_67111_67142[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (1))){
var state_67109__$1 = state_67109;
var statearr_67112_67143 = state_67109__$1;
(statearr_67112_67143[(2)] = null);

(statearr_67112_67143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (4))){
var inst_67054 = (state_67109[(2)]);
var state_67109__$1 = state_67109;
var statearr_67113_67144 = state_67109__$1;
(statearr_67113_67144[(2)] = inst_67054);

(statearr_67113_67144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (15))){
var inst_67086 = (state_67109[(2)]);
var inst_67087 = fluree.db.util.async.throw_err(inst_67086);
var inst_67088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67087,(0),null);
var inst_67089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67087,(1),null);
var inst_67090 = cljs.core.empty_QMARK_(inst_67088);
var state_67109__$1 = (function (){var statearr_67114 = state_67109;
(statearr_67114[(7)] = inst_67089);

return statearr_67114;
})();
if(inst_67090){
var statearr_67115_67145 = state_67109__$1;
(statearr_67115_67145[(1)] = (16));

} else {
var statearr_67116_67146 = state_67109__$1;
(statearr_67116_67146[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (13))){
var inst_67070 = (state_67109[(8)]);
var inst_67082 = (state_67109[(9)]);
var inst_67074 = (state_67109[(10)]);
var inst_67082__$1 = (state_67109[(2)]);
var inst_67083 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67084 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_67083,inst_67070,inst_67074,inst_67082__$1);
var state_67109__$1 = (function (){var statearr_67117 = state_67109;
(statearr_67117[(9)] = inst_67082__$1);

return statearr_67117;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67109__$1,(15),inst_67084);
} else {
if((state_val_67110 === (6))){
var state_67109__$1 = state_67109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67109__$1,(9),startSubject);
} else {
if((state_val_67110 === (17))){
var state_67109__$1 = state_67109;
var statearr_67118_67147 = state_67109__$1;
(statearr_67118_67147[(2)] = true);

(statearr_67118_67147[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (3))){
var inst_67107 = (state_67109[(2)]);
var state_67109__$1 = state_67109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67109__$1,inst_67107);
} else {
if((state_val_67110 === (12))){
var state_67109__$1 = state_67109;
var statearr_67119_67148 = state_67109__$1;
(statearr_67119_67148[(2)] = endSubject);

(statearr_67119_67148[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (2))){
var _ = (function (){var statearr_67120 = state_67109;
(statearr_67120[(4)] = cljs.core.cons((5),(state_67109[(4)])));

return statearr_67120;
})();
var inst_67063 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_67109__$1 = state_67109;
if(inst_67063){
var statearr_67121_67149 = state_67109__$1;
(statearr_67121_67149[(1)] = (6));

} else {
var statearr_67122_67150 = state_67109__$1;
(statearr_67122_67150[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (11))){
var state_67109__$1 = state_67109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67109__$1,(14),endSubject);
} else {
if((state_val_67110 === (9))){
var inst_67066 = (state_67109[(2)]);
var inst_67067 = fluree.db.util.async.throw_err(inst_67066);
var state_67109__$1 = state_67109;
var statearr_67124_67151 = state_67109__$1;
(statearr_67124_67151[(2)] = inst_67067);

(statearr_67124_67151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (5))){
var _ = (function (){var statearr_67125 = state_67109;
(statearr_67125[(4)] = cljs.core.rest((state_67109[(4)])));

return statearr_67125;
})();
var state_67109__$1 = state_67109;
var ex67123 = (state_67109__$1[(2)]);
var statearr_67126_67152 = state_67109__$1;
(statearr_67126_67152[(5)] = ex67123);


if((ex67123 instanceof Error)){
var statearr_67127_67153 = state_67109__$1;
(statearr_67127_67153[(1)] = (4));

(statearr_67127_67153[(5)] = null);

} else {
throw ex67123;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (14))){
var inst_67078 = (state_67109[(2)]);
var inst_67079 = fluree.db.util.async.throw_err(inst_67078);
var state_67109__$1 = state_67109;
var statearr_67128_67154 = state_67109__$1;
(statearr_67128_67154[(2)] = inst_67079);

(statearr_67128_67154[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (16))){
var state_67109__$1 = state_67109;
var statearr_67129_67155 = state_67109__$1;
(statearr_67129_67155[(2)] = false);

(statearr_67129_67155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (10))){
var inst_67073 = (state_67109[(2)]);
var inst_67074 = fluree.db.util.async.throw_err(inst_67073);
var inst_67075 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_67109__$1 = (function (){var statearr_67130 = state_67109;
(statearr_67130[(10)] = inst_67074);

return statearr_67130;
})();
if(inst_67075){
var statearr_67131_67156 = state_67109__$1;
(statearr_67131_67156[(1)] = (11));

} else {
var statearr_67132_67157 = state_67109__$1;
(statearr_67132_67157[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (18))){
var inst_67070 = (state_67109[(8)]);
var inst_67082 = (state_67109[(9)]);
var inst_67074 = (state_67109[(10)]);
var inst_67089 = (state_67109[(7)]);
var inst_67094 = (state_67109[(2)]);
var inst_67095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67096 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67098 = [inst_67070,inst_67074,inst_67082];
var inst_67099 = (new cljs.core.PersistentVector(null,3,(5),inst_67097,inst_67098,null));
var inst_67100 = ["relationship?",inst_67099,inst_67094];
var inst_67101 = cljs.core.PersistentHashMap.fromArrays(inst_67096,inst_67100);
var inst_67102 = [inst_67101,inst_67089];
var inst_67103 = (new cljs.core.PersistentVector(null,2,(5),inst_67095,inst_67102,null));
var inst_67104 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67103);
var _ = (function (){var statearr_67133 = state_67109;
(statearr_67133[(4)] = cljs.core.rest((state_67109[(4)])));

return statearr_67133;
})();
var state_67109__$1 = (function (){var statearr_67134 = state_67109;
(statearr_67134[(11)] = inst_67104);

return statearr_67134;
})();
var statearr_67135_67158 = state_67109__$1;
(statearr_67135_67158[(2)] = inst_67094);

(statearr_67135_67158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67110 === (8))){
var inst_67070 = (state_67109[(2)]);
var inst_67071 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_67109__$1 = (function (){var statearr_67136 = state_67109;
(statearr_67136[(8)] = inst_67070);

return statearr_67136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67109__$1,(10),inst_67071);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_67137 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67137[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_67137[(1)] = (1));

return statearr_67137;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_67109){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67109);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67138){var ex__2687__auto__ = e67138;
var statearr_67139_67159 = state_67109;
(statearr_67139_67159[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67109[(4)]))){
var statearr_67140_67160 = state_67109;
(statearr_67140_67160[(1)] = cljs.core.first((state_67109[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67161 = state_67109;
state_67109 = G__67161;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = function(state_67109){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_67109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67141 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67141[(6)] = c__2706__auto__);

return statearr_67141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67198){
var state_val_67199 = (state_67198[(1)]);
if((state_val_67199 === (7))){
var state_67198__$1 = state_67198;
var statearr_67200_67220 = state_67198__$1;
(statearr_67200_67220[(2)] = pred_name);

(statearr_67200_67220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67199 === (1))){
var state_67198__$1 = state_67198;
var statearr_67201_67221 = state_67198__$1;
(statearr_67201_67221[(2)] = null);

(statearr_67201_67221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67199 === (4))){
var inst_67162 = (state_67198[(2)]);
var state_67198__$1 = state_67198;
var statearr_67202_67222 = state_67198__$1;
(statearr_67202_67222[(2)] = inst_67162);

(statearr_67202_67222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67199 === (6))){
var state_67198__$1 = state_67198;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67198__$1,(9),pred_name);
} else {
if((state_val_67199 === (3))){
var inst_67196 = (state_67198[(2)]);
var state_67198__$1 = state_67198;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67198__$1,inst_67196);
} else {
if((state_val_67199 === (2))){
var _ = (function (){var statearr_67204 = state_67198;
(statearr_67204[(4)] = cljs.core.cons((5),(state_67198[(4)])));

return statearr_67204;
})();
var inst_67171 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_67198__$1 = state_67198;
if(inst_67171){
var statearr_67205_67223 = state_67198__$1;
(statearr_67205_67223[(1)] = (6));

} else {
var statearr_67206_67224 = state_67198__$1;
(statearr_67206_67224[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67199 === (9))){
var inst_67174 = (state_67198[(2)]);
var inst_67175 = fluree.db.util.async.throw_err(inst_67174);
var state_67198__$1 = state_67198;
var statearr_67207_67225 = state_67198__$1;
(statearr_67207_67225[(2)] = inst_67175);

(statearr_67207_67225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67199 === (5))){
var _ = (function (){var statearr_67208 = state_67198;
(statearr_67208[(4)] = cljs.core.rest((state_67198[(4)])));

return statearr_67208;
})();
var state_67198__$1 = state_67198;
var ex67203 = (state_67198__$1[(2)]);
var statearr_67209_67226 = state_67198__$1;
(statearr_67209_67226[(5)] = ex67203);


if((ex67203 instanceof Error)){
var statearr_67210_67227 = state_67198__$1;
(statearr_67210_67227[(1)] = (4));

(statearr_67210_67227[(5)] = null);

} else {
throw ex67203;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67199 === (10))){
var inst_67178 = (state_67198[(7)]);
var inst_67182 = (state_67198[(2)]);
var inst_67183 = fluree.db.util.async.throw_err(inst_67182);
var inst_67184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67183,(0),null);
var inst_67185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67183,(1),null);
var inst_67186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67187 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67188 = ["max-pred-val",inst_67178,inst_67184];
var inst_67189 = cljs.core.PersistentHashMap.fromArrays(inst_67187,inst_67188);
var inst_67190 = (inst_67185 + (10));
var inst_67191 = [inst_67189,inst_67190];
var inst_67192 = (new cljs.core.PersistentVector(null,2,(5),inst_67186,inst_67191,null));
var inst_67193 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67192);
var _ = (function (){var statearr_67211 = state_67198;
(statearr_67211[(4)] = cljs.core.rest((state_67198[(4)])));

return statearr_67211;
})();
var state_67198__$1 = (function (){var statearr_67212 = state_67198;
(statearr_67212[(8)] = inst_67193);

return statearr_67212;
})();
var statearr_67213_67228 = state_67198__$1;
(statearr_67213_67228[(2)] = inst_67184);

(statearr_67213_67228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67199 === (8))){
var inst_67178 = (state_67198[(7)]);
var inst_67178__$1 = (state_67198[(2)]);
var inst_67179 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67180 = fluree.db.dbfunctions.internal.max_pred_val(inst_67179,inst_67178__$1,null);
var state_67198__$1 = (function (){var statearr_67214 = state_67198;
(statearr_67214[(7)] = inst_67178__$1);

return statearr_67214;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67198__$1,(10),inst_67180);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_67215 = [null,null,null,null,null,null,null,null,null];
(statearr_67215[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__);

(statearr_67215[(1)] = (1));

return statearr_67215;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1 = (function (state_67198){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67198);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67216){var ex__2687__auto__ = e67216;
var statearr_67217_67229 = state_67198;
(statearr_67217_67229[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67198[(4)]))){
var statearr_67218_67230 = state_67198;
(statearr_67218_67230[(1)] = cljs.core.first((state_67198[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67231 = state_67198;
state_67198 = G__67231;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = function(state_67198){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1.call(this,state_67198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67219 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67219[(6)] = c__2706__auto__);

return statearr_67219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67258){
var state_val_67259 = (state_67258[(1)]);
if((state_val_67259 === (7))){
var state_67258__$1 = state_67258;
var statearr_67260_67279 = state_67258__$1;
(statearr_67260_67279[(2)] = n);

(statearr_67260_67279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67259 === (1))){
var state_67258__$1 = state_67258;
var statearr_67261_67280 = state_67258__$1;
(statearr_67261_67280[(2)] = null);

(statearr_67261_67280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67259 === (4))){
var inst_67232 = (state_67258[(2)]);
var state_67258__$1 = state_67258;
var statearr_67262_67281 = state_67258__$1;
(statearr_67262_67281[(2)] = inst_67232);

(statearr_67262_67281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67259 === (6))){
var state_67258__$1 = state_67258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67258__$1,(9),n);
} else {
if((state_val_67259 === (3))){
var inst_67256 = (state_67258[(2)]);
var state_67258__$1 = state_67258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67258__$1,inst_67256);
} else {
if((state_val_67259 === (2))){
var _ = (function (){var statearr_67264 = state_67258;
(statearr_67264[(4)] = cljs.core.cons((5),(state_67258[(4)])));

return statearr_67264;
})();
var inst_67238 = fluree.db.util.async.channel_QMARK_(n);
var state_67258__$1 = state_67258;
if(inst_67238){
var statearr_67265_67282 = state_67258__$1;
(statearr_67265_67282[(1)] = (6));

} else {
var statearr_67266_67283 = state_67258__$1;
(statearr_67266_67283[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67259 === (9))){
var inst_67241 = (state_67258[(2)]);
var inst_67242 = fluree.db.util.async.throw_err(inst_67241);
var state_67258__$1 = state_67258;
var statearr_67267_67284 = state_67258__$1;
(statearr_67267_67284[(2)] = inst_67242);

(statearr_67267_67284[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67259 === (5))){
var _ = (function (){var statearr_67268 = state_67258;
(statearr_67268[(4)] = cljs.core.rest((state_67258[(4)])));

return statearr_67268;
})();
var state_67258__$1 = state_67258;
var ex67263 = (state_67258__$1[(2)]);
var statearr_67269_67285 = state_67258__$1;
(statearr_67269_67285[(5)] = ex67263);


if((ex67263 instanceof Error)){
var statearr_67270_67286 = state_67258__$1;
(statearr_67270_67286[(1)] = (4));

(statearr_67270_67286[(5)] = null);

} else {
throw ex67263;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67259 === (8))){
var inst_67245 = (state_67258[(2)]);
var inst_67246 = fluree.db.dbfunctions.internal.inc(inst_67245);
var inst_67247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67248 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67249 = ["inc",inst_67245,inst_67246];
var inst_67250 = cljs.core.PersistentHashMap.fromArrays(inst_67248,inst_67249);
var inst_67251 = [inst_67250,(10)];
var inst_67252 = (new cljs.core.PersistentVector(null,2,(5),inst_67247,inst_67251,null));
var inst_67253 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67252);
var _ = (function (){var statearr_67271 = state_67258;
(statearr_67271[(4)] = cljs.core.rest((state_67258[(4)])));

return statearr_67271;
})();
var state_67258__$1 = (function (){var statearr_67272 = state_67258;
(statearr_67272[(7)] = inst_67253);

return statearr_67272;
})();
var statearr_67273_67287 = state_67258__$1;
(statearr_67273_67287[(2)] = inst_67246);

(statearr_67273_67287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0 = (function (){
var statearr_67274 = [null,null,null,null,null,null,null,null];
(statearr_67274[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__);

(statearr_67274[(1)] = (1));

return statearr_67274;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1 = (function (state_67258){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67258);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67275){var ex__2687__auto__ = e67275;
var statearr_67276_67288 = state_67258;
(statearr_67276_67288[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67258[(4)]))){
var statearr_67277_67289 = state_67258;
(statearr_67277_67289[(1)] = cljs.core.first((state_67258[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67290 = state_67258;
state_67258 = G__67290;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = function(state_67258){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1.call(this,state_67258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67278 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67278[(6)] = c__2706__auto__);

return statearr_67278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67317){
var state_val_67318 = (state_67317[(1)]);
if((state_val_67318 === (7))){
var state_67317__$1 = state_67317;
var statearr_67319_67338 = state_67317__$1;
(statearr_67319_67338[(2)] = n);

(statearr_67319_67338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67318 === (1))){
var state_67317__$1 = state_67317;
var statearr_67320_67339 = state_67317__$1;
(statearr_67320_67339[(2)] = null);

(statearr_67320_67339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67318 === (4))){
var inst_67291 = (state_67317[(2)]);
var state_67317__$1 = state_67317;
var statearr_67321_67340 = state_67317__$1;
(statearr_67321_67340[(2)] = inst_67291);

(statearr_67321_67340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67318 === (6))){
var state_67317__$1 = state_67317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67317__$1,(9),n);
} else {
if((state_val_67318 === (3))){
var inst_67315 = (state_67317[(2)]);
var state_67317__$1 = state_67317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67317__$1,inst_67315);
} else {
if((state_val_67318 === (2))){
var _ = (function (){var statearr_67323 = state_67317;
(statearr_67323[(4)] = cljs.core.cons((5),(state_67317[(4)])));

return statearr_67323;
})();
var inst_67297 = fluree.db.util.async.channel_QMARK_(n);
var state_67317__$1 = state_67317;
if(inst_67297){
var statearr_67324_67341 = state_67317__$1;
(statearr_67324_67341[(1)] = (6));

} else {
var statearr_67325_67342 = state_67317__$1;
(statearr_67325_67342[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67318 === (9))){
var inst_67300 = (state_67317[(2)]);
var inst_67301 = fluree.db.util.async.throw_err(inst_67300);
var state_67317__$1 = state_67317;
var statearr_67326_67343 = state_67317__$1;
(statearr_67326_67343[(2)] = inst_67301);

(statearr_67326_67343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67318 === (5))){
var _ = (function (){var statearr_67327 = state_67317;
(statearr_67327[(4)] = cljs.core.rest((state_67317[(4)])));

return statearr_67327;
})();
var state_67317__$1 = state_67317;
var ex67322 = (state_67317__$1[(2)]);
var statearr_67328_67344 = state_67317__$1;
(statearr_67328_67344[(5)] = ex67322);


if((ex67322 instanceof Error)){
var statearr_67329_67345 = state_67317__$1;
(statearr_67329_67345[(1)] = (4));

(statearr_67329_67345[(5)] = null);

} else {
throw ex67322;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67318 === (8))){
var inst_67304 = (state_67317[(2)]);
var inst_67305 = fluree.db.dbfunctions.internal.dec(inst_67304);
var inst_67306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67307 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67308 = ["dec",inst_67304,inst_67305];
var inst_67309 = cljs.core.PersistentHashMap.fromArrays(inst_67307,inst_67308);
var inst_67310 = [inst_67309,(10)];
var inst_67311 = (new cljs.core.PersistentVector(null,2,(5),inst_67306,inst_67310,null));
var inst_67312 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67311);
var _ = (function (){var statearr_67330 = state_67317;
(statearr_67330[(4)] = cljs.core.rest((state_67317[(4)])));

return statearr_67330;
})();
var state_67317__$1 = (function (){var statearr_67331 = state_67317;
(statearr_67331[(7)] = inst_67312);

return statearr_67331;
})();
var statearr_67332_67346 = state_67317__$1;
(statearr_67332_67346[(2)] = inst_67305);

(statearr_67332_67346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0 = (function (){
var statearr_67333 = [null,null,null,null,null,null,null,null];
(statearr_67333[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__);

(statearr_67333[(1)] = (1));

return statearr_67333;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1 = (function (state_67317){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67317);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67334){var ex__2687__auto__ = e67334;
var statearr_67335_67347 = state_67317;
(statearr_67335_67347[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67317[(4)]))){
var statearr_67336_67348 = state_67317;
(statearr_67336_67348[(1)] = cljs.core.first((state_67317[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67349 = state_67317;
state_67317 = G__67349;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = function(state_67317){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1.call(this,state_67317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67337 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67337[(6)] = c__2706__auto__);

return statearr_67337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67399 = arguments.length;
var i__5770__auto___67400 = (0);
while(true){
if((i__5770__auto___67400 < len__5769__auto___67399)){
args__5775__auto__.push((arguments[i__5770__auto___67400]));

var G__67401 = (i__5770__auto___67400 + (1));
i__5770__auto___67400 = G__67401;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67382){
var state_val_67383 = (state_67382[(1)]);
if((state_val_67383 === (1))){
var state_67382__$1 = state_67382;
var statearr_67384_67402 = state_67382__$1;
(statearr_67384_67402[(2)] = null);

(statearr_67384_67402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67383 === (2))){
var _ = (function (){var statearr_67385 = state_67382;
(statearr_67385[(4)] = cljs.core.cons((5),(state_67382[(4)])));

return statearr_67385;
})();
var inst_67358 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67382__$1 = state_67382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67382__$1,(6),inst_67358);
} else {
if((state_val_67383 === (3))){
var inst_67380 = (state_67382[(2)]);
var state_67382__$1 = state_67382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67382__$1,inst_67380);
} else {
if((state_val_67383 === (4))){
var inst_67352 = (state_67382[(2)]);
var state_67382__$1 = state_67382;
var statearr_67387_67403 = state_67382__$1;
(statearr_67387_67403[(2)] = inst_67352);

(statearr_67387_67403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67383 === (5))){
var _ = (function (){var statearr_67388 = state_67382;
(statearr_67388[(4)] = cljs.core.rest((state_67382[(4)])));

return statearr_67388;
})();
var state_67382__$1 = state_67382;
var ex67386 = (state_67382__$1[(2)]);
var statearr_67389_67404 = state_67382__$1;
(statearr_67389_67404[(5)] = ex67386);


if((ex67386 instanceof Error)){
var statearr_67390_67405 = state_67382__$1;
(statearr_67390_67405[(1)] = (4));

(statearr_67390_67405[(5)] = null);

} else {
throw ex67386;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67383 === (6))){
var inst_67360 = (state_67382[(2)]);
var inst_67361 = fluree.db.util.async.throw_err(inst_67360);
var inst_67362 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_67361);
var inst_67363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67364 = [inst_67361];
var inst_67365 = (new cljs.core.PersistentVector(null,1,(5),inst_67363,inst_67364,null));
var inst_67366 = cljs.core.count(inst_67365);
var inst_67367 = ((9) + inst_67366);
var inst_67368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67369 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67371 = [inst_67361];
var inst_67372 = (new cljs.core.PersistentVector(null,1,(5),inst_67370,inst_67371,null));
var inst_67373 = ["+",inst_67372,inst_67362];
var inst_67374 = cljs.core.PersistentHashMap.fromArrays(inst_67369,inst_67373);
var inst_67375 = [inst_67374,inst_67367];
var inst_67376 = (new cljs.core.PersistentVector(null,2,(5),inst_67368,inst_67375,null));
var inst_67377 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67376);
var _ = (function (){var statearr_67391 = state_67382;
(statearr_67391[(4)] = cljs.core.rest((state_67382[(4)])));

return statearr_67391;
})();
var state_67382__$1 = (function (){var statearr_67392 = state_67382;
(statearr_67392[(7)] = inst_67377);

return statearr_67392;
})();
var statearr_67393_67406 = state_67382__$1;
(statearr_67393_67406[(2)] = inst_67362);

(statearr_67393_67406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_67394 = [null,null,null,null,null,null,null,null];
(statearr_67394[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_67394[(1)] = (1));

return statearr_67394;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_67382){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67382);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67395){var ex__2687__auto__ = e67395;
var statearr_67396_67407 = state_67382;
(statearr_67396_67407[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67382[(4)]))){
var statearr_67397_67408 = state_67382;
(statearr_67397_67408[(1)] = cljs.core.first((state_67382[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67409 = state_67382;
state_67382 = G__67409;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_67382){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_67382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67398 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67398[(6)] = c__2706__auto__);

return statearr_67398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq67350){
var G__67351 = cljs.core.first(seq67350);
var seq67350__$1 = cljs.core.next(seq67350);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67351,seq67350__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67459 = arguments.length;
var i__5770__auto___67460 = (0);
while(true){
if((i__5770__auto___67460 < len__5769__auto___67459)){
args__5775__auto__.push((arguments[i__5770__auto___67460]));

var G__67461 = (i__5770__auto___67460 + (1));
i__5770__auto___67460 = G__67461;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67442){
var state_val_67443 = (state_67442[(1)]);
if((state_val_67443 === (1))){
var state_67442__$1 = state_67442;
var statearr_67444_67462 = state_67442__$1;
(statearr_67444_67462[(2)] = null);

(statearr_67444_67462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67443 === (2))){
var _ = (function (){var statearr_67445 = state_67442;
(statearr_67445[(4)] = cljs.core.cons((5),(state_67442[(4)])));

return statearr_67445;
})();
var inst_67418 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67442__$1 = state_67442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67442__$1,(6),inst_67418);
} else {
if((state_val_67443 === (3))){
var inst_67440 = (state_67442[(2)]);
var state_67442__$1 = state_67442;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67442__$1,inst_67440);
} else {
if((state_val_67443 === (4))){
var inst_67412 = (state_67442[(2)]);
var state_67442__$1 = state_67442;
var statearr_67447_67463 = state_67442__$1;
(statearr_67447_67463[(2)] = inst_67412);

(statearr_67447_67463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67443 === (5))){
var _ = (function (){var statearr_67448 = state_67442;
(statearr_67448[(4)] = cljs.core.rest((state_67442[(4)])));

return statearr_67448;
})();
var state_67442__$1 = state_67442;
var ex67446 = (state_67442__$1[(2)]);
var statearr_67449_67464 = state_67442__$1;
(statearr_67449_67464[(5)] = ex67446);


if((ex67446 instanceof Error)){
var statearr_67450_67465 = state_67442__$1;
(statearr_67450_67465[(1)] = (4));

(statearr_67450_67465[(5)] = null);

} else {
throw ex67446;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67443 === (6))){
var inst_67420 = (state_67442[(2)]);
var inst_67421 = fluree.db.util.async.throw_err(inst_67420);
var inst_67422 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_67421);
var inst_67423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67424 = [inst_67421];
var inst_67425 = (new cljs.core.PersistentVector(null,1,(5),inst_67423,inst_67424,null));
var inst_67426 = cljs.core.count(inst_67425);
var inst_67427 = ((9) + inst_67426);
var inst_67428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67429 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67431 = [inst_67421];
var inst_67432 = (new cljs.core.PersistentVector(null,1,(5),inst_67430,inst_67431,null));
var inst_67433 = ["-",inst_67432,inst_67422];
var inst_67434 = cljs.core.PersistentHashMap.fromArrays(inst_67429,inst_67433);
var inst_67435 = [inst_67434,inst_67427];
var inst_67436 = (new cljs.core.PersistentVector(null,2,(5),inst_67428,inst_67435,null));
var inst_67437 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67436);
var _ = (function (){var statearr_67451 = state_67442;
(statearr_67451[(4)] = cljs.core.rest((state_67442[(4)])));

return statearr_67451;
})();
var state_67442__$1 = (function (){var statearr_67452 = state_67442;
(statearr_67452[(7)] = inst_67437);

return statearr_67452;
})();
var statearr_67453_67466 = state_67442__$1;
(statearr_67453_67466[(2)] = inst_67422);

(statearr_67453_67466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_67454 = [null,null,null,null,null,null,null,null];
(statearr_67454[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_67454[(1)] = (1));

return statearr_67454;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_67442){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67442);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67455){var ex__2687__auto__ = e67455;
var statearr_67456_67467 = state_67442;
(statearr_67456_67467[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67442[(4)]))){
var statearr_67457_67468 = state_67442;
(statearr_67457_67468[(1)] = cljs.core.first((state_67442[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67469 = state_67442;
state_67442 = G__67469;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_67442){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_67442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67458 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67458[(6)] = c__2706__auto__);

return statearr_67458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq67410){
var G__67411 = cljs.core.first(seq67410);
var seq67410__$1 = cljs.core.next(seq67410);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67411,seq67410__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67519 = arguments.length;
var i__5770__auto___67520 = (0);
while(true){
if((i__5770__auto___67520 < len__5769__auto___67519)){
args__5775__auto__.push((arguments[i__5770__auto___67520]));

var G__67521 = (i__5770__auto___67520 + (1));
i__5770__auto___67520 = G__67521;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67502){
var state_val_67503 = (state_67502[(1)]);
if((state_val_67503 === (1))){
var state_67502__$1 = state_67502;
var statearr_67504_67522 = state_67502__$1;
(statearr_67504_67522[(2)] = null);

(statearr_67504_67522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67503 === (2))){
var _ = (function (){var statearr_67505 = state_67502;
(statearr_67505[(4)] = cljs.core.cons((5),(state_67502[(4)])));

return statearr_67505;
})();
var inst_67478 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67502__$1 = state_67502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67502__$1,(6),inst_67478);
} else {
if((state_val_67503 === (3))){
var inst_67500 = (state_67502[(2)]);
var state_67502__$1 = state_67502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67502__$1,inst_67500);
} else {
if((state_val_67503 === (4))){
var inst_67472 = (state_67502[(2)]);
var state_67502__$1 = state_67502;
var statearr_67507_67523 = state_67502__$1;
(statearr_67507_67523[(2)] = inst_67472);

(statearr_67507_67523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67503 === (5))){
var _ = (function (){var statearr_67508 = state_67502;
(statearr_67508[(4)] = cljs.core.rest((state_67502[(4)])));

return statearr_67508;
})();
var state_67502__$1 = state_67502;
var ex67506 = (state_67502__$1[(2)]);
var statearr_67509_67524 = state_67502__$1;
(statearr_67509_67524[(5)] = ex67506);


if((ex67506 instanceof Error)){
var statearr_67510_67525 = state_67502__$1;
(statearr_67510_67525[(1)] = (4));

(statearr_67510_67525[(5)] = null);

} else {
throw ex67506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67503 === (6))){
var inst_67480 = (state_67502[(2)]);
var inst_67481 = fluree.db.util.async.throw_err(inst_67480);
var inst_67482 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_67481);
var inst_67483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67484 = [inst_67481];
var inst_67485 = (new cljs.core.PersistentVector(null,1,(5),inst_67483,inst_67484,null));
var inst_67486 = cljs.core.count(inst_67485);
var inst_67487 = ((9) + inst_67486);
var inst_67488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67489 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67491 = [inst_67481];
var inst_67492 = (new cljs.core.PersistentVector(null,1,(5),inst_67490,inst_67491,null));
var inst_67493 = ["*",inst_67492,inst_67482];
var inst_67494 = cljs.core.PersistentHashMap.fromArrays(inst_67489,inst_67493);
var inst_67495 = [inst_67494,inst_67487];
var inst_67496 = (new cljs.core.PersistentVector(null,2,(5),inst_67488,inst_67495,null));
var inst_67497 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67496);
var _ = (function (){var statearr_67511 = state_67502;
(statearr_67511[(4)] = cljs.core.rest((state_67502[(4)])));

return statearr_67511;
})();
var state_67502__$1 = (function (){var statearr_67512 = state_67502;
(statearr_67512[(7)] = inst_67497);

return statearr_67512;
})();
var statearr_67513_67526 = state_67502__$1;
(statearr_67513_67526[(2)] = inst_67482);

(statearr_67513_67526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_67514 = [null,null,null,null,null,null,null,null];
(statearr_67514[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_67514[(1)] = (1));

return statearr_67514;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_67502){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67502);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67515){var ex__2687__auto__ = e67515;
var statearr_67516_67527 = state_67502;
(statearr_67516_67527[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67502[(4)]))){
var statearr_67517_67528 = state_67502;
(statearr_67517_67528[(1)] = cljs.core.first((state_67502[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67529 = state_67502;
state_67502 = G__67529;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_67502){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_67502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67518 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67518[(6)] = c__2706__auto__);

return statearr_67518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq67470){
var G__67471 = cljs.core.first(seq67470);
var seq67470__$1 = cljs.core.next(seq67470);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67471,seq67470__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67579 = arguments.length;
var i__5770__auto___67580 = (0);
while(true){
if((i__5770__auto___67580 < len__5769__auto___67579)){
args__5775__auto__.push((arguments[i__5770__auto___67580]));

var G__67581 = (i__5770__auto___67580 + (1));
i__5770__auto___67580 = G__67581;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67562){
var state_val_67563 = (state_67562[(1)]);
if((state_val_67563 === (1))){
var state_67562__$1 = state_67562;
var statearr_67564_67582 = state_67562__$1;
(statearr_67564_67582[(2)] = null);

(statearr_67564_67582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67563 === (2))){
var _ = (function (){var statearr_67565 = state_67562;
(statearr_67565[(4)] = cljs.core.cons((5),(state_67562[(4)])));

return statearr_67565;
})();
var inst_67538 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67562__$1 = state_67562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67562__$1,(6),inst_67538);
} else {
if((state_val_67563 === (3))){
var inst_67560 = (state_67562[(2)]);
var state_67562__$1 = state_67562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67562__$1,inst_67560);
} else {
if((state_val_67563 === (4))){
var inst_67532 = (state_67562[(2)]);
var state_67562__$1 = state_67562;
var statearr_67567_67583 = state_67562__$1;
(statearr_67567_67583[(2)] = inst_67532);

(statearr_67567_67583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67563 === (5))){
var _ = (function (){var statearr_67568 = state_67562;
(statearr_67568[(4)] = cljs.core.rest((state_67562[(4)])));

return statearr_67568;
})();
var state_67562__$1 = state_67562;
var ex67566 = (state_67562__$1[(2)]);
var statearr_67569_67584 = state_67562__$1;
(statearr_67569_67584[(5)] = ex67566);


if((ex67566 instanceof Error)){
var statearr_67570_67585 = state_67562__$1;
(statearr_67570_67585[(1)] = (4));

(statearr_67570_67585[(5)] = null);

} else {
throw ex67566;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67563 === (6))){
var inst_67540 = (state_67562[(2)]);
var inst_67541 = fluree.db.util.async.throw_err(inst_67540);
var inst_67542 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_67541);
var inst_67543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67544 = [inst_67541];
var inst_67545 = (new cljs.core.PersistentVector(null,1,(5),inst_67543,inst_67544,null));
var inst_67546 = cljs.core.count(inst_67545);
var inst_67547 = ((9) + inst_67546);
var inst_67548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67549 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67551 = [inst_67541];
var inst_67552 = (new cljs.core.PersistentVector(null,1,(5),inst_67550,inst_67551,null));
var inst_67553 = ["/",inst_67552,inst_67542];
var inst_67554 = cljs.core.PersistentHashMap.fromArrays(inst_67549,inst_67553);
var inst_67555 = [inst_67554,inst_67547];
var inst_67556 = (new cljs.core.PersistentVector(null,2,(5),inst_67548,inst_67555,null));
var inst_67557 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67556);
var _ = (function (){var statearr_67571 = state_67562;
(statearr_67571[(4)] = cljs.core.rest((state_67562[(4)])));

return statearr_67571;
})();
var state_67562__$1 = (function (){var statearr_67572 = state_67562;
(statearr_67572[(7)] = inst_67557);

return statearr_67572;
})();
var statearr_67573_67586 = state_67562__$1;
(statearr_67573_67586[(2)] = inst_67542);

(statearr_67573_67586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_67574 = [null,null,null,null,null,null,null,null];
(statearr_67574[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_67574[(1)] = (1));

return statearr_67574;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_67562){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67562);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67575){var ex__2687__auto__ = e67575;
var statearr_67576_67587 = state_67562;
(statearr_67576_67587[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67562[(4)]))){
var statearr_67577_67588 = state_67562;
(statearr_67577_67588[(1)] = cljs.core.first((state_67562[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67589 = state_67562;
state_67562 = G__67589;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_67562){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_67562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67578 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67578[(6)] = c__2706__auto__);

return statearr_67578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq67530){
var G__67531 = cljs.core.first(seq67530);
var seq67530__$1 = cljs.core.next(seq67530);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67531,seq67530__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67627){
var state_val_67628 = (state_67627[(1)]);
if((state_val_67628 === (7))){
var state_67627__$1 = state_67627;
var statearr_67629_67653 = state_67627__$1;
(statearr_67629_67653[(2)] = n);

(statearr_67629_67653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (1))){
var state_67627__$1 = state_67627;
var statearr_67630_67654 = state_67627__$1;
(statearr_67630_67654[(2)] = null);

(statearr_67630_67654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (4))){
var inst_67590 = (state_67627[(2)]);
var state_67627__$1 = state_67627;
var statearr_67631_67655 = state_67627__$1;
(statearr_67631_67655[(2)] = inst_67590);

(statearr_67631_67655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (13))){
var inst_67607 = (state_67627[(2)]);
var inst_67608 = fluree.db.util.async.throw_err(inst_67607);
var state_67627__$1 = state_67627;
var statearr_67632_67656 = state_67627__$1;
(statearr_67632_67656[(2)] = inst_67608);

(statearr_67632_67656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (6))){
var state_67627__$1 = state_67627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67627__$1,(9),n);
} else {
if((state_val_67628 === (3))){
var inst_67625 = (state_67627[(2)]);
var state_67627__$1 = state_67627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67627__$1,inst_67625);
} else {
if((state_val_67628 === (12))){
var inst_67603 = (state_67627[(7)]);
var inst_67611 = (state_67627[(2)]);
var inst_67612 = fluree.db.dbfunctions.internal.quot(inst_67603,inst_67611);
var inst_67613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67614 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67616 = [inst_67603,inst_67611];
var inst_67617 = (new cljs.core.PersistentVector(null,2,(5),inst_67615,inst_67616,null));
var inst_67618 = ["quot",inst_67617,inst_67612];
var inst_67619 = cljs.core.PersistentHashMap.fromArrays(inst_67614,inst_67618);
var inst_67620 = [inst_67619,(2)];
var inst_67621 = (new cljs.core.PersistentVector(null,2,(5),inst_67613,inst_67620,null));
var inst_67622 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67621);
var _ = (function (){var statearr_67633 = state_67627;
(statearr_67633[(4)] = cljs.core.rest((state_67627[(4)])));

return statearr_67633;
})();
var state_67627__$1 = (function (){var statearr_67634 = state_67627;
(statearr_67634[(8)] = inst_67622);

return statearr_67634;
})();
var statearr_67635_67657 = state_67627__$1;
(statearr_67635_67657[(2)] = inst_67612);

(statearr_67635_67657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (2))){
var _ = (function (){var statearr_67636 = state_67627;
(statearr_67636[(4)] = cljs.core.cons((5),(state_67627[(4)])));

return statearr_67636;
})();
var inst_67596 = fluree.db.util.async.channel_QMARK_(n);
var state_67627__$1 = state_67627;
if(inst_67596){
var statearr_67637_67658 = state_67627__$1;
(statearr_67637_67658[(1)] = (6));

} else {
var statearr_67638_67659 = state_67627__$1;
(statearr_67638_67659[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (11))){
var state_67627__$1 = state_67627;
var statearr_67640_67660 = state_67627__$1;
(statearr_67640_67660[(2)] = d);

(statearr_67640_67660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (9))){
var inst_67599 = (state_67627[(2)]);
var inst_67600 = fluree.db.util.async.throw_err(inst_67599);
var state_67627__$1 = state_67627;
var statearr_67641_67661 = state_67627__$1;
(statearr_67641_67661[(2)] = inst_67600);

(statearr_67641_67661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (5))){
var _ = (function (){var statearr_67642 = state_67627;
(statearr_67642[(4)] = cljs.core.rest((state_67627[(4)])));

return statearr_67642;
})();
var state_67627__$1 = state_67627;
var ex67639 = (state_67627__$1[(2)]);
var statearr_67643_67662 = state_67627__$1;
(statearr_67643_67662[(5)] = ex67639);


if((ex67639 instanceof Error)){
var statearr_67644_67663 = state_67627__$1;
(statearr_67644_67663[(1)] = (4));

(statearr_67644_67663[(5)] = null);

} else {
throw ex67639;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67628 === (10))){
var state_67627__$1 = state_67627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67627__$1,(13),d);
} else {
if((state_val_67628 === (8))){
var inst_67603 = (state_67627[(2)]);
var inst_67604 = fluree.db.util.async.channel_QMARK_(d);
var state_67627__$1 = (function (){var statearr_67645 = state_67627;
(statearr_67645[(7)] = inst_67603);

return statearr_67645;
})();
if(inst_67604){
var statearr_67646_67664 = state_67627__$1;
(statearr_67646_67664[(1)] = (10));

} else {
var statearr_67647_67665 = state_67627__$1;
(statearr_67647_67665[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0 = (function (){
var statearr_67648 = [null,null,null,null,null,null,null,null,null];
(statearr_67648[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__);

(statearr_67648[(1)] = (1));

return statearr_67648;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1 = (function (state_67627){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67627);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67649){var ex__2687__auto__ = e67649;
var statearr_67650_67666 = state_67627;
(statearr_67650_67666[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67627[(4)]))){
var statearr_67651_67667 = state_67627;
(statearr_67651_67667[(1)] = cljs.core.first((state_67627[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67668 = state_67627;
state_67627 = G__67668;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = function(state_67627){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1.call(this,state_67627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67652 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67652[(6)] = c__2706__auto__);

return statearr_67652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67706){
var state_val_67707 = (state_67706[(1)]);
if((state_val_67707 === (7))){
var state_67706__$1 = state_67706;
var statearr_67708_67732 = state_67706__$1;
(statearr_67708_67732[(2)] = n);

(statearr_67708_67732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (1))){
var state_67706__$1 = state_67706;
var statearr_67709_67733 = state_67706__$1;
(statearr_67709_67733[(2)] = null);

(statearr_67709_67733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (4))){
var inst_67669 = (state_67706[(2)]);
var state_67706__$1 = state_67706;
var statearr_67710_67734 = state_67706__$1;
(statearr_67710_67734[(2)] = inst_67669);

(statearr_67710_67734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (13))){
var inst_67686 = (state_67706[(2)]);
var inst_67687 = fluree.db.util.async.throw_err(inst_67686);
var state_67706__$1 = state_67706;
var statearr_67711_67735 = state_67706__$1;
(statearr_67711_67735[(2)] = inst_67687);

(statearr_67711_67735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (6))){
var state_67706__$1 = state_67706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67706__$1,(9),n);
} else {
if((state_val_67707 === (3))){
var inst_67704 = (state_67706[(2)]);
var state_67706__$1 = state_67706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67706__$1,inst_67704);
} else {
if((state_val_67707 === (12))){
var inst_67682 = (state_67706[(7)]);
var inst_67690 = (state_67706[(2)]);
var inst_67691 = fluree.db.dbfunctions.internal.mod(inst_67682,inst_67690);
var inst_67692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67693 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67695 = [inst_67682,inst_67690];
var inst_67696 = (new cljs.core.PersistentVector(null,2,(5),inst_67694,inst_67695,null));
var inst_67697 = ["mod",inst_67696,inst_67691];
var inst_67698 = cljs.core.PersistentHashMap.fromArrays(inst_67693,inst_67697);
var inst_67699 = [inst_67698,(2)];
var inst_67700 = (new cljs.core.PersistentVector(null,2,(5),inst_67692,inst_67699,null));
var inst_67701 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67700);
var _ = (function (){var statearr_67712 = state_67706;
(statearr_67712[(4)] = cljs.core.rest((state_67706[(4)])));

return statearr_67712;
})();
var state_67706__$1 = (function (){var statearr_67713 = state_67706;
(statearr_67713[(8)] = inst_67701);

return statearr_67713;
})();
var statearr_67714_67736 = state_67706__$1;
(statearr_67714_67736[(2)] = inst_67691);

(statearr_67714_67736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (2))){
var _ = (function (){var statearr_67715 = state_67706;
(statearr_67715[(4)] = cljs.core.cons((5),(state_67706[(4)])));

return statearr_67715;
})();
var inst_67675 = fluree.db.util.async.channel_QMARK_(n);
var state_67706__$1 = state_67706;
if(inst_67675){
var statearr_67716_67737 = state_67706__$1;
(statearr_67716_67737[(1)] = (6));

} else {
var statearr_67717_67738 = state_67706__$1;
(statearr_67717_67738[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (11))){
var state_67706__$1 = state_67706;
var statearr_67719_67739 = state_67706__$1;
(statearr_67719_67739[(2)] = d);

(statearr_67719_67739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (9))){
var inst_67678 = (state_67706[(2)]);
var inst_67679 = fluree.db.util.async.throw_err(inst_67678);
var state_67706__$1 = state_67706;
var statearr_67720_67740 = state_67706__$1;
(statearr_67720_67740[(2)] = inst_67679);

(statearr_67720_67740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (5))){
var _ = (function (){var statearr_67721 = state_67706;
(statearr_67721[(4)] = cljs.core.rest((state_67706[(4)])));

return statearr_67721;
})();
var state_67706__$1 = state_67706;
var ex67718 = (state_67706__$1[(2)]);
var statearr_67722_67741 = state_67706__$1;
(statearr_67722_67741[(5)] = ex67718);


if((ex67718 instanceof Error)){
var statearr_67723_67742 = state_67706__$1;
(statearr_67723_67742[(1)] = (4));

(statearr_67723_67742[(5)] = null);

} else {
throw ex67718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (10))){
var state_67706__$1 = state_67706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67706__$1,(13),d);
} else {
if((state_val_67707 === (8))){
var inst_67682 = (state_67706[(2)]);
var inst_67683 = fluree.db.util.async.channel_QMARK_(d);
var state_67706__$1 = (function (){var statearr_67724 = state_67706;
(statearr_67724[(7)] = inst_67682);

return statearr_67724;
})();
if(inst_67683){
var statearr_67725_67743 = state_67706__$1;
(statearr_67725_67743[(1)] = (10));

} else {
var statearr_67726_67744 = state_67706__$1;
(statearr_67726_67744[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0 = (function (){
var statearr_67727 = [null,null,null,null,null,null,null,null,null];
(statearr_67727[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__);

(statearr_67727[(1)] = (1));

return statearr_67727;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1 = (function (state_67706){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67706);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67728){var ex__2687__auto__ = e67728;
var statearr_67729_67745 = state_67706;
(statearr_67729_67745[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67706[(4)]))){
var statearr_67730_67746 = state_67706;
(statearr_67730_67746[(1)] = cljs.core.first((state_67706[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67747 = state_67706;
state_67706 = G__67747;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = function(state_67706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1.call(this,state_67706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67731 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67731[(6)] = c__2706__auto__);

return statearr_67731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67785){
var state_val_67786 = (state_67785[(1)]);
if((state_val_67786 === (7))){
var state_67785__$1 = state_67785;
var statearr_67787_67811 = state_67785__$1;
(statearr_67787_67811[(2)] = n);

(statearr_67787_67811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (1))){
var state_67785__$1 = state_67785;
var statearr_67788_67812 = state_67785__$1;
(statearr_67788_67812[(2)] = null);

(statearr_67788_67812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (4))){
var inst_67748 = (state_67785[(2)]);
var state_67785__$1 = state_67785;
var statearr_67789_67813 = state_67785__$1;
(statearr_67789_67813[(2)] = inst_67748);

(statearr_67789_67813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (13))){
var inst_67765 = (state_67785[(2)]);
var inst_67766 = fluree.db.util.async.throw_err(inst_67765);
var state_67785__$1 = state_67785;
var statearr_67790_67814 = state_67785__$1;
(statearr_67790_67814[(2)] = inst_67766);

(statearr_67790_67814[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (6))){
var state_67785__$1 = state_67785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67785__$1,(9),n);
} else {
if((state_val_67786 === (3))){
var inst_67783 = (state_67785[(2)]);
var state_67785__$1 = state_67785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67785__$1,inst_67783);
} else {
if((state_val_67786 === (12))){
var inst_67761 = (state_67785[(7)]);
var inst_67769 = (state_67785[(2)]);
var inst_67770 = fluree.db.dbfunctions.internal.rem(inst_67761,inst_67769);
var inst_67771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67772 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67774 = [inst_67761,inst_67769];
var inst_67775 = (new cljs.core.PersistentVector(null,2,(5),inst_67773,inst_67774,null));
var inst_67776 = ["rem",inst_67775,inst_67770];
var inst_67777 = cljs.core.PersistentHashMap.fromArrays(inst_67772,inst_67776);
var inst_67778 = [inst_67777,(2)];
var inst_67779 = (new cljs.core.PersistentVector(null,2,(5),inst_67771,inst_67778,null));
var inst_67780 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67779);
var _ = (function (){var statearr_67791 = state_67785;
(statearr_67791[(4)] = cljs.core.rest((state_67785[(4)])));

return statearr_67791;
})();
var state_67785__$1 = (function (){var statearr_67792 = state_67785;
(statearr_67792[(8)] = inst_67780);

return statearr_67792;
})();
var statearr_67793_67815 = state_67785__$1;
(statearr_67793_67815[(2)] = inst_67770);

(statearr_67793_67815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (2))){
var _ = (function (){var statearr_67794 = state_67785;
(statearr_67794[(4)] = cljs.core.cons((5),(state_67785[(4)])));

return statearr_67794;
})();
var inst_67754 = fluree.db.util.async.channel_QMARK_(n);
var state_67785__$1 = state_67785;
if(inst_67754){
var statearr_67795_67816 = state_67785__$1;
(statearr_67795_67816[(1)] = (6));

} else {
var statearr_67796_67817 = state_67785__$1;
(statearr_67796_67817[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (11))){
var state_67785__$1 = state_67785;
var statearr_67798_67818 = state_67785__$1;
(statearr_67798_67818[(2)] = d);

(statearr_67798_67818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (9))){
var inst_67757 = (state_67785[(2)]);
var inst_67758 = fluree.db.util.async.throw_err(inst_67757);
var state_67785__$1 = state_67785;
var statearr_67799_67819 = state_67785__$1;
(statearr_67799_67819[(2)] = inst_67758);

(statearr_67799_67819[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (5))){
var _ = (function (){var statearr_67800 = state_67785;
(statearr_67800[(4)] = cljs.core.rest((state_67785[(4)])));

return statearr_67800;
})();
var state_67785__$1 = state_67785;
var ex67797 = (state_67785__$1[(2)]);
var statearr_67801_67820 = state_67785__$1;
(statearr_67801_67820[(5)] = ex67797);


if((ex67797 instanceof Error)){
var statearr_67802_67821 = state_67785__$1;
(statearr_67802_67821[(1)] = (4));

(statearr_67802_67821[(5)] = null);

} else {
throw ex67797;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67786 === (10))){
var state_67785__$1 = state_67785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67785__$1,(13),d);
} else {
if((state_val_67786 === (8))){
var inst_67761 = (state_67785[(2)]);
var inst_67762 = fluree.db.util.async.channel_QMARK_(d);
var state_67785__$1 = (function (){var statearr_67803 = state_67785;
(statearr_67803[(7)] = inst_67761);

return statearr_67803;
})();
if(inst_67762){
var statearr_67804_67822 = state_67785__$1;
(statearr_67804_67822[(1)] = (10));

} else {
var statearr_67805_67823 = state_67785__$1;
(statearr_67805_67823[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0 = (function (){
var statearr_67806 = [null,null,null,null,null,null,null,null,null];
(statearr_67806[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__);

(statearr_67806[(1)] = (1));

return statearr_67806;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1 = (function (state_67785){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67785);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67807){var ex__2687__auto__ = e67807;
var statearr_67808_67824 = state_67785;
(statearr_67808_67824[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67785[(4)]))){
var statearr_67809_67825 = state_67785;
(statearr_67809_67825[(1)] = cljs.core.first((state_67785[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67826 = state_67785;
state_67785 = G__67826;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = function(state_67785){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1.call(this,state_67785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67810 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67810[(6)] = c__2706__auto__);

return statearr_67810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67853){
var state_val_67854 = (state_67853[(1)]);
if((state_val_67854 === (7))){
var state_67853__$1 = state_67853;
var statearr_67855_67874 = state_67853__$1;
(statearr_67855_67874[(2)] = x);

(statearr_67855_67874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (1))){
var state_67853__$1 = state_67853;
var statearr_67856_67875 = state_67853__$1;
(statearr_67856_67875[(2)] = null);

(statearr_67856_67875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (4))){
var inst_67827 = (state_67853[(2)]);
var state_67853__$1 = state_67853;
var statearr_67857_67876 = state_67853__$1;
(statearr_67857_67876[(2)] = inst_67827);

(statearr_67857_67876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (6))){
var state_67853__$1 = state_67853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67853__$1,(9),x);
} else {
if((state_val_67854 === (3))){
var inst_67851 = (state_67853[(2)]);
var state_67853__$1 = state_67853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67853__$1,inst_67851);
} else {
if((state_val_67854 === (2))){
var _ = (function (){var statearr_67859 = state_67853;
(statearr_67859[(4)] = cljs.core.cons((5),(state_67853[(4)])));

return statearr_67859;
})();
var inst_67833 = fluree.db.util.async.channel_QMARK_(x);
var state_67853__$1 = state_67853;
if(inst_67833){
var statearr_67860_67877 = state_67853__$1;
(statearr_67860_67877[(1)] = (6));

} else {
var statearr_67861_67878 = state_67853__$1;
(statearr_67861_67878[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (9))){
var inst_67836 = (state_67853[(2)]);
var inst_67837 = fluree.db.util.async.throw_err(inst_67836);
var state_67853__$1 = state_67853;
var statearr_67862_67879 = state_67853__$1;
(statearr_67862_67879[(2)] = inst_67837);

(statearr_67862_67879[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (5))){
var _ = (function (){var statearr_67863 = state_67853;
(statearr_67863[(4)] = cljs.core.rest((state_67853[(4)])));

return statearr_67863;
})();
var state_67853__$1 = state_67853;
var ex67858 = (state_67853__$1[(2)]);
var statearr_67864_67880 = state_67853__$1;
(statearr_67864_67880[(5)] = ex67858);


if((ex67858 instanceof Error)){
var statearr_67865_67881 = state_67853__$1;
(statearr_67865_67881[(1)] = (4));

(statearr_67865_67881[(5)] = null);

} else {
throw ex67858;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (8))){
var inst_67840 = (state_67853[(2)]);
var inst_67841 = fluree.db.dbfunctions.internal.boolean$(inst_67840);
var inst_67842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67843 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67844 = ["boolean",inst_67840,inst_67841];
var inst_67845 = cljs.core.PersistentHashMap.fromArrays(inst_67843,inst_67844);
var inst_67846 = [inst_67845,(10)];
var inst_67847 = (new cljs.core.PersistentVector(null,2,(5),inst_67842,inst_67846,null));
var inst_67848 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67847);
var _ = (function (){var statearr_67866 = state_67853;
(statearr_67866[(4)] = cljs.core.rest((state_67853[(4)])));

return statearr_67866;
})();
var state_67853__$1 = (function (){var statearr_67867 = state_67853;
(statearr_67867[(7)] = inst_67848);

return statearr_67867;
})();
var statearr_67868_67882 = state_67853__$1;
(statearr_67868_67882[(2)] = inst_67841);

(statearr_67868_67882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0 = (function (){
var statearr_67869 = [null,null,null,null,null,null,null,null];
(statearr_67869[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__);

(statearr_67869[(1)] = (1));

return statearr_67869;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1 = (function (state_67853){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67853);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67870){var ex__2687__auto__ = e67870;
var statearr_67871_67883 = state_67853;
(statearr_67871_67883[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67853[(4)]))){
var statearr_67872_67884 = state_67853;
(statearr_67872_67884[(1)] = cljs.core.first((state_67853[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67885 = state_67853;
state_67853 = G__67885;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = function(state_67853){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1.call(this,state_67853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67873 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67873[(6)] = c__2706__auto__);

return statearr_67873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67923){
var state_val_67924 = (state_67923[(1)]);
if((state_val_67924 === (7))){
var state_67923__$1 = state_67923;
var statearr_67925_67949 = state_67923__$1;
(statearr_67925_67949[(2)] = pattern);

(statearr_67925_67949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (1))){
var state_67923__$1 = state_67923;
var statearr_67926_67950 = state_67923__$1;
(statearr_67926_67950[(2)] = null);

(statearr_67926_67950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (4))){
var inst_67886 = (state_67923[(2)]);
var state_67923__$1 = state_67923;
var statearr_67927_67951 = state_67923__$1;
(statearr_67927_67951[(2)] = inst_67886);

(statearr_67927_67951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (13))){
var inst_67903 = (state_67923[(2)]);
var inst_67904 = fluree.db.util.async.throw_err(inst_67903);
var state_67923__$1 = state_67923;
var statearr_67928_67952 = state_67923__$1;
(statearr_67928_67952[(2)] = inst_67904);

(statearr_67928_67952[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (6))){
var state_67923__$1 = state_67923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67923__$1,(9),pattern);
} else {
if((state_val_67924 === (3))){
var inst_67921 = (state_67923[(2)]);
var state_67923__$1 = state_67923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67923__$1,inst_67921);
} else {
if((state_val_67924 === (12))){
var inst_67899 = (state_67923[(7)]);
var inst_67907 = (state_67923[(2)]);
var inst_67908 = fluree.db.dbfunctions.internal.re_find(inst_67899,inst_67907);
var inst_67909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67910 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67912 = [inst_67899,inst_67907];
var inst_67913 = (new cljs.core.PersistentVector(null,2,(5),inst_67911,inst_67912,null));
var inst_67914 = ["re-find",inst_67913,inst_67908];
var inst_67915 = cljs.core.PersistentHashMap.fromArrays(inst_67910,inst_67914);
var inst_67916 = [inst_67915,(10)];
var inst_67917 = (new cljs.core.PersistentVector(null,2,(5),inst_67909,inst_67916,null));
var inst_67918 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67917);
var _ = (function (){var statearr_67929 = state_67923;
(statearr_67929[(4)] = cljs.core.rest((state_67923[(4)])));

return statearr_67929;
})();
var state_67923__$1 = (function (){var statearr_67930 = state_67923;
(statearr_67930[(8)] = inst_67918);

return statearr_67930;
})();
var statearr_67931_67953 = state_67923__$1;
(statearr_67931_67953[(2)] = inst_67908);

(statearr_67931_67953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (2))){
var _ = (function (){var statearr_67932 = state_67923;
(statearr_67932[(4)] = cljs.core.cons((5),(state_67923[(4)])));

return statearr_67932;
})();
var inst_67892 = fluree.db.util.async.channel_QMARK_(pattern);
var state_67923__$1 = state_67923;
if(inst_67892){
var statearr_67933_67954 = state_67923__$1;
(statearr_67933_67954[(1)] = (6));

} else {
var statearr_67934_67955 = state_67923__$1;
(statearr_67934_67955[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (11))){
var state_67923__$1 = state_67923;
var statearr_67936_67956 = state_67923__$1;
(statearr_67936_67956[(2)] = string);

(statearr_67936_67956[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (9))){
var inst_67895 = (state_67923[(2)]);
var inst_67896 = fluree.db.util.async.throw_err(inst_67895);
var state_67923__$1 = state_67923;
var statearr_67937_67957 = state_67923__$1;
(statearr_67937_67957[(2)] = inst_67896);

(statearr_67937_67957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (5))){
var _ = (function (){var statearr_67938 = state_67923;
(statearr_67938[(4)] = cljs.core.rest((state_67923[(4)])));

return statearr_67938;
})();
var state_67923__$1 = state_67923;
var ex67935 = (state_67923__$1[(2)]);
var statearr_67939_67958 = state_67923__$1;
(statearr_67939_67958[(5)] = ex67935);


if((ex67935 instanceof Error)){
var statearr_67940_67959 = state_67923__$1;
(statearr_67940_67959[(1)] = (4));

(statearr_67940_67959[(5)] = null);

} else {
throw ex67935;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67924 === (10))){
var state_67923__$1 = state_67923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67923__$1,(13),string);
} else {
if((state_val_67924 === (8))){
var inst_67899 = (state_67923[(2)]);
var inst_67900 = fluree.db.util.async.channel_QMARK_(string);
var state_67923__$1 = (function (){var statearr_67941 = state_67923;
(statearr_67941[(7)] = inst_67899);

return statearr_67941;
})();
if(inst_67900){
var statearr_67942_67960 = state_67923__$1;
(statearr_67942_67960[(1)] = (10));

} else {
var statearr_67943_67961 = state_67923__$1;
(statearr_67943_67961[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0 = (function (){
var statearr_67944 = [null,null,null,null,null,null,null,null,null];
(statearr_67944[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__);

(statearr_67944[(1)] = (1));

return statearr_67944;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1 = (function (state_67923){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67923);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67945){var ex__2687__auto__ = e67945;
var statearr_67946_67962 = state_67923;
(statearr_67946_67962[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67923[(4)]))){
var statearr_67947_67963 = state_67923;
(statearr_67947_67963[(1)] = cljs.core.first((state_67923[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67964 = state_67923;
state_67923 = G__67964;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = function(state_67923){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1.call(this,state_67923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67948 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67948[(6)] = c__2706__auto__);

return statearr_67948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67991){
var state_val_67992 = (state_67991[(1)]);
if((state_val_67992 === (7))){
var state_67991__$1 = state_67991;
var statearr_67993_68012 = state_67991__$1;
(statearr_67993_68012[(2)] = email);

(statearr_67993_68012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67992 === (1))){
var state_67991__$1 = state_67991;
var statearr_67994_68013 = state_67991__$1;
(statearr_67994_68013[(2)] = null);

(statearr_67994_68013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67992 === (4))){
var inst_67965 = (state_67991[(2)]);
var state_67991__$1 = state_67991;
var statearr_67995_68014 = state_67991__$1;
(statearr_67995_68014[(2)] = inst_67965);

(statearr_67995_68014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67992 === (6))){
var state_67991__$1 = state_67991;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67991__$1,(9),email);
} else {
if((state_val_67992 === (3))){
var inst_67989 = (state_67991[(2)]);
var state_67991__$1 = state_67991;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67991__$1,inst_67989);
} else {
if((state_val_67992 === (2))){
var _ = (function (){var statearr_67997 = state_67991;
(statearr_67997[(4)] = cljs.core.cons((5),(state_67991[(4)])));

return statearr_67997;
})();
var inst_67971 = fluree.db.util.async.channel_QMARK_(email);
var state_67991__$1 = state_67991;
if(inst_67971){
var statearr_67998_68015 = state_67991__$1;
(statearr_67998_68015[(1)] = (6));

} else {
var statearr_67999_68016 = state_67991__$1;
(statearr_67999_68016[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67992 === (9))){
var inst_67974 = (state_67991[(2)]);
var inst_67975 = fluree.db.util.async.throw_err(inst_67974);
var state_67991__$1 = state_67991;
var statearr_68000_68017 = state_67991__$1;
(statearr_68000_68017[(2)] = inst_67975);

(statearr_68000_68017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67992 === (5))){
var _ = (function (){var statearr_68001 = state_67991;
(statearr_68001[(4)] = cljs.core.rest((state_67991[(4)])));

return statearr_68001;
})();
var state_67991__$1 = state_67991;
var ex67996 = (state_67991__$1[(2)]);
var statearr_68002_68018 = state_67991__$1;
(statearr_68002_68018[(5)] = ex67996);


if((ex67996 instanceof Error)){
var statearr_68003_68019 = state_67991__$1;
(statearr_68003_68019[(1)] = (4));

(statearr_68003_68019[(5)] = null);

} else {
throw ex67996;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67992 === (8))){
var inst_67978 = (state_67991[(2)]);
var inst_67979 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_67978);
var inst_67980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67981 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67982 = ["re-find",inst_67978,inst_67979];
var inst_67983 = cljs.core.PersistentHashMap.fromArrays(inst_67981,inst_67982);
var inst_67984 = [inst_67983,(10)];
var inst_67985 = (new cljs.core.PersistentVector(null,2,(5),inst_67980,inst_67984,null));
var inst_67986 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67985);
var _ = (function (){var statearr_68004 = state_67991;
(statearr_68004[(4)] = cljs.core.rest((state_67991[(4)])));

return statearr_68004;
})();
var state_67991__$1 = (function (){var statearr_68005 = state_67991;
(statearr_68005[(7)] = inst_67986);

return statearr_68005;
})();
var statearr_68006_68020 = state_67991__$1;
(statearr_68006_68020[(2)] = inst_67979);

(statearr_68006_68020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_68007 = [null,null,null,null,null,null,null,null];
(statearr_68007[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__);

(statearr_68007[(1)] = (1));

return statearr_68007;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1 = (function (state_67991){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67991);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68008){var ex__2687__auto__ = e68008;
var statearr_68009_68021 = state_67991;
(statearr_68009_68021[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67991[(4)]))){
var statearr_68010_68022 = state_67991;
(statearr_68010_68022[(1)] = cljs.core.first((state_67991[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68023 = state_67991;
state_67991 = G__68023;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = function(state_67991){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1.call(this,state_67991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68011 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68011[(6)] = c__2706__auto__);

return statearr_68011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68070){
var state_val_68071 = (state_68070[(1)]);
if((state_val_68071 === (7))){
var inst_68040 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68070__$1 = state_68070;
if(cljs.core.truth_(inst_68040)){
var statearr_68072_68099 = state_68070__$1;
(statearr_68072_68099[(1)] = (9));

} else {
var statearr_68073_68100 = state_68070__$1;
(statearr_68073_68100[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (1))){
var state_68070__$1 = state_68070;
var statearr_68074_68101 = state_68070__$1;
(statearr_68074_68101[(2)] = null);

(statearr_68074_68101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (4))){
var inst_68024 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
var statearr_68075_68102 = state_68070__$1;
(statearr_68075_68102[(2)] = inst_68024);

(statearr_68075_68102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (15))){
var inst_68051 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
var statearr_68076_68103 = state_68070__$1;
(statearr_68076_68103[(2)] = inst_68051);

(statearr_68076_68103[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (13))){
var inst_68048 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_68070__$1 = state_68070;
var statearr_68077_68104 = state_68070__$1;
(statearr_68077_68104[(2)] = inst_68048);

(statearr_68077_68104[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (6))){
var inst_68035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68036 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_68037 = [inst_68036,(0)];
var inst_68038 = (new cljs.core.PersistentVector(null,2,(5),inst_68035,inst_68037,null));
var state_68070__$1 = state_68070;
var statearr_68078_68105 = state_68070__$1;
(statearr_68078_68105[(2)] = inst_68038);

(statearr_68078_68105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (3))){
var inst_68068 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68070__$1,inst_68068);
} else {
if((state_val_68071 === (12))){
var inst_68044 = (state_68070[(2)]);
var inst_68045 = fluree.db.util.async.throw_err(inst_68044);
var state_68070__$1 = state_68070;
var statearr_68079_68106 = state_68070__$1;
(statearr_68079_68106[(2)] = inst_68045);

(statearr_68079_68106[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (2))){
var _ = (function (){var statearr_68080 = state_68070;
(statearr_68080[(4)] = cljs.core.cons((5),(state_68070[(4)])));

return statearr_68080;
})();
var inst_68033 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68070__$1 = state_68070;
if(cljs.core.truth_(inst_68033)){
var statearr_68081_68107 = state_68070__$1;
(statearr_68081_68107[(1)] = (6));

} else {
var statearr_68082_68108 = state_68070__$1;
(statearr_68082_68108[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (11))){
var inst_68053 = (state_68070[(2)]);
var state_68070__$1 = state_68070;
var statearr_68084_68109 = state_68070__$1;
(statearr_68084_68109[(2)] = inst_68053);

(statearr_68084_68109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (9))){
var inst_68042 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_68070__$1 = state_68070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68070__$1,(12),inst_68042);
} else {
if((state_val_68071 === (5))){
var _ = (function (){var statearr_68085 = state_68070;
(statearr_68085[(4)] = cljs.core.rest((state_68070[(4)])));

return statearr_68085;
})();
var state_68070__$1 = state_68070;
var ex68083 = (state_68070__$1[(2)]);
var statearr_68086_68110 = state_68070__$1;
(statearr_68086_68110[(5)] = ex68083);


if((ex68083 instanceof Error)){
var statearr_68087_68111 = state_68070__$1;
(statearr_68087_68111[(1)] = (4));

(statearr_68087_68111[(5)] = null);

} else {
throw ex68083;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (14))){
var state_68070__$1 = state_68070;
var statearr_68088_68112 = state_68070__$1;
(statearr_68088_68112[(2)] = null);

(statearr_68088_68112[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (10))){
var state_68070__$1 = state_68070;
var statearr_68089_68113 = state_68070__$1;
(statearr_68089_68113[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68071 === (8))){
var inst_68055 = (state_68070[(2)]);
var inst_68056 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68055,(0),null);
var inst_68057 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68055,(1),null);
var inst_68058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68059 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68060 = ["?user_id","?ctx",inst_68056];
var inst_68061 = cljs.core.PersistentHashMap.fromArrays(inst_68059,inst_68060);
var inst_68062 = ((10) + inst_68057);
var inst_68063 = [inst_68061,inst_68062];
var inst_68064 = (new cljs.core.PersistentVector(null,2,(5),inst_68058,inst_68063,null));
var inst_68065 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68064);
var _ = (function (){var statearr_68091 = state_68070;
(statearr_68091[(4)] = cljs.core.rest((state_68070[(4)])));

return statearr_68091;
})();
var state_68070__$1 = (function (){var statearr_68092 = state_68070;
(statearr_68092[(7)] = inst_68065);

return statearr_68092;
})();
var statearr_68093_68114 = state_68070__$1;
(statearr_68093_68114[(2)] = inst_68056);

(statearr_68093_68114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0 = (function (){
var statearr_68094 = [null,null,null,null,null,null,null,null];
(statearr_68094[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__);

(statearr_68094[(1)] = (1));

return statearr_68094;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1 = (function (state_68070){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68070);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68095){var ex__2687__auto__ = e68095;
var statearr_68096_68115 = state_68070;
(statearr_68096_68115[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68070[(4)]))){
var statearr_68097_68116 = state_68070;
(statearr_68097_68116[(1)] = cljs.core.first((state_68070[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68117 = state_68070;
state_68070 = G__68117;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = function(state_68070){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1.call(this,state_68070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68098 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68098[(6)] = c__2706__auto__);

return statearr_68098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68145){
var state_val_68146 = (state_68145[(1)]);
if((state_val_68146 === (7))){
var inst_68138 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_68145__$1 = state_68145;
var statearr_68147_68166 = state_68145__$1;
(statearr_68147_68166[(2)] = inst_68138);

(statearr_68147_68166[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (1))){
var state_68145__$1 = state_68145;
var statearr_68148_68167 = state_68145__$1;
(statearr_68148_68167[(2)] = null);

(statearr_68148_68167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (4))){
var inst_68118 = (state_68145[(2)]);
var state_68145__$1 = state_68145;
var statearr_68149_68168 = state_68145__$1;
(statearr_68149_68168[(2)] = inst_68118);

(statearr_68149_68168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (6))){
var inst_68126 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_68145__$1 = state_68145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68145__$1,(9),inst_68126);
} else {
if((state_val_68146 === (3))){
var inst_68143 = (state_68145[(2)]);
var state_68145__$1 = state_68145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68145__$1,inst_68143);
} else {
if((state_val_68146 === (2))){
var _ = (function (){var statearr_68151 = state_68145;
(statearr_68151[(4)] = cljs.core.cons((5),(state_68145[(4)])));

return statearr_68151;
})();
var inst_68124 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68145__$1 = state_68145;
if(cljs.core.truth_(inst_68124)){
var statearr_68152_68169 = state_68145__$1;
(statearr_68152_68169[(1)] = (6));

} else {
var statearr_68153_68170 = state_68145__$1;
(statearr_68153_68170[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (9))){
var inst_68128 = (state_68145[(2)]);
var inst_68129 = fluree.db.util.async.throw_err(inst_68128);
var inst_68130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68131 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68132 = ["?auth_id","?ctx",inst_68129];
var inst_68133 = cljs.core.PersistentHashMap.fromArrays(inst_68131,inst_68132);
var inst_68134 = [inst_68133,(10)];
var inst_68135 = (new cljs.core.PersistentVector(null,2,(5),inst_68130,inst_68134,null));
var inst_68136 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68135);
var state_68145__$1 = (function (){var statearr_68154 = state_68145;
(statearr_68154[(7)] = inst_68136);

return statearr_68154;
})();
var statearr_68155_68171 = state_68145__$1;
(statearr_68155_68171[(2)] = inst_68129);

(statearr_68155_68171[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (5))){
var _ = (function (){var statearr_68156 = state_68145;
(statearr_68156[(4)] = cljs.core.rest((state_68145[(4)])));

return statearr_68156;
})();
var state_68145__$1 = state_68145;
var ex68150 = (state_68145__$1[(2)]);
var statearr_68157_68172 = state_68145__$1;
(statearr_68157_68172[(5)] = ex68150);


if((ex68150 instanceof Error)){
var statearr_68158_68173 = state_68145__$1;
(statearr_68158_68173[(1)] = (4));

(statearr_68158_68173[(5)] = null);

} else {
throw ex68150;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68146 === (8))){
var inst_68140 = (state_68145[(2)]);
var _ = (function (){var statearr_68159 = state_68145;
(statearr_68159[(4)] = cljs.core.rest((state_68145[(4)])));

return statearr_68159;
})();
var state_68145__$1 = state_68145;
var statearr_68160_68174 = state_68145__$1;
(statearr_68160_68174[(2)] = inst_68140);

(statearr_68160_68174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_68161 = [null,null,null,null,null,null,null,null];
(statearr_68161[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_68161[(1)] = (1));

return statearr_68161;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_68145){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68145);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68162){var ex__2687__auto__ = e68162;
var statearr_68163_68175 = state_68145;
(statearr_68163_68175[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68145[(4)]))){
var statearr_68164_68176 = state_68145;
(statearr_68164_68176[(1)] = cljs.core.first((state_68145[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68177 = state_68145;
state_68145 = G__68177;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_68145){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_68145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68165 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68165[(6)] = c__2706__auto__);

return statearr_68165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__68179 = arguments.length;
switch (G__68179) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68221){
var state_val_68222 = (state_68221[(1)]);
if((state_val_68222 === (7))){
var state_68221__$1 = state_68221;
var statearr_68223_68253 = state_68221__$1;
(statearr_68223_68253[(2)] = seed);

(statearr_68223_68253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (1))){
var state_68221__$1 = state_68221;
var statearr_68224_68254 = state_68221__$1;
(statearr_68224_68254[(2)] = null);

(statearr_68224_68254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (4))){
var inst_68180 = (state_68221[(2)]);
var state_68221__$1 = state_68221;
var statearr_68225_68255 = state_68221__$1;
(statearr_68225_68255[(2)] = inst_68180);

(statearr_68225_68255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (15))){
var state_68221__$1 = state_68221;
var statearr_68226_68256 = state_68221__$1;
(statearr_68226_68256[(2)] = (10));

(statearr_68226_68256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (13))){
var inst_68197 = (state_68221[(2)]);
var inst_68198 = fluree.db.util.async.throw_err(inst_68197);
var state_68221__$1 = state_68221;
var statearr_68227_68257 = state_68221__$1;
(statearr_68227_68257[(2)] = inst_68198);

(statearr_68227_68257[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (6))){
var state_68221__$1 = state_68221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68221__$1,(9),seed);
} else {
if((state_val_68222 === (3))){
var inst_68219 = (state_68221[(2)]);
var state_68221__$1 = state_68221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68221__$1,inst_68219);
} else {
if((state_val_68222 === (12))){
var inst_68201 = (state_68221[(7)]);
var inst_68201__$1 = (state_68221[(2)]);
var state_68221__$1 = (function (){var statearr_68228 = state_68221;
(statearr_68228[(7)] = inst_68201__$1);

return statearr_68228;
})();
if(cljs.core.truth_(inst_68201__$1)){
var statearr_68229_68258 = state_68221__$1;
(statearr_68229_68258[(1)] = (14));

} else {
var statearr_68230_68259 = state_68221__$1;
(statearr_68230_68259[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (2))){
var _ = (function (){var statearr_68231 = state_68221;
(statearr_68231[(4)] = cljs.core.cons((5),(state_68221[(4)])));

return statearr_68231;
})();
var inst_68186 = fluree.db.util.async.channel_QMARK_(seed);
var state_68221__$1 = state_68221;
if(inst_68186){
var statearr_68232_68260 = state_68221__$1;
(statearr_68232_68260[(1)] = (6));

} else {
var statearr_68233_68261 = state_68221__$1;
(statearr_68233_68261[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (11))){
var state_68221__$1 = state_68221;
var statearr_68235_68262 = state_68221__$1;
(statearr_68235_68262[(2)] = max);

(statearr_68235_68262[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (9))){
var inst_68189 = (state_68221[(2)]);
var inst_68190 = fluree.db.util.async.throw_err(inst_68189);
var state_68221__$1 = state_68221;
var statearr_68236_68263 = state_68221__$1;
(statearr_68236_68263[(2)] = inst_68190);

(statearr_68236_68263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (5))){
var _ = (function (){var statearr_68237 = state_68221;
(statearr_68237[(4)] = cljs.core.rest((state_68221[(4)])));

return statearr_68237;
})();
var state_68221__$1 = state_68221;
var ex68234 = (state_68221__$1[(2)]);
var statearr_68238_68264 = state_68221__$1;
(statearr_68238_68264[(5)] = ex68234);


if((ex68234 instanceof Error)){
var statearr_68239_68265 = state_68221__$1;
(statearr_68239_68265[(1)] = (4));

(statearr_68239_68265[(5)] = null);

} else {
throw ex68234;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (14))){
var inst_68201 = (state_68221[(7)]);
var state_68221__$1 = state_68221;
var statearr_68240_68266 = state_68221__$1;
(statearr_68240_68266[(2)] = inst_68201);

(statearr_68240_68266[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (16))){
var inst_68193 = (state_68221[(8)]);
var inst_68205 = (state_68221[(2)]);
var inst_68206 = fluree.db.dbfunctions.internal.rand(inst_68193,inst_68205);
var inst_68207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68208 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68210 = [max,seed];
var inst_68211 = (new cljs.core.PersistentVector(null,2,(5),inst_68209,inst_68210,null));
var inst_68212 = ["rand",inst_68211,inst_68206];
var inst_68213 = cljs.core.PersistentHashMap.fromArrays(inst_68208,inst_68212);
var inst_68214 = [inst_68213,(10)];
var inst_68215 = (new cljs.core.PersistentVector(null,2,(5),inst_68207,inst_68214,null));
var inst_68216 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68215);
var _ = (function (){var statearr_68241 = state_68221;
(statearr_68241[(4)] = cljs.core.rest((state_68221[(4)])));

return statearr_68241;
})();
var state_68221__$1 = (function (){var statearr_68242 = state_68221;
(statearr_68242[(9)] = inst_68216);

return statearr_68242;
})();
var statearr_68243_68267 = state_68221__$1;
(statearr_68243_68267[(2)] = inst_68206);

(statearr_68243_68267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68222 === (10))){
var state_68221__$1 = state_68221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68221__$1,(13),max);
} else {
if((state_val_68222 === (8))){
var inst_68193 = (state_68221[(2)]);
var inst_68194 = fluree.db.util.async.channel_QMARK_(max);
var state_68221__$1 = (function (){var statearr_68244 = state_68221;
(statearr_68244[(8)] = inst_68193);

return statearr_68244;
})();
if(inst_68194){
var statearr_68245_68268 = state_68221__$1;
(statearr_68245_68268[(1)] = (10));

} else {
var statearr_68246_68269 = state_68221__$1;
(statearr_68246_68269[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_68247 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68247[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_68247[(1)] = (1));

return statearr_68247;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_68221){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68221);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68248){var ex__2687__auto__ = e68248;
var statearr_68249_68270 = state_68221;
(statearr_68249_68270[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68221[(4)]))){
var statearr_68250_68271 = state_68221;
(statearr_68250_68271[(1)] = cljs.core.first((state_68221[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68272 = state_68221;
state_68221 = G__68272;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_68221){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_68221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68251 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68251[(6)] = c__2706__auto__);

return statearr_68251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68293){
var state_val_68294 = (state_68293[(1)]);
if((state_val_68294 === (1))){
var state_68293__$1 = state_68293;
var statearr_68295_68310 = state_68293__$1;
(statearr_68295_68310[(2)] = null);

(statearr_68295_68310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68294 === (2))){
var _ = (function (){var statearr_68296 = state_68293;
(statearr_68296[(4)] = cljs.core.cons((5),(state_68293[(4)])));

return statearr_68296;
})();
var inst_68279 = cljs.core.random_uuid();
var inst_68280 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68279);
var inst_68281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68282 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68283 = cljs.core.PersistentVector.EMPTY;
var inst_68284 = ["uuid",inst_68283,inst_68280];
var inst_68285 = cljs.core.PersistentHashMap.fromArrays(inst_68282,inst_68284);
var inst_68286 = [inst_68285,(10)];
var inst_68287 = (new cljs.core.PersistentVector(null,2,(5),inst_68281,inst_68286,null));
var inst_68288 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68287);
var ___$1 = (function (){var statearr_68297 = state_68293;
(statearr_68297[(4)] = cljs.core.rest((state_68293[(4)])));

return statearr_68297;
})();
var state_68293__$1 = (function (){var statearr_68298 = state_68293;
(statearr_68298[(7)] = inst_68288);

return statearr_68298;
})();
var statearr_68299_68311 = state_68293__$1;
(statearr_68299_68311[(2)] = inst_68280);

(statearr_68299_68311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68294 === (3))){
var inst_68291 = (state_68293[(2)]);
var state_68293__$1 = state_68293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68293__$1,inst_68291);
} else {
if((state_val_68294 === (4))){
var inst_68273 = (state_68293[(2)]);
var state_68293__$1 = state_68293;
var statearr_68301_68312 = state_68293__$1;
(statearr_68301_68312[(2)] = inst_68273);

(statearr_68301_68312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68294 === (5))){
var _ = (function (){var statearr_68302 = state_68293;
(statearr_68302[(4)] = cljs.core.rest((state_68293[(4)])));

return statearr_68302;
})();
var state_68293__$1 = state_68293;
var ex68300 = (state_68293__$1[(2)]);
var statearr_68303_68313 = state_68293__$1;
(statearr_68303_68313[(5)] = ex68300);


if((ex68300 instanceof Error)){
var statearr_68304_68314 = state_68293__$1;
(statearr_68304_68314[(1)] = (4));

(statearr_68304_68314[(5)] = null);

} else {
throw ex68300;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0 = (function (){
var statearr_68305 = [null,null,null,null,null,null,null,null];
(statearr_68305[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__);

(statearr_68305[(1)] = (1));

return statearr_68305;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1 = (function (state_68293){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68293);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68306){var ex__2687__auto__ = e68306;
var statearr_68307_68315 = state_68293;
(statearr_68307_68315[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68293[(4)]))){
var statearr_68308_68316 = state_68293;
(statearr_68308_68316[(1)] = cljs.core.first((state_68293[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68317 = state_68293;
state_68293 = G__68317;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = function(state_68293){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1.call(this,state_68293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68309 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68309[(6)] = c__2706__auto__);

return statearr_68309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68347){
var state_val_68348 = (state_68347[(1)]);
if((state_val_68348 === (7))){
var state_68347__$1 = state_68347;
var statearr_68349_68368 = state_68347__$1;
(statearr_68349_68368[(2)] = num);

(statearr_68349_68368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68348 === (1))){
var state_68347__$1 = state_68347;
var statearr_68350_68369 = state_68347__$1;
(statearr_68350_68369[(2)] = null);

(statearr_68350_68369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68348 === (4))){
var inst_68318 = (state_68347[(2)]);
var state_68347__$1 = state_68347;
var statearr_68351_68370 = state_68347__$1;
(statearr_68351_68370[(2)] = inst_68318);

(statearr_68351_68370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68348 === (6))){
var state_68347__$1 = state_68347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68347__$1,(9),num);
} else {
if((state_val_68348 === (3))){
var inst_68345 = (state_68347[(2)]);
var state_68347__$1 = state_68347;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68347__$1,inst_68345);
} else {
if((state_val_68348 === (2))){
var _ = (function (){var statearr_68353 = state_68347;
(statearr_68353[(4)] = cljs.core.cons((5),(state_68347[(4)])));

return statearr_68353;
})();
var inst_68324 = fluree.db.util.async.channel_QMARK_(num);
var state_68347__$1 = state_68347;
if(inst_68324){
var statearr_68354_68371 = state_68347__$1;
(statearr_68354_68371[(1)] = (6));

} else {
var statearr_68355_68372 = state_68347__$1;
(statearr_68355_68372[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68348 === (9))){
var inst_68327 = (state_68347[(2)]);
var inst_68328 = fluree.db.util.async.throw_err(inst_68327);
var state_68347__$1 = state_68347;
var statearr_68356_68373 = state_68347__$1;
(statearr_68356_68373[(2)] = inst_68328);

(statearr_68356_68373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68348 === (5))){
var _ = (function (){var statearr_68357 = state_68347;
(statearr_68357[(4)] = cljs.core.rest((state_68347[(4)])));

return statearr_68357;
})();
var state_68347__$1 = state_68347;
var ex68352 = (state_68347__$1[(2)]);
var statearr_68358_68374 = state_68347__$1;
(statearr_68358_68374[(5)] = ex68352);


if((ex68352 instanceof Error)){
var statearr_68359_68375 = state_68347__$1;
(statearr_68359_68375[(1)] = (4));

(statearr_68359_68375[(5)] = null);

} else {
throw ex68352;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68348 === (8))){
var inst_68331 = (state_68347[(2)]);
var inst_68332 = fluree.db.dbfunctions.internal.ceil(inst_68331);
var inst_68333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68334 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68336 = [fluree.db.dbfunctions.fns.ceil];
var inst_68337 = (new cljs.core.PersistentVector(null,1,(5),inst_68335,inst_68336,null));
var inst_68338 = ["",inst_68337,inst_68332];
var inst_68339 = cljs.core.PersistentHashMap.fromArrays(inst_68334,inst_68338);
var inst_68340 = [inst_68339,(10)];
var inst_68341 = (new cljs.core.PersistentVector(null,2,(5),inst_68333,inst_68340,null));
var inst_68342 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68341);
var _ = (function (){var statearr_68360 = state_68347;
(statearr_68360[(4)] = cljs.core.rest((state_68347[(4)])));

return statearr_68360;
})();
var state_68347__$1 = (function (){var statearr_68361 = state_68347;
(statearr_68361[(7)] = inst_68342);

return statearr_68361;
})();
var statearr_68362_68376 = state_68347__$1;
(statearr_68362_68376[(2)] = inst_68332);

(statearr_68362_68376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0 = (function (){
var statearr_68363 = [null,null,null,null,null,null,null,null];
(statearr_68363[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__);

(statearr_68363[(1)] = (1));

return statearr_68363;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1 = (function (state_68347){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68347);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68364){var ex__2687__auto__ = e68364;
var statearr_68365_68377 = state_68347;
(statearr_68365_68377[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68347[(4)]))){
var statearr_68366_68378 = state_68347;
(statearr_68366_68378[(1)] = cljs.core.first((state_68347[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68379 = state_68347;
state_68347 = G__68379;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = function(state_68347){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1.call(this,state_68347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68367 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68367[(6)] = c__2706__auto__);

return statearr_68367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68409){
var state_val_68410 = (state_68409[(1)]);
if((state_val_68410 === (7))){
var state_68409__$1 = state_68409;
var statearr_68411_68430 = state_68409__$1;
(statearr_68411_68430[(2)] = num);

(statearr_68411_68430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68410 === (1))){
var state_68409__$1 = state_68409;
var statearr_68412_68431 = state_68409__$1;
(statearr_68412_68431[(2)] = null);

(statearr_68412_68431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68410 === (4))){
var inst_68380 = (state_68409[(2)]);
var state_68409__$1 = state_68409;
var statearr_68413_68432 = state_68409__$1;
(statearr_68413_68432[(2)] = inst_68380);

(statearr_68413_68432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68410 === (6))){
var state_68409__$1 = state_68409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68409__$1,(9),num);
} else {
if((state_val_68410 === (3))){
var inst_68407 = (state_68409[(2)]);
var state_68409__$1 = state_68409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68409__$1,inst_68407);
} else {
if((state_val_68410 === (2))){
var _ = (function (){var statearr_68415 = state_68409;
(statearr_68415[(4)] = cljs.core.cons((5),(state_68409[(4)])));

return statearr_68415;
})();
var inst_68386 = fluree.db.util.async.channel_QMARK_(num);
var state_68409__$1 = state_68409;
if(inst_68386){
var statearr_68416_68433 = state_68409__$1;
(statearr_68416_68433[(1)] = (6));

} else {
var statearr_68417_68434 = state_68409__$1;
(statearr_68417_68434[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68410 === (9))){
var inst_68389 = (state_68409[(2)]);
var inst_68390 = fluree.db.util.async.throw_err(inst_68389);
var state_68409__$1 = state_68409;
var statearr_68418_68435 = state_68409__$1;
(statearr_68418_68435[(2)] = inst_68390);

(statearr_68418_68435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68410 === (5))){
var _ = (function (){var statearr_68419 = state_68409;
(statearr_68419[(4)] = cljs.core.rest((state_68409[(4)])));

return statearr_68419;
})();
var state_68409__$1 = state_68409;
var ex68414 = (state_68409__$1[(2)]);
var statearr_68420_68436 = state_68409__$1;
(statearr_68420_68436[(5)] = ex68414);


if((ex68414 instanceof Error)){
var statearr_68421_68437 = state_68409__$1;
(statearr_68421_68437[(1)] = (4));

(statearr_68421_68437[(5)] = null);

} else {
throw ex68414;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68410 === (8))){
var inst_68393 = (state_68409[(2)]);
var inst_68394 = fluree.db.dbfunctions.internal.floor(inst_68393);
var inst_68395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68396 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68398 = [fluree.db.dbfunctions.fns.floor];
var inst_68399 = (new cljs.core.PersistentVector(null,1,(5),inst_68397,inst_68398,null));
var inst_68400 = ["",inst_68399,inst_68394];
var inst_68401 = cljs.core.PersistentHashMap.fromArrays(inst_68396,inst_68400);
var inst_68402 = [inst_68401,(10)];
var inst_68403 = (new cljs.core.PersistentVector(null,2,(5),inst_68395,inst_68402,null));
var inst_68404 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68403);
var _ = (function (){var statearr_68422 = state_68409;
(statearr_68422[(4)] = cljs.core.rest((state_68409[(4)])));

return statearr_68422;
})();
var state_68409__$1 = (function (){var statearr_68423 = state_68409;
(statearr_68423[(7)] = inst_68404);

return statearr_68423;
})();
var statearr_68424_68438 = state_68409__$1;
(statearr_68424_68438[(2)] = inst_68394);

(statearr_68424_68438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0 = (function (){
var statearr_68425 = [null,null,null,null,null,null,null,null];
(statearr_68425[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__);

(statearr_68425[(1)] = (1));

return statearr_68425;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1 = (function (state_68409){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68409);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68426){var ex__2687__auto__ = e68426;
var statearr_68427_68439 = state_68409;
(statearr_68427_68439[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68409[(4)]))){
var statearr_68428_68440 = state_68409;
(statearr_68428_68440[(1)] = cljs.core.first((state_68409[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68441 = state_68409;
state_68409 = G__68441;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = function(state_68409){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1.call(this,state_68409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68429 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68429[(6)] = c__2706__auto__);

return statearr_68429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68466){
var state_val_68467 = (state_68466[(1)]);
if((state_val_68467 === (1))){
var state_68466__$1 = state_68466;
var statearr_68468_68483 = state_68466__$1;
(statearr_68468_68483[(2)] = null);

(statearr_68468_68483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68467 === (2))){
var _ = (function (){var statearr_68469 = state_68466;
(statearr_68469[(4)] = cljs.core.cons((5),(state_68466[(4)])));

return statearr_68469;
})();
var inst_68448 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_68466__$1 = state_68466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68466__$1,(6),inst_68448);
} else {
if((state_val_68467 === (3))){
var inst_68464 = (state_68466[(2)]);
var state_68466__$1 = state_68466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68466__$1,inst_68464);
} else {
if((state_val_68467 === (4))){
var inst_68442 = (state_68466[(2)]);
var state_68466__$1 = state_68466;
var statearr_68471_68484 = state_68466__$1;
(statearr_68471_68484[(2)] = inst_68442);

(statearr_68471_68484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68467 === (5))){
var _ = (function (){var statearr_68472 = state_68466;
(statearr_68472[(4)] = cljs.core.rest((state_68466[(4)])));

return statearr_68472;
})();
var state_68466__$1 = state_68466;
var ex68470 = (state_68466__$1[(2)]);
var statearr_68473_68485 = state_68466__$1;
(statearr_68473_68485[(5)] = ex68470);


if((ex68470 instanceof Error)){
var statearr_68474_68486 = state_68466__$1;
(statearr_68474_68486[(1)] = (4));

(statearr_68474_68486[(5)] = null);

} else {
throw ex68470;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68467 === (6))){
var inst_68450 = (state_68466[(2)]);
var inst_68451 = fluree.db.util.async.throw_err(inst_68450);
var inst_68452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68453 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68455 = [compare_val,new_val];
var inst_68456 = (new cljs.core.PersistentVector(null,2,(5),inst_68454,inst_68455,null));
var inst_68457 = ["",inst_68456,inst_68451];
var inst_68458 = cljs.core.PersistentHashMap.fromArrays(inst_68453,inst_68457);
var inst_68459 = [inst_68458,(10)];
var inst_68460 = (new cljs.core.PersistentVector(null,2,(5),inst_68452,inst_68459,null));
var inst_68461 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68460);
var _ = (function (){var statearr_68475 = state_68466;
(statearr_68475[(4)] = cljs.core.rest((state_68466[(4)])));

return statearr_68475;
})();
var state_68466__$1 = (function (){var statearr_68476 = state_68466;
(statearr_68476[(7)] = inst_68461);

return statearr_68476;
})();
var statearr_68477_68487 = state_68466__$1;
(statearr_68477_68487[(2)] = inst_68451);

(statearr_68477_68487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_68478 = [null,null,null,null,null,null,null,null];
(statearr_68478[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__);

(statearr_68478[(1)] = (1));

return statearr_68478;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1 = (function (state_68466){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68466);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68479){var ex__2687__auto__ = e68479;
var statearr_68480_68488 = state_68466;
(statearr_68480_68488[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68466[(4)]))){
var statearr_68481_68489 = state_68466;
(statearr_68481_68489[(1)] = cljs.core.first((state_68466[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68490 = state_68466;
state_68466 = G__68490;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = function(state_68466){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1.call(this,state_68466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68482 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68482[(6)] = c__2706__auto__);

return statearr_68482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
