// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__70600 = arguments.length;
switch (G__70600) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___70748 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70687){
var state_val_70688 = (state_70687[(1)]);
if((state_val_70688 === (7))){
var inst_70618 = (state_70687[(7)]);
var inst_70621 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_70618);
var state_70687__$1 = state_70687;
var statearr_70689_70749 = state_70687__$1;
(statearr_70689_70749[(2)] = inst_70621);

(statearr_70689_70749[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (20))){
var inst_70642 = (state_70687[(8)]);
var inst_70613 = (state_70687[(9)]);
var inst_70646 = fluree.db.auth.roles(inst_70613,inst_70642);
var state_70687__$1 = state_70687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70687__$1,(23),inst_70646);
} else {
if((state_val_70688 === (27))){
var inst_70613 = (state_70687[(9)]);
var inst_70661 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_70662 = fluree.db.time_travel.as_of_block(inst_70613,inst_70661);
var state_70687__$1 = state_70687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70687__$1,(30),inst_70662);
} else {
if((state_val_70688 === (1))){
var state_70687__$1 = state_70687;
var statearr_70690_70750 = state_70687__$1;
(statearr_70690_70750[(2)] = null);

(statearr_70690_70750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (24))){
var inst_70613 = (state_70687[(9)]);
var inst_70654 = (state_70687[(10)]);
var inst_70656 = fluree.db.permissions.permission_map(inst_70613,inst_70654,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_70687__$1 = state_70687;
var statearr_70691_70751 = state_70687__$1;
(statearr_70691_70751[(2)] = inst_70656);

(statearr_70691_70751[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (4))){
var inst_70601 = (state_70687[(2)]);
var inst_70602 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70601);
var inst_70603 = cljs.core.async.close_BANG_(pc);
var state_70687__$1 = (function (){var statearr_70692 = state_70687;
(statearr_70692[(11)] = inst_70602);

return statearr_70692;
})();
var statearr_70693_70752 = state_70687__$1;
(statearr_70693_70752[(2)] = inst_70603);

(statearr_70693_70752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (15))){
var inst_70618 = (state_70687[(7)]);
var inst_70632 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70618)," unknown."].join('');
var inst_70633 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70634 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_70635 = cljs.core.PersistentHashMap.fromArrays(inst_70633,inst_70634);
var inst_70636 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70632,inst_70635);
var inst_70637 = (function(){throw inst_70636})();
var state_70687__$1 = state_70687;
var statearr_70694_70753 = state_70687__$1;
(statearr_70694_70753[(2)] = inst_70637);

(statearr_70694_70753[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (21))){
var state_70687__$1 = state_70687;
var statearr_70695_70754 = state_70687__$1;
(statearr_70695_70754[(2)] = null);

(statearr_70695_70754[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (31))){
var inst_70618 = (state_70687[(7)]);
var inst_70668 = (state_70687[(12)]);
var inst_70670 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70668,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_70618);
var state_70687__$1 = state_70687;
var statearr_70696_70755 = state_70687__$1;
(statearr_70696_70755[(2)] = inst_70670);

(statearr_70696_70755[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (32))){
var inst_70668 = (state_70687[(12)]);
var state_70687__$1 = state_70687;
var statearr_70697_70756 = state_70687__$1;
(statearr_70697_70756[(2)] = inst_70668);

(statearr_70697_70756[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (33))){
var inst_70654 = (state_70687[(10)]);
var inst_70673 = (state_70687[(2)]);
var state_70687__$1 = (function (){var statearr_70698 = state_70687;
(statearr_70698[(13)] = inst_70673);

return statearr_70698;
})();
if(cljs.core.truth_(inst_70654)){
var statearr_70699_70757 = state_70687__$1;
(statearr_70699_70757[(1)] = (34));

} else {
var statearr_70700_70758 = state_70687__$1;
(statearr_70700_70758[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (13))){
var inst_70629 = (state_70687[(14)]);
var inst_70628 = (state_70687[(2)]);
var inst_70629__$1 = fluree.db.util.async.throw_err(inst_70628);
var state_70687__$1 = (function (){var statearr_70701 = state_70687;
(statearr_70701[(14)] = inst_70629__$1);

return statearr_70701;
})();
if(cljs.core.truth_(inst_70629__$1)){
var statearr_70702_70759 = state_70687__$1;
(statearr_70702_70759[(1)] = (14));

} else {
var statearr_70703_70760 = state_70687__$1;
(statearr_70703_70760[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (22))){
var inst_70652 = (state_70687[(2)]);
var state_70687__$1 = state_70687;
var statearr_70704_70761 = state_70687__$1;
(statearr_70704_70761[(2)] = inst_70652);

(statearr_70704_70761[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (36))){
var inst_70681 = (state_70687[(2)]);
var inst_70682 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70681);
var _ = (function (){var statearr_70705 = state_70687;
(statearr_70705[(4)] = cljs.core.rest((state_70687[(4)])));

return statearr_70705;
})();
var state_70687__$1 = state_70687;
var statearr_70706_70762 = state_70687__$1;
(statearr_70706_70762[(2)] = inst_70682);

(statearr_70706_70762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (29))){
var inst_70618 = (state_70687[(7)]);
var inst_70668 = (state_70687[(2)]);
var state_70687__$1 = (function (){var statearr_70707 = state_70687;
(statearr_70707[(12)] = inst_70668);

return statearr_70707;
})();
if(cljs.core.truth_(inst_70618)){
var statearr_70708_70763 = state_70687__$1;
(statearr_70708_70763[(1)] = (31));

} else {
var statearr_70709_70764 = state_70687__$1;
(statearr_70709_70764[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (6))){
var inst_70618 = (state_70687[(7)]);
var inst_70612 = (state_70687[(2)]);
var inst_70613 = fluree.db.util.async.throw_err(inst_70612);
var inst_70614 = opts;
var inst_70615 = cljs.core.__destructure_map(inst_70614);
var inst_70616 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70615,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_70617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70615,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_70618__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70615,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70615,new cljs.core.Keyword(null,"block","block",664686210));
var state_70687__$1 = (function (){var statearr_70710 = state_70687;
(statearr_70710[(7)] = inst_70618__$1);

(statearr_70710[(9)] = inst_70613);

(statearr_70710[(15)] = inst_70619);

(statearr_70710[(16)] = inst_70617);

(statearr_70710[(17)] = inst_70616);

return statearr_70710;
})();
if(cljs.core.truth_(inst_70618__$1)){
var statearr_70711_70765 = state_70687__$1;
(statearr_70711_70765[(1)] = (7));

} else {
var statearr_70712_70766 = state_70687__$1;
(statearr_70712_70766[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (28))){
var inst_70613 = (state_70687[(9)]);
var state_70687__$1 = state_70687;
var statearr_70713_70767 = state_70687__$1;
(statearr_70713_70767[(2)] = inst_70613);

(statearr_70713_70767[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (25))){
var state_70687__$1 = state_70687;
var statearr_70714_70768 = state_70687__$1;
(statearr_70714_70768[(2)] = null);

(statearr_70714_70768[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (34))){
var inst_70659 = (state_70687[(18)]);
var state_70687__$1 = state_70687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70687__$1,(37),inst_70659);
} else {
if((state_val_70688 === (17))){
var inst_70616 = (state_70687[(17)]);
var state_70687__$1 = state_70687;
var statearr_70715_70769 = state_70687__$1;
(statearr_70715_70769[(2)] = inst_70616);

(statearr_70715_70769[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (3))){
var inst_70685 = (state_70687[(2)]);
var state_70687__$1 = state_70687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70687__$1,inst_70685);
} else {
if((state_val_70688 === (12))){
var inst_70616 = (state_70687[(17)]);
var inst_70642 = (state_70687[(2)]);
var state_70687__$1 = (function (){var statearr_70716 = state_70687;
(statearr_70716[(8)] = inst_70642);

return statearr_70716;
})();
if(cljs.core.truth_(inst_70616)){
var statearr_70717_70770 = state_70687__$1;
(statearr_70717_70770[(1)] = (17));

} else {
var statearr_70718_70771 = state_70687__$1;
(statearr_70718_70771[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (2))){
var _ = (function (){var statearr_70719 = state_70687;
(statearr_70719[(4)] = cljs.core.cons((5),(state_70687[(4)])));

return statearr_70719;
})();
var inst_70610 = fluree.db.session.db(conn,ledger,null);
var state_70687__$1 = state_70687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70687__$1,(6),inst_70610);
} else {
if((state_val_70688 === (23))){
var inst_70648 = (state_70687[(2)]);
var inst_70649 = fluree.db.util.async.throw_err(inst_70648);
var state_70687__$1 = state_70687;
var statearr_70720_70772 = state_70687__$1;
(statearr_70720_70772[(2)] = inst_70649);

(statearr_70720_70772[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (35))){
var inst_70673 = (state_70687[(13)]);
var state_70687__$1 = state_70687;
var statearr_70721_70773 = state_70687__$1;
(statearr_70721_70773[(2)] = inst_70673);

(statearr_70721_70773[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (19))){
var inst_70654 = (state_70687[(10)]);
var inst_70654__$1 = (state_70687[(2)]);
var state_70687__$1 = (function (){var statearr_70722 = state_70687;
(statearr_70722[(10)] = inst_70654__$1);

return statearr_70722;
})();
if(cljs.core.truth_(inst_70654__$1)){
var statearr_70723_70774 = state_70687__$1;
(statearr_70723_70774[(1)] = (24));

} else {
var statearr_70724_70775 = state_70687__$1;
(statearr_70724_70775[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (11))){
var state_70687__$1 = state_70687;
var statearr_70726_70776 = state_70687__$1;
(statearr_70726_70776[(2)] = null);

(statearr_70726_70776[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (9))){
var inst_70624 = (state_70687[(2)]);
var state_70687__$1 = state_70687;
if(cljs.core.truth_(inst_70624)){
var statearr_70727_70777 = state_70687__$1;
(statearr_70727_70777[(1)] = (10));

} else {
var statearr_70728_70778 = state_70687__$1;
(statearr_70728_70778[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (5))){
var _ = (function (){var statearr_70729 = state_70687;
(statearr_70729[(4)] = cljs.core.rest((state_70687[(4)])));

return statearr_70729;
})();
var state_70687__$1 = state_70687;
var ex70725 = (state_70687__$1[(2)]);
var statearr_70730_70779 = state_70687__$1;
(statearr_70730_70779[(5)] = ex70725);


var statearr_70731_70780 = state_70687__$1;
(statearr_70731_70780[(1)] = (4));

(statearr_70731_70780[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (14))){
var inst_70629 = (state_70687[(14)]);
var state_70687__$1 = state_70687;
var statearr_70732_70781 = state_70687__$1;
(statearr_70732_70781[(2)] = inst_70629);

(statearr_70732_70781[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (26))){
var inst_70619 = (state_70687[(15)]);
var inst_70659 = (state_70687[(2)]);
var state_70687__$1 = (function (){var statearr_70733 = state_70687;
(statearr_70733[(18)] = inst_70659);

return statearr_70733;
})();
if(cljs.core.truth_(inst_70619)){
var statearr_70734_70782 = state_70687__$1;
(statearr_70734_70782[(1)] = (27));

} else {
var statearr_70735_70783 = state_70687__$1;
(statearr_70735_70783[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (16))){
var inst_70639 = (state_70687[(2)]);
var state_70687__$1 = state_70687;
var statearr_70736_70784 = state_70687__$1;
(statearr_70736_70784[(2)] = inst_70639);

(statearr_70736_70784[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (30))){
var inst_70664 = (state_70687[(2)]);
var inst_70665 = fluree.db.util.async.throw_err(inst_70664);
var state_70687__$1 = state_70687;
var statearr_70737_70785 = state_70687__$1;
(statearr_70737_70785[(2)] = inst_70665);

(statearr_70737_70785[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (10))){
var inst_70618 = (state_70687[(7)]);
var inst_70613 = (state_70687[(9)]);
var inst_70626 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_70613,inst_70618);
var state_70687__$1 = state_70687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70687__$1,(13),inst_70626);
} else {
if((state_val_70688 === (18))){
var inst_70642 = (state_70687[(8)]);
var state_70687__$1 = state_70687;
if(cljs.core.truth_(inst_70642)){
var statearr_70738_70786 = state_70687__$1;
(statearr_70738_70786[(1)] = (20));

} else {
var statearr_70739_70787 = state_70687__$1;
(statearr_70739_70787[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (37))){
var inst_70673 = (state_70687[(13)]);
var inst_70676 = (state_70687[(2)]);
var inst_70677 = fluree.db.util.async.throw_err(inst_70676);
var inst_70678 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70673,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_70677);
var state_70687__$1 = state_70687;
var statearr_70740_70788 = state_70687__$1;
(statearr_70740_70788[(2)] = inst_70678);

(statearr_70740_70788[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70688 === (8))){
var inst_70618 = (state_70687[(7)]);
var state_70687__$1 = state_70687;
var statearr_70741_70789 = state_70687__$1;
(statearr_70741_70789[(2)] = inst_70618);

(statearr_70741_70789[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2684__auto__ = null;
var fluree$db$api$query$state_machine__2684__auto____0 = (function (){
var statearr_70742 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70742[(0)] = fluree$db$api$query$state_machine__2684__auto__);

(statearr_70742[(1)] = (1));

return statearr_70742;
});
var fluree$db$api$query$state_machine__2684__auto____1 = (function (state_70687){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70687);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70743){var ex__2687__auto__ = e70743;
var statearr_70744_70790 = state_70687;
(statearr_70744_70790[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70687[(4)]))){
var statearr_70745_70791 = state_70687;
(statearr_70745_70791[(1)] = cljs.core.first((state_70687[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70792 = state_70687;
state_70687 = G__70792;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2684__auto__ = function(state_70687){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2684__auto____1.call(this,state_70687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2684__auto____0;
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2684__auto____1;
return fluree$db$api$query$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70746 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70746[(6)] = c__2706__auto___70748);

return statearr_70746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70933){
var state_val_70934 = (state_70933[(1)]);
if((state_val_70934 === (7))){
var inst_70813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70814 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70815 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70816 = [inst_70814,inst_70815];
var inst_70817 = (new cljs.core.PersistentVector(null,2,(5),inst_70813,inst_70816,null));
var state_70933__$1 = state_70933;
var statearr_70935_71005 = state_70933__$1;
(statearr_70935_71005[(2)] = inst_70817);

(statearr_70935_71005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (20))){
var inst_70843 = (state_70933[(7)]);
var state_70933__$1 = state_70933;
var statearr_70936_71006 = state_70933__$1;
(statearr_70936_71006[(2)] = inst_70843);

(statearr_70936_71006[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (27))){
var state_70933__$1 = state_70933;
var statearr_70937_71007 = state_70933__$1;
(statearr_70937_71007[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (1))){
var state_70933__$1 = state_70933;
var statearr_70939_71008 = state_70933__$1;
(statearr_70939_71008[(2)] = null);

(statearr_70939_71008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (24))){
var inst_70842 = (state_70933[(8)]);
var state_70933__$1 = state_70933;
if(cljs.core.truth_(inst_70842)){
var statearr_70940_71009 = state_70933__$1;
(statearr_70940_71009[(1)] = (26));

} else {
var statearr_70941_71010 = state_70933__$1;
(statearr_70941_71010[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (39))){
var inst_70889 = (state_70933[(9)]);
var inst_70888 = (state_70933[(10)]);
var inst_70914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70915 = [inst_70888,inst_70889];
var inst_70916 = (new cljs.core.PersistentVector(null,2,(5),inst_70914,inst_70915,null));
var state_70933__$1 = state_70933;
var statearr_70942_71011 = state_70933__$1;
(statearr_70942_71011[(2)] = inst_70916);

(statearr_70942_71011[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (4))){
var inst_70793 = (state_70933[(2)]);
var state_70933__$1 = state_70933;
var statearr_70943_71012 = state_70933__$1;
(statearr_70943_71012[(2)] = inst_70793);

(statearr_70943_71012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (15))){
var inst_70827 = (state_70933[(11)]);
var inst_70822 = (state_70933[(12)]);
var inst_70836 = (state_70933[(2)]);
var inst_70837 = [inst_70827,inst_70836];
var inst_70838 = (new cljs.core.PersistentVector(null,2,(5),inst_70822,inst_70837,null));
var state_70933__$1 = state_70933;
var statearr_70944_71013 = state_70933__$1;
(statearr_70944_71013[(2)] = inst_70838);

(statearr_70944_71013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (21))){
var inst_70842 = (state_70933[(8)]);
var state_70933__$1 = state_70933;
var statearr_70945_71014 = state_70933__$1;
(statearr_70945_71014[(2)] = inst_70842);

(statearr_70945_71014[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (31))){
var inst_70883 = (state_70933[(2)]);
var state_70933__$1 = state_70933;
var statearr_70946_71015 = state_70933__$1;
(statearr_70946_71015[(2)] = inst_70883);

(statearr_70946_71015[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (32))){
var inst_70889 = (state_70933[(9)]);
var inst_70892 = cljs.core.pos_int_QMARK_(inst_70889);
var state_70933__$1 = state_70933;
var statearr_70947_71016 = state_70933__$1;
(statearr_70947_71016[(2)] = inst_70892);

(statearr_70947_71016[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (40))){
var inst_70920 = (state_70933[(13)]);
var inst_70844 = (state_70933[(14)]);
var inst_70918 = (state_70933[(2)]);
var inst_70919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70918,(0),null);
var inst_70920__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70918,(1),null);
var inst_70921 = (inst_70920__$1 > inst_70844);
var state_70933__$1 = (function (){var statearr_70948 = state_70933;
(statearr_70948[(13)] = inst_70920__$1);

(statearr_70948[(15)] = inst_70919);

return statearr_70948;
})();
if(cljs.core.truth_(inst_70921)){
var statearr_70949_71017 = state_70933__$1;
(statearr_70949_71017[(1)] = (41));

} else {
var statearr_70950_71018 = state_70933__$1;
(statearr_70950_71018[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (33))){
var inst_70890 = (state_70933[(16)]);
var state_70933__$1 = state_70933;
var statearr_70951_71019 = state_70933__$1;
(statearr_70951_71019[(2)] = inst_70890);

(statearr_70951_71019[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (13))){
var inst_70828 = (state_70933[(17)]);
var inst_70830 = fluree.db.time_travel.block_to_int_format(db,inst_70828);
var state_70933__$1 = state_70933;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70933__$1,(16),inst_70830);
} else {
if((state_val_70934 === (22))){
var inst_70861 = (state_70933[(2)]);
var state_70933__$1 = state_70933;
if(cljs.core.truth_(inst_70861)){
var statearr_70952_71020 = state_70933__$1;
(statearr_70952_71020[(1)] = (23));

} else {
var statearr_70953_71021 = state_70933__$1;
(statearr_70953_71021[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (36))){
var state_70933__$1 = state_70933;
var statearr_70954_71022 = state_70933__$1;
(statearr_70954_71022[(2)] = null);

(statearr_70954_71022[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (41))){
var inst_70844 = (state_70933[(14)]);
var state_70933__$1 = state_70933;
var statearr_70955_71023 = state_70933__$1;
(statearr_70955_71023[(2)] = inst_70844);

(statearr_70955_71023[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (43))){
var inst_70919 = (state_70933[(15)]);
var inst_70925 = (state_70933[(2)]);
var inst_70926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70927 = [inst_70919,inst_70925];
var inst_70928 = (new cljs.core.PersistentVector(null,2,(5),inst_70926,inst_70927,null));
var _ = (function (){var statearr_70956 = state_70933;
(statearr_70956[(4)] = cljs.core.rest((state_70933[(4)])));

return statearr_70956;
})();
var state_70933__$1 = state_70933;
var statearr_70957_71024 = state_70933__$1;
(statearr_70957_71024[(2)] = inst_70928);

(statearr_70957_71024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (29))){
var inst_70819 = (state_70933[(18)]);
var inst_70874 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70819], 0));
var inst_70875 = ["Invalid block range provided: ",inst_70874].join('');
var inst_70876 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70877 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70878 = cljs.core.PersistentHashMap.fromArrays(inst_70876,inst_70877);
var inst_70879 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70875,inst_70878);
var inst_70880 = (function(){throw inst_70879})();
var state_70933__$1 = state_70933;
var statearr_70958_71025 = state_70933__$1;
(statearr_70958_71025[(2)] = inst_70880);

(statearr_70958_71025[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (6))){
var inst_70811 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70933__$1 = state_70933;
var statearr_70959_71026 = state_70933__$1;
(statearr_70959_71026[(2)] = inst_70811);

(statearr_70959_71026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (28))){
var inst_70885 = (state_70933[(2)]);
var state_70933__$1 = state_70933;
var statearr_70960_71027 = state_70933__$1;
(statearr_70960_71027[(2)] = inst_70885);

(statearr_70960_71027[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (25))){
var inst_70888 = (state_70933[(10)]);
var inst_70890 = (state_70933[(16)]);
var inst_70887 = (state_70933[(2)]);
var inst_70888__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70887,(0),null);
var inst_70889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70887,(1),null);
var inst_70890__$1 = cljs.core.pos_int_QMARK_(inst_70888__$1);
var state_70933__$1 = (function (){var statearr_70961 = state_70933;
(statearr_70961[(9)] = inst_70889);

(statearr_70961[(10)] = inst_70888__$1);

(statearr_70961[(16)] = inst_70890__$1);

return statearr_70961;
})();
if(inst_70890__$1){
var statearr_70962_71028 = state_70933__$1;
(statearr_70962_71028[(1)] = (32));

} else {
var statearr_70963_71029 = state_70933__$1;
(statearr_70963_71029[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (34))){
var inst_70895 = (state_70933[(2)]);
var inst_70896 = cljs.core.not(inst_70895);
var state_70933__$1 = state_70933;
if(inst_70896){
var statearr_70964_71030 = state_70933__$1;
(statearr_70964_71030[(1)] = (35));

} else {
var statearr_70965_71031 = state_70933__$1;
(statearr_70965_71031[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (17))){
var inst_70842 = (state_70933[(8)]);
var inst_70844 = (state_70933[(14)]);
var inst_70847 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70842], 0));
var inst_70848 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70844], 0));
var inst_70849 = ["Start block is out of range for this ledger. Start block provided: ",inst_70847,". Database block: ",inst_70848].join('');
var inst_70850 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70851 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70852 = cljs.core.PersistentHashMap.fromArrays(inst_70850,inst_70851);
var inst_70853 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70849,inst_70852);
var inst_70854 = (function(){throw inst_70853})();
var state_70933__$1 = state_70933;
var statearr_70966_71032 = state_70933__$1;
(statearr_70966_71032[(2)] = inst_70854);

(statearr_70966_71032[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (3))){
var inst_70931 = (state_70933[(2)]);
var state_70933__$1 = state_70933;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70933__$1,inst_70931);
} else {
if((state_val_70934 === (12))){
var inst_70819 = (state_70933[(18)]);
var inst_70828 = (state_70933[(17)]);
var inst_70826 = (state_70933[(2)]);
var inst_70827 = fluree.db.util.async.throw_err(inst_70826);
var inst_70828__$1 = cljs.core.second(inst_70819);
var state_70933__$1 = (function (){var statearr_70967 = state_70933;
(statearr_70967[(11)] = inst_70827);

(statearr_70967[(17)] = inst_70828__$1);

return statearr_70967;
})();
if(cljs.core.truth_(inst_70828__$1)){
var statearr_70968_71033 = state_70933__$1;
(statearr_70968_71033[(1)] = (13));

} else {
var statearr_70969_71034 = state_70933__$1;
(statearr_70969_71034[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (2))){
var _ = (function (){var statearr_70970 = state_70933;
(statearr_70970[(4)] = cljs.core.cons((5),(state_70933[(4)])));

return statearr_70970;
})();
var inst_70808 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70809 = cljs.core.sequential_QMARK_(inst_70808);
var state_70933__$1 = state_70933;
if(inst_70809){
var statearr_70971_71035 = state_70933__$1;
(statearr_70971_71035[(1)] = (6));

} else {
var statearr_70972_71036 = state_70933__$1;
(statearr_70972_71036[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (23))){
var inst_70843 = (state_70933[(7)]);
var inst_70842 = (state_70933[(8)]);
var inst_70863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70864 = [inst_70842,inst_70843];
var inst_70865 = (new cljs.core.PersistentVector(null,2,(5),inst_70863,inst_70864,null));
var state_70933__$1 = state_70933;
var statearr_70973_71037 = state_70933__$1;
(statearr_70973_71037[(2)] = inst_70865);

(statearr_70973_71037[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (35))){
var inst_70819 = (state_70933[(18)]);
var inst_70898 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70819], 0));
var inst_70899 = ["Invalid block range provided: ",inst_70898].join('');
var inst_70900 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70901 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70902 = cljs.core.PersistentHashMap.fromArrays(inst_70900,inst_70901);
var inst_70903 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70899,inst_70902);
var inst_70904 = (function(){throw inst_70903})();
var state_70933__$1 = state_70933;
var statearr_70974_71038 = state_70933__$1;
(statearr_70974_71038[(2)] = inst_70904);

(statearr_70974_71038[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (19))){
var inst_70842 = (state_70933[(8)]);
var inst_70857 = (state_70933[(2)]);
var state_70933__$1 = (function (){var statearr_70975 = state_70933;
(statearr_70975[(19)] = inst_70857);

return statearr_70975;
})();
if(cljs.core.truth_(inst_70842)){
var statearr_70976_71039 = state_70933__$1;
(statearr_70976_71039[(1)] = (20));

} else {
var statearr_70977_71040 = state_70933__$1;
(statearr_70977_71040[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (11))){
var inst_70842 = (state_70933[(8)]);
var inst_70844 = (state_70933[(14)]);
var inst_70841 = (state_70933[(2)]);
var inst_70842__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70841,(0),null);
var inst_70843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70841,(1),null);
var inst_70844__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70845 = (inst_70842__$1 > inst_70844__$1);
var state_70933__$1 = (function (){var statearr_70979 = state_70933;
(statearr_70979[(7)] = inst_70843);

(statearr_70979[(8)] = inst_70842__$1);

(statearr_70979[(14)] = inst_70844__$1);

return statearr_70979;
})();
if(cljs.core.truth_(inst_70845)){
var statearr_70980_71041 = state_70933__$1;
(statearr_70980_71041[(1)] = (17));

} else {
var statearr_70981_71042 = state_70933__$1;
(statearr_70981_71042[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (9))){
var inst_70819 = (state_70933[(18)]);
var inst_70822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70823 = cljs.core.first(inst_70819);
var inst_70824 = fluree.db.time_travel.block_to_int_format(db,inst_70823);
var state_70933__$1 = (function (){var statearr_70982 = state_70933;
(statearr_70982[(12)] = inst_70822);

return statearr_70982;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70933__$1,(12),inst_70824);
} else {
if((state_val_70934 === (5))){
var _ = (function (){var statearr_70983 = state_70933;
(statearr_70983[(4)] = cljs.core.rest((state_70933[(4)])));

return statearr_70983;
})();
var state_70933__$1 = state_70933;
var ex70978 = (state_70933__$1[(2)]);
var statearr_70984_71043 = state_70933__$1;
(statearr_70984_71043[(5)] = ex70978);


if((ex70978 instanceof Error)){
var statearr_70985_71044 = state_70933__$1;
(statearr_70985_71044[(1)] = (4));

(statearr_70985_71044[(5)] = null);

} else {
throw ex70978;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (14))){
var state_70933__$1 = state_70933;
var statearr_70986_71045 = state_70933__$1;
(statearr_70986_71045[(2)] = null);

(statearr_70986_71045[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (26))){
var inst_70842 = (state_70933[(8)]);
var inst_70868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70869 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70870 = [inst_70842,inst_70869];
var inst_70871 = (new cljs.core.PersistentVector(null,2,(5),inst_70868,inst_70870,null));
var state_70933__$1 = state_70933;
var statearr_70987_71046 = state_70933__$1;
(statearr_70987_71046[(2)] = inst_70871);

(statearr_70987_71046[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (16))){
var inst_70832 = (state_70933[(2)]);
var inst_70833 = fluree.db.util.async.throw_err(inst_70832);
var state_70933__$1 = state_70933;
var statearr_70988_71047 = state_70933__$1;
(statearr_70988_71047[(2)] = inst_70833);

(statearr_70988_71047[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (38))){
var inst_70889 = (state_70933[(9)]);
var inst_70888 = (state_70933[(10)]);
var inst_70910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70911 = [inst_70889,inst_70888];
var inst_70912 = (new cljs.core.PersistentVector(null,2,(5),inst_70910,inst_70911,null));
var state_70933__$1 = state_70933;
var statearr_70989_71048 = state_70933__$1;
(statearr_70989_71048[(2)] = inst_70912);

(statearr_70989_71048[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (30))){
var state_70933__$1 = state_70933;
var statearr_70990_71049 = state_70933__$1;
(statearr_70990_71049[(2)] = null);

(statearr_70990_71049[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (10))){
var inst_70819 = (state_70933[(18)]);
var state_70933__$1 = state_70933;
var statearr_70991_71050 = state_70933__$1;
(statearr_70991_71050[(2)] = inst_70819);

(statearr_70991_71050[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (18))){
var state_70933__$1 = state_70933;
var statearr_70992_71051 = state_70933__$1;
(statearr_70992_71051[(2)] = null);

(statearr_70992_71051[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (42))){
var inst_70920 = (state_70933[(13)]);
var state_70933__$1 = state_70933;
var statearr_70993_71052 = state_70933__$1;
(statearr_70993_71052[(2)] = inst_70920);

(statearr_70993_71052[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (37))){
var inst_70889 = (state_70933[(9)]);
var inst_70888 = (state_70933[(10)]);
var inst_70907 = (state_70933[(2)]);
var inst_70908 = (inst_70889 < inst_70888);
var state_70933__$1 = (function (){var statearr_70994 = state_70933;
(statearr_70994[(20)] = inst_70907);

return statearr_70994;
})();
if(cljs.core.truth_(inst_70908)){
var statearr_70995_71053 = state_70933__$1;
(statearr_70995_71053[(1)] = (38));

} else {
var statearr_70996_71054 = state_70933__$1;
(statearr_70996_71054[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70934 === (8))){
var inst_70819 = (state_70933[(18)]);
var inst_70819__$1 = (state_70933[(2)]);
var inst_70820 = cljs.core.some(cljs.core.string_QMARK_,inst_70819__$1);
var state_70933__$1 = (function (){var statearr_70997 = state_70933;
(statearr_70997[(18)] = inst_70819__$1);

return statearr_70997;
})();
if(cljs.core.truth_(inst_70820)){
var statearr_70998_71055 = state_70933__$1;
(statearr_70998_71055[(1)] = (9));

} else {
var statearr_70999_71056 = state_70933__$1;
(statearr_70999_71056[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_71000 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71000[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__);

(statearr_71000[(1)] = (1));

return statearr_71000;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_70933){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70933);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71001){var ex__2687__auto__ = e71001;
var statearr_71002_71057 = state_70933;
(statearr_71002_71057[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70933[(4)]))){
var statearr_71003_71058 = state_70933;
(statearr_71003_71058[(1)] = cljs.core.first((state_70933[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71059 = state_70933;
state_70933 = G__71059;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = function(state_70933){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_70933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71004 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71004[(6)] = c__2706__auto__);

return statearr_71004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71211){
var state_val_71212 = (state_71211[(1)]);
if((state_val_71212 === (7))){
var inst_71121 = (state_71211[(2)]);
var inst_71122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71121,(0),null);
var inst_71123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71121,(1),null);
var inst_71131 = cljs.core.vals(inst_71123);
var inst_71132 = cljs.core.seq(inst_71131);
var inst_71133 = cljs.core.first(inst_71132);
var inst_71134 = cljs.core.next(inst_71132);
var inst_71135 = cljs.core.PersistentVector.EMPTY;
var inst_71136 = inst_71131;
var inst_71137 = inst_71135;
var state_71211__$1 = (function (){var statearr_71213 = state_71211;
(statearr_71213[(7)] = inst_71136);

(statearr_71213[(8)] = inst_71137);

(statearr_71213[(9)] = inst_71133);

(statearr_71213[(10)] = inst_71122);

(statearr_71213[(11)] = inst_71134);

return statearr_71213;
})();
var statearr_71214_71267 = state_71211__$1;
(statearr_71214_71267[(2)] = null);

(statearr_71214_71267[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (20))){
var inst_71143 = (state_71211[(12)]);
var inst_71148 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_71149 = cljs.core.PersistentHashMap.EMPTY;
var inst_71150 = [true,inst_71149];
var inst_71151 = cljs.core.PersistentHashMap.fromArrays(inst_71148,inst_71150);
var inst_71152 = cljs.core.PersistentHashMap.EMPTY;
var inst_71153 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_71151,inst_71152,inst_71143);
var state_71211__$1 = state_71211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71211__$1,(22),inst_71153);
} else {
if((state_val_71212 === (27))){
var inst_71199 = (state_71211[(2)]);
var state_71211__$1 = state_71211;
var statearr_71215_71268 = state_71211__$1;
(statearr_71215_71268[(2)] = inst_71199);

(statearr_71215_71268[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (1))){
var state_71211__$1 = state_71211;
var statearr_71216_71269 = state_71211__$1;
(statearr_71216_71269[(2)] = null);

(statearr_71216_71269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (24))){
var inst_71162 = (state_71211[(13)]);
var inst_71201 = (state_71211[(2)]);
var inst_71202 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_71203 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71204 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71205 = [inst_71203,inst_71204,inst_71162,inst_71201];
var inst_71206 = cljs.core.PersistentHashMap.fromArrays(inst_71202,inst_71205);
var _ = (function (){var statearr_71218 = state_71211;
(statearr_71218[(4)] = cljs.core.rest((state_71211[(4)])));

return statearr_71218;
})();
var state_71211__$1 = state_71211;
var statearr_71219_71270 = state_71211__$1;
(statearr_71219_71270[(2)] = inst_71206);

(statearr_71219_71270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (4))){
var inst_71062 = (state_71211[(2)]);
var state_71211__$1 = state_71211;
var statearr_71220_71271 = state_71211__$1;
(statearr_71220_71271[(2)] = inst_71062);

(statearr_71220_71271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (15))){
var inst_71100 = (state_71211[(14)]);
var inst_71084 = (state_71211[(15)]);
var inst_71080 = (state_71211[(16)]);
var inst_71086 = (state_71211[(17)]);
var inst_71102 = (state_71211[(18)]);
var inst_71081 = (state_71211[(19)]);
var inst_71092 = (state_71211[(20)]);
var inst_71107 = (state_71211[(21)]);
var inst_71093 = (state_71211[(22)]);
var inst_71085 = (state_71211[(23)]);
var inst_71078 = (state_71211[(24)]);
var inst_71113 = (function (){var first__71090 = inst_71092;
var vec__71088 = inst_71084;
var seq__71089 = inst_71093;
var subject = inst_71100;
var flake = inst_71092;
var vec__71075 = inst_71078;
var G__71074 = inst_71084;
var r = inst_71093;
var asserted_subjects = inst_71085;
var first__71077 = inst_71080;
var flake_SINGLEQUOTE_ = inst_71107;
var retracted_subjects = inst_71086;
var asserted_QMARK_ = inst_71102;
var seq__71076 = inst_71081;
return (function (p1__71061_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__71061_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_71114 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_71086,inst_71100,inst_71113);
var tmp71217 = inst_71085;
var inst_71084__$1 = inst_71093;
var inst_71085__$1 = tmp71217;
var inst_71086__$1 = inst_71114;
var state_71211__$1 = (function (){var statearr_71221 = state_71211;
(statearr_71221[(15)] = inst_71084__$1);

(statearr_71221[(17)] = inst_71086__$1);

(statearr_71221[(23)] = inst_71085__$1);

return statearr_71221;
})();
var statearr_71222_71272 = state_71211__$1;
(statearr_71222_71272[(2)] = null);

(statearr_71222_71272[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (21))){
var inst_71160 = (state_71211[(2)]);
var state_71211__$1 = state_71211;
var statearr_71223_71273 = state_71211__$1;
(statearr_71223_71273[(2)] = inst_71160);

(statearr_71223_71273[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (13))){
var inst_71102 = (state_71211[(18)]);
var inst_71107 = (state_71211[(2)]);
var state_71211__$1 = (function (){var statearr_71224 = state_71211;
(statearr_71224[(21)] = inst_71107);

return statearr_71224;
})();
if(cljs.core.truth_(inst_71102)){
var statearr_71225_71274 = state_71211__$1;
(statearr_71225_71274[(1)] = (14));

} else {
var statearr_71226_71275 = state_71211__$1;
(statearr_71226_71275[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (22))){
var inst_71144 = (state_71211[(25)]);
var inst_71137 = (state_71211[(8)]);
var inst_71155 = (state_71211[(2)]);
var inst_71156 = fluree.db.util.async.throw_err(inst_71155);
var inst_71157 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_71137,inst_71156);
var inst_71136 = inst_71144;
var inst_71137__$1 = inst_71157;
var state_71211__$1 = (function (){var statearr_71227 = state_71211;
(statearr_71227[(7)] = inst_71136);

(statearr_71227[(8)] = inst_71137__$1);

return statearr_71227;
})();
var statearr_71228_71276 = state_71211__$1;
(statearr_71228_71276[(2)] = null);

(statearr_71228_71276[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (6))){
var inst_71084 = (state_71211[(15)]);
var inst_71092 = (state_71211[(20)]);
var inst_71091 = cljs.core.seq(inst_71084);
var inst_71092__$1 = cljs.core.first(inst_71091);
var inst_71093 = cljs.core.next(inst_71091);
var inst_71094 = cljs.core.not(inst_71092__$1);
var state_71211__$1 = (function (){var statearr_71229 = state_71211;
(statearr_71229[(20)] = inst_71092__$1);

(statearr_71229[(22)] = inst_71093);

return statearr_71229;
})();
if(inst_71094){
var statearr_71230_71277 = state_71211__$1;
(statearr_71230_71277[(1)] = (8));

} else {
var statearr_71231_71278 = state_71211__$1;
(statearr_71231_71278[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (28))){
var inst_71183 = (state_71211[(26)]);
var inst_71176 = (state_71211[(27)]);
var inst_71194 = (state_71211[(2)]);
var inst_71195 = fluree.db.util.async.throw_err(inst_71194);
var inst_71196 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_71176,inst_71195);
var inst_71175 = inst_71183;
var inst_71176__$1 = inst_71196;
var state_71211__$1 = (function (){var statearr_71232 = state_71211;
(statearr_71232[(27)] = inst_71176__$1);

(statearr_71232[(28)] = inst_71175);

return statearr_71232;
})();
var statearr_71233_71279 = state_71211__$1;
(statearr_71233_71279[(2)] = null);

(statearr_71233_71279[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (25))){
var inst_71176 = (state_71211[(27)]);
var state_71211__$1 = state_71211;
var statearr_71234_71280 = state_71211__$1;
(statearr_71234_71280[(2)] = inst_71176);

(statearr_71234_71280[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (17))){
var inst_71143 = (state_71211[(12)]);
var inst_71136 = (state_71211[(7)]);
var inst_71142 = cljs.core.seq(inst_71136);
var inst_71143__$1 = cljs.core.first(inst_71142);
var inst_71144 = cljs.core.next(inst_71142);
var inst_71145 = cljs.core.not(inst_71143__$1);
var state_71211__$1 = (function (){var statearr_71235 = state_71211;
(statearr_71235[(12)] = inst_71143__$1);

(statearr_71235[(25)] = inst_71144);

return statearr_71235;
})();
if(inst_71145){
var statearr_71236_71281 = state_71211__$1;
(statearr_71236_71281[(1)] = (19));

} else {
var statearr_71237_71282 = state_71211__$1;
(statearr_71237_71282[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (3))){
var inst_71209 = (state_71211[(2)]);
var state_71211__$1 = state_71211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71211__$1,inst_71209);
} else {
if((state_val_71212 === (12))){
var inst_71092 = (state_71211[(20)]);
var inst_71105 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_71092);
var state_71211__$1 = state_71211;
var statearr_71238_71283 = state_71211__$1;
(statearr_71238_71283[(2)] = inst_71105);

(statearr_71238_71283[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (2))){
var inst_71078 = (state_71211[(24)]);
var _ = (function (){var statearr_71239 = state_71211;
(statearr_71239[(4)] = cljs.core.cons((5),(state_71211[(4)])));

return statearr_71239;
})();
var inst_71078__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71079 = cljs.core.seq(inst_71078__$1);
var inst_71080 = cljs.core.first(inst_71079);
var inst_71081 = cljs.core.next(inst_71079);
var inst_71082 = cljs.core.PersistentHashMap.EMPTY;
var inst_71083 = cljs.core.PersistentHashMap.EMPTY;
var inst_71084 = inst_71078__$1;
var inst_71085 = inst_71082;
var inst_71086 = inst_71083;
var state_71211__$1 = (function (){var statearr_71240 = state_71211;
(statearr_71240[(15)] = inst_71084);

(statearr_71240[(16)] = inst_71080);

(statearr_71240[(17)] = inst_71086);

(statearr_71240[(19)] = inst_71081);

(statearr_71240[(23)] = inst_71085);

(statearr_71240[(24)] = inst_71078__$1);

return statearr_71240;
})();
var statearr_71241_71284 = state_71211__$1;
(statearr_71241_71284[(2)] = null);

(statearr_71241_71284[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (23))){
var inst_71175 = (state_71211[(28)]);
var inst_71182 = (state_71211[(29)]);
var inst_71181 = cljs.core.seq(inst_71175);
var inst_71182__$1 = cljs.core.first(inst_71181);
var inst_71183 = cljs.core.next(inst_71181);
var inst_71184 = cljs.core.not(inst_71182__$1);
var state_71211__$1 = (function (){var statearr_71242 = state_71211;
(statearr_71242[(26)] = inst_71183);

(statearr_71242[(29)] = inst_71182__$1);

return statearr_71242;
})();
if(inst_71184){
var statearr_71243_71285 = state_71211__$1;
(statearr_71243_71285[(1)] = (25));

} else {
var statearr_71244_71286 = state_71211__$1;
(statearr_71244_71286[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (19))){
var inst_71137 = (state_71211[(8)]);
var state_71211__$1 = state_71211;
var statearr_71245_71287 = state_71211__$1;
(statearr_71245_71287[(2)] = inst_71137);

(statearr_71245_71287[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (11))){
var inst_71092 = (state_71211[(20)]);
var state_71211__$1 = state_71211;
var statearr_71247_71288 = state_71211__$1;
(statearr_71247_71288[(2)] = inst_71092);

(statearr_71247_71288[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (9))){
var inst_71102 = (state_71211[(18)]);
var inst_71092 = (state_71211[(20)]);
var inst_71100 = fluree.db.flake.s(inst_71092);
var inst_71101 = fluree.db.flake.op(inst_71092);
var inst_71102__$1 = inst_71101 === true;
var state_71211__$1 = (function (){var statearr_71249 = state_71211;
(statearr_71249[(14)] = inst_71100);

(statearr_71249[(18)] = inst_71102__$1);

return statearr_71249;
})();
if(cljs.core.truth_(inst_71102__$1)){
var statearr_71250_71289 = state_71211__$1;
(statearr_71250_71289[(1)] = (11));

} else {
var statearr_71251_71290 = state_71211__$1;
(statearr_71251_71290[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (5))){
var _ = (function (){var statearr_71252 = state_71211;
(statearr_71252[(4)] = cljs.core.rest((state_71211[(4)])));

return statearr_71252;
})();
var state_71211__$1 = state_71211;
var ex71246 = (state_71211__$1[(2)]);
var statearr_71253_71291 = state_71211__$1;
(statearr_71253_71291[(5)] = ex71246);


if((ex71246 instanceof Error)){
var statearr_71254_71292 = state_71211__$1;
(statearr_71254_71292[(1)] = (4));

(statearr_71254_71292[(5)] = null);

} else {
throw ex71246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (14))){
var inst_71100 = (state_71211[(14)]);
var inst_71084 = (state_71211[(15)]);
var inst_71080 = (state_71211[(16)]);
var inst_71086 = (state_71211[(17)]);
var inst_71102 = (state_71211[(18)]);
var inst_71081 = (state_71211[(19)]);
var inst_71092 = (state_71211[(20)]);
var inst_71107 = (state_71211[(21)]);
var inst_71093 = (state_71211[(22)]);
var inst_71085 = (state_71211[(23)]);
var inst_71078 = (state_71211[(24)]);
var inst_71109 = (function (){var first__71090 = inst_71092;
var vec__71088 = inst_71084;
var seq__71089 = inst_71093;
var subject = inst_71100;
var flake = inst_71092;
var vec__71075 = inst_71078;
var G__71074 = inst_71084;
var r = inst_71093;
var asserted_subjects = inst_71085;
var first__71077 = inst_71080;
var flake_SINGLEQUOTE_ = inst_71107;
var retracted_subjects = inst_71086;
var asserted_QMARK_ = inst_71102;
var seq__71076 = inst_71081;
return (function (p1__71060_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__71060_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_71110 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_71085,inst_71100,inst_71109);
var tmp71248 = inst_71086;
var inst_71084__$1 = inst_71093;
var inst_71085__$1 = inst_71110;
var inst_71086__$1 = tmp71248;
var state_71211__$1 = (function (){var statearr_71255 = state_71211;
(statearr_71255[(15)] = inst_71084__$1);

(statearr_71255[(17)] = inst_71086__$1);

(statearr_71255[(23)] = inst_71085__$1);

return statearr_71255;
})();
var statearr_71256_71293 = state_71211__$1;
(statearr_71256_71293[(2)] = null);

(statearr_71256_71293[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (26))){
var inst_71182 = (state_71211[(29)]);
var inst_71187 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_71188 = cljs.core.PersistentHashMap.EMPTY;
var inst_71189 = [true,inst_71188];
var inst_71190 = cljs.core.PersistentHashMap.fromArrays(inst_71187,inst_71189);
var inst_71191 = cljs.core.PersistentHashMap.EMPTY;
var inst_71192 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_71190,inst_71191,inst_71182);
var state_71211__$1 = state_71211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71211__$1,(28),inst_71192);
} else {
if((state_val_71212 === (16))){
var inst_71117 = (state_71211[(2)]);
var state_71211__$1 = state_71211;
var statearr_71257_71294 = state_71211__$1;
(statearr_71257_71294[(2)] = inst_71117);

(statearr_71257_71294[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (10))){
var inst_71119 = (state_71211[(2)]);
var state_71211__$1 = state_71211;
var statearr_71258_71295 = state_71211__$1;
(statearr_71258_71295[(2)] = inst_71119);

(statearr_71258_71295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (18))){
var inst_71122 = (state_71211[(10)]);
var inst_71162 = (state_71211[(2)]);
var inst_71170 = cljs.core.vals(inst_71122);
var inst_71171 = cljs.core.seq(inst_71170);
var inst_71172 = cljs.core.first(inst_71171);
var inst_71173 = cljs.core.next(inst_71171);
var inst_71174 = cljs.core.PersistentVector.EMPTY;
var inst_71175 = inst_71170;
var inst_71176 = inst_71174;
var state_71211__$1 = (function (){var statearr_71259 = state_71211;
(statearr_71259[(27)] = inst_71176);

(statearr_71259[(28)] = inst_71175);

(statearr_71259[(30)] = inst_71172);

(statearr_71259[(13)] = inst_71162);

(statearr_71259[(31)] = inst_71173);

return statearr_71259;
})();
var statearr_71260_71296 = state_71211__$1;
(statearr_71260_71296[(2)] = null);

(statearr_71260_71296[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71212 === (8))){
var inst_71086 = (state_71211[(17)]);
var inst_71085 = (state_71211[(23)]);
var inst_71096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71097 = [inst_71085,inst_71086];
var inst_71098 = (new cljs.core.PersistentVector(null,2,(5),inst_71096,inst_71097,null));
var state_71211__$1 = state_71211;
var statearr_71261_71297 = state_71211__$1;
(statearr_71261_71297[(2)] = inst_71098);

(statearr_71261_71297[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_71262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71262[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_71262[(1)] = (1));

return statearr_71262;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_71211){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71211);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71263){var ex__2687__auto__ = e71263;
var statearr_71264_71298 = state_71211;
(statearr_71264_71298[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71211[(4)]))){
var statearr_71265_71299 = state_71211;
(statearr_71265_71299[(1)] = cljs.core.first((state_71211[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71300 = state_71211;
state_71211 = G__71300;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_71211){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_71211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71266 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71266[(6)] = c__2706__auto__);

return statearr_71266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71332){
var state_val_71333 = (state_71332[(1)]);
if((state_val_71333 === (1))){
var inst_71301 = cljs.core.volatile_BANG_((0));
var inst_71302 = cljs.core.PersistentHashMap.EMPTY;
var inst_71303 = cljs.core.volatile_BANG_(inst_71302);
var inst_71304 = cljs.core.first(resp);
var inst_71305 = cljs.core.rest(resp);
var inst_71306 = cljs.core.PersistentVector.EMPTY;
var inst_71307 = inst_71301;
var inst_71308 = inst_71303;
var inst_71309 = inst_71304;
var inst_71310 = inst_71305;
var inst_71311 = inst_71306;
var state_71332__$1 = (function (){var statearr_71334 = state_71332;
(statearr_71334[(7)] = inst_71311);

(statearr_71334[(8)] = inst_71307);

(statearr_71334[(9)] = inst_71310);

(statearr_71334[(10)] = inst_71309);

(statearr_71334[(11)] = inst_71308);

return statearr_71334;
})();
var statearr_71335_71350 = state_71332__$1;
(statearr_71335_71350[(2)] = null);

(statearr_71335_71350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71333 === (2))){
var inst_71307 = (state_71332[(8)]);
var inst_71309 = (state_71332[(10)]);
var inst_71308 = (state_71332[(11)]);
var inst_71313 = fluree.db.api.query.format_block_resp_pretty(db,inst_71309,inst_71308,inst_71307);
var state_71332__$1 = state_71332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71332__$1,(4),inst_71313);
} else {
if((state_val_71333 === (3))){
var inst_71330 = (state_71332[(2)]);
var state_71332__$1 = state_71332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71332__$1,inst_71330);
} else {
if((state_val_71333 === (4))){
var inst_71311 = (state_71332[(7)]);
var inst_71310 = (state_71332[(9)]);
var inst_71315 = (state_71332[(2)]);
var inst_71316 = fluree.db.util.async.throw_err(inst_71315);
var inst_71317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71318 = [inst_71316];
var inst_71319 = (new cljs.core.PersistentVector(null,1,(5),inst_71317,inst_71318,null));
var inst_71320 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_71311,inst_71319);
var inst_71321 = cljs.core.first(inst_71310);
var state_71332__$1 = (function (){var statearr_71338 = state_71332;
(statearr_71338[(12)] = inst_71320);

return statearr_71338;
})();
if(cljs.core.truth_(inst_71321)){
var statearr_71339_71351 = state_71332__$1;
(statearr_71339_71351[(1)] = (5));

} else {
var statearr_71340_71352 = state_71332__$1;
(statearr_71340_71352[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71333 === (5))){
var inst_71320 = (state_71332[(12)]);
var inst_71307 = (state_71332[(8)]);
var inst_71310 = (state_71332[(9)]);
var inst_71308 = (state_71332[(11)]);
var inst_71323 = cljs.core.first(inst_71310);
var inst_71324 = cljs.core.rest(inst_71310);
var tmp71336 = inst_71307;
var tmp71337 = inst_71308;
var inst_71307__$1 = tmp71336;
var inst_71308__$1 = tmp71337;
var inst_71309 = inst_71323;
var inst_71310__$1 = inst_71324;
var inst_71311 = inst_71320;
var state_71332__$1 = (function (){var statearr_71341 = state_71332;
(statearr_71341[(7)] = inst_71311);

(statearr_71341[(8)] = inst_71307__$1);

(statearr_71341[(9)] = inst_71310__$1);

(statearr_71341[(10)] = inst_71309);

(statearr_71341[(11)] = inst_71308__$1);

return statearr_71341;
})();
var statearr_71342_71353 = state_71332__$1;
(statearr_71342_71353[(2)] = null);

(statearr_71342_71353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71333 === (6))){
var inst_71320 = (state_71332[(12)]);
var state_71332__$1 = state_71332;
var statearr_71343_71354 = state_71332__$1;
(statearr_71343_71354[(2)] = inst_71320);

(statearr_71343_71354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71333 === (7))){
var inst_71328 = (state_71332[(2)]);
var state_71332__$1 = state_71332;
var statearr_71344_71355 = state_71332__$1;
(statearr_71344_71355[(2)] = inst_71328);

(statearr_71344_71355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_71345 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71345[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__);

(statearr_71345[(1)] = (1));

return statearr_71345;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1 = (function (state_71332){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71332);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71346){var ex__2687__auto__ = e71346;
var statearr_71347_71356 = state_71332;
(statearr_71347_71356[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71332[(4)]))){
var statearr_71348_71357 = state_71332;
(statearr_71348_71357[(1)] = cljs.core.first((state_71332[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71358 = state_71332;
state_71332 = G__71358;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = function(state_71332){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1.call(this,state_71332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71349 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71349[(6)] = c__2706__auto__);

return statearr_71349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__71360 = arguments.length;
switch (G__71360) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__71362){
var map__71363 = p__71362;
var map__71363__$1 = cljs.core.__destructure_map(map__71363);
var query = map__71363__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71363__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71448){
var state_val_71449 = (state_71448[(1)]);
if((state_val_71449 === (7))){
var inst_71374 = (state_71448[(7)]);
var inst_71378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71379 = ["_auth/id",inst_71374];
var inst_71380 = (new cljs.core.PersistentVector(null,2,(5),inst_71378,inst_71379,null));
var state_71448__$1 = state_71448;
var statearr_71450_71494 = state_71448__$1;
(statearr_71450_71494[(2)] = inst_71380);

(statearr_71450_71494[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (20))){
var inst_71428 = (state_71448[(2)]);
var inst_71429 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_71448__$1 = (function (){var statearr_71451 = state_71448;
(statearr_71451[(8)] = inst_71428);

return statearr_71451;
})();
if(cljs.core.truth_(inst_71429)){
var statearr_71452_71495 = state_71448__$1;
(statearr_71452_71495[(1)] = (22));

} else {
var statearr_71453_71496 = state_71448__$1;
(statearr_71453_71496[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (27))){
var inst_71375 = (state_71448[(9)]);
var inst_71431 = (state_71448[(10)]);
var inst_71437 = (state_71448[(2)]);
var inst_71438 = fluree.db.util.core.response_time_formatted(inst_71375);
var inst_71439 = [(200),inst_71437,(100),inst_71438];
var inst_71440 = cljs.core.PersistentHashMap.fromArrays(inst_71431,inst_71439);
var state_71448__$1 = state_71448;
var statearr_71454_71497 = state_71448__$1;
(statearr_71454_71497[(2)] = inst_71440);

(statearr_71454_71497[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (1))){
var state_71448__$1 = state_71448;
var statearr_71455_71498 = state_71448__$1;
(statearr_71455_71498[(2)] = null);

(statearr_71455_71498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (24))){
var inst_71443 = (state_71448[(2)]);
var _ = (function (){var statearr_71456 = state_71448;
(statearr_71456[(4)] = cljs.core.rest((state_71448[(4)])));

return statearr_71456;
})();
var state_71448__$1 = state_71448;
var statearr_71457_71499 = state_71448__$1;
(statearr_71457_71499[(2)] = inst_71443);

(statearr_71457_71499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (4))){
var inst_71364 = (state_71448[(2)]);
var state_71448__$1 = state_71448;
var statearr_71458_71500 = state_71448__$1;
(statearr_71458_71500[(2)] = inst_71364);

(statearr_71458_71500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (15))){
var inst_71415 = (state_71448[(11)]);
var state_71448__$1 = state_71448;
var statearr_71459_71501 = state_71448__$1;
(statearr_71459_71501[(2)] = inst_71415);

(statearr_71459_71501[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (21))){
var inst_71424 = (state_71448[(2)]);
var inst_71425 = fluree.db.util.async.throw_err(inst_71424);
var state_71448__$1 = state_71448;
var statearr_71460_71502 = state_71448__$1;
(statearr_71460_71502[(2)] = inst_71425);

(statearr_71460_71502[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (13))){
var inst_71415 = (state_71448[(11)]);
var inst_71373 = (state_71448[(12)]);
var inst_71414 = (state_71448[(2)]);
var inst_71415__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_71373);
var state_71448__$1 = (function (){var statearr_71461 = state_71448;
(statearr_71461[(11)] = inst_71415__$1);

(statearr_71461[(13)] = inst_71414);

return statearr_71461;
})();
if(cljs.core.truth_(inst_71415__$1)){
var statearr_71462_71503 = state_71448__$1;
(statearr_71462_71503[(1)] = (15));

} else {
var statearr_71463_71504 = state_71448__$1;
(statearr_71463_71504[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (22))){
var inst_71428 = (state_71448[(8)]);
var inst_71431 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71432 = cljs.core.sequential_QMARK_(inst_71428);
var state_71448__$1 = (function (){var statearr_71464 = state_71448;
(statearr_71464[(10)] = inst_71431);

return statearr_71464;
})();
if(inst_71432){
var statearr_71465_71505 = state_71448__$1;
(statearr_71465_71505[(1)] = (25));

} else {
var statearr_71466_71506 = state_71448__$1;
(statearr_71466_71506[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (6))){
var inst_71389 = (state_71448[(14)]);
var inst_71373 = (state_71448[(12)]);
var inst_71388 = (state_71448[(2)]);
var inst_71389__$1 = fluree.db.util.async.throw_err(inst_71388);
var inst_71390 = fluree.db.api.query.resolve_block_range(inst_71389__$1,inst_71373);
var state_71448__$1 = (function (){var statearr_71467 = state_71448;
(statearr_71467[(14)] = inst_71389__$1);

return statearr_71467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71448__$1,(10),inst_71390);
} else {
if((state_val_71449 === (25))){
var inst_71428 = (state_71448[(8)]);
var inst_71434 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_71428);
var state_71448__$1 = state_71448;
var statearr_71468_71507 = state_71448__$1;
(statearr_71468_71507[(2)] = inst_71434);

(statearr_71468_71507[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (17))){
var inst_71420 = (state_71448[(2)]);
var state_71448__$1 = state_71448;
if(cljs.core.truth_(inst_71420)){
var statearr_71469_71508 = state_71448__$1;
(statearr_71469_71508[(1)] = (18));

} else {
var statearr_71470_71509 = state_71448__$1;
(statearr_71470_71509[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (3))){
var inst_71446 = (state_71448[(2)]);
var state_71448__$1 = state_71448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71448__$1,inst_71446);
} else {
if((state_val_71449 === (12))){
var inst_71373 = (state_71448[(12)]);
var inst_71406 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_71373], 0));
var inst_71407 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_71406].join('');
var inst_71408 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71409 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71410 = cljs.core.PersistentHashMap.fromArrays(inst_71408,inst_71409);
var inst_71411 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71407,inst_71410);
var inst_71412 = (function(){throw inst_71411})();
var state_71448__$1 = state_71448;
var statearr_71471_71510 = state_71448__$1;
(statearr_71471_71510[(2)] = inst_71412);

(statearr_71471_71510[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (2))){
var inst_71374 = (state_71448[(7)]);
var _ = (function (){var statearr_71472 = state_71448;
(statearr_71472[(4)] = cljs.core.cons((5),(state_71448[(4)])));

return statearr_71472;
})();
var inst_71373 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71374__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71375 = fluree.db.util.core.current_time_millis();
var inst_71376 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_71448__$1 = (function (){var statearr_71473 = state_71448;
(statearr_71473[(15)] = inst_71376);

(statearr_71473[(7)] = inst_71374__$1);

(statearr_71473[(9)] = inst_71375);

(statearr_71473[(12)] = inst_71373);

return statearr_71473;
})();
if(cljs.core.truth_(inst_71374__$1)){
var statearr_71474_71511 = state_71448__$1;
(statearr_71474_71511[(1)] = (7));

} else {
var statearr_71475_71512 = state_71448__$1;
(statearr_71475_71512[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (23))){
var inst_71428 = (state_71448[(8)]);
var state_71448__$1 = state_71448;
var statearr_71476_71513 = state_71448__$1;
(statearr_71476_71513[(2)] = inst_71428);

(statearr_71476_71513[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (19))){
var inst_71414 = (state_71448[(13)]);
var state_71448__$1 = state_71448;
var statearr_71477_71514 = state_71448__$1;
(statearr_71477_71514[(2)] = inst_71414);

(statearr_71477_71514[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (11))){
var inst_71389 = (state_71448[(14)]);
var inst_71395 = (state_71448[(16)]);
var inst_71394 = (state_71448[(17)]);
var inst_71401 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_71389,inst_71394,inst_71395,opts);
var state_71448__$1 = state_71448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71448__$1,(14),inst_71401);
} else {
if((state_val_71449 === (9))){
var inst_71376 = (state_71448[(15)]);
var inst_71383 = (state_71448[(2)]);
var inst_71384 = [inst_71383];
var inst_71385 = cljs.core.PersistentHashMap.fromArrays(inst_71376,inst_71384);
var inst_71386 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_71385);
var state_71448__$1 = state_71448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71448__$1,(6),inst_71386);
} else {
if((state_val_71449 === (5))){
var _ = (function (){var statearr_71479 = state_71448;
(statearr_71479[(4)] = cljs.core.rest((state_71448[(4)])));

return statearr_71479;
})();
var state_71448__$1 = state_71448;
var ex71478 = (state_71448__$1[(2)]);
var statearr_71480_71515 = state_71448__$1;
(statearr_71480_71515[(5)] = ex71478);


if((ex71478 instanceof Error)){
var statearr_71481_71516 = state_71448__$1;
(statearr_71481_71516[(1)] = (4));

(statearr_71481_71516[(5)] = null);

} else {
throw ex71478;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (14))){
var inst_71403 = (state_71448[(2)]);
var inst_71404 = fluree.db.util.async.throw_err(inst_71403);
var state_71448__$1 = state_71448;
var statearr_71482_71517 = state_71448__$1;
(statearr_71482_71517[(2)] = inst_71404);

(statearr_71482_71517[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (26))){
var inst_71428 = (state_71448[(8)]);
var state_71448__$1 = state_71448;
var statearr_71483_71518 = state_71448__$1;
(statearr_71483_71518[(2)] = inst_71428);

(statearr_71483_71518[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (16))){
var inst_71373 = (state_71448[(12)]);
var inst_71418 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_71373);
var state_71448__$1 = state_71448;
var statearr_71484_71519 = state_71448__$1;
(statearr_71484_71519[(2)] = inst_71418);

(statearr_71484_71519[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (10))){
var inst_71373 = (state_71448[(12)]);
var inst_71392 = (state_71448[(2)]);
var inst_71393 = fluree.db.util.async.throw_err(inst_71392);
var inst_71394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71393,(0),null);
var inst_71395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71393,(1),null);
var inst_71396 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_71397 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_71373,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_71398 = cljs.core.keys(inst_71397);
var inst_71399 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71396,inst_71398);
var state_71448__$1 = (function (){var statearr_71485 = state_71448;
(statearr_71485[(16)] = inst_71395);

(statearr_71485[(17)] = inst_71394);

return statearr_71485;
})();
if(inst_71399){
var statearr_71486_71520 = state_71448__$1;
(statearr_71486_71520[(1)] = (11));

} else {
var statearr_71487_71521 = state_71448__$1;
(statearr_71487_71521[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71449 === (18))){
var inst_71389 = (state_71448[(14)]);
var inst_71414 = (state_71448[(13)]);
var inst_71422 = fluree.db.api.query.format_blocks_resp_pretty(inst_71389,inst_71414);
var state_71448__$1 = state_71448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71448__$1,(21),inst_71422);
} else {
if((state_val_71449 === (8))){
var state_71448__$1 = state_71448;
var statearr_71488_71522 = state_71448__$1;
(statearr_71488_71522[(2)] = null);

(statearr_71488_71522[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_71489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71489[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2684__auto__);

(statearr_71489[(1)] = (1));

return statearr_71489;
});
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1 = (function (state_71448){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71448);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71490){var ex__2687__auto__ = e71490;
var statearr_71491_71523 = state_71448;
(statearr_71491_71523[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71448[(4)]))){
var statearr_71492_71524 = state_71448;
(statearr_71492_71524[(1)] = cljs.core.first((state_71448[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71525 = state_71448;
state_71448 = G__71525;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = function(state_71448){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1.call(this,state_71448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71493 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71493[(6)] = c__2706__auto__);

return statearr_71493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__71526 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71526,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71526,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71526,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71526,(3),null);
var vec__71529 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71529,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71529,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__71532 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t(flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71532,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71532,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___71536 = arguments.length;
var i__5770__auto___71537 = (0);
while(true){
if((i__5770__auto___71537 < len__5769__auto___71536)){
args__5775__auto__.push((arguments[i__5770__auto___71537]));

var G__71538 = (i__5770__auto___71537 + (1));
i__5770__auto___71537 = G__71538;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq71535){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq71535));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71734){
var state_val_71735 = (state_71734[(1)]);
if((state_val_71735 === (7))){
var inst_71654 = (state_71734[(7)]);
var inst_71661 = (state_71734[(8)]);
var inst_71660 = cljs.core.seq(inst_71654);
var inst_71661__$1 = cljs.core.first(inst_71660);
var inst_71662 = cljs.core.next(inst_71660);
var state_71734__$1 = (function (){var statearr_71736 = state_71734;
(statearr_71736[(9)] = inst_71662);

(statearr_71736[(8)] = inst_71661__$1);

return statearr_71736;
})();
if(cljs.core.truth_(inst_71661__$1)){
var statearr_71737_71837 = state_71734__$1;
(statearr_71737_71837[(1)] = (9));

} else {
var statearr_71738_71838 = state_71734__$1;
(statearr_71738_71838[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (20))){
var inst_71724 = (state_71734[(2)]);
var state_71734__$1 = state_71734;
var statearr_71739_71839 = state_71734__$1;
(statearr_71739_71839[(2)] = inst_71724);

(statearr_71739_71839[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (27))){
var inst_71700 = (state_71734[(10)]);
var inst_71679 = (state_71734[(11)]);
var inst_71682 = (state_71734[(12)]);
var inst_71702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71703 = [inst_71682,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_71704 = (new cljs.core.PersistentVector(null,2,(5),inst_71702,inst_71703,null));
var inst_71705 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_71700,inst_71704,fluree.db.api.query.min_safe,inst_71679);
var state_71734__$1 = state_71734;
var statearr_71740_71840 = state_71734__$1;
(statearr_71740_71840[(2)] = inst_71705);

(statearr_71740_71840[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (1))){
var state_71734__$1 = state_71734;
var statearr_71741_71841 = state_71734__$1;
(statearr_71741_71841[(2)] = null);

(statearr_71741_71841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (24))){
var inst_71692 = (state_71734[(13)]);
var inst_71661 = (state_71734[(8)]);
var inst_71682 = (state_71734[(12)]);
var inst_71694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71695 = [inst_71682,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_71696 = (new cljs.core.PersistentVector(null,2,(5),inst_71694,inst_71695,null));
var inst_71697 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_71692,inst_71696,cljs.core.conj,inst_71661);
var state_71734__$1 = state_71734;
var statearr_71743_71842 = state_71734__$1;
(statearr_71743_71842[(2)] = inst_71697);

(statearr_71743_71842[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (4))){
var inst_71540 = (state_71734[(2)]);
var state_71734__$1 = state_71734;
var statearr_71744_71843 = state_71734__$1;
(statearr_71744_71843[(2)] = inst_71540);

(statearr_71744_71843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (15))){
var inst_71662 = (state_71734[(9)]);
var inst_71655 = (state_71734[(14)]);
var tmp71742 = inst_71655;
var inst_71654 = inst_71662;
var inst_71655__$1 = tmp71742;
var state_71734__$1 = (function (){var statearr_71745 = state_71734;
(statearr_71745[(14)] = inst_71655__$1);

(statearr_71745[(7)] = inst_71654);

return statearr_71745;
})();
var statearr_71746_71844 = state_71734__$1;
(statearr_71746_71844[(2)] = null);

(statearr_71746_71844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (21))){
var inst_71655 = (state_71734[(14)]);
var inst_71682 = (state_71734[(12)]);
var inst_71686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71687 = [inst_71682,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71688 = (new cljs.core.PersistentVector(null,2,(5),inst_71686,inst_71687,null));
var inst_71689 = cljs.core.assoc_in(inst_71655,inst_71688,inst_71682);
var state_71734__$1 = state_71734;
var statearr_71747_71845 = state_71734__$1;
(statearr_71747_71845[(2)] = inst_71689);

(statearr_71747_71845[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (31))){
var inst_71708 = (state_71734[(15)]);
var state_71734__$1 = state_71734;
var statearr_71748_71846 = state_71734__$1;
(statearr_71748_71846[(2)] = inst_71708);

(statearr_71748_71846[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (32))){
var inst_71662 = (state_71734[(9)]);
var inst_71716 = (state_71734[(2)]);
var inst_71654 = inst_71662;
var inst_71655 = inst_71716;
var state_71734__$1 = (function (){var statearr_71749 = state_71734;
(statearr_71749[(14)] = inst_71655);

(statearr_71749[(7)] = inst_71654);

return statearr_71749;
})();
var statearr_71750_71847 = state_71734__$1;
(statearr_71750_71847[(2)] = null);

(statearr_71750_71847[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (33))){
var inst_71655 = (state_71734[(14)]);
var state_71734__$1 = state_71734;
var statearr_71751_71848 = state_71734__$1;
(statearr_71751_71848[(2)] = inst_71655);

(statearr_71751_71848[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (13))){
var inst_71664 = (state_71734[(16)]);
var state_71734__$1 = state_71734;
var statearr_71752_71849 = state_71734__$1;
(statearr_71752_71849[(2)] = inst_71664);

(statearr_71752_71849[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (22))){
var inst_71655 = (state_71734[(14)]);
var state_71734__$1 = state_71734;
var statearr_71753_71850 = state_71734__$1;
(statearr_71753_71850[(2)] = inst_71655);

(statearr_71753_71850[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (29))){
var inst_71708 = (state_71734[(2)]);
var state_71734__$1 = (function (){var statearr_71754 = state_71734;
(statearr_71754[(15)] = inst_71708);

return statearr_71754;
})();
if(cljs.core.truth_(show_auth)){
var statearr_71755_71851 = state_71734__$1;
(statearr_71755_71851[(1)] = (30));

} else {
var statearr_71756_71852 = state_71734__$1;
(statearr_71756_71852[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (6))){
var inst_71640 = (state_71734[(2)]);
var inst_71641 = fluree.db.util.async.throw_err(inst_71640);
var inst_71649 = resp;
var inst_71650 = cljs.core.seq(inst_71649);
var inst_71651 = cljs.core.first(inst_71650);
var inst_71652 = cljs.core.next(inst_71650);
var inst_71653 = cljs.core.PersistentHashMap.EMPTY;
var inst_71654 = inst_71649;
var inst_71655 = inst_71653;
var state_71734__$1 = (function (){var statearr_71757 = state_71734;
(statearr_71757[(17)] = inst_71652);

(statearr_71757[(18)] = inst_71641);

(statearr_71757[(19)] = inst_71651);

(statearr_71757[(14)] = inst_71655);

(statearr_71757[(7)] = inst_71654);

return statearr_71757;
})();
var statearr_71758_71853 = state_71734__$1;
(statearr_71758_71853[(2)] = null);

(statearr_71758_71853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (28))){
var inst_71700 = (state_71734[(10)]);
var state_71734__$1 = state_71734;
var statearr_71759_71854 = state_71734__$1;
(statearr_71759_71854[(2)] = inst_71700);

(statearr_71759_71854[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (25))){
var inst_71692 = (state_71734[(13)]);
var state_71734__$1 = state_71734;
var statearr_71760_71855 = state_71734__$1;
(statearr_71760_71855[(2)] = inst_71692);

(statearr_71760_71855[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (34))){
var state_71734__$1 = state_71734;
var statearr_71761_71856 = state_71734__$1;
(statearr_71761_71856[(2)] = null);

(statearr_71761_71856[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (17))){
var inst_71726 = (state_71734[(2)]);
var state_71734__$1 = state_71734;
var statearr_71762_71857 = state_71734__$1;
(statearr_71762_71857[(2)] = inst_71726);

(statearr_71762_71857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (3))){
var inst_71732 = (state_71734[(2)]);
var state_71734__$1 = state_71734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71734__$1,inst_71732);
} else {
if((state_val_71735 === (12))){
var inst_71641 = (state_71734[(18)]);
var inst_71661 = (state_71734[(8)]);
var inst_71666 = fluree.db.api.query.auth_match(auth,inst_71641,inst_71661);
var inst_71667 = cljs.core.not(inst_71666);
var state_71734__$1 = state_71734;
var statearr_71763_71858 = state_71734__$1;
(statearr_71763_71858[(2)] = inst_71667);

(statearr_71763_71858[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (2))){
var _ = (function (){var statearr_71764 = state_71734;
(statearr_71764[(4)] = cljs.core.cons((5),(state_71734[(4)])));

return statearr_71764;
})();
var inst_71546 = (function (){return (function (p1__71539_SHARP_){
return fluree.db.flake.t(p1__71539_SHARP_);
});
})();
var inst_71547 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_71546,resp);
var inst_71548 = cljs.core.set(inst_71547);
var inst_71636 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_71637 = (function (){var ts = inst_71548;
var c__2706__auto____$1 = inst_71636;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71634){
var state_val_71635 = (state_71634[(1)]);
if((state_val_71635 === (7))){
var inst_71568 = (state_71634[(7)]);
var inst_71580 = (state_71634[(8)]);
var inst_71574 = (state_71634[(9)]);
var inst_71562 = (state_71634[(10)]);
var inst_71573 = (state_71634[(2)]);
var inst_71574__$1 = fluree.db.util.async.throw_err(inst_71573);
var inst_71576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71577 = [inst_71568,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71578 = (new cljs.core.PersistentVector(null,2,(5),inst_71576,inst_71577,null));
var inst_71579 = cljs.core.assoc_in(inst_71562,inst_71578,inst_71574__$1);
var inst_71580__$1 = auth;
var state_71634__$1 = (function (){var statearr_71765 = state_71634;
(statearr_71765[(8)] = inst_71580__$1);

(statearr_71765[(9)] = inst_71574__$1);

(statearr_71765[(11)] = inst_71579);

return statearr_71765;
})();
if(cljs.core.truth_(inst_71580__$1)){
var statearr_71766_71859 = state_71634__$1;
(statearr_71766_71859[(1)] = (8));

} else {
var statearr_71767_71860 = state_71634__$1;
(statearr_71767_71860[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (1))){
var inst_71556 = (state_71634[(12)]);
var inst_71556__$1 = ts;
var inst_71557 = cljs.core.seq(inst_71556__$1);
var inst_71558 = cljs.core.first(inst_71557);
var inst_71559 = cljs.core.next(inst_71557);
var inst_71560 = cljs.core.PersistentHashMap.EMPTY;
var inst_71561 = inst_71556__$1;
var inst_71562 = inst_71560;
var state_71634__$1 = (function (){var statearr_71768 = state_71634;
(statearr_71768[(13)] = inst_71559);

(statearr_71768[(14)] = inst_71561);

(statearr_71768[(15)] = inst_71558);

(statearr_71768[(10)] = inst_71562);

(statearr_71768[(12)] = inst_71556__$1);

return statearr_71768;
})();
var statearr_71769_71861 = state_71634__$1;
(statearr_71769_71861[(2)] = null);

(statearr_71769_71861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (4))){
var inst_71568 = (state_71634[(7)]);
var inst_71571 = fluree.db.time_travel.non_border_t_to_block(db,inst_71568);
var state_71634__$1 = state_71634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71634__$1,(7),inst_71571);
} else {
if((state_val_71635 === (13))){
var inst_71569 = (state_71634[(16)]);
var inst_71626 = (state_71634[(2)]);
var inst_71561 = inst_71569;
var inst_71562 = inst_71626;
var state_71634__$1 = (function (){var statearr_71770 = state_71634;
(statearr_71770[(14)] = inst_71561);

(statearr_71770[(10)] = inst_71562);

return statearr_71770;
})();
var statearr_71771_71862 = state_71634__$1;
(statearr_71771_71862[(2)] = null);

(statearr_71771_71862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (6))){
var inst_71630 = (state_71634[(2)]);
var state_71634__$1 = state_71634;
var statearr_71772_71863 = state_71634__$1;
(statearr_71772_71863[(2)] = inst_71630);

(statearr_71772_71863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (3))){
var inst_71632 = (state_71634[(2)]);
var state_71634__$1 = state_71634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71634__$1,inst_71632);
} else {
if((state_val_71635 === (12))){
var inst_71579 = (state_71634[(11)]);
var state_71634__$1 = state_71634;
var statearr_71773_71864 = state_71634__$1;
(statearr_71773_71864[(2)] = inst_71579);

(statearr_71773_71864[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (2))){
var inst_71568 = (state_71634[(7)]);
var inst_71561 = (state_71634[(14)]);
var inst_71567 = cljs.core.seq(inst_71561);
var inst_71568__$1 = cljs.core.first(inst_71567);
var inst_71569 = cljs.core.next(inst_71567);
var state_71634__$1 = (function (){var statearr_71774 = state_71634;
(statearr_71774[(16)] = inst_71569);

(statearr_71774[(7)] = inst_71568__$1);

return statearr_71774;
})();
if(cljs.core.truth_(inst_71568__$1)){
var statearr_71775_71865 = state_71634__$1;
(statearr_71775_71865[(1)] = (4));

} else {
var statearr_71776_71866 = state_71634__$1;
(statearr_71776_71866[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (11))){
var inst_71569 = (state_71634[(16)]);
var inst_71568 = (state_71634[(7)]);
var inst_71559 = (state_71634[(13)]);
var inst_71561 = (state_71634[(14)]);
var inst_71558 = (state_71634[(15)]);
var inst_71574 = (state_71634[(9)]);
var inst_71579 = (state_71634[(11)]);
var inst_71562 = (state_71634[(10)]);
var inst_71556 = (state_71634[(12)]);
var inst_71586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71587 = [inst_71568,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71588 = (new cljs.core.PersistentVector(null,2,(5),inst_71586,inst_71587,null));
var inst_71601 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_71602 = (function (){var vec__71553 = inst_71556;
var t = inst_71568;
var G__71552 = inst_71561;
var first__71555 = inst_71558;
var block = inst_71574;
var r = inst_71569;
var acc = inst_71562;
var first__71566 = inst_71568;
var seq__71554 = inst_71559;
var seq__71565 = inst_71569;
var c__2706__auto____$2 = inst_71601;
var G__71575 = inst_71579;
var vec__71564 = inst_71561;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71599){
var state_val_71600 = (state_71599[(1)]);
if((state_val_71600 === (1))){
var state_71599__$1 = state_71599;
var statearr_71777_71867 = state_71599__$1;
(statearr_71777_71867[(2)] = null);

(statearr_71777_71867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71600 === (2))){
var ___$1 = (function (){var statearr_71778 = state_71599;
(statearr_71778[(4)] = cljs.core.cons((5),(state_71599[(4)])));

return statearr_71778;
})();
var ___$2 = (function (){var statearr_71779 = state_71599;
(statearr_71779[(4)] = cljs.core.rest((state_71599[(4)])));

return statearr_71779;
})();
var state_71599__$1 = state_71599;
var statearr_71780_71868 = state_71599__$1;
(statearr_71780_71868[(2)] = db);

(statearr_71780_71868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71600 === (3))){
var inst_71597 = (state_71599[(2)]);
var state_71599__$1 = state_71599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71599__$1,inst_71597);
} else {
if((state_val_71600 === (4))){
var inst_71589 = (state_71599[(2)]);
var state_71599__$1 = state_71599;
var statearr_71782_71869 = state_71599__$1;
(statearr_71782_71869[(2)] = inst_71589);

(statearr_71782_71869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71600 === (5))){
var ___$1 = (function (){var statearr_71783 = state_71599;
(statearr_71783[(4)] = cljs.core.rest((state_71599[(4)])));

return statearr_71783;
})();
var state_71599__$1 = state_71599;
var ex71781 = (state_71599__$1[(2)]);
var statearr_71784_71870 = state_71599__$1;
(statearr_71784_71870[(5)] = ex71781);


if((ex71781 instanceof Error)){
var statearr_71785_71871 = state_71599__$1;
(statearr_71785_71871[(1)] = (4));

(statearr_71785_71871[(5)] = null);

} else {
throw ex71781;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_71786 = [null,null,null,null,null,null,null];
(statearr_71786[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_71786[(1)] = (1));

return statearr_71786;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_71599){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71599);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71787){var ex__2687__auto__ = e71787;
var statearr_71788_71872 = state_71599;
(statearr_71788_71872[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71599[(4)]))){
var statearr_71789_71873 = state_71599;
(statearr_71789_71873[(1)] = cljs.core.first((state_71599[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71874 = state_71599;
state_71599 = G__71874;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_71599){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_71599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71790 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71790[(6)] = c__2706__auto____$2);

return statearr_71790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_71603 = cljs.core.async.impl.dispatch.run(inst_71602);
var inst_71604 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_71605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71606 = ["?auth","?id"];
var inst_71607 = (new cljs.core.PersistentVector(null,2,(5),inst_71605,inst_71606,null));
var inst_71608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71610 = [inst_71568,"_tx/auth","?auth"];
var inst_71611 = (new cljs.core.PersistentVector(null,3,(5),inst_71609,inst_71610,null));
var inst_71612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71613 = ["?auth","_auth/id","?id"];
var inst_71614 = (new cljs.core.PersistentVector(null,3,(5),inst_71612,inst_71613,null));
var inst_71615 = [inst_71611,inst_71614];
var inst_71616 = (new cljs.core.PersistentVector(null,2,(5),inst_71608,inst_71615,null));
var inst_71617 = [inst_71607,inst_71616];
var inst_71618 = cljs.core.PersistentHashMap.fromArrays(inst_71604,inst_71617);
var inst_71619 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_71601,inst_71618) : fluree.db.api.query.query_async.call(null,inst_71601,inst_71618));
var state_71634__$1 = (function (){var statearr_71791 = state_71634;
(statearr_71791[(17)] = inst_71603);

(statearr_71791[(18)] = inst_71588);

return statearr_71791;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71634__$1,(14),inst_71619);
} else {
if((state_val_71635 === (9))){
var state_71634__$1 = state_71634;
var statearr_71792_71875 = state_71634__$1;
(statearr_71792_71875[(2)] = show_auth);

(statearr_71792_71875[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (5))){
var inst_71562 = (state_71634[(10)]);
var state_71634__$1 = state_71634;
var statearr_71793_71876 = state_71634__$1;
(statearr_71793_71876[(2)] = inst_71562);

(statearr_71793_71876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (14))){
var inst_71588 = (state_71634[(18)]);
var inst_71579 = (state_71634[(11)]);
var inst_71621 = (state_71634[(2)]);
var inst_71622 = fluree.db.util.async.throw_err(inst_71621);
var inst_71623 = cljs.core.assoc_in(inst_71579,inst_71588,inst_71622);
var state_71634__$1 = state_71634;
var statearr_71794_71877 = state_71634__$1;
(statearr_71794_71877[(2)] = inst_71623);

(statearr_71794_71877[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (10))){
var inst_71584 = (state_71634[(2)]);
var state_71634__$1 = state_71634;
if(cljs.core.truth_(inst_71584)){
var statearr_71795_71878 = state_71634__$1;
(statearr_71795_71878[(1)] = (11));

} else {
var statearr_71796_71879 = state_71634__$1;
(statearr_71796_71879[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71635 === (8))){
var inst_71580 = (state_71634[(8)]);
var state_71634__$1 = state_71634;
var statearr_71797_71880 = state_71634__$1;
(statearr_71797_71880[(2)] = inst_71580);

(statearr_71797_71880[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_71798 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71798[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_71798[(1)] = (1));

return statearr_71798;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_71634){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71634);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71799){var ex__2687__auto__ = e71799;
var statearr_71800_71881 = state_71634;
(statearr_71800_71881[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71634[(4)]))){
var statearr_71801_71882 = state_71634;
(statearr_71801_71882[(1)] = cljs.core.first((state_71634[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71883 = state_71634;
state_71634 = G__71883;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_71634){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_71634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71802 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71802[(6)] = c__2706__auto____$1);

return statearr_71802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_71638 = cljs.core.async.impl.dispatch.run(inst_71637);
var state_71734__$1 = (function (){var statearr_71803 = state_71734;
(statearr_71803[(20)] = inst_71638);

return statearr_71803;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71734__$1,(6),inst_71636);
} else {
if((state_val_71735 === (23))){
var inst_71692 = (state_71734[(2)]);
var state_71734__$1 = (function (){var statearr_71804 = state_71734;
(statearr_71804[(13)] = inst_71692);

return statearr_71804;
})();
var statearr_71805_71884 = state_71734__$1;
(statearr_71805_71884[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (35))){
var inst_71722 = (state_71734[(2)]);
var state_71734__$1 = state_71734;
var statearr_71807_71885 = state_71734__$1;
(statearr_71807_71885[(2)] = inst_71722);

(statearr_71807_71885[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (19))){
var state_71734__$1 = state_71734;
var statearr_71808_71886 = state_71734__$1;
(statearr_71808_71886[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (11))){
var inst_71673 = (state_71734[(2)]);
var state_71734__$1 = state_71734;
if(cljs.core.truth_(inst_71673)){
var statearr_71811_71887 = state_71734__$1;
(statearr_71811_71887[(1)] = (15));

} else {
var statearr_71812_71888 = state_71734__$1;
(statearr_71812_71888[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (9))){
var inst_71664 = (state_71734[(16)]);
var inst_71664__$1 = auth;
var state_71734__$1 = (function (){var statearr_71813 = state_71734;
(statearr_71813[(16)] = inst_71664__$1);

return statearr_71813;
})();
if(cljs.core.truth_(inst_71664__$1)){
var statearr_71814_71889 = state_71734__$1;
(statearr_71814_71889[(1)] = (12));

} else {
var statearr_71815_71890 = state_71734__$1;
(statearr_71815_71890[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (5))){
var _ = (function (){var statearr_71816 = state_71734;
(statearr_71816[(4)] = cljs.core.rest((state_71734[(4)])));

return statearr_71816;
})();
var state_71734__$1 = state_71734;
var ex71810 = (state_71734__$1[(2)]);
var statearr_71817_71891 = state_71734__$1;
(statearr_71817_71891[(5)] = ex71810);


if((ex71810 instanceof Error)){
var statearr_71818_71892 = state_71734__$1;
(statearr_71818_71892[(1)] = (4));

(statearr_71818_71892[(5)] = null);

} else {
throw ex71810;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (14))){
var inst_71670 = (state_71734[(2)]);
var state_71734__$1 = state_71734;
var statearr_71819_71893 = state_71734__$1;
(statearr_71819_71893[(2)] = inst_71670);

(statearr_71819_71893[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (26))){
var inst_71700 = (state_71734[(2)]);
var state_71734__$1 = (function (){var statearr_71820 = state_71734;
(statearr_71820[(10)] = inst_71700);

return statearr_71820;
})();
var statearr_71821_71894 = state_71734__$1;
(statearr_71821_71894[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (16))){
var inst_71661 = (state_71734[(8)]);
var state_71734__$1 = state_71734;
if(cljs.core.truth_(inst_71661)){
var statearr_71823_71895 = state_71734__$1;
(statearr_71823_71895[(1)] = (18));

} else {
var statearr_71824_71896 = state_71734__$1;
(statearr_71824_71896[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (30))){
var inst_71683 = (state_71734[(21)]);
var inst_71708 = (state_71734[(15)]);
var inst_71682 = (state_71734[(12)]);
var inst_71710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71711 = [inst_71682,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71712 = (new cljs.core.PersistentVector(null,2,(5),inst_71710,inst_71711,null));
var inst_71713 = cljs.core.assoc_in(inst_71708,inst_71712,inst_71683);
var state_71734__$1 = state_71734;
var statearr_71825_71897 = state_71734__$1;
(statearr_71825_71897[(2)] = inst_71713);

(statearr_71825_71897[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (10))){
var inst_71661 = (state_71734[(8)]);
var state_71734__$1 = state_71734;
var statearr_71826_71898 = state_71734__$1;
(statearr_71826_71898[(2)] = inst_71661);

(statearr_71826_71898[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (18))){
var inst_71641 = (state_71734[(18)]);
var inst_71679 = (state_71734[(11)]);
var inst_71661 = (state_71734[(8)]);
var inst_71679__$1 = fluree.db.flake.t(inst_71661);
var inst_71680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71641,inst_71679__$1);
var inst_71681 = cljs.core.__destructure_map(inst_71680);
var inst_71682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71681,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71681,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_71734__$1 = (function (){var statearr_71827 = state_71734;
(statearr_71827[(21)] = inst_71683);

(statearr_71827[(11)] = inst_71679__$1);

(statearr_71827[(12)] = inst_71682);

return statearr_71827;
})();
var statearr_71828_71899 = state_71734__$1;
(statearr_71828_71899[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71735 === (8))){
var inst_71728 = (state_71734[(2)]);
var inst_71729 = cljs.core.vals(inst_71728);
var _ = (function (){var statearr_71830 = state_71734;
(statearr_71830[(4)] = cljs.core.rest((state_71734[(4)])));

return statearr_71830;
})();
var state_71734__$1 = state_71734;
var statearr_71831_71900 = state_71734__$1;
(statearr_71831_71900[(2)] = inst_71729);

(statearr_71831_71900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_71832 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71832[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_71832[(1)] = (1));

return statearr_71832;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_71734){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71734);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71833){var ex__2687__auto__ = e71833;
var statearr_71834_71901 = state_71734;
(statearr_71834_71901[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71734[(4)]))){
var statearr_71835_71902 = state_71734;
(statearr_71835_71902[(1)] = cljs.core.first((state_71734[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71903 = state_71734;
state_71734 = G__71903;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_71734){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_71734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71836 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71836[(6)] = c__2706__auto__);

return statearr_71836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72027){
var state_val_72028 = (state_72027[(1)]);
if((state_val_72028 === (7))){
var inst_71926 = (state_72027[(7)]);
var inst_71928 = fluree.db.api.query.resolve_block_range(inst_71926,query_map);
var state_72027__$1 = state_72027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72027__$1,(10),inst_71928);
} else {
if((state_val_72028 === (20))){
var inst_71952 = (state_72027[(2)]);
var inst_71953 = fluree.db.util.async.throw_err(inst_71952);
var inst_71954 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71953);
var inst_71955 = (inst_71954 - (1));
var state_72027__$1 = state_72027;
var statearr_72029_72092 = state_72027__$1;
(statearr_72029_72092[(2)] = inst_71955);

(statearr_72029_72092[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (27))){
var state_72027__$1 = state_72027;
var statearr_72030_72093 = state_72027__$1;
(statearr_72030_72093[(2)] = null);

(statearr_72030_72093[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (1))){
var state_72027__$1 = state_72027;
var statearr_72031_72094 = state_72027__$1;
(statearr_72031_72094[(2)] = null);

(statearr_72031_72094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (24))){
var inst_71962 = (state_72027[(2)]);
var inst_71963 = fluree.db.util.async.throw_err(inst_71962);
var inst_71964 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71963);
var state_72027__$1 = state_72027;
var statearr_72032_72095 = state_72027__$1;
(statearr_72032_72095[(2)] = inst_71964);

(statearr_72032_72095[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (39))){
var inst_71999 = (state_72027[(2)]);
var inst_72000 = fluree.db.util.async.throw_err(inst_71999);
var state_72027__$1 = state_72027;
var statearr_72033_72096 = state_72027__$1;
(statearr_72033_72096[(2)] = inst_72000);

(statearr_72033_72096[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (4))){
var inst_71904 = (state_72027[(2)]);
var state_72027__$1 = state_72027;
var statearr_72034_72097 = state_72027__$1;
(statearr_72034_72097[(2)] = inst_71904);

(statearr_72034_72097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (15))){
var inst_71935 = (state_72027[(8)]);
var state_72027__$1 = state_72027;
var statearr_72035_72098 = state_72027__$1;
(statearr_72035_72098[(2)] = inst_71935);

(statearr_72035_72098[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (21))){
var inst_71926 = (state_72027[(7)]);
var inst_71936 = (state_72027[(9)]);
var inst_71960 = fluree.db.time_travel.as_of_block(inst_71926,inst_71936);
var state_72027__$1 = state_72027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72027__$1,(24),inst_71960);
} else {
if((state_val_72028 === (31))){
var inst_71920 = (state_72027[(10)]);
var state_72027__$1 = state_72027;
var statearr_72036_72099 = state_72027__$1;
(statearr_72036_72099[(2)] = inst_71920);

(statearr_72036_72099[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (32))){
var inst_71926 = (state_72027[(7)]);
var inst_71978 = (state_72027[(11)]);
var inst_71983 = (state_72027[(12)]);
var inst_71987 = (state_72027[(2)]);
var inst_71988 = fluree.db.api.query.format_history_resp(inst_71926,inst_71978,inst_71983,inst_71987);
var state_72027__$1 = state_72027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72027__$1,(29),inst_71988);
} else {
if((state_val_72028 === (40))){
var inst_71978 = (state_72027[(11)]);
var inst_72004 = (state_72027[(13)]);
var inst_72006 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_72007 = cljs.core.count(inst_71978);
var inst_72008 = [inst_72004,inst_72007,(200)];
var inst_72009 = cljs.core.PersistentHashMap.fromArrays(inst_72006,inst_72008);
var state_72027__$1 = state_72027;
var statearr_72037_72100 = state_72027__$1;
(statearr_72037_72100[(2)] = inst_72009);

(statearr_72037_72100[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (33))){
var inst_71919 = (state_72027[(14)]);
var state_72027__$1 = state_72027;
var statearr_72038_72101 = state_72027__$1;
(statearr_72038_72101[(2)] = inst_71919);

(statearr_72038_72101[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (13))){
var inst_72022 = (state_72027[(2)]);
var _ = (function (){var statearr_72039 = state_72027;
(statearr_72039[(4)] = cljs.core.rest((state_72027[(4)])));

return statearr_72039;
})();
var state_72027__$1 = state_72027;
var statearr_72040_72102 = state_72027__$1;
(statearr_72040_72102[(2)] = inst_72022);

(statearr_72040_72102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (22))){
var inst_71926 = (state_72027[(7)]);
var inst_71966 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71926);
var state_72027__$1 = state_72027;
var statearr_72041_72103 = state_72027__$1;
(statearr_72041_72103[(2)] = inst_71966);

(statearr_72041_72103[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (36))){
var inst_71926 = (state_72027[(7)]);
var inst_71991 = (state_72027[(15)]);
var inst_71997 = fluree.db.api.query.format_blocks_resp_pretty(inst_71926,inst_71991);
var state_72027__$1 = state_72027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72027__$1,(39),inst_71997);
} else {
if((state_val_72028 === (41))){
var inst_72004 = (state_72027[(13)]);
var state_72027__$1 = state_72027;
var statearr_72042_72104 = state_72027__$1;
(statearr_72042_72104[(2)] = inst_72004);

(statearr_72042_72104[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (29))){
var inst_71919 = (state_72027[(14)]);
var inst_71990 = (state_72027[(2)]);
var inst_71991 = fluree.db.util.async.throw_err(inst_71990);
var state_72027__$1 = (function (){var statearr_72043 = state_72027;
(statearr_72043[(15)] = inst_71991);

return statearr_72043;
})();
if(cljs.core.truth_(inst_71919)){
var statearr_72044_72105 = state_72027__$1;
(statearr_72044_72105[(1)] = (33));

} else {
var statearr_72045_72106 = state_72027__$1;
(statearr_72045_72106[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (6))){
var inst_71916 = (state_72027[(16)]);
var inst_71925 = (state_72027[(2)]);
var inst_71926 = fluree.db.util.async.throw_err(inst_71925);
var state_72027__$1 = (function (){var statearr_72046 = state_72027;
(statearr_72046[(7)] = inst_71926);

return statearr_72046;
})();
if(cljs.core.truth_(inst_71916)){
var statearr_72047_72107 = state_72027__$1;
(statearr_72047_72107[(1)] = (7));

} else {
var statearr_72048_72108 = state_72027__$1;
(statearr_72048_72108[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (28))){
var inst_71921 = (state_72027[(17)]);
var inst_71983 = (state_72027[(2)]);
var state_72027__$1 = (function (){var statearr_72049 = state_72027;
(statearr_72049[(12)] = inst_71983);

return statearr_72049;
})();
if(cljs.core.truth_(inst_71921)){
var statearr_72050_72109 = state_72027__$1;
(statearr_72050_72109[(1)] = (30));

} else {
var statearr_72051_72110 = state_72027__$1;
(statearr_72051_72110[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (25))){
var inst_71922 = (state_72027[(18)]);
var inst_71977 = (state_72027[(2)]);
var inst_71978 = fluree.db.util.async.throw_err(inst_71977);
var state_72027__$1 = (function (){var statearr_72052 = state_72027;
(statearr_72052[(11)] = inst_71978);

return statearr_72052;
})();
if(cljs.core.truth_(inst_71922)){
var statearr_72053_72111 = state_72027__$1;
(statearr_72053_72111[(1)] = (26));

} else {
var statearr_72054_72112 = state_72027__$1;
(statearr_72054_72112[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (34))){
var inst_71918 = (state_72027[(19)]);
var state_72027__$1 = state_72027;
var statearr_72055_72113 = state_72027__$1;
(statearr_72055_72113[(2)] = inst_71918);

(statearr_72055_72113[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (17))){
var inst_71926 = (state_72027[(7)]);
var inst_71935 = (state_72027[(8)]);
var inst_71949 = (inst_71935 - (1));
var inst_71950 = fluree.db.time_travel.as_of_block(inst_71926,inst_71949);
var state_72027__$1 = state_72027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72027__$1,(20),inst_71950);
} else {
if((state_val_72028 === (3))){
var inst_72025 = (state_72027[(2)]);
var state_72027__$1 = state_72027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72027__$1,inst_72025);
} else {
if((state_val_72028 === (12))){
var inst_72014 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_72015 = ["History query not properly formatted. Provided ",inst_72014].join('');
var inst_72016 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72017 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72018 = cljs.core.PersistentHashMap.fromArrays(inst_72016,inst_72017);
var inst_72019 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72015,inst_72018);
var inst_72020 = (function(){throw inst_72019})();
var state_72027__$1 = state_72027;
var statearr_72056_72114 = state_72027__$1;
(statearr_72056_72114[(2)] = inst_72020);

(statearr_72056_72114[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (2))){
var _ = (function (){var statearr_72057 = state_72027;
(statearr_72057[(4)] = cljs.core.cons((5),(state_72027[(4)])));

return statearr_72057;
})();
var inst_71914 = query_map;
var inst_71915 = cljs.core.__destructure_map(inst_71914);
var inst_71916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71915,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71915,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_71918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71915,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_71919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71915,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_71920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71915,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_71921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71915,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_71922 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71915,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_71923 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71915,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_72027__$1 = (function (){var statearr_72058 = state_72027;
(statearr_72058[(20)] = inst_71917);

(statearr_72058[(21)] = inst_71923);

(statearr_72058[(14)] = inst_71919);

(statearr_72058[(18)] = inst_71922);

(statearr_72058[(10)] = inst_71920);

(statearr_72058[(17)] = inst_71921);

(statearr_72058[(16)] = inst_71916);

(statearr_72058[(19)] = inst_71918);

return statearr_72058;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72027__$1,(6),sources);
} else {
if((state_val_72028 === (23))){
var inst_71917 = (state_72027[(20)]);
var inst_71926 = (state_72027[(7)]);
var inst_71958 = (state_72027[(22)]);
var inst_71968 = (state_72027[(2)]);
var inst_71969 = fluree.db.api.query.get_history_pattern(inst_71917);
var inst_71970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71969,(0),null);
var inst_71971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71969,(1),null);
var inst_71972 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_71973 = [inst_71958,inst_71968];
var inst_71974 = cljs.core.PersistentHashMap.fromArrays(inst_71972,inst_71973);
var inst_71975 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_71926,inst_71971,cljs.core._EQ_,inst_71970,inst_71974);
var state_72027__$1 = state_72027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72027__$1,(25),inst_71975);
} else {
if((state_val_72028 === (35))){
var inst_71995 = (state_72027[(2)]);
var state_72027__$1 = state_72027;
if(cljs.core.truth_(inst_71995)){
var statearr_72059_72115 = state_72027__$1;
(statearr_72059_72115[(1)] = (36));

} else {
var statearr_72060_72116 = state_72027__$1;
(statearr_72060_72116[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (19))){
var inst_71936 = (state_72027[(9)]);
var inst_71958 = (state_72027[(2)]);
var state_72027__$1 = (function (){var statearr_72061 = state_72027;
(statearr_72061[(22)] = inst_71958);

return statearr_72061;
})();
if(cljs.core.truth_(inst_71936)){
var statearr_72062_72117 = state_72027__$1;
(statearr_72062_72117[(1)] = (21));

} else {
var statearr_72063_72118 = state_72027__$1;
(statearr_72063_72118[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (11))){
var inst_71935 = (state_72027[(8)]);
var inst_71923 = (state_72027[(21)]);
var inst_71942 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71923);
var state_72027__$1 = (function (){var statearr_72065 = state_72027;
(statearr_72065[(23)] = inst_71942);

return statearr_72065;
})();
if(cljs.core.truth_(inst_71935)){
var statearr_72066_72119 = state_72027__$1;
(statearr_72066_72119[(1)] = (14));

} else {
var statearr_72067_72120 = state_72027__$1;
(statearr_72067_72120[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (9))){
var inst_71934 = (state_72027[(2)]);
var inst_71935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71934,(0),null);
var inst_71936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71934,(1),null);
var inst_71937 = cljs.core.contains_QMARK_(query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_72027__$1 = (function (){var statearr_72068 = state_72027;
(statearr_72068[(8)] = inst_71935);

(statearr_72068[(9)] = inst_71936);

return statearr_72068;
})();
if(inst_71937){
var statearr_72069_72121 = state_72027__$1;
(statearr_72069_72121[(1)] = (11));

} else {
var statearr_72070_72122 = state_72027__$1;
(statearr_72070_72122[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (5))){
var _ = (function (){var statearr_72071 = state_72027;
(statearr_72071[(4)] = cljs.core.rest((state_72027[(4)])));

return statearr_72071;
})();
var state_72027__$1 = state_72027;
var ex72064 = (state_72027__$1[(2)]);
var statearr_72072_72123 = state_72027__$1;
(statearr_72072_72123[(5)] = ex72064);


if((ex72064 instanceof Error)){
var statearr_72073_72124 = state_72027__$1;
(statearr_72073_72124[(1)] = (4));

(statearr_72073_72124[(5)] = null);

} else {
throw ex72064;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (14))){
var inst_71935 = (state_72027[(8)]);
var inst_71944 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_71935);
var state_72027__$1 = state_72027;
var statearr_72074_72125 = state_72027__$1;
(statearr_72074_72125[(2)] = inst_71944);

(statearr_72074_72125[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (26))){
var inst_71922 = (state_72027[(18)]);
var inst_71980 = cljs.core.set(inst_71922);
var state_72027__$1 = state_72027;
var statearr_72075_72126 = state_72027__$1;
(statearr_72075_72126[(2)] = inst_71980);

(statearr_72075_72126[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (16))){
var inst_71947 = (state_72027[(2)]);
var state_72027__$1 = state_72027;
if(cljs.core.truth_(inst_71947)){
var statearr_72076_72127 = state_72027__$1;
(statearr_72076_72127[(1)] = (17));

} else {
var statearr_72077_72128 = state_72027__$1;
(statearr_72077_72128[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (38))){
var inst_71942 = (state_72027[(23)]);
var inst_72004 = (state_72027[(2)]);
var state_72027__$1 = (function (){var statearr_72078 = state_72027;
(statearr_72078[(13)] = inst_72004);

return statearr_72078;
})();
if(cljs.core.truth_(inst_71942)){
var statearr_72079_72129 = state_72027__$1;
(statearr_72079_72129[(1)] = (40));

} else {
var statearr_72080_72130 = state_72027__$1;
(statearr_72080_72130[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (30))){
var inst_71921 = (state_72027[(17)]);
var state_72027__$1 = state_72027;
var statearr_72081_72131 = state_72027__$1;
(statearr_72081_72131[(2)] = inst_71921);

(statearr_72081_72131[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (10))){
var inst_71930 = (state_72027[(2)]);
var inst_71931 = fluree.db.util.async.throw_err(inst_71930);
var state_72027__$1 = state_72027;
var statearr_72082_72132 = state_72027__$1;
(statearr_72082_72132[(2)] = inst_71931);

(statearr_72082_72132[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (18))){
var state_72027__$1 = state_72027;
var statearr_72083_72133 = state_72027__$1;
(statearr_72083_72133[(2)] = (-1));

(statearr_72083_72133[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (42))){
var inst_72012 = (state_72027[(2)]);
var state_72027__$1 = state_72027;
var statearr_72084_72134 = state_72027__$1;
(statearr_72084_72134[(2)] = inst_72012);

(statearr_72084_72134[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (37))){
var inst_71991 = (state_72027[(15)]);
var inst_72002 = fluree.db.api.query.block_Flakes__GT_vector(inst_71991);
var state_72027__$1 = state_72027;
var statearr_72085_72135 = state_72027__$1;
(statearr_72085_72135[(2)] = inst_72002);

(statearr_72085_72135[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72028 === (8))){
var state_72027__$1 = state_72027;
var statearr_72086_72136 = state_72027__$1;
(statearr_72086_72136[(2)] = null);

(statearr_72086_72136[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_72087 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72087[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2684__auto__);

(statearr_72087[(1)] = (1));

return statearr_72087;
});
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1 = (function (state_72027){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72027);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72088){var ex__2687__auto__ = e72088;
var statearr_72089_72137 = state_72027;
(statearr_72089_72137[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72027[(4)]))){
var statearr_72090_72138 = state_72027;
(statearr_72090_72138[(1)] = cljs.core.first((state_72027[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72139 = state_72027;
state_72027 = G__72139;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = function(state_72027){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1.call(this,state_72027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72091 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72091[(6)] = c__2706__auto__);

return statearr_72091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72272){
var state_val_72273 = (state_72272[(1)]);
if((state_val_72273 === (7))){
var inst_72169 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_72170 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_72169].join('');
var inst_72171 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72172 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72173 = cljs.core.PersistentHashMap.fromArrays(inst_72171,inst_72172);
var inst_72174 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72170,inst_72173);
var inst_72175 = (function(){throw inst_72174})();
var state_72272__$1 = state_72272;
var statearr_72274_72353 = state_72272__$1;
(statearr_72274_72353[(2)] = inst_72175);

(statearr_72274_72353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (20))){
var inst_72207 = (state_72272[(2)]);
var state_72272__$1 = state_72272;
if(cljs.core.truth_(inst_72207)){
var statearr_72275_72354 = state_72272__$1;
(statearr_72275_72354[(1)] = (21));

} else {
var statearr_72276_72355 = state_72272__$1;
(statearr_72276_72355[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (27))){
var inst_72151 = (state_72272[(7)]);
var state_72272__$1 = state_72272;
var statearr_72277_72356 = state_72272__$1;
(statearr_72277_72356[(2)] = inst_72151);

(statearr_72277_72356[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (1))){
var state_72272__$1 = state_72272;
var statearr_72278_72357 = state_72272__$1;
(statearr_72278_72357[(2)] = null);

(statearr_72278_72357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (24))){
var inst_72213 = (state_72272[(8)]);
var state_72272__$1 = state_72272;
var statearr_72279_72358 = state_72272__$1;
(statearr_72279_72358[(2)] = inst_72213);

(statearr_72279_72358[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (39))){
var inst_72157 = (state_72272[(9)]);
var state_72272__$1 = state_72272;
if(cljs.core.truth_(inst_72157)){
var statearr_72280_72359 = state_72272__$1;
(statearr_72280_72359[(1)] = (42));

} else {
var statearr_72281_72360 = state_72272__$1;
(statearr_72281_72360[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (46))){
var inst_72245 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72246 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72247 = cljs.core.PersistentHashMap.fromArrays(inst_72245,inst_72246);
var inst_72248 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_72247);
var inst_72249 = (function(){throw inst_72248})();
var state_72272__$1 = state_72272;
var statearr_72282_72361 = state_72272__$1;
(statearr_72282_72361[(2)] = inst_72249);

(statearr_72282_72361[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (4))){
var inst_72141 = (state_72272[(2)]);
var state_72272__$1 = state_72272;
var statearr_72283_72362 = state_72272__$1;
(statearr_72283_72362[(2)] = inst_72141);

(statearr_72283_72362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (15))){
var inst_72154 = (state_72272[(10)]);
var inst_72192 = (state_72272[(11)]);
var inst_72194 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_72192);
var inst_72195 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_72192);
var inst_72196 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_72192);
var inst_72197 = fluree.db.api.query.get_sources(inst_72194,inst_72195,inst_72196,inst_72154);
var state_72272__$1 = state_72272;
var statearr_72284_72363 = state_72272__$1;
(statearr_72284_72363[(2)] = inst_72197);

(statearr_72284_72363[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (48))){
var inst_72202 = (state_72272[(12)]);
var inst_72256 = (state_72272[(2)]);
var inst_72257 = fluree.db.util.async.throw_err(inst_72256);
var state_72272__$1 = (function (){var statearr_72285 = state_72272;
(statearr_72285[(13)] = inst_72257);

return statearr_72285;
})();
if(cljs.core.truth_(inst_72202)){
var statearr_72286_72364 = state_72272__$1;
(statearr_72286_72364[(1)] = (49));

} else {
var statearr_72287_72365 = state_72272__$1;
(statearr_72287_72365[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (50))){
var inst_72257 = (state_72272[(13)]);
var state_72272__$1 = state_72272;
var statearr_72288_72366 = state_72272__$1;
(statearr_72288_72366[(2)] = inst_72257);

(statearr_72288_72366[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (21))){
var inst_72209 = cljs.core.volatile_BANG_((0));
var state_72272__$1 = state_72272;
var statearr_72289_72367 = state_72272__$1;
(statearr_72289_72367[(2)] = inst_72209);

(statearr_72289_72367[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (31))){
var inst_72155 = (state_72272[(14)]);
var state_72272__$1 = state_72272;
if(cljs.core.truth_(inst_72155)){
var statearr_72290_72368 = state_72272__$1;
(statearr_72290_72368[(1)] = (33));

} else {
var statearr_72291_72369 = state_72272__$1;
(statearr_72291_72369[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (32))){
var inst_72232 = (state_72272[(2)]);
var state_72272__$1 = state_72272;
var statearr_72292_72370 = state_72272__$1;
(statearr_72292_72370[(2)] = inst_72232);

(statearr_72292_72370[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (40))){
var inst_72234 = (state_72272[(15)]);
var state_72272__$1 = state_72272;
var statearr_72293_72371 = state_72272__$1;
(statearr_72293_72371[(2)] = inst_72234);

(statearr_72293_72371[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (33))){
var inst_72155 = (state_72272[(14)]);
var state_72272__$1 = state_72272;
var statearr_72294_72372 = state_72272__$1;
(statearr_72294_72372[(2)] = inst_72155);

(statearr_72294_72372[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (13))){
var inst_72152 = (state_72272[(16)]);
var inst_72181 = (state_72272[(2)]);
var inst_72182 = fluree.db.util.async.throw_err(inst_72181);
var inst_72183 = fluree.db.time_travel.as_of_block(inst_72182,inst_72152);
var state_72272__$1 = state_72272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72272__$1,(12),inst_72183);
} else {
if((state_val_72273 === (22))){
var state_72272__$1 = state_72272;
var statearr_72295_72373 = state_72272__$1;
(statearr_72295_72373[(2)] = null);

(statearr_72295_72373[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (36))){
var inst_72159 = (state_72272[(17)]);
var state_72272__$1 = state_72272;
var statearr_72296_72374 = state_72272__$1;
(statearr_72296_72374[(2)] = inst_72159);

(statearr_72296_72374[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (41))){
var inst_72242 = (state_72272[(2)]);
var state_72272__$1 = state_72272;
if(cljs.core.truth_(inst_72242)){
var statearr_72297_72375 = state_72272__$1;
(statearr_72297_72375[(1)] = (45));

} else {
var statearr_72298_72376 = state_72272__$1;
(statearr_72298_72376[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (43))){
var inst_72153 = (state_72272[(18)]);
var state_72272__$1 = state_72272;
var statearr_72299_72377 = state_72272__$1;
(statearr_72299_72377[(2)] = inst_72153);

(statearr_72299_72377[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (29))){
var inst_72234 = (state_72272[(15)]);
var inst_72234__$1 = (state_72272[(2)]);
var state_72272__$1 = (function (){var statearr_72300 = state_72272;
(statearr_72300[(15)] = inst_72234__$1);

return statearr_72300;
})();
if(cljs.core.truth_(inst_72234__$1)){
var statearr_72301_72378 = state_72272__$1;
(statearr_72301_72378[(1)] = (39));

} else {
var statearr_72302_72379 = state_72272__$1;
(statearr_72302_72379[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (44))){
var inst_72239 = (state_72272[(2)]);
var state_72272__$1 = state_72272;
var statearr_72303_72380 = state_72272__$1;
(statearr_72303_72380[(2)] = inst_72239);

(statearr_72303_72380[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (6))){
var state_72272__$1 = state_72272;
var statearr_72304_72381 = state_72272__$1;
(statearr_72304_72381[(2)] = null);

(statearr_72304_72381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (28))){
var inst_72156 = (state_72272[(19)]);
var state_72272__$1 = state_72272;
if(cljs.core.truth_(inst_72156)){
var statearr_72305_72382 = state_72272__$1;
(statearr_72305_72382[(1)] = (30));

} else {
var statearr_72306_72383 = state_72272__$1;
(statearr_72306_72383[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (51))){
var inst_72267 = (state_72272[(2)]);
var _ = (function (){var statearr_72307 = state_72272;
(statearr_72307[(4)] = cljs.core.rest((state_72272[(4)])));

return statearr_72307;
})();
var state_72272__$1 = state_72272;
var statearr_72308_72384 = state_72272__$1;
(statearr_72308_72384[(2)] = inst_72267);

(statearr_72308_72384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (25))){
var state_72272__$1 = state_72272;
var statearr_72309_72385 = state_72272__$1;
(statearr_72309_72385[(2)] = (1000000));

(statearr_72309_72385[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (34))){
var inst_72159 = (state_72272[(17)]);
var state_72272__$1 = state_72272;
if(cljs.core.truth_(inst_72159)){
var statearr_72310_72386 = state_72272__$1;
(statearr_72310_72386[(1)] = (36));

} else {
var statearr_72311_72387 = state_72272__$1;
(statearr_72311_72387[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (17))){
var inst_72158 = (state_72272[(20)]);
var inst_72203 = (state_72272[(21)]);
var inst_72201 = (state_72272[(2)]);
var inst_72202 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_72158);
var inst_72203__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72158);
var state_72272__$1 = (function (){var statearr_72312 = state_72272;
(statearr_72312[(21)] = inst_72203__$1);

(statearr_72312[(22)] = inst_72201);

(statearr_72312[(12)] = inst_72202);

return statearr_72312;
})();
if(cljs.core.truth_(inst_72203__$1)){
var statearr_72313_72388 = state_72272__$1;
(statearr_72313_72388[(1)] = (18));

} else {
var statearr_72314_72389 = state_72272__$1;
(statearr_72314_72389[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (3))){
var inst_72270 = (state_72272[(2)]);
var state_72272__$1 = state_72272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72272__$1,inst_72270);
} else {
if((state_val_72273 === (12))){
var inst_72185 = (state_72272[(2)]);
var inst_72186 = fluree.db.util.async.throw_err(inst_72185);
var state_72272__$1 = state_72272;
var statearr_72315_72390 = state_72272__$1;
(statearr_72315_72390[(2)] = inst_72186);

(statearr_72315_72390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (2))){
var inst_72155 = (state_72272[(14)]);
var inst_72153 = (state_72272[(18)]);
var inst_72150 = (state_72272[(23)]);
var inst_72158 = (state_72272[(20)]);
var inst_72154 = (state_72272[(10)]);
var inst_72159 = (state_72272[(17)]);
var inst_72156 = (state_72272[(19)]);
var inst_72152 = (state_72272[(16)]);
var inst_72151 = (state_72272[(7)]);
var inst_72157 = (state_72272[(9)]);
var _ = (function (){var statearr_72316 = state_72272;
(statearr_72316[(4)] = cljs.core.cons((5),(state_72272[(4)])));

return statearr_72316;
})();
var inst_72148 = flureeQL;
var inst_72149 = cljs.core.__destructure_map(inst_72148);
var inst_72150__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_72151__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_72152__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72153__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_72154__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_72155__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_72156__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_72157__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_72158__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_72159__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72149,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_72160 = (function (){var construct = inst_72150__$1;
var select = inst_72151__$1;
var block = inst_72152__$1;
var where = inst_72153__$1;
var prefixes = inst_72154__$1;
var selectDistinct = inst_72155__$1;
var selectOne = inst_72156__$1;
var from = inst_72157__$1;
var opts = inst_72158__$1;
var map__72147 = inst_72149;
var selectReduced = inst_72159__$1;
return (function (p1__72140_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__72140_SHARP_);
});
})();
var inst_72161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72162 = [inst_72151__$1,inst_72156__$1,inst_72155__$1,inst_72159__$1];
var inst_72163 = (new cljs.core.PersistentVector(null,4,(5),inst_72161,inst_72162,null));
var inst_72164 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_72163);
var inst_72165 = cljs.core.count(inst_72164);
var inst_72166 = (inst_72160.cljs$core$IFn$_invoke$arity$1 ? inst_72160.cljs$core$IFn$_invoke$arity$1(inst_72165) : inst_72160.call(null,inst_72165));
var state_72272__$1 = (function (){var statearr_72317 = state_72272;
(statearr_72317[(14)] = inst_72155__$1);

(statearr_72317[(18)] = inst_72153__$1);

(statearr_72317[(23)] = inst_72150__$1);

(statearr_72317[(20)] = inst_72158__$1);

(statearr_72317[(10)] = inst_72154__$1);

(statearr_72317[(17)] = inst_72159__$1);

(statearr_72317[(19)] = inst_72156__$1);

(statearr_72317[(16)] = inst_72152__$1);

(statearr_72317[(7)] = inst_72151__$1);

(statearr_72317[(9)] = inst_72157__$1);

return statearr_72317;
})();
if(cljs.core.truth_(inst_72166)){
var statearr_72318_72391 = state_72272__$1;
(statearr_72318_72391[(1)] = (6));

} else {
var statearr_72319_72392 = state_72272__$1;
(statearr_72319_72392[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (23))){
var inst_72213 = (state_72272[(8)]);
var inst_72158 = (state_72272[(20)]);
var inst_72212 = (state_72272[(2)]);
var inst_72213__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72158);
var state_72272__$1 = (function (){var statearr_72320 = state_72272;
(statearr_72320[(8)] = inst_72213__$1);

(statearr_72320[(24)] = inst_72212);

return statearr_72320;
})();
if(cljs.core.truth_(inst_72213__$1)){
var statearr_72321_72393 = state_72272__$1;
(statearr_72321_72393[(1)] = (24));

} else {
var statearr_72322_72394 = state_72272__$1;
(statearr_72322_72394[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (47))){
var inst_72218 = (state_72272[(25)]);
var inst_72192 = (state_72272[(11)]);
var inst_72251 = (state_72272[(2)]);
var inst_72252 = fluree.db.util.core.current_time_millis();
var inst_72253 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_72218);
var inst_72254 = fluree.db.query.fql.query(inst_72192,inst_72253);
var state_72272__$1 = (function (){var statearr_72323 = state_72272;
(statearr_72323[(26)] = inst_72252);

(statearr_72323[(27)] = inst_72251);

return statearr_72323;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72272__$1,(48),inst_72254);
} else {
if((state_val_72273 === (35))){
var inst_72230 = (state_72272[(2)]);
var state_72272__$1 = state_72272;
var statearr_72324_72395 = state_72272__$1;
(statearr_72324_72395[(2)] = inst_72230);

(statearr_72324_72395[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (19))){
var inst_72202 = (state_72272[(12)]);
var state_72272__$1 = state_72272;
var statearr_72325_72396 = state_72272__$1;
(statearr_72325_72396[(2)] = inst_72202);

(statearr_72325_72396[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (11))){
var inst_72154 = (state_72272[(10)]);
var inst_72192 = (state_72272[(2)]);
var state_72272__$1 = (function (){var statearr_72327 = state_72272;
(statearr_72327[(11)] = inst_72192);

return statearr_72327;
})();
if(cljs.core.truth_(inst_72154)){
var statearr_72328_72397 = state_72272__$1;
(statearr_72328_72397[(1)] = (15));

} else {
var statearr_72329_72398 = state_72272__$1;
(statearr_72329_72398[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (9))){
var inst_72178 = (state_72272[(28)]);
var state_72272__$1 = state_72272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72272__$1,(13),inst_72178);
} else {
if((state_val_72273 === (5))){
var _ = (function (){var statearr_72330 = state_72272;
(statearr_72330[(4)] = cljs.core.rest((state_72272[(4)])));

return statearr_72330;
})();
var state_72272__$1 = state_72272;
var ex72326 = (state_72272__$1[(2)]);
var statearr_72331_72399 = state_72272__$1;
(statearr_72331_72399[(5)] = ex72326);


if((ex72326 instanceof Error)){
var statearr_72332_72400 = state_72272__$1;
(statearr_72332_72400[(1)] = (4));

(statearr_72332_72400[(5)] = null);

} else {
throw ex72326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (14))){
var inst_72189 = (state_72272[(2)]);
var inst_72190 = fluree.db.util.async.throw_err(inst_72189);
var state_72272__$1 = state_72272;
var statearr_72333_72401 = state_72272__$1;
(statearr_72333_72401[(2)] = inst_72190);

(statearr_72333_72401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (45))){
var state_72272__$1 = state_72272;
var statearr_72334_72402 = state_72272__$1;
(statearr_72334_72402[(2)] = null);

(statearr_72334_72402[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (26))){
var inst_72158 = (state_72272[(20)]);
var inst_72201 = (state_72272[(22)]);
var inst_72151 = (state_72272[(7)]);
var inst_72212 = (state_72272[(24)]);
var inst_72217 = (state_72272[(2)]);
var inst_72218 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_72158,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_72201,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_72217,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_72212], 0));
var state_72272__$1 = (function (){var statearr_72335 = state_72272;
(statearr_72335[(25)] = inst_72218);

return statearr_72335;
})();
if(cljs.core.truth_(inst_72151)){
var statearr_72336_72403 = state_72272__$1;
(statearr_72336_72403[(1)] = (27));

} else {
var statearr_72337_72404 = state_72272__$1;
(statearr_72337_72404[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (16))){
var inst_72199 = cljs.core.PersistentHashMap.EMPTY;
var state_72272__$1 = state_72272;
var statearr_72338_72405 = state_72272__$1;
(statearr_72338_72405[(2)] = inst_72199);

(statearr_72338_72405[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (38))){
var inst_72228 = (state_72272[(2)]);
var state_72272__$1 = state_72272;
var statearr_72339_72406 = state_72272__$1;
(statearr_72339_72406[(2)] = inst_72228);

(statearr_72339_72406[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (30))){
var inst_72156 = (state_72272[(19)]);
var state_72272__$1 = state_72272;
var statearr_72340_72407 = state_72272__$1;
(statearr_72340_72407[(2)] = inst_72156);

(statearr_72340_72407[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (10))){
var inst_72178 = (state_72272[(28)]);
var state_72272__$1 = state_72272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72272__$1,(14),inst_72178);
} else {
if((state_val_72273 === (18))){
var inst_72203 = (state_72272[(21)]);
var state_72272__$1 = state_72272;
var statearr_72341_72408 = state_72272__$1;
(statearr_72341_72408[(2)] = inst_72203);

(statearr_72341_72408[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (42))){
var inst_72157 = (state_72272[(9)]);
var state_72272__$1 = state_72272;
var statearr_72342_72409 = state_72272__$1;
(statearr_72342_72409[(2)] = inst_72157);

(statearr_72342_72409[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (37))){
var inst_72150 = (state_72272[(23)]);
var state_72272__$1 = state_72272;
var statearr_72343_72410 = state_72272__$1;
(statearr_72343_72410[(2)] = inst_72150);

(statearr_72343_72410[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (8))){
var inst_72152 = (state_72272[(16)]);
var inst_72177 = (state_72272[(2)]);
var inst_72178 = sources;
var state_72272__$1 = (function (){var statearr_72344 = state_72272;
(statearr_72344[(28)] = inst_72178);

(statearr_72344[(29)] = inst_72177);

return statearr_72344;
})();
if(cljs.core.truth_(inst_72152)){
var statearr_72345_72411 = state_72272__$1;
(statearr_72345_72411[(1)] = (9));

} else {
var statearr_72346_72412 = state_72272__$1;
(statearr_72346_72412[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72273 === (49))){
var inst_72257 = (state_72272[(13)]);
var inst_72252 = (state_72272[(26)]);
var inst_72212 = (state_72272[(24)]);
var inst_72192 = (state_72272[(11)]);
var inst_72259 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72260 = cljs.core.deref(inst_72212);
var inst_72261 = fluree.db.util.core.response_time_formatted(inst_72252);
var inst_72262 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_72192);
var inst_72263 = [(200),inst_72257,inst_72260,inst_72261,inst_72262];
var inst_72264 = cljs.core.PersistentHashMap.fromArrays(inst_72259,inst_72263);
var state_72272__$1 = state_72272;
var statearr_72347_72413 = state_72272__$1;
(statearr_72347_72413[(2)] = inst_72264);

(statearr_72347_72413[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_72348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72348[(0)] = fluree$db$api$query$query_async_$_state_machine__2684__auto__);

(statearr_72348[(1)] = (1));

return statearr_72348;
});
var fluree$db$api$query$query_async_$_state_machine__2684__auto____1 = (function (state_72272){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72272);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72349){var ex__2687__auto__ = e72349;
var statearr_72350_72414 = state_72272;
(statearr_72350_72414[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72272[(4)]))){
var statearr_72351_72415 = state_72272;
(statearr_72351_72415[(1)] = cljs.core.first((state_72272[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72416 = state_72272;
state_72272 = G__72416;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2684__auto__ = function(state_72272){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____1.call(this,state_72272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72352 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72352[(6)] = c__2706__auto__);

return statearr_72352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72557){
var state_val_72558 = (state_72557[(1)]);
if((state_val_72558 === (7))){
var inst_72552 = (state_72557[(2)]);
var _ = (function (){var statearr_72559 = state_72557;
(statearr_72559[(4)] = cljs.core.rest((state_72557[(4)])));

return statearr_72559;
})();
var state_72557__$1 = state_72557;
var statearr_72560_72636 = state_72557__$1;
(statearr_72560_72636[(2)] = inst_72552);

(statearr_72560_72636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (20))){
var inst_72524 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
var statearr_72561_72637 = state_72557__$1;
(statearr_72561_72637[(2)] = inst_72524);

(statearr_72561_72637[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (27))){
var inst_72504 = (state_72557[(7)]);
var state_72557__$1 = state_72557;
var statearr_72562_72638 = state_72557__$1;
(statearr_72562_72638[(2)] = inst_72504);

(statearr_72562_72638[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (1))){
var state_72557__$1 = state_72557;
var statearr_72563_72639 = state_72557__$1;
(statearr_72563_72639[(2)] = null);

(statearr_72563_72639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (24))){
var inst_72501 = (state_72557[(8)]);
var state_72557__$1 = state_72557;
var statearr_72564_72640 = state_72557__$1;
(statearr_72564_72640[(2)] = inst_72501);

(statearr_72564_72640[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (39))){
var inst_72458 = (state_72557[(9)]);
var inst_72469 = (state_72557[(10)]);
var inst_72491 = (state_72557[(11)]);
var inst_72535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72536 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_72469];
var inst_72537 = (new cljs.core.PersistentVector(null,2,(5),inst_72535,inst_72536,null));
var inst_72538 = cljs.core.assoc_in(inst_72458,inst_72537,inst_72491);
var state_72557__$1 = state_72557;
var statearr_72565_72641 = state_72557__$1;
(statearr_72565_72641[(2)] = inst_72538);

(statearr_72565_72641[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (4))){
var inst_72417 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
var statearr_72566_72642 = state_72557__$1;
(statearr_72566_72642[(2)] = inst_72417);

(statearr_72566_72642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (15))){
var inst_72456 = (state_72557[(12)]);
var inst_72491 = (state_72557[(11)]);
var inst_72494 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_72491);
var inst_72495 = (inst_72456 == null);
var state_72557__$1 = (function (){var statearr_72567 = state_72557;
(statearr_72567[(13)] = inst_72494);

return statearr_72567;
})();
if(cljs.core.truth_(inst_72495)){
var statearr_72568_72643 = state_72557__$1;
(statearr_72568_72643[(1)] = (18));

} else {
var statearr_72569_72644 = state_72557__$1;
(statearr_72569_72644[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (21))){
var inst_72494 = (state_72557[(13)]);
var state_72557__$1 = state_72557;
var statearr_72570_72645 = state_72557__$1;
(statearr_72570_72645[(2)] = inst_72494);

(statearr_72570_72645[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (31))){
var state_72557__$1 = state_72557;
var statearr_72571_72646 = state_72557__$1;
(statearr_72571_72646[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (32))){
var inst_72520 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
var statearr_72573_72647 = state_72557__$1;
(statearr_72573_72647[(2)] = inst_72520);

(statearr_72573_72647[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (40))){
var inst_72489 = (state_72557[(14)]);
var state_72557__$1 = state_72557;
if(cljs.core.truth_(inst_72489)){
var statearr_72574_72648 = state_72557__$1;
(statearr_72574_72648[(1)] = (42));

} else {
var statearr_72575_72649 = state_72557__$1;
(statearr_72575_72649[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (33))){
var inst_72456 = (state_72557[(12)]);
var inst_72494 = (state_72557[(13)]);
var inst_72515 = ((inst_72494 > inst_72456) ? inst_72494 : inst_72456);
var state_72557__$1 = state_72557;
var statearr_72576_72650 = state_72557__$1;
(statearr_72576_72650[(2)] = inst_72515);

(statearr_72576_72650[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (13))){
var inst_72480 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
var statearr_72577_72651 = state_72557__$1;
(statearr_72577_72651[(2)] = inst_72480);

(statearr_72577_72651[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (22))){
var inst_72501 = (state_72557[(8)]);
var inst_72494 = (state_72557[(13)]);
var inst_72501__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_72494);
var state_72557__$1 = (function (){var statearr_72578 = state_72557;
(statearr_72578[(8)] = inst_72501__$1);

return statearr_72578;
})();
if(inst_72501__$1){
var statearr_72579_72652 = state_72557__$1;
(statearr_72579_72652[(1)] = (24));

} else {
var statearr_72580_72653 = state_72557__$1;
(statearr_72580_72653[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (36))){
var inst_72491 = (state_72557[(11)]);
var inst_72457 = (state_72557[(15)]);
var inst_72529 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_72491,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_72530 = (inst_72457 + inst_72529);
var state_72557__$1 = state_72557;
var statearr_72581_72654 = state_72557__$1;
(statearr_72581_72654[(2)] = inst_72530);

(statearr_72581_72654[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (41))){
var inst_72527 = (state_72557[(16)]);
var inst_72533 = (state_72557[(17)]);
var inst_72468 = (state_72557[(18)]);
var inst_72547 = (state_72557[(2)]);
var inst_72455 = inst_72468;
var inst_72456 = inst_72527;
var inst_72457 = inst_72533;
var inst_72458 = inst_72547;
var state_72557__$1 = (function (){var statearr_72582 = state_72557;
(statearr_72582[(9)] = inst_72458);

(statearr_72582[(19)] = inst_72455);

(statearr_72582[(12)] = inst_72456);

(statearr_72582[(15)] = inst_72457);

return statearr_72582;
})();
var statearr_72583_72655 = state_72557__$1;
(statearr_72583_72655[(2)] = null);

(statearr_72583_72655[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (43))){
var inst_72491 = (state_72557[(11)]);
var state_72557__$1 = state_72557;
var statearr_72584_72656 = state_72557__$1;
(statearr_72584_72656[(2)] = inst_72491);

(statearr_72584_72656[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (29))){
var inst_72509 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
var statearr_72585_72657 = state_72557__$1;
(statearr_72585_72657[(2)] = inst_72509);

(statearr_72585_72657[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (44))){
var inst_72458 = (state_72557[(9)]);
var inst_72469 = (state_72557[(10)]);
var inst_72544 = (state_72557[(2)]);
var inst_72545 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_72458,inst_72469,inst_72544);
var state_72557__$1 = state_72557;
var statearr_72586_72658 = state_72557__$1;
(statearr_72586_72658[(2)] = inst_72545);

(statearr_72586_72658[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (6))){
var inst_72455 = (state_72557[(19)]);
var inst_72470 = (state_72557[(20)]);
var inst_72466 = cljs.core.seq(inst_72455);
var inst_72467 = cljs.core.first(inst_72466);
var inst_72468 = cljs.core.next(inst_72466);
var inst_72469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72467,(0),null);
var inst_72470__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72467,(1),null);
var inst_72471 = (inst_72470__$1 == null);
var state_72557__$1 = (function (){var statearr_72587 = state_72557;
(statearr_72587[(18)] = inst_72468);

(statearr_72587[(10)] = inst_72469);

(statearr_72587[(20)] = inst_72470__$1);

return statearr_72587;
})();
if(cljs.core.truth_(inst_72471)){
var statearr_72588_72659 = state_72557__$1;
(statearr_72588_72659[(1)] = (8));

} else {
var statearr_72589_72660 = state_72557__$1;
(statearr_72589_72660[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (28))){
var inst_72456 = (state_72557[(12)]);
var inst_72507 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_72456);
var state_72557__$1 = state_72557;
var statearr_72590_72661 = state_72557__$1;
(statearr_72590_72661[(2)] = inst_72507);

(statearr_72590_72661[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (25))){
var inst_72504 = (state_72557[(7)]);
var inst_72456 = (state_72557[(12)]);
var inst_72504__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_72456);
var state_72557__$1 = (function (){var statearr_72591 = state_72557;
(statearr_72591[(7)] = inst_72504__$1);

return statearr_72591;
})();
if(inst_72504__$1){
var statearr_72592_72662 = state_72557__$1;
(statearr_72592_72662[(1)] = (27));

} else {
var statearr_72593_72663 = state_72557__$1;
(statearr_72593_72663[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (34))){
var state_72557__$1 = state_72557;
var statearr_72594_72664 = state_72557__$1;
(statearr_72594_72664[(2)] = null);

(statearr_72594_72664[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (17))){
var inst_72488 = (state_72557[(21)]);
var inst_72527 = (state_72557[(2)]);
var state_72557__$1 = (function (){var statearr_72595 = state_72557;
(statearr_72595[(16)] = inst_72527);

return statearr_72595;
})();
if(cljs.core.truth_(inst_72488)){
var statearr_72596_72665 = state_72557__$1;
(statearr_72596_72665[(1)] = (36));

} else {
var statearr_72597_72666 = state_72557__$1;
(statearr_72597_72666[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (3))){
var inst_72555 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72557__$1,inst_72555);
} else {
if((state_val_72558 === (12))){
var inst_72458 = (state_72557[(9)]);
var state_72557__$1 = state_72557;
var statearr_72598_72667 = state_72557__$1;
(statearr_72598_72667[(2)] = inst_72458);

(statearr_72598_72667[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (2))){
var inst_72432 = (state_72557[(22)]);
var inst_72427 = (state_72557[(23)]);
var inst_72431 = (state_72557[(24)]);
var _ = (function (){var statearr_72599 = state_72557;
(statearr_72599[(4)] = cljs.core.cons((5),(state_72557[(4)])));

return statearr_72599;
})();
var inst_72423 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_72424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72425 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_72426 = (new cljs.core.PersistentVector(null,2,(5),inst_72424,inst_72425,null));
var inst_72427__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_72426);
var inst_72428 = (function (){var global_block = inst_72423;
var global_meta_QMARK_ = inst_72427__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_72429 = cljs.core.PersistentHashMap.EMPTY;
var inst_72430 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_72431__$1 = cljs.core.reduce_kv(inst_72428,inst_72429,inst_72430);
var inst_72432__$1 = fluree.db.util.core.current_time_millis();
var inst_72434 = (function (){var global_block = inst_72423;
var global_meta_QMARK_ = inst_72427__$1;
var queries = inst_72431__$1;
var start_time = inst_72432__$1;
return (function (p__72433){
var vec__72600 = p__72433;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72600,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72600,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_72435 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_72434,inst_72431__$1);
var inst_72449 = cljs.core.seq(inst_72435);
var inst_72450 = cljs.core.first(inst_72449);
var inst_72451 = cljs.core.next(inst_72449);
var inst_72452 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72450,(0),null);
var inst_72453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72450,(1),null);
var inst_72454 = cljs.core.PersistentHashMap.EMPTY;
var inst_72455 = inst_72435;
var inst_72456 = null;
var inst_72457 = (0);
var inst_72458 = inst_72454;
var state_72557__$1 = (function (){var statearr_72603 = state_72557;
(statearr_72603[(25)] = inst_72452);

(statearr_72603[(9)] = inst_72458);

(statearr_72603[(22)] = inst_72432__$1);

(statearr_72603[(26)] = inst_72453);

(statearr_72603[(23)] = inst_72427__$1);

(statearr_72603[(19)] = inst_72455);

(statearr_72603[(27)] = inst_72451);

(statearr_72603[(12)] = inst_72456);

(statearr_72603[(24)] = inst_72431__$1);

(statearr_72603[(15)] = inst_72457);

return statearr_72603;
})();
var statearr_72604_72668 = state_72557__$1;
(statearr_72604_72668[(2)] = null);

(statearr_72604_72668[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (23))){
var inst_72522 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
var statearr_72605_72669 = state_72557__$1;
(statearr_72605_72669[(2)] = inst_72522);

(statearr_72605_72669[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (35))){
var inst_72518 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
var statearr_72606_72670 = state_72557__$1;
(statearr_72606_72670[(2)] = inst_72518);

(statearr_72606_72670[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (19))){
var inst_72456 = (state_72557[(12)]);
var inst_72494 = (state_72557[(13)]);
var inst_72498 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72456,inst_72494);
var state_72557__$1 = state_72557;
if(inst_72498){
var statearr_72607_72671 = state_72557__$1;
(statearr_72607_72671[(1)] = (21));

} else {
var statearr_72608_72672 = state_72557__$1;
(statearr_72608_72672[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (11))){
var inst_72458 = (state_72557[(9)]);
var inst_72432 = (state_72557[(22)]);
var inst_72456 = (state_72557[(12)]);
var inst_72457 = (state_72557[(15)]);
var inst_72474 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_72475 = fluree.db.util.core.response_time_formatted(inst_72432);
var inst_72476 = [inst_72458,inst_72457,inst_72456,inst_72475];
var inst_72477 = cljs.core.PersistentHashMap.fromArrays(inst_72474,inst_72476);
var state_72557__$1 = state_72557;
var statearr_72610_72673 = state_72557__$1;
(statearr_72610_72673[(2)] = inst_72477);

(statearr_72610_72673[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (9))){
var inst_72469 = (state_72557[(10)]);
var inst_72470 = (state_72557[(20)]);
var inst_72431 = (state_72557[(24)]);
var inst_72483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72484 = [inst_72469,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_72485 = (new cljs.core.PersistentVector(null,2,(5),inst_72483,inst_72484,null));
var inst_72486 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72431,inst_72485);
var inst_72487 = cljs.core.__destructure_map(inst_72486);
var inst_72488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72487,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_72489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72487,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_72557__$1 = (function (){var statearr_72611 = state_72557;
(statearr_72611[(14)] = inst_72489);

(statearr_72611[(21)] = inst_72488);

return statearr_72611;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72557__$1,(14),inst_72470);
} else {
if((state_val_72558 === (5))){
var _ = (function (){var statearr_72612 = state_72557;
(statearr_72612[(4)] = cljs.core.rest((state_72557[(4)])));

return statearr_72612;
})();
var state_72557__$1 = state_72557;
var ex72609 = (state_72557__$1[(2)]);
var statearr_72613_72674 = state_72557__$1;
(statearr_72613_72674[(5)] = ex72609);


var statearr_72614_72675 = state_72557__$1;
(statearr_72614_72675[(1)] = (4));

(statearr_72614_72675[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (14))){
var inst_72488 = (state_72557[(21)]);
var inst_72491 = (state_72557[(11)]);
var inst_72491__$1 = (state_72557[(2)]);
var inst_72492 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_72491__$1);
var state_72557__$1 = (function (){var statearr_72615 = state_72557;
(statearr_72615[(28)] = inst_72492);

(statearr_72615[(11)] = inst_72491__$1);

return statearr_72615;
})();
if(cljs.core.truth_(inst_72488)){
var statearr_72616_72676 = state_72557__$1;
(statearr_72616_72676[(1)] = (15));

} else {
var statearr_72617_72677 = state_72557__$1;
(statearr_72617_72677[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (26))){
var inst_72511 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
if(cljs.core.truth_(inst_72511)){
var statearr_72618_72678 = state_72557__$1;
(statearr_72618_72678[(1)] = (30));

} else {
var statearr_72619_72679 = state_72557__$1;
(statearr_72619_72679[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (16))){
var state_72557__$1 = state_72557;
var statearr_72620_72680 = state_72557__$1;
(statearr_72620_72680[(2)] = null);

(statearr_72620_72680[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (38))){
var inst_72492 = (state_72557[(28)]);
var inst_72533 = (state_72557[(2)]);
var state_72557__$1 = (function (){var statearr_72621 = state_72557;
(statearr_72621[(17)] = inst_72533);

return statearr_72621;
})();
if(cljs.core.truth_(inst_72492)){
var statearr_72622_72681 = state_72557__$1;
(statearr_72622_72681[(1)] = (39));

} else {
var statearr_72623_72682 = state_72557__$1;
(statearr_72623_72682[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (30))){
var state_72557__$1 = state_72557;
var statearr_72624_72683 = state_72557__$1;
(statearr_72624_72683[(2)] = (207));

(statearr_72624_72683[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (10))){
var inst_72550 = (state_72557[(2)]);
var state_72557__$1 = state_72557;
var statearr_72625_72684 = state_72557__$1;
(statearr_72625_72684[(2)] = inst_72550);

(statearr_72625_72684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (18))){
var inst_72494 = (state_72557[(13)]);
var state_72557__$1 = state_72557;
var statearr_72626_72685 = state_72557__$1;
(statearr_72626_72685[(2)] = inst_72494);

(statearr_72626_72685[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (42))){
var inst_72491 = (state_72557[(11)]);
var inst_72541 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_72491);
var state_72557__$1 = state_72557;
var statearr_72627_72686 = state_72557__$1;
(statearr_72627_72686[(2)] = inst_72541);

(statearr_72627_72686[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (37))){
var state_72557__$1 = state_72557;
var statearr_72628_72687 = state_72557__$1;
(statearr_72628_72687[(2)] = null);

(statearr_72628_72687[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72558 === (8))){
var inst_72427 = (state_72557[(23)]);
var state_72557__$1 = state_72557;
if(cljs.core.truth_(inst_72427)){
var statearr_72629_72688 = state_72557__$1;
(statearr_72629_72688[(1)] = (11));

} else {
var statearr_72630_72689 = state_72557__$1;
(statearr_72630_72689[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_72631 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72631[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__);

(statearr_72631[(1)] = (1));

return statearr_72631;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1 = (function (state_72557){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72557);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72632){var ex__2687__auto__ = e72632;
var statearr_72633_72690 = state_72557;
(statearr_72633_72690[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72557[(4)]))){
var statearr_72634_72691 = state_72557;
(statearr_72634_72691[(1)] = cljs.core.first((state_72557[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72692 = state_72557;
state_72557 = G__72692;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = function(state_72557){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1.call(this,state_72557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72635 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72635[(6)] = c__2706__auto__);

return statearr_72635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__72693 = query_type;
var G__72693__$1 = (((G__72693 instanceof cljs.core.Keyword))?G__72693.fqn:null);
switch (G__72693__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__72693__$1)].join('')));

}
});
