// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__5828){
var vec__5829 = p__5828;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5829,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5829,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5832 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5832,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5832,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5832,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5832,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5832,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5804__auto__)){
var name__$1 = temp__5804__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5835 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5835,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5835,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5835,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5835,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5835,(4),null);
var vec__5838 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5838,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5838,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5838,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5838,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5838,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__5045__auto__ = source;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__5045__auto__ = line;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__5045__auto__ = col;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5841 = segmap;
var map__5841__$1 = cljs.core.__destructure_map(map__5841);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5841__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5841__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5841__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5841__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5841__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5843 = arguments.length;
switch (G__5843) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5847 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5851 = cljs.core.next(segs__$1);
var G__5852 = nrelseg;
var G__5853 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5851;
relseg__$1 = G__5852;
result__$1 = G__5853;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5847,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5847,(1),null);
var G__5854 = (gline + (1));
var G__5855 = cljs.core.next(lines__$1);
var G__5856 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5857 = result__$1;
gline = G__5854;
lines__$1 = G__5855;
relseg = G__5856;
result = G__5857;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5859 = segmap;
var map__5859__$1 = cljs.core.__destructure_map(map__5859);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5859__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5859__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5859__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5859__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5859__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__5858_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__5858_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5861 = arguments.length;
switch (G__5861) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5865 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5869 = cljs.core.next(segs__$1);
var G__5870 = nrelseg;
var G__5871 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5869;
relseg__$1 = G__5870;
result__$1 = G__5871;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5865,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5865,(1),null);
var G__5872 = (gline + (1));
var G__5873 = cljs.core.next(lines__$1);
var G__5874 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5875 = result__$1;
gline = G__5872;
lines__$1 = G__5873;
relseg = G__5874;
result = G__5875;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5876){
var vec__5877 = p__5876;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5877,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5877,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5877,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5877,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5877,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__5880){
var vec__5881 = p__5880;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5881,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5881,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5881,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5881,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5881,(4),null);
var seg = vec__5881;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5884){
var vec__5885 = p__5884;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5885,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5885,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5885,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5885,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5885,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5802__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5802__auto__)){
var name = temp__5802__auto__;
var idx = (function (){var temp__5802__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5802__auto____$1)){
var idx = temp__5802__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5891 = cljs.core.seq(infos);
var chunk__5892 = null;
var count__5893 = (0);
var i__5894 = (0);
while(true){
if((i__5894 < count__5893)){
var info = chunk__5892.cljs$core$IIndexed$_nth$arity$2(null,i__5894);
var segv_6248 = info__GT_segv(info,source_idx,line,col);
var gline_6249 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6250 = cljs.core.count(cljs.core.deref(lines));
if((gline_6249 > (lc_6250 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5891,chunk__5892,count__5893,i__5894,segv_6248,gline_6249,lc_6250,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6249 - (lc_6250 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6248], null));
});})(seq__5891,chunk__5892,count__5893,i__5894,segv_6248,gline_6249,lc_6250,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5891,chunk__5892,count__5893,i__5894,segv_6248,gline_6249,lc_6250,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6249], null),cljs.core.conj,segv_6248);
});})(seq__5891,chunk__5892,count__5893,i__5894,segv_6248,gline_6249,lc_6250,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6251 = seq__5891;
var G__6252 = chunk__5892;
var G__6253 = count__5893;
var G__6254 = (i__5894 + (1));
seq__5891 = G__6251;
chunk__5892 = G__6252;
count__5893 = G__6253;
i__5894 = G__6254;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__5891);
if(temp__5804__auto__){
var seq__5891__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5891__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__5891__$1);
var G__6255 = cljs.core.chunk_rest(seq__5891__$1);
var G__6256 = c__5568__auto__;
var G__6257 = cljs.core.count(c__5568__auto__);
var G__6258 = (0);
seq__5891 = G__6255;
chunk__5892 = G__6256;
count__5893 = G__6257;
i__5894 = G__6258;
continue;
} else {
var info = cljs.core.first(seq__5891__$1);
var segv_6259 = info__GT_segv(info,source_idx,line,col);
var gline_6260 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6261 = cljs.core.count(cljs.core.deref(lines));
if((gline_6260 > (lc_6261 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5891,chunk__5892,count__5893,i__5894,segv_6259,gline_6260,lc_6261,info,seq__5891__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6260 - (lc_6261 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6259], null));
});})(seq__5891,chunk__5892,count__5893,i__5894,segv_6259,gline_6260,lc_6261,info,seq__5891__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5891,chunk__5892,count__5893,i__5894,segv_6259,gline_6260,lc_6261,info,seq__5891__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6260], null),cljs.core.conj,segv_6259);
});})(seq__5891,chunk__5892,count__5893,i__5894,segv_6259,gline_6260,lc_6261,info,seq__5891__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6262 = cljs.core.next(seq__5891__$1);
var G__6263 = null;
var G__6264 = (0);
var G__6265 = (0);
seq__5891 = G__6262;
chunk__5892 = G__6263;
count__5893 = G__6264;
i__5894 = G__6265;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5895_6266 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5896_6267 = null;
var count__5897_6268 = (0);
var i__5898_6269 = (0);
while(true){
if((i__5898_6269 < count__5897_6268)){
var vec__6071_6270 = chunk__5896_6267.cljs$core$IIndexed$_nth$arity$2(null,i__5898_6269);
var source_idx_6271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6071_6270,(0),null);
var vec__6074_6272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6071_6270,(1),null);
var __6273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6074_6272,(0),null);
var lines_6274__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6074_6272,(1),null);
var seq__6077_6275 = cljs.core.seq(lines_6274__$1);
var chunk__6078_6276 = null;
var count__6079_6277 = (0);
var i__6080_6278 = (0);
while(true){
if((i__6080_6278 < count__6079_6277)){
var vec__6119_6279 = chunk__6078_6276.cljs$core$IIndexed$_nth$arity$2(null,i__6080_6278);
var line_6280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6119_6279,(0),null);
var cols_6281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6119_6279,(1),null);
var seq__6122_6282 = cljs.core.seq(cols_6281);
var chunk__6123_6283 = null;
var count__6124_6284 = (0);
var i__6125_6285 = (0);
while(true){
if((i__6125_6285 < count__6124_6284)){
var vec__6132_6286 = chunk__6123_6283.cljs$core$IIndexed$_nth$arity$2(null,i__6125_6285);
var col_6287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6132_6286,(0),null);
var infos_6288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6132_6286,(1),null);
encode_cols(infos_6288,source_idx_6271,line_6280,col_6287);


var G__6289 = seq__6122_6282;
var G__6290 = chunk__6123_6283;
var G__6291 = count__6124_6284;
var G__6292 = (i__6125_6285 + (1));
seq__6122_6282 = G__6289;
chunk__6123_6283 = G__6290;
count__6124_6284 = G__6291;
i__6125_6285 = G__6292;
continue;
} else {
var temp__5804__auto___6293 = cljs.core.seq(seq__6122_6282);
if(temp__5804__auto___6293){
var seq__6122_6294__$1 = temp__5804__auto___6293;
if(cljs.core.chunked_seq_QMARK_(seq__6122_6294__$1)){
var c__5568__auto___6295 = cljs.core.chunk_first(seq__6122_6294__$1);
var G__6296 = cljs.core.chunk_rest(seq__6122_6294__$1);
var G__6297 = c__5568__auto___6295;
var G__6298 = cljs.core.count(c__5568__auto___6295);
var G__6299 = (0);
seq__6122_6282 = G__6296;
chunk__6123_6283 = G__6297;
count__6124_6284 = G__6298;
i__6125_6285 = G__6299;
continue;
} else {
var vec__6135_6300 = cljs.core.first(seq__6122_6294__$1);
var col_6301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6135_6300,(0),null);
var infos_6302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6135_6300,(1),null);
encode_cols(infos_6302,source_idx_6271,line_6280,col_6301);


var G__6303 = cljs.core.next(seq__6122_6294__$1);
var G__6304 = null;
var G__6305 = (0);
var G__6306 = (0);
seq__6122_6282 = G__6303;
chunk__6123_6283 = G__6304;
count__6124_6284 = G__6305;
i__6125_6285 = G__6306;
continue;
}
} else {
}
}
break;
}


var G__6307 = seq__6077_6275;
var G__6308 = chunk__6078_6276;
var G__6309 = count__6079_6277;
var G__6310 = (i__6080_6278 + (1));
seq__6077_6275 = G__6307;
chunk__6078_6276 = G__6308;
count__6079_6277 = G__6309;
i__6080_6278 = G__6310;
continue;
} else {
var temp__5804__auto___6311 = cljs.core.seq(seq__6077_6275);
if(temp__5804__auto___6311){
var seq__6077_6312__$1 = temp__5804__auto___6311;
if(cljs.core.chunked_seq_QMARK_(seq__6077_6312__$1)){
var c__5568__auto___6313 = cljs.core.chunk_first(seq__6077_6312__$1);
var G__6314 = cljs.core.chunk_rest(seq__6077_6312__$1);
var G__6315 = c__5568__auto___6313;
var G__6316 = cljs.core.count(c__5568__auto___6313);
var G__6317 = (0);
seq__6077_6275 = G__6314;
chunk__6078_6276 = G__6315;
count__6079_6277 = G__6316;
i__6080_6278 = G__6317;
continue;
} else {
var vec__6138_6318 = cljs.core.first(seq__6077_6312__$1);
var line_6319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6138_6318,(0),null);
var cols_6320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6138_6318,(1),null);
var seq__6141_6321 = cljs.core.seq(cols_6320);
var chunk__6142_6322 = null;
var count__6143_6323 = (0);
var i__6144_6324 = (0);
while(true){
if((i__6144_6324 < count__6143_6323)){
var vec__6151_6325 = chunk__6142_6322.cljs$core$IIndexed$_nth$arity$2(null,i__6144_6324);
var col_6326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6151_6325,(0),null);
var infos_6327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6151_6325,(1),null);
encode_cols(infos_6327,source_idx_6271,line_6319,col_6326);


var G__6328 = seq__6141_6321;
var G__6329 = chunk__6142_6322;
var G__6330 = count__6143_6323;
var G__6331 = (i__6144_6324 + (1));
seq__6141_6321 = G__6328;
chunk__6142_6322 = G__6329;
count__6143_6323 = G__6330;
i__6144_6324 = G__6331;
continue;
} else {
var temp__5804__auto___6332__$1 = cljs.core.seq(seq__6141_6321);
if(temp__5804__auto___6332__$1){
var seq__6141_6333__$1 = temp__5804__auto___6332__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6141_6333__$1)){
var c__5568__auto___6334 = cljs.core.chunk_first(seq__6141_6333__$1);
var G__6335 = cljs.core.chunk_rest(seq__6141_6333__$1);
var G__6336 = c__5568__auto___6334;
var G__6337 = cljs.core.count(c__5568__auto___6334);
var G__6338 = (0);
seq__6141_6321 = G__6335;
chunk__6142_6322 = G__6336;
count__6143_6323 = G__6337;
i__6144_6324 = G__6338;
continue;
} else {
var vec__6154_6339 = cljs.core.first(seq__6141_6333__$1);
var col_6340 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6154_6339,(0),null);
var infos_6341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6154_6339,(1),null);
encode_cols(infos_6341,source_idx_6271,line_6319,col_6340);


var G__6342 = cljs.core.next(seq__6141_6333__$1);
var G__6343 = null;
var G__6344 = (0);
var G__6345 = (0);
seq__6141_6321 = G__6342;
chunk__6142_6322 = G__6343;
count__6143_6323 = G__6344;
i__6144_6324 = G__6345;
continue;
}
} else {
}
}
break;
}


var G__6346 = cljs.core.next(seq__6077_6312__$1);
var G__6347 = null;
var G__6348 = (0);
var G__6349 = (0);
seq__6077_6275 = G__6346;
chunk__6078_6276 = G__6347;
count__6079_6277 = G__6348;
i__6080_6278 = G__6349;
continue;
}
} else {
}
}
break;
}


var G__6350 = seq__5895_6266;
var G__6351 = chunk__5896_6267;
var G__6352 = count__5897_6268;
var G__6353 = (i__5898_6269 + (1));
seq__5895_6266 = G__6350;
chunk__5896_6267 = G__6351;
count__5897_6268 = G__6352;
i__5898_6269 = G__6353;
continue;
} else {
var temp__5804__auto___6354 = cljs.core.seq(seq__5895_6266);
if(temp__5804__auto___6354){
var seq__5895_6355__$1 = temp__5804__auto___6354;
if(cljs.core.chunked_seq_QMARK_(seq__5895_6355__$1)){
var c__5568__auto___6356 = cljs.core.chunk_first(seq__5895_6355__$1);
var G__6357 = cljs.core.chunk_rest(seq__5895_6355__$1);
var G__6358 = c__5568__auto___6356;
var G__6359 = cljs.core.count(c__5568__auto___6356);
var G__6360 = (0);
seq__5895_6266 = G__6357;
chunk__5896_6267 = G__6358;
count__5897_6268 = G__6359;
i__5898_6269 = G__6360;
continue;
} else {
var vec__6157_6361 = cljs.core.first(seq__5895_6355__$1);
var source_idx_6362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6157_6361,(0),null);
var vec__6160_6363 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6157_6361,(1),null);
var __6364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6160_6363,(0),null);
var lines_6365__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6160_6363,(1),null);
var seq__6163_6366 = cljs.core.seq(lines_6365__$1);
var chunk__6164_6367 = null;
var count__6165_6368 = (0);
var i__6166_6369 = (0);
while(true){
if((i__6166_6369 < count__6165_6368)){
var vec__6205_6370 = chunk__6164_6367.cljs$core$IIndexed$_nth$arity$2(null,i__6166_6369);
var line_6371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6205_6370,(0),null);
var cols_6372 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6205_6370,(1),null);
var seq__6208_6373 = cljs.core.seq(cols_6372);
var chunk__6209_6374 = null;
var count__6210_6375 = (0);
var i__6211_6376 = (0);
while(true){
if((i__6211_6376 < count__6210_6375)){
var vec__6218_6377 = chunk__6209_6374.cljs$core$IIndexed$_nth$arity$2(null,i__6211_6376);
var col_6378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6218_6377,(0),null);
var infos_6379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6218_6377,(1),null);
encode_cols(infos_6379,source_idx_6362,line_6371,col_6378);


var G__6380 = seq__6208_6373;
var G__6381 = chunk__6209_6374;
var G__6382 = count__6210_6375;
var G__6383 = (i__6211_6376 + (1));
seq__6208_6373 = G__6380;
chunk__6209_6374 = G__6381;
count__6210_6375 = G__6382;
i__6211_6376 = G__6383;
continue;
} else {
var temp__5804__auto___6384__$1 = cljs.core.seq(seq__6208_6373);
if(temp__5804__auto___6384__$1){
var seq__6208_6385__$1 = temp__5804__auto___6384__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6208_6385__$1)){
var c__5568__auto___6386 = cljs.core.chunk_first(seq__6208_6385__$1);
var G__6387 = cljs.core.chunk_rest(seq__6208_6385__$1);
var G__6388 = c__5568__auto___6386;
var G__6389 = cljs.core.count(c__5568__auto___6386);
var G__6390 = (0);
seq__6208_6373 = G__6387;
chunk__6209_6374 = G__6388;
count__6210_6375 = G__6389;
i__6211_6376 = G__6390;
continue;
} else {
var vec__6221_6391 = cljs.core.first(seq__6208_6385__$1);
var col_6392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6221_6391,(0),null);
var infos_6393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6221_6391,(1),null);
encode_cols(infos_6393,source_idx_6362,line_6371,col_6392);


var G__6394 = cljs.core.next(seq__6208_6385__$1);
var G__6395 = null;
var G__6396 = (0);
var G__6397 = (0);
seq__6208_6373 = G__6394;
chunk__6209_6374 = G__6395;
count__6210_6375 = G__6396;
i__6211_6376 = G__6397;
continue;
}
} else {
}
}
break;
}


var G__6398 = seq__6163_6366;
var G__6399 = chunk__6164_6367;
var G__6400 = count__6165_6368;
var G__6401 = (i__6166_6369 + (1));
seq__6163_6366 = G__6398;
chunk__6164_6367 = G__6399;
count__6165_6368 = G__6400;
i__6166_6369 = G__6401;
continue;
} else {
var temp__5804__auto___6402__$1 = cljs.core.seq(seq__6163_6366);
if(temp__5804__auto___6402__$1){
var seq__6163_6403__$1 = temp__5804__auto___6402__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6163_6403__$1)){
var c__5568__auto___6404 = cljs.core.chunk_first(seq__6163_6403__$1);
var G__6405 = cljs.core.chunk_rest(seq__6163_6403__$1);
var G__6406 = c__5568__auto___6404;
var G__6407 = cljs.core.count(c__5568__auto___6404);
var G__6408 = (0);
seq__6163_6366 = G__6405;
chunk__6164_6367 = G__6406;
count__6165_6368 = G__6407;
i__6166_6369 = G__6408;
continue;
} else {
var vec__6224_6409 = cljs.core.first(seq__6163_6403__$1);
var line_6410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6224_6409,(0),null);
var cols_6411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6224_6409,(1),null);
var seq__6227_6412 = cljs.core.seq(cols_6411);
var chunk__6228_6413 = null;
var count__6229_6414 = (0);
var i__6230_6415 = (0);
while(true){
if((i__6230_6415 < count__6229_6414)){
var vec__6237_6416 = chunk__6228_6413.cljs$core$IIndexed$_nth$arity$2(null,i__6230_6415);
var col_6417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6237_6416,(0),null);
var infos_6418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6237_6416,(1),null);
encode_cols(infos_6418,source_idx_6362,line_6410,col_6417);


var G__6419 = seq__6227_6412;
var G__6420 = chunk__6228_6413;
var G__6421 = count__6229_6414;
var G__6422 = (i__6230_6415 + (1));
seq__6227_6412 = G__6419;
chunk__6228_6413 = G__6420;
count__6229_6414 = G__6421;
i__6230_6415 = G__6422;
continue;
} else {
var temp__5804__auto___6423__$2 = cljs.core.seq(seq__6227_6412);
if(temp__5804__auto___6423__$2){
var seq__6227_6424__$1 = temp__5804__auto___6423__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6227_6424__$1)){
var c__5568__auto___6425 = cljs.core.chunk_first(seq__6227_6424__$1);
var G__6426 = cljs.core.chunk_rest(seq__6227_6424__$1);
var G__6427 = c__5568__auto___6425;
var G__6428 = cljs.core.count(c__5568__auto___6425);
var G__6429 = (0);
seq__6227_6412 = G__6426;
chunk__6228_6413 = G__6427;
count__6229_6414 = G__6428;
i__6230_6415 = G__6429;
continue;
} else {
var vec__6240_6430 = cljs.core.first(seq__6227_6424__$1);
var col_6431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6240_6430,(0),null);
var infos_6432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6240_6430,(1),null);
encode_cols(infos_6432,source_idx_6362,line_6410,col_6431);


var G__6433 = cljs.core.next(seq__6227_6424__$1);
var G__6434 = null;
var G__6435 = (0);
var G__6436 = (0);
seq__6227_6412 = G__6433;
chunk__6228_6413 = G__6434;
count__6229_6414 = G__6435;
i__6230_6415 = G__6436;
continue;
}
} else {
}
}
break;
}


var G__6437 = cljs.core.next(seq__6163_6403__$1);
var G__6438 = null;
var G__6439 = (0);
var G__6440 = (0);
seq__6163_6366 = G__6437;
chunk__6164_6367 = G__6438;
count__6165_6368 = G__6439;
i__6166_6369 = G__6440;
continue;
}
} else {
}
}
break;
}


var G__6441 = cljs.core.next(seq__5895_6355__$1);
var G__6442 = null;
var G__6443 = (0);
var G__6444 = (0);
seq__5895_6266 = G__6441;
chunk__5896_6267 = G__6442;
count__5897_6268 = G__6443;
i__5898_6269 = G__6444;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__6243 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5888_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5888_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5889_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__5889_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__5890_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__5890_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__6244 = G__6243;
var G__6245_6445 = G__6244;
var G__6246_6446 = "sourcesContent";
var G__6247_6447 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
cljs.source_map.goog$module$goog$object.set.call(null,G__6245_6445,G__6246_6446,G__6247_6447);

return G__6244;
} else {
return G__6243;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__6448 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6448,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6448,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__6451 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6451,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6451,(1),null);
var G__6456 = cljs.core.next(col_map_seq);
var G__6457 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6451,col,infos,vec__6448,line,col_map){
return (function (v,p__6454){
var map__6455 = p__6454;
var map__6455__$1 = cljs.core.__destructure_map(map__6455);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6455__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6455__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6451,col,infos,vec__6448,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6456;
new_cols = G__6457;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6458 = cljs.core.next(line_map_seq);
var G__6459 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__6458;
new_lines = G__6459;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__6460_6668 = cljs.core.seq(reverse_map);
var chunk__6461_6669 = null;
var count__6462_6670 = (0);
var i__6463_6671 = (0);
while(true){
if((i__6463_6671 < count__6462_6670)){
var vec__6566_6672 = chunk__6461_6669.cljs$core$IIndexed$_nth$arity$2(null,i__6463_6671);
var line_6673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6566_6672,(0),null);
var columns_6674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6566_6672,(1),null);
var seq__6569_6675 = cljs.core.seq(columns_6674);
var chunk__6570_6676 = null;
var count__6571_6677 = (0);
var i__6572_6678 = (0);
while(true){
if((i__6572_6678 < count__6571_6677)){
var vec__6595_6679 = chunk__6570_6676.cljs$core$IIndexed$_nth$arity$2(null,i__6572_6678);
var column_6680 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6595_6679,(0),null);
var column_info_6681 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6595_6679,(1),null);
var seq__6598_6682 = cljs.core.seq(column_info_6681);
var chunk__6599_6683 = null;
var count__6600_6684 = (0);
var i__6601_6685 = (0);
while(true){
if((i__6601_6685 < count__6600_6684)){
var map__6604_6686 = chunk__6599_6683.cljs$core$IIndexed$_nth$arity$2(null,i__6601_6685);
var map__6604_6687__$1 = cljs.core.__destructure_map(map__6604_6686);
var gline_6688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6604_6687__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6689 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6604_6687__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6690 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6604_6687__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6688], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6598_6682,chunk__6599_6683,count__6600_6684,i__6601_6685,seq__6569_6675,chunk__6570_6676,count__6571_6677,i__6572_6678,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6604_6686,map__6604_6687__$1,gline_6688,gcol_6689,name_6690,vec__6595_6679,column_6680,column_info_6681,vec__6566_6672,line_6673,columns_6674,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6689], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6673,new cljs.core.Keyword(null,"col","col",-1959363084),column_6680,new cljs.core.Keyword(null,"name","name",1843675177),name_6690], null));
});})(seq__6598_6682,chunk__6599_6683,count__6600_6684,i__6601_6685,seq__6569_6675,chunk__6570_6676,count__6571_6677,i__6572_6678,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6604_6686,map__6604_6687__$1,gline_6688,gcol_6689,name_6690,vec__6595_6679,column_6680,column_info_6681,vec__6566_6672,line_6673,columns_6674,inverted))
,cljs.core.sorted_map()));


var G__6691 = seq__6598_6682;
var G__6692 = chunk__6599_6683;
var G__6693 = count__6600_6684;
var G__6694 = (i__6601_6685 + (1));
seq__6598_6682 = G__6691;
chunk__6599_6683 = G__6692;
count__6600_6684 = G__6693;
i__6601_6685 = G__6694;
continue;
} else {
var temp__5804__auto___6695 = cljs.core.seq(seq__6598_6682);
if(temp__5804__auto___6695){
var seq__6598_6696__$1 = temp__5804__auto___6695;
if(cljs.core.chunked_seq_QMARK_(seq__6598_6696__$1)){
var c__5568__auto___6697 = cljs.core.chunk_first(seq__6598_6696__$1);
var G__6698 = cljs.core.chunk_rest(seq__6598_6696__$1);
var G__6699 = c__5568__auto___6697;
var G__6700 = cljs.core.count(c__5568__auto___6697);
var G__6701 = (0);
seq__6598_6682 = G__6698;
chunk__6599_6683 = G__6699;
count__6600_6684 = G__6700;
i__6601_6685 = G__6701;
continue;
} else {
var map__6605_6702 = cljs.core.first(seq__6598_6696__$1);
var map__6605_6703__$1 = cljs.core.__destructure_map(map__6605_6702);
var gline_6704 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6605_6703__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6705 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6605_6703__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6706 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6605_6703__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6704], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6598_6682,chunk__6599_6683,count__6600_6684,i__6601_6685,seq__6569_6675,chunk__6570_6676,count__6571_6677,i__6572_6678,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6605_6702,map__6605_6703__$1,gline_6704,gcol_6705,name_6706,seq__6598_6696__$1,temp__5804__auto___6695,vec__6595_6679,column_6680,column_info_6681,vec__6566_6672,line_6673,columns_6674,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6705], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6673,new cljs.core.Keyword(null,"col","col",-1959363084),column_6680,new cljs.core.Keyword(null,"name","name",1843675177),name_6706], null));
});})(seq__6598_6682,chunk__6599_6683,count__6600_6684,i__6601_6685,seq__6569_6675,chunk__6570_6676,count__6571_6677,i__6572_6678,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6605_6702,map__6605_6703__$1,gline_6704,gcol_6705,name_6706,seq__6598_6696__$1,temp__5804__auto___6695,vec__6595_6679,column_6680,column_info_6681,vec__6566_6672,line_6673,columns_6674,inverted))
,cljs.core.sorted_map()));


var G__6707 = cljs.core.next(seq__6598_6696__$1);
var G__6708 = null;
var G__6709 = (0);
var G__6710 = (0);
seq__6598_6682 = G__6707;
chunk__6599_6683 = G__6708;
count__6600_6684 = G__6709;
i__6601_6685 = G__6710;
continue;
}
} else {
}
}
break;
}


var G__6711 = seq__6569_6675;
var G__6712 = chunk__6570_6676;
var G__6713 = count__6571_6677;
var G__6714 = (i__6572_6678 + (1));
seq__6569_6675 = G__6711;
chunk__6570_6676 = G__6712;
count__6571_6677 = G__6713;
i__6572_6678 = G__6714;
continue;
} else {
var temp__5804__auto___6715 = cljs.core.seq(seq__6569_6675);
if(temp__5804__auto___6715){
var seq__6569_6716__$1 = temp__5804__auto___6715;
if(cljs.core.chunked_seq_QMARK_(seq__6569_6716__$1)){
var c__5568__auto___6717 = cljs.core.chunk_first(seq__6569_6716__$1);
var G__6718 = cljs.core.chunk_rest(seq__6569_6716__$1);
var G__6719 = c__5568__auto___6717;
var G__6720 = cljs.core.count(c__5568__auto___6717);
var G__6721 = (0);
seq__6569_6675 = G__6718;
chunk__6570_6676 = G__6719;
count__6571_6677 = G__6720;
i__6572_6678 = G__6721;
continue;
} else {
var vec__6606_6722 = cljs.core.first(seq__6569_6716__$1);
var column_6723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6606_6722,(0),null);
var column_info_6724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6606_6722,(1),null);
var seq__6609_6725 = cljs.core.seq(column_info_6724);
var chunk__6610_6726 = null;
var count__6611_6727 = (0);
var i__6612_6728 = (0);
while(true){
if((i__6612_6728 < count__6611_6727)){
var map__6615_6729 = chunk__6610_6726.cljs$core$IIndexed$_nth$arity$2(null,i__6612_6728);
var map__6615_6730__$1 = cljs.core.__destructure_map(map__6615_6729);
var gline_6731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6615_6730__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6615_6730__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6615_6730__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6731], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6609_6725,chunk__6610_6726,count__6611_6727,i__6612_6728,seq__6569_6675,chunk__6570_6676,count__6571_6677,i__6572_6678,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6615_6729,map__6615_6730__$1,gline_6731,gcol_6732,name_6733,vec__6606_6722,column_6723,column_info_6724,seq__6569_6716__$1,temp__5804__auto___6715,vec__6566_6672,line_6673,columns_6674,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6732], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6673,new cljs.core.Keyword(null,"col","col",-1959363084),column_6723,new cljs.core.Keyword(null,"name","name",1843675177),name_6733], null));
});})(seq__6609_6725,chunk__6610_6726,count__6611_6727,i__6612_6728,seq__6569_6675,chunk__6570_6676,count__6571_6677,i__6572_6678,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6615_6729,map__6615_6730__$1,gline_6731,gcol_6732,name_6733,vec__6606_6722,column_6723,column_info_6724,seq__6569_6716__$1,temp__5804__auto___6715,vec__6566_6672,line_6673,columns_6674,inverted))
,cljs.core.sorted_map()));


var G__6734 = seq__6609_6725;
var G__6735 = chunk__6610_6726;
var G__6736 = count__6611_6727;
var G__6737 = (i__6612_6728 + (1));
seq__6609_6725 = G__6734;
chunk__6610_6726 = G__6735;
count__6611_6727 = G__6736;
i__6612_6728 = G__6737;
continue;
} else {
var temp__5804__auto___6738__$1 = cljs.core.seq(seq__6609_6725);
if(temp__5804__auto___6738__$1){
var seq__6609_6739__$1 = temp__5804__auto___6738__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6609_6739__$1)){
var c__5568__auto___6740 = cljs.core.chunk_first(seq__6609_6739__$1);
var G__6741 = cljs.core.chunk_rest(seq__6609_6739__$1);
var G__6742 = c__5568__auto___6740;
var G__6743 = cljs.core.count(c__5568__auto___6740);
var G__6744 = (0);
seq__6609_6725 = G__6741;
chunk__6610_6726 = G__6742;
count__6611_6727 = G__6743;
i__6612_6728 = G__6744;
continue;
} else {
var map__6616_6745 = cljs.core.first(seq__6609_6739__$1);
var map__6616_6746__$1 = cljs.core.__destructure_map(map__6616_6745);
var gline_6747 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6616_6746__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6748 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6616_6746__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6616_6746__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6747], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6609_6725,chunk__6610_6726,count__6611_6727,i__6612_6728,seq__6569_6675,chunk__6570_6676,count__6571_6677,i__6572_6678,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6616_6745,map__6616_6746__$1,gline_6747,gcol_6748,name_6749,seq__6609_6739__$1,temp__5804__auto___6738__$1,vec__6606_6722,column_6723,column_info_6724,seq__6569_6716__$1,temp__5804__auto___6715,vec__6566_6672,line_6673,columns_6674,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6748], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6673,new cljs.core.Keyword(null,"col","col",-1959363084),column_6723,new cljs.core.Keyword(null,"name","name",1843675177),name_6749], null));
});})(seq__6609_6725,chunk__6610_6726,count__6611_6727,i__6612_6728,seq__6569_6675,chunk__6570_6676,count__6571_6677,i__6572_6678,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6616_6745,map__6616_6746__$1,gline_6747,gcol_6748,name_6749,seq__6609_6739__$1,temp__5804__auto___6738__$1,vec__6606_6722,column_6723,column_info_6724,seq__6569_6716__$1,temp__5804__auto___6715,vec__6566_6672,line_6673,columns_6674,inverted))
,cljs.core.sorted_map()));


var G__6750 = cljs.core.next(seq__6609_6739__$1);
var G__6751 = null;
var G__6752 = (0);
var G__6753 = (0);
seq__6609_6725 = G__6750;
chunk__6610_6726 = G__6751;
count__6611_6727 = G__6752;
i__6612_6728 = G__6753;
continue;
}
} else {
}
}
break;
}


var G__6754 = cljs.core.next(seq__6569_6716__$1);
var G__6755 = null;
var G__6756 = (0);
var G__6757 = (0);
seq__6569_6675 = G__6754;
chunk__6570_6676 = G__6755;
count__6571_6677 = G__6756;
i__6572_6678 = G__6757;
continue;
}
} else {
}
}
break;
}


var G__6758 = seq__6460_6668;
var G__6759 = chunk__6461_6669;
var G__6760 = count__6462_6670;
var G__6761 = (i__6463_6671 + (1));
seq__6460_6668 = G__6758;
chunk__6461_6669 = G__6759;
count__6462_6670 = G__6760;
i__6463_6671 = G__6761;
continue;
} else {
var temp__5804__auto___6762 = cljs.core.seq(seq__6460_6668);
if(temp__5804__auto___6762){
var seq__6460_6763__$1 = temp__5804__auto___6762;
if(cljs.core.chunked_seq_QMARK_(seq__6460_6763__$1)){
var c__5568__auto___6764 = cljs.core.chunk_first(seq__6460_6763__$1);
var G__6765 = cljs.core.chunk_rest(seq__6460_6763__$1);
var G__6766 = c__5568__auto___6764;
var G__6767 = cljs.core.count(c__5568__auto___6764);
var G__6768 = (0);
seq__6460_6668 = G__6765;
chunk__6461_6669 = G__6766;
count__6462_6670 = G__6767;
i__6463_6671 = G__6768;
continue;
} else {
var vec__6617_6769 = cljs.core.first(seq__6460_6763__$1);
var line_6770 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6617_6769,(0),null);
var columns_6771 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6617_6769,(1),null);
var seq__6620_6772 = cljs.core.seq(columns_6771);
var chunk__6621_6773 = null;
var count__6622_6774 = (0);
var i__6623_6775 = (0);
while(true){
if((i__6623_6775 < count__6622_6774)){
var vec__6646_6776 = chunk__6621_6773.cljs$core$IIndexed$_nth$arity$2(null,i__6623_6775);
var column_6777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6646_6776,(0),null);
var column_info_6778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6646_6776,(1),null);
var seq__6649_6779 = cljs.core.seq(column_info_6778);
var chunk__6650_6780 = null;
var count__6651_6781 = (0);
var i__6652_6782 = (0);
while(true){
if((i__6652_6782 < count__6651_6781)){
var map__6655_6783 = chunk__6650_6780.cljs$core$IIndexed$_nth$arity$2(null,i__6652_6782);
var map__6655_6784__$1 = cljs.core.__destructure_map(map__6655_6783);
var gline_6785 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6655_6784__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6786 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6655_6784__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6787 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6655_6784__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6785], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6649_6779,chunk__6650_6780,count__6651_6781,i__6652_6782,seq__6620_6772,chunk__6621_6773,count__6622_6774,i__6623_6775,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6655_6783,map__6655_6784__$1,gline_6785,gcol_6786,name_6787,vec__6646_6776,column_6777,column_info_6778,vec__6617_6769,line_6770,columns_6771,seq__6460_6763__$1,temp__5804__auto___6762,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6786], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6770,new cljs.core.Keyword(null,"col","col",-1959363084),column_6777,new cljs.core.Keyword(null,"name","name",1843675177),name_6787], null));
});})(seq__6649_6779,chunk__6650_6780,count__6651_6781,i__6652_6782,seq__6620_6772,chunk__6621_6773,count__6622_6774,i__6623_6775,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6655_6783,map__6655_6784__$1,gline_6785,gcol_6786,name_6787,vec__6646_6776,column_6777,column_info_6778,vec__6617_6769,line_6770,columns_6771,seq__6460_6763__$1,temp__5804__auto___6762,inverted))
,cljs.core.sorted_map()));


var G__6788 = seq__6649_6779;
var G__6789 = chunk__6650_6780;
var G__6790 = count__6651_6781;
var G__6791 = (i__6652_6782 + (1));
seq__6649_6779 = G__6788;
chunk__6650_6780 = G__6789;
count__6651_6781 = G__6790;
i__6652_6782 = G__6791;
continue;
} else {
var temp__5804__auto___6792__$1 = cljs.core.seq(seq__6649_6779);
if(temp__5804__auto___6792__$1){
var seq__6649_6793__$1 = temp__5804__auto___6792__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6649_6793__$1)){
var c__5568__auto___6794 = cljs.core.chunk_first(seq__6649_6793__$1);
var G__6795 = cljs.core.chunk_rest(seq__6649_6793__$1);
var G__6796 = c__5568__auto___6794;
var G__6797 = cljs.core.count(c__5568__auto___6794);
var G__6798 = (0);
seq__6649_6779 = G__6795;
chunk__6650_6780 = G__6796;
count__6651_6781 = G__6797;
i__6652_6782 = G__6798;
continue;
} else {
var map__6656_6799 = cljs.core.first(seq__6649_6793__$1);
var map__6656_6800__$1 = cljs.core.__destructure_map(map__6656_6799);
var gline_6801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6656_6800__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6656_6800__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6656_6800__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6801], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6649_6779,chunk__6650_6780,count__6651_6781,i__6652_6782,seq__6620_6772,chunk__6621_6773,count__6622_6774,i__6623_6775,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6656_6799,map__6656_6800__$1,gline_6801,gcol_6802,name_6803,seq__6649_6793__$1,temp__5804__auto___6792__$1,vec__6646_6776,column_6777,column_info_6778,vec__6617_6769,line_6770,columns_6771,seq__6460_6763__$1,temp__5804__auto___6762,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6802], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6770,new cljs.core.Keyword(null,"col","col",-1959363084),column_6777,new cljs.core.Keyword(null,"name","name",1843675177),name_6803], null));
});})(seq__6649_6779,chunk__6650_6780,count__6651_6781,i__6652_6782,seq__6620_6772,chunk__6621_6773,count__6622_6774,i__6623_6775,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6656_6799,map__6656_6800__$1,gline_6801,gcol_6802,name_6803,seq__6649_6793__$1,temp__5804__auto___6792__$1,vec__6646_6776,column_6777,column_info_6778,vec__6617_6769,line_6770,columns_6771,seq__6460_6763__$1,temp__5804__auto___6762,inverted))
,cljs.core.sorted_map()));


var G__6804 = cljs.core.next(seq__6649_6793__$1);
var G__6805 = null;
var G__6806 = (0);
var G__6807 = (0);
seq__6649_6779 = G__6804;
chunk__6650_6780 = G__6805;
count__6651_6781 = G__6806;
i__6652_6782 = G__6807;
continue;
}
} else {
}
}
break;
}


var G__6808 = seq__6620_6772;
var G__6809 = chunk__6621_6773;
var G__6810 = count__6622_6774;
var G__6811 = (i__6623_6775 + (1));
seq__6620_6772 = G__6808;
chunk__6621_6773 = G__6809;
count__6622_6774 = G__6810;
i__6623_6775 = G__6811;
continue;
} else {
var temp__5804__auto___6812__$1 = cljs.core.seq(seq__6620_6772);
if(temp__5804__auto___6812__$1){
var seq__6620_6813__$1 = temp__5804__auto___6812__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6620_6813__$1)){
var c__5568__auto___6814 = cljs.core.chunk_first(seq__6620_6813__$1);
var G__6815 = cljs.core.chunk_rest(seq__6620_6813__$1);
var G__6816 = c__5568__auto___6814;
var G__6817 = cljs.core.count(c__5568__auto___6814);
var G__6818 = (0);
seq__6620_6772 = G__6815;
chunk__6621_6773 = G__6816;
count__6622_6774 = G__6817;
i__6623_6775 = G__6818;
continue;
} else {
var vec__6657_6819 = cljs.core.first(seq__6620_6813__$1);
var column_6820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6657_6819,(0),null);
var column_info_6821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6657_6819,(1),null);
var seq__6660_6822 = cljs.core.seq(column_info_6821);
var chunk__6661_6823 = null;
var count__6662_6824 = (0);
var i__6663_6825 = (0);
while(true){
if((i__6663_6825 < count__6662_6824)){
var map__6666_6826 = chunk__6661_6823.cljs$core$IIndexed$_nth$arity$2(null,i__6663_6825);
var map__6666_6827__$1 = cljs.core.__destructure_map(map__6666_6826);
var gline_6828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6666_6827__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6666_6827__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6666_6827__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6828], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6660_6822,chunk__6661_6823,count__6662_6824,i__6663_6825,seq__6620_6772,chunk__6621_6773,count__6622_6774,i__6623_6775,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6666_6826,map__6666_6827__$1,gline_6828,gcol_6829,name_6830,vec__6657_6819,column_6820,column_info_6821,seq__6620_6813__$1,temp__5804__auto___6812__$1,vec__6617_6769,line_6770,columns_6771,seq__6460_6763__$1,temp__5804__auto___6762,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6829], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6770,new cljs.core.Keyword(null,"col","col",-1959363084),column_6820,new cljs.core.Keyword(null,"name","name",1843675177),name_6830], null));
});})(seq__6660_6822,chunk__6661_6823,count__6662_6824,i__6663_6825,seq__6620_6772,chunk__6621_6773,count__6622_6774,i__6623_6775,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6666_6826,map__6666_6827__$1,gline_6828,gcol_6829,name_6830,vec__6657_6819,column_6820,column_info_6821,seq__6620_6813__$1,temp__5804__auto___6812__$1,vec__6617_6769,line_6770,columns_6771,seq__6460_6763__$1,temp__5804__auto___6762,inverted))
,cljs.core.sorted_map()));


var G__6831 = seq__6660_6822;
var G__6832 = chunk__6661_6823;
var G__6833 = count__6662_6824;
var G__6834 = (i__6663_6825 + (1));
seq__6660_6822 = G__6831;
chunk__6661_6823 = G__6832;
count__6662_6824 = G__6833;
i__6663_6825 = G__6834;
continue;
} else {
var temp__5804__auto___6835__$2 = cljs.core.seq(seq__6660_6822);
if(temp__5804__auto___6835__$2){
var seq__6660_6836__$1 = temp__5804__auto___6835__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6660_6836__$1)){
var c__5568__auto___6837 = cljs.core.chunk_first(seq__6660_6836__$1);
var G__6838 = cljs.core.chunk_rest(seq__6660_6836__$1);
var G__6839 = c__5568__auto___6837;
var G__6840 = cljs.core.count(c__5568__auto___6837);
var G__6841 = (0);
seq__6660_6822 = G__6838;
chunk__6661_6823 = G__6839;
count__6662_6824 = G__6840;
i__6663_6825 = G__6841;
continue;
} else {
var map__6667_6842 = cljs.core.first(seq__6660_6836__$1);
var map__6667_6843__$1 = cljs.core.__destructure_map(map__6667_6842);
var gline_6844 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6667_6843__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6667_6843__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6846 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6667_6843__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6844], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6660_6822,chunk__6661_6823,count__6662_6824,i__6663_6825,seq__6620_6772,chunk__6621_6773,count__6622_6774,i__6623_6775,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6667_6842,map__6667_6843__$1,gline_6844,gcol_6845,name_6846,seq__6660_6836__$1,temp__5804__auto___6835__$2,vec__6657_6819,column_6820,column_info_6821,seq__6620_6813__$1,temp__5804__auto___6812__$1,vec__6617_6769,line_6770,columns_6771,seq__6460_6763__$1,temp__5804__auto___6762,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6845], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6770,new cljs.core.Keyword(null,"col","col",-1959363084),column_6820,new cljs.core.Keyword(null,"name","name",1843675177),name_6846], null));
});})(seq__6660_6822,chunk__6661_6823,count__6662_6824,i__6663_6825,seq__6620_6772,chunk__6621_6773,count__6622_6774,i__6623_6775,seq__6460_6668,chunk__6461_6669,count__6462_6670,i__6463_6671,map__6667_6842,map__6667_6843__$1,gline_6844,gcol_6845,name_6846,seq__6660_6836__$1,temp__5804__auto___6835__$2,vec__6657_6819,column_6820,column_info_6821,seq__6620_6813__$1,temp__5804__auto___6812__$1,vec__6617_6769,line_6770,columns_6771,seq__6460_6763__$1,temp__5804__auto___6762,inverted))
,cljs.core.sorted_map()));


var G__6847 = cljs.core.next(seq__6660_6836__$1);
var G__6848 = null;
var G__6849 = (0);
var G__6850 = (0);
seq__6660_6822 = G__6847;
chunk__6661_6823 = G__6848;
count__6662_6824 = G__6849;
i__6663_6825 = G__6850;
continue;
}
} else {
}
}
break;
}


var G__6851 = cljs.core.next(seq__6620_6813__$1);
var G__6852 = null;
var G__6853 = (0);
var G__6854 = (0);
seq__6620_6772 = G__6851;
chunk__6621_6773 = G__6852;
count__6622_6774 = G__6853;
i__6623_6775 = G__6854;
continue;
}
} else {
}
}
break;
}


var G__6855 = cljs.core.next(seq__6460_6763__$1);
var G__6856 = null;
var G__6857 = (0);
var G__6858 = (0);
seq__6460_6668 = G__6855;
chunk__6461_6669 = G__6856;
count__6462_6670 = G__6857;
i__6463_6671 = G__6858;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
