// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11627 = arguments.length;
switch (G__11627) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11628 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11628 = (function (f,blockable,meta11629){
this.f = f;
this.blockable = blockable;
this.meta11629 = meta11629;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11628.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11630,meta11629__$1){
var self__ = this;
var _11630__$1 = this;
return (new cljs.core.async.t_cljs$core$async11628(self__.f,self__.blockable,meta11629__$1));
}));

(cljs.core.async.t_cljs$core$async11628.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11630){
var self__ = this;
var _11630__$1 = this;
return self__.meta11629;
}));

(cljs.core.async.t_cljs$core$async11628.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11628.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11628.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11628.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11628.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11629","meta11629",-355747278,null)], null);
}));

(cljs.core.async.t_cljs$core$async11628.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11628.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11628");

(cljs.core.async.t_cljs$core$async11628.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async11628");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11628.
 */
cljs.core.async.__GT_t_cljs$core$async11628 = (function cljs$core$async$__GT_t_cljs$core$async11628(f__$1,blockable__$1,meta11629){
return (new cljs.core.async.t_cljs$core$async11628(f__$1,blockable__$1,meta11629));
});

}

return (new cljs.core.async.t_cljs$core$async11628(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11634 = arguments.length;
switch (G__11634) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11637 = arguments.length;
switch (G__11637) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11640 = arguments.length;
switch (G__11640) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_11642 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11642) : fn1.call(null,val_11642));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_11642) : fn1.call(null,val_11642));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11644 = arguments.length;
switch (G__11644) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___11646 = n;
var x_11647 = (0);
while(true){
if((x_11647 < n__5636__auto___11646)){
(a[x_11647] = x_11647);

var G__11648 = (x_11647 + (1));
x_11647 = G__11648;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11649 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11649 = (function (flag,meta11650){
this.flag = flag;
this.meta11650 = meta11650;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11651,meta11650__$1){
var self__ = this;
var _11651__$1 = this;
return (new cljs.core.async.t_cljs$core$async11649(self__.flag,meta11650__$1));
}));

(cljs.core.async.t_cljs$core$async11649.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11651){
var self__ = this;
var _11651__$1 = this;
return self__.meta11650;
}));

(cljs.core.async.t_cljs$core$async11649.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11649.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11649.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11649.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11649.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11650","meta11650",-1897629873,null)], null);
}));

(cljs.core.async.t_cljs$core$async11649.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11649.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11649");

(cljs.core.async.t_cljs$core$async11649.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async11649");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11649.
 */
cljs.core.async.__GT_t_cljs$core$async11649 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11649(flag__$1,meta11650){
return (new cljs.core.async.t_cljs$core$async11649(flag__$1,meta11650));
});

}

return (new cljs.core.async.t_cljs$core$async11649(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11652 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11652 = (function (flag,cb,meta11653){
this.flag = flag;
this.cb = cb;
this.meta11653 = meta11653;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11652.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11654,meta11653__$1){
var self__ = this;
var _11654__$1 = this;
return (new cljs.core.async.t_cljs$core$async11652(self__.flag,self__.cb,meta11653__$1));
}));

(cljs.core.async.t_cljs$core$async11652.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11654){
var self__ = this;
var _11654__$1 = this;
return self__.meta11653;
}));

(cljs.core.async.t_cljs$core$async11652.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11652.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async11652.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11652.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11652.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11653","meta11653",-1087197151,null)], null);
}));

(cljs.core.async.t_cljs$core$async11652.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11652.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11652");

(cljs.core.async.t_cljs$core$async11652.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async11652");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11652.
 */
cljs.core.async.__GT_t_cljs$core$async11652 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11652(flag__$1,cb__$1,meta11653){
return (new cljs.core.async.t_cljs$core$async11652(flag__$1,cb__$1,meta11653));
});

}

return (new cljs.core.async.t_cljs$core$async11652(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11655_SHARP_){
var G__11657 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11655_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11657) : fret.call(null,G__11657));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11656_SHARP_){
var G__11658 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11656_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__11658) : fret.call(null,G__11658));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11659 = (i + (1));
i = G__11659;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___11664 = arguments.length;
var i__5770__auto___11665 = (0);
while(true){
if((i__5770__auto___11665 < len__5769__auto___11664)){
args__5775__auto__.push((arguments[i__5770__auto___11665]));

var G__11666 = (i__5770__auto___11665 + (1));
i__5770__auto___11665 = G__11666;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11662){
var map__11663 = p__11662;
var map__11663__$1 = cljs.core.__destructure_map(map__11663);
var opts = map__11663__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11660){
var G__11661 = cljs.core.first(seq11660);
var seq11660__$1 = cljs.core.next(seq11660);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11661,seq11660__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11668 = arguments.length;
switch (G__11668) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11567__auto___11715 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_11692){
var state_val_11693 = (state_11692[(1)]);
if((state_val_11693 === (7))){
var inst_11688 = (state_11692[(2)]);
var state_11692__$1 = state_11692;
var statearr_11694_11716 = state_11692__$1;
(statearr_11694_11716[(2)] = inst_11688);

(statearr_11694_11716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (1))){
var state_11692__$1 = state_11692;
var statearr_11695_11717 = state_11692__$1;
(statearr_11695_11717[(2)] = null);

(statearr_11695_11717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (4))){
var inst_11671 = (state_11692[(7)]);
var inst_11671__$1 = (state_11692[(2)]);
var inst_11672 = (inst_11671__$1 == null);
var state_11692__$1 = (function (){var statearr_11696 = state_11692;
(statearr_11696[(7)] = inst_11671__$1);

return statearr_11696;
})();
if(cljs.core.truth_(inst_11672)){
var statearr_11697_11718 = state_11692__$1;
(statearr_11697_11718[(1)] = (5));

} else {
var statearr_11698_11719 = state_11692__$1;
(statearr_11698_11719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (13))){
var state_11692__$1 = state_11692;
var statearr_11699_11720 = state_11692__$1;
(statearr_11699_11720[(2)] = null);

(statearr_11699_11720[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (6))){
var inst_11671 = (state_11692[(7)]);
var state_11692__$1 = state_11692;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11692__$1,(11),to,inst_11671);
} else {
if((state_val_11693 === (3))){
var inst_11690 = (state_11692[(2)]);
var state_11692__$1 = state_11692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11692__$1,inst_11690);
} else {
if((state_val_11693 === (12))){
var state_11692__$1 = state_11692;
var statearr_11700_11721 = state_11692__$1;
(statearr_11700_11721[(2)] = null);

(statearr_11700_11721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (2))){
var state_11692__$1 = state_11692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11692__$1,(4),from);
} else {
if((state_val_11693 === (11))){
var inst_11681 = (state_11692[(2)]);
var state_11692__$1 = state_11692;
if(cljs.core.truth_(inst_11681)){
var statearr_11701_11722 = state_11692__$1;
(statearr_11701_11722[(1)] = (12));

} else {
var statearr_11702_11723 = state_11692__$1;
(statearr_11702_11723[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (9))){
var state_11692__$1 = state_11692;
var statearr_11703_11724 = state_11692__$1;
(statearr_11703_11724[(2)] = null);

(statearr_11703_11724[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (5))){
var state_11692__$1 = state_11692;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11704_11725 = state_11692__$1;
(statearr_11704_11725[(1)] = (8));

} else {
var statearr_11705_11726 = state_11692__$1;
(statearr_11705_11726[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (14))){
var inst_11686 = (state_11692[(2)]);
var state_11692__$1 = state_11692;
var statearr_11706_11727 = state_11692__$1;
(statearr_11706_11727[(2)] = inst_11686);

(statearr_11706_11727[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (10))){
var inst_11678 = (state_11692[(2)]);
var state_11692__$1 = state_11692;
var statearr_11707_11728 = state_11692__$1;
(statearr_11707_11728[(2)] = inst_11678);

(statearr_11707_11728[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11693 === (8))){
var inst_11675 = cljs.core.async.close_BANG_(to);
var state_11692__$1 = state_11692;
var statearr_11708_11729 = state_11692__$1;
(statearr_11708_11729[(2)] = inst_11675);

(statearr_11708_11729[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_11709 = [null,null,null,null,null,null,null,null];
(statearr_11709[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_11709[(1)] = (1));

return statearr_11709;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_11692){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_11692);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e11710){var ex__11496__auto__ = e11710;
var statearr_11711_11730 = state_11692;
(statearr_11711_11730[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_11692[(4)]))){
var statearr_11712_11731 = state_11692;
(statearr_11712_11731[(1)] = cljs.core.first((state_11692[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11732 = state_11692;
state_11692 = G__11732;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_11692){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_11692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_11713 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_11713[(6)] = c__11567__auto___11715);

return statearr_11713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__11733){
var vec__11734 = p__11733;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11734,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11734,(1),null);
var job = vec__11734;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11567__auto___11910 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_11741){
var state_val_11742 = (state_11741[(1)]);
if((state_val_11742 === (1))){
var state_11741__$1 = state_11741;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11741__$1,(2),res,v);
} else {
if((state_val_11742 === (2))){
var inst_11738 = (state_11741[(2)]);
var inst_11739 = cljs.core.async.close_BANG_(res);
var state_11741__$1 = (function (){var statearr_11743 = state_11741;
(statearr_11743[(7)] = inst_11738);

return statearr_11743;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_11741__$1,inst_11739);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0 = (function (){
var statearr_11744 = [null,null,null,null,null,null,null,null];
(statearr_11744[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__);

(statearr_11744[(1)] = (1));

return statearr_11744;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1 = (function (state_11741){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_11741);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e11745){var ex__11496__auto__ = e11745;
var statearr_11746_11911 = state_11741;
(statearr_11746_11911[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_11741[(4)]))){
var statearr_11747_11912 = state_11741;
(statearr_11747_11912[(1)] = cljs.core.first((state_11741[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11913 = state_11741;
state_11741 = G__11913;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = function(state_11741){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1.call(this,state_11741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_11748 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_11748[(6)] = c__11567__auto___11910);

return statearr_11748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__11749){
var vec__11750 = p__11749;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11750,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11750,(1),null);
var job = vec__11750;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___11914 = n;
var __11915 = (0);
while(true){
if((__11915 < n__5636__auto___11914)){
var G__11753_11916 = type;
var G__11753_11917__$1 = (((G__11753_11916 instanceof cljs.core.Keyword))?G__11753_11916.fqn:null);
switch (G__11753_11917__$1) {
case "compute":
var c__11567__auto___11919 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11915,c__11567__auto___11919,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async){
return (function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = ((function (__11915,c__11567__auto___11919,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async){
return (function (state_11766){
var state_val_11767 = (state_11766[(1)]);
if((state_val_11767 === (1))){
var state_11766__$1 = state_11766;
var statearr_11768_11920 = state_11766__$1;
(statearr_11768_11920[(2)] = null);

(statearr_11768_11920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11767 === (2))){
var state_11766__$1 = state_11766;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11766__$1,(4),jobs);
} else {
if((state_val_11767 === (3))){
var inst_11764 = (state_11766[(2)]);
var state_11766__$1 = state_11766;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11766__$1,inst_11764);
} else {
if((state_val_11767 === (4))){
var inst_11756 = (state_11766[(2)]);
var inst_11757 = process__$1(inst_11756);
var state_11766__$1 = state_11766;
if(cljs.core.truth_(inst_11757)){
var statearr_11769_11921 = state_11766__$1;
(statearr_11769_11921[(1)] = (5));

} else {
var statearr_11770_11922 = state_11766__$1;
(statearr_11770_11922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11767 === (5))){
var state_11766__$1 = state_11766;
var statearr_11771_11923 = state_11766__$1;
(statearr_11771_11923[(2)] = null);

(statearr_11771_11923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11767 === (6))){
var state_11766__$1 = state_11766;
var statearr_11772_11924 = state_11766__$1;
(statearr_11772_11924[(2)] = null);

(statearr_11772_11924[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11767 === (7))){
var inst_11762 = (state_11766[(2)]);
var state_11766__$1 = state_11766;
var statearr_11773_11925 = state_11766__$1;
(statearr_11773_11925[(2)] = inst_11762);

(statearr_11773_11925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11915,c__11567__auto___11919,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async))
;
return ((function (__11915,switch__11492__auto__,c__11567__auto___11919,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0 = (function (){
var statearr_11774 = [null,null,null,null,null,null,null];
(statearr_11774[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__);

(statearr_11774[(1)] = (1));

return statearr_11774;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1 = (function (state_11766){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_11766);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e11775){var ex__11496__auto__ = e11775;
var statearr_11776_11926 = state_11766;
(statearr_11776_11926[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_11766[(4)]))){
var statearr_11777_11927 = state_11766;
(statearr_11777_11927[(1)] = cljs.core.first((state_11766[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11928 = state_11766;
state_11766 = G__11928;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = function(state_11766){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1.call(this,state_11766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__;
})()
;})(__11915,switch__11492__auto__,c__11567__auto___11919,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async))
})();
var state__11569__auto__ = (function (){var statearr_11778 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_11778[(6)] = c__11567__auto___11919);

return statearr_11778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
});})(__11915,c__11567__auto___11919,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async))
);


break;
case "async":
var c__11567__auto___11929 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__11915,c__11567__auto___11929,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async){
return (function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = ((function (__11915,c__11567__auto___11929,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async){
return (function (state_11791){
var state_val_11792 = (state_11791[(1)]);
if((state_val_11792 === (1))){
var state_11791__$1 = state_11791;
var statearr_11793_11930 = state_11791__$1;
(statearr_11793_11930[(2)] = null);

(statearr_11793_11930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11792 === (2))){
var state_11791__$1 = state_11791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11791__$1,(4),jobs);
} else {
if((state_val_11792 === (3))){
var inst_11789 = (state_11791[(2)]);
var state_11791__$1 = state_11791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11791__$1,inst_11789);
} else {
if((state_val_11792 === (4))){
var inst_11781 = (state_11791[(2)]);
var inst_11782 = async(inst_11781);
var state_11791__$1 = state_11791;
if(cljs.core.truth_(inst_11782)){
var statearr_11794_11931 = state_11791__$1;
(statearr_11794_11931[(1)] = (5));

} else {
var statearr_11795_11932 = state_11791__$1;
(statearr_11795_11932[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11792 === (5))){
var state_11791__$1 = state_11791;
var statearr_11796_11933 = state_11791__$1;
(statearr_11796_11933[(2)] = null);

(statearr_11796_11933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11792 === (6))){
var state_11791__$1 = state_11791;
var statearr_11797_11934 = state_11791__$1;
(statearr_11797_11934[(2)] = null);

(statearr_11797_11934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11792 === (7))){
var inst_11787 = (state_11791[(2)]);
var state_11791__$1 = state_11791;
var statearr_11798_11935 = state_11791__$1;
(statearr_11798_11935[(2)] = inst_11787);

(statearr_11798_11935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11915,c__11567__auto___11929,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async))
;
return ((function (__11915,switch__11492__auto__,c__11567__auto___11929,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0 = (function (){
var statearr_11799 = [null,null,null,null,null,null,null];
(statearr_11799[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__);

(statearr_11799[(1)] = (1));

return statearr_11799;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1 = (function (state_11791){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_11791);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e11800){var ex__11496__auto__ = e11800;
var statearr_11801_11936 = state_11791;
(statearr_11801_11936[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_11791[(4)]))){
var statearr_11802_11937 = state_11791;
(statearr_11802_11937[(1)] = cljs.core.first((state_11791[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11938 = state_11791;
state_11791 = G__11938;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = function(state_11791){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1.call(this,state_11791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__;
})()
;})(__11915,switch__11492__auto__,c__11567__auto___11929,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async))
})();
var state__11569__auto__ = (function (){var statearr_11803 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_11803[(6)] = c__11567__auto___11929);

return statearr_11803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
});})(__11915,c__11567__auto___11929,G__11753_11916,G__11753_11917__$1,n__5636__auto___11914,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11753_11917__$1)].join('')));

}

var G__11939 = (__11915 + (1));
__11915 = G__11939;
continue;
} else {
}
break;
}

var c__11567__auto___11940 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_11825){
var state_val_11826 = (state_11825[(1)]);
if((state_val_11826 === (7))){
var inst_11821 = (state_11825[(2)]);
var state_11825__$1 = state_11825;
var statearr_11827_11941 = state_11825__$1;
(statearr_11827_11941[(2)] = inst_11821);

(statearr_11827_11941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11826 === (1))){
var state_11825__$1 = state_11825;
var statearr_11828_11942 = state_11825__$1;
(statearr_11828_11942[(2)] = null);

(statearr_11828_11942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11826 === (4))){
var inst_11806 = (state_11825[(7)]);
var inst_11806__$1 = (state_11825[(2)]);
var inst_11807 = (inst_11806__$1 == null);
var state_11825__$1 = (function (){var statearr_11829 = state_11825;
(statearr_11829[(7)] = inst_11806__$1);

return statearr_11829;
})();
if(cljs.core.truth_(inst_11807)){
var statearr_11830_11943 = state_11825__$1;
(statearr_11830_11943[(1)] = (5));

} else {
var statearr_11831_11944 = state_11825__$1;
(statearr_11831_11944[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11826 === (6))){
var inst_11806 = (state_11825[(7)]);
var inst_11811 = (state_11825[(8)]);
var inst_11811__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_11812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11813 = [inst_11806,inst_11811__$1];
var inst_11814 = (new cljs.core.PersistentVector(null,2,(5),inst_11812,inst_11813,null));
var state_11825__$1 = (function (){var statearr_11832 = state_11825;
(statearr_11832[(8)] = inst_11811__$1);

return statearr_11832;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11825__$1,(8),jobs,inst_11814);
} else {
if((state_val_11826 === (3))){
var inst_11823 = (state_11825[(2)]);
var state_11825__$1 = state_11825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11825__$1,inst_11823);
} else {
if((state_val_11826 === (2))){
var state_11825__$1 = state_11825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11825__$1,(4),from);
} else {
if((state_val_11826 === (9))){
var inst_11818 = (state_11825[(2)]);
var state_11825__$1 = (function (){var statearr_11833 = state_11825;
(statearr_11833[(9)] = inst_11818);

return statearr_11833;
})();
var statearr_11834_11945 = state_11825__$1;
(statearr_11834_11945[(2)] = null);

(statearr_11834_11945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11826 === (5))){
var inst_11809 = cljs.core.async.close_BANG_(jobs);
var state_11825__$1 = state_11825;
var statearr_11835_11946 = state_11825__$1;
(statearr_11835_11946[(2)] = inst_11809);

(statearr_11835_11946[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11826 === (8))){
var inst_11811 = (state_11825[(8)]);
var inst_11816 = (state_11825[(2)]);
var state_11825__$1 = (function (){var statearr_11836 = state_11825;
(statearr_11836[(10)] = inst_11816);

return statearr_11836;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11825__$1,(9),results,inst_11811);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0 = (function (){
var statearr_11837 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11837[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__);

(statearr_11837[(1)] = (1));

return statearr_11837;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1 = (function (state_11825){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_11825);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e11838){var ex__11496__auto__ = e11838;
var statearr_11839_11947 = state_11825;
(statearr_11839_11947[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_11825[(4)]))){
var statearr_11840_11948 = state_11825;
(statearr_11840_11948[(1)] = cljs.core.first((state_11825[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11949 = state_11825;
state_11825 = G__11949;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = function(state_11825){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1.call(this,state_11825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_11841 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_11841[(6)] = c__11567__auto___11940);

return statearr_11841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


var c__11567__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_11879){
var state_val_11880 = (state_11879[(1)]);
if((state_val_11880 === (7))){
var inst_11875 = (state_11879[(2)]);
var state_11879__$1 = state_11879;
var statearr_11881_11950 = state_11879__$1;
(statearr_11881_11950[(2)] = inst_11875);

(statearr_11881_11950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (20))){
var state_11879__$1 = state_11879;
var statearr_11882_11951 = state_11879__$1;
(statearr_11882_11951[(2)] = null);

(statearr_11882_11951[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (1))){
var state_11879__$1 = state_11879;
var statearr_11883_11952 = state_11879__$1;
(statearr_11883_11952[(2)] = null);

(statearr_11883_11952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (4))){
var inst_11844 = (state_11879[(7)]);
var inst_11844__$1 = (state_11879[(2)]);
var inst_11845 = (inst_11844__$1 == null);
var state_11879__$1 = (function (){var statearr_11884 = state_11879;
(statearr_11884[(7)] = inst_11844__$1);

return statearr_11884;
})();
if(cljs.core.truth_(inst_11845)){
var statearr_11885_11953 = state_11879__$1;
(statearr_11885_11953[(1)] = (5));

} else {
var statearr_11886_11954 = state_11879__$1;
(statearr_11886_11954[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (15))){
var inst_11857 = (state_11879[(8)]);
var state_11879__$1 = state_11879;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_11879__$1,(18),to,inst_11857);
} else {
if((state_val_11880 === (21))){
var inst_11870 = (state_11879[(2)]);
var state_11879__$1 = state_11879;
var statearr_11887_11955 = state_11879__$1;
(statearr_11887_11955[(2)] = inst_11870);

(statearr_11887_11955[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (13))){
var inst_11872 = (state_11879[(2)]);
var state_11879__$1 = (function (){var statearr_11888 = state_11879;
(statearr_11888[(9)] = inst_11872);

return statearr_11888;
})();
var statearr_11889_11956 = state_11879__$1;
(statearr_11889_11956[(2)] = null);

(statearr_11889_11956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (6))){
var inst_11844 = (state_11879[(7)]);
var state_11879__$1 = state_11879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11879__$1,(11),inst_11844);
} else {
if((state_val_11880 === (17))){
var inst_11865 = (state_11879[(2)]);
var state_11879__$1 = state_11879;
if(cljs.core.truth_(inst_11865)){
var statearr_11890_11957 = state_11879__$1;
(statearr_11890_11957[(1)] = (19));

} else {
var statearr_11891_11958 = state_11879__$1;
(statearr_11891_11958[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (3))){
var inst_11877 = (state_11879[(2)]);
var state_11879__$1 = state_11879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11879__$1,inst_11877);
} else {
if((state_val_11880 === (12))){
var inst_11854 = (state_11879[(10)]);
var state_11879__$1 = state_11879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11879__$1,(14),inst_11854);
} else {
if((state_val_11880 === (2))){
var state_11879__$1 = state_11879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11879__$1,(4),results);
} else {
if((state_val_11880 === (19))){
var state_11879__$1 = state_11879;
var statearr_11892_11959 = state_11879__$1;
(statearr_11892_11959[(2)] = null);

(statearr_11892_11959[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (11))){
var inst_11854 = (state_11879[(2)]);
var state_11879__$1 = (function (){var statearr_11893 = state_11879;
(statearr_11893[(10)] = inst_11854);

return statearr_11893;
})();
var statearr_11894_11960 = state_11879__$1;
(statearr_11894_11960[(2)] = null);

(statearr_11894_11960[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (9))){
var state_11879__$1 = state_11879;
var statearr_11895_11961 = state_11879__$1;
(statearr_11895_11961[(2)] = null);

(statearr_11895_11961[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (5))){
var state_11879__$1 = state_11879;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11896_11962 = state_11879__$1;
(statearr_11896_11962[(1)] = (8));

} else {
var statearr_11897_11963 = state_11879__$1;
(statearr_11897_11963[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (14))){
var inst_11857 = (state_11879[(8)]);
var inst_11859 = (state_11879[(11)]);
var inst_11857__$1 = (state_11879[(2)]);
var inst_11858 = (inst_11857__$1 == null);
var inst_11859__$1 = cljs.core.not(inst_11858);
var state_11879__$1 = (function (){var statearr_11898 = state_11879;
(statearr_11898[(8)] = inst_11857__$1);

(statearr_11898[(11)] = inst_11859__$1);

return statearr_11898;
})();
if(inst_11859__$1){
var statearr_11899_11964 = state_11879__$1;
(statearr_11899_11964[(1)] = (15));

} else {
var statearr_11900_11965 = state_11879__$1;
(statearr_11900_11965[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (16))){
var inst_11859 = (state_11879[(11)]);
var state_11879__$1 = state_11879;
var statearr_11901_11966 = state_11879__$1;
(statearr_11901_11966[(2)] = inst_11859);

(statearr_11901_11966[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (10))){
var inst_11851 = (state_11879[(2)]);
var state_11879__$1 = state_11879;
var statearr_11902_11967 = state_11879__$1;
(statearr_11902_11967[(2)] = inst_11851);

(statearr_11902_11967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (18))){
var inst_11862 = (state_11879[(2)]);
var state_11879__$1 = state_11879;
var statearr_11903_11968 = state_11879__$1;
(statearr_11903_11968[(2)] = inst_11862);

(statearr_11903_11968[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11880 === (8))){
var inst_11848 = cljs.core.async.close_BANG_(to);
var state_11879__$1 = state_11879;
var statearr_11904_11969 = state_11879__$1;
(statearr_11904_11969[(2)] = inst_11848);

(statearr_11904_11969[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0 = (function (){
var statearr_11905 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11905[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__);

(statearr_11905[(1)] = (1));

return statearr_11905;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1 = (function (state_11879){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_11879);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e11906){var ex__11496__auto__ = e11906;
var statearr_11907_11970 = state_11879;
(statearr_11907_11970[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_11879[(4)]))){
var statearr_11908_11971 = state_11879;
(statearr_11908_11971[(1)] = cljs.core.first((state_11879[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11972 = state_11879;
state_11879 = G__11972;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__ = function(state_11879){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1.call(this,state_11879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11493__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_11909 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_11909[(6)] = c__11567__auto__);

return statearr_11909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));

return c__11567__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11974 = arguments.length;
switch (G__11974) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11977 = arguments.length;
switch (G__11977) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11980 = arguments.length;
switch (G__11980) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11567__auto___12030 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12006){
var state_val_12007 = (state_12006[(1)]);
if((state_val_12007 === (7))){
var inst_12002 = (state_12006[(2)]);
var state_12006__$1 = state_12006;
var statearr_12008_12031 = state_12006__$1;
(statearr_12008_12031[(2)] = inst_12002);

(statearr_12008_12031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (1))){
var state_12006__$1 = state_12006;
var statearr_12009_12032 = state_12006__$1;
(statearr_12009_12032[(2)] = null);

(statearr_12009_12032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (4))){
var inst_11983 = (state_12006[(7)]);
var inst_11983__$1 = (state_12006[(2)]);
var inst_11984 = (inst_11983__$1 == null);
var state_12006__$1 = (function (){var statearr_12010 = state_12006;
(statearr_12010[(7)] = inst_11983__$1);

return statearr_12010;
})();
if(cljs.core.truth_(inst_11984)){
var statearr_12011_12033 = state_12006__$1;
(statearr_12011_12033[(1)] = (5));

} else {
var statearr_12012_12034 = state_12006__$1;
(statearr_12012_12034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (13))){
var state_12006__$1 = state_12006;
var statearr_12013_12035 = state_12006__$1;
(statearr_12013_12035[(2)] = null);

(statearr_12013_12035[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (6))){
var inst_11983 = (state_12006[(7)]);
var inst_11989 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_11983) : p.call(null,inst_11983));
var state_12006__$1 = state_12006;
if(cljs.core.truth_(inst_11989)){
var statearr_12014_12036 = state_12006__$1;
(statearr_12014_12036[(1)] = (9));

} else {
var statearr_12015_12037 = state_12006__$1;
(statearr_12015_12037[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (3))){
var inst_12004 = (state_12006[(2)]);
var state_12006__$1 = state_12006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12006__$1,inst_12004);
} else {
if((state_val_12007 === (12))){
var state_12006__$1 = state_12006;
var statearr_12016_12038 = state_12006__$1;
(statearr_12016_12038[(2)] = null);

(statearr_12016_12038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (2))){
var state_12006__$1 = state_12006;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12006__$1,(4),ch);
} else {
if((state_val_12007 === (11))){
var inst_11983 = (state_12006[(7)]);
var inst_11993 = (state_12006[(2)]);
var state_12006__$1 = state_12006;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12006__$1,(8),inst_11993,inst_11983);
} else {
if((state_val_12007 === (9))){
var state_12006__$1 = state_12006;
var statearr_12017_12039 = state_12006__$1;
(statearr_12017_12039[(2)] = tc);

(statearr_12017_12039[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (5))){
var inst_11986 = cljs.core.async.close_BANG_(tc);
var inst_11987 = cljs.core.async.close_BANG_(fc);
var state_12006__$1 = (function (){var statearr_12018 = state_12006;
(statearr_12018[(8)] = inst_11986);

return statearr_12018;
})();
var statearr_12019_12040 = state_12006__$1;
(statearr_12019_12040[(2)] = inst_11987);

(statearr_12019_12040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (14))){
var inst_12000 = (state_12006[(2)]);
var state_12006__$1 = state_12006;
var statearr_12020_12041 = state_12006__$1;
(statearr_12020_12041[(2)] = inst_12000);

(statearr_12020_12041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (10))){
var state_12006__$1 = state_12006;
var statearr_12021_12042 = state_12006__$1;
(statearr_12021_12042[(2)] = fc);

(statearr_12021_12042[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12007 === (8))){
var inst_11995 = (state_12006[(2)]);
var state_12006__$1 = state_12006;
if(cljs.core.truth_(inst_11995)){
var statearr_12022_12043 = state_12006__$1;
(statearr_12022_12043[(1)] = (12));

} else {
var statearr_12023_12044 = state_12006__$1;
(statearr_12023_12044[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_12024 = [null,null,null,null,null,null,null,null,null];
(statearr_12024[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_12024[(1)] = (1));

return statearr_12024;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_12006){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12006);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12025){var ex__11496__auto__ = e12025;
var statearr_12026_12045 = state_12006;
(statearr_12026_12045[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12006[(4)]))){
var statearr_12027_12046 = state_12006;
(statearr_12027_12046[(1)] = cljs.core.first((state_12006[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12047 = state_12006;
state_12006 = G__12047;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_12006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_12006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12028 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12028[(6)] = c__11567__auto___12030);

return statearr_12028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11567__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12069){
var state_val_12070 = (state_12069[(1)]);
if((state_val_12070 === (7))){
var inst_12065 = (state_12069[(2)]);
var state_12069__$1 = state_12069;
var statearr_12071_12090 = state_12069__$1;
(statearr_12071_12090[(2)] = inst_12065);

(statearr_12071_12090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12070 === (1))){
var inst_12048 = init;
var inst_12049 = inst_12048;
var state_12069__$1 = (function (){var statearr_12072 = state_12069;
(statearr_12072[(7)] = inst_12049);

return statearr_12072;
})();
var statearr_12073_12091 = state_12069__$1;
(statearr_12073_12091[(2)] = null);

(statearr_12073_12091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12070 === (4))){
var inst_12052 = (state_12069[(8)]);
var inst_12052__$1 = (state_12069[(2)]);
var inst_12053 = (inst_12052__$1 == null);
var state_12069__$1 = (function (){var statearr_12074 = state_12069;
(statearr_12074[(8)] = inst_12052__$1);

return statearr_12074;
})();
if(cljs.core.truth_(inst_12053)){
var statearr_12075_12092 = state_12069__$1;
(statearr_12075_12092[(1)] = (5));

} else {
var statearr_12076_12093 = state_12069__$1;
(statearr_12076_12093[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12070 === (6))){
var inst_12056 = (state_12069[(9)]);
var inst_12052 = (state_12069[(8)]);
var inst_12049 = (state_12069[(7)]);
var inst_12056__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_12049,inst_12052) : f.call(null,inst_12049,inst_12052));
var inst_12057 = cljs.core.reduced_QMARK_(inst_12056__$1);
var state_12069__$1 = (function (){var statearr_12077 = state_12069;
(statearr_12077[(9)] = inst_12056__$1);

return statearr_12077;
})();
if(inst_12057){
var statearr_12078_12094 = state_12069__$1;
(statearr_12078_12094[(1)] = (8));

} else {
var statearr_12079_12095 = state_12069__$1;
(statearr_12079_12095[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12070 === (3))){
var inst_12067 = (state_12069[(2)]);
var state_12069__$1 = state_12069;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12069__$1,inst_12067);
} else {
if((state_val_12070 === (2))){
var state_12069__$1 = state_12069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12069__$1,(4),ch);
} else {
if((state_val_12070 === (9))){
var inst_12056 = (state_12069[(9)]);
var inst_12049 = inst_12056;
var state_12069__$1 = (function (){var statearr_12080 = state_12069;
(statearr_12080[(7)] = inst_12049);

return statearr_12080;
})();
var statearr_12081_12096 = state_12069__$1;
(statearr_12081_12096[(2)] = null);

(statearr_12081_12096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12070 === (5))){
var inst_12049 = (state_12069[(7)]);
var state_12069__$1 = state_12069;
var statearr_12082_12097 = state_12069__$1;
(statearr_12082_12097[(2)] = inst_12049);

(statearr_12082_12097[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12070 === (10))){
var inst_12063 = (state_12069[(2)]);
var state_12069__$1 = state_12069;
var statearr_12083_12098 = state_12069__$1;
(statearr_12083_12098[(2)] = inst_12063);

(statearr_12083_12098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12070 === (8))){
var inst_12056 = (state_12069[(9)]);
var inst_12059 = cljs.core.deref(inst_12056);
var state_12069__$1 = state_12069;
var statearr_12084_12099 = state_12069__$1;
(statearr_12084_12099[(2)] = inst_12059);

(statearr_12084_12099[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__11493__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11493__auto____0 = (function (){
var statearr_12085 = [null,null,null,null,null,null,null,null,null,null];
(statearr_12085[(0)] = cljs$core$async$reduce_$_state_machine__11493__auto__);

(statearr_12085[(1)] = (1));

return statearr_12085;
});
var cljs$core$async$reduce_$_state_machine__11493__auto____1 = (function (state_12069){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12069);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12086){var ex__11496__auto__ = e12086;
var statearr_12087_12100 = state_12069;
(statearr_12087_12100[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12069[(4)]))){
var statearr_12088_12101 = state_12069;
(statearr_12088_12101[(1)] = cljs.core.first((state_12069[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12102 = state_12069;
state_12069 = G__12102;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11493__auto__ = function(state_12069){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11493__auto____1.call(this,state_12069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11493__auto____0;
cljs$core$async$reduce_$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11493__auto____1;
return cljs$core$async$reduce_$_state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12089 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12089[(6)] = c__11567__auto__);

return statearr_12089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));

return c__11567__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__11567__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12108){
var state_val_12109 = (state_12108[(1)]);
if((state_val_12109 === (1))){
var inst_12103 = cljs.core.async.reduce(f__$1,init,ch);
var state_12108__$1 = state_12108;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12108__$1,(2),inst_12103);
} else {
if((state_val_12109 === (2))){
var inst_12105 = (state_12108[(2)]);
var inst_12106 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_12105) : f__$1.call(null,inst_12105));
var state_12108__$1 = state_12108;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12108__$1,inst_12106);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__11493__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11493__auto____0 = (function (){
var statearr_12110 = [null,null,null,null,null,null,null];
(statearr_12110[(0)] = cljs$core$async$transduce_$_state_machine__11493__auto__);

(statearr_12110[(1)] = (1));

return statearr_12110;
});
var cljs$core$async$transduce_$_state_machine__11493__auto____1 = (function (state_12108){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12108);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12111){var ex__11496__auto__ = e12111;
var statearr_12112_12115 = state_12108;
(statearr_12112_12115[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12108[(4)]))){
var statearr_12113_12116 = state_12108;
(statearr_12113_12116[(1)] = cljs.core.first((state_12108[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12117 = state_12108;
state_12108 = G__12117;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11493__auto__ = function(state_12108){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11493__auto____1.call(this,state_12108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11493__auto____0;
cljs$core$async$transduce_$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11493__auto____1;
return cljs$core$async$transduce_$_state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12114 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12114[(6)] = c__11567__auto__);

return statearr_12114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));

return c__11567__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__12119 = arguments.length;
switch (G__12119) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11567__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12144){
var state_val_12145 = (state_12144[(1)]);
if((state_val_12145 === (7))){
var inst_12126 = (state_12144[(2)]);
var state_12144__$1 = state_12144;
var statearr_12146_12168 = state_12144__$1;
(statearr_12146_12168[(2)] = inst_12126);

(statearr_12146_12168[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (1))){
var inst_12120 = cljs.core.seq(coll);
var inst_12121 = inst_12120;
var state_12144__$1 = (function (){var statearr_12147 = state_12144;
(statearr_12147[(7)] = inst_12121);

return statearr_12147;
})();
var statearr_12148_12169 = state_12144__$1;
(statearr_12148_12169[(2)] = null);

(statearr_12148_12169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (4))){
var inst_12121 = (state_12144[(7)]);
var inst_12124 = cljs.core.first(inst_12121);
var state_12144__$1 = state_12144;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12144__$1,(7),ch,inst_12124);
} else {
if((state_val_12145 === (13))){
var inst_12138 = (state_12144[(2)]);
var state_12144__$1 = state_12144;
var statearr_12149_12170 = state_12144__$1;
(statearr_12149_12170[(2)] = inst_12138);

(statearr_12149_12170[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (6))){
var inst_12129 = (state_12144[(2)]);
var state_12144__$1 = state_12144;
if(cljs.core.truth_(inst_12129)){
var statearr_12150_12171 = state_12144__$1;
(statearr_12150_12171[(1)] = (8));

} else {
var statearr_12151_12172 = state_12144__$1;
(statearr_12151_12172[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (3))){
var inst_12142 = (state_12144[(2)]);
var state_12144__$1 = state_12144;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12144__$1,inst_12142);
} else {
if((state_val_12145 === (12))){
var state_12144__$1 = state_12144;
var statearr_12152_12173 = state_12144__$1;
(statearr_12152_12173[(2)] = null);

(statearr_12152_12173[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (2))){
var inst_12121 = (state_12144[(7)]);
var state_12144__$1 = state_12144;
if(cljs.core.truth_(inst_12121)){
var statearr_12153_12174 = state_12144__$1;
(statearr_12153_12174[(1)] = (4));

} else {
var statearr_12154_12175 = state_12144__$1;
(statearr_12154_12175[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (11))){
var inst_12135 = cljs.core.async.close_BANG_(ch);
var state_12144__$1 = state_12144;
var statearr_12155_12176 = state_12144__$1;
(statearr_12155_12176[(2)] = inst_12135);

(statearr_12155_12176[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (9))){
var state_12144__$1 = state_12144;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12156_12177 = state_12144__$1;
(statearr_12156_12177[(1)] = (11));

} else {
var statearr_12157_12178 = state_12144__$1;
(statearr_12157_12178[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (5))){
var inst_12121 = (state_12144[(7)]);
var state_12144__$1 = state_12144;
var statearr_12158_12179 = state_12144__$1;
(statearr_12158_12179[(2)] = inst_12121);

(statearr_12158_12179[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (10))){
var inst_12140 = (state_12144[(2)]);
var state_12144__$1 = state_12144;
var statearr_12159_12180 = state_12144__$1;
(statearr_12159_12180[(2)] = inst_12140);

(statearr_12159_12180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12145 === (8))){
var inst_12121 = (state_12144[(7)]);
var inst_12131 = cljs.core.next(inst_12121);
var inst_12121__$1 = inst_12131;
var state_12144__$1 = (function (){var statearr_12160 = state_12144;
(statearr_12160[(7)] = inst_12121__$1);

return statearr_12160;
})();
var statearr_12161_12181 = state_12144__$1;
(statearr_12161_12181[(2)] = null);

(statearr_12161_12181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_12162 = [null,null,null,null,null,null,null,null];
(statearr_12162[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_12162[(1)] = (1));

return statearr_12162;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_12144){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12144);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12163){var ex__11496__auto__ = e12163;
var statearr_12164_12182 = state_12144;
(statearr_12164_12182[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12144[(4)]))){
var statearr_12165_12183 = state_12144;
(statearr_12165_12183[(1)] = cljs.core.first((state_12144[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12184 = state_12144;
state_12144 = G__12184;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_12144){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_12144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12166 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12166[(6)] = c__11567__auto__);

return statearr_12166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));

return c__11567__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__12186 = arguments.length;
switch (G__12186) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_12188 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_12188(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_12189 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_12189(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_12190 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_12190(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_12191 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_12191(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12192 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12192 = (function (ch,cs,meta12193){
this.ch = ch;
this.cs = cs;
this.meta12193 = meta12193;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12192.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12194,meta12193__$1){
var self__ = this;
var _12194__$1 = this;
return (new cljs.core.async.t_cljs$core$async12192(self__.ch,self__.cs,meta12193__$1));
}));

(cljs.core.async.t_cljs$core$async12192.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12194){
var self__ = this;
var _12194__$1 = this;
return self__.meta12193;
}));

(cljs.core.async.t_cljs$core$async12192.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12192.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12192.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12192.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async12192.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async12192.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async12192.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12193","meta12193",-1468359279,null)], null);
}));

(cljs.core.async.t_cljs$core$async12192.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12192.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12192");

(cljs.core.async.t_cljs$core$async12192.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async12192");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12192.
 */
cljs.core.async.__GT_t_cljs$core$async12192 = (function cljs$core$async$mult_$___GT_t_cljs$core$async12192(ch__$1,cs__$1,meta12193){
return (new cljs.core.async.t_cljs$core$async12192(ch__$1,cs__$1,meta12193));
});

}

return (new cljs.core.async.t_cljs$core$async12192(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__11567__auto___12411 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12327){
var state_val_12328 = (state_12327[(1)]);
if((state_val_12328 === (7))){
var inst_12323 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12329_12412 = state_12327__$1;
(statearr_12329_12412[(2)] = inst_12323);

(statearr_12329_12412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (20))){
var inst_12228 = (state_12327[(7)]);
var inst_12240 = cljs.core.first(inst_12228);
var inst_12241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12240,(0),null);
var inst_12242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12240,(1),null);
var state_12327__$1 = (function (){var statearr_12330 = state_12327;
(statearr_12330[(8)] = inst_12241);

return statearr_12330;
})();
if(cljs.core.truth_(inst_12242)){
var statearr_12331_12413 = state_12327__$1;
(statearr_12331_12413[(1)] = (22));

} else {
var statearr_12332_12414 = state_12327__$1;
(statearr_12332_12414[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (27))){
var inst_12270 = (state_12327[(9)]);
var inst_12197 = (state_12327[(10)]);
var inst_12272 = (state_12327[(11)]);
var inst_12277 = (state_12327[(12)]);
var inst_12277__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12270,inst_12272);
var inst_12278 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12277__$1,inst_12197,done);
var state_12327__$1 = (function (){var statearr_12333 = state_12327;
(statearr_12333[(12)] = inst_12277__$1);

return statearr_12333;
})();
if(cljs.core.truth_(inst_12278)){
var statearr_12334_12415 = state_12327__$1;
(statearr_12334_12415[(1)] = (30));

} else {
var statearr_12335_12416 = state_12327__$1;
(statearr_12335_12416[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (1))){
var state_12327__$1 = state_12327;
var statearr_12336_12417 = state_12327__$1;
(statearr_12336_12417[(2)] = null);

(statearr_12336_12417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (24))){
var inst_12228 = (state_12327[(7)]);
var inst_12247 = (state_12327[(2)]);
var inst_12248 = cljs.core.next(inst_12228);
var inst_12206 = inst_12248;
var inst_12207 = null;
var inst_12208 = (0);
var inst_12209 = (0);
var state_12327__$1 = (function (){var statearr_12337 = state_12327;
(statearr_12337[(13)] = inst_12209);

(statearr_12337[(14)] = inst_12208);

(statearr_12337[(15)] = inst_12247);

(statearr_12337[(16)] = inst_12206);

(statearr_12337[(17)] = inst_12207);

return statearr_12337;
})();
var statearr_12338_12418 = state_12327__$1;
(statearr_12338_12418[(2)] = null);

(statearr_12338_12418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (39))){
var state_12327__$1 = state_12327;
var statearr_12342_12419 = state_12327__$1;
(statearr_12342_12419[(2)] = null);

(statearr_12342_12419[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (4))){
var inst_12197 = (state_12327[(10)]);
var inst_12197__$1 = (state_12327[(2)]);
var inst_12198 = (inst_12197__$1 == null);
var state_12327__$1 = (function (){var statearr_12343 = state_12327;
(statearr_12343[(10)] = inst_12197__$1);

return statearr_12343;
})();
if(cljs.core.truth_(inst_12198)){
var statearr_12344_12420 = state_12327__$1;
(statearr_12344_12420[(1)] = (5));

} else {
var statearr_12345_12421 = state_12327__$1;
(statearr_12345_12421[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (15))){
var inst_12209 = (state_12327[(13)]);
var inst_12208 = (state_12327[(14)]);
var inst_12206 = (state_12327[(16)]);
var inst_12207 = (state_12327[(17)]);
var inst_12224 = (state_12327[(2)]);
var inst_12225 = (inst_12209 + (1));
var tmp12339 = inst_12208;
var tmp12340 = inst_12206;
var tmp12341 = inst_12207;
var inst_12206__$1 = tmp12340;
var inst_12207__$1 = tmp12341;
var inst_12208__$1 = tmp12339;
var inst_12209__$1 = inst_12225;
var state_12327__$1 = (function (){var statearr_12346 = state_12327;
(statearr_12346[(13)] = inst_12209__$1);

(statearr_12346[(14)] = inst_12208__$1);

(statearr_12346[(16)] = inst_12206__$1);

(statearr_12346[(18)] = inst_12224);

(statearr_12346[(17)] = inst_12207__$1);

return statearr_12346;
})();
var statearr_12347_12422 = state_12327__$1;
(statearr_12347_12422[(2)] = null);

(statearr_12347_12422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (21))){
var inst_12251 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12351_12423 = state_12327__$1;
(statearr_12351_12423[(2)] = inst_12251);

(statearr_12351_12423[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (31))){
var inst_12277 = (state_12327[(12)]);
var inst_12281 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12277);
var state_12327__$1 = state_12327;
var statearr_12352_12424 = state_12327__$1;
(statearr_12352_12424[(2)] = inst_12281);

(statearr_12352_12424[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (32))){
var inst_12270 = (state_12327[(9)]);
var inst_12271 = (state_12327[(19)]);
var inst_12269 = (state_12327[(20)]);
var inst_12272 = (state_12327[(11)]);
var inst_12283 = (state_12327[(2)]);
var inst_12284 = (inst_12272 + (1));
var tmp12348 = inst_12270;
var tmp12349 = inst_12271;
var tmp12350 = inst_12269;
var inst_12269__$1 = tmp12350;
var inst_12270__$1 = tmp12348;
var inst_12271__$1 = tmp12349;
var inst_12272__$1 = inst_12284;
var state_12327__$1 = (function (){var statearr_12353 = state_12327;
(statearr_12353[(9)] = inst_12270__$1);

(statearr_12353[(19)] = inst_12271__$1);

(statearr_12353[(20)] = inst_12269__$1);

(statearr_12353[(21)] = inst_12283);

(statearr_12353[(11)] = inst_12272__$1);

return statearr_12353;
})();
var statearr_12354_12425 = state_12327__$1;
(statearr_12354_12425[(2)] = null);

(statearr_12354_12425[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (40))){
var inst_12296 = (state_12327[(22)]);
var inst_12300 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_12296);
var state_12327__$1 = state_12327;
var statearr_12355_12426 = state_12327__$1;
(statearr_12355_12426[(2)] = inst_12300);

(statearr_12355_12426[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (33))){
var inst_12287 = (state_12327[(23)]);
var inst_12289 = cljs.core.chunked_seq_QMARK_(inst_12287);
var state_12327__$1 = state_12327;
if(inst_12289){
var statearr_12356_12427 = state_12327__$1;
(statearr_12356_12427[(1)] = (36));

} else {
var statearr_12357_12428 = state_12327__$1;
(statearr_12357_12428[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (13))){
var inst_12218 = (state_12327[(24)]);
var inst_12221 = cljs.core.async.close_BANG_(inst_12218);
var state_12327__$1 = state_12327;
var statearr_12358_12429 = state_12327__$1;
(statearr_12358_12429[(2)] = inst_12221);

(statearr_12358_12429[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (22))){
var inst_12241 = (state_12327[(8)]);
var inst_12244 = cljs.core.async.close_BANG_(inst_12241);
var state_12327__$1 = state_12327;
var statearr_12359_12430 = state_12327__$1;
(statearr_12359_12430[(2)] = inst_12244);

(statearr_12359_12430[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (36))){
var inst_12287 = (state_12327[(23)]);
var inst_12291 = cljs.core.chunk_first(inst_12287);
var inst_12292 = cljs.core.chunk_rest(inst_12287);
var inst_12293 = cljs.core.count(inst_12291);
var inst_12269 = inst_12292;
var inst_12270 = inst_12291;
var inst_12271 = inst_12293;
var inst_12272 = (0);
var state_12327__$1 = (function (){var statearr_12360 = state_12327;
(statearr_12360[(9)] = inst_12270);

(statearr_12360[(19)] = inst_12271);

(statearr_12360[(20)] = inst_12269);

(statearr_12360[(11)] = inst_12272);

return statearr_12360;
})();
var statearr_12361_12431 = state_12327__$1;
(statearr_12361_12431[(2)] = null);

(statearr_12361_12431[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (41))){
var inst_12287 = (state_12327[(23)]);
var inst_12302 = (state_12327[(2)]);
var inst_12303 = cljs.core.next(inst_12287);
var inst_12269 = inst_12303;
var inst_12270 = null;
var inst_12271 = (0);
var inst_12272 = (0);
var state_12327__$1 = (function (){var statearr_12362 = state_12327;
(statearr_12362[(25)] = inst_12302);

(statearr_12362[(9)] = inst_12270);

(statearr_12362[(19)] = inst_12271);

(statearr_12362[(20)] = inst_12269);

(statearr_12362[(11)] = inst_12272);

return statearr_12362;
})();
var statearr_12363_12432 = state_12327__$1;
(statearr_12363_12432[(2)] = null);

(statearr_12363_12432[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (43))){
var state_12327__$1 = state_12327;
var statearr_12364_12433 = state_12327__$1;
(statearr_12364_12433[(2)] = null);

(statearr_12364_12433[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (29))){
var inst_12311 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12365_12434 = state_12327__$1;
(statearr_12365_12434[(2)] = inst_12311);

(statearr_12365_12434[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (44))){
var inst_12320 = (state_12327[(2)]);
var state_12327__$1 = (function (){var statearr_12366 = state_12327;
(statearr_12366[(26)] = inst_12320);

return statearr_12366;
})();
var statearr_12367_12435 = state_12327__$1;
(statearr_12367_12435[(2)] = null);

(statearr_12367_12435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (6))){
var inst_12261 = (state_12327[(27)]);
var inst_12260 = cljs.core.deref(cs);
var inst_12261__$1 = cljs.core.keys(inst_12260);
var inst_12262 = cljs.core.count(inst_12261__$1);
var inst_12263 = cljs.core.reset_BANG_(dctr,inst_12262);
var inst_12268 = cljs.core.seq(inst_12261__$1);
var inst_12269 = inst_12268;
var inst_12270 = null;
var inst_12271 = (0);
var inst_12272 = (0);
var state_12327__$1 = (function (){var statearr_12368 = state_12327;
(statearr_12368[(9)] = inst_12270);

(statearr_12368[(27)] = inst_12261__$1);

(statearr_12368[(19)] = inst_12271);

(statearr_12368[(20)] = inst_12269);

(statearr_12368[(11)] = inst_12272);

(statearr_12368[(28)] = inst_12263);

return statearr_12368;
})();
var statearr_12369_12436 = state_12327__$1;
(statearr_12369_12436[(2)] = null);

(statearr_12369_12436[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (28))){
var inst_12269 = (state_12327[(20)]);
var inst_12287 = (state_12327[(23)]);
var inst_12287__$1 = cljs.core.seq(inst_12269);
var state_12327__$1 = (function (){var statearr_12370 = state_12327;
(statearr_12370[(23)] = inst_12287__$1);

return statearr_12370;
})();
if(inst_12287__$1){
var statearr_12371_12437 = state_12327__$1;
(statearr_12371_12437[(1)] = (33));

} else {
var statearr_12372_12438 = state_12327__$1;
(statearr_12372_12438[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (25))){
var inst_12271 = (state_12327[(19)]);
var inst_12272 = (state_12327[(11)]);
var inst_12274 = (inst_12272 < inst_12271);
var inst_12275 = inst_12274;
var state_12327__$1 = state_12327;
if(cljs.core.truth_(inst_12275)){
var statearr_12373_12439 = state_12327__$1;
(statearr_12373_12439[(1)] = (27));

} else {
var statearr_12374_12440 = state_12327__$1;
(statearr_12374_12440[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (34))){
var state_12327__$1 = state_12327;
var statearr_12375_12441 = state_12327__$1;
(statearr_12375_12441[(2)] = null);

(statearr_12375_12441[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (17))){
var state_12327__$1 = state_12327;
var statearr_12376_12442 = state_12327__$1;
(statearr_12376_12442[(2)] = null);

(statearr_12376_12442[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (3))){
var inst_12325 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12327__$1,inst_12325);
} else {
if((state_val_12328 === (12))){
var inst_12256 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12377_12443 = state_12327__$1;
(statearr_12377_12443[(2)] = inst_12256);

(statearr_12377_12443[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (2))){
var state_12327__$1 = state_12327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12327__$1,(4),ch);
} else {
if((state_val_12328 === (23))){
var state_12327__$1 = state_12327;
var statearr_12378_12444 = state_12327__$1;
(statearr_12378_12444[(2)] = null);

(statearr_12378_12444[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (35))){
var inst_12309 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12379_12445 = state_12327__$1;
(statearr_12379_12445[(2)] = inst_12309);

(statearr_12379_12445[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (19))){
var inst_12228 = (state_12327[(7)]);
var inst_12232 = cljs.core.chunk_first(inst_12228);
var inst_12233 = cljs.core.chunk_rest(inst_12228);
var inst_12234 = cljs.core.count(inst_12232);
var inst_12206 = inst_12233;
var inst_12207 = inst_12232;
var inst_12208 = inst_12234;
var inst_12209 = (0);
var state_12327__$1 = (function (){var statearr_12380 = state_12327;
(statearr_12380[(13)] = inst_12209);

(statearr_12380[(14)] = inst_12208);

(statearr_12380[(16)] = inst_12206);

(statearr_12380[(17)] = inst_12207);

return statearr_12380;
})();
var statearr_12381_12446 = state_12327__$1;
(statearr_12381_12446[(2)] = null);

(statearr_12381_12446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (11))){
var inst_12206 = (state_12327[(16)]);
var inst_12228 = (state_12327[(7)]);
var inst_12228__$1 = cljs.core.seq(inst_12206);
var state_12327__$1 = (function (){var statearr_12382 = state_12327;
(statearr_12382[(7)] = inst_12228__$1);

return statearr_12382;
})();
if(inst_12228__$1){
var statearr_12383_12447 = state_12327__$1;
(statearr_12383_12447[(1)] = (16));

} else {
var statearr_12384_12448 = state_12327__$1;
(statearr_12384_12448[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (9))){
var inst_12258 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12385_12449 = state_12327__$1;
(statearr_12385_12449[(2)] = inst_12258);

(statearr_12385_12449[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (5))){
var inst_12204 = cljs.core.deref(cs);
var inst_12205 = cljs.core.seq(inst_12204);
var inst_12206 = inst_12205;
var inst_12207 = null;
var inst_12208 = (0);
var inst_12209 = (0);
var state_12327__$1 = (function (){var statearr_12386 = state_12327;
(statearr_12386[(13)] = inst_12209);

(statearr_12386[(14)] = inst_12208);

(statearr_12386[(16)] = inst_12206);

(statearr_12386[(17)] = inst_12207);

return statearr_12386;
})();
var statearr_12387_12450 = state_12327__$1;
(statearr_12387_12450[(2)] = null);

(statearr_12387_12450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (14))){
var state_12327__$1 = state_12327;
var statearr_12388_12451 = state_12327__$1;
(statearr_12388_12451[(2)] = null);

(statearr_12388_12451[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (45))){
var inst_12317 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12389_12452 = state_12327__$1;
(statearr_12389_12452[(2)] = inst_12317);

(statearr_12389_12452[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (26))){
var inst_12261 = (state_12327[(27)]);
var inst_12313 = (state_12327[(2)]);
var inst_12314 = cljs.core.seq(inst_12261);
var state_12327__$1 = (function (){var statearr_12390 = state_12327;
(statearr_12390[(29)] = inst_12313);

return statearr_12390;
})();
if(inst_12314){
var statearr_12391_12453 = state_12327__$1;
(statearr_12391_12453[(1)] = (42));

} else {
var statearr_12392_12454 = state_12327__$1;
(statearr_12392_12454[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (16))){
var inst_12228 = (state_12327[(7)]);
var inst_12230 = cljs.core.chunked_seq_QMARK_(inst_12228);
var state_12327__$1 = state_12327;
if(inst_12230){
var statearr_12393_12455 = state_12327__$1;
(statearr_12393_12455[(1)] = (19));

} else {
var statearr_12394_12456 = state_12327__$1;
(statearr_12394_12456[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (38))){
var inst_12306 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12395_12457 = state_12327__$1;
(statearr_12395_12457[(2)] = inst_12306);

(statearr_12395_12457[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (30))){
var state_12327__$1 = state_12327;
var statearr_12396_12458 = state_12327__$1;
(statearr_12396_12458[(2)] = null);

(statearr_12396_12458[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (10))){
var inst_12209 = (state_12327[(13)]);
var inst_12207 = (state_12327[(17)]);
var inst_12217 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12207,inst_12209);
var inst_12218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12217,(0),null);
var inst_12219 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12217,(1),null);
var state_12327__$1 = (function (){var statearr_12397 = state_12327;
(statearr_12397[(24)] = inst_12218);

return statearr_12397;
})();
if(cljs.core.truth_(inst_12219)){
var statearr_12398_12459 = state_12327__$1;
(statearr_12398_12459[(1)] = (13));

} else {
var statearr_12399_12460 = state_12327__$1;
(statearr_12399_12460[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (18))){
var inst_12254 = (state_12327[(2)]);
var state_12327__$1 = state_12327;
var statearr_12400_12461 = state_12327__$1;
(statearr_12400_12461[(2)] = inst_12254);

(statearr_12400_12461[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (42))){
var state_12327__$1 = state_12327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12327__$1,(45),dchan);
} else {
if((state_val_12328 === (37))){
var inst_12296 = (state_12327[(22)]);
var inst_12197 = (state_12327[(10)]);
var inst_12287 = (state_12327[(23)]);
var inst_12296__$1 = cljs.core.first(inst_12287);
var inst_12297 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_12296__$1,inst_12197,done);
var state_12327__$1 = (function (){var statearr_12401 = state_12327;
(statearr_12401[(22)] = inst_12296__$1);

return statearr_12401;
})();
if(cljs.core.truth_(inst_12297)){
var statearr_12402_12462 = state_12327__$1;
(statearr_12402_12462[(1)] = (39));

} else {
var statearr_12403_12463 = state_12327__$1;
(statearr_12403_12463[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12328 === (8))){
var inst_12209 = (state_12327[(13)]);
var inst_12208 = (state_12327[(14)]);
var inst_12211 = (inst_12209 < inst_12208);
var inst_12212 = inst_12211;
var state_12327__$1 = state_12327;
if(cljs.core.truth_(inst_12212)){
var statearr_12404_12464 = state_12327__$1;
(statearr_12404_12464[(1)] = (10));

} else {
var statearr_12405_12465 = state_12327__$1;
(statearr_12405_12465[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__11493__auto__ = null;
var cljs$core$async$mult_$_state_machine__11493__auto____0 = (function (){
var statearr_12406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12406[(0)] = cljs$core$async$mult_$_state_machine__11493__auto__);

(statearr_12406[(1)] = (1));

return statearr_12406;
});
var cljs$core$async$mult_$_state_machine__11493__auto____1 = (function (state_12327){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12327);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12407){var ex__11496__auto__ = e12407;
var statearr_12408_12466 = state_12327;
(statearr_12408_12466[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12327[(4)]))){
var statearr_12409_12467 = state_12327;
(statearr_12409_12467[(1)] = cljs.core.first((state_12327[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12468 = state_12327;
state_12327 = G__12468;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11493__auto__ = function(state_12327){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11493__auto____1.call(this,state_12327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11493__auto____0;
cljs$core$async$mult_$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11493__auto____1;
return cljs$core$async$mult_$_state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12410 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12410[(6)] = c__11567__auto___12411);

return statearr_12410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__12470 = arguments.length;
switch (G__12470) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_12472 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_12472(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_12473 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_12473(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_12474 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_12474(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_12475 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_12475(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_12476 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_12476(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___12486 = arguments.length;
var i__5770__auto___12487 = (0);
while(true){
if((i__5770__auto___12487 < len__5769__auto___12486)){
args__5775__auto__.push((arguments[i__5770__auto___12487]));

var G__12488 = (i__5770__auto___12487 + (1));
i__5770__auto___12487 = G__12488;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12481){
var map__12482 = p__12481;
var map__12482__$1 = cljs.core.__destructure_map(map__12482);
var opts = map__12482__$1;
var statearr_12483_12489 = state;
(statearr_12483_12489[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_12484_12490 = state;
(statearr_12484_12490[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_12485_12491 = state;
(statearr_12485_12491[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12477){
var G__12478 = cljs.core.first(seq12477);
var seq12477__$1 = cljs.core.next(seq12477);
var G__12479 = cljs.core.first(seq12477__$1);
var seq12477__$2 = cljs.core.next(seq12477__$1);
var G__12480 = cljs.core.first(seq12477__$2);
var seq12477__$3 = cljs.core.next(seq12477__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12478,G__12479,G__12480,seq12477__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12492 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12492 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12493){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12493 = meta12493;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12494,meta12493__$1){
var self__ = this;
var _12494__$1 = this;
return (new cljs.core.async.t_cljs$core$async12492(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12493__$1));
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12494){
var self__ = this;
var _12494__$1 = this;
return self__.meta12493;
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12492.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async12492.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12493","meta12493",1776147428,null)], null);
}));

(cljs.core.async.t_cljs$core$async12492.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12492.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12492");

(cljs.core.async.t_cljs$core$async12492.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async12492");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12492.
 */
cljs.core.async.__GT_t_cljs$core$async12492 = (function cljs$core$async$mix_$___GT_t_cljs$core$async12492(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12493){
return (new cljs.core.async.t_cljs$core$async12492(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12493));
});

}

return (new cljs.core.async.t_cljs$core$async12492(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11567__auto___12607 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12562){
var state_val_12563 = (state_12562[(1)]);
if((state_val_12563 === (7))){
var inst_12522 = (state_12562[(2)]);
var state_12562__$1 = state_12562;
if(cljs.core.truth_(inst_12522)){
var statearr_12564_12608 = state_12562__$1;
(statearr_12564_12608[(1)] = (8));

} else {
var statearr_12565_12609 = state_12562__$1;
(statearr_12565_12609[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (20))){
var inst_12515 = (state_12562[(7)]);
var state_12562__$1 = state_12562;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12562__$1,(23),out,inst_12515);
} else {
if((state_val_12563 === (1))){
var inst_12498 = calc_state();
var inst_12499 = cljs.core.__destructure_map(inst_12498);
var inst_12500 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12499,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12501 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12499,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12502 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12499,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12503 = inst_12498;
var state_12562__$1 = (function (){var statearr_12566 = state_12562;
(statearr_12566[(8)] = inst_12500);

(statearr_12566[(9)] = inst_12501);

(statearr_12566[(10)] = inst_12502);

(statearr_12566[(11)] = inst_12503);

return statearr_12566;
})();
var statearr_12567_12610 = state_12562__$1;
(statearr_12567_12610[(2)] = null);

(statearr_12567_12610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (24))){
var inst_12506 = (state_12562[(12)]);
var inst_12503 = inst_12506;
var state_12562__$1 = (function (){var statearr_12568 = state_12562;
(statearr_12568[(11)] = inst_12503);

return statearr_12568;
})();
var statearr_12569_12611 = state_12562__$1;
(statearr_12569_12611[(2)] = null);

(statearr_12569_12611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (4))){
var inst_12515 = (state_12562[(7)]);
var inst_12517 = (state_12562[(13)]);
var inst_12514 = (state_12562[(2)]);
var inst_12515__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12514,(0),null);
var inst_12516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12514,(1),null);
var inst_12517__$1 = (inst_12515__$1 == null);
var state_12562__$1 = (function (){var statearr_12570 = state_12562;
(statearr_12570[(14)] = inst_12516);

(statearr_12570[(7)] = inst_12515__$1);

(statearr_12570[(13)] = inst_12517__$1);

return statearr_12570;
})();
if(cljs.core.truth_(inst_12517__$1)){
var statearr_12571_12612 = state_12562__$1;
(statearr_12571_12612[(1)] = (5));

} else {
var statearr_12572_12613 = state_12562__$1;
(statearr_12572_12613[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (15))){
var inst_12536 = (state_12562[(15)]);
var inst_12507 = (state_12562[(16)]);
var inst_12536__$1 = cljs.core.empty_QMARK_(inst_12507);
var state_12562__$1 = (function (){var statearr_12573 = state_12562;
(statearr_12573[(15)] = inst_12536__$1);

return statearr_12573;
})();
if(inst_12536__$1){
var statearr_12574_12614 = state_12562__$1;
(statearr_12574_12614[(1)] = (17));

} else {
var statearr_12575_12615 = state_12562__$1;
(statearr_12575_12615[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (21))){
var inst_12506 = (state_12562[(12)]);
var inst_12503 = inst_12506;
var state_12562__$1 = (function (){var statearr_12576 = state_12562;
(statearr_12576[(11)] = inst_12503);

return statearr_12576;
})();
var statearr_12577_12616 = state_12562__$1;
(statearr_12577_12616[(2)] = null);

(statearr_12577_12616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (13))){
var inst_12529 = (state_12562[(2)]);
var inst_12530 = calc_state();
var inst_12503 = inst_12530;
var state_12562__$1 = (function (){var statearr_12578 = state_12562;
(statearr_12578[(17)] = inst_12529);

(statearr_12578[(11)] = inst_12503);

return statearr_12578;
})();
var statearr_12579_12617 = state_12562__$1;
(statearr_12579_12617[(2)] = null);

(statearr_12579_12617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (22))){
var inst_12556 = (state_12562[(2)]);
var state_12562__$1 = state_12562;
var statearr_12580_12618 = state_12562__$1;
(statearr_12580_12618[(2)] = inst_12556);

(statearr_12580_12618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (6))){
var inst_12516 = (state_12562[(14)]);
var inst_12520 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_12516,change);
var state_12562__$1 = state_12562;
var statearr_12581_12619 = state_12562__$1;
(statearr_12581_12619[(2)] = inst_12520);

(statearr_12581_12619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (25))){
var state_12562__$1 = state_12562;
var statearr_12582_12620 = state_12562__$1;
(statearr_12582_12620[(2)] = null);

(statearr_12582_12620[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (17))){
var inst_12516 = (state_12562[(14)]);
var inst_12508 = (state_12562[(18)]);
var inst_12538 = (inst_12508.cljs$core$IFn$_invoke$arity$1 ? inst_12508.cljs$core$IFn$_invoke$arity$1(inst_12516) : inst_12508.call(null,inst_12516));
var inst_12539 = cljs.core.not(inst_12538);
var state_12562__$1 = state_12562;
var statearr_12583_12621 = state_12562__$1;
(statearr_12583_12621[(2)] = inst_12539);

(statearr_12583_12621[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (3))){
var inst_12560 = (state_12562[(2)]);
var state_12562__$1 = state_12562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12562__$1,inst_12560);
} else {
if((state_val_12563 === (12))){
var state_12562__$1 = state_12562;
var statearr_12584_12622 = state_12562__$1;
(statearr_12584_12622[(2)] = null);

(statearr_12584_12622[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (2))){
var inst_12506 = (state_12562[(12)]);
var inst_12503 = (state_12562[(11)]);
var inst_12506__$1 = cljs.core.__destructure_map(inst_12503);
var inst_12507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12506__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12508 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12506__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12509 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12506__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12562__$1 = (function (){var statearr_12585 = state_12562;
(statearr_12585[(12)] = inst_12506__$1);

(statearr_12585[(16)] = inst_12507);

(statearr_12585[(18)] = inst_12508);

return statearr_12585;
})();
return cljs.core.async.ioc_alts_BANG_(state_12562__$1,(4),inst_12509);
} else {
if((state_val_12563 === (23))){
var inst_12547 = (state_12562[(2)]);
var state_12562__$1 = state_12562;
if(cljs.core.truth_(inst_12547)){
var statearr_12586_12623 = state_12562__$1;
(statearr_12586_12623[(1)] = (24));

} else {
var statearr_12587_12624 = state_12562__$1;
(statearr_12587_12624[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (19))){
var inst_12542 = (state_12562[(2)]);
var state_12562__$1 = state_12562;
var statearr_12588_12625 = state_12562__$1;
(statearr_12588_12625[(2)] = inst_12542);

(statearr_12588_12625[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (11))){
var inst_12516 = (state_12562[(14)]);
var inst_12526 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_12516);
var state_12562__$1 = state_12562;
var statearr_12589_12626 = state_12562__$1;
(statearr_12589_12626[(2)] = inst_12526);

(statearr_12589_12626[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (9))){
var inst_12516 = (state_12562[(14)]);
var inst_12533 = (state_12562[(19)]);
var inst_12507 = (state_12562[(16)]);
var inst_12533__$1 = (inst_12507.cljs$core$IFn$_invoke$arity$1 ? inst_12507.cljs$core$IFn$_invoke$arity$1(inst_12516) : inst_12507.call(null,inst_12516));
var state_12562__$1 = (function (){var statearr_12590 = state_12562;
(statearr_12590[(19)] = inst_12533__$1);

return statearr_12590;
})();
if(cljs.core.truth_(inst_12533__$1)){
var statearr_12591_12627 = state_12562__$1;
(statearr_12591_12627[(1)] = (14));

} else {
var statearr_12592_12628 = state_12562__$1;
(statearr_12592_12628[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (5))){
var inst_12517 = (state_12562[(13)]);
var state_12562__$1 = state_12562;
var statearr_12593_12629 = state_12562__$1;
(statearr_12593_12629[(2)] = inst_12517);

(statearr_12593_12629[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (14))){
var inst_12533 = (state_12562[(19)]);
var state_12562__$1 = state_12562;
var statearr_12594_12630 = state_12562__$1;
(statearr_12594_12630[(2)] = inst_12533);

(statearr_12594_12630[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (26))){
var inst_12552 = (state_12562[(2)]);
var state_12562__$1 = state_12562;
var statearr_12595_12631 = state_12562__$1;
(statearr_12595_12631[(2)] = inst_12552);

(statearr_12595_12631[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (16))){
var inst_12544 = (state_12562[(2)]);
var state_12562__$1 = state_12562;
if(cljs.core.truth_(inst_12544)){
var statearr_12596_12632 = state_12562__$1;
(statearr_12596_12632[(1)] = (20));

} else {
var statearr_12597_12633 = state_12562__$1;
(statearr_12597_12633[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (10))){
var inst_12558 = (state_12562[(2)]);
var state_12562__$1 = state_12562;
var statearr_12598_12634 = state_12562__$1;
(statearr_12598_12634[(2)] = inst_12558);

(statearr_12598_12634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (18))){
var inst_12536 = (state_12562[(15)]);
var state_12562__$1 = state_12562;
var statearr_12599_12635 = state_12562__$1;
(statearr_12599_12635[(2)] = inst_12536);

(statearr_12599_12635[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12563 === (8))){
var inst_12515 = (state_12562[(7)]);
var inst_12524 = (inst_12515 == null);
var state_12562__$1 = state_12562;
if(cljs.core.truth_(inst_12524)){
var statearr_12600_12636 = state_12562__$1;
(statearr_12600_12636[(1)] = (11));

} else {
var statearr_12601_12637 = state_12562__$1;
(statearr_12601_12637[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__11493__auto__ = null;
var cljs$core$async$mix_$_state_machine__11493__auto____0 = (function (){
var statearr_12602 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12602[(0)] = cljs$core$async$mix_$_state_machine__11493__auto__);

(statearr_12602[(1)] = (1));

return statearr_12602;
});
var cljs$core$async$mix_$_state_machine__11493__auto____1 = (function (state_12562){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12562);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12603){var ex__11496__auto__ = e12603;
var statearr_12604_12638 = state_12562;
(statearr_12604_12638[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12562[(4)]))){
var statearr_12605_12639 = state_12562;
(statearr_12605_12639[(1)] = cljs.core.first((state_12562[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12640 = state_12562;
state_12562 = G__12640;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11493__auto__ = function(state_12562){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11493__auto____1.call(this,state_12562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11493__auto____0;
cljs$core$async$mix_$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11493__auto____1;
return cljs$core$async$mix_$_state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12606 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12606[(6)] = c__11567__auto___12607);

return statearr_12606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12643 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12643(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12644 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12644(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12645 = (function() {
var G__12646 = null;
var G__12646__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__12646__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__12646 = function(p,v){
switch(arguments.length){
case 1:
return G__12646__1.call(this,p);
case 2:
return G__12646__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12646.cljs$core$IFn$_invoke$arity$1 = G__12646__1;
G__12646.cljs$core$IFn$_invoke$arity$2 = G__12646__2;
return G__12646;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12642 = arguments.length;
switch (G__12642) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12645.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12645.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12650 = arguments.length;
switch (G__12650) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__12648_SHARP_){
if(cljs.core.truth_((p1__12648_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__12648_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__12648_SHARP_.call(null,topic)))){
return p1__12648_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__12648_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12651 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12651 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12652){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12652 = meta12652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12653,meta12652__$1){
var self__ = this;
var _12653__$1 = this;
return (new cljs.core.async.t_cljs$core$async12651(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12652__$1));
}));

(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12653){
var self__ = this;
var _12653__$1 = this;
return self__.meta12652;
}));

(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12651.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12651.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12652","meta12652",-375993176,null)], null);
}));

(cljs.core.async.t_cljs$core$async12651.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12651.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12651");

(cljs.core.async.t_cljs$core$async12651.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async12651");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12651.
 */
cljs.core.async.__GT_t_cljs$core$async12651 = (function cljs$core$async$__GT_t_cljs$core$async12651(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12652){
return (new cljs.core.async.t_cljs$core$async12651(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12652));
});

}

return (new cljs.core.async.t_cljs$core$async12651(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11567__auto___12772 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12725){
var state_val_12726 = (state_12725[(1)]);
if((state_val_12726 === (7))){
var inst_12721 = (state_12725[(2)]);
var state_12725__$1 = state_12725;
var statearr_12727_12773 = state_12725__$1;
(statearr_12727_12773[(2)] = inst_12721);

(statearr_12727_12773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (20))){
var state_12725__$1 = state_12725;
var statearr_12728_12774 = state_12725__$1;
(statearr_12728_12774[(2)] = null);

(statearr_12728_12774[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (1))){
var state_12725__$1 = state_12725;
var statearr_12729_12775 = state_12725__$1;
(statearr_12729_12775[(2)] = null);

(statearr_12729_12775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (24))){
var inst_12704 = (state_12725[(7)]);
var inst_12713 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_12704);
var state_12725__$1 = state_12725;
var statearr_12730_12776 = state_12725__$1;
(statearr_12730_12776[(2)] = inst_12713);

(statearr_12730_12776[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (4))){
var inst_12656 = (state_12725[(8)]);
var inst_12656__$1 = (state_12725[(2)]);
var inst_12657 = (inst_12656__$1 == null);
var state_12725__$1 = (function (){var statearr_12731 = state_12725;
(statearr_12731[(8)] = inst_12656__$1);

return statearr_12731;
})();
if(cljs.core.truth_(inst_12657)){
var statearr_12732_12777 = state_12725__$1;
(statearr_12732_12777[(1)] = (5));

} else {
var statearr_12733_12778 = state_12725__$1;
(statearr_12733_12778[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (15))){
var inst_12698 = (state_12725[(2)]);
var state_12725__$1 = state_12725;
var statearr_12734_12779 = state_12725__$1;
(statearr_12734_12779[(2)] = inst_12698);

(statearr_12734_12779[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (21))){
var inst_12718 = (state_12725[(2)]);
var state_12725__$1 = (function (){var statearr_12735 = state_12725;
(statearr_12735[(9)] = inst_12718);

return statearr_12735;
})();
var statearr_12736_12780 = state_12725__$1;
(statearr_12736_12780[(2)] = null);

(statearr_12736_12780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (13))){
var inst_12680 = (state_12725[(10)]);
var inst_12682 = cljs.core.chunked_seq_QMARK_(inst_12680);
var state_12725__$1 = state_12725;
if(inst_12682){
var statearr_12737_12781 = state_12725__$1;
(statearr_12737_12781[(1)] = (16));

} else {
var statearr_12738_12782 = state_12725__$1;
(statearr_12738_12782[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (22))){
var inst_12710 = (state_12725[(2)]);
var state_12725__$1 = state_12725;
if(cljs.core.truth_(inst_12710)){
var statearr_12739_12783 = state_12725__$1;
(statearr_12739_12783[(1)] = (23));

} else {
var statearr_12740_12784 = state_12725__$1;
(statearr_12740_12784[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (6))){
var inst_12704 = (state_12725[(7)]);
var inst_12656 = (state_12725[(8)]);
var inst_12706 = (state_12725[(11)]);
var inst_12704__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_12656) : topic_fn.call(null,inst_12656));
var inst_12705 = cljs.core.deref(mults);
var inst_12706__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_12705,inst_12704__$1);
var state_12725__$1 = (function (){var statearr_12741 = state_12725;
(statearr_12741[(7)] = inst_12704__$1);

(statearr_12741[(11)] = inst_12706__$1);

return statearr_12741;
})();
if(cljs.core.truth_(inst_12706__$1)){
var statearr_12742_12785 = state_12725__$1;
(statearr_12742_12785[(1)] = (19));

} else {
var statearr_12743_12786 = state_12725__$1;
(statearr_12743_12786[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (25))){
var inst_12715 = (state_12725[(2)]);
var state_12725__$1 = state_12725;
var statearr_12744_12787 = state_12725__$1;
(statearr_12744_12787[(2)] = inst_12715);

(statearr_12744_12787[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (17))){
var inst_12680 = (state_12725[(10)]);
var inst_12689 = cljs.core.first(inst_12680);
var inst_12690 = cljs.core.async.muxch_STAR_(inst_12689);
var inst_12691 = cljs.core.async.close_BANG_(inst_12690);
var inst_12692 = cljs.core.next(inst_12680);
var inst_12666 = inst_12692;
var inst_12667 = null;
var inst_12668 = (0);
var inst_12669 = (0);
var state_12725__$1 = (function (){var statearr_12745 = state_12725;
(statearr_12745[(12)] = inst_12669);

(statearr_12745[(13)] = inst_12667);

(statearr_12745[(14)] = inst_12691);

(statearr_12745[(15)] = inst_12666);

(statearr_12745[(16)] = inst_12668);

return statearr_12745;
})();
var statearr_12746_12788 = state_12725__$1;
(statearr_12746_12788[(2)] = null);

(statearr_12746_12788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (3))){
var inst_12723 = (state_12725[(2)]);
var state_12725__$1 = state_12725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12725__$1,inst_12723);
} else {
if((state_val_12726 === (12))){
var inst_12700 = (state_12725[(2)]);
var state_12725__$1 = state_12725;
var statearr_12747_12789 = state_12725__$1;
(statearr_12747_12789[(2)] = inst_12700);

(statearr_12747_12789[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (2))){
var state_12725__$1 = state_12725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12725__$1,(4),ch);
} else {
if((state_val_12726 === (23))){
var state_12725__$1 = state_12725;
var statearr_12748_12790 = state_12725__$1;
(statearr_12748_12790[(2)] = null);

(statearr_12748_12790[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (19))){
var inst_12656 = (state_12725[(8)]);
var inst_12706 = (state_12725[(11)]);
var inst_12708 = cljs.core.async.muxch_STAR_(inst_12706);
var state_12725__$1 = state_12725;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12725__$1,(22),inst_12708,inst_12656);
} else {
if((state_val_12726 === (11))){
var inst_12680 = (state_12725[(10)]);
var inst_12666 = (state_12725[(15)]);
var inst_12680__$1 = cljs.core.seq(inst_12666);
var state_12725__$1 = (function (){var statearr_12749 = state_12725;
(statearr_12749[(10)] = inst_12680__$1);

return statearr_12749;
})();
if(inst_12680__$1){
var statearr_12750_12791 = state_12725__$1;
(statearr_12750_12791[(1)] = (13));

} else {
var statearr_12751_12792 = state_12725__$1;
(statearr_12751_12792[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (9))){
var inst_12702 = (state_12725[(2)]);
var state_12725__$1 = state_12725;
var statearr_12752_12793 = state_12725__$1;
(statearr_12752_12793[(2)] = inst_12702);

(statearr_12752_12793[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (5))){
var inst_12663 = cljs.core.deref(mults);
var inst_12664 = cljs.core.vals(inst_12663);
var inst_12665 = cljs.core.seq(inst_12664);
var inst_12666 = inst_12665;
var inst_12667 = null;
var inst_12668 = (0);
var inst_12669 = (0);
var state_12725__$1 = (function (){var statearr_12753 = state_12725;
(statearr_12753[(12)] = inst_12669);

(statearr_12753[(13)] = inst_12667);

(statearr_12753[(15)] = inst_12666);

(statearr_12753[(16)] = inst_12668);

return statearr_12753;
})();
var statearr_12754_12794 = state_12725__$1;
(statearr_12754_12794[(2)] = null);

(statearr_12754_12794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (14))){
var state_12725__$1 = state_12725;
var statearr_12758_12795 = state_12725__$1;
(statearr_12758_12795[(2)] = null);

(statearr_12758_12795[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (16))){
var inst_12680 = (state_12725[(10)]);
var inst_12684 = cljs.core.chunk_first(inst_12680);
var inst_12685 = cljs.core.chunk_rest(inst_12680);
var inst_12686 = cljs.core.count(inst_12684);
var inst_12666 = inst_12685;
var inst_12667 = inst_12684;
var inst_12668 = inst_12686;
var inst_12669 = (0);
var state_12725__$1 = (function (){var statearr_12759 = state_12725;
(statearr_12759[(12)] = inst_12669);

(statearr_12759[(13)] = inst_12667);

(statearr_12759[(15)] = inst_12666);

(statearr_12759[(16)] = inst_12668);

return statearr_12759;
})();
var statearr_12760_12796 = state_12725__$1;
(statearr_12760_12796[(2)] = null);

(statearr_12760_12796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (10))){
var inst_12669 = (state_12725[(12)]);
var inst_12667 = (state_12725[(13)]);
var inst_12666 = (state_12725[(15)]);
var inst_12668 = (state_12725[(16)]);
var inst_12674 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_12667,inst_12669);
var inst_12675 = cljs.core.async.muxch_STAR_(inst_12674);
var inst_12676 = cljs.core.async.close_BANG_(inst_12675);
var inst_12677 = (inst_12669 + (1));
var tmp12755 = inst_12667;
var tmp12756 = inst_12666;
var tmp12757 = inst_12668;
var inst_12666__$1 = tmp12756;
var inst_12667__$1 = tmp12755;
var inst_12668__$1 = tmp12757;
var inst_12669__$1 = inst_12677;
var state_12725__$1 = (function (){var statearr_12761 = state_12725;
(statearr_12761[(12)] = inst_12669__$1);

(statearr_12761[(17)] = inst_12676);

(statearr_12761[(13)] = inst_12667__$1);

(statearr_12761[(15)] = inst_12666__$1);

(statearr_12761[(16)] = inst_12668__$1);

return statearr_12761;
})();
var statearr_12762_12797 = state_12725__$1;
(statearr_12762_12797[(2)] = null);

(statearr_12762_12797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (18))){
var inst_12695 = (state_12725[(2)]);
var state_12725__$1 = state_12725;
var statearr_12763_12798 = state_12725__$1;
(statearr_12763_12798[(2)] = inst_12695);

(statearr_12763_12798[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12726 === (8))){
var inst_12669 = (state_12725[(12)]);
var inst_12668 = (state_12725[(16)]);
var inst_12671 = (inst_12669 < inst_12668);
var inst_12672 = inst_12671;
var state_12725__$1 = state_12725;
if(cljs.core.truth_(inst_12672)){
var statearr_12764_12799 = state_12725__$1;
(statearr_12764_12799[(1)] = (10));

} else {
var statearr_12765_12800 = state_12725__$1;
(statearr_12765_12800[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_12766 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12766[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_12766[(1)] = (1));

return statearr_12766;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_12725){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12725);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12767){var ex__11496__auto__ = e12767;
var statearr_12768_12801 = state_12725;
(statearr_12768_12801[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12725[(4)]))){
var statearr_12769_12802 = state_12725;
(statearr_12769_12802[(1)] = cljs.core.first((state_12725[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12803 = state_12725;
state_12725 = G__12803;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_12725){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_12725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12770 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12770[(6)] = c__11567__auto___12772);

return statearr_12770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12805 = arguments.length;
switch (G__12805) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12808 = arguments.length;
switch (G__12808) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12811 = arguments.length;
switch (G__12811) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__11567__auto___12889 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12854){
var state_val_12855 = (state_12854[(1)]);
if((state_val_12855 === (7))){
var state_12854__$1 = state_12854;
var statearr_12856_12890 = state_12854__$1;
(statearr_12856_12890[(2)] = null);

(statearr_12856_12890[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (1))){
var state_12854__$1 = state_12854;
var statearr_12857_12891 = state_12854__$1;
(statearr_12857_12891[(2)] = null);

(statearr_12857_12891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (4))){
var inst_12814 = (state_12854[(7)]);
var inst_12815 = (state_12854[(8)]);
var inst_12817 = (inst_12815 < inst_12814);
var state_12854__$1 = state_12854;
if(cljs.core.truth_(inst_12817)){
var statearr_12858_12892 = state_12854__$1;
(statearr_12858_12892[(1)] = (6));

} else {
var statearr_12859_12893 = state_12854__$1;
(statearr_12859_12893[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (15))){
var inst_12840 = (state_12854[(9)]);
var inst_12845 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_12840);
var state_12854__$1 = state_12854;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12854__$1,(17),out,inst_12845);
} else {
if((state_val_12855 === (13))){
var inst_12840 = (state_12854[(9)]);
var inst_12840__$1 = (state_12854[(2)]);
var inst_12841 = cljs.core.some(cljs.core.nil_QMARK_,inst_12840__$1);
var state_12854__$1 = (function (){var statearr_12860 = state_12854;
(statearr_12860[(9)] = inst_12840__$1);

return statearr_12860;
})();
if(cljs.core.truth_(inst_12841)){
var statearr_12861_12894 = state_12854__$1;
(statearr_12861_12894[(1)] = (14));

} else {
var statearr_12862_12895 = state_12854__$1;
(statearr_12862_12895[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (6))){
var state_12854__$1 = state_12854;
var statearr_12863_12896 = state_12854__$1;
(statearr_12863_12896[(2)] = null);

(statearr_12863_12896[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (17))){
var inst_12847 = (state_12854[(2)]);
var state_12854__$1 = (function (){var statearr_12865 = state_12854;
(statearr_12865[(10)] = inst_12847);

return statearr_12865;
})();
var statearr_12866_12897 = state_12854__$1;
(statearr_12866_12897[(2)] = null);

(statearr_12866_12897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (3))){
var inst_12852 = (state_12854[(2)]);
var state_12854__$1 = state_12854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12854__$1,inst_12852);
} else {
if((state_val_12855 === (12))){
var _ = (function (){var statearr_12867 = state_12854;
(statearr_12867[(4)] = cljs.core.rest((state_12854[(4)])));

return statearr_12867;
})();
var state_12854__$1 = state_12854;
var ex12864 = (state_12854__$1[(2)]);
var statearr_12868_12898 = state_12854__$1;
(statearr_12868_12898[(5)] = ex12864);


if((ex12864 instanceof Object)){
var statearr_12869_12899 = state_12854__$1;
(statearr_12869_12899[(1)] = (11));

(statearr_12869_12899[(5)] = null);

} else {
throw ex12864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (2))){
var inst_12813 = cljs.core.reset_BANG_(dctr,cnt);
var inst_12814 = cnt;
var inst_12815 = (0);
var state_12854__$1 = (function (){var statearr_12870 = state_12854;
(statearr_12870[(11)] = inst_12813);

(statearr_12870[(7)] = inst_12814);

(statearr_12870[(8)] = inst_12815);

return statearr_12870;
})();
var statearr_12871_12900 = state_12854__$1;
(statearr_12871_12900[(2)] = null);

(statearr_12871_12900[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (11))){
var inst_12819 = (state_12854[(2)]);
var inst_12820 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_12854__$1 = (function (){var statearr_12872 = state_12854;
(statearr_12872[(12)] = inst_12819);

return statearr_12872;
})();
var statearr_12873_12901 = state_12854__$1;
(statearr_12873_12901[(2)] = inst_12820);

(statearr_12873_12901[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (9))){
var inst_12815 = (state_12854[(8)]);
var _ = (function (){var statearr_12874 = state_12854;
(statearr_12874[(4)] = cljs.core.cons((12),(state_12854[(4)])));

return statearr_12874;
})();
var inst_12826 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_12815) : chs__$1.call(null,inst_12815));
var inst_12827 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_12815) : done.call(null,inst_12815));
var inst_12828 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_12826,inst_12827);
var ___$1 = (function (){var statearr_12875 = state_12854;
(statearr_12875[(4)] = cljs.core.rest((state_12854[(4)])));

return statearr_12875;
})();
var state_12854__$1 = state_12854;
var statearr_12876_12902 = state_12854__$1;
(statearr_12876_12902[(2)] = inst_12828);

(statearr_12876_12902[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (5))){
var inst_12838 = (state_12854[(2)]);
var state_12854__$1 = (function (){var statearr_12877 = state_12854;
(statearr_12877[(13)] = inst_12838);

return statearr_12877;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12854__$1,(13),dchan);
} else {
if((state_val_12855 === (14))){
var inst_12843 = cljs.core.async.close_BANG_(out);
var state_12854__$1 = state_12854;
var statearr_12878_12903 = state_12854__$1;
(statearr_12878_12903[(2)] = inst_12843);

(statearr_12878_12903[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (16))){
var inst_12850 = (state_12854[(2)]);
var state_12854__$1 = state_12854;
var statearr_12879_12904 = state_12854__$1;
(statearr_12879_12904[(2)] = inst_12850);

(statearr_12879_12904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (10))){
var inst_12815 = (state_12854[(8)]);
var inst_12831 = (state_12854[(2)]);
var inst_12832 = (inst_12815 + (1));
var inst_12815__$1 = inst_12832;
var state_12854__$1 = (function (){var statearr_12880 = state_12854;
(statearr_12880[(14)] = inst_12831);

(statearr_12880[(8)] = inst_12815__$1);

return statearr_12880;
})();
var statearr_12881_12905 = state_12854__$1;
(statearr_12881_12905[(2)] = null);

(statearr_12881_12905[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12855 === (8))){
var inst_12836 = (state_12854[(2)]);
var state_12854__$1 = state_12854;
var statearr_12882_12906 = state_12854__$1;
(statearr_12882_12906[(2)] = inst_12836);

(statearr_12882_12906[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_12883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12883[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_12883[(1)] = (1));

return statearr_12883;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_12854){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12854);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12884){var ex__11496__auto__ = e12884;
var statearr_12885_12907 = state_12854;
(statearr_12885_12907[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12854[(4)]))){
var statearr_12886_12908 = state_12854;
(statearr_12886_12908[(1)] = cljs.core.first((state_12854[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12909 = state_12854;
state_12854 = G__12909;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_12854){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_12854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12887 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12887[(6)] = c__11567__auto___12889);

return statearr_12887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12912 = arguments.length;
switch (G__12912) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11567__auto___12967 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_12944){
var state_val_12945 = (state_12944[(1)]);
if((state_val_12945 === (7))){
var inst_12923 = (state_12944[(7)]);
var inst_12924 = (state_12944[(8)]);
var inst_12923__$1 = (state_12944[(2)]);
var inst_12924__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12923__$1,(0),null);
var inst_12925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_12923__$1,(1),null);
var inst_12926 = (inst_12924__$1 == null);
var state_12944__$1 = (function (){var statearr_12946 = state_12944;
(statearr_12946[(7)] = inst_12923__$1);

(statearr_12946[(9)] = inst_12925);

(statearr_12946[(8)] = inst_12924__$1);

return statearr_12946;
})();
if(cljs.core.truth_(inst_12926)){
var statearr_12947_12968 = state_12944__$1;
(statearr_12947_12968[(1)] = (8));

} else {
var statearr_12948_12969 = state_12944__$1;
(statearr_12948_12969[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12945 === (1))){
var inst_12913 = cljs.core.vec(chs);
var inst_12914 = inst_12913;
var state_12944__$1 = (function (){var statearr_12949 = state_12944;
(statearr_12949[(10)] = inst_12914);

return statearr_12949;
})();
var statearr_12950_12970 = state_12944__$1;
(statearr_12950_12970[(2)] = null);

(statearr_12950_12970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12945 === (4))){
var inst_12914 = (state_12944[(10)]);
var state_12944__$1 = state_12944;
return cljs.core.async.ioc_alts_BANG_(state_12944__$1,(7),inst_12914);
} else {
if((state_val_12945 === (6))){
var inst_12940 = (state_12944[(2)]);
var state_12944__$1 = state_12944;
var statearr_12951_12971 = state_12944__$1;
(statearr_12951_12971[(2)] = inst_12940);

(statearr_12951_12971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12945 === (3))){
var inst_12942 = (state_12944[(2)]);
var state_12944__$1 = state_12944;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12944__$1,inst_12942);
} else {
if((state_val_12945 === (2))){
var inst_12914 = (state_12944[(10)]);
var inst_12916 = cljs.core.count(inst_12914);
var inst_12917 = (inst_12916 > (0));
var state_12944__$1 = state_12944;
if(cljs.core.truth_(inst_12917)){
var statearr_12953_12972 = state_12944__$1;
(statearr_12953_12972[(1)] = (4));

} else {
var statearr_12954_12973 = state_12944__$1;
(statearr_12954_12973[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12945 === (11))){
var inst_12914 = (state_12944[(10)]);
var inst_12933 = (state_12944[(2)]);
var tmp12952 = inst_12914;
var inst_12914__$1 = tmp12952;
var state_12944__$1 = (function (){var statearr_12955 = state_12944;
(statearr_12955[(11)] = inst_12933);

(statearr_12955[(10)] = inst_12914__$1);

return statearr_12955;
})();
var statearr_12956_12974 = state_12944__$1;
(statearr_12956_12974[(2)] = null);

(statearr_12956_12974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12945 === (9))){
var inst_12924 = (state_12944[(8)]);
var state_12944__$1 = state_12944;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12944__$1,(11),out,inst_12924);
} else {
if((state_val_12945 === (5))){
var inst_12938 = cljs.core.async.close_BANG_(out);
var state_12944__$1 = state_12944;
var statearr_12957_12975 = state_12944__$1;
(statearr_12957_12975[(2)] = inst_12938);

(statearr_12957_12975[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12945 === (10))){
var inst_12936 = (state_12944[(2)]);
var state_12944__$1 = state_12944;
var statearr_12958_12976 = state_12944__$1;
(statearr_12958_12976[(2)] = inst_12936);

(statearr_12958_12976[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12945 === (8))){
var inst_12923 = (state_12944[(7)]);
var inst_12925 = (state_12944[(9)]);
var inst_12914 = (state_12944[(10)]);
var inst_12924 = (state_12944[(8)]);
var inst_12928 = (function (){var cs = inst_12914;
var vec__12919 = inst_12923;
var v = inst_12924;
var c = inst_12925;
return (function (p1__12910_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__12910_SHARP_);
});
})();
var inst_12929 = cljs.core.filterv(inst_12928,inst_12914);
var inst_12914__$1 = inst_12929;
var state_12944__$1 = (function (){var statearr_12959 = state_12944;
(statearr_12959[(10)] = inst_12914__$1);

return statearr_12959;
})();
var statearr_12960_12977 = state_12944__$1;
(statearr_12960_12977[(2)] = null);

(statearr_12960_12977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_12961 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12961[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_12961[(1)] = (1));

return statearr_12961;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_12944){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_12944);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e12962){var ex__11496__auto__ = e12962;
var statearr_12963_12978 = state_12944;
(statearr_12963_12978[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_12944[(4)]))){
var statearr_12964_12979 = state_12944;
(statearr_12964_12979[(1)] = cljs.core.first((state_12944[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12980 = state_12944;
state_12944 = G__12980;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_12944){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_12944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_12965 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_12965[(6)] = c__11567__auto___12967);

return statearr_12965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12982 = arguments.length;
switch (G__12982) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11567__auto___13028 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_13006){
var state_val_13007 = (state_13006[(1)]);
if((state_val_13007 === (7))){
var inst_12988 = (state_13006[(7)]);
var inst_12988__$1 = (state_13006[(2)]);
var inst_12989 = (inst_12988__$1 == null);
var inst_12990 = cljs.core.not(inst_12989);
var state_13006__$1 = (function (){var statearr_13008 = state_13006;
(statearr_13008[(7)] = inst_12988__$1);

return statearr_13008;
})();
if(inst_12990){
var statearr_13009_13029 = state_13006__$1;
(statearr_13009_13029[(1)] = (8));

} else {
var statearr_13010_13030 = state_13006__$1;
(statearr_13010_13030[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13007 === (1))){
var inst_12983 = (0);
var state_13006__$1 = (function (){var statearr_13011 = state_13006;
(statearr_13011[(8)] = inst_12983);

return statearr_13011;
})();
var statearr_13012_13031 = state_13006__$1;
(statearr_13012_13031[(2)] = null);

(statearr_13012_13031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13007 === (4))){
var state_13006__$1 = state_13006;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13006__$1,(7),ch);
} else {
if((state_val_13007 === (6))){
var inst_13001 = (state_13006[(2)]);
var state_13006__$1 = state_13006;
var statearr_13013_13032 = state_13006__$1;
(statearr_13013_13032[(2)] = inst_13001);

(statearr_13013_13032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13007 === (3))){
var inst_13003 = (state_13006[(2)]);
var inst_13004 = cljs.core.async.close_BANG_(out);
var state_13006__$1 = (function (){var statearr_13014 = state_13006;
(statearr_13014[(9)] = inst_13003);

return statearr_13014;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13006__$1,inst_13004);
} else {
if((state_val_13007 === (2))){
var inst_12983 = (state_13006[(8)]);
var inst_12985 = (inst_12983 < n);
var state_13006__$1 = state_13006;
if(cljs.core.truth_(inst_12985)){
var statearr_13015_13033 = state_13006__$1;
(statearr_13015_13033[(1)] = (4));

} else {
var statearr_13016_13034 = state_13006__$1;
(statearr_13016_13034[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13007 === (11))){
var inst_12983 = (state_13006[(8)]);
var inst_12993 = (state_13006[(2)]);
var inst_12994 = (inst_12983 + (1));
var inst_12983__$1 = inst_12994;
var state_13006__$1 = (function (){var statearr_13017 = state_13006;
(statearr_13017[(8)] = inst_12983__$1);

(statearr_13017[(10)] = inst_12993);

return statearr_13017;
})();
var statearr_13018_13035 = state_13006__$1;
(statearr_13018_13035[(2)] = null);

(statearr_13018_13035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13007 === (9))){
var state_13006__$1 = state_13006;
var statearr_13019_13036 = state_13006__$1;
(statearr_13019_13036[(2)] = null);

(statearr_13019_13036[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13007 === (5))){
var state_13006__$1 = state_13006;
var statearr_13020_13037 = state_13006__$1;
(statearr_13020_13037[(2)] = null);

(statearr_13020_13037[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13007 === (10))){
var inst_12998 = (state_13006[(2)]);
var state_13006__$1 = state_13006;
var statearr_13021_13038 = state_13006__$1;
(statearr_13021_13038[(2)] = inst_12998);

(statearr_13021_13038[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13007 === (8))){
var inst_12988 = (state_13006[(7)]);
var state_13006__$1 = state_13006;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13006__$1,(11),out,inst_12988);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_13022 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13022[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_13022[(1)] = (1));

return statearr_13022;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_13006){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_13006);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e13023){var ex__11496__auto__ = e13023;
var statearr_13024_13039 = state_13006;
(statearr_13024_13039[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_13006[(4)]))){
var statearr_13025_13040 = state_13006;
(statearr_13025_13040[(1)] = cljs.core.first((state_13006[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13041 = state_13006;
state_13006 = G__13041;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_13006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_13006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_13026 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_13026[(6)] = c__11567__auto___13028);

return statearr_13026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13043 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13043 = (function (f,ch,meta13044){
this.f = f;
this.ch = ch;
this.meta13044 = meta13044;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13045,meta13044__$1){
var self__ = this;
var _13045__$1 = this;
return (new cljs.core.async.t_cljs$core$async13043(self__.f,self__.ch,meta13044__$1));
}));

(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13045){
var self__ = this;
var _13045__$1 = this;
return self__.meta13044;
}));

(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13046 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13046 = (function (f,ch,meta13044,_,fn1,meta13047){
this.f = f;
this.ch = ch;
this.meta13044 = meta13044;
this._ = _;
this.fn1 = fn1;
this.meta13047 = meta13047;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13046.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13048,meta13047__$1){
var self__ = this;
var _13048__$1 = this;
return (new cljs.core.async.t_cljs$core$async13046(self__.f,self__.ch,self__.meta13044,self__._,self__.fn1,meta13047__$1));
}));

(cljs.core.async.t_cljs$core$async13046.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13048){
var self__ = this;
var _13048__$1 = this;
return self__.meta13047;
}));

(cljs.core.async.t_cljs$core$async13046.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13046.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async13046.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13046.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__13042_SHARP_){
var G__13049 = (((p1__13042_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__13042_SHARP_) : self__.f.call(null,p1__13042_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__13049) : f1.call(null,G__13049));
});
}));

(cljs.core.async.t_cljs$core$async13046.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13044","meta13044",-1021559533,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13043","cljs.core.async/t_cljs$core$async13043",765317018,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13047","meta13047",111091253,null)], null);
}));

(cljs.core.async.t_cljs$core$async13046.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13046.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13046");

(cljs.core.async.t_cljs$core$async13046.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async13046");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13046.
 */
cljs.core.async.__GT_t_cljs$core$async13046 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13046(f__$1,ch__$1,meta13044__$1,___$2,fn1__$1,meta13047){
return (new cljs.core.async.t_cljs$core$async13046(f__$1,ch__$1,meta13044__$1,___$2,fn1__$1,meta13047));
});

}

return (new cljs.core.async.t_cljs$core$async13046(self__.f,self__.ch,self__.meta13044,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__13050 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__13050) : self__.f.call(null,G__13050));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13043.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async13043.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13044","meta13044",-1021559533,null)], null);
}));

(cljs.core.async.t_cljs$core$async13043.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13043.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13043");

(cljs.core.async.t_cljs$core$async13043.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async13043");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13043.
 */
cljs.core.async.__GT_t_cljs$core$async13043 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13043(f__$1,ch__$1,meta13044){
return (new cljs.core.async.t_cljs$core$async13043(f__$1,ch__$1,meta13044));
});

}

return (new cljs.core.async.t_cljs$core$async13043(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13051 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13051 = (function (f,ch,meta13052){
this.f = f;
this.ch = ch;
this.meta13052 = meta13052;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13051.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13053,meta13052__$1){
var self__ = this;
var _13053__$1 = this;
return (new cljs.core.async.t_cljs$core$async13051(self__.f,self__.ch,meta13052__$1));
}));

(cljs.core.async.t_cljs$core$async13051.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13053){
var self__ = this;
var _13053__$1 = this;
return self__.meta13052;
}));

(cljs.core.async.t_cljs$core$async13051.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13051.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13051.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13051.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async13051.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13051.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async13051.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13052","meta13052",-2099204424,null)], null);
}));

(cljs.core.async.t_cljs$core$async13051.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13051.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13051");

(cljs.core.async.t_cljs$core$async13051.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async13051");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13051.
 */
cljs.core.async.__GT_t_cljs$core$async13051 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13051(f__$1,ch__$1,meta13052){
return (new cljs.core.async.t_cljs$core$async13051(f__$1,ch__$1,meta13052));
});

}

return (new cljs.core.async.t_cljs$core$async13051(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13054 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13054 = (function (p,ch,meta13055){
this.p = p;
this.ch = ch;
this.meta13055 = meta13055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13056,meta13055__$1){
var self__ = this;
var _13056__$1 = this;
return (new cljs.core.async.t_cljs$core$async13054(self__.p,self__.ch,meta13055__$1));
}));

(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13056){
var self__ = this;
var _13056__$1 = this;
return self__.meta13055;
}));

(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13054.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async13054.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13055","meta13055",-1852668985,null)], null);
}));

(cljs.core.async.t_cljs$core$async13054.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13054.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13054");

(cljs.core.async.t_cljs$core$async13054.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async13054");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13054.
 */
cljs.core.async.__GT_t_cljs$core$async13054 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13054(p__$1,ch__$1,meta13055){
return (new cljs.core.async.t_cljs$core$async13054(p__$1,ch__$1,meta13055));
});

}

return (new cljs.core.async.t_cljs$core$async13054(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__13058 = arguments.length;
switch (G__13058) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11567__auto___13099 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_13079){
var state_val_13080 = (state_13079[(1)]);
if((state_val_13080 === (7))){
var inst_13075 = (state_13079[(2)]);
var state_13079__$1 = state_13079;
var statearr_13081_13100 = state_13079__$1;
(statearr_13081_13100[(2)] = inst_13075);

(statearr_13081_13100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (1))){
var state_13079__$1 = state_13079;
var statearr_13082_13101 = state_13079__$1;
(statearr_13082_13101[(2)] = null);

(statearr_13082_13101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (4))){
var inst_13061 = (state_13079[(7)]);
var inst_13061__$1 = (state_13079[(2)]);
var inst_13062 = (inst_13061__$1 == null);
var state_13079__$1 = (function (){var statearr_13083 = state_13079;
(statearr_13083[(7)] = inst_13061__$1);

return statearr_13083;
})();
if(cljs.core.truth_(inst_13062)){
var statearr_13084_13102 = state_13079__$1;
(statearr_13084_13102[(1)] = (5));

} else {
var statearr_13085_13103 = state_13079__$1;
(statearr_13085_13103[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (6))){
var inst_13061 = (state_13079[(7)]);
var inst_13066 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_13061) : p.call(null,inst_13061));
var state_13079__$1 = state_13079;
if(cljs.core.truth_(inst_13066)){
var statearr_13086_13104 = state_13079__$1;
(statearr_13086_13104[(1)] = (8));

} else {
var statearr_13087_13105 = state_13079__$1;
(statearr_13087_13105[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (3))){
var inst_13077 = (state_13079[(2)]);
var state_13079__$1 = state_13079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13079__$1,inst_13077);
} else {
if((state_val_13080 === (2))){
var state_13079__$1 = state_13079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13079__$1,(4),ch);
} else {
if((state_val_13080 === (11))){
var inst_13069 = (state_13079[(2)]);
var state_13079__$1 = state_13079;
var statearr_13088_13106 = state_13079__$1;
(statearr_13088_13106[(2)] = inst_13069);

(statearr_13088_13106[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (9))){
var state_13079__$1 = state_13079;
var statearr_13089_13107 = state_13079__$1;
(statearr_13089_13107[(2)] = null);

(statearr_13089_13107[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (5))){
var inst_13064 = cljs.core.async.close_BANG_(out);
var state_13079__$1 = state_13079;
var statearr_13090_13108 = state_13079__$1;
(statearr_13090_13108[(2)] = inst_13064);

(statearr_13090_13108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (10))){
var inst_13072 = (state_13079[(2)]);
var state_13079__$1 = (function (){var statearr_13091 = state_13079;
(statearr_13091[(8)] = inst_13072);

return statearr_13091;
})();
var statearr_13092_13109 = state_13079__$1;
(statearr_13092_13109[(2)] = null);

(statearr_13092_13109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13080 === (8))){
var inst_13061 = (state_13079[(7)]);
var state_13079__$1 = state_13079;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13079__$1,(11),out,inst_13061);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_13093 = [null,null,null,null,null,null,null,null,null];
(statearr_13093[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_13093[(1)] = (1));

return statearr_13093;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_13079){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_13079);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e13094){var ex__11496__auto__ = e13094;
var statearr_13095_13110 = state_13079;
(statearr_13095_13110[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_13079[(4)]))){
var statearr_13096_13111 = state_13079;
(statearr_13096_13111[(1)] = cljs.core.first((state_13079[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13112 = state_13079;
state_13079 = G__13112;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_13079){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_13079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_13097 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_13097[(6)] = c__11567__auto___13099);

return statearr_13097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__13114 = arguments.length;
switch (G__13114) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11567__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_13177){
var state_val_13178 = (state_13177[(1)]);
if((state_val_13178 === (7))){
var inst_13173 = (state_13177[(2)]);
var state_13177__$1 = state_13177;
var statearr_13179_13218 = state_13177__$1;
(statearr_13179_13218[(2)] = inst_13173);

(statearr_13179_13218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (20))){
var inst_13143 = (state_13177[(7)]);
var inst_13154 = (state_13177[(2)]);
var inst_13155 = cljs.core.next(inst_13143);
var inst_13129 = inst_13155;
var inst_13130 = null;
var inst_13131 = (0);
var inst_13132 = (0);
var state_13177__$1 = (function (){var statearr_13180 = state_13177;
(statearr_13180[(8)] = inst_13131);

(statearr_13180[(9)] = inst_13130);

(statearr_13180[(10)] = inst_13132);

(statearr_13180[(11)] = inst_13129);

(statearr_13180[(12)] = inst_13154);

return statearr_13180;
})();
var statearr_13181_13219 = state_13177__$1;
(statearr_13181_13219[(2)] = null);

(statearr_13181_13219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (1))){
var state_13177__$1 = state_13177;
var statearr_13182_13220 = state_13177__$1;
(statearr_13182_13220[(2)] = null);

(statearr_13182_13220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (4))){
var inst_13118 = (state_13177[(13)]);
var inst_13118__$1 = (state_13177[(2)]);
var inst_13119 = (inst_13118__$1 == null);
var state_13177__$1 = (function (){var statearr_13183 = state_13177;
(statearr_13183[(13)] = inst_13118__$1);

return statearr_13183;
})();
if(cljs.core.truth_(inst_13119)){
var statearr_13184_13221 = state_13177__$1;
(statearr_13184_13221[(1)] = (5));

} else {
var statearr_13185_13222 = state_13177__$1;
(statearr_13185_13222[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (15))){
var state_13177__$1 = state_13177;
var statearr_13189_13223 = state_13177__$1;
(statearr_13189_13223[(2)] = null);

(statearr_13189_13223[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (21))){
var state_13177__$1 = state_13177;
var statearr_13190_13224 = state_13177__$1;
(statearr_13190_13224[(2)] = null);

(statearr_13190_13224[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (13))){
var inst_13131 = (state_13177[(8)]);
var inst_13130 = (state_13177[(9)]);
var inst_13132 = (state_13177[(10)]);
var inst_13129 = (state_13177[(11)]);
var inst_13139 = (state_13177[(2)]);
var inst_13140 = (inst_13132 + (1));
var tmp13186 = inst_13131;
var tmp13187 = inst_13130;
var tmp13188 = inst_13129;
var inst_13129__$1 = tmp13188;
var inst_13130__$1 = tmp13187;
var inst_13131__$1 = tmp13186;
var inst_13132__$1 = inst_13140;
var state_13177__$1 = (function (){var statearr_13191 = state_13177;
(statearr_13191[(8)] = inst_13131__$1);

(statearr_13191[(14)] = inst_13139);

(statearr_13191[(9)] = inst_13130__$1);

(statearr_13191[(10)] = inst_13132__$1);

(statearr_13191[(11)] = inst_13129__$1);

return statearr_13191;
})();
var statearr_13192_13225 = state_13177__$1;
(statearr_13192_13225[(2)] = null);

(statearr_13192_13225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (22))){
var state_13177__$1 = state_13177;
var statearr_13193_13226 = state_13177__$1;
(statearr_13193_13226[(2)] = null);

(statearr_13193_13226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (6))){
var inst_13118 = (state_13177[(13)]);
var inst_13127 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13118) : f.call(null,inst_13118));
var inst_13128 = cljs.core.seq(inst_13127);
var inst_13129 = inst_13128;
var inst_13130 = null;
var inst_13131 = (0);
var inst_13132 = (0);
var state_13177__$1 = (function (){var statearr_13194 = state_13177;
(statearr_13194[(8)] = inst_13131);

(statearr_13194[(9)] = inst_13130);

(statearr_13194[(10)] = inst_13132);

(statearr_13194[(11)] = inst_13129);

return statearr_13194;
})();
var statearr_13195_13227 = state_13177__$1;
(statearr_13195_13227[(2)] = null);

(statearr_13195_13227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (17))){
var inst_13143 = (state_13177[(7)]);
var inst_13147 = cljs.core.chunk_first(inst_13143);
var inst_13148 = cljs.core.chunk_rest(inst_13143);
var inst_13149 = cljs.core.count(inst_13147);
var inst_13129 = inst_13148;
var inst_13130 = inst_13147;
var inst_13131 = inst_13149;
var inst_13132 = (0);
var state_13177__$1 = (function (){var statearr_13196 = state_13177;
(statearr_13196[(8)] = inst_13131);

(statearr_13196[(9)] = inst_13130);

(statearr_13196[(10)] = inst_13132);

(statearr_13196[(11)] = inst_13129);

return statearr_13196;
})();
var statearr_13197_13228 = state_13177__$1;
(statearr_13197_13228[(2)] = null);

(statearr_13197_13228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (3))){
var inst_13175 = (state_13177[(2)]);
var state_13177__$1 = state_13177;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13177__$1,inst_13175);
} else {
if((state_val_13178 === (12))){
var inst_13163 = (state_13177[(2)]);
var state_13177__$1 = state_13177;
var statearr_13198_13229 = state_13177__$1;
(statearr_13198_13229[(2)] = inst_13163);

(statearr_13198_13229[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (2))){
var state_13177__$1 = state_13177;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13177__$1,(4),in$);
} else {
if((state_val_13178 === (23))){
var inst_13171 = (state_13177[(2)]);
var state_13177__$1 = state_13177;
var statearr_13199_13230 = state_13177__$1;
(statearr_13199_13230[(2)] = inst_13171);

(statearr_13199_13230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (19))){
var inst_13158 = (state_13177[(2)]);
var state_13177__$1 = state_13177;
var statearr_13200_13231 = state_13177__$1;
(statearr_13200_13231[(2)] = inst_13158);

(statearr_13200_13231[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (11))){
var inst_13129 = (state_13177[(11)]);
var inst_13143 = (state_13177[(7)]);
var inst_13143__$1 = cljs.core.seq(inst_13129);
var state_13177__$1 = (function (){var statearr_13201 = state_13177;
(statearr_13201[(7)] = inst_13143__$1);

return statearr_13201;
})();
if(inst_13143__$1){
var statearr_13202_13232 = state_13177__$1;
(statearr_13202_13232[(1)] = (14));

} else {
var statearr_13203_13233 = state_13177__$1;
(statearr_13203_13233[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (9))){
var inst_13165 = (state_13177[(2)]);
var inst_13166 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_13177__$1 = (function (){var statearr_13204 = state_13177;
(statearr_13204[(15)] = inst_13165);

return statearr_13204;
})();
if(cljs.core.truth_(inst_13166)){
var statearr_13205_13234 = state_13177__$1;
(statearr_13205_13234[(1)] = (21));

} else {
var statearr_13206_13235 = state_13177__$1;
(statearr_13206_13235[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (5))){
var inst_13121 = cljs.core.async.close_BANG_(out);
var state_13177__$1 = state_13177;
var statearr_13207_13236 = state_13177__$1;
(statearr_13207_13236[(2)] = inst_13121);

(statearr_13207_13236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (14))){
var inst_13143 = (state_13177[(7)]);
var inst_13145 = cljs.core.chunked_seq_QMARK_(inst_13143);
var state_13177__$1 = state_13177;
if(inst_13145){
var statearr_13208_13237 = state_13177__$1;
(statearr_13208_13237[(1)] = (17));

} else {
var statearr_13209_13238 = state_13177__$1;
(statearr_13209_13238[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (16))){
var inst_13161 = (state_13177[(2)]);
var state_13177__$1 = state_13177;
var statearr_13210_13239 = state_13177__$1;
(statearr_13210_13239[(2)] = inst_13161);

(statearr_13210_13239[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13178 === (10))){
var inst_13130 = (state_13177[(9)]);
var inst_13132 = (state_13177[(10)]);
var inst_13137 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_13130,inst_13132);
var state_13177__$1 = state_13177;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13177__$1,(13),out,inst_13137);
} else {
if((state_val_13178 === (18))){
var inst_13143 = (state_13177[(7)]);
var inst_13152 = cljs.core.first(inst_13143);
var state_13177__$1 = state_13177;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13177__$1,(20),out,inst_13152);
} else {
if((state_val_13178 === (8))){
var inst_13131 = (state_13177[(8)]);
var inst_13132 = (state_13177[(10)]);
var inst_13134 = (inst_13132 < inst_13131);
var inst_13135 = inst_13134;
var state_13177__$1 = state_13177;
if(cljs.core.truth_(inst_13135)){
var statearr_13211_13240 = state_13177__$1;
(statearr_13211_13240[(1)] = (10));

} else {
var statearr_13212_13241 = state_13177__$1;
(statearr_13212_13241[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11493__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11493__auto____0 = (function (){
var statearr_13213 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13213[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11493__auto__);

(statearr_13213[(1)] = (1));

return statearr_13213;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11493__auto____1 = (function (state_13177){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_13177);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e13214){var ex__11496__auto__ = e13214;
var statearr_13215_13242 = state_13177;
(statearr_13215_13242[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_13177[(4)]))){
var statearr_13216_13243 = state_13177;
(statearr_13216_13243[(1)] = cljs.core.first((state_13177[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13244 = state_13177;
state_13177 = G__13244;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11493__auto__ = function(state_13177){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11493__auto____1.call(this,state_13177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11493__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11493__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_13217 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_13217[(6)] = c__11567__auto__);

return statearr_13217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));

return c__11567__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__13246 = arguments.length;
switch (G__13246) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__13249 = arguments.length;
switch (G__13249) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__13252 = arguments.length;
switch (G__13252) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11567__auto___13300 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_13276){
var state_val_13277 = (state_13276[(1)]);
if((state_val_13277 === (7))){
var inst_13271 = (state_13276[(2)]);
var state_13276__$1 = state_13276;
var statearr_13278_13301 = state_13276__$1;
(statearr_13278_13301[(2)] = inst_13271);

(statearr_13278_13301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (1))){
var inst_13253 = null;
var state_13276__$1 = (function (){var statearr_13279 = state_13276;
(statearr_13279[(7)] = inst_13253);

return statearr_13279;
})();
var statearr_13280_13302 = state_13276__$1;
(statearr_13280_13302[(2)] = null);

(statearr_13280_13302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (4))){
var inst_13256 = (state_13276[(8)]);
var inst_13256__$1 = (state_13276[(2)]);
var inst_13257 = (inst_13256__$1 == null);
var inst_13258 = cljs.core.not(inst_13257);
var state_13276__$1 = (function (){var statearr_13281 = state_13276;
(statearr_13281[(8)] = inst_13256__$1);

return statearr_13281;
})();
if(inst_13258){
var statearr_13282_13303 = state_13276__$1;
(statearr_13282_13303[(1)] = (5));

} else {
var statearr_13283_13304 = state_13276__$1;
(statearr_13283_13304[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (6))){
var state_13276__$1 = state_13276;
var statearr_13284_13305 = state_13276__$1;
(statearr_13284_13305[(2)] = null);

(statearr_13284_13305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (3))){
var inst_13273 = (state_13276[(2)]);
var inst_13274 = cljs.core.async.close_BANG_(out);
var state_13276__$1 = (function (){var statearr_13285 = state_13276;
(statearr_13285[(9)] = inst_13273);

return statearr_13285;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13276__$1,inst_13274);
} else {
if((state_val_13277 === (2))){
var state_13276__$1 = state_13276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13276__$1,(4),ch);
} else {
if((state_val_13277 === (11))){
var inst_13256 = (state_13276[(8)]);
var inst_13265 = (state_13276[(2)]);
var inst_13253 = inst_13256;
var state_13276__$1 = (function (){var statearr_13286 = state_13276;
(statearr_13286[(10)] = inst_13265);

(statearr_13286[(7)] = inst_13253);

return statearr_13286;
})();
var statearr_13287_13306 = state_13276__$1;
(statearr_13287_13306[(2)] = null);

(statearr_13287_13306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (9))){
var inst_13256 = (state_13276[(8)]);
var state_13276__$1 = state_13276;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13276__$1,(11),out,inst_13256);
} else {
if((state_val_13277 === (5))){
var inst_13256 = (state_13276[(8)]);
var inst_13253 = (state_13276[(7)]);
var inst_13260 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13256,inst_13253);
var state_13276__$1 = state_13276;
if(inst_13260){
var statearr_13289_13307 = state_13276__$1;
(statearr_13289_13307[(1)] = (8));

} else {
var statearr_13290_13308 = state_13276__$1;
(statearr_13290_13308[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (10))){
var inst_13268 = (state_13276[(2)]);
var state_13276__$1 = state_13276;
var statearr_13291_13309 = state_13276__$1;
(statearr_13291_13309[(2)] = inst_13268);

(statearr_13291_13309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (8))){
var inst_13253 = (state_13276[(7)]);
var tmp13288 = inst_13253;
var inst_13253__$1 = tmp13288;
var state_13276__$1 = (function (){var statearr_13292 = state_13276;
(statearr_13292[(7)] = inst_13253__$1);

return statearr_13292;
})();
var statearr_13293_13310 = state_13276__$1;
(statearr_13293_13310[(2)] = null);

(statearr_13293_13310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_13294 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13294[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_13294[(1)] = (1));

return statearr_13294;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_13276){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_13276);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e13295){var ex__11496__auto__ = e13295;
var statearr_13296_13311 = state_13276;
(statearr_13296_13311[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_13276[(4)]))){
var statearr_13297_13312 = state_13276;
(statearr_13297_13312[(1)] = cljs.core.first((state_13276[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13313 = state_13276;
state_13276 = G__13313;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_13276){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_13276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_13298 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_13298[(6)] = c__11567__auto___13300);

return statearr_13298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__13315 = arguments.length;
switch (G__13315) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11567__auto___13382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_13353){
var state_val_13354 = (state_13353[(1)]);
if((state_val_13354 === (7))){
var inst_13349 = (state_13353[(2)]);
var state_13353__$1 = state_13353;
var statearr_13355_13383 = state_13353__$1;
(statearr_13355_13383[(2)] = inst_13349);

(statearr_13355_13383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (1))){
var inst_13316 = (new Array(n));
var inst_13317 = inst_13316;
var inst_13318 = (0);
var state_13353__$1 = (function (){var statearr_13356 = state_13353;
(statearr_13356[(7)] = inst_13318);

(statearr_13356[(8)] = inst_13317);

return statearr_13356;
})();
var statearr_13357_13384 = state_13353__$1;
(statearr_13357_13384[(2)] = null);

(statearr_13357_13384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (4))){
var inst_13321 = (state_13353[(9)]);
var inst_13321__$1 = (state_13353[(2)]);
var inst_13322 = (inst_13321__$1 == null);
var inst_13323 = cljs.core.not(inst_13322);
var state_13353__$1 = (function (){var statearr_13358 = state_13353;
(statearr_13358[(9)] = inst_13321__$1);

return statearr_13358;
})();
if(inst_13323){
var statearr_13359_13385 = state_13353__$1;
(statearr_13359_13385[(1)] = (5));

} else {
var statearr_13360_13386 = state_13353__$1;
(statearr_13360_13386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (15))){
var inst_13343 = (state_13353[(2)]);
var state_13353__$1 = state_13353;
var statearr_13361_13387 = state_13353__$1;
(statearr_13361_13387[(2)] = inst_13343);

(statearr_13361_13387[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (13))){
var state_13353__$1 = state_13353;
var statearr_13362_13388 = state_13353__$1;
(statearr_13362_13388[(2)] = null);

(statearr_13362_13388[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (6))){
var inst_13318 = (state_13353[(7)]);
var inst_13339 = (inst_13318 > (0));
var state_13353__$1 = state_13353;
if(cljs.core.truth_(inst_13339)){
var statearr_13363_13389 = state_13353__$1;
(statearr_13363_13389[(1)] = (12));

} else {
var statearr_13364_13390 = state_13353__$1;
(statearr_13364_13390[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (3))){
var inst_13351 = (state_13353[(2)]);
var state_13353__$1 = state_13353;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13353__$1,inst_13351);
} else {
if((state_val_13354 === (12))){
var inst_13317 = (state_13353[(8)]);
var inst_13341 = cljs.core.vec(inst_13317);
var state_13353__$1 = state_13353;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13353__$1,(15),out,inst_13341);
} else {
if((state_val_13354 === (2))){
var state_13353__$1 = state_13353;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13353__$1,(4),ch);
} else {
if((state_val_13354 === (11))){
var inst_13333 = (state_13353[(2)]);
var inst_13334 = (new Array(n));
var inst_13317 = inst_13334;
var inst_13318 = (0);
var state_13353__$1 = (function (){var statearr_13365 = state_13353;
(statearr_13365[(7)] = inst_13318);

(statearr_13365[(10)] = inst_13333);

(statearr_13365[(8)] = inst_13317);

return statearr_13365;
})();
var statearr_13366_13391 = state_13353__$1;
(statearr_13366_13391[(2)] = null);

(statearr_13366_13391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (9))){
var inst_13317 = (state_13353[(8)]);
var inst_13331 = cljs.core.vec(inst_13317);
var state_13353__$1 = state_13353;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13353__$1,(11),out,inst_13331);
} else {
if((state_val_13354 === (5))){
var inst_13318 = (state_13353[(7)]);
var inst_13317 = (state_13353[(8)]);
var inst_13321 = (state_13353[(9)]);
var inst_13326 = (state_13353[(11)]);
var inst_13325 = (inst_13317[inst_13318] = inst_13321);
var inst_13326__$1 = (inst_13318 + (1));
var inst_13327 = (inst_13326__$1 < n);
var state_13353__$1 = (function (){var statearr_13367 = state_13353;
(statearr_13367[(12)] = inst_13325);

(statearr_13367[(11)] = inst_13326__$1);

return statearr_13367;
})();
if(cljs.core.truth_(inst_13327)){
var statearr_13368_13392 = state_13353__$1;
(statearr_13368_13392[(1)] = (8));

} else {
var statearr_13369_13393 = state_13353__$1;
(statearr_13369_13393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (14))){
var inst_13346 = (state_13353[(2)]);
var inst_13347 = cljs.core.async.close_BANG_(out);
var state_13353__$1 = (function (){var statearr_13371 = state_13353;
(statearr_13371[(13)] = inst_13346);

return statearr_13371;
})();
var statearr_13372_13394 = state_13353__$1;
(statearr_13372_13394[(2)] = inst_13347);

(statearr_13372_13394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (10))){
var inst_13337 = (state_13353[(2)]);
var state_13353__$1 = state_13353;
var statearr_13373_13395 = state_13353__$1;
(statearr_13373_13395[(2)] = inst_13337);

(statearr_13373_13395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13354 === (8))){
var inst_13317 = (state_13353[(8)]);
var inst_13326 = (state_13353[(11)]);
var tmp13370 = inst_13317;
var inst_13317__$1 = tmp13370;
var inst_13318 = inst_13326;
var state_13353__$1 = (function (){var statearr_13374 = state_13353;
(statearr_13374[(7)] = inst_13318);

(statearr_13374[(8)] = inst_13317__$1);

return statearr_13374;
})();
var statearr_13375_13396 = state_13353__$1;
(statearr_13375_13396[(2)] = null);

(statearr_13375_13396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_13376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13376[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_13376[(1)] = (1));

return statearr_13376;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_13353){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_13353);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e13377){var ex__11496__auto__ = e13377;
var statearr_13378_13397 = state_13353;
(statearr_13378_13397[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_13353[(4)]))){
var statearr_13379_13398 = state_13353;
(statearr_13379_13398[(1)] = cljs.core.first((state_13353[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13399 = state_13353;
state_13353 = G__13399;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_13353){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_13353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_13380 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_13380[(6)] = c__11567__auto___13382);

return statearr_13380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__13401 = arguments.length;
switch (G__13401) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11567__auto___13479 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11568__auto__ = (function (){var switch__11492__auto__ = (function (state_13446){
var state_val_13447 = (state_13446[(1)]);
if((state_val_13447 === (7))){
var inst_13442 = (state_13446[(2)]);
var state_13446__$1 = state_13446;
var statearr_13448_13480 = state_13446__$1;
(statearr_13448_13480[(2)] = inst_13442);

(statearr_13448_13480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (1))){
var inst_13402 = [];
var inst_13403 = inst_13402;
var inst_13404 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13446__$1 = (function (){var statearr_13449 = state_13446;
(statearr_13449[(7)] = inst_13403);

(statearr_13449[(8)] = inst_13404);

return statearr_13449;
})();
var statearr_13450_13481 = state_13446__$1;
(statearr_13450_13481[(2)] = null);

(statearr_13450_13481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (4))){
var inst_13407 = (state_13446[(9)]);
var inst_13407__$1 = (state_13446[(2)]);
var inst_13408 = (inst_13407__$1 == null);
var inst_13409 = cljs.core.not(inst_13408);
var state_13446__$1 = (function (){var statearr_13451 = state_13446;
(statearr_13451[(9)] = inst_13407__$1);

return statearr_13451;
})();
if(inst_13409){
var statearr_13452_13482 = state_13446__$1;
(statearr_13452_13482[(1)] = (5));

} else {
var statearr_13453_13483 = state_13446__$1;
(statearr_13453_13483[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (15))){
var inst_13403 = (state_13446[(7)]);
var inst_13434 = cljs.core.vec(inst_13403);
var state_13446__$1 = state_13446;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13446__$1,(18),out,inst_13434);
} else {
if((state_val_13447 === (13))){
var inst_13429 = (state_13446[(2)]);
var state_13446__$1 = state_13446;
var statearr_13454_13484 = state_13446__$1;
(statearr_13454_13484[(2)] = inst_13429);

(statearr_13454_13484[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (6))){
var inst_13403 = (state_13446[(7)]);
var inst_13431 = inst_13403.length;
var inst_13432 = (inst_13431 > (0));
var state_13446__$1 = state_13446;
if(cljs.core.truth_(inst_13432)){
var statearr_13455_13485 = state_13446__$1;
(statearr_13455_13485[(1)] = (15));

} else {
var statearr_13456_13486 = state_13446__$1;
(statearr_13456_13486[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (17))){
var inst_13439 = (state_13446[(2)]);
var inst_13440 = cljs.core.async.close_BANG_(out);
var state_13446__$1 = (function (){var statearr_13457 = state_13446;
(statearr_13457[(10)] = inst_13439);

return statearr_13457;
})();
var statearr_13458_13487 = state_13446__$1;
(statearr_13458_13487[(2)] = inst_13440);

(statearr_13458_13487[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (3))){
var inst_13444 = (state_13446[(2)]);
var state_13446__$1 = state_13446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13446__$1,inst_13444);
} else {
if((state_val_13447 === (12))){
var inst_13403 = (state_13446[(7)]);
var inst_13422 = cljs.core.vec(inst_13403);
var state_13446__$1 = state_13446;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13446__$1,(14),out,inst_13422);
} else {
if((state_val_13447 === (2))){
var state_13446__$1 = state_13446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13446__$1,(4),ch);
} else {
if((state_val_13447 === (11))){
var inst_13407 = (state_13446[(9)]);
var inst_13411 = (state_13446[(11)]);
var inst_13403 = (state_13446[(7)]);
var inst_13419 = inst_13403.push(inst_13407);
var tmp13459 = inst_13403;
var inst_13403__$1 = tmp13459;
var inst_13404 = inst_13411;
var state_13446__$1 = (function (){var statearr_13460 = state_13446;
(statearr_13460[(12)] = inst_13419);

(statearr_13460[(7)] = inst_13403__$1);

(statearr_13460[(8)] = inst_13404);

return statearr_13460;
})();
var statearr_13461_13488 = state_13446__$1;
(statearr_13461_13488[(2)] = null);

(statearr_13461_13488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (9))){
var inst_13404 = (state_13446[(8)]);
var inst_13415 = cljs.core.keyword_identical_QMARK_(inst_13404,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_13446__$1 = state_13446;
var statearr_13462_13489 = state_13446__$1;
(statearr_13462_13489[(2)] = inst_13415);

(statearr_13462_13489[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (5))){
var inst_13407 = (state_13446[(9)]);
var inst_13411 = (state_13446[(11)]);
var inst_13412 = (state_13446[(13)]);
var inst_13404 = (state_13446[(8)]);
var inst_13411__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13407) : f.call(null,inst_13407));
var inst_13412__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13411__$1,inst_13404);
var state_13446__$1 = (function (){var statearr_13463 = state_13446;
(statearr_13463[(11)] = inst_13411__$1);

(statearr_13463[(13)] = inst_13412__$1);

return statearr_13463;
})();
if(inst_13412__$1){
var statearr_13464_13490 = state_13446__$1;
(statearr_13464_13490[(1)] = (8));

} else {
var statearr_13465_13491 = state_13446__$1;
(statearr_13465_13491[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (14))){
var inst_13407 = (state_13446[(9)]);
var inst_13411 = (state_13446[(11)]);
var inst_13424 = (state_13446[(2)]);
var inst_13425 = [];
var inst_13426 = inst_13425.push(inst_13407);
var inst_13403 = inst_13425;
var inst_13404 = inst_13411;
var state_13446__$1 = (function (){var statearr_13466 = state_13446;
(statearr_13466[(14)] = inst_13424);

(statearr_13466[(7)] = inst_13403);

(statearr_13466[(8)] = inst_13404);

(statearr_13466[(15)] = inst_13426);

return statearr_13466;
})();
var statearr_13467_13492 = state_13446__$1;
(statearr_13467_13492[(2)] = null);

(statearr_13467_13492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (16))){
var state_13446__$1 = state_13446;
var statearr_13468_13493 = state_13446__$1;
(statearr_13468_13493[(2)] = null);

(statearr_13468_13493[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (10))){
var inst_13417 = (state_13446[(2)]);
var state_13446__$1 = state_13446;
if(cljs.core.truth_(inst_13417)){
var statearr_13469_13494 = state_13446__$1;
(statearr_13469_13494[(1)] = (11));

} else {
var statearr_13470_13495 = state_13446__$1;
(statearr_13470_13495[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (18))){
var inst_13436 = (state_13446[(2)]);
var state_13446__$1 = state_13446;
var statearr_13471_13496 = state_13446__$1;
(statearr_13471_13496[(2)] = inst_13436);

(statearr_13471_13496[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13447 === (8))){
var inst_13412 = (state_13446[(13)]);
var state_13446__$1 = state_13446;
var statearr_13472_13497 = state_13446__$1;
(statearr_13472_13497[(2)] = inst_13412);

(statearr_13472_13497[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11493__auto__ = null;
var cljs$core$async$state_machine__11493__auto____0 = (function (){
var statearr_13473 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13473[(0)] = cljs$core$async$state_machine__11493__auto__);

(statearr_13473[(1)] = (1));

return statearr_13473;
});
var cljs$core$async$state_machine__11493__auto____1 = (function (state_13446){
while(true){
var ret_value__11494__auto__ = (function (){try{while(true){
var result__11495__auto__ = switch__11492__auto__(state_13446);
if(cljs.core.keyword_identical_QMARK_(result__11495__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11495__auto__;
}
break;
}
}catch (e13474){var ex__11496__auto__ = e13474;
var statearr_13475_13498 = state_13446;
(statearr_13475_13498[(2)] = ex__11496__auto__);


if(cljs.core.seq((state_13446[(4)]))){
var statearr_13476_13499 = state_13446;
(statearr_13476_13499[(1)] = cljs.core.first((state_13446[(4)])));

} else {
throw ex__11496__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11494__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13500 = state_13446;
state_13446 = G__13500;
continue;
} else {
return ret_value__11494__auto__;
}
break;
}
});
cljs$core$async$state_machine__11493__auto__ = function(state_13446){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11493__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11493__auto____1.call(this,state_13446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11493__auto____0;
cljs$core$async$state_machine__11493__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11493__auto____1;
return cljs$core$async$state_machine__11493__auto__;
})()
})();
var state__11569__auto__ = (function (){var statearr_13477 = (f__11568__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11568__auto__.cljs$core$IFn$_invoke$arity$0() : f__11568__auto__.call(null));
(statearr_13477[(6)] = c__11567__auto___13479);

return statearr_13477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11569__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

